// This file is auto-generated by the build script
// Please, do not modify it manually

use super::test_markdown_html;

#[test]
fn strikethrough_test_1() {
    let original = r##"~~This is *stricken out*~~
"##;
    let expected = r##"<p><del>This is <em>stricken out</em></del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_2() {
    let original = r##"~~This is \~\~stricken~~
"##;
    let expected = r##"<p><del>This is ~~stricken</del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_3() {
    let original = r##"This~~is~~stricken
"##;
    let expected = r##"<p>This<del>is</del>stricken</p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_4() {
    let original = r##"~~This~~is~~stricken~~
"##;
    let expected = r##"<p><del>This</del>is<del>stricken</del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_5() {
    let original = r##"Here I strike out an exclamation point~~!~~.
"##;
    let expected = r##"<p>Here I strike out an exclamation point<del>!</del>.</p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_6() {
    let original = r##"~This is stricken out~
"##;
    let expected = r##"<p><del>This is stricken out</del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_7() {
    let original = r##"~This is \~stricken~
"##;
    let expected = r##"<p><del>This is ~stricken</del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_8() {
    let original = r##"This~is~nothing
"##;
    let expected = r##"<p>This~is~nothing</p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_9() {
    let original = r##"~This~is~nothing~
"##;
    let expected = r##"<p><del>This~is~nothing</del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_10() {
    let original = r##"Here I fail to strike out an exclamation point~!~.
"##;
    let expected = r##"<p>Here I fail to strike out an exclamation point~!~.</p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_11() {
    let original = r##"Here I fail to strike out a tilde ~~~.
"##;
    let expected = r##"<p>Here I fail to strike out a tilde ~~~.</p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_12() {
    let original = r##"Here I fail to match up ~~tildes~.
"##;
    let expected = r##"<p>Here I fail to match up ~~tildes~.</p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_13() {
    let original = r##"Here I fail to match up ~tildes~~.
"##;
    let expected = r##"<p>Here I fail to match up ~tildes~~.</p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_14() {
    let original = r##"~~This ~is stricken.~~
"##;
    let expected = r##"<p><del>This ~is stricken.</del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}

#[test]
fn strikethrough_test_15() {
    let original = r##"~This ~~is stricken.~
"##;
    let expected = r##"<p><del>This ~~is stricken.</del></p>
"##;

    test_markdown_html(original, expected, false, false, false, false, false);
}
