# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class BatchQueryRequest(_Model):
    """A single request in a batch.

    :ivar id: Unique ID corresponding to each request in the batch. Required.
    :vartype id: str
    :ivar headers: Headers of the request. Can use prefer header to set server timeout and to
     query statistics and visualization information.
    :vartype headers: dict[str, str]
    :ivar body: The Analytics query. Learn more about the
     `Analytics query syntax
     <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
     Required.
    :vartype body: ~azure.monitor.query.models._models.QueryBody
    :ivar path: The path for the batch query request. Required. Default value is "/query".
    :vartype path: str
    :ivar method: The method of a single request in a batch. Required. Default value is "POST".
    :vartype method: str
    :ivar workspace: Primary Workspace ID of the query. This is the Workspace ID from the
     Properties
     blade in the Azure portal. Required.
    :vartype workspace: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique ID corresponding to each request in the batch. Required."""
    headers: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Headers of the request. Can use prefer header to set server timeout and to
     query statistics and visualization information."""
    body: "_models._models.QueryBody" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The Analytics query. Learn more about the
     `Analytics query syntax
     <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
     Required."""
    path: Literal["/query"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The path for the batch query request. Required. Default value is \"/query\"."""
    method: Literal["POST"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The method of a single request in a batch. Required. Default value is \"POST\"."""
    workspace: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Primary Workspace ID of the query. This is the Workspace ID from the Properties
     blade in the Azure portal. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        body: "_models._models.QueryBody",
        workspace: str,
        headers: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.path: Literal["/query"] = "/query"
        self.method: Literal["POST"] = "POST"


class BatchQueryResponse(_Model):
    """Contains the batch query response and the headers, id, and status of the request.

    :ivar id: Unique ID corresponding to each request in the batch.
    :vartype id: str
    :ivar status: The HTTP status code of the response.
    :vartype status: int
    :ivar body: Contains the tables, columns & rows resulting from a query.
    :vartype body: ~azure.monitor.query.models._models.BatchQueryResults
    :ivar headers: Dictionary of <string>.
    :vartype headers: dict[str, str]
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique ID corresponding to each request in the batch."""
    status: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The HTTP status code of the response."""
    body: Optional["_models._models.BatchQueryResults"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the tables, columns & rows resulting from a query."""
    headers: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Dictionary of <string>."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[int] = None,
        body: Optional["_models._models.BatchQueryResults"] = None,
        headers: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchQueryResults(_Model):
    """Contains the tables, columns & rows resulting from a query.

    :ivar tables: The results of the query in tabular format.
    :vartype tables: list[~azure.monitor.query.models._models.Table]
    :ivar statistics: Statistics represented in JSON format.
    :vartype statistics: dict[str, any]
    :ivar render: Visualization data in JSON format.
    :vartype render: dict[str, any]
    :ivar error: The code and message for an error.
    :vartype error: ~azure.monitor.query.models._models.ErrorInfo
    """

    tables: Optional[List["_models._models.Table"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results of the query in tabular format."""
    statistics: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Statistics represented in JSON format."""
    render: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Visualization data in JSON format."""
    error: Optional["_models._models.ErrorInfo"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The code and message for an error."""

    @overload
    def __init__(
        self,
        *,
        tables: Optional[List["_models._models.Table"]] = None,
        statistics: Optional[Dict[str, Any]] = None,
        render: Optional[Dict[str, Any]] = None,
        error: Optional["_models._models.ErrorInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchRequest(_Model):
    """An array of requests.

    :ivar requests: An single request in a batch. Required.
    :vartype requests: list[~azure.monitor.query.models._models.BatchQueryRequest]
    """

    requests: List["_models._models.BatchQueryRequest"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An single request in a batch. Required."""

    @overload
    def __init__(
        self,
        *,
        requests: List["_models._models.BatchQueryRequest"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BatchResponse(_Model):
    """Response to a batch query.

    :ivar responses: An array of responses corresponding to each individual request in a batch.
    :vartype responses: list[~azure.monitor.query.models._models.BatchQueryResponse]
    """

    responses: Optional[List["_models._models.BatchQueryResponse"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of responses corresponding to each individual request in a batch."""

    @overload
    def __init__(
        self,
        *,
        responses: Optional[List["_models._models.BatchQueryResponse"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Column(_Model):
    """A column in a table.

    :ivar name: The name of this column. Required.
    :vartype name: str
    :ivar type: The data type of this column. Required. Known values are: "bool", "datetime",
     "dynamic", "int", "long", "real", "string", "guid", "decimal", and "timespan".
    :vartype type: str or ~azure.monitor.query.models._ColumnType
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of this column. Required."""
    type: Union[str, "_models._ColumnType"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The data type of this column. Required. Known values are: \"bool\", \"datetime\", \"dynamic\",
     \"int\", \"long\", \"real\", \"string\", \"guid\", \"decimal\", and \"timespan\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "_models._ColumnType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorDetail(_Model):
    """Error details.

    :ivar code: The error's code. Required.
    :vartype code: str
    :ivar message: A human readable error message. Required.
    :vartype message: str
    :ivar target: Indicates which property in the request is responsible for the error.
    :vartype target: str
    :ivar value: Indicates which value in 'target' is responsible for the error.
    :vartype value: str
    :ivar resources: Indicates resources which were responsible for the error.
    :vartype resources: list[str]
    :ivar additional_properties: Additional properties that can be provided on the error details
     object.
    :vartype additional_properties: dict[str, any]
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error's code. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human readable error message. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which property in the request is responsible for the error."""
    value: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates which value in 'target' is responsible for the error."""
    resources: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates resources which were responsible for the error."""
    additional_properties: Optional[Dict[str, Any]] = rest_field(
        name="additionalProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional properties that can be provided on the error details object."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        value: Optional[str] = None,
        resources: Optional[List[str]] = None,
        additional_properties: Optional[Dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorInfo(_Model):
    """The code and message for an error.

    :ivar code: A machine readable error code. Required.
    :vartype code: str
    :ivar message: A human readable error message. Required.
    :vartype message: str
    :ivar details: error details.
    :vartype details: list[~azure.monitor.query.models._models.ErrorDetail]
    :ivar innererror: Inner error details if they exist.
    :vartype innererror: ~azure.monitor.query.models._models.ErrorInfo
    :ivar additional_properties: Additional properties that can be provided on the error info
     object.
    :vartype additional_properties: dict[str, any]
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A machine readable error code. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human readable error message. Required."""
    details: Optional[List["_models._models.ErrorDetail"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """error details."""
    innererror: Optional["_models._models.ErrorInfo"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Inner error details if they exist."""
    additional_properties: Optional[Dict[str, Any]] = rest_field(
        name="additionalProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional properties that can be provided on the error info object."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["_models._models.ErrorDetail"]] = None,
        innererror: Optional["_models._models.ErrorInfo"] = None,
        additional_properties: Optional[Dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Contains details when the response code indicates an error.

    :ivar error: The error details. Required.
    :vartype error: ~azure.monitor.query.models._models.ErrorInfo
    """

    error: "_models._models.ErrorInfo" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error details. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models._models.ErrorInfo",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QueryBody(_Model):
    """The Analytics query. Learn more about the
    `Analytics query syntax
    <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.

    :ivar query: The query to execute. Required.
    :vartype query: str
    :ivar timespan: Optional. The timespan over which to query data. This is an ISO8601 time period
     value.  This timespan is applied in addition to any that are specified in the
     query expression.
    :vartype timespan: str
    :ivar workspaces: A list of workspaces to query in addition to the primary workspace.
    :vartype workspaces: list[str]
    """

    query: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The query to execute. Required."""
    timespan: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional. The timespan over which to query data. This is an ISO8601 time period
     value.  This timespan is applied in addition to any that are specified in the
     query expression."""
    workspaces: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of workspaces to query in addition to the primary workspace."""

    @overload
    def __init__(
        self,
        *,
        query: str,
        timespan: Optional[str] = None,
        workspaces: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class QueryResults(_Model):
    """Contains the tables, columns & rows resulting from a query.

    :ivar tables: The results of the query in tabular format. Required.
    :vartype tables: list[~azure.monitor.query.models._models.Table]
    :ivar statistics: Statistics represented in JSON format.
    :vartype statistics: dict[str, any]
    :ivar render: Visualization data in JSON format.
    :vartype render: dict[str, any]
    :ivar error: The code and message for an error.
    :vartype error: ~azure.monitor.query.models._models.ErrorInfo
    """

    tables: List["_models._models.Table"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The results of the query in tabular format. Required."""
    statistics: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Statistics represented in JSON format."""
    render: Optional[Dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Visualization data in JSON format."""
    error: Optional["_models._models.ErrorInfo"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The code and message for an error."""

    @overload
    def __init__(
        self,
        *,
        tables: List["_models._models.Table"],
        statistics: Optional[Dict[str, Any]] = None,
        render: Optional[Dict[str, Any]] = None,
        error: Optional["_models._models.ErrorInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Table(_Model):
    """Contains the columns and rows for one table in a query response.

    :ivar name: The name of the table. Required.
    :vartype name: str
    :ivar columns: The list of columns in this table. Required.
    :vartype columns: list[~azure.monitor.query.models._models.Column]
    :ivar rows: The resulting rows from this query. Required.
    :vartype rows: list[list[any]]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the table. Required."""
    columns: List["_models._models.Column"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of columns in this table. Required."""
    rows: List[List[Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resulting rows from this query. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        columns: List["_models._models.Column"],
        rows: List[List[Any]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
