# Copyright

.NET is a member project of the [.NET Foundation](http://www.dotnetfoundation.org/).

Source copyright is held by ".NET Foundation and Contributors", while binary distributions (and associated copyright) are provided by a variety of parties.

## Source License

The .NET project primarily uses the [MIT License](https://opensource.org/licenses/MIT) for code and [Creative Commons licenses](https://creativecommons.org/) for non-code assets, like [documentation](https://github.com/dotnet/docs/), [swag](https://github.com/dotnet/swag), and [brand](https://github.com/dotnet/brand) content.

We use the following approach for code contributions:

- New code is licensed as MIT, per [repo license](/LICENSE.TXT) and via [file headers](/src/libraries/System.Private.CoreLib/src/System/Collections/Generic/List.cs).
- Contributions (like ports) can be based on existing code or algorithms that are licensed with a permissive [OSI-approved licenses](https://opensource.org/licenses) (for example, [MIT](https://opensource.org/licenses/MIT), [Apache 2](https://opensource.org/licenses/Apache-2.0), and [BSD](https://opensource.org/licenses/BSD-3-Clause)) and should be ackowledged in the [repo THIRD-PARTY-NOTICE](/THIRD-PARTY-NOTICES.TXT) file.
- Non-product contributions (like tests) can be based on existing code or algorithms that are licensed with any OSI-approved license (including [GPL](https://opensource.org/licenses/GPL-2.0)) and should be acknowleged in a local THIRD-PARTY-NOTICE file (for example, [SciMark/THIRD-PARTY-NOTICES](/src/tests/JIT/Performance/CodeQuality/SciMark/THIRD-PARTY-NOTICES)).
- We will typically reject the use of product code licensed with [Creative Commons](https://creativecommons.org/) or [public domain licenses](https://en.wikipedia.org/wiki/Public-domain-equivalent_license) given their lack of universal acceptance.
- The [.NET Foundation Contribution License Agreement (CLA)](https://cla.dotnetfoundation.org) is used to license contributions from contributors.

More mechanical guidance is provided in [CONTRIBUTING.md](../../CONTRIBUTING.md#copying-files-from-other-projects).

References:

- https://opensource.org/faq#cc-zero
- https://opensource.org/faq#public-domain
- https://opensource.stackexchange.com/questions/1717/why-is-cc-by-sa-discouraged-for-code
- https://gitlab.com/fedora/legal/fedora-license-data/-/issues/104
- https://gitlab.com/fedora/legal/fedora-license-data/-/blob/11a7b58ea6d92e1ae06d7d9e44e4a2f2257b687e/data/CC0-1.0.toml#L11

## Binary License

Microsoft distributes binary builds of .NET per the following description. Distributions from other parties may differ.

- Binary archives, installers, packages, and containers are licensed as MIT (same as the [.NET source license](https://github.com/dotnet/core/blob/master/LICENSE.TXT)).
- Windows-based distributions include closed-source assets, per [License information for .NET on Windows](https://github.com/dotnet/core/blob/main/license-information-windows.md)

## Patents

Microsoft has issued a [Patent Promise for .NET Libraries and Runtime Components](/PATENTS.TXT).
