% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trailing_blank_lines_linter.R
\name{trailing_blank_lines_linter}
\alias{trailing_blank_lines_linter}
\title{Trailing blank lines linter}
\usage{
trailing_blank_lines_linter()
}
\description{
Check that there are no trailing blank lines in source code.
}
\examples{
\dontshow{if (requireNamespace("withr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# will produce lints
f <- withr::local_tempfile(lines = "x <- 1\n")
readLines(f)
lint(
  filename = f,
  linters = trailing_blank_lines_linter()
)

# okay
f <- withr::local_tempfile(lines = "x <- 1")
readLines(f)
lint(
  filename = f,
  linters = trailing_blank_lines_linter()
)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=default_linters]{default}, \link[=style_linters]{style}
}
