
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Image_SupportedFormats.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Image_CompressedPixMap.hxx>
#include <Image_SupportedFormats.hxx>
#include <Image_PixMap.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Image_AlienPixMap.hxx>
#include <Image_Color.hxx>
#include <Image_CompressedFormat.hxx>
#include <Image_CompressedPixMap.hxx>
#include <Image_DDSParser.hxx>
#include <Image_Diff.hxx>
#include <Image_Format.hxx>
#include <Image_PixMap.hxx>
#include <Image_PixMapData.hxx>
#include <Image_PixMapTypedData.hxx>
#include <Image_SupportedFormats.hxx>
#include <Image_Texture.hxx>
#include <Image_VideoRecorder.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <ostream>
using std::basic_ostream;
using std::char_traits;

// Module definiiton
void register_Image(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Image"));
py::object klass;

//Python trampoline classes

// classes

    // Class Image_ColorBGR from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorBGR");

    // default constructor
    register_default_constructor<Image_ColorBGR , shared_ptr<Image_ColorBGR>>(m,"Image_ColorBGR");

    // nested enums

    static_cast<py::class_<Image_ColorBGR , shared_ptr<Image_ColorBGR>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_Byte (Image_ColorBGR::*)() const) static_cast<Standard_Byte (Image_ColorBGR::*)() const>(&Image_ColorBGR::r),
             R"#(Alias to 3rd component (red intensity).)#" 
          )
        .def("g",
             (Standard_Byte (Image_ColorBGR::*)() const) static_cast<Standard_Byte (Image_ColorBGR::*)() const>(&Image_ColorBGR::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_Byte (Image_ColorBGR::*)() const) static_cast<Standard_Byte (Image_ColorBGR::*)() const>(&Image_ColorBGR::b),
             R"#(Alias to 1st component (blue intensity).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorBGR::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_Byte & (Image_ColorBGR::*)() ) static_cast<Standard_Byte & (Image_ColorBGR::*)() >(&Image_ColorBGR::r),
             R"#(Alias to 3rd component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_Byte & (Image_ColorBGR::*)() ) static_cast<Standard_Byte & (Image_ColorBGR::*)() >(&Image_ColorBGR::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_Byte & (Image_ColorBGR::*)() ) static_cast<Standard_Byte & (Image_ColorBGR::*)() >(&Image_ColorBGR::b),
             R"#(Alias to 1st component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorBGR32 from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorBGR32");

    // default constructor
    register_default_constructor<Image_ColorBGR32 , shared_ptr<Image_ColorBGR32>>(m,"Image_ColorBGR32");

    // nested enums

    static_cast<py::class_<Image_ColorBGR32 , shared_ptr<Image_ColorBGR32>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_Byte (Image_ColorBGR32::*)() const) static_cast<Standard_Byte (Image_ColorBGR32::*)() const>(&Image_ColorBGR32::r),
             R"#(Alias to 3rd component (red intensity).)#" 
          )
        .def("g",
             (Standard_Byte (Image_ColorBGR32::*)() const) static_cast<Standard_Byte (Image_ColorBGR32::*)() const>(&Image_ColorBGR32::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_Byte (Image_ColorBGR32::*)() const) static_cast<Standard_Byte (Image_ColorBGR32::*)() const>(&Image_ColorBGR32::b),
             R"#(Alias to 1st component (blue intensity).)#" 
          )
        .def("a_",
             (Standard_Byte (Image_ColorBGR32::*)() const) static_cast<Standard_Byte (Image_ColorBGR32::*)() const>(&Image_ColorBGR32::a_),
             R"#(Alias to 4th component (dummy).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorBGR32::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_Byte & (Image_ColorBGR32::*)() ) static_cast<Standard_Byte & (Image_ColorBGR32::*)() >(&Image_ColorBGR32::r),
             R"#(Alias to 3rd component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_Byte & (Image_ColorBGR32::*)() ) static_cast<Standard_Byte & (Image_ColorBGR32::*)() >(&Image_ColorBGR32::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_Byte & (Image_ColorBGR32::*)() ) static_cast<Standard_Byte & (Image_ColorBGR32::*)() >(&Image_ColorBGR32::b),
             R"#(Alias to 1st component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("a_",
             (Standard_Byte & (Image_ColorBGR32::*)() ) static_cast<Standard_Byte & (Image_ColorBGR32::*)() >(&Image_ColorBGR32::a_),
             R"#(Alias to 4th component (dummy).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorBGRA from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorBGRA");

    // default constructor
    register_default_constructor<Image_ColorBGRA , shared_ptr<Image_ColorBGRA>>(m,"Image_ColorBGRA");

    // nested enums

    static_cast<py::class_<Image_ColorBGRA , shared_ptr<Image_ColorBGRA>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_Byte (Image_ColorBGRA::*)() const) static_cast<Standard_Byte (Image_ColorBGRA::*)() const>(&Image_ColorBGRA::r),
             R"#(Alias to 3rd component (red intensity).)#" 
          )
        .def("g",
             (Standard_Byte (Image_ColorBGRA::*)() const) static_cast<Standard_Byte (Image_ColorBGRA::*)() const>(&Image_ColorBGRA::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_Byte (Image_ColorBGRA::*)() const) static_cast<Standard_Byte (Image_ColorBGRA::*)() const>(&Image_ColorBGRA::b),
             R"#(Alias to 1st component (blue intensity).)#" 
          )
        .def("a",
             (Standard_Byte (Image_ColorBGRA::*)() const) static_cast<Standard_Byte (Image_ColorBGRA::*)() const>(&Image_ColorBGRA::a),
             R"#(Alias to 4th component (alpha value).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorBGRA::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_Byte & (Image_ColorBGRA::*)() ) static_cast<Standard_Byte & (Image_ColorBGRA::*)() >(&Image_ColorBGRA::r),
             R"#(Alias to 3rd component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_Byte & (Image_ColorBGRA::*)() ) static_cast<Standard_Byte & (Image_ColorBGRA::*)() >(&Image_ColorBGRA::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_Byte & (Image_ColorBGRA::*)() ) static_cast<Standard_Byte & (Image_ColorBGRA::*)() >(&Image_ColorBGRA::b),
             R"#(Alias to 1st component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("a",
             (Standard_Byte & (Image_ColorBGRA::*)() ) static_cast<Standard_Byte & (Image_ColorBGRA::*)() >(&Image_ColorBGRA::a),
             R"#(Alias to 4th component (alpha value).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorBGRAF from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorBGRAF");

    // default constructor
    register_default_constructor<Image_ColorBGRAF , shared_ptr<Image_ColorBGRAF>>(m,"Image_ColorBGRAF");

    // nested enums

    static_cast<py::class_<Image_ColorBGRAF , shared_ptr<Image_ColorBGRAF>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_ShortReal (Image_ColorBGRAF::*)() const) static_cast<Standard_ShortReal (Image_ColorBGRAF::*)() const>(&Image_ColorBGRAF::r),
             R"#(Alias to 3rd component (red intensity).)#" 
          )
        .def("g",
             (Standard_ShortReal (Image_ColorBGRAF::*)() const) static_cast<Standard_ShortReal (Image_ColorBGRAF::*)() const>(&Image_ColorBGRAF::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_ShortReal (Image_ColorBGRAF::*)() const) static_cast<Standard_ShortReal (Image_ColorBGRAF::*)() const>(&Image_ColorBGRAF::b),
             R"#(Alias to 1st component (blue intensity).)#" 
          )
        .def("a",
             (Standard_ShortReal (Image_ColorBGRAF::*)() const) static_cast<Standard_ShortReal (Image_ColorBGRAF::*)() const>(&Image_ColorBGRAF::a),
             R"#(Alias to 4th component (alpha value).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorBGRAF::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_ShortReal & (Image_ColorBGRAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorBGRAF::*)() >(&Image_ColorBGRAF::r),
             R"#(Alias to 3rd component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_ShortReal & (Image_ColorBGRAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorBGRAF::*)() >(&Image_ColorBGRAF::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_ShortReal & (Image_ColorBGRAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorBGRAF::*)() >(&Image_ColorBGRAF::b),
             R"#(Alias to 1st component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("a",
             (Standard_ShortReal & (Image_ColorBGRAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorBGRAF::*)() >(&Image_ColorBGRAF::a),
             R"#(Alias to 4th component (alpha value).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorBGRF from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorBGRF");

    // default constructor
    register_default_constructor<Image_ColorBGRF , shared_ptr<Image_ColorBGRF>>(m,"Image_ColorBGRF");

    // nested enums

    static_cast<py::class_<Image_ColorBGRF , shared_ptr<Image_ColorBGRF>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_ShortReal (Image_ColorBGRF::*)() const) static_cast<Standard_ShortReal (Image_ColorBGRF::*)() const>(&Image_ColorBGRF::r),
             R"#(Alias to 3rd component (red intensity).)#" 
          )
        .def("g",
             (Standard_ShortReal (Image_ColorBGRF::*)() const) static_cast<Standard_ShortReal (Image_ColorBGRF::*)() const>(&Image_ColorBGRF::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_ShortReal (Image_ColorBGRF::*)() const) static_cast<Standard_ShortReal (Image_ColorBGRF::*)() const>(&Image_ColorBGRF::b),
             R"#(Alias to 1st component (blue intensity).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorBGRF::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_ShortReal & (Image_ColorBGRF::*)() ) static_cast<Standard_ShortReal & (Image_ColorBGRF::*)() >(&Image_ColorBGRF::r),
             R"#(Alias to 3rd component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_ShortReal & (Image_ColorBGRF::*)() ) static_cast<Standard_ShortReal & (Image_ColorBGRF::*)() >(&Image_ColorBGRF::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_ShortReal & (Image_ColorBGRF::*)() ) static_cast<Standard_ShortReal & (Image_ColorBGRF::*)() >(&Image_ColorBGRF::b),
             R"#(Alias to 1st component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorRGB from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorRGB");

    // default constructor
    register_default_constructor<Image_ColorRGB , shared_ptr<Image_ColorRGB>>(m,"Image_ColorRGB");

    // nested enums

    static_cast<py::class_<Image_ColorRGB , shared_ptr<Image_ColorRGB>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_Byte (Image_ColorRGB::*)() const) static_cast<Standard_Byte (Image_ColorRGB::*)() const>(&Image_ColorRGB::r),
             R"#(Alias to 1st component (red intensity).)#" 
          )
        .def("g",
             (Standard_Byte (Image_ColorRGB::*)() const) static_cast<Standard_Byte (Image_ColorRGB::*)() const>(&Image_ColorRGB::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_Byte (Image_ColorRGB::*)() const) static_cast<Standard_Byte (Image_ColorRGB::*)() const>(&Image_ColorRGB::b),
             R"#(Alias to 3rd component (blue intensity).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorRGB::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_Byte & (Image_ColorRGB::*)() ) static_cast<Standard_Byte & (Image_ColorRGB::*)() >(&Image_ColorRGB::r),
             R"#(Alias to 1st component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_Byte & (Image_ColorRGB::*)() ) static_cast<Standard_Byte & (Image_ColorRGB::*)() >(&Image_ColorRGB::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_Byte & (Image_ColorRGB::*)() ) static_cast<Standard_Byte & (Image_ColorRGB::*)() >(&Image_ColorRGB::b),
             R"#(Alias to 3rd component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorRGB32 from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorRGB32");

    // default constructor
    register_default_constructor<Image_ColorRGB32 , shared_ptr<Image_ColorRGB32>>(m,"Image_ColorRGB32");

    // nested enums

    static_cast<py::class_<Image_ColorRGB32 , shared_ptr<Image_ColorRGB32>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_Byte (Image_ColorRGB32::*)() const) static_cast<Standard_Byte (Image_ColorRGB32::*)() const>(&Image_ColorRGB32::r),
             R"#(Alias to 1st component (red intensity).)#" 
          )
        .def("g",
             (Standard_Byte (Image_ColorRGB32::*)() const) static_cast<Standard_Byte (Image_ColorRGB32::*)() const>(&Image_ColorRGB32::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_Byte (Image_ColorRGB32::*)() const) static_cast<Standard_Byte (Image_ColorRGB32::*)() const>(&Image_ColorRGB32::b),
             R"#(Alias to 3rd component (blue intensity).)#" 
          )
        .def("a_",
             (Standard_Byte (Image_ColorRGB32::*)() const) static_cast<Standard_Byte (Image_ColorRGB32::*)() const>(&Image_ColorRGB32::a_),
             R"#(Alias to 4th component (dummy).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorRGB32::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_Byte & (Image_ColorRGB32::*)() ) static_cast<Standard_Byte & (Image_ColorRGB32::*)() >(&Image_ColorRGB32::r),
             R"#(Alias to 1st component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_Byte & (Image_ColorRGB32::*)() ) static_cast<Standard_Byte & (Image_ColorRGB32::*)() >(&Image_ColorRGB32::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_Byte & (Image_ColorRGB32::*)() ) static_cast<Standard_Byte & (Image_ColorRGB32::*)() >(&Image_ColorRGB32::b),
             R"#(Alias to 3rd component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("a_",
             (Standard_Byte & (Image_ColorRGB32::*)() ) static_cast<Standard_Byte & (Image_ColorRGB32::*)() >(&Image_ColorRGB32::a_),
             R"#(Alias to 4th component (dummy).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorRGBA from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorRGBA");

    // default constructor
    register_default_constructor<Image_ColorRGBA , shared_ptr<Image_ColorRGBA>>(m,"Image_ColorRGBA");

    // nested enums

    static_cast<py::class_<Image_ColorRGBA , shared_ptr<Image_ColorRGBA>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_Byte (Image_ColorRGBA::*)() const) static_cast<Standard_Byte (Image_ColorRGBA::*)() const>(&Image_ColorRGBA::r),
             R"#(Alias to 1st component (red intensity).)#" 
          )
        .def("g",
             (Standard_Byte (Image_ColorRGBA::*)() const) static_cast<Standard_Byte (Image_ColorRGBA::*)() const>(&Image_ColorRGBA::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_Byte (Image_ColorRGBA::*)() const) static_cast<Standard_Byte (Image_ColorRGBA::*)() const>(&Image_ColorRGBA::b),
             R"#(Alias to 3rd component (blue intensity).)#" 
          )
        .def("a",
             (Standard_Byte (Image_ColorRGBA::*)() const) static_cast<Standard_Byte (Image_ColorRGBA::*)() const>(&Image_ColorRGBA::a),
             R"#(Alias to 4th component (alpha value).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorRGBA::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_Byte & (Image_ColorRGBA::*)() ) static_cast<Standard_Byte & (Image_ColorRGBA::*)() >(&Image_ColorRGBA::r),
             R"#(Alias to 1st component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_Byte & (Image_ColorRGBA::*)() ) static_cast<Standard_Byte & (Image_ColorRGBA::*)() >(&Image_ColorRGBA::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_Byte & (Image_ColorRGBA::*)() ) static_cast<Standard_Byte & (Image_ColorRGBA::*)() >(&Image_ColorRGBA::b),
             R"#(Alias to 3rd component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("a",
             (Standard_Byte & (Image_ColorRGBA::*)() ) static_cast<Standard_Byte & (Image_ColorRGBA::*)() >(&Image_ColorRGBA::a),
             R"#(Alias to 4th component (alpha value).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorRGBAF from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorRGBAF");

    // default constructor
    register_default_constructor<Image_ColorRGBAF , shared_ptr<Image_ColorRGBAF>>(m,"Image_ColorRGBAF");

    // nested enums

    static_cast<py::class_<Image_ColorRGBAF , shared_ptr<Image_ColorRGBAF>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_ShortReal (Image_ColorRGBAF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGBAF::*)() const>(&Image_ColorRGBAF::r),
             R"#(Alias to 1st component (red intensity).)#" 
          )
        .def("g",
             (Standard_ShortReal (Image_ColorRGBAF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGBAF::*)() const>(&Image_ColorRGBAF::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_ShortReal (Image_ColorRGBAF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGBAF::*)() const>(&Image_ColorRGBAF::b),
             R"#(Alias to 3rd component (blue intensity).)#" 
          )
        .def("a",
             (Standard_ShortReal (Image_ColorRGBAF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGBAF::*)() const>(&Image_ColorRGBAF::a),
             R"#(Alias to 4th component (alpha value).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorRGBAF::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_ShortReal & (Image_ColorRGBAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGBAF::*)() >(&Image_ColorRGBAF::r),
             R"#(Alias to 1st component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_ShortReal & (Image_ColorRGBAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGBAF::*)() >(&Image_ColorRGBAF::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_ShortReal & (Image_ColorRGBAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGBAF::*)() >(&Image_ColorRGBAF::b),
             R"#(Alias to 3rd component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("a",
             (Standard_ShortReal & (Image_ColorRGBAF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGBAF::*)() >(&Image_ColorRGBAF::a),
             R"#(Alias to 4th component (alpha value).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorRGBF from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorRGBF");

    // default constructor
    register_default_constructor<Image_ColorRGBF , shared_ptr<Image_ColorRGBF>>(m,"Image_ColorRGBF");

    // nested enums

    static_cast<py::class_<Image_ColorRGBF , shared_ptr<Image_ColorRGBF>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_ShortReal (Image_ColorRGBF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGBF::*)() const>(&Image_ColorRGBF::r),
             R"#(Alias to 1st component (red intensity).)#" 
          )
        .def("g",
             (Standard_ShortReal (Image_ColorRGBF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGBF::*)() const>(&Image_ColorRGBF::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
        .def("b",
             (Standard_ShortReal (Image_ColorRGBF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGBF::*)() const>(&Image_ColorRGBF::b),
             R"#(Alias to 3rd component (blue intensity).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorRGBF::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_ShortReal & (Image_ColorRGBF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGBF::*)() >(&Image_ColorRGBF::r),
             R"#(Alias to 1st component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_ShortReal & (Image_ColorRGBF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGBF::*)() >(&Image_ColorRGBF::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("b",
             (Standard_ShortReal & (Image_ColorRGBF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGBF::*)() >(&Image_ColorRGBF::b),
             R"#(Alias to 3rd component (blue intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_ColorRGF from ./opencascade/Image_Color.hxx
    klass = m.attr("Image_ColorRGF");

    // default constructor
    register_default_constructor<Image_ColorRGF , shared_ptr<Image_ColorRGF>>(m,"Image_ColorRGF");

    // nested enums

    static_cast<py::class_<Image_ColorRGF , shared_ptr<Image_ColorRGF>  >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("r",
             (Standard_ShortReal (Image_ColorRGF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGF::*)() const>(&Image_ColorRGF::r),
             R"#(Alias to 1st component (red intensity).)#" 
          )
        .def("g",
             (Standard_ShortReal (Image_ColorRGF::*)() const) static_cast<Standard_ShortReal (Image_ColorRGF::*)() const>(&Image_ColorRGF::g),
             R"#(Alias to 2nd component (green intensity).)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Length_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&Image_ColorRGF::Length),
                    R"#(Returns the number of components.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("r",
             (Standard_ShortReal & (Image_ColorRGF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGF::*)() >(&Image_ColorRGF::r),
             R"#(Alias to 1st component (red intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("g",
             (Standard_ShortReal & (Image_ColorRGF::*)() ) static_cast<Standard_ShortReal & (Image_ColorRGF::*)() >(&Image_ColorRGF::g),
             R"#(Alias to 2nd component (green intensity).)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_CompressedPixMap from ./opencascade/Image_CompressedPixMap.hxx
    klass = m.attr("Image_CompressedPixMap");


    // nested enums

    static_cast<py::class_<Image_CompressedPixMap ,opencascade::handle<Image_CompressedPixMap>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("BaseFormat",
             (Image_Format (Image_CompressedPixMap::*)() const) static_cast<Image_Format (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::BaseFormat),
             R"#(Return base (uncompressed) pixel format.)#" 
          )
        .def("SetBaseFormat",
             (void (Image_CompressedPixMap::*)( Image_Format  ) ) static_cast<void (Image_CompressedPixMap::*)( Image_Format  ) >(&Image_CompressedPixMap::SetBaseFormat),
             R"#(Set base (uncompressed) pixel format.)#"  , py::arg("theFormat")
          )
        .def("CompressedFormat",
             (Image_CompressedFormat (Image_CompressedPixMap::*)() const) static_cast<Image_CompressedFormat (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::CompressedFormat),
             R"#(Return compressed format.)#" 
          )
        .def("SetCompressedFormat",
             (void (Image_CompressedPixMap::*)( Image_CompressedFormat  ) ) static_cast<void (Image_CompressedPixMap::*)( Image_CompressedFormat  ) >(&Image_CompressedPixMap::SetCompressedFormat),
             R"#(Set compressed format.)#"  , py::arg("theFormat")
          )
        .def("SetFaceData",
             (void (Image_CompressedPixMap::*)( const opencascade::handle<NCollection_Buffer> &  ) ) static_cast<void (Image_CompressedPixMap::*)( const opencascade::handle<NCollection_Buffer> &  ) >(&Image_CompressedPixMap::SetFaceData),
             R"#(Set raw (compressed) data.)#"  , py::arg("theBuffer")
          )
        .def("IsCompleteMipMapSet",
             (Standard_Boolean (Image_CompressedPixMap::*)() const) static_cast<Standard_Boolean (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::IsCompleteMipMapSet),
             R"#(Return TRUE if complete mip map level set (up to 1x1 resolution).)#" 
          )
        .def("SetCompleteMipMapSet",
             (void (Image_CompressedPixMap::*)( Standard_Boolean  ) ) static_cast<void (Image_CompressedPixMap::*)( Standard_Boolean  ) >(&Image_CompressedPixMap::SetCompleteMipMapSet),
             R"#(Set if complete mip map level set (up to 1x1 resolution).)#"  , py::arg("theIsComplete")
          )
        .def("FaceBytes",
             (Standard_Size (Image_CompressedPixMap::*)() const) static_cast<Standard_Size (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::FaceBytes),
             R"#(Return surface length in bytes.)#" 
          )
        .def("SetFaceBytes",
             (void (Image_CompressedPixMap::*)( Standard_Size  ) ) static_cast<void (Image_CompressedPixMap::*)( Standard_Size  ) >(&Image_CompressedPixMap::SetFaceBytes),
             R"#(Set surface length in bytes.)#"  , py::arg("theSize")
          )
        .def("SizeX",
             (Standard_Integer (Image_CompressedPixMap::*)() const) static_cast<Standard_Integer (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::SizeX),
             R"#(Return surface width.)#" 
          )
        .def("SizeY",
             (Standard_Integer (Image_CompressedPixMap::*)() const) static_cast<Standard_Integer (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::SizeY),
             R"#(Return surface height.)#" 
          )
        .def("SetSize",
             (void (Image_CompressedPixMap::*)( Standard_Integer ,  Standard_Integer  ) ) static_cast<void (Image_CompressedPixMap::*)( Standard_Integer ,  Standard_Integer  ) >(&Image_CompressedPixMap::SetSize),
             R"#(Set surface width x height.)#"  , py::arg("theSizeX"),  py::arg("theSizeY")
          )
        .def("IsTopDown",
             (bool (Image_CompressedPixMap::*)() const) static_cast<bool (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::IsTopDown),
             R"#(Return TRUE if image layout is top-down (always true).)#" 
          )
        .def("NbFaces",
             (Standard_Integer (Image_CompressedPixMap::*)() const) static_cast<Standard_Integer (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::NbFaces),
             R"#(Return number of faces in the file; should be 6 for cubemap.)#" 
          )
        .def("SetNbFaces",
             (void (Image_CompressedPixMap::*)( Standard_Integer  ) ) static_cast<void (Image_CompressedPixMap::*)( Standard_Integer  ) >(&Image_CompressedPixMap::SetNbFaces),
             R"#(Set number of faces in the file.)#"  , py::arg("theSize")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_CompressedPixMap::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_CompressedPixMap::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_CompressedPixMap::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::DynamicType),
             R"#(None)#"
             
         )
       .def("FaceData",
             (const opencascade::handle<NCollection_Buffer> & (Image_CompressedPixMap::*)() const) static_cast<const opencascade::handle<NCollection_Buffer> & (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::FaceData),
             R"#(Return raw (compressed) data.)#"
             
         )
       .def("MipMaps",
             (const NCollection_Array1<Standard_Integer> & (Image_CompressedPixMap::*)() const) static_cast<const NCollection_Array1<Standard_Integer> & (Image_CompressedPixMap::*)() const>(&Image_CompressedPixMap::MipMaps),
             R"#(Return Array of mipmap sizes, including base level.)#"
             
         )
       .def("ChangeMipMaps",
             (NCollection_Array1<Standard_Integer> & (Image_CompressedPixMap::*)() ) static_cast<NCollection_Array1<Standard_Integer> & (Image_CompressedPixMap::*)() >(&Image_CompressedPixMap::ChangeMipMaps),
             R"#(Return Array of mipmap sizes, including base level.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_DDSParser from ./opencascade/Image_DDSParser.hxx
    klass = m.attr("Image_DDSParser");

    // default constructor
    register_default_constructor<Image_DDSParser , shared_ptr<Image_DDSParser>>(m,"Image_DDSParser");

    // nested enums

    static_cast<py::class_<Image_DDSParser , shared_ptr<Image_DDSParser>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Load_s",
                    (opencascade::handle<Image_CompressedPixMap> (*)( const opencascade::handle<Image_SupportedFormats> & ,  const TCollection_AsciiString & ,  const Standard_Integer ,  const int64_t  ) ) static_cast<opencascade::handle<Image_CompressedPixMap> (*)( const opencascade::handle<Image_SupportedFormats> & ,  const TCollection_AsciiString & ,  const Standard_Integer ,  const int64_t  ) >(&Image_DDSParser::Load),
                    R"#(Load the face from DDS file.)#"  , py::arg("theSupported"),  py::arg("theFile"),  py::arg("theFaceIndex"),  py::arg("theFileOffset")=static_cast<const int64_t>(0)
          )
        .def_static("Load_s",
                    (opencascade::handle<Image_CompressedPixMap> (*)( const opencascade::handle<Image_SupportedFormats> & ,  const opencascade::handle<NCollection_Buffer> & ,  const Standard_Integer  ) ) static_cast<opencascade::handle<Image_CompressedPixMap> (*)( const opencascade::handle<Image_SupportedFormats> & ,  const opencascade::handle<NCollection_Buffer> & ,  const Standard_Integer  ) >(&Image_DDSParser::Load),
                    R"#(Load the face from DDS file.)#"  , py::arg("theSupported"),  py::arg("theBuffer"),  py::arg("theFaceIndex")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Image_Diff from ./opencascade/Image_Diff.hxx
    klass = m.attr("Image_Diff");


    // nested enums

    static_cast<py::class_<Image_Diff ,opencascade::handle<Image_Diff>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (Standard_Boolean (Image_Diff::*)( const opencascade::handle<Image_PixMap> & ,  const opencascade::handle<Image_PixMap> & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (Image_Diff::*)( const opencascade::handle<Image_PixMap> & ,  const opencascade::handle<Image_PixMap> & ,  const Standard_Boolean  ) >(&Image_Diff::Init),
             R"#(Initialize algorithm by two images.)#"  , py::arg("theImageRef"),  py::arg("theImageNew"),  py::arg("theToBlackWhite")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("Init",
             (Standard_Boolean (Image_Diff::*)( const TCollection_AsciiString & ,  const TCollection_AsciiString & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (Image_Diff::*)( const TCollection_AsciiString & ,  const TCollection_AsciiString & ,  const Standard_Boolean  ) >(&Image_Diff::Init),
             R"#(Initialize algorithm by two images (will be loaded from files).)#"  , py::arg("theImgPathRef"),  py::arg("theImgPathNew"),  py::arg("theToBlackWhite")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("SetColorTolerance",
             (void (Image_Diff::*)( const Standard_Real  ) ) static_cast<void (Image_Diff::*)( const Standard_Real  ) >(&Image_Diff::SetColorTolerance),
             R"#(Color tolerance for equality check. Should be within range 0..1: Corresponds to a difference between white and black colors (maximum difference). By default, the tolerance is equal to 0 thus equality check will return false for any different colors.)#"  , py::arg("theTolerance")
          )
        .def("ColorTolerance",
             (Standard_Real (Image_Diff::*)() const) static_cast<Standard_Real (Image_Diff::*)() const>(&Image_Diff::ColorTolerance),
             R"#(Color tolerance for equality check.)#" 
          )
        .def("SetBorderFilterOn",
             (void (Image_Diff::*)( const Standard_Boolean  ) ) static_cast<void (Image_Diff::*)( const Standard_Boolean  ) >(&Image_Diff::SetBorderFilterOn),
             R"#(Sets taking into account (ignoring) a "border effect" on comparison of images. The border effect is caused by a border of shaded shapes in the viewer 3d. Triangles of this area are located at about 0 or 90 degrees to the user. Therefore, they deflect light differently according to implementation of a video card driver. This flag allows to detect such a "border" area and skip it from comparison of images. Filter turned OFF by default.)#"  , py::arg("theToIgnore")
          )
        .def("IsBorderFilterOn",
             (Standard_Boolean (Image_Diff::*)() const) static_cast<Standard_Boolean (Image_Diff::*)() const>(&Image_Diff::IsBorderFilterOn),
             R"#(Returns a flag of taking into account (ignoring) a border effect in comparison of images.)#" 
          )
        .def("Compare",
             (Standard_Integer (Image_Diff::*)() ) static_cast<Standard_Integer (Image_Diff::*)() >(&Image_Diff::Compare),
             R"#(Compares two images. It returns a number of different pixels (or groups of pixels). It returns -1 if algorithm not initialized before.)#" 
          )
        .def("SaveDiffImage",
             (Standard_Boolean (Image_Diff::*)( Image_PixMap &  ) const) static_cast<Standard_Boolean (Image_Diff::*)( Image_PixMap &  ) const>(&Image_Diff::SaveDiffImage),
             R"#(Saves a difference between two images as white pixels on black background.)#"  , py::arg("theDiffImage")
          )
        .def("SaveDiffImage",
             (Standard_Boolean (Image_Diff::*)( const TCollection_AsciiString &  ) const) static_cast<Standard_Boolean (Image_Diff::*)( const TCollection_AsciiString &  ) const>(&Image_Diff::SaveDiffImage),
             R"#(Saves a difference between two images as white pixels on black background.)#"  , py::arg("theDiffPath")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_Diff::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_Diff::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_Diff::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_Diff::*)() const>(&Image_Diff::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Image_PixMap from ./opencascade/Image_PixMap.hxx
    klass = m.attr("Image_PixMap");


    // nested enums

    static_cast<py::class_<Image_PixMap ,opencascade::handle<Image_PixMap>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Format",
             (Image_Format (Image_PixMap::*)() const) static_cast<Image_Format (Image_PixMap::*)() const>(&Image_PixMap::Format),
             R"#(Return pixel format.)#" 
          )
        .def("SetFormat",
             (void (Image_PixMap::*)( const Image_Format  ) ) static_cast<void (Image_PixMap::*)( const Image_Format  ) >(&Image_PixMap::SetFormat),
             R"#(Override pixel format specified by InitXXX() methods. Will throw exception if pixel size of new format is not equal to currently initialized format. Intended to switch formats indicating different interpretation of the same data (e.g. ImgGray and ImgAlpha).)#"  , py::arg("thePixelFormat")
          )
        .def("Width",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::Width),
             R"#(Return image width in pixels.)#" 
          )
        .def("Height",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::Height),
             R"#(Return image height in pixels.)#" 
          )
        .def("Depth",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::Depth),
             R"#(Return image depth in pixels.)#" 
          )
        .def("SizeX",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::SizeX),
             R"#(Return image width in pixels.)#" 
          )
        .def("SizeY",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::SizeY),
             R"#(Return image height in pixels.)#" 
          )
        .def("SizeZ",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::SizeZ),
             R"#(Return image depth in pixels.)#" 
          )
        .def("SizeXYZ",
             (NCollection_Vec3<Standard_Size> (Image_PixMap::*)() const) static_cast<NCollection_Vec3<Standard_Size> (Image_PixMap::*)() const>(&Image_PixMap::SizeXYZ),
             R"#(Return image width x height x depth in pixels.)#" 
          )
        .def("Ratio",
             (Standard_Real (Image_PixMap::*)() const) static_cast<Standard_Real (Image_PixMap::*)() const>(&Image_PixMap::Ratio),
             R"#(Return width / height.)#" 
          )
        .def("IsEmpty",
             (bool (Image_PixMap::*)() const) static_cast<bool (Image_PixMap::*)() const>(&Image_PixMap::IsEmpty),
             R"#(Return true if data is NULL.)#" 
          )
        .def("PixelColor",
             (Quantity_ColorRGBA (Image_PixMap::*)( Standard_Integer ,  Standard_Integer ,  Standard_Boolean  ) const) static_cast<Quantity_ColorRGBA (Image_PixMap::*)( Standard_Integer ,  Standard_Integer ,  Standard_Boolean  ) const>(&Image_PixMap::PixelColor),
             R"#(Returns the pixel color. This function is relatively slow. Beware that this method takes coordinates in opposite order in contrast to ::Value() and ::ChangeValue().)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theToLinearize")=static_cast<Standard_Boolean>(false)
          )
        .def("SetPixelColor",
             (void (Image_PixMap::*)( const Standard_Integer ,  const Standard_Integer ,  const Quantity_Color & ,  const Standard_Boolean  ) ) static_cast<void (Image_PixMap::*)( const Standard_Integer ,  const Standard_Integer ,  const Quantity_Color & ,  const Standard_Boolean  ) >(&Image_PixMap::SetPixelColor),
             R"#(Sets the pixel color. This function is relatively slow. Beware that this method takes coordinates in opposite order in contrast to ::Value() and ::ChangeValue().)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theColor"),  py::arg("theToDeLinearize")=static_cast<const Standard_Boolean>(false)
          )
        .def("SetPixelColor",
             (void (Image_PixMap::*)( const Standard_Integer ,  const Standard_Integer ,  const Quantity_ColorRGBA & ,  const Standard_Boolean  ) ) static_cast<void (Image_PixMap::*)( const Standard_Integer ,  const Standard_Integer ,  const Quantity_ColorRGBA & ,  const Standard_Boolean  ) >(&Image_PixMap::SetPixelColor),
             R"#(Sets the pixel color. This function is relatively slow. Beware that this method takes coordinates in opposite order in contrast to ::Value() and ::ChangeValue().)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theColor"),  py::arg("theToDeLinearize")=static_cast<const Standard_Boolean>(false)
          )
        .def("InitWrapper",
             (bool (Image_PixMap::*)( Image_Format ,  Standard_Byte * ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size  ) ) static_cast<bool (Image_PixMap::*)( Image_Format ,  Standard_Byte * ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size  ) >(&Image_PixMap::InitWrapper),
             R"#(Initialize image plane as wrapper over alien data. Data will not be copied! Notice that caller should ensure that data pointer will not be released during this wrapper lifetime. You may call InitCopy() to perform data copying.)#"  , py::arg("thePixelFormat"),  py::arg("theDataPtr"),  py::arg("theSizeX"),  py::arg("theSizeY"),  py::arg("theSizeRowBytes")=static_cast<const Standard_Size>(0)
          )
        .def("InitTrash",
             (bool (Image_PixMap::*)( Image_Format ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size  ) ) static_cast<bool (Image_PixMap::*)( Image_Format ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size  ) >(&Image_PixMap::InitTrash),
             R"#(Initialize image plane with required dimensions. Memory will be left uninitialized (performance trick).)#"  , py::arg("thePixelFormat"),  py::arg("theSizeX"),  py::arg("theSizeY"),  py::arg("theSizeRowBytes")=static_cast<const Standard_Size>(0)
          )
        .def("InitCopy",
             (bool (Image_PixMap::*)( const Image_PixMap &  ) ) static_cast<bool (Image_PixMap::*)( const Image_PixMap &  ) >(&Image_PixMap::InitCopy),
             R"#(Initialize by copying data. If you want to copy alien data you should create wrapper using InitWrapper() before.)#"  , py::arg("theCopy")
          )
        .def("InitZero",
             (bool (Image_PixMap::*)( Image_Format ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size ,  const Standard_Byte  ) ) static_cast<bool (Image_PixMap::*)( Image_Format ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size ,  const Standard_Byte  ) >(&Image_PixMap::InitZero),
             R"#(Initialize image plane with required dimensions. Buffer will be zeroed (black color for most formats).)#"  , py::arg("thePixelFormat"),  py::arg("theSizeX"),  py::arg("theSizeY"),  py::arg("theSizeRowBytes")=static_cast<const Standard_Size>(0),  py::arg("theValue")=static_cast<const Standard_Byte>(0)
          )
        .def("Clear",
             (void (Image_PixMap::*)() ) static_cast<void (Image_PixMap::*)() >(&Image_PixMap::Clear),
             R"#(Method correctly deallocate internal buffer.)#" 
          )
        .def("InitWrapper3D",
             (bool (Image_PixMap::*)( Image_Format ,  Standard_Byte * ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size  ) ) static_cast<bool (Image_PixMap::*)( Image_Format ,  Standard_Byte * ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size  ) >(&Image_PixMap::InitWrapper3D),
             R"#(Initialize 2D/3D image as wrapper over alien data. Data will not be copied! Notice that caller should ensure that data pointer will not be released during this wrapper lifetime. You may call InitCopy() to perform data copying.)#"  , py::arg("thePixelFormat"),  py::arg("theDataPtr"),  py::arg("theSizeXYZ"),  py::arg("theSizeRowBytes")=static_cast<const Standard_Size>(0)
          )
        .def("InitTrash3D",
             (bool (Image_PixMap::*)( Image_Format ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size  ) ) static_cast<bool (Image_PixMap::*)( Image_Format ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size  ) >(&Image_PixMap::InitTrash3D),
             R"#(Initialize 2D/3D image with required dimensions. Memory will be left uninitialized (performance trick).)#"  , py::arg("thePixelFormat"),  py::arg("theSizeXYZ"),  py::arg("theSizeRowBytes")=static_cast<const Standard_Size>(0)
          )
        .def("InitZero3D",
             (bool (Image_PixMap::*)( Image_Format ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size ,  const Standard_Byte  ) ) static_cast<bool (Image_PixMap::*)( Image_Format ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size ,  const Standard_Byte  ) >(&Image_PixMap::InitZero3D),
             R"#(Initialize 2D/3D image with required dimensions. Buffer will be zeroed (black color for most formats).)#"  , py::arg("thePixelFormat"),  py::arg("theSizeXYZ"),  py::arg("theSizeRowBytes")=static_cast<const Standard_Size>(0),  py::arg("theValue")=static_cast<const Standard_Byte>(0)
          )
        .def("IsTopDown",
             (bool (Image_PixMap::*)() const) static_cast<bool (Image_PixMap::*)() const>(&Image_PixMap::IsTopDown),
             R"#(Returns TRUE if image data is stored from Top to the Down. By default Bottom Up order is used instead (topmost scanlines starts from the bottom in memory). which is most image frameworks naturally support.)#" 
          )
        .def("SetTopDown",
             (void (Image_PixMap::*)( const bool  ) ) static_cast<void (Image_PixMap::*)( const bool  ) >(&Image_PixMap::SetTopDown),
             R"#(Setup scanlines order in memory - top-down or bottom-up. Drawers should explicitly specify this value if current state IsTopDown() was ignored!)#"  , py::arg("theIsTopDown")
          )
        .def("TopDownInc",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::TopDownInc),
             R"#(Returns +1 if scanlines ordered in Top->Down order in memory and -1 otherwise.)#" 
          )
        .def("Data",
             (const Standard_Byte * (Image_PixMap::*)() const) static_cast<const Standard_Byte * (Image_PixMap::*)() const>(&Image_PixMap::Data),
             R"#(Return data pointer for low-level operations (copying entire buffer, parsing with extra tools etc.).)#" 
          )
        .def("ChangeData",
             (Standard_Byte * (Image_PixMap::*)() ) static_cast<Standard_Byte * (Image_PixMap::*)() >(&Image_PixMap::ChangeData),
             R"#(Return data pointer for low-level operations (copying entire buffer, parsing with extra tools etc.).)#" 
          )
        .def("Row",
             (const Standard_Byte * (Image_PixMap::*)( Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMap::*)( Standard_Size  ) const>(&Image_PixMap::Row),
             R"#(Return data pointer to requested row (first column). Indexation starts from 0.)#"  , py::arg("theRow")
          )
        .def("ChangeRow",
             (Standard_Byte * (Image_PixMap::*)( Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMap::*)( Standard_Size  ) >(&Image_PixMap::ChangeRow),
             R"#(Return data pointer to requested row (first column). Indexation starts from 0.)#"  , py::arg("theRow")
          )
        .def("Slice",
             (const Standard_Byte * (Image_PixMap::*)( Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMap::*)( Standard_Size  ) const>(&Image_PixMap::Slice),
             R"#(Return data pointer to requested 2D slice. Indexation starts from 0.)#"  , py::arg("theSlice")
          )
        .def("ChangeSlice",
             (Standard_Byte * (Image_PixMap::*)( Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMap::*)( Standard_Size  ) >(&Image_PixMap::ChangeSlice),
             R"#(Return data pointer to requested 2D slice. Indexation starts from 0.)#"  , py::arg("theSlice")
          )
        .def("SliceRow",
             (const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) const>(&Image_PixMap::SliceRow),
             R"#(Return data pointer to requested row (first column). Indexation starts from 0.)#"  , py::arg("theSlice"),  py::arg("theRow")
          )
        .def("ChangeSliceRow",
             (Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) >(&Image_PixMap::ChangeSliceRow),
             R"#(Return data pointer to requested row (first column). Indexation starts from 0.)#"  , py::arg("theSlice"),  py::arg("theRow")
          )
        .def("SizePixelBytes",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::SizePixelBytes),
             R"#(Return bytes reserved for one pixel (may include extra bytes for alignment).)#" 
          )
        .def("SizeRowBytes",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::SizeRowBytes),
             R"#(Return bytes reserved per row. Could be larger than needed to store packed row (extra bytes for alignment etc.).)#" 
          )
        .def("RowExtraBytes",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::RowExtraBytes),
             R"#(Return the extra bytes in the row.)#" 
          )
        .def("MaxRowAligmentBytes",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::MaxRowAligmentBytes),
             R"#(Compute the maximal row alignment for current row size.)#" 
          )
        .def("SizeSliceBytes",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::SizeSliceBytes),
             R"#(Return number of bytes per 2D slice.)#" 
          )
        .def("SizeBytes",
             (Standard_Size (Image_PixMap::*)() const) static_cast<Standard_Size (Image_PixMap::*)() const>(&Image_PixMap::SizeBytes),
             R"#(Return buffer size)#" 
          )
        .def("RawValue",
             (const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) const>(&Image_PixMap::RawValue),
             R"#(Access image pixel as raw data pointer. Indexation starts from 0. This method does not perform any type checks - use on own risk (check Format() before)! WARNING: Input parameters are defined in the decreasing majority following memory layout - e.g. row first, column next.)#"  , py::arg("theRow"),  py::arg("theCol")
          )
        .def("ChangeRawValue",
             (Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) >(&Image_PixMap::ChangeRawValue),
             R"#(Access image pixel as raw data pointer. Indexation starts from 0. This method does not perform any type checks - use on own risk (check Format() before)! WARNING: Input parameters are defined in the decreasing majority following memory layout - e.g. row first, column next.)#"  , py::arg("theRow"),  py::arg("theCol")
          )
        .def("RawValueXY",
             (const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) const>(&Image_PixMap::RawValueXY),
             R"#(Access image pixel as raw data pointer. Indexation starts from 0. This method does not perform any type checks - use on own risk (check Format() before)! WARNING: Input parameters are defined in traditional X, Y order.)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("ChangeRawValueXY",
             (Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size  ) >(&Image_PixMap::ChangeRawValueXY),
             R"#(Access image pixel as raw data pointer. Indexation starts from 0. This method does not perform any type checks - use on own risk (check Format() before)! WARNING: Input parameters are defined in traditional X, Y order.)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("RawValueXYZ",
             (const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) const>(&Image_PixMap::RawValueXYZ),
             R"#(Access image pixel as raw data pointer. Indexation starts from 0. This method does not perform any type checks - use on own risk (check Format() before)! WARNING: Input parameters are defined in traditional X, Y, Z order.)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("ChangeRawValueXYZ",
             (Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMap::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) >(&Image_PixMap::ChangeRawValueXYZ),
             R"#(Access image pixel as raw data pointer. Indexation starts from 0. This method does not perform any type checks - use on own risk (check Format() before)! WARNING: Input parameters are defined in traditional X, Y, Z order.)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_PixMap::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_PixMap::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("IsBigEndianHost_s",
                    (bool (*)() ) static_cast<bool (*)() >(&Image_PixMap::IsBigEndianHost),
                    R"#(Determine Big-Endian at runtime)#" 
          )
        .def_static("SizePixelBytes_s",
                    (Standard_Size (*)( const Image_Format  ) ) static_cast<Standard_Size (*)( const Image_Format  ) >(&Image_PixMap::SizePixelBytes),
                    R"#(Return bytes reserved for one pixel (may include extra bytes for alignment).)#"  , py::arg("thePixelFormat")
          )
        .def_static("SwapRgbaBgra_s",
                    (bool (*)( Image_PixMap &  ) ) static_cast<bool (*)( Image_PixMap &  ) >(&Image_PixMap::SwapRgbaBgra),
                    R"#(Auxiliary method for swapping bytes between RGB and BGR formats. This method modifies the image data but does not change pixel format! Method will fail if pixel format is not one of the following: - Image_Format_RGB32 / Image_Format_BGR32 - Image_Format_RGBA / Image_Format_BGRA - Image_Format_RGB / Image_Format_BGR - Image_Format_RGBF / Image_Format_BGRF - Image_Format_RGBAF / Image_Format_BGRAF)#"  , py::arg("theImage")
          )
        .def_static("ToBlackWhite_s",
                    (void (*)( Image_PixMap &  ) ) static_cast<void (*)( Image_PixMap &  ) >(&Image_PixMap::ToBlackWhite),
                    R"#(Convert image to Black/White.)#"  , py::arg("theImage")
          )
        .def_static("FlipY_s",
                    (bool (*)( Image_PixMap &  ) ) static_cast<bool (*)( Image_PixMap &  ) >(&Image_PixMap::FlipY),
                    R"#(Reverse line order as it draws it from bottom to top.)#"  , py::arg("theImage")
          )
        .def_static("DefaultAllocator_s",
                    (const opencascade::handle<NCollection_BaseAllocator> & (*)() ) static_cast<const opencascade::handle<NCollection_BaseAllocator> & (*)() >(&Image_PixMap::DefaultAllocator),
                    R"#(Return default image data allocator.)#" 
          )
        .def_static("ImageFormatToString_s",
                    (Standard_CString (*)( Image_Format  ) ) static_cast<Standard_CString (*)( Image_Format  ) >(&Image_PixMap::ImageFormatToString),
                    R"#(Return string representation of pixel format.)#"  , py::arg("theFormat")
          )
        .def_static("ImageFormatToString_s",
                    (Standard_CString (*)( Image_CompressedFormat  ) ) static_cast<Standard_CString (*)( Image_CompressedFormat  ) >(&Image_PixMap::ImageFormatToString),
                    R"#(Return string representation of compressed pixel format.)#"  , py::arg("theFormat")
          )
        .def_static("ColorFromRawPixel_s",
                    (Quantity_ColorRGBA (*)( const Standard_Byte * ,  const Image_Format ,  const Standard_Boolean  ) ) static_cast<Quantity_ColorRGBA (*)( const Standard_Byte * ,  const Image_Format ,  const Standard_Boolean  ) >(&Image_PixMap::ColorFromRawPixel),
                    R"#(Convert raw pixel value into Quantity_ColorRGBA. This function is relatively slow.)#"  , py::arg("theRawValue"),  py::arg("theFormat"),  py::arg("theToLinearize")=static_cast<const Standard_Boolean>(false)
          )
        .def_static("ColorToRawPixel_s",
                    (void (*)( Standard_Byte * ,  const Image_Format ,  const Quantity_ColorRGBA & ,  const Standard_Boolean  ) ) static_cast<void (*)( Standard_Byte * ,  const Image_Format ,  const Quantity_ColorRGBA & ,  const Standard_Boolean  ) >(&Image_PixMap::ColorToRawPixel),
                    R"#(Set raw pixel value from Quantity_ColorRGBA. This function is relatively slow.)#"  , py::arg("theRawValue"),  py::arg("theFormat"),  py::arg("theColor"),  py::arg("theToDeLinearize")=static_cast<const Standard_Boolean>(false)
          )
        .def_static("ConvertFromHalfFloat_s",
                    (float (*)( const uint16_t  ) ) static_cast<float (*)( const uint16_t  ) >(&Image_PixMap::ConvertFromHalfFloat),
                    R"#(Convert 16-bit half-float value into 32-bit float (simple conversion).)#"  , py::arg("theHalf")
          )
        .def_static("ConvertToHalfFloat_s",
                    (uint16_t (*)( const float  ) ) static_cast<uint16_t (*)( const float  ) >(&Image_PixMap::ConvertToHalfFloat),
                    R"#(Convert 32-bit float value into IEEE-754 16-bit floating-point format without infinity: 1-5-10, exp-15, +-131008.0, +-6.1035156E-5, +-5.9604645E-8, 3.311 digits.)#"  , py::arg("theFloat")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_PixMap::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_PixMap::*)() const>(&Image_PixMap::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Image_PixMapData from ./opencascade/Image_PixMapData.hxx
    klass = m.attr("Image_PixMapData");


    // nested enums

    static_cast<py::class_<Image_PixMapData ,opencascade::handle<Image_PixMapData>  , NCollection_Buffer >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Init",
             (bool (Image_PixMapData::*)( const opencascade::handle<NCollection_BaseAllocator> & ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size ,  Standard_Byte *  ) ) static_cast<bool (Image_PixMapData::*)( const opencascade::handle<NCollection_BaseAllocator> & ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size ,  Standard_Byte *  ) >(&Image_PixMapData::Init),
             R"#(Initializer.)#"  , py::arg("theAlloc"),  py::arg("theSizeBPP"),  py::arg("theSizeX"),  py::arg("theSizeY"),  py::arg("theSizeRowBytes"),  py::arg("theDataPtr")
          )
        .def("Init",
             (bool (Image_PixMapData::*)( const opencascade::handle<NCollection_BaseAllocator> & ,  const Standard_Size ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size ,  Standard_Byte *  ) ) static_cast<bool (Image_PixMapData::*)( const opencascade::handle<NCollection_BaseAllocator> & ,  const Standard_Size ,  const NCollection_Vec3<Standard_Size> & ,  const Standard_Size ,  Standard_Byte *  ) >(&Image_PixMapData::Init),
             R"#(Initializer.)#"  , py::arg("theAlloc"),  py::arg("theSizeBPP"),  py::arg("theSizeXYZ"),  py::arg("theSizeRowBytes"),  py::arg("theDataPtr")
          )
        .def("ZeroData",
             (void (Image_PixMapData::*)() ) static_cast<void (Image_PixMapData::*)() >(&Image_PixMapData::ZeroData),
             R"#(Reset all values to zeros.)#" 
          )
        .def("Row",
             (const Standard_Byte * (Image_PixMapData::*)( const Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMapData::*)( const Standard_Size  ) const>(&Image_PixMapData::Row),
             R"#(Return data pointer to requested row (first column).)#"  , py::arg("theRow")
          )
        .def("ChangeRow",
             (Standard_Byte * (Image_PixMapData::*)( const Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMapData::*)( const Standard_Size  ) >(&Image_PixMapData::ChangeRow),
             R"#(Return data pointer to requested row (first column).)#"  , py::arg("theRow")
          )
        .def("Value",
             (const Standard_Byte * (Image_PixMapData::*)( const Standard_Size ,  const Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMapData::*)( const Standard_Size ,  const Standard_Size  ) const>(&Image_PixMapData::Value),
             R"#(Return data pointer to requested position.)#"  , py::arg("theRow"),  py::arg("theCol")
          )
        .def("ChangeValue",
             (Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) >(&Image_PixMapData::ChangeValue),
             R"#(Return data pointer to requested position.)#"  , py::arg("theRow"),  py::arg("theCol")
          )
        .def("ValueXY",
             (const Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) const>(&Image_PixMapData::ValueXY),
             R"#(Return data pointer to requested position.)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("ChangeValueXY",
             (Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) >(&Image_PixMapData::ChangeValueXY),
             R"#(Return data pointer to requested position.)#"  , py::arg("theX"),  py::arg("theY")
          )
        .def("Slice",
             (const Standard_Byte * (Image_PixMapData::*)( Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMapData::*)( Standard_Size  ) const>(&Image_PixMapData::Slice),
             R"#(Return data pointer to requested 2D slice.)#"  , py::arg("theSlice")
          )
        .def("ChangeSlice",
             (Standard_Byte * (Image_PixMapData::*)( Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMapData::*)( Standard_Size  ) >(&Image_PixMapData::ChangeSlice),
             R"#(Return data pointer to requested 2D slice.)#"  , py::arg("theSlice")
          )
        .def("SliceRow",
             (const Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) const>(&Image_PixMapData::SliceRow),
             R"#(Return data pointer to requested row (first column).)#"  , py::arg("theSlice"),  py::arg("theRow")
          )
        .def("ChangeSliceRow",
             (Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size  ) >(&Image_PixMapData::ChangeSliceRow),
             R"#(Return data pointer to requested row (first column).)#"  , py::arg("theSlice"),  py::arg("theRow")
          )
        .def("ValueXYZ",
             (const Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) const) static_cast<const Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) const>(&Image_PixMapData::ValueXYZ),
             R"#(Return data pointer to requested position.)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("ChangeValueXYZ",
             (Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) ) static_cast<Standard_Byte * (Image_PixMapData::*)( Standard_Size ,  Standard_Size ,  Standard_Size  ) >(&Image_PixMapData::ChangeValueXYZ),
             R"#(Return data pointer to requested position.)#"  , py::arg("theX"),  py::arg("theY"),  py::arg("theZ")
          )
        .def("MaxRowAligmentBytes",
             (Standard_Size (Image_PixMapData::*)() const) static_cast<Standard_Size (Image_PixMapData::*)() const>(&Image_PixMapData::MaxRowAligmentBytes),
             R"#(Compute the maximal row alignment for current row size.)#" 
          )
        .def("SetTopDown",
             (void (Image_PixMapData::*)( const bool  ) ) static_cast<void (Image_PixMapData::*)( const bool  ) >(&Image_PixMapData::SetTopDown),
             R"#(Setup scanlines order in memory - top-down or bottom-up. Drawers should explicitly specify this value if current state IsTopDown() was ignored!)#"  , py::arg("theIsTopDown")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_PixMapData::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_PixMapData::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("SizeBPP", &Image_PixMapData::SizeBPP)
        .def_readwrite("SizeX", &Image_PixMapData::SizeX)
        .def_readwrite("SizeY", &Image_PixMapData::SizeY)
        .def_readwrite("SizeZ", &Image_PixMapData::SizeZ)
        .def_readwrite("SizeRowBytes", &Image_PixMapData::SizeRowBytes)
        .def_readwrite("SizeSliceBytes", &Image_PixMapData::SizeSliceBytes)
        .def_readwrite("TopToDown", &Image_PixMapData::TopToDown)
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_PixMapData::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_PixMapData::*)() const>(&Image_PixMapData::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Image_SupportedFormats from ./opencascade/Image_SupportedFormats.hxx
    klass = m.attr("Image_SupportedFormats");


    // nested enums

    static_cast<py::class_<Image_SupportedFormats ,opencascade::handle<Image_SupportedFormats>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("IsSupported",
             (bool (Image_SupportedFormats::*)( Image_Format  ) const) static_cast<bool (Image_SupportedFormats::*)( Image_Format  ) const>(&Image_SupportedFormats::IsSupported),
             R"#(Return TRUE if image format is supported.)#"  , py::arg("theFormat")
          )
        .def("Add",
             (void (Image_SupportedFormats::*)( Image_Format  ) ) static_cast<void (Image_SupportedFormats::*)( Image_Format  ) >(&Image_SupportedFormats::Add),
             R"#(Set if image format is supported or not.)#"  , py::arg("theFormat")
          )
        .def("HasCompressed",
             (bool (Image_SupportedFormats::*)() const) static_cast<bool (Image_SupportedFormats::*)() const>(&Image_SupportedFormats::HasCompressed),
             R"#(Return TRUE if there are compressed image formats supported.)#" 
          )
        .def("IsSupported",
             (bool (Image_SupportedFormats::*)( Image_CompressedFormat  ) const) static_cast<bool (Image_SupportedFormats::*)( Image_CompressedFormat  ) const>(&Image_SupportedFormats::IsSupported),
             R"#(Return TRUE if compressed image format is supported.)#"  , py::arg("theFormat")
          )
        .def("Add",
             (void (Image_SupportedFormats::*)( Image_CompressedFormat  ) ) static_cast<void (Image_SupportedFormats::*)( Image_CompressedFormat  ) >(&Image_SupportedFormats::Add),
             R"#(Set if compressed image format is supported or not.)#"  , py::arg("theFormat")
          )
        .def("Clear",
             (void (Image_SupportedFormats::*)() ) static_cast<void (Image_SupportedFormats::*)() >(&Image_SupportedFormats::Clear),
             R"#(Reset flags.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_SupportedFormats::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_SupportedFormats::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_SupportedFormats::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_SupportedFormats::*)() const>(&Image_SupportedFormats::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Image_Texture from ./opencascade/Image_Texture.hxx
    klass = m.attr("Image_Texture");


    // nested enums

    static_cast<py::class_<Image_Texture ,opencascade::handle<Image_Texture>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString & >()  , py::arg("theFileName") )
        .def(py::init< const TCollection_AsciiString &,int64_t,int64_t >()  , py::arg("theFileName"),  py::arg("theOffset"),  py::arg("theLength") )
        .def(py::init< const opencascade::handle<NCollection_Buffer> &,const TCollection_AsciiString & >()  , py::arg("theBuffer"),  py::arg("theId") )
    // custom constructors
    // methods
        .def("FileOffset",
             (int64_t (Image_Texture::*)() const) static_cast<int64_t (Image_Texture::*)() const>(&Image_Texture::FileOffset),
             R"#(Return offset within file.)#" 
          )
        .def("FileLength",
             (int64_t (Image_Texture::*)() const) static_cast<int64_t (Image_Texture::*)() const>(&Image_Texture::FileLength),
             R"#(Return length of image data within the file after offset.)#" 
          )
        .def("MimeType",
             (TCollection_AsciiString (Image_Texture::*)() const) static_cast<TCollection_AsciiString (Image_Texture::*)() const>(&Image_Texture::MimeType),
             R"#(Return mime-type of image file based on ProbeImageFileFormat().)#" 
          )
        .def("ProbeImageFileFormat",
             (TCollection_AsciiString (Image_Texture::*)() const) static_cast<TCollection_AsciiString (Image_Texture::*)() const>(&Image_Texture::ProbeImageFileFormat),
             R"#(Return image file format.)#" 
          )
        .def("ReadCompressedImage",
             (opencascade::handle<Image_CompressedPixMap> (Image_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) const) static_cast<opencascade::handle<Image_CompressedPixMap> (Image_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) const>(&Image_Texture::ReadCompressedImage),
             R"#(Image reader without decoding data for formats supported natively by GPUs.)#"  , py::arg("theSupported")
          )
        .def("ReadImage",
             (opencascade::handle<Image_PixMap> (Image_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) const) static_cast<opencascade::handle<Image_PixMap> (Image_Texture::*)( const opencascade::handle<Image_SupportedFormats> &  ) const>(&Image_Texture::ReadImage),
             R"#(Image reader.)#"  , py::arg("theSupported")
          )
        .def("WriteImage",
             (Standard_Boolean (Image_Texture::*)( const TCollection_AsciiString &  ) ) static_cast<Standard_Boolean (Image_Texture::*)( const TCollection_AsciiString &  ) >(&Image_Texture::WriteImage),
             R"#(Write image to specified file without decoding data.)#"  , py::arg("theFile")
          )
        .def("WriteImage",
             (Standard_Boolean (Image_Texture::*)( basic_ostream<char> & ,  const TCollection_AsciiString &  ) ) static_cast<Standard_Boolean (Image_Texture::*)( basic_ostream<char> & ,  const TCollection_AsciiString &  ) >(&Image_Texture::WriteImage),
             R"#(Write image to specified stream without decoding data.)#"  , py::arg("theStream"),  py::arg("theFile")
          )
        .def("DumpJson",
             (void (Image_Texture::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Image_Texture::*)( std::ostream & ,  Standard_Integer  ) const>(&Image_Texture::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_Texture::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_Texture::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_Texture::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_Texture::*)() const>(&Image_Texture::DynamicType),
             R"#(None)#"
             
         )
       .def("TextureId",
             (const TCollection_AsciiString & (Image_Texture::*)() const) static_cast<const TCollection_AsciiString & (Image_Texture::*)() const>(&Image_Texture::TextureId),
             R"#(Return generated texture id.)#"
             
         )
       .def("FilePath",
             (const TCollection_AsciiString & (Image_Texture::*)() const) static_cast<const TCollection_AsciiString & (Image_Texture::*)() const>(&Image_Texture::FilePath),
             R"#(Return image file path.)#"
             
         )
       .def("DataBuffer",
             (const opencascade::handle<NCollection_Buffer> & (Image_Texture::*)() const) static_cast<const opencascade::handle<NCollection_Buffer> & (Image_Texture::*)() const>(&Image_Texture::DataBuffer),
             R"#(Return buffer holding encoded image content.)#"
             
         )
;

    // Class Image_VideoParams from ./opencascade/Image_VideoRecorder.hxx
    klass = m.attr("Image_VideoParams");


    // nested enums

    static_cast<py::class_<Image_VideoParams , shared_ptr<Image_VideoParams>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetFramerate",
             (void (Image_VideoParams::*)( const Standard_Integer ,  const Standard_Integer  ) ) static_cast<void (Image_VideoParams::*)( const Standard_Integer ,  const Standard_Integer  ) >(&Image_VideoParams::SetFramerate),
             R"#(Setup playback FPS.)#"  , py::arg("theNumerator"),  py::arg("theDenominator")
          )
        .def("SetFramerate",
             (void (Image_VideoParams::*)( const Standard_Integer  ) ) static_cast<void (Image_VideoParams::*)( const Standard_Integer  ) >(&Image_VideoParams::SetFramerate),
             R"#(Setup playback FPS. For fixed-fps content, timebase should be 1/framerate and timestamp increments should be identical to 1.)#"  , py::arg("theValue")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
        .def_readwrite("Format", &Image_VideoParams::Format)
        .def_readwrite("VideoCodec", &Image_VideoParams::VideoCodec)
        .def_readwrite("PixelFormat", &Image_VideoParams::PixelFormat)
        .def_readwrite("Width", &Image_VideoParams::Width)
        .def_readwrite("Height", &Image_VideoParams::Height)
        .def_readwrite("FpsNum", &Image_VideoParams::FpsNum)
        .def_readwrite("FpsDen", &Image_VideoParams::FpsDen)
        .def_readwrite("VideoCodecParams", &Image_VideoParams::VideoCodecParams)
    // methods returning by ref wrapped as properties
;

    // Class Image_VideoRecorder from ./opencascade/Image_VideoRecorder.hxx
    klass = m.attr("Image_VideoRecorder");


    // nested enums

    static_cast<py::class_<Image_VideoRecorder ,opencascade::handle<Image_VideoRecorder>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Close",
             (void (Image_VideoRecorder::*)() ) static_cast<void (Image_VideoRecorder::*)() >(&Image_VideoRecorder::Close),
             R"#(Close the stream - stop recorder.)#" 
          )
        .def("Open",
             (Standard_Boolean (Image_VideoRecorder::*)( const char * ,  const Image_VideoParams &  ) ) static_cast<Standard_Boolean (Image_VideoRecorder::*)( const char * ,  const Image_VideoParams &  ) >(&Image_VideoRecorder::Open),
             R"#(Open output stream - initialize recorder.)#"  , py::arg("theFileName"),  py::arg("theParams")
          )
        .def("FrameCount",
             (int64_t (Image_VideoRecorder::*)() const) static_cast<int64_t (Image_VideoRecorder::*)() const>(&Image_VideoRecorder::FrameCount),
             R"#(Return current frame index.)#" 
          )
        .def("PushFrame",
             (Standard_Boolean (Image_VideoRecorder::*)() ) static_cast<Standard_Boolean (Image_VideoRecorder::*)() >(&Image_VideoRecorder::PushFrame),
             R"#(Push new frame, should be called after Open().)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_VideoRecorder::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_VideoRecorder::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_VideoRecorder::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_VideoRecorder::*)() const>(&Image_VideoRecorder::DynamicType),
             R"#(None)#"
             
         )
       .def("ChangeFrame",
             (Image_PixMap & (Image_VideoRecorder::*)() ) static_cast<Image_PixMap & (Image_VideoRecorder::*)() >(&Image_VideoRecorder::ChangeFrame),
             R"#(Access RGBA frame, should NOT be re-initialized outside. Note that image is expected to have upper-left origin.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Image_AlienPixMap from ./opencascade/Image_AlienPixMap.hxx
    klass = m.attr("Image_AlienPixMap");


    // nested enums

    static_cast<py::class_<Image_AlienPixMap ,opencascade::handle<Image_AlienPixMap>  , Image_PixMap >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Save",
             (bool (Image_AlienPixMap::*)( const TCollection_AsciiString &  ) ) static_cast<bool (Image_AlienPixMap::*)( const TCollection_AsciiString &  ) >(&Image_AlienPixMap::Save),
             R"#(Write image data to file.)#"  , py::arg("theFileName")
          )
        .def("Save",
             (bool (Image_AlienPixMap::*)( basic_ostream<char> & ,  const TCollection_AsciiString &  ) ) static_cast<bool (Image_AlienPixMap::*)( basic_ostream<char> & ,  const TCollection_AsciiString &  ) >(&Image_AlienPixMap::Save),
             R"#(Write image data to stream.)#"  , py::arg("theStream"),  py::arg("theExtension")
          )
        .def("Save",
             (bool (Image_AlienPixMap::*)( Standard_Byte * ,  const Standard_Size ,  const TCollection_AsciiString &  ) ) static_cast<bool (Image_AlienPixMap::*)( Standard_Byte * ,  const Standard_Size ,  const TCollection_AsciiString &  ) >(&Image_AlienPixMap::Save),
             R"#(Write image data to file or memory buffer using file extension to determine format.)#"  , py::arg("theBuffer"),  py::arg("theLength"),  py::arg("theFileName")
          )
        .def("InitTrash",
             (bool (Image_AlienPixMap::*)( Image_Format ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size  ) ) static_cast<bool (Image_AlienPixMap::*)( Image_Format ,  const Standard_Size ,  const Standard_Size ,  const Standard_Size  ) >(&Image_AlienPixMap::InitTrash),
             R"#(Initialize image plane with required dimensions.)#"  , py::arg("thePixelFormat"),  py::arg("theSizeX"),  py::arg("theSizeY"),  py::arg("theSizeRowBytes")=static_cast<const Standard_Size>(0)
          )
        .def("InitCopy",
             (bool (Image_AlienPixMap::*)( const Image_PixMap &  ) ) static_cast<bool (Image_AlienPixMap::*)( const Image_PixMap &  ) >(&Image_AlienPixMap::InitCopy),
             R"#(Initialize by copying data.)#"  , py::arg("theCopy")
          )
        .def("Clear",
             (void (Image_AlienPixMap::*)() ) static_cast<void (Image_AlienPixMap::*)() >(&Image_AlienPixMap::Clear),
             R"#(Method correctly deallocate internal buffer.)#" 
          )
        .def("AdjustGamma",
             (bool (Image_AlienPixMap::*)( const Standard_Real  ) ) static_cast<bool (Image_AlienPixMap::*)( const Standard_Real  ) >(&Image_AlienPixMap::AdjustGamma),
             R"#(Performs gamma correction on image.)#"  , py::arg("theGammaCorr")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Image_AlienPixMap::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Image_AlienPixMap::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("IsTopDownDefault_s",
                    (bool (*)() ) static_cast<bool (*)() >(&Image_AlienPixMap::IsTopDownDefault),
                    R"#(Return default rows order used by underlying image library.)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Image_AlienPixMap::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Image_AlienPixMap::*)() const>(&Image_AlienPixMap::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/Image_AlienPixMap.hxx
// ./opencascade/Image_Color.hxx
// ./opencascade/Image_CompressedFormat.hxx
// ./opencascade/Image_CompressedPixMap.hxx
// ./opencascade/Image_DDSParser.hxx
// ./opencascade/Image_Diff.hxx
// ./opencascade/Image_Format.hxx
// ./opencascade/Image_PixMap.hxx
// ./opencascade/Image_PixMapData.hxx
// ./opencascade/Image_PixMapTypedData.hxx
// ./opencascade/Image_SupportedFormats.hxx
// ./opencascade/Image_Texture.hxx
// ./opencascade/Image_VideoRecorder.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
