------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2011-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Calendar;          use Ada.Calendar;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.SQL;          use GNATCOLL.SQL;
with GNATCOLL.SQL.Exec;     use GNATCOLL.SQL.Exec;
with GNATCOLL.SQL.Inspect;  use GNATCOLL.SQL.Inspect;
with GNATCOLL.SQL.Postgres; use GNATCOLL.SQL.Postgres;
with GNATCOLL.Traces;       use GNATCOLL.Traces;
with GNATCOLL.VFS;          use GNATCOLL.VFS;

--  Load the auto-generated file that describes the database
with Dbschema;              use Dbschema;

--  This test does not actually execute queries on a postgreSQL server,
--  since that requires a more complex setup that nightly runs might not
--  have.

procedure PreparedPsql is
   Me : constant Trace_Handle := Create ("MAIN");

   Descr    : Database_Description;
   DB1      : Database_Connection;

   Q : constant SQL_Query := SQL_Select
      (Fields => Data.Id,
       From   => Data,
       Where  => Data.Value = Integer_Param (1)
         and Data.Name = Text_Param (2) and Data.Amount = Money_Param (3));

   P2 : constant Prepared_Statement := Prepare (Q, On_Server => True);

   procedure Do_Test is
      D  : Direct_Cursor;
      N  : aliased String := "name";
   begin
      --  Check that we do not insert extra quotes around parameters
      D.Fetch (DB1, P2, Params => (1 => +2, 2 => +N'Access));
   end Do_Test;

begin
   --  If you want to see what SQL commands are executed, create a file
   --  called ".gnatdebug" in the current directory, that contains a
   --  single "+" (see documentation for GNATCOLL.Traces)

   GNATCOLL.Traces.Parse_Config_File;

   --  Connect to the database.
   --  We will not execute queries on this database, since this requires
   --  a complex setup.

   Descr := GNATCOLL.SQL.Postgres.Setup (Database => "test");
   DB1 := Descr.Build_Connection;

   Do_Test;

   --  Free memory

   Free (Descr);
   Free (DB1);
   GNATCOLL.Traces.Finalize;
end PreparedPsql;
