with GNAT.Strings;
with GNATCOLL.Projects;          use GNATCOLL.Projects;
with GNATCOLL.VFS;               use GNATCOLL.VFS;
with GNATCOLL.Traces;            use GNATCOLL.Traces;
with GNATCOLL.VFS_Utils;         use GNATCOLL.VFS_Utils;

with Ada.Containers.Indefinite_Ordered_Sets;
with Ada.Containers.Indefinite_Vectors;

with Ada.Text_IO;

with GNAT.OS_Lib;             use GNAT.OS_Lib;
with Ada.Characters.Handling; use Ada.Characters.Handling;

procedure Main is
   Env                 : Project_Environment_Access;
   Source_Project_Tree : GNATCOLL.Projects.Project_Tree;

   P : Project_Type;

   Str : String_Access;

begin
   Free (Str);
   Initialize (Env);
   Env.Register_Default_Language_Extension ("C", ".h", ".c");
   Source_Project_Tree.Load
     (GNATCOLL.VFS.Create (+"p.gpr"),
      Env,
      Recompute_View => False);

   Source_Project_Tree.Recompute_View;

   if Source_Project_Tree.Root_Project = No_Project then
      Ada.Text_IO.Put_Line ("project not loaded");
      return;
   end if;

   P := Source_Project_Tree.Root_Project;

   Str := new String'(Register_New_Attribute
                      (Name => "image_dir",
                       Pkg  => "documentation"));
   if Str.all /= "" then
      Ada.Text_IO.Put_Line (Str.all);
   end if;

   Source_Project_Tree.Unload;
   Free (Env);
end Main;
