/*
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License, version 2.1 as published by the Free Software
 * Foundation.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, you can obtain a copy at http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html
 * or from the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * Copyright (c) 2006 - 2009 Pentaho Corporation and Contributors.  All rights reserved.
 */

package org.pentaho.reporting.libraries.formula.parser;

/**
 * Although this class was autogenerated, we modified it to provide better
 * error reporting. Do not delete this file or let the auto-generator replace it,
 * or you will suffer compile errors later.
 */
public class TokenMgrError extends Error
{
  /*
  * Ordinals for various reasons why an Error of this type can be thrown.
  */

  /**
   * Lexical error occured.
   */
  public static final int LEXICAL_ERROR = 0;

  /**
   * An attempt wass made to create a second instance of a static token manager.
   */
  public static final int STATIC_LEXER_ERROR = 1;

  /**
   * Tried to change to an invalid lexical state.
   */
  public static final int INVALID_LEXICAL_STATE = 2;

  /**
   * Detected (and bailed out of) an infinite loop in the token manager.
   */
  public static final int LOOP_DETECTED = 3;

  private static final long serialVersionUID = -4952285962531386774L;

  /**
   * Indicates the reason why the exception is thrown. It will have one of the above 4 values.
   */
  private int errorCode;
  private boolean EOFSeen;
  private int lexState;
  private int errorLine;
  private int errorColumn;
  private String errorAfter;
  private char curChar;
  private int reason;

  /**
   * Replaces unprintable characters by their espaced (or unicode escaped) equivalents in the given string
   */
  protected static String addEscapes(final String str)
  {
    final StringBuffer retval = new StringBuffer();
    for (int i = 0; i < str.length(); i++)
    {
      final char ch;
      switch (str.charAt(i))
      {
        case 0:
          continue;
        case '\b':
          retval.append("\\b");
          continue;
        case '\t':
          retval.append("\\t");
          continue;
        case '\n':
          retval.append("\\n");
          continue;
        case '\f':
          retval.append("\\f");
          continue;
        case '\r':
          retval.append("\\r");
          continue;
        case '\"':
          retval.append("\\\"");
          continue;
        case '\'':
          retval.append("\\\'");
          continue;
        case '\\':
          retval.append("\\\\");
          continue;
        default:
          if ((ch = str.charAt(i)) < 0x20 || ch > 0x7e)
          {
            final String s = "0000" + Integer.toString(ch, 16);
            retval.append("\\u" + s.substring(s.length() - 4, s.length()));
          }
          else
          {
            retval.append(ch);
          }
          continue;
      }
    }
    return retval.toString();
  }

  /**
   * Returns a detailed message for the Error when it is thrown by the token manager to indicate a lexical error.
   * Parameters : EOFSeen     : indicates if EOF caused the lexicl error curLexState : lexical state in which this
   * error occured errorLine   : line number when the error occured errorColumn : column number when the error occured
   * errorAfter  : prefix that was seen before this error occured curchar     : the offending character Note: You can
   * customize the lexical error message by modifying this method.
   */
  protected static String LexicalError(final boolean EOFSeen, final int lexState, final int errorLine, final int errorColumn, final String errorAfter, final char curChar)
  {
    return ("Lexical error at line " +
        errorLine + ", column " +
        errorColumn + ".  Encountered: " +
        (EOFSeen ? "<EOF> " : ('\"' + addEscapes(String.valueOf(curChar)) + '\"') + " (" + (int) curChar + "), ") +
        "after : \"" + addEscapes(errorAfter) + '\"');
  }

  /**
   * You can also modify the body of this method to customize your error messages. For example, cases like
   * LOOP_DETECTED and INVALID_LEXICAL_STATE are not of end-users concern, so you can return something like :
   * <p/>
   * "Internal Error : Please file a bug report .... "
   * <p/>
   * from this method for such cases in the release version of your parser.
   */
  public String getMessage()
  {
    return super.getMessage();
  }

  /*
  * Constructors of various flavors follow.
  */

  public TokenMgrError()
  {
  }

  public TokenMgrError(final String message, final int reason)
  {
    super(message);
    errorCode = reason;
  }

  public TokenMgrError(final boolean EOFSeen, final int lexState, final int errorLine, final int errorColumn, final String errorAfter, final char curChar, final int reason)
  {
    this(LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
    this.EOFSeen = EOFSeen;
    this.lexState = lexState;
    this.errorLine = errorLine;
    this.errorColumn = errorColumn;
    this.errorAfter = errorAfter;
    this.curChar = curChar;
    this.reason = reason;
  }

  public int getErrorCode()
  {
    return errorCode;
  }

  public boolean isEOFSeen()
  {
    return EOFSeen;
  }

  public int getLexState()
  {
    return lexState;
  }

  public int getErrorLine()
  {
    return errorLine;
  }

  public int getErrorColumn()
  {
    return errorColumn;
  }

  public String getErrorAfter()
  {
    return errorAfter;
  }

  public char getCurChar()
  {
    return curChar;
  }

  public int getReason()
  {
    return reason;
  }
}
