/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;
import org.chromium.devtools.jsdoc.checks.TypeRecord;

public final class ProtoFollowsExtendsChecker
extends ContextTrackingChecker {
    private static final String PROTO_PROPERTY_NAME = "__proto__";
    private static final Set<String> IGNORED_SUPER_TYPES = new HashSet<String>();
    private final Set<TypeRecord> typesWithAssignedProto = new HashSet<TypeRecord>();
    private final Set<FunctionRecord> functionsMissingSuperCall = new HashSet<FunctionRecord>();

    @Override
    protected void enterNode(Node node) {
        switch (node.getType()) {
            case 86: 
            case 118: {
                this.handleAssignment(node);
                break;
            }
            case 154: {
                this.handleColonNode(node);
                break;
            }
            case 105: {
                this.enterFunction();
                break;
            }
            case 37: {
                this.handleCall(node);
                break;
            }
        }
    }

    private void handleCall(Node node) {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (functionRecord == null || !functionRecord.isConstructor() || !this.functionsMissingSuperCall.contains(functionRecord)) {
            return;
        }
        String string = this.validSuperConstructorName(node);
        if (string == null) {
            return;
        }
        TypeRecord typeRecord = this.getState().typeRecordsByTypeName.get(functionRecord.name);
        if (typeRecord == null) {
            return;
        }
        JSTypeExpression jSTypeExpression = typeRecord.getExtendedType();
        if (jSTypeExpression == null || !string.equals(AstUtil.getAnnotationTypeString(jSTypeExpression))) {
            return;
        }
        this.functionsMissingSuperCall.remove(functionRecord);
    }

    private String validSuperConstructorName(Node node) {
        String string = this.getContext().getNodeText(node.getFirstChild());
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        if (!"call".equals(string2) && !"apply".equals(string2)) {
            return null;
        }
        List<Node> list = AstUtil.getArguments(node);
        if (list.isEmpty() || !"this".equals(this.getContext().getNodeText(list.get(0)))) {
            return null;
        }
        return string.substring(0, n);
    }

    @Override
    protected void leaveNode(Node node) {
        if (node.getType() == 132) {
            this.checkFinished();
            return;
        }
        if (node.getType() == 105) {
            this.leaveFunction();
            return;
        }
    }

    private void enterFunction() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        JSTypeExpression jSTypeExpression = this.getExtendedTypeToCheck(functionRecord);
        if (jSTypeExpression == null) {
            return;
        }
        if (!IGNORED_SUPER_TYPES.contains(AstUtil.getAnnotationTypeString(jSTypeExpression))) {
            this.functionsMissingSuperCall.add(functionRecord);
        }
    }

    private void leaveFunction() {
        FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
        if (!this.functionsMissingSuperCall.contains(functionRecord)) {
            return;
        }
        JSTypeExpression jSTypeExpression = this.getExtendedTypeToCheck(functionRecord);
        if (jSTypeExpression == null) {
            return;
        }
        String string = AstUtil.getAnnotationTypeString(jSTypeExpression);
        if (string.startsWith("HTML")) {
            return;
        }
        this.reportErrorAtNodeStart(AstUtil.getFunctionNameNode(functionRecord.functionNode), String.format("Type %s extends %s but does not properly invoke its constructor", functionRecord.name, string));
    }

    private JSTypeExpression getExtendedTypeToCheck(FunctionRecord functionRecord) {
        if (!functionRecord.isConstructor() || functionRecord.name == null) {
            return null;
        }
        TypeRecord typeRecord = this.getState().typeRecordsByTypeName.get(functionRecord.name);
        if (typeRecord == null || typeRecord.isInterface()) {
            return null;
        }
        return typeRecord.getExtendedType();
    }

    private void checkFinished() {
        for (TypeRecord typeRecord : this.getState().getTypeRecordsByTypeName().values()) {
            JSTypeExpression jSTypeExpression;
            if (typeRecord.isInterface() || this.typesWithAssignedProto.contains(typeRecord) || (jSTypeExpression = typeRecord.getExtendedType()) == null) continue;
            Node node = jSTypeExpression.getRoot();
            if (node.getType() == 306 && node.getFirstChild() != null) {
                node = node.getFirstChild();
            }
            this.getContext().reportErrorAtOffset(node.getSourceOffset(), String.format("No __proto__ assigned for type %s having @extends", typeRecord.typeName));
        }
    }

    private void handleColonNode(Node node) {
        String string;
        ContextTrackingState contextTrackingState = this.getState();
        TypeRecord typeRecord = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord == null) {
            return;
        }
        String string2 = node.getString();
        if (!PROTO_PROPERTY_NAME.equals(string2)) {
            return;
        }
        TypeRecord typeRecord2 = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord2 == null) {
            return;
        }
        this.typesWithAssignedProto.add(typeRecord2);
        Node node2 = node.getFirstChild();
        String string3 = contextTrackingState.getNodeText(node2);
        boolean bl = "null".equals(string3);
        if (!bl && !AstUtil.isPrototypeName(string3)) {
            this.reportErrorAtNodeStart(node2, "__proto__ value is not a prototype");
            return;
        }
        String string4 = string = bl ? "null" : AstUtil.getTypeNameFromPrototype(string3);
        if (typeRecord.isInterface()) {
            this.reportErrorAtNodeStart(node, String.format("__proto__ defined for interface %s", typeRecord.typeName));
            return;
        }
        if (!bl && typeRecord.getExtendedType() == null) {
            this.reportErrorAtNodeStart(node2, String.format("No @extends annotation for %s extending %s", typeRecord.typeName, string));
            return;
        }
        if (bl) {
            return;
        }
        JSTypeExpression jSTypeExpression = typeRecord.getExtendedType();
        String string5 = AstUtil.getAnnotationTypeString(jSTypeExpression);
        if (!string.equals(string5)) {
            this.reportErrorAtNodeStart(node2, String.format("Supertype does not match %s declared in @extends for %s (line %d)", string5, typeRecord.typeName, contextTrackingState.getContext().getPosition((int)jSTypeExpression.getRoot().getSourceOffset()).line));
        }
    }

    private void handleAssignment(Node node) {
        String string = this.getState().getNodeText(AstUtil.getAssignedTypeNameNode(node));
        if (string == null) {
            return;
        }
        if (!AstUtil.isPrototypeName(string)) {
            return;
        }
        Node node2 = node.getLastChild();
        if (node2.getType() == 64) {
            return;
        }
        ContextTrackingState contextTrackingState = this.getState();
        TypeRecord typeRecord = contextTrackingState.getCurrentTypeRecord();
        if (typeRecord == null) {
            return;
        }
        if (typeRecord.getExtendedType() != null) {
            this.reportErrorAtNodeStart(node2, String.format("@extends found for type %s but its prototype is not an object containing __proto__", AstUtil.getTypeNameFromPrototype(string)));
        }
    }

    static {
        IGNORED_SUPER_TYPES.add("WebInspector.Object");
    }
}

