

  Polymer({

    is: 'hero-animation',

    behaviors: [
      Polymer.NeonSharedElementAnimationBehavior
    ],

    configure: function(config) {
      var shared = this.findSharedElements(config);
      if (!shared) {
        return null;
      }

      var fromRect = shared.from.getBoundingClientRect();
      var toRect = shared.to.getBoundingClientRect();

      var deltaLeft = fromRect.left - toRect.left;
      var deltaTop = fromRect.top - toRect.top;
      var deltaWidth = fromRect.width / toRect.width;
      var deltaHeight = fromRect.height / toRect.height;

      this.setPrefixedProperty(shared.to, 'transformOrigin', '0 0');
      shared.to.style.zIndex = 10000;
      shared.from.style.visibility = 'hidden';

      this._effect = new KeyframeEffect(shared.to, [
        {'transform': 'translate(' + deltaLeft + 'px,' + deltaTop + 'px) scale(' + deltaWidth + ',' + deltaHeight + ')'},
        {'transform': 'none'}
      ], this.timingFromConfig(config));

      return this._effect;
    },

    complete: function(config) {
      var shared = this.findSharedElements(config);
      if (!shared) {
        return null;
      }
      shared.to.style.zIndex = '';
      shared.from.style.visibility = '';
    }

  });

