/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class LocalizedMessage
implements Comparable<LocalizedMessage>,
Serializable {
    private static final long serialVersionUID = 5675176836184862150L;
    private static final int HASH_MULT = 29;
    private static Locale sLocale = Locale.getDefault();
    private static final Map<String, ResourceBundle> BUNDLE_CACHE = Collections.synchronizedMap(new HashMap());
    private final int lineNo;
    private final int colNo;
    private final SeverityLevel severityLevel;
    private final String moduleId;
    private static final SeverityLevel DEFAULT_SEVERITY = SeverityLevel.ERROR;
    private final String key;
    private final Object[] args;
    private final String bundle;
    private final Class<?> sourceClass;
    private final String customMessage;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocalizedMessage)) {
            return false;
        }
        LocalizedMessage localizedMessage = (LocalizedMessage)object;
        if (this.colNo != localizedMessage.colNo) {
            return false;
        }
        if (this.lineNo != localizedMessage.lineNo) {
            return false;
        }
        if (!this.key.equals(localizedMessage.key)) {
            return false;
        }
        return Arrays.equals(this.args, localizedMessage.args);
    }

    public int hashCode() {
        int result = this.lineNo;
        result = 29 * result + this.colNo;
        result = 29 * result + this.key.hashCode();
        for (Object element : this.args) {
            result = 29 * result + element.hashCode();
        }
        return result;
    }

    public LocalizedMessage(int lineNo, int colNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this.lineNo = lineNo;
        this.colNo = colNo;
        this.key = key;
        this.args = null == args ? null : (Object[])args.clone();
        this.bundle = bundle;
        this.severityLevel = severityLevel;
        this.moduleId = moduleId;
        this.sourceClass = sourceClass;
        this.customMessage = customMessage;
    }

    public LocalizedMessage(int lineNo, int colNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, colNo, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, 0, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, 0, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, ResourceBundle> map = BUNDLE_CACHE;
        synchronized (map) {
            BUNDLE_CACHE.clear();
        }
    }

    public String getMessage() {
        String customMessage = this.getCustomMessage();
        if (customMessage != null) {
            return customMessage;
        }
        try {
            ResourceBundle bundle = this.getBundle(this.bundle);
            String pattern = bundle.getString(this.key);
            return MessageFormat.format(pattern, this.args);
        }
        catch (MissingResourceException ex) {
            return MessageFormat.format(this.key, this.args);
        }
    }

    private String getCustomMessage() {
        if (this.customMessage == null) {
            return null;
        }
        return MessageFormat.format(this.customMessage, this.args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle(String bundleName) {
        Map<String, ResourceBundle> map = BUNDLE_CACHE;
        synchronized (map) {
            ResourceBundle bundle = BUNDLE_CACHE.get(bundleName);
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(bundleName, sLocale, this.sourceClass.getClassLoader(), new UTF8Control());
                BUNDLE_CACHE.put(bundleName, bundle);
            }
            return bundle;
        }
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.colNo;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getKey() {
        return this.key;
    }

    public String getSourceName() {
        return this.sourceClass.getName();
    }

    public static void setLocale(Locale locale) {
        sLocale = locale;
    }

    @Override
    public int compareTo(LocalizedMessage other) {
        if (this.getLineNo() == other.getLineNo()) {
            if (this.getColumnNo() == other.getColumnNo()) {
                return this.getMessage().compareTo(other.getMessage());
            }
            return this.getColumnNo() < other.getColumnNo() ? -1 : 1;
        }
        return this.getLineNo() < other.getLineNo() ? -1 : 1;
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String aBaseName, Locale aLocale, String aFormat, ClassLoader aLoader, boolean aReload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(aBaseName, aLocale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (aReload) {
                URLConnection connection;
                URL url = aLoader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = aLoader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try (InputStreamReader streamReader = new InputStreamReader(stream, "UTF-8");){
                    bundle = new PropertyResourceBundle(streamReader);
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

