// Copyright 2014 The Crashpad Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef CRASHPAD_COMPAT_WIN_SYS_TYPES_H_
#define CRASHPAD_COMPAT_WIN_SYS_TYPES_H_

// This is intended to be roughly equivalent to #include_next.
#include <../include/sys/types.h>

#include <stdint.h>

#ifdef _WIN64
typedef int64_t ssize_t;
#else
typedef __w64 int ssize_t;
#endif

typedef unsigned int pid_t;

#endif  // CRASHPAD_COMPAT_WIN_SYS_TYPES_H_
