/* Copyright (c) 2015, Google Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. */

 /* This file was generated by err_data_generate.go. */

#include <openssl/base.h>
#include <openssl/err.h>
#include <openssl/type_check.h>


OPENSSL_COMPILE_ASSERT(ERR_LIB_NONE == 1, library_values_changed_1);
OPENSSL_COMPILE_ASSERT(ERR_LIB_SYS == 2, library_values_changed_2);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BN == 3, library_values_changed_3);
OPENSSL_COMPILE_ASSERT(ERR_LIB_RSA == 4, library_values_changed_4);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DH == 5, library_values_changed_5);
OPENSSL_COMPILE_ASSERT(ERR_LIB_EVP == 6, library_values_changed_6);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BUF == 7, library_values_changed_7);
OPENSSL_COMPILE_ASSERT(ERR_LIB_OBJ == 8, library_values_changed_8);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PEM == 9, library_values_changed_9);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DSA == 10, library_values_changed_10);
OPENSSL_COMPILE_ASSERT(ERR_LIB_X509 == 11, library_values_changed_11);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ASN1 == 12, library_values_changed_12);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CONF == 13, library_values_changed_13);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CRYPTO == 14, library_values_changed_14);
OPENSSL_COMPILE_ASSERT(ERR_LIB_EC == 15, library_values_changed_15);
OPENSSL_COMPILE_ASSERT(ERR_LIB_SSL == 16, library_values_changed_16);
OPENSSL_COMPILE_ASSERT(ERR_LIB_BIO == 17, library_values_changed_17);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PKCS7 == 18, library_values_changed_18);
OPENSSL_COMPILE_ASSERT(ERR_LIB_PKCS8 == 19, library_values_changed_19);
OPENSSL_COMPILE_ASSERT(ERR_LIB_X509V3 == 20, library_values_changed_20);
OPENSSL_COMPILE_ASSERT(ERR_LIB_RAND == 21, library_values_changed_21);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ENGINE == 22, library_values_changed_22);
OPENSSL_COMPILE_ASSERT(ERR_LIB_OCSP == 23, library_values_changed_23);
OPENSSL_COMPILE_ASSERT(ERR_LIB_UI == 24, library_values_changed_24);
OPENSSL_COMPILE_ASSERT(ERR_LIB_COMP == 25, library_values_changed_25);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ECDSA == 26, library_values_changed_26);
OPENSSL_COMPILE_ASSERT(ERR_LIB_ECDH == 27, library_values_changed_27);
OPENSSL_COMPILE_ASSERT(ERR_LIB_HMAC == 28, library_values_changed_28);
OPENSSL_COMPILE_ASSERT(ERR_LIB_DIGEST == 29, library_values_changed_29);
OPENSSL_COMPILE_ASSERT(ERR_LIB_CIPHER == 30, library_values_changed_30);
OPENSSL_COMPILE_ASSERT(ERR_LIB_USER == 31, library_values_changed_31);
OPENSSL_COMPILE_ASSERT(ERR_LIB_HKDF == 32, library_values_changed_32);
OPENSSL_COMPILE_ASSERT(ERR_NUM_LIBS == 33, library_values_changed_num);

const uint32_t kOpenSSLFunctionValues[] = {
    0xc32054b,
    0xc328556,
    0xc330561,
    0xc33856e,
    0xc340578,
    0xc348582,
    0xc350589,
    0xc358595,
    0xc36059c,
    0xc3685b2,
    0xc3705d1,
    0xc3785e2,
    0xc3805f2,
    0xc38860c,
    0xc390621,
    0xc398630,
    0xc3a0649,
    0xc3a865d,
    0xc3b0669,
    0xc3b8670,
    0xc3c0678,
    0xc3c8690,
    0xc3d0698,
    0xc3d86a0,
    0xc3e06ab,
    0xc3e85c7,
    0xc3f0686,
    0x1032193d,
    0x10329954,
    0x1033196d,
    0x10339983,
    0x10341993,
    0x103499bb,
    0x103519c9,
    0x103599d8,
    0x103619f8,
    0x10369a17,
    0x10371a34,
    0x10379a51,
    0x10381a66,
    0x10389a88,
    0x10391aa7,
    0x10399ac6,
    0x103a1add,
    0x103a9af4,
    0x103b1afd,
    0x103b9b08,
    0x103c1b22,
    0x103c9b2a,
    0x103d1b32,
    0x103d99a6,
    0x103e1b4b,
    0x103e9b5d,
    0x103f1b70,
    0x103f9b79,
    0x10401b39,
    0x14320a4e,
    0x14328a5c,
    0x14330a68,
    0x14338a75,
    0x18361224,
    0x18371252,
    0x18379263,
    0x18381279,
    0x1839129c,
    0x183992b1,
    0x183a12c3,
    0x183c1307,
    0x183c9315,
    0x183d1328,
    0x183d9338,
    0x183e935e,
    0x183f1371,
    0x183f9380,
    0x184093aa,
    0x18411416,
    0x18419427,
    0x1842143a,
    0x1842944c,
    0x1843145e,
    0x1843946f,
    0x18441480,
    0x18449491,
    0x184514a2,
    0x184594af,
    0x184614d1,
    0x184694e4,
    0x184714f8,
    0x18479505,
    0x18481514,
    0x18489523,
    0x18491534,
    0x18499550,
    0x184a155e,
    0x184a956f,
    0x184b1580,
    0x184b958e,
    0x184c159e,
    0x184c95c4,
    0x184d15d3,
    0x184d95e3,
    0x184e15f3,
    0x184e9602,
    0x184f1541,
    0x184f91b3,
    0x18501156,
    0x1850916e,
    0x18511190,
    0x185191a2,
    0x185211d4,
    0x185291ed,
    0x185311fe,
    0x18539214,
    0x18541239,
    0x1854928a,
    0x185512d3,
    0x185592e8,
    0x185612f5,
    0x1856934d,
    0x18571390,
    0x1857939d,
    0x185813b9,
    0x185893ca,
    0x185913da,
    0x185993ea,
    0x185a13f9,
    0x185a9408,
    0x185b14bd,
    0x1c3206b8,
    0x1c3286c4,
    0x1c3306cf,
    0x1c3386db,
    0x20321616,
    0x20329621,
    0x20331629,
    0x20339635,
    0x24321641,
    0x2432964f,
    0x24331661,
    0x24339670,
    0x24341683,
    0x24349696,
    0x243516ad,
    0x243596c5,
    0x243616d3,
    0x243696eb,
    0x243716f4,
    0x24379706,
    0x2438171a,
    0x24389727,
    0x2439173d,
    0x24399755,
    0x243a176d,
    0x243a9777,
    0x243b178c,
    0x243b979a,
    0x243c17b2,
    0x243c97c9,
    0x243d17d4,
    0x243d97e2,
    0x28320aae,
    0x28328abd,
    0x28330ac8,
    0x28338acd,
    0x28340ad8,
    0x2c322b99,
    0x2c32aba5,
    0x2c332bb8,
    0x2c33abc9,
    0x2c342be2,
    0x2c34ac0a,
    0x2c352c21,
    0x2c35ac3e,
    0x2c362c5b,
    0x2c36ac78,
    0x2c372c91,
    0x2c37acaa,
    0x2c382cc0,
    0x2c38acce,
    0x2c392ce0,
    0x2c39acfd,
    0x2c3a2d1a,
    0x2c3aad28,
    0x2c3b2d46,
    0x2c3bad64,
    0x2c3c2d7f,
    0x2c3cad93,
    0x2c3d2da5,
    0x2c3dadb5,
    0x2c3e2dc3,
    0x2c3eadd3,
    0x2c3f2de3,
    0x2c3fae22,
    0x2c402e33,
    0x2c40ae4e,
    0x2c412e62,
    0x2c41ae75,
    0x2c422e94,
    0x2c42aea8,
    0x2c432ebb,
    0x2c43aeca,
    0x2c442ed9,
    0x2c44aef0,
    0x2c452f0b,
    0x2c45af23,
    0x2c462f37,
    0x2c46af4a,
    0x2c472f5b,
    0x2c47af6c,
    0x2c482f7d,
    0x2c48af8e,
    0x2c492f9d,
    0x2c49afaa,
    0x2c4a2fb7,
    0x2c4aafc4,
    0x2c4b2fcd,
    0x2c4bafe1,
    0x2c4c2ff0,
    0x2c4caffe,
    0x2c4d3020,
    0x2c4db031,
    0x2c4e3042,
    0x2c4eb00d,
    0x2c4f2bfb,
    0x2c4fadfe,
    0x2c502e10,
    0x30320000,
    0x30328018,
    0x3033002c,
    0x30338042,
    0x3034005b,
    0x3034806c,
    0x3035007f,
    0x3035808f,
    0x3036009d,
    0x303680b3,
    0x303700c3,
    0x303780d8,
    0x303800e6,
    0x303880f7,
    0x30390103,
    0x3039810c,
    0x303a011d,
    0x303a812d,
    0x303b013a,
    0x303b8146,
    0x303c0157,
    0x303c8165,
    0x303d0176,
    0x303d8188,
    0x303e0199,
    0x303e81a8,
    0x303f01b9,
    0x303f81cd,
    0x304001df,
    0x304081ec,
    0x30410202,
    0x30418215,
    0x30420225,
    0x30428239,
    0x3043024a,
    0x3043825a,
    0x30440265,
    0x3044826d,
    0x3045027d,
    0x30458294,
    0x304602a1,
    0x304682b7,
    0x304702c9,
    0x304782d5,
    0x304802e1,
    0x304882ef,
    0x30490308,
    0x30498316,
    0x304a032b,
    0x304a8343,
    0x304b034d,
    0x304b8361,
    0x304c0372,
    0x304c8382,
    0x304d038f,
    0x304d83a0,
    0x304e03b0,
    0x304e83c2,
    0x304f03d3,
    0x304f83e2,
    0x305003f6,
    0x30508404,
    0x30510413,
    0x3051841c,
    0x343209d6,
    0x343289e6,
    0x343309f1,
    0x343389fe,
    0x38320a07,
    0x38328a1f,
    0x38330a32,
    0x38338a3c,
    0x3c320aeb,
    0x3c328af9,
    0x3c330b10,
    0x3c338b24,
    0x3c340b56,
    0x3c348b67,
    0x3c350b73,
    0x3c358ba0,
    0x3c360bb2,
    0x3c368bdb,
    0x3c370be8,
    0x3c378bf5,
    0x3c380c03,
    0x3c388c10,
    0x3c390c1d,
    0x3c398c41,
    0x3c3a0c51,
    0x3c3a8c69,
    0x3c3b0c7e,
    0x3c3b8c93,
    0x3c3c0ca0,
    0x3c3c8cb3,
    0x3c3d0cc6,
    0x3c3d8cea,
    0x3c3e0d12,
    0x3c3e8d2b,
    0x3c3f0d41,
    0x3c3f8d4e,
    0x3c400d61,
    0x3c408d72,
    0x3c410d83,
    0x3c418d9c,
    0x3c420db5,
    0x3c428dcb,
    0x3c430de8,
    0x3c438dfe,
    0x3c440e82,
    0x3c448ea9,
    0x3c450ec7,
    0x3c458ee1,
    0x3c460ef9,
    0x3c468f11,
    0x3c470f3c,
    0x3c478f67,
    0x3c480f88,
    0x3c488fb1,
    0x3c490fcc,
    0x3c498ff5,
    0x3c4a1002,
    0x3c4a9019,
    0x3c4b1030,
    0x3c4b9059,
    0x3c4c1069,
    0x3c4c9075,
    0x3c4d108d,
    0x3c4d90a0,
    0x3c4e10b1,
    0x3c4e90c2,
    0x3c4f10e8,
    0x3c4f8adf,
    0x3c500e1a,
    0x3c508e3a,
    0x3c510e67,
    0x3c518fe7,
    0x3c5210d2,
    0x3c528b87,
    0x3c530b3f,
    0x40321bb9,
    0x40329bf2,
    0x40331c1a,
    0x40339c32,
    0x40341c50,
    0x40349cb6,
    0x40351ccd,
    0x40359ce9,
    0x40361d05,
    0x40369d1f,
    0x40371d3e,
    0x40379d5d,
    0x40381d75,
    0x40389d92,
    0x40391db5,
    0x40399dd2,
    0x403a1e07,
    0x403a9e61,
    0x403b1e76,
    0x403b9e92,
    0x403c1eac,
    0x403c9eb7,
    0x403d1eda,
    0x403d9efe,
    0x403e1f14,
    0x403e9f1e,
    0x403f1f2a,
    0x403f9f3b,
    0x40401f53,
    0x40409f5b,
    0x40411f64,
    0x40419f6d,
    0x40421f95,
    0x40429fa9,
    0x40431fb4,
    0x40439fc0,
    0x40442014,
    0x4044a020,
    0x4045202d,
    0x4045a040,
    0x40462058,
    0x4046a070,
    0x40472086,
    0x4047a0a1,
    0x404820bc,
    0x4048a0d0,
    0x404920e9,
    0x4049a102,
    0x404a211c,
    0x404aa126,
    0x404b1e29,
    0x404b9e48,
    0x404c2136,
    0x404ca144,
    0x404d2151,
    0x404da165,
    0x404e217d,
    0x404ea18b,
    0x404f21b5,
    0x404fa1cc,
    0x405021de,
    0x4050a20f,
    0x40512240,
    0x4051a255,
    0x40522278,
    0x4052a298,
    0x405322ad,
    0x4053a2bd,
    0x4054a2c9,
    0x405522df,
    0x4055a31f,
    0x4056232c,
    0x4056a336,
    0x40572344,
    0x4057a35f,
    0x4058237a,
    0x4058a399,
    0x405923ae,
    0x4059a3c3,
    0x405a23e0,
    0x405aa3f4,
    0x405b2410,
    0x405ba426,
    0x405c2443,
    0x405ca455,
    0x405d246c,
    0x405da47d,
    0x405e2499,
    0x405ea4ad,
    0x405f24bd,
    0x405fa4d9,
    0x406024ee,
    0x4060a504,
    0x40612521,
    0x4061a53a,
    0x40622564,
    0x4062a56d,
    0x4063257d,
    0x4063a5b6,
    0x406425cc,
    0x4064a5ea,
    0x406525ff,
    0x4065a61c,
    0x40662633,
    0x4066a651,
    0x4067266e,
    0x4067a685,
    0x406826a3,
    0x4068a6ba,
    0x406926d2,
    0x4069a6e3,
    0x406a26f6,
    0x406aa709,
    0x406b271d,
    0x406ba741,
    0x406c275c,
    0x406ca77d,
    0x406d27a1,
    0x406da7bc,
    0x406e27dd,
    0x406ea7f2,
    0x406f280b,
    0x406fa818,
    0x40702826,
    0x4070a833,
    0x40712850,
    0x4071a870,
    0x4072288b,
    0x4072a8a4,
    0x407328bb,
    0x4073a8d5,
    0x407428f9,
    0x4074a90f,
    0x40752923,
    0x4075a938,
    0x40762952,
    0x4076a964,
    0x40772979,
    0x4077a99f,
    0x407829bc,
    0x4078a9df,
    0x40792a05,
    0x4079aa22,
    0x407a2a45,
    0x407aaa61,
    0x407b2a7d,
    0x407baa8f,
    0x407c2a9c,
    0x407e2aa9,
    0x407eaabf,
    0x407f2ad7,
    0x407faaea,
    0x40802aff,
    0x4080ab18,
    0x40812b36,
    0x4081ab56,
    0x40822b5f,
    0x4082ab7b,
    0x40832b84,
    0x4083a19a,
    0x40842229,
    0x4084a1f9,
    0x408525a5,
    0x4085a589,
    0x40861c8e,
    0x40869ca1,
    0x40871ff4,
    0x4087a003,
    0x40881bfe,
    0x40889f7d,
    0x40891fdb,
    0x4089a54d,
    0x408a1b84,
    0x408a9b95,
    0x408b1ba7,
    0x408ba266,
    0x408c1df0,
    0x408c9e17,
    0x408d22fd,
    0x408d9bd3,
    0x408e1c6f,
    0x4432042a,
    0x4432843c,
    0x44330445,
    0x4433844d,
    0x4434045a,
    0x44348475,
    0x44350490,
    0x443584b0,
    0x443604cc,
    0x443684ed,
    0x443704f4,
    0x44378502,
    0x4438050c,
    0x44388518,
    0x44390522,
    0x4439852d,
    0x443a0537,
    0x443a8541,
    0x443b046a,
    0x4c3217ea,
    0x4c3297f9,
    0x4c331808,
    0x4c339821,
    0x4c34183c,
    0x4c349858,
    0x4c35186a,
    0x4c359878,
    0x4c36188d,
    0x4c36989e,
    0x4c3718ac,
    0x4c3798ba,
    0x4c3818cc,
    0x4c3898dc,
    0x4c3918e6,
    0x4c3998fe,
    0x4c3a1916,
    0x4c3a9929,
    0x50323053,
    0x5032b068,
    0x50333079,
    0x5033b08c,
    0x5034309d,
    0x5034b0b0,
    0x503530bf,
    0x5035b0d4,
    0x503630e4,
    0x5036b0f3,
    0x50373104,
    0x5037b114,
    0x50383125,
    0x5038b138,
    0x5039314a,
    0x5039b160,
    0x503a3172,
    0x503ab183,
    0x503b3194,
    0x503bb1a5,
    0x503c31b0,
    0x503cb1bc,
    0x503d31c7,
    0x503db1d2,
    0x503e31df,
    0x503eb1f4,
    0x503f3202,
    0x503fb216,
    0x50403229,
    0x5040b23a,
    0x50413254,
    0x5041b263,
    0x5042326c,
    0x5042b27b,
    0x5043328d,
    0x5043b299,
    0x504432a1,
    0x5044b2b4,
    0x504532c5,
    0x5045b2db,
    0x504632e7,
    0x5046b2fb,
    0x50473309,
    0x5047b31d,
    0x50483337,
    0x5048b34b,
    0x50493361,
    0x5049b378,
    0x504a338a,
    0x504ab39e,
    0x504b33b3,
    0x504bb3ca,
    0x504c33de,
    0x504cb3e7,
    0x504d33ef,
    0x504db3fe,
    0x504e340e,
    0x68321109,
    0x6832911a,
    0x6833112a,
    0x68339138,
    0x68341145,
    0x6c3210f8,
    0x74320a89,
    0x74328a9b,
    0x783206e8,
    0x7832871b,
    0x7833072d,
    0x7833873f,
    0x78340753,
    0x78348767,
    0x78350785,
    0x78358797,
    0x783607ab,
    0x78368819,
    0x7837082b,
    0x7837883d,
    0x7838084f,
    0x78388866,
    0x7839087d,
    0x78398894,
    0x783a08b0,
    0x783a88cc,
    0x783b08e8,
    0x783b88fe,
    0x783c0914,
    0x783c892a,
    0x783d0947,
    0x783d8956,
    0x783e0965,
    0x783e8974,
    0x783f0990,
    0x783f899e,
    0x784009ac,
    0x784089ba,
    0x784109c7,
    0x784186fa,
    0x784207bf,
    0x784287dd,
    0x784307fb,
    0x80321611,
};

const size_t kOpenSSLFunctionValuesLen = sizeof(kOpenSSLFunctionValues) / sizeof(kOpenSSLFunctionValues[0]);

const char kOpenSSLFunctionStringData[] =
    "ASN1_BIT_STRING_set_bit\0"
    "ASN1_ENUMERATED_set\0"
    "ASN1_ENUMERATED_to_BN\0"
    "ASN1_GENERALIZEDTIME_adj\0"
    "ASN1_INTEGER_set\0"
    "ASN1_INTEGER_to_BN\0"
    "ASN1_OBJECT_new\0"
    "ASN1_PCTX_new\0"
    "ASN1_STRING_TABLE_add\0"
    "ASN1_STRING_set\0"
    "ASN1_STRING_type_new\0"
    "ASN1_TIME_adj\0"
    "ASN1_UTCTIME_adj\0"
    "ASN1_d2i_fp\0"
    "ASN1_dup\0"
    "ASN1_generate_v3\0"
    "ASN1_get_object\0"
    "ASN1_i2d_bio\0"
    "ASN1_i2d_fp\0"
    "ASN1_item_d2i_fp\0"
    "ASN1_item_dup\0"
    "ASN1_item_ex_d2i\0"
    "ASN1_item_i2d_bio\0"
    "ASN1_item_i2d_fp\0"
    "ASN1_item_pack\0"
    "ASN1_item_unpack\0"
    "ASN1_mbstring_ncopy\0"
    "ASN1_template_new\0"
    "BIO_new_NDEF\0"
    "BN_to_ASN1_ENUMERATED\0"
    "BN_to_ASN1_INTEGER\0"
    "a2d_ASN1_OBJECT\0"
    "a2i_ASN1_ENUMERATED\0"
    "a2i_ASN1_INTEGER\0"
    "a2i_ASN1_STRING\0"
    "append_exp\0"
    "asn1_cb\0"
    "asn1_check_tlen\0"
    "asn1_collate_primitive\0"
    "asn1_collect\0"
    "asn1_d2i_ex_primitive\0"
    "asn1_d2i_read_bio\0"
    "asn1_do_adb\0"
    "asn1_ex_c2i\0"
    "asn1_find_end\0"
    "asn1_item_ex_combine_new\0"
    "asn1_str2type\0"
    "asn1_template_ex_d2i\0"
    "asn1_template_noexp_d2i\0"
    "bitstr_cb\0"
    "c2i_ASN1_BIT_STRING\0"
    "c2i_ASN1_INTEGER\0"
    "c2i_ASN1_OBJECT\0"
    "collect_data\0"
    "d2i_ASN1_BOOLEAN\0"
    "d2i_ASN1_OBJECT\0"
    "d2i_ASN1_UINTEGER\0"
    "d2i_ASN1_UTCTIME\0"
    "d2i_ASN1_bytes\0"
    "d2i_ASN1_type_bytes\0"
    "i2d_ASN1_TIME\0"
    "i2d_PrivateKey\0"
    "long_c2i\0"
    "parse_tagging\0"
    "BIO_callback_ctrl\0"
    "BIO_ctrl\0"
    "BIO_new\0"
    "BIO_new_file\0"
    "BIO_new_mem_buf\0"
    "BIO_printf\0"
    "BIO_zero_copy_get_read_buf\0"
    "BIO_zero_copy_get_read_buf_done\0"
    "BIO_zero_copy_get_write_buf\0"
    "BIO_zero_copy_get_write_buf_done\0"
    "bio_io\0"
    "bio_make_pair\0"
    "bio_write\0"
    "buffer_ctrl\0"
    "conn_ctrl\0"
    "conn_state\0"
    "file_ctrl\0"
    "file_read\0"
    "mem_write\0"
    "BN_CTX_get\0"
    "BN_CTX_new\0"
    "BN_CTX_start\0"
    "BN_bn2dec\0"
    "BN_bn2hex\0"
    "BN_div\0"
    "BN_div_recp\0"
    "BN_exp\0"
    "BN_generate_dsa_nonce\0"
    "BN_generate_prime_ex\0"
    "BN_lshift\0"
    "BN_mod_exp2_mont\0"
    "BN_mod_exp_mont\0"
    "BN_mod_exp_mont_consttime\0"
    "BN_mod_exp_mont_word\0"
    "BN_mod_inverse\0"
    "BN_mod_inverse_no_branch\0"
    "BN_mod_lshift_quick\0"
    "BN_mod_sqrt\0"
    "BN_new\0"
    "BN_rand\0"
    "BN_rand_range\0"
    "BN_rshift\0"
    "BN_sqrt\0"
    "BN_usub\0"
    "bn_wexpand\0"
    "mod_exp_recp\0"
    "BUF_MEM_new\0"
    "BUF_memdup\0"
    "BUF_strndup\0"
    "buf_mem_grow\0"
    "EVP_AEAD_CTX_init\0"
    "EVP_AEAD_CTX_init_with_direction\0"
    "EVP_AEAD_CTX_open\0"
    "EVP_AEAD_CTX_seal\0"
    "EVP_CIPHER_CTX_copy\0"
    "EVP_CIPHER_CTX_ctrl\0"
    "EVP_CIPHER_CTX_set_key_length\0"
    "EVP_CipherInit_ex\0"
    "EVP_DecryptFinal_ex\0"
    "EVP_EncryptFinal_ex\0"
    "aead_aes_ctr_hmac_sha256_init\0"
    "aead_aes_ctr_hmac_sha256_open\0"
    "aead_aes_ctr_hmac_sha256_seal\0"
    "aead_aes_gcm_init\0"
    "aead_aes_gcm_open\0"
    "aead_aes_gcm_seal\0"
    "aead_aes_key_wrap_init\0"
    "aead_aes_key_wrap_open\0"
    "aead_aes_key_wrap_seal\0"
    "aead_chacha20_poly1305_init\0"
    "aead_chacha20_poly1305_open\0"
    "aead_chacha20_poly1305_seal\0"
    "aead_rc4_md5_tls_init\0"
    "aead_rc4_md5_tls_open\0"
    "aead_rc4_md5_tls_seal\0"
    "aead_ssl3_ensure_cipher_init\0"
    "aead_ssl3_init\0"
    "aead_ssl3_open\0"
    "aead_ssl3_seal\0"
    "aead_tls_ensure_cipher_init\0"
    "aead_tls_init\0"
    "aead_tls_open\0"
    "aead_tls_seal\0"
    "aes_init_key\0"
    "aesni_init_key\0"
    "CONF_parse_list\0"
    "NCONF_load\0"
    "def_load_bio\0"
    "str_copy\0"
    "CRYPTO_get_ex_new_index\0"
    "CRYPTO_set_ex_data\0"
    "get_class\0"
    "get_func_pointers\0"
    "DH_new_method\0"
    "compute_key\0"
    "generate_key\0"
    "generate_parameters\0"
    "EVP_DigestInit_ex\0"
    "EVP_MD_CTX_copy_ex\0"
    "DSA_new_method\0"
    "dsa_sig_cb\0"
    "sign\0"
    "sign_setup\0"
    "verify\0"
    "BN_to_felem\0"
    "EC_GROUP_copy\0"
    "EC_GROUP_get_curve_GFp\0"
    "EC_GROUP_get_degree\0"
    "EC_GROUP_new_by_curve_name\0"
    "EC_GROUP_new_curve_GFp\0"
    "EC_KEY_check_key\0"
    "EC_KEY_copy\0"
    "EC_KEY_generate_key\0"
    "EC_KEY_new_by_curve_name\0"
    "EC_KEY_new_method\0"
    "EC_KEY_set_public_key_affine_coordinates\0"
    "EC_POINT_add\0"
    "EC_POINT_cmp\0"
    "EC_POINT_copy\0"
    "EC_POINT_dbl\0"
    "EC_POINT_dup\0"
    "EC_POINT_get_affine_coordinates_GFp\0"
    "EC_POINT_invert\0"
    "EC_POINT_is_at_infinity\0"
    "EC_POINT_is_on_curve\0"
    "EC_POINT_make_affine\0"
    "EC_POINT_new\0"
    "EC_POINT_oct2point\0"
    "EC_POINT_point2oct\0"
    "EC_POINT_set_affine_coordinates_GFp\0"
    "EC_POINT_set_compressed_coordinates_GFp\0"
    "EC_POINT_set_to_infinity\0"
    "EC_POINTs_make_affine\0"
    "compute_wNAF\0"
    "d2i_ECPKParameters\0"
    "d2i_ECParameters\0"
    "d2i_ECPrivateKey\0"
    "ec_GFp_mont_field_decode\0"
    "ec_GFp_mont_field_encode\0"
    "ec_GFp_mont_field_mul\0"
    "ec_GFp_mont_field_set_to_one\0"
    "ec_GFp_mont_field_sqr\0"
    "ec_GFp_mont_group_set_curve\0"
    "ec_GFp_nistp256_group_set_curve\0"
    "ec_GFp_nistp256_point_get_affine_coordinates\0"
    "ec_GFp_nistp256_points_mul\0"
    "ec_GFp_simple_group_check_discriminant\0"
    "ec_GFp_simple_group_set_curve\0"
    "ec_GFp_simple_make_affine\0"
    "ec_GFp_simple_oct2point\0"
    "ec_GFp_simple_point2oct\0"
    "ec_GFp_simple_point_get_affine_coordinates\0"
    "ec_GFp_simple_point_set_affine_coordinates\0"
    "ec_GFp_simple_points_make_affine\0"
    "ec_GFp_simple_set_compressed_coordinates\0"
    "ec_asn1_group2pkparameters\0"
    "ec_asn1_pkparameters2group\0"
    "ec_group_copy\0"
    "ec_group_new\0"
    "ec_group_new_curve_GFp\0"
    "ec_group_new_from_data\0"
    "ec_point_set_Jprojective_coordinates_GFp\0"
    "ec_pre_comp_new\0"
    "ec_wNAF_mul\0"
    "ec_wNAF_precompute_mult\0"
    "i2d_ECPKParameters\0"
    "i2d_ECParameters\0"
    "i2d_ECPrivateKey\0"
    "i2o_ECPublicKey\0"
    "nistp256_pre_comp_new\0"
    "o2i_ECPublicKey\0"
    "ECDH_compute_key\0"
    "ECDSA_do_sign_ex\0"
    "ECDSA_do_verify\0"
    "ECDSA_sign_ex\0"
    "digest_to_bn\0"
    "ecdsa_sign_setup\0"
    "EVP_DigestSignAlgorithm\0"
    "EVP_DigestVerifyInitFromAlgorithm\0"
    "EVP_PKEY_CTX_ctrl\0"
    "EVP_PKEY_CTX_dup\0"
    "EVP_PKEY_CTX_get0_rsa_oaep_label\0"
    "EVP_PKEY_copy_parameters\0"
    "EVP_PKEY_decrypt\0"
    "EVP_PKEY_decrypt_init\0"
    "EVP_PKEY_derive\0"
    "EVP_PKEY_derive_init\0"
    "EVP_PKEY_derive_set_peer\0"
    "EVP_PKEY_encrypt\0"
    "EVP_PKEY_encrypt_init\0"
    "EVP_PKEY_get1_DH\0"
    "EVP_PKEY_get1_DSA\0"
    "EVP_PKEY_get1_EC_KEY\0"
    "EVP_PKEY_get1_RSA\0"
    "EVP_PKEY_keygen\0"
    "EVP_PKEY_keygen_init\0"
    "EVP_PKEY_new\0"
    "EVP_PKEY_set_type\0"
    "EVP_PKEY_sign\0"
    "EVP_PKEY_sign_init\0"
    "EVP_PKEY_verify\0"
    "EVP_PKEY_verify_init\0"
    "check_padding_md\0"
    "d2i_AutoPrivateKey\0"
    "d2i_PrivateKey\0"
    "do_EC_KEY_print\0"
    "do_dsa_print\0"
    "do_rsa_print\0"
    "do_sigver_init\0"
    "dsa_param_decode\0"
    "dsa_priv_decode\0"
    "dsa_priv_encode\0"
    "dsa_pub_decode\0"
    "dsa_pub_encode\0"
    "dsa_sig_print\0"
    "eckey_param2type\0"
    "eckey_param_decode\0"
    "eckey_priv_decode\0"
    "eckey_priv_encode\0"
    "eckey_pub_decode\0"
    "eckey_pub_encode\0"
    "eckey_type2param\0"
    "evp_pkey_ctx_new\0"
    "hmac_signctx\0"
    "i2d_PublicKey\0"
    "old_dsa_priv_decode\0"
    "old_ec_priv_decode\0"
    "old_rsa_priv_decode\0"
    "pkey_ec_ctrl\0"
    "pkey_ec_derive\0"
    "pkey_ec_keygen\0"
    "pkey_ec_paramgen\0"
    "pkey_ec_sign\0"
    "pkey_hmac_ctrl\0"
    "pkey_rsa_ctrl\0"
    "pkey_rsa_decrypt\0"
    "pkey_rsa_encrypt\0"
    "pkey_rsa_sign\0"
    "rsa_algor_to_md\0"
    "rsa_digest_verify_init_from_algorithm\0"
    "rsa_mgf1_to_md\0"
    "rsa_priv_decode\0"
    "rsa_priv_encode\0"
    "rsa_pss_to_ctx\0"
    "rsa_pub_decode\0"
    "HKDF\0"
    "OBJ_create\0"
    "OBJ_dup\0"
    "OBJ_nid2obj\0"
    "OBJ_txt2obj\0"
    "PEM_ASN1_read\0"
    "PEM_ASN1_read_bio\0"
    "PEM_ASN1_write\0"
    "PEM_ASN1_write_bio\0"
    "PEM_X509_INFO_read\0"
    "PEM_X509_INFO_read_bio\0"
    "PEM_X509_INFO_write_bio\0"
    "PEM_do_header\0"
    "PEM_get_EVP_CIPHER_INFO\0"
    "PEM_read\0"
    "PEM_read_DHparams\0"
    "PEM_read_PrivateKey\0"
    "PEM_read_bio\0"
    "PEM_read_bio_DHparams\0"
    "PEM_read_bio_Parameters\0"
    "PEM_read_bio_PrivateKey\0"
    "PEM_write\0"
    "PEM_write_PrivateKey\0"
    "PEM_write_bio\0"
    "d2i_PKCS8PrivateKey_bio\0"
    "d2i_PKCS8PrivateKey_fp\0"
    "do_pk8pkey\0"
    "do_pk8pkey_fp\0"
    "load_iv\0"
    "EVP_PKCS82PKEY\0"
    "EVP_PKEY2PKCS8\0"
    "PKCS12_get_key_and_certs\0"
    "PKCS12_handle_content_info\0"
    "PKCS12_handle_content_infos\0"
    "PKCS5_pbe2_set_iv\0"
    "PKCS5_pbe_set\0"
    "PKCS5_pbe_set0_algor\0"
    "PKCS5_pbkdf2_set\0"
    "PKCS8_decrypt\0"
    "PKCS8_encrypt\0"
    "PKCS8_encrypt_pbe\0"
    "pbe_cipher_init\0"
    "pbe_crypt\0"
    "pkcs12_item_decrypt_d2i\0"
    "pkcs12_item_i2d_encrypt\0"
    "pkcs12_key_gen_raw\0"
    "pkcs12_pbe_keyivgen\0"
    "BN_BLINDING_convert_ex\0"
    "BN_BLINDING_create_param\0"
    "BN_BLINDING_invert_ex\0"
    "BN_BLINDING_new\0"
    "BN_BLINDING_update\0"
    "RSA_add_pkcs1_prefix\0"
    "RSA_check_key\0"
    "RSA_new_method\0"
    "RSA_padding_add_PKCS1_OAEP_mgf1\0"
    "RSA_padding_add_PKCS1_PSS_mgf1\0"
    "RSA_padding_add_PKCS1_type_1\0"
    "RSA_padding_add_PKCS1_type_2\0"
    "RSA_padding_add_none\0"
    "RSA_padding_check_PKCS1_OAEP_mgf1\0"
    "RSA_padding_check_PKCS1_type_1\0"
    "RSA_padding_check_PKCS1_type_2\0"
    "RSA_padding_check_none\0"
    "RSA_recover_crt_params\0"
    "RSA_sign\0"
    "RSA_verify\0"
    "RSA_verify_PKCS1_PSS_mgf1\0"
    "decrypt\0"
    "encrypt\0"
    "keygen\0"
    "keygen_multiprime\0"
    "private_transform\0"
    "rsa_setup_blinding\0"
    "sign_raw\0"
    "verify_raw\0"
    "SSL_AEAD_CTX_new\0"
    "SSL_AEAD_CTX_open\0"
    "SSL_AEAD_CTX_seal\0"
    "SSL_CTX_check_private_key\0"
    "SSL_CTX_get_tlsext_ticket_keys\0"
    "SSL_CTX_new\0"
    "SSL_CTX_set1_tls_channel_id\0"
    "SSL_CTX_set_cipher_list\0"
    "SSL_CTX_set_cipher_list_tls11\0"
    "SSL_CTX_set_session_id_context\0"
    "SSL_CTX_set_tlsext_ticket_keys\0"
    "SSL_CTX_set_tmp_dh\0"
    "SSL_CTX_set_tmp_ecdh\0"
    "SSL_CTX_use_PrivateKey\0"
    "SSL_CTX_use_PrivateKey_ASN1\0"
    "SSL_CTX_use_PrivateKey_file\0"
    "SSL_CTX_use_RSAPrivateKey\0"
    "SSL_CTX_use_RSAPrivateKey_ASN1\0"
    "SSL_CTX_use_RSAPrivateKey_file\0"
    "SSL_CTX_use_certificate\0"
    "SSL_CTX_use_certificate_ASN1\0"
    "SSL_CTX_use_certificate_chain_file\0"
    "SSL_CTX_use_certificate_file\0"
    "SSL_CTX_use_psk_identity_hint\0"
    "SSL_SESSION_from_bytes\0"
    "SSL_SESSION_new\0"
    "SSL_SESSION_parse\0"
    "SSL_SESSION_parse_octet_string\0"
    "SSL_SESSION_parse_string\0"
    "SSL_SESSION_print_fp\0"
    "SSL_SESSION_set1_id_context\0"
    "SSL_SESSION_to_bytes_full\0"
    "SSL_accept\0"
    "SSL_add_dir_cert_subjects_to_stack\0"
    "SSL_add_file_cert_subjects_to_stack\0"
    "SSL_check_private_key\0"
    "SSL_clear\0"
    "SSL_connect\0"
    "SSL_do_handshake\0"
    "SSL_load_client_CA_file\0"
    "SSL_new\0"
    "SSL_peek\0"
    "SSL_read\0"
    "SSL_renegotiate\0"
    "SSL_set1_tls_channel_id\0"
    "SSL_set_cipher_list\0"
    "SSL_set_fd\0"
    "SSL_set_rfd\0"
    "SSL_set_session_id_context\0"
    "SSL_set_tlsext_host_name\0"
    "SSL_set_tmp_dh\0"
    "SSL_set_tmp_ecdh\0"
    "SSL_set_wfd\0"
    "SSL_shutdown\0"
    "SSL_use_PrivateKey\0"
    "SSL_use_PrivateKey_ASN1\0"
    "SSL_use_PrivateKey_file\0"
    "SSL_use_RSAPrivateKey\0"
    "SSL_use_RSAPrivateKey_ASN1\0"
    "SSL_use_RSAPrivateKey_file\0"
    "SSL_use_certificate\0"
    "SSL_use_certificate_ASN1\0"
    "SSL_use_certificate_file\0"
    "SSL_use_psk_identity_hint\0"
    "SSL_write\0"
    "d2i_SSL_SESSION\0"
    "do_ssl3_write\0"
    "dtls1_accept\0"
    "dtls1_buffer_record\0"
    "dtls1_check_timeout_num\0"
    "dtls1_connect\0"
    "dtls1_do_write\0"
    "dtls1_get_buffered_message\0"
    "dtls1_get_hello_verify\0"
    "dtls1_get_message\0"
    "dtls1_get_message_fragment\0"
    "dtls1_hm_fragment_new\0"
    "dtls1_preprocess_fragment\0"
    "dtls1_process_fragment\0"
    "dtls1_process_record\0"
    "dtls1_read_bytes\0"
    "dtls1_seal_record\0"
    "dtls1_send_hello_verify_request\0"
    "dtls1_write_app_data\0"
    "i2d_SSL_SESSION\0"
    "ssl3_accept\0"
    "ssl3_cert_verify_hash\0"
    "ssl3_check_cert_and_algorithm\0"
    "ssl3_check_certificate_for_cipher\0"
    "ssl3_connect\0"
    "ssl3_ctrl\0"
    "ssl3_ctx_ctrl\0"
    "ssl3_digest_cached_records\0"
    "ssl3_do_change_cipher_spec\0"
    "ssl3_expect_change_cipher_spec\0"
    "ssl3_get_cert_status\0"
    "ssl3_get_cert_verify\0"
    "ssl3_get_certificate_request\0"
    "ssl3_get_channel_id\0"
    "ssl3_get_client_certificate\0"
    "ssl3_get_client_hello\0"
    "ssl3_get_client_key_exchange\0"
    "ssl3_get_finished\0"
    "ssl3_get_initial_bytes\0"
    "ssl3_get_message\0"
    "ssl3_get_new_session_ticket\0"
    "ssl3_get_next_proto\0"
    "ssl3_get_record\0"
    "ssl3_get_server_certificate\0"
    "ssl3_get_server_done\0"
    "ssl3_get_server_hello\0"
    "ssl3_get_server_key_exchange\0"
    "ssl3_get_v2_client_hello\0"
    "ssl3_handshake_mac\0"
    "ssl3_output_cert_chain\0"
    "ssl3_prf\0"
    "ssl3_read_bytes\0"
    "ssl3_read_n\0"
    "ssl3_record_sequence_update\0"
    "ssl3_seal_record\0"
    "ssl3_send_cert_verify\0"
    "ssl3_send_certificate_request\0"
    "ssl3_send_channel_id\0"
    "ssl3_send_client_certificate\0"
    "ssl3_send_client_hello\0"
    "ssl3_send_client_key_exchange\0"
    "ssl3_send_server_certificate\0"
    "ssl3_send_server_hello\0"
    "ssl3_send_server_key_exchange\0"
    "ssl3_setup_read_buffer\0"
    "ssl3_setup_write_buffer\0"
    "ssl3_write_bytes\0"
    "ssl3_write_pending\0"
    "ssl_add_cert_chain\0"
    "ssl_add_cert_to_buf\0"
    "ssl_add_clienthello_renegotiate_ext\0"
    "ssl_add_clienthello_tlsext\0"
    "ssl_add_clienthello_use_srtp_ext\0"
    "ssl_add_serverhello_renegotiate_ext\0"
    "ssl_add_serverhello_tlsext\0"
    "ssl_add_serverhello_use_srtp_ext\0"
    "ssl_build_cert_chain\0"
    "ssl_bytes_to_cipher_list\0"
    "ssl_cert_dup\0"
    "ssl_cert_inst\0"
    "ssl_cert_new\0"
    "ssl_check_serverhello_tlsext\0"
    "ssl_check_srvr_ecc_cert_and_alg\0"
    "ssl_cipher_process_rulestr\0"
    "ssl_cipher_strength_sort\0"
    "ssl_create_cipher_list\0"
    "ssl_ctx_log_master_secret\0"
    "ssl_ctx_log_rsa_client_key_exchange\0"
    "ssl_ctx_make_profiles\0"
    "ssl_get_new_session\0"
    "ssl_get_prev_session\0"
    "ssl_get_server_cert_index\0"
    "ssl_get_sign_pkey\0"
    "ssl_init_wbio_buffer\0"
    "ssl_parse_clienthello_renegotiate_ext\0"
    "ssl_parse_clienthello_tlsext\0"
    "ssl_parse_clienthello_use_srtp_ext\0"
    "ssl_parse_serverhello_renegotiate_ext\0"
    "ssl_parse_serverhello_tlsext\0"
    "ssl_parse_serverhello_use_srtp_ext\0"
    "ssl_scan_clienthello_tlsext\0"
    "ssl_scan_serverhello_tlsext\0"
    "ssl_sess_cert_new\0"
    "ssl_set_cert\0"
    "ssl_set_pkey\0"
    "ssl_verify_cert_chain\0"
    "tls12_check_peer_sigalg\0"
    "tls1_aead_ctx_init\0"
    "tls1_cert_verify_mac\0"
    "tls1_change_cipher_state\0"
    "tls1_change_cipher_state_aead\0"
    "tls1_check_duplicate_extensions\0"
    "tls1_enc\0"
    "tls1_export_keying_material\0"
    "tls1_prf\0"
    "tls1_setup_key_block\0"
    "ASN1_digest\0"
    "ASN1_item_sign_ctx\0"
    "ASN1_item_verify\0"
    "NETSCAPE_SPKI_b64_decode\0"
    "NETSCAPE_SPKI_b64_encode\0"
    "PKCS7_get_CRLs\0"
    "PKCS7_get_certificates\0"
    "X509_ATTRIBUTE_create_by_NID\0"
    "X509_ATTRIBUTE_create_by_OBJ\0"
    "X509_ATTRIBUTE_create_by_txt\0"
    "X509_ATTRIBUTE_get0_data\0"
    "X509_ATTRIBUTE_set1_data\0"
    "X509_CRL_add0_revoked\0"
    "X509_CRL_diff\0"
    "X509_CRL_print_fp\0"
    "X509_EXTENSION_create_by_NID\0"
    "X509_EXTENSION_create_by_OBJ\0"
    "X509_INFO_new\0"
    "X509_NAME_ENTRY_create_by_NID\0"
    "X509_NAME_ENTRY_create_by_txt\0"
    "X509_NAME_ENTRY_set_object\0"
    "X509_NAME_add_entry\0"
    "X509_NAME_oneline\0"
    "X509_NAME_print\0"
    "X509_PKEY_new\0"
    "X509_PUBKEY_get\0"
    "X509_PUBKEY_set\0"
    "X509_REQ_check_private_key\0"
    "X509_REQ_print_ex\0"
    "X509_REQ_print_fp\0"
    "X509_REQ_to_X509\0"
    "X509_STORE_CTX_get1_issuer\0"
    "X509_STORE_CTX_init\0"
    "X509_STORE_CTX_new\0"
    "X509_STORE_CTX_purpose_inherit\0"
    "X509_STORE_add_cert\0"
    "X509_STORE_add_crl\0"
    "X509_TRUST_add\0"
    "X509_TRUST_set\0"
    "X509_check_private_key\0"
    "X509_get_pubkey_parameters\0"
    "X509_load_cert_crl_file\0"
    "X509_load_cert_file\0"
    "X509_load_crl_file\0"
    "X509_print_ex_fp\0"
    "X509_to_X509_REQ\0"
    "X509_verify_cert\0"
    "X509at_add1_attr\0"
    "X509v3_add_ext\0"
    "add_cert_dir\0"
    "by_file_ctrl\0"
    "check_policy\0"
    "dir_ctrl\0"
    "get_cert_by_subject\0"
    "i2d_DSA_PUBKEY\0"
    "i2d_EC_PUBKEY\0"
    "i2d_RSA_PUBKEY\0"
    "pkcs7_parse_header\0"
    "x509_name_encode\0"
    "x509_name_ex_d2i\0"
    "x509_name_ex_new\0"
    "SXNET_add_id_INTEGER\0"
    "SXNET_add_id_asc\0"
    "SXNET_add_id_ulong\0"
    "SXNET_get_id_asc\0"
    "SXNET_get_id_ulong\0"
    "X509V3_EXT_add\0"
    "X509V3_EXT_add_alias\0"
    "X509V3_EXT_free\0"
    "X509V3_EXT_i2d\0"
    "X509V3_EXT_nconf\0"
    "X509V3_add1_i2d\0"
    "X509V3_add_value\0"
    "X509V3_get_section\0"
    "X509V3_get_string\0"
    "X509V3_get_value_bool\0"
    "X509V3_parse_list\0"
    "X509_PURPOSE_add\0"
    "X509_PURPOSE_set\0"
    "a2i_GENERAL_NAME\0"
    "copy_email\0"
    "copy_issuer\0"
    "do_dirname\0"
    "do_ext_i2d\0"
    "do_ext_nconf\0"
    "gnames_from_sectname\0"
    "hex_to_string\0"
    "i2s_ASN1_ENUMERATED\0"
    "i2s_ASN1_IA5STRING\0"
    "i2s_ASN1_INTEGER\0"
    "i2v_AUTHORITY_INFO_ACCESS\0"
    "notice_section\0"
    "nref_nos\0"
    "policy_section\0"
    "process_pci_value\0"
    "r2i_certpol\0"
    "r2i_pci\0"
    "s2i_ASN1_IA5STRING\0"
    "s2i_ASN1_INTEGER\0"
    "s2i_ASN1_OCTET_STRING\0"
    "s2i_skey_id\0"
    "set_dist_point_name\0"
    "string_to_hex\0"
    "v2i_ASN1_BIT_STRING\0"
    "v2i_AUTHORITY_INFO_ACCESS\0"
    "v2i_AUTHORITY_KEYID\0"
    "v2i_BASIC_CONSTRAINTS\0"
    "v2i_EXTENDED_KEY_USAGE\0"
    "v2i_GENERAL_NAMES\0"
    "v2i_GENERAL_NAME_ex\0"
    "v2i_NAME_CONSTRAINTS\0"
    "v2i_POLICY_CONSTRAINTS\0"
    "v2i_POLICY_MAPPINGS\0"
    "v2i_crld\0"
    "v2i_idp\0"
    "v2i_issuer_alt\0"
    "v2i_subject_alt\0"
    "v3_generic_extension\0"
    "";

const uint32_t kOpenSSLReasonValues[] = {
    0xc3207ba,
    0xc3287c7,
    0xc3307d6,
    0xc3387e6,
    0xc3407f5,
    0xc34880e,
    0xc35081a,
    0xc358837,
    0xc360849,
    0xc368857,
    0xc370867,
    0xc378874,
    0xc380884,
    0xc38888f,
    0xc3908a5,
    0xc3988b4,
    0xc3a08c8,
    0x1032146b,
    0x10329477,
    0x10331490,
    0x103394a3,
    0x10340dd4,
    0x103494b6,
    0x103514cb,
    0x103594fd,
    0x10361516,
    0x1036952b,
    0x10371549,
    0x10379558,
    0x10381574,
    0x1038958f,
    0x1039159e,
    0x103995ba,
    0x103a15d5,
    0x103a95ec,
    0x103b15fd,
    0x103b9611,
    0x103c1630,
    0x103c963f,
    0x103d1656,
    0x103d9669,
    0x103e0b5f,
    0x103e969a,
    0x103f16ad,
    0x103f96c7,
    0x104016d7,
    0x104096eb,
    0x10411701,
    0x10419719,
    0x1042172e,
    0x10429742,
    0x10431754,
    0x104385d0,
    0x104408b4,
    0x10449769,
    0x10451780,
    0x10459795,
    0x104617a3,
    0x1046967c,
    0x104714de,
    0x14320b42,
    0x14328b50,
    0x14330b5f,
    0x14338b71,
    0x18320083,
    0x18328e3a,
    0x18340e68,
    0x18348e7c,
    0x18358eb3,
    0x18368ee0,
    0x18370ef3,
    0x18378f07,
    0x18380f2b,
    0x18388f39,
    0x18390f4f,
    0x18398f63,
    0x183a0f73,
    0x183b0f83,
    0x183b8f98,
    0x183c8fc3,
    0x183d0fd7,
    0x183d8fe7,
    0x183e0b8e,
    0x183e8ff4,
    0x183f1006,
    0x183f9011,
    0x18401021,
    0x18409032,
    0x18411043,
    0x18419055,
    0x1842107e,
    0x184290b0,
    0x184310bf,
    0x18451128,
    0x1845913e,
    0x18461159,
    0x18468ecb,
    0x184709cc,
    0x18478094,
    0x18480faf,
    0x184890f4,
    0x18490e50,
    0x18498e91,
    0x184a118f,
    0x184a910c,
    0x184b10d3,
    0x184b8e2a,
    0x184c1097,
    0x184c866b,
    0x184d1174,
    0x203211b6,
    0x243211c2,
    0x243288fa,
    0x243311d4,
    0x243391e1,
    0x243411ee,
    0x24349200,
    0x2435120f,
    0x2435922c,
    0x24361239,
    0x24369247,
    0x24371255,
    0x24379263,
    0x2438126c,
    0x24389279,
    0x2439128c,
    0x28320b82,
    0x28328b8e,
    0x28330b5f,
    0x28338ba1,
    0x2c322b08,
    0x2c32ab16,
    0x2c332b28,
    0x2c33ab3a,
    0x2c342b4e,
    0x2c34ab60,
    0x2c352b7b,
    0x2c35ab8d,
    0x2c362ba0,
    0x2c3682f3,
    0x2c372bad,
    0x2c37abbf,
    0x2c382bd2,
    0x2c38abe0,
    0x2c392bf0,
    0x2c39ac02,
    0x2c3a2c16,
    0x2c3aac27,
    0x2c3b134c,
    0x2c3bac38,
    0x2c3c2c4c,
    0x2c3cac62,
    0x2c3d2c7b,
    0x2c3daca9,
    0x2c3e2cb7,
    0x2c3eaccf,
    0x2c3f2ce7,
    0x2c3facf4,
    0x2c402d17,
    0x2c40ad36,
    0x2c4111b6,
    0x2c41ad47,
    0x2c422d5a,
    0x2c429128,
    0x2c432d6b,
    0x2c4386a2,
    0x2c442c98,
    0x30320000,
    0x30328015,
    0x3033001f,
    0x30338038,
    0x3034004a,
    0x30348064,
    0x3035006b,
    0x30358083,
    0x30360094,
    0x303680a1,
    0x303700b0,
    0x303780bd,
    0x303800d0,
    0x303880eb,
    0x30390100,
    0x30398114,
    0x303a0128,
    0x303a8139,
    0x303b0152,
    0x303b816f,
    0x303c017d,
    0x303c8191,
    0x303d01a1,
    0x303d81ba,
    0x303e01ca,
    0x303e81dd,
    0x303f01ec,
    0x303f81f8,
    0x3040020d,
    0x3040821d,
    0x30410234,
    0x30418241,
    0x30420254,
    0x30428263,
    0x30430278,
    0x30438299,
    0x304402ac,
    0x304482bf,
    0x304502d8,
    0x304582f3,
    0x30460310,
    0x30468329,
    0x30470337,
    0x30478348,
    0x30480357,
    0x3048836f,
    0x30490381,
    0x30498395,
    0x304a03b4,
    0x304a83c7,
    0x304b03d2,
    0x304b83e1,
    0x304c03f2,
    0x304c83fe,
    0x304d0414,
    0x304d8422,
    0x304e0438,
    0x304e844a,
    0x304f045c,
    0x304f846f,
    0x30500482,
    0x30508493,
    0x305104a3,
    0x305184bb,
    0x305204d0,
    0x305284e8,
    0x305304fc,
    0x30538514,
    0x3054052d,
    0x30548546,
    0x30550563,
    0x3055856e,
    0x30560586,
    0x30568596,
    0x305705a7,
    0x305785ba,
    0x305805d0,
    0x305885d9,
    0x305905ee,
    0x30598601,
    0x305a0610,
    0x305a8630,
    0x305b063f,
    0x305b864b,
    0x305c066b,
    0x305c8687,
    0x305d0698,
    0x305d86a2,
    0x34320abc,
    0x34328ad0,
    0x34330aed,
    0x34338b00,
    0x34340b0f,
    0x34348b2c,
    0x3c320083,
    0x3c328bcb,
    0x3c330be4,
    0x3c338bff,
    0x3c340c1c,
    0x3c348c37,
    0x3c350c52,
    0x3c358c67,
    0x3c360c80,
    0x3c368c98,
    0x3c370ca9,
    0x3c378cb7,
    0x3c380cc4,
    0x3c388cd8,
    0x3c390b8e,
    0x3c398cec,
    0x3c3a0d00,
    0x3c3a8874,
    0x3c3b0d10,
    0x3c3b8d2b,
    0x3c3c0d3d,
    0x3c3c8d53,
    0x3c3d0d5d,
    0x3c3d8d71,
    0x3c3e0d7f,
    0x3c3e8da4,
    0x3c3f0bb7,
    0x3c3f8d8d,
    0x403217ba,
    0x403297d0,
    0x403317fe,
    0x40339808,
    0x4034181f,
    0x4034983d,
    0x4035184d,
    0x4035985f,
    0x4036186c,
    0x40369878,
    0x4037188d,
    0x403798a2,
    0x403818b4,
    0x403898bf,
    0x403918d1,
    0x40398dd4,
    0x403a18e1,
    0x403a98f4,
    0x403b1915,
    0x403b9926,
    0x403c1936,
    0x403c8064,
    0x403d1942,
    0x403d995e,
    0x403e1974,
    0x403e9983,
    0x403f1996,
    0x403f99b0,
    0x404019be,
    0x404099d3,
    0x404119e7,
    0x40419a04,
    0x40421a1d,
    0x40429a38,
    0x40431a51,
    0x40439a64,
    0x40441a78,
    0x40449a90,
    0x40451aa0,
    0x40459aae,
    0x40461acc,
    0x40468094,
    0x40471ae1,
    0x40479af3,
    0x40481b17,
    0x40489b37,
    0x40491b4b,
    0x40499b60,
    0x404a1b79,
    0x404a9bb3,
    0x404b1bcd,
    0x404b9beb,
    0x404c1c06,
    0x404c9c20,
    0x404d1c37,
    0x404d9c5f,
    0x404e1c76,
    0x404e9c92,
    0x404f1cae,
    0x404f9ccf,
    0x40501cf1,
    0x40509d0d,
    0x40511d21,
    0x40519d2e,
    0x40521d45,
    0x40529d55,
    0x40531d65,
    0x40539d79,
    0x40541d94,
    0x40549da4,
    0x40551dbb,
    0x40559dca,
    0x40561de5,
    0x40569dfd,
    0x40571e19,
    0x40579e32,
    0x40581e45,
    0x40589e5a,
    0x40591e7d,
    0x40599e8b,
    0x405a1e98,
    0x405a9eb1,
    0x405b1ec9,
    0x405b9edc,
    0x405c1ef1,
    0x405c9f03,
    0x405d1f18,
    0x405d9f28,
    0x405e1f41,
    0x405e9f55,
    0x405f1f65,
    0x405f9f7d,
    0x40601f8e,
    0x40609fa1,
    0x40611fb2,
    0x40619fd0,
    0x40621fe1,
    0x40629fee,
    0x40632005,
    0x4063a046,
    0x4064205d,
    0x4064a06a,
    0x40652078,
    0x4065a09a,
    0x406620c2,
    0x4066a0d7,
    0x406720ee,
    0x4067a0ff,
    0x40682110,
    0x4068a121,
    0x40692136,
    0x4069a14d,
    0x406a215e,
    0x406aa177,
    0x406b2192,
    0x406ba1a9,
    0x406c2216,
    0x406ca237,
    0x406d224a,
    0x406da26b,
    0x406e2286,
    0x406ea2a1,
    0x406f22c2,
    0x406fa2e8,
    0x40702308,
    0x4070a324,
    0x407124b1,
    0x4071a4d4,
    0x407224ea,
    0x4072a509,
    0x40732521,
    0x4073a541,
    0x4074276b,
    0x4074a790,
    0x407527ab,
    0x4075a7ca,
    0x407627f9,
    0x4076a821,
    0x40772852,
    0x4077a871,
    0x40782896,
    0x4078a8ad,
    0x407928c0,
    0x4079a8dd,
    0x407a0782,
    0x407aa8ef,
    0x407b2902,
    0x407ba91b,
    0x407c2933,
    0x407c90b0,
    0x407d2947,
    0x407da961,
    0x407e2972,
    0x407ea986,
    0x407f2994,
    0x407fa9af,
    0x40801279,
    0x4080a9d4,
    0x408129f6,
    0x4081aa11,
    0x40822a26,
    0x4082aa3e,
    0x40832a56,
    0x4083aa6d,
    0x40842a83,
    0x4084aa8f,
    0x40852aa2,
    0x4085aab7,
    0x40862ac9,
    0x4086aade,
    0x40872ae7,
    0x40879c4d,
    0x40880083,
    0x4088a025,
    0x40890a0a,
    0x4089a1c1,
    0x408a1b9c,
    0x408aa1eb,
    0x408b283a,
    0x41f423dc,
    0x41f9246e,
    0x41fe2361,
    0x41fea592,
    0x41ff2683,
    0x420323f5,
    0x42082417,
    0x4208a453,
    0x42092345,
    0x4209a48d,
    0x420a239c,
    0x420aa37c,
    0x420b23bc,
    0x420ba435,
    0x420c269f,
    0x420ca55f,
    0x420d2579,
    0x420da5b0,
    0x421225ca,
    0x42172666,
    0x4217a60c,
    0x421c262e,
    0x421f25e9,
    0x422126b6,
    0x42262649,
    0x422b274f,
    0x422ba718,
    0x422c2737,
    0x422ca6f2,
    0x422d26d1,
    0x443206ad,
    0x443286bc,
    0x443306c8,
    0x443386d6,
    0x443406e9,
    0x443486fa,
    0x44350701,
    0x4435870b,
    0x4436071e,
    0x44368734,
    0x44370746,
    0x44378753,
    0x44380762,
    0x4438876a,
    0x44390782,
    0x44398790,
    0x443a07a3,
    0x4c3212a3,
    0x4c3292b3,
    0x4c3312c6,
    0x4c3392e6,
    0x4c340094,
    0x4c3480b0,
    0x4c3512f2,
    0x4c359300,
    0x4c36131c,
    0x4c36932f,
    0x4c37133e,
    0x4c37934c,
    0x4c381361,
    0x4c38936d,
    0x4c39138d,
    0x4c3993b7,
    0x4c3a13d0,
    0x4c3a93e9,
    0x4c3b05d0,
    0x4c3b9402,
    0x4c3c1414,
    0x4c3c9423,
    0x4c3d10b0,
    0x4c3d943c,
    0x4c3e1449,
    0x50322d7d,
    0x5032ad8c,
    0x50332d97,
    0x5033ada7,
    0x50342dc0,
    0x5034adda,
    0x50352de8,
    0x5035adfe,
    0x50362e10,
    0x5036ae26,
    0x50372e3f,
    0x5037ae52,
    0x50382e6a,
    0x5038ae7b,
    0x50392e90,
    0x5039aea4,
    0x503a2ec4,
    0x503aaeda,
    0x503b2ef2,
    0x503baf04,
    0x503c2f20,
    0x503caf37,
    0x503d2f50,
    0x503daf66,
    0x503e2f73,
    0x503eaf89,
    0x503f2f9b,
    0x503f8348,
    0x50402fae,
    0x5040afbe,
    0x50412fd8,
    0x5041afe7,
    0x50423001,
    0x5042b01e,
    0x5043302e,
    0x5043b03e,
    0x5044304d,
    0x50448414,
    0x50453061,
    0x5045b07f,
    0x50463092,
    0x5046b0a8,
    0x504730ba,
    0x5047b0cf,
    0x504830f5,
    0x5048b103,
    0x50493116,
    0x5049b12b,
    0x504a3141,
    0x504ab151,
    0x504b3171,
    0x504bb184,
    0x504c31a7,
    0x504cb1d5,
    0x504d31e7,
    0x504db204,
    0x504e321f,
    0x504eb23b,
    0x504f324d,
    0x504fb264,
    0x50503273,
    0x50508687,
    0x50513286,
    0x58320e12,
    0x68320dd4,
    0x68328b8e,
    0x68330ba1,
    0x68338de2,
    0x68340df2,
    0x6c320db0,
    0x6c328b71,
    0x6c330dbb,
    0x74320980,
    0x783208e5,
    0x783288fa,
    0x78330906,
    0x78338083,
    0x78340915,
    0x7834892a,
    0x78350949,
    0x7835896b,
    0x78360980,
    0x78368996,
    0x783709a6,
    0x783789b9,
    0x783809cc,
    0x783889de,
    0x783909eb,
    0x78398a0a,
    0x783a0a1f,
    0x783a8a2d,
    0x783b0a37,
    0x783b8a4b,
    0x783c0a62,
    0x783c8a77,
    0x783d0a8e,
    0x783d8aa3,
    0x783e09f9,
    0x803211a5,
};

const size_t kOpenSSLReasonValuesLen = sizeof(kOpenSSLReasonValues) / sizeof(kOpenSSLReasonValues[0]);

const char kOpenSSLReasonStringData[] =
    "ASN1_LENGTH_MISMATCH\0"
    "AUX_ERROR\0"
    "BAD_GET_ASN1_OBJECT_CALL\0"
    "BAD_OBJECT_HEADER\0"
    "BMPSTRING_IS_WRONG_LENGTH\0"
    "BN_LIB\0"
    "BOOLEAN_IS_WRONG_LENGTH\0"
    "BUFFER_TOO_SMALL\0"
    "DECODE_ERROR\0"
    "DEPTH_EXCEEDED\0"
    "ENCODE_ERROR\0"
    "ERROR_GETTING_TIME\0"
    "EXPECTING_AN_ASN1_SEQUENCE\0"
    "EXPECTING_AN_INTEGER\0"
    "EXPECTING_AN_OBJECT\0"
    "EXPECTING_A_BOOLEAN\0"
    "EXPECTING_A_TIME\0"
    "EXPLICIT_LENGTH_MISMATCH\0"
    "EXPLICIT_TAG_NOT_CONSTRUCTED\0"
    "FIELD_MISSING\0"
    "FIRST_NUM_TOO_LARGE\0"
    "HEADER_TOO_LONG\0"
    "ILLEGAL_BITSTRING_FORMAT\0"
    "ILLEGAL_BOOLEAN\0"
    "ILLEGAL_CHARACTERS\0"
    "ILLEGAL_FORMAT\0"
    "ILLEGAL_HEX\0"
    "ILLEGAL_IMPLICIT_TAG\0"
    "ILLEGAL_INTEGER\0"
    "ILLEGAL_NESTED_TAGGING\0"
    "ILLEGAL_NULL\0"
    "ILLEGAL_NULL_VALUE\0"
    "ILLEGAL_OBJECT\0"
    "ILLEGAL_OPTIONAL_ANY\0"
    "ILLEGAL_OPTIONS_ON_ITEM_TEMPLATE\0"
    "ILLEGAL_TAGGED_ANY\0"
    "ILLEGAL_TIME_VALUE\0"
    "INTEGER_NOT_ASCII_FORMAT\0"
    "INTEGER_TOO_LARGE_FOR_LONG\0"
    "INVALID_BIT_STRING_BITS_LEFT\0"
    "INVALID_BMPSTRING_LENGTH\0"
    "INVALID_DIGIT\0"
    "INVALID_MODIFIER\0"
    "INVALID_NUMBER\0"
    "INVALID_OBJECT_ENCODING\0"
    "INVALID_SEPARATOR\0"
    "INVALID_TIME_FORMAT\0"
    "INVALID_UNIVERSALSTRING_LENGTH\0"
    "INVALID_UTF8STRING\0"
    "LIST_ERROR\0"
    "MALLOC_FAILURE\0"
    "MISSING_ASN1_EOS\0"
    "MISSING_EOC\0"
    "MISSING_SECOND_NUMBER\0"
    "MISSING_VALUE\0"
    "MSTRING_NOT_UNIVERSAL\0"
    "MSTRING_WRONG_TAG\0"
    "NESTED_ASN1_ERROR\0"
    "NESTED_ASN1_STRING\0"
    "NON_HEX_CHARACTERS\0"
    "NOT_ASCII_FORMAT\0"
    "NOT_ENOUGH_DATA\0"
    "NO_MATCHING_CHOICE_TYPE\0"
    "NULL_IS_WRONG_LENGTH\0"
    "OBJECT_NOT_ASCII_FORMAT\0"
    "ODD_NUMBER_OF_CHARS\0"
    "SECOND_NUMBER_TOO_LARGE\0"
    "SEQUENCE_LENGTH_MISMATCH\0"
    "SEQUENCE_NOT_CONSTRUCTED\0"
    "SEQUENCE_OR_SET_NEEDS_CONFIG\0"
    "SHORT_LINE\0"
    "STREAMING_NOT_SUPPORTED\0"
    "STRING_TOO_LONG\0"
    "STRING_TOO_SHORT\0"
    "TAG_VALUE_TOO_HIGH\0"
    "TIME_NOT_ASCII_FORMAT\0"
    "TOO_LONG\0"
    "TYPE_NOT_CONSTRUCTED\0"
    "TYPE_NOT_PRIMITIVE\0"
    "UNEXPECTED_EOC\0"
    "UNIVERSALSTRING_IS_WRONG_LENGTH\0"
    "UNKNOWN_FORMAT\0"
    "UNKNOWN_TAG\0"
    "UNSUPPORTED_ANY_DEFINED_BY_TYPE\0"
    "UNSUPPORTED_PUBLIC_KEY_TYPE\0"
    "UNSUPPORTED_TYPE\0"
    "WRONG_TAG\0"
    "WRONG_TYPE\0"
    "BAD_FOPEN_MODE\0"
    "BROKEN_PIPE\0"
    "CONNECT_ERROR\0"
    "ERROR_SETTING_NBIO\0"
    "INVALID_ARGUMENT\0"
    "IN_USE\0"
    "KEEPALIVE\0"
    "NBIO_CONNECT_ERROR\0"
    "NO_HOSTNAME_SPECIFIED\0"
    "NO_PORT_SPECIFIED\0"
    "NO_SUCH_FILE\0"
    "NULL_PARAMETER\0"
    "SYS_LIB\0"
    "UNABLE_TO_CREATE_SOCKET\0"
    "UNINITIALIZED\0"
    "UNSUPPORTED_METHOD\0"
    "WRITE_TO_READ_ONLY_BIO\0"
    "ARG2_LT_ARG3\0"
    "BAD_RECIPROCAL\0"
    "BIGNUM_TOO_LONG\0"
    "BITS_TOO_SMALL\0"
    "CALLED_WITH_EVEN_MODULUS\0"
    "DIV_BY_ZERO\0"
    "EXPAND_ON_STATIC_BIGNUM_DATA\0"
    "INPUT_NOT_REDUCED\0"
    "INVALID_RANGE\0"
    "NEGATIVE_NUMBER\0"
    "NOT_A_SQUARE\0"
    "NOT_INITIALIZED\0"
    "NO_INVERSE\0"
    "PRIVATE_KEY_TOO_LARGE\0"
    "P_IS_NOT_PRIME\0"
    "TOO_MANY_ITERATIONS\0"
    "TOO_MANY_TEMPORARY_VARIABLES\0"
    "AES_KEY_SETUP_FAILED\0"
    "BAD_DECRYPT\0"
    "BAD_KEY_LENGTH\0"
    "CTRL_NOT_IMPLEMENTED\0"
    "CTRL_OPERATION_NOT_IMPLEMENTED\0"
    "DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH\0"
    "INITIALIZATION_ERROR\0"
    "INPUT_NOT_INITIALIZED\0"
    "INVALID_AD_SIZE\0"
    "INVALID_KEY_LENGTH\0"
    "INVALID_NONCE_SIZE\0"
    "INVALID_OPERATION\0"
    "IV_TOO_LARGE\0"
    "NO_CIPHER_SET\0"
    "NO_DIRECTION_SET\0"
    "OUTPUT_ALIASES_INPUT\0"
    "TAG_TOO_LARGE\0"
    "TOO_LARGE\0"
    "UNSUPPORTED_AD_SIZE\0"
    "UNSUPPORTED_INPUT_SIZE\0"
    "UNSUPPORTED_KEY_SIZE\0"
    "UNSUPPORTED_NONCE_SIZE\0"
    "UNSUPPORTED_TAG_SIZE\0"
    "WRONG_FINAL_BLOCK_LENGTH\0"
    "LIST_CANNOT_BE_NULL\0"
    "MISSING_CLOSE_SQUARE_BRACKET\0"
    "MISSING_EQUAL_SIGN\0"
    "NO_CLOSE_BRACE\0"
    "UNABLE_TO_CREATE_NEW_SECTION\0"
    "VARIABLE_HAS_NO_VALUE\0"
    "BAD_GENERATOR\0"
    "INVALID_PUBKEY\0"
    "MODULUS_TOO_LARGE\0"
    "NO_PRIVATE_VALUE\0"
    "BAD_Q_VALUE\0"
    "MISSING_PARAMETERS\0"
    "NEED_NEW_SETUP_VALUES\0"
    "BIGNUM_OUT_OF_RANGE\0"
    "COORDINATES_OUT_OF_RANGE\0"
    "D2I_ECPKPARAMETERS_FAILURE\0"
    "EC_GROUP_NEW_BY_NAME_FAILURE\0"
    "GROUP2PKPARAMETERS_FAILURE\0"
    "I2D_ECPKPARAMETERS_FAILURE\0"
    "INCOMPATIBLE_OBJECTS\0"
    "INVALID_COMPRESSED_POINT\0"
    "INVALID_COMPRESSION_BIT\0"
    "INVALID_ENCODING\0"
    "INVALID_FIELD\0"
    "INVALID_FORM\0"
    "INVALID_GROUP_ORDER\0"
    "INVALID_PRIVATE_KEY\0"
    "MISSING_PRIVATE_KEY\0"
    "NON_NAMED_CURVE\0"
    "PKPARAMETERS2GROUP_FAILURE\0"
    "POINT_AT_INFINITY\0"
    "POINT_IS_NOT_ON_CURVE\0"
    "SLOT_FULL\0"
    "UNDEFINED_GENERATOR\0"
    "UNKNOWN_GROUP\0"
    "UNKNOWN_ORDER\0"
    "WRONG_CURVE_PARAMETERS\0"
    "WRONG_ORDER\0"
    "KDF_FAILED\0"
    "POINT_ARITHMETIC_FAILURE\0"
    "BAD_SIGNATURE\0"
    "NOT_IMPLEMENTED\0"
    "RANDOM_NUMBER_GENERATION_FAILED\0"
    "OPERATION_NOT_SUPPORTED\0"
    "BN_DECODE_ERROR\0"
    "COMMAND_NOT_SUPPORTED\0"
    "CONTEXT_NOT_INITIALISED\0"
    "DIFFERENT_KEY_TYPES\0"
    "DIFFERENT_PARAMETERS\0"
    "DIGEST_AND_KEY_TYPE_NOT_SUPPORTED\0"
    "EXPECTING_AN_EC_KEY_KEY\0"
    "EXPECTING_AN_RSA_KEY\0"
    "EXPECTING_A_DH_KEY\0"
    "EXPECTING_A_DSA_KEY\0"
    "ILLEGAL_OR_UNSUPPORTED_PADDING_MODE\0"
    "INVALID_CURVE\0"
    "INVALID_DIGEST_LENGTH\0"
    "INVALID_DIGEST_TYPE\0"
    "INVALID_KEYBITS\0"
    "INVALID_MGF1_MD\0"
    "INVALID_PADDING_MODE\0"
    "INVALID_PSS_PARAMETERS\0"
    "INVALID_PSS_SALTLEN\0"
    "INVALID_SALT_LENGTH\0"
    "INVALID_TRAILER\0"
    "KEYS_NOT_SET\0"
    "NO_DEFAULT_DIGEST\0"
    "NO_KEY_SET\0"
    "NO_MDC2_SUPPORT\0"
    "NO_NID_FOR_CURVE\0"
    "NO_OPERATION_SET\0"
    "NO_PARAMETERS_SET\0"
    "OPERATION_NOT_SUPPORTED_FOR_THIS_KEYTYPE\0"
    "OPERATON_NOT_INITIALIZED\0"
    "PARAMETER_ENCODING_ERROR\0"
    "UNKNOWN_DIGEST\0"
    "UNKNOWN_MASK_DIGEST\0"
    "UNKNOWN_MESSAGE_DIGEST_ALGORITHM\0"
    "UNKNOWN_PUBLIC_KEY_TYPE\0"
    "UNKNOWN_SIGNATURE_ALGORITHM\0"
    "UNSUPPORTED_ALGORITHM\0"
    "UNSUPPORTED_MASK_ALGORITHM\0"
    "UNSUPPORTED_MASK_PARAMETER\0"
    "UNSUPPORTED_SIGNATURE_TYPE\0"
    "WRONG_PUBLIC_KEY_TYPE\0"
    "OUTPUT_TOO_LARGE\0"
    "UNKNOWN_NID\0"
    "BAD_BASE64_DECODE\0"
    "BAD_END_LINE\0"
    "BAD_IV_CHARS\0"
    "BAD_PASSWORD_READ\0"
    "CIPHER_IS_NULL\0"
    "ERROR_CONVERTING_PRIVATE_KEY\0"
    "NOT_DEK_INFO\0"
    "NOT_ENCRYPTED\0"
    "NOT_PROC_TYPE\0"
    "NO_START_LINE\0"
    "READ_KEY\0"
    "SHORT_HEADER\0"
    "UNSUPPORTED_CIPHER\0"
    "UNSUPPORTED_ENCRYPTION\0"
    "BAD_PKCS12_DATA\0"
    "BAD_PKCS12_VERSION\0"
    "CIPHER_HAS_NO_OBJECT_IDENTIFIER\0"
    "CRYPT_ERROR\0"
    "ENCRYPT_ERROR\0"
    "ERROR_SETTING_CIPHER_PARAMS\0"
    "INCORRECT_PASSWORD\0"
    "KEYGEN_FAILURE\0"
    "KEY_GEN_ERROR\0"
    "METHOD_NOT_SUPPORTED\0"
    "MISSING_MAC\0"
    "MULTIPLE_PRIVATE_KEYS_IN_PKCS12\0"
    "PKCS12_PUBLIC_KEY_INTEGRITY_NOT_SUPPORTED\0"
    "PKCS12_TOO_DEEPLY_NESTED\0"
    "PRIVATE_KEY_DECODE_ERROR\0"
    "PRIVATE_KEY_ENCODE_ERROR\0"
    "UNKNOWN_ALGORITHM\0"
    "UNKNOWN_CIPHER\0"
    "UNKNOWN_CIPHER_ALGORITHM\0"
    "UNKNOWN_HASH\0"
    "UNSUPPORTED_PRIVATE_KEY_ALGORITHM\0"
    "BAD_E_VALUE\0"
    "BAD_FIXED_HEADER_DECRYPT\0"
    "BAD_PAD_BYTE_COUNT\0"
    "BAD_RSA_PARAMETERS\0"
    "BLOCK_TYPE_IS_NOT_01\0"
    "BN_NOT_INITIALIZED\0"
    "CANNOT_RECOVER_MULTI_PRIME_KEY\0"
    "CRT_PARAMS_ALREADY_GIVEN\0"
    "CRT_VALUES_INCORRECT\0"
    "DATA_LEN_NOT_EQUAL_TO_MOD_LEN\0"
    "DATA_TOO_LARGE\0"
    "DATA_TOO_LARGE_FOR_KEY_SIZE\0"
    "DATA_TOO_LARGE_FOR_MODULUS\0"
    "DATA_TOO_SMALL\0"
    "DATA_TOO_SMALL_FOR_KEY_SIZE\0"
    "DIGEST_TOO_BIG_FOR_RSA_KEY\0"
    "D_E_NOT_CONGRUENT_TO_1\0"
    "EMPTY_PUBLIC_KEY\0"
    "FIRST_OCTET_INVALID\0"
    "INCONSISTENT_SET_OF_CRT_VALUES\0"
    "INTERNAL_ERROR\0"
    "INVALID_MESSAGE_LENGTH\0"
    "KEY_SIZE_TOO_SMALL\0"
    "LAST_OCTET_INVALID\0"
    "MUST_HAVE_AT_LEAST_TWO_PRIMES\0"
    "NO_PUBLIC_EXPONENT\0"
    "NULL_BEFORE_BLOCK_MISSING\0"
    "N_NOT_EQUAL_P_Q\0"
    "OAEP_DECODING_ERROR\0"
    "ONLY_ONE_OF_P_Q_GIVEN\0"
    "OUTPUT_BUFFER_TOO_SMALL\0"
    "PADDING_CHECK_FAILED\0"
    "PKCS_DECODING_ERROR\0"
    "SLEN_CHECK_FAILED\0"
    "SLEN_RECOVERY_FAILED\0"
    "UNKNOWN_ALGORITHM_TYPE\0"
    "UNKNOWN_PADDING_TYPE\0"
    "VALUE_MISSING\0"
    "WRONG_SIGNATURE_LENGTH\0"
    "APP_DATA_IN_HANDSHAKE\0"
    "ATTEMPT_TO_REUSE_SESSION_IN_DIFFERENT_CONTEXT\0"
    "BAD_ALERT\0"
    "BAD_CHANGE_CIPHER_SPEC\0"
    "BAD_DATA_RETURNED_BY_CALLBACK\0"
    "BAD_DH_P_LENGTH\0"
    "BAD_DIGEST_LENGTH\0"
    "BAD_ECC_CERT\0"
    "BAD_ECPOINT\0"
    "BAD_HANDSHAKE_LENGTH\0"
    "BAD_HANDSHAKE_RECORD\0"
    "BAD_HELLO_REQUEST\0"
    "BAD_LENGTH\0"
    "BAD_PACKET_LENGTH\0"
    "BAD_RSA_ENCRYPT\0"
    "BAD_SRTP_MKI_VALUE\0"
    "BAD_SRTP_PROTECTION_PROFILE_LIST\0"
    "BAD_SSL_FILETYPE\0"
    "BAD_WRITE_RETRY\0"
    "BIO_NOT_SET\0"
    "CANNOT_SERIALIZE_PUBLIC_KEY\0"
    "CA_DN_LENGTH_MISMATCH\0"
    "CA_DN_TOO_LONG\0"
    "CCS_RECEIVED_EARLY\0"
    "CERTIFICATE_VERIFY_FAILED\0"
    "CERT_CB_ERROR\0"
    "CERT_LENGTH_MISMATCH\0"
    "CHANNEL_ID_NOT_P256\0"
    "CHANNEL_ID_SIGNATURE_INVALID\0"
    "CIPHER_CODE_WRONG_LENGTH\0"
    "CIPHER_OR_HASH_UNAVAILABLE\0"
    "CLIENTHELLO_PARSE_FAILED\0"
    "CLIENTHELLO_TLSEXT\0"
    "CONNECTION_REJECTED\0"
    "CONNECTION_TYPE_NOT_SET\0"
    "COOKIE_MISMATCH\0"
    "D2I_ECDSA_SIG\0"
    "DATA_BETWEEN_CCS_AND_FINISHED\0"
    "DATA_LENGTH_TOO_LONG\0"
    "DECRYPTION_FAILED\0"
    "DECRYPTION_FAILED_OR_BAD_RECORD_MAC\0"
    "DH_PUBLIC_VALUE_LENGTH_IS_WRONG\0"
    "DIGEST_CHECK_FAILED\0"
    "DTLS_MESSAGE_TOO_BIG\0"
    "ECC_CERT_NOT_FOR_SIGNING\0"
    "EMPTY_SRTP_PROTECTION_PROFILE_LIST\0"
    "EMS_STATE_INCONSISTENT\0"
    "ENCRYPTED_LENGTH_TOO_LONG\0"
    "ERROR_IN_RECEIVED_CIPHER_LIST\0"
    "EVP_DIGESTSIGNFINAL_FAILED\0"
    "EVP_DIGESTSIGNINIT_FAILED\0"
    "EXCESSIVE_MESSAGE_SIZE\0"
    "EXTRA_DATA_IN_MESSAGE\0"
    "FRAGMENT_MISMATCH\0"
    "GOT_A_FIN_BEFORE_A_CCS\0"
    "GOT_CHANNEL_ID_BEFORE_A_CCS\0"
    "GOT_NEXT_PROTO_BEFORE_A_CCS\0"
    "GOT_NEXT_PROTO_WITHOUT_EXTENSION\0"
    "HANDSHAKE_FAILURE_ON_CLIENT_HELLO\0"
    "HANDSHAKE_RECORD_BEFORE_CCS\0"
    "HTTPS_PROXY_REQUEST\0"
    "HTTP_REQUEST\0"
    "INAPPROPRIATE_FALLBACK\0"
    "INVALID_COMMAND\0"
    "INVALID_MESSAGE\0"
    "INVALID_SSL_SESSION\0"
    "INVALID_TICKET_KEYS_LENGTH\0"
    "LENGTH_MISMATCH\0"
    "LIBRARY_HAS_NO_CIPHERS\0"
    "MISSING_DH_KEY\0"
    "MISSING_ECDSA_SIGNING_CERT\0"
    "MISSING_RSA_CERTIFICATE\0"
    "MISSING_RSA_ENCRYPTING_CERT\0"
    "MISSING_RSA_SIGNING_CERT\0"
    "MISSING_TMP_DH_KEY\0"
    "MISSING_TMP_ECDH_KEY\0"
    "MIXED_SPECIAL_OPERATOR_WITH_GROUPS\0"
    "MTU_TOO_SMALL\0"
    "NESTED_GROUP\0"
    "NO_CERTIFICATES_RETURNED\0"
    "NO_CERTIFICATE_ASSIGNED\0"
    "NO_CERTIFICATE_SET\0"
    "NO_CIPHERS_AVAILABLE\0"
    "NO_CIPHERS_PASSED\0"
    "NO_CIPHERS_SPECIFIED\0"
    "NO_CIPHER_MATCH\0"
    "NO_COMPRESSION_SPECIFIED\0"
    "NO_METHOD_SPECIFIED\0"
    "NO_P256_SUPPORT\0"
    "NO_PRIVATE_KEY_ASSIGNED\0"
    "NO_RENEGOTIATION\0"
    "NO_REQUIRED_DIGEST\0"
    "NO_SHARED_CIPHER\0"
    "NO_SHARED_SIGATURE_ALGORITHMS\0"
    "NO_SRTP_PROFILES\0"
    "NULL_SSL_CTX\0"
    "NULL_SSL_METHOD_PASSED\0"
    "OLD_SESSION_CIPHER_NOT_RETURNED\0"
    "OLD_SESSION_VERSION_NOT_RETURNED\0"
    "PACKET_LENGTH_TOO_LONG\0"
    "PARSE_TLSEXT\0"
    "PATH_TOO_LONG\0"
    "PEER_DID_NOT_RETURN_A_CERTIFICATE\0"
    "PEER_ERROR_UNSUPPORTED_CERTIFICATE_TYPE\0"
    "PROTOCOL_IS_SHUTDOWN\0"
    "PSK_IDENTITY_NOT_FOUND\0"
    "PSK_NO_CLIENT_CB\0"
    "PSK_NO_SERVER_CB\0"
    "READ_BIO_NOT_SET\0"
    "READ_TIMEOUT_EXPIRED\0"
    "RECORD_LENGTH_MISMATCH\0"
    "RECORD_TOO_LARGE\0"
    "RENEGOTIATE_EXT_TOO_LONG\0"
    "RENEGOTIATION_ENCODING_ERR\0"
    "RENEGOTIATION_MISMATCH\0"
    "REQUIRED_CIPHER_MISSING\0"
    "RESUMED_EMS_SESSION_WITHOUT_EMS_EXTENSION\0"
    "RESUMED_NON_EMS_SESSION_WITH_EMS_EXTENSION\0"
    "SCSV_RECEIVED_WHEN_RENEGOTIATING\0"
    "SERVERHELLO_TLSEXT\0"
    "SESSION_ID_CONTEXT_UNINITIALIZED\0"
    "SESSION_MAY_NOT_BE_CREATED\0"
    "SIGNATURE_ALGORITHMS_ERROR\0"
    "SRTP_COULD_NOT_ALLOCATE_PROFILES\0"
    "SRTP_PROTECTION_PROFILE_LIST_TOO_LONG\0"
    "SRTP_UNKNOWN_PROTECTION_PROFILE\0"
    "SSL3_EXT_INVALID_SERVERNAME\0"
    "SSL3_EXT_INVALID_SERVERNAME_TYPE\0"
    "SSLV3_ALERT_BAD_CERTIFICATE\0"
    "SSLV3_ALERT_BAD_RECORD_MAC\0"
    "SSLV3_ALERT_CERTIFICATE_EXPIRED\0"
    "SSLV3_ALERT_CERTIFICATE_REVOKED\0"
    "SSLV3_ALERT_CERTIFICATE_UNKNOWN\0"
    "SSLV3_ALERT_CLOSE_NOTIFY\0"
    "SSLV3_ALERT_DECOMPRESSION_FAILURE\0"
    "SSLV3_ALERT_HANDSHAKE_FAILURE\0"
    "SSLV3_ALERT_ILLEGAL_PARAMETER\0"
    "SSLV3_ALERT_NO_CERTIFICATE\0"
    "SSLV3_ALERT_UNEXPECTED_MESSAGE\0"
    "SSLV3_ALERT_UNSUPPORTED_CERTIFICATE\0"
    "SSL_CTX_HAS_NO_DEFAULT_SSL_VERSION\0"
    "SSL_HANDSHAKE_FAILURE\0"
    "SSL_SESSION_ID_CALLBACK_FAILED\0"
    "SSL_SESSION_ID_CONFLICT\0"
    "SSL_SESSION_ID_CONTEXT_TOO_LONG\0"
    "SSL_SESSION_ID_HAS_BAD_LENGTH\0"
    "TLSV1_ALERT_ACCESS_DENIED\0"
    "TLSV1_ALERT_DECODE_ERROR\0"
    "TLSV1_ALERT_DECRYPTION_FAILED\0"
    "TLSV1_ALERT_DECRYPT_ERROR\0"
    "TLSV1_ALERT_EXPORT_RESTRICTION\0"
    "TLSV1_ALERT_INAPPROPRIATE_FALLBACK\0"
    "TLSV1_ALERT_INSUFFICIENT_SECURITY\0"
    "TLSV1_ALERT_INTERNAL_ERROR\0"
    "TLSV1_ALERT_NO_RENEGOTIATION\0"
    "TLSV1_ALERT_PROTOCOL_VERSION\0"
    "TLSV1_ALERT_RECORD_OVERFLOW\0"
    "TLSV1_ALERT_UNKNOWN_CA\0"
    "TLSV1_ALERT_USER_CANCELLED\0"
    "TLSV1_BAD_CERTIFICATE_HASH_VALUE\0"
    "TLSV1_BAD_CERTIFICATE_STATUS_RESPONSE\0"
    "TLSV1_CERTIFICATE_UNOBTAINABLE\0"
    "TLSV1_UNRECOGNIZED_NAME\0"
    "TLSV1_UNSUPPORTED_EXTENSION\0"
    "TLS_CLIENT_CERT_REQ_WITH_ANON_CIPHER\0"
    "TLS_ILLEGAL_EXPORTER_LABEL\0"
    "TLS_INVALID_ECPOINTFORMAT_LIST\0"
    "TLS_PEER_DID_NOT_RESPOND_WITH_CERTIFICATE_LIST\0"
    "TLS_RSA_ENCRYPTED_VALUE_LENGTH_IS_WRONG\0"
    "TOO_MANY_EMPTY_FRAGMENTS\0"
    "TOO_MANY_WARNING_ALERTS\0"
    "UNABLE_TO_FIND_ECDH_PARAMETERS\0"
    "UNABLE_TO_FIND_PUBLIC_KEY_PARAMETERS\0"
    "UNEXPECTED_GROUP_CLOSE\0"
    "UNEXPECTED_MESSAGE\0"
    "UNEXPECTED_OPERATOR_IN_GROUP\0"
    "UNEXPECTED_RECORD\0"
    "UNKNOWN_ALERT_TYPE\0"
    "UNKNOWN_CERTIFICATE_TYPE\0"
    "UNKNOWN_CIPHER_RETURNED\0"
    "UNKNOWN_CIPHER_TYPE\0"
    "UNKNOWN_KEY_EXCHANGE_TYPE\0"
    "UNKNOWN_PROTOCOL\0"
    "UNKNOWN_SSL_VERSION\0"
    "UNKNOWN_STATE\0"
    "UNPROCESSED_HANDSHAKE_DATA\0"
    "UNSAFE_LEGACY_RENEGOTIATION_DISABLED\0"
    "UNSUPPORTED_COMPRESSION_ALGORITHM\0"
    "UNSUPPORTED_ELLIPTIC_CURVE\0"
    "UNSUPPORTED_PROTOCOL\0"
    "UNSUPPORTED_SSL_VERSION\0"
    "USE_SRTP_NOT_NEGOTIATED\0"
    "WRONG_CERTIFICATE_TYPE\0"
    "WRONG_CIPHER_RETURNED\0"
    "WRONG_CURVE\0"
    "WRONG_MESSAGE_TYPE\0"
    "WRONG_SIGNATURE_TYPE\0"
    "WRONG_SSL_VERSION\0"
    "WRONG_VERSION_NUMBER\0"
    "X509_LIB\0"
    "X509_VERIFICATION_SETUP_PROBLEMS\0"
    "AKID_MISMATCH\0"
    "BAD_PKCS7_VERSION\0"
    "BAD_X509_FILETYPE\0"
    "BASE64_DECODE_ERROR\0"
    "CANT_CHECK_DH_KEY\0"
    "CERT_ALREADY_IN_HASH_TABLE\0"
    "CRL_ALREADY_DELTA\0"
    "CRL_VERIFY_FAILURE\0"
    "IDP_MISMATCH\0"
    "INVALID_DIRECTORY\0"
    "INVALID_FIELD_NAME\0"
    "INVALID_TRUST\0"
    "ISSUER_MISMATCH\0"
    "KEY_TYPE_MISMATCH\0"
    "KEY_VALUES_MISMATCH\0"
    "LOADING_CERT_DIR\0"
    "LOADING_DEFAULTS\0"
    "NEWER_CRL_NOT_NEWER\0"
    "NOT_PKCS7_SIGNED_DATA\0"
    "NO_CERTIFICATES_INCLUDED\0"
    "NO_CERT_SET_FOR_US_TO_VERIFY\0"
    "NO_CRLS_INCLUDED\0"
    "NO_CRL_NUMBER\0"
    "PUBLIC_KEY_DECODE_ERROR\0"
    "PUBLIC_KEY_ENCODE_ERROR\0"
    "SHOULD_RETRY\0"
    "UNABLE_TO_FIND_PARAMETERS_IN_CHAIN\0"
    "UNABLE_TO_GET_CERTS_PUBLIC_KEY\0"
    "UNKNOWN_KEY_TYPE\0"
    "UNKNOWN_PURPOSE_ID\0"
    "UNKNOWN_TRUST_ID\0"
    "WRONG_LOOKUP_TYPE\0"
    "BAD_IP_ADDRESS\0"
    "BAD_OBJECT\0"
    "BN_DEC2BN_ERROR\0"
    "BN_TO_ASN1_INTEGER_ERROR\0"
    "CANNOT_FIND_FREE_FUNCTION\0"
    "DIRNAME_ERROR\0"
    "DISTPOINT_ALREADY_SET\0"
    "DUPLICATE_ZONE_ID\0"
    "ERROR_CONVERTING_ZONE\0"
    "ERROR_CREATING_EXTENSION\0"
    "ERROR_IN_EXTENSION\0"
    "EXPECTED_A_SECTION_NAME\0"
    "EXTENSION_EXISTS\0"
    "EXTENSION_NAME_ERROR\0"
    "EXTENSION_NOT_FOUND\0"
    "EXTENSION_SETTING_NOT_SUPPORTED\0"
    "EXTENSION_VALUE_ERROR\0"
    "ILLEGAL_EMPTY_EXTENSION\0"
    "ILLEGAL_HEX_DIGIT\0"
    "INCORRECT_POLICY_SYNTAX_TAG\0"
    "INVALID_BOOLEAN_STRING\0"
    "INVALID_EXTENSION_STRING\0"
    "INVALID_MULTIPLE_RDNS\0"
    "INVALID_NAME\0"
    "INVALID_NULL_ARGUMENT\0"
    "INVALID_NULL_NAME\0"
    "INVALID_NULL_VALUE\0"
    "INVALID_NUMBERS\0"
    "INVALID_OBJECT_IDENTIFIER\0"
    "INVALID_OPTION\0"
    "INVALID_POLICY_IDENTIFIER\0"
    "INVALID_PROXY_POLICY_SETTING\0"
    "INVALID_PURPOSE\0"
    "INVALID_SECTION\0"
    "INVALID_SYNTAX\0"
    "ISSUER_DECODE_ERROR\0"
    "NEED_ORGANIZATION_AND_NUMBERS\0"
    "NO_CONFIG_DATABASE\0"
    "NO_ISSUER_CERTIFICATE\0"
    "NO_ISSUER_DETAILS\0"
    "NO_POLICY_IDENTIFIER\0"
    "NO_PROXY_CERT_POLICY_LANGUAGE_DEFINED\0"
    "NO_PUBLIC_KEY\0"
    "NO_SUBJECT_DETAILS\0"
    "ODD_NUMBER_OF_DIGITS\0"
    "OPERATION_NOT_DEFINED\0"
    "OTHERNAME_ERROR\0"
    "POLICY_LANGUAGE_ALREADY_DEFINED\0"
    "POLICY_PATH_LENGTH\0"
    "POLICY_PATH_LENGTH_ALREADY_DEFINED\0"
    "POLICY_WHEN_PROXY_LANGUAGE_REQUIRES_NO_POLICY\0"
    "SECTION_NOT_FOUND\0"
    "UNABLE_TO_GET_ISSUER_DETAILS\0"
    "UNABLE_TO_GET_ISSUER_KEYID\0"
    "UNKNOWN_BIT_STRING_ARGUMENT\0"
    "UNKNOWN_EXTENSION\0"
    "UNKNOWN_EXTENSION_NAME\0"
    "UNKNOWN_OPTION\0"
    "UNSUPPORTED_OPTION\0"
    "USER_TOO_LONG\0"
    "";

