/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Quick Controls module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Digia Plc and its Subsidiary(-ies) nor the names
**     of its contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick 2.1
import QtQuick.Controls 1.0
import QtQuick.Controls.Tizen 1.0
import QtQuick.Window 2.0
import "content"

ApplicationWindow {
    id: appWindow
    y: 60
    width: 720
    height: 1220
    View {
        id: view
        anchors.fill: parent

        titleBar.text: "Controls Gallery"
        titleBar.subText: pageStack.depth > 1 ? pageStack.currentItem: "Main Page"
        property bool active:Qt.application.active


        /*SOME UGLY HACK - FIXME*/
        onActiveChanged: {
            /* quit only on device*/
            if (!active && Screen.width == 720 && Screen.height == 1280) {
                Qt.quit()
            }
        }
        backAction.onTriggered: pageStack.depth > 1 ? pageStack.pop() : Qt.quit()
        // Implements back key navigation
        Keys.onReleased: {
            if (event.key === Qt.Key_Back) {
                if (pageStack.depth > 1) {
                    pageStack.pop();
                    event.accepted = true;
                } else { Qt.quit(); }
            }
        }

        ListModel {
            id: pageModel
            ListElement {
                title: "Buttons"
                page: "content/ButtonPage.qml"
            }
            ListElement {
                title: "Sliders"
                page: "content/SliderPage.qml"
            }
            ListElement {
                title: "ProgressBar"
                page: "content/ProgressBarPage.qml"
            }
            ListElement {
                title: "Tabs"
                page: "content/TabBarPage.qml"
            }
            ListElement {
                title: "CheckBoxes"
                page: "content/CheckBoxPage.qml"
            }
            ListElement {
                title: "ContextMenu"
                page: "content/ContextMenuPage.qml"
            }
            ListElement {
                title: "SplitView"
                page: "content/SplitViewPage.qml"
            }
            ListElement {
                title: "DateTimeEdit"
                page: "content/DateTimeEditPage.qml"
            }
        }

        StackView {
            id: pageStack
            anchors.fill: parent

            initialItem: Item {
                width: parent.width
                height: parent.height


                ListView {
                    id:listView
                    model: pageModel
                    anchors.fill: parent
                    clip:true

                    delegate: AndroidDelegate {
                        text: title
                        onClicked: {
                            view.titleBar.subText = Qt.binding(function() {return pageStack.depth > 1 ? title: "Main Page"})
                            pageStack.push(Qt.resolvedUrl(page))
                        }
                    }
                    ScrollDecorator {flickableItem: listView}
                }
            }
        }
    }
}
