# The following environment variables must be defined when mysql-test-run.pl is run:
#   MTR_VAULT_ADDRESS - Hashicorp Vault server URL including protocol and optional port (e.g. http://128.0.0.1:8200)
#   MTR_VAULT_PLUGIN_TOKEN - Hashicorp Vault server token
#   MTR_VAULT_CA - path to Hashicorp Vault server CA certificate (optional)
# The following MTR variables must be defined when this file is included
#   $vault_conf_file - the name of the configuration file to be generated
#   $vault_conf_mount_point_uuid - unique identifier used as a stem for the mount point (usually generated by 'SELECT UUID()')
#   $vault_conf_mount_point_suffix - optional mount point suffix (e.g. '_1', '_2')
#   $vault_conf_mount_point_directory - optional directory within mount point
#   $vault_conf_mount_point_version - optional Hashicorp Vault server version that will be written to the configuration file
#   $vault_conf_address - optional Hashicorp Vault server URL, if not defined, taken from MTR_VAULT_ADDRESS environment variable
#   $vault_conf_token - optional Hashicorp Vault server token, if not defined, taken from MTR_VAULT_PLUGIN_TOKEN environment variable
#   $vault_conf_ca - optional path to Hashicorp Vault server CA certificate, if not defined, taken from MTR_VAULT_CA environment variable
#   $skip_vault_conf_ca - do not fill in vault_conf_ca even in case it is provided in MTR_VAULT_CA environment variable

--let EXPORTED_VAULT_CONF_FILE = $vault_conf_file
--let EXPORTED_VAULT_CONF_MOUNT_POINT_UUID = $vault_conf_mount_point_uuid
--let EXPORTED_VAULT_CONF_MOUNT_POINT_SUFFIX = $vault_conf_mount_point_suffix
--let EXPORTED_VAULT_CONF_MOUNT_POINT_DIRECTORY = $vault_conf_mount_point_directory
--let EXPORTED_VAULT_CONF_MOUNT_POINT_VERSION = $vault_conf_mount_point_version
--let EXPORTED_VAULT_CONF_ADDRESS =
if ($vault_conf_address)
{
  --let EXPORTED_VAULT_CONF_ADDRESS = $vault_conf_address
}
--let EXPORTED_VAULT_CONF_TOKEN =
if ($vault_conf_token)
{
  --let EXPORTED_VAULT_CONF_TOKEN = $vault_conf_token
}
--let EXPORTED_VAULT_CONF_CA =
if ($vault_conf_ca)
{
  --let EXPORTED_VAULT_CONF_CA = $vault_conf_ca
}
--let EXPORTED_SKIP_VAULT_CONF_CA = 0
if ($skip_vault_conf_ca)
{
  --let EXPORTED_SKIP_VAULT_CONF_CA = 1
}

--perl
  use strict;
  # Vaults' credentials from ENV variables
  my $imported_vault_conf_address = $ENV{'EXPORTED_VAULT_CONF_ADDRESS'};
  if (!$imported_vault_conf_address)
  {
    $imported_vault_conf_address = $ENV{'MTR_VAULT_ADDRESS'} or die "Please export MTR_VAULT_ADDRESS variable";
  }

  my $imported_vault_conf_token = $ENV{'EXPORTED_VAULT_CONF_TOKEN'};
  if (!$imported_vault_conf_token)
  {
    $imported_vault_conf_token = $ENV{'MTR_VAULT_PLUGIN_TOKEN'} or die("Please export MTR_VAULT_PLUGIN_TOKEN variable");
  }

  my $imported_vault_conf_ca = $ENV{'EXPORTED_VAULT_CONF_CA'};
  if (!$imported_vault_conf_ca)
  {
    $imported_vault_conf_ca = $ENV{'MTR_VAULT_CA'};
  }

  my $imported_skip_vault_conf_ca = $ENV{EXPORTED_SKIP_VAULT_CONF_CA};
  if ($imported_skip_vault_conf_ca)
  {
    $imported_vault_conf_ca = '';
  }

  my $imported_vault_conf_file = $ENV{'EXPORTED_VAULT_CONF_FILE'} or die("EXPORTED_VAULT_CONF_FILE not set\n");
  my $imported_vault_conf_mount_point_uuid = $ENV{'EXPORTED_VAULT_CONF_MOUNT_POINT_UUID'} or die("EXPORTED_VAULT_CONF_MOUNT_POINT_UUID not set\n");
  my $imported_vault_conf_mount_point_suffix = $ENV{'EXPORTED_VAULT_CONF_MOUNT_POINT_SUFFIX'};
  my $imported_vault_conf_mount_point_directory = $ENV{EXPORTED_VAULT_CONF_MOUNT_POINT_DIRECTORY};
  my $imported_vault_conf_mount_point_version = $ENV{EXPORTED_VAULT_CONF_MOUNT_POINT_VERSION};

  my $secret_mount_point = "mtr/" . $imported_vault_conf_mount_point_uuid;
  if ($imported_vault_conf_mount_point_directory)
  {
    $secret_mount_point .= "/";
    $secret_mount_point .= $imported_vault_conf_mount_point_directory;
  }
  if ($imported_vault_conf_mount_point_suffix)
  {
    $secret_mount_point .= $imported_vault_conf_mount_point_suffix;
  }

  open(CONF_FILE, ">", $imported_vault_conf_file) or die "Could not create configuration file: ${imported_vault_conf_file}.\n";

  print CONF_FILE "vault_url = " . $imported_vault_conf_address . "\n";
  print CONF_FILE "secret_mount_point = " . $secret_mount_point . "\n";
  print CONF_FILE "token = " . $imported_vault_conf_token . "\n";
  if ($imported_vault_conf_ca)
  {
    print CONF_FILE "vault_ca = " . $imported_vault_conf_ca . "\n";
  }
  if ($imported_vault_conf_mount_point_version)
  {
    print CONF_FILE "secret_mount_point_version = " . $imported_vault_conf_mount_point_version . "\n";
  }

  close(CONF_FILE);
EOF
