# *Percona XtraBackup* 8.0.27-19


* **Date**

    February 2, 2022



* **Installation**

    [Installing Percona XtraBackup](https://www.percona.com/doc/percona-xtrabackup/8.0/installation.html)


Percona XtraBackup enables MySQL backups without blocking user queries, making it ideal for companies with large data sets and mission-critical applications that cannot tolerate long periods of downtime. Offered free as an open source solution, it drives down backup costs while providing unique features for MySQL backups.

## Release Highlights

The following list contains a number of the bug fixes for *MySQL* 8.0.27, provided by Oracle, and included in Percona Server for MySQL:


* The `default_authentication_plugin` is deprecated. Support for this plugin may be removed in future versions. Use the `authentication_policy` variable.


* The `binary` operator is deprecated. Support for this operator may be removed in future versions. Use `CAST(... AS BINARY)`.


* When a parent table updated or deleted a row, this operation initiated a cascading `SET NULL` operation on the child table. On the child table, a virtual column value could be set to NULL instead of the value derived from the base column value.

Find the full list of bug fixes and changes in the [MySQL 8.0.27 Release Notes](https://dev.mysql.com/doc/relnotes/mysql/8.0/en/news-8-0-27.html).

## New Features


* [PXB-1883](https://jira.percona.com/browse/PXB-1883): Added support for Microsoft Azure Cloud Storage in the xbcloud binary. (Thanks to Ivan for reporting this issue)

## Improvements


* [PXB-2434](https://jira.percona.com/browse/PXB-2434): Use MySQL page tracking for incremental backup

## Bugs Fixed


* [PXB-1741](https://jira.percona.com/browse/PXB-1741): PS startup displays errors for databases excluded during partial backup


* [PXB-2614](https://jira.percona.com/browse/PXB-2614): The `xbstream` binary was enhanced to support sparse files  on the XFS file system.


* [PXB-2608](https://jira.percona.com/browse/PXB-2608): Upgrade the Vault API to V2 (Thanks to Benedito Marques Magalhaes for reporting this issue)


* [PXB-2543](https://jira.percona.com/browse/PXB-2543): Fix that adds `IB_EXPORT_CFG_VERSION_V6` when exporting a `.cfg` file for a table (Thanks to Peng Gao for reporting this issue)


* [PXB-2465](https://jira.percona.com/browse/PXB-2465): Fix for querying the `ps.log_status` when group replication channels are items on that list. XtraBackup skips the name if it matches either `group_replication_applier`or `group_replication_recovery`.(Thanks to Galamb Gergő for reporting this issue)


* [PXB-2625](https://jira.percona.com/browse/PXB-2625): The default version of CURL in Debian Buster failed to identify a TLS HTTP2 connection as closed and attempted to reuse the connection. (Thanks to Johan Andersson for reporting this issue)
