﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-autoscaling/ApplicationAutoScaling_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace ApplicationAutoScaling
{
namespace Model
{

  /**
   * <p>Represents the minimum and maximum capacity for a scheduled
   * action.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/application-autoscaling-2016-02-06/ScalableTargetAction">AWS
   * API Reference</a></p>
   */
  class AWS_APPLICATIONAUTOSCALING_API ScalableTargetAction
  {
  public:
    ScalableTargetAction();
    ScalableTargetAction(Aws::Utils::Json::JsonView jsonValue);
    ScalableTargetAction& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The minimum capacity.</p> <p>For Lambda provisioned concurrency, the minimum
     * value allowed is 0. For all other resources, the minimum value allowed is 1.</p>
     */
    inline int GetMinCapacity() const{ return m_minCapacity; }

    /**
     * <p>The minimum capacity.</p> <p>For Lambda provisioned concurrency, the minimum
     * value allowed is 0. For all other resources, the minimum value allowed is 1.</p>
     */
    inline bool MinCapacityHasBeenSet() const { return m_minCapacityHasBeenSet; }

    /**
     * <p>The minimum capacity.</p> <p>For Lambda provisioned concurrency, the minimum
     * value allowed is 0. For all other resources, the minimum value allowed is 1.</p>
     */
    inline void SetMinCapacity(int value) { m_minCapacityHasBeenSet = true; m_minCapacity = value; }

    /**
     * <p>The minimum capacity.</p> <p>For Lambda provisioned concurrency, the minimum
     * value allowed is 0. For all other resources, the minimum value allowed is 1.</p>
     */
    inline ScalableTargetAction& WithMinCapacity(int value) { SetMinCapacity(value); return *this;}


    /**
     * <p>The maximum capacity.</p>
     */
    inline int GetMaxCapacity() const{ return m_maxCapacity; }

    /**
     * <p>The maximum capacity.</p>
     */
    inline bool MaxCapacityHasBeenSet() const { return m_maxCapacityHasBeenSet; }

    /**
     * <p>The maximum capacity.</p>
     */
    inline void SetMaxCapacity(int value) { m_maxCapacityHasBeenSet = true; m_maxCapacity = value; }

    /**
     * <p>The maximum capacity.</p>
     */
    inline ScalableTargetAction& WithMaxCapacity(int value) { SetMaxCapacity(value); return *this;}

  private:

    int m_minCapacity;
    bool m_minCapacityHasBeenSet;

    int m_maxCapacity;
    bool m_maxCapacityHasBeenSet;
  };

} // namespace Model
} // namespace ApplicationAutoScaling
} // namespace Aws
