﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>
#include <aws/cognito-idp/model/RiskDecisionType.h>
#include <aws/cognito-idp/model/RiskLevelType.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CognitoIdentityProvider
{
namespace Model
{

  /**
   * <p>The event risk type.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/EventRiskType">AWS
   * API Reference</a></p>
   */
  class AWS_COGNITOIDENTITYPROVIDER_API EventRiskType
  {
  public:
    EventRiskType();
    EventRiskType(Aws::Utils::Json::JsonView jsonValue);
    EventRiskType& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The risk decision.</p>
     */
    inline const RiskDecisionType& GetRiskDecision() const{ return m_riskDecision; }

    /**
     * <p>The risk decision.</p>
     */
    inline bool RiskDecisionHasBeenSet() const { return m_riskDecisionHasBeenSet; }

    /**
     * <p>The risk decision.</p>
     */
    inline void SetRiskDecision(const RiskDecisionType& value) { m_riskDecisionHasBeenSet = true; m_riskDecision = value; }

    /**
     * <p>The risk decision.</p>
     */
    inline void SetRiskDecision(RiskDecisionType&& value) { m_riskDecisionHasBeenSet = true; m_riskDecision = std::move(value); }

    /**
     * <p>The risk decision.</p>
     */
    inline EventRiskType& WithRiskDecision(const RiskDecisionType& value) { SetRiskDecision(value); return *this;}

    /**
     * <p>The risk decision.</p>
     */
    inline EventRiskType& WithRiskDecision(RiskDecisionType&& value) { SetRiskDecision(std::move(value)); return *this;}


    /**
     * <p>The risk level.</p>
     */
    inline const RiskLevelType& GetRiskLevel() const{ return m_riskLevel; }

    /**
     * <p>The risk level.</p>
     */
    inline bool RiskLevelHasBeenSet() const { return m_riskLevelHasBeenSet; }

    /**
     * <p>The risk level.</p>
     */
    inline void SetRiskLevel(const RiskLevelType& value) { m_riskLevelHasBeenSet = true; m_riskLevel = value; }

    /**
     * <p>The risk level.</p>
     */
    inline void SetRiskLevel(RiskLevelType&& value) { m_riskLevelHasBeenSet = true; m_riskLevel = std::move(value); }

    /**
     * <p>The risk level.</p>
     */
    inline EventRiskType& WithRiskLevel(const RiskLevelType& value) { SetRiskLevel(value); return *this;}

    /**
     * <p>The risk level.</p>
     */
    inline EventRiskType& WithRiskLevel(RiskLevelType&& value) { SetRiskLevel(std::move(value)); return *this;}


    /**
     * <p>Indicates whether compromised credentials were detected during an
     * authentication event.</p>
     */
    inline bool GetCompromisedCredentialsDetected() const{ return m_compromisedCredentialsDetected; }

    /**
     * <p>Indicates whether compromised credentials were detected during an
     * authentication event.</p>
     */
    inline bool CompromisedCredentialsDetectedHasBeenSet() const { return m_compromisedCredentialsDetectedHasBeenSet; }

    /**
     * <p>Indicates whether compromised credentials were detected during an
     * authentication event.</p>
     */
    inline void SetCompromisedCredentialsDetected(bool value) { m_compromisedCredentialsDetectedHasBeenSet = true; m_compromisedCredentialsDetected = value; }

    /**
     * <p>Indicates whether compromised credentials were detected during an
     * authentication event.</p>
     */
    inline EventRiskType& WithCompromisedCredentialsDetected(bool value) { SetCompromisedCredentialsDetected(value); return *this;}

  private:

    RiskDecisionType m_riskDecision;
    bool m_riskDecisionHasBeenSet;

    RiskLevelType m_riskLevel;
    bool m_riskLevelHasBeenSet;

    bool m_compromisedCredentialsDetected;
    bool m_compromisedCredentialsDetectedHasBeenSet;
  };

} // namespace Model
} // namespace CognitoIdentityProvider
} // namespace Aws
