# How to build RPM:
#
#   rpmbuild -ba pgpool.spec --define="pgpool_version 3.4.0" --define="pg_version 93" --define="pghome /usr/pgsql-9.3" --define="dist .rhel7" --define="pgsql_ver 93"
#
# OR
#
#   rpmbuild -ba pgpool.spec --define="pgpool_version 3.4.0" --define="pg_version 11" --define="pghome /usr/pgsql-11" --define="dist .rhel7" --define="pgsql_ver 110"
#
# RPM names are:
#   percona-pgpool-II-pg{pg_version}-{pgpool_version}-{rel}.rhel{v}.{arch}.rpm
#   percona-pgpool-II-pg{pg_version}-devel-{pgpool_version}-{rel}.rhel{v}.{arch}.rpm
#   percona-pgpool-II-pg{pg_version}-extensions-{pgpool_version}-{rel}.rhel{v}.{arch}.rpm
#   percona-pgpool-II-pg{pg_version}-{pgpool_version}-{rel}.rhel{v}.src.rpm

%global short_name  pgpool-II

%if 0%{rhel} && 0%{rhel} <= 6
  %global systemd_enabled 0
%else
  %global systemd_enabled 1
%endif

%global _varrundir %{_localstatedir}/run/pgpool
%global _varlogdir %{_localstatedir}/log/pgpool_log

Summary:        Pgpool is a connection pooling/replication server for PostgreSQL
Name:           percona-pgpool-II-pg%{pg_version}
Version:        %{pgpool_version}
Release:        1%{?dist}
License:        BSD
Group:          Applications/Databases
Vendor:         Pgpool Global Development Group
URL:            http://www.pgpool.net/
Source0:        percona-pgpool-II-%{version}.tar.gz
Source1:        pgpool.init
Source2:        pgpool_rhel6.sysconfig
%if %{systemd_enabled}
Source3:        pgpool.service
%endif
Source4:        pgpool_rhel.sysconfig
Source5:        pgpool_tmpfiles.d
Source6:        pgpool_sudoers.d
%if %{pgsql_ver} >=94 && %{rhel} >= 7
Patch1:         pgpool_socket_dir.patch
Patch2:         pcp_unix_domain_path.patch
%endif
Patch3:         pgpool_log.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:  postgresql%{pg_version}-devel pam-devel openssl-devel jade libxslt docbook-dtds docbook-style-xsl docbook-style-dsssl openldap-devel
%if %{rhel} >= 9
BuildRequires:  libmemcached-awesome-devel
%else
BuildRequires:  libmemcached-devel
%endif
%if %{pgsql_ver} >= 110 && %{rhel} == 7
BuildRequires:  llvm-toolset-7 llvm-toolset-7-llvm-devel llvm5.0
%endif
%if %{pgsql_ver} >= 110 && %{rhel} >= 8
BuildRequires:  llvm-devel >= 6.0.0 clang-devel >= 6.0.0
%endif
%if %{systemd_enabled}
BuildRequires:    systemd
Requires:         systemd
Requires(post):   systemd-sysv
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd
%else
Requires(post):   chkconfig
Requires(preun):  chkconfig
Requires(preun):  initscripts
Requires(postun): initscripts
%endif
Obsoletes:      postgresql-pgpool

# original pgpool archive name
%define archive_name percona-pgpool-II-%{version}

%description
percona-pgpool-II is a inherited project of pgpool (to classify from
percona-pgpool-II, it is sometimes called as pgpool-I). For those of
you not familiar with pgpool-I, it is a multi-functional
middle ware for PostgreSQL that features connection pooling,
replication and load balancing functions. pgpool-I allows a
user to connect at most two PostgreSQL servers for higher
availability or for higher search performance compared to a
single PostgreSQL server.

%package devel
Summary:     The development files for percona-pgpool-II
Group:       Development/Libraries
Requires:    %{name} = %{version}

%description devel
Development headers and libraries for percona-pgpool-II.

%package extensions
Summary:     PostgreSQL extensions for percona-pgpool-II
Group:       Applications/Databases
%description extensions
PostgreSQL extensions libraries and sql files for percona-pgpool-II.

%prep
%setup -q -n %{archive_name}
%if %{pgsql_ver} >=94 && %{rhel} >= 7
#%patch1 -p0
%patch2 -p0
%endif
%patch3 -p0

%build
libtoolize; autoreconf --force --install; %configure --with-pgsql=%{pghome} \
           --disable-static \
           --with-pam \
           --with-openssl \
           --with-ldap \
           --with-memcached=%{_usr} \
           --disable-rpath \
           --sysconfdir=%{_sysconfdir}/%{short_name}/

make
make -C doc

%install
rm -rf %{buildroot}

# make percona-pgpool-II
export PATH=%{pghome}/bin:$PATH
make DESTDIR=%{buildroot} install

# install to PostgreSQL
make DESTDIR=%{buildroot} install -C src/sql/pgpool-recovery
%if %{pgsql_ver} <= 93
# From PostgreSQL 9.4 pgpool-regclass.so is not needed anymore
# because 9.4 or later has to_regclass.
make DESTDIR=%{buildroot} install -C src/sql/pgpool-regclass
%endif
make DESTDIR=%{buildroot} install -C src/sql/pgpool_adm

install -d %{buildroot}%{_datadir}/%{short_name}
install -d %{buildroot}%{_sysconfdir}/%{short_name}
install -d %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts
mv %{buildroot}%{_sysconfdir}/%{short_name}/failover.sh.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/failover.sh.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/follow_primary.sh.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/follow_primary.sh.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/pgpool_remote_start.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/pgpool_remote_start.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/recovery_1st_stage.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/recovery_1st_stage.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/replication_mode_recovery_1st_stage.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/replication_mode_recovery_1st_stage.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/replication_mode_recovery_2nd_stage.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/replication_mode_recovery_2nd_stage.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/escalation.sh.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/escalation.sh.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/aws_eip_if_cmd.sh.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/aws_eip_if_cmd.sh.sample
mv %{buildroot}%{_sysconfdir}/%{short_name}/aws_rtb_if_cmd.sh.sample \
        %{buildroot}%{_sysconfdir}/%{short_name}/sample_scripts/aws_rtb_if_cmd.sh.sample
cp %{buildroot}%{_sysconfdir}/%{short_name}/pcp.conf.sample %{buildroot}%{_sysconfdir}/%{short_name}/pcp.conf
cp %{buildroot}%{_sysconfdir}/%{short_name}/pgpool.conf.sample %{buildroot}%{_sysconfdir}/%{short_name}/pgpool.conf
cp %{buildroot}%{_sysconfdir}/%{short_name}/pool_hba.conf.sample %{buildroot}%{_sysconfdir}/%{short_name}/pool_hba.conf
touch %{buildroot}%{_sysconfdir}/%{short_name}/pool_passwd
touch %{buildroot}%{_sysconfdir}/%{short_name}/pgpool_node_id

%if %{systemd_enabled}
install -d %{buildroot}%{_unitdir}
install -m 644 %{SOURCE3} %{buildroot}%{_unitdir}/pgpool.service

install -d -m 755 %{buildroot}%{_varrundir}
mkdir -p %{buildroot}%{_tmpfilesdir}
install -m 0644 %{SOURCE5} %{buildroot}%{_tmpfilesdir}/%{name}.conf
%else
install -d %{buildroot}%{_initrddir}
install -m 755 %{SOURCE1} %{buildroot}%{_initrddir}/pgpool
%endif

mkdir -p %{buildroot}%{_varlogdir} 

install -d %{buildroot}%{_sysconfdir}/sysconfig
%if 0%{rhel} && 0%{rhel} <= 6
    install -m 644 %{SOURCE2} %{buildroot}%{_sysconfdir}/sysconfig/pgpool
%else
    install -m 644 %{SOURCE4} %{buildroot}%{_sysconfdir}/sysconfig/pgpool
%endif

# install sudoers.d to allow postgres user to run ip and arping with root privileges without a password
install -d %{buildroot}%{_sysconfdir}/sudoers.d
install -m 0644 %{SOURCE6} %{buildroot}%{_sysconfdir}/sudoers.d/pgpool

# nuke libtool archive and static lib
rm -f %{buildroot}%{_libdir}/libpcp.{a,la}

mkdir html
mv doc/src/sgml/html html/en

install -d %{buildroot}%{_mandir}/man1
install doc/src/sgml/man1/*.1 %{buildroot}%{_mandir}/man1
install -d %{buildroot}%{_mandir}/man8
install doc/src/sgml/man8/*.8 %{buildroot}%{_mandir}/man8

%clean
rm -rf %{buildroot}

%pre
groupadd -g 26 -o -r postgres >/dev/null 2>&1 || :
useradd -M -g postgres -o -r -d /var/lib/pgsql -s /bin/bash \
        -c "PostgreSQL Server" -u 26 postgres >/dev/null 2>&1 || :

%post
/sbin/ldconfig

%if %{systemd_enabled}
%systemd_post pgpool.service
%else
/sbin/chkconfig --add pgpool
%endif

%preun
%if %{systemd_enabled}
%systemd_preun pgpool.service
%else
if [ $1 = 0 ] ; then
  /sbin/service pgpool condstop >/dev/null 2>&1
  chkconfig --del pgpool
fi
%endif

%postun
/sbin/ldconfig

%if %{systemd_enabled}
%systemd_postun_with_restart pgpool.service

%triggerun -- pgpool < 3.1-1
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply pgpool
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save pgpool >/dev/null 2>&1 ||:

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del pgpool >/dev/null 2>&1 || :
/bin/systemctl try-restart pgpool.service >/dev/null 2>&1 || :

%else
if [ $1 -ge 1 ] ; then
  /sbin/service pgpool condrestart >/dev/null 2>&1 || :
fi
%endif

%files
%defattr(-,root,root,-)
%dir %{_datadir}/%{short_name}
%doc README TODO COPYING INSTALL AUTHORS ChangeLog html
%{_bindir}/pgpool
%{_bindir}/pcp_attach_node
%{_bindir}/pcp_detach_node
%{_bindir}/pcp_node_count
%{_bindir}/pcp_node_info
%{_bindir}/pcp_pool_status
%{_bindir}/pcp_proc_count
%{_bindir}/pcp_proc_info
%{_bindir}/pcp_promote_node
%{_bindir}/pcp_stop_pgpool
%{_bindir}/pcp_recovery_node
%{_bindir}/pcp_watchdog_info
%{_bindir}/pcp_reload_config
%{_bindir}/pcp_health_check_stats
%{_bindir}/pg_md5
%{_bindir}/pg_enc
%{_bindir}/pgpool_setup
%{_bindir}/watchdog_setup
%{_bindir}/pgproto
%{_bindir}/wd_cli
%{_mandir}/man8/*.8.gz
%{_mandir}/man1/*.1.gz
%{_datadir}/%{short_name}/insert_lock.sql
%{_datadir}/%{short_name}/pgpool.pam
%{_libdir}/libpcp.so.*
%if %{systemd_enabled}
%attr(755,postgres,postgres) %dir %{_varrundir}
%{_tmpfilesdir}/%{name}.conf
%{_sysconfdir}/sudoers.d/pgpool
%{_unitdir}/pgpool.service
%else
%{_initrddir}/pgpool
%endif
%attr(0755,postgres,postgres) %dir %{_varlogdir}
%defattr(600,postgres,postgres,-)
%{_sysconfdir}/%{short_name}/pgpool.conf.sample
%{_sysconfdir}/%{short_name}/pcp.conf.sample
%{_sysconfdir}/%{short_name}/pool_hba.conf.sample
%defattr(755,postgres,postgres,-)
%{_sysconfdir}/%{short_name}/sample_scripts/failover.sh.sample
%{_sysconfdir}/%{short_name}/sample_scripts/follow_primary.sh.sample
%{_sysconfdir}/%{short_name}/sample_scripts/pgpool_remote_start.sample
%{_sysconfdir}/%{short_name}/sample_scripts/recovery_1st_stage.sample
%{_sysconfdir}/%{short_name}/sample_scripts/replication_mode_recovery_1st_stage.sample
%{_sysconfdir}/%{short_name}/sample_scripts/replication_mode_recovery_2nd_stage.sample
%{_sysconfdir}/%{short_name}/sample_scripts/escalation.sh.sample
%{_sysconfdir}/%{short_name}/sample_scripts/aws_eip_if_cmd.sh.sample
%{_sysconfdir}/%{short_name}/sample_scripts/aws_rtb_if_cmd.sh.sample
%attr(600,postgres,postgres) %config(noreplace) %{_sysconfdir}/%{short_name}/*.conf
%attr(600,postgres,postgres) %config(noreplace) %{_sysconfdir}/%{short_name}/pool_passwd
%attr(600,postgres,postgres) %config(noreplace) %{_sysconfdir}/%{short_name}/pgpool_node_id
%config(noreplace) %{_sysconfdir}/sysconfig/pgpool

%files devel
%defattr(-,root,root,-)
%{_includedir}/libpcp_ext.h
%{_includedir}/pcp.h
%{_includedir}/pool_process_reporting.h
%{_includedir}/pool_type.h
%{_libdir}/libpcp.so

%files extensions
%defattr(-,root,root,-)
%{pghome}/share/extension/pgpool-recovery.sql
%{pghome}/share/extension/pgpool_recovery--1.1.sql
%{pghome}/share/extension/pgpool_recovery--1.2.sql
%{pghome}/share/extension/pgpool_recovery--1.1--1.2.sql
%{pghome}/share/extension/pgpool_recovery--1.3.sql
%{pghome}/share/extension/pgpool_recovery--1.2--1.3.sql
%{pghome}/share/extension/pgpool_recovery--1.4.sql
%{pghome}/share/extension/pgpool_recovery--1.3--1.4.sql
%{pghome}/share/extension/pgpool_recovery.control
%{pghome}/lib/pgpool-recovery.so
%{pghome}/share/extension/pgpool_adm--1.0.sql
%{pghome}/share/extension/pgpool_adm--1.1.sql
%{pghome}/share/extension/pgpool_adm--1.0--1.1.sql
%{pghome}/share/extension/pgpool_adm--1.2.sql
%{pghome}/share/extension/pgpool_adm--1.1--1.2.sql
%{pghome}/share/extension/pgpool_adm--1.3.sql
%{pghome}/share/extension/pgpool_adm--1.2--1.3.sql
%{pghome}/share/extension/pgpool_adm--1.4.sql
%{pghome}/share/extension/pgpool_adm--1.3--1.4.sql
%{pghome}/share/extension/pgpool_adm--1.5.sql
%{pghome}/share/extension/pgpool_adm--1.4--1.5.sql
%{pghome}/share/extension/pgpool_adm.control
%{pghome}/lib/pgpool_adm.so
# From PostgreSQL 9.4 pgpool-regclass.so is not needed anymore
# because 9.4 or later has to_regclass.
%if %{pgsql_ver} <= 93
  %{pghome}/share/extension/pgpool_regclass--1.0.sql
  %{pghome}/share/extension/pgpool_regclass.control
  %{pghome}/share/extension/pgpool-regclass.sql
  %{pghome}/lib/pgpool-regclass.so
%endif
# From PostgreSQL 11 the relevant files have to be installed 
# into $pkglibdir/bitcode/
%if %{pgsql_ver} >= 110 && %{rhel} >= 7
  %{pghome}/lib/bitcode/pgpool-recovery.index.bc
  %{pghome}/lib/bitcode/pgpool-recovery/pgpool-recovery.bc
  %{pghome}/lib/bitcode/pgpool_adm.index.bc
  %{pghome}/lib/bitcode/pgpool_adm/pgpool_adm.bc
%endif

%changelog
* Fri Feb 09 2024 Percona Build/Release Team <eng-build@percona.com> - 4.5.0-1
- Release 4.5.0-1

