##! Events generated by the QUIC analyzer.
##!
##! See See `RFC9000 <https://datatracker.ietf.org/doc/html/rfc9000>`__.

## Generated for a QUIC Initial packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
##
global QUIC::initial_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string);


## Generated for a QUIC Retry packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
##
## retry_token: The Retry Token field.
##
## integrity_tag: The Retry Integrity Tag field.
global QUIC::retry_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string, retry_token: string, retry_integrity_tag: string);


## Generated for a QUIC Handshake packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
global QUIC::handshake_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string);

## Generated for a QUIC 0-RTT packet.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
global QUIC::zero_rtt_packet: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string);


## Generated for a QUIC CONNECTION_CLOSE frame.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
##
## error_code: Count indicating the reason for closing this connection.
##
## reason_phrase: Additional diagnostic information for the closure.
##
## .. note:: Packets with CONNECTION_CLOSE frames are usually encrypted after connection establishment and not visible to Zeek.
global QUIC::connection_close_frame: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string, error_code: count, reason_phrase: string);


## Generated for an unrecognized QUIC version.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## version: The Version field.
##
## dcid: The Destination Connection ID field.
##
## scid: The Source Connection ID field.
global QUIC::unhandled_version: event(c: connection, is_orig: bool, version: count, dcid: string, scid: string);

## Generated when a QUIC packet with fixed_bit 0 is encountered.
##
## This event is only generated if some INITIAL QUIC packets were successfully
## decrypted previously.
##
## c: The connection.
##
## is_orig: True if the packet is from the the connection's originator.
##
## total_decrypted: The number of QUIC packets successfully decrypted previously.
global QUIC::discarded_packet: event(c: connection, is_orig: bool, total_decrypted: count);
