/***************************************************************************
 *
 * Copyright (c) 2000-2015 BalaBit IT Ltd, Budapest, Hungary
 * Copyright (c) 2015-2018 BalaSys IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 ***************************************************************************/

#ifndef ZORP_H_INCLUDED
#define ZORP_H_INCLUDED

#ifdef _XOPEN_SOURCE
#undef _XOPEN_SOURCE
#endif

#ifdef _POSIX_C_SOURCE
#undef _POSIX_C_SOURCE
#endif

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wregister"
#include <Python.h>
#pragma GCC diagnostic pop
#include <zorpll/zorplibconfig.h>
#include <glib.h>
#include <zorpll/misc.h>
#include <zorpll/memtrace.h>

#include "zorpconfig.h"


#define ZORP_POLICY_FILE	ZORP_SYSCONFDIR "/policy.py"
#define ZORP_AUTH_CERT_FILE	ZORP_SYSCONFDIR "/zorp.crt"
#define ZORP_AUTH_KEY_FILE	ZORP_SYSCONFDIR "/zorp.key"
#define ZORP_STATE_DIR          ZORP_STATEDIR
#define ZORP_PID_FILE_DIR       ZORP_PIDFILEDIR
#define ZORP_SZIG_SOCKET_NAME      ZORP_PID_FILE_DIR "/zorpctl"
#define ZORP_WORKING_DIR        ZORP_STATEDIR "/cores"

#define MAX_SESSION_ID		128
#define DEADLOCK_CHECKER_DEFAULT_TIMEOUT  60

#define CORE_POLICY    "core.policy"
#define CORE_AUDIT     "core.audit"
#define CORE_VIOLATION "core.violation"

#if SIZEOF_VOID_P == 4
#   define G_GPOINTER_FORMAT "08" G_GSIZE_MODIFIER "x"
#elif SIZEOF_VOID_P == 8
#   define G_GPOINTER_FORMAT "016" G_GSIZE_MODIFIER "x"
#else
#   error "Can't find suitable printf format for pointers"
#endif

extern GMainLoop *main_loop;
extern gint exit_code;
extern gboolean usr1_received;
extern gboolean usr2_received;
extern guint32 startup_id;
extern const gchar *instance_name;
extern const gchar *virtual_instance_name;
extern gboolean zorp_process_master_mode;
extern gboolean is_kzorp_enabled;


void z_main_loop_initiate_reload(gboolean called_from_sighandler);
gboolean z_main_loop_get_last_reload_result(void);

void z_main_loop_initiate_termination(gboolean called_from_sighandler);

void z_main_loop(const gchar *policy_file,
                 const gchar *instance_name,
                 gchar const **instance_policy_list,
                 gchar const *virtual_instance_name,
                 gboolean is_master);
void z_main_loop_quit(int exit_code);
void z_main_loop_init(void);
void z_main_loop_destroy(void);

void z_log_set_fake_session_id(const gchar *instance_name);

gboolean z_main_loop_is_initial_policy_load(void);

#if GLIB_MINOR_VERSION < 8
# define G_GNUC_NULL_TERMINATED
#endif

#if GLIB_MINOR_VERSION < 10
# define G_GNUC_WARN_UNUSED_RESULT
#endif

#endif
