/*****************************************************************************
 *
 * Testmanager - Graphical Automation and Visualisation Tool
 *
 * Copyright (C) 2025  Florian Pose <fp@igh.de>
 *
 * This file is part of Testmanager.
 *
 * Testmanager is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * Testmanager is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with Testmanager. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#pragma once

/****************************************************************************/

#include <QDockWidget>

class MainWindow;

/****************************************************************************/

class DetachedDockWidget: public QDockWidget
{
        Q_OBJECT

    public:
        DetachedDockWidget(MainWindow *);
        DetachedDockWidget() = delete;

        void setAttachOnClose(bool);
        void editModeChanged();

    protected:
        void closeEvent(QCloseEvent *) override;

    private:
        MainWindow *const mainWindow;
        bool attachOnClose;
};

/****************************************************************************/
