/*****************************************************************************
 *
 * Copyright (C) 2009 - 2025  Florian Pose <fp@igh.de>
 *
 * This file is part of the QtPdCom library.
 *
 * The QtPdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The QtPdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the QtPdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#pragma once

#include "Export.h"

#include <QAbstractTableModel>

#include <memory>

namespace QtPdCom {

class MessageModel;
class MessageModelFilter;
class Message;

/****************************************************************************/

/** Table model that combines the rows of multiple MessageModels or
 * MessageModelFilters.
 */
class QTPDCOM_PUBLIC MessageModelUnion: public QAbstractTableModel
{
        Q_OBJECT

    public:
        enum Columns {
            TextColumn = 0,
            TimeOccurredColumn,
            TimeResetColumn,
            SourceColumn
        };
        Q_ENUM(Columns)

        explicit MessageModelUnion(QObject *parent = nullptr);
        virtual ~MessageModelUnion();

        void addSourceModel(QAbstractItemModel *, QString = QString());
        void removeSourceModel(QAbstractItemModel *);

        void clearSourceModels();

        // from QAbstractItemModel
        virtual int rowCount(const QModelIndex &) const override;
        virtual int columnCount(const QModelIndex &) const override;
        virtual QVariant data(const QModelIndex &, int) const override;
        virtual QVariant headerData(int, Qt::Orientation, int) const override;
        virtual Qt::ItemFlags flags(const QModelIndex &) const override;
        virtual bool canFetchMore(const QModelIndex &) const override;
        virtual void fetchMore(const QModelIndex &) override;

    signals:
        /** Emitted, when a new message gets active.
         *
         * This signal announces the most recent message. It is only emitted
         * for the first message getting active, or for a subsequent message
         * with a higher type.
         *
         * In QML, a currentMessage property is available.
         *
         * \param message The message that got active. The signal is emitted
         *                with \a message being \a NULL, if no messages are
         *                active any more.
         */
        void currentMessage(const QtPdCom::Message *message);

    private:
        struct Q_DECL_HIDDEN Impl;
        std::unique_ptr<Impl> impl;
};

/****************************************************************************/

}  // namespace QtPdCom
