#ifndef TEXT_H
#define TEXT_H

#ifdef WITH_NLS
#include <glib/gi18n.h>
#else
#define _(text) (text)
#endif

// common
#define BUTTON_OKAY    _("Okay")
#define ON_HDR         _("on")
#define OFF_HDR        _("off")
#define UNIT_SEC       _("sec")
#define UNIT_MSEC      _("msec")
#define UNIT_USEC      _("usec")
#define UNIT_HEX       _("0x")
#define NODATA_MSG     _("No data")
#define NODATAYET_MSG  _("No data yet")
#define NOREACH_MSG    _("Not reached")
#define NOREACHYET_MSG _("Not reached yet")
#define ACTIONS_HDR    _("Actions")
#define OPTIONS_HDR    _("Options")
#define CLI_HDR        _("CLI")
#define UNKNTYPE_HDR   _("Unknown type")
#define MIN_HDR        _("min")
#define MAX_HDR        _("max")
// graphics
#define NONLS_TIME     "Time"
#define NONLS_DELAY    "Delay"
#define NONLS_HOPS     "Hops"
#define TIME_TITLE     _(NONLS_TIME)
#define DELAY_TITLE    _(NONLS_DELAY)
#define HOPS_TITLE     _(NONLS_HOPS)


// tab names-n-tips
#define PING_TAB_TAG  _("Trace")
#define PING_TAB_TIP  _("Ping path with stats")
#define LOG_TAB_TAG   _("Log")
#define LOG_TAB_TIP   _("Auxiliary logs")
#define GRAPH_TAB_TAG _("Graphs")
#define GRAPH_TAB_TIP _("2D graphs")
#define PLOT_TAB_TAG  _("3D")
#define PLOT_TAB_TIP  _("3D graphics")

// help window
#define HELP_THEME_MAIN  _("Main theme")
#define HELP_THEME_GRAPH _("Graph theme")
#define HELP_THEME_3D    _("3D-plot theme")
#define H_PINGING_HDR    _("pinging")
#define H_DATAUP_HDR     _("data refreshing")
#define H_STATDATA_HDR   _("statistics data")
#define H_EXIT_HDR       _("stop and quit")
#define H_CYCLES_HDR     _("Tracing cycles")
#define H_DARK_S_HDR     _("Dark style")
#define H_LIGHT_S_HDR    _("Light style")
#define H_3DCOLORS_HDR   _("RGB color pairs:")
#define H_ROT_PARAMS_HDR _("Space, Orientation, and Step")
#define H_LOG_MAXROW_HDR _("Max rows in log-tab")
#define H_SEE_TOO_HDR    _("Options are given in " APPNAME "(1) manual page")

// menu tooltips
#define OPT_ACTIONS_TIP  _("Command Menu")
#define OPT_MAINMENU_TIP _("Main Options")
#define OPT_AUXMENU_TIP  _("Auxiliary")

// actions
#define ACT_START_HDR    _("Start")
#define ACT_STOP_HDR     _("Stop")
#define ACT_PAUSE_HDR    _("Pause")
#define ACT_RESUME_HDR   _("Resume")
#define ACT_RESET_HDR    _("Reset")
#define ACT_HELP_HDR     _("Help")
#define ACT_QUIT_HDR     _("Exit")
#define ACT_CLPBRD_HDR   _("Clipoard")
#define ACT_COPY_HDR     _("Copy")
#define ACT_SALL_HDR     _("Select all")
#define ACT_UNSALL_HDR   _("Unselect all")
#define ACT_ACTION_HDR   _("Action")
#define ACT_LGND_HDR     _("Legend")
#define ACT_LEFT_K_HDR   _("Rotate Left")
#define ACT_RIGHT_K_HDR  _("Rotate Right")
#define ACT_UP_K_HDR     _("Rotate Up")
#define ACT_DOWN_K_HDR   _("Rotate Down")
#define ACT_PGUP_K_HDR   _("Rotate Clockwise")
#define ACT_PGDN_K_HDR   _("Rotate AntiClockwise")
#define ACT_IN_K_HDR     _("Zoom In")
#define ACT_OUT_K_HDR    _("Zoom Out")

// general headers
#define TARGET_HDR       _("Target")
#define TARGET_HINT      _("Enter hostname or IP address ...")
#define DATE_HDR         _("Date")

// options
#define OPT_CYCLES_HDR   _("Cycles")
#define OPT_IVAL_HDR     _("Interval")
#define OPT_DNS_HDR      _("DNS")
#define OPT_INFO_HDR     _("Hop Info")
#define OPT_STAT_HDR     _("Statistics")
#define OPT_TTL_HDR      _("TTL")
#define OPT_QOS_HDR      _("QoS")
#define OPT_PLOAD_HDR    _("Payload")
#define OPT_PSIZE_HDR    _("Size")
#define OPT_IPV_HDR      _("IP Version")
#define OPT_IPVA_HDR     _("Auto")
#define OPT_IPV4_HDR     _("IPv4")
#define OPT_IPV6_HDR     _("IPv6")

#define OPT_MN_DARK_HDR  _("Main dark theme")
#define OPT_GR_DARK_HDR  _("Graph dark theme")
#define OPT_PL_DARK_HDR  _("3D-plot dark theme")
#define OPT_GRAPH_HDR    _("Graph type")
#define OPT_GR_DOT_HDR   _("Dots")
#define OPT_GR_LINE_HDR  _("Lines")
#define OPT_GR_CURVE_HDR _("Splines")
#define OPT_LGND_HDR     _("Graph legend")
#define OPT_GRLG_HDR     _("Legend fields")
#define OPT_GREX_HDR     _("Extra graph elements")
#define OPT_PLOT_HDR     _("Plot elements")
#define OPT_PLEX_HDR     _("Plot parameters")
#define OPT_GRAD_HDR     _("Plot gradient")
#define OPT_GLOB_HDR     _("Global space")
#define OPT_LOCAL_HDR    _("Local space")
#define OPT_ROTOR_HDR    _("Plot rotation")
#define OPT_SCALE_HDR    _("Plot scale")
#define OPT_FOV_HDR      _("Field of view")
#define OPT_LOGMAX_HDR   _("LogTab rows")

// statistic elements and their tooltips
#define ELEM_HOST_HDR    _("Host")
#define ELEM_HOST_HEADER _("_Host")
#define ELEM_HOST_TIP    _("Hostname or IP-address")
#define ELEM_AS_HDR      _("AS")
#define ELEM_AS_HEADER   _("AS Number")
#define ELEM_AS_TIP      _("Autonomous System")
#define ELEM_CC_HDR      _("CC")
#define ELEM_CC_HEADER   _("Country Code")
#define ELEM_CC_TIP      _("Registrant Country Code")
#define ELEM_DESC_HDR    _("Desc")
#define ELEM_DESC_HEADER _("Description")
#define ELEM_DESC_TIP    _("Short description in free form")
#define ELEM_RT_HDR      _("Network")
#define ELEM_RT_TIP      _("Network prefix")
#define ELEM_LOSS_HDR    _("Loss")
#define ELEM_LOSS_HEADER _("Lost")
#define ELEM_LOSS_TIP    _("Loss in percentage")
#define ELEM_SENT_HDR    _("Sent")
#define ELEM_SENT_HEADER _("_Sent")
#define ELEM_SENT_TIP    _("Number of pings sent")
#define ELEM_RECV_HDR    _("Recv")
#define ELEM_RECV_HEADER _("Received")
#define ELEM_RECV_TIP    _("Number of pongs received")
#define ELEM_LAST_HDR    _("Last")
#define ELEM_LAST_HEADER _("_Last")
#define ELEM_LAST_TIP    _("Last delay in milliseconds")
#define ELEM_BEST_HDR    _("Best")
#define ELEM_BEST_HEADER _("_Best")
#define ELEM_BEST_TIP    _("Best delay in milliseconds")
#define ELEM_WRST_HDR    _("Wrst")
#define ELEM_WRST_HEADER _("Worst")
#define ELEM_WRST_TIP    _("Worst delay in milliseconds")
#define ELEM_AVRG_HDR    _("Avrg")
#define ELEM_AVRG_HEADER _("Average")
#define ELEM_AVRG_TIP    _("Average delay in milliseconds")
#define ELEM_JTTR_HDR    _("Jttr")
#define ELEM_JTTR_HEADER _("Jitter")
#define ELEM_JTTR_TIP    _("Jitter (variation in delay)")

// 2D-graphs elements
#define GRLG_DASH_HDR    _("Color")
#define GRLG_DASH_HEADER _("Color dash")
#define GRLG_AVJT_HDR    _("RTT±Jitter")
#define GRLG_AVJT_HEADER _("Average RTT ± Jitter")
#define GRLG_CCAS_HDR    _("CC:ASN")
#define GRLG_CCAS_HEADER _("Country Code : AS Number")
#define GRLG_LGHN_HDR    _("Hopname")
#define GRLG_LGHN_HEADER _("_Hopname")
//
#define GREX_MEAN_HDR    _("Midline")
#define GREX_MEAN_HEADER _("Average line")
#define GREX_JRNG_HDR    _("Scopes")
#define GREX_JRNG_HEADER _("Jitter range")
#define GREX_AREA_HDR    _("JArea")
#define GREX_AREA_HEADER _("Jitter area")

// 3D-graphics elements
#define PLEL_BACK_HDR    _("Backsides")
#define PLEL_AXIS_HDR    _("Axes")
#define PLEL_GRID_HDR    _("Grid on surface")
#define PLEL_ROTR_HDR    _("Rotator")

// spinner fields
#define SPN_TTL_DELIM  _("range")
#define SPN_RCOL_DELIM _("red")
#define SPN_GCOL_DELIM _("green")
#define SPN_BCOL_DELIM _("blue")
//
#define PLOT_GRAD_COLR _("Plot red gradient")
#define PLOT_GRAD_COLG _("Plot green gradient")
#define PLOT_GRAD_COLB _("Plot blue gradient")

// 3D-rotation parameters
#define ORIENT_HDR    _("Orientation")
#define ROT_ROLL      _("Roll")
#define ROT_PITCH     _("Pitch")
#define ROT_YAW       _("Yaw")
#define ROT_AXES      _("Rotation")
#define ROT_ANGLE_X   _("Axis X")
#define ROT_ANGLE_Y   _("Axis Y")
#define ROT_ANGLE_Z   _("Axis Z")
#define ROT_STEP      _("Angular step")

// CLI option help
#define CLI_FOPT_DESC _("Get options from file")
#define CLI_NOPT_DESC _("IP addresses in numeric form")
#define CLI_IOPT_DESC _("Interval between pings")
#define CLI_TTL_DESC  _("TTL range")
#define CLI_QOS_DESC  _("QoS/ToS byte")
#define CLI_SIZE_DESC _("ICMP payload size")
#define CLI_POPT_DESC _("Payload in hex notation")
#define CLI_STAT_DESC _("Statistics fields")
#define CLI_TOPT_DESC _("Toggle dark/light themes")
#define CLI_SUMM_DESC _("Summary at exit")
#define CLI_SUMM_TCJ  _("Text, CSV, or JSON")
#define CLI_SUMM_TC   _("Text, CSV")
#define CLI_ROPT_DESC _("Autostart")
#define CLI_AOPT_DESC _("Initial active tab")
#define CLI_VERB_DESC _("More detailed messaging")
#define CLI_VERS_DESC _("Build features and runtime lib versions")
#define CLI_1D_DESC   _("Without graphics")
#define CLI_2D_DESC   _("Without 3D graphics")

// CLI option hints
#define CLI_FOPT_HINT _("<filepath>")
#define CLI_COPT_HINT _("<number>")
#define CLI_IOPT_HINT _("<seconds>")
#define CLI_TTL_HINT  _("[min][,max]")
#define CLI_BITS_HINT _("<bits>")
#define CLI_SIZE_HINT _("<in-bytes>")
#define CLI_POPT_HINT _("<upto-16-bytes>")
#define CLI_XOPT_HINT _("<tag:values>")
#define CLI_VOPT_HINT _("<6bit-level>")

// CLI misc messages
#define CLI_NOMATCH_HDR _("No match")
#define CLI_NOPARSE_HDR _("Cannot parse")
#define CLI_DUPTAG_HDR  _("Tag duplicate")
#define CLI_NOPAIR_HDR  _("Wrong pair")
#define CLI_NDXDIFF_HDR _("Different number of indexes")
#define CLI_ROPT_T_HDR  _("Text")
#define CLI_ROPT_C_HDR  _("CSV")
#define CLI_ROPT_J_HDR  _("JSON")
#define CLI_TOPT_HDR    _("Theme bits")
#define CLI_MUT_EXC_HDR _("Mutually exclusive options")
#define CLI_APPFEAT_HDR _("Build features")
#define CLI_LIBVER_HDR  _("Runtime lib versions")
#define CLI_SKIPARG_HDR _("Skipping extra")
#define CLI_BADOPT_HDR  _("Unknown option")
#define CLI_NOGOAL_HDR  _("No goal")
#define CLI_RECAP_HDR   _("Non-interactive mode with summary at exit")

// misc
#define PING_HDR        _("Ping")
#define HOP_HDR         _("hop")
#define UNKN_HDR        _("unknown")
#define INFO_HDR        _("Info")
#define PINGS_DONE_HDR  _("Pings completed")
#define DONE_HDR        _("completed")
#define ATEXIT_HDR      _("at exit")
#define UNKN_ERR        _("Unknown error")
#define ERROR_HDR       _("ERROR")
#define BADTAG_HDR      _("Wrong tag")
#define INVAL_HDR       _("Invalid value")
#define NOVAL_HDR       _("No value")
#define PROC_EXP_HDR    _("Process is still active after expire time, stopping ...")
#define PROC_NOSTOP_ERR _("Subprocess has not stopped")
#define EXPTIME_HDR     _("expiration time")
#define RUNTIME_EXP     _("time's up")
#define INP_FAILED      _("stdin failed")
#define RELRES_HDR      _("release resources")
#define STOPPID_HDR     _("Stop process")
#define EOF_HDR         _("finish")
#define BYREQ_HDR       _("by request")
#define VISROWS_HDR     _("Visible rows")
#define UPTO_HDR        _("upto")
#define SYNC_FRWD_HDR   _("Sync forward")
#define SYNC_BACK_HDR   _("Sync backward")

#define SNAPBOX_HINT _("Snap container related:\n" \
  "if minimal ping's slot (network-observe) is not autoconnected (permission denied),\n" \
  "it can be connected with the following command:\n" \
  "  snap connect pingpath:network-observe :network-observe")

// logging, warnings
#define DNS_HDR       _("DNS:")
#define WHOIS_HDR     _("WHOIS:")
#define CONFIG_HDR    _("CONFIG:")
#define PARSE_SUCCESS _("SUCCESS")
#define PARSE_DISCARD _("DISCARD")
#define PARSE_TIMEOUT _("TIMEOUT")
#define PARSE_INFO    _("INFO")
#define PARSE_UNKN    _("UNKNOWN")
#define NDX_HDR       _("ndx")  /* index */
#define ADDR_HDR      _("addr") /* address */
#define NAME_HDR      _("name") /* hostname */
#define SEQ_HDR       _("seq")  /* icmp seq */
#define TTL_HDR       _("ttl")
#define DELAY_HDR     _("delay")
#define TIMESTAMP_HDR _("timestamp")
#define INFOSTAMP_HDR _("info")
#define REASON_HDR    _("reason")
#define REGEX_HDR     _("regex")
#define PATT_HDR      _("PATTERN")
#define HOSTNAME_HDR  _("Hostname")
#define OVERLEN_HDR   _("Out of length limit")
#define ENDHYPEN_ERR  _("Cannot end with hyphen")
#define STARTCHAR_ERR _("Must start with a letter or a digit")
#define INVALCHAR_ERR _("Contains not allowed characters")
#define RENOMATCH_ERR _("No regex match")
#define WRONGCAT_ERR  _("Wrong category")
#define OUTRANGE_ERR  _("Out of range")
#define INITFAIL_ERR  _("Init failed")
#define NOICON_ERR    _("No icon")
#define NOSLOTS_ERR   _("No free slots")
#define SKIPDUP_HDR   _("skip duplicates")
#define DNS_CUP_HDR   _("DNS cache update")
#define HOST_CUP_HDR  _("Host cache update")
#define WHOIS_CUP_HDR _("Whois cache update")
#define EMPTY_HDR     _("<empty>")
#define REACHED_HDR   _("Target is reached")
#define AFTER_TGT_HDR _("behind the target")
#define UNREACH_HDR   _("unreachable")
#define ORIG_CHNG_HDR _("Origin changed")
#define CACHE_HIT_HDR _("Cache hit")
#define SENDQ_HDR     _("Send query")
#define SAVEQ_HDR     _("Save query")
#define LOOKUP_HDR    _("Lookup")
#define UNRES_HDR     _("Unresolved")
#define NOBUFF_ERR    _("No space in buffer")
#define NOCONN_ERR    _("Connection failed")
#define LEGEND_TIP    _("show/hide graph")
#define LEGEND_EXCL   _("Graph exclusion mask")
#define DEB_DND       _("DND")
#define DEB_REORDER   _("REORDER")
#define ARRAY_HDR     _("array")
#define GROUP_HDR     _("group")
#define RDR_PART_ERR  _("partial reordering")
#define BEFORE_HDR    _("before")
#define AFTER_HDR     _("after")
#define CLIPBOARD_HDR _("clipboard")
#define SHADER_LOOKUP_HDR _("Vertex shader texture lookups")
#define REQUESTED_HDR _("requested")
#define RECEIVED_HDR  _("received")
#define INCOMPATV_HDR _("Incompat version")
#define TABLE_HDR     _("table")

#define ABETKA    "__abetka__"
#define ABETKA_NLS _(ABETKA)

#endif
