// Two cubes sharing an edge,
// but with a manifold topology (the coincident vertices are distinct).
minkowski() {
  polyhedron(
    points=[
      [0, 0, 0],
      [1, 0, 0],
      [0, 1, 0],
      [1, 1, 0],
      [0, 0, 1],
      [1, 0, 1],
      [0, 1, 1],
      [1, 1, 1],

      [1, 1, 0],
      [2, 1, 0],
      [1, 2, 0],
      [2, 2, 0],
      [1, 1, 1],
      [2, 1, 1],
      [1, 2, 1],
      [2, 2, 1],
    ],
    faces=[
      [6,7,5],[6,5,4],
      [0,1,3],[0,3,2],
      [4,5,1],[4,1,0],
      [5,7,3],[5,3,1],
      [7,6,2],[7,2,3],
      [6,4,0],[6,0,2],

      [14,15,13],[14,13,12],
      [8,9,11],[8,11,10],
      [12,13,9],[12,9,8],
      [13,15,11],[13,11,9],
      [15,14,10],[15,10,11],
      [14,12,8],[14,8,10],
    ]);
  sphere(0.1, $fn=8);
}