#include <vsg/io/VSG.h>
static auto lz = []() {
    std::istringstream str(
        R"(#vsga 0.4.3
Root id=1 vsg::MatrixTransform
{
  userObjects 1
  key "Name"
  object id=2 vsg::stringValue
  {
    userObjects 0
    Layout 0 0 0 1 1 1 0 -1
    Value "saved_model.osg"
  }
  children 3
  vsg::Node id=3 vsg::MatrixTransform
  {
    userObjects 0
    children 8
    vsg::Node id=4 vsg::Group
    {
      userObjects 0
      children 15
      vsg::Node id=5 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.7769 -0.8972 1.89821 0.156205
        child id=6 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=7 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=8 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=9 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=10 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=11 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.7769 -0.8972 1.77821
            }
            Indices id=12 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13 vsg::BindGraphicsPipeline
          {
            userObjects 0
            slot 0
            pipeline id=14 vsg::GraphicsPipeline
            {
              userObjects 0
              layout id=15 vsg::PipelineLayout
              {
                userObjects 0
                flags 0
                setLayouts 1
                descriptorLayout id=16 vsg::DescriptorSetLayout
                {
                  userObjects 0
                  bindings 1
                  binding 0
                  descriptorType 1
                  descriptorCount 1
                  stageFlags 16
                }
                pushConstantRanges 1
                stageFlags 1
                offset 0
                size 128
              }
              stages 2
              vsg::ShaderStage id=17 vsg::ShaderStage
              {
                userObjects 0
                stage 1
                entryPointName "main"
                module id=18 vsg::ShaderModule
                {
                  userObjects 0
                  hints id=0
                  source "#version 450
#pragma import_defines ( VSG_NORMAL, VSG_TANGENT, VSG_COLOR, VSG_TEXCOORD0, VSG_LIGHTING, VSG_NORMAL_MAP, VSG_BILLBOARD, VSG_TRANSLATE )
#define VSG_COLOR
#define VSG_TEXCOORD0
#define VSG_BILLBOARD
#define VSG_TRANSLATE
#extension GL_ARB_separate_shader_objects : enable
layout(push_constant) uniform PushConstants {
    mat4 projection;
    mat4 modelView;
    //mat3 normal;
} pc;
layout(location = 0) in vec3 osg_Vertex;
#ifdef VSG_NORMAL
layout(location = 1) in vec3 osg_Normal;
layout(location = 1) out vec3 normalDir;
#endif
#ifdef VSG_TANGENT
layout(location = 2) in vec4 osg_Tangent;
#endif
#ifdef VSG_COLOR
layout(location = 3) in vec4 osg_Color;
layout(location = 3) out vec4 vertColor;
#endif
#ifdef VSG_TEXCOORD0
layout(location = 4) in vec2 osg_MultiTexCoord0;
layout(location = 4) out vec2 texCoord0;
#endif
#ifdef VSG_LIGHTING
layout(location = 5) out vec3 viewDir;
layout(location = 6) out vec3 lightDir;
#endif
#ifdef VSG_TRANSLATE
layout(location = 7) in vec3 translate;
#endif


out gl_PerVertex{ vec4 gl_Position; };

void main()
{
    mat4 modelView = pc.modelView;

#ifdef VSG_TRANSLATE
    mat4 translate_mat = mat4(1.0, 0.0, 0.0, 0.0,
                              0.0, 1.0, 0.0, 0.0,
                              0.0, 0.0, 1.0, 0.0,
                              translate.x,  translate.y,  translate.z, 1.0);

    modelView = modelView * translate_mat;
#endif

#ifdef VSG_BILLBOARD
    vec3 lookDir = vec3(-modelView[0][2], -modelView[1][2], -modelView[2][2]);

    // rotate around local z axis
    float l = length(lookDir.xy);
    if (l>0.0)
    {
        float inv = 1.0/l;
        float c = lookDir.y * inv;
        float s = lookDir.x * inv;

        mat4 rotation_z = mat4(c,   -s,  0.0, 0.0,
                               s,   c,   0.0, 0.0,
                               0.0, 0.0, 1.0, 0.0,
                               0.0, 0.0, 0.0, 1.0);

        modelView = modelView * rotation_z;
    }
#endif

    gl_Position = (pc.projection * modelView) * vec4(osg_Vertex, 1.0);

#ifdef VSG_TEXCOORD0
    texCoord0 = osg_MultiTexCoord0.st;
#endif
#ifdef VSG_NORMAL
    vec3 n = (modelView * vec4(osg_Normal, 0.0)).xyz;
    normalDir = n;
#endif
#ifdef VSG_LIGHTING
    vec4 lpos = /*osg_LightSource.position*/ vec4(0.0, 0.25, 1.0, 0.0);
#ifdef VSG_NORMAL_MAP
    vec3 t = (modelView * vec4(osg_Tangent.xyz, 0.0)).xyz;
    vec3 b = cross(n, t);
    vec3 dir = -vec3(modelView * vec4(osg_Vertex, 1.0));
    viewDir.x = dot(dir, t);
    viewDir.y = dot(dir, b);
    viewDir.z = dot(dir, n);
    if (lpos.w == 0.0)
        dir = lpos.xyz;
    else
        dir += lpos.xyz;
    lightDir.x = dot(dir, t);
    lightDir.y = dot(dir, b);
    lightDir.z = dot(dir, n);
#else
    viewDir = -vec3(modelView * vec4(osg_Vertex, 1.0));
    if (lpos.w == 0.0)
        lightDir = lpos.xyz;
    else
        lightDir = lpos.xyz + viewDir;
#endif
#endif
#ifdef VSG_COLOR
    vertColor = osg_Color;
#endif
}

"
                  code 786
                   119734787 65536 524298 121 0 131089 1 393227 1 1280527431 1685353262 808793134
                   0 196622 0 1 786447 0 4 1852399981 0 24 98 103
                   113 115 117 119 196611 2 450 589828 1096764487 1935622738 1918988389 1600484449
                   1684105331 1868526181 1667590754 29556 262149 4 1852399981 0 327685 10 1701080941 1701402220
                   119 393221 11 1752397136 1936617283 1953390964 115 393222 11 0 1785688688 1769235301
                   28271 393222 11 1 1701080941 1701402220 119 196613 13 25456 393221 19
                   1851880052 1952541811 1634557797 116 327685 24 1851880052 1952541811 101 262149 45 1802465132
                   7498052 196613 59 108 196613 69 7761513 196613 72 99 196613 77
                   115 327685 82 1635020658 1852795252 31327 393221 96 1348430951 1700164197 2019914866 0
                   393222 96 0 1348430951 1953067887 7237481 196613 98 0 327685 103 1600615279
                   1953654102 30821 327685 113 1131963764 1685221231 48 458757 115 1600615279 1953264973 2019906665
                   1919905603 12388 327685 117 1953654134 1869377347 114 327685 119 1600615279 1869377347 114
                   262216 11 0 5 327752 11 0 35 0 327752 11 0
                   7 16 262216 11 1 5 327752 11 1 35 64 327752
                   11 1 7 16 196679 11 2 262215 24 30 7 327752
                   96 0 11 0 196679 96 2 262215 103 30 0 262215
                   113 30 4 262215 115 30 4 262215 117 30 3 262215
                   119 30 3 131091 2 196641 3 2 196630 6 32 262167
                   7 6 4 262168 8 7 4 262176 9 7 8 262174
                   11 8 8 262176 12 9 11 262203 12 13 9 262165
                   14 32 1 262187 14 15 1 262176 16 9 8 262187
                   6 20 1065353216 262187 6 21 0 262167 22 6 3 262176
                   23 1 22 262203 23 24 1 262165 25 32 0 262187
                   25 26 0 262176 27 1 6 262187 25 30 1 262187
                   25 33 2 262176 44 7 22 262187 14 46 0 262176
                   47 7 6 262187 14 54 2 262167 60 6 2 131092
                   65 196638 96 7 262176 97 3 96 262203 97 98 3
                   262203 23 103 1 262176 110 3 7 262176 112 3 60
                   262203 112 113 3 262176 114 1 60 262203 114 115 1
                   262203 110 117 3 262176 118 1 7 262203 118 119 1
                   327734 2 4 0 3 131320 5 262203 9 10 7 262203
                   9 19 7 262203 44 45 7 262203 47 59 7 262203
                   47 69 7 262203 47 72 7 262203 47 77 7 262203
                   9 82 7 327745 16 17 13 15 262205 8 18 17
                   196670 10 18 327745 27 28 24 26 262205 6 29 28
                   327745 27 31 24 30 262205 6 32 31 327745 27 34
                   24 33 262205 6 35 34 458832 7 36 20 21 21
                   21 458832 7 37 21 20 21 21 458832 7 38 21
                   21 20 21 458832 7 39 29 32 35 20 458832 8
                   40 36 37 38 39 196670 19 40 262205 8 41 10
                   262205 8 42 19 327826 8 43 41 42 196670 10 43
                   393281 47 48 10 46 33 262205 6 49 48 262271 6
                   50 49 393281 47 51 10 15 33 262205 6 52 51
                   262271 6 53 52 393281 47 55 10 54 33 262205 6
                   56 55 262271 6 57 56 393296 22 58 50 53 57
                   196670 45 58 262205 22 61 45 458831 60 62 61 61
                   0 1 393228 6 63 1 66 62 196670 59 63 262205
                   6 64 59 327866 65 66 64 21 196855 68 0 262394
                   66 67 68 131320 67 262205 6 70 59 327816 6 71
                   20 70 196670 69 71 327745 47 73 45 30 262205 6
                   74 73 262205 6 75 69 327813 6 76 74 75 196670
                   72 76 327745 47 78 45 26 262205 6 79 78 262205
                   6 80 69 327813 6 81 79 80 196670 77 81 262205
                   6 83 72 262205 6 84 77 262271 6 85 84 262205
                   6 86 77 262205 6 87 72 458832 7 88 83 85
                   21 21 458832 7 89 86 87 21 21 458832 7 90
                   21 21 20 21 458832 7 91 21 21 21 20 458832
                   8 92 88 89 90 91 196670 82 92 262205 8 93
                   10 262205 8 94 82 327826 8 95 93 94 196670 10
                   95 131321 68 131320 68 327745 16 99 13 46 262205 8
                   100 99 262205 8 101 10 327826 8 102 100 101 262205
                   22 104 103 327761 6 105 104 0 327761 6 106 104
                   1 327761 6 107 104 2 458832 7 108 105 106 107
                   20 327825 7 109 102 108 327745 110 111 98 46 196670
                   111 109 262205 60 116 115 196670 113 116 262205 7 120
                   119 196670 117 120 65789 65592
                }
                NumSpecializationConstants 0
              }
              vsg::ShaderStage id=19 vsg::ShaderStage
              {
                userObjects 0
                stage 16
                entryPointName "main"
                module id=20 vsg::ShaderModule
                {
                  userObjects 0
                  hints id=0
                  source "#version 450
#pragma import_defines ( VSG_NORMAL, VSG_COLOR, VSG_TEXCOORD0, VSG_LIGHTING, VSG_MATERIAL, VSG_DIFFUSE_MAP, VSG_OPACITY_MAP, VSG_AMBIENT_MAP, VSG_NORMAL_MAP, VSG_SPECULAR_MAP )
#define VSG_COLOR
#define VSG_TEXCOORD0
#define VSG_DIFFUSE_MAP
#extension GL_ARB_separate_shader_objects : enable
#ifdef VSG_DIFFUSE_MAP
layout(binding = 0) uniform sampler2D diffuseMap;
#endif
#ifdef VSG_OPACITY_MAP
layout(binding = 1) uniform sampler2D opacityMap;
#endif
#ifdef VSG_AMBIENT_MAP
layout(binding = 4) uniform sampler2D ambientMap;
#endif
#ifdef VSG_NORMAL_MAP
layout(binding = 5) uniform sampler2D normalMap;
#endif
#ifdef VSG_SPECULAR_MAP
layout(binding = 6) uniform sampler2D specularMap;
#endif

#ifdef VSG_MATERIAL
layout(binding = 10) uniform MaterialData
{
    vec4 ambientColor;
    vec4 diffuseColor;
    vec4 specularColor;
    float shininess;
} material;
#endif

#ifdef VSG_NORMAL
layout(location = 1) in vec3 normalDir;
#endif
#ifdef VSG_COLOR
layout(location = 3) in vec4 vertColor;
#endif
#ifdef VSG_TEXCOORD0
layout(location = 4) in vec2 texCoord0;
#endif
#ifdef VSG_LIGHTING
layout(location = 5) in vec3 viewDir;
layout(location = 6) in vec3 lightDir;
#endif
layout(location = 0) out vec4 outColor;

void main()
{
#ifdef VSG_DIFFUSE_MAP
    vec4 base = texture(diffuseMap, texCoord0.st);
#else
    vec4 base = vec4(1.0,1.0,1.0,1.0);
#endif
#ifdef VSG_COLOR
    base = base * vertColor;
#endif
#ifdef VSG_MATERIAL
    vec3 ambientColor = material.ambientColor.rgb;
    vec3 diffuseColor = material.diffuseColor.rgb;
    vec3 specularColor = material.specularColor.rgb;
    float shininess = material.shininess;
#else
    vec3 ambientColor = vec3(0.1,0.1,0.1);
    vec3 diffuseColor = vec3(1.0,1.0,1.0);
    vec3 specularColor = vec3(0.3,0.3,0.3);
    float shininess = 16.0;
#endif
#ifdef VSG_AMBIENT_MAP
    ambientColor *= texture(ambientMap, texCoord0.st).r;
#endif
#ifdef VSG_SPECULAR_MAP
    specularColor = texture(specularMap, texCoord0.st).rrr;
#endif
#ifdef VSG_LIGHTING
#ifdef VSG_NORMAL_MAP
    vec3 nDir = texture(normalMap, texCoord0.st).xyz*2.0 - 1.0;
    nDir.g = -nDir.g;
#else
    vec3 nDir = normalDir;
#endif
    vec3 nd = normalize(nDir);
    vec3 ld = normalize(lightDir);
    vec3 vd = normalize(viewDir);
    vec4 color = vec4(0.01, 0.01, 0.01, 1.0);
    color.rgb += ambientColor;
    float diff = max(dot(ld, nd), 0.0);
    color.rgb += diffuseColor * diff;
    color *= base;
    if (diff > 0.0)
    {
        vec3 halfDir = normalize(ld + vd);
        color.rgb += base.a * specularColor *
            pow(max(dot(halfDir, nd), 0.0), shininess);
    }
#else
    vec4 color = base;
    color.rgb *= diffuseColor;
#endif
    outColor = color;
#ifdef VSG_OPACITY_MAP
    outColor.a *= texture(opacityMap, texCoord0.st).r;
#endif
    if (outColor.a==0.0) discard;
}

"
                  code 431
                   119734787 65536 524298 68 0 131089 1 393227 1 1280527431 1685353262 808793134
                   0 196622 0 1 524303 4 4 1852399981 0 17 22 56
                   196624 4 7 196611 2 450 589828 1096764487 1935622738 1918988389 1600484449 1684105331
                   1868526181 1667590754 29556 262149 4 1852399981 0 262149 9 1702060386 0 327685
                   13 1717987684 1298494325 28769 327685 17 1131963764 1685221231 48 327685 22 1953654134
                   1869377347 114 393221 27 1768058209 1131703909 1919904879 0 393221 30 1717987684 1130722165
                   1919904879 0 393221 33 1667592307 1918987381 1869377347 114 327685 37 1852401779 1936027241
                   115 262149 39 1869377379 114 327685 56 1131705711 1919904879 0 262215 13
                   34 0 262215 13 33 0 262215 17 30 4 262215 22
                   30 3 262215 56 30 0 131091 2 196641 3 2 196630
                   6 32 262167 7 6 4 262176 8 7 7 589849 10
                   6 1 0 0 0 1 0 196635 11 10 262176 12
                   0 11 262203 12 13 0 262167 15 6 2 262176 16
                   1 15 262203 16 17 1 262176 21 1 7 262203 21
                   22 1 262167 25 6 3 262176 26 7 25 262187 6
                   28 1036831949 393260 25 29 28 28 28 262187 6 31 1065353216
                   393260 25 32 31 31 31 262187 6 34 1050253722 393260 25
                   35 34 34 34 262176 36 7 6 262187 6 38 1098907648
                   262165 45 32 0 262187 45 46 0 262187 45 49 1
                   262187 45 52 2 262176 55 3 7 262203 55 56 3
                   262187 45 58 3 262176 59 3 6 262187 6 62 0
                   131092 63 327734 2 4 0 3 131320 5 262203 8 9
                   7 262203 26 27 7 262203 26 30 7 262203 26 33
                   7 262203 36 37 7 262203 8 39 7 262205 11 14
                   13 262205 15 18 17 327767 7 19 14 18 196670 9
                   19 262205 7 20 9 262205 7 23 22 327813 7 24
                   20 23 196670 9 24 196670 27 29 196670 30 32 196670
                   33 35 196670 37 38 262205 7 40 9 196670 39 40
                   262205 25 41 30 262205 7 42 39 524367 25 43 42
                   42 0 1 2 327813 25 44 43 41 327745 36 47
                   39 46 327761 6 48 44 0 196670 47 48 327745 36
                   50 39 49 327761 6 51 44 1 196670 50 51 327745
                   36 53 39 52 327761 6 54 44 2 196670 53 54
)"
        R"(                   262205 7 57 39 196670 56 57 327745 59 60 56 58
                   262205 6 61 60 327860 63 64 61 62 196855 66 0
                   262394 64 65 66 131320 65 65788 131320 66 65789 65592
                }
                NumSpecializationConstants 0
              }
              pipelineStates 6
              vsg::GraphicsPipelineState id=21 vsg::VertexInputState
              {
                userObjects 0
                NumBindings 4
                binding 0
                stride 12
                inputRate 0
                binding 1
                stride 16
                inputRate 1
                binding 2
                stride 8
                inputRate 0
                binding 3
                stride 12
                inputRate 1
                NumAttributes 4
                location 0
                binding 0
                format 106
                offset 0
                location 3
                binding 1
                format 109
                offset 0
                location 4
                binding 2
                format 103
                offset 0
                location 7
                binding 3
                format 106
                offset 0
              }
              vsg::GraphicsPipelineState id=22 vsg::InputAssemblyState
              {
                userObjects 0
                topology 3
                primitiveRestartEnable 0
              }
              vsg::GraphicsPipelineState id=23 vsg::RasterizationState
              {
                userObjects 0
                depthClampEnable 0
                rasterizerDiscardEnable 0
                polygonMode 0
                cullMode 2
                frontFace 0
                depthBiasEnable 0
                depthBiasConstantFactor 1
                depthBiasClamp 0
                depthBiasSlopeFactor 1
                lineWidth 1
              }
              vsg::GraphicsPipelineState id=24 vsg::MultisampleState
              {
                userObjects 0
                rasterizationSamples 1
                sampleShadingEnable 0
                minSampleShading 0
                NumSampleMask 0
                alphaToCoverageEnable 0
                alphaToOneEnable 0
              }
              vsg::GraphicsPipelineState id=25 vsg::ColorBlendState
              {
                userObjects 0
                logicOp 3
                logicOpEnable 0
                NumColorBlendAttachments 1
                blendEnable 1
                srcColorBlendFactor 6
                dstColorBlendFactor 7
                colorBlendOp 0
                srcAlphaBlendFactor 1
                dstAlphaBlendFactor 0
                alphaBlendOp 0
                colorWriteMask 15
                blendConstants 0 0 0 0
              }
              vsg::GraphicsPipelineState id=26 vsg::DepthStencilState
              {
                userObjects 0
                depthTestEnable 1
                depthWriteEnable 1
                depthCompareOp 4
                depthBoundsTestEnable 0
                stencilTestEnable 0
                front.failOp 0
                front.passOp 0
                front.depthFailOp 0
                front.compareOp 0
                front.compareMask 0
                front.writeMask 0
                front.reference 0
                back.failOp 0
                back.passOp 0
                back.depthFailOp 0
                back.compareOp 0
                back.compareMask 0
                back.writeMask 0
                back.reference 0
                minDepthBounds 0
                maxDepthBounds 1
              }
              subpass 0
            }
          }
          vsg::StateCommand id=27 vsg::BindDescriptorSet
          {
            userObjects 0
            slot 1
            layout id=15
            firstSet 0
            descriptorSet id=28 vsg::DescriptorSet
            {
              userObjects 0
              setLayout id=16
              descriptors 1
              vsg::Descriptor id=29 vsg::DescriptorImage
              {
                userObjects 0
                dstBinding 0
                dstArrayElement 0
                images 1
                sampler id=30 vsg::Sampler
                {
                  flags 0
                  minFilter 1
                  magFilter 1
                  mipmapMode 1
                  addressModeU 2
                  addressModeV 2
                  addressModeW 2
                  mipLodBias 0
                  anisotropyEnable 0
                  maxAnisotropy 1
                  compareEnable 0
                  compareOp 0
                  minLod 0
                  maxLod 8
                  borderColor 1
                  unnormalizedCoordinates 0
                }
                image id=31 vsg::ubvec4Array2D
                {
                  userObjects 0
                  Layout 37 4 1 1 1 1 2 -1
                  width 128
                  height 128
                  storage id=0
                  data 0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 3 1 0 0 10 6 3 0
                   11 7 2 0 19 8 1 0 23 8 0 255
                   18 7 0 255 6 2 0 255 1 0 0 255
                   0 0 0 255 1 0 0 255 2 1 0 255
                   9 3 0 255 23 8 0 255 23 8 0 255
                   23 14 6 255 5 6 3 0 6 7 3 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 8 7 3 0 9 7 4 0
                   6 9 4 0 15 8 3 255 11 4 1 255
                   8 3 0 255 4 2 0 255 1 0 0 255
                   1 0 0 255 9 4 0 255 20 7 0 255
                   22 8 0 255 17 11 1 255 7 6 2 255
                   5 6 3 0 5 6 3 0 6 7 3 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   6 7 3 0 8 7 2 0 8 7 3 0
                   11 9 3 0 7 3 1 255 8 3 1 255
                   8 3 0 255 2 1 0 255 5 2 0 255
                   15 6 1 255 16 7 1 255 20 8 0 255
                   17 8 1 255 5 7 3 0 5 7 3 0
                   5 6 3 0 6 7 3 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 6 7 4 0
                   8 7 3 0 8 7 3 0 6 7 4 0
                   12 6 0 255 14 5 0 255 13 4 0 255
                   4 2 0 255 5 3 0 255 14 5 1 255
                   10 5 3 255 18 8 2 255 16 7 2 255
                   6 7 3 0 6 7 3 0 5 7 3 0
                   6 7 4 0 6 9 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 6 7 4 0 6 7 4 0
                   10 6 3 0 10 6 3 0 15 7 0 0
                   17 6 0 255 17 6 0 255 10 4 0 255
                   6 2 0 255 9 4 0 255 15 7 1 255
                   14 7 3 255 13 8 3 0 6 7 4 0
                   6 7 4 0 6 7 3 0 6 7 3 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 6 7 4 0 10 6 3 0
                   10 6 3 0 9 6 3 0 13 5 1 255
                   15 6 0 255 16 6 0 255 13 4 0 255
                   12 4 0 255 15 6 0 255 17 7 1 255
                   16 7 1 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
)"
        R"(                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   9 8 4 0 9 8 4 0 6 7 4 0
                   8 7 3 0 13 6 1 255 8 3 0 255
                   13 4 0 255 18 6 0 255 13 5 0 255
                   15 6 0 255 19 8 0 255 17 7 0 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 4 2 0 0
                   9 8 4 0 6 7 4 0 18 7 1 0
                   19 8 1 255 8 3 0 255 12 4 0 255
                   7 3 0 255 6 2 0 255 20 8 0 255
                   17 8 0 255 12 7 1 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 6 7 4 0
                   6 7 4 0 18 7 1 0 21 8 1 255
                   12 4 0 255 10 4 0 255 3 1 0 255
                   2 1 0 255 12 6 0 255 16 7 1 255
                   13 7 3 0 6 7 4 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   3 1 0 0 10 7 2 0 8 7 3 0
                   6 7 4 0 18 6 1 255 18 6 0 255
                   8 3 0 255 8 3 1 255 6 2 0 255
                   9 4 0 255 15 7 3 255 15 7 4 0
                   6 7 4 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 3 1 0 0
                   10 7 2 0 8 7 3 0 9 8 4 0
                   18 6 1 255 20 6 0 255 10 3 0 255
                   5 1 0 255 13 5 0 255 14 5 0 255
                   14 7 2 255 13 7 3 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 11 8 4 0
                   11 8 4 0 9 8 4 0 13 7 3 255
                   17 5 0 255 9 3 0 255 11 4 0 255
                   15 6 1 255 17 7 2 255 11 6 2 255
                   8 7 3 0 6 7 4 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 1 2 0 0
                   1 2 0 0 0 0 0 0 0 0 0 0
                   2 1 0 0 12 8 4 0 12 7 3 0
                   8 6 3 0 10 4 2 255 13 4 0 255
                   10 4 0 255 11 4 0 255 11 4 0 255
                   16 6 0 255 14 6 1 255 9 7 4 0
                   6 7 4 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 1 2 0 0 1 2 0 0
                   0 0 0 0 0 0 0 0 2 1 0 0
                   10 7 4 0 11 6 2 0 9 5 2 0
                   10 5 1 255 10 3 0 255 11 4 0 255
                   5 1 0 255 3 0 0 255 16 5 0 255
                   17 6 0 255 11 7 3 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 3 1 0 0 10 7 3 0
                   11 6 2 0 10 5 1 0 11 4 0 255
                   9 3 0 255 7 2 0 255 5 1 0 255
                   6 3 0 255 17 6 0 255 15 5 1 255
                   12 7 1 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
)"
        R"(                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   3 1 0 0 8 7 3 0 9 6 2 0
                   12 5 1 0 12 4 0 255 10 4 0 255
                   5 2 0 255 3 1 0 255 5 2 0 255
                   15 5 0 255 17 6 0 255 15 7 1 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   5 7 3 0 6 7 4 0 17 8 1 0
                   18 7 1 255 17 6 0 255 6 3 0 255
                   3 1 0 255 4 2 0 255 7 3 0 255
                   18 6 0 255 15 7 2 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   3 1 0 0 3 1 0 0 6 7 3 0
                   8 7 3 0 15 8 2 0 17 6 1 255
                   16 6 0 255 13 4 0 255 8 2 0 255
                   5 1 0 255 7 3 0 255 18 7 1 255
                   10 7 3 0 6 7 4 0 6 9 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 3 1 0 0
                   3 1 0 0 6 7 4 0 8 7 3 0
                   10 7 2 0 16 6 0 255 17 6 0 255
                   11 4 0 255 10 3 0 255 11 4 0 255
                   13 4 0 255 16 6 0 255 6 7 4 0
                   6 7 4 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   6 7 4 0 9 8 4 0 13 8 3 0
                   13 7 1 255 14 5 0 255 10 3 0 255
                   12 3 0 255 13 5 0 255 12 5 0 255
                   15 5 0 255 15 8 2 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 3 1 0 0
                   3 1 0 0 0 0 0 0 6 7 4 0
                   9 8 4 0 11 8 4 0 16 6 1 255
                   12 5 0 255 17 5 0 255 13 4 0 255
                   12 3 0 255 12 5 0 255 16 6 0 255
                   21 8 0 0 6 7 4 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 3 1 0 0 3 1 0 0
                   0 0 0 0 6 7 4 0 8 7 3 0
                   10 7 3 0 12 4 1 255 10 4 0 255
                   17 5 0 255 11 4 0 255 9 3 0 255
                   15 5 0 255 16 6 0 255 19 8 0 0
                   6 7 4 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   6 2 0 0 9 3 0 0 4 1 0 0
                   6 7 4 0 9 6 3 0 12 6 2 0
                   8 3 1 255 4 2 0 255 8 2 0 255
                   17 5 0 255 18 6 0 255 11 4 0 255
                   15 5 0 255 17 8 1 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 6 2 0 0
                   11 4 0 0 7 2 0 0 6 7 4 0
                   6 5 3 0 13 5 1 0 13 5 1 255
                   6 2 0 255 8 2 0 255 19 6 0 255
                   20 6 0 255 9 4 0 255 19 6 0 255
                   14 8 2 0 6 7 4 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
)"
        R"(                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 3 1 0 0
                   3 1 0 0 6 7 4 0 5 6 3 0
                   14 6 1 0 26 11 3 255 17 6 0 255
                   12 5 0 255 13 4 0 255 14 4 0 255
                   10 3 0 255 17 6 0 255 12 6 2 0
                   6 7 4 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 9 3 0 0
                   13 8 3 0 6 7 4 0 8 7 3 0
                   26 12 3 255 15 5 0 255 8 4 0 255
                   10 4 0 255 13 5 0 255 13 5 0 255
                   15 5 0 255 13 6 1 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 13 8 3 0 17 8 1 0
                   12 7 2 0 11 7 1 0 25 11 2 255
                   14 5 0 255 8 3 0 255 12 4 0 255
                   17 6 0 255 15 5 0 255 15 5 0 255
                   12 7 2 0 6 7 4 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 7 3 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 14 7 2 0 20 8 1 0
                   21 8 0 0 18 6 1 255 14 5 0 255
                   14 5 1 255 12 4 0 255 13 4 0 255
                   19 7 0 255 20 9 2 255 11 7 3 0
                   6 7 4 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 5 6 3 0 5 6 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 7 3 0 6 7 3 0 6 7 3 0
                   5 7 3 0 5 6 3 0 5 7 3 0
                   9 7 4 0 21 8 0 0 23 8 0 0
                   14 5 0 255 13 5 0 255 13 4 0 255
                   8 4 0 255 11 4 0 255 18 8 1 255
                   20 9 2 255 6 7 4 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 6 7 3 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   5 6 3 0 5 6 3 0 5 7 3 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   5 7 3 0 5 7 3 0 6 7 3 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   6 7 4 0 6 7 4 0 6 7 3 0
                   5 7 3 0 6 7 3 0 6 7 4 0
                   18 8 0 0 23 8 0 0 16 7 3 255
                   13 7 1 255 14 5 0 255 5 2 0 255
                   5 1 0 255 9 4 1 255 12 9 2 255
                   6 7 4 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 7 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 6 3 0
                   5 6 3 0 6 7 3 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 5 7 3 0
                   5 7 3 0 6 7 3 0 6 7 3 0
                   5 7 3 0 5 6 3 0 6 7 3 0
                   6 7 3 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 3 0
                   6 7 4 0 6 7 4 0 12 7 2 0
                   15 7 2 0 13 8 3 255 7 4 1 255
                   10 6 0 255 12 4 0 255 7 2 0 255
                   7 4 1 255 6 7 3 255 6 7 4 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   6 7 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 7 3 0 5 7 3 0 5 6 3 0
                   5 6 3 0 6 7 3 0 6 7 4 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   1 2 1 0 2 3 2 0 1 1 1 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 7 3 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 6 7 3 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   5 6 3 0 6 7 3 0 6 7 3 0
                   6 7 4 0 6 7 4 0 6 7 3 0
                   5 7 3 0 6 7 4 0 6 7 4 0
                   6 8 4 0 6 8 4 0 7 9 4 255
                   15 18 9 255 25 26 16 255 15 17 9 255
                   11 14 6 255 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 9 7 4 0
                   21 14 7 255 10 6 1 255 13 5 0 255
                   15 6 0 255 9 4 0 255 5 6 3 255
                   6 7 3 255 10 13 6 255 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   5 7 3 0 5 7 3 0 5 6 3 0
                   5 7 3 0 5 7 3 0 6 7 3 0
                   6 7 3 0 5 7 3 0 6 7 3 0
                   6 7 3 0 5 7 3 0 5 8 3 0
                   5 7 3 0 5 7 3 0 6 7 3 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 6 7 3 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 7 3 0 5 6 3 0 5 7 3 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 1 3 1 0
                   2 4 2 0 1 1 1 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 7 3 0
                   6 8 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 5 7 3 0 5 7 3 0
                   5 6 3 0 6 8 3 0 6 8 3 0
                   5 7 3 0 6 7 3 0 6 7 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 6 7 3 0 6 7 4 0
                   6 7 4 0 6 8 4 0 5 7 3 0
                   6 7 4 0 7 9 4 0 7 9 4 0
                   6 7 4 0 6 7 4 0 7 9 4 0
                   7 9 4 0 6 8 4 0 7 9 4 0
                   14 15 8 255 11 14 6 255 11 15 6 255
                   14 18 7 255 12 15 6 255 10 14 5 255
                   11 14 6 255 18 18 10 255 34 35 21 255
)"
        R"(                   27 26 16 255 19 19 11 255 22 20 12 255
                   12 10 5 255 11 6 1 255 9 4 1 255
                   4 4 2 255 5 6 3 255 7 9 4 255
                   16 18 8 255 9 11 5 255 6 7 4 255
                   6 7 4 0 6 7 4 0 6 7 3 0
                   6 7 3 0 5 7 3 0 6 7 3 0
                   6 7 3 0 6 7 4 0 7 9 4 0
                   7 9 4 0 6 9 4 0 6 8 3 0
                   5 8 3 0 6 8 3 0 6 7 3 0
                   6 7 3 0 6 8 4 0 7 8 4 0
                   6 9 4 0 7 10 4 0 7 9 4 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   5 6 3 0 5 6 3 0 6 7 3 0
                   6 7 4 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 7 3 0 6 7 3 0
                   5 7 3 0 6 7 3 0 6 7 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 1 1 0 0 1 1 0 0
                   0 0 0 0 0 0 0 0 5 6 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 6 3 0 5 6 3 0 5 6 3 0
                   6 7 3 0 6 7 3 0 5 7 3 0
                   6 9 3 0 6 9 3 0 6 7 3 0
                   6 7 4 0 6 8 4 0 6 8 3 0
                   6 7 3 0 6 7 3 0 5 7 3 0
                   5 7 3 0 6 7 4 0 6 7 4 0
                   5 6 3 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   6 7 4 0 6 9 4 0 6 8 4 0
                   6 8 4 0 6 8 3 0 6 8 4 0
                   7 9 4 0 7 9 4 0 12 14 7 255
                   22 21 12 255 7 10 4 0 7 10 4 0
                   7 9 4 0 7 10 4 0 14 15 8 100
                   22 24 11 255 11 13 6 255 12 15 7 255
                   20 22 10 255 11 14 6 255 8 11 5 255
                   7 10 4 255 7 9 4 255 6 9 4 255
                   6 7 4 255 6 7 4 255 6 7 4 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 6 7 3 255 14 14 7 255
                   13 14 6 255 12 14 6 255 9 11 5 255
                   6 9 4 255 6 7 4 0 7 8 4 0
                   7 8 4 0 6 8 4 0 6 8 4 0
                   6 7 4 0 7 9 4 0 7 9 4 0
                   7 10 4 0 7 9 4 0 6 9 3 0
                   6 8 4 0 6 8 4 0 6 8 4 0
                   6 8 4 0 7 8 4 0 7 9 4 0
                   7 10 4 0 7 10 4 0 5 8 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 6 3 0 6 7 3 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   6 7 3 0 10 15 6 0 10 15 6 0
                   6 7 4 0 6 7 4 0 6 7 3 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   12 18 7 0 13 21 7 0 8 11 5 0
                   6 9 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 7 3 0
                   5 7 3 0 5 7 3 0 6 7 3 0
                   5 7 3 0 5 7 3 0 5 7 3 0
                   5 7 3 0 5 7 3 0 6 7 4 0
                   6 7 4 0 7 8 4 0 7 9 4 0
                   7 9 4 0 7 8 4 0 6 7 4 0
                   6 8 4 0 6 8 4 0 6 7 4 0
                   6 7 4 0 6 7 3 0 6 7 3 0
                   6 8 4 0 6 8 4 0 6 8 4 0
                   7 8 4 0 6 8 3 0 6 8 3 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   6 7 3 0 5 6 3 0 6 7 3 0
                   6 7 4 0 6 7 3 0 6 7 3 0
                   6 8 4 0 7 9 4 0 7 9 4 0
                   6 8 4 255 8 12 5 255 13 15 9 255
                   11 14 5 255 13 14 6 255 27 27 16 0
                   14 16 9 86 15 16 8 255 22 23 12 255
                   12 14 7 255 10 13 5 255 15 17 9 255
                   12 17 6 255 6 9 4 255 6 7 3 255
                   6 7 4 255 6 9 4 255 6 9 4 255
                   6 7 3 255 5 7 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 2 255
                   5 6 3 255 6 7 3 255 8 9 4 255
                   7 10 5 255 8 10 5 255 7 10 4 255
                   6 9 4 255 11 13 6 255 7 8 4 0
                   6 8 4 0 6 8 4 0 7 8 4 0
                   13 15 7 255 25 27 12 255 7 10 4 0
                   7 9 4 0 6 9 4 0 6 8 4 0
                   6 8 4 0 6 8 4 255 16 16 7 255
                   32 31 17 255 6 7 4 0 6 8 4 0
                   6 8 3 0 6 7 3 0 6 7 3 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   5 7 3 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   14 23 9 0 14 23 9 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 17 27 10 0
                   20 34 11 0 16 26 8 0 7 10 4 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 5 6 3 0 5 6 3 0
                   5 7 3 0 5 8 3 0 5 8 3 0
                   6 7 3 0 6 7 4 0 6 7 3 0
                   6 7 3 0 6 7 3 0 6 7 3 0
                   6 7 3 0 6 7 4 0 6 7 4 0
                   7 8 4 0 7 8 4 0 7 8 4 0
                   7 8 4 0 44 40 23 255 20 20 10 255
                   16 17 8 255 42 39 25 255 31 29 16 255
                   6 8 4 0 6 8 4 0 6 7 3 0
                   6 7 3 0 7 9 4 0 7 9 4 0
                   6 8 4 0 6 8 4 0 6 8 4 0
                   6 8 4 0 6 8 4 0 6 8 4 0
                   5 7 3 0 6 7 4 0 6 9 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   7 9 4 0 7 9 4 0 8 10 4 255
                   7 10 4 255 8 10 4 255 11 13 5 255
                   13 16 7 255 19 20 10 255 11 12 5 255
                   13 14 7 255 33 31 17 123 23 22 11 255
                   15 18 8 255 16 20 8 255 10 15 5 255
                   7 13 4 255 7 11 4 255 6 10 3 255
                   6 9 3 255 6 10 4 255 7 11 4 255
                   6 9 4 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 2 255 5 6 3 255
                   5 6 3 255 6 7 4 255 6 8 4 255
                   6 8 4 255 7 10 4 255 6 9 4 255
                   8 10 5 255 6 7 4 0 6 7 4 0
                   6 7 4 255 13 16 8 255 9 12 5 255
                   16 18 9 255 15 17 10 255 15 17 8 255
                   29 28 17 255 18 18 12 255 9 10 5 255
                   8 10 4 255 8 10 4 255 9 10 4 255
                   19 20 10 255 18 18 9 255 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 3 0
                   6 7 3 0 6 7 4 255 12 14 6 255
                   9 11 5 255 11 14 5 255 19 29 10 255
                   17 27 10 0 8 11 5 0 6 7 4 0
                   19 20 9 0 14 19 7 255 15 19 7 255
                   19 22 9 255 16 19 8 255 23 26 12 255
                   29 31 14 255 16 26 10 255 20 34 12 0
                   18 30 10 0 7 10 4 0 6 7 3 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   5 7 3 0 5 7 3 0 6 7 3 0
                   6 7 3 0 6 7 3 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 255 6 7 4 255
                   11 14 5 255 21 20 10 255 29 28 15 255
                   23 23 11 255 10 13 5 255 9 11 5 255
                   13 14 6 255 22 22 12 255 15 18 8 255
                   23 24 13 255 6 8 4 0 6 7 4 0
                   6 8 4 0 6 8 4 0 6 7 4 0
                   6 7 4 0 35 33 20 255 16 17 9 255
                   13 14 7 255 25 26 14 255 6 7 3 0
                   6 7 3 0 6 7 4 255 30 28 16 255
                   6 7 4 255 6 7 4 0 6 8 4 0
                   31 28 16 255 14 16 7 255 7 9 4 255
                   6 9 3 255 6 8 4 255 6 9 3 255
                   11 13 5 255 8 10 4 255 10 13 5 255
                   20 19 10 255 13 14 6 255 7 12 4 255
                   12 18 6 255 10 17 5 255 7 14 4 255
                   7 14 4 255 7 13 4 255 6 9 3 255
                   6 9 3 255 6 10 4 255 6 9 3 255
                   6 7 3 255 6 7 3 255 5 6 3 255
                   5 7 3 255 5 6 2 255 5 7 3 255
                   8 10 5 255 7 10 4 255 7 10 5 255
                   6 9 4 255 7 10 4 255 7 10 4 255
                   7 9 4 255 8 10 6 255 8 11 5 255
                   8 11 4 255 8 11 4 255 6 9 4 255
                   6 9 4 255 7 10 4 255 8 13 4 255
                   7 11 4 255 6 7 3 255 6 7 3 255
                   5 7 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 8 10 4 0 15 15 8 0
                   12 13 6 0 10 11 5 255 10 13 5 255
                   8 10 4 255 6 7 4 255 6 7 4 255
                   6 7 4 255 6 9 3 255 6 9 4 255
                   8 11 4 0 17 25 9 0 23 33 13 255
                   24 29 13 255 17 19 8 255 10 15 5 255
                   10 15 5 255 12 18 6 255 13 19 7 255
                   15 22 8 255 18 28 9 255 17 26 9 255
                   20 30 11 255 23 35 12 255 14 19 8 255
                   9 15 4 0 12 20 6 0 6 7 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 6 7 3 0
                   6 7 3 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   6 7 4 0 50 49 26 0 24 26 12 255
                   23 24 11 255 18 20 8 255 17 19 8 0
                   17 19 8 0 15 17 7 0 8 10 4 255
                   7 10 4 255 7 10 4 255 6 9 3 255
                   6 7 3 255 6 7 3 255 6 8 3 255
                   7 9 4 255 9 12 6 255 9 11 5 255
                   9 11 5 255 12 12 6 255 11 12 5 255
                   11 12 5 255 11 13 5 255 14 15 8 255
                   11 12 6 255 8 11 5 255 13 14 6 255
                   13 14 7 255 6 8 4 0 6 7 4 0
                   6 7 4 255 9 10 5 255 11 11 5 255
                   11 11 5 255 19 19 11 255 30 28 16 255
                   13 13 6 255 7 9 4 255 5 8 3 255
                   5 7 3 255 5 6 3 255 7 9 4 255
                   7 9 4 255 6 7 3 255 6 7 4 255
                   6 8 4 255 6 10 4 255 7 11 4 255
                   7 11 4 255 6 10 4 255 6 9 4 255
                   6 9 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 5 7 3 255 6 7 3 255
                   6 7 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 6 7 3 255 9 11 5 255
                   16 20 10 255 34 36 22 255 17 18 10 255
                   7 10 5 255 8 13 5 255 6 10 4 255
                   6 7 4 255 6 9 4 255 8 14 4 255
                   9 15 5 255 8 13 4 255 6 10 4 255
                   6 9 4 255 7 10 4 255 6 10 4 255
                   6 9 3 255 7 10 4 255 5 7 3 255
                   5 7 3 255 5 7 3 255 5 6 3 0
                   5 6 3 0 5 6 3 255 5 7 3 255
                   5 7 3 255 6 7 3 255 6 7 3 255
                   5 7 3 255 5 7 3 255 6 7 3 255
                   6 9 4 255 7 10 4 255 9 13 5 255
                   8 11 4 255 11 16 6 255 13 21 7 255
                   11 17 5 255 9 14 4 255 12 18 6 255
                   16 24 8 255 16 22 8 255 16 22 8 255
                   15 23 7 255 13 23 7 255 13 19 6 255
                   11 15 6 255 24 28 12 255 10 17 5 0
                   12 20 6 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 6 7 4 0 6 7 4 0
                   6 7 4 0 6 7 4 0 48 51 22 0
                   27 30 12 0 33 34 16 0 47 44 25 0
                   24 26 12 0 17 20 8 255 14 19 7 255
                   9 13 5 255 7 10 4 255 7 10 4 255
                   7 10 4 0 6 9 4 0 6 8 4 0
                   6 8 4 255 5 8 3 255 5 7 3 255
                   5 7 3 255 6 7 3 255 6 7 3 255
                   6 8 4 255 6 8 3 255 5 7 3 255
                   5 6 3 255 6 7 4 255 6 8 4 255
                   7 9 4 255 7 10 4 255 8 11 5 255
                   9 11 5 255 8 10 4 255 7 10 4 255
                   6 8 4 255 7 7 4 255 9 10 4 255
                   21 22 12 255 14 14 7 255 7 7 4 255
                   5 7 3 255 7 7 4 255 5 6 3 255
                   5 6 3 255 5 7 3 255 5 7 3 255
                   5 6 3 255 5 6 3 255 5 6 2 255
                   5 6 3 255 4 6 3 255 5 5 3 255
                   5 6 3 255 6 7 3 255 6 9 4 255
                   6 10 4 255 6 7 3 255 6 7 3 255
                   6 9 4 255 5 7 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 7 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 6 9 4 255 8 10 5 255
                   13 15 9 255 11 14 8 255 7 10 5 255
                   8 13 6 255 8 11 5 255 8 10 5 255
                   7 9 5 255 6 10 4 255 7 11 4 255
                   7 11 4 255 6 9 4 255 6 9 4 255
                   7 11 4 255 8 15 4 255 8 14 4 255
                   8 14 4 255 7 11 4 255 6 10 3 255
                   6 9 3 0 6 9 3 0 5 7 3 255
                   5 7 3 255 5 7 3 255 6 7 3 255
                   5 7 3 255 6 9 3 255 5 7 3 255
                   5 7 3 255 6 9 3 255 7 10 4 255
                   7 11 4 255 7 11 4 255 7 11 4 255
                   8 11 4 255 11 16 6 255 11 17 6 255
                   9 13 5 255 15 23 9 255 20 34 11 255
                   22 35 13 255 28 37 16 255 17 23 9 255
                   16 23 8 255 16 23 8 255 15 20 7 255
                   11 17 6 0 8 11 4 0 6 7 4 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   6 7 4 0 6 7 4 0 6 7 4 0
                   82 81 48 0 37 43 17 0 17 23 8 0
                   24 26 11 0 36 35 19 255 15 18 8 255
                   13 18 6 255 16 20 7 255 10 15 5 255
                   6 11 4 255 6 10 4 255 5 9 4 255
                   5 7 3 0 5 6 3 0 5 6 2 255
                   5 6 3 255 5 7 4 255 5 7 4 255
                   5 7 4 255 5 7 4 255 6 7 4 255
                   5 6 3 255 4 6 3 255 5 7 3 255
                   5 7 3 255 5 7 4 255 6 7 4 255
                   7 9 5 255 7 9 4 255 7 7 4 255
                   7 9 4 255 7 9 4 255 6 7 4 255
                   6 7 4 255 5 7 3 255 7 9 4 255
                   6 7 3 255 5 7 3 255 5 7 3 255
                   7 9 4 255 5 7 3 255 5 6 2 255
                   4 6 2 255 4 6 3 255 4 6 3 255
                   4 6 3 255 4 6 2 255 5 6 3 255
                   4 6 3 255 4 6 3 255 6 9 4 255
                   17 19 9 255 8 10 4 255 6 10 4 255
                   6 11 4 255 6 10 4 255 6 11 4 255
                   6 10 4 255 6 11 4 255 6 9 3 255
                   5 7 3 255 5 9 3 255 5 9 3 255
                   5 7 3 255 5 7 3 255 5 7 3 255
                   6 7 4 255 6 9 4 255 6 9 4 255
                   6 10 4 255 7 10 5 255 7 11 6 255
                   7 10 5 255 7 10 4 255 6 9 4 255
                   6 10 4 255 6 9 4 255 6 7 4 255
                   6 7 4 255 6 9 4 255 6 9 4 255
                   7 11 4 255 8 15 5 255 10 18 5 255
                   8 15 4 255 8 14 4 255 7 13 4 255
                   8 15 4 255 6 10 4 255 7 11 4 255
                   6 9 4 255 6 9 3 255 6 9 4 255
                   5 7 3 255 5 7 3 255 6 7 4 255
                   6 10 4 255 7 13 4 255 7 10 3 255
                   7 10 4 255 12 19 6 255 11 16 7 255
                   11 15 7 255 10 14 6 255 11 14 6 255
                   31 36 18 255 30 44 17 255 30 42 16 255
                   33 45 18 255 23 35 12 255 26 38 14 255
                   27 37 15 255 18 30 10 0 20 34 12 0
                   6 7 4 0 6 7 4 0 6 9 4 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 6 7 4 0
                   5 6 3 0 6 7 3 0 6 7 4 0
                   53 55 26 0 29 32 14 0 17 20 8 0
                   16 18 8 255 8 11 5 255 8 11 4 255
                   11 13 6 255 7 10 4 255 7 10 4 255
                   6 10 4 255 6 7 3 255 6 7 3 255
                   6 7 3 255 5 7 3 255 5 6 3 255
                   5 6 3 255 5 7 3 255 5 7 4 255
                   5 7 3 255 5 6 3 255 5 7 3 255
                   5 7 4 255 5 7 3 255 5 7 4 255
                   5 6 3 255 5 7 4 255 7 9 4 255
                   8 9 5 255 6 7 3 255 5 7 3 255
                   5 6 3 255 5 6 3 255 5 7 3 255
                   5 7 4 255 4 6 3 255 4 6 2 255
                   4 6 3 255 4 6 3 255 5 6 3 255
                   5 6 2 255 4 6 3 255 4 6 3 255
                   4 6 3 255 4 6 3 255 4 5 3 255
)"
        R"(                   4 6 3 255 5 7 3 255 5 6 3 255
                   4 6 3 255 7 9 4 255 15 15 9 255
                   8 10 5 255 6 11 4 255 6 11 4 255
                   6 11 4 255 7 14 4 255 6 13 4 255
                   7 13 4 255 7 13 4 255 6 10 4 255
                   5 9 4 255 5 9 4 255 5 6 3 255
                   5 7 3 255 5 7 4 255 6 9 4 255
                   6 9 4 255 6 9 4 255 6 10 5 255
                   6 10 5 255 6 9 5 255 6 9 4 255
                   7 11 4 255 7 11 5 255 6 11 5 255
                   6 10 4 255 5 7 3 255 5 7 3 255
                   5 7 3 255 6 9 4 255 7 11 4 255
                   8 14 5 255 8 15 5 255 7 13 4 255
                   8 15 4 255 10 19 5 255 10 19 5 255
                   8 15 4 255 8 14 5 255 6 10 3 255
                   7 11 4 255 7 10 4 255 6 10 4 255
                   6 9 4 255 6 10 4 255 7 11 4 255
                   9 15 4 255 9 14 4 255 12 20 6 255
                   15 25 8 255 12 20 7 255 14 20 7 255
                   17 22 9 255 17 21 9 255 39 43 21 255
                   44 51 26 255 23 37 13 255 20 34 11 255
                   18 29 9 255 25 35 13 255 38 45 20 255
                   16 26 9 0 20 32 11 0 18 29 10 0
                   9 14 6 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 6 7 4 0 5 7 3 0
                   6 7 4 0 6 9 4 0 34 41 16 0
                   15 23 7 0 11 18 6 255 9 15 5 255
                   7 11 4 255 7 10 4 255 7 10 4 255
                   6 7 3 255 9 11 5 255 9 11 5 255
                   7 10 4 255 7 10 4 255 7 11 4 255
                   6 10 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 5 7 4 255 5 7 4 255
                   6 7 4 255 6 7 4 255 5 7 4 255
                   5 7 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 6 7 3 255
                   6 7 3 255 6 7 3 255 5 6 3 255
                   4 6 3 255 5 6 3 255 5 6 3 255
                   4 6 3 255 4 6 2 255 5 6 3 255
                   4 6 3 255 4 6 3 255 4 5 2 255
                   4 6 3 255 4 6 3 255 5 6 3 255
                   5 6 2 255 4 6 2 255 4 6 3 255
                   4 6 3 255 4 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 4 6 3 255
                   4 6 3 255 5 9 3 255 6 10 4 255
                   6 11 4 255 8 15 4 255 8 15 4 255
                   8 15 4 255 6 10 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   6 7 4 255 7 10 5 255 8 11 5 255
                   7 9 5 255 7 10 5 255 7 10 5 255
                   7 10 5 255 9 13 5 255 7 10 5 255
                   7 13 5 255 7 13 4 255 6 10 4 255
                   6 9 3 255 6 9 3 255 6 7 3 255
                   5 7 3 255 6 9 4 255 6 10 4 255
                   6 11 4 255 8 15 4 255 10 18 4 255
                   11 20 4 255 11 20 5 255 11 20 5 255
                   9 15 4 255 8 14 5 255 9 15 4 255
                   8 13 4 255 6 11 4 255 7 13 4 255
                   10 17 5 255 9 15 4 255 10 18 4 255
                   13 22 6 255 13 22 7 255 13 20 8 255
                   13 20 8 255 13 20 7 255 17 23 9 255
                   20 29 11 255 19 26 8 255 20 31 9 255
                   19 32 11 255 18 30 11 255 17 26 8 255
                   22 30 10 255 10 17 6 255 14 22 7 0
                   16 28 10 0 19 32 11 0 14 22 9 0
                   11 16 7 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   6 7 4 0 6 7 3 0 6 7 3 0
                   6 9 4 0 31 37 16 0 18 31 8 0
                   12 22 6 255 10 18 5 255 8 15 4 255
                   7 13 4 255 6 10 4 255 6 9 4 255
                   7 10 4 255 7 10 4 255 7 11 4 255
                   9 15 5 255 10 18 5 255 8 15 5 255
                   7 11 3 255 6 9 3 255 5 7 3 255
                   5 7 3 255 5 7 3 255 5 7 4 255
                   5 7 4 255 5 7 4 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 2 255 4 6 3 255
                   4 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   4 6 2 255 4 6 2 255 4 6 2 255
                   4 6 3 255 4 6 2 255 4 6 3 255
                   4 5 3 255 4 6 3 255 4 6 2 255
                   4 6 2 255 4 6 2 255 4 6 3 255
                   4 5 3 255 5 7 3 255 5 7 3 255
                   4 6 3 255 5 6 3 255 5 6 3 255
                   5 7 3 255 6 9 4 255 6 9 4 255
                   6 9 4 255 6 10 4 255 6 10 4 255
                   5 7 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 7 3 255 6 7 4 255
                   7 10 5 255 11 14 7 255 18 20 11 255
                   20 22 12 255 11 14 7 255 9 15 6 255
                   15 20 9 255 13 18 8 255 10 17 6 255
                   9 18 6 255 7 13 5 255 8 15 4 255
                   7 14 4 255 7 10 4 255 5 9 3 255
                   6 9 3 255 6 10 4 255 8 13 4 255
                   12 20 5 255 12 23 5 255 14 26 6 255
                   16 30 7 255 16 30 7 255 15 26 6 255
                   12 23 4 255 12 22 4 255 11 19 5 255
                   8 14 4 255 9 15 5 255 12 22 6 255
                   12 20 6 255 11 19 6 255 13 22 6 255
                   13 22 7 255 13 21 7 255 15 24 8 255
                   13 20 6 255 13 19 5 255 14 22 7 255
                   13 23 6 255 16 27 8 255 17 29 9 255
                   17 27 10 255 16 26 8 255 19 29 9 255
                   14 21 7 255 15 23 8 0 18 29 10 0
                   15 26 8 0 15 25 9 0 13 22 8 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 6 7 4 0
                   6 7 4 0 6 7 4 0 6 9 4 0
                   28 33 14 0 25 39 10 0 20 32 9 255
                   18 30 8 255 13 23 7 255 10 17 5 255
                   8 13 4 255 7 11 4 255 7 11 4 255
                   7 13 5 255 8 14 5 255 12 20 6 255
                   13 24 7 255 11 22 6 255 10 18 5 255
                   8 14 5 255 7 11 4 255 6 9 4 255
                   6 7 3 255 6 7 4 255 6 7 4 255
                   5 7 4 255 5 7 3 255 5 7 3 255
                   5 7 4 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 4 6 2 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 4 6 3 255 5 6 3 255
                   4 6 3 255 5 6 3 255 5 6 3 255
                   4 6 2 255 5 6 3 255 4 6 3 255
                   5 7 3 255 6 8 3 255 5 7 3 255
                   7 9 4 255 7 10 4 255 9 12 5 255
                   19 20 10 255 13 14 6 255 8 11 4 255
                   14 16 7 255 14 17 8 255 11 12 6 255
                   6 9 3 255 5 7 3 255 6 7 4 255
                   5 6 3 255 5 6 3 255 5 7 4 255
                   5 7 4 255 6 9 4 255 7 10 5 255
                   7 10 5 255 10 13 7 255 12 14 8 255
                   11 14 7 255 10 15 7 255 9 15 6 255
                   13 23 8 255 14 26 8 255 14 26 7 255
                   13 23 6 255 12 22 5 255 10 18 5 255
                   8 14 4 255 8 14 4 255 8 14 4 255
                   9 15 4 255 9 17 4 255 12 22 6 255
                   17 31 7 255 21 36 7 255 21 37 7 255
                   20 35 7 255 18 31 7 255 14 25 5 255
                   14 24 5 255 16 29 7 255 14 24 6 255
                   10 18 5 255 12 21 6 255 15 27 7 255
                   14 25 6 255 12 18 6 255 12 18 6 255
                   11 18 6 255 13 22 7 255 12 20 5 255
                   11 20 5 255 12 20 6 255 13 21 6 255
                   17 32 10 255 20 33 11 255 16 24 8 255
                   15 24 7 255 21 34 11 255 15 24 8 0
                   14 22 8 0 14 23 7 0 11 18 6 0
                   14 23 8 0 13 20 7 0 8 12 4 0
                   8 12 5 0 0 0 0 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   0 0 0 0 18 36 7 0 86 85 47 0
                   51 57 23 0 49 52 27 0 33 38 17 0
                   22 34 9 0 18 30 7 255 14 24 6 255
                   12 22 6 255 12 20 7 255 11 18 6 0
                   9 14 5 0 8 14 4 0 10 15 5 255
                   10 17 5 255 12 22 6 255 14 27 7 255
                   16 30 8 255 12 23 6 255 13 23 6 255
                   10 17 4 255 7 13 4 255 6 10 4 255
                   6 9 4 255 6 7 4 255 5 7 3 255
                   5 7 3 255 5 7 3 255 5 7 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   4 6 3 255 4 6 2 255 4 6 2 255
                   4 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 4 6 3 255
                   6 8 4 255 6 8 4 255 6 7 3 255
                   6 8 3 255 5 7 3 255 7 10 4 255
                   8 11 5 255 14 17 8 255 26 26 16 255
                   13 16 8 255 18 21 10 255 17 19 11 255
                   26 27 15 255 25 27 16 255 9 11 5 255
                   7 9 4 255 6 9 4 255 5 7 3 255
                   6 7 4 255 5 9 4 255 6 9 4 255
                   6 10 4 255 7 10 5 255 8 11 6 255
                   11 15 8 255 11 14 7 255 9 13 6 255
                   8 11 6 255 8 13 5 255 10 17 6 255
                   14 24 7 255 17 31 8 255 16 30 7 255
                   14 26 6 255 10 19 5 255 12 22 6 255
                   13 23 6 255 11 20 5 255 11 19 5 255
                   12 22 5 255 13 23 5 255 15 28 6 255
                   13 23 6 255 13 22 5 255 12 19 5 255
                   11 19 5 255 14 24 6 255 13 23 6 255
                   13 23 6 255 12 22 6 255 12 20 6 255
                   11 18 5 255 13 22 6 255 14 22 6 255
                   9 13 5 255 7 10 4 255 7 10 4 255
                   7 12 4 255 9 15 6 255 12 21 7 255
                   10 16 5 255 8 12 4 255 16 26 8 255
                   17 29 10 255 14 21 7 255 16 27 10 255
                   27 40 15 255 12 20 7 0 10 15 6 0
                   10 14 6 0 12 18 7 0 17 28 9 0
                   13 20 8 0 7 11 4 0 7 11 4 0
                   6 7 3 0 6 7 4 0 0 0 0 0
                   0 0 0 0 0 0 0 0 0 0 0 0
                   18 36 7 0 75 79 37 0 38 51 14 0
                   26 35 10 0 23 31 10 0 17 30 7 0
                   20 35 8 255 18 31 7 255 16 28 7 255
                   16 28 8 0 16 27 8 255 12 20 6 255
                   10 17 4 255 10 15 5 255 11 18 5 255
                   15 27 7 255 16 27 8 255 17 31 8 255
                   14 27 7 255 16 30 8 255 14 24 7 255
                   11 19 5 255 8 14 4 255 7 13 4 255
                   6 10 4 255 6 7 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 7 3 255
                   5 6 3 255 5 6 3 255 4 6 2 255
                   4 6 2 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 2 255 5 6 2 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 7 3 255
                   5 7 3 255 5 6 3 255 7 9 4 255
                   7 9 4 255 5 7 3 255 5 6 3 255
                   5 6 3 255 8 10 5 255 10 13 6 255
                   16 18 10 255 15 15 9 255 12 15 7 255
                   32 31 17 255 16 19 8 255 18 23 10 255
                   16 19 10 255 14 17 9 255 15 18 10 255
                   6 9 4 255 5 7 3 255 6 9 4 255
                   6 10 4 255 6 10 4 255 7 11 5 255
                   8 11 5 255 8 13 6 255 15 19 9 255
                   13 17 9 255 10 14 7 255 8 13 6 255
                   8 13 5 255 8 13 5 255 9 15 6 255
                   11 19 6 255 11 19 6 255 10 17 5 255
                   8 15 4 255 11 20 5 255 13 24 6 255
                   14 24 6 255 12 23 5 255 11 22 5 255
                   11 20 5 255 10 20 5 255 8 14 4 255
                   8 15 4 255 8 14 4 255 10 18 5 255
                   11 18 5 255 12 20 5 255 11 18 5 255
                   8 14 4 255 7 11 4 255 6 9 4 255
                   7 10 4 255 6 10 4 255 7 11 4 255
                   7 10 4 255 6 10 4 255 6 10 4 255
                   7 13 4 255 8 13 4 255 9 11 4 255
                   9 11 4 255 9 11 4 255 11 14 6 255
                   16 23 8 255 22 34 12 255 23 31 12 255
                   24 29 15 255 31 38 17 255 35 39 18 255
                   15 23 9 0 16 27 10 0 11 18 6 0
                   13 21 7 0 12 18 7 0 6 7 3 0
                   6 7 4 0 4 6 2 0 4 6 2 0
                   0 0 0 0 0 0 0 0 18 36 7 0
                   18 36 7 0 66 73 34 0 31 43 13 0
                   17 30 7 0 19 34 8 0 24 39 9 0
                   24 35 10 0 16 25 7 0 16 26 7 0
                   16 27 8 255 14 24 7 255 9 17 5 255
                   8 14 4 255 9 13 5 255 10 16 5 255
                   12 17 6 255 12 18 6 255 13 22 6 255
                   11 19 6 255 10 18 5 255 10 18 5 255
                   9 15 4 255 8 15 4 255 8 13 4 255
                   6 11 4 255 6 10 3 255 6 9 3 255
                   5 7 3 255 5 9 3 255 5 7 3 255
                   5 6 3 255 5 6 3 255 4 6 2 255
                   4 6 3 255 5 6 3 255 5 6 3 255
                   5 6 2 255 5 7 3 255 6 9 3 255
                   5 7 3 255 5 6 3 255 5 6 3 255
                   4 6 3 255 4 7 3 255 5 7 3 255
                   5 6 3 255 5 8 4 255 6 8 4 255
                   5 7 3 255 6 9 3 255 8 10 5 255
                   16 17 9 255 20 20 11 255 25 24 14 255
                   16 17 9 255 22 23 12 255 22 23 12 255
                   14 18 7 255 10 14 5 255 8 13 5 255
                   10 14 6 255 10 14 6 255 7 11 4 255
                   5 7 3 255 6 9 4 255 6 9 4 255
                   7 11 4 255 12 17 7 255 13 17 8 255
                   11 14 7 255 11 15 7 255 9 13 6 255
                   7 11 5 255 8 14 5 255 9 17 6 255
                   10 17 6 255 9 14 5 255 8 14 5 255
                   7 11 4 255 6 9 4 255 6 9 4 255
                   7 11 4 255 8 14 4 255 9 14 4 255
                   10 19 4 255 10 19 5 255 8 14 4 255
                   7 11 4 255 7 11 4 255 7 10 4 255
                   6 9 3 255 9 18 4 255 10 17 4 255
                   9 14 4 255 8 13 4 255 6 10 4 255
                   7 10 4 255 7 9 4 255 6 9 4 255
                   6 10 4 255 6 10 4 255 7 13 4 255
                   8 14 4 255 7 14 4 255 9 17 5 255
                   10 17 5 255 18 23 9 255 18 21 9 255
                   9 14 5 255 13 17 7 255 13 19 7 255
                   12 18 7 255 13 20 8 255 18 25 9 255
                   15 21 8 255 17 24 9 255 19 25 10 255
                   29 36 15 255 13 19 7 0 18 29 11 0
                   17 27 9 0 7 10 4 0 6 7 3 0
                   9 12 6 0 4 6 2 0 0 0 0 0
                   0 0 0 0 18 36 7 0 18 36 7 0
                   66 73 30 0 27 38 11 0 14 24 6 0
                   19 31 8 0 20 32 8 0 19 28 9 255
                   18 25 8 255 19 27 7 255 19 30 8 255
                   19 30 8 255 11 18 5 255 7 11 4 255
                   7 10 4 255 8 11 4 255 8 11 4 255
                   7 10 3 255 7 11 3 255 8 15 4 255
                   7 11 4 255 6 11 4 255 7 14 4 255
                   7 14 4 255 8 14 4 255 8 14 4 255
                   7 13 4 255 6 10 4 255 6 9 3 255
                   6 9 3 255 6 9 3 255 6 7 3 255
                   5 7 3 255 5 7 3 255 5 7 3 255
                   6 7 3 255 6 7 3 255 6 9 3 255
                   7 13 4 255 7 14 4 255 6 10 4 255
                   6 7 3 255 5 7 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 7 3 255 5 7 3 255 6 9 4 255
                   6 9 3 255 8 11 5 255 11 13 6 255
                   14 15 8 255 14 14 8 255 12 14 7 255
                   14 14 8 255 9 11 5 255 6 10 4 255
                   6 9 4 255 6 9 3 255 7 11 4 255
                   8 14 4 255 7 10 4 255 5 6 3 255
                   5 7 3 255 6 9 4 255 6 9 4 255
                   9 11 5 255 12 14 7 255 14 18 9 255
                   13 18 7 255 9 14 5 255 8 14 5 255
                   9 17 5 255 11 19 6 255 10 18 6 255
                   6 9 4 255 6 7 4 255 5 7 4 255
                   5 6 3 255 5 7 3 255 5 7 3 255
                   6 9 4 255 6 9 4 255 8 14 4 255
                   8 14 4 255 7 10 3 255 6 7 3 255
                   6 9 4 255 6 7 3 255 6 7 3 255
                   7 11 3 255 6 9 3 255 6 9 3 255
                   6 7 3 255 6 9 3 255 8 11 5 255
                   8 10 4 255 6 9 3 255 6 11 4 255
                   8 14 4 255 9 15 4 255 9 17 5 255
                   9 17 4 255 9 18 4 255 10 19 5 255
)"
        R"(                   11 16 5 255 11 15 5 255 14 21 7 255
                   12 19 6 255 12 19 6 255 12 17 7 255
                   12 18 7 255 16 24 7 255 15 22 7 255
                   18 25 9 255 19 26 10 255 20 26 10 255
                   12 18 7 0 17 28 10 0 17 30 9 0
                   12 21 7 0 5 6 3 0 6 7 3 0
                   6 7 4 0 0 0 0 0 0 0 0 0
                   18 36 7 0 18 36 7 0 63 75 25 0
                   31 45 10 0 28 38 12 0 34 46 14 0
                   29 41 12 255 20 31 8 255 17 24 7 255
                   15 21 8 255 18 24 9 255 16 26 6 255
                   12 22 5 255 9 15 4 255 7 10 4 255
                   7 13 4 255 10 18 5 255 12 22 5 255
                   11 20 5 255 11 22 5 255 7 14 4 255
                   7 13 4 255 8 15 4 255 10 19 5 255
                   10 18 5 255 9 15 4 255 7 13 4 255
                   6 10 4 255 6 9 3 255 6 9 3 255
                   6 9 3 255 6 9 3 255 6 9 3 255
                   5 7 3 255 5 7 3 255 6 7 3 255
                   6 9 3 255 8 14 4 255 9 17 4 255
                   9 18 5 255 7 13 4 255 7 11 4 255
                   6 9 4 255 6 7 3 255 5 7 3 255
                   5 7 3 255 5 6 3 255 5 7 3 255
                   6 9 3 255 6 10 4 255 6 10 4 255
                   7 11 4 255 6 9 4 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 7 3 255 6 7 3 255 6 7 3 255
                   6 7 3 255 6 10 4 255 7 13 4 255
                   7 10 4 255 6 7 3 255 5 7 3 255
                   5 7 3 255 5 7 4 255 7 10 5 255
                   15 17 8 255 15 18 9 255 10 17 6 255
                   10 18 5 255 9 17 5 255 10 18 6 255
                   11 19 7 255 9 13 5 255 6 9 4 255
                   6 7 4 255 6 7 4 255 6 7 4 255
                   6 7 4 255 6 9 4 255 6 9 4 255
                   6 9 4 255 6 9 4 255 7 10 4 255
                   7 10 4 255 7 10 4 255 6 10 4 255
                   6 9 4 255 6 7 3 255 6 7 4 255
                   6 7 4 255 6 9 4 255 6 9 4 255
                   6 7 3 255 6 9 4 255 5 7 3 255
                   5 6 3 255 6 9 3 255 7 11 4 255
                   8 13 4 255 8 15 4 255 8 14 4 255
                   10 19 5 255 11 22 5 255 11 18 5 255
                   10 17 5 255 13 21 6 255 10 15 6 255
                   14 20 7 255 18 29 9 255 17 24 9 255
                   23 30 10 255 23 31 11 255 28 38 14 255
                   20 29 11 255 17 23 8 255 20 29 11 255
                   15 25 8 0 17 28 8 0 15 23 7 0
                   5 6 3 0 5 6 3 0 11 15 6 0
                   6 10 3 0 0 0 0 0 18 36 7 0
                   18 36 7 0 18 36 7 0 65 71 30 0
                   60 63 32 0 60 65 28 0 63 69 31 0
                   47 52 24 255 10 17 5 255 41 46 22 255
                   34 40 16 255 24 33 11 255 16 25 7 255
                   11 19 6 255 9 15 5 255 9 14 4 255
                   12 20 5 255 20 37 7 255 22 40 8 255
                   16 28 6 255 10 19 5 255 11 20 5 255
                   10 18 4 255 13 24 6 255 15 27 7 255
                   11 19 5 255 9 17 5 255 7 11 4 255
                   6 9 3 255 6 11 4 255 6 10 3 255
                   6 9 4 255 6 9 4 255 6 9 4 255
                   6 9 3 255 6 7 3 255 5 7 3 255
                   7 11 4 255 10 19 5 255 10 18 5 255
                   9 17 4 255 8 15 4 255 6 11 4 255
                   6 9 4 255 5 7 3 255 5 7 3 255
                   5 7 3 255 5 7 3 255 6 7 3 255
                   7 11 4 255 7 11 4 255 6 11 4 255
                   6 9 4 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 6 7 3 255
                   6 10 4 255 5 7 3 255 6 9 4 255
                   6 9 4 255 6 9 4 255 6 7 4 255
                   5 7 4 255 5 7 3 255 5 6 3 255
                   5 7 3 255 5 7 4 255 9 11 6 255
                   14 15 9 255 10 14 6 255 11 18 7 255
                   10 19 6 255 11 20 7 255 9 15 6 255
                   7 9 4 255 6 7 4 255 6 7 4 255
                   6 7 4 255 6 7 3 255 6 7 4 255
                   6 9 4 255 5 7 3 255 6 7 4 255
                   6 9 4 255 6 9 4 255 8 10 5 255
                   8 10 5 255 6 10 4 255 7 10 4 255
                   6 9 4 255 7 10 4 255 6 9 4 255
                   7 10 4 255 7 11 4 255 6 10 4 255
                   6 9 4 255 5 6 3 255 5 6 3 255
                   5 6 3 255 6 7 3 255 7 10 4 255
                   6 9 4 255 6 10 4 255 7 11 4 255
                   7 11 4 255 9 14 4 255 10 15 4 255
                   11 18 6 255 10 15 6 255 11 16 6 255
                   14 22 9 255 15 22 9 255 13 17 7 255
                   14 18 7 255 23 33 11 255 15 21 8 255
                   12 20 6 255 18 27 10 255 32 39 16 255
                   11 18 6 0 9 14 5 0 9 14 5 0
                   10 15 6 0 11 17 7 0 9 14 5 0
                   0 0 0 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 16 32 6 0
                   16 32 6 0 18 36 7 0 69 69 41 0
                   55 58 31 0 46 49 24 255 18 34 7 255
                   15 21 7 255 10 16 5 255 10 18 5 255
                   18 35 6 255 22 40 7 255 22 39 8 255
                   16 28 7 255 13 24 6 255 13 26 6 255
                   13 23 6 255 17 32 7 255 16 30 7 255
                   13 23 6 255 9 17 5 255 7 14 4 255
                   8 15 4 255 7 13 4 255 6 11 4 255
                   6 9 3 255 5 9 3 255 5 7 3 255
                   5 9 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 6 10 4 255 6 10 4 255
                   7 13 4 255 7 13 4 255 7 13 4 255
                   7 13 4 255 6 9 3 255 7 13 4 255
                   7 13 4 255 6 10 4 255 7 13 4 255
                   9 18 4 255 9 17 4 255 7 11 4 255
                   5 9 3 255 5 7 3 255 5 7 4 255
                   6 7 4 255 6 11 4 255 9 18 5 255
                   8 14 4 255 6 9 3 255 5 7 3 255
                   5 7 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 5 6 4 255 5 7 3 255
                   6 10 4 255 6 10 4 255 7 10 5 255
                   9 11 5 255 14 18 9 255 11 18 7 255
                   11 18 7 255 8 13 5 255 6 9 4 255
                   6 9 4 255 6 9 4 255 6 9 4 255
                   6 9 4 255 6 7 4 255 8 13 4 255
                   6 7 3 255 6 7 4 255 6 7 4 255
                   6 7 4 255 6 9 4 255 7 10 4 255
                   7 11 4 255 8 14 5 255 8 13 4 255
                   8 11 4 255 7 11 4 255 8 13 4 255
                   7 13 4 255 6 10 3 255 6 9 3 255
                   5 6 3 255 5 7 3 255 5 7 3 255
                   5 6 3 255 5 7 3 255 6 7 3 255
                   6 9 3 255 6 10 4 255 7 13 4 255
                   9 15 4 255 12 19 5 255 11 18 5 255
                   14 20 8 255 13 18 6 255 21 24 11 255
                   7 9 4 255 5 8 3 255 10 16 6 255
                   17 28 10 255 12 19 6 255 13 21 7 255
                   13 20 7 255 14 21 7 255 21 30 11 255
                   7 10 4 0 12 18 7 0 12 18 8 0
                   9 12 5 0 6 10 3 0 0 0 0 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   79 78 46 0 57 57 29 0 18 24 9 255
                   14 24 5 213 17 32 7 0 34 40 17 255
                   17 25 6 255 12 22 6 255 13 24 5 255
                   13 26 6 255 18 34 7 255 18 34 7 255
                   12 24 5 255 11 23 5 255 11 19 5 255
                   9 17 4 255 10 19 5 255 9 17 5 255
                   9 17 5 255 8 13 4 255 9 17 4 255
                   7 14 4 255 6 11 4 255 6 10 4 255
                   6 10 4 255 6 9 3 255 6 9 3 255
                   6 9 3 255 5 7 3 255 5 6 3 255
                   5 6 3 255 5 7 3 255 7 11 4 255
                   10 19 4 255 9 18 4 255 10 20 5 255
                   10 19 5 255 14 28 6 255 11 22 6 255
                   8 14 4 255 6 13 4 255 10 20 5 255
                   14 28 6 255 13 26 5 255 11 20 5 255
                   9 15 5 255 9 14 4 255 7 11 4 255
                   7 11 4 255 9 15 4 255 9 14 4 255
                   5 7 3 255 5 6 3 255 5 7 3 255
                   5 7 3 255 5 6 3 255 5 7 4 255
                   5 7 4 255 5 7 4 255 6 10 4 255
                   6 10 4 255 6 9 4 255 6 9 4 255
                   7 10 5 255 8 10 5 255 10 13 7 255
                   7 10 5 255 6 9 4 255 6 9 4 255
                   6 10 4 255 8 13 4 255 10 14 5 255
                   16 18 9 255 8 13 4 255 14 15 8 255
                   7 9 4 255 6 7 3 255 5 7 3 255
                   6 9 3 255 8 11 5 255 8 13 4 255
                   8 13 4 255 8 13 4 255 8 13 4 255
                   8 13 4 255 6 10 3 255 5 7 3 255
                   5 7 3 255 5 6 3 255 4 6 3 255
                   5 7 3 255 6 7 4 255 6 7 3 255
                   5 7 3 255 5 7 3 255 5 7 3 255
                   6 9 4 255 7 13 4 255 9 15 4 255
                   11 18 5 255 11 18 5 255 11 17 5 255
                   10 15 5 255 14 18 7 255 7 9 4 255
                   7 8 3 255 14 20 7 255 17 26 10 255
                   13 21 7 255 15 25 8 255 12 22 7 255
                   15 22 7 255 25 35 13 255 10 15 6 0
                   9 12 6 0 9 12 6 0 6 7 4 0
                   4 6 2 0 7 11 3 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 39 45 17 0
                   20 26 10 0 27 30 14 255 28 28 14 255
                   30 32 16 255 19 24 9 255 14 22 6 255
                   13 22 6 255 14 24 7 255 14 24 5 255
                   14 24 5 255 13 23 6 255 14 24 5 255
                   10 20 4 255 10 19 5 255 10 18 4 255
                   10 18 5 255 12 22 5 255 13 24 6 255
                   13 23 6 255 12 20 6 255 9 17 5 255
                   6 13 4 255 6 11 4 255 6 10 4 255
                   6 11 4 255 6 9 3 255 6 9 3 255
                   6 9 4 255 5 7 3 255 5 7 3 255
                   5 9 4 255 7 11 4 255 9 18 4 255
                   10 20 5 255 10 20 5 255 16 31 7 255
                   18 34 8 255 12 24 6 255 10 19 5 255
                   9 17 4 255 13 23 6 255 19 35 8 255
                   22 43 8 255 18 36 7 255 16 30 7 255
                   11 19 5 255 6 10 4 255 6 10 4 255
                   8 13 4 255 7 11 4 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   5 6 3 255 5 7 4 255 5 7 4 255
                   6 7 4 255 10 13 6 255 9 11 6 255
                   7 10 4 255 6 10 4 255 6 9 4 255
                   7 10 5 255 7 9 4 255 6 9 4 255
                   6 9 4 255 6 10 4 255 6 10 4 255
                   8 11 5 255 13 16 6 255 26 27 15 255
                   28 27 16 255 9 11 5 255 6 9 4 255
                   6 9 4 255 6 9 4 255 6 7 4 255
                   6 9 4 255 7 10 4 255 6 10 4 255
                   6 9 3 255 6 9 3 255 6 10 3 255
                   5 7 3 255 5 7 3 255 6 7 3 255
                   5 7 3 255 5 7 3 255 6 7 3 255
                   7 9 4 255 6 9 3 255 6 9 4 255
                   6 10 4 255 6 9 4 255 7 11 4 255
                   9 17 4 255 10 17 4 255 10 15 4 255
                   10 17 4 255 10 16 4 255 10 15 4 255
                   9 14 4 255 13 17 6 255 14 16 7 255
                   10 12 5 255 10 14 5 255 10 16 5 255
                   10 15 5 255 13 18 6 255 23 29 10 255
                   28 37 13 255 27 37 14 255 39 44 18 255
                   18 36 7 0 18 36 7 0 19 37 8 0
                   19 37 8 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   47 56 20 0 39 48 17 255 18 27 8 255
                   14 19 7 255 13 17 7 255 13 19 7 255
                   16 24 7 255 15 24 7 255 16 27 7 255
                   13 20 6 255 14 24 5 255 9 15 4 255
                   17 27 6 255 15 27 6 255 12 23 5 255
                   15 27 7 255 15 26 7 255 14 23 6 255
                   14 23 7 255 18 31 8 255 18 31 7 255
                   16 28 7 255 12 22 6 255 9 17 5 255
                   7 13 4 255 7 11 4 255 6 11 4 255
                   6 9 3 255 6 10 3 255 6 10 4 255
                   6 10 4 255 6 10 3 255 6 10 4 255
                   6 9 3 255 6 10 3 255 9 19 4 255
                   10 19 4 255 11 20 5 255 17 35 6 255
                   20 40 7 255 15 31 7 255 14 26 6 255
                   15 26 7 255 16 26 7 255 18 32 6 255
                   15 28 6 255 11 20 5 255 6 10 3 255
                   5 7 3 255 6 9 4 255 6 9 4 255
                   5 7 4 255 5 6 3 255 5 7 3 255
                   5 6 3 255 5 7 3 255 6 9 4 255
                   6 9 4 255 6 7 4 255 6 7 4 255
                   7 10 5 255 7 10 4 255 10 13 6 255
                   7 10 4 255 6 9 4 255 6 9 4 255
                   6 9 4 255 6 9 4 255 6 10 4 255
                   7 11 4 255 7 10 4 255 6 10 4 255
                   8 10 5 255 10 13 6 255 10 13 6 255
                   6 10 4 255 6 9 4 255 6 9 4 255
                   6 9 4 255 6 9 4 255 6 7 4 255
                   5 7 3 255 5 7 3 255 5 6 3 255
                   5 6 3 255 5 6 3 255 5 7 3 255
                   5 7 3 255 6 9 3 255 6 9 3 255
                   6 7 3 255 6 9 3 255 7 10 4 255
                   6 9 3 255 6 9 4 255 6 10 4 255
                   6 10 4 255 6 10 4 255 7 11 4 255
                   7 11 4 255 7 11 4 255 9 14 4 255
                   9 12 4 255 8 12 4 255 12 15 6 255
                   15 19 8 255 18 20 10 255 10 13 6 255
                   9 10 4 255 12 16 5 255 17 19 7 255
                   16 17 8 255 26 29 13 255 22 33 12 255
                   22 35 12 255 37 47 18 255 18 36 7 0
                   19 36 8 0 19 36 9 0 19 36 8 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 67 74 32 0 45 60 16 0
                   28 43 11 255 19 30 8 255 14 21 7 255
                   18 25 9 255 26 35 12 255 36 50 14 229
                   29 41 11 255 23 35 10 255 18 28 8 255
                   14 24 5 255 9 15 4 255 15 26 6 255
                   20 35 8 255 19 32 8 255 21 34 9 255
                   24 34 11 255 21 30 8 255 17 26 7 255
                   21 34 8 255 20 35 8 255 16 27 7 255
                   13 22 6 255 11 20 5 255 10 18 5 255
                   8 14 4 255 7 13 4 255 8 13 4 255
                   8 14 4 255 7 14 4 255 7 14 4 255
                   8 14 4 255 7 13 4 255 6 10 4 255
                   6 11 4 255 7 11 4 255 6 10 4 255
                   6 9 3 255 9 15 4 255 15 28 5 255
                   19 37 7 255 16 30 6 255 11 15 5 255
                   8 11 4 255 7 10 4 255 6 7 3 255
                   5 6 3 255 5 6 3 255 5 6 3 255
                   6 7 4 255 6 7 3 255 6 7 3 255
                   5 7 3 255 5 6 3 255 5 6 3 255
                   5 7 3 255 7 13 4 255 8 13 4 255
                   7 11 4 255 7 11 4 255 13 17 8 255
                   10 13 6 255 11 14 7 255 8 11 5 255
                   6 11 4 255 7 10 4 255 6 9 4 255
                   6 9 4 255 6 10 4 255 8 13 4 255
                   7 11 4 255 6 9 4 255 6 7 3 255
                   7 10 4 255 9 13 5 255 6 10 4 255
                   6 9 4 255 6 10 4 255 6 10 4 255
                   6 9 4 255 6 9 3 255 5 7 3 255
                   5 7 3 255 5 6 3 255 5 6 2 255
                   5 6 3 255 5 7 3 255 6 7 3 255
                   6 9 3 255 6 9 3 255 6 9 4 255
                   9 11 5 255 6 10 4 255 6 9 4 255
                   6 9 4 255 7 10 4 255 6 10 4 255
                   6 9 4 255 6 10 3 255 9 12 4 255
                   13 17 6 255 18 20 9 255 11 12 6 255
                   12 12 6 255 21 22 11 255 14 17 7 255
                   17 20 9 255 12 15 6 255 10 14 5 255
                   17 22 8 255 25 26 12 255 12 17 6 255
                   12 17 7 255 16 22 10 255 22 32 13 255
                   42 52 23 255 19 37 9 0 19 36 8 0
                   19 36 9 0 19 36 8 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   89 91 47 0 64 75 25 0 44 60 15 0
                   32 47 12 0 27 39 11 255 15 21 8 255
                   43 46 25 20 46 52 19 255 40 49 16 255
                   27 36 11 255 22 32 10 255 14 24 6 255
                   14 24 7 255 10 18 5 255 17 32 7 255
                   14 24 6 255 23 36 9 255 20 28 8 255
                   20 27 8 255 18 24 7 255 15 22 6 255
)"
        R"(                   14 24 5 255 13 22 7 255 11 18 5 255
                   9 15 4 255 8 15 4 255 7 14 4 255
                   7 13 4 255 9 17 4 255 9 15 4 255
                   8 14 4 255 7 13 4 255 8 13 4 255
                   9 15 4 255 8 14 4 255 7 11 4 255
                   6 9 3 255 5 7 3 255 5 7 3 255
                   5 9 3 255 6 9 3 255 7 11 4 255
                   7 11 4 255 5 7 3 255 5 7 3 255
                   6 7 3 255 5 6 3 255 6 7 3 255
                   5 6 3 255 5 6 2 255 5 6 3 255
                   4 6 3 255 5 6 3 255 5 7 3 255
                   5 7 4 255 5 7 3 255 5 6 4 255
                   6 9 4 255 7 13 4 255 7 11 4 255
                   8 15 5 255 12 20 7 255 11 18 6 255
                   9 17 6 255 7 10 4 255 7 10 4 255
                   6 9 4 255 6 10 4 255 6 10 4 255
                   6 10 4 255 6 10 4 255 7 10 4 255
                   7 11 4 255 6 10 4 255 6 9 4 255
                   7 9 4 255 6 9 4 255 6 9 4 255
                   7 10 4 255 8 13 4 255 8 11 4 255
                   6 10 3 255 6 10 4 255 5 7 3 255
                   5 7 3 255 6 7 3 255 5 7 3 255
                   6 7 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 5 7 3 255 6 9 3 255
                   6 9 4 255 6 9 3 255 6 9 4 255
                   7 10 4 255 8 11 4 255 7 11 4 255
                   11 14 5 255 15 18 8 255 22 23 10 255
                   19 20 9 255 10 11 5 255 12 13 6 255
                   23 26 11 255 19 22 9 255 12 17 6 255
                   11 15 6 255 9 13 5 255 10 16 6 255
                   12 17 6 255 11 17 6 255 17 23 10 255
                   31 36 18 255 15 30 7 0 19 37 9 0
                   19 37 9 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 94 94 52 0
                   70 81 31 0 57 68 23 0 65 74 30 0
                   55 64 24 0 36 39 21 0 31 37 19 0
                   38 46 17 255 23 32 9 255 18 31 8 255
                   13 22 6 255 10 17 5 255 11 19 5 255
                   12 22 6 255 10 18 5 255 11 20 5 255
                   16 26 7 255 13 19 5 255 12 19 5 255
                   11 19 5 255 12 20 5 255 12 22 5 255
                   10 18 4 255 9 15 4 255 8 14 4 255
                   8 14 4 255 9 15 4 255 10 17 4 255
                   9 18 4 255 9 18 4 255 8 17 4 255
                   7 14 4 255 8 14 4 255 8 14 4 255
                   8 14 4 255 8 13 4 255 5 9 3 255
                   5 9 3 255 6 9 3 255 6 10 4 255
                   6 9 3 255 5 9 3 255 5 7 3 255
                   5 6 3 255 5 6 3 255 5 7 3 255
                   5 9 3 255 6 9 4 255 6 9 4 255
                   5 7 3 255 6 9 4 255 5 7 4 255
                   5 6 3 255 5 7 3 255 6 9 4 255
                   5 9 3 255 6 9 4 255 6 9 4 255
                   6 9 4 255 6 10 4 255 7 14 4 255
                   12 23 6 255 12 23 6 255 11 19 6 255
                   7 11 4 255 7 11 4 255 6 9 4 255
                   6 10 4 255 6 9 4 255 6 9 4 255
                   6 10 4 255 7 13 4 255 7 13 4 255
                   8 13 4 255 7 11 4 255 8 13 4 255
                   8 13 4 255 8 13 4 255 9 14 4 255
                   9 14 4 255 9 15 4 255 9 17 4 255
                   10 18 4 255 7 10 3 255 8 13 4 255
                   13 17 6 255 9 11 5 255 5 6 3 255
                   6 7 3 255 6 9 3 255 6 9 4 255
                   6 9 3 255 6 9 4 255 6 10 4 255
                   7 10 4 255 8 11 5 255 8 11 4 255
                   10 14 6 255 11 14 5 255 12 13 5 255
                   21 23 11 255 26 26 15 240 16 18 8 255
                   9 13 4 255 11 17 5 255 16 22 8 255
                   19 23 9 255 13 18 7 255 13 19 6 255
                   12 18 6 255 12 17 6 255 13 19 6 255
                   24 29 14 255 64 69 39 0 18 36 7 0
                   18 36 7 0 18 36 8 0 18 36 8 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   102 100 64 0 18 36 7 0 18 36 7 0
                   12 22 5 0 38 42 21 0 27 40 11 0
                   15 26 7 0 16 28 6 255 12 22 6 255
                   8 14 5 255 7 13 4 255 7 13 4 255
                   8 14 4 255 9 15 4 255 13 22 7 255
                   13 20 6 255 12 19 5 255 17 30 7 255
                   17 32 7 255 16 30 7 255 11 22 5 255
                   10 18 4 255 9 15 4 255 10 18 4 255
                   12 22 5 255 13 26 5 255 12 24 5 255
                   13 26 6 255 11 22 5 255 9 18 4 255
                   9 18 4 255 10 20 5 255 11 22 5 255
                   10 19 5 255 9 19 4 255 8 14 4 255
                   6 11 4 255 6 11 4 255 6 9 3 255
                   5 7 3 255 5 7 3 255 5 6 3 255
                   5 6 3 255 5 7 3 255 9 15 5 255
                   10 18 5 255 9 17 5 255 8 14 4 255
                   9 15 6 255 7 11 5 255 6 9 4 255
                   6 7 4 255 6 9 4 255 6 10 4 255
                   9 13 5 255 7 10 4 255 6 9 4 255
                   6 11 4 255 6 10 4 255 8 14 4 255
                   9 15 4 255 9 14 4 255 10 15 5 255
                   8 13 4 255 6 10 4 255 7 10 4 255
                   7 11 4 255 7 11 4 255 7 11 4 255
                   6 10 4 255 6 9 3 255 7 11 3 255
                   7 11 4 255 11 18 5 255 10 15 4 255
                   9 15 4 255 9 15 4 255 10 15 4 255
                   11 18 5 255 12 19 5 255 11 18 4 255
                   9 15 5 255 7 11 4 255 8 13 4 255
                   9 13 4 255 6 9 3 255 6 7 3 255
                   6 9 3 255 7 10 4 255 6 10 4 255
                   7 10 4 255 9 14 5 255 12 16 6 255
                   18 20 9 255 11 12 6 255 8 10 4 255
                   8 13 4 255 9 13 5 255 12 16 5 255
                   15 19 8 255 12 17 6 255 12 18 6 255
                   12 18 6 255 15 21 9 255 15 19 8 255
                   11 15 6 255 9 12 5 255 8 13 5 255
                   11 17 6 255 20 28 9 255 30 37 13 255
                   29 37 13 255 27 34 12 255 36 38 17 255
                   32 39 17 255 20 37 10 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   71 81 35 0 29 43 11 0 15 27 7 255
                   17 34 7 255 12 22 6 255 8 14 4 255
                   7 13 4 255 10 18 5 255 12 20 5 255
                   11 20 4 255 14 23 6 255 13 22 6 255
                   16 28 7 255 24 41 8 255 27 48 8 244
                   24 44 7 255 18 35 7 255 16 30 7 255
                   14 27 6 255 17 32 7 255 20 37 7 255
                   20 37 7 255 17 32 6 255 18 34 7 255
                   16 30 6 255 15 31 6 255 15 31 6 255
                   15 31 6 255 16 31 7 255 18 34 7 255
                   13 26 6 255 9 18 5 255 6 10 4 255
                   6 9 3 255 5 7 3 255 5 7 3 255
                   5 7 3 255 5 7 3 255 6 9 3 255
                   7 14 4 255 14 27 7 255 20 37 9 255
                   18 32 8 255 15 28 7 255 13 23 7 255
                   10 19 6 255 10 19 6 255 7 13 5 255
                   6 10 4 255 6 9 4 255 7 10 4 255
                   6 9 4 255 6 10 4 255 7 11 4 255
                   7 13 4 255 9 14 5 255 7 11 4 255
                   9 14 6 255 11 15 6 255 7 11 4 255
                   6 10 4 255 6 9 4 255 7 11 4 255
                   7 14 4 255 7 13 4 255 7 13 4 255
                   7 10 4 255 6 10 4 255 7 10 4 255
                   9 14 5 255 9 13 4 255 9 15 4 255
                   11 19 5 255 12 20 6 255 12 20 6 255
                   13 22 6 255 11 17 5 255 14 24 6 255
                   13 23 6 255 14 26 6 255 12 22 5 255
                   12 19 5 255 8 13 4 255 8 10 4 255
                   7 10 4 255 7 10 4 255 7 10 4 255
                   8 13 4 255 11 14 5 255 15 18 8 255
                   9 12 4 255 7 12 4 255 10 15 5 255
                   10 18 5 255 12 20 6 255 11 18 6 255
                   11 18 6 255 14 22 8 255 17 26 9 255
                   22 28 11 255 14 19 7 255 10 15 6 255
                   10 13 5 255 9 14 5 255 13 19 7 255
                   21 35 12 255 11 21 8 255 11 21 8 255
                   37 41 20 255 15 21 8 255 17 23 9 255
                   20 37 10 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 77 83 41 0
                   32 45 12 255 17 32 6 255 20 36 7 255
                   18 34 8 255 14 26 6 255 13 22 6 255
                   18 31 7 255 19 34 7 255 14 27 6 255
                   17 32 7 255 18 31 8 255 19 31 8 255
                   22 36 9 255 24 39 9 255 27 47 8 255
                   25 43 8 255 23 41 7 255 15 27 6 255
                   15 26 5 255 18 31 6 255 24 43 7 255
                   26 48 7 255 22 39 7 255 22 40 7 255
                   18 34 6 255 17 31 6 255 14 24 5 255
                   14 26 6 255 17 32 8 255 12 23 6 255
                   11 20 6 255 7 13 4 255 7 11 4 255
                   7 11 4 255 6 10 3 255 5 6 3 255
                   5 7 3 255 6 10 4 255 8 14 5 255
                   8 15 4 255 10 19 6 255 17 31 8 255
                   17 30 8 255 13 23 7 255 13 24 7 255
                   17 32 8 255 15 30 7 255 10 20 6 255
                   9 17 5 255 8 17 5 255 7 13 5 255
                   9 15 5 255 10 19 6 255 11 20 6 255
                   10 18 6 255 10 18 6 255 9 15 5 255
                   9 14 5 255 8 13 4 255 7 13 4 255
                   8 15 5 255 7 14 4 255 8 14 4 255
                   8 14 4 255 9 17 5 255 8 15 4 255
                   8 14 4 255 9 15 4 255 11 18 5 255
                   11 19 5 255 13 23 6 255 15 27 7 255
                   17 31 7 255 16 31 7 255 17 30 7 255
                   13 22 6 255 16 27 7 255 16 27 7 255
                   16 27 7 255 16 28 7 255 18 31 8 255
                   14 20 7 255 9 13 5 255 7 9 4 255
                   6 9 4 255 6 10 4 255 7 11 4 255
                   12 15 6 255 19 22 10 255 13 16 8 255
                   10 14 6 255 12 19 6 255 16 28 8 255
                   17 26 9 255 13 21 7 255 17 23 8 255
                   17 24 8 255 20 28 10 255 19 23 10 255
                   17 22 9 255 16 22 9 255 17 26 9 255
                   19 28 10 255 20 29 10 255 20 35 12 219
                   11 21 8 255 22 30 12 255 17 33 7 0
                   34 39 21 255 28 33 14 255 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 54 64 23 0 22 36 8 255
                   18 31 7 255 19 30 7 255 23 34 10 0
                   27 37 12 0 24 32 11 255 21 32 9 255
                   26 43 9 255 24 40 9 255 21 34 8 255
                   22 37 9 255 23 37 9 255 19 32 8 255
                   20 32 8 255 21 34 7 255 17 28 6 255
                   17 28 6 255 11 19 5 255 9 14 4 255
                   8 13 4 255 11 17 5 255 15 23 5 255
                   13 20 5 255 16 28 5 255 12 19 5 255
                   8 11 4 255 7 9 3 255 7 10 4 255
                   11 19 5 255 14 27 7 255 15 31 8 255
                   13 24 6 255 13 26 7 255 11 20 5 255
                   7 13 4 255 6 9 3 255 6 7 3 255
                   6 9 4 255 6 10 4 255 7 13 4 255
                   7 11 4 255 7 11 4 255 8 13 4 255
                   7 13 4 255 9 18 5 255 15 28 7 255
                   21 39 9 255 23 40 9 255 17 31 8 255
                   14 26 7 255 14 27 7 255 15 26 7 255
                   12 22 7 255 11 18 5 255 10 18 5 255
                   11 22 6 255 11 19 5 255 13 24 7 255
                   13 24 7 255 10 18 4 255 9 17 4 255
                   9 17 4 255 10 17 4 255 11 19 5 255
                   15 26 6 255 13 24 6 255 11 19 5 255
                   10 19 4 255 13 22 5 255 13 22 6 255
                   12 19 5 255 12 18 5 255 13 23 5 255
                   15 27 6 255 15 24 6 255 10 17 4 255
                   11 18 5 255 10 17 5 255 13 22 5 255
                   16 27 7 255 18 28 7 255 12 18 6 255
                   7 10 4 255 6 9 4 255 6 10 4 255
                   8 11 4 255 7 11 4 255 7 11 4 255
                   10 14 5 255 11 14 6 255 9 15 6 255
                   13 19 7 255 18 24 9 255 18 22 8 255
                   26 32 15 255 24 26 12 255 10 11 5 255
                   17 18 9 255 22 26 10 255 27 31 16 0
                   36 39 21 255 31 40 15 255 35 44 17 255
                   17 23 8 255 15 20 8 255 15 27 9 255
                   17 33 7 0 17 33 7 0 15 29 6 0
                   15 29 6 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   75 82 41 0 57 68 29 0 60 68 33 0
                   50 53 30 0 46 49 28 0 58 65 32 0
                   48 53 24 102 31 40 13 255 22 30 9 255
                   16 24 7 255 13 19 6 255 16 23 7 255
                   22 32 8 255 24 34 9 255 20 27 8 255
                   14 22 6 255 15 23 6 255 13 22 6 255
                   11 19 5 255 9 17 5 255 9 15 5 255
                   9 14 4 255 9 14 4 255 7 11 4 255
                   7 11 4 255 6 10 4 255 7 10 4 255
                   6 9 4 255 6 10 3 255 12 22 6 255
                   15 30 8 255 13 26 7 255 11 22 6 255
                   12 22 6 255 10 18 5 255 8 15 4 255
                   7 13 4 255 7 11 4 255 6 10 4 255
                   6 9 4 255 5 9 3 255 5 7 3 255
                   5 7 3 255 5 9 3 255 8 15 4 255
                   10 20 5 255 9 17 4 255 12 24 6 255
                   24 45 9 255 25 45 9 255 21 39 8 255
                   20 39 8 255 17 31 7 255 11 20 6 255
                   8 13 5 255 6 9 4 255 7 11 4 255
                   11 18 6 255 14 24 7 255 13 24 7 255
                   14 28 7 255 11 20 5 255 10 19 5 255
                   15 27 7 255 17 28 7 255 17 32 7 255
                   17 32 7 255 15 28 6 255 12 23 5 255
                   12 20 5 255 9 15 5 255 6 9 3 255
                   6 7 3 255 6 9 3 255 6 10 4 255
                   7 10 4 255 7 11 4 255 7 10 4 255
                   8 14 4 255 10 19 5 255 8 15 4 255
                   8 14 4 255 9 15 4 255 9 14 4 255
                   7 11 4 255 8 11 4 255 9 14 4 255
                   8 14 4 255 8 14 4 255 10 17 5 255
                   10 17 5 255 10 16 6 255 11 16 7 255
                   9 12 5 255 9 12 5 255 16 20 9 255
                   10 13 5 255 7 9 4 255 11 14 6 255
                   13 17 6 255 28 33 15 0 11 24 6 0
                   15 31 7 0 16 33 7 0 12 23 6 0
                   20 27 10 255 33 42 18 255 17 33 7 0
                   17 33 7 0 15 29 6 0 15 29 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 14 28 6 0
                   14 28 6 0 18 36 7 0 16 30 7 0
                   59 62 37 0 35 42 17 255 18 24 8 255
                   14 22 5 255 12 18 5 255 9 15 4 255
                   7 11 4 255 9 13 5 255 12 15 6 255
                   20 24 9 255 20 26 9 255 12 18 5 255
                   14 26 6 255 16 28 7 255 11 19 5 255
                   10 18 5 255 11 19 5 255 10 18 4 255
                   10 17 4 255 11 15 4 255 8 13 4 255
                   7 11 4 255 7 11 4 255 8 11 4 255
                   7 11 4 255 10 18 5 255 13 24 6 255
                   16 27 8 255 14 26 7 255 13 23 6 255
                   10 19 5 255 12 23 5 255 11 22 5 255
                   10 19 5 255 7 13 4 255 7 11 4 255
                   5 9 3 255 5 7 3 255 5 7 3 255
                   6 7 3 255 6 9 4 255 7 13 4 255
                   8 14 4 255 11 20 5 255 16 31 7 255
)"
        R"(                   19 34 7 255 18 32 7 255 16 30 6 255
                   13 24 6 255 7 13 4 255 6 9 4 255
                   6 9 4 255 6 9 4 255 9 17 5 255
                   16 28 8 255 16 27 8 255 18 32 8 255
                   13 23 6 255 13 24 6 255 14 26 6 255
                   11 19 5 255 10 18 4 255 14 23 6 255
                   17 30 7 255 20 35 8 255 21 35 8 255
                   13 19 6 255 7 10 4 255 7 9 4 255
                   6 9 4 255 6 10 4 255 6 10 4 255
                   6 9 4 255 6 9 4 255 7 11 4 255
                   7 11 4 255 7 10 4 255 12 17 7 255
                   11 17 6 255 8 14 4 255 7 12 5 255
                   7 12 5 255 8 14 4 255 10 17 5 255
                   10 17 6 255 12 20 6 255 13 20 7 255
                   11 19 6 255 9 14 6 255 8 12 4 255
                   9 15 5 255 8 14 5 255 10 16 5 255
                   14 20 7 255 12 15 7 0 8 13 4 0
                   23 25 14 0 10 20 6 0 13 25 6 0
                   15 29 6 0 16 33 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 13 26 6 0 13 26 6 0
                   16 32 7 0 14 26 6 0 46 48 25 0
                   35 38 18 255 19 24 9 255 14 20 6 255
                   12 18 5 255 10 15 4 255 7 13 4 255
                   8 11 4 255 11 14 5 255 14 18 6 255
                   24 31 10 255 23 34 9 255 20 31 8 255
                   21 34 9 255 13 22 6 255 10 18 5 255
                   9 15 4 255 9 15 4 255 9 14 4 255
                   10 15 4 255 10 15 4 255 8 13 4 255
                   8 11 4 255 7 11 4 255 8 13 4 255
                   12 19 5 255 15 26 6 255 13 19 5 255
                   12 20 5 255 14 23 6 255 10 18 5 255
                   10 18 4 255 11 22 5 255 11 19 4 255
                   10 19 5 255 8 14 5 255 6 10 3 255
                   6 11 4 255 5 9 4 255 5 9 3 255
                   6 7 4 255 5 7 3 255 6 9 3 255
                   7 11 4 255 9 17 5 255 8 13 4 255
                   6 10 4 255 6 10 4 255 6 13 4 255
                   6 10 4 255 7 10 4 255 6 10 4 255
                   6 10 4 255 8 14 4 255 12 20 6 255
                   13 23 7 255 20 36 8 255 17 32 7 255
                   15 27 6 255 12 23 5 255 8 13 4 255
                   7 10 4 255 7 10 4 255 18 24 9 255
                   38 45 19 255 37 45 18 255 31 35 16 255
                   14 17 7 255 8 10 5 255 8 11 5 255
                   7 10 4 255 6 10 4 255 6 10 4 255
                   6 10 4 255 6 10 4 255 6 10 4 255
                   7 10 4 255 9 13 5 255 8 11 4 255
                   7 9 4 255 7 11 5 255 7 13 5 255
                   9 15 5 255 10 17 5 255 10 17 6 255
                   11 19 5 255 15 23 7 255 16 23 7 255
                   15 20 7 255 12 17 6 255 11 16 6 255
                   9 13 5 255 11 15 6 255 13 18 7 255
                   10 15 7 255 9 14 5 255 9 14 5 0
                   13 25 6 0 15 29 6 0 16 31 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   16 33 7 0 16 33 7 0 16 32 7 0
                   14 26 6 0 36 39 20 0 33 37 16 0
                   33 37 16 255 20 23 9 255 15 19 8 255
                   11 17 6 255 8 11 5 255 10 14 6 255
                   13 17 6 255 20 23 10 255 25 30 11 255
                   24 34 10 255 25 37 10 255 25 36 10 255
                   24 36 11 255 16 27 7 255 11 18 5 255
                   10 17 5 255 12 19 5 255 10 18 5 255
                   10 17 5 255 9 15 5 255 10 15 5 255
                   9 15 4 255 10 15 5 255 11 19 5 255
                   14 26 6 255 13 22 6 255 12 20 6 255
                   12 20 5 255 11 22 5 255 11 20 5 255
                   11 19 5 255 9 15 4 255 7 13 4 255
                   7 11 4 255 7 14 4 255 11 22 5 255
                   11 20 5 255 7 13 4 255 6 9 4 255
                   5 7 4 255 6 7 4 255 6 7 4 255
                   6 9 3 255 6 7 4 255 6 10 4 255
                   6 11 4 255 7 13 4 255 8 13 4 255
                   9 15 5 255 8 13 5 255 6 9 4 255
                   7 10 4 255 7 10 4 255 7 11 4 255
                   11 20 5 255 16 31 6 255 19 36 7 255
                   16 28 6 255 13 23 6 255 8 13 4 255
                   9 11 5 255 20 22 11 255 21 22 12 255
                   20 22 10 255 21 23 11 255 16 18 8 255
                   13 15 7 255 31 35 18 235 21 24 12 255
                   12 17 6 255 9 14 5 255 8 11 4 255
                   9 14 5 255 9 14 5 255 11 15 6 255
                   9 14 5 255 8 11 4 255 6 10 4 255
                   7 10 4 255 8 14 4 255 10 17 5 255
                   10 17 5 255 11 18 6 255 14 22 7 255
                   25 31 12 255 28 33 12 255 40 42 20 255
                   16 18 9 255 11 14 6 255 11 17 7 255
                   11 16 6 255 19 23 10 255 22 25 10 255
                   20 25 11 255 8 16 5 0 8 15 3 0
                   12 22 5 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   63 63 44 0 34 38 22 0 32 37 17 0
                   41 42 22 0 53 52 31 0 44 45 25 0
                   21 23 11 0 18 36 7 255 36 35 18 255
                   45 48 23 255 42 51 18 255 35 51 14 255
                   31 41 12 255 28 39 11 255 33 47 13 255
                   23 37 10 255 15 27 7 255 13 23 6 255
                   15 27 7 255 17 28 7 255 15 26 7 255
                   17 28 7 255 14 22 6 255 13 23 7 255
                   15 23 8 255 12 19 6 255 15 22 8 255
                   16 26 7 255 23 39 8 255 21 37 7 255
                   17 31 6 255 15 30 6 255 14 27 6 255
                   11 18 5 255 8 15 5 255 7 14 4 255
                   9 18 5 255 14 27 6 255 15 30 7 255
                   13 24 6 255 8 13 5 255 6 10 4 255
                   6 9 4 255 6 9 4 255 7 13 4 255
                   8 13 5 255 7 11 4 255 7 13 4 255
                   6 11 4 255 7 11 4 255 7 13 4 255
                   7 10 4 255 6 9 4 255 6 9 4 255
                   6 7 4 255 6 9 4 255 6 9 4 255
                   9 15 4 255 16 31 6 255 18 34 6 255
                   12 20 5 255 8 11 4 255 8 11 5 255
                   9 11 5 255 8 11 4 255 18 20 9 255
                   21 22 10 255 27 28 14 255 23 23 13 255
                   24 27 13 255 24 27 12 255 17 23 8 255
                   24 34 10 255 15 19 8 255 8 13 5 255
                   9 14 4 255 10 15 5 255 8 14 4 255
                   8 13 4 255 8 14 4 255 9 15 5 255
                   11 18 6 255 11 17 6 255 11 17 5 255
                   12 19 7 255 16 25 7 255 22 31 10 255
                   25 30 11 255 27 31 14 255 28 34 15 255
                   28 34 15 255 22 28 10 255 27 31 13 255
                   20 24 11 255 15 19 9 255 21 26 11 255
                   17 20 9 255 15 18 7 255 12 22 5 0
                   18 36 7 0 15 29 6 0 15 29 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 16 30 7 0 55 56 36 0
                   28 32 15 0 24 26 12 0 33 35 17 0
                   61 58 34 0 72 70 43 0 44 45 24 0
                   23 26 13 0 37 37 23 0 76 78 51 0
                   86 90 51 0 68 75 35 0 41 49 17 0
                   38 49 14 0 47 60 17 0 37 52 14 255
                   32 47 13 255 30 45 12 255 27 40 10 255
                   33 48 14 255 35 48 15 255 36 51 14 255
                   29 44 10 255 29 45 12 255 29 40 12 255
                   25 35 10 255 27 35 13 255 31 39 15 255
                   38 49 14 255 28 45 8 255 23 41 7 255
                   23 41 7 255 18 32 7 255 11 19 5 255
                   12 23 6 255 15 27 8 255 11 19 6 255
                   9 17 5 255 9 17 5 255 10 17 5 255
                   8 13 5 255 6 10 4 255 6 10 4 255
                   7 11 4 255 10 18 5 255 12 23 6 255
                   11 20 5 255 10 18 5 255 9 15 5 255
                   8 14 4 255 6 9 4 255 6 9 4 255
                   7 10 4 255 7 10 4 255 6 9 4 255
                   7 10 5 255 9 10 5 255 6 7 4 255
                   7 10 4 255 8 13 4 255 8 13 4 255
                   10 13 6 255 12 15 7 255 9 11 5 255
                   7 13 4 255 8 13 4 255 9 13 4 255
                   19 22 10 255 18 19 10 255 7 10 4 255
                   10 13 5 255 10 13 5 255 11 15 6 255
                   9 13 5 255 6 9 4 255 8 11 4 255
                   9 15 4 255 8 14 4 255 9 15 4 255
                   10 17 5 255 12 19 6 255 12 21 7 255
                   13 23 7 255 14 25 7 255 15 25 7 255
                   14 22 6 255 15 22 7 255 15 20 8 255
                   17 20 9 255 36 39 18 255 25 27 13 255
                   27 31 13 255 45 48 23 0 27 31 13 0
                   12 17 6 255 14 20 8 255 11 15 6 255
                   15 21 8 255 17 33 7 0 18 36 7 0
                   15 29 6 0 15 29 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   16 30 7 0 12 22 5 0 32 36 16 0
                   32 36 16 0 30 35 14 0 27 31 13 0
                   28 31 13 0 34 36 17 0 48 49 28 0
                   64 62 40 0 82 78 54 0 75 74 50 0
                   85 85 54 0 39 40 20 255 27 31 12 255
                   34 40 15 255 56 64 30 0 61 62 33 0
                   56 61 29 0 41 51 16 255 34 43 14 255
                   46 49 23 255 51 53 26 255 29 35 12 255
                   26 34 11 255 41 45 19 255 44 47 21 255
                   24 27 11 255 15 19 8 255 14 20 6 255
                   15 24 6 255 20 34 7 255 17 27 6 255
                   11 19 5 255 11 22 5 255 15 28 7 255
                   17 30 9 255 17 30 8 255 10 18 5 255
                   7 13 5 255 7 10 4 255 8 13 5 255
                   7 10 4 255 6 9 4 255 7 11 4 255
                   8 15 4 255 13 26 7 255 14 26 7 255
                   11 19 6 255 7 11 4 255 7 10 4 255
                   6 9 4 255 7 11 4 255 11 15 6 255
                   19 23 10 255 20 22 11 255 14 18 7 255
                   16 19 9 255 7 10 4 255 7 10 4 255
                   6 9 4 255 6 10 4 255 8 13 4 255
                   8 13 4 255 6 9 4 255 8 13 4 255
                   12 20 5 255 13 22 7 255 20 26 10 255
                   17 19 9 255 9 14 5 255 8 13 5 255
                   9 14 4 255 8 13 4 255 6 10 4 255
                   6 10 4 255 7 10 4 255 8 13 4 255
                   9 15 4 255 10 18 5 255 13 22 6 255
                   14 23 7 255 14 24 7 255 14 25 6 255
                   15 26 7 255 17 28 8 255 14 22 6 255
                   12 18 6 255 15 22 7 255 26 31 13 255
                   19 21 9 255 15 17 7 255 21 23 10 255
                   31 34 15 255 27 31 13 255 22 31 10 255
                   26 37 12 255 22 30 10 255 31 38 17 255
                   17 33 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   11 20 4 0 22 28 10 255 28 35 12 255
                   26 31 12 255 20 24 9 255 18 24 8 255
                   20 24 9 255 22 24 11 0 31 31 17 0
                   25 24 13 0 25 27 15 255 48 47 30 255
                   24 24 13 255 10 14 5 255 7 10 4 255
                   11 13 6 255 19 18 10 255 25 26 14 255
                   23 24 11 255 12 15 6 255 19 20 10 255
                   21 24 10 255 14 19 6 255 9 14 5 255
                   14 17 8 255 19 23 9 255 23 32 10 255
                   27 39 11 255 18 28 8 255 14 23 6 255
                   12 20 6 255 9 14 4 255 8 14 5 255
                   12 22 7 255 12 22 7 255 11 19 6 255
                   12 22 7 255 10 18 6 255 10 18 5 255
                   9 18 5 255 8 13 5 255 7 10 4 255
                   6 9 4 255 7 11 4 255 10 17 6 255
                   11 20 6 255 9 15 5 255 6 10 4 255
                   6 7 4 255 6 9 4 255 7 10 4 255
                   8 13 5 255 14 20 8 255 20 26 10 255
                   20 26 10 255 12 17 6 255 11 18 6 255
                   9 15 5 255 9 14 4 255 7 11 4 255
                   7 13 4 255 11 22 5 255 11 20 5 255
                   8 13 4 255 7 10 4 255 9 15 5 255
                   16 28 8 255 15 26 7 255 14 23 7 255
                   15 23 7 255 13 20 6 255 10 15 5 255
                   7 13 4 255 7 10 4 255 9 13 4 255
                   12 17 6 255 11 17 6 255 12 19 5 255
                   15 24 7 255 16 26 8 255 20 32 9 255
                   20 31 9 255 14 20 6 255 12 20 5 255
                   22 35 9 255 21 34 9 255 15 23 7 255
                   12 19 6 255 13 18 6 255 12 14 7 255
                   16 17 10 255 38 41 24 255 14 28 6 0
                   18 36 7 0 18 36 7 0 17 32 7 0
                   17 32 7 0 16 32 6 0 16 32 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 7 14 4 0
                   16 20 9 255 30 36 15 255 18 25 10 255
                   18 24 9 255 16 23 8 255 13 20 7 255
                   10 17 5 255 8 13 4 255 9 14 5 255
                   9 13 5 255 9 13 5 255 8 11 5 255
                   9 13 5 255 8 13 4 255 7 10 4 255
                   6 9 3 255 7 9 4 255 9 11 5 255
                   11 14 6 255 10 13 5 255 12 19 6 255
                   17 30 7 255 13 24 6 255 8 14 4 255
                   11 17 6 255 19 28 8 255 19 31 8 255
                   18 30 8 255 23 36 10 255 17 27 8 255
                   10 17 5 255 8 13 4 255 10 17 6 255
                   13 23 8 255 11 19 7 255 9 14 6 255
                   10 14 6 255 12 22 6 255 15 30 7 255
                   11 20 6 255 8 13 5 255 7 13 4 255
                   9 15 5 255 11 18 6 255 13 23 7 255
                   11 19 6 255 7 11 4 255 6 9 4 255
                   8 13 5 255 10 15 5 255 8 13 5 255
                   10 15 6 255 13 19 7 255 12 18 6 255
                   8 14 4 255 7 14 4 255 8 14 4 255
                   7 11 4 255 6 10 4 255 7 13 4 255
                   14 26 5 255 19 35 7 255 15 26 7 255
                   9 15 5 255 8 13 4 255 12 20 6 255
                   12 22 6 255 15 26 7 255 14 23 7 255
                   12 19 6 255 9 14 5 255 8 13 4 255
                   8 13 4 255 10 15 5 255 12 20 6 255
)"
        R"(                   11 16 6 255 8 12 5 255 11 17 5 255
                   15 25 8 255 15 23 8 255 16 21 8 255
                   12 13 6 255 8 9 5 255 9 11 5 255
                   7 8 3 242 7 10 3 255 11 16 6 255
                   12 15 5 255 9 11 5 82 8 11 4 0
                   9 15 5 0 9 15 5 0 11 19 5 0
                   10 17 5 0 11 21 5 0 12 22 5 0
                   14 26 5 0 14 26 5 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 8 16 4 0 7 15 4 0
                   18 24 9 255 38 42 20 255 46 52 27 255
                   41 48 21 255 21 31 10 255 14 22 7 255
                   10 15 5 255 10 15 5 255 10 15 5 255
                   9 14 5 255 10 14 6 255 13 17 7 255
                   10 14 5 255 10 15 6 255 9 14 5 255
                   6 9 4 255 6 9 3 255 8 10 5 255
                   7 9 4 255 7 11 4 255 16 26 7 255
                   18 32 8 255 13 23 6 255 9 17 5 255
                   9 17 5 255 8 14 4 255 9 15 5 255
                   12 19 5 255 13 20 6 255 10 17 5 255
                   9 15 4 255 10 18 5 255 14 23 8 255
                   11 18 6 255 9 15 5 255 8 14 5 255
                   7 13 4 255 9 17 6 255 9 15 5 255
                   7 11 4 255 9 18 4 255 13 24 6 255
                   10 19 5 255 11 20 6 255 12 22 6 255
                   9 15 5 255 7 10 4 255 8 14 5 255
                   9 15 5 255 9 15 5 255 7 11 4 255
                   7 10 4 255 10 14 6 255 7 10 4 255
                   6 10 4 255 7 10 4 255 8 11 5 255
                   7 11 4 255 7 11 4 255 10 18 5 255
                   16 28 7 255 13 20 6 255 10 15 5 255
                   8 13 4 255 8 13 4 255 9 14 4 255
                   10 15 5 255 9 14 4 255 9 13 4 255
                   8 13 4 255 10 14 5 255 10 15 5 255
                   11 17 6 255 12 19 6 255 12 20 7 255
                   12 18 5 255 11 17 5 255 11 15 5 255
                   8 12 4 255 9 12 4 255 9 10 4 255
                   7 10 4 255 5 8 3 255 5 6 3 255
                   7 10 3 255 15 17 8 255 13 16 8 0
                   5 7 3 0 6 8 3 0 8 11 3 0
                   8 12 3 0 11 19 5 0 9 16 5 0
                   11 21 5 0 13 25 5 0 15 29 6 0
                   15 29 6 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 16 32 7 0
                   13 23 7 0 14 25 7 0 29 32 15 255
                   23 26 11 255 33 36 17 255 31 35 15 255
                   23 30 11 255 19 27 10 255 12 19 7 255
                   11 17 6 255 12 18 6 255 10 14 5 255
                   9 14 5 255 11 14 6 255 10 13 5 255
                   10 13 5 255 9 13 5 255 6 10 4 255
                   6 9 4 255 6 9 4 255 6 9 4 255
                   9 17 5 255 14 24 6 255 17 32 7 255
                   19 35 8 255 16 28 7 255 13 26 7 255
                   10 18 5 255 9 15 4 255 9 15 4 255
                   8 14 4 255 7 13 4 255 8 15 4 255
                   14 27 7 255 19 35 9 255 15 26 7 255
                   11 19 6 255 9 14 5 255 9 15 5 255
                   11 19 7 255 9 14 6 255 7 13 5 255
                   10 19 5 255 17 34 7 255 13 24 6 255
                   11 19 5 255 10 18 5 255 12 22 6 255
                   12 20 5 255 7 11 4 255 8 14 4 255
                   9 14 5 255 7 11 4 255 6 7 3 255
                   6 9 4 255 6 7 3 255 6 10 4 255
                   7 11 4 255 8 11 5 255 7 11 5 255
                   7 11 4 255 6 10 4 255 7 11 4 255
                   9 14 4 255 9 14 4 255 9 14 5 255
                   9 15 5 255 9 15 4 255 9 14 4 255
                   9 14 4 255 8 13 4 255 8 13 4 255
                   11 17 6 255 14 20 7 255 14 21 7 255
                   15 24 7 255 18 30 8 255 16 23 6 255
                   10 16 5 255 11 14 4 255 10 15 5 255
                   11 16 6 255 9 12 4 255 7 9 4 255
                   6 7 4 255 6 8 3 255 14 17 7 255
                   18 20 10 0 12 16 7 255 6 9 4 0
                   7 9 4 255 14 17 8 255 8 15 4 0
                   10 18 6 0 10 18 5 0 11 21 6 0
                   17 32 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 15 29 6 0 11 18 6 0
                   11 19 6 0 18 24 9 255 18 25 8 255
                   18 24 9 255 14 21 7 255 17 27 8 255
                   16 24 9 255 13 19 8 255 11 17 6 255
                   10 15 5 255 11 15 6 255 12 17 6 255
                   13 18 6 255 10 14 5 255 8 11 4 255
                   7 10 4 255 6 10 4 255 6 10 4 255
                   7 10 4 255 7 10 4 255 8 13 4 255
                   11 19 5 255 12 20 6 255 14 22 7 255
                   18 31 8 255 16 27 7 255 10 17 5 255
                   8 13 4 255 7 13 4 255 7 11 4 255
                   7 13 4 255 8 15 4 255 11 20 6 255
                   17 32 8 255 20 35 8 255 19 34 8 255
                   13 23 7 255 13 23 8 255 18 31 10 255
                   17 30 8 255 14 24 7 255 15 28 6 255
                   19 37 7 255 20 37 7 255 19 35 7 255
                   17 31 7 255 14 24 6 255 10 15 5 255
                   7 9 4 255 9 14 6 255 7 13 4 255
                   6 11 4 255 6 10 4 255 6 10 4 255
                   6 10 4 255 7 11 4 255 7 13 4 255
                   9 13 5 255 7 11 5 255 7 10 4 255
                   7 11 4 255 10 17 5 255 11 20 5 255
                   10 17 5 255 10 14 5 255 9 14 5 255
                   9 14 5 255 10 18 6 255 12 19 6 255
                   11 18 6 255 11 18 6 255 12 18 6 255
                   15 22 7 255 16 25 7 255 18 28 7 255
                   18 27 8 255 17 25 7 255 13 20 7 255
                   12 16 6 255 9 14 5 255 8 12 5 255
                   8 11 4 255 7 9 4 255 7 10 4 255
                   7 10 4 255 10 12 5 255 11 13 6 255
                   11 14 7 255 12 14 6 255 9 11 5 255
                   8 12 5 255 8 13 5 255 13 16 8 255
                   16 23 9 255 23 27 14 255 13 24 5 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   16 32 6 0 11 21 6 0 11 18 5 0
                   18 24 9 255 26 33 11 255 24 32 11 255
                   16 24 8 255 13 19 7 255 13 20 7 255
                   14 20 7 255 12 18 6 255 9 14 5 255
                   10 17 6 255 11 18 7 255 10 17 6 255
                   9 15 5 255 8 13 4 255 7 13 4 255
                   7 11 4 255 8 13 5 255 12 17 7 255
                   13 18 7 255 10 14 6 255 8 11 5 255
                   12 15 7 255 17 22 9 255 21 35 9 255
                   24 41 10 255 16 30 7 255 12 23 6 255
                   10 18 6 255 10 17 6 255 9 17 5 255
                   8 14 5 255 8 14 5 255 11 20 6 255
                   13 22 7 255 16 28 8 255 14 26 8 255
                   12 20 8 255 16 27 9 255 24 41 10 255
                   24 43 10 255 20 37 8 255 20 39 7 255
                   23 44 8 255 24 41 8 255 17 31 7 255
                   10 15 5 255 6 10 4 255 7 11 4 255
                   9 14 5 255 10 17 5 255 7 13 4 255
                   9 15 4 255 13 24 5 255 10 19 5 255
                   9 15 4 255 10 17 5 255 9 15 5 255
                   9 15 5 255 9 14 4 255 9 14 4 255
                   13 22 6 255 17 32 8 255 14 23 7 255
                   11 18 6 255 12 19 6 255 12 18 6 255
                   11 18 6 255 13 19 7 255 17 28 8 255
                   19 31 9 255 18 30 8 255 16 24 8 255
                   20 32 9 255 21 32 8 255 19 31 9 255
                   19 28 9 255 14 18 7 255 11 16 6 255
                   10 14 5 255 9 13 5 255 9 15 6 255
                   9 14 6 255 9 13 5 255 9 14 5 255
                   10 14 6 255 12 17 7 255 11 17 7 255
                   12 18 8 255 11 15 6 255 10 14 6 255
                   11 14 6 255 15 19 7 255 19 24 9 255
                   8 13 5 255 7 12 4 0 14 27 6 0
                   17 32 7 0 14 25 7 0 14 25 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   14 29 6 0 14 29 6 0 17 33 7 0
                   15 27 7 0 10 19 5 0 33 38 19 0
                   29 43 12 255 17 28 8 255 16 24 8 255
                   14 20 7 255 16 23 9 255 18 26 9 255
                   15 24 7 255 15 24 8 255 14 24 8 255
                   13 22 7 255 13 20 7 255 12 19 7 255
                   11 17 6 255 9 14 4 255 6 11 4 255
                   6 10 4 255 8 13 5 255 11 15 6 255
                   10 14 5 255 9 13 4 255 7 11 4 255
                   7 11 4 255 7 11 4 255 13 22 6 255
                   21 34 8 255 21 37 9 255 15 28 8 255
                   11 19 6 255 9 15 5 255 8 14 5 255
                   8 14 4 255 9 15 5 255 11 17 7 255
                   11 19 7 255 13 23 8 255 12 22 8 255
                   10 18 6 255 13 23 6 255 21 39 8 255
                   22 43 8 255 21 39 7 255 16 28 6 255
                   12 20 5 255 9 14 5 255 6 10 4 255
                   9 17 4 255 14 26 6 255 13 22 5 255
                   13 23 6 255 9 14 5 255 8 13 4 255
                   15 28 6 255 18 34 7 255 14 26 6 255
                   15 27 7 255 15 26 7 255 12 22 6 255
                   11 19 6 255 10 15 5 255 10 15 4 255
                   11 19 5 255 11 18 5 255 13 20 6 255
                   13 22 7 255 14 20 7 255 14 19 7 255
                   13 18 7 255 17 26 8 255 19 30 9 255
                   23 34 11 255 24 35 11 255 28 44 12 255
                   26 43 10 255 25 42 10 255 22 33 10 255
                   11 16 6 255 10 12 5 255 11 17 6 255
                   13 18 7 255 13 19 7 255 13 19 7 255
                   12 18 7 255 13 18 7 255 12 17 7 255
                   18 23 9 255 21 28 11 255 12 17 7 255
                   11 16 7 255 15 21 8 255 20 24 9 255
                   23 28 10 255 8 11 5 255 6 10 4 255
                   9 14 5 255 35 41 17 255 15 28 7 0
                   13 24 7 0 14 25 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 14 29 6 0
                   14 29 6 0 17 33 7 0 59 63 29 0
                   25 31 14 0 21 27 10 0 28 40 11 255
                   23 37 11 255 19 31 9 255 17 26 8 255
                   20 30 10 255 21 32 9 255 22 36 10 255
                   22 36 11 255 19 31 10 255 15 26 8 255
                   14 23 7 255 13 22 7 255 12 19 6 255
                   10 17 5 255 8 13 4 255 7 11 4 255
                   8 13 4 255 8 14 4 255 9 15 5 255
                   9 13 5 255 7 11 4 255 6 10 4 255
                   6 10 4 255 6 9 4 255 12 17 6 255
                   20 34 8 255 21 37 8 255 16 30 7 255
                   11 19 6 255 10 18 6 255 12 22 6 255
                   11 19 7 255 11 17 7 255 9 15 6 255
                   11 19 7 255 14 27 8 255 13 27 7 255
                   11 22 5 255 14 27 6 255 17 31 6 255
                   25 45 8 255 23 41 8 255 19 34 7 255
                   9 14 4 255 6 9 4 255 8 11 4 255
                   10 17 5 255 11 19 5 255 12 20 5 255
                   10 17 5 255 8 13 4 255 10 18 5 255
                   17 31 7 255 23 41 8 255 21 36 8 255
                   17 30 7 255 11 19 6 255 9 15 5 255
                   9 14 5 255 10 15 5 255 9 15 4 255
                   10 17 5 255 12 20 6 255 12 19 7 255
                   16 23 8 255 22 30 10 255 21 30 10 255
                   18 26 9 255 19 28 9 255 20 30 10 255
                   20 30 9 255 18 26 10 255 18 29 9 255
                   25 40 10 255 22 32 9 255 14 20 7 255
                   11 15 6 255 9 14 5 255 11 17 6 255
                   14 22 8 255 15 23 8 255 16 25 10 255
                   19 26 10 255 19 27 9 255 25 34 12 255
                   21 33 11 255 21 33 11 255 9 14 5 255
                   19 26 8 255 19 27 10 255 20 25 10 255
                   10 14 5 255 13 16 5 255 16 20 9 255
                   31 34 18 255 15 29 6 0 16 31 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 15 29 6 0 15 29 6 0
                   83 89 47 0 38 47 14 0 22 30 10 0
                   23 29 11 255 34 44 15 255 37 56 15 201
                   23 39 10 255 19 32 9 255 21 34 10 255
                   15 24 8 255 13 22 7 255 18 31 9 255
                   25 44 10 255 20 36 8 255 16 31 8 255
                   16 28 8 255 14 23 7 255 12 20 6 255
                   10 17 6 255 10 17 6 255 11 19 6 255
                   10 15 4 255 9 15 4 255 9 15 5 255
                   10 17 5 255 9 14 5 255 9 13 5 255
                   8 11 5 255 10 15 5 255 16 27 7 255
                   20 35 8 255 21 37 8 255 20 39 7 255
                   19 35 7 255 19 36 8 255 22 37 9 255
                   13 20 7 255 8 13 5 255 9 13 5 255
                   11 18 6 255 15 30 7 255 18 36 7 255
                   15 28 6 255 12 20 5 255 16 26 6 255
                   21 36 7 255 20 34 7 255 10 17 5 255
                   6 9 4 255 6 9 4 255 7 10 5 255
                   7 10 4 255 9 15 5 255 12 20 6 255
                   11 20 6 255 11 20 6 255 12 20 6 255
                   14 23 6 255 12 20 6 255 9 14 5 255
                   8 13 4 255 9 14 5 255 10 17 5 255
                   11 18 5 255 11 17 6 255 12 19 7 255
                   14 23 7 255 17 27 8 255 14 23 7 255
                   16 24 8 255 19 30 9 255 20 30 9 255
                   21 27 11 255 21 26 11 255 13 19 7 255
                   13 21 8 255 14 20 8 255 12 18 7 255
                   10 15 5 255 9 14 5 255 10 14 6 255
                   10 15 6 255 12 18 7 255 16 24 8 255
                   17 26 8 255 18 29 10 255 16 26 8 255
                   21 31 9 255 41 51 20 255 35 45 17 255
                   21 33 11 255 21 33 11 255 25 35 12 255
                   35 44 16 255 30 36 14 255 27 30 14 255
                   23 28 12 255 23 25 13 255 11 19 5 0
                   15 30 5 0 14 28 5 0 17 33 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
)"
        R"(                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   15 29 6 0 13 26 5 0 62 71 30 0
                   28 40 11 0 15 20 6 255 25 29 12 0
                   49 57 24 0 33 49 12 255 31 52 11 225
                   27 47 11 255 24 43 10 255 22 37 9 255
                   17 28 8 255 16 27 8 255 18 28 8 255
                   25 40 9 255 25 43 10 255 27 44 11 255
                   24 40 10 255 19 32 10 255 15 24 8 255
                   12 19 7 255 11 18 6 255 10 15 5 255
                   10 15 5 255 10 17 5 255 11 18 6 255
                   14 19 8 255 13 17 7 255 9 14 5 255
                   11 18 6 255 19 32 8 255 21 37 8 255
                   18 32 8 255 20 36 8 255 19 32 8 255
                   14 24 7 255 24 41 9 255 22 36 8 255
                   10 14 6 255 9 13 6 255 8 13 5 255
                   12 22 6 255 16 31 6 255 19 36 7 255
                   14 23 6 255 8 14 5 255 10 18 5 255
                   9 15 5 255 6 11 4 255 6 9 4 255
                   6 9 4 255 8 11 5 255 8 13 5 255
                   12 18 7 255 13 22 7 255 15 27 8 255
                   16 28 8 255 13 23 7 255 13 22 6 255
                   12 20 6 255 10 17 5 255 9 15 5 255
                   9 15 5 255 11 18 6 255 11 18 6 255
                   11 17 6 255 11 17 7 255 13 20 7 255
                   20 32 9 255 19 30 9 255 16 23 8 255
                   18 27 10 255 15 20 8 255 13 18 8 255
                   10 14 6 255 9 14 5 255 10 15 6 255
                   10 17 7 255 11 18 7 255 12 20 7 255
                   11 18 7 255 12 19 7 255 10 15 6 255
                   13 19 7 255 25 34 12 255 20 27 10 255
                   19 27 9 255 19 30 9 255 19 30 9 255
                   26 39 11 255 26 38 11 255 28 42 12 248
                   23 39 13 255 20 30 10 255 29 39 13 255
                   24 33 11 255 21 27 10 255 25 31 12 255
                   35 41 19 255 18 34 7 0 16 32 6 0
                   15 30 6 0 17 33 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 96 94 62 0
                   67 67 38 0 49 56 23 0 27 34 12 255
                   14 18 6 255 16 22 8 255 23 28 12 255
                   17 26 9 255 17 27 8 255 18 31 8 255
                   19 32 7 255 22 36 9 255 26 41 12 255
                   24 34 12 255 16 20 8 255 22 26 11 255
                   22 28 11 255 29 37 13 255 38 51 18 255
                   33 45 15 255 22 32 11 255 18 30 9 255
                   15 24 8 255 12 18 7 255 10 15 6 255
                   10 15 5 255 14 20 8 255 23 27 13 255
                   19 22 11 255 10 15 6 255 11 17 6 255
                   12 18 6 255 12 22 6 255 12 20 6 255
                   11 17 6 255 10 17 6 255 9 14 5 255
                   10 17 5 255 11 17 5 255 7 10 4 255
                   7 10 4 255 6 10 4 255 7 11 4 255
                   7 13 4 255 9 17 5 255 8 14 5 255
                   7 11 4 255 7 11 4 255 8 15 5 255
                   7 13 4 255 7 11 4 255 7 13 4 255
                   10 15 6 255 13 20 7 255 15 23 9 255
                   12 19 7 255 13 22 7 255 12 20 6 255
                   10 17 5 255 12 19 6 255 16 27 7 255
                   13 22 6 255 10 17 5 255 11 18 6 255
                   13 23 8 255 15 22 8 255 14 20 7 255
                   14 23 7 255 18 28 8 255 18 28 8 255
                   19 28 9 255 18 27 9 255 17 24 10 255
                   12 17 8 255 9 14 5 255 9 14 5 255
                   9 14 5 255 10 15 6 255 11 17 7 255
                   12 19 7 255 14 23 8 255 16 27 8 255
                   17 30 9 255 15 24 8 255 15 24 8 255
                   20 31 10 255 16 23 8 255 14 21 8 255
                   23 31 11 255 27 41 13 255 29 42 15 255
                   27 38 14 255 15 21 6 255 13 19 6 255
                   17 28 10 238 33 43 16 43 26 35 12 255
                   33 42 19 255 64 71 41 0 18 31 9 0
                   21 37 10 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   78 77 44 0 34 39 17 0 20 26 10 255
                   18 24 9 255 14 19 9 255 18 24 9 255
                   18 23 10 255 26 30 13 255 29 32 16 255
                   22 25 12 255 12 17 7 255 8 13 5 255
                   11 16 5 255 24 31 13 255 21 26 10 255
                   18 20 10 255 24 26 13 255 23 24 12 255
                   27 30 14 255 37 45 18 255 29 40 14 255
                   25 36 12 255 20 30 10 255 16 24 9 255
                   14 20 7 255 12 18 6 255 11 17 6 255
                   13 19 7 255 13 20 7 255 12 18 6 255
                   11 19 6 255 10 17 5 255 10 15 5 255
                   9 15 5 255 9 15 5 255 10 17 6 255
                   10 17 6 255 10 15 5 255 9 14 5 255
                   8 13 4 255 7 11 4 255 7 11 4 255
                   7 13 4 255 8 14 4 255 8 15 5 255
                   7 13 4 255 7 13 5 255 8 13 5 255
                   7 11 4 255 8 14 5 255 10 18 6 255
                   11 19 7 255 11 18 6 255 9 15 6 255
                   11 17 6 255 12 18 7 255 11 17 6 255
                   10 14 6 255 8 11 4 255 7 11 4 255
                   10 17 5 255 17 30 8 255 17 31 8 255
                   13 23 7 255 11 19 6 255 15 27 8 255
                   16 24 9 255 17 30 8 255 22 39 9 255
                   21 32 9 255 12 18 7 255 9 14 5 255
                   9 14 6 255 8 13 5 255 8 13 5 255
                   9 14 6 255 9 14 5 255 12 20 7 255
                   13 21 7 255 16 22 9 255 19 30 9 255
                   22 39 10 255 24 39 11 255 22 36 10 255
                   21 34 10 255 21 34 9 255 19 28 9 255
                   17 27 9 255 14 20 7 255 13 18 7 0
                   18 27 10 255 29 40 16 255 26 36 14 0
                   13 18 7 0 16 22 9 255 19 32 11 255
                   13 22 8 255 40 48 23 0 18 34 9 0
                   12 21 7 0 12 21 6 0 18 33 8 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 89 90 47 0 45 50 19 0
                   24 30 11 0 17 22 9 255 13 19 8 255
                   10 15 6 255 12 19 7 255 16 22 8 255
                   16 20 8 255 16 20 9 255 14 17 9 255
                   9 14 5 255 7 13 5 255 10 14 5 255
                   21 23 11 255 18 20 9 255 13 18 7 255
                   11 14 6 255 13 17 7 255 19 23 10 255
                   32 41 15 255 32 47 14 255 24 37 10 255
                   19 31 9 255 19 31 9 255 17 27 8 255
                   16 24 8 255 14 22 7 255 13 19 7 255
                   14 22 7 255 15 23 8 255 12 20 7 255
                   10 17 5 255 11 17 6 255 10 15 5 255
                   9 14 5 255 9 13 5 255 9 14 5 255
                   11 17 6 255 10 15 5 255 9 14 5 255
                   8 13 4 255 7 13 4 255 8 14 5 255
                   8 14 4 255 7 13 4 255 7 11 4 255
                   7 13 4 255 8 13 5 255 7 11 4 255
                   8 14 4 255 10 17 5 255 10 17 6 255
                   8 13 5 255 8 11 4 255 8 11 4 255
                   8 13 5 255 10 14 5 255 10 13 5 255
                   8 11 5 255 7 11 4 255 9 14 5 255
                   15 27 7 255 22 39 8 255 21 39 9 255
                   20 36 9 255 19 34 9 255 15 23 8 255
                   16 26 8 255 15 24 8 255 10 14 6 255
                   9 14 6 255 9 13 5 255 8 13 5 255
                   7 13 5 255 7 13 5 255 10 15 6 255
                   10 17 7 255 12 21 7 255 13 22 8 255
                   15 22 8 255 17 24 9 255 16 24 9 255
                   18 27 9 255 22 32 11 255 23 36 10 255
                   24 38 11 255 16 23 8 255 15 21 8 255
                   25 34 12 255 24 31 12 0 19 27 9 0
                   30 38 16 0 28 36 15 0 24 28 13 0
                   23 26 12 176 14 21 8 255 13 21 7 255
                   30 34 15 255 12 20 5 0 10 16 6 0
                   9 15 5 0 14 25 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   80 87 38 0 48 58 19 0 26 36 11 255
                   25 33 12 255 31 36 14 255 20 28 8 255
                   15 24 6 255 18 31 9 255 17 31 8 255
                   12 22 6 255 11 19 6 255 10 17 6 255
                   11 18 7 255 15 20 8 255 14 19 8 255
                   11 15 6 255 14 20 7 255 13 20 7 255
                   10 17 6 255 10 14 5 255 15 19 8 255
                   23 34 11 255 24 39 9 255 19 31 8 255
                   18 31 8 255 20 32 9 255 16 26 8 255
                   15 24 8 255 12 20 7 255 12 18 6 255
                   11 18 6 255 13 22 7 255 12 20 7 255
                   10 15 5 255 10 15 5 255 9 14 5 255
                   8 13 5 255 9 15 5 255 9 15 5 255
                   9 15 5 255 8 13 5 255 7 11 4 255
                   8 13 4 255 9 18 5 255 11 22 6 255
                   9 17 5 255 8 14 5 255 8 13 4 255
                   7 13 5 255 8 13 5 255 7 11 4 255
                   7 11 4 255 6 10 4 255 7 11 4 255
                   7 10 4 255 7 10 5 255 11 15 7 255
                   13 18 7 255 14 18 9 255 16 20 10 255
                   9 13 5 255 8 13 4 255 9 14 5 255
                   13 22 6 255 25 39 11 255 38 55 16 255
                   33 52 12 255 22 36 10 255 18 26 10 255
                   15 19 9 255 12 18 7 255 11 18 7 255
                   10 15 7 255 9 15 6 255 10 17 7 255
                   11 17 7 255 11 17 7 255 11 18 8 255
                   14 22 8 255 17 27 9 255 17 27 10 255
                   19 27 10 255 15 21 8 255 16 22 9 255
                   21 28 11 255 15 23 9 255 16 26 9 255
                   17 22 8 255 18 24 9 255 31 35 16 255
                   34 38 17 0 19 23 10 0 16 19 9 0
                   37 46 19 0 32 41 17 0 24 29 13 255
                   28 36 15 255 33 42 15 255 34 42 16 255
                   10 19 4 0 12 22 6 0 11 20 5 0
                   13 25 5 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 101 106 59 0
                   60 70 25 0 31 45 11 255 26 39 11 255
                   34 43 16 255 31 42 12 255 29 47 10 255
                   26 47 10 255 26 47 11 255 20 35 10 255
                   16 28 8 255 16 27 8 255 16 27 8 255
                   20 30 11 255 16 23 9 255 12 18 7 255
                   13 20 7 255 14 20 7 255 12 19 6 255
                   12 17 6 255 11 15 6 255 16 26 8 255
                   25 39 10 255 26 40 11 255 20 31 10 255
                   18 28 9 255 16 26 8 255 15 24 8 255
                   16 27 8 255 14 23 8 255 12 19 6 255
                   13 22 7 255 15 26 8 255 13 22 7 255
                   10 17 5 255 8 13 5 255 7 11 4 255
                   9 15 5 255 10 17 6 255 11 18 6 255
                   10 17 6 255 8 14 5 255 9 15 5 255
                   10 17 5 255 13 23 7 255 14 24 7 255
                   12 23 7 255 10 18 5 255 9 15 6 255
                   9 15 5 255 9 15 5 255 8 13 4 255
                   7 11 4 255 8 13 4 255 10 17 6 255
                   12 17 7 255 11 15 6 255 10 14 6 255
                   16 19 10 255 23 26 14 255 10 14 6 255
                   11 15 7 255 14 18 8 255 10 14 6 255
                   17 22 9 255 27 35 14 255 28 39 12 255
                   27 37 12 255 24 28 13 255 33 37 21 255
                   16 23 9 255 14 23 8 255 15 24 8 255
                   14 22 8 255 13 22 8 255 15 23 9 255
                   12 18 8 255 13 20 8 255 16 24 9 255
                   19 28 11 255 19 28 10 255 22 34 10 255
                   18 27 8 255 19 26 8 255 23 34 10 255
                   25 35 11 255 24 32 12 255 19 25 9 255
                   16 20 8 255 17 21 10 255 19 26 11 255
                   17 21 8 255 24 28 12 0 15 30 7 0
                   18 36 7 0 18 36 7 0 17 34 7 0
                   17 34 7 0 17 34 7 0 17 31 7 0
                   17 31 7 0 15 29 6 0 16 31 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 86 95 41 0 32 39 12 0
                   23 32 8 255 36 51 13 0 38 49 17 0
                   34 49 13 0 40 60 13 255 37 57 11 255
                   31 51 11 255 22 36 9 255 20 35 9 255
                   27 47 11 255 23 37 10 255 21 32 10 255
                   22 32 11 255 25 32 13 255 19 26 10 255
                   16 23 8 255 14 22 7 255 13 18 6 255
                   14 19 7 255 19 26 9 255 26 35 12 255
                   36 51 15 255 26 41 11 255 19 32 9 255
                   23 36 11 255 20 30 9 255 18 30 9 255
                   16 27 8 255 14 24 7 255 14 23 8 255
                   17 28 9 255 22 37 10 255 18 31 9 255
                   10 19 6 255 9 17 5 255 14 26 7 255
                   12 22 7 255 13 23 7 255 13 22 7 255
                   13 22 7 255 10 17 6 255 12 20 6 255
                   16 28 8 255 17 30 8 255 14 26 7 255
                   12 22 6 255 12 20 7 255 11 19 6 255
                   11 19 6 255 12 20 7 255 10 18 6 255
                   10 17 6 255 11 19 6 255 13 19 8 255
                   11 15 7 255 10 15 6 255 11 15 7 255
                   9 14 6 255 10 15 6 255 11 15 6 255
                   12 18 8 255 12 18 7 255 17 23 9 255
                   20 27 11 255 17 23 9 255 16 23 9 255
                   16 22 9 255 20 27 11 255 19 27 10 255
                   17 26 9 255 17 26 9 255 18 27 9 255
                   17 24 9 255 14 20 8 255 14 20 8 255
                   17 24 9 255 21 30 11 255 21 31 10 255
                   22 32 10 255 26 37 12 255 22 32 11 255
                   22 31 11 255 37 45 19 255 38 46 21 255
                   27 36 14 207 24 32 12 255 24 32 13 255
                   20 25 11 255 32 41 18 255 41 51 21 255
                   15 30 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 19 36 8 0 19 37 9 0
                   19 37 8 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   82 93 38 0 27 35 11 0 30 37 12 0
                   67 77 32 0 79 85 48 0 60 68 33 0
                   57 68 27 0 47 62 17 255 36 51 13 255
)"
        R"(                   25 36 10 255 32 47 13 255 30 49 11 255
                   23 37 9 255 17 26 9 255 31 36 16 255
                   51 52 29 255 46 47 25 255 40 44 22 255
                   19 24 10 255 14 21 8 255 17 25 8 255
                   21 30 9 255 21 31 8 255 24 35 11 255
                   24 35 11 255 21 32 10 255 21 28 10 255
                   18 26 9 255 16 27 9 255 16 26 8 255
                   14 22 8 255 12 20 7 255 14 23 7 255
                   23 37 11 255 29 48 13 255 18 32 9 255
                   17 31 8 255 30 49 12 255 26 43 11 255
                   24 39 11 255 15 24 8 255 12 18 7 255
                   16 22 9 255 17 24 9 255 22 36 9 255
                   25 40 9 255 20 36 8 255 16 29 8 255
                   14 22 8 255 11 18 7 255 10 15 6 255
                   11 18 6 255 10 17 6 255 11 18 7 255
                   13 22 7 255 12 18 7 255 10 15 6 255
                   11 17 7 255 11 17 7 255 10 17 7 255
                   14 23 7 255 18 30 9 255 15 26 8 255
                   16 24 8 255 22 31 11 255 20 28 12 255
                   15 23 8 255 15 23 9 255 21 30 11 255
                   27 37 13 255 28 39 13 255 29 39 14 255
                   30 39 15 240 24 32 12 255 19 26 10 255
                   14 20 8 255 17 30 9 255 24 36 12 255
                   25 34 12 255 22 30 11 255 28 34 14 255
                   21 25 10 255 14 17 7 255 12 15 5 255
                   27 32 13 255 35 45 18 255 31 41 16 255
                   32 41 17 255 19 28 11 255 32 35 19 255
                   13 25 6 0 14 27 7 0 15 29 8 0
                   15 28 7 0 15 29 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 20 37 9 0 20 37 9 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   80 87 54 0 16 32 6 0 18 36 7 0
                   18 36 7 0 67 74 37 0 49 56 25 255
                   46 52 23 188 30 38 14 255 26 36 12 255
                   32 44 15 255 29 41 13 255 23 34 10 255
                   14 20 8 255 14 19 8 255 18 21 9 255
                   16 19 8 255 16 19 8 255 21 27 12 255
                   35 42 17 255 24 33 10 255 21 29 10 255
                   18 27 8 255 21 29 10 255 28 36 13 255
                   22 31 11 255 19 28 9 255 17 26 8 255
                   19 30 10 255 13 20 8 255 12 19 7 255
                   12 20 8 255 13 22 8 255 14 24 8 255
                   17 27 8 255 20 31 10 255 26 39 12 255
                   31 47 12 255 26 39 11 255 21 31 10 255
                   19 28 9 255 13 21 7 255 12 16 6 255
                   11 15 6 255 15 20 8 255 14 20 8 255
                   13 22 8 255 13 24 8 255 13 21 7 255
                   10 18 6 255 10 18 6 255 12 18 7 255
                   14 24 8 255 14 24 8 255 14 23 8 255
                   11 17 7 255 10 15 6 255 13 19 8 255
                   18 24 10 255 11 15 6 255 13 20 6 255
                   22 37 10 255 24 40 11 255 26 40 12 255
                   30 36 17 255 22 28 12 255 25 34 13 255
                   36 47 20 255 41 48 22 255 37 45 18 255
                   28 37 14 255 27 36 13 255 23 31 11 255
                   20 30 9 255 16 24 8 255 13 21 7 255
                   17 26 9 255 18 27 10 255 14 20 8 255
                   16 23 10 255 29 33 16 255 13 14 7 255
                   9 10 5 255 8 9 5 255 10 13 6 255
                   27 29 16 0 35 42 18 0 14 28 7 0
                   11 21 6 0 14 25 7 0 11 20 6 0
                   9 17 6 0 13 23 7 0 15 28 8 0
                   15 29 6 0 19 37 8 0 19 37 8 0
                   19 37 9 0 19 37 9 0 19 36 8 0
                   19 37 8 0 19 37 8 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 17 33 7 0
                   15 29 6 0 16 32 6 0 18 36 7 0
                   84 91 49 0 62 65 34 255 50 50 27 255
                   37 41 19 255 35 42 17 255 29 36 14 255
                   24 30 12 255 21 30 10 255 16 24 8 255
                   14 24 7 255 15 25 8 255 14 22 7 255
                   11 16 7 255 19 25 10 255 45 55 20 255
                   33 48 11 255 22 32 9 255 19 28 9 255
                   25 34 11 255 28 37 13 255 19 30 10 255
                   18 30 9 255 22 37 11 255 20 32 11 255
                   13 19 8 255 14 20 8 255 14 20 8 255
                   11 18 7 255 11 17 7 255 12 19 8 255
                   18 26 10 255 27 35 13 255 24 32 11 255
                   20 27 9 255 19 28 9 255 19 31 10 255
                   18 28 9 255 13 20 7 255 12 18 6 255
                   11 17 6 255 13 20 8 255 11 18 6 255
                   14 24 7 255 18 31 8 255 12 22 6 255
                   11 19 7 255 12 20 8 255 12 20 8 255
                   14 24 7 255 13 20 7 255 11 17 7 255
                   12 19 7 255 17 24 10 255 18 23 10 255
                   11 15 6 255 10 17 6 255 13 22 7 255
                   15 24 8 255 22 28 11 255 37 39 20 255
                   25 28 14 255 27 30 15 255 49 52 29 255
                   49 48 28 255 42 44 22 255 28 31 16 255
                   16 19 9 255 20 24 11 255 15 20 8 255
                   16 24 8 255 17 28 8 255 16 26 8 255
                   14 22 8 255 12 17 7 255 14 21 9 255
                   15 19 8 255 8 10 5 255 7 11 4 255
                   8 11 5 255 12 15 7 255 14 15 8 255
                   20 24 11 255 13 23 6 0 14 25 7 0
                   15 28 8 0 9 17 5 0 9 18 6 0
                   14 28 7 0 19 36 8 0 18 36 7 0
                   19 37 8 0 19 37 8 0 19 37 9 0
                   19 37 9 0 19 36 8 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 17 33 7 0 14 26 6 0
                   15 29 6 0 18 36 7 0 71 74 47 0
                   33 36 19 255 38 42 20 197 33 36 18 255
                   29 32 14 255 26 32 13 255 21 28 10 255
                   20 27 11 255 19 26 10 255 30 40 16 255
                   29 41 13 255 23 35 10 255 17 25 8 255
                   18 28 8 255 22 35 9 255 23 37 9 255
                   22 33 10 255 21 32 10 255 30 43 12 255
                   33 49 15 255 24 36 12 255 20 31 10 255
                   18 31 10 255 20 34 11 255 15 24 9 255
                   15 23 9 255 15 24 9 255 11 18 7 255
                   15 24 8 255 20 32 9 255 22 36 10 255
                   24 37 10 255 20 31 9 255 19 24 10 255
                   18 26 10 255 18 27 10 255 24 36 12 255
                   21 32 10 255 24 37 11 255 22 34 11 255
                   23 35 12 255 20 34 10 255 17 31 8 255
                   21 37 9 255 17 32 9 255 13 22 8 255
                   12 19 8 255 16 27 9 255 15 25 8 255
                   12 18 7 255 13 20 8 255 14 23 8 255
                   13 19 8 255 13 18 8 255 13 18 8 255
                   12 18 8 255 15 23 9 255 17 27 9 255
                   22 31 12 255 44 48 24 255 33 34 17 255
                   34 34 18 255 49 49 29 255 30 30 18 255
                   20 23 12 255 21 23 12 255 11 14 7 255
                   12 15 8 255 13 19 8 255 19 30 10 255
                   21 34 10 255 15 25 8 255 11 16 7 255
                   12 17 7 255 11 14 7 255 11 16 7 255
                   10 15 5 255 9 11 5 255 12 14 7 255
                   9 16 3 0 8 15 3 0 9 19 4 0
                   11 19 5 0 13 22 6 0 16 31 8 0
                   13 25 7 0 15 30 7 0 18 36 8 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 17 32 7 0 17 32 7 0
                   18 36 7 0 49 53 30 0 25 31 14 0
                   29 34 14 255 19 25 10 255 18 22 10 255
                   28 32 15 255 16 21 8 255 15 22 8 255
                   36 42 23 0 71 78 45 0 52 60 27 0
                   35 44 20 0 40 48 24 255 32 40 16 255
                   19 28 9 255 22 30 11 255 23 31 12 255
                   17 24 10 255 22 30 11 255 27 39 12 255
                   21 31 10 255 21 33 11 255 25 40 13 255
                   20 32 12 255 19 31 11 255 18 28 10 255
                   18 32 10 255 17 31 9 255 22 37 10 255
                   31 51 12 255 29 48 12 255 29 48 11 255
                   26 41 10 255 20 31 9 255 17 26 9 255
                   20 31 10 255 27 41 13 255 20 31 10 255
                   19 30 10 255 23 32 12 255 22 34 11 255
                   22 36 10 255 24 40 10 255 30 53 10 255
                   25 43 8 255 18 31 7 255 18 29 8 255
                   23 39 10 255 18 27 9 255 13 19 7 255
                   12 19 7 255 16 24 8 255 15 21 8 255
                   13 19 8 255 17 24 9 255 18 27 9 255
                   20 31 11 255 25 41 11 255 26 40 12 255
                   42 51 22 255 32 32 19 255 21 23 12 255
                   24 26 14 255 18 20 11 255 15 19 9 255
                   14 19 9 255 11 17 7 255 10 14 6 255
                   11 14 7 255 13 20 8 255 13 19 8 255
                   12 18 8 255 11 17 7 255 13 20 7 255
                   11 16 7 255 15 19 9 255 22 26 12 255
                   12 15 7 255 14 15 8 255 12 24 5 0
                   10 21 4 0 11 19 4 0 13 25 5 0
                   15 30 6 0 20 37 9 0 18 34 9 0
                   17 33 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   60 64 36 0 38 45 17 255 52 60 24 0
                   19 25 10 255 15 21 8 255 35 39 18 225
                   17 25 10 255 19 27 10 0 47 52 29 0
                   17 33 7 0 16 32 7 0 15 27 7 0
                   85 91 60 0 75 82 48 158 34 41 19 255
                   37 45 21 255 40 48 21 255 19 25 10 255
                   13 20 8 255 16 24 8 255 14 20 8 255
                   14 23 9 255 23 37 12 255 20 34 11 255
                   19 32 10 255 20 31 10 255 20 34 10 255
                   22 39 10 255 24 43 10 255 26 44 11 255
                   24 39 10 255 19 30 9 255 18 31 9 255
                   18 28 9 255 15 22 8 255 18 27 10 255
                   27 40 13 255 23 36 11 255 21 32 10 255
                   21 31 11 255 22 35 10 255 18 30 9 255
                   17 27 9 255 28 48 10 255 28 49 10 255
                   26 43 9 255 23 38 9 255 26 44 10 255
                   22 35 9 255 16 26 8 255 15 22 8 255
                   21 28 10 255 23 29 11 255 24 29 13 255
                   25 29 14 255 17 26 9 255 24 35 11 255
                   29 45 13 255 29 44 13 255 24 36 12 255
                   16 22 9 255 15 20 9 255 23 26 13 255
                   20 24 11 255 23 28 13 255 24 30 13 255
                   16 24 9 255 14 20 8 255 11 15 7 255
                   11 17 8 255 11 17 8 255 12 18 8 255
                   11 16 6 255 12 17 7 255 12 19 8 255
                   18 27 10 255 23 30 12 255 10 14 5 255
                   13 16 5 255 9 15 4 0 9 17 5 0
                   13 25 6 0 16 32 6 0 18 36 7 0
                   18 36 7 0 16 32 6 0 16 32 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 63 70 33 0
                   36 48 12 255 39 51 15 255 29 40 13 98
                   21 32 10 255 23 35 11 255 48 57 27 0
                   18 36 7 0 16 33 7 0 16 33 7 0
                   18 36 7 0 16 32 7 0 16 32 7 0
                   18 36 7 0 87 91 63 0 72 76 45 0
                   43 52 21 255 22 31 11 255 18 27 9 255
                   16 25 8 255 16 23 8 255 18 28 9 255
                   23 37 11 255 24 36 12 255 24 37 12 255
                   26 43 11 255 20 32 10 255 17 26 9 255
                   17 27 9 255 17 30 9 255 16 26 8 255
                   12 19 7 255 13 19 7 255 14 22 8 255
                   17 24 9 255 24 32 13 255 29 43 13 255
                   25 39 12 255 19 30 9 255 19 31 9 255
                   19 34 10 255 17 28 9 255 15 24 8 255
                   17 27 9 255 22 34 10 255 26 40 11 255
                   19 30 9 255 16 24 8 255 13 20 7 255
                   14 18 8 255 22 28 12 255 20 26 10 255
                   22 27 10 255 31 37 16 255 28 31 14 255
                   20 25 10 255 18 22 10 255 26 32 13 255
                   24 35 13 255 22 31 11 255 21 27 12 255
                   17 23 9 255 27 32 15 255 23 27 12 255
                   17 20 10 255 15 19 9 255 14 23 9 255
                   17 26 9 255 14 22 9 255 13 19 8 255
                   12 19 7 255 13 20 8 255 15 20 9 255
                   14 19 7 255 16 24 8 255 20 29 12 255
                   18 26 11 255 13 18 6 255 23 28 13 255
                   11 19 5 0 9 18 4 0 14 26 5 0
                   17 34 7 0 20 37 10 0 20 37 10 0
                   16 32 6 0 16 32 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 97 104 57 0 63 79 25 0
                   55 72 19 255 48 64 17 255 40 61 13 217
                   42 62 16 255 73 85 38 0 18 36 7 0
                   16 33 7 0 16 33 7 0 18 36 7 0
                   16 32 7 0 16 32 7 0 18 36 7 0
                   16 32 6 0 60 64 40 0 28 35 14 255
                   20 31 11 255 18 28 9 255 14 21 7 255
                   13 19 7 255 10 16 6 255 14 22 7 255
)"
        R"(                   25 37 13 255 24 35 12 255 25 43 11 255
                   23 40 9 255 16 25 8 255 15 27 8 255
                   15 27 7 255 15 25 8 255 15 23 8 255
                   15 26 8 255 16 24 9 255 17 26 9 255
                   21 32 10 255 24 37 11 255 23 37 11 255
                   18 28 10 255 17 25 9 255 14 22 8 255
                   13 19 7 255 12 19 8 255 11 17 7 255
                   16 24 9 255 18 27 9 255 18 27 9 255
                   19 27 9 255 15 22 8 255 15 18 8 255
                   23 27 11 255 15 22 8 255 19 28 10 255
                   31 41 14 255 36 47 16 255 28 37 12 255
                   18 24 10 255 16 20 10 255 22 27 12 255
                   20 30 11 255 26 35 13 255 20 28 10 255
                   23 32 11 255 21 30 11 255 14 20 8 255
                   12 18 8 255 16 23 9 255 19 30 10 255
                   19 31 10 255 17 26 10 255 15 25 8 255
                   16 22 9 255 18 24 11 255 15 21 8 255
                   14 20 8 255 13 18 8 255 10 16 6 255
                   15 22 9 255 22 28 14 255 29 32 16 255
                   10 17 5 0 9 18 5 0 13 25 6 0
                   17 32 9 0 16 30 8 0 17 34 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 91 104 51 0
                   50 66 20 0 35 48 15 0 80 93 50 0
                   16 32 7 0 16 32 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   17 33 7 0 17 33 7 0 81 84 59 0
                   44 47 31 0 20 27 11 255 14 20 7 255
                   10 17 5 255 9 16 5 255 12 19 8 255
                   9 15 5 255 10 16 5 255 14 22 8 255
                   14 20 8 255 13 21 8 255 18 30 8 255
                   22 33 9 255 20 35 9 255 17 28 8 255
                   13 21 7 255 15 25 9 255 15 26 8 255
                   16 25 8 255 16 24 9 255 20 32 11 255
                   24 39 12 255 24 37 11 255 21 29 10 255
                   19 27 10 255 17 24 9 255 15 24 8 255
                   19 28 10 255 17 24 10 255 19 27 10 255
                   20 30 10 255 22 30 10 255 24 31 11 255
                   24 31 12 255 25 30 11 255 23 28 10 255
                   21 29 10 255 22 29 11 255 24 31 11 255
                   35 49 14 255 35 48 14 255 23 28 11 255
                   12 17 8 255 16 19 10 255 15 20 9 255
                   18 27 9 255 23 35 11 255 24 36 11 255
                   22 34 10 255 17 28 10 255 19 30 10 255
                   18 26 10 255 20 28 11 255 29 43 14 255
                   27 39 13 255 22 32 12 255 21 32 12 255
                   16 23 9 255 12 19 8 255 12 17 6 255
                   9 14 5 255 9 13 5 255 12 17 8 255
                   16 19 7 255 12 16 7 255 13 18 7 255
                   15 20 7 255 11 20 4 0 14 29 7 0
                   14 25 6 0 14 24 5 0 16 31 6 0
                   16 31 7 0 16 31 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 128 132 93 0 83 94 47 0
                   74 79 48 0 124 127 92 0 16 32 7 0
                   16 32 7 0 17 33 7 0 15 29 6 0
                   16 32 6 0 16 33 7 0 11 21 6 0
                   11 20 6 0 45 48 27 255 39 44 25 0
                   25 30 12 0 14 19 7 236 12 19 6 255
                   11 18 6 255 13 21 7 255 11 16 7 255
                   11 15 6 255 13 20 8 255 17 24 10 255
                   19 26 10 255 16 24 10 255 16 24 9 255
                   15 24 9 255 14 23 8 255 15 23 8 255
                   18 29 9 255 20 34 10 255 20 34 9 255
                   22 35 11 255 18 27 10 255 15 24 8 255
                   14 22 8 255 16 25 9 255 21 32 11 255
                   22 33 11 255 21 31 10 255 25 37 12 255
                   27 39 13 255 25 35 12 255 24 32 11 255
                   26 32 12 255 34 39 14 255 31 34 15 255
                   31 34 15 255 30 35 15 255 18 26 9 255
                   20 27 10 255 29 35 15 255 30 40 15 255
                   30 37 14 255 17 21 9 255 12 18 8 255
                   12 18 8 255 12 18 8 255 14 19 8 255
                   19 30 10 255 23 35 11 255 21 31 10 255
                   20 31 11 255 24 39 12 255 24 37 13 255
                   26 34 15 255 39 45 22 255 37 47 18 255
                   32 43 16 255 19 26 9 255 12 18 7 255
                   14 20 9 255 12 16 7 255 12 16 6 255
                   10 15 6 255 13 18 8 255 11 16 6 255
                   10 13 6 255 10 15 6 255 23 29 12 255
                   24 28 12 255 9 19 4 0 14 28 7 0
                   14 24 6 0 11 22 5 0 12 24 6 0
                   16 31 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   17 33 7 0 15 29 6 0 12 21 4 0
                   12 20 5 0 11 19 6 0 44 48 32 0
                   54 57 34 0 29 36 15 255 26 31 14 255
                   29 35 14 72 22 31 10 255 16 24 8 255
                   13 21 8 255 11 18 8 255 12 18 8 255
                   15 20 9 255 23 32 12 255 33 48 16 255
                   23 37 11 255 19 31 11 255 15 25 9 255
                   13 22 8 255 17 29 9 255 17 28 9 255
                   17 29 9 255 18 29 9 255 20 31 11 255
                   18 28 11 255 15 23 9 255 14 23 9 255
                   16 27 10 255 16 26 10 255 19 31 11 255
                   24 39 12 255 26 41 13 255 30 45 14 255
                   33 44 16 255 26 36 12 255 29 39 13 255
                   30 39 13 255 30 35 15 255 25 32 13 255
                   28 36 15 255 22 31 11 255 19 28 10 255
                   29 37 15 255 28 32 16 255 18 21 11 255
                   17 22 11 255 13 22 9 255 13 21 9 255
                   11 17 8 255 12 18 8 255 22 35 10 255
                   31 51 12 255 29 47 12 255 26 43 12 255
                   31 49 14 255 27 37 15 255 22 28 13 255
                   29 34 17 255 33 39 19 255 31 37 17 255
                   13 16 7 255 10 13 6 255 17 24 10 255
                   18 23 10 255 15 21 8 255 16 21 9 255
                   17 22 9 255 21 26 10 255 18 22 8 255
                   15 19 7 255 24 31 13 255 30 37 16 255
                   9 17 4 0 14 28 6 0 17 34 7 0
                   12 24 5 0 13 25 5 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 11 20 4 0 10 17 4 0
                   34 38 22 0 30 34 20 0 32 37 18 255
                   51 59 28 255 36 42 20 255 24 31 12 255
                   18 26 11 255 12 21 8 255 13 20 8 255
                   12 19 8 255 12 17 8 255 13 20 8 255
                   15 23 9 255 20 32 10 255 25 40 11 255
                   25 39 11 255 17 28 9 255 17 26 9 255
                   22 37 11 255 21 33 11 255 15 24 8 255
                   14 20 8 255 19 27 11 255 18 27 11 255
                   16 24 10 255 15 24 10 255 15 24 10 255
                   14 23 9 255 15 24 10 255 17 27 10 255
                   20 30 11 255 26 37 13 255 30 40 17 255
                   22 32 12 255 22 31 11 255 24 34 12 255
                   25 32 12 255 21 32 11 255 28 43 12 255
                   30 47 13 255 27 41 13 255 32 41 17 255
                   35 40 19 255 15 20 9 255 14 18 9 255
                   17 23 11 255 15 19 10 255 11 16 7 255
                   14 20 9 255 22 32 11 255 33 51 12 255
                   39 62 14 255 34 52 14 255 25 36 13 255
                   21 30 12 255 26 35 14 255 47 53 25 255
                   44 49 25 255 33 39 19 255 14 19 8 255
                   13 17 7 255 17 23 10 255 24 29 13 255
                   24 30 14 255 20 27 9 255 28 35 13 255
                   34 43 16 255 24 33 10 255 18 25 9 255
                   27 35 14 255 53 60 33 0 11 20 5 0
                   13 24 6 0 17 34 7 0 17 33 6 0
                   16 31 6 0 16 31 6 0 15 30 6 0
                   17 34 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 15 30 5 0
                   11 21 4 0 26 31 15 0 23 28 13 0
                   19 24 10 172 19 25 10 255 60 63 37 0
                   61 64 35 0 36 43 19 255 29 35 16 255
                   19 27 10 255 18 28 11 255 19 29 11 255
                   15 23 9 255 17 26 10 255 19 30 12 255
                   18 26 10 255 19 29 11 255 20 30 11 255
                   17 23 10 255 23 35 13 255 40 57 19 255
                   25 39 12 255 19 28 11 255 18 24 11 255
                   20 28 13 255 22 31 13 255 27 36 14 255
                   24 35 12 255 18 28 10 255 16 24 11 255
                   13 20 10 255 13 19 9 255 14 19 9 255
                   15 22 10 255 22 30 14 255 17 23 10 255
                   19 24 11 255 19 28 10 255 20 34 11 255
                   21 32 11 255 23 31 12 255 27 37 13 255
                   29 43 13 255 35 48 17 255 44 52 25 255
                   27 34 16 255 14 20 9 255 13 18 9 255
                   9 14 6 255 9 13 6 255 14 21 9 255
                   19 28 12 255 18 27 10 255 21 31 11 255
                   16 24 10 255 14 20 9 255 19 27 12 255
                   25 35 14 255 31 39 17 255 30 38 16 255
                   24 30 12 255 15 20 9 255 18 23 10 255
                   23 27 12 255 30 34 15 255 27 33 14 255
                   21 27 9 255 34 42 17 255 46 58 23 255
                   36 47 17 255 18 25 9 255 24 30 14 255
                   63 69 45 0 12 20 5 0 13 23 6 0
                   17 34 7 0 18 35 7 0 17 33 7 0
                   16 31 6 0 15 30 6 0 17 34 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 12 22 4 0 10 18 4 0
                   35 40 22 0 30 36 16 255 20 25 8 255
                   20 26 9 255 30 34 16 255 35 40 19 255
                   28 36 15 255 26 32 14 255 24 32 14 255
                   24 32 14 255 26 35 15 255 20 31 12 255
                   19 27 11 255 19 26 12 255 17 26 12 255
                   15 19 9 255 15 22 9 255 15 24 9 255
                   18 27 12 255 35 48 18 255 37 55 15 255
                   32 48 15 255 28 36 16 255 21 30 12 255
                   27 36 17 255 36 42 19 255 29 40 14 255
                   19 31 11 255 17 27 12 255 16 24 11 255
                   14 20 10 255 14 22 10 255 16 24 10 255
                   18 26 11 255 17 23 11 255 17 20 11 255
                   17 23 10 255 23 35 12 255 22 31 11 255
                   16 20 10 255 17 22 10 255 20 28 11 255
                   38 46 23 255 60 63 39 255 47 49 30 255
                   20 27 13 255 15 22 11 255 12 19 7 255
                   12 17 7 255 15 22 9 255 17 26 10 255
                   19 28 11 255 19 30 12 255 15 23 11 255
                   16 22 10 255 19 24 12 255 22 30 13 255
                   24 34 15 255 24 35 14 255 18 25 10 255
                   14 19 8 255 17 20 10 255 22 25 12 255
                   23 29 13 255 35 40 19 255 25 30 14 255
                   24 29 14 255 38 45 21 255 52 61 33 255
                   10 18 5 0 11 18 6 0 15 29 6 0
                   15 29 6 0 15 29 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 15 30 6 0
                   10 21 5 0 10 19 5 0 10 17 4 0
                   36 41 23 255 25 32 12 255 22 30 12 255
                   29 36 15 255 34 43 19 255 33 42 18 255
                   32 38 18 255 32 39 17 255 26 35 15 255
                   25 35 15 255 23 32 14 255 18 26 11 255
                   19 27 12 255 23 29 16 255 23 26 15 255
                   32 39 21 255 25 33 15 255 22 32 14 255
                   36 44 20 255 34 43 17 255 28 39 15 255
                   28 34 16 255 21 27 13 255 29 34 18 255
                   41 48 22 255 38 55 17 255 25 40 13 255
                   22 37 13 255 21 34 13 255 17 27 11 255
                   17 27 11 255 19 30 11 255 22 35 13 255
)"
        R"(                   20 31 12 255 16 23 10 255 12 16 9 255
                   12 17 9 255 9 12 6 255 15 17 9 255
                   26 28 16 255 16 22 9 255 15 21 9 255
                   38 43 26 255 46 49 29 255 28 35 17 255
                   19 24 12 255 16 24 9 255 15 22 9 255
                   16 23 11 255 17 24 11 255 21 28 13 255
                   21 30 13 255 17 25 13 255 16 20 11 255
                   15 19 10 255 17 22 11 255 19 27 12 255
                   19 26 11 255 15 22 9 255 13 18 7 255
                   18 22 9 255 19 22 11 255 21 25 12 255
                   48 52 31 255 40 44 24 255 16 21 9 255
                   11 17 7 255 10 18 5 0 11 20 5 0
                   12 20 6 0 17 32 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 15 30 6 0 14 27 6 0
                   10 18 4 0 9 15 4 0 11 20 6 0
                   35 42 18 255 32 39 17 255 39 47 21 255
                   37 44 19 255 29 36 17 255 33 39 20 255
                   30 36 17 255 15 20 8 255 17 24 9 255
                   26 35 14 255 24 32 14 255 20 30 12 255
                   23 29 16 255 33 34 22 255 48 53 30 255
                   27 34 16 255 20 31 13 255 24 34 15 255
                   22 30 13 255 22 30 13 255 24 31 14 255
                   22 30 14 255 25 32 16 255 24 32 14 255
                   36 47 18 255 30 44 16 255 26 43 15 255
                   23 39 13 255 22 37 14 255 19 30 12 255
                   22 35 13 255 31 48 16 255 30 47 15 255
                   24 37 13 244 15 22 10 255 14 19 11 255
                   10 14 6 255 17 19 11 255 23 26 14 255
                   15 22 8 255 15 24 9 255 17 27 11 255
                   21 32 12 255 22 35 14 255 21 34 14 255
                   16 21 10 255 14 21 10 255 18 24 13 255
                   24 31 16 255 28 35 18 255 30 36 20 255
                   26 30 16 255 17 21 12 255 12 16 8 255
                   14 20 9 255 20 26 12 255 13 18 7 255
                   11 17 7 255 19 26 13 255 24 29 15 255
                   20 25 13 255 22 27 13 255 32 37 19 255
                   35 41 20 255 15 21 9 255 11 14 6 227
                   11 18 5 0 13 22 7 0 14 25 6 0
                   15 29 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 12 23 6 0
                   10 18 5 0 13 24 6 0 16 30 7 255
                   69 78 43 255 64 72 37 255 35 43 19 255
                   23 32 14 255 22 30 14 255 23 31 13 255
                   13 19 8 255 16 20 8 255 27 33 15 255
                   32 40 19 255 24 36 15 255 29 41 17 255
                   25 36 14 255 23 35 15 255 22 32 15 255
                   22 32 15 255 22 31 15 255 25 34 17 255
                   25 35 17 255 22 31 15 255 20 30 14 255
                   19 28 13 255 21 31 13 255 21 30 14 255
                   20 30 13 255 23 34 15 255 21 31 14 255
                   19 30 13 255 18 30 12 255 23 39 14 255
                   33 55 17 255 30 48 16 255 24 36 15 255
                   18 27 13 255 16 22 13 255 13 18 11 255
                   13 18 10 255 12 17 9 255 14 20 9 255
                   18 29 12 255 19 27 13 255 20 28 15 255
                   20 28 14 255 17 24 11 255 13 17 8 255
                   17 22 12 255 16 21 12 255 18 23 13 255
                   32 39 23 255 50 55 36 255 33 38 23 255
                   15 20 10 255 8 12 5 255 8 10 5 255
                   9 13 5 255 9 15 5 255 12 18 8 255
                   40 47 31 255 42 47 29 255 25 33 14 255
                   22 29 13 255 25 31 14 255 23 30 14 255
                   25 30 16 255 34 40 22 255 28 35 18 255
                   11 19 7 0 9 16 5 0 10 19 5 0
                   15 29 7 0 15 29 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   16 32 6 0 67 81 41 255 57 67 34 255
                   44 53 26 255 38 53 23 255 30 47 19 255
                   28 43 18 255 25 37 15 255 24 33 14 255
                   22 31 14 255 29 40 19 255 32 48 20 255
                   31 47 20 255 38 53 24 255 34 48 22 255
                   30 45 20 255 29 43 19 250 25 35 19 255
                   25 34 19 255 24 32 19 255 27 36 20 255
                   23 34 18 255 21 32 17 255 23 37 15 255
                   25 44 15 255 20 32 15 255 20 32 16 255
                   20 30 16 255 19 27 16 255 17 26 15 255
                   21 31 17 255 23 34 17 255 28 45 18 255
                   26 43 15 255 20 31 14 255 16 24 14 255
                   13 20 13 255 12 19 12 255 12 18 11 255
                   17 22 15 255 19 24 15 255 18 23 14 255
                   33 38 26 255 51 56 39 255 27 32 22 255
                   12 17 10 255 11 17 8 255 16 23 13 255
                   15 19 11 255 16 23 12 255 21 32 17 255
                   30 39 22 255 30 35 23 255 15 18 11 255
                   7 10 4 255 5 6 3 255 5 8 3 255
                   10 15 7 255 12 17 8 255 26 31 19 255
                   35 42 23 255 23 31 13 255 21 32 13 255
                   23 35 15 255 18 23 9 255 26 31 17 255
                   14 30 6 0 9 19 4 0 9 15 4 0
                   10 17 5 0 12 22 5 0 15 29 7 0
                   15 29 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 14 28 5 0
                   66 78 47 0 49 66 31 0 46 62 30 0
                   50 73 31 211 28 45 19 255 23 35 14 255
                   27 43 19 255 25 36 17 255 22 33 16 255
                   31 47 23 255 35 52 26 255 34 49 26 255
                   36 49 28 255 38 49 29 255 33 41 25 255
                   28 37 22 255 28 39 22 255 28 40 22 255
                   23 36 19 255 28 40 24 255 24 35 21 255
                   24 36 21 255 28 45 20 255 37 65 20 255
                   28 48 18 255 25 39 19 255 23 36 20 255
                   23 32 19 255 21 32 19 255 18 27 17 255
                   12 18 10 255 12 16 10 255 17 26 13 255
                   18 29 16 255 17 26 17 255 13 19 14 255
                   11 18 12 255 12 18 12 255 16 23 16 255
                   18 24 16 255 16 21 13 255 25 29 20 255
                   42 45 34 255 27 32 23 255 17 26 16 255
                   17 27 16 255 19 28 16 255 18 23 15 255
                   27 35 24 255 36 46 30 255 32 40 25 255
                   19 26 16 255 17 23 16 255 10 14 7 255
                   5 6 3 255 5 7 3 255 11 14 7 0
                   15 21 10 255 19 24 13 255 25 32 17 255
                   22 28 12 223 21 29 12 255 27 40 16 255
                   24 32 16 255 38 46 26 250 17 32 7 0
                   10 20 4 0 10 20 4 0 17 33 7 0
                   17 33 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 13 26 5 0 48 69 30 0
                   77 94 58 0 51 68 37 0 44 64 27 252
                   26 40 16 255 24 38 16 255 41 49 25 255
                   55 66 36 255 41 48 25 255 48 57 31 0
                   35 52 26 255 34 49 26 255 36 49 28 255
                   38 49 29 255 33 41 25 255 23 36 21 255
                   27 45 23 255 21 35 18 255 22 38 18 255
                   25 41 23 255 23 36 20 255 28 47 21 255
                   35 62 25 255 44 75 28 255 31 52 20 255
                   24 40 18 255 26 43 22 255 24 38 21 255
                   21 31 19 255 18 26 14 255 17 24 12 255
                   16 23 11 255 19 26 14 255 15 22 16 255
                   16 24 17 255 10 16 10 255 11 17 9 255
                   12 18 12 255 16 23 14 255 16 24 14 255
                   12 18 10 255 17 25 14 255 24 35 23 255
                   24 34 23 255 25 39 24 255 29 40 27 255
                   27 35 26 255 18 26 18 255 24 31 23 255
                   31 36 29 255 32 37 29 255 19 26 20 255
                   20 27 21 255 19 24 17 255 12 18 11 255
                   10 15 10 255 19 26 17 0 15 20 12 0
                   14 19 9 255 30 38 20 255 26 34 19 255
                   38 46 29 255 15 28 7 0 14 27 6 0
                   14 27 6 0 17 32 7 0 12 24 5 0
                   12 24 5 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   15 29 6 0 42 62 27 0 67 83 54 0
                   48 65 39 0 44 64 27 0 37 58 23 255
                   36 56 23 255 25 39 17 255 56 82 35 0
                   65 93 41 255 31 47 23 255 35 52 26 255
                   34 49 26 255 36 49 28 255 38 49 29 255
                   33 41 25 255 31 45 29 255 32 47 31 255
                   21 34 19 255 22 37 20 255 28 45 27 255
                   14 22 13 255 13 21 11 255 18 30 15 255
                   26 44 18 255 34 58 24 255 27 44 21 255
                   28 47 22 255 32 53 26 255 22 35 22 255
                   17 24 13 255 17 25 14 255 18 26 12 255
                   14 19 10 255 13 19 12 255 22 32 16 255
                   13 19 8 255 15 20 9 255 18 25 11 255
                   15 21 14 255 17 25 14 255 13 20 10 255
                   16 25 13 255 23 36 20 255 16 24 15 255
                   15 21 14 255 36 46 31 255 41 52 35 255
                   36 49 32 255 30 37 27 255 14 19 13 255
                   14 19 13 255 19 27 19 255 24 35 25 255
                   18 23 13 255 16 20 11 255 18 24 14 255
                   23 28 20 255 11 15 7 0 14 19 10 0
                   50 60 42 12 34 42 28 255 12 22 5 0
                   16 32 6 0 18 36 7 0 18 36 7 0
                   16 33 7 0 16 33 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   49 72 31 0 43 63 28 0 65 93 41 0
                   29 38 19 255 25 32 19 255 37 43 22 255
                   42 51 27 255 56 81 35 0 53 62 32 255
                   63 74 41 255 36 48 24 255 31 43 21 255
                   36 50 23 255 41 60 23 255 32 48 20 255
                   31 48 21 255 30 43 24 255 25 36 21 255
                   18 27 14 255 15 22 12 255 11 17 8 255
                   11 16 8 255 16 26 11 255 25 36 14 255
                   28 40 18 255 20 28 13 255 15 21 12 255
                   19 27 14 255 22 31 17 255 19 27 15 255
                   17 24 12 255 14 21 10 255 13 17 8 255
                   13 17 10 255 16 24 12 255 17 26 11 255
                   22 31 15 255 19 28 15 255 15 21 10 255
                   13 20 10 255 14 21 10 255 13 21 9 255
                   15 23 9 255 15 20 9 255 12 17 8 255
                   49 54 37 255 65 65 51 255 21 24 14 255
                   12 15 7 255 10 13 5 255 12 17 8 255
                   12 16 8 255 17 22 10 255 16 20 9 255
                   14 18 8 255 14 18 9 255 24 27 17 255
)"
        R"(                   30 35 21 255 11 23 5 0 16 29 6 0
                   13 23 7 0 10 18 5 0 13 23 5 0
                   18 36 7 0 18 36 7 0 16 33 7 0
                   16 33 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 109 120 67 0 74 86 41 0
                   54 63 30 0 39 47 23 0 24 31 13 255
                   27 32 17 255 34 49 21 255 42 49 25 255
                   62 68 39 255 61 69 36 255 46 54 28 255
                   55 64 35 255 36 49 22 255 31 45 16 255
                   41 62 19 255 38 58 20 255 37 58 19 255
                   24 38 14 255 18 27 14 255 16 21 11 255
                   13 20 10 255 15 23 12 255 13 19 10 255
                   19 26 10 255 23 33 15 255 17 25 11 255
                   21 33 11 255 16 20 13 255 16 20 13 255
                   24 31 17 255 27 36 19 246 24 36 16 255
                   20 27 14 255 18 24 12 255 15 21 10 255
                   14 17 7 255 14 18 8 255 18 24 12 255
                   21 29 15 255 16 24 11 255 14 21 9 255
                   13 19 8 255 13 20 8 255 18 27 10 255
                   10 15 7 255 10 13 6 255 23 28 15 255
                   31 34 21 255 15 18 11 255 9 12 6 255
                   11 15 7 255 28 35 17 255 16 20 9 255
                   16 24 10 255 18 25 10 255 14 20 9 255
                   14 19 10 255 23 27 16 255 35 39 24 255
                   14 26 7 0 15 29 7 0 14 25 7 0
                   12 23 5 0 13 26 5 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 64 73 41 0
                   34 42 21 0 34 44 18 255 41 51 23 255
                   34 40 23 255 35 44 21 255 47 61 25 255
                   43 57 25 0 39 50 22 255 49 57 32 0
                   52 66 28 255 37 56 20 255 33 48 18 255
                   28 43 17 255 34 54 17 255 31 50 15 255
                   22 34 14 255 19 27 13 255 18 27 13 255
                   19 28 13 255 15 22 10 255 18 23 11 255
                   21 31 15 255 21 31 14 255 21 33 11 255
                   35 41 27 255 50 56 36 255 28 35 20 255
                   22 31 16 255 24 36 16 255 21 31 15 255
                   20 26 14 255 16 20 12 255 14 17 10 255
                   11 15 8 255 15 19 12 255 23 28 16 255
                   17 24 12 255 20 27 15 255 17 25 11 255
                   14 22 8 255 19 29 11 255 12 18 7 255
                   13 18 7 255 20 25 13 255 19 23 12 255
                   22 25 15 255 18 22 12 255 25 30 16 255
                   41 49 25 255 29 37 17 255 17 24 10 255
                   22 27 13 255 35 41 24 255 20 26 13 255
                   21 26 14 255 30 37 21 255 10 18 5 0
                   14 29 6 0 15 30 7 0 15 29 6 0
                   14 28 5 0 16 32 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 11 22 5 0 23 33 14 0
                   37 54 23 255 56 80 35 255 43 62 27 255
                   49 71 31 0 64 79 33 255 53 72 29 0
                   49 64 30 0 47 58 28 0 43 58 23 255
                   35 51 17 255 29 43 17 255 26 39 16 255
                   24 35 15 255 32 50 17 227 27 42 16 255
                   22 34 15 255 17 25 12 255 15 22 11 255
                   21 29 15 255 27 35 19 255 28 40 19 255
                   28 41 19 255 21 33 11 255 37 40 25 255
                   35 38 24 255 24 31 18 255 21 30 16 255
                   22 31 15 255 22 31 15 255 22 30 15 255
                   23 32 16 255 24 32 16 255 27 37 18 255
                   20 30 14 255 24 33 15 255 25 37 16 255
                   22 32 14 255 18 27 11 255 12 18 8 255
                   10 14 7 255 16 23 12 255 17 22 10 255
                   22 27 13 255 26 29 17 255 29 35 21 255
                   20 25 14 255 22 28 15 255 43 48 29 255
                   43 46 29 255 19 24 11 255 23 27 13 255
                   45 49 29 255 18 23 12 255 21 27 15 255
                   11 20 6 0 11 20 5 0 15 29 6 0
                   16 30 7 0 14 26 5 0 13 25 4 0
                   16 32 6 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 10 18 5 0
                   10 15 5 0 12 20 5 0 13 26 6 0
                   18 36 7 0 64 93 41 0 76 84 46 0
                   62 72 37 0 64 74 41 0 63 72 39 0
                   50 61 28 0 34 51 19 255 34 51 17 255
                   33 50 18 255 32 49 20 0 24 38 17 0
                   27 42 18 255 28 43 16 255 26 41 16 255
                   19 30 14 255 17 25 13 255 21 30 16 255
                   28 39 20 255 30 43 19 255 30 44 19 255
                   21 33 11 255 27 37 17 255 21 30 15 255
                   24 36 18 255 27 39 20 255 16 24 12 255
                   15 22 11 255 19 27 13 255 21 32 15 255
                   25 38 15 255 26 39 16 255 24 36 15 255
                   27 38 18 255 29 42 19 255 23 35 15 255
                   20 29 12 255 14 21 9 255 10 13 6 255
                   10 14 7 255 12 16 7 255 16 20 9 255
                   24 29 14 255 45 50 29 255 38 41 25 255
                   26 30 17 255 29 33 21 255 23 29 16 255
                   19 25 11 255 24 30 16 255 43 49 29 255
                   22 27 14 255 8 14 4 0 11 20 5 0
                   14 25 6 0 16 30 7 0 15 29 7 0
                   16 31 6 0 17 33 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 10 15 5 0 10 14 5 0
                   16 32 7 0 18 36 7 0 18 36 7 0
                   72 83 47 0 54 66 32 0 67 81 43 0
                   65 74 44 0 79 91 51 0 51 69 28 0
                   39 60 21 255 48 73 23 227 47 72 24 255
                   40 61 24 0 31 48 21 0 28 43 19 255
                   26 41 15 255 33 51 17 255 33 53 20 255
                   28 45 18 255 28 44 19 255 33 51 21 235
                   34 53 20 255 32 49 19 255 21 33 11 255
                   36 57 21 255 32 50 20 255 31 47 21 255
                   37 56 23 255 24 36 15 255 17 26 12 255
                   21 29 14 255 21 33 15 255 25 39 16 255
                   27 41 17 255 33 46 23 255 49 58 34 255
                   39 48 26 255 26 36 16 255 24 34 15 255
                   22 32 13 255 15 21 11 255 13 16 9 255
                   18 24 13 255 13 18 9 255 18 22 10 255
                   37 43 24 255 30 35 21 255 33 42 23 255
                   24 32 17 255 19 25 13 255 19 26 12 255
                   28 33 20 255 36 40 24 255 12 20 6 255
                   11 22 5 255 10 20 4 255 11 22 5 0
                   17 33 7 0 17 33 7 0 18 36 7 0
                   18 36 7 0 17 32 7 0 17 32 7 0
                   18 36 7 0 18 36 7 0 17 33 7 0
                   17 33 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   15 29 6 0 15 29 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 15 30 7 0
                   15 30 7 0 18 36 7 0 17 33 7 0
                   65 94 41 0 63 81 36 0 48 68 25 0
                   51 74 27 0 56 83 28 0 41 64 22 0
                   24 38 15 255 23 36 15 255 29 45 18 255
                   34 53 18 255 34 55 19 255 36 58 20 236
                   37 57 23 255 34 51 21 255 37 57 22 255
                   39 60 23 255 21 33 11 255 27 42 18 255
                   30 48 20 255 33 51 22 255 40 58 25 255
                   39 58 24 255 37 53 24 255 34 52 22 255
                   28 44 17 255 24 39 16 255 28 44 19 255
                   31 44 20 255 21 33 11 255 52 59 37 255
                   24 33 16 255 24 32 15 255 28 37 19 255
                   24 31 17 255 17 24 13 255 30 39 22 255
                   30 38 20 255 23 28 15 255 15 21 10 255
                   10 16 7 255 16 25 11 255 29 42 20 255
                   24 34 18 255 12 17 8 255 12 17 8 255
                   17 22 11 255 19 26 11 255 12 24 7 255
                   11 21 6 255 12 23 6 0 17 33 7 0
                   17 33 7 0 17 33 7 0 18 36 7 0
                   17 32 7 0 15 29 6 0 14 28 6 0
                   16 32 6 0 17 33 7 0 17 33 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 17 33 7 0 65 94 41 0
                   74 93 45 0 47 64 28 0 46 61 28 0
                   54 75 31 0 41 64 23 0 24 38 14 255
                   29 46 18 255 48 74 28 255 49 77 25 255
                   43 67 24 255 38 61 23 255 41 61 25 255
                   41 58 25 255 37 55 24 255 42 56 29 255
                   21 33 11 255 21 33 11 255 26 40 19 255
                   32 49 22 255 35 50 21 255 37 50 23 255
                   33 47 23 255 35 51 23 255 25 39 16 255
                   20 31 14 255 28 40 19 255 25 38 18 255
                   21 33 11 255 44 49 34 255 21 33 11 255
                   28 33 20 255 41 47 30 255 34 41 24 255
                   21 29 15 255 26 35 18 255 39 52 26 255
                   32 45 22 255 15 24 11 255 11 16 7 255
                   16 24 10 255 28 40 19 255 27 38 19 255
                   17 23 11 255 14 18 8 255 21 27 13 255
                   18 26 11 255 16 24 11 255 41 47 30 255
                   15 30 7 0 14 27 6 0 13 25 5 0
                   15 30 6 0 18 36 7 0 18 36 7 0
                   15 28 6 0 12 22 5 0 14 28 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
)"
        R"(                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 15 29 6 0 15 29 6 0
                   16 32 6 0 64 93 40 0 83 102 50 0
                   63 81 40 0 57 72 37 0 52 65 32 0
                   39 53 24 0 48 64 31 255 52 70 33 255
                   56 74 38 255 64 84 40 255 71 90 45 255
                   52 68 33 255 47 61 31 255 51 64 36 255
                   46 57 33 255 47 54 34 255 21 33 11 255
                   21 33 11 255 21 33 11 255 21 33 11 255
                   36 51 24 255 47 63 30 255 47 62 32 255
                   37 50 26 255 12 19 7 255 12 19 7 255
                   19 30 10 255 21 33 11 255 21 33 11 255
                   21 33 11 255 21 33 11 255 35 43 25 255
                   29 36 20 255 22 30 16 255 26 37 19 255
                   32 43 23 255 41 53 29 255 37 48 26 255
                   23 29 15 255 19 25 14 255 34 43 23 255
                   23 31 15 255 20 29 14 255 41 54 28 255
                   29 39 21 255 22 31 13 255 18 28 12 255
                   25 31 16 255 33 40 20 0 46 55 29 0
                   45 53 29 0 10 20 5 0 14 26 6 0
                   16 31 6 0 16 31 6 0 16 32 7 0
                   15 28 6 0 16 32 6 0 18 36 7 0
                   16 32 6 0 16 32 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   15 29 6 0 15 29 6 0 14 29 5 0
                   14 29 5 0 18 36 7 0 78 102 45 0
                   78 95 50 0 42 57 26 0 36 48 23 0
                   52 65 34 59 30 39 20 255 31 39 23 255
                   65 79 44 0 69 81 46 255 29 37 20 255
                   20 27 13 255 30 41 21 255 40 50 29 0
                   39 49 28 255 36 49 28 255 21 33 11 255
                   31 45 25 255 21 33 11 255 30 45 22 255
                   41 58 28 255 40 58 26 255 38 56 26 255
                   27 39 19 255 26 38 18 255 19 30 10 255
                   21 33 11 255 25 35 19 255 19 30 10 255
                   30 44 21 255 29 42 21 255 29 39 20 255
                   24 33 16 255 34 48 23 255 46 61 29 255
                   46 59 29 255 39 47 26 255 12 18 8 255
                   8 14 6 255 15 23 11 255 19 25 11 255
                   19 25 11 0 40 51 25 0 35 44 22 255
                   27 37 17 255 32 41 21 255 32 39 22 255
                   20 31 12 0 26 34 15 255 38 46 25 0
                   40 46 26 0 15 29 7 0 16 31 6 0
                   16 31 6 0 18 36 7 0 17 33 7 0
                   17 33 7 0 18 36 7 0 15 29 6 0
                   15 29 6 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 16 32 6 0 16 32 6 0
                   18 36 7 0 91 112 57 0 74 107 47 0
                   55 81 35 0 42 56 30 0 41 57 29 255
                   28 41 19 255 25 35 19 255 44 54 31 0
                   40 51 28 255 17 26 13 255 18 27 13 255
                   39 55 26 0 44 64 31 0 36 53 26 0
                   34 48 25 255 38 51 30 255 21 33 11 255
                   21 33 11 255 28 43 23 255 34 51 25 255
                   40 58 27 255 38 53 29 255 21 33 11 255
                   29 40 22 255 26 37 21 255 34 48 26 255
                   26 37 20 255 16 25 9 255 33 50 23 255
                   25 38 18 255 27 40 19 255 41 58 29 255
                   38 55 27 255 44 61 29 255 49 63 31 255
                   44 56 29 255 21 32 13 255 12 21 8 255
                   19 28 14 255 33 41 23 0 45 55 31 0
                   49 62 30 0 36 47 23 0 38 51 24 0
                   47 55 28 0 38 49 24 248 27 37 16 255
                   33 44 19 255 53 59 36 0 70 77 52 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 17 33 7 0 17 33 7 0
                   18 36 7 0 16 32 7 0 16 32 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 16 33 7 0
                   104 116 81 0 33 50 21 0 32 40 23 0
                   76 84 58 0 59 68 42 255 47 60 35 255
                   46 58 35 0 51 64 40 0 57 72 44 170
                   32 43 24 255 30 43 23 255 45 64 31 0
                   51 72 35 0 45 61 34 0 36 48 26 255
                   35 51 27 255 38 52 30 255 21 33 11 255
                   33 49 27 255 39 58 27 255 46 63 29 255
                   21 33 11 255 21 33 11 255 13 20 8 255
                   13 20 8 255 36 48 29 255 29 38 21 255
                   27 38 17 255 21 33 11 255 27 40 19 255
                   20 29 13 255 29 38 22 255 30 42 24 255
                   33 46 26 255 43 57 30 255 38 50 25 255
                   38 51 25 255 40 52 27 255 39 49 28 255
                   45 52 31 255 58 65 39 255 76 93 51 0
                   62 79 42 0 52 68 35 0 53 65 35 0
                   57 70 37 0 59 77 37 0 61 78 40 0
                   75 87 51 0 119 129 91 0 18 36 7 0
                   18 36 7 0 18 36 7 0 17 32 7 0
                   15 29 6 0 16 32 6 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 82 96 59 0 64 93 41 0
                   33 50 21 0 33 50 21 0 62 71 42 0
                   50 62 36 0 70 86 53 0 97 110 77 0
                   106 116 88 0 96 105 77 0 70 81 50 0
                   61 78 44 0 62 79 45 0 55 70 38 0
                   50 65 36 0 44 61 32 255 46 68 34 255
                   44 61 32 255 42 58 33 255 48 62 38 255
                   38 53 27 255 38 53 25 255 21 33 11 255
                   29 40 23 255 41 51 16 255 11 15 9 255
                   34 45 28 255 23 32 17 255 26 39 17 255
                   21 33 11 255 43 62 30 255 35 46 25 255
                   31 38 23 255 37 50 29 255 40 55 31 255
                   45 56 32 0 40 49 28 255 37 47 27 255
                   32 39 21 255 33 40 24 255 29 36 18 255
                   29 37 18 255 48 62 31 255 58 75 39 0
                   75 92 53 0 67 83 47 0 78 94 56 0
                   88 107 65 0 96 120 69 0 101 121 73 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 17 32 7 0 15 29 6 0
                   16 32 6 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 93 108 67 0 81 90 59 0
                   74 87 50 0 50 64 32 0 56 72 37 0
                   82 95 59 0 90 98 67 0 64 72 47 0
                   64 74 48 0 89 102 70 0 85 103 66 0
                   84 99 63 0 57 75 42 0 46 62 34 0
                   38 55 27 209 38 56 26 225 41 57 30 255
                   39 55 30 0 37 52 28 255 31 45 23 255
                   21 33 11 255 21 33 11 255 25 35 21 255
                   41 51 16 255 10 14 8 255 28 39 22 255
                   22 32 17 255 26 40 17 255 13 20 7 255
                   21 31 13 255 13 21 7 255 28 39 20 255
                   37 54 29 255 39 50 29 255 38 45 27 255
                   42 51 32 2 30 42 20 255 21 31 15 255
                   32 42 23 255 30 40 21 201 27 36 17 255
                   44 60 30 0 47 61 32 0 76 92 54 0
                   91 110 65 0 96 113 73 0 127 142 101 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 92 104 69 0 66 82 44 0
                   63 78 43 0 81 94 61 0 86 97 61 0
                   72 83 47 0 52 61 34 0 72 83 54 0
                   96 104 74 0 122 136 103 0 134 149 114 0
                   99 119 77 0 75 95 59 0 48 62 35 255
                   38 53 27 255 41 57 30 255 37 53 28 0
                   26 39 20 255 25 36 19 255 21 33 11 255
                   21 33 11 255 29 42 25 255 41 51 16 255
                   14 19 11 255 23 34 19 255 28 39 21 255
                   30 43 22 255 24 35 18 255 9 15 6 255
                   22 34 15 255 34 50 23 255 48 72 35 255
                   45 61 33 0 39 45 29 0 32 36 22 0
                   24 35 16 255 29 42 19 63 38 50 25 10
                   39 52 30 0 46 57 33 188 67 83 51 0
                   80 95 63 0 109 125 89 0 129 149 103 0
                   113 134 86 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   74 107 47 0 74 107 47 0 74 107 47 0
                   106 118 88 0 65 94 41 0 98 110 75 0
                   88 101 62 0 87 98 53 0 86 95 52 0
                   18 36 7 0 18 36 7 0 18 36 7 0
)"
        R"(                   112 128 92 0 69 87 51 0 56 81 39 255
                   50 71 36 0 47 65 35 0 29 43 21 0
                   23 34 17 255 29 40 24 255 34 49 27 255
                   38 56 32 255 21 30 17 0 12 19 10 0
                   20 30 16 0 25 35 20 255 23 31 17 255
                   45 57 34 255 53 68 41 255 41 56 30 255
                   47 63 34 255 69 85 51 0 53 67 37 0
                   33 42 22 0 22 30 14 0 22 31 14 195
                   36 53 22 215 17 27 9 255 45 62 31 0
                   61 77 47 0 93 109 76 0 18 34 8 0
                   19 37 8 0 18 36 7 0 16 32 6 0
                   15 29 6 0 16 32 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 74 107 47 0 74 107 47 0
                   74 107 47 0 74 107 47 0 74 107 47 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   83 98 59 0 84 99 63 0 18 36 7 0
                   18 36 7 0 18 36 7 0 84 97 67 0
                   59 74 41 0 73 103 49 0 63 89 42 0
                   56 77 41 0 36 51 28 255 24 35 20 255
                   19 30 10 255 29 39 21 255 31 41 25 255
                   28 38 22 0 19 28 15 0 30 42 24 0
                   21 29 17 255 16 20 11 255 31 40 23 255
                   48 60 37 0 38 50 30 0 30 40 22 0
                   45 56 32 0 68 83 48 0 54 68 38 0
                   51 66 36 0 44 60 29 255 45 63 31 0
                   86 108 65 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 15 29 6 0 13 24 5 0
                   14 29 6 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 105 119 81 0 74 107 47 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 109 133 87 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 90 104 69 0 77 95 58 0
                   78 103 55 0 59 86 38 0 50 75 35 0
                   47 73 34 255 41 63 33 255 46 64 35 255
                   25 33 16 255 22 29 16 255 40 51 30 0
                   43 55 30 0 46 58 35 0 37 47 27 255
                   30 41 23 255 34 49 26 255 48 65 36 255
                   71 89 54 0 42 53 31 0 35 45 26 0
                   63 74 49 0 88 100 70 0 123 138 102 0
                   124 138 103 0 92 106 75 0 18 34 8 0
                   17 33 7 0 19 37 9 0 19 37 9 0
                   19 36 8 0 19 36 8 0 18 36 7 0
                   17 33 7 0 15 29 6 0 16 32 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 17 32 7 0 17 32 7 0
                   16 32 6 0 16 32 6 0 93 115 69 0
                   66 93 45 0 66 92 47 0 65 93 41 0
                   69 102 45 0 21 33 11 255 40 53 28 255
                   38 49 26 255 57 76 39 0 60 82 38 0
                   51 68 35 0 46 60 35 0 49 65 38 0
                   51 69 40 0 50 64 37 0 72 86 57 0
                   12 22 5 0 13 22 6 0 92 110 78 0
                   125 145 106 0 149 166 130 0 18 36 7 0
                   18 36 7 0 17 33 7 0 17 33 7 0
                   19 37 9 0 19 37 9 0 19 36 8 0
                   19 36 8 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   14 26 6 0 14 26 6 0 16 32 6 0
                   16 32 6 0 18 36 7 0 95 120 70 0
                   101 125 78 0 81 112 56 0 72 100 49 0
                   64 86 48 255 67 91 47 0 68 85 48 0
                   67 89 50 0 67 93 48 0 67 93 50 0
                   57 74 44 0 41 55 33 0 49 66 40 0
                   50 69 38 0 62 78 47 0 15 29 6 0
                   17 32 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 13 26 5 0
                   13 26 5 0 18 36 7 0 18 36 7 0
                   18 36 7 0 102 119 87 0 104 125 88 0
                   100 129 82 0 84 107 66 0 68 86 53 0
                   69 91 53 0 69 87 54 0 74 95 58 0
                   78 103 61 0 76 104 59 0 73 98 59 0
                   63 87 51 0 63 86 50 0 73 98 57 0
                   89 115 72 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 16 32 6 0 16 32 6 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   165 208 146 0 126 159 108 0 92 116 78 0
                   83 108 71 0 92 119 78 0 114 146 98 0
                   136 174 117 0 124 154 105 0 113 145 94 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 154 193 134 0
                   118 151 94 0 135 172 113 0 184 227 166 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0 18 36 7 0 18 36 7 0
                   18 36 7 0
                }
              }
            }
          }
          prototypeArrayState id=0
        }
      }
      vsg::Node id=32 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
)"
        R"(        bound -0.7981 -1.0853 1.8884 0.212191
        child id=33 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=34 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=35 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.175 0 0 0.175 0 0 0.175 0 0.24 -0.175 0 0.24
            }
            Array id=36 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=37 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=38 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.7981 -1.0853 1.7684
            }
            Indices id=39 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=40 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.5543 -0.9117 1.91274 0.156205
        child id=41 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=42 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=43 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=44 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=45 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=46 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.5543 -0.9117 1.79274
            }
            Indices id=47 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=48 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.8405 -1.259 1.88699 0.156205
        child id=49 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=50 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=51 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=52 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=53 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=54 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.8405 -1.259 1.76699
            }
            Indices id=55 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=56 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.3424 -0.8538 1.91718 0.156205
        child id=57 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=58 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=59 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=60 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=61 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=62 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.3424 -0.8538 1.79718
            }
            Indices id=63 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=64 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.8442 -1.3442 1.88686 0.13
        child id=65 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=66 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=67 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.24 -0.05 0 0.24
            }
            Array id=68 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=69 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=70 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.8442 -1.3442 1.76686
            }
            Indices id=71 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=72 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.4967 -1.418 1.87045 0.104709
        child id=73 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=74 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=75 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.184 -0.05 0 0.184
            }
            Array id=76 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=77 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=78 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.4967 -1.418 1.77845
            }
            Indices id=79 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=80 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.3131 -1.2704 1.8612 0.0852115
        child id=81 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=82 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=83 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.138 -0.05 0 0.138
            }
            Array id=84 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=85 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=86 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.3131 -1.2704 1.7922
            }
            Indices id=87 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=88 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.141 -0.8827 1.93059 0.156205
        child id=89 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=90 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=91 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=92 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=93 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=94 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.141 -0.8827 1.81059
            }
            Indices id=95 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=96 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.8723 -1.5339 1.8848 0.156205
        child id=97 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=98 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=99 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=100 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=101 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=102 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.8723 -1.5339 1.7648
            }
            Indices id=103 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=104 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.0902 -1.2049 1.8808 0.0934933
        child id=105 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=106 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=107 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
)"
        R"(              data -0.05 0 0 0.05 0 0 0.05 0 0.158 -0.05 0 0.158
            }
            Array id=108 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=109 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=110 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.0902 -1.2049 1.8018
            }
            Indices id=111 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=112 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.8639 -1.6885 1.87994 0.13
        child id=113 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=114 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=115 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.24 -0.05 0 0.24
            }
            Array id=116 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=117 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=118 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.8639 -1.6885 1.75994
            }
            Indices id=119 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=120 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.041 -1.3196 1.85887 0.075447
        child id=121 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=122 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=123 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.113 -0.05 0 0.113
            }
            Array id=124 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=125 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=126 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.041 -1.3196 1.80237
            }
            Indices id=127 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=128 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.9252 -1.8667 1.87417 0.156205
        child id=129 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=130 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=131 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=132 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=133 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=134 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.9252 -1.8667 1.75417
            }
            Indices id=135 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=136 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.2705 -1.2704 1.88081 0.0761988
        child id=137 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=138 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=139 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.115 -0.05 0 0.115
            }
            Array id=140 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=141 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=142 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.2705 -1.2704 1.82331
            }
            Indices id=143 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
    }
    vsg::Node id=144 vsg::Group
    {
      userObjects 0
      children 15
      vsg::Node id=145 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.904 -2.0259 1.87487 0.156205
        child id=146 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=147 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=148 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=149 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=150 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=151 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.904 -2.0259 1.75487
            }
            Indices id=152 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=153 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.8617 -2.1851 1.87628 0.156205
        child id=154 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=155 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=156 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=157 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=158 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=159 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.8617 -2.1851 1.75628
            }
            Indices id=160 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=161 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.7345 -2.3443 1.88052 0.156205
        child id=162 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=163 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=164 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=165 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=166 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=167 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.7345 -2.3443 1.76052
            }
            Indices id=168 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=169 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.8087 -2.4166 1.87853 0.156205
        child id=170 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=171 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=172 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=173 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=174 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=175 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.8087 -2.4166 1.75853
            }
            Indices id=176 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=177 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.5426 -2.3442 1.90492 0.146779
        child id=178 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=179 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=180 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.276 -0.05 0 0.276
            }
            Array id=181 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=182 vsg::vec2Array
)"
        R"(            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=183 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.5426 -2.3442 1.76692
            }
            Indices id=184 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=185 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.477 -2.4179 1.92763 0.165723
        child id=186 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=187 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=188 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.316 -0.05 0 0.316
            }
            Array id=189 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=190 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=191 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.477 -2.4179 1.76963
            }
            Indices id=192 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=193 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.3852 -2.5327 1.88956 0.123568
        child id=194 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=195 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=196 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.226 -0.05 0 0.226
            }
            Array id=197 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=198 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=199 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.3852 -2.5327 1.77656
            }
            Indices id=200 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=201 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.4967 -2.6474 1.9367 0.167631
        child id=202 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=203 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=204 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.32 -0.05 0 0.32
            }
            Array id=205 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=206 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=207 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.4967 -2.6474 1.7767
            }
            Indices id=208 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=209 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.6082 -2.7212 1.96492 0.190673
        child id=210 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=211 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=212 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.368 -0.05 0 0.368
            }
            Array id=213 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=214 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=215 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.6082 -2.7212 1.78092
            }
            Indices id=216 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=217 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.0836 -2.1311 1.83998 0.0852115
        child id=218 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=219 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=220 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.138 -0.05 0 0.138
            }
            Array id=221 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=222 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=223 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.0836 -2.1311 1.77098
            }
            Indices id=224 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=225 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.3131 -2.6065 1.89644 0.125399
        child id=226 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=227 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=228 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.23 -0.05 0 0.23
            }
            Array id=229 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=230 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=231 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.3131 -2.6065 1.78144
            }
            Indices id=232 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=233 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.6344 -2.8359 1.9298 0.151489
        child id=234 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=235 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=236 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.286 -0.05 0 0.286
            }
            Array id=237 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=238 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=239 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.6344 -2.8359 1.7868
            }
            Indices id=240 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=241 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.418 -2.7458 1.90965 0.134629
        child id=242 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=243 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=244 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.25 -0.05 0 0.25
            }
            Array id=245 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=246 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=247 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.418 -2.7458 1.78465
            }
            Indices id=248 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=249 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.0115 -2.213 1.8527 0.0934933
        child id=250 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=251 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=252 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.158 -0.05 0 0.158
            }
            Array id=253 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=254 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=255 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
)"
        R"(              data -0.0115 -2.213 1.7737
            }
            Indices id=256 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=257 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.2213 -2.6638 1.93743 0.159063
        child id=258 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=259 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=260 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.302 -0.05 0 0.302
            }
            Array id=261 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=262 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=263 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.2213 -2.6638 1.78643
            }
            Indices id=264 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
    }
    vsg::Node id=265 vsg::Group
    {
      userObjects 0
      children 15
      vsg::Node id=266 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.5492 -2.8933 1.9853 0.195502
        child id=267 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=268 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=269 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.378 -0.05 0 0.378
            }
            Array id=270 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=271 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=272 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.5492 -2.8933 1.7963
            }
            Indices id=273 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=274 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.0606 -2.2786 1.83239 0.075447
        child id=275 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=276 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=277 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.113 -0.05 0 0.113
            }
            Array id=278 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=279 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=280 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.0606 -2.2786 1.77589
            }
            Indices id=281 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=282 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.1951 -2.7622 1.91328 0.136488
        child id=283 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=284 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=285 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.254 -0.05 0 0.254
            }
            Array id=286 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=287 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=288 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.1951 -2.7622 1.78628
            }
            Indices id=289 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=290 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.5295 -3.0409 1.98078 0.173367
        child id=291 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=292 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=293 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.332 -0.05 0 0.332
            }
            Array id=294 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=295 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=296 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.5295 -3.0409 1.81478
            }
            Indices id=297 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=298 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.1328 -2.3442 1.83557 0.0761988
        child id=299 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=300 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=301 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.115 -0.05 0 0.115
            }
            Array id=302 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=303 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=304 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.1328 -2.3442 1.77807
            }
            Indices id=305 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=306 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.4246 -3.0491 1.9979 0.189708
        child id=307 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=308 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=309 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.366 -0.05 0 0.366
            }
            Array id=310 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=311 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=312 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.4246 -3.0491 1.8149
            }
            Indices id=313 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=314 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.123 -2.8687 1.91037 0.12083
        child id=315 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=316 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=317 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.22 -0.05 0 0.22
            }
            Array id=318 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=319 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=320 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.123 -2.8687 1.80037
            }
            Indices id=321 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=322 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.2246 -2.4343 1.85658 0.0905552
        child id=323 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=324 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=325 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.151 -0.05 0 0.151
            }
            Array id=326 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=327 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=328 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.2246 -2.4343 1.78108
            }
            Indices id=329 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
)"
        R"(            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=330 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -0.3 -3.0818 1.95516 0.145839
        child id=331 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=332 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=333 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.274 -0.05 0 0.274
            }
            Array id=334 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=335 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=336 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -0.3 -3.0818 1.81816
            }
            Indices id=337 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=338 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.0213 -2.9507 1.92001 0.129078
        child id=339 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=340 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=341 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.238 -0.05 0 0.238
            }
            Array id=342 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=343 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=344 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.0213 -2.9507 1.80101
            }
            Indices id=345 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=346 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.336 -2.5245 1.84761 0.0808223
        child id=347 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=348 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=349 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.127 -0.05 0 0.127
            }
            Array id=350 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=351 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=352 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.336 -2.5245 1.78411
            }
            Indices id=353 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=354 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.336 -1.4344 1.89228 0.0905552
        child id=355 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=356 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=357 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.151 -0.05 0 0.151
            }
            Array id=358 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=359 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=360 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.336 -1.4344 1.81678
            }
            Indices id=361 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=362 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.1065 -3.0163 1.90652 0.122654
        child id=363 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=364 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=365 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.224 -0.05 0 0.224
            }
            Array id=366 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=367 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=368 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.1065 -3.0163 1.79452
            }
            Indices id=369 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=370 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.4541 -2.4261 1.84485 0.0743304
        child id=371 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=372 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=373 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.11 -0.05 0 0.11
            }
            Array id=374 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=375 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=376 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.4541 -2.4261 1.78985
            }
            Indices id=377 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=378 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.4934 -2.2786 1.8495 0.077719
        child id=379 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=380 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=381 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.119 -0.05 0 0.119
            }
            Array id=382 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=383 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=384 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.4934 -2.2786 1.79
            }
            Indices id=385 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
    }
    vsg::Node id=386 vsg::Group
    {
      userObjects 0
      children 13
      vsg::Node id=387 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.0738 -3.1802 1.99905 0.192603
        child id=388 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=389 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=390 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.372 -0.05 0 0.372
            }
            Array id=391 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=392 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=393 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.0738 -3.1802 1.81305
            }
            Indices id=394 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=395 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.2508 -3.2048 1.95252 0.157166
        child id=396 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=397 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=398 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.298 -0.05 0 0.298
            }
            Array id=399 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=400 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=401 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.2508 -3.2048 1.80352
            }
            Indices id=402 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=403 vsg::DepthSorted
      {
)"
        R"(        userObjects 0
        binNumber 10
        bound 0.2836 -3.3031 1.96939 0.174324
        child id=404 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=405 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=406 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.334 -0.05 0 0.334
            }
            Array id=407 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=408 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=409 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.2836 -3.3031 1.80239
            }
            Indices id=410 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=411 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.5459 -2.6474 1.8798 0.105589
        child id=412 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=413 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=414 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.186 -0.05 0 0.186
            }
            Array id=415 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=416 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=417 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.5459 -2.6474 1.7868
            }
            Indices id=418 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=419 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.7426 -2.6884 1.85475 0.0897232
        child id=420 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=421 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=422 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.149 -0.05 0 0.149
            }
            Array id=423 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=424 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=425 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.7426 -2.6884 1.78025
            }
            Indices id=426 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=427 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.8475 -2.7458 1.8666 0.0973255
        child id=428 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=429 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=430 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.167 -0.05 0 0.167
            }
            Array id=431 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=432 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=433 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.8475 -2.7458 1.7831
            }
            Indices id=434 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=435 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.7295 -2.2868 1.846 0.0750733
        child id=436 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=437 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=438 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.112 -0.05 0 0.112
            }
            Array id=439 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=440 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=441 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.7295 -2.2868 1.79
            }
            Indices id=442 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=443 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.418 -2.8933 1.90031 0.106912
        child id=444 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=445 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=446 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.189 -0.05 0 0.189
            }
            Array id=447 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=448 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=449 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.418 -2.8933 1.80581
            }
            Indices id=450 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=451 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.4835 -2.5327 1.89156 0.0872482
        child id=452 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=453 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=454 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.143 -0.05 0 0.143
            }
            Array id=455 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=456 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=457 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.4835 -2.5327 1.82006
            }
            Indices id=458 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=459 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.6343 -3.0409 1.8915 0.10427
        child id=460 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=461 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=462 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.183 -0.05 0 0.183
            }
            Array id=463 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=464 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=465 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.6343 -3.0409 1.8
            }
            Indices id=466 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=467 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.6246 -1.418 1.9006 0.0808223
        child id=468 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=469 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=470 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.127 -0.05 0 0.127
            }
            Array id=471 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=472 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=473 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.6246 -1.418 1.8371
            }
            Indices id=474 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=475 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.6343 -2.1065 1.92282 0.0973255
        child id=476 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=477 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=478 vsg::vec3Array
            {
              userObjects 0
)"
        R"(              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.167 -0.05 0 0.167
            }
            Array id=479 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=480 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=481 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.6343 -2.1065 1.83932
            }
            Indices id=482 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=483 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.1819 -1.5983 1.95086 0.105589
        child id=484 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=485 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=486 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.186 -0.05 0 0.186
            }
            Array id=487 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=488 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=489 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.1819 -1.5983 1.85786
            }
            Indices id=490 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
    }
    vsg::Node id=491 vsg::Group
    {
      userObjects 0
      children 14
      vsg::Node id=492 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.8245 -2.3196 1.9364 0.104709
        child id=493 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=494 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=495 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.184 -0.05 0 0.184
            }
            Array id=496 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=497 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=498 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.8245 -2.3196 1.8444
            }
            Indices id=499 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=500 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.7623 -1.336 1.90673 0.0743304
        child id=501 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=502 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=503 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.11 -0.05 0 0.11
            }
            Array id=504 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=505 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=506 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.7623 -1.336 1.85173
            }
            Indices id=507 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=508 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.0639 -1.4753 1.91858 0.0750733
        child id=509 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=510 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=511 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.112 -0.05 0 0.112
            }
            Array id=512 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=513 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=514 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.0639 -1.4753 1.86258
            }
            Indices id=515 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=516 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.9393 -1.3934 1.91922 0.077719
        child id=517 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=518 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=519 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.119 -0.05 0 0.119
            }
            Array id=520 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=521 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=522 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.9393 -1.3934 1.85972
            }
            Indices id=523 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=524 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.0343 -2.6228 1.92097 0.0968968
        child id=525 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=526 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=527 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.166 -0.05 0 0.166
            }
            Array id=528 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=529 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=530 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.0343 -2.6228 1.83797
            }
            Indices id=531 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=532 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.9556 -2.3032 1.93349 0.0943398
        child id=533 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=534 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=535 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.16 -0.05 0 0.16
            }
            Array id=536 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=537 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=538 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.9556 -2.3032 1.85349
            }
            Indices id=539 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=540 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.1524 -3.4671 1.8685 0.0848071
        child id=541 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=542 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=543 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.137 -0.05 0 0.137
            }
            Array id=544 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=545 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=546 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.1524 -3.4671 1.8
            }
            Indices id=547 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=548 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.1786 -2.8851 1.90682 0.0968968
        child id=549 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=550 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=551 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.166 -0.05 0 0.166
            }
            Array id=552 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
)"
        R"(              storage id=0
              data 1 1 1 1
            }
            Array id=553 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=554 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.1786 -2.8851 1.82382
            }
            Indices id=555 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=556 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.4835 -1.5819 1.95078 0.0897232
        child id=557 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=558 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=559 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.149 -0.05 0 0.149
            }
            Array id=560 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=561 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=562 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.4835 -1.5819 1.87628
            }
            Indices id=563 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=564 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.7196 -1.7868 1.96304 0.109128
        child id=565 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=566 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=567 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.194 -0.05 0 0.194
            }
            Array id=568 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=569 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=570 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.7196 -1.7868 1.86604
            }
            Indices id=571 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=572 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.4082 -1.0409 1.94256 0.111803
        child id=573 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=574 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=575 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.2 -0.05 0 0.2
            }
            Array id=576 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=577 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=578 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.4082 -1.0409 1.84256
            }
            Indices id=579 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=580 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.1196 -2.3688 1.91927 0.080039
        child id=581 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=582 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=583 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.125 -0.05 0 0.125
            }
            Array id=584 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=585 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=586 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.1196 -2.3688 1.85677
            }
            Indices id=587 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=588 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.8573 -1.877 1.92127 0.0725
        child id=589 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=590 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=591 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.105 -0.05 0 0.105
            }
            Array id=592 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=593 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=594 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.8573 -1.877 1.86877
            }
            Indices id=595 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=596 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.0147 -1.9753 1.93472 0.0796492
        child id=597 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=598 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=599 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.124 -0.05 0 0.124
            }
            Array id=600 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=601 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=602 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.0147 -1.9753 1.87272
            }
            Indices id=603 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
    }
    vsg::Node id=604 vsg::Group
    {
      userObjects 0
      children 3
      vsg::Node id=605 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.4802 -3.3031 1.851 0.0714213
        child id=606 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=607 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=608 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.102 -0.05 0 0.102
            }
            Array id=609 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=610 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=611 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.4802 -3.3031 1.8
            }
            Indices id=612 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=613 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.9425 -1.5491 2.02462 0.166208
        child id=614 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=615 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=616 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.115 0 0 0.115 0 0 0.115 0 0.24 -0.115 0 0.24
            }
            Array id=617 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=618 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=619 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.9425 -1.5491 1.90462
            }
            Indices id=620 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=621 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.5589 -3.172 1.88406 0.0905552
        child id=622 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=623 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=624 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.151 -0.05 0 0.151
            }
            Array id=625 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=626 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
)"
        R"(            Array id=627 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.5589 -3.172 1.80856
            }
            Indices id=628 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
    }
    vsg::Node id=629 vsg::Group
    {
      userObjects 0
      children 18
      vsg::Node id=630 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.0958 -1.713 2.05107 0.184879
        child id=631 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=632 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=633 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.311 -0.1 0 0.311
            }
            Array id=634 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=635 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=636 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.0958 -1.713 1.89557
            }
            Indices id=637 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=638 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.3622 -2.0983 1.9557 0.0844038
        child id=639 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=640 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=641 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.136 -0.05 0 0.136
            }
            Array id=642 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=643 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=644 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.3622 -2.0983 1.8877
            }
            Indices id=645 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=646 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.4802 -2.3933 1.94146 0.0824029
        child id=647 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=648 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=649 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.131 -0.05 0 0.131
            }
            Array id=650 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=651 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=652 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.4802 -2.3933 1.87596
            }
            Indices id=653 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=654 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.336 -1.8278 2.00144 0.109573
        child id=655 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=656 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=657 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.195 -0.05 0 0.195
            }
            Array id=658 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=659 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=660 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.336 -1.8278 1.90394
            }
            Indices id=661 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=662 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.7163 -2.8114 1.91122 0.0973254
        child id=663 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=664 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=665 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.167 -0.05 0 0.167
            }
            Array id=666 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=667 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=668 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.7163 -2.8114 1.82772
            }
            Indices id=669 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=670 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.513 -2.0737 1.9884 0.102083
        child id=671 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=672 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=673 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.178 -0.05 0 0.178
            }
            Array id=674 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=675 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=676 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.513 -2.0737 1.8994
            }
            Indices id=677 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=678 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 1.9688 -1.2868 1.99831 0.0973255
        child id=679 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=680 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=681 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.167 -0.05 0 0.167
            }
            Array id=682 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=683 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=684 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1.9688 -1.2868 1.91481
            }
            Indices id=685 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=686 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.631 -2.254 1.98357 0.103832
        child id=687 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=688 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=689 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.182 -0.05 0 0.182
            }
            Array id=690 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=691 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=692 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.631 -2.254 1.89257
            }
            Indices id=693 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=694 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.7163 -2.4179 1.95647 0.0880695
        child id=695 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=696 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=697 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.145 -0.05 0 0.145
            }
            Array id=698 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=699 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=700 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.7163 -2.4179 1.88397
            }
            Indices id=701 vsg::ushortArray
            {
              userObjects 0
)"
        R"(              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=702 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 2.1196 -1.1147 2.00835 0.0918096
        child id=703 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=704 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=705 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.154 -0.05 0 0.154
            }
            Array id=706 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=707 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=708 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 2.1196 -1.1147 1.93135
            }
            Indices id=709 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=710 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 3.0441 -2.4671 1.9904 0.106471
        child id=711 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=712 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=713 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.188 -0.05 0 0.188
            }
            Array id=714 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=715 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=716 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 3.0441 -2.4671 1.8964
            }
            Indices id=717 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=718 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 3.2081 -2.4179 1.98931 0.0918095
        child id=719 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=720 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=721 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.154 -0.05 0 0.154
            }
            Array id=722 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=723 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=724 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 3.2081 -2.4179 1.91231
            }
            Indices id=725 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=726 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 3.2277 -2.3196 2.00254 0.0913906
        child id=727 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=728 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=729 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.153 -0.05 0 0.153
            }
            Array id=730 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=731 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=732 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 3.2277 -2.3196 1.92604
            }
            Indices id=733 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=734 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 3.3654 -2.5819 1.98673 0.0947642
        child id=735 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=736 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=737 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.161 -0.05 0 0.161
            }
            Array id=738 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=739 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=740 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 3.3654 -2.5819 1.90623
            }
            Indices id=741 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=742 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 3.4179 -2.7622 1.99644 0.110018
        child id=743 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=744 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=745 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.196 -0.05 0 0.196
            }
            Array id=746 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=747 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=748 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 3.4179 -2.7622 1.89844
            }
            Indices id=749 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=750 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 3.4769 -2.4671 1.99799 0.0812157
        child id=751 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=752 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=753 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.05 0 0 0.05 0 0 0.05 0 0.128 -0.05 0 0.128
            }
            Array id=754 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=755 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=756 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 3.4769 -2.4671 1.93399
            }
            Indices id=757 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=758 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.6639 3.2048 2.80344 0.1
        child id=759 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=760 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=761 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.06 0 0 0.06 0 0 0.06 0 0.16 -0.06 0 0.16
            }
            Array id=762 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=763 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=764 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.6639 3.2048 2.72344
            }
            Indices id=765 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=766 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound 0.6246 3.4835 2.80044 0.160078
        child id=767 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=768 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=769 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.125 0 0 0.125 0 0 0.125 0 0.2 -0.125 0 0.2
            }
            Array id=770 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=771 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=772 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data 0.6246 3.4835 2.70044
            }
            Indices id=773 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
)"
        R"(          prototypeArrayState id=0
        }
      }
    }
    vsg::Node id=774 vsg::Group
    {
      userObjects 0
      children 3
      vsg::Node id=775 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -3.2355 -1.8378 1.79592 0.156205
        child id=776 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=777 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=778 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=779 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=780 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=781 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -3.2355 -1.8378 1.67592
            }
            Indices id=782 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=783 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -3.3202 -1.6497 1.79935 0.156205
        child id=784 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=785 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=786 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=787 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=788 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=789 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -3.3202 -1.6497 1.67935
            }
            Indices id=790 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
      vsg::Node id=791 vsg::DepthSorted
      {
        userObjects 0
        binNumber 10
        bound -3.3308 -1.5484 1.80237 0.156205
        child id=792 vsg::StateGroup
        {
          userObjects 0
          children 1
          vsg::Node id=793 vsg::VertexIndexDraw
          {
            userObjects 0
            firstBinding 0
            NumArrays 4
            Array id=794 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 4
              storage id=0
              data -0.1 0 0 0.1 0 0 0.1 0 0.24 -0.1 0 0.24
            }
            Array id=795 vsg::vec4Array
            {
              userObjects 0
              Layout 0 16 0 1 1 1 0 -1
              size 1
              storage id=0
              data 1 1 1 1
            }
            Array id=796 vsg::vec2Array
            {
              userObjects 0
              Layout 0 8 0 1 1 1 0 -1
              size 4
              storage id=0
              data 0 0 1 0 1 1 0 1
            }
            Array id=797 vsg::vec3Array
            {
              userObjects 0
              Layout 0 12 0 1 1 1 0 -1
              size 1
              storage id=0
              data -3.3308 -1.5484 1.68237
            }
            Indices id=798 vsg::ushortArray
            {
              userObjects 0
              Layout 0 2 0 1 1 1 0 -1
              size 6
              storage id=0
              data 0 1 2 0 2 3
            }
            indexCount 6
            instanceCount 1
            firstIndex 0
            vertexOffset 0
            firstInstance 0
          }
          stateCommands 2
          vsg::StateCommand id=13
          vsg::StateCommand id=27
          prototypeArrayState id=0
        }
      }
    }
    matrix 1 0 0 0 0 1 0 0 0 0 1 0
     0 0 0 1
    subgraphRequiresLocalFrustum 1
  }
  vsg::Node id=799 vsg::Group
  {
    userObjects 0
    children 1
    vsg::Node id=800 vsg::CullNode
    {
      userObjects 0
      bound -0.150145 0.15039 2.855 8.05031
      child id=801 vsg::StateGroup
      {
        userObjects 0
        children 1
        vsg::Node id=802 vsg::VertexIndexDraw
        {
          userObjects 0
          firstBinding 0
          NumArrays 3
          Array id=803 vsg::vec3Array
          {
            userObjects 0
            Layout 0 12 0 1 1 1 0 -1
            size 1482
            storage id=0
            data -5.55029 -5.69922 1.78 -5.55029 -5.40234 1.82 -5.55029 -5.10156 1.86 -5.55029 -4.80078 1.88
             -5.55029 -4.5 1.9 -5.55029 -4.19922 1.9 -5.55029 -3.90234 1.89 -5.55029 -3.60156 1.88
             -5.55029 -3.30078 1.86 -5.55029 -3 1.85 -5.55029 -2.69922 1.83 -5.55029 -2.40234 1.81
             -5.55029 -2.10156 1.78 -5.55029 -1.80078 1.75 -5.55029 -1.5 1.73 -5.55029 -1.19922 1.71
             -5.55029 -0.902344 1.7 -5.55029 -0.601562 1.69 -5.55029 -0.300781 1.7 -5.55029 0 1.74
             -5.55029 0.300781 1.79 -5.55029 0.597656 1.86 -5.55029 0.898438 1.94 -5.55029 1.19922 1.99
             -5.55029 1.5 2.02 -5.55029 1.80078 2.03 -5.55029 2.09766 2.03 -5.55029 2.39844 2.02
             -5.55029 2.69922 2.01 -5.55029 3 1.99 -5.55029 3.30078 1.97 -5.55029 3.59766 1.96
             -5.55029 3.89844 1.95 -5.55029 4.19922 1.95 -5.55029 4.5 1.95 -5.55029 4.80078 1.95
             -5.55029 5.09766 1.94 -5.55029 5.39844 1.93 -5.55029 5.69922 1.92 -5.25 -5.69922 1.86
             -5.25 -5.40234 1.91 -5.25 -5.10156 1.96 -5.25 -4.80078 1.99 -5.25 -4.5 2.01
             -5.25 -4.19922 2 -5.25 -3.90234 1.97 -5.25 -3.60156 1.94 -5.25 -3.30078 1.91
             -5.25 -3 1.87 -5.25 -2.69922 1.84 -5.25 -2.40234 1.8 -5.25 -2.10156 1.77
             -5.25 -1.80078 1.74 -5.25 -1.5 1.73 -5.25 -1.19922 1.72 -5.25 -0.902344 1.72
             -5.25 -0.601562 1.73 -5.25 -0.300781 1.76 -5.25 0 1.79 -5.25 0.300781 1.83
             -5.25 0.597656 1.87 -5.25 0.898438 1.91 -5.25 1.19922 1.94 -5.25 1.5 1.97
             -5.25 1.80078 1.99 -5.25 2.09766 2.01 -5.25 2.39844 2.02 -5.25 2.69922 2.01
             -5.25 3 1.99 -5.25 3.30078 1.97 -5.25 3.59766 1.96 -5.25 3.89844 1.96
             -5.25 4.19922 1.96 -5.25 4.5 1.96 -5.25 4.80078 1.96 -5.25 5.09766 1.96
             -5.25 5.39844 1.96 -5.25 5.69922 1.96 -4.9502 -5.69922 1.92 -4.9502 -5.40234 1.98
             -4.9502 -5.10156 2.03 -4.9502 -4.80078 2.06 -4.9502 -4.5 2.07 -4.9502 -4.19922 2.05
             -4.9502 -3.90234 2.01 -4.9502 -3.60156 1.97 -4.9502 -3.30078 1.92 -4.9502 -3 1.87
             -4.9502 -2.69922 1.83 -4.9502 -2.40234 1.79 -4.9502 -2.10156 1.75 -4.9502 -1.80078 1.73
             -4.9502 -1.5 1.72 -4.9502 -1.19922 1.72 -4.9502 -0.902344 1.74 -4.9502 -0.601562 1.77
             -4.9502 -0.300781 1.81 -4.9502 0 1.84 -4.9502 0.300781 1.87 -4.9502 0.597656 1.89
             -4.9502 0.898438 1.91 -4.9502 1.19922 1.92 -4.9502 1.5 1.94 -4.9502 1.80078 1.97
             -4.9502 2.09766 2 -4.9502 2.39844 2.01 -4.9502 2.69922 2.01 -4.9502 3 2
             -4.9502 3.30078 1.98 -4.9502 3.59766 1.97 -4.9502 3.89844 1.97 -4.9502 4.19922 1.97
             -4.9502 4.5 1.98 -4.9502 4.80078 1.98 -4.9502 5.09766 1.99 -4.9502 5.39844 1.99
             -4.9502 5.69922 2.01 -4.6499 -5.69922 1.98 -4.6499 -5.40234 2.03 -4.6499 -5.10156 2.07
             -4.6499 -4.80078 2.09 -4.6499 -4.5 2.08 -4.6499 -4.19922 2.05 -4.6499 -3.90234 2
             -4.6499 -3.60156 1.95 -4.6499 -3.30078 1.9 -4.6499 -3 1.84 -4.6499 -2.69922 1.8
             -4.6499 -2.40234 1.76 -4.6499 -2.10156 1.72 -4.6499 -1.80078 1.71 -4.6499 -1.5 1.71
             -4.6499 -1.19922 1.72 -4.6499 -0.902344 1.75 -4.6499 -0.601562 1.8 -4.6499 -0.300781 1.86
             -4.6499 0 1.9 -4.6499 0.300781 1.93 -4.6499 0.597656 1.94 -4.6499 0.898438 1.94
             -4.6499 1.19922 1.95 -4.6499 1.5 1.96 -4.6499 1.80078 1.98 -4.6499 2.09766 2
             -4.6499 2.39844 2.01 -4.6499 2.69922 2.01 -4.6499 3 2 -4.6499 3.30078 1.99
             -4.6499 3.59766 1.98 -4.6499 3.89844 1.98 -4.6499 4.19922 1.99 -4.6499 4.5 2
             -4.6499 4.80078 2.01 -4.6499 5.09766 2.02 -4.6499 5.39844 2.04 -4.6499 5.69922 2.06
             -4.3501 -5.69922 2.02 -4.3501 -5.40234 2.04 -4.3501 -5.10156 2.06 -4.3501 -4.80078 2.06
             -4.3501 -4.5 2.04 -4.3501 -4.19922 2 -4.3501 -3.90234 1.95 -4.3501 -3.60156 1.9
             -4.3501 -3.30078 1.84 -4.3501 -3 1.79 -4.3501 -2.69922 1.75 -4.3501 -2.40234 1.71
             -4.3501 -2.10156 1.69 -4.3501 -1.80078 1.68 -4.3501 -1.5 1.69 -4.3501 -1.19922 1.72
             -4.3501 -0.902344 1.76 -4.3501 -0.601562 1.82 -4.3501 -0.300781 1.88 -4.3501 0 1.93
             -4.3501 0.300781 1.96 -4.3501 0.597656 1.96 -4.3501 0.898438 1.96 -4.3501 1.19922 1.96
             -4.3501 1.5 1.97 -4.3501 1.80078 1.99 -4.3501 2.09766 2.01 -4.3501 2.39844 2.02
             -4.3501 2.69922 2.02 -4.3501 3 2.01 -4.3501 3.30078 1.99 -4.3501 3.59766 1.99
             -4.3501 3.89844 1.99 -4.3501 4.19922 2 -4.3501 4.5 2.02 -4.3501 4.80078 2.04
             -4.3501 5.09766 2.06 -4.3501 5.39844 2.08 -4.3501 5.69922 2.1 -4.05029 -5.69922 2.06
             -4.05029 -5.40234 2.07 -4.05029 -5.10156 2.07 -4.05029 -4.80078 2.05 -4.05029 -4.5 2.02
             -4.05029 -4.19922 1.97 -4.05029 -3.90234 1.9 -4.05029 -3.60156 1.84 -4.05029 -3.30078 1.78
             -4.05029 -3 1.74 -4.05029 -2.69922 1.7 -4.05029 -2.40234 1.68 -4.05029 -2.10156 1.67
             -4.05029 -1.80078 1.67 -4.05029 -1.5 1.68 -4.05029 -1.19922 1.71 -4.05029 -0.902344 1.74
             -4.05029 -0.601562 1.78 -4.05029 -0.300781 1.83 -4.05029 0 1.87 -4.05029 0.300781 1.89
             -4.05029 0.597656 1.9 -4.05029 0.898438 1.9 -4.05029 1.19922 1.91 -4.05029 1.5 1.93
             -4.05029 1.80078 1.95 -4.05029 2.09766 1.98 -4.05029 2.39844 2 -4.05029 2.69922 2.01
             -4.05029 3 2.01 -4.05029 3.30078 2 -4.05029 3.59766 2 -4.05029 3.89844 2
             -4.05029 4.19922 2.02 -4.05029 4.5 2.04 -4.05029 4.80078 2.06 -4.05029 5.09766 2.08
             -4.05029 5.39844 2.11 -4.05029 5.69922 2.13 -3.75 -5.69922 2.1 -3.75 -5.40234 2.11
             -3.75 -5.10156 2.1 -3.75 -4.80078 2.07 -3.75 -4.5 2.02 -3.75 -4.19922 1.95
             -3.75 -3.90234 1.87 -3.75 -3.60156 1.8 -3.75 -3.30078 1.74 -3.75 -3 1.7
             -3.75 -2.69922 1.68 -3.75 -2.40234 1.66 -3.75 -2.10156 1.66 -3.75 -1.80078 1.67
             -3.75 -1.5 1.68 -3.75 -1.19922 1.7 -3.75 -0.902344 1.72 -3.75 -0.601562 1.74
             -3.75 -0.300781 1.77 -3.75 0 1.79 -3.75 0.300781 1.81 -3.75 0.597656 1.82
             -3.75 0.898438 1.82 -3.75 1.19922 1.84 -3.75 1.5 1.86 -3.75 1.80078 1.9
             -3.75 2.09766 1.94 -3.75 2.39844 1.96 -3.75 2.69922 1.98 -3.75 3 1.99
             -3.75 3.30078 2 -3.75 3.59766 2.01 -3.75 3.89844 2.02 -3.75 4.19922 2.04
             -3.75 4.5 2.06 -3.75 4.80078 2.09 -3.75 5.09766 2.11 -3.75 5.39844 2.13
             -3.75 5.69922 2.16 -3.4502 -5.69922 2.1 -3.4502 -5.40234 2.1 -3.4502 -5.10156 2.08
             -3.4502 -4.80078 2.05 -3.4502 -4.5 2 -3.4502 -4.19922 1.92 -3.4502 -3.90234 1.84
             -3.4502 -3.60156 1.78 -3.4502 -3.30078 1.72 -3.4502 -3 1.69 -3.4502 -2.69922 1.67
             -3.4502 -2.40234 1.66 -3.4502 -2.10156 1.66 -3.4502 -1.80078 1.67 -3.4502 -1.5 1.68
             -3.4502 -1.19922 1.69 -3.4502 -0.902344 1.71 -3.4502 -0.601562 1.72 -3.4502 -0.300781 1.73
             -3.4502 0 1.74 -3.4502 0.300781 1.75 -3.4502 0.597656 1.76 -3.4502 0.898438 1.77
             -3.4502 1.19922 1.79 -3.4502 1.5 1.82 -3.4502 1.80078 1.86 -3.4502 2.09766 1.9
             -3.4502 2.39844 1.94 -3.4502 2.69922 1.97 -3.4502 3 1.99 -3.4502 3.30078 2.01
             -3.4502 3.59766 2.03 -3.4502 3.89844 2.05 -3.4502 4.19922 2.07 -3.4502 4.5 2.09
             -3.4502 4.80078 2.12 -3.4502 5.09766 2.14 -3.4502 5.39844 2.16 -3.4502 5.69922 2.18
             -3.1499 -5.69922 2.06 -3.1499 -5.40234 2.04 -3.1499 -5.10156 2.02 -3.1499 -4.80078 1.98
             -3.1499 -4.5 1.94 -3.1499 -4.19922 1.88 -3.1499 -3.90234 1.81 -3.1499 -3.60156 1.76
             -3.1499 -3.30078 1.72 -3.1499 -3 1.7 -3.1499 -2.69922 1.68 -3.1499 -2.40234 1.67
             -3.1499 -2.10156 1.67 -3.1499 -1.80078 1.68 -3.1499 -1.5 1.69 -3.1499 -1.19922 1.7
             -3.1499 -0.902344 1.71 -3.1499 -0.601562 1.71 -3.1499 -0.300781 1.72 -3.1499 0 1.72
             -3.1499 0.300781 1.73 -3.1499 0.597656 1.74 -3.1499 0.898438 1.75 -3.1499 1.19922 1.77
             -3.1499 1.5 1.81 -3.1499 1.80078 1.87 -3.1499 2.09766 1.93 -3.1499 2.39844 1.98
             -3.1499 2.69922 2.02 -3.1499 3 2.04 -3.1499 3.30078 2.05 -3.1499 3.59766 2.06
             -3.1499 3.89844 2.08 -3.1499 4.19922 2.1 -3.1499 4.5 2.12 -3.1499 4.80078 2.15
             -3.1499 5.09766 2.17 -3.1499 5.39844 2.19 -3.1499 5.69922 2.22 -2.8501 -5.69922 2
             -2.8501 -5.40234 1.97 -2.8501 -5.10156 1.94 -2.8501 -4.80078 1.9 -2.8501 -4.5 1.86
             -2.8501 -4.19922 1.82 -2.8501 -3.90234 1.78 -2.8501 -3.60156 1.75 -2.8501 -3.30078 1.72
             -2.8501 -3 1.71 -2.8501 -2.69922 1.7 -2.8501 -2.40234 1.69 -2.8501 -2.10156 1.69
             -2.8501 -1.80078 1.7 -2.8501 -1.5 1.71 -2.8501 -1.19922 1.71 -2.8501 -0.902344 1.72
             -2.8501 -0.601562 1.72 -2.8501 -0.300781 1.72 -2.8501 0 1.72 -2.8501 0.300781 1.72
             -2.8501 0.597656 1.73 -2.8501 0.898438 1.75 -2.8501 1.19922 1.78 -2.8501 1.5 1.82
             -2.8501 1.80078 1.89 -2.8501 2.09766 1.97 -2.8501 2.39844 2.03 -2.8501 2.69922 2.08
             -2.8501 3 2.09 -2.8501 3.30078 2.09 -2.8501 3.59766 2.09 -2.8501 3.89844 2.1
             -2.8501 4.19922 2.12 -2.8501 4.5 2.15 -2.8501 4.80078 2.17 -2.8501 5.09766 2.2
             -2.8501 5.39844 2.22 -2.8501 5.69922 2.26 -2.55029 -5.69922 1.94 -2.55029 -5.40234 1.91
             -2.55029 -5.10156 1.87 -2.55029 -4.80078 1.84 -2.55029 -4.5 1.81 -2.55029 -4.19922 1.79
             -2.55029 -3.90234 1.77 -2.55029 -3.60156 1.75 -2.55029 -3.30078 1.73 -2.55029 -3 1.72
             -2.55029 -2.69922 1.71 -2.55029 -2.40234 1.71 -2.55029 -2.10156 1.71 -2.55029 -1.80078 1.71
             -2.55029 -1.5 1.72 -2.55029 -1.19922 1.72 -2.55029 -0.902344 1.73 -2.55029 -0.601562 1.73
             -2.55029 -0.300781 1.72 -2.55029 0 1.72 -2.55029 0.300781 1.72 -2.55029 0.597656 1.73
             -2.55029 0.898438 1.76 -2.55029 1.19922 1.79 -2.55029 1.5 1.84 -2.55029 1.80078 1.92
             -2.55029 2.09766 2.01 -2.55029 2.39844 2.08 -2.55029 2.69922 2.12 -2.55029 3 2.13
             -2.55029 3.30078 2.12 -2.55029 3.59766 2.11 -2.55029 3.89844 2.12 -2.55029 4.19922 2.13
             -2.55029 4.5 2.16 -2.55029 4.80078 2.18 -2.55029 5.09766 2.21 -2.55029 5.39844 2.24
             -2.55029 5.69922 2.28 -2.25 -5.69922 1.89 -2.25 -5.40234 1.85 -2.25 -5.10156 1.82
)"
        R"(             -2.25 -4.80078 1.8 -2.25 -4.5 1.78 -2.25 -4.19922 1.76 -2.25 -3.90234 1.75
             -2.25 -3.60156 1.74 -2.25 -3.30078 1.74 -2.25 -3 1.73 -2.25 -2.69922 1.73
             -2.25 -2.40234 1.72 -2.25 -2.10156 1.72 -2.25 -1.80078 1.72 -2.25 -1.5 1.73
             -2.25 -1.19922 1.73 -2.25 -0.902344 1.74 -2.25 -0.601562 1.73 -2.25 -0.300781 1.72
             -2.25 0 1.72 -2.25 0.300781 1.73 -2.25 0.597656 1.75 -2.25 0.898438 1.78
             -2.25 1.19922 1.82 -2.25 1.5 1.88 -2.25 1.80078 1.96 -2.25 2.09766 2.06
             -2.25 2.39844 2.13 -2.25 2.69922 2.17 -2.25 3 2.17 -2.25 3.30078 2.15
             -2.25 3.59766 2.14 -2.25 3.89844 2.13 -2.25 4.19922 2.14 -2.25 4.5 2.16
             -2.25 4.80078 2.18 -2.25 5.09766 2.21 -2.25 5.39844 2.24 -2.25 5.69922 2.29
             -1.9502 -5.69922 1.83 -1.9502 -5.40234 1.8 -1.9502 -5.10156 1.78 -1.9502 -4.80078 1.76
             -1.9502 -4.5 1.74 -1.9502 -4.19922 1.74 -1.9502 -3.90234 1.74 -1.9502 -3.60156 1.74
             -1.9502 -3.30078 1.74 -1.9502 -3 1.74 -1.9502 -2.69922 1.73 -1.9502 -2.40234 1.73
             -1.9502 -2.10156 1.73 -1.9502 -1.80078 1.73 -1.9502 -1.5 1.74 -1.9502 -1.19922 1.74
             -1.9502 -0.902344 1.74 -1.9502 -0.601562 1.74 -1.9502 -0.300781 1.73 -1.9502 0 1.73
             -1.9502 0.300781 1.74 -1.9502 0.597656 1.77 -1.9502 0.898438 1.8 -1.9502 1.19922 1.85
             -1.9502 1.5 1.92 -1.9502 1.80078 2.01 -1.9502 2.09766 2.11 -1.9502 2.39844 2.18
             -1.9502 2.69922 2.22 -1.9502 3 2.22 -1.9502 3.30078 2.19 -1.9502 3.59766 2.17
             -1.9502 3.89844 2.15 -1.9502 4.19922 2.16 -1.9502 4.5 2.17 -1.9502 4.80078 2.19
             -1.9502 5.09766 2.21 -1.9502 5.39844 2.24 -1.9502 5.69922 2.29 -1.6499 -5.69922 1.81
             -1.6499 -5.40234 1.79 -1.6499 -5.10156 1.78 -1.6499 -4.80078 1.76 -1.6499 -4.5 1.75
             -1.6499 -4.19922 1.75 -1.6499 -3.90234 1.75 -1.6499 -3.60156 1.75 -1.6499 -3.30078 1.75
             -1.6499 -3 1.75 -1.6499 -2.69922 1.74 -1.6499 -2.40234 1.73 -1.6499 -2.10156 1.73
             -1.6499 -1.80078 1.73 -1.6499 -1.5 1.74 -1.6499 -1.19922 1.74 -1.6499 -0.902344 1.75
             -1.6499 -0.601562 1.74 -1.6499 -0.300781 1.74 -1.6499 0 1.74 -1.6499 0.300781 1.75
             -1.6499 0.597656 1.79 -1.6499 0.898438 1.83 -1.6499 1.19922 1.88 -1.6499 1.5 1.95
             -1.6499 1.80078 2.04 -1.6499 2.09766 2.14 -1.6499 2.39844 2.21 -1.6499 2.69922 2.26
             -1.6499 3 2.25 -1.6499 3.30078 2.22 -1.6499 3.59766 2.2 -1.6499 3.89844 2.19
             -1.6499 4.19922 2.19 -1.6499 4.5 2.21 -1.6499 4.80078 2.22 -1.6499 5.09766 2.24
             -1.6499 5.39844 2.27 -1.6499 5.69922 2.31 -1.3501 -5.69922 1.84 -1.3501 -5.40234 1.83
             -1.3501 -5.10156 1.82 -1.3501 -4.80078 1.81 -1.3501 -4.5 1.8 -1.3501 -4.19922 1.79
             -1.3501 -3.90234 1.78 -1.3501 -3.60156 1.77 -1.3501 -3.30078 1.76 -1.3501 -3 1.76
             -1.3501 -2.69922 1.75 -1.3501 -2.40234 1.74 -1.3501 -2.10156 1.74 -1.3501 -1.80078 1.74
             -1.3501 -1.5 1.75 -1.3501 -1.19922 1.75 -1.3501 -0.902344 1.75 -1.3501 -0.601562 1.75
             -1.3501 -0.300781 1.75 -1.3501 0 1.75 -1.3501 0.300781 1.77 -1.3501 0.597656 1.8
             -1.3501 0.898438 1.85 -1.3501 1.19922 1.91 -1.3501 1.5 1.98 -1.3501 1.80078 2.06
             -1.3501 2.09766 2.15 -1.3501 2.39844 2.22 -1.3501 2.69922 2.27 -1.3501 3 2.27
             -1.3501 3.30078 2.24 -1.3501 3.59766 2.23 -1.3501 3.89844 2.22 -1.3501 4.19922 2.23
             -1.3501 4.5 2.26 -1.3501 4.80078 2.28 -1.3501 5.09766 2.3 -1.3501 5.39844 2.33
             -1.3501 5.69922 2.37 -1.05029 -5.69922 1.85 -1.05029 -5.40234 1.86 -1.05029 -5.10156 1.87
             -1.05029 -4.80078 1.87 -1.05029 -4.5 1.86 -1.05029 -4.19922 1.85 -1.05029 -3.90234 1.82
             -1.05029 -3.60156 1.8 -1.05029 -3.30078 1.78 -1.05029 -3 1.77 -1.05029 -2.69922 1.76
             -1.05029 -2.40234 1.75 -1.05029 -2.10156 1.75 -1.05029 -1.80078 1.75 -1.05029 -1.5 1.76
             -1.05029 -1.19922 1.76 -1.05029 -0.902344 1.76 -1.05029 -0.601562 1.76 -1.05029 -0.300781 1.76
             -1.05029 0 1.77 -1.05029 0.300781 1.78 -1.05029 0.597656 1.82 -1.05029 0.898438 1.87
             -1.05029 1.19922 1.93 -1.05029 1.5 1.99 -1.05029 1.80078 2.07 -1.05029 2.09766 2.15
             -1.05029 2.39844 2.21 -1.05029 2.69922 2.26 -1.05029 3 2.26 -1.05029 3.30078 2.25
             -1.05029 3.59766 2.25 -1.05029 3.89844 2.25 -1.05029 4.19922 2.28 -1.05029 4.5 2.32
             -1.05029 4.80078 2.35 -1.05029 5.09766 2.38 -1.05029 5.39844 2.41 -1.05029 5.69922 2.44
             -0.75 -5.69922 1.86 -0.75 -5.40234 1.88 -0.75 -5.10156 1.9 -0.75 -4.80078 1.92
             -0.75 -4.5 1.92 -0.75 -4.19922 1.9 -0.75 -3.90234 1.87 -0.75 -3.60156 1.84
             -0.75 -3.30078 1.81 -0.75 -3 1.79 -0.75 -2.69922 1.77 -0.75 -2.40234 1.76
             -0.75 -2.10156 1.76 -0.75 -1.80078 1.76 -0.75 -1.5 1.77 -0.75 -1.19922 1.77
             -0.75 -0.902344 1.78 -0.75 -0.601562 1.77 -0.75 -0.300781 1.77 -0.75 0 1.78
             -0.75 0.300781 1.8 -0.75 0.597656 1.84 -0.75 0.898438 1.9 -0.75 1.19922 1.95
             -0.75 1.5 2.02 -0.75 1.80078 2.09 -0.75 2.09766 2.16 -0.75 2.39844 2.22
             -0.75 2.69922 2.26 -0.75 3 2.27 -0.75 3.30078 2.27 -0.75 3.59766 2.27
             -0.75 3.89844 2.29 -0.75 4.19922 2.34 -0.75 4.5 2.4 -0.75 4.80078 2.45
             -0.75 5.09766 2.49 -0.75 5.39844 2.51 -0.75 5.69922 2.52 -0.450195 -5.69922 1.88
             -0.450195 -5.40234 1.9 -0.450195 -5.10156 1.93 -0.450195 -4.80078 1.96 -0.450195 -4.5 1.96
             -0.450195 -4.19922 1.94 -0.450195 -3.90234 1.9 -0.450195 -3.60156 1.87 -0.450195 -3.30078 1.84
             -0.450195 -3 1.81 -0.450195 -2.69922 1.78 -0.450195 -2.40234 1.77 -0.450195 -2.10156 1.76
             -0.450195 -1.80078 1.77 -0.450195 -1.5 1.78 -0.450195 -1.19922 1.79 -0.450195 -0.902344 1.79
             -0.450195 -0.601562 1.79 -0.450195 -0.300781 1.79 -0.450195 0 1.8 -0.450195 0.300781 1.82
             -0.450195 0.597656 1.87 -0.450195 0.898438 1.93 -0.450195 1.19922 2 -0.450195 1.5 2.06
             -0.450195 1.80078 2.14 -0.450195 2.09766 2.21 -0.450195 2.39844 2.28 -0.450195 2.69922 2.32
             -0.450195 3 2.32 -0.450195 3.30078 2.32 -0.450195 3.59766 2.33 -0.450195 3.89844 2.35
             -0.450195 4.19922 2.41 -0.450195 4.5 2.49 -0.450195 4.80078 2.55 -0.450195 5.09766 2.59
             -0.450195 5.39844 2.6 -0.450195 5.69922 2.6 -0.149902 -5.69922 1.91 -0.149902 -5.40234 1.92
             -0.149902 -5.10156 1.96 -0.149902 -4.80078 1.98 -0.149902 -4.5 1.98 -0.149902 -4.19922 1.95
             -0.149902 -3.90234 1.91 -0.149902 -3.60156 1.87 -0.149902 -3.30078 1.84 -0.149902 -3 1.81
             -0.149902 -2.69922 1.79 -0.149902 -2.40234 1.78 -0.149902 -2.10156 1.77 -0.149902 -1.80078 1.78
             -0.149902 -1.5 1.79 -0.149902 -1.19922 1.8 -0.149902 -0.902344 1.81 -0.149902 -0.601562 1.81
             -0.149902 -0.300781 1.8 -0.149902 0 1.81 -0.149902 0.300781 1.84 -0.149902 0.597656 1.9
             -0.149902 0.898438 1.97 -0.149902 1.19922 2.05 -0.149902 1.5 2.14 -0.149902 1.80078 2.22
             -0.149902 2.09766 2.31 -0.149902 2.39844 2.38 -0.149902 2.69922 2.43 -0.149902 3 2.44
             -0.149902 3.30078 2.42 -0.149902 3.59766 2.42 -0.149902 3.89844 2.44 -0.149902 4.19922 2.51
             -0.149902 4.5 2.58 -0.149902 4.80078 2.65 -0.149902 5.09766 2.69 -0.149902 5.39844 2.69
             -0.149902 5.69922 2.68 0.149902 -5.69922 1.95 0.149902 -5.40234 1.95 0.149902 -5.10156 1.96
             0.149902 -4.80078 1.97 0.149902 -4.5 1.96 0.149902 -4.19922 1.93 0.149902 -3.90234 1.89
             0.149902 -3.60156 1.85 0.149902 -3.30078 1.82 0.149902 -3 1.8 0.149902 -2.69922 1.79
             0.149902 -2.40234 1.78 0.149902 -2.10156 1.78 0.149902 -1.80078 1.79 0.149902 -1.5 1.8
             0.149902 -1.19922 1.82 0.149902 -0.902344 1.83 0.149902 -0.601562 1.83 0.149902 -0.300781 1.83
             0.149902 0 1.84 0.149902 0.300781 1.87 0.149902 0.597656 1.94 0.149902 0.898438 2.02
             0.149902 1.19922 2.12 0.149902 1.5 2.21 0.149902 1.80078 2.32 0.149902 2.09766 2.42
             0.149902 2.39844 2.5 0.149902 2.69922 2.56 0.149902 3 2.56 0.149902 3.30078 2.54
             0.149902 3.59766 2.54 0.149902 3.89844 2.55 0.149902 4.19922 2.61 0.149902 4.5 2.68
             0.149902 4.80078 2.74 0.149902 5.09766 2.78 0.149902 5.39844 2.78 0.149902 5.69922 2.76
             0.449707 -5.69922 1.98 0.449707 -5.40234 1.96 0.449707 -5.10156 1.94 0.449707 -4.80078 1.91
             0.449707 -4.5 1.89 0.449707 -4.19922 1.86 0.449707 -3.90234 1.83 0.449707 -3.60156 1.81
             0.449707 -3.30078 1.79 0.449707 -3 1.79 0.449707 -2.69922 1.79 0.449707 -2.40234 1.79
             0.449707 -2.10156 1.79 0.449707 -1.80078 1.8 0.449707 -1.5 1.82 0.449707 -1.19922 1.84
             0.449707 -0.902344 1.85 0.449707 -0.601562 1.86 0.449707 -0.300781 1.87 0.449707 0 1.89
             0.449707 0.300781 1.92 0.449707 0.597656 1.99 0.449707 0.898438 2.08 0.449707 1.19922 2.17
             0.449707 1.5 2.27 0.449707 1.80078 2.39 0.449707 2.09766 2.51 0.449707 2.39844 2.61
             0.449707 2.69922 2.67 0.449707 3 2.68 0.449707 3.30078 2.66 0.449707 3.59766 2.65
             0.449707 3.89844 2.66 0.449707 4.19922 2.71 0.449707 4.5 2.77 0.449707 4.80078 2.83
             0.449707 5.09766 2.87 0.449707 5.39844 2.87 0.449707 5.69922 2.85 0.75 -5.69922 2.03
             0.75 -5.40234 1.98 0.75 -5.10156 1.93 0.75 -4.80078 1.89 0.75 -4.5 1.84
             0.75 -4.19922 1.82 0.75 -3.90234 1.8 0.75 -3.60156 1.8 0.75 -3.30078 1.8
             0.75 -3 1.8 0.75 -2.69922 1.78 0.75 -2.40234 1.79 0.75 -2.10156 1.8
             0.75 -1.80078 1.82 0.75 -1.5 1.84 0.75 -1.19922 1.86 0.75 -0.902344 1.88
             0.75 -0.601562 1.9 0.75 -0.300781 1.92 0.75 0 1.94 0.75 0.300781 1.98
             0.75 0.597656 2.05 0.75 0.898438 2.13 0.75 1.19922 2.21 0.75 1.5 2.31
             0.75 1.80078 2.43 0.75 2.09766 2.56 0.75 2.39844 2.66 0.75 2.69922 2.74
             0.75 3 2.76 0.75 3.30078 2.74 0.75 3.59766 2.74 0.75 3.89844 2.75
             0.75 4.19922 2.79 0.75 4.5 2.86 0.75 4.80078 2.91 0.75 5.09766 2.94
             0.75 5.39844 2.95 0.75 5.69922 2.93 1.0498 -5.69922 2.07 1.0498 -5.40234 2.02
             1.0498 -5.10156 1.95 1.0498 -4.80078 1.89 1.0498 -4.5 1.84 1.0498 -4.19922 1.81
             1.0498 -3.90234 1.8 1.0498 -3.60156 1.8 1.0498 -3.30078 1.8 1.0498 -3 1.8
             1.0498 -2.69922 1.79 1.0498 -2.40234 1.8 1.0498 -2.10156 1.82 1.0498 -1.80078 1.84
             1.0498 -1.5 1.86 1.0498 -1.19922 1.88 1.0498 -0.902344 1.91 1.0498 -0.601562 1.93
             1.0498 -0.300781 1.96 1.0498 0 1.99 1.0498 0.300781 2.03 1.0498 0.597656 2.09
             1.0498 0.898438 2.17 1.0498 1.19922 2.25 1.0498 1.5 2.34 1.0498 1.80078 2.45
             1.0498 2.09766 2.56 1.0498 2.39844 2.66 1.0498 2.69922 2.74 1.0498 3 2.77
             1.0498 3.30078 2.78 1.0498 3.59766 2.8 1.0498 3.89844 2.83 1.0498 4.19922 2.88
             1.0498 4.5 2.94 1.0498 4.80078 2.98 1.0498 5.09766 3.02 1.0498 5.39844 3.03
             1.0498 5.69922 3.02 1.3501 -5.69922 2.09 1.3501 -5.40234 2.03 1.3501 -5.10156 1.96
             1.3501 -4.80078 1.89 1.3501 -4.5 1.83 1.3501 -4.19922 1.8 1.3501 -3.90234 1.8
             1.3501 -3.60156 1.8 1.3501 -3.30078 1.8 1.3501 -3 1.8 1.3501 -2.69922 1.81
             1.3501 -2.40234 1.82 1.3501 -2.10156 1.83 1.3501 -1.80078 1.85 1.3501 -1.5 1.88
             1.3501 -1.19922 1.9 1.3501 -0.902344 1.92 1.3501 -0.601562 1.95 1.3501 -0.300781 1.98
             1.3501 0 2.02 1.3501 0.300781 2.06 1.3501 0.597656 2.12 1.3501 0.898438 2.2
             1.3501 1.19922 2.28 1.3501 1.5 2.37 1.3501 1.80078 2.46 1.3501 2.09766 2.55
             1.3501 2.39844 2.64 1.3501 2.69922 2.72 1.3501 3 2.77 1.3501 3.30078 2.81
             1.3501 3.59766 2.86 1.3501 3.89844 2.91 1.3501 4.19922 2.96 1.3501 4.5 3.01
             1.3501 4.80078 3.05 1.3501 5.09766 3.09 1.3501 5.39844 3.1 1.3501 5.69922 3.1
             1.6499 -5.69922 2.07 1.6499 -5.40234 2.01 1.6499 -5.10156 1.94 1.6499 -4.80078 1.87
             1.6499 -4.5 1.8 1.6499 -4.19922 1.8 1.6499 -3.90234 1.8 1.6499 -3.60156 1.8
             1.6499 -3.30078 1.8 1.6499 -3 1.81 1.6499 -2.69922 1.82 1.6499 -2.40234 1.83
             1.6499 -2.10156 1.84 1.6499 -1.80078 1.86 1.6499 -1.5 1.89 1.6499 -1.19922 1.91
             1.6499 -0.902344 1.93 1.6499 -0.601562 1.96 1.6499 -0.300781 1.99 1.6499 0 2.03
             1.6499 0.300781 2.08 1.6499 0.597656 2.15 1.6499 0.898438 2.24 1.6499 1.19922 2.32
             1.6499 1.5 2.41 1.6499 1.80078 2.5 1.6499 2.09766 2.6 1.6499 2.39844 2.69
             1.6499 2.69922 2.78 1.6499 3 2.83 1.6499 3.30078 2.88 1.6499 3.59766 2.92
             1.6499 3.89844 2.97 1.6499 4.19922 3.02 1.6499 4.5 3.07 1.6499 4.80078 3.12
             1.6499 5.09766 3.15 1.6499 5.39844 3.17 1.6499 5.69922 3.17 1.94971 -5.69922 2.03
             1.94971 -5.40234 1.97 1.94971 -5.10156 1.9 1.94971 -4.80078 1.83 1.94971 -4.5 1.8
             1.94971 -4.19922 1.8 1.94971 -3.90234 1.8 1.94971 -3.60156 1.8 1.94971 -3.30078 1.8
             1.94971 -3 1.82 1.94971 -2.69922 1.83 1.94971 -2.40234 1.85 1.94971 -2.10156 1.86
             1.94971 -1.80078 1.88 1.94971 -1.5 1.9 1.94971 -1.19922 1.92 1.94971 -0.902344 1.94
             1.94971 -0.601562 1.97 1.94971 -0.300781 2.01 1.94971 0 2.05 1.94971 0.300781 2.1
             1.94971 0.597656 2.18 1.94971 0.898438 2.27 1.94971 1.19922 2.36 1.94971 1.5 2.45
             1.94971 1.80078 2.56 1.94971 2.09766 2.67 1.94971 2.39844 2.77 1.94971 2.69922 2.86
             1.94971 3 2.91 1.94971 3.30078 2.94 1.94971 3.59766 2.97 1.94971 3.89844 3.01
             1.94971 4.19922 3.06 1.94971 4.5 3.12 1.94971 4.80078 3.18 1.94971 5.09766 3.22
             1.94971 5.39844 3.24 1.94971 5.69922 3.24 2.25 -5.69922 1.96 2.25 -5.40234 1.91
             2.25 -5.10156 1.85 2.25 -4.80078 1.8 2.25 -4.5 1.8 2.25 -4.19922 1.8
             2.25 -3.90234 1.8 2.25 -3.60156 1.8 2.25 -3.30078 1.8 2.25 -3 1.82
             2.25 -2.69922 1.84 2.25 -2.40234 1.86 2.25 -2.10156 1.88 2.25 -1.80078 1.9
             2.25 -1.5 1.91 2.25 -1.19922 1.93 2.25 -0.902344 1.95 2.25 -0.601562 1.98
             2.25 -0.300781 2.02 2.25 0 2.07 2.25 0.300781 2.12 2.25 0.597656 2.2
             2.25 0.898438 2.3 2.25 1.19922 2.39 2.25 1.5 2.49 2.25 1.80078 2.61
             2.25 2.09766 2.73 2.25 2.39844 2.84 2.25 2.69922 2.93 2.25 3 2.97
             2.25 3.30078 2.98 2.25 3.59766 3 2.25 3.89844 3.03 2.25 4.19922 3.09
             2.25 4.5 3.17 2.25 4.80078 3.24 2.25 5.09766 3.3 2.25 5.39844 3.32
             2.25 5.69922 3.32 2.5498 -5.69922 1.88 2.5498 -5.40234 1.85 2.5498 -5.10156 1.8
             2.5498 -4.80078 1.8 2.5498 -4.5 1.8 2.5498 -4.19922 1.8 2.5498 -3.90234 1.8
             2.5498 -3.60156 1.8 2.5498 -3.30078 1.8 2.5498 -3 1.82 2.5498 -2.69922 1.85
             2.5498 -2.40234 1.88 2.5498 -2.10156 1.9 2.5498 -1.80078 1.92 2.5498 -1.5 1.93
             2.5498 -1.19922 1.94 2.5498 -0.902344 1.96 2.5498 -0.601562 1.99 2.5498 -0.300781 2.04
             2.5498 0 2.08 2.5498 0.300781 2.14 2.5498 0.597656 2.23 2.5498 0.898438 2.33
             2.5498 1.19922 2.43 2.5498 1.5 2.54 2.5498 1.80078 2.67 2.5498 2.09766 2.79
             2.5498 2.39844 2.91 2.5498 2.69922 3 2.5498 3 3.04 2.5498 3.30078 3.04
             2.5498 3.59766 3.05 2.5498 3.89844 3.08 2.5498 4.19922 3.15 2.5498 4.5 3.24
             2.5498 4.80078 3.32 2.5498 5.09766 3.38 2.5498 5.39844 3.4 2.5498 5.69922 3.4
             2.8501 -5.69922 1.83 2.8501 -5.40234 1.8 2.8501 -5.10156 1.8 2.8501 -4.80078 1.8
             2.8501 -4.5 1.8 2.8501 -4.19922 1.8 2.8501 -3.90234 1.8 2.8501 -3.60156 1.8
             2.8501 -3.30078 1.8 2.8501 -3 1.8 2.8501 -2.69922 1.86 2.8501 -2.40234 1.89
             2.8501 -2.10156 1.92 2.8501 -1.80078 1.94 2.8501 -1.5 1.95 2.8501 -1.19922 1.96
             2.8501 -0.902344 1.98 2.8501 -0.601562 2.01 2.8501 -0.300781 2.06 2.8501 0 2.11
             2.8501 0.300781 2.17 2.8501 0.597656 2.26 2.8501 0.898438 2.37 2.8501 1.19922 2.48
             2.8501 1.5 2.6 2.8501 1.80078 2.73 2.8501 2.09766 2.86 2.8501 2.39844 2.97
             2.8501 2.69922 3.06 2.8501 3 3.09 2.8501 3.30078 3.09 2.8501 3.59766 3.1
             2.8501 3.89844 3.13 2.8501 4.19922 3.21 2.8501 4.5 3.31 2.8501 4.80078 3.41
)"
        R"(             2.8501 5.09766 3.48 2.8501 5.39844 3.5 2.8501 5.69922 3.48 3.1499 -5.69922 1.8
             3.1499 -5.40234 1.78 3.1499 -5.10156 1.8 3.1499 -4.80078 1.8 3.1499 -4.5 1.8
             3.1499 -4.19922 1.8 3.1499 -3.90234 1.8 3.1499 -3.60156 1.8 3.1499 -3.30078 1.8
             3.1499 -3 1.84 3.1499 -2.69922 1.88 3.1499 -2.40234 1.91 3.1499 -2.10156 1.94
             3.1499 -1.80078 1.96 3.1499 -1.5 1.97 3.1499 -1.19922 1.99 3.1499 -0.902344 2.01
             3.1499 -0.601562 2.05 3.1499 -0.300781 2.1 3.1499 0 2.16 3.1499 0.300781 2.23
             3.1499 0.597656 2.32 3.1499 0.898438 2.44 3.1499 1.19922 2.56 3.1499 1.5 2.68
             3.1499 1.80078 2.8 3.1499 2.09766 2.92 3.1499 2.39844 3.02 3.1499 2.69922 3.11
             3.1499 3 3.13 3.1499 3.30078 3.12 3.1499 3.59766 3.12 3.1499 3.89844 3.15
             3.1499 4.19922 3.24 3.1499 4.5 3.37 3.1499 4.80078 3.48 3.1499 5.09766 3.57
             3.1499 5.39844 3.58 3.1499 5.69922 3.56 3.44971 -5.69922 1.81 3.44971 -5.40234 1.78
             3.44971 -5.10156 1.8 3.44971 -4.80078 1.8 3.44971 -4.5 1.8 3.44971 -4.19922 1.8
             3.44971 -3.90234 1.8 3.44971 -3.60156 1.8 3.44971 -3.30078 1.8 3.44971 -3 1.87
             3.44971 -2.69922 1.9 3.44971 -2.40234 1.94 3.44971 -2.10156 1.97 3.44971 -1.80078 1.99
             3.44971 -1.5 2 3.44971 -1.19922 2.02 3.44971 -0.902344 2.05 3.44971 -0.601562 2.1
             3.44971 -0.300781 2.16 3.44971 0 2.23 3.44971 0.300781 2.31 3.44971 0.597656 2.41
             3.44971 0.898438 2.54 3.44971 1.19922 2.66 3.44971 1.5 2.78 3.44971 1.80078 2.89
             3.44971 2.09766 2.99 3.44971 2.39844 3.08 3.44971 2.69922 3.16 3.44971 3 3.18
             3.44971 3.30078 3.17 3.44971 3.59766 3.18 3.44971 3.89844 3.21 3.44971 4.19922 3.3
             3.44971 4.5 3.43 3.44971 4.80078 3.54 3.44971 5.09766 3.63 3.44971 5.39844 3.64
             3.44971 5.69922 3.6 3.75 -5.69922 1.82 3.75 -5.40234 1.79 3.75 -5.10156 1.8
             3.75 -4.80078 1.8 3.75 -4.5 1.8 3.75 -4.19922 1.8 3.75 -3.90234 1.8
             3.75 -3.60156 1.8 3.75 -3.30078 1.87 3.75 -3 1.9 3.75 -2.69922 1.93
             3.75 -2.40234 1.96 3.75 -2.10156 2 3.75 -1.80078 2.02 3.75 -1.5 2.04
             3.75 -1.19922 2.07 3.75 -0.902344 2.1 3.75 -0.601562 2.16 3.75 -0.300781 2.23
             3.75 0 2.31 3.75 0.300781 2.39 3.75 0.597656 2.5 3.75 0.898438 2.63
             3.75 1.19922 2.75 3.75 1.5 2.87 3.75 1.80078 2.98 3.75 2.09766 3.08
             3.75 2.39844 3.16 3.75 2.69922 3.23 3.75 3 3.26 3.75 3.30078 3.25
             3.75 3.59766 3.26 3.75 3.89844 3.29 3.75 4.19922 3.38 3.75 4.5 3.49
             3.75 4.80078 3.59 3.75 5.09766 3.67 3.75 5.39844 3.67 3.75 5.69922 3.64
             4.0498 -5.69922 1.81 4.0498 -5.40234 1.8 4.0498 -5.10156 1.8 4.0498 -4.80078 1.8
             4.0498 -4.5 1.8 4.0498 -4.19922 1.8 4.0498 -3.90234 1.8 4.0498 -3.60156 1.8
             4.0498 -3.30078 1.91 4.0498 -3 1.94 4.0498 -2.69922 1.96 4.0498 -2.40234 1.99
             4.0498 -2.10156 2.02 4.0498 -1.80078 2.05 4.0498 -1.5 2.08 4.0498 -1.19922 2.12
             4.0498 -0.902344 2.16 4.0498 -0.601562 2.22 4.0498 -0.300781 2.29 4.0498 0 2.36
             4.0498 0.300781 2.44 4.0498 0.597656 2.56 4.0498 0.898438 2.69 4.0498 1.19922 2.81
             4.0498 1.5 2.94 4.0498 1.80078 3.06 4.0498 2.09766 3.17 4.0498 2.39844 3.27
             4.0498 2.69922 3.35 4.0498 3 3.37 4.0498 3.30078 3.36 4.0498 3.59766 3.36
             4.0498 3.89844 3.38 4.0498 4.19922 3.45 4.0498 4.5 3.55 4.0498 4.80078 3.64
             4.0498 5.09766 3.71 4.0498 5.39844 3.71 4.0498 5.69922 3.69 4.3501 -5.69922 1.78
             4.3501 -5.40234 1.78 4.3501 -5.10156 1.8 4.3501 -4.80078 1.8 4.3501 -4.5 1.8
             4.3501 -4.19922 1.8 4.3501 -3.90234 1.8 4.3501 -3.60156 1.9 4.3501 -3.30078 1.94
             4.3501 -3 1.98 4.3501 -2.69922 2.01 4.3501 -2.40234 2.04 4.3501 -2.10156 2.08
             4.3501 -1.80078 2.11 4.3501 -1.5 2.15 4.3501 -1.19922 2.18 4.3501 -0.902344 2.23
             4.3501 -0.601562 2.28 4.3501 -0.300781 2.33 4.3501 0 2.38 4.3501 0.300781 2.46
             4.3501 0.597656 2.57 4.3501 0.898438 2.7 4.3501 1.19922 2.83 4.3501 1.5 2.97
             4.3501 1.80078 3.1 4.3501 2.09766 3.23 4.3501 2.39844 3.36 4.3501 2.69922 3.45
             4.3501 3 3.48 4.3501 3.30078 3.46 4.3501 3.59766 3.46 4.3501 3.89844 3.47
             4.3501 4.19922 3.53 4.3501 4.5 3.62 4.3501 4.80078 3.7 4.3501 5.09766 3.76
             4.3501 5.39844 3.77 4.3501 5.69922 3.75 4.6499 -5.69922 1.73 4.6499 -5.40234 1.75
             4.6499 -5.10156 1.75 4.6499 -4.80078 1.8 4.6499 -4.5 1.8 4.6499 -4.19922 1.8
             4.6499 -3.90234 1.86 4.6499 -3.60156 1.9 4.6499 -3.30078 1.95 4.6499 -3 2
             4.6499 -2.69922 2.06 4.6499 -2.40234 2.11 4.6499 -2.10156 2.17 4.6499 -1.80078 2.21
             4.6499 -1.5 2.24 4.6499 -1.19922 2.28 4.6499 -0.902344 2.32 4.6499 -0.601562 2.34
             4.6499 -0.300781 2.37 4.6499 0 2.4 4.6499 0.300781 2.45 4.6499 0.597656 2.55
             4.6499 0.898438 2.68 4.6499 1.19922 2.81 4.6499 1.5 2.94 4.6499 1.80078 3.09
             4.6499 2.09766 3.23 4.6499 2.39844 3.37 4.6499 2.69922 3.49 4.6499 3 3.52
             4.6499 3.30078 3.52 4.6499 3.59766 3.52 4.6499 3.89844 3.54 4.6499 4.19922 3.6
             4.6499 4.5 3.69 4.6499 4.80078 3.76 4.6499 5.09766 3.83 4.6499 5.39844 3.84
             4.6499 5.69922 3.83 4.94971 -5.69922 1.7 4.94971 -5.40234 1.71 4.94971 -5.10156 1.72
             4.94971 -4.80078 1.74 4.94971 -4.5 1.76 4.94971 -4.19922 1.79 4.94971 -3.90234 1.84
             4.94971 -3.60156 1.89 4.94971 -3.30078 1.94 4.94971 -3 2 4.94971 -2.69922 2.08
             4.94971 -2.40234 2.15 4.94971 -2.10156 2.23 4.94971 -1.80078 2.28 4.94971 -1.5 2.33
             4.94971 -1.19922 2.38 4.94971 -0.902344 2.42 4.94971 -0.601562 2.43 4.94971 -0.300781 2.43
             4.94971 0 2.43 4.94971 0.300781 2.45 4.94971 0.597656 2.54 4.94971 0.898438 2.65
             4.94971 1.19922 2.77 4.94971 1.5 2.89 4.94971 1.80078 3.03 4.94971 2.09766 3.18
             4.94971 2.39844 3.32 4.94971 2.69922 3.45 4.94971 3 3.5 4.94971 3.30078 3.52
             4.94971 3.59766 3.54 4.94971 3.89844 3.58 4.94971 4.19922 3.65 4.94971 4.5 3.75
             4.94971 4.80078 3.84 4.94971 5.09766 3.91 4.94971 5.39844 3.94 4.94971 5.69922 3.93
             5.25 -5.40234 1.69 5.25 -5.10156 1.7 5.25 -4.80078 1.71 5.25 -4.5 1.73
             5.25 -4.19922 1.76 5.25 -3.90234 1.8 5.25 -3.60156 1.85 5.25 -3.30078 1.9
             5.25 -3 1.97 5.25 -2.69922 2.05 5.25 -2.40234 2.14 5.25 -2.10156 2.22
             5.25 -1.80078 2.31 5.25 -1.5 2.38 5.25 -1.19922 2.46 5.25 -0.902344 2.52
             5.25 -0.601562 2.54 5.25 -0.300781 2.52 5.25 0 2.52 5.25 0.300781 2.53
             5.25 0.597656 2.59 5.25 0.898438 2.69 5.25 1.19922 2.79 5.25 1.5 2.89
             5.25 1.80078 3.01 5.25 2.09766 3.14 5.25 2.39844 3.26 5.25 2.69922 3.37
             5.25 3 3.44 5.25 3.30078 3.49 5.25 3.59766 3.55 5.25 3.89844 3.61
             5.25 4.19922 3.7 5.25 4.5 3.81 5.25 4.80078 3.92 5.25 5.09766 4
             5.25 5.39844 4.04 5.25 5.69922 4.04 5.25 6 4.05 5.5498 -5.40234 1.69
             5.5498 -5.10156 1.7 5.5498 -4.80078 1.71 5.5498 -4.5 1.72 5.5498 -4.19922 1.74
             5.5498 -3.90234 1.76 5.5498 -3.60156 1.79 5.5498 -3.30078 1.82 5.5498 -3 1.9
             5.5498 -2.69922 2 5.5498 -2.40234 2.1 5.5498 -2.10156 2.2 5.5498 -1.80078 2.31
             5.5498 -1.5 2.42 5.5498 -1.19922 2.52 5.5498 -0.902344 2.62 5.5498 -0.601562 2.65
             5.5498 -0.300781 2.66 5.5498 0 2.67 5.5498 0.300781 2.69 5.5498 0.597656 2.74
             5.5498 0.898438 2.82 5.5498 1.19922 2.9 5.5498 1.5 2.99 5.5498 1.80078 3.07
             5.5498 2.09766 3.16 5.5498 2.39844 3.24 5.5498 2.69922 3.31 5.5498 3 3.4
             5.5498 3.30078 3.48 5.5498 3.59766 3.57 5.5498 3.89844 3.66 5.5498 4.19922 3.77
             5.5498 4.5 3.88 5.5498 4.80078 3.99 5.5498 5.09766 4.09 5.5498 5.39844 4.13
             5.5498 5.69922 4.14 5.5498 6 4.16
          }
          Array id=804 vsg::vec4Array
          {
            userObjects 0
            Layout 0 16 0 1 1 1 0 -1
            size 1
            storage id=0
            data 1 1 1 1
          }
          Array id=805 vsg::vec2Array
          {
            userObjects 0
            Layout 0 8 0 1 1 1 0 -1
            size 1482
            storage id=0
            data 0.1121 0.0171 0.1094 0.0411 0.1066 0.0654 0.1038 0.0898 0.101 0.1141 0.0982 0.1384
             0.0954 0.1624 0.0926 0.1868 0.0898 0.2111 0.087 0.2354 0.0842 0.2598 0.0815 0.2838
             0.0787 0.3081 0.0759 0.3325 0.0731 0.3568 0.0703 0.3811 0.0675 0.4052 0.0647 0.4295
             0.0619 0.4538 0.0591 0.4782 0.0564 0.5025 0.0536 0.5265 0.0508 0.5508 0.048 0.5752
             0.0452 0.5995 0.0424 0.6239 0.0397 0.6479 0.0369 0.6722 0.0341 0.6965 0.0313 0.7209
             0.0285 0.7452 0.0257 0.7692 0.0229 0.7936 0.0201 0.8179 0.0173 0.8422 0.0145 0.8666
             0.0118 0.8906 0.009 0.9149 0.0062 0.9393 0.1364 0.0199 0.1336 0.0439 0.1309 0.0682
             0.1281 0.0925 0.1253 0.1169 0.1225 0.1412 0.1197 0.1652 0.1169 0.1896 0.1141 0.2139
             0.1113 0.2382 0.1085 0.2626 0.1058 0.2866 0.103 0.3109 0.1002 0.3353 0.0974 0.3596
             0.0946 0.3839 0.0918 0.4079 0.089 0.4323 0.0862 0.4566 0.0834 0.481 0.0806 0.5053
             0.0779 0.5293 0.0751 0.5536 0.0723 0.578 0.0695 0.6023 0.0667 0.6266 0.064 0.6507
             0.0612 0.675 0.0584 0.6993 0.0556 0.7237 0.0528 0.748 0.05 0.772 0.0472 0.7964
             0.0444 0.8207 0.0416 0.845 0.0388 0.8694 0.0361 0.8934 0.0333 0.9177 0.0305 0.942
             0.1607 0.0226 0.1579 0.0467 0.1551 0.071 0.1523 0.0953 0.1495 0.1197 0.1467 0.144
             0.144 0.168 0.1412 0.1924 0.1384 0.2167 0.1356 0.241 0.1328 0.2654 0.13 0.2894
             0.1272 0.3137 0.1244 0.338 0.1216 0.3624 0.1188 0.3867 0.1161 0.4107 0.1133 0.4351
             0.1105 0.4594 0.1077 0.4837 0.1049 0.5081 0.1021 0.5321 0.0994 0.5564 0.0966 0.5808
             0.0938 0.6051 0.091 0.6294 0.0882 0.6534 0.0854 0.6778 0.0826 0.7021 0.0798 0.7265
             0.077 0.7508 0.0743 0.7748 0.0715 0.7991 0.0687 0.8235 0.0659 0.8478 0.0631 0.8721
             0.0603 0.8962 0.0575 0.9205 0.0547 0.9448 0.185 0.0254 0.1822 0.0495 0.1794 0.0738
             0.1766 0.0981 0.1738 0.1225 0.171 0.1468 0.1683 0.1708 0.1655 0.1951 0.1627 0.2195
             0.1599 0.2438 0.1571 0.2681 0.1543 0.2922 0.1515 0.3165 0.1487 0.3408 0.1459 0.3652
             0.1431 0.3895 0.1404 0.4135 0.1376 0.4379 0.1348 0.4622 0.132 0.4865 0.1292 0.5109
             0.1264 0.5349 0.1236 0.5592 0.1209 0.5835 0.1181 0.6079 0.1153 0.6322 0.1125 0.6562
             0.1097 0.6806 0.1069 0.7049 0.1041 0.7292 0.1013 0.7536 0.0986 0.7776 0.0958 0.8019
             0.093 0.8263 0.0902 0.8506 0.0874 0.8749 0.0846 0.899 0.0818 0.9233 0.079 0.9476
             0.2092 0.0282 0.2065 0.0522 0.2037 0.0766 0.2009 0.1009 0.1981 0.1252 0.1953 0.1496
             0.1925 0.1736 0.1897 0.1979 0.1869 0.2223 0.1841 0.2466 0.1813 0.2709 0.1786 0.295
             0.1758 0.3193 0.173 0.3436 0.1702 0.368 0.1674 0.3923 0.1646 0.4163 0.1618 0.4406
             0.159 0.465 0.1563 0.4893 0.1535 0.5136 0.1507 0.5377 0.1479 0.562 0.1451 0.5863
             0.1423 0.6107 0.1395 0.635 0.1368 0.659 0.134 0.6834 0.1312 0.7077 0.1284 0.732
             0.1256 0.7564 0.1228 0.7804 0.12 0.8047 0.1172 0.829 0.1144 0.8534 0.1116 0.8777
             0.1089 0.9017 0.1061 0.9261 0.1033 0.9504 0.2335 0.031 0.2307 0.055 0.2279 0.0794
             0.2251 0.1037 0.2223 0.128 0.2195 0.1524 0.2168 0.1764 0.214 0.2007 0.2112 0.2251
             0.2084 0.2494 0.2056 0.2737 0.2028 0.2977 0.2 0.3221 0.1972 0.3464 0.1944 0.3707
             0.1916 0.3951 0.1889 0.4191 0.1861 0.4434 0.1833 0.4678 0.1805 0.4921 0.1777 0.5164
             0.175 0.5405 0.1722 0.5648 0.1694 0.5891 0.1666 0.6135 0.1638 0.6378 0.161 0.6618
             0.1582 0.6861 0.1554 0.7105 0.1526 0.7348 0.1498 0.7591 0.1471 0.7832 0.1443 0.8075
             0.1415 0.8318 0.1387 0.8562 0.1359 0.8805 0.1331 0.9045 0.1303 0.9289 0.1275 0.9532
             0.2578 0.0338 0.255 0.0578 0.2522 0.0822 0.2494 0.1065 0.2466 0.1308 0.2438 0.1552
             0.2411 0.1792 0.2383 0.2035 0.2355 0.2278 0.2327 0.2522 0.2299 0.2765 0.2271 0.3005
             0.2243 0.3249 0.2215 0.3492 0.2187 0.3735 0.2159 0.3979 0.2132 0.4219 0.2104 0.4462
             0.2076 0.4706 0.2048 0.4949 0.202 0.5192 0.1992 0.5432 0.1965 0.5676 0.1937 0.5919
             0.1909 0.6162 0.1881 0.6406 0.1853 0.6646 0.1825 0.6889 0.1797 0.7133 0.1769 0.7376
             0.1741 0.7619 0.1714 0.786 0.1686 0.8103 0.1658 0.8346 0.163 0.859 0.1602 0.8833
             0.1574 0.9073 0.1546 0.9316 0.1518 0.956 0.282 0.0366 0.2793 0.0606 0.2765 0.0849
             0.2737 0.1093 0.2709 0.1336 0.2681 0.1579 0.2653 0.182 0.2625 0.2063 0.2597 0.2306
             0.2569 0.255 0.2541 0.2793 0.2514 0.3033 0.2486 0.3277 0.2458 0.352 0.243 0.3763
             0.2402 0.4007 0.2374 0.4247 0.2346 0.449 0.2319 0.4733 0.2291 0.4977 0.2263 0.522
             0.2235 0.546 0.2207 0.5704 0.2179 0.5947 0.2151 0.619 0.2123 0.6434 0.2096 0.6674
             0.2068 0.6917 0.204 0.7161 0.2012 0.7404 0.1984 0.7647 0.1956 0.7887 0.1928 0.8131
             0.19 0.8374 0.1872 0.8617 0.1844 0.8861 0.1817 0.9101 0.1789 0.9344 0.1761 0.9588
             0.3063 0.0394 0.3036 0.0634 0.3008 0.0877 0.298 0.1121 0.2952 0.1364 0.2924 0.1607
             0.2896 0.1848 0.2868 0.2091 0.284 0.2334 0.2812 0.2578 0.2784 0.2821 0.2757 0.3061
             0.2729 0.3304 0.2701 0.3548 0.2673 0.3791 0.2645 0.4034 0.2617 0.4275 0.2589 0.4518
             0.2561 0.4761 0.2534 0.5005 0.2506 0.5248 0.2478 0.5488 0.245 0.5732 0.2422 0.5975
             0.2394 0.6218 0.2366 0.6462 0.2339 0.6702 0.2311 0.6945 0.2283 0.7188 0.2255 0.7432
             0.2227 0.7675 0.2199 0.7915 0.2171 0.8159 0.2143 0.8402 0.2115 0.8645 0.2087 0.8889
             0.206 0.9129 0.2032 0.9372 0.2004 0.9616 0.3306 0.0422 0.3278 0.0662 0.325 0.0905
             0.3222 0.1148 0.3194 0.1392 0.3166 0.1635 0.3139 0.1875 0.3111 0.2119 0.3083 0.2362
             0.3055 0.2605 0.3027 0.2849 0.2999 0.3089 0.2971 0.3332 0.2943 0.3576 0.2915 0.3819
             0.2888 0.4062 0.286 0.4302 0.2832 0.4546 0.2804 0.4789 0.2776 0.5033 0.2748 0.5276
             0.2721 0.5516 0.2693 0.5759 0.2665 0.6003 0.2637 0.6246 0.2609 0.6489 0.2581 0.673
             0.2553 0.6973 0.2525 0.7216 0.2497 0.746 0.2469 0.7703 0.2442 0.7943 0.2414 0.8187
             0.2386 0.843 0.2358 0.8673 0.233 0.8917 0.2302 0.9157 0.2274 0.94 0.2246 0.9643
             0.3548 0.0449 0.3521 0.069 0.3493 0.0933 0.3465 0.1176 0.3437 0.142 0.3409 0.1663
             0.3381 0.1903 0.3353 0.2147 0.3325 0.239 0.3297 0.2633 0.3269 0.2877 0.3242 0.3117
             0.3214 0.336 0.3186 0.3603 0.3158 0.3847 0.313 0.409 0.3102 0.433 0.3075 0.4574
             0.3047 0.4817 0.3019 0.506 0.2991 0.5304 0.2963 0.5544 0.2935 0.5787 0.2907 0.6031
             0.2879 0.6274 0.2851 0.6517 0.2824 0.6757 0.2796 0.7001 0.2768 0.7244 0.274 0.7488
             0.2712 0.7731 0.2684 0.7971 0.2656 0.8214 0.2628 0.8458 0.26 0.8701 0.2573 0.8944
             0.2545 0.9185 0.2517 0.9428 0.2489 0.9671 0.3791 0.0477 0.3764 0.0718 0.3736 0.0961
             0.3708 0.1204 0.368 0.1448 0.3652 0.1691 0.3624 0.1931 0.3596 0.2174 0.3568 0.2418
             0.354 0.2661 0.3512 0.2905 0.3485 0.3145 0.3457 0.3388 0.3429 0.3631 0.3401 0.3875
             0.3373 0.4118 0.3345 0.4358 0.3317 0.4602 0.329 0.4845 0.3262 0.5088 0.3234 0.5332
             0.3206 0.5572 0.3178 0.5815 0.315 0.6059 0.3122 0.6302 0.3094 0.6545 0.3067 0.6785
             0.3039 0.7029 0.3011 0.7272 0.2983 0.7515 0.2955 0.7759 0.2927 0.7999 0.2899 0.8242
             0.2871 0.8486 0.2843 0.8729 0.2815 0.8972 0.2788 0.9213 0.276 0.9456 0.2732 0.9699
             0.4034 0.0505 0.4006 0.0745 0.3978 0.0989 0.395 0.1232 0.3922 0.1475 0.3894 0.1719
             0.3867 0.1959 0.3839 0.2202 0.3811 0.2446 0.3783 0.2689 0.3755 0.2932 0.3727 0.3173
             0.3699 0.3416 0.3671 0.3659 0.3644 0.3903 0.3616 0.4146 0.3588 0.4386 0.356 0.4629
             0.3532 0.4873 0.3504 0.5116 0.3476 0.5359 0.3449 0.56 0.3421 0.5843 0.3393 0.6086
             0.3365 0.633 0.3337 0.6573 0.3309 0.6813 0.3281 0.7057 0.3253 0.73 0.3225 0.7543
)"
        R"(             0.3197 0.7787 0.317 0.8027 0.3142 0.827 0.3114 0.8513 0.3086 0.8757 0.3058 0.9
             0.303 0.924 0.3002 0.9484 0.2975 0.9727 0.4277 0.0533 0.4249 0.0773 0.4221 0.1017
             0.4193 0.126 0.4165 0.1503 0.4137 0.1747 0.411 0.1987 0.4082 0.223 0.4054 0.2474
             0.4026 0.2717 0.3998 0.296 0.397 0.32 0.3942 0.3444 0.3914 0.3687 0.3886 0.393
             0.3859 0.4174 0.3831 0.4414 0.3803 0.4657 0.3775 0.4901 0.3747 0.5144 0.3719 0.5387
             0.3692 0.5628 0.3664 0.5871 0.3636 0.6114 0.3608 0.6358 0.358 0.6601 0.3552 0.6841
             0.3524 0.7084 0.3496 0.7328 0.3468 0.7571 0.344 0.7815 0.3413 0.8055 0.3385 0.8298
             0.3357 0.8541 0.3329 0.8785 0.3301 0.9028 0.3273 0.9268 0.3245 0.9512 0.3217 0.9755
             0.4519 0.0561 0.4492 0.0801 0.4464 0.1045 0.4436 0.1288 0.4408 0.1531 0.438 0.1775
             0.4352 0.2015 0.4324 0.2258 0.4296 0.2501 0.4268 0.2745 0.424 0.2988 0.4213 0.3228
             0.4185 0.3472 0.4157 0.3715 0.4129 0.3958 0.4101 0.4202 0.4073 0.4442 0.4046 0.4685
             0.4018 0.4929 0.399 0.5172 0.3962 0.5415 0.3934 0.5655 0.3906 0.5899 0.3878 0.6142
             0.385 0.6385 0.3822 0.6629 0.3795 0.6869 0.3767 0.7112 0.3739 0.7356 0.3711 0.7599
             0.3683 0.7842 0.3655 0.8083 0.3627 0.8326 0.3599 0.8569 0.3571 0.8813 0.3544 0.9056
             0.3516 0.9296 0.3488 0.9539 0.346 0.9783 0.4762 0.0589 0.4734 0.0829 0.4706 0.1072
             0.4678 0.1316 0.465 0.1559 0.4622 0.1802 0.4595 0.2043 0.4567 0.2286 0.4539 0.2529
             0.4511 0.2773 0.4483 0.3016 0.4455 0.3256 0.4427 0.35 0.44 0.3743 0.4372 0.3986
             0.4344 0.423 0.4316 0.447 0.4288 0.4713 0.426 0.4956 0.4232 0.52 0.4204 0.5443
             0.4177 0.5683 0.4149 0.5927 0.4121 0.617 0.4093 0.6413 0.4065 0.6657 0.4037 0.6897
             0.4009 0.714 0.3981 0.7384 0.3953 0.7627 0.3925 0.787 0.3898 0.811 0.387 0.8354
             0.3842 0.8597 0.3814 0.884 0.3786 0.9084 0.3758 0.9324 0.3731 0.9567 0.3703 0.9811
             0.5005 0.0617 0.4977 0.0857 0.4949 0.11 0.4921 0.1344 0.4893 0.1587 0.4865 0.183
             0.4838 0.2071 0.481 0.2314 0.4782 0.2557 0.4754 0.2801 0.4726 0.3044 0.4698 0.3284
             0.467 0.3527 0.4642 0.3771 0.4615 0.4014 0.4587 0.4257 0.4559 0.4498 0.4531 0.4741
             0.4503 0.4984 0.4475 0.5228 0.4447 0.5471 0.442 0.5711 0.4392 0.5955 0.4364 0.6198
             0.4336 0.6441 0.4308 0.6685 0.428 0.6925 0.4252 0.7168 0.4224 0.7411 0.4196 0.7655
             0.4168 0.7898 0.4141 0.8138 0.4113 0.8382 0.4085 0.8625 0.4057 0.8868 0.4029 0.9112
             0.4001 0.9352 0.3973 0.9595 0.3946 0.9839 0.5247 0.0645 0.522 0.0885 0.5192 0.1128
             0.5164 0.1371 0.5136 0.1615 0.5108 0.1858 0.508 0.2098 0.5052 0.2342 0.5024 0.2585
             0.4996 0.2828 0.4969 0.3072 0.4941 0.3312 0.4913 0.3555 0.4885 0.3799 0.4857 0.4042
             0.4829 0.4285 0.4802 0.4526 0.4774 0.4769 0.4746 0.5012 0.4718 0.5256 0.469 0.5499
             0.4662 0.5739 0.4634 0.5982 0.4606 0.6226 0.4578 0.6469 0.455 0.6712 0.4523 0.6953
             0.4495 0.7196 0.4467 0.7439 0.4439 0.7683 0.4411 0.7926 0.4383 0.8166 0.4355 0.841
             0.4327 0.8653 0.43 0.8896 0.4272 0.914 0.4244 0.938 0.4216 0.9623 0.4188 0.9866
             0.549 0.0673 0.5463 0.0913 0.5435 0.1156 0.5407 0.1399 0.5379 0.1643 0.5351 0.1886
             0.5323 0.2126 0.5295 0.237 0.5267 0.2613 0.5239 0.2856 0.5211 0.31 0.5184 0.334
             0.5156 0.3583 0.5128 0.3827 0.51 0.407 0.5072 0.4313 0.5044 0.4553 0.5017 0.4797
             0.4989 0.504 0.4961 0.5283 0.4933 0.5527 0.4905 0.5767 0.4877 0.601 0.4849 0.6254
             0.4821 0.6497 0.4793 0.674 0.4766 0.6981 0.4738 0.7224 0.471 0.7467 0.4682 0.7711
             0.4654 0.7954 0.4626 0.8194 0.4598 0.8437 0.457 0.8681 0.4542 0.8924 0.4515 0.9167
             0.4487 0.9408 0.4459 0.9651 0.4431 0.9894 0.5733 0.07 0.5705 0.0941 0.5677 0.1184
             0.5649 0.1427 0.5621 0.1671 0.5593 0.1914 0.5566 0.2154 0.5538 0.2397 0.551 0.2641
             0.5482 0.2884 0.5454 0.3128 0.5426 0.3368 0.5398 0.3611 0.5371 0.3854 0.5343 0.4098
             0.5315 0.4341 0.5287 0.4581 0.5259 0.4825 0.5231 0.5068 0.5203 0.5311 0.5175 0.5555
             0.5148 0.5795 0.512 0.6038 0.5092 0.6282 0.5064 0.6525 0.5036 0.6768 0.5008 0.7008
             0.498 0.7252 0.4952 0.7495 0.4924 0.7738 0.4896 0.7982 0.4869 0.8222 0.4841 0.8465
             0.4813 0.8709 0.4785 0.8952 0.4757 0.9195 0.4729 0.9436 0.4702 0.9679 0.4674 0.9922
             0.5975 0.0728 0.5948 0.0968 0.592 0.1212 0.5892 0.1455 0.5864 0.1698 0.5836 0.1942
             0.5808 0.2182 0.578 0.2425 0.5752 0.2669 0.5725 0.2912 0.5697 0.3155 0.5669 0.3396
             0.5641 0.3639 0.5613 0.3882 0.5585 0.4126 0.5557 0.4369 0.553 0.4609 0.5502 0.4852
             0.5474 0.5096 0.5446 0.5339 0.5418 0.5583 0.539 0.5823 0.5362 0.6066 0.5334 0.6309
             0.5306 0.6553 0.5278 0.6796 0.5251 0.7036 0.5223 0.728 0.5195 0.7523 0.5167 0.7766
             0.5139 0.801 0.5111 0.825 0.5083 0.8493 0.5056 0.8737 0.5028 0.898 0.5 0.9223
             0.4972 0.9463 0.4944 0.9707 0.4916 0.995 0.6218 0.0756 0.6191 0.0996 0.6163 0.124
             0.6135 0.1483 0.6107 0.1726 0.6079 0.197 0.6051 0.221 0.6023 0.2453 0.5995 0.2697
             0.5967 0.294 0.594 0.3183 0.5912 0.3423 0.5884 0.3667 0.5856 0.391 0.5828 0.4153
             0.58 0.4397 0.5773 0.4637 0.5745 0.488 0.5717 0.5124 0.5689 0.5367 0.5661 0.561
             0.5633 0.5851 0.5605 0.6094 0.5577 0.6337 0.5549 0.6581 0.5521 0.6824 0.5494 0.7064
             0.5466 0.7308 0.5438 0.7551 0.541 0.7794 0.5382 0.8038 0.5354 0.8278 0.5326 0.8521
             0.5298 0.8764 0.5271 0.9008 0.5243 0.9251 0.5215 0.9491 0.5187 0.9735 0.5159 0.9978
             0.6461 0.0784 0.6433 0.1024 0.6405 0.1268 0.6377 0.1511 0.6349 0.1754 0.6321 0.1998
             0.6294 0.2238 0.6266 0.2481 0.6238 0.2724 0.621 0.2968 0.6182 0.3211 0.6154 0.3451
             0.6127 0.3695 0.6099 0.3938 0.6071 0.4181 0.6043 0.4425 0.6015 0.4665 0.5987 0.4908
             0.5959 0.5152 0.5931 0.5395 0.5903 0.5638 0.5876 0.5878 0.5848 0.6122 0.582 0.6365
             0.5792 0.6608 0.5764 0.6852 0.5736 0.7092 0.5708 0.7335 0.568 0.7579 0.5652 0.7822
             0.5625 0.8065 0.5597 0.8306 0.5569 0.8549 0.5541 0.8792 0.5513 0.9036 0.5485 0.9279
             0.5458 0.9519 0.543 0.9762 0.5402 1.0006 0.6704 0.0812 0.6676 0.1052 0.6648 0.1295
             0.662 0.1539 0.6592 0.1782 0.6564 0.2025 0.6537 0.2266 0.6509 0.2509 0.6481 0.2752
             0.6453 0.2996 0.6425 0.3239 0.6397 0.3479 0.6369 0.3723 0.6342 0.3966 0.6314 0.4209
             0.6286 0.4453 0.6258 0.4693 0.623 0.4936 0.6202 0.5179 0.6174 0.5423 0.6146 0.5666
             0.6119 0.5906 0.6091 0.615 0.6063 0.6393 0.6035 0.6636 0.6007 0.688 0.5979 0.712
             0.5951 0.7363 0.5923 0.7607 0.5895 0.785 0.5867 0.8093 0.584 0.8333 0.5812 0.8577
             0.5784 0.882 0.5756 0.9064 0.5728 0.9307 0.5701 0.9547 0.5673 0.979 0.5645 1.0034
             0.6946 0.084 0.6919 0.108 0.6891 0.1323 0.6863 0.1567 0.6835 0.181 0.6807 0.2053
             0.6779 0.2294 0.6751 0.2537 0.6723 0.278 0.6696 0.3024 0.6668 0.3267 0.664 0.3507
             0.6612 0.375 0.6584 0.3994 0.6556 0.4237 0.6528 0.448 0.6501 0.4721 0.6473 0.4964
             0.6445 0.5207 0.6417 0.5451 0.6389 0.5694 0.6361 0.5934 0.6333 0.6178 0.6305 0.6421
             0.6277 0.6664 0.6249 0.6908 0.6222 0.7148 0.6194 0.7391 0.6166 0.7634 0.6138 0.7878
             0.611 0.8121 0.6082 0.8361 0.6055 0.8605 0.6027 0.8848 0.5999 0.9091 0.5971 0.9335
             0.5943 0.9575 0.5915 0.9818 0.5887 1.0062 0.7189 0.0868 0.7161 0.1108 0.7133 0.1351
             0.7105 0.1595 0.7077 0.1838 0.705 0.2081 0.7022 0.2321 0.6994 0.2565 0.6966 0.2808
             0.6938 0.3051 0.691 0.3295 0.6883 0.3535 0.6855 0.3778 0.6827 0.4022 0.6799 0.4265
             0.6771 0.4508 0.6743 0.4749 0.6715 0.4992 0.6687 0.5235 0.6659 0.5479 0.6631 0.5722
             0.6604 0.5962 0.6576 0.6205 0.6548 0.6449 0.652 0.6692 0.6492 0.6935 0.6464 0.7176
             0.6436 0.7419 0.6408 0.7662 0.6381 0.7906 0.6353 0.8149 0.6325 0.8389 0.6297 0.8633
             0.6269 0.8876 0.6241 0.9119 0.6213 0.9363 0.6186 0.9603 0.6158 0.9846 0.613 1.0089
             0.7432 0.0896 0.7404 0.1136 0.7376 0.1379 0.7348 0.1622 0.732 0.1866 0.7292 0.2109
             0.7265 0.2349 0.7237 0.2593 0.7209 0.2836 0.7181 0.3079 0.7153 0.3323 0.7126 0.3563
             0.7098 0.3806 0.707 0.405 0.7042 0.4293 0.7014 0.4536 0.6986 0.4776 0.6958 0.502
             0.693 0.5263 0.6902 0.5506 0.6874 0.575 0.6847 0.599 0.6819 0.6233 0.6791 0.6477
             0.6763 0.672 0.6735 0.6963 0.6707 0.7204 0.6679 0.7447 0.6651 0.769 0.6623 0.7934
             0.6596 0.8177 0.6568 0.8417 0.654 0.866 0.6512 0.8904 0.6484 0.9147 0.6456 0.939
             0.6429 0.9631 0.6401 0.9874 0.6373 1.0117 0.7674 0.0923 0.7647 0.1164 0.7619 0.1407
             0.7591 0.165 0.7563 0.1894 0.7535 0.2137 0.7507 0.2377 0.7479 0.262 0.7452 0.2864
             0.7424 0.3107 0.7396 0.3351 0.7368 0.3591 0.734 0.3834 0.7312 0.4077 0.7284 0.4321
             0.7256 0.4564 0.7229 0.4804 0.7201 0.5048 0.7173 0.5291 0.7145 0.5534 0.7117 0.5778
             0.7089 0.6018 0.7061 0.6261 0.7033 0.6505 0.7005 0.6748 0.6977 0.6991 0.695 0.7231
             0.6922 0.7475 0.6894 0.7718 0.6866 0.7961 0.6838 0.8205 0.6811 0.8445 0.6783 0.8688
             0.6755 0.8932 0.6727 0.9175 0.6699 0.9418 0.6671 0.9659 0.6643 0.9902 0.6615 1.0145
             0.7917 0.0951 0.789 0.1191 0.7862 0.1435 0.7834 0.1678 0.7806 0.1922 0.7778 0.2165
             0.775 0.2405 0.7722 0.2648 0.7694 0.2892 0.7667 0.3135 0.7639 0.3378 0.7611 0.3619
             0.7583 0.3862 0.7555 0.4105 0.7527 0.4349 0.7499 0.4592 0.7472 0.4832 0.7444 0.5076
             0.7416 0.5319 0.7388 0.5562 0.736 0.5806 0.7332 0.6046 0.7304 0.6289 0.7276 0.6532
             0.7248 0.6776 0.722 0.7019 0.7193 0.7259 0.7165 0.7503 0.7137 0.7746 0.7109 0.7989
             0.7081 0.8233 0.7053 0.8473 0.7026 0.8716 0.6998 0.896 0.697 0.9203 0.6942 0.9446
             0.6914 0.9686 0.6886 0.993 0.6858 1.0173 0.816 0.0979 0.8132 0.1219 0.8104 0.1463
             0.8076 0.1706 0.8048 0.1949 0.8021 0.2193 0.7993 0.2433 0.7965 0.2676 0.7937 0.292
             0.7909 0.3163 0.7881 0.3406 0.7854 0.3646 0.7826 0.389 0.7798 0.4133 0.777 0.4377
             0.7742 0.462 0.7714 0.486 0.7686 0.5103 0.7658 0.5347 0.763 0.559 0.7602 0.5833
             0.7575 0.6074 0.7547 0.6317 0.7519 0.656 0.7491 0.6804 0.7463 0.7047 0.7435 0.7287
             0.7407 0.7531 0.738 0.7774 0.7352 0.8017 0.7324 0.8261 0.7296 0.8501 0.7268 0.8744
             0.724 0.8987 0.7212 0.9231 0.7184 0.9474 0.7157 0.9714 0.7129 0.9958 0.7101 1.0201
             0.8402 0.1007 0.8375 0.1247 0.8347 0.1491 0.8319 0.1734 0.8291 0.1977 0.8263 0.2221
             0.8236 0.2461 0.8208 0.2704 0.818 0.2947 0.8152 0.3191 0.8124 0.3434 0.8096 0.3674
             0.8068 0.3918 0.804 0.4161 0.8012 0.4404 0.7984 0.4648 0.7957 0.4888 0.7929 0.5131
             0.7901 0.5375 0.7873 0.5618 0.7845 0.5861 0.7817 0.6101 0.7789 0.6345 0.7761 0.6588
             0.7733 0.6831 0.7706 0.7075 0.7678 0.7315 0.765 0.7558 0.7622 0.7802 0.7594 0.8045
             0.7566 0.8288 0.7539 0.8529 0.7511 0.8772 0.7483 0.9015 0.7455 0.9259 0.7427 0.9502
             0.7399 0.9742 0.7371 0.9986 0.7343 1.0229 0.8645 0.1035 0.8618 0.1275 0.859 0.1518
             0.8562 0.1762 0.8534 0.2005 0.8506 0.2248 0.8478 0.2489 0.8451 0.2732 0.8423 0.2975
             0.8395 0.3219 0.8367 0.3462 0.8339 0.3702 0.8311 0.3946 0.8283 0.4189 0.8255 0.4432
             0.8227 0.4676 0.82 0.4916 0.8172 0.5159 0.8144 0.5402 0.8116 0.5646 0.8088 0.5889
             0.806 0.6129 0.8032 0.6373 0.8004 0.6616 0.7976 0.6859 0.7948 0.7103 0.7921 0.7343
             0.7893 0.7586 0.7865 0.783 0.7837 0.8073 0.7809 0.8316 0.7782 0.8556 0.7754 0.88
             0.7726 0.9043 0.7698 0.9287 0.767 0.953 0.7642 0.977 0.7614 1.0013 0.7586 1.0257
             0.8888 0.1063 0.886 0.1303 0.8832 0.1546 0.8805 0.179 0.8777 0.2033 0.8749 0.2276
             0.8721 0.2517 0.8693 0.276 0.8665 0.3003 0.8637 0.3247 0.8609 0.349 0.8582 0.373
             0.8554 0.3973 0.8526 0.4217 0.8498 0.446 0.847 0.4703 0.8442 0.4944 0.8414 0.5187
             0.8386 0.543 0.8358 0.5674 0.833 0.5917 0.8303 0.6157 0.8275 0.6401 0.8247 0.6644
             0.8219 0.6887 0.8191 0.7131 0.8163 0.7371 0.8136 0.7614 0.8108 0.7857 0.808 0.8101
             0.8052 0.8344 0.8024 0.8584 0.7996 0.8828 0.7968 0.9071 0.794 0.9314 0.7912 0.9558
             0.7885 0.9798 0.7857 1.0041 0.7829 1.0285 0.9131 0.1091 0.9103 0.1331 0.9075 0.1574
             0.9047 0.1818 0.902 0.2061 0.8992 0.2304 0.8964 0.2544 0.8936 0.2788 0.8908 0.3031
             0.888 0.3274 0.8852 0.3518 0.8825 0.3758 0.8797 0.4001 0.8769 0.4245 0.8741 0.4488
             0.8713 0.4731 0.8685 0.4972 0.8657 0.5215 0.8629 0.5458 0.8601 0.5702 0.8573 0.5945
             0.8546 0.6185 0.8518 0.6428 0.849 0.6672 0.8462 0.6915 0.8434 0.7159 0.8406 0.7399
             0.8378 0.7642 0.8351 0.7885 0.8323 0.8129 0.8295 0.8372 0.8267 0.8612 0.8239 0.8856
             0.8211 0.9099 0.8183 0.9342 0.8155 0.9586 0.8128 0.9826 0.81 1.0069 0.8072 1.0313
             0.9373 0.1119 0.9346 0.1359 0.9318 0.1602 0.929 0.1845 0.9262 0.2089 0.9234 0.2332
             0.9207 0.2572 0.9179 0.2816 0.9151 0.3059 0.9123 0.3302 0.9095 0.3546 0.9067 0.3786
             0.9039 0.4029 0.9011 0.4273 0.8983 0.4516 0.8955 0.4759 0.8928 0.4999 0.89 0.5243
             0.8872 0.5486 0.8844 0.5729 0.8816 0.5973 0.8788 0.6213 0.876 0.6456 0.8732 0.67
             0.8705 0.6943 0.8677 0.7186 0.8649 0.7427 0.8621 0.767 0.8593 0.7913 0.8565 0.8157
             0.8537 0.84 0.851 0.864 0.8482 0.8883 0.8454 0.9127 0.8426 0.937 0.8398 0.9614
             0.837 0.9854 0.8342 1.0097 0.8314 1.034 0.9616 0.1146 0.9588 0.1387 0.9561 0.163
             0.9533 0.1873 0.9505 0.2117 0.9477 0.236 0.9449 0.26 0.9421 0.2844 0.9393 0.3087
             0.9365 0.333 0.9337 0.3574 0.931 0.3814 0.9282 0.4057 0.9254 0.43 0.9226 0.4544
             0.9198 0.4787 0.917 0.5027 0.9142 0.5271 0.9114 0.5514 0.9086 0.5757 0.9058 0.6001
             0.9031 0.6241 0.9003 0.6484 0.8975 0.6728 0.8947 0.6971 0.8919 0.7214 0.8892 0.7454
             0.8864 0.7698 0.8836 0.7941 0.8808 0.8184 0.878 0.8428 0.8752 0.8668 0.8724 0.8911
             0.8696 0.9155 0.8668 0.9398 0.864 0.9641 0.8613 0.9882 0.8585 1.0125 0.8557 1.0368
             0.9831 0.1414 0.9803 0.1658 0.9776 0.1901 0.9748 0.2145 0.972 0.2388 0.9692 0.2628
             0.9664 0.2871 0.9636 0.3115 0.9608 0.3358 0.958 0.3601 0.9553 0.3842 0.9525 0.4085
             0.9497 0.4328 0.9469 0.4572 0.9441 0.4815 0.9413 0.5055 0.9385 0.5299 0.9357 0.5542
             0.9329 0.5785 0.9301 0.6029 0.9274 0.6269 0.9246 0.6512 0.9218 0.6755 0.919 0.6999
             0.9162 0.7242 0.9134 0.7482 0.9107 0.7726 0.9079 0.7969 0.9051 0.8212 0.9023 0.8456
             0.8995 0.8696 0.8967 0.8939 0.8939 0.9183 0.8911 0.9426 0.8883 0.9669 0.8856 0.9909
             0.8828 1.0153 0.88 1.0396 0.8772 1.0639 0.025 0 5998.82 41456.1 1.805 5998.8
             41456.4 1.82 5998.82 41456.7 1.885 5998.8 41457 1.88 5998.82 41457.3 1.925 5998.8
             41457.6 1.9 5998.82 41457.9 1.915 5998.8 41458.2 1.88 5998.82 41458.5 1.885 5998.8
             41458.8 1.85 5998.82 41459.1 1.855 5998.8 41459.4 1.81 5998.82 41459.7 1.805 5998.8
             41460 1.75 5998.82 41460.3 1.755 5998.8 41460.6 1.71 5998.82 41460.9 1.725 5998.8
             41461.2 1.69 5998.82 41461.5 1.725 5998.8 41461.8 1.74 5998.82 41462.1 1.815 5998.8
             41462.4 1.86 5998.82 41462.7 1.965 5998.8 41463 1.99 5998.82 41463.3 2.045 5998.8
          }
          Indices id=806 vsg::ushortArray
          {
            userObjects 0
            Layout 0 2 0 1 1 1 0 -1
            size 8208
            storage id=0
            data 0 39 1 39 40 1 1 40 2 40 41 2
             2 41 3 41 42 3 3 42 4 42 43 4
             4 43 5 43 44 5 5 44 6 44 45 6
             6 45 7 45 46 7 7 46 8 46 47 8
             8 47 9 47 48 9 9 48 10 48 49 10
             10 49 11 49 50 11 11 50 12 50 51 12
             12 51 13 51 52 13 13 52 14 52 53 14
             14 53 15 53 54 15 15 54 16 54 55 16
             16 55 17 55 56 17 17 56 18 56 57 18
             18 57 19 57 58 19 19 58 20 58 59 20
)"
        R"(             20 59 21 59 60 21 21 60 22 60 61 22
             22 61 23 61 62 23 23 62 24 62 63 24
             24 63 25 63 64 25 25 64 26 64 65 26
             26 65 27 65 66 27 27 66 28 66 67 28
             28 67 29 67 68 29 29 68 30 68 69 30
             30 69 31 69 70 31 31 70 32 70 71 32
             32 71 33 71 72 33 33 72 34 72 73 34
             34 73 35 73 74 35 35 74 36 74 75 36
             36 75 37 75 76 37 37 76 38 76 77 38
             39 78 40 78 79 40 40 79 41 79 80 41
             41 80 42 80 81 42 42 81 43 81 82 43
             43 82 44 82 83 44 44 83 45 83 84 45
             45 84 46 84 85 46 46 85 47 85 86 47
             47 86 48 86 87 48 48 87 49 87 88 49
             49 88 50 88 89 50 50 89 51 89 90 51
             51 90 52 90 91 52 52 91 53 91 92 53
             53 92 54 92 93 54 54 93 55 93 94 55
             55 94 56 94 95 56 56 95 57 95 96 57
             57 96 58 96 97 58 58 97 59 97 98 59
             59 98 60 98 99 60 60 99 61 99 100 61
             61 100 62 100 101 62 62 101 63 101 102 63
             63 102 64 102 103 64 64 103 65 103 104 65
             65 104 66 104 105 66 66 105 67 105 106 67
             67 106 68 106 107 68 68 107 69 107 108 69
             69 108 70 108 109 70 70 109 71 109 110 71
             71 110 72 110 111 72 72 111 73 111 112 73
             73 112 74 112 113 74 74 113 75 113 114 75
             75 114 76 114 115 76 76 115 77 115 116 77
             78 117 79 117 118 79 79 118 80 118 119 80
             80 119 81 119 120 81 81 120 82 120 121 82
             82 121 83 121 122 83 83 122 84 122 123 84
             84 123 85 123 124 85 85 124 86 124 125 86
             86 125 87 125 126 87 87 126 88 126 127 88
             88 127 89 127 128 89 89 128 90 128 129 90
             90 129 91 129 130 91 91 130 92 130 131 92
             92 131 93 131 132 93 93 132 94 132 133 94
             94 133 95 133 134 95 95 134 96 134 135 96
             96 135 97 135 136 97 97 136 98 136 137 98
             98 137 99 137 138 99 99 138 100 138 139 100
             100 139 101 139 140 101 101 140 102 140 141 102
             102 141 103 141 142 103 103 142 104 142 143 104
             104 143 105 143 144 105 105 144 106 144 145 106
             106 145 107 145 146 107 107 146 108 146 147 108
             108 147 109 147 148 109 109 148 110 148 149 110
             110 149 111 149 150 111 111 150 112 150 151 112
             112 151 113 151 152 113 113 152 114 152 153 114
             114 153 115 153 154 115 115 154 116 154 155 116
             117 156 118 156 157 118 118 157 119 157 158 119
             119 158 120 158 159 120 120 159 121 159 160 121
             121 160 122 160 161 122 122 161 123 161 162 123
             123 162 124 162 163 124 124 163 125 163 164 125
             125 164 126 164 165 126 126 165 127 165 166 127
             127 166 128 166 167 128 128 167 129 167 168 129
             129 168 130 168 169 130 130 169 131 169 170 131
             131 170 132 170 171 132 132 171 133 171 172 133
             133 172 134 172 173 134 134 173 135 173 174 135
             135 174 136 174 175 136 136 175 137 175 176 137
             137 176 138 176 177 138 138 177 139 177 178 139
             139 178 140 178 179 140 140 179 141 179 180 141
             141 180 142 180 181 142 142 181 143 181 182 143
             143 182 144 182 183 144 144 183 145 183 184 145
             145 184 146 184 185 146 146 185 147 185 186 147
             147 186 148 186 187 148 148 187 149 187 188 149
             149 188 150 188 189 150 150 189 151 189 190 151
             151 190 152 190 191 152 152 191 153 191 192 153
             153 192 154 192 193 154 154 193 155 193 194 155
             156 195 157 195 196 157 157 196 158 196 197 158
             158 197 159 197 198 159 159 198 160 198 199 160
             160 199 161 199 200 161 161 200 162 200 201 162
             162 201 163 201 202 163 163 202 164 202 203 164
             164 203 165 203 204 165 165 204 166 204 205 166
             166 205 167 205 206 167 167 206 168 206 207 168
             168 207 169 207 208 169 169 208 170 208 209 170
             170 209 171 209 210 171 171 210 172 210 211 172
             172 211 173 211 212 173 173 212 174 212 213 174
             174 213 175 213 214 175 175 214 176 214 215 176
             176 215 177 215 216 177 177 216 178 216 217 178
             178 217 179 217 218 179 179 218 180 218 219 180
             180 219 181 219 220 181 181 220 182 220 221 182
             182 221 183 221 222 183 183 222 184 222 223 184
             184 223 185 223 224 185 185 224 186 224 225 186
             186 225 187 225 226 187 187 226 188 226 227 188
             188 227 189 227 228 189 189 228 190 228 229 190
             190 229 191 229 230 191 191 230 192 230 231 192
             192 231 193 231 232 193 193 232 194 232 233 194
             195 234 196 234 235 196 196 235 197 235 236 197
             197 236 198 236 237 198 198 237 199 237 238 199
             199 238 200 238 239 200 200 239 201 239 240 201
             201 240 202 240 241 202 202 241 203 241 242 203
             203 242 204 242 243 204 204 243 205 243 244 205
             205 244 206 244 245 206 206 245 207 245 246 207
             207 246 208 246 247 208 208 247 209 247 248 209
             209 248 210 248 249 210 210 249 211 249 250 211
             211 250 212 250 251 212 212 251 213 251 252 213
             213 252 214 252 253 214 214 253 215 253 254 215
             215 254 216 254 255 216 216 255 217 255 256 217
             217 256 218 256 257 218 218 257 219 257 258 219
             219 258 220 258 259 220 220 259 221 259 260 221
             221 260 222 260 261 222 222 261 223 261 262 223
             223 262 224 262 263 224 224 263 225 263 264 225
             225 264 226 264 265 226 226 265 227 265 266 227
             227 266 228 266 267 228 228 267 229 267 268 229
             229 268 230 268 269 230 230 269 231 269 270 231
             231 270 232 270 271 232 232 271 233 271 272 233
             234 273 235 273 274 235 235 274 236 274 275 236
             236 275 237 275 276 237 237 276 238 276 277 238
             238 277 239 277 278 239 239 278 240 278 279 240
             240 279 241 279 280 241 241 280 242 280 281 242
             242 281 243 281 282 243 243 282 244 282 283 244
             244 283 245 283 284 245 245 284 246 284 285 246
             246 285 247 285 286 247 247 286 248 286 287 248
             248 287 249 287 288 249 249 288 250 288 289 250
             250 289 251 289 290 251 251 290 252 290 291 252
             252 291 253 291 292 253 253 292 254 292 293 254
             254 293 255 293 294 255 255 294 256 294 295 256
             256 295 257 295 296 257 257 296 258 296 297 258
             258 297 259 297 298 259 259 298 260 298 299 260
             260 299 261 299 300 261 261 300 262 300 301 262
             262 301 263 301 302 263 263 302 264 302 303 264
             264 303 265 303 304 265 265 304 266 304 305 266
             266 305 267 305 306 267 267 306 268 306 307 268
             268 307 269 307 308 269 269 308 270 308 309 270
             270 309 271 309 310 271 271 310 272 310 311 272
             273 312 274 312 313 274 274 313 275 313 314 275
             275 314 276 314 315 276 276 315 277 315 316 277
             277 316 278 316 317 278 278 317 279 317 318 279
             279 318 280 318 319 280 280 319 281 319 320 281
             281 320 282 320 321 282 282 321 283 321 322 283
             283 322 284 322 323 284 284 323 285 323 324 285
             285 324 286 324 325 286 286 325 287 325 326 287
             287 326 288 326 327 288 288 327 289 327 328 289
             289 328 290 328 329 290 290 329 291 329 330 291
             291 330 292 330 331 292 292 331 293 331 332 293
             293 332 294 332 333 294 294 333 295 333 334 295
             295 334 296 334 335 296 296 335 297 335 336 297
             297 336 298 336 337 298 298 337 299 337 338 299
             299 338 300 338 339 300 300 339 301 339 340 301
             301 340 302 340 341 302 302 341 303 341 342 303
             303 342 304 342 343 304 304 343 305 343 344 305
             305 344 306 344 345 306 306 345 307 345 346 307
             307 346 308 346 347 308 308 347 309 347 348 309
             309 348 310 348 349 310 310 349 311 349 350 311
             312 351 313 351 352 313 313 352 314 352 353 314
             314 353 315 353 354 315 315 354 316 354 355 316
             316 355 317 355 356 317 317 356 318 356 357 318
             318 357 319 357 358 319 319 358 320 358 359 320
             320 359 321 359 360 321 321 360 322 360 361 322
             322 361 323 361 362 323 323 362 324 362 363 324
             324 363 325 363 364 325 325 364 326 364 365 326
             326 365 327 365 366 327 327 366 328 366 367 328
             328 367 329 367 368 329 329 368 330 368 369 330
             330 369 331 369 370 331 331 370 332 370 371 332
             332 371 333 371 372 333 333 372 334 372 373 334
             334 373 335 373 374 335 335 374 336 374 375 336
             336 375 337 375 376 337 337 376 338 376 377 338
             338 377 339 377 378 339 339 378 340 378 379 340
             340 379 341 379 380 341 341 380 342 380 381 342
             342 381 343 381 382 343 343 382 344 382 383 344
             344 383 345 383 384 345 345 384 346 384 385 346
             346 385 347 385 386 347 347 386 348 386 387 348
             348 387 349 387 388 349 349 388 350 388 389 350
             351 390 352 390 391 352 352 391 353 391 392 353
             353 392 354 392 393 354 354 393 355 393 394 355
             355 394 356 394 395 356 356 395 357 395 396 357
             357 396 358 396 397 358 358 397 359 397 398 359
             359 398 360 398 399 360 360 399 361 399 400 361
             361 400 362 400 401 362 362 401 363 401 402 363
             363 402 364 402 403 364 364 403 365 403 404 365
             365 404 366 404 405 366 366 405 367 405 406 367
             367 406 368 406 407 368 368 407 369 407 408 369
             369 408 370 408 409 370 370 409 371 409 410 371
             371 410 372 410 411 372 372 411 373 411 412 373
             373 412 374 412 413 374 374 413 375 413 414 375
             375 414 376 414 415 376 376 415 377 415 416 377
             377 416 378 416 417 378 378 417 379 417 418 379
             379 418 380 418 419 380 380 419 381 419 420 381
             381 420 382 420 421 382 382 421 383 421 422 383
             383 422 384 422 423 384 384 423 385 423 424 385
             385 424 386 424 425 386 386 425 387 425 426 387
             387 426 388 426 427 388 388 427 389 427 428 389
             390 429 391 429 430 391 391 430 392 430 431 392
             392 431 393 431 432 393 393 432 394 432 433 394
             394 433 395 433 434 395 395 434 396 434 435 396
             396 435 397 435 436 397 397 436 398 436 437 398
             398 437 399 437 438 399 399 438 400 438 439 400
             400 439 401 439 440 401 401 440 402 440 441 402
             402 441 403 441 442 403 403 442 404 442 443 404
             404 443 405 443 444 405 405 444 406 444 445 406
             406 445 407 445 446 407 407 446 408 446 447 408
             408 447 409 447 448 409 409 448 410 448 449 410
             410 449 411 449 450 411 411 450 412 450 451 412
             412 451 413 451 452 413 413 452 414 452 453 414
             414 453 415 453 454 415 415 454 416 454 455 416
             416 455 417 455 456 417 417 456 418 456 457 418
             418 457 419 457 458 419 419 458 420 458 459 420
             420 459 421 459 460 421 421 460 422 460 461 422
             422 461 423 461 462 423 423 462 424 462 463 424
             424 463 425 463 464 425 425 464 426 464 465 426
             426 465 427 465 466 427 427 466 428 466 467 428
             429 468 430 468 469 430 430 469 431 469 470 431
             431 470 432 470 471 432 432 471 433 471 472 433
             433 472 434 472 473 434 434 473 435 473 474 435
             435 474 436 474 475 436 436 475 437 475 476 437
             437 476 438 476 477 438 438 477 439 477 478 439
             439 478 440 478 479 440 440 479 441 479 480 441
             441 480 442 480 481 442 442 481 443 481 482 443
             443 482 444 482 483 444 444 483 445 483 484 445
             445 484 446 484 485 446 446 485 447 485 486 447
             447 486 448 486 487 448 448 487 449 487 488 449
             449 488 450 488 489 450 450 489 451 489 490 451
             451 490 452 490 491 452 452 491 453 491 492 453
             453 492 454 492 493 454 454 493 455 493 494 455
             455 494 456 494 495 456 456 495 457 495 496 457
             457 496 458 496 497 458 458 497 459 497 498 459
             459 498 460 498 499 460 460 499 461 499 500 461
             461 500 462 500 501 462 462 501 463 501 502 463
             463 502 464 502 503 464 464 503 465 503 504 465
             465 504 466 504 505 466 466 505 467 505 506 467
             468 507 469 507 508 469 469 508 470 508 509 470
             470 509 471 509 510 471 471 510 472 510 511 472
             472 511 473 511 512 473 473 512 474 512 513 474
             474 513 475 513 514 475 475 514 476 514 515 476
             476 515 477 515 516 477 477 516 478 516 517 478
             478 517 479 517 518 479 479 518 480 518 519 480
             480 519 481 519 520 481 481 520 482 520 521 482
             482 521 483 521 522 483 483 522 484 522 523 484
             484 523 485 523 524 485 485 524 486 524 525 486
             486 525 487 525 526 487 487 526 488 526 527 488
             488 527 489 527 528 489 489 528 490 528 529 490
             490 529 491 529 530 491 491 530 492 530 531 492
             492 531 493 531 532 493 493 532 494 532 533 494
             494 533 495 533 534 495 495 534 496 534 535 496
             496 535 497 535 536 497 497 536 498 536 537 498
             498 537 499 537 538 499 499 538 500 538 539 500
             500 539 501 539 540 501 501 540 502 540 541 502
             502 541 503 541 542 503 503 542 504 542 543 504
             504 543 505 543 544 505 505 544 506 544 545 506
             507 546 508 546 547 508 508 547 509 547 548 509
             509 548 510 548 549 510 510 549 511 549 550 511
             511 550 512 550 551 512 512 551 513 551 552 513
             513 552 514 552 553 514 514 553 515 553 554 515
             515 554 516 554 555 516 516 555 517 555 556 517
             517 556 518 556 557 518 518 557 519 557 558 519
             519 558 520 558 559 520 520 559 521 559 560 521
             521 560 522 560 561 522 522 561 523 561 562 523
             523 562 524 562 563 524 524 563 525 563 564 525
             525 564 526 564 565 526 526 565 527 565 566 527
             527 566 528 566 567 528 528 567 529 567 568 529
             529 568 530 568 569 530 530 569 531 569 570 531
             531 570 532 570 571 532 532 571 533 571 572 533
             533 572 534 572 573 534 534 573 535 573 574 535
             535 574 536 574 575 536 536 575 537 575 576 537
             537 576 538 576 577 538 538 577 539 577 578 539
             539 578 540 578 579 540 540 579 541 579 580 541
             541 580 542 580 581 542 542 581 543 581 582 543
             543 582 544 582 583 544 544 583 545 583 584 545
             546 585 547 585 586 547 547 586 548 586 587 548
             548 587 549 587 588 549 549 588 550 588 589 550
             550 589 551 589 590 551 551 590 552 590 591 552
             552 591 553 591 592 553 553 592 554 592 593 554
             554 593 555 593 594 555 555 594 556 594 595 556
             556 595 557 595 596 557 557 596 558 596 597 558
             558 597 559 597 598 559 559 598 560 598 599 560
             560 599 561 599 600 561 561 600 562 600 601 562
             562 601 563 601 602 563 563 602 564 602 603 564
             564 603 565 603 604 565 565 604 566 604 605 566
             566 605 567 605 606 567 567 606 568 606 607 568
             568 607 569 607 608 569 569 608 570 608 609 570
             570 609 571 609 610 571 571 610 572 610 611 572
             572 611 573 611 612 573 573 612 574 612 613 574
             574 613 575 613 614 575 575 614 576 614 615 576
             576 615 577 615 616 577 577 616 578 616 617 578
             578 617 579 617 618 579 579 618 580 618 619 580
)"
        R"(             580 619 581 619 620 581 581 620 582 620 621 582
             582 621 583 621 622 583 583 622 584 622 623 584
             585 624 586 624 625 586 586 625 587 625 626 587
             587 626 588 626 627 588 588 627 589 627 628 589
             589 628 590 628 629 590 590 629 591 629 630 591
             591 630 592 630 631 592 592 631 593 631 632 593
             593 632 594 632 633 594 594 633 595 633 634 595
             595 634 596 634 635 596 596 635 597 635 636 597
             597 636 598 636 637 598 598 637 599 637 638 599
             599 638 600 638 639 600 600 639 601 639 640 601
             601 640 602 640 641 602 602 641 603 641 642 603
             603 642 604 642 643 604 604 643 605 643 644 605
             605 644 606 644 645 606 606 645 607 645 646 607
             607 646 608 646 647 608 608 647 609 647 648 609
             609 648 610 648 649 610 610 649 611 649 650 611
             611 650 612 650 651 612 612 651 613 651 652 613
             613 652 614 652 653 614 614 653 615 653 654 615
             615 654 616 654 655 616 616 655 617 655 656 617
             617 656 618 656 657 618 618 657 619 657 658 619
             619 658 620 658 659 620 620 659 621 659 660 621
             621 660 622 660 661 622 622 661 623 661 662 623
             624 663 625 663 664 625 625 664 626 664 665 626
             626 665 627 665 666 627 627 666 628 666 667 628
             628 667 629 667 668 629 629 668 630 668 669 630
             630 669 631 669 670 631 631 670 632 670 671 632
             632 671 633 671 672 633 633 672 634 672 673 634
             634 673 635 673 674 635 635 674 636 674 675 636
             636 675 637 675 676 637 637 676 638 676 677 638
             638 677 639 677 678 639 639 678 640 678 679 640
             640 679 641 679 680 641 641 680 642 680 681 642
             642 681 643 681 682 643 643 682 644 682 683 644
             644 683 645 683 684 645 645 684 646 684 685 646
             646 685 647 685 686 647 647 686 648 686 687 648
             648 687 649 687 688 649 649 688 650 688 689 650
             650 689 651 689 690 651 651 690 652 690 691 652
             652 691 653 691 692 653 653 692 654 692 693 654
             654 693 655 693 694 655 655 694 656 694 695 656
             656 695 657 695 696 657 657 696 658 696 697 658
             658 697 659 697 698 659 659 698 660 698 699 660
             660 699 661 699 700 661 661 700 662 700 701 662
             663 702 664 702 703 664 664 703 665 703 704 665
             665 704 666 704 705 666 666 705 667 705 706 667
             667 706 668 706 707 668 668 707 669 707 708 669
             669 708 670 708 709 670 670 709 671 709 710 671
             671 710 672 710 711 672 672 711 673 711 712 673
             673 712 674 712 713 674 674 713 675 713 714 675
             675 714 676 714 715 676 676 715 677 715 716 677
             677 716 678 716 717 678 678 717 679 717 718 679
             679 718 680 718 719 680 680 719 681 719 720 681
             681 720 682 720 721 682 682 721 683 721 722 683
             683 722 684 722 723 684 684 723 685 723 724 685
             685 724 686 724 725 686 686 725 687 725 726 687
             687 726 688 726 727 688 688 727 689 727 728 689
             689 728 690 728 729 690 690 729 691 729 730 691
             691 730 692 730 731 692 692 731 693 731 732 693
             693 732 694 732 733 694 694 733 695 733 734 695
             695 734 696 734 735 696 696 735 697 735 736 697
             697 736 698 736 737 698 698 737 699 737 738 699
             699 738 700 738 739 700 700 739 701 739 740 701
             702 741 703 741 742 703 703 742 704 742 743 704
             704 743 705 743 744 705 705 744 706 744 745 706
             706 745 707 745 746 707 707 746 708 746 747 708
             708 747 709 747 748 709 709 748 710 748 749 710
             710 749 711 749 750 711 711 750 712 750 751 712
             712 751 713 751 752 713 713 752 714 752 753 714
             714 753 715 753 754 715 715 754 716 754 755 716
             716 755 717 755 756 717 717 756 718 756 757 718
             718 757 719 757 758 719 719 758 720 758 759 720
             720 759 721 759 760 721 721 760 722 760 761 722
             722 761 723 761 762 723 723 762 724 762 763 724
             724 763 725 763 764 725 725 764 726 764 765 726
             726 765 727 765 766 727 727 766 728 766 767 728
             728 767 729 767 768 729 729 768 730 768 769 730
             730 769 731 769 770 731 731 770 732 770 771 732
             732 771 733 771 772 733 733 772 734 772 773 734
             734 773 735 773 774 735 735 774 736 774 775 736
             736 775 737 775 776 737 737 776 738 776 777 738
             738 777 739 777 778 739 739 778 740 778 779 740
             741 780 742 780 781 742 742 781 743 781 782 743
             743 782 744 782 783 744 744 783 745 783 784 745
             745 784 746 784 785 746 746 785 747 785 786 747
             747 786 748 786 787 748 748 787 749 787 788 749
             749 788 750 788 789 750 750 789 751 789 790 751
             751 790 752 790 791 752 752 791 753 791 792 753
             753 792 754 792 793 754 754 793 755 793 794 755
             755 794 756 794 795 756 756 795 757 795 796 757
             757 796 758 796 797 758 758 797 759 797 798 759
             759 798 760 798 799 760 760 799 761 799 800 761
             761 800 762 800 801 762 762 801 763 801 802 763
             763 802 764 802 803 764 764 803 765 803 804 765
             765 804 766 804 805 766 766 805 767 805 806 767
             767 806 768 806 807 768 768 807 769 807 808 769
             769 808 770 808 809 770 770 809 771 809 810 771
             771 810 772 810 811 772 772 811 773 811 812 773
             773 812 774 812 813 774 774 813 775 813 814 775
             775 814 776 814 815 776 776 815 777 815 816 777
             777 816 778 816 817 778 778 817 779 817 818 779
             780 819 781 819 820 781 781 820 782 820 821 782
             782 821 783 821 822 783 783 822 784 822 823 784
             784 823 785 823 824 785 785 824 786 824 825 786
             786 825 787 825 826 787 787 826 788 826 827 788
             788 827 789 827 828 789 789 828 790 828 829 790
             790 829 791 829 830 791 791 830 792 830 831 792
             792 831 793 831 832 793 793 832 794 832 833 794
             794 833 795 833 834 795 795 834 796 834 835 796
             796 835 797 835 836 797 797 836 798 836 837 798
             798 837 799 837 838 799 799 838 800 838 839 800
             800 839 801 839 840 801 801 840 802 840 841 802
             802 841 803 841 842 803 803 842 804 842 843 804
             804 843 805 843 844 805 805 844 806 844 845 806
             806 845 807 845 846 807 807 846 808 846 847 808
             808 847 809 847 848 809 809 848 810 848 849 810
             810 849 811 849 850 811 811 850 812 850 851 812
             812 851 813 851 852 813 813 852 814 852 853 814
             814 853 815 853 854 815 815 854 816 854 855 816
             816 855 817 855 856 817 817 856 818 856 857 818
             819 858 820 858 859 820 820 859 821 859 860 821
             821 860 822 860 861 822 822 861 823 861 862 823
             823 862 824 862 863 824 824 863 825 863 864 825
             825 864 826 864 865 826 826 865 827 865 866 827
             827 866 828 866 867 828 828 867 829 867 868 829
             829 868 830 868 869 830 830 869 831 869 870 831
             831 870 832 870 871 832 832 871 833 871 872 833
             833 872 834 872 873 834 834 873 835 873 874 835
             835 874 836 874 875 836 836 875 837 875 876 837
             837 876 838 876 877 838 838 877 839 877 878 839
             839 878 840 878 879 840 840 879 841 879 880 841
             841 880 842 880 881 842 842 881 843 881 882 843
             843 882 844 882 883 844 844 883 845 883 884 845
             845 884 846 884 885 846 846 885 847 885 886 847
             847 886 848 886 887 848 848 887 849 887 888 849
             849 888 850 888 889 850 850 889 851 889 890 851
             851 890 852 890 891 852 852 891 853 891 892 853
             853 892 854 892 893 854 854 893 855 893 894 855
             855 894 856 894 895 856 856 895 857 895 896 857
             858 897 859 897 898 859 859 898 860 898 899 860
             860 899 861 899 900 861 861 900 862 900 901 862
             862 901 863 901 902 863 863 902 864 902 903 864
             864 903 865 903 904 865 865 904 866 904 905 866
             866 905 867 905 906 867 867 906 868 906 907 868
             868 907 869 907 908 869 869 908 870 908 909 870
             870 909 871 909 910 871 871 910 872 910 911 872
             872 911 873 911 912 873 873 912 874 912 913 874
             874 913 875 913 914 875 875 914 876 914 915 876
             876 915 877 915 916 877 877 916 878 916 917 878
             878 917 879 917 918 879 879 918 880 918 919 880
             880 919 881 919 920 881 881 920 882 920 921 882
             882 921 883 921 922 883 883 922 884 922 923 884
             884 923 885 923 924 885 885 924 886 924 925 886
             886 925 887 925 926 887 887 926 888 926 927 888
             888 927 889 927 928 889 889 928 890 928 929 890
             890 929 891 929 930 891 891 930 892 930 931 892
             892 931 893 931 932 893 893 932 894 932 933 894
             894 933 895 933 934 895 895 934 896 934 935 896
             897 936 898 936 937 898 898 937 899 937 938 899
             899 938 900 938 939 900 900 939 901 939 940 901
             901 940 902 940 941 902 902 941 903 941 942 903
             903 942 904 942 943 904 904 943 905 943 944 905
             905 944 906 944 945 906 906 945 907 945 946 907
             907 946 908 946 947 908 908 947 909 947 948 909
             909 948 910 948 949 910 910 949 911 949 950 911
             911 950 912 950 951 912 912 951 913 951 952 913
             913 952 914 952 953 914 914 953 915 953 954 915
             915 954 916 954 955 916 916 955 917 955 956 917
             917 956 918 956 957 918 918 957 919 957 958 919
             919 958 920 958 959 920 920 959 921 959 960 921
             921 960 922 960 961 922 922 961 923 961 962 923
             923 962 924 962 963 924 924 963 925 963 964 925
             925 964 926 964 965 926 926 965 927 965 966 927
             927 966 928 966 967 928 928 967 929 967 968 929
             929 968 930 968 969 930 930 969 931 969 970 931
             931 970 932 970 971 932 932 971 933 971 972 933
             933 972 934 972 973 934 934 973 935 973 974 935
             936 975 937 975 976 937 937 976 938 976 977 938
             938 977 939 977 978 939 939 978 940 978 979 940
             940 979 941 979 980 941 941 980 942 980 981 942
             942 981 943 981 982 943 943 982 944 982 983 944
             944 983 945 983 984 945 945 984 946 984 985 946
             946 985 947 985 986 947 947 986 948 986 987 948
             948 987 949 987 988 949 949 988 950 988 989 950
             950 989 951 989 990 951 951 990 952 990 991 952
             952 991 953 991 992 953 953 992 954 992 993 954
             954 993 955 993 994 955 955 994 956 994 995 956
             956 995 957 995 996 957 957 996 958 996 997 958
             958 997 959 997 998 959 959 998 960 998 999 960
             960 999 961 999 1000 961 961 1000 962 1000 1001 962
             962 1001 963 1001 1002 963 963 1002 964 1002 1003 964
             964 1003 965 1003 1004 965 965 1004 966 1004 1005 966
             966 1005 967 1005 1006 967 967 1006 968 1006 1007 968
             968 1007 969 1007 1008 969 969 1008 970 1008 1009 970
             970 1009 971 1009 1010 971 971 1010 972 1010 1011 972
             972 1011 973 1011 1012 973 973 1012 974 1012 1013 974
             975 1014 976 1014 1015 976 976 1015 977 1015 1016 977
             977 1016 978 1016 1017 978 978 1017 979 1017 1018 979
             979 1018 980 1018 1019 980 980 1019 981 1019 1020 981
             981 1020 982 1020 1021 982 982 1021 983 1021 1022 983
             983 1022 984 1022 1023 984 984 1023 985 1023 1024 985
             985 1024 986 1024 1025 986 986 1025 987 1025 1026 987
             987 1026 988 1026 1027 988 988 1027 989 1027 1028 989
             989 1028 990 1028 1029 990 990 1029 991 1029 1030 991
             991 1030 992 1030 1031 992 992 1031 993 1031 1032 993
             993 1032 994 1032 1033 994 994 1033 995 1033 1034 995
             995 1034 996 1034 1035 996 996 1035 997 1035 1036 997
             997 1036 998 1036 1037 998 998 1037 999 1037 1038 999
             999 1038 1000 1038 1039 1000 1000 1039 1001 1039 1040 1001
             1001 1040 1002 1040 1041 1002 1002 1041 1003 1041 1042 1003
             1003 1042 1004 1042 1043 1004 1004 1043 1005 1043 1044 1005
             1005 1044 1006 1044 1045 1006 1006 1045 1007 1045 1046 1007
             1007 1046 1008 1046 1047 1008 1008 1047 1009 1047 1048 1009
             1009 1048 1010 1048 1049 1010 1010 1049 1011 1049 1050 1011
             1011 1050 1012 1050 1051 1012 1012 1051 1013 1051 1052 1013
             1014 1053 1015 1053 1054 1015 1015 1054 1016 1054 1055 1016
             1016 1055 1017 1055 1056 1017 1017 1056 1018 1056 1057 1018
             1018 1057 1019 1057 1058 1019 1019 1058 1020 1058 1059 1020
             1020 1059 1021 1059 1060 1021 1021 1060 1022 1060 1061 1022
             1022 1061 1023 1061 1062 1023 1023 1062 1024 1062 1063 1024
             1024 1063 1025 1063 1064 1025 1025 1064 1026 1064 1065 1026
             1026 1065 1027 1065 1066 1027 1027 1066 1028 1066 1067 1028
             1028 1067 1029 1067 1068 1029 1029 1068 1030 1068 1069 1030
             1030 1069 1031 1069 1070 1031 1031 1070 1032 1070 1071 1032
             1032 1071 1033 1071 1072 1033 1033 1072 1034 1072 1073 1034
             1034 1073 1035 1073 1074 1035 1035 1074 1036 1074 1075 1036
             1036 1075 1037 1075 1076 1037 1037 1076 1038 1076 1077 1038
             1038 1077 1039 1077 1078 1039 1039 1078 1040 1078 1079 1040
             1040 1079 1041 1079 1080 1041 1041 1080 1042 1080 1081 1042
             1042 1081 1043 1081 1082 1043 1043 1082 1044 1082 1083 1044
             1044 1083 1045 1083 1084 1045 1045 1084 1046 1084 1085 1046
             1046 1085 1047 1085 1086 1047 1047 1086 1048 1086 1087 1048
             1048 1087 1049 1087 1088 1049 1049 1088 1050 1088 1089 1050
             1050 1089 1051 1089 1090 1051 1051 1090 1052 1090 1091 1052
             1053 1092 1054 1092 1093 1054 1054 1093 1055 1093 1094 1055
             1055 1094 1056 1094 1095 1056 1056 1095 1057 1095 1096 1057
             1057 1096 1058 1096 1097 1058 1058 1097 1059 1097 1098 1059
             1059 1098 1060 1098 1099 1060 1060 1099 1061 1099 1100 1061
             1061 1100 1062 1100 1101 1062 1062 1101 1063 1101 1102 1063
             1063 1102 1064 1102 1103 1064 1064 1103 1065 1103 1104 1065
             1065 1104 1066 1104 1105 1066 1066 1105 1067 1105 1106 1067
             1067 1106 1068 1106 1107 1068 1068 1107 1069 1107 1108 1069
             1069 1108 1070 1108 1109 1070 1070 1109 1071 1109 1110 1071
             1071 1110 1072 1110 1111 1072 1072 1111 1073 1111 1112 1073
             1073 1112 1074 1112 1113 1074 1074 1113 1075 1113 1114 1075
             1075 1114 1076 1114 1115 1076 1076 1115 1077 1115 1116 1077
             1077 1116 1078 1116 1117 1078 1078 1117 1079 1117 1118 1079
             1079 1118 1080 1118 1119 1080 1080 1119 1081 1119 1120 1081
             1081 1120 1082 1120 1121 1082 1082 1121 1083 1121 1122 1083
             1083 1122 1084 1122 1123 1084 1084 1123 1085 1123 1124 1085
             1085 1124 1086 1124 1125 1086 1086 1125 1087 1125 1126 1087
             1087 1126 1088 1126 1127 1088 1088 1127 1089 1127 1128 1089
             1089 1128 1090 1128 1129 1090 1090 1129 1091 1129 1130 1091
             1092 1131 1093 1131 1132 1093 1093 1132 1094 1132 1133 1094
             1094 1133 1095 1133 1134 1095 1095 1134 1096 1134 1135 1096
             1096 1135 1097 1135 1136 1097 1097 1136 1098 1136 1137 1098
             1098 1137 1099 1137 1138 1099 1099 1138 1100 1138 1139 1100
             1100 1139 1101 1139 1140 1101 1101 1140 1102 1140 1141 1102
             1102 1141 1103 1141 1142 1103 1103 1142 1104 1142 1143 1104
             1104 1143 1105 1143 1144 1105 1105 1144 1106 1144 1145 1106
)"
        R"(             1106 1145 1107 1145 1146 1107 1107 1146 1108 1146 1147 1108
             1108 1147 1109 1147 1148 1109 1109 1148 1110 1148 1149 1110
             1110 1149 1111 1149 1150 1111 1111 1150 1112 1150 1151 1112
             1112 1151 1113 1151 1152 1113 1113 1152 1114 1152 1153 1114
             1114 1153 1115 1153 1154 1115 1115 1154 1116 1154 1155 1116
             1116 1155 1117 1155 1156 1117 1117 1156 1118 1156 1157 1118
             1118 1157 1119 1157 1158 1119 1119 1158 1120 1158 1159 1120
             1120 1159 1121 1159 1160 1121 1121 1160 1122 1160 1161 1122
             1122 1161 1123 1161 1162 1123 1123 1162 1124 1162 1163 1124
             1124 1163 1125 1163 1164 1125 1125 1164 1126 1164 1165 1126
             1126 1165 1127 1165 1166 1127 1127 1166 1128 1166 1167 1128
             1128 1167 1129 1167 1168 1129 1129 1168 1130 1168 1169 1130
             1131 1170 1132 1170 1171 1132 1132 1171 1133 1171 1172 1133
             1133 1172 1134 1172 1173 1134 1134 1173 1135 1173 1174 1135
             1135 1174 1136 1174 1175 1136 1136 1175 1137 1175 1176 1137
             1137 1176 1138 1176 1177 1138 1138 1177 1139 1177 1178 1139
             1139 1178 1140 1178 1179 1140 1140 1179 1141 1179 1180 1141
             1141 1180 1142 1180 1181 1142 1142 1181 1143 1181 1182 1143
             1143 1182 1144 1182 1183 1144 1144 1183 1145 1183 1184 1145
             1145 1184 1146 1184 1185 1146 1146 1185 1147 1185 1186 1147
             1147 1186 1148 1186 1187 1148 1148 1187 1149 1187 1188 1149
             1149 1188 1150 1188 1189 1150 1150 1189 1151 1189 1190 1151
             1151 1190 1152 1190 1191 1152 1152 1191 1153 1191 1192 1153
             1153 1192 1154 1192 1193 1154 1154 1193 1155 1193 1194 1155
             1155 1194 1156 1194 1195 1156 1156 1195 1157 1195 1196 1157
             1157 1196 1158 1196 1197 1158 1158 1197 1159 1197 1198 1159
             1159 1198 1160 1198 1199 1160 1160 1199 1161 1199 1200 1161
             1161 1200 1162 1200 1201 1162 1162 1201 1163 1201 1202 1163
             1163 1202 1164 1202 1203 1164 1164 1203 1165 1203 1204 1165
             1165 1204 1166 1204 1205 1166 1166 1205 1167 1205 1206 1167
             1167 1206 1168 1206 1207 1168 1168 1207 1169 1207 1208 1169
             1170 1209 1171 1209 1210 1171 1171 1210 1172 1210 1211 1172
             1172 1211 1173 1211 1212 1173 1173 1212 1174 1212 1213 1174
             1174 1213 1175 1213 1214 1175 1175 1214 1176 1214 1215 1176
             1176 1215 1177 1215 1216 1177 1177 1216 1178 1216 1217 1178
             1178 1217 1179 1217 1218 1179 1179 1218 1180 1218 1219 1180
             1180 1219 1181 1219 1220 1181 1181 1220 1182 1220 1221 1182
             1182 1221 1183 1221 1222 1183 1183 1222 1184 1222 1223 1184
             1184 1223 1185 1223 1224 1185 1185 1224 1186 1224 1225 1186
             1186 1225 1187 1225 1226 1187 1187 1226 1188 1226 1227 1188
             1188 1227 1189 1227 1228 1189 1189 1228 1190 1228 1229 1190
             1190 1229 1191 1229 1230 1191 1191 1230 1192 1230 1231 1192
             1192 1231 1193 1231 1232 1193 1193 1232 1194 1232 1233 1194
             1194 1233 1195 1233 1234 1195 1195 1234 1196 1234 1235 1196
             1196 1235 1197 1235 1236 1197 1197 1236 1198 1236 1237 1198
             1198 1237 1199 1237 1238 1199 1199 1238 1200 1238 1239 1200
             1200 1239 1201 1239 1240 1201 1201 1240 1202 1240 1241 1202
             1202 1241 1203 1241 1242 1203 1203 1242 1204 1242 1243 1204
             1204 1243 1205 1243 1244 1205 1205 1244 1206 1244 1245 1206
             1206 1245 1207 1245 1246 1207 1207 1246 1208 1246 1247 1208
             1209 1248 1210 1248 1249 1210 1210 1249 1211 1249 1250 1211
             1211 1250 1212 1250 1251 1212 1212 1251 1213 1251 1252 1213
             1213 1252 1214 1252 1253 1214 1214 1253 1215 1253 1254 1215
             1215 1254 1216 1254 1255 1216 1216 1255 1217 1255 1256 1217
             1217 1256 1218 1256 1257 1218 1218 1257 1219 1257 1258 1219
             1219 1258 1220 1258 1259 1220 1220 1259 1221 1259 1260 1221
             1221 1260 1222 1260 1261 1222 1222 1261 1223 1261 1262 1223
             1223 1262 1224 1262 1263 1224 1224 1263 1225 1263 1264 1225
             1225 1264 1226 1264 1265 1226 1226 1265 1227 1265 1266 1227
             1227 1266 1228 1266 1267 1228 1228 1267 1229 1267 1268 1229
             1229 1268 1230 1268 1269 1230 1230 1269 1231 1269 1270 1231
             1231 1270 1232 1270 1271 1232 1232 1271 1233 1271 1272 1233
             1233 1272 1234 1272 1273 1234 1234 1273 1235 1273 1274 1235
             1235 1274 1236 1274 1275 1236 1236 1275 1237 1275 1276 1237
             1237 1276 1238 1276 1277 1238 1238 1277 1239 1277 1278 1239
             1239 1278 1240 1278 1279 1240 1240 1279 1241 1279 1280 1241
             1241 1280 1242 1280 1281 1242 1242 1281 1243 1281 1282 1243
             1243 1282 1244 1282 1283 1244 1244 1283 1245 1283 1284 1245
             1245 1284 1246 1284 1285 1246 1246 1285 1247 1285 1286 1247
             1248 1287 1249 1287 1288 1249 1249 1288 1250 1288 1289 1250
             1250 1289 1251 1289 1290 1251 1251 1290 1252 1290 1291 1252
             1252 1291 1253 1291 1292 1253 1253 1292 1254 1292 1293 1254
             1254 1293 1255 1293 1294 1255 1255 1294 1256 1294 1295 1256
             1256 1295 1257 1295 1296 1257 1257 1296 1258 1296 1297 1258
             1258 1297 1259 1297 1298 1259 1259 1298 1260 1298 1299 1260
             1260 1299 1261 1299 1300 1261 1261 1300 1262 1300 1301 1262
             1262 1301 1263 1301 1302 1263 1263 1302 1264 1302 1303 1264
             1264 1303 1265 1303 1304 1265 1265 1304 1266 1304 1305 1266
             1266 1305 1267 1305 1306 1267 1267 1306 1268 1306 1307 1268
             1268 1307 1269 1307 1308 1269 1269 1308 1270 1308 1309 1270
             1270 1309 1271 1309 1310 1271 1271 1310 1272 1310 1311 1272
             1272 1311 1273 1311 1312 1273 1273 1312 1274 1312 1313 1274
             1274 1313 1275 1313 1314 1275 1275 1314 1276 1314 1315 1276
             1276 1315 1277 1315 1316 1277 1277 1316 1278 1316 1317 1278
             1278 1317 1279 1317 1318 1279 1279 1318 1280 1318 1319 1280
             1280 1319 1281 1319 1320 1281 1281 1320 1282 1320 1321 1282
             1282 1321 1283 1321 1322 1283 1283 1322 1284 1322 1323 1284
             1284 1323 1285 1323 1324 1285 1285 1324 1286 1324 1325 1286
             1287 1326 1288 1326 1327 1288 1288 1327 1289 1327 1328 1289
             1289 1328 1290 1328 1329 1290 1290 1329 1291 1329 1330 1291
             1291 1330 1292 1330 1331 1292 1292 1331 1293 1331 1332 1293
             1293 1332 1294 1332 1333 1294 1294 1333 1295 1333 1334 1295
             1295 1334 1296 1334 1335 1296 1296 1335 1297 1335 1336 1297
             1297 1336 1298 1336 1337 1298 1298 1337 1299 1337 1338 1299
             1299 1338 1300 1338 1339 1300 1300 1339 1301 1339 1340 1301
             1301 1340 1302 1340 1341 1302 1302 1341 1303 1341 1342 1303
             1303 1342 1304 1342 1343 1304 1304 1343 1305 1343 1344 1305
             1305 1344 1306 1344 1345 1306 1306 1345 1307 1345 1346 1307
             1307 1346 1308 1346 1347 1308 1308 1347 1309 1347 1348 1309
             1309 1348 1310 1348 1349 1310 1310 1349 1311 1349 1350 1311
             1311 1350 1312 1350 1351 1312 1312 1351 1313 1351 1352 1313
             1313 1352 1314 1352 1353 1314 1314 1353 1315 1353 1354 1315
             1315 1354 1316 1354 1355 1316 1316 1355 1317 1355 1356 1317
             1317 1356 1318 1356 1357 1318 1318 1357 1319 1357 1358 1319
             1319 1358 1320 1358 1359 1320 1320 1359 1321 1359 1360 1321
             1321 1360 1322 1360 1361 1322 1322 1361 1323 1361 1362 1323
             1323 1362 1324 1362 1363 1324 1324 1363 1325 1363 1364 1325
             1326 1365 1327 1365 1366 1327 1327 1366 1328 1366 1367 1328
             1328 1367 1329 1367 1368 1329 1329 1368 1330 1368 1369 1330
             1330 1369 1331 1369 1370 1331 1331 1370 1332 1370 1371 1332
             1332 1371 1333 1371 1372 1333 1333 1372 1334 1372 1373 1334
             1334 1373 1335 1373 1374 1335 1335 1374 1336 1374 1375 1336
             1336 1375 1337 1375 1376 1337 1337 1376 1338 1376 1377 1338
             1338 1377 1339 1377 1378 1339 1339 1378 1340 1378 1379 1340
             1340 1379 1341 1379 1380 1341 1341 1380 1342 1380 1381 1342
             1342 1381 1343 1381 1382 1343 1343 1382 1344 1382 1383 1344
             1344 1383 1345 1383 1384 1345 1345 1384 1346 1384 1385 1346
             1346 1385 1347 1385 1386 1347 1347 1386 1348 1386 1387 1348
             1348 1387 1349 1387 1388 1349 1349 1388 1350 1388 1389 1350
             1350 1389 1351 1389 1390 1351 1351 1390 1352 1390 1391 1352
             1352 1391 1353 1391 1392 1353 1353 1392 1354 1392 1393 1354
             1354 1393 1355 1393 1394 1355 1355 1394 1356 1394 1395 1356
             1356 1395 1357 1395 1396 1357 1357 1396 1358 1396 1397 1358
             1358 1397 1359 1397 1398 1359 1359 1398 1360 1398 1399 1360
             1360 1399 1361 1399 1400 1361 1361 1400 1362 1400 1401 1362
             1362 1401 1363 1401 1402 1363 1363 1402 1364 1402 1403 1364
             1365 1404 1366 1404 1405 1366 1366 1405 1367 1405 1406 1367
             1367 1406 1368 1406 1407 1368 1368 1407 1369 1407 1408 1369
             1369 1408 1370 1408 1409 1370 1370 1409 1371 1409 1410 1371
             1371 1410 1372 1410 1411 1372 1372 1411 1373 1411 1412 1373
             1373 1412 1374 1412 1413 1374 1374 1413 1375 1413 1414 1375
             1375 1414 1376 1414 1415 1376 1376 1415 1377 1415 1416 1377
             1377 1416 1378 1416 1417 1378 1378 1417 1379 1417 1418 1379
             1379 1418 1380 1418 1419 1380 1380 1419 1381 1419 1420 1381
             1381 1420 1382 1420 1421 1382 1382 1421 1383 1421 1422 1383
             1383 1422 1384 1422 1423 1384 1384 1423 1385 1423 1424 1385
             1385 1424 1386 1424 1425 1386 1386 1425 1387 1425 1426 1387
             1387 1426 1388 1426 1427 1388 1388 1427 1389 1427 1428 1389
             1389 1428 1390 1428 1429 1390 1390 1429 1391 1429 1430 1391
             1391 1430 1392 1430 1431 1392 1392 1431 1393 1431 1432 1393
             1393 1432 1394 1432 1433 1394 1394 1433 1395 1433 1434 1395
             1395 1434 1396 1434 1435 1396 1396 1435 1397 1435 1436 1397
             1397 1436 1398 1436 1437 1398 1398 1437 1399 1437 1438 1399
             1399 1438 1400 1438 1439 1400 1400 1439 1401 1439 1440 1401
             1401 1440 1402 1440 1441 1402 1402 1441 1403 1441 1442 1403
          }
          indexCount 8208
          instanceCount 1
          firstIndex 0
          vertexOffset 0
          firstInstance 0
        }
        stateCommands 2
        vsg::StateCommand id=807 vsg::BindGraphicsPipeline
        {
          userObjects 0
          slot 0
          pipeline id=808 vsg::GraphicsPipeline
          {
            userObjects 0
            layout id=809 vsg::PipelineLayout
            {
              userObjects 0
              flags 0
              setLayouts 1
              descriptorLayout id=810 vsg::DescriptorSetLayout
              {
                userObjects 0
                bindings 1
                binding 0
                descriptorType 1
                descriptorCount 1
                stageFlags 16
              }
              pushConstantRanges 1
              stageFlags 1
              offset 0
              size 128
            }
            stages 2
            vsg::ShaderStage id=811 vsg::ShaderStage
            {
              userObjects 0
              stage 1
              entryPointName "main"
              module id=812 vsg::ShaderModule
              {
                userObjects 0
                hints id=0
                source "#version 450
#pragma import_defines ( VSG_NORMAL, VSG_TANGENT, VSG_COLOR, VSG_TEXCOORD0, VSG_LIGHTING, VSG_NORMAL_MAP, VSG_BILLBOARD, VSG_TRANSLATE )
#define VSG_COLOR
#define VSG_TEXCOORD0
#extension GL_ARB_separate_shader_objects : enable
layout(push_constant) uniform PushConstants {
    mat4 projection;
    mat4 modelView;
    //mat3 normal;
} pc;
layout(location = 0) in vec3 osg_Vertex;
#ifdef VSG_NORMAL
layout(location = 1) in vec3 osg_Normal;
layout(location = 1) out vec3 normalDir;
#endif
#ifdef VSG_TANGENT
layout(location = 2) in vec4 osg_Tangent;
#endif
#ifdef VSG_COLOR
layout(location = 3) in vec4 osg_Color;
layout(location = 3) out vec4 vertColor;
#endif
#ifdef VSG_TEXCOORD0
layout(location = 4) in vec2 osg_MultiTexCoord0;
layout(location = 4) out vec2 texCoord0;
#endif
#ifdef VSG_LIGHTING
layout(location = 5) out vec3 viewDir;
layout(location = 6) out vec3 lightDir;
#endif
#ifdef VSG_TRANSLATE
layout(location = 7) in vec3 translate;
#endif


out gl_PerVertex{ vec4 gl_Position; };

void main()
{
    mat4 modelView = pc.modelView;

#ifdef VSG_TRANSLATE
    mat4 translate_mat = mat4(1.0, 0.0, 0.0, 0.0,
                              0.0, 1.0, 0.0, 0.0,
                              0.0, 0.0, 1.0, 0.0,
                              translate.x,  translate.y,  translate.z, 1.0);

    modelView = modelView * translate_mat;
#endif

#ifdef VSG_BILLBOARD
    vec3 lookDir = vec3(-modelView[0][2], -modelView[1][2], -modelView[2][2]);

    // rotate around local z axis
    float l = length(lookDir.xy);
    if (l>0.0)
    {
        float inv = 1.0/l;
        float c = lookDir.y * inv;
        float s = lookDir.x * inv;

        mat4 rotation_z = mat4(c,   -s,  0.0, 0.0,
                               s,   c,   0.0, 0.0,
                               0.0, 0.0, 1.0, 0.0,
                               0.0, 0.0, 0.0, 1.0);

        modelView = modelView * rotation_z;
    }
#endif

    gl_Position = (pc.projection * modelView) * vec4(osg_Vertex, 1.0);

#ifdef VSG_TEXCOORD0
    texCoord0 = osg_MultiTexCoord0.st;
#endif
#ifdef VSG_NORMAL
    vec3 n = (modelView * vec4(osg_Normal, 0.0)).xyz;
    normalDir = n;
#endif
#ifdef VSG_LIGHTING
    vec4 lpos = /*osg_LightSource.position*/ vec4(0.0, 0.25, 1.0, 0.0);
#ifdef VSG_NORMAL_MAP
    vec3 t = (modelView * vec4(osg_Tangent.xyz, 0.0)).xyz;
    vec3 b = cross(n, t);
    vec3 dir = -vec3(modelView * vec4(osg_Vertex, 1.0));
    viewDir.x = dot(dir, t);
    viewDir.y = dot(dir, b);
    viewDir.z = dot(dir, n);
    if (lpos.w == 0.0)
        dir = lpos.xyz;
    else
        dir += lpos.xyz;
    lightDir.x = dot(dir, t);
    lightDir.y = dot(dir, b);
    lightDir.z = dot(dir, n);
#else
    viewDir = -vec3(modelView * vec4(osg_Vertex, 1.0));
    if (lpos.w == 0.0)
        lightDir = lpos.xyz;
    else
        lightDir = lpos.xyz + viewDir;
#endif
#endif
#ifdef VSG_COLOR
    vertColor = osg_Color;
#endif
}

"
                code 377
                 119734787 65536 524298 49 0 131089 1 393227 1 1280527431 1685353262 808793134
                 0 196622 0 1 720911 0 4 1852399981 0 21 29 41
                 43 45 47 196611 2 450 589828 1096764487 1935622738 1918988389 1600484449 1684105331
                 1868526181 1667590754 29556 262149 4 1852399981 0 327685 10 1701080941 1701402220 119
                 393221 11 1752397136 1936617283 1953390964 115 393222 11 0 1785688688 1769235301 28271
                 393222 11 1 1701080941 1701402220 119 196613 13 25456 393221 19 1348430951
                 1700164197 2019914866 0 393222 19 0 1348430951 1953067887 7237481 196613 21 0
                 327685 29 1600615279 1953654102 30821 327685 41 1131963764 1685221231 48 458757 43
                 1600615279 1953264973 2019906665 1919905603 12388 327685 45 1953654134 1869377347 114 327685 47
                 1600615279 1869377347 114 262216 11 0 5 327752 11 0 35 0
                 327752 11 0 7 16 262216 11 1 5 327752 11 1
                 35 64 327752 11 1 7 16 196679 11 2 327752 19
                 0 11 0 196679 19 2 262215 29 30 0 262215 41
                 30 4 262215 43 30 4 262215 45 30 3 262215 47
                 30 3 131091 2 196641 3 2 196630 6 32 262167 7
                 6 4 262168 8 7 4 262176 9 7 8 262174 11
                 8 8 262176 12 9 11 262203 12 13 9 262165 14
                 32 1 262187 14 15 1 262176 16 9 8 196638 19
                 7 262176 20 3 19 262203 20 21 3 262187 14 22
                 0 262167 27 6 3 262176 28 1 27 262203 28 29
                 1 262187 6 31 1065353216 262176 37 3 7 262167 39 6
)"
        R"(                 2 262176 40 3 39 262203 40 41 3 262176 42 1
                 39 262203 42 43 1 262203 37 45 3 262176 46 1
                 7 262203 46 47 1 327734 2 4 0 3 131320 5
                 262203 9 10 7 327745 16 17 13 15 262205 8 18
                 17 196670 10 18 327745 16 23 13 22 262205 8 24
                 23 262205 8 25 10 327826 8 26 24 25 262205 27
                 30 29 327761 6 32 30 0 327761 6 33 30 1
                 327761 6 34 30 2 458832 7 35 32 33 34 31
                 327825 7 36 26 35 327745 37 38 21 22 196670 38
                 36 262205 39 44 43 196670 41 44 262205 7 48 47
                 196670 45 48 65789 65592
              }
              NumSpecializationConstants 0
            }
            vsg::ShaderStage id=813 vsg::ShaderStage
            {
              userObjects 0
              stage 16
              entryPointName "main"
              module id=814 vsg::ShaderModule
              {
                userObjects 0
                hints id=0
                source "#version 450
#pragma import_defines ( VSG_NORMAL, VSG_COLOR, VSG_TEXCOORD0, VSG_LIGHTING, VSG_MATERIAL, VSG_DIFFUSE_MAP, VSG_OPACITY_MAP, VSG_AMBIENT_MAP, VSG_NORMAL_MAP, VSG_SPECULAR_MAP )
#define VSG_COLOR
#define VSG_TEXCOORD0
#define VSG_DIFFUSE_MAP
#extension GL_ARB_separate_shader_objects : enable
#ifdef VSG_DIFFUSE_MAP
layout(binding = 0) uniform sampler2D diffuseMap;
#endif
#ifdef VSG_OPACITY_MAP
layout(binding = 1) uniform sampler2D opacityMap;
#endif
#ifdef VSG_AMBIENT_MAP
layout(binding = 4) uniform sampler2D ambientMap;
#endif
#ifdef VSG_NORMAL_MAP
layout(binding = 5) uniform sampler2D normalMap;
#endif
#ifdef VSG_SPECULAR_MAP
layout(binding = 6) uniform sampler2D specularMap;
#endif

#ifdef VSG_MATERIAL
layout(binding = 10) uniform MaterialData
{
    vec4 ambientColor;
    vec4 diffuseColor;
    vec4 specularColor;
    float shininess;
} material;
#endif

#ifdef VSG_NORMAL
layout(location = 1) in vec3 normalDir;
#endif
#ifdef VSG_COLOR
layout(location = 3) in vec4 vertColor;
#endif
#ifdef VSG_TEXCOORD0
layout(location = 4) in vec2 texCoord0;
#endif
#ifdef VSG_LIGHTING
layout(location = 5) in vec3 viewDir;
layout(location = 6) in vec3 lightDir;
#endif
layout(location = 0) out vec4 outColor;

void main()
{
#ifdef VSG_DIFFUSE_MAP
    vec4 base = texture(diffuseMap, texCoord0.st);
#else
    vec4 base = vec4(1.0,1.0,1.0,1.0);
#endif
#ifdef VSG_COLOR
    base = base * vertColor;
#endif
#ifdef VSG_MATERIAL
    vec3 ambientColor = material.ambientColor.rgb;
    vec3 diffuseColor = material.diffuseColor.rgb;
    vec3 specularColor = material.specularColor.rgb;
    float shininess = material.shininess;
#else
    vec3 ambientColor = vec3(0.1,0.1,0.1);
    vec3 diffuseColor = vec3(1.0,1.0,1.0);
    vec3 specularColor = vec3(0.3,0.3,0.3);
    float shininess = 16.0;
#endif
#ifdef VSG_AMBIENT_MAP
    ambientColor *= texture(ambientMap, texCoord0.st).r;
#endif
#ifdef VSG_SPECULAR_MAP
    specularColor = texture(specularMap, texCoord0.st).rrr;
#endif
#ifdef VSG_LIGHTING
#ifdef VSG_NORMAL_MAP
    vec3 nDir = texture(normalMap, texCoord0.st).xyz*2.0 - 1.0;
    nDir.g = -nDir.g;
#else
    vec3 nDir = normalDir;
#endif
    vec3 nd = normalize(nDir);
    vec3 ld = normalize(lightDir);
    vec3 vd = normalize(viewDir);
    vec4 color = vec4(0.01, 0.01, 0.01, 1.0);
    color.rgb += ambientColor;
    float diff = max(dot(ld, nd), 0.0);
    color.rgb += diffuseColor * diff;
    color *= base;
    if (diff > 0.0)
    {
        vec3 halfDir = normalize(ld + vd);
        color.rgb += base.a * specularColor *
            pow(max(dot(halfDir, nd), 0.0), shininess);
    }
#else
    vec4 color = base;
    color.rgb *= diffuseColor;
#endif
    outColor = color;
#ifdef VSG_OPACITY_MAP
    outColor.a *= texture(opacityMap, texCoord0.st).r;
#endif
    if (outColor.a==0.0) discard;
}

"
                code 431
                 119734787 65536 524298 68 0 131089 1 393227 1 1280527431 1685353262 808793134
                 0 196622 0 1 524303 4 4 1852399981 0 17 22 56
                 196624 4 7 196611 2 450 589828 1096764487 1935622738 1918988389 1600484449 1684105331
                 1868526181 1667590754 29556 262149 4 1852399981 0 262149 9 1702060386 0 327685
                 13 1717987684 1298494325 28769 327685 17 1131963764 1685221231 48 327685 22 1953654134
                 1869377347 114 393221 27 1768058209 1131703909 1919904879 0 393221 30 1717987684 1130722165
                 1919904879 0 393221 33 1667592307 1918987381 1869377347 114 327685 37 1852401779 1936027241
                 115 262149 39 1869377379 114 327685 56 1131705711 1919904879 0 262215 13
                 34 0 262215 13 33 0 262215 17 30 4 262215 22
                 30 3 262215 56 30 0 131091 2 196641 3 2 196630
                 6 32 262167 7 6 4 262176 8 7 7 589849 10
                 6 1 0 0 0 1 0 196635 11 10 262176 12
                 0 11 262203 12 13 0 262167 15 6 2 262176 16
                 1 15 262203 16 17 1 262176 21 1 7 262203 21
                 22 1 262167 25 6 3 262176 26 7 25 262187 6
                 28 1036831949 393260 25 29 28 28 28 262187 6 31 1065353216
                 393260 25 32 31 31 31 262187 6 34 1050253722 393260 25
                 35 34 34 34 262176 36 7 6 262187 6 38 1098907648
                 262165 45 32 0 262187 45 46 0 262187 45 49 1
                 262187 45 52 2 262176 55 3 7 262203 55 56 3
                 262187 45 58 3 262176 59 3 6 262187 6 62 0
                 131092 63 327734 2 4 0 3 131320 5 262203 8 9
                 7 262203 26 27 7 262203 26 30 7 262203 26 33
                 7 262203 36 37 7 262203 8 39 7 262205 11 14
                 13 262205 15 18 17 327767 7 19 14 18 196670 9
                 19 262205 7 20 9 262205 7 23 22 327813 7 24
                 20 23 196670 9 24 196670 27 29 196670 30 32 196670
                 33 35 196670 37 38 262205 7 40 9 196670 39 40
                 262205 25 41 30 262205 7 42 39 524367 25 43 42
                 42 0 1 2 327813 25 44 43 41 327745 36 47
                 39 46 327761 6 48 44 0 196670 47 48 327745 36
                 50 39 49 327761 6 51 44 1 196670 50 51 327745
                 36 53 39 52 327761 6 54 44 2 196670 53 54
                 262205 7 57 39 196670 56 57 327745 59 60 56 58
                 262205 6 61 60 327860 63 64 61 62 196855 66 0
                 262394 64 65 66 131320 65 65788 131320 66 65789 65592
              }
              NumSpecializationConstants 0
            }
            pipelineStates 6
            vsg::GraphicsPipelineState id=815 vsg::VertexInputState
            {
              userObjects 0
              NumBindings 3
              binding 0
              stride 12
              inputRate 0
              binding 1
              stride 16
              inputRate 1
              binding 2
              stride 8
              inputRate 0
              NumAttributes 3
              location 0
              binding 0
              format 106
              offset 0
              location 3
              binding 1
              format 109
              offset 0
              location 4
              binding 2
              format 103
              offset 0
            }
            vsg::GraphicsPipelineState id=816 vsg::InputAssemblyState
            {
              userObjects 0
              topology 3
              primitiveRestartEnable 0
            }
            vsg::GraphicsPipelineState id=817 vsg::RasterizationState
            {
              userObjects 0
              depthClampEnable 0
              rasterizerDiscardEnable 0
              polygonMode 0
              cullMode 2
              frontFace 0
              depthBiasEnable 0
              depthBiasConstantFactor 1
              depthBiasClamp 0
              depthBiasSlopeFactor 1
              lineWidth 1
            }
            vsg::GraphicsPipelineState id=818 vsg::MultisampleState
            {
              userObjects 0
              rasterizationSamples 1
              sampleShadingEnable 0
              minSampleShading 0
              NumSampleMask 0
              alphaToCoverageEnable 0
              alphaToOneEnable 0
            }
            vsg::GraphicsPipelineState id=819 vsg::ColorBlendState
            {
              userObjects 0
              logicOp 3
              logicOpEnable 0
              NumColorBlendAttachments 1
              blendEnable 0
              srcColorBlendFactor 0
              dstColorBlendFactor 0
              colorBlendOp 0
              srcAlphaBlendFactor 0
              dstAlphaBlendFactor 0
              alphaBlendOp 0
              colorWriteMask 15
              blendConstants 0 0 0 0
            }
            vsg::GraphicsPipelineState id=820 vsg::DepthStencilState
            {
              userObjects 0
              depthTestEnable 1
              depthWriteEnable 1
              depthCompareOp 4
              depthBoundsTestEnable 0
              stencilTestEnable 0
              front.failOp 0
              front.passOp 0
              front.depthFailOp 0
              front.compareOp 0
              front.compareMask 0
              front.writeMask 0
              front.reference 0
              back.failOp 0
              back.passOp 0
              back.depthFailOp 0
              back.compareOp 0
              back.compareMask 0
              back.writeMask 0
              back.reference 0
              minDepthBounds 0
              maxDepthBounds 1
            }
            subpass 0
          }
        }
        vsg::StateCommand id=821 vsg::BindDescriptorSet
        {
          userObjects 0
          slot 1
          layout id=809
          firstSet 0
          descriptorSet id=822 vsg::DescriptorSet
          {
            userObjects 0
            setLayout id=810
            descriptors 1
            vsg::Descriptor id=823 vsg::DescriptorImage
            {
              userObjects 0
              dstBinding 0
              dstArrayElement 0
              images 1
              sampler id=824 vsg::Sampler
              {
                flags 0
                minFilter 1
                magFilter 1
                mipmapMode 1
                addressModeU 2
                addressModeV 2
                addressModeW 2
                mipLodBias 0
                anisotropyEnable 0
                maxAnisotropy 1
                compareEnable 0
                compareOp 0
                minLod 0
                maxLod 9
                borderColor 1
                unnormalizedCoordinates 0
              }
              image id=825 vsg::ubvec4Array2D
              {
                userObjects 0
                Layout 37 4 1 1 1 1 2 -1
                width 256
                height 256
                storage id=0
                data 109 87 49 255 106 85 51 255 107 85 49 255
                 103 79 44 255 87 66 39 255 85 63 39 255
                 86 64 40 255 75 58 36 255 70 51 35 255
                 68 50 33 255 65 48 32 255 64 48 32 255
                 63 47 33 255 68 51 33 255 71 51 34 255
                 71 50 35 255 71 50 33 255 69 52 33 255
                 66 52 34 255 67 51 35 255 68 51 33 255
                 66 50 34 255 59 45 30 255 62 48 32 255
                 62 47 33 255 57 44 30 255 54 43 30 255
                 52 40 28 255 53 40 29 255 54 43 30 255
                 55 42 29 255 60 44 31 255 61 46 31 255
                 59 45 30 255 59 45 30 255 61 46 32 255
                 66 50 34 255 67 50 34 255 73 54 37 255
                 81 61 39 255 92 69 41 255 95 71 42 255
                 96 70 41 255 102 75 44 255 104 77 45 255
                 102 76 45 255 102 75 46 255 98 74 44 255
                 90 68 41 255 75 58 36 255 64 49 34 255
                 65 49 34 255 73 55 36 255 79 58 39 255
                 81 60 42 255 87 63 41 255 98 70 41 255
                 106 77 40 255 114 83 44 255 115 86 48 255
                 109 81 44 255 108 80 42 255 112 82 48 255
                 113 85 50 255 112 85 47 255 110 84 48 255
                 105 79 46 255 102 76 43 255 93 69 38 255
                 85 62 35 255 84 61 35 255 86 62 36 255
                 89 64 37 255 97 70 39 255 97 71 40 255
                 103 75 42 255 105 77 44 255 107 79 44 255
                 107 78 43 255 105 76 43 255 99 72 40 255
                 91 67 37 255 91 66 38 255 90 66 38 255
                 86 64 37 255 81 61 35 255 77 57 34 255
                 67 50 31 255 59 44 27 255 53 39 26 255
                 48 35 24 255 43 33 24 255 37 29 23 255
                 36 28 23 255 41 31 23 255 40 30 24 255
                 47 34 24 255 58 39 26 255 68 47 28 255
                 74 52 30 255 80 56 31 255 85 59 34 255
                 86 58 36 255 80 56 34 255 77 55 30 255
                 80 56 30 255 74 50 32 255 71 47 30 255
                 75 52 30 255 79 57 30 255 83 58 32 255
                 87 59 33 255 90 62 34 255 93 64 35 255
                 97 66 36 255 100 69 38 255 103 74 41 255
                 105 76 42 255 108 78 43 255 107 79 43 255
                 105 75 42 255 98 72 41 255 92 68 39 255
                 84 62 37 255 79 58 35 255 76 56 34 255
                 77 55 35 255 74 54 33 255 65 47 30 255
                 59 43 28 255 64 46 29 255 60 45 28 255
                 55 41 27 255 56 41 27 255 58 43 29 255
                 63 46 31 255 67 50 32 255 67 51 32 255
                 68 50 32 255 64 48 31 255 59 44 29 255
                 54 41 28 255 49 37 27 255 48 36 27 255
                 47 36 27 255 50 37 27 255 45 34 25 255
                 47 35 26 255 55 40 28 255 58 42 28 255
                 55 41 28 255 51 38 26 255 47 35 25 255
                 48 35 25 255 55 39 27 255 62 44 28 255
                 52 39 26 255 43 32 24 255 42 31 23 255
                 40 30 23 255 35 27 22 255 35 28 22 255
                 34 28 22 255 41 30 23 255 41 31 23 255
                 34 29 22 255 27 24 20 255 23 18 18 255
                 48 35 25 255 42 34 23 255 41 30 22 255
                 53 37 24 255 56 40 26 255 53 38 25 255
                 53 37 25 255 53 38 25 255 53 38 25 255
                 53 38 26 255 55 39 26 255 55 39 25 255
                 57 41 25 255 62 45 27 255 60 44 27 255
                 60 43 28 255 69 49 30 255 69 49 29 255
                 70 50 30 255 73 54 31 255 73 52 30 255
                 71 48 29 255 75 53 31 255 81 58 33 255
                 83 59 34 255 82 59 32 255 82 58 33 255
                 86 62 34 255 89 64 35 255 83 61 35 255
                 77 56 35 255 82 58 34 255 88 63 36 255
                 93 64 36 255 96 68 38 255 91 66 37 255
                 88 63 34 255 85 61 34 255 75 55 31 255
                 56 42 26 255 52 38 25 255 51 39 25 255
                 47 36 25 255 42 33 24 255 48 36 25 255
                 49 37 25 255 51 38 25 255 53 39 26 255
                 58 41 27 255 56 41 26 255 55 40 26 255
                 55 40 26 255 54 40 27 255 55 40 26 255
                 59 41 27 255 64 46 28 255 66 46 29 255
                 68 48 29 255 68 49 31 255 69 48 30 255
                 70 49 29 255 69 50 30 255 65 47 29 255
                 69 47 29 255 79 55 32 255 80 57 33 255
                 83 58 33 255 85 60 34 255 87 61 34 255
                 84 59 33 255 82 58 33 255 82 57 33 255
                 74 54 32 255 56 42 28 255 49 38 27 255
                 42 36 25 255 32 30 25 255 37 35 28 255
                 39 37 29 255 41 38 32 255 40 37 31 255
                 31 30 23 255 25 22 19 255 37 27 22 255
                 41 32 23 255 41 32 23 255 43 35 23 255
                 34 28 22 255 107 85 51 255 105 83 52 255
                 111 88 53 255 120 94 55 255 111 86 48 255
                 100 75 44 255 95 70 44 255 84 64 38 255
                 77 57 36 255 73 53 34 255 69 51 33 255
                 67 49 34 255 72 53 33 255 78 54 36 255
                 77 54 37 255 74 52 35 255 75 52 36 255
                 72 50 35 255 68 52 33 255 67 51 35 255
                 69 50 33 255 68 51 33 255 62 48 33 255
                 60 47 31 255 60 47 33 255 57 43 30 255
                 52 41 28 255 52 41 28 255 53 40 27 255
                 57 43 31 255 59 47 32 255 65 49 32 255
                 67 49 32 255 66 48 32 255 67 50 33 255
                 67 50 32 255 66 50 33 255 63 47 32 255
                 70 51 34 255 68 51 33 255 77 56 37 255
)"
        R"(                 89 66 42 255 98 73 44 255 103 77 45 255
                 104 77 44 255 102 75 43 255 97 71 43 255
                 95 71 44 255 91 71 41 255 82 64 36 255
                 69 54 31 255 68 52 32 255 73 55 34 255
                 75 58 37 255 76 59 40 255 82 60 41 255
                 90 65 40 255 99 72 38 255 105 76 42 255
                 110 81 48 255 112 83 45 255 113 84 44 255
                 114 83 47 255 114 85 47 255 113 86 48 255
                 108 82 46 255 101 75 43 255 100 74 43 255
                 95 71 39 255 93 68 37 255 93 66 37 255
                 90 64 36 255 91 66 39 255 95 69 39 255
                 92 67 38 255 103 75 42 255 105 78 43 255
                 103 76 43 255 107 78 44 255 107 77 43 255
                 103 75 41 255 95 69 38 255 92 67 38 255
                 90 66 37 255 88 64 36 255 83 61 36 255
                 79 58 34 255 70 51 32 255 61 45 28 255
                 52 39 25 255 45 34 24 255 45 34 24 255
                 37 29 22 255 35 27 22 255 39 30 22 255
                 37 28 22 255 39 29 22 255 45 32 23 255
                 52 37 26 255 61 43 29 255 68 48 28 255
                 79 55 30 255 84 58 33 255 76 54 33 255
                 68 49 29 255 69 50 28 255 69 48 30 255
                 71 46 30 255 71 47 30 255 77 54 31 255
                 81 56 32 255 81 55 31 255 81 57 31 255
                 85 59 33 255 91 63 35 255 96 68 38 255
                 101 73 41 255 104 75 42 255 106 78 43 255
                 107 78 43 255 104 75 42 255 99 73 41 255
                 94 69 40 255 87 64 37 255 78 57 34 255
                 71 52 33 255 73 52 33 255 73 52 32 255
                 63 46 30 255 56 41 27 255 60 43 29 255
                 60 44 29 255 57 42 28 255 59 43 28 255
                 60 44 28 255 64 46 31 255 68 49 32 255
                 67 49 31 255 66 48 31 255 63 47 30 255
                 56 43 28 255 50 39 27 255 46 35 26 255
                 44 34 26 255 44 33 25 255 45 34 26 255
                 42 33 25 255 41 31 25 255 50 36 27 255
                 54 40 27 255 52 39 27 255 50 38 26 255
                 49 36 25 255 52 37 26 255 55 39 26 255
                 46 34 25 255 40 30 23 255 43 31 24 255
                 40 31 23 255 38 29 23 255 39 30 23 255
                 28 25 20 255 23 20 19 255 43 31 23 255
                 35 29 21 255 18 16 17 255 30 23 19 255
                 40 28 21 255 52 37 25 255 48 36 24 255
                 49 35 24 255 54 40 26 255 53 38 26 255
                 55 38 26 255 59 41 27 255 57 41 26 255
                 56 40 25 255 54 39 26 255 60 43 27 255
                 60 43 27 255 58 42 26 255 61 45 28 255
                 63 45 28 255 60 44 27 255 65 46 28 255
                 71 50 29 255 77 54 32 255 78 56 33 255
                 76 55 33 255 70 50 30 255 60 43 29 255
                 73 50 32 255 85 60 35 255 92 66 36 255
                 89 65 37 255 77 58 34 255 74 54 34 255
                 76 56 33 255 77 56 33 255 84 60 34 255
                 91 64 36 255 92 64 36 255 93 66 37 255
                 91 64 36 255 86 62 35 255 81 58 33 255
                 74 54 32 255 61 46 27 255 53 40 26 255
                 51 39 25 255 46 36 25 255 43 33 24 255
                 45 34 23 255 43 32 23 255 44 32 24 255
                 56 40 26 255 60 42 27 255 62 44 27 255
                 61 44 28 255 58 42 27 255 53 40 26 255
                 56 40 27 255 59 42 28 255 65 45 29 255
                 68 48 30 255 70 50 30 255 70 49 30 255
                 70 48 30 255 71 49 30 255 67 48 29 255
                 62 45 28 255 62 45 28 255 74 52 31 255
                 78 55 32 255 80 56 32 255 84 59 33 255
                 87 61 34 255 84 59 33 255 83 57 32 255
                 78 56 32 255 66 48 31 255 53 40 27 255
                 51 39 27 255 39 35 26 255 38 35 27 255
                 49 43 32 255 43 41 32 255 27 28 25 255
                 14 15 18 255 20 20 19 255 28 23 20 255
                 36 28 22 255 38 30 23 255 43 32 23 255
                 50 39 26 255 42 34 23 255 114 90 53 255
                 112 89 55 255 115 91 56 255 121 97 59 255
                 124 99 59 255 120 95 53 255 110 84 47 255
                 97 72 42 255 87 64 38 255 82 61 37 255
                 73 55 36 255 74 55 36 255 82 59 38 255
                 80 58 36 255 74 57 34 255 73 57 33 255
                 70 53 33 255 69 49 34 255 69 49 34 255
                 68 51 33 255 68 50 35 255 69 52 32 255
                 66 50 33 255 64 49 33 255 64 50 34 255
                 63 48 33 255 59 45 29 255 56 44 29 255
                 56 44 29 255 61 45 31 255 67 49 33 255
                 71 52 35 255 69 54 35 255 68 53 35 255
                 71 54 35 255 73 54 34 255 73 54 35 255
                 71 52 34 255 71 52 35 255 75 55 35 255
                 78 57 36 255 78 58 37 255 81 59 38 255
                 86 63 40 255 95 71 45 255 101 77 45 255
                 99 74 43 255 96 71 41 255 96 71 42 255
                 90 66 39 255 81 59 36 255 79 57 36 255
                 81 59 36 255 78 59 35 255 74 59 36 255
                 77 58 40 255 83 61 42 255 92 66 37 255
                 100 73 40 255 102 75 46 255 106 78 44 255
                 115 85 45 255 114 84 45 255 111 83 45 255
                 108 81 46 255 106 81 46 255 105 79 43 255
                 100 74 42 255 95 70 39 255 95 68 39 255
                 94 67 39 255 92 65 37 255 88 64 36 255
                 94 68 37 255 99 71 38 255 106 78 43 255
                 106 78 43 255 106 78 44 255 108 80 44 255
                 107 79 43 255 107 80 45 255 103 76 44 255
                 97 71 41 255 93 69 38 255 90 66 38 255
                 83 62 36 255 78 57 34 255 73 53 32 255
                 66 48 29 255 56 42 27 255 49 37 25 255
                 47 35 24 255 43 32 22 255 39 30 22 255
                 42 32 23 255 42 32 24 255 47 34 24 255
                 49 36 23 255 48 35 23 255 49 35 26 255
                 58 40 28 255 66 46 27 255 70 48 28 255
                 71 50 31 255 63 45 29 255 58 43 26 255
                 68 48 28 255 72 50 30 255 75 49 31 255
                 78 52 30 255 81 55 31 255 81 55 30 255
                 79 55 31 255 82 56 32 255 89 60 33 255
                 92 65 37 255 97 69 41 255 101 72 42 255
                 102 74 42 255 107 78 43 255 105 76 42 255
                 99 73 39 255 95 70 38 255 84 62 36 255
                 73 53 34 255 67 48 31 255 67 47 31 255
                 68 49 31 255 65 46 30 255 58 43 27 255
                 54 40 27 255 62 45 28 255 64 48 29 255
                 68 50 31 255 69 50 32 255 70 51 32 255
                 69 51 32 255 66 49 32 255 65 48 30 255
                 58 44 29 255 54 41 27 255 49 38 26 255
                 44 35 26 255 40 31 24 255 41 31 24 255
                 42 32 25 255 41 32 24 255 41 32 24 255
                 44 33 25 255 48 36 27 255 47 36 26 255
                 46 35 26 255 51 38 27 255 54 39 27 255
                 45 34 24 255 38 28 22 255 43 32 24 255
                 40 31 23 255 34 27 22 255 39 30 24 255
                 36 30 23 255 21 21 19 255 18 16 17 255
                 34 26 22 255 37 30 21 255 25 20 18 255
                 48 34 23 255 59 40 26 255 60 41 26 255
                 55 38 25 255 54 38 25 255 53 39 26 255
                 54 39 26 255 54 39 26 255 56 40 27 255
                 55 40 26 255 57 41 26 255 56 40 27 255
                 76 56 39 255 71 56 36 255 59 43 27 255
                 61 44 26 255 68 48 29 255 71 51 30 255
                 72 52 30 255 77 55 31 255 79 56 32 255
                 78 57 32 255 72 53 32 255 57 43 29 255
                 50 37 26 255 58 40 27 255 70 49 31 255
                 81 59 34 255 82 60 35 255 72 54 33 255
                 60 43 29 255 68 48 31 255 76 57 35 255
                 78 57 34 255 85 61 35 255 87 62 35 255
                 86 61 35 255 88 62 36 255 85 62 36 255
                 80 58 34 255 66 50 31 255 53 42 27 255
                 48 37 26 255 47 36 25 255 42 33 24 255
                 45 35 25 255 44 33 24 255 42 31 23 255
                 49 35 24 255 60 43 27 255 63 45 29 255
                 65 47 29 255 63 46 29 255 60 44 28 255
                 60 44 28 255 60 44 27 255 61 43 28 255
                 66 47 29 255 71 49 31 255 74 52 30 255
                 76 53 31 255 75 53 32 255 73 53 32 255
                 69 51 30 255 65 47 29 255 63 45 29 255
                 72 51 32 255 77 54 33 255 79 56 32 255
                 82 57 32 255 82 57 32 255 81 56 32 255
                 75 53 31 255 67 48 31 255 57 41 28 255
                 58 42 29 255 73 58 37 255 68 61 38 255
                 58 50 34 255 60 51 35 255 32 30 25 255
                 17 17 18 255 13 14 16 255 17 18 18 255
                 27 23 20 255 32 25 21 255 38 29 22 255
                 45 34 24 255 45 35 25 255 40 31 23 255
                 116 91 55 255 121 97 59 255 125 99 60 255
                 126 100 60 255 125 100 61 255 127 102 61 255
                 126 101 59 255 115 89 49 255 102 76 43 255
                 91 68 41 255 84 63 38 255 83 60 39 255
                 83 62 38 255 76 60 35 255 74 57 36 255
                 71 54 35 255 72 56 34 255 70 52 32 255
                 69 47 33 255 75 54 34 255 74 55 35 255
                 72 52 34 255 69 51 32 255 65 48 33 255
                 67 50 33 255 71 54 35 255 66 49 33 255
                 63 47 30 255 62 48 32 255 63 49 34 255
                 66 50 34 255 72 53 35 255 71 52 35 255
                 74 53 35 255 78 58 37 255 79 57 36 255
                 78 57 36 255 75 54 35 255 75 55 35 255
                 75 55 36 255 79 58 37 255 77 56 36 255
                 80 58 36 255 78 58 36 255 80 59 37 255
                 85 63 40 255 90 67 41 255 95 70 40 255
                 94 71 39 255 91 68 37 255 83 61 36 255
                 77 54 36 255 77 52 37 255 75 54 36 255
                 73 55 33 255 74 57 36 255 77 57 39 255
                 85 61 38 255 95 68 37 255 97 70 42 255
                 99 73 40 255 106 77 43 255 108 79 43 255
                 108 80 44 255 100 74 42 255 97 71 41 255
                 95 70 39 255 93 68 38 255 93 67 37 255
                 93 66 37 255 93 66 38 255 95 68 38 255
                 99 71 40 255 105 77 41 255 105 77 42 255
                 106 77 43 255 110 79 43 255 110 81 45 255
                 110 80 44 255 108 79 44 255 106 79 45 255
                 104 78 45 255 102 75 43 255 99 74 41 255
                 93 69 39 255 86 64 36 255 83 61 34 255
                 77 57 33 255 72 53 32 255 64 47 30 255
                 54 41 27 255 45 34 24 255 41 30 23 255
                 39 29 22 255 39 29 22 255 39 29 22 255
                 44 32 23 255 48 34 24 255 44 33 23 255
                 45 33 24 255 54 38 28 255 57 40 27 255
                 58 41 25 255 60 42 27 255 55 39 27 255
                 60 41 27 255 65 46 27 255 65 46 27 255
                 70 49 29 255 71 50 29 255 76 52 29 255
                 77 53 30 255 78 54 30 255 84 57 33 255
                 92 63 35 255 95 67 37 255 95 68 39 255
                 97 70 41 255 99 72 41 255 103 74 42 255
                 104 75 41 255 100 73 39 255 96 69 39 255
                 82 61 36 255 68 49 32 255 63 45 30 255
                 63 44 30 255 65 46 30 255 64 46 30 255
                 63 46 29 255 66 48 30 255 70 52 32 255
                 70 51 32 255 71 51 33 255 71 51 33 255
                 73 53 33 255 70 52 32 255 66 49 32 255
                 65 48 31 255 58 44 29 255 54 42 28 255
                 50 38 26 255 45 34 25 255 40 31 24 255
                 40 30 23 255 42 32 24 255 40 31 24 255
                 39 30 24 255 39 30 23 255 43 32 25 255
                 44 33 25 255 45 34 25 255 44 33 25 255
                 41 31 23 255 42 31 23 255 42 30 24 255
                 41 31 24 255 42 33 25 255 39 31 24 255
                 38 30 23 255 30 25 21 255 24 20 18 255
                 25 21 18 255 37 25 20 255 61 42 25 255
                 51 37 24 255 56 40 25 255 63 43 27 255
                 61 42 27 255 61 42 27 255 60 41 27 255
                 57 42 27 255 50 37 26 255 50 37 26 255
                 52 38 27 255 51 37 25 255 54 39 26 255
                 64 45 29 255 75 56 40 255 64 50 35 255
                 61 43 28 255 67 48 29 255 68 48 29 255
                 69 49 30 255 70 50 30 255 71 51 30 255
                 72 51 31 255 74 54 32 255 74 54 32 255
                 59 46 29 255 49 38 26 255 53 39 26 255
                 61 44 29 255 62 46 30 255 65 48 31 255
                 68 49 31 255 66 47 30 255 71 51 31 255
                 70 51 31 255 69 49 31 255 76 54 33 255
                 76 55 33 255 75 53 33 255 73 52 33 255
                 70 50 32 255 70 51 32 255 58 44 28 255
                 45 36 25 255 39 30 24 255 40 31 25 255
                 43 33 24 255 50 37 25 255 48 36 24 255
                 51 37 25 255 59 42 27 255 65 47 31 255
                 69 50 31 255 68 50 31 255 65 48 30 255
                 62 45 29 255 64 46 30 255 66 47 30 255
                 67 47 29 255 72 51 32 255 75 52 32 255
                 77 54 31 255 79 55 32 255 77 54 32 255
                 75 54 32 255 74 54 31 255 73 52 31 255
                 68 49 29 255 73 51 31 255 76 53 32 255
                 78 54 31 255 79 56 32 255 77 54 30 255
                 73 51 31 255 66 47 30 255 59 42 29 255
                 58 42 29 255 73 55 35 255 91 76 48 255
                 80 72 47 255 46 41 31 255 42 34 27 255
                 24 21 19 255 18 17 17 255 19 21 18 255
                 23 23 19 255 28 24 20 255 25 21 19 255
                 30 24 21 255 40 29 23 255 41 31 23 255
                 45 34 24 255 117 92 56 255 124 98 60 255
                 130 105 64 255 131 105 62 255 129 103 62 255
                 129 103 63 255 130 105 62 255 126 100 58 255
                 116 89 49 255 101 75 42 255 95 69 41 255
                 86 64 39 255 82 63 38 255 80 59 37 255
                 80 55 36 255 80 53 36 255 79 56 38 255
                 73 57 33 255 70 49 33 255 82 58 36 255
                 80 60 36 255 77 55 36 255 74 54 32 255
                 73 52 35 255 71 50 34 255 71 52 34 255
                 74 54 35 255 72 52 33 255 68 50 32 255
                 65 49 33 255 64 48 34 255 69 52 35 255
                 76 55 36 255 81 60 37 255 83 62 38 255
                 86 62 40 255 83 61 38 255 78 57 36 255
                 80 58 36 255 76 55 35 255 76 55 35 255
                 71 52 35 255 72 54 36 255 76 55 36 255
                 78 55 35 255 76 58 35 255 75 58 34 255
                 78 60 35 255 78 62 36 255 87 70 38 255
                 91 72 38 255 84 63 34 255 81 56 34 255
                 77 52 36 255 76 55 34 255 75 57 33 255
                 72 55 35 255 77 55 37 255 88 63 36 255
                 89 64 37 255 91 65 37 255 97 70 39 255
                 96 70 39 255 97 70 41 255 103 75 43 255
                 102 76 44 255 101 76 44 255 100 74 41 255
                 98 71 40 255 100 72 40 255 100 73 41 255
                 103 76 42 255 103 76 42 255 103 74 41 255
                 105 75 42 255 109 78 43 255 112 80 44 255
                 111 81 45 255 110 80 45 255 109 80 44 255
                 106 78 44 255 102 75 42 255 98 71 41 255
                 98 73 42 255 98 72 41 255 94 69 38 255
                 88 65 36 255 82 60 34 255 77 56 33 255
                 69 51 31 255 56 42 28 255 45 34 24 255
                 41 31 23 255 43 32 23 255 42 31 22 255
                 38 28 22 255 40 29 22 255 41 30 23 255
                 36 27 22 255 37 28 22 255 41 31 24 255
                 47 34 26 255 48 35 24 255 46 35 23 255
                 50 35 24 255 59 40 27 255 57 40 26 255
                 57 41 25 255 59 43 26 255 61 44 25 255
                 67 47 28 255 70 49 29 255 75 52 31 255
                 80 56 32 255 86 60 34 255 91 64 36 255
                 93 67 38 255 94 68 39 255 99 71 40 255
                 103 73 42 255 104 74 40 255 100 72 38 255
                 95 69 39 255 80 61 35 255 65 48 30 255
                 63 45 30 255 65 46 30 255 66 49 30 255
                 70 51 31 255 76 55 33 255 77 57 34 255
                 73 55 34 255 71 52 33 255 72 53 33 255
                 72 53 33 255 72 53 33 255 69 52 33 255
                 65 48 32 255 63 46 31 255 58 44 29 255
                 53 41 28 255 47 36 25 255 43 33 24 255
)"
        R"(                 40 31 24 255 40 31 24 255 41 31 24 255
                 36 29 23 255 34 27 23 255 36 28 23 255
                 42 32 24 255 43 32 25 255 39 30 23 255
                 37 28 23 255 43 31 23 255 44 32 24 255
                 34 28 23 255 37 28 24 255 48 36 27 255
                 44 33 25 255 41 32 24 255 39 31 23 255
                 47 34 22 255 51 36 23 255 66 44 26 255
                 76 52 29 255 66 46 27 255 64 45 29 255
                 65 46 29 255 64 44 28 255 64 44 28 255
                 63 43 27 255 57 41 27 255 49 37 26 255
                 49 37 26 255 54 39 27 255 54 40 27 255
                 56 41 26 255 65 46 30 255 66 50 34 255
                 49 38 28 255 59 41 28 255 64 47 29 255
                 62 44 29 255 65 46 30 255 65 47 29 255
                 57 42 27 255 62 44 29 255 69 50 31 255
                 77 57 33 255 44 39 26 255 37 29 23 255
                 66 47 29 255 70 52 31 255 66 48 29 255
                 61 45 27 255 59 43 28 255 67 47 29 255
                 74 52 31 255 78 56 32 255 72 52 32 255
                 67 49 30 255 62 45 29 255 61 43 28 255
                 59 43 27 255 56 41 27 255 57 41 27 255
                 52 39 26 255 35 30 23 255 32 25 21 255
                 36 27 22 255 45 33 24 255 55 40 26 255
                 56 41 26 255 62 45 29 255 69 50 31 255
                 73 52 33 255 71 53 33 255 69 51 32 255
                 67 48 30 255 65 46 29 255 66 47 30 255
                 70 49 31 255 76 53 31 255 77 55 32 255
                 77 54 32 255 75 53 32 255 76 53 31 255
                 75 53 32 255 76 54 31 255 77 54 31 255
                 74 52 31 255 69 48 29 255 72 49 30 255
                 73 50 30 255 72 50 30 255 70 49 30 255
                 70 48 29 255 65 46 29 255 59 43 28 255
                 56 41 28 255 65 49 32 255 87 70 45 255
                 95 81 52 255 65 60 39 255 26 25 22 255
                 25 20 21 255 26 21 19 255 24 21 18 255
                 24 26 20 255 25 26 20 255 29 27 21 255
                 25 23 19 255 26 21 19 255 30 24 21 255
                 35 27 22 255 47 35 25 255 121 95 58 255
                 126 99 59 255 129 103 62 255 130 105 63 255
                 131 106 64 255 131 107 63 255 128 103 62 255
                 123 99 59 255 122 96 54 255 115 88 47 255
                 105 76 42 255 91 67 40 255 87 61 39 255
                 87 59 36 255 83 56 33 255 79 51 33 255
                 80 53 37 255 78 60 37 255 76 55 35 255
                 88 62 39 255 78 58 34 255 78 55 38 255
                 80 57 34 255 82 59 37 255 77 55 36 255
                 69 50 31 255 76 55 34 255 80 57 37 255
                 79 56 35 255 79 55 33 255 77 55 33 255
                 77 56 34 255 80 58 36 255 83 62 37 255
                 90 64 39 255 94 66 43 255 88 64 39 255
                 81 59 37 255 80 59 37 255 73 53 33 255
                 68 49 32 255 67 48 32 255 68 49 34 255
                 74 52 35 255 75 57 34 255 67 52 34 255
                 68 49 33 255 65 44 31 255 58 42 31 255
                 62 48 34 255 78 63 38 255 85 68 37 255
                 92 71 38 255 93 66 40 255 89 62 38 255
                 85 63 34 255 75 58 33 255 73 53 36 255
                 74 52 33 255 78 55 32 255 83 59 35 255
                 92 66 38 255 92 66 38 255 88 62 36 255
                 89 64 39 255 95 70 45 255 106 80 48 255
                 109 81 46 255 102 75 42 255 95 69 39 255
                 91 66 38 255 93 67 38 255 96 68 38 255
                 101 71 40 255 106 77 43 255 111 81 44 255
                 112 81 44 255 108 80 43 255 107 78 43 255
                 108 77 43 255 108 77 43 255 104 76 42 255
                 98 71 39 255 95 69 39 255 96 70 40 255
                 99 72 41 255 94 69 38 255 84 61 35 255
                 77 56 33 255 73 53 31 255 63 47 30 255
                 50 40 27 255 44 34 24 255 41 32 24 255
                 38 30 23 255 37 28 22 255 36 28 22 255
                 35 27 22 255 34 26 21 255 33 26 22 255
                 35 28 22 255 37 29 23 255 37 29 23 255
                 38 30 22 255 44 33 22 255 51 36 24 255
                 52 36 27 255 55 38 28 255 53 37 25 255
                 55 39 26 255 58 40 27 255 64 43 28 255
                 74 49 30 255 81 56 32 255 84 60 35 255
                 89 63 36 255 96 68 38 255 97 69 39 255
                 99 72 40 255 101 73 41 255 103 75 40 255
                 100 72 39 255 97 70 39 255 86 64 37 255
                 76 56 33 255 73 53 31 255 71 52 31 255
                 74 54 33 255 83 60 34 255 86 62 36 255
                 84 62 35 255 79 59 35 255 74 55 34 255
                 72 54 33 255 72 53 33 255 72 52 34 255
                 69 52 32 255 65 49 31 255 58 44 29 255
                 50 38 27 255 46 35 26 255 46 35 26 255
                 45 35 25 255 40 31 24 255 38 30 24 255
                 37 29 22 255 32 26 22 255 30 24 22 255
                 36 28 23 255 42 32 24 255 37 28 22 255
                 34 26 21 255 45 32 24 255 44 33 24 255
                 33 26 21 255 28 23 20 255 33 26 22 255
                 44 32 25 255 43 31 24 255 37 30 23 255
                 33 27 23 255 59 41 27 255 72 50 29 255
                 74 51 29 255 70 49 30 255 67 46 29 255
                 67 48 30 255 72 51 32 255 67 49 31 255
                 66 48 30 255 68 48 29 255 57 42 27 255
                 56 40 27 255 53 40 26 255 55 40 27 255
                 54 40 27 255 53 40 26 255 62 44 29 255
                 61 47 31 255 43 33 24 255 47 34 24 255
                 47 35 25 255 45 33 24 255 47 35 25 255
                 54 38 26 255 61 43 28 255 73 52 31 255
                 79 57 33 255 78 58 34 255 45 39 24 255
                 49 37 24 255 72 56 34 255 75 56 34 255
                 80 59 33 255 76 55 32 255 71 53 30 255
                 71 49 30 255 75 52 31 255 79 56 32 255
                 71 51 31 255 65 46 29 255 56 40 27 255
                 59 41 27 255 57 43 28 255 50 37 26 255
                 48 36 24 255 49 37 26 255 37 30 23 255
                 35 27 22 255 43 32 23 255 48 36 26 255
                 59 42 27 255 64 45 28 255 66 48 30 255
                 71 51 31 255 77 55 33 255 72 52 32 255
                 64 47 30 255 61 44 28 255 66 47 29 255
                 69 50 31 255 74 52 32 255 80 57 33 255
                 80 57 33 255 79 56 34 255 74 54 32 255
                 73 51 31 255 74 51 32 255 77 54 31 255
                 78 55 32 255 75 53 32 255 72 50 30 255
                 70 48 29 255 67 47 29 255 62 44 27 255
                 60 43 27 255 62 43 29 255 58 42 28 255
                 57 41 27 255 64 47 31 255 82 66 42 255
                 91 77 50 255 94 78 49 255 60 54 34 255
                 24 23 20 255 30 22 19 255 34 26 20 255
                 24 23 20 255 27 31 22 255 25 31 21 255
                 28 30 22 255 28 27 21 255 26 22 20 255
                 31 24 20 255 43 32 23 255 55 41 27 255
                 122 96 56 255 123 97 59 255 124 98 59 255
                 125 100 60 255 129 103 61 255 130 104 62 255
                 129 105 62 255 120 98 58 255 115 91 54 255
                 117 91 52 255 112 86 48 255 102 75 43 255
                 95 68 40 255 87 66 37 255 87 65 36 255
                 85 60 34 255 88 58 38 255 77 57 37 255
                 78 58 35 255 89 62 40 255 82 61 36 255
                 82 61 40 255 83 60 36 255 86 62 37 255
                 81 58 38 255 74 53 33 255 80 58 33 255
                 83 60 38 255 86 60 39 255 88 62 39 255
                 86 62 38 255 85 61 38 255 86 61 38 255
                 90 65 40 255 94 67 42 255 90 66 40 255
                 83 62 38 255 81 59 37 255 84 60 38 255
                 78 57 35 255 72 53 33 255 69 50 33 255
                 68 49 33 255 73 54 34 255 75 56 35 255
                 67 46 31 255 67 43 29 255 70 44 29 255
                 66 42 31 255 59 42 32 255 65 52 35 255
                 64 53 31 255 69 52 32 255 80 56 38 255
                 93 65 42 255 95 71 38 255 88 67 35 255
                 78 58 36 255 76 53 33 255 76 53 31 255
                 77 55 34 255 79 56 34 255 85 60 35 255
                 88 62 35 255 87 62 35 255 87 62 37 255
                 95 68 40 255 102 74 42 255 101 74 41 255
                 89 65 37 255 87 63 36 255 89 63 36 255
                 94 66 37 255 102 73 42 255 107 77 43 255
                 110 79 45 255 111 81 45 255 109 80 44 255
                 107 77 42 255 110 78 43 255 111 80 44 255
                 106 77 42 255 102 73 40 255 99 71 39 255
                 94 68 38 255 97 70 40 255 98 71 39 255
                 88 65 36 255 77 57 33 255 75 54 32 255
                 72 52 32 255 62 47 30 255 53 41 26 255
                 45 35 24 255 39 31 23 255 36 28 22 255
                 37 28 22 255 35 28 22 255 32 25 21 255
                 31 25 22 255 30 25 21 255 30 25 21 255
                 31 25 22 255 33 26 21 255 39 29 21 255
                 46 33 22 255 49 34 25 255 53 37 27 255
                 52 37 27 255 55 38 27 255 60 41 28 255
                 62 42 27 255 69 46 28 255 77 54 31 255
                 83 59 34 255 86 62 36 255 91 66 38 255
                 96 69 39 255 98 71 39 255 101 73 41 255
                 100 72 41 255 96 70 39 255 96 70 40 255
                 91 68 38 255 85 63 36 255 84 61 35 255
                 84 61 36 255 85 62 36 255 87 62 35 255
                 85 62 35 255 83 61 36 255 79 58 35 255
                 76 56 34 255 72 54 32 255 68 51 32 255
                 66 49 32 255 64 48 30 255 61 47 30 255
                 55 42 29 255 48 37 27 255 44 33 25 255
                 44 34 25 255 40 32 24 255 36 29 23 255
                 34 27 23 255 32 26 22 255 32 25 21 255
                 33 26 22 255 37 27 22 255 37 28 22 255
                 35 27 22 255 42 30 23 255 41 32 24 255
                 31 26 21 255 27 22 20 255 33 25 21 255
                 41 31 23 255 45 33 24 255 46 33 24 255
                 40 32 23 255 38 29 22 255 61 42 27 255
                 66 45 28 255 65 44 28 255 67 46 29 255
                 69 48 30 255 71 50 31 255 73 52 32 255
                 68 51 33 255 64 47 31 255 67 49 30 255
                 60 44 29 255 58 42 28 255 58 42 27 255
                 57 41 27 255 55 41 27 255 54 39 26 255
                 52 38 27 255 47 37 27 255 45 33 23 255
                 49 36 24 255 45 33 24 255 42 32 23 255
                 48 35 24 255 62 43 28 255 68 47 30 255
                 72 51 33 255 78 56 33 255 80 58 34 255
                 75 56 32 255 71 55 32 255 42 38 25 255
                 57 42 29 255 81 59 34 255 80 58 33 255
                 79 58 33 255 77 55 33 255 71 51 31 255
                 69 49 30 255 64 46 29 255 64 46 29 255
                 59 42 27 255 60 42 28 255 63 44 29 255
                 57 41 26 255 53 39 24 255 47 36 25 255
                 37 29 23 255 36 27 22 255 37 28 22 255
                 38 30 23 255 51 37 26 255 62 44 29 255
                 64 46 29 255 66 47 29 255 73 52 32 255
                 73 54 33 255 67 50 31 255 66 48 30 255
                 68 48 30 255 73 51 32 255 76 54 33 255
                 80 57 33 255 81 58 34 255 80 57 34 255
                 78 56 34 255 75 53 33 255 74 51 32 255
                 76 54 32 255 75 52 31 255 72 50 31 255
                 69 49 29 255 67 46 29 255 63 44 27 255
                 54 39 25 255 53 38 26 255 52 38 26 255
                 55 40 27 255 61 45 29 255 81 64 41 255
                 92 79 51 255 96 84 54 255 100 84 51 255
                 79 67 37 255 47 38 24 255 54 38 24 255
                 38 31 21 255 21 20 18 255 26 28 22 255
                 26 32 22 255 22 25 20 255 25 22 20 255
                 28 23 20 255 41 30 23 255 56 42 27 255
                 55 42 27 255 117 93 54 255 117 94 56 255
                 117 93 56 255 121 95 58 255 125 99 59 255
                 129 104 61 255 129 105 63 255 121 98 57 255
                 113 90 53 255 113 90 54 255 116 92 53 255
                 107 82 45 255 102 78 46 255 90 71 43 255
                 86 68 41 255 90 69 38 255 96 67 41 255
                 88 64 40 255 87 66 37 255 91 63 40 255
                 85 63 36 255 81 60 39 255 86 62 37 255
                 90 65 37 255 85 61 40 255 80 58 37 255
                 85 63 36 255 83 61 35 255 86 62 38 255
                 92 66 42 255 93 68 42 255 92 67 40 255
                 94 68 40 255 93 69 40 255 92 69 41 255
                 90 66 41 255 83 61 38 255 82 58 37 255
                 85 60 38 255 84 61 37 255 80 57 35 255
                 71 52 32 255 73 55 34 255 77 55 36 255
                 78 52 35 255 72 46 30 255 71 45 29 255
                 76 48 30 255 72 46 32 255 66 46 35 255
                 61 49 33 255 59 48 29 255 63 46 29 255
                 71 47 34 255 80 54 38 255 87 63 37 255
                 90 69 37 255 88 66 39 255 90 64 38 255
                 84 59 33 255 79 56 33 255 77 56 33 255
                 84 59 34 255 91 63 35 255 96 67 36 255
                 96 68 37 255 92 65 37 255 96 69 39 255
                 97 71 40 255 89 65 37 255 91 65 37 255
                 96 68 38 255 101 71 39 255 104 75 42 255
                 107 77 44 255 111 80 45 255 112 81 45 255
                 111 82 45 255 112 80 43 255 115 83 45 255
                 112 82 44 255 105 75 40 255 99 70 38 255
                 99 71 38 255 94 68 37 255 91 66 38 255
                 94 69 37 255 92 68 37 255 84 62 34 255
                 80 57 33 255 77 55 32 255 70 52 31 255
                 61 46 29 255 54 41 26 255 44 34 23 255
                 35 28 22 255 34 27 22 255 34 28 22 255
                 33 26 21 255 31 24 21 255 28 23 20 255
                 26 22 20 255 28 22 20 255 32 25 21 255
                 39 29 21 255 44 32 22 255 46 32 23 255
                 48 34 25 255 49 35 26 255 51 35 26 255
                 57 39 27 255 60 41 27 255 62 43 27 255
                 68 49 31 255 77 56 35 255 81 60 36 255
                 88 64 37 255 93 68 38 255 96 70 40 255
                 99 72 41 255 96 69 39 255 95 68 38 255
                 95 69 39 255 92 68 39 255 88 65 38 255
                 89 64 37 255 88 64 36 255 88 64 35 255
                 84 61 34 255 82 60 34 255 82 61 35 255
                 77 57 34 255 71 53 34 255 68 51 32 255
                 61 47 30 255 56 42 28 255 57 43 28 255
                 58 44 29 255 53 40 28 255 46 36 26 255
                 45 34 25 255 43 35 25 255 38 30 23 255
                 35 28 22 255 33 26 22 255 31 26 21 255
                 35 27 22 255 38 29 23 255 38 28 22 255
                 38 28 22 255 44 32 24 255 40 31 23 255
                 30 24 20 255 30 24 20 255 33 25 20 255
                 41 29 23 255 50 36 24 255 55 38 25 255
                 58 40 25 255 60 43 27 255 62 44 28 255
                 69 48 29 255 66 45 28 255 64 44 28 255
                 69 48 30 255 71 50 31 255 69 49 30 255
                 68 49 32 255 67 50 32 255 62 45 29 255
                 61 44 29 255 62 45 29 255 62 45 29 255
                 65 46 29 255 61 44 27 255 61 43 27 255
                 53 39 26 255 45 34 24 255 41 31 23 255
                 48 35 24 255 50 36 24 255 47 34 23 255
                 46 34 23 255 53 37 25 255 66 46 29 255
                 71 50 31 255 73 52 32 255 75 54 34 255
                 74 53 33 255 76 54 34 255 72 54 33 255
                 51 41 25 255 68 49 30 255 80 59 34 255
                 81 58 34 255 81 59 34 255 74 55 33 255
                 63 47 30 255 63 46 29 255 61 44 28 255
                 63 44 28 255 57 41 27 255 55 40 27 255
                 55 41 27 255 52 38 25 255 53 39 25 255
                 46 35 24 255 38 30 22 255 34 26 21 255
                 36 28 22 255 35 28 22 255 45 33 25 255
                 59 42 27 255 65 47 30 255 67 48 29 255
                 74 52 32 255 75 54 34 255 72 51 32 255
                 74 53 33 255 72 52 32 255 72 51 33 255
                 72 51 33 255 78 55 33 255 79 57 33 255
                 78 54 32 255 80 56 33 255 75 54 33 255
                 72 51 32 255 73 52 31 255 74 53 31 255
                 73 51 31 255 69 50 30 255 62 45 28 255
                 59 42 27 255 52 38 25 255 52 38 25 255
                 54 40 26 255 60 45 28 255 79 61 38 255
                 92 78 51 255 100 87 58 255 99 87 58 255
                 100 86 53 255 101 82 46 255 93 72 38 255
)"
        R"(                 86 66 35 255 46 40 24 255 27 25 21 255
                 27 28 22 255 30 33 24 255 27 28 21 255
                 29 24 20 255 35 28 22 255 49 37 27 255
                 55 43 29 255 48 38 26 255 97 75 51 255
                 103 83 51 255 106 85 53 255 116 91 55 255
                 123 97 58 255 128 103 62 255 130 105 63 255
                 121 99 58 255 114 92 54 255 116 92 55 255
                 113 89 54 255 110 90 54 255 110 84 49 255
                 104 77 45 255 89 66 40 255 88 68 41 255
                 90 65 38 255 89 62 39 255 90 67 38 255
                 96 69 42 255 88 66 38 255 81 58 38 255
                 85 61 36 255 90 65 36 255 88 64 41 255
                 83 60 40 255 80 60 37 255 83 61 35 255
                 88 65 36 255 89 67 38 255 92 69 39 255
                 94 70 39 255 94 69 39 255 90 67 40 255
                 87 64 42 255 92 68 42 255 85 63 37 255
                 86 61 39 255 90 65 38 255 89 63 38 255
                 85 63 35 255 79 60 36 255 84 60 38 255
                 83 55 37 255 86 55 35 255 81 52 30 255
                 78 49 30 255 78 50 33 255 72 48 35 255
                 69 51 37 255 67 54 33 255 66 52 29 255
                 71 49 32 255 79 52 37 255 82 56 38 255
                 78 57 33 255 75 57 32 255 74 55 36 255
                 81 58 39 255 92 68 38 255 90 67 37 255
                 85 62 35 255 88 63 36 255 98 70 39 255
                 104 75 41 255 101 73 39 255 98 69 37 255
                 96 68 38 255 94 69 39 255 89 65 38 255
                 94 66 37 255 101 71 39 255 104 75 43 255
                 107 77 44 255 110 79 45 255 111 80 45 255
                 114 83 46 255 115 85 46 255 113 84 45 255
                 113 84 45 255 109 80 43 255 105 75 40 255
                 98 71 38 255 96 69 38 255 88 64 36 255
                 80 57 34 255 79 58 34 255 90 65 36 255
                 93 67 37 255 86 62 35 255 82 60 34 255
                 77 58 33 255 69 51 31 255 65 47 29 255
                 55 41 26 255 43 33 24 255 39 30 23 255
                 39 30 23 255 39 29 22 255 34 26 21 255
                 30 24 20 255 28 23 20 255 31 24 21 255
                 32 26 20 255 36 28 21 255 41 31 22 255
                 47 34 24 255 49 34 25 255 49 35 25 255
                 49 34 26 255 53 36 27 255 59 41 28 255
                 63 46 29 255 62 47 31 255 70 52 34 255
                 80 60 36 255 87 64 38 255 86 63 38 255
                 96 69 39 255 96 69 39 255 93 67 38 255
                 94 69 39 255 93 68 39 255 90 66 38 255
                 89 66 38 255 89 66 37 255 91 66 37 255
                 89 65 36 255 84 61 35 255 81 59 35 255
                 81 61 35 255 72 54 33 255 62 47 30 255
                 58 44 29 255 56 43 28 255 55 42 27 255
                 54 41 28 255 50 39 28 255 47 36 26 255
                 43 34 25 255 42 32 24 255 42 32 25 255
                 40 30 23 255 37 28 22 255 36 28 22 255
                 38 29 22 255 42 32 23 255 39 30 23 255
                 43 30 23 255 47 34 24 255 42 32 23 255
                 34 27 21 255 32 25 20 255 38 27 21 255
                 45 31 22 255 48 33 23 255 60 40 24 255
                 65 42 25 255 64 43 26 255 65 45 28 255
                 67 47 30 255 72 50 31 255 71 50 31 255
                 72 50 30 255 71 51 30 255 71 50 31 255
                 69 49 32 255 69 50 32 255 64 48 30 255
                 63 46 30 255 64 47 29 255 63 45 29 255
                 62 44 29 255 68 47 30 255 67 47 29 255
                 56 42 27 255 46 34 25 255 48 35 25 255
                 44 33 24 255 48 35 24 255 55 38 25 255
                 52 38 24 255 50 36 24 255 56 39 26 255
                 69 48 29 255 78 55 33 255 79 57 35 255
                 75 54 32 255 75 54 32 255 77 55 32 255
                 73 53 32 255 70 51 31 255 73 52 33 255
                 74 53 33 255 77 55 34 255 79 57 34 255
                 70 51 31 255 57 43 27 255 56 44 31 255
                 60 43 28 255 64 45 28 255 58 41 27 255
                 55 40 26 255 45 35 24 255 44 32 24 255
                 49 37 25 255 47 36 24 255 40 31 22 255
                 39 29 22 255 40 31 23 255 36 28 22 255
                 44 31 23 255 59 42 27 255 66 47 29 255
                 68 49 30 255 69 50 31 255 68 49 31 255
                 68 48 30 255 72 51 33 255 65 48 31 255
                 65 46 30 255 68 48 31 255 72 50 32 255
                 78 55 33 255 78 55 33 255 77 54 33 255
                 74 53 33 255 71 50 31 255 72 49 30 255
                 75 53 31 255 74 52 32 255 69 49 31 255
                 59 43 28 255 54 40 27 255 51 38 26 255
                 56 40 27 255 65 47 30 255 82 64 39 255
                 96 80 51 255 99 85 55 255 97 82 56 255
                 100 84 57 255 99 86 56 255 99 83 51 255
                 105 82 46 255 100 79 42 255 55 48 28 255
                 24 23 19 255 18 19 19 255 21 22 20 255
                 27 24 20 255 29 24 21 255 40 30 23 255
                 55 41 28 255 49 39 27 255 37 30 23 255
                 74 58 43 255 80 64 43 255 89 72 47 255
                 104 82 51 255 119 94 56 255 127 102 61 255
                 123 101 61 255 106 88 53 255 96 77 49 255
                 99 80 50 255 107 85 51 255 108 88 54 255
                 110 84 49 255 112 82 44 255 99 70 39 255
                 87 65 40 255 88 65 36 255 90 62 38 255
                 91 67 39 255 93 67 41 255 86 64 37 255
                 86 60 40 255 92 66 39 255 93 69 37 255
                 88 65 40 255 84 60 40 255 81 59 39 255
                 84 60 38 255 85 63 37 255 88 64 37 255
                 91 66 38 255 95 68 41 255 96 69 43 255
                 96 70 45 255 93 69 42 255 87 64 36 255
                 79 57 36 255 82 59 37 255 86 62 37 255
                 85 61 37 255 81 63 36 255 79 57 38 255
                 87 58 38 255 90 58 36 255 91 57 34 255
                 86 55 31 255 80 50 32 255 76 50 35 255
                 72 50 36 255 74 57 35 255 74 57 33 255
                 77 55 32 255 83 54 35 255 88 58 40 255
                 85 59 37 255 78 57 32 255 78 59 32 255
                 72 54 34 255 71 50 35 255 74 53 33 255
                 76 57 36 255 86 63 39 255 96 70 40 255
                 105 77 42 255 106 78 42 255 102 74 40 255
                 100 72 39 255 95 68 37 255 97 70 39 255
                 96 70 39 255 98 70 40 255 103 74 41 255
                 106 76 42 255 110 79 44 255 111 80 46 255
                 112 82 46 255 115 85 47 255 115 86 46 255
                 112 83 44 255 105 77 41 255 102 73 41 255
                 105 75 41 255 100 73 39 255 91 66 36 255
                 79 58 33 255 71 51 31 255 69 50 31 255
                 75 54 33 255 91 65 36 255 89 65 36 255
                 84 61 35 255 82 60 34 255 75 55 32 255
                 71 52 31 255 63 46 29 255 54 41 27 255
                 48 35 24 255 45 34 24 255 41 30 23 255
                 36 27 22 255 32 26 20 255 29 24 21 255
                 39 29 22 255 39 31 22 255 34 27 22 255
                 38 28 23 255 46 34 26 255 48 34 26 255
                 50 35 26 255 54 38 27 255 54 39 27 255
                 55 39 28 255 59 43 29 255 62 46 30 255
                 71 53 34 255 84 62 36 255 89 67 38 255
                 90 66 38 255 93 68 38 255 94 68 37 255
                 91 66 37 255 90 66 38 255 90 66 38 255
                 90 66 38 255 89 66 38 255 89 65 38 255
                 90 66 38 255 89 65 37 255 85 62 35 255
                 82 60 35 255 79 59 35 255 69 53 33 255
                 57 44 28 255 52 39 27 255 51 39 26 255
                 48 37 26 255 45 35 26 255 42 34 25 255
                 41 32 23 255 41 32 24 255 41 31 24 255
                 43 32 24 255 41 31 23 255 41 30 22 255
                 45 33 24 255 48 35 24 255 46 35 24 255
                 45 34 24 255 45 33 25 255 38 30 23 255
                 42 31 23 255 43 33 24 255 39 29 22 255
                 45 30 22 255 57 37 23 255 61 40 24 255
                 70 46 27 255 65 44 26 255 64 43 27 255
                 65 45 28 255 64 45 29 255 72 50 31 255
                 74 53 31 255 75 53 31 255 72 52 32 255
                 69 50 31 255 68 49 32 255 69 50 31 255
                 68 49 30 255 68 49 31 255 63 47 29 255
                 62 44 28 255 64 44 29 255 73 50 30 255
                 71 50 30 255 53 40 26 255 48 35 25 255
                 50 37 26 255 43 33 24 255 43 31 23 255
                 51 36 24 255 54 39 26 255 61 42 27 255
                 67 47 29 255 75 52 32 255 80 58 34 255
                 78 56 33 255 77 56 33 255 79 57 33 255
                 79 57 33 255 75 54 32 255 72 52 32 255
                 70 49 31 255 71 51 31 255 74 53 32 255
                 73 52 32 255 66 48 29 255 46 37 25 255
                 35 27 24 255 48 34 25 255 64 45 28 255
                 60 43 27 255 55 40 26 255 47 35 24 255
                 44 32 24 255 46 35 24 255 46 34 24 255
                 45 34 23 255 42 31 22 255 41 30 22 255
                 43 31 23 255 49 35 24 255 63 44 28 255
                 73 52 31 255 70 51 31 255 66 47 29 255
                 66 47 29 255 65 46 29 255 68 49 32 255
                 61 44 29 255 62 44 29 255 68 47 30 255
                 73 50 31 255 79 54 32 255 79 55 32 255
                 76 54 33 255 73 51 33 255 71 50 31 255
                 72 50 30 255 74 52 31 255 73 51 31 255
                 65 46 30 255 50 37 26 255 49 36 26 255
                 56 40 27 255 70 51 31 255 87 68 41 255
                 98 82 52 255 106 88 54 255 102 82 49 255
                 95 72 45 255 99 76 47 255 95 76 49 255
                 99 82 53 255 102 83 50 255 85 71 43 255
                 41 38 27 255 24 24 19 255 14 14 17 255
                 22 20 18 255 31 25 21 255 29 25 20 255
                 45 33 24 255 57 43 28 255 34 30 23 255
                 28 22 20 255 53 47 36 255 67 57 39 255
                 83 70 45 255 91 76 49 255 98 82 52 255
                 109 89 53 255 105 87 53 255 88 73 46 255
                 77 64 42 255 77 62 42 255 87 70 46 255
                 91 76 49 255 93 70 44 255 103 76 45 255
                 103 75 41 255 91 66 40 255 89 68 39 255
                 88 62 37 255 83 61 37 255 92 65 39 255
                 88 64 38 255 92 65 43 255 99 72 42 255
                 98 73 37 255 92 68 39 255 90 65 42 255
                 88 64 42 255 87 61 41 255 88 62 40 255
                 90 64 41 255 92 66 42 255 94 67 44 255
                 96 69 47 255 97 71 47 255 94 69 41 255
                 89 64 36 255 83 59 38 255 83 60 36 255
                 80 57 34 255 78 55 34 255 75 57 34 255
                 74 53 36 255 84 56 37 255 87 56 36 255
                 85 53 35 255 85 55 35 255 76 49 35 255
                 76 52 37 255 71 54 35 255 75 58 33 255
                 74 54 32 255 78 52 33 255 91 59 39 255
                 96 65 41 255 88 62 36 255 85 62 33 255
                 84 63 33 255 78 58 34 255 77 54 36 255
                 73 51 31 255 64 46 29 255 67 48 31 255
                 74 53 35 255 91 66 41 255 103 76 42 255
                 103 75 41 255 103 74 40 255 102 74 40 255
                 105 75 41 255 107 78 43 255 109 80 45 255
                 108 79 43 255 108 78 42 255 111 80 44 255
                 112 81 45 255 114 84 47 255 116 86 47 255
                 114 85 45 255 107 79 43 255 98 71 40 255
                 94 66 38 255 103 73 40 255 104 75 40 255
                 92 67 37 255 76 56 33 255 70 51 32 255
                 70 50 32 255 70 50 32 255 82 58 35 255
                 92 68 38 255 89 65 36 255 85 62 34 255
                 80 58 32 255 77 56 32 255 70 51 31 255
                 64 48 29 255 58 42 27 255 51 38 25 255
                 43 31 22 255 40 30 22 255 33 26 21 255
                 32 25 21 255 37 28 22 255 36 28 22 255
                 33 26 23 255 38 29 24 255 41 33 24 255
                 41 32 23 255 49 36 24 255 54 40 26 255
                 53 40 26 255 49 37 27 255 50 37 27 255
                 55 42 28 255 72 53 34 255 93 68 38 255
                 99 73 41 255 94 69 38 255 88 65 37 255
                 91 66 37 255 88 63 36 255 87 64 36 255
                 89 65 37 255 88 65 37 255 86 64 38 255
                 84 62 37 255 85 63 37 255 87 64 37 255
                 85 63 35 255 81 60 35 255 75 56 35 255
                 65 49 32 255 54 41 27 255 50 37 26 255
                 47 35 26 255 45 34 25 255 43 33 25 255
                 40 32 24 255 38 30 23 255 39 29 23 255
                 40 30 24 255 43 32 24 255 44 33 23 255
                 48 35 24 255 48 36 25 255 45 33 23 255
                 48 35 25 255 46 34 25 255 39 29 23 255
                 38 29 23 255 46 33 24 255 47 34 24 255
                 44 31 22 255 55 36 23 255 70 45 26 255
                 73 48 27 255 68 46 28 255 67 45 27 255
                 71 47 30 255 69 48 30 255 65 47 29 255
                 73 51 31 255 73 52 31 255 69 49 31 255
                 70 50 31 255 67 49 30 255 66 48 30 255
                 70 51 32 255 73 52 32 255 73 52 32 255
                 65 47 29 255 67 47 30 255 69 49 30 255
                 61 45 28 255 58 42 28 255 52 39 26 255
                 46 34 25 255 47 35 26 255 44 33 24 255
                 46 33 23 255 51 36 24 255 59 41 26 255
                 67 47 29 255 69 49 30 255 70 50 31 255
                 75 54 33 255 78 56 32 255 79 58 34 255
                 80 58 33 255 77 55 34 255 75 54 33 255
                 74 53 33 255 73 53 32 255 72 52 32 255
                 73 52 32 255 72 51 31 255 70 50 30 255
                 51 40 25 255 41 31 21 255 53 38 25 255
                 63 44 28 255 59 43 28 255 54 39 26 255
                 51 36 25 255 44 33 24 255 46 33 24 255
                 49 36 25 255 46 35 25 255 42 31 23 255
                 45 32 23 255 52 37 25 255 58 41 26 255
                 63 44 28 255 65 47 30 255 64 46 29 255
                 68 48 30 255 68 49 30 255 66 47 29 255
                 62 45 29 255 56 40 27 255 59 42 28 255
                 67 45 29 255 74 51 31 255 75 53 32 255
                 73 52 32 255 67 48 30 255 62 44 29 255
                 63 45 30 255 70 49 31 255 74 52 32 255
                 71 51 32 255 58 44 28 255 43 34 25 255
                 36 31 24 255 64 46 31 255 89 71 44 255
                 99 83 54 255 105 87 55 255 103 81 48 255
                 97 72 42 255 102 75 42 255 105 79 43 255
                 98 75 42 255 95 75 48 255 96 81 51 255
                 62 59 36 255 23 23 20 255 17 17 17 255
                 14 13 15 255 28 23 19 255 38 30 22 255
                 35 28 21 255 52 37 25 255 56 43 27 255
                 29 26 20 255 25 21 19 255 42 44 30 255
                 53 53 36 255 65 62 41 255 61 61 41 255
                 59 59 41 255 64 62 43 255 65 63 42 255
                 66 63 42 255 70 64 41 255 76 64 41 255
                 81 65 40 255 74 63 43 255 69 53 36 255
                 80 59 37 255 95 70 41 255 96 73 44 255
                 95 75 44 255 90 66 37 255 76 55 35 255
                 91 66 40 255 93 69 42 255 98 70 44 255
                 100 73 42 255 103 76 39 255 99 73 40 255
                 98 73 42 255 94 69 41 255 90 65 43 255
                 92 66 44 255 93 66 44 255 91 64 44 255
                 95 67 46 255 95 68 46 255 93 68 44 255
                 86 64 37 255 83 60 35 255 79 57 38 255
                 80 59 36 255 80 58 34 255 81 57 35 255
                 81 59 33 255 80 62 35 255 83 62 38 255
                 82 59 38 255 81 56 38 255 82 58 38 255
                 77 55 37 255 77 57 37 255 75 58 33 255
                 78 56 32 255 80 54 34 255 84 56 37 255
                 94 63 41 255 100 71 42 255 89 65 35 255
                 86 64 34 255 85 66 34 255 82 62 35 255
                 79 57 36 255 74 53 31 255 68 50 30 255
                 68 49 31 255 67 49 31 255 64 47 31 255
                 71 51 34 255 83 61 39 255 97 73 41 255
                 106 78 43 255 107 79 44 255 109 80 44 255
                 113 82 47 255 112 82 45 255 113 82 45 255
                 113 82 44 255 113 82 44 255 113 83 45 255
                 113 83 45 255 110 82 44 255 105 77 43 255
                 100 73 41 255 99 70 39 255 103 73 40 255
                 106 77 42 255 96 70 39 255 78 57 34 255
                 71 51 31 255 72 52 32 255 71 52 32 255
                 70 51 33 255 82 60 37 255 92 66 37 255
)"
        R"(                 87 64 35 255 81 59 34 255 81 58 34 255
                 75 55 33 255 69 51 31 255 64 47 29 255
                 56 41 26 255 48 36 24 255 45 35 24 255
                 37 29 22 255 32 26 21 255 33 26 22 255
                 34 27 22 255 35 27 23 255 41 32 23 255
                 45 35 24 255 43 33 23 255 51 36 25 255
                 52 38 26 255 47 37 24 255 45 36 26 255
                 48 37 28 255 62 45 29 255 91 66 38 255
                 101 74 41 255 97 72 39 255 92 67 38 255
                 86 63 36 255 86 63 36 255 87 62 35 255
                 87 64 35 255 87 64 36 255 85 62 37 255
                 79 59 36 255 76 56 35 255 80 59 36 255
                 82 61 36 255 81 60 36 255 78 57 35 255
                 68 51 32 255 62 46 30 255 53 41 27 255
                 46 35 25 255 44 33 25 255 45 34 25 255
                 42 32 24 255 40 31 24 255 39 29 23 255
                 38 29 22 255 40 30 23 255 45 32 24 255
                 50 36 25 255 47 35 24 255 40 30 23 255
                 44 32 23 255 44 33 23 255 39 29 22 255
                 45 33 23 255 50 35 24 255 52 37 24 255
                 51 36 23 255 51 34 23 255 64 41 26 255
                 60 42 26 255 63 43 27 255 63 44 28 255
                 69 48 30 255 71 50 31 255 66 48 31 255
                 69 50 32 255 73 52 32 255 71 51 32 255
                 70 51 31 255 69 50 32 255 66 49 30 255
                 64 48 30 255 68 49 30 255 69 51 31 255
                 68 50 31 255 65 47 29 255 70 49 31 255
                 67 49 31 255 50 39 26 255 45 33 24 255
                 51 38 25 255 46 35 24 255 48 35 24 255
                 42 32 24 255 50 36 25 255 53 37 25 255
                 60 41 26 255 63 44 29 255 66 47 29 255
                 70 50 30 255 77 55 33 255 76 55 33 255
                 81 59 35 255 79 58 34 255 75 54 33 255
                 75 54 33 255 76 55 34 255 74 54 33 255
                 74 53 33 255 74 53 33 255 69 49 30 255
                 68 49 30 255 58 44 28 255 57 42 27 255
                 67 47 29 255 64 46 29 255 59 42 26 255
                 52 38 25 255 49 36 25 255 43 33 23 255
                 43 32 23 255 47 35 25 255 44 34 24 255
                 39 29 22 255 42 31 23 255 48 34 25 255
                 54 38 25 255 57 40 26 255 59 42 28 255
                 63 44 28 255 67 48 30 255 69 51 31 255
                 67 49 30 255 61 44 28 255 60 42 27 255
                 65 46 29 255 58 42 28 255 62 43 29 255
                 67 47 29 255 56 41 27 255 47 35 25 255
                 43 33 25 255 46 34 27 255 62 44 30 255
                 67 49 32 255 57 44 30 255 48 39 28 255
                 32 28 23 255 48 38 27 255 82 65 42 255
                 99 84 54 255 106 87 55 255 104 81 47 255
                 98 73 43 255 93 71 42 255 101 76 44 255
                 103 78 45 255 101 76 43 255 91 71 42 255
                 91 74 48 255 84 74 46 255 51 47 27 255
                 23 24 19 255 16 16 17 255 32 25 21 255
                 41 33 24 255 36 29 23 255 53 38 26 255
                 56 43 27 255 37 31 22 255 31 26 21 255
                 30 37 28 255 30 37 30 255 29 36 30 255
                 33 38 30 255 46 47 33 255 50 51 34 255
                 51 53 35 255 37 41 31 255 55 52 38 255
                 72 64 43 255 83 72 45 255 83 72 45 255
                 82 64 39 255 86 65 38 255 87 66 38 255
                 81 62 39 255 79 65 42 255 87 66 38 255
                 76 57 34 255 76 57 36 255 78 57 38 255
                 88 62 41 255 98 71 42 255 102 75 42 255
                 100 75 41 255 99 73 40 255 97 71 39 255
                 97 71 41 255 97 71 44 255 98 70 46 255
                 94 67 45 255 93 67 46 255 95 68 45 255
                 92 67 44 255 87 65 39 255 78 58 33 255
                 73 53 33 255 82 58 38 255 83 60 36 255
                 85 62 36 255 88 62 36 255 86 62 36 255
                 82 61 35 255 77 58 34 255 76 57 35 255
                 73 56 34 255 76 57 35 255 79 59 34 255
                 80 58 34 255 83 57 35 255 86 57 38 255
                 90 62 39 255 95 68 39 255 94 70 38 255
                 86 65 33 255 83 63 32 255 80 63 32 255
                 77 60 35 255 73 54 36 255 73 52 33 255
                 70 50 30 255 68 49 32 255 67 49 32 255
                 64 46 30 255 62 44 29 255 65 47 32 255
                 71 52 34 255 82 60 39 255 95 70 43 255
                 105 78 44 255 111 82 45 255 112 82 45 255
                 113 82 46 255 113 82 46 255 113 82 46 255
                 112 82 44 255 111 81 44 255 109 81 43 255
                 108 80 44 255 106 77 42 255 102 73 41 255
                 103 73 40 255 104 75 41 255 98 71 39 255
                 83 60 34 255 76 54 33 255 77 55 33 255
                 77 56 33 255 71 51 32 255 75 54 34 255
                 88 63 37 255 89 65 37 255 83 61 35 255
                 79 57 33 255 78 56 33 255 73 54 33 255
                 67 49 30 255 59 43 27 255 47 36 25 255
                 40 31 23 255 36 29 22 255 31 25 22 255
                 31 25 22 255 35 28 22 255 35 28 22 255
                 41 30 23 255 45 33 24 255 44 32 24 255
                 51 36 26 255 50 36 26 255 49 37 27 255
                 55 42 28 255 72 54 34 255 95 69 40 255
                 105 78 43 255 98 73 40 255 91 67 36 255
                 86 64 36 255 86 64 36 255 85 62 35 255
                 87 63 35 255 88 64 35 255 86 64 36 255
                 82 61 36 255 75 56 35 255 72 53 34 255
                 73 54 33 255 73 54 34 255 73 54 35 255
                 71 54 35 255 65 48 31 255 58 44 29 255
                 51 39 27 255 45 35 25 255 41 32 24 255
                 40 30 23 255 40 30 23 255 38 29 23 255
                 38 28 22 255 38 28 22 255 42 31 23 255
                 49 35 24 255 47 34 24 255 43 31 23 255
                 42 31 23 255 39 30 22 255 40 29 22 255
                 46 33 23 255 47 34 23 255 49 33 23 255
                 55 36 23 255 64 42 25 255 65 43 25 255
                 64 43 26 255 49 37 25 255 53 38 26 255
                 56 40 27 255 64 44 29 255 67 48 30 255
                 63 46 30 255 71 51 31 255 70 51 31 255
                 68 49 31 255 71 51 32 255 68 49 30 255
                 67 48 30 255 64 46 29 255 72 51 31 255
                 69 51 31 255 67 49 32 255 65 47 29 255
                 66 47 30 255 56 42 28 255 44 34 24 255
                 43 32 24 255 50 36 25 255 53 39 25 255
                 54 39 26 255 43 33 23 255 47 34 24 255
                 57 40 26 255 59 42 26 255 61 43 28 255
                 65 46 29 255 71 51 32 255 72 52 33 255
                 72 52 32 255 76 54 33 255 78 55 34 255
                 76 54 33 255 68 50 31 255 70 50 32 255
                 72 52 34 255 72 53 33 255 73 53 33 255
                 72 51 32 255 69 49 30 255 60 44 28 255
                 62 44 28 255 72 51 32 255 70 51 30 255
                 63 45 27 255 55 40 26 255 49 36 25 255
                 39 30 22 255 38 29 23 255 41 31 24 255
                 43 32 23 255 41 31 22 255 42 31 23 255
                 46 34 24 255 51 37 25 255 53 38 25 255
                 57 39 27 255 61 42 28 255 61 44 28 255
                 64 46 29 255 63 46 28 255 61 44 28 255
                 62 44 28 255 58 41 27 255 44 33 24 255
                 39 29 23 255 46 34 24 255 36 28 23 255
                 33 26 22 255 36 29 23 255 41 31 26 255
                 52 39 28 255 46 37 27 255 30 27 22 255
                 41 33 26 255 58 47 33 255 84 70 46 255
                 98 82 51 255 105 85 51 255 105 81 47 255
                 102 77 43 255 102 77 44 255 80 63 38 255
                 93 68 40 255 98 74 42 255 96 72 41 255
                 94 71 41 255 88 68 43 255 93 77 51 255
                 72 64 39 255 30 30 22 255 18 18 17 255
                 30 24 20 255 43 34 24 255 38 31 23 255
                 47 34 25 255 50 39 26 255 33 28 22 255
                 27 22 20 255 20 27 23 255 19 27 22 255
                 20 28 22 255 37 40 31 255 64 62 43 255
                 72 68 45 255 69 68 44 255 37 43 29 255
                 34 36 27 255 41 40 30 255 56 50 37 255
                 71 61 42 255 89 72 43 255 99 81 46 255
                 97 78 45 255 76 61 35 255 43 39 29 255
                 65 51 34 255 77 60 36 255 65 51 32 255
                 65 48 34 255 72 51 35 255 78 56 38 255
                 90 65 42 255 98 72 44 255 97 71 41 255
                 99 72 40 255 98 72 39 255 96 71 41 255
                 98 71 43 255 94 68 44 255 90 64 44 255
                 94 66 45 255 91 66 44 255 85 62 41 255
                 79 57 35 255 79 57 33 255 87 62 37 255
                 89 64 38 255 88 64 37 255 88 65 37 255
                 85 61 38 255 83 59 37 255 77 54 33 255
                 79 54 32 255 81 58 33 255 79 56 32 255
                 85 58 35 255 87 60 37 255 84 59 37 255
                 88 62 37 255 90 66 36 255 88 66 34 255
                 88 66 34 255 89 68 33 255 89 68 33 255
                 83 64 32 255 74 57 32 255 71 51 34 255
                 73 52 33 255 70 50 30 255 68 50 32 255
                 67 49 33 255 65 47 31 255 64 46 30 255
                 66 48 31 255 68 49 31 255 65 47 31 255
                 67 49 33 255 80 58 37 255 94 70 42 255
                 103 76 42 255 109 80 45 255 111 81 45 255
                 110 80 44 255 110 81 44 255 110 81 44 255
                 109 80 43 255 108 78 43 255 108 78 42 255
                 107 78 44 255 108 79 43 255 103 75 40 255
                 94 67 37 255 93 67 36 255 87 63 35 255
                 82 59 34 255 79 57 34 255 75 54 33 255
                 75 54 34 255 82 59 36 255 88 65 37 255
                 82 60 35 255 76 55 33 255 78 56 33 255
                 78 57 32 255 71 51 30 255 64 47 28 255
                 47 37 24 255 40 31 23 255 40 31 23 255
                 32 27 22 255 30 25 21 255 35 27 22 255
                 34 26 22 255 35 27 22 255 43 33 24 255
                 46 37 24 255 49 39 25 255 53 41 27 255
                 60 43 30 255 76 55 33 255 96 73 41 255
                 105 76 44 255 101 74 40 255 88 64 36 255
                 81 58 33 255 84 62 36 255 85 64 37 255
                 83 61 35 255 85 62 35 255 86 62 35 255
                 86 63 36 255 82 61 36 255 73 54 34 255
                 71 51 33 255 68 50 31 255 67 50 32 255
                 68 50 33 255 65 49 32 255 60 45 30 255
                 50 39 27 255 44 33 24 255 42 32 23 255
                 41 31 24 255 39 30 23 255 39 29 22 255
                 40 30 23 255 41 31 23 255 42 31 23 255
                 47 35 24 255 47 35 24 255 45 33 23 255
                 42 31 23 255 32 28 22 255 32 26 21 255
                 47 33 23 255 53 36 23 255 60 39 24 255
                 65 43 25 255 69 45 26 255 75 49 27 255
                 75 52 29 255 68 48 28 255 62 45 28 255
                 58 43 27 255 55 41 27 255 60 43 29 255
                 64 45 30 255 64 46 30 255 71 52 32 255
                 68 50 30 255 65 46 30 255 69 48 31 255
                 71 51 31 255 70 51 31 255 71 50 30 255
                 74 52 31 255 69 50 32 255 70 51 33 255
                 72 51 31 255 65 48 30 255 49 38 25 255
                 40 31 23 255 42 31 24 255 53 39 26 255
                 58 42 27 255 56 40 26 255 49 37 25 255
                 51 38 25 255 56 41 27 255 56 41 27 255
                 58 41 28 255 61 44 29 255 64 47 30 255
                 68 49 31 255 72 53 33 255 74 54 33 255
                 75 54 32 255 75 54 32 255 68 49 30 255
                 66 47 31 255 62 45 30 255 59 43 29 255
                 69 49 31 255 71 50 32 255 68 48 30 255
                 63 44 28 255 65 47 29 255 70 50 31 255
                 74 53 31 255 65 47 29 255 58 41 26 255
                 50 36 25 255 39 30 22 255 38 28 22 255
                 41 31 23 255 42 31 23 255 43 32 23 255
                 42 32 23 255 48 34 24 255 52 37 25 255
                 52 37 25 255 54 38 25 255 59 41 26 255
                 58 41 27 255 54 39 26 255 60 42 26 255
                 63 44 28 255 57 41 27 255 48 35 24 255
                 39 31 22 255 31 24 20 255 34 26 22 255
                 30 24 21 255 35 27 22 255 40 31 24 255
                 46 34 26 255 53 40 28 255 35 33 24 255
                 29 25 22 255 69 57 37 255 90 76 51 255
                 100 83 55 255 105 83 49 255 105 81 45 255
                 102 77 43 255 97 73 42 255 105 78 44 255
                 100 76 42 255 97 73 42 255 84 66 39 255
                 92 69 40 255 100 75 43 255 89 70 41 255
                 91 73 48 255 78 70 45 255 30 32 23 255
                 17 18 17 255 25 21 19 255 41 32 24 255
                 36 29 22 255 42 31 23 255 42 33 24 255
                 31 26 21 255 27 22 19 255 22 28 22 255
                 25 31 23 255 23 30 23 255 24 31 25 255
                 27 33 27 255 28 33 27 255 30 35 28 255
                 26 32 25 255 25 29 22 255 25 28 23 255
                 30 32 25 255 48 42 29 255 64 54 35 255
                 85 71 46 255 98 80 48 255 86 71 42 255
                 63 56 34 255 69 60 38 255 74 62 40 255
                 68 56 36 255 66 51 34 255 65 48 33 255
                 63 46 34 255 78 57 39 255 91 67 43 255
                 95 70 44 255 95 70 44 255 92 67 40 255
                 92 67 37 255 97 71 40 255 96 70 42 255
                 92 65 42 255 93 66 44 255 85 61 40 255
                 80 58 39 255 80 56 38 255 82 59 38 255
                 83 59 36 255 89 63 37 255 93 67 38 255
                 83 60 35 255 76 54 34 255 81 59 35 255
                 79 58 33 255 83 59 35 255 84 60 36 255
                 84 60 37 255 83 60 37 255 81 58 35 255
                 82 61 34 255 84 63 34 255 82 61 34 255
                 83 61 34 255 91 68 35 255 93 70 34 255
                 90 68 33 255 89 69 33 255 82 62 32 255
                 75 55 33 255 70 50 34 255 73 51 32 255
                 72 51 33 255 69 50 33 255 67 48 31 255
                 66 47 30 255 65 46 30 255 65 46 31 255
                 62 46 31 255 61 45 30 255 65 48 32 255
                 66 49 31 255 73 52 33 255 84 62 40 255
                 101 75 45 255 107 80 44 255 108 81 44 255
                 109 80 45 255 108 79 44 255 105 75 41 255
                 106 75 41 255 103 73 41 255 105 76 43 255
                 107 77 42 255 105 75 41 255 107 77 40 255
                 99 72 38 255 89 64 35 255 85 61 35 255
                 84 60 35 255 85 61 36 255 79 58 34 255
                 80 58 35 255 82 60 35 255 79 57 35 255
                 81 59 34 255 79 58 32 255 75 54 31 255
                 69 50 30 255 62 46 27 255 54 41 26 255
                 46 36 25 255 38 31 24 255 38 30 23 255
                 45 32 25 255 42 32 24 255 40 34 23 255
                 49 42 26 255 49 42 27 255 48 41 28 255
                 57 45 28 255 76 54 35 255 99 70 42 255
                 102 76 41 255 98 70 39 255 91 64 35 255
                 85 60 33 255 86 60 35 255 90 66 38 255
                 87 65 37 255 83 61 35 255 83 59 34 255
                 85 60 34 255 87 63 36 255 83 61 36 255
                 72 53 34 255 70 51 33 255 68 49 32 255
                 65 47 31 255 60 44 30 255 52 39 28 255
                 49 36 27 255 46 34 25 255 43 31 23 255
                 42 32 24 255 42 31 24 255 41 31 23 255
                 41 31 23 255 43 32 24 255 48 35 25 255
                 50 37 25 255 46 34 24 255 47 34 24 255
                 43 32 24 255 34 27 22 255 19 18 18 255
                 32 23 20 255 58 39 25 255 72 46 27 255
                 82 55 30 255 81 55 31 255 75 52 30 255
                 71 49 29 255 65 45 29 255 64 44 28 255
                 69 47 29 255 68 46 30 255 65 46 30 255
                 70 50 31 255 71 51 30 255 66 48 29 255
                 68 49 32 255 71 51 32 255 71 51 31 255
                 70 49 31 255 70 50 31 255 70 50 30 255
                 72 50 31 255 79 55 32 255 75 53 31 255
                 67 49 31 255 64 47 30 255 54 40 27 255
                 44 34 24 255 45 34 24 255 52 38 26 255
                 53 40 26 255 55 40 26 255 62 44 28 255
                 56 42 27 255 53 39 26 255 53 39 27 255
                 54 41 27 255 59 43 29 255 58 43 29 255
                 57 42 28 255 61 44 29 255 64 47 31 255
                 68 49 32 255 72 52 32 255 75 54 33 255
                 75 55 33 255 71 51 32 255 60 44 28 255
                 62 44 27 255 66 47 29 255 69 48 30 255
)"
        R"(                 64 46 29 255 61 44 28 255 61 44 28 255
                 66 46 29 255 71 50 32 255 63 46 29 255
                 59 42 27 255 53 38 26 255 43 33 23 255
                 40 30 22 255 44 33 24 255 43 32 23 255
                 42 32 23 255 42 32 23 255 43 32 24 255
                 45 33 24 255 48 34 24 255 52 36 25 255
                 57 40 26 255 55 40 26 255 55 40 26 255
                 59 42 27 255 61 43 28 255 57 41 26 255
                 49 36 25 255 40 31 22 255 30 25 21 255
                 34 27 23 255 37 29 23 255 38 31 24 255
                 33 28 24 255 57 41 30 255 70 53 34 255
                 65 58 35 255 68 58 37 255 91 76 50 255
                 96 77 49 255 104 79 47 255 107 81 45 255
                 108 82 45 255 109 82 46 255 107 82 46 255
                 107 80 45 255 102 76 43 255 94 72 42 255
                 58 49 31 255 87 64 38 255 107 85 46 255
                 91 74 41 255 82 66 43 255 83 74 48 255
                 35 38 26 255 14 16 17 255 18 18 18 255
                 31 25 21 255 37 28 22 255 42 32 23 255
                 37 31 23 255 30 24 20 255 30 25 20 255
                 44 43 32 255 51 53 32 255 25 34 23 255
                 23 32 23 255 27 35 24 255 26 35 23 255
                 24 33 23 255 22 30 22 255 20 26 21 255
                 19 25 21 255 23 28 23 255 37 36 26 255
                 51 44 30 255 68 56 38 255 76 64 40 255
                 64 57 35 255 53 50 35 255 54 53 38 255
                 59 57 39 255 71 63 40 255 74 60 37 255
                 87 67 40 255 86 67 38 255 84 63 35 255
                 84 63 36 255 92 68 39 255 92 69 40 255
                 86 62 40 255 88 63 39 255 94 68 39 255
                 96 70 42 255 92 66 42 255 87 64 39 255
                 84 63 36 255 84 62 36 255 83 60 35 255
                 83 60 35 255 85 61 35 255 88 62 36 255
                 90 64 38 255 81 58 34 255 81 58 35 255
                 83 60 36 255 80 57 35 255 76 55 34 255
                 76 55 35 255 77 57 36 255 77 58 35 255
                 77 57 34 255 79 57 34 255 78 57 34 255
                 78 55 35 255 82 58 36 255 86 63 35 255
                 91 67 34 255 93 70 34 255 91 68 33 255
                 84 63 31 255 77 56 31 255 71 50 32 255
                 72 50 32 255 71 50 31 255 72 51 33 255
                 72 50 32 255 68 49 30 255 63 45 29 255
                 58 43 29 255 57 42 30 255 62 45 31 255
                 61 45 30 255 58 43 29 255 59 44 30 255
                 64 47 30 255 71 52 34 255 81 59 38 255
                 96 71 43 255 108 80 45 255 109 81 44 255
                 107 77 42 255 103 74 39 255 100 71 39 255
                 99 70 39 255 104 74 40 255 108 78 42 255
                 109 79 41 255 110 80 42 255 104 76 40 255
                 95 68 37 255 90 65 37 255 93 67 39 255
                 81 59 34 255 74 54 33 255 78 56 34 255
                 83 59 34 255 81 60 34 255 75 55 32 255
                 76 54 32 255 75 54 32 255 72 52 30 255
                 64 47 28 255 51 40 27 255 44 35 25 255
                 46 34 25 255 50 37 26 255 48 39 25 255
                 42 37 25 255 46 41 28 255 50 42 28 255
                 51 43 28 255 63 50 30 255 89 64 38 255
                 103 74 43 255 95 70 38 255 84 59 34 255
                 78 54 31 255 82 57 33 255 89 63 36 255
                 91 66 38 255 88 64 37 255 86 62 35 255
                 83 60 34 255 85 61 34 255 86 62 35 255
                 81 60 36 255 70 51 32 255 65 47 30 255
                 64 45 30 255 61 44 30 255 60 44 30 255
                 52 40 27 255 45 34 25 255 42 31 24 255
                 41 30 23 255 42 31 23 255 42 30 23 255
                 42 30 23 255 44 32 24 255 50 36 25 255
                 52 37 26 255 48 35 25 255 46 33 23 255
                 45 33 23 255 37 28 21 255 43 31 22 255
                 32 24 18 255 51 34 23 255 66 44 26 255
                 73 47 28 255 79 53 31 255 79 55 32 255
                 72 51 31 255 72 51 30 255 71 50 30 255
                 78 54 31 255 81 56 33 255 76 52 32 255
                 73 52 32 255 75 53 32 255 72 51 31 255
                 72 52 31 255 69 50 31 255 71 51 32 255
                 73 53 32 255 70 50 30 255 71 50 31 255
                 73 52 31 255 73 51 31 255 78 55 32 255
                 73 52 32 255 59 44 28 255 56 41 27 255
                 50 38 26 255 46 35 25 255 49 36 25 255
                 57 41 27 255 53 40 26 255 57 41 27 255
                 68 48 32 255 60 45 29 255 55 40 26 255
                 55 40 26 255 54 40 27 255 56 42 28 255
                 57 41 28 255 56 41 26 255 56 41 27 255
                 58 42 28 255 64 46 30 255 71 51 32 255
                 74 54 34 255 69 51 32 255 66 48 31 255
                 67 48 31 255 71 51 31 255 69 50 31 255
                 70 49 31 255 69 49 30 255 66 48 29 255
                 63 46 29 255 64 45 29 255 69 49 31 255
                 63 46 28 255 60 42 27 255 55 40 26 255
                 45 35 24 255 41 30 23 255 47 34 24 255
                 43 32 23 255 38 30 23 255 37 29 22 255
                 39 29 23 255 41 30 23 255 42 30 23 255
                 48 34 25 255 52 37 26 255 51 37 26 255
                 54 39 27 255 54 40 27 255 53 39 26 255
                 51 38 26 255 48 35 26 255 44 33 25 255
                 35 29 24 255 34 29 23 255 28 24 22 255
                 22 20 20 255 33 27 23 255 75 58 38 255
                 92 76 48 255 95 81 52 255 95 79 50 255
                 98 76 46 255 100 76 44 255 103 77 45 255
                 105 78 44 255 104 78 44 255 110 83 47 255
                 111 85 48 255 106 82 45 255 97 74 42 255
                 102 77 43 255 95 74 41 255 107 82 46 255
                 108 88 48 255 68 61 37 255 63 52 37 255
                 69 65 45 255 24 29 23 255 11 12 16 255
                 13 14 16 255 18 17 18 255 25 22 20 255
                 34 27 22 255 36 29 22 255 30 25 21 255
                 26 23 20 255 80 72 52 255 76 77 46 255
                 28 38 25 255 26 35 24 255 29 39 26 255
                 31 40 26 255 29 39 26 255 24 35 24 255
                 18 27 21 255 16 22 21 255 17 21 21 255
                 28 30 25 255 43 40 27 255 45 40 28 255
                 44 40 28 255 38 38 27 255 31 35 27 255
                 26 32 25 255 27 30 26 255 54 51 37 255
                 66 56 37 255 97 74 48 255 120 91 54 255
                 110 83 46 255 91 65 39 255 93 66 40 255
                 91 68 39 255 81 60 36 255 83 60 39 255
                 89 64 37 255 92 66 41 255 87 63 38 255
                 80 59 35 255 78 58 36 255 86 61 38 255
                 85 60 37 255 88 63 38 255 92 65 38 255
                 97 69 38 255 90 64 35 255 84 60 35 255
                 78 57 35 255 71 53 34 255 73 54 33 255
                 80 57 34 255 81 59 36 255 80 57 36 255
                 77 55 36 255 79 56 36 255 77 53 35 255
                 80 55 36 255 79 55 37 255 79 56 37 255
                 83 61 35 255 87 64 33 255 92 67 33 255
                 88 65 33 255 82 61 31 255 73 55 29 255
                 68 49 30 255 71 49 33 255 71 50 31 255
                 72 49 31 255 74 51 32 255 72 52 32 255
                 64 46 29 255 59 43 29 255 55 41 28 255
                 60 44 30 255 61 46 29 255 52 40 27 255
                 50 37 28 255 58 43 29 255 64 47 31 255
                 69 49 32 255 73 52 34 255 83 61 39 255
                 95 71 42 255 105 76 43 255 105 76 40 255
                 104 74 42 255 99 70 39 255 100 70 38 255
                 101 72 38 255 101 70 38 255 106 75 41 255
                 110 79 43 255 102 74 40 255 96 68 37 255
                 102 73 40 255 93 68 37 255 78 57 33 255
                 75 53 33 255 79 56 34 255 78 58 34 255
                 71 52 32 255 70 50 32 255 76 54 32 255
                 76 55 32 255 70 53 32 255 58 46 29 255
                 52 41 27 255 48 37 27 255 46 37 26 255
                 45 40 25 255 40 38 25 255 42 38 27 255
                 49 42 28 255 58 48 29 255 83 64 36 255
                 100 72 41 255 95 66 38 255 83 60 34 255
                 74 52 32 255 78 53 31 255 86 60 34 255
                 89 63 35 255 90 64 36 255 87 63 36 255
                 86 61 35 255 86 61 34 255 86 62 35 255
                 86 62 35 255 80 59 35 255 68 50 32 255
                 62 45 29 255 59 43 28 255 59 42 29 255
                 62 46 30 255 59 44 29 255 49 37 25 255
                 46 33 24 255 47 35 24 255 46 34 24 255
                 45 32 23 255 45 32 23 255 53 37 25 255
                 57 41 27 255 52 38 25 255 50 36 26 255
                 47 35 24 255 41 31 22 255 42 30 22 255
                 60 40 25 255 64 44 26 255 74 51 30 255
                 75 52 30 255 69 47 29 255 72 50 31 255
                 77 54 33 255 77 54 31 255 79 55 33 255
                 77 54 32 255 78 55 32 255 76 53 32 255
                 72 51 32 255 71 51 32 255 71 52 31 255
                 66 48 30 255 71 51 32 255 69 49 31 255
                 71 50 31 255 69 50 30 255 67 47 29 255
                 68 48 30 255 71 50 31 255 68 49 31 255
                 75 52 31 255 68 49 30 255 62 45 29 255
                 64 46 28 255 57 43 27 255 51 38 26 255
                 55 40 26 255 58 42 27 255 56 41 26 255
                 62 45 29 255 64 46 31 255 64 46 29 255
                 60 43 27 255 59 43 27 255 55 41 26 255
                 55 40 27 255 58 42 28 255 57 42 27 255
                 56 42 27 255 57 42 28 255 60 44 29 255
                 67 49 31 255 69 50 31 255 55 43 28 255
                 49 36 26 255 62 44 29 255 71 50 32 255
                 72 52 33 255 70 50 31 255 69 48 30 255
                 67 47 29 255 69 48 31 255 66 47 29 255
                 64 44 29 255 60 42 27 255 58 41 27 255
                 52 37 25 255 46 34 24 255 44 32 23 255
                 45 34 24 255 41 31 24 255 34 27 22 255
                 32 25 22 255 32 26 22 255 36 27 22 255
                 41 30 23 255 45 32 24 255 48 35 25 255
                 50 37 25 255 50 37 27 255 47 35 26 255
                 45 33 26 255 46 35 26 255 47 35 26 255
                 41 34 26 255 25 24 21 255 20 19 19 255
                 25 22 20 255 45 37 26 255 68 56 37 255
                 92 77 51 255 97 81 52 255 95 75 48 255
                 95 73 44 255 100 74 43 255 104 78 44 255
                 105 78 44 255 105 78 44 255 105 79 44 255
                 107 81 47 255 110 84 48 255 91 76 44 255
                 71 56 37 255 101 75 44 255 109 83 47 255
                 109 84 47 255 102 80 45 255 55 51 30 255
                 58 46 33 255 52 52 36 255 14 17 17 255
                 11 11 15 255 12 13 16 255 12 13 16 255
                 14 15 17 255 23 21 20 255 32 28 22 255
                 26 25 20 255 21 21 18 255 46 46 39 255
                 40 45 33 255 21 29 23 255 24 33 25 255
                 28 38 26 255 29 40 26 255 27 39 26 255
                 23 34 24 255 19 27 21 255 15 21 20 255
                 15 20 19 255 24 27 23 255 31 36 27 255
                 26 32 25 255 24 29 25 255 21 27 23 255
                 21 29 24 255 28 33 25 255 42 42 32 255
                 44 47 34 255 61 53 35 255 103 82 51 255
                 124 101 58 255 99 80 43 255 76 57 34 255
                 78 56 36 255 85 59 39 255 83 60 36 255
                 83 61 38 255 87 62 37 255 93 67 42 255
                 88 64 37 255 82 59 35 255 81 57 37 255
                 88 62 38 255 86 60 36 255 91 65 38 255
                 93 65 38 255 94 65 38 255 88 61 36 255
                 81 58 35 255 71 52 32 255 66 49 32 255
                 74 54 34 255 86 61 36 255 87 63 36 255
                 85 61 34 255 83 60 33 255 84 60 34 255
                 83 58 33 255 80 55 34 255 76 52 35 255
                 76 53 36 255 79 57 33 255 79 58 31 255
                 83 59 32 255 83 59 34 255 81 59 33 255
                 74 54 29 255 70 51 29 255 72 51 33 255
                 74 51 33 255 77 54 32 255 78 54 32 255
                 75 53 32 255 68 49 30 255 65 46 30 255
                 60 44 29 255 60 44 30 255 62 46 30 255
                 53 40 27 255 52 38 27 255 57 41 28 255
                 60 43 30 255 66 47 31 255 63 45 29 255
                 63 45 30 255 71 51 33 255 82 60 38 255
                 93 67 40 255 100 73 42 255 97 70 37 255
                 90 63 35 255 92 64 36 255 97 67 37 255
                 101 71 38 255 107 75 41 255 108 78 41 255
                 108 78 41 255 109 79 43 255 106 77 42 255
                 91 67 37 255 80 57 34 255 74 54 33 255
                 74 54 32 255 71 53 33 255 70 51 32 255
                 73 52 33 255 76 54 33 255 75 54 33 255
                 64 48 30 255 61 47 31 255 50 38 27 255
                 45 36 25 255 47 39 25 255 42 38 25 255
                 46 40 26 255 58 47 28 255 82 63 35 255
                 98 74 41 255 94 67 39 255 82 58 34 255
                 70 51 30 255 73 50 30 255 83 56 33 255
                 89 62 35 255 90 64 36 255 90 64 36 255
                 86 62 35 255 85 61 34 255 88 63 36 255
                 87 63 35 255 86 62 36 255 82 60 36 255
                 72 52 32 255 64 46 29 255 60 43 28 255
                 68 48 30 255 72 52 32 255 68 51 32 255
                 53 41 27 255 51 37 26 255 51 38 25 255
                 52 37 26 255 57 40 27 255 64 45 28 255
                 62 44 28 255 55 39 27 255 58 40 27 255
                 57 40 27 255 56 39 25 255 60 42 26 255
                 59 42 26 255 68 47 29 255 70 49 29 255
                 68 47 29 255 71 49 30 255 70 50 30 255
                 69 49 31 255 73 52 32 255 76 54 32 255
                 76 53 32 255 71 51 31 255 70 49 30 255
                 72 51 31 255 67 48 30 255 67 47 31 255
                 68 49 31 255 65 46 29 255 68 49 31 255
                 66 48 31 255 67 47 30 255 65 47 30 255
                 66 46 29 255 65 47 29 255 60 43 28 255
                 62 44 28 255 68 47 30 255 67 48 30 255
                 53 40 27 255 58 42 28 255 63 45 29 255
                 61 44 28 255 57 41 26 255 59 43 28 255
                 58 43 27 255 61 44 28 255 62 45 29 255
                 64 46 29 255 62 45 29 255 59 44 29 255
                 59 44 29 255 60 44 29 255 60 45 29 255
                 58 43 28 255 56 42 28 255 54 41 27 255
                 58 42 28 255 62 45 30 255 62 45 30 255
                 59 44 28 255 57 42 27 255 62 44 28 255
                 66 47 30 255 71 50 32 255 71 50 31 255
                 71 50 31 255 69 49 30 255 68 48 31 255
                 68 49 31 255 62 44 28 255 59 41 27 255
                 56 40 27 255 51 37 25 255 48 35 24 255
                 44 32 24 255 41 31 24 255 36 28 22 255
                 30 24 20 255 29 23 20 255 31 24 21 255
                 36 26 22 255 40 30 22 255 44 32 24 255
                 49 36 25 255 48 35 26 255 45 33 25 255
                 50 36 26 255 52 39 28 255 39 32 26 255
                 32 27 23 255 20 19 20 255 21 19 19 255
                 39 32 24 255 70 57 38 255 86 72 47 255
                 93 77 49 255 92 72 46 255 94 70 41 255
                 95 69 40 255 92 69 40 255 96 70 40 255
                 107 79 44 255 111 83 45 255 110 83 46 255
                 107 83 47 255 78 64 39 255 94 70 43 255
                 94 77 43 255 87 68 39 255 103 78 45 255
                 105 78 45 255 105 79 44 255 107 80 46 255
                 92 75 41 255 77 62 38 255 56 55 37 255
                 15 18 17 255 11 12 15 255 11 12 16 255
                 10 11 15 255 11 12 15 255 15 15 17 255
                 25 23 21 255 24 24 20 255 24 24 19 255
                 21 26 22 255 14 19 19 255 15 21 20 255
                 17 26 23 255 21 30 24 255 23 33 25 255
                 22 33 25 255 20 30 23 255 19 26 21 255
                 18 23 20 255 17 22 21 255 25 27 22 255
                 24 30 23 255 19 27 23 255 15 24 23 255
                 18 26 24 255 38 43 34 255 61 61 40 255
                 44 44 30 255 40 38 30 255 75 61 41 255
                 105 85 51 255 100 84 49 255 81 66 37 255
                 73 58 35 255 74 57 33 255 80 59 36 255
                 86 61 36 255 87 64 38 255 90 65 39 255
                 89 65 39 255 87 62 37 255 90 64 38 255
                 88 63 38 255 85 64 38 255 87 65 39 255
                 92 68 40 255 89 65 38 255 84 60 36 255
                 80 57 34 255 77 54 33 255 70 49 33 255
)"
        R"(                 77 55 35 255 88 63 36 255 90 65 36 255
                 86 62 36 255 85 61 36 255 82 57 34 255
                 80 56 33 255 82 59 33 255 80 57 31 255
                 77 54 34 255 77 54 36 255 80 58 33 255
                 82 60 32 255 78 54 32 255 75 49 33 255
                 78 51 35 255 79 53 33 255 76 54 31 255
                 74 54 31 255 74 53 33 255 80 56 34 255
                 80 56 34 255 75 54 33 255 69 50 31 255
                 68 48 30 255 66 46 30 255 66 47 31 255
                 66 47 30 255 56 41 27 255 53 38 27 255
                 56 40 27 255 55 40 28 255 55 40 29 255
                 54 39 27 255 57 41 28 255 63 45 30 255
                 66 48 32 255 67 48 31 255 75 53 34 255
                 86 61 37 255 89 63 36 255 92 65 36 255
                 97 67 36 255 102 71 38 255 108 77 40 255
                 110 78 42 255 110 79 42 255 110 79 42 255
                 109 78 43 255 100 73 40 255 81 59 34 255
                 73 53 33 255 68 50 31 255 72 52 32 255
                 76 55 33 255 73 54 33 255 73 53 33 255
                 76 55 33 255 72 54 33 255 71 54 33 255
                 64 47 30 255 58 43 28 255 59 44 28 255
                 60 47 27 255 65 51 29 255 79 58 32 255
                 93 68 38 255 91 64 38 255 79 56 35 255
                 72 51 31 255 72 52 30 255 82 56 32 255
                 89 61 34 255 91 64 36 255 92 66 37 255
                 90 65 37 255 86 62 36 255 85 61 36 255
                 85 61 35 255 85 61 34 255 87 62 35 255
                 85 61 36 255 81 58 35 255 73 53 32 255
                 70 50 31 255 77 55 33 255 80 58 35 255
                 77 57 33 255 66 50 30 255 53 40 26 255
                 51 36 25 255 62 43 27 255 72 51 32 255
                 68 50 31 255 57 40 27 255 58 40 27 255
                 60 42 27 255 62 43 27 255 69 46 27 255
                 72 49 29 255 66 46 28 255 67 47 29 255
                 68 47 30 255 65 46 29 255 67 46 30 255
                 69 49 30 255 70 50 31 255 70 50 32 255
                 70 50 31 255 71 51 32 255 67 48 30 255
                 71 51 31 255 76 55 32 255 68 49 31 255
                 66 47 30 255 68 48 30 255 68 47 30 255
                 68 48 29 255 66 48 30 255 64 46 29 255
                 63 46 28 255 61 44 29 255 56 41 27 255
                 55 39 26 255 57 41 27 255 63 43 29 255
                 61 44 29 255 52 39 26 255 55 40 27 255
                 58 42 28 255 60 43 29 255 59 43 28 255
                 59 44 28 255 57 42 27 255 58 43 28 255
                 66 48 31 255 67 48 30 255 62 45 30 255
                 57 43 29 255 60 43 29 255 63 45 30 255
                 61 45 31 255 60 45 30 255 58 44 29 255
                 56 42 28 255 59 43 29 255 59 43 29 255
                 57 42 29 255 58 42 29 255 60 43 29 255
                 65 46 30 255 71 50 32 255 71 50 32 255
                 71 51 32 255 70 49 31 255 68 48 30 255
                 67 47 29 255 67 47 30 255 63 45 29 255
                 61 44 28 255 57 40 27 255 53 38 25 255
                 48 35 24 255 42 31 24 255 34 27 22 255
                 29 23 20 255 28 23 19 255 29 23 20 255
                 30 23 20 255 34 25 21 255 39 29 22 255
                 42 30 23 255 48 35 25 255 51 37 26 255
                 45 35 26 255 44 33 27 255 45 35 27 255
                 30 26 22 255 40 31 24 255 32 29 22 255
                 47 39 28 255 80 67 43 255 93 77 50 255
                 94 75 48 255 94 71 42 255 95 70 40 255
                 97 71 40 255 99 72 40 255 101 73 40 255
                 101 74 40 255 108 80 45 255 112 85 48 255
                 112 86 47 255 108 85 47 255 83 68 38 255
                 97 73 42 255 85 71 42 255 86 66 41 255
                 104 78 44 255 102 75 43 255 103 77 43 255
                 102 76 43 255 93 72 42 255 78 61 39 255
                 67 62 42 255 20 25 21 255 11 12 15 255
                 9 10 14 255 10 10 14 255 12 13 16 255
                 18 19 18 255 26 25 21 255 25 26 21 255
                 28 29 22 255 22 26 21 255 12 15 17 255
                 13 18 20 255 13 21 20 255 16 23 21 255
                 16 23 21 255 16 23 22 255 19 25 22 255
                 21 26 22 255 20 25 21 255 15 21 20 255
                 17 23 22 255 17 23 20 255 16 24 20 255
                 20 28 23 255 34 40 31 255 45 52 40 255
                 57 58 39 255 46 43 26 255 47 38 29 255
                 74 55 41 255 85 66 45 255 75 59 39 255
                 77 59 39 255 76 57 37 255 78 60 36 255
                 81 61 35 255 90 64 38 255 89 65 39 255
                 87 63 37 255 83 60 36 255 82 58 35 255
                 88 62 38 255 88 64 38 255 77 57 36 255
                 80 58 38 255 85 61 39 255 85 61 39 255
                 81 60 37 255 77 57 35 255 79 58 33 255
                 77 54 33 255 83 58 35 255 86 59 37 255
                 89 63 37 255 86 62 36 255 85 61 34 255
                 80 56 33 255 76 53 33 255 77 53 34 255
                 77 55 31 255 78 56 32 255 79 54 36 255
                 76 54 32 255 81 58 33 255 77 52 33 255
                 73 48 32 255 79 53 33 255 80 53 34 255
                 78 52 34 255 76 54 31 255 73 53 32 255
                 76 53 33 255 75 53 34 255 66 48 31 255
                 65 47 31 255 67 48 31 255 67 47 31 255
                 68 48 30 255 69 49 30 255 65 47 29 255
                 57 41 27 255 54 40 27 255 51 38 27 255
                 48 36 27 255 48 36 27 255 53 39 27 255
                 56 41 26 255 54 40 27 255 55 40 27 255
                 60 42 29 255 65 45 30 255 71 50 32 255
                 80 57 34 255 95 67 37 255 104 74 39 255
                 109 79 40 255 105 75 39 255 107 75 40 255
                 110 79 42 255 112 82 44 255 107 78 41 255
                 91 67 37 255 74 54 32 255 66 49 30 255
                 71 51 31 255 80 58 34 255 79 58 34 255
                 74 54 33 255 76 56 33 255 78 57 34 255
                 75 56 35 255 75 57 34 255 75 54 33 255
                 78 53 34 255 86 60 35 255 91 64 38 255
                 94 66 38 255 86 59 37 255 77 52 35 255
                 76 52 32 255 80 57 32 255 84 60 33 255
                 89 61 34 255 92 64 35 255 89 63 35 255
                 91 65 37 255 88 64 37 255 86 62 37 255
                 85 62 36 255 86 62 37 255 86 61 35 255
                 87 62 35 255 87 62 36 255 86 62 36 255
                 80 57 33 255 80 57 34 255 83 60 35 255
                 85 62 36 255 81 60 35 255 75 56 33 255
                 64 47 29 255 62 43 28 255 71 51 31 255
                 65 48 30 255 59 41 27 255 62 43 28 255
                 67 47 29 255 65 46 29 255 67 47 29 255
                 72 49 29 255 74 51 30 255 63 45 29 255
                 62 44 28 255 64 45 29 255 63 45 29 255
                 61 44 29 255 62 44 28 255 64 45 30 255
                 68 47 31 255 71 50 32 255 73 52 32 255
                 72 52 31 255 75 55 32 255 73 53 32 255
                 68 49 31 255 66 48 29 255 64 46 29 255
                 67 47 30 255 69 49 31 255 67 48 30 255
                 67 49 30 255 61 46 28 255 55 40 27 255
                 51 37 26 255 49 36 26 255 50 36 26 255
                 54 39 27 255 53 39 26 255 52 38 26 255
                 52 38 26 255 52 38 26 255 57 41 28 255
                 59 43 28 255 59 44 28 255 54 40 27 255
                 56 40 27 255 62 45 30 255 60 44 29 255
                 59 43 29 255 57 43 28 255 61 45 30 255
                 61 46 30 255 55 42 29 255 54 41 28 255
                 54 40 28 255 54 41 28 255 55 41 28 255
                 57 42 28 255 58 42 29 255 59 42 29 255
                 64 45 29 255 68 49 32 255 72 52 33 255
                 73 52 32 255 70 51 31 255 68 48 30 255
                 68 49 30 255 67 48 30 255 67 47 30 255
                 65 46 29 255 63 45 28 255 59 41 27 255
                 55 39 26 255 49 36 25 255 41 30 23 255
                 35 27 21 255 31 24 20 255 32 24 20 255
                 35 26 21 255 38 27 22 255 37 27 22 255
                 42 30 23 255 49 35 25 255 58 42 28 255
                 56 43 29 255 36 30 24 255 31 25 22 255
                 38 30 24 255 47 36 27 255 71 56 36 255
                 77 65 41 255 87 73 47 255 96 80 51 255
                 95 74 46 255 95 72 42 255 96 73 42 255
                 100 74 44 255 105 78 45 255 106 79 44 255
                 106 79 44 255 105 78 43 255 111 83 46 255
                 108 82 47 255 106 81 46 255 105 81 46 255
                 109 85 47 255 109 87 48 255 84 69 38 255
                 92 67 39 255 106 80 44 255 102 75 42 255
                 100 75 43 255 97 73 41 255 87 67 38 255
                 74 58 37 255 65 60 41 255 19 24 21 255
                 11 12 15 255 9 10 14 255 10 11 14 255
                 16 17 17 255 25 25 20 255 28 29 22 255
                 31 32 23 255 50 47 31 255 30 32 23 255
                 20 24 21 255 14 19 20 255 12 17 18 255
                 13 16 19 255 15 23 21 255 17 24 22 255
                 25 28 23 255 24 29 24 255 22 29 22 255
                 16 25 21 255 14 22 21 255 16 23 22 255
                 26 29 24 255 43 43 29 255 40 46 30 255
                 32 39 28 255 35 38 26 255 35 34 23 255
                 37 30 25 255 57 42 36 255 68 50 39 255
                 76 57 40 255 76 57 38 255 73 55 38 255
                 75 57 37 255 82 61 36 255 88 62 37 255
                 85 62 36 255 88 63 36 255 86 61 36 255
                 90 64 37 255 90 64 37 255 89 64 38 255
                 82 59 36 255 78 55 33 255 68 48 31 255
                 76 52 34 255 80 57 36 255 74 53 35 255
                 71 53 35 255 80 59 35 255 85 62 35 255
                 86 61 35 255 85 59 35 255 81 56 35 255
                 79 55 35 255 79 56 32 255 74 53 30 255
                 71 50 32 255 73 51 33 255 75 54 31 255
                 75 52 33 255 72 51 33 255 72 53 32 255
                 74 50 32 255 70 50 30 255 73 55 30 255
                 77 56 31 255 76 52 32 255 77 50 33 255
                 75 53 32 255 72 52 33 255 72 52 33 255
                 59 44 29 255 58 41 29 255 66 47 30 255
                 65 47 30 255 66 47 30 255 75 53 32 255
                 68 50 30 255 54 40 27 255 52 39 26 255
                 48 35 26 255 45 34 25 255 44 33 24 255
                 52 38 26 255 50 37 25 255 46 35 24 255
                 44 33 24 255 50 37 26 255 54 39 27 255
                 59 42 27 255 69 48 30 255 76 53 33 255
                 80 56 35 255 95 68 39 255 104 75 40 255
                 109 78 41 255 110 80 42 255 111 80 44 255
                 105 76 42 255 98 71 39 255 86 63 34 255
                 68 50 30 255 68 49 31 255 80 58 35 255
                 79 58 34 255 78 58 36 255 81 60 35 255
                 83 60 34 255 83 60 35 255 81 60 36 255
                 84 63 36 255 92 66 38 255 97 68 42 255
                 93 65 41 255 83 57 37 255 74 49 35 255
                 78 52 35 255 88 60 36 255 92 64 35 255
                 90 65 35 255 91 63 35 255 92 65 36 255
                 91 65 36 255 92 66 37 255 87 63 37 255
                 84 62 38 255 85 62 36 255 85 61 36 255
                 85 61 35 255 85 60 35 255 86 62 36 255
                 88 62 36 255 82 59 34 255 83 59 35 255
                 84 60 36 255 86 61 36 255 82 60 34 255
                 80 58 34 255 81 59 35 255 75 56 33 255
                 63 47 29 255 55 40 27 255 65 44 29 255
                 78 55 32 255 75 54 33 255 72 52 31 255
                 64 46 29 255 67 47 29 255 75 53 32 255
                 66 48 30 255 63 45 29 255 66 47 30 255
                 61 45 29 255 53 40 27 255 50 37 26 255
                 54 39 27 255 68 48 31 255 70 50 32 255
                 64 46 30 255 66 47 30 255 74 52 32 255
                 73 53 31 255 70 50 30 255 59 44 27 255
                 53 38 25 255 63 44 28 255 66 46 30 255
                 60 43 28 255 58 43 29 255 60 44 29 255
                 54 41 27 255 50 37 27 255 49 36 25 255
                 47 35 24 255 48 35 25 255 48 36 25 255
                 48 35 25 255 51 38 25 255 51 38 26 255
                 55 40 28 255 60 45 29 255 58 43 27 255
                 56 41 27 255 56 41 27 255 56 41 28 255
                 56 42 28 255 57 43 29 255 53 40 28 255
                 54 40 27 255 52 39 27 255 48 37 26 255
                 46 35 25 255 45 34 25 255 49 36 26 255
                 50 37 26 255 52 38 26 255 57 42 28 255
                 58 43 29 255 64 46 31 255 68 49 32 255
                 68 50 32 255 69 50 33 255 65 48 31 255
                 65 47 29 255 67 49 31 255 65 47 30 255
                 65 46 29 255 65 46 29 255 61 43 28 255
                 60 41 28 255 54 39 27 255 50 37 26 255
                 45 33 23 255 41 30 22 255 44 32 23 255
                 42 31 22 255 42 30 22 255 43 32 23 255
                 48 35 25 255 55 40 28 255 54 40 29 255
                 48 37 27 255 44 34 25 255 43 33 26 255
                 45 34 26 255 62 47 33 255 83 67 44 255
                 94 80 53 255 98 81 52 255 93 74 47 255
                 87 68 41 255 81 63 40 255 72 59 38 255
                 62 52 36 255 80 61 41 255 97 75 45 255
                 103 79 45 255 107 81 45 255 107 80 44 255
                 113 86 47 255 110 84 45 255 87 69 39 255
                 85 64 39 255 89 71 44 255 91 70 44 255
                 106 81 45 255 108 82 45 255 105 79 45 255
                 100 75 42 255 94 71 40 255 94 71 42 255
                 89 69 39 255 72 57 37 255 60 56 39 255
                 17 22 20 255 11 12 16 255 12 13 15 255
                 16 16 17 255 25 23 20 255 36 33 23 255
                 34 35 25 255 48 46 32 255 40 44 32 255
                 41 38 27 255 28 31 23 255 20 27 22 255
                 15 22 19 255 17 21 21 255 18 26 22 255
                 17 24 21 255 21 25 22 255 20 26 22 255
                 18 26 22 255 15 23 21 255 19 25 22 255
                 30 35 28 255 39 44 32 255 40 42 29 255
                 31 33 23 255 28 30 23 255 32 33 23 255
                 35 32 23 255 43 34 28 255 51 40 33 255
                 61 47 36 255 69 54 37 255 67 53 35 255
                 64 51 34 255 68 53 33 255 77 55 34 255
                 81 57 35 255 78 56 35 255 84 59 35 255
                 85 61 36 255 90 63 37 255 88 63 36 255
                 86 62 36 255 80 58 35 255 72 51 31 255
                 66 46 29 255 82 56 33 255 82 56 33 255
                 83 57 34 255 83 59 36 255 85 62 38 255
                 83 61 36 255 85 62 35 255 82 59 33 255
                 76 54 32 255 71 50 32 255 73 50 32 255
                 74 52 31 255 72 51 30 255 73 51 32 255
                 72 50 31 255 70 49 30 255 66 46 32 255
                 63 46 29 255 67 47 30 255 63 45 29 255
                 59 44 28 255 64 45 28 255 70 48 31 255
                 76 49 33 255 78 53 33 255 77 57 33 255
                 74 54 34 255 65 47 30 255 65 46 29 255
                 69 49 30 255 69 49 30 255 64 46 30 255
                 66 48 31 255 57 43 28 255 46 35 25 255
                 45 34 25 255 43 32 24 255 44 32 24 255
                 43 31 23 255 46 33 25 255 44 33 25 255
                 47 35 25 255 44 33 23 255 46 34 24 255
                 51 37 25 255 54 39 26 255 64 46 30 255
                 76 54 33 255 68 50 31 255 69 50 32 255
                 84 61 37 255 97 70 39 255 102 75 41 255
                 105 76 42 255 102 74 40 255 95 69 37 255
                 88 64 36 255 78 57 32 255 73 53 32 255
                 81 59 35 255 80 59 35 255 79 58 37 255
                 80 60 38 255 80 59 35 255 83 60 35 255
                 84 61 36 255 82 62 37 255 83 62 36 255
                 84 60 38 255 80 54 37 255 79 54 36 255
                 83 56 36 255 87 58 37 255 93 62 37 255
                 95 65 36 255 94 67 36 255 91 64 36 255
                 92 64 37 255 93 67 38 255 92 67 39 255
                 89 65 39 255 88 64 37 255 87 64 37 255
                 86 62 36 255 86 62 36 255 86 62 36 255
                 86 62 36 255 87 63 36 255 86 62 35 255
                 88 62 36 255 87 62 35 255 88 63 35 255
                 86 62 34 255 86 62 36 255 76 57 34 255
                 61 46 30 255 60 43 27 255 68 47 29 255
                 73 50 30 255 73 50 30 255 69 48 31 255
                 69 49 31 255 64 47 30 255 67 47 30 255
                 78 55 33 255 72 52 32 255 62 45 29 255
                 59 43 28 255 53 40 27 255 50 38 26 255
)"
        R"(                 51 38 25 255 60 42 28 255 67 48 31 255
                 64 46 30 255 59 44 28 255 59 42 27 255
                 65 45 29 255 68 48 30 255 67 47 29 255
                 59 43 26 255 54 39 25 255 55 39 26 255
                 58 41 28 255 56 41 27 255 52 39 26 255
                 50 37 25 255 46 35 24 255 46 34 24 255
                 49 36 26 255 47 34 24 255 45 33 24 255
                 46 34 25 255 50 36 26 255 54 39 26 255
                 55 40 27 255 54 39 27 255 56 41 28 255
                 55 40 26 255 52 38 26 255 52 39 26 255
                 52 38 27 255 52 39 27 255 54 41 28 255
                 54 40 27 255 52 39 27 255 49 38 27 255
                 48 36 26 255 47 36 26 255 47 36 26 255
                 48 36 26 255 46 35 26 255 49 36 26 255
                 52 39 27 255 54 40 27 255 60 43 28 255
                 64 46 29 255 61 45 29 255 60 44 29 255
                 57 42 28 255 57 42 28 255 62 45 29 255
                 64 46 29 255 61 43 28 255 62 44 28 255
                 61 43 28 255 59 42 28 255 51 37 26 255
                 50 36 25 255 50 35 24 255 44 33 23 255
                 44 32 23 255 49 36 24 255 39 31 23 255
                 29 24 22 255 32 25 23 255 40 30 25 255
                 44 34 26 255 42 32 25 255 49 37 26 255
                 64 48 32 255 79 63 41 255 93 78 52 255
                 101 84 55 255 100 82 52 255 94 75 47 255
                 82 65 41 255 76 60 39 255 66 55 37 255
                 43 40 29 255 29 28 25 255 56 45 33 255
                 52 47 33 255 70 53 36 255 90 72 43 255
                 94 71 42 255 113 85 48 255 110 84 47 255
                 95 76 43 255 90 70 40 255 61 53 33 255
                 70 50 34 255 105 78 45 255 106 80 46 255
                 105 80 46 255 95 72 41 255 89 67 39 255
                 94 69 40 255 92 70 40 255 72 58 36 255
                 68 61 41 255 25 29 23 255 15 15 16 255
                 20 21 18 255 21 22 19 255 26 26 22 255
                 36 35 25 255 47 45 30 255 43 46 32 255
                 27 32 24 255 36 34 25 255 30 33 25 255
                 24 31 24 255 22 29 22 255 24 29 22 255
                 23 29 23 255 21 27 22 255 21 26 22 255
                 18 25 21 255 18 25 21 255 22 28 23 255
                 34 38 30 255 37 42 31 255 28 36 27 255
                 30 34 26 255 28 29 22 255 28 26 22 255
                 31 29 23 255 39 33 27 255 42 35 30 255
                 52 43 34 255 61 50 34 255 64 53 32 255
                 65 53 31 255 65 52 30 255 73 54 33 255
                 82 57 35 255 78 56 34 255 75 52 33 255
                 77 54 34 255 80 56 35 255 83 58 36 255
                 79 55 34 255 77 55 34 255 73 54 35 255
                 67 48 31 255 65 44 29 255 83 56 33 255
                 87 59 33 255 89 60 34 255 89 62 36 255
                 84 59 36 255 83 59 37 255 83 61 36 255
                 79 58 34 255 71 53 31 255 67 48 29 255
                 69 47 31 255 73 51 32 255 72 52 31 255
                 69 49 30 255 65 46 30 255 65 45 28 255
                 62 44 29 255 64 46 30 255 60 44 29 255
                 62 44 30 255 64 43 30 255 67 44 30 255
                 65 43 30 255 70 45 33 255 82 55 35 255
                 80 59 34 255 71 52 33 255 65 47 30 255
                 66 46 30 255 66 46 30 255 69 48 31 255
                 62 45 29 255 61 43 29 255 53 40 26 255
                 46 35 25 255 41 31 24 255 40 30 23 255
                 40 30 23 255 37 28 23 255 37 28 23 255
                 38 30 24 255 46 34 25 255 48 36 24 255
                 43 31 23 255 46 33 24 255 48 35 25 255
                 58 42 28 255 67 48 31 255 56 41 28 255
                 57 41 28 255 71 51 32 255 76 55 33 255
                 71 50 33 255 87 62 38 255 100 71 40 255
                 94 68 36 255 88 62 35 255 88 63 35 255
                 83 60 34 255 81 58 34 255 76 57 35 255
                 75 55 36 255 73 54 36 255 74 55 35 255
                 79 57 36 255 82 60 36 255 75 55 33 255
                 66 49 31 255 74 51 33 255 81 55 34 255
                 84 60 34 255 86 61 34 255 89 61 35 255
                 92 62 36 255 91 61 36 255 93 66 36 255
                 94 67 36 255 94 66 37 255 94 68 39 255
                 92 68 41 255 90 66 39 255 88 65 37 255
                 87 64 36 255 87 63 36 255 88 63 36 255
                 88 63 36 255 88 64 36 255 90 65 38 255
                 90 65 37 255 91 66 36 255 90 65 36 255
                 90 65 36 255 87 64 35 255 77 58 34 255
                 59 44 30 255 60 42 28 255 77 54 32 255
                 80 57 33 255 74 52 30 255 69 48 29 255
                 64 45 29 255 65 46 29 255 65 46 30 255
                 72 51 32 255 78 55 33 255 69 50 31 255
                 57 42 27 255 54 40 27 255 50 37 25 255
                 53 38 26 255 61 44 28 255 63 45 29 255
                 58 42 28 255 54 40 27 255 53 40 26 255
                 54 39 26 255 58 41 26 255 62 44 28 255
                 65 45 28 255 61 44 27 255 53 39 25 255
                 48 35 24 255 50 36 25 255 54 39 27 255
                 50 36 26 255 46 34 24 255 44 32 23 255
                 48 35 24 255 49 35 25 255 47 34 24 255
                 45 33 25 255 47 34 25 255 52 38 25 255
                 56 41 27 255 60 43 28 255 57 41 27 255
                 54 39 27 255 53 39 26 255 48 36 25 255
                 49 36 25 255 48 36 26 255 47 36 25 255
                 50 38 26 255 53 39 27 255 49 37 26 255
                 47 35 26 255 49 36 27 255 50 38 28 255
                 48 37 27 255 46 35 27 255 42 32 25 255
                 44 33 24 255 47 35 25 255 50 38 26 255
                 55 40 27 255 58 43 28 255 55 41 27 255
                 53 38 26 255 51 37 26 255 52 38 27 255
                 57 40 27 255 64 45 28 255 64 46 28 255
                 61 44 28 255 60 44 28 255 57 42 27 255
                 51 37 26 255 50 36 25 255 47 34 24 255
                 45 33 24 255 41 32 23 255 40 32 24 255
                 22 21 20 255 15 14 17 255 21 18 18 255
                 35 26 22 255 45 34 25 255 58 43 28 255
                 78 59 37 255 93 76 49 255 99 85 56 255
                 103 86 57 255 103 83 52 255 97 79 49 255
                 74 64 42 255 51 42 33 255 63 49 37 255
                 57 49 33 255 37 36 26 255 26 24 23 255
                 54 46 35 255 48 45 30 255 71 55 36 255
                 57 52 34 255 68 50 33 255 104 82 46 255
                 102 79 46 255 89 72 44 255 78 60 38 255
                 85 66 36 255 95 70 39 255 105 79 44 255
                 104 77 43 255 103 77 43 255 95 71 39 255
                 93 69 40 255 96 70 40 255 97 73 41 255
                 77 61 38 255 75 63 43 255 33 36 26 255
                 18 18 17 255 25 25 20 255 26 28 21 255
                 26 27 22 255 43 39 27 255 57 56 36 255
                 33 38 26 255 39 37 25 255 36 34 24 255
                 29 34 25 255 24 32 25 255 25 33 24 255
                 26 33 23 255 26 32 23 255 23 30 22 255
                 22 28 22 255 25 29 23 255 34 37 27 255
                 35 39 29 255 29 33 26 255 27 31 24 255
                 27 31 24 255 25 29 22 255 27 31 24 255
                 36 35 28 255 38 35 27 255 33 31 27 255
                 39 36 29 255 45 40 28 255 51 43 27 255
                 59 47 28 255 63 48 29 255 67 47 31 255
                 76 52 35 255 80 59 35 255 77 56 34 255
                 79 56 34 255 73 52 33 255 69 49 32 255
                 72 51 34 255 70 49 32 255 75 54 32 255
                 71 53 34 255 66 49 31 255 71 49 30 255
                 89 61 35 255 93 62 35 255 88 60 33 255
                 82 55 33 255 81 55 33 255 81 56 34 255
                 77 55 35 255 74 54 35 255 66 50 31 255
                 62 46 28 255 68 47 29 255 75 52 34 255
                 69 49 32 255 62 45 28 255 56 42 28 255
                 59 42 29 255 64 46 28 255 68 49 30 255
                 63 45 29 255 65 47 29 255 68 48 31 255
                 72 51 32 255 71 49 32 255 72 48 33 255
                 77 51 35 255 74 53 32 255 68 50 30 255
                 62 44 30 255 64 44 29 255 63 44 29 255
                 63 44 29 255 59 42 28 255 52 37 26 255
                 50 36 25 255 50 37 25 255 43 34 23 255
                 35 28 22 255 32 26 22 255 31 25 22 255
                 32 25 22 255 38 30 23 255 45 33 25 255
                 44 34 24 255 38 29 23 255 41 30 23 255
                 42 31 23 255 47 34 25 255 54 39 27 255
                 49 36 24 255 46 34 24 255 65 46 31 255
                 73 53 33 255 63 46 29 255 68 47 30 255
                 83 59 35 255 90 65 36 255 91 66 36 255
                 90 65 36 255 84 61 34 255 79 58 35 255
                 78 58 36 255 74 56 35 255 69 51 33 255
                 71 52 32 255 79 58 33 255 81 58 33 255
                 83 60 35 255 83 60 34 255 85 61 34 255
                 85 63 35 255 87 66 35 255 89 68 35 255
                 93 69 35 255 93 67 35 255 93 63 36 255
                 95 66 36 255 93 67 37 255 94 68 39 255
                 92 67 39 255 90 66 42 255 90 65 38 255
                 88 64 37 255 88 63 37 255 89 64 37 255
                 91 65 36 255 92 66 37 255 90 66 37 255
                 93 67 38 255 95 67 37 255 95 69 38 255
                 94 69 37 255 87 63 35 255 71 54 33 255
                 59 44 29 255 62 43 28 255 65 46 30 255
                 73 52 34 255 76 54 33 255 71 50 31 255
                 66 46 29 255 64 45 29 255 67 46 30 255
                 69 48 31 255 76 54 33 255 80 56 34 255
                 72 52 33 255 62 46 29 255 62 45 28 255
                 57 42 27 255 58 42 28 255 61 44 28 255
                 56 41 27 255 51 37 26 255 48 35 26 255
                 52 38 25 255 55 39 25 255 56 39 26 255
                 61 42 28 255 63 45 29 255 51 38 26 255
                 46 34 24 255 48 35 24 255 47 34 24 255
                 46 34 24 255 48 35 24 255 46 34 24 255
                 47 35 26 255 45 35 24 255 45 33 24 255
                 43 32 23 255 45 32 23 255 53 38 26 255
                 58 42 26 255 59 42 27 255 58 42 28 255
                 54 39 27 255 54 40 28 255 54 40 27 255
                 52 39 26 255 50 37 26 255 49 37 26 255
                 49 36 25 255 49 35 25 255 48 36 26 255
                 49 37 26 255 46 35 25 255 45 34 26 255
                 47 36 27 255 48 36 26 255 44 34 24 255
                 40 30 23 255 41 32 23 255 42 32 24 255
                 45 33 25 255 50 36 26 255 54 40 27 255
                 52 39 26 255 50 36 25 255 49 36 25 255
                 52 37 26 255 57 40 26 255 63 44 28 255
                 66 47 30 255 62 44 28 255 61 44 28 255
                 59 43 28 255 53 39 26 255 47 35 25 255
                 43 32 24 255 45 34 25 255 36 30 24 255
                 20 19 20 255 12 12 16 255 14 12 16 255
                 34 25 21 255 52 39 26 255 72 55 35 255
                 89 71 45 255 97 82 54 255 100 84 57 255
                 102 82 52 255 104 83 51 255 95 78 50 255
                 90 79 55 255 70 67 46 255 49 44 31 255
                 67 55 38 255 67 58 39 255 62 55 37 255
                 56 51 35 255 68 60 45 255 72 65 45 255
                 77 67 44 255 73 62 38 255 88 69 40 255
                 65 57 36 255 74 56 38 255 73 62 37 255
                 70 53 32 255 101 75 42 255 107 80 45 255
                 108 82 45 255 106 80 44 255 103 77 44 255
                 96 70 40 255 95 69 40 255 99 72 42 255
                 102 77 43 255 86 68 39 255 85 69 45 255
                 62 61 38 255 22 25 20 255 31 29 22 255
                 35 36 24 255 41 39 27 255 70 59 38 255
                 63 59 35 255 48 45 27 255 64 51 32 255
                 35 35 24 255 32 35 25 255 30 35 26 255
                 28 35 26 255 26 33 25 255 28 34 26 255
                 33 38 27 255 35 40 29 255 36 40 29 255
                 34 38 28 255 32 34 26 255 36 34 26 255
                 42 37 27 255 40 36 26 255 34 33 25 255
                 33 33 24 255 39 37 28 255 41 39 28 255
                 34 34 26 255 41 38 27 255 44 39 25 255
                 52 40 26 255 58 42 29 255 57 40 29 255
                 64 44 32 255 70 50 33 255 74 55 33 255
                 78 56 35 255 78 56 33 255 71 51 33 255
                 73 52 32 255 71 52 31 255 76 52 34 255
                 79 55 33 255 68 50 31 255 73 53 34 255
                 82 59 36 255 85 60 36 255 87 61 35 255
                 80 55 32 255 77 53 31 255 77 53 32 255
                 72 51 32 255 71 50 33 255 69 51 34 255
                 63 48 31 255 62 46 29 255 64 45 27 255
                 67 47 30 255 61 44 29 255 56 41 28 255
                 51 39 26 255 55 40 28 255 63 45 31 255
                 69 50 31 255 66 47 28 255 65 46 29 255
                 67 47 30 255 71 50 32 255 71 52 31 255
                 67 49 29 255 67 46 31 255 64 44 29 255
                 60 44 27 255 58 43 27 255 60 42 28 255
                 61 43 28 255 61 43 29 255 53 40 27 255
                 44 33 24 255 44 32 24 255 44 32 24 255
                 40 30 23 255 35 28 22 255 29 25 21 255
                 28 23 21 255 28 23 21 255 32 26 23 255
                 37 29 23 255 35 28 22 255 31 26 22 255
                 36 28 23 255 36 28 22 255 41 31 24 255
                 46 34 25 255 42 32 24 255 46 33 24 255
                 62 44 30 255 73 53 33 255 69 51 31 255
                 61 44 29 255 61 45 30 255 69 49 31 255
                 67 48 31 255 78 56 34 255 80 58 34 255
                 82 59 35 255 81 60 35 255 77 57 34 255
                 72 53 33 255 76 55 33 255 83 60 34 255
                 83 59 34 255 81 58 34 255 86 62 36 255
                 91 67 36 255 90 69 37 255 90 70 38 255
                 92 71 39 255 98 74 39 255 99 73 37 255
                 99 69 37 255 95 67 36 255 92 66 37 255
                 95 68 38 255 92 67 39 255 89 66 41 255
                 90 65 37 255 88 63 36 255 88 63 36 255
                 89 64 37 255 91 66 37 255 92 66 37 255
                 93 67 38 255 96 69 39 255 97 69 38 255
                 94 68 38 255 88 65 37 255 70 52 32 255
                 58 43 28 255 61 43 28 255 59 42 27 255
                 57 40 26 255 64 45 29 255 64 45 30 255
                 64 44 29 255 62 44 29 255 63 45 29 255
                 66 46 30 255 70 50 31 255 72 51 32 255
                 80 56 34 255 70 50 31 255 56 42 27 255
                 57 41 27 255 57 42 26 255 57 42 26 255
                 56 41 26 255 53 39 26 255 50 37 26 255
                 51 38 26 255 57 42 27 255 56 41 26 255
                 61 43 28 255 62 44 28 255 56 41 27 255
                 46 35 24 255 44 33 23 255 45 33 23 255
                 45 33 23 255 45 33 23 255 46 34 24 255
                 43 32 23 255 43 31 24 255 44 33 25 255
                 44 33 24 255 44 32 24 255 50 36 24 255
                 56 40 26 255 59 42 27 255 58 42 26 255
                 56 41 27 255 53 39 26 255 52 39 26 255
                 56 41 27 255 54 41 26 255 48 36 25 255
                 47 35 25 255 46 35 25 255 49 36 25 255
                 47 35 26 255 45 35 25 255 44 33 25 255
                 46 34 25 255 47 36 25 255 46 34 25 255
                 44 34 25 255 41 32 23 255 40 31 23 255
                 42 32 23 255 44 33 24 255 48 36 26 255
                 51 38 26 255 50 37 25 255 48 35 25 255
                 47 34 24 255 51 36 25 255 54 39 25 255
                 55 39 26 255 58 41 27 255 62 43 28 255
                 60 43 27 255 55 40 26 255 50 37 25 255
                 46 34 25 255 36 30 24 255 23 21 21 255
                 18 17 19 255 18 15 18 255 17 16 16 255
                 25 19 18 255 56 41 28 255 81 63 39 255
                 93 77 51 255 96 81 53 255 92 75 49 255
                 94 73 46 255 83 67 42 255 88 69 47 255
                 92 79 53 255 84 75 54 255 77 69 51 255
                 65 59 41 255 61 53 38 255 60 53 39 255
                 53 45 36 255 66 57 42 255 75 68 48 255
                 72 66 47 255 74 67 47 255 81 69 46 255
                 86 72 46 255 68 59 36 255 51 45 31 255
                 60 47 33 255 95 71 41 255 105 78 44 255
                 109 81 45 255 109 82 45 255 108 80 45 255
                 109 77 45 255 99 71 40 255 97 71 39 255
                 99 71 41 255 101 76 43 255 86 68 40 255
                 87 71 48 255 73 69 46 255 25 29 23 255
                 36 31 25 255 63 53 35 255 80 68 43 255
)"
        R"(                 91 76 47 255 90 73 42 255 96 82 45 255
                 86 72 40 255 28 32 23 255 32 34 24 255
                 37 38 27 255 38 40 29 255 40 42 29 255
                 42 45 32 255 38 44 32 255 30 37 27 255
                 27 32 24 255 26 29 23 255 37 35 28 255
                 54 45 33 255 64 53 35 255 60 50 34 255
                 51 44 30 255 43 39 28 255 46 39 29 255
                 56 45 32 255 47 39 27 255 43 35 25 255
                 45 34 25 255 53 37 29 255 56 40 30 255
                 48 34 28 255 56 42 29 255 65 50 30 255
                 71 53 33 255 78 56 36 255 80 58 34 255
                 74 53 34 255 77 54 33 255 83 62 35 255
                 82 58 35 255 78 54 32 255 73 51 29 255
                 80 56 33 255 78 56 34 255 77 55 34 255
                 77 56 34 255 75 54 33 255 76 54 33 255
                 69 49 31 255 65 45 31 255 67 48 32 255
                 64 47 33 255 62 47 31 255 59 46 30 255
                 55 41 26 255 56 40 25 255 51 37 26 255
                 50 37 28 255 51 39 27 255 53 40 26 255
                 58 41 30 255 64 45 32 255 62 44 28 255
                 61 43 26 255 65 46 28 255 69 47 31 255
                 68 49 31 255 62 47 26 255 61 44 28 255
                 66 44 30 255 64 44 29 255 58 42 26 255
                 56 41 27 255 54 39 27 255 55 39 27 255
                 50 37 26 255 41 31 23 255 41 30 23 255
                 40 29 23 255 36 28 23 255 35 28 22 255
                 29 24 21 255 27 23 21 255 27 23 21 255
                 28 24 22 255 30 25 22 255 28 24 21 255
                 27 23 21 255 32 25 22 255 34 26 22 255
                 34 26 22 255 36 28 22 255 36 27 22 255
                 43 31 24 255 53 39 28 255 59 43 29 255
                 61 46 30 255 52 39 27 255 47 36 26 255
                 53 38 27 255 56 41 28 255 64 46 30 255
                 66 46 30 255 70 49 31 255 75 54 33 255
                 76 55 35 255 77 57 36 255 80 59 35 255
                 84 62 36 255 84 61 34 255 82 59 33 255
                 85 61 35 255 89 66 36 255 92 71 37 255
                 94 72 39 255 97 74 40 255 101 74 42 255
                 100 74 39 255 99 71 38 255 96 68 37 255
                 94 68 38 255 98 71 39 255 94 69 40 255
                 91 67 41 255 92 66 37 255 89 64 36 255
                 89 64 36 255 90 64 36 255 92 66 36 255
                 92 66 36 255 93 67 37 255 97 69 39 255
                 95 68 39 255 82 61 36 255 66 50 32 255
                 60 42 28 255 63 45 28 255 60 43 27 255
                 61 43 27 255 65 46 29 255 67 48 30 255
                 65 47 30 255 64 45 29 255 61 43 29 255
                 62 43 29 255 64 45 29 255 65 46 29 255
                 69 48 30 255 76 54 33 255 68 49 31 255
                 63 46 28 255 58 42 27 255 55 41 26 255
                 59 43 27 255 55 41 27 255 51 38 26 255
                 52 38 26 255 51 38 26 255 54 39 27 255
                 58 42 27 255 61 43 28 255 60 42 28 255
                 53 39 26 255 49 36 25 255 46 34 24 255
                 42 30 23 255 43 31 23 255 45 33 24 255
                 46 34 24 255 42 31 23 255 40 29 22 255
                 42 31 24 255 47 35 26 255 49 35 25 255
                 53 38 26 255 57 40 27 255 58 41 26 255
                 56 40 26 255 55 40 27 255 56 41 28 255
                 55 40 26 255 59 42 27 255 57 43 27 255
                 51 38 26 255 46 34 24 255 43 32 23 255
                 46 34 25 255 45 34 24 255 45 34 24 255
                 46 34 25 255 47 35 25 255 47 36 25 255
                 46 35 25 255 44 34 25 255 40 31 24 255
                 40 31 23 255 44 32 23 255 46 35 25 255
                 50 36 26 255 49 36 25 255 46 34 24 255
                 48 34 24 255 50 36 25 255 50 36 25 255
                 51 37 25 255 50 37 25 255 50 37 26 255
                 56 40 27 255 55 40 26 255 48 36 24 255
                 47 34 25 255 48 36 27 255 26 25 22 255
                 12 12 16 255 15 14 17 255 32 25 21 255
                 47 37 25 255 65 51 33 255 87 71 44 255
                 91 77 51 255 88 73 50 255 79 63 41 255
                 81 60 37 255 79 61 39 255 76 60 39 255
                 88 72 48 255 88 78 52 255 85 76 53 255
                 77 70 50 255 44 44 33 255 35 30 27 255
                 41 38 29 255 29 26 24 255 61 51 41 255
                 80 72 57 255 81 74 52 255 74 68 47 255
                 74 67 48 255 75 66 47 255 83 69 44 255
                 54 49 31 255 74 54 34 255 108 82 46 255
                 110 81 45 255 110 82 46 255 108 80 44 255
                 106 78 43 255 111 79 46 255 103 75 42 255
                 99 73 40 255 100 73 41 255 94 72 42 255
                 70 56 36 255 82 65 46 255 70 66 46 255
                 21 25 22 255 18 18 19 255 43 36 29 255
                 79 63 43 255 98 80 52 255 104 83 50 255
                 103 86 52 255 79 72 44 255 37 40 26 255
                 44 46 30 255 44 47 33 255 36 41 31 255
                 30 36 28 255 25 31 25 255 24 30 23 255
                 27 32 24 255 29 32 24 255 29 32 24 255
                 36 35 28 255 53 45 34 255 66 53 38 255
                 71 57 38 255 62 51 33 255 53 46 31 255
                 52 45 30 255 48 38 30 255 54 40 30 255
                 47 34 27 255 41 30 26 255 44 32 28 255
                 53 40 29 255 49 39 26 255 51 41 25 255
                 59 46 29 255 70 51 36 255 77 57 35 255
                 74 56 34 255 71 52 34 255 78 56 34 255
                 85 63 37 255 82 59 36 255 80 55 34 255
                 79 53 33 255 79 53 31 255 73 50 29 255
                 70 50 30 255 71 52 33 255 72 53 34 255
                 72 53 34 255 62 46 31 255 62 45 30 255
                 66 49 32 255 61 46 31 255 58 44 30 255
                 50 39 27 255 43 33 24 255 46 35 23 255
                 42 32 24 255 42 31 25 255 42 32 26 255
                 46 35 25 255 51 39 26 255 53 38 28 255
                 53 38 29 255 52 38 28 255 58 41 25 255
                 63 43 29 255 66 46 32 255 65 48 27 255
                 65 45 28 255 67 43 32 255 68 43 32 255
                 58 39 29 255 53 37 26 255 49 36 24 255
                 44 32 24 255 45 34 25 255 41 30 23 255
                 40 29 22 255 40 30 23 255 36 27 22 255
                 33 27 22 255 29 24 21 255 27 23 21 255
                 26 21 20 255 25 22 20 255 27 23 20 255
                 27 24 20 255 26 22 20 255 29 24 21 255
                 31 25 21 255 31 26 21 255 31 25 22 255
                 34 27 23 255 36 29 23 255 35 28 23 255
                 37 29 24 255 46 34 25 255 46 35 25 255
                 51 38 26 255 52 39 26 255 51 39 27 255
                 55 41 28 255 64 47 29 255 63 45 28 255
                 63 45 28 255 64 47 29 255 69 51 32 255
                 78 58 35 255 83 61 36 255 84 62 35 255
                 89 65 37 255 88 63 36 255 91 68 35 255
                 96 74 36 255 97 74 36 255 98 72 37 255
                 99 72 40 255 98 72 39 255 97 69 37 255
                 95 68 38 255 93 67 38 255 95 68 37 255
                 91 66 38 255 89 64 38 255 91 64 37 255
                 90 65 36 255 92 66 37 255 93 67 37 255
                 93 67 37 255 94 68 37 255 96 70 39 255
                 93 68 39 255 79 59 35 255 61 46 30 255
                 63 44 30 255 69 47 30 255 63 45 29 255
                 63 44 28 255 65 45 29 255 64 45 28 255
                 64 45 29 255 65 47 29 255 64 45 29 255
                 65 46 30 255 67 46 29 255 67 47 29 255
                 67 47 29 255 69 49 30 255 71 50 32 255
                 63 46 30 255 61 45 29 255 39 34 24 255
                 33 27 22 255 56 40 27 255 54 41 28 255
                 53 39 26 255 54 40 27 255 50 37 26 255
                 54 39 27 255 57 42 28 255 58 41 27 255
                 59 41 28 255 59 42 29 255 52 38 26 255
                 47 35 25 255 43 32 23 255 42 30 22 255
                 42 31 23 255 42 31 24 255 40 30 22 255
                 38 28 22 255 39 28 22 255 47 35 27 255
                 50 37 26 255 55 39 26 255 56 41 27 255
                 58 42 27 255 58 42 27 255 56 41 27 255
                 56 41 27 255 55 40 26 255 59 43 28 255
                 59 43 28 255 56 40 27 255 50 36 25 255
                 46 34 24 255 45 33 24 255 45 34 24 255
                 46 35 25 255 46 34 25 255 43 33 24 255
                 43 32 24 255 45 34 26 255 44 34 26 255
                 38 30 23 255 39 29 23 255 44 32 24 255
                 47 35 25 255 49 36 25 255 51 37 26 255
                 49 36 24 255 48 35 24 255 52 38 26 255
                 53 39 26 255 51 38 26 255 51 38 26 255
                 48 35 25 255 50 36 25 255 46 35 25 255
                 32 28 23 255 41 31 26 255 41 34 26 255
                 18 18 18 255 16 14 16 255 41 31 23 255
                 69 54 34 255 85 71 45 255 93 79 52 255
                 83 72 48 255 74 57 40 255 64 50 34 255
                 48 38 28 255 66 50 33 255 67 53 34 255
                 87 67 42 255 93 75 49 255 88 77 52 255
                 86 77 53 255 80 72 50 255 55 54 35 255
                 32 33 26 255 23 24 22 255 32 30 25 255
                 56 50 39 255 57 52 42 255 69 57 47 255
                 72 63 46 255 64 58 43 255 70 63 45 255
                 82 70 47 255 79 65 40 255 98 75 44 255
                 112 84 47 255 114 86 47 255 109 83 44 255
                 105 78 43 255 105 79 44 255 106 78 45 255
                 105 77 44 255 101 75 41 255 95 71 40 255
                 80 61 36 255 64 49 31 255 79 63 43 255
                 59 60 41 255 16 21 20 255 13 15 17 255
                 29 26 22 255 65 53 36 255 78 66 44 255
                 90 74 48 255 70 64 40 255 31 32 26 255
                 40 43 30 255 38 42 30 255 27 35 26 255
                 22 30 24 255 23 29 23 255 25 31 23 255
                 27 33 24 255 29 34 25 255 36 36 27 255
                 36 38 27 255 34 34 28 255 45 39 31 255
                 59 47 34 255 73 57 37 255 75 58 35 255
                 63 51 32 255 63 50 33 255 40 35 25 255
                 45 36 27 255 50 40 27 255 40 31 25 255
                 40 32 25 255 44 36 25 255 44 37 24 255
                 49 40 25 255 54 41 30 255 62 46 34 255
                 70 52 32 255 71 53 33 255 70 51 34 255
                 75 55 33 255 78 57 34 255 76 55 35 255
                 74 52 34 255 74 52 34 255 74 51 32 255
                 67 46 29 255 61 43 27 255 63 45 28 255
                 64 47 30 255 62 46 30 255 57 44 30 255
                 60 45 31 255 61 46 32 255 54 42 29 255
                 47 38 26 255 38 31 23 255 31 26 21 255
                 35 27 21 255 36 27 22 255 35 26 23 255
                 36 27 23 255 39 30 23 255 43 34 23 255
                 43 33 25 255 49 33 28 255 49 35 27 255
                 50 36 24 255 54 38 26 255 60 42 30 255
                 60 45 26 255 56 40 26 255 57 37 29 255
                 58 40 27 255 54 41 25 255 49 36 24 255
                 47 35 24 255 42 32 23 255 44 32 23 255
                 43 31 23 255 39 29 22 255 36 27 22 255
                 36 27 22 255 35 27 22 255 34 26 22 255
                 33 27 22 255 28 24 21 255 26 22 20 255
                 25 21 20 255 25 21 20 255 29 23 21 255
                 29 24 21 255 29 24 21 255 30 25 21 255
                 28 24 21 255 30 25 22 255 31 25 21 255
                 33 26 21 255 33 26 22 255 37 29 23 255
                 43 32 24 255 49 35 25 255 50 38 25 255
                 48 36 26 255 54 40 27 255 59 44 29 255
                 57 42 27 255 62 44 27 255 63 44 28 255
                 59 41 27 255 59 42 28 255 64 46 31 255
                 75 54 33 255 86 63 36 255 90 67 36 255
                 95 73 37 255 99 76 38 255 99 76 37 255
                 97 73 36 255 97 72 37 255 99 72 38 255
                 100 71 39 255 97 70 39 255 96 69 39 255
                 93 66 37 255 89 65 37 255 88 65 39 255
                 89 64 37 255 89 64 37 255 90 64 37 255
                 92 66 37 255 93 67 37 255 95 68 39 255
                 92 68 40 255 76 58 36 255 61 45 29 255
                 63 44 29 255 69 48 31 255 61 43 28 255
                 59 42 28 255 61 43 28 255 64 45 29 255
                 66 47 29 255 66 47 30 255 67 49 31 255
                 69 48 31 255 70 49 30 255 73 52 32 255
                 75 52 31 255 74 53 31 255 72 51 31 255
                 68 49 31 255 60 43 29 255 54 41 27 255
                 23 22 18 255 27 21 18 255 47 34 24 255
                 50 37 26 255 54 39 27 255 54 39 26 255
                 53 38 26 255 54 40 27 255 53 39 27 255
                 55 40 27 255 53 38 27 255 59 42 28 255
                 53 39 26 255 46 34 25 255 41 30 23 255
                 40 29 22 255 41 30 23 255 40 29 23 255
                 40 29 22 255 37 27 21 255 38 27 22 255
                 46 33 27 255 50 37 27 255 56 40 27 255
                 55 40 26 255 51 38 26 255 50 37 26 255
                 54 40 27 255 59 43 28 255 60 44 28 255
                 59 43 28 255 59 43 28 255 56 41 28 255
                 49 37 25 255 49 36 25 255 48 36 25 255
                 46 34 24 255 45 34 24 255 43 32 23 255
                 40 30 23 255 39 30 23 255 44 32 24 255
                 45 34 26 255 40 31 24 255 36 28 22 255
                 40 30 24 255 43 32 23 255 47 35 25 255
                 49 36 25 255 51 36 25 255 47 34 24 255
                 46 34 24 255 49 36 25 255 49 37 25 255
                 47 35 25 255 46 34 25 255 41 31 25 255
                 32 27 23 255 17 17 18 255 29 22 21 255
                 37 30 23 255 28 24 19 255 43 33 24 255
                 76 61 39 255 87 74 49 255 88 76 51 255
                 77 67 46 255 53 46 33 255 66 47 31 255
                 72 54 34 255 48 42 29 255 55 44 31 255
                 78 61 39 255 89 69 43 255 92 76 49 255
                 90 77 51 255 87 76 52 255 85 74 51 255
                 75 66 43 255 33 36 26 255 14 16 18 255
                 18 18 20 255 29 27 27 255 49 43 35 255
                 61 53 39 255 51 45 34 255 62 52 39 255
                 67 59 42 255 73 60 42 255 74 60 39 255
                 86 65 40 255 103 77 45 255 110 82 46 255
                 111 84 46 255 107 79 44 255 105 79 44 255
                 104 78 45 255 104 77 44 255 98 74 42 255
                 84 63 36 255 67 51 31 255 61 45 30 255
                 82 64 45 255 62 62 41 255 18 23 20 255
                 15 18 18 255 31 29 24 255 53 47 32 255
                 46 46 31 255 56 50 36 255 43 44 31 255
                 15 17 18 255 25 30 25 255 28 34 27 255
                 23 32 24 255 23 30 22 255 27 33 25 255
                 32 38 26 255 32 38 26 255 31 35 25 255
                 36 37 28 255 35 36 27 255 37 35 28 255
                 48 40 31 255 65 49 34 255 78 59 36 255
                 83 62 37 255 78 59 35 255 73 56 35 255
                 52 43 28 255 33 29 23 255 46 38 24 255
                 41 34 22 255 37 32 22 255 34 31 22 255
                 34 30 21 255 41 33 24 255 47 35 29 255
                 54 39 31 255 64 47 30 255 69 51 32 255
                 66 48 34 255 66 49 32 255 66 49 30 255
                 72 51 33 255 70 49 32 255 68 48 31 255
                 68 47 31 255 60 42 28 255 54 37 26 255
                 56 39 26 255 57 40 26 255 56 41 27 255
                 56 43 29 255 58 44 30 255 54 41 28 255
                 46 36 24 255 38 31 23 255 33 27 21 255
                 26 22 19 255 27 22 19 255 34 25 21 255
                 36 26 22 255 37 27 23 255 34 27 22 255
                 37 29 21 255 39 29 22 255 45 31 25 255
                 45 31 25 255 45 32 23 255 50 35 25 255
                 55 39 29 255 50 37 25 255 46 33 24 255
                 46 32 24 255 49 37 24 255 49 38 25 255
                 45 34 25 255 43 33 24 255 43 32 23 255
                 45 33 23 255 44 32 23 255 43 32 23 255
                 41 31 22 255 37 28 22 255 38 29 23 255
                 42 31 24 255 44 33 24 255 37 30 23 255
                 31 26 21 255 25 22 20 255 24 21 19 255
                 26 22 20 255 26 21 20 255 25 21 19 255
                 24 21 20 255 25 21 20 255 27 22 20 255
                 29 24 21 255 31 25 21 255 30 25 21 255
                 33 26 21 255 38 28 22 255 49 35 25 255
                 54 40 26 255 54 40 26 255 60 44 28 255
                 58 43 28 255 58 43 26 255 60 41 27 255
                 60 40 27 255 55 40 25 255 52 39 25 255
)"
        R"(                 49 36 25 255 55 39 27 255 67 49 32 255
                 83 60 37 255 92 68 41 255 96 73 40 255
                 97 74 37 255 96 71 36 255 98 70 37 255
                 102 72 40 255 100 71 39 255 93 68 37 255
                 95 68 38 255 93 68 37 255 89 64 37 255
                 87 64 39 255 87 63 36 255 89 63 36 255
                 89 64 35 255 90 65 37 255 92 67 36 255
                 90 65 37 255 76 57 35 255 60 44 30 255
                 67 46 30 255 70 49 31 255 64 46 30 255
                 60 43 28 255 61 44 29 255 62 44 28 255
                 59 42 27 255 64 46 29 255 64 47 30 255
                 68 50 32 255 66 49 32 255 63 45 29 255
                 65 46 31 255 72 50 32 255 74 52 32 255
                 75 54 33 255 67 49 30 255 58 41 27 255
                 53 39 26 255 41 32 21 255 46 34 23 255
                 46 34 24 255 48 35 25 255 51 36 26 255
                 54 39 26 255 54 40 26 255 51 38 26 255
                 52 38 26 255 50 38 25 255 44 33 24 255
                 53 37 26 255 53 38 27 255 48 36 25 255
                 40 29 22 255 37 28 22 255 39 29 23 255
                 38 28 22 255 38 28 22 255 37 28 21 255
                 39 28 22 255 44 32 25 255 49 36 26 255
                 53 38 26 255 52 38 26 255 48 35 25 255
                 45 34 25 255 50 37 26 255 58 43 29 255
                 61 44 29 255 60 44 28 255 59 44 28 255
                 56 41 28 255 50 38 26 255 48 36 25 255
                 46 34 25 255 47 34 24 255 47 35 24 255
                 44 33 23 255 43 32 23 255 39 30 22 255
                 44 33 24 255 46 35 25 255 43 33 24 255
                 39 30 22 255 38 29 22 255 42 30 23 255
                 43 32 23 255 43 31 23 255 47 33 23 255
                 44 32 23 255 40 29 23 255 41 30 23 255
                 39 30 23 255 42 31 24 255 44 33 26 255
                 28 25 22 255 15 15 18 255 13 12 16 255
                 31 23 20 255 52 39 26 255 66 52 31 255
                 79 66 41 255 88 77 52 255 83 75 51 255
                 74 66 45 255 47 44 31 255 36 31 25 255
                 61 45 32 255 66 54 36 255 41 37 28 255
                 52 43 32 255 73 56 37 255 86 69 43 255
                 89 75 51 255 89 72 48 255 83 71 47 255
                 72 63 44 255 66 55 37 255 34 33 24 255
                 24 21 19 255 15 16 18 255 16 15 18 255
                 33 27 26 255 57 48 36 255 50 45 31 255
                 65 52 38 255 69 60 41 255 67 51 35 255
                 79 62 40 255 84 64 39 255 97 73 43 255
                 104 76 44 255 111 84 47 255 108 82 46 255
                 101 77 44 255 95 72 41 255 88 64 39 255
                 82 61 36 255 77 58 34 255 67 52 31 255
                 66 48 30 255 88 69 45 255 72 69 45 255
                 23 28 23 255 17 19 20 255 27 28 23 255
                 37 37 27 255 48 44 29 255 39 39 28 255
                 24 26 23 255 12 14 17 255 20 27 23 255
                 22 31 24 255 23 31 23 255 27 32 24 255
                 38 41 29 255 45 47 31 255 48 49 31 255
                 42 43 29 255 39 36 31 255 43 39 32 255
                 51 44 33 255 61 49 34 255 77 58 36 255
                 81 60 36 255 80 60 36 255 79 59 36 255
                 78 59 36 255 58 46 28 255 27 25 21 255
                 32 29 22 255 36 33 21 255 29 26 20 255
                 28 26 20 255 29 27 21 255 37 31 23 255
                 43 33 27 255 48 35 28 255 58 43 28 255
                 61 46 28 255 56 42 30 255 55 41 29 255
                 58 44 26 255 66 48 30 255 65 47 29 255
                 61 45 28 255 57 43 26 255 54 39 27 255
                 54 37 28 255 54 37 27 255 54 38 26 255
                 51 37 26 255 50 37 25 255 47 36 24 255
                 44 33 24 255 37 29 22 255 33 25 21 255
                 31 24 20 255 25 20 18 255 24 19 18 255
                 34 24 21 255 35 25 22 255 34 26 22 255
                 27 23 20 255 28 23 19 255 33 25 21 255
                 36 26 23 255 40 28 23 255 41 29 22 255
                 43 31 23 255 47 35 26 255 40 32 23 255
                 40 29 23 255 41 29 23 255 42 32 24 255
                 46 31 24 255 45 29 23 255 46 31 24 255
                 42 33 23 255 44 32 23 255 40 29 22 255
                 40 30 23 255 45 33 24 255 42 32 23 255
                 41 31 24 255 49 36 26 255 52 39 26 255
                 48 37 25 255 41 32 23 255 30 25 21 255
                 25 21 19 255 25 21 20 255 23 20 19 255
                 22 19 19 255 21 19 19 255 21 18 18 255
                 22 19 19 255 26 22 21 255 28 23 21 255
                 28 23 20 255 32 25 21 255 40 29 22 255
                 49 35 25 255 52 39 26 255 52 39 28 255
                 61 44 29 255 60 44 28 255 62 44 27 255
                 59 40 26 255 56 41 24 255 53 41 25 255
                 51 36 26 255 53 35 25 255 61 39 26 255
                 60 39 27 255 56 36 27 255 59 40 31 255
                 74 55 35 255 88 66 35 255 95 67 36 255
                 98 67 39 255 102 72 42 255 92 67 37 255
                 76 55 33 255 83 58 35 255 85 62 35 255
                 84 59 35 255 89 64 38 255 92 65 37 255
                 94 67 37 255 98 70 38 255 97 71 39 255
                 88 66 36 255 72 54 33 255 67 48 31 255
                 74 51 32 255 76 55 33 255 68 48 30 255
                 66 47 29 255 65 46 29 255 65 46 31 255
                 63 45 29 255 61 43 29 255 64 46 31 255
                 65 47 31 255 62 46 31 255 55 41 29 255
                 53 39 27 255 56 41 28 255 61 44 29 255
                 68 48 30 255 78 55 33 255 69 50 30 255
                 61 44 27 255 55 40 25 255 55 39 26 255
                 59 42 27 255 57 41 26 255 53 38 25 255
                 50 36 25 255 52 37 25 255 54 40 27 255
                 51 38 26 255 51 38 26 255 49 36 25 255
                 51 37 25 255 56 40 27 255 53 39 27 255
                 45 34 24 255 38 28 22 255 36 27 22 255
                 36 27 22 255 37 27 22 255 40 29 22 255
                 39 29 22 255 41 30 22 255 42 31 24 255
                 47 35 25 255 48 35 25 255 47 35 25 255
                 48 36 25 255 48 36 25 255 51 38 26 255
                 58 42 28 255 61 44 28 255 58 43 28 255
                 57 42 28 255 53 40 27 255 49 36 26 255
                 48 35 25 255 48 35 25 255 48 36 25 255
                 48 36 25 255 48 35 25 255 47 35 24 255
                 45 33 23 255 45 34 24 255 43 33 24 255
                 42 32 23 255 38 29 22 255 37 28 22 255
                 39 29 22 255 38 28 22 255 38 28 22 255
                 40 30 23 255 36 28 22 255 32 25 21 255
                 35 27 23 255 41 31 25 255 46 35 26 255
                 38 31 24 255 18 18 18 255 18 16 17 255
                 29 22 19 255 64 48 32 255 84 69 43 255
                 92 77 50 255 88 75 49 255 83 71 49 255
                 74 67 47 255 54 53 38 255 22 25 22 255
                 19 18 20 255 48 36 29 255 62 51 35 255
                 52 48 33 255 36 32 26 255 65 51 36 255
                 77 65 45 255 75 62 43 255 67 54 38 255
                 50 47 35 255 26 27 25 255 25 23 23 255
                 21 19 20 255 35 28 24 255 36 31 22 255
                 33 28 22 255 22 22 21 255 49 38 31 255
                 65 55 36 255 65 52 37 255 68 58 40 255
                 58 45 32 255 72 56 39 255 74 59 37 255
                 83 64 40 255 92 68 42 255 96 71 44 255
                 90 67 41 255 80 60 37 255 70 52 33 255
                 69 49 32 255 67 50 32 255 61 47 30 255
                 60 45 29 255 67 51 33 255 71 57 39 255
                 59 55 40 255 25 30 23 255 18 20 19 255
                 26 29 23 255 41 37 27 255 70 56 34 255
                 43 43 28 255 16 18 20 255 12 14 17 255
                 26 30 23 255 30 35 25 255 30 36 26 255
                 36 38 27 255 46 47 32 255 46 48 31 255
                 50 49 34 255 55 49 33 255 61 49 36 255
                 69 54 38 255 72 56 36 255 79 60 37 255
                 85 64 37 255 84 64 37 255 81 61 36 255
                 76 58 35 255 79 60 35 255 60 47 29 255
                 28 25 22 255 27 25 20 255 36 32 21 255
                 31 28 20 255 27 25 19 255 29 26 19 255
                 35 29 22 255 42 33 26 255 47 35 29 255
                 51 38 27 255 55 42 26 255 51 38 27 255
                 49 37 28 255 53 39 27 255 58 42 27 255
                 56 41 26 255 53 39 25 255 49 38 23 255
                 48 36 24 255 50 37 26 255 51 37 27 255
                 50 36 27 255 47 34 25 255 44 32 24 255
                 38 29 23 255 36 27 22 255 36 27 22 255
                 34 26 21 255 29 22 20 255 27 21 18 255
                 24 19 19 255 31 22 20 255 32 23 21 255
                 34 26 22 255 28 23 19 255 26 23 18 255
                 29 23 19 255 34 24 21 255 37 26 22 255
                 36 26 21 255 35 26 20 255 38 28 24 255
                 36 28 22 255 37 28 21 255 35 25 22 255
                 38 29 23 255 45 30 23 255 45 29 21 255
                 45 29 23 255 43 32 24 255 40 32 23 255
                 36 27 22 255 37 28 23 255 42 31 24 255
                 42 31 24 255 46 35 26 255 51 38 27 255
                 53 40 27 255 53 40 27 255 50 39 26 255
                 38 31 23 255 29 24 20 255 27 23 21 255
                 24 21 19 255 21 19 19 255 19 18 18 255
                 19 17 18 255 21 18 18 255 24 21 20 255
                 28 23 21 255 29 24 21 255 33 27 22 255
                 40 29 23 255 45 32 24 255 43 33 24 255
                 47 35 26 255 57 41 28 255 56 41 27 255
                 56 41 26 255 54 38 26 255 49 39 25 255
                 42 34 25 255 43 29 23 255 44 30 22 255
                 53 35 23 255 57 38 24 255 54 35 23 255
                 47 32 25 255 44 35 26 255 57 41 28 255
                 73 49 33 255 83 57 35 255 89 66 37 255
                 82 62 35 255 77 56 34 255 82 59 34 255
                 83 60 34 255 87 61 34 255 93 66 38 255
                 95 68 38 255 95 69 39 255 98 70 40 255
                 90 67 39 255 68 53 32 255 61 45 29 255
                 77 54 33 255 73 53 32 255 65 46 30 255
                 70 49 31 255 69 48 29 255 66 46 29 255
                 65 45 29 255 65 47 29 255 59 44 28 255
                 59 44 28 255 61 45 29 255 53 41 28 255
                 50 37 27 255 49 37 26 255 49 36 26 255
                 51 37 27 255 66 45 29 255 77 54 32 255
                 69 50 30 255 69 48 30 255 62 44 27 255
                 61 42 28 255 60 41 27 255 59 42 27 255
                 59 43 27 255 55 40 26 255 53 38 25 255
                 54 40 26 255 53 38 26 255 53 39 26 255
                 49 36 25 255 50 37 25 255 53 38 26 255
                 51 38 26 255 45 34 23 255 42 30 23 255
                 38 28 22 255 36 27 22 255 36 26 22 255
                 37 27 22 255 35 26 21 255 38 28 22 255
                 40 30 23 255 43 33 25 255 45 33 24 255
                 45 34 24 255 47 35 25 255 46 35 25 255
                 51 38 26 255 56 41 28 255 61 44 29 255
                 63 46 30 255 61 45 29 255 57 43 28 255
                 52 39 26 255 48 35 25 255 48 35 25 255
                 51 37 26 255 50 37 25 255 50 36 25 255
                 49 36 25 255 49 36 25 255 47 35 25 255
                 43 33 24 255 38 29 22 255 36 28 22 255
                 38 29 23 255 37 29 22 255 35 27 22 255
                 33 26 22 255 32 25 22 255 32 25 22 255
                 32 25 22 255 32 26 23 255 29 24 22 255
                 39 31 24 255 34 28 22 255 33 26 21 255
                 56 43 28 255 74 59 39 255 89 74 48 255
                 87 75 50 255 78 65 45 255 63 52 36 255
                 56 47 35 255 56 48 37 255 45 46 33 255
                 15 18 18 255 18 15 18 255 54 41 31 255
                 63 53 37 255 52 44 30 255 46 39 29 255
                 44 41 33 255 33 31 29 255 40 33 29 255
                 39 33 28 255 28 26 24 255 25 23 21 255
                 18 19 19 255 15 16 19 255 30 23 23 255
                 47 38 29 255 39 34 27 255 42 36 27 255
                 63 54 37 255 62 52 36 255 71 58 39 255
                 68 60 41 255 60 48 33 255 69 55 38 255
                 63 51 33 255 62 47 32 255 70 52 34 255
                 71 51 34 255 68 49 33 255 62 45 30 255
                 61 44 29 255 59 43 29 255 53 40 27 255
                 49 37 25 255 53 40 27 255 38 34 26 255
                 27 25 23 255 30 27 25 255 46 41 30 255
                 46 44 28 255 46 42 27 255 73 58 35 255
                 83 67 40 255 48 45 30 255 20 21 20 255
                 13 14 18 255 37 38 25 255 44 43 28 255
                 45 46 30 255 50 51 32 255 51 51 33 255
                 53 51 32 255 58 52 35 255 64 53 36 255
                 84 63 40 255 101 76 44 255 103 78 43 255
                 99 74 42 255 93 69 39 255 86 65 38 255
                 82 62 37 255 81 60 36 255 85 64 36 255
                 58 47 30 255 32 28 23 255 28 26 20 255
                 35 30 22 255 42 35 22 255 33 30 21 255
                 34 31 21 255 37 32 21 255 42 34 24 255
                 45 36 26 255 47 35 27 255 51 38 26 255
                 50 38 24 255 47 35 26 255 48 34 27 255
                 53 38 28 255 52 36 27 255 50 36 26 255
                 48 35 24 255 45 33 23 255 45 34 24 255
                 45 34 24 255 45 34 24 255 46 34 24 255
                 42 32 24 255 34 28 23 255 34 27 22 255
                 36 27 22 255 34 26 21 255 27 22 20 255
                 28 22 20 255 27 21 19 255 27 22 19 255
                 28 22 21 255 32 25 21 255 27 23 18 255
                 24 21 18 255 27 20 19 255 33 24 21 255
                 35 26 22 255 32 24 19 255 29 23 17 255
                 30 22 20 255 29 23 20 255 33 26 20 255
                 33 24 21 255 36 27 21 255 40 28 22 255
                 43 27 21 255 43 28 23 255 43 32 25 255
                 38 33 22 255 33 26 21 255 37 26 24 255
                 42 31 23 255 48 35 25 255 47 35 26 255
                 47 35 26 255 52 38 26 255 56 40 27 255
                 56 41 27 255 45 35 24 255 30 26 21 255
                 27 23 21 255 26 22 20 255 23 20 19 255
                 20 18 18 255 21 19 18 255 22 20 19 255
                 24 21 20 255 26 22 20 255 28 24 21 255
                 31 25 21 255 37 27 22 255 40 29 22 255
                 36 28 22 255 40 31 23 255 54 39 26 255
                 53 40 26 255 45 35 24 255 42 30 24 255
                 38 30 22 255 38 31 23 255 48 33 24 255
                 51 33 22 255 53 34 22 255 58 38 23 255
                 52 34 22 255 48 34 25 255 48 37 26 255
                 51 36 26 255 51 34 25 255 57 41 26 255
                 66 48 30 255 69 50 33 255 75 53 34 255
                 85 61 35 255 88 63 36 255 90 63 36 255
                 93 67 38 255 91 66 38 255 89 65 37 255
                 87 64 38 255 66 51 33 255 61 44 29 255
                 76 53 32 255 87 61 35 255 78 56 31 255
                 68 48 29 255 76 53 32 255 73 51 31 255
                 69 48 30 255 66 46 29 255 66 47 30 255
                 60 44 29 255 55 41 27 255 57 42 27 255
                 51 38 27 255 48 36 26 255 46 35 25 255
                 49 37 26 255 47 35 24 255 63 44 28 255
                 74 53 31 255 74 52 32 255 74 51 31 255
                 70 50 30 255 64 45 29 255 60 41 27 255
                 57 40 26 255 58 41 27 255 58 42 27 255
                 56 40 26 255 56 41 27 255 55 40 27 255
                 46 34 24 255 43 32 23 255 45 34 24 255
                 50 36 26 255 46 35 25 255 42 32 23 255
                 40 30 23 255 37 28 22 255 33 26 21 255
                 32 25 21 255 31 25 21 255 30 24 20 255
                 32 25 21 255 35 26 22 255 39 29 24 255
                 40 30 23 255 41 31 23 255 43 32 24 255
                 46 35 25 255 50 37 26 255 55 41 28 255
                 62 45 30 255 66 49 32 255 65 49 31 255
                 58 43 28 255 55 40 28 255 52 38 26 255
                 50 36 26 255 51 38 26 255 51 37 26 255
                 49 36 25 255 48 35 25 255 49 36 25 255
                 49 36 25 255 46 35 25 255 37 29 22 255
                 34 27 22 255 38 30 23 255 36 29 22 255
                 34 27 22 255 35 28 22 255 34 27 23 255
                 29 24 21 255 22 19 20 255 21 19 19 255
                 24 19 19 255 41 32 24 255 57 43 28 255
                 77 62 37 255 90 75 47 255 90 76 51 255
                 79 68 47 255 51 46 35 255 45 35 28 255
                 31 28 23 255 31 27 23 255 48 38 28 255
)"
        R"(                 49 45 33 255 20 22 20 255 25 21 20 255
                 51 40 29 255 62 49 33 255 70 57 37 255
                 59 55 39 255 22 26 25 255 14 15 19 255
                 30 26 25 255 23 23 22 255 35 28 24 255
                 60 49 33 255 48 44 28 255 27 27 22 255
                 42 33 25 255 33 30 24 255 45 37 29 255
                 68 59 42 255 69 63 42 255 61 53 36 255
                 75 65 45 255 70 63 43 255 68 59 39 255
                 67 55 37 255 54 43 29 255 52 39 28 255
                 57 42 29 255 54 39 28 255 57 41 28 255
                 59 42 28 255 59 42 27 255 53 39 26 255
                 41 32 24 255 41 31 23 255 45 35 25 255
                 25 24 20 255 14 15 16 255 24 21 20 255
                 59 48 35 255 81 72 44 255 75 63 37 255
                 94 73 43 255 91 73 42 255 78 63 36 255
                 51 48 29 255 22 23 20 255 44 47 31 255
                 52 52 32 255 53 50 33 255 58 54 35 255
                 59 52 35 255 62 54 36 255 67 56 36 255
                 79 61 38 255 105 77 45 255 113 84 47 255
                 114 85 47 255 105 80 44 255 98 73 42 255
                 92 69 41 255 88 65 39 255 86 64 37 255
                 74 56 34 255 55 43 30 255 44 37 25 255
                 39 33 22 255 34 28 22 255 44 34 25 255
                 33 28 23 255 33 27 22 255 37 30 22 255
                 41 34 23 255 44 36 24 255 43 33 26 255
                 44 33 27 255 43 32 25 255 42 33 23 255
                 49 36 24 255 53 38 27 255 52 38 27 255
                 50 36 27 255 47 33 26 255 41 30 23 255
                 41 30 23 255 43 31 23 255 42 32 23 255
                 44 34 24 255 40 31 23 255 35 28 22 255
                 34 27 22 255 30 25 21 255 28 23 20 255
                 27 23 19 255 30 25 20 255 28 24 19 255
                 27 23 19 255 26 22 19 255 25 21 19 255
                 22 20 17 255 21 18 17 255 24 19 19 255
                 28 21 21 255 32 23 21 255 31 23 19 255
                 31 23 18 255 30 22 18 255 27 20 19 255
                 29 22 19 255 32 25 20 255 32 24 20 255
                 34 26 21 255 38 28 22 255 39 29 23 255
                 42 33 24 255 39 33 22 255 37 28 21 255
                 39 27 23 255 43 30 24 255 52 38 25 255
                 46 35 25 255 45 33 25 255 47 35 26 255
                 56 40 27 255 55 40 26 255 49 37 26 255
                 33 27 22 255 26 22 21 255 26 22 20 255
                 25 22 20 255 23 20 19 255 22 19 18 255
                 23 20 19 255 26 22 20 255 26 23 20 255
                 29 24 21 255 29 24 21 255 33 25 21 255
                 37 28 22 255 36 29 22 255 34 27 22 255
                 44 33 25 255 46 35 25 255 41 31 23 255
                 47 34 25 255 48 35 25 255 48 38 25 255
                 56 42 28 255 59 39 27 255 61 38 27 255
                 60 39 25 255 52 34 23 255 48 33 25 255
                 50 38 26 255 48 36 24 255 47 34 23 255
                 52 36 21 255 49 35 23 255 53 36 26 255
                 65 45 30 255 78 56 33 255 89 63 36 255
                 86 62 36 255 88 64 37 255 87 63 36 255
                 80 58 34 255 65 49 31 255 64 45 30 255
                 79 56 34 255 78 57 35 255 83 59 36 255
                 83 60 35 255 82 59 34 255 87 62 35 255
                 82 57 32 255 75 53 31 255 74 52 31 255
                 72 52 32 255 68 50 31 255 60 45 28 255
                 51 38 25 255 51 37 26 255 54 39 28 255
                 48 37 27 255 52 39 27 255 54 40 27 255
                 64 47 30 255 69 50 32 255 74 52 33 255
                 74 52 32 255 71 50 31 255 61 44 28 255
                 56 39 27 255 55 39 26 255 54 39 26 255
                 56 39 27 255 58 41 26 255 58 42 27 255
                 55 40 27 255 47 34 25 255 48 34 24 255
                 50 37 25 255 49 36 26 255 45 34 24 255
                 42 32 24 255 38 28 23 255 35 27 22 255
                 31 25 20 255 30 23 20 255 29 23 20 255
                 29 23 20 255 30 24 20 255 30 24 21 255
                 31 24 21 255 34 27 24 255 35 28 22 255
                 41 30 23 255 46 35 25 255 50 37 26 255
                 54 40 28 255 58 44 30 255 59 45 30 255
                 61 45 30 255 57 42 28 255 54 40 28 255
                 51 38 26 255 51 37 26 255 52 38 25 255
                 52 38 26 255 47 35 25 255 44 32 23 255
                 46 33 24 255 46 34 24 255 44 33 24 255
                 42 32 23 255 40 31 23 255 37 29 22 255
                 36 28 22 255 29 25 21 255 31 26 23 255
                 22 20 20 255 18 17 18 255 21 17 19 255
                 24 21 19 255 42 31 24 255 73 57 36 255
                 89 74 47 255 93 80 52 255 85 72 49 255
                 69 55 38 255 55 42 29 255 40 32 23 255
                 39 31 23 255 21 19 18 255 34 24 21 255
                 64 48 32 255 56 48 34 255 47 45 33 255
                 53 49 33 255 65 54 35 255 74 60 41 255
                 76 65 46 255 47 48 36 255 14 17 20 255
                 14 13 18 255 21 20 21 255 26 23 22 255
                 48 38 29 255 45 41 32 255 37 35 29 255
                 28 27 24 255 54 44 33 255 55 50 35 255
                 68 60 41 255 76 69 49 255 73 68 47 255
                 69 64 44 255 66 61 45 255 67 61 43 255
                 72 62 43 255 66 53 35 255 48 37 26 255
                 44 33 24 255 47 35 26 255 45 34 24 255
                 56 39 27 255 62 44 29 255 61 44 28 255
                 50 39 26 255 40 32 24 255 54 39 27 255
                 63 49 30 255 51 44 27 255 22 24 19 255
                 28 24 21 255 57 46 33 255 82 70 49 255
                 89 79 51 255 84 68 43 255 90 70 42 255
                 90 69 42 255 88 70 40 255 76 64 35 255
                 57 55 34 255 58 55 35 255 57 52 35 255
                 71 57 37 255 86 68 42 255 90 72 42 255
                 99 78 44 255 114 88 48 255 121 92 51 255
                 115 87 47 255 102 76 43 255 85 63 37 255
                 79 59 37 255 86 64 39 255 88 65 39 255
                 75 58 36 255 51 41 28 255 51 39 30 255
                 58 47 28 255 56 45 27 255 46 36 25 255
                 41 30 26 255 42 30 26 255 37 27 25 255
                 38 28 24 255 42 32 24 255 45 37 23 255
                 45 36 24 255 41 32 26 255 38 29 25 255
                 39 29 23 255 47 35 23 255 50 37 23 255
                 51 37 24 255 52 37 24 255 48 35 25 255
                 42 32 25 255 40 30 24 255 42 30 24 255
                 42 31 24 255 44 32 24 255 41 30 23 255
                 37 28 23 255 32 26 22 255 30 24 21 255
                 29 24 20 255 28 23 20 255 27 23 20 255
                 25 21 19 255 24 21 17 255 24 20 18 255
                 22 20 18 255 20 18 17 255 22 18 18 255
                 22 18 19 255 25 19 19 255 29 21 20 255
                 29 22 19 255 30 23 18 255 31 23 18 255
                 30 22 19 255 29 21 20 255 30 23 19 255
                 29 22 19 255 31 23 19 255 33 25 19 255
                 36 27 20 255 40 31 21 255 38 31 21 255
                 34 26 20 255 36 25 22 255 39 27 24 255
                 48 33 27 255 49 36 26 255 46 35 24 255
                 42 32 24 255 45 33 25 255 51 37 26 255
                 54 39 26 255 44 35 24 255 31 26 21 255
                 27 23 20 255 26 22 20 255 24 21 19 255
                 24 21 19 255 28 23 20 255 30 24 20 255
                 29 25 21 255 28 24 20 255 29 24 21 255
                 31 25 21 255 37 28 23 255 42 32 24 255
                 38 30 22 255 40 31 24 255 43 33 23 255
                 44 32 24 255 50 37 25 255 54 39 27 255
                 56 40 26 255 58 44 29 255 60 44 30 255
                 61 42 30 255 54 37 27 255 49 32 25 255
                 47 32 25 255 49 37 26 255 49 37 23 255
                 54 36 24 255 54 36 21 255 49 34 21 255
                 49 31 23 255 48 32 24 255 59 39 26 255
                 74 51 31 255 78 54 33 255 78 56 33 255
                 71 52 32 255 63 46 30 255 60 43 29 255
                 74 51 33 255 83 60 36 255 75 55 34 255
                 79 55 34 255 81 56 34 255 80 57 34 255
                 71 51 32 255 76 53 33 255 80 56 33 255
                 80 57 33 255 75 54 33 255 76 55 33 255
                 69 52 32 255 58 43 27 255 56 41 26 255
                 53 39 27 255 49 37 27 255 48 36 26 255
                 52 38 27 255 63 45 30 255 68 49 32 255
                 72 51 33 255 74 52 33 255 68 48 31 255
                 60 42 28 255 57 39 26 255 56 40 26 255
                 53 38 26 255 54 38 27 255 57 41 27 255
                 60 43 28 255 59 42 28 255 51 37 26 255
                 50 36 25 255 53 38 26 255 51 37 27 255
                 47 35 25 255 47 34 25 255 43 32 24 255
                 37 28 22 255 32 26 21 255 30 24 20 255
                 30 25 20 255 31 24 21 255 31 24 21 255
                 31 25 21 255 29 24 20 255 31 24 21 255
                 35 26 21 255 41 30 22 255 44 33 24 255
                 49 37 27 255 53 39 27 255 55 41 28 255
                 55 41 28 255 56 41 28 255 57 42 28 255
                 53 39 27 255 51 37 26 255 53 38 26 255
                 54 39 25 255 52 38 26 255 46 34 24 255
                 42 31 23 255 44 32 23 255 43 32 23 255
                 42 32 22 255 43 33 24 255 41 32 24 255
                 41 31 23 255 37 29 24 255 19 18 19 255
                 27 22 21 255 27 23 20 255 24 21 19 255
                 35 27 22 255 57 44 29 255 82 64 42 255
                 93 80 52 255 90 79 53 255 78 65 43 255
                 63 50 33 255 56 41 28 255 57 40 26 255
                 56 41 26 255 55 41 26 255 48 36 24 255
                 55 39 25 255 65 48 31 255 43 38 30 255
                 50 42 35 255 70 62 45 255 72 65 46 255
                 72 64 47 255 68 62 45 255 30 33 27 255
                 12 13 17 255 22 18 19 255 36 30 25 255
                 44 36 28 255 35 31 27 255 24 24 23 255
                 34 29 25 255 48 40 29 255 59 52 36 255
                 48 43 32 255 72 62 44 255 77 70 50 255
                 71 66 49 255 66 62 45 255 57 55 41 255
                 46 45 36 255 53 44 34 255 57 44 31 255
                 46 36 25 255 44 33 25 255 46 34 25 255
                 48 35 26 255 57 41 27 255 62 44 29 255
                 57 44 28 255 45 39 26 255 52 42 28 255
                 73 55 33 255 62 53 33 255 52 45 30 255
                 25 27 22 255 28 26 23 255 35 33 26 255
                 48 40 34 255 87 73 53 255 87 78 50 255
                 85 69 41 255 90 70 41 255 97 74 43 255
                 110 86 49 255 62 53 35 255 57 48 33 255
                 59 49 34 255 75 58 39 255 112 87 53 255
                 120 96 56 255 119 94 54 255 113 87 50 255
                 103 79 47 255 94 70 41 255 84 63 38 255
                 78 58 36 255 75 55 34 255 74 54 34 255
                 73 54 35 255 61 46 31 255 47 37 28 255
                 56 44 31 255 67 53 32 255 65 49 33 255
                 60 43 32 255 45 31 27 255 48 34 28 255
                 39 28 26 255 37 26 25 255 43 30 26 255
                 48 35 25 255 48 38 24 255 43 35 24 255
                 40 31 25 255 39 29 25 255 47 34 25 255
                 50 36 24 255 49 36 23 255 52 37 23 255
                 51 37 23 255 46 35 24 255 42 32 24 255
                 42 31 24 255 46 33 24 255 49 36 25 255
                 44 33 24 255 38 30 23 255 34 27 22 255
                 34 27 22 255 31 25 21 255 28 22 20 255
                 29 23 21 255 26 22 20 255 21 19 18 255
                 22 18 18 255 22 19 19 255 22 18 18 255
                 23 19 20 255 23 18 19 255 25 19 20 255
                 26 20 20 255 26 19 20 255 27 20 19 255
                 27 21 17 255 30 22 18 255 29 22 19 255
                 27 20 19 255 27 21 18 255 32 23 19 255
                 35 24 20 255 36 24 20 255 37 25 21 255
                 39 26 22 255 39 27 22 255 36 26 22 255
                 35 26 21 255 41 29 24 255 46 32 26 255
                 48 34 26 255 45 34 24 255 41 32 23 255
                 46 34 25 255 52 37 27 255 50 37 25 255
                 41 31 23 255 30 25 21 255 26 22 20 255
                 24 21 19 255 27 22 20 255 34 26 22 255
                 34 27 21 255 30 25 21 255 27 23 20 255
                 28 24 20 255 31 25 21 255 39 29 23 255
                 45 33 25 255 47 35 24 255 47 35 26 255
                 47 36 25 255 47 34 25 255 49 37 25 255
                 55 41 27 255 62 43 29 255 56 41 26 255
                 52 41 27 255 53 40 28 255 47 35 27 255
                 47 31 26 255 52 34 26 255 52 36 27 255
                 50 37 23 255 54 36 22 255 52 33 22 255
                 51 33 20 255 49 32 21 255 50 31 22 255
                 57 35 23 255 59 39 25 255 58 39 27 255
                 60 43 30 255 57 41 28 255 63 44 29 255
                 73 50 31 255 79 55 34 255 81 58 35 255
                 75 54 33 255 79 56 33 255 82 57 34 255
                 76 55 33 255 61 45 29 255 61 43 28 255
                 69 46 29 255 71 50 32 255 72 51 33 255
                 77 55 32 255 72 52 31 255 69 50 31 255
                 66 48 30 255 58 42 28 255 54 40 26 255
                 49 36 25 255 53 39 27 255 60 43 28 255
                 59 43 29 255 59 43 29 255 70 50 33 255
                 65 46 30 255 63 43 28 255 62 42 27 255
                 59 42 28 255 54 39 27 255 55 38 27 255
                 50 37 26 255 56 39 27 255 60 42 28 255
                 56 40 27 255 53 38 26 255 54 39 27 255
                 54 39 27 255 50 37 25 255 49 36 25 255
                 46 34 25 255 42 32 23 255 37 28 22 255
                 33 26 22 255 30 24 21 255 29 23 21 255
                 30 23 21 255 31 24 21 255 32 25 21 255
                 32 25 21 255 35 26 22 255 37 28 22 255
                 39 29 23 255 45 33 25 255 51 38 27 255
                 53 39 28 255 57 41 27 255 56 42 27 255
                 57 42 28 255 55 40 27 255 53 39 26 255
                 53 39 26 255 54 40 25 255 52 39 26 255
                 47 36 24 255 44 33 23 255 44 33 23 255
                 43 32 23 255 43 33 24 255 42 33 24 255
                 46 35 25 255 49 36 26 255 36 30 23 255
                 19 17 17 255 40 29 23 255 47 37 25 255
                 54 43 28 255 73 59 37 255 90 75 49 255
                 96 81 57 255 87 75 51 255 67 56 38 255
                 58 45 30 255 55 41 26 255 55 39 26 255
                 55 39 26 255 55 39 27 255 61 42 27 255
                 67 47 29 255 70 50 30 255 66 49 30 255
                 36 31 23 255 43 35 28 255 60 50 38 255
                 67 59 43 255 73 63 46 255 59 56 42 255
                 19 22 21 255 21 18 19 255 53 41 30 255
                 69 55 37 255 63 55 38 255 46 42 31 255
                 50 46 32 255 66 55 36 255 74 61 39 255
                 73 62 42 255 73 64 42 255 73 65 45 255
                 72 63 47 255 70 64 47 255 58 58 42 255
                 36 39 32 255 20 21 22 255 38 30 25 255
                 44 34 26 255 43 33 25 255 48 36 26 255
                 50 38 26 255 50 37 27 255 53 39 26 255
                 53 40 28 255 37 34 25 255 29 30 24 255
                 48 40 29 255 72 56 34 255 53 47 31 255
                 47 41 30 255 24 26 22 255 23 23 22 255
                 23 25 21 255 28 25 22 255 69 56 43 255
                 95 84 58 255 89 79 48 255 85 68 41 255
                 93 71 41 255 106 80 48 255 68 53 32 255
                 62 48 31 255 71 54 35 255 67 50 34 255
                 86 63 42 255 93 69 44 255 87 65 40 255
                 83 62 37 255 76 56 35 255 71 52 34 255
                 77 56 36 255 77 56 36 255 79 57 35 255
                 77 56 35 255 66 49 32 255 60 46 31 255
                 59 45 33 255 67 53 34 255 72 55 36 255
                 66 47 35 255 67 46 34 255 54 40 27 255
                 49 37 26 255 42 35 24 255 33 27 23 255
                 36 28 24 255 44 31 27 255 47 33 26 255
                 47 36 24 255 44 35 23 255 37 30 24 255
                 42 31 27 255 45 33 26 255 48 35 24 255
                 50 37 23 255 49 37 22 255 47 36 23 255
                 41 32 22 255 43 33 23 255 48 36 24 255
                 51 38 25 255 44 33 24 255 38 29 23 255
                 37 28 23 255 35 27 22 255 36 28 21 255
                 35 28 21 255 39 30 22 255 31 25 21 255
                 25 21 20 255 23 20 19 255 25 20 19 255
                 26 20 20 255 27 21 21 255 24 19 20 255
                 20 17 19 255 22 17 19 255 25 18 19 255
)"
        R"(                 25 19 19 255 23 18 18 255 25 20 18 255
                 28 22 17 255 28 22 18 255 28 21 19 255
                 30 22 19 255 31 24 20 255 33 25 20 255
                 33 25 21 255 38 26 24 255 42 28 24 255
                 36 27 21 255 33 28 20 255 36 29 21 255
                 36 30 22 255 43 32 25 255 42 31 25 255
                 45 34 24 255 45 35 24 255 49 36 27 255
                 52 38 26 255 45 35 24 255 34 28 22 255
                 26 22 20 255 24 21 19 255 28 23 20 255
                 31 25 22 255 30 25 22 255 30 25 21 255
                 28 23 21 255 28 23 21 255 31 25 22 255
                 44 33 24 255 50 37 25 255 53 38 27 255
                 52 39 26 255 44 34 24 255 45 34 24 255
                 49 37 26 255 52 39 26 255 60 44 28 255
                 54 37 26 255 50 38 24 255 50 41 26 255
                 46 36 28 255 50 34 27 255 54 34 25 255
                 55 36 26 255 54 37 24 255 51 36 21 255
                 52 33 22 255 53 33 21 255 50 33 20 255
                 51 33 22 255 57 35 23 255 59 39 23 255
                 52 37 24 255 53 38 27 255 61 44 31 255
                 74 53 33 255 81 56 35 255 81 57 35 255
                 81 56 34 255 82 58 34 255 82 58 34 255
                 85 60 35 255 79 57 33 255 67 49 31 255
                 64 45 29 255 64 44 28 255 65 45 29 255
                 66 47 30 255 63 46 29 255 59 43 28 255
                 66 48 31 255 70 50 32 255 69 48 31 255
                 66 48 30 255 64 47 29 255 66 47 29 255
                 73 53 31 255 68 50 31 255 60 44 30 255
                 64 46 31 255 67 48 30 255 69 50 31 255
                 64 46 29 255 60 44 29 255 60 43 29 255
                 57 41 27 255 55 39 26 255 59 42 27 255
                 60 42 28 255 56 40 27 255 52 38 26 255
                 53 39 27 255 55 40 28 255 51 39 26 255
                 45 35 25 255 43 32 24 255 43 32 24 255
                 38 30 23 255 33 26 22 255 30 25 22 255
                 29 23 20 255 29 23 20 255 29 24 20 255
                 29 23 20 255 28 23 20 255 31 24 21 255
                 34 26 22 255 33 26 22 255 38 29 23 255
                 43 32 24 255 49 36 26 255 54 40 27 255
                 57 42 28 255 58 43 28 255 57 41 28 255
                 57 41 28 255 57 42 27 255 54 41 26 255
                 54 41 27 255 51 40 26 255 47 35 24 255
                 44 33 24 255 41 31 24 255 44 34 25 255
                 43 34 26 255 41 32 25 255 54 39 27 255
                 51 40 26 255 44 35 23 255 60 44 28 255
                 77 61 37 255 87 72 48 255 88 76 51 255
                 88 74 51 255 77 62 43 255 65 50 33 255
                 59 43 28 255 56 41 27 255 53 38 26 255
                 56 40 26 255 57 40 26 255 59 41 26 255
                 64 45 28 255 66 47 30 255 69 49 31 255
                 67 49 31 255 48 38 26 255 42 34 25 255
                 37 32 24 255 47 39 30 255 73 56 39 255
                 66 56 38 255 41 38 27 255 56 46 34 255
                 79 66 42 255 84 68 44 255 81 70 46 255
                 76 68 47 255 79 70 49 255 79 69 49 255
                 79 69 47 255 72 64 45 255 71 62 43 255
                 68 57 38 255 74 58 41 255 73 65 45 255
                 35 39 31 255 15 18 20 255 17 16 18 255
                 34 27 23 255 39 31 25 255 40 31 24 255
                 47 35 26 255 48 37 27 255 48 37 26 255
                 46 34 25 255 46 36 25 255 23 24 21 255
                 16 17 19 255 45 35 27 255 73 61 36 255
                 47 45 30 255 44 39 28 255 27 28 22 255
                 16 17 19 255 29 25 21 255 43 36 25 255
                 55 46 34 255 78 65 48 255 95 83 58 255
                 85 76 47 255 90 71 41 255 98 76 46 255
                 82 61 36 255 77 58 35 255 76 56 36 255
                 71 52 33 255 72 52 34 255 79 58 35 255
                 78 57 34 255 71 52 33 255 66 49 33 255
                 63 46 31 255 66 48 32 255 75 54 34 255
                 80 59 35 255 78 58 35 255 74 55 33 255
                 64 47 31 255 67 51 35 255 73 56 36 255
                 76 56 39 255 75 55 36 255 73 55 34 255
                 66 54 30 255 54 46 27 255 50 44 26 255
                 35 33 23 255 32 30 23 255 41 33 25 255
                 45 32 26 255 48 33 27 255 45 35 25 255
                 37 31 22 255 41 32 25 255 41 31 26 255
                 42 32 27 255 47 36 26 255 49 36 23 255
                 46 35 22 255 39 30 22 255 43 32 23 255
                 47 34 24 255 52 37 26 255 39 30 24 255
                 35 27 24 255 35 27 25 255 33 26 23 255
                 35 27 23 255 38 29 23 255 40 31 23 255
                 35 28 22 255 32 27 21 255 28 24 20 255
                 27 21 20 255 24 20 20 255 25 20 21 255
                 25 20 20 255 19 17 18 255 19 16 17 255
                 22 17 18 255 22 18 17 255 20 17 17 255
                 21 17 17 255 24 19 18 255 24 19 18 255
                 24 19 18 255 27 21 18 255 30 22 19 255
                 31 24 20 255 30 25 20 255 31 24 21 255
                 35 24 23 255 35 26 22 255 34 29 22 255
                 37 30 23 255 35 29 23 255 36 31 22 255
                 37 28 23 255 42 30 24 255 44 34 24 255
                 48 36 26 255 50 36 26 255 46 35 25 255
                 39 31 24 255 35 28 23 255 32 26 21 255
                 31 25 21 255 28 24 22 255 28 24 21 255
                 27 23 20 255 27 22 20 255 34 25 21 255
                 42 31 23 255 53 38 26 255 51 39 26 255
                 46 36 26 255 48 36 25 255 44 33 24 255
                 41 31 24 255 49 36 26 255 52 38 27 255
                 57 43 27 255 58 40 27 255 55 39 25 255
                 49 40 25 255 48 37 28 255 51 34 26 255
                 54 33 24 255 58 35 25 255 57 35 24 255
                 51 35 23 255 48 33 21 255 51 31 22 255
                 51 33 21 255 51 34 22 255 54 35 24 255
                 64 42 27 255 76 52 30 255 77 56 32 255
                 66 48 31 255 73 51 33 255 75 53 33 255
                 76 55 34 255 74 53 32 255 80 56 34 255
                 83 59 36 255 84 60 36 255 79 56 34 255
                 68 49 31 255 66 46 30 255 67 46 29 255
                 71 50 31 255 69 50 30 255 60 44 28 255
                 51 38 25 255 55 39 26 255 61 42 27 255
                 67 46 30 255 69 48 30 255 71 51 31 255
                 77 54 33 255 85 61 35 255 78 56 33 255
                 65 48 30 255 64 45 29 255 70 49 30 255
                 74 52 32 255 70 51 32 255 63 46 30 255
                 60 43 28 255 61 43 28 255 62 43 28 255
                 66 46 29 255 61 44 29 255 55 39 27 255
                 55 40 26 255 54 40 26 255 54 39 28 255
                 50 38 27 255 45 34 25 255 43 32 25 255
                 40 31 24 255 33 27 22 255 29 23 20 255
                 28 22 20 255 27 22 19 255 28 22 19 255
                 28 22 20 255 27 22 20 255 25 21 19 255
                 27 22 20 255 29 24 20 255 28 22 20 255
                 32 25 22 255 36 28 23 255 41 32 24 255
                 46 34 26 255 50 37 27 255 56 42 29 255
                 57 41 28 255 55 41 28 255 54 42 28 255
                 53 40 28 255 51 38 26 255 48 36 25 255
                 44 34 25 255 42 33 25 255 36 30 24 255
                 30 25 22 255 44 35 25 255 50 38 27 255
                 63 46 30 255 67 50 30 255 75 58 35 255
                 87 71 44 255 92 78 51 255 88 75 51 255
                 78 65 43 255 70 54 36 255 63 47 30 255
                 59 42 27 255 59 41 26 255 59 42 27 255
                 58 42 27 255 56 40 27 255 43 34 24 255
                 42 33 23 255 54 39 26 255 58 41 28 255
                 58 42 28 255 52 41 28 255 40 34 24 255
                 52 39 26 255 45 36 24 255 51 36 26 255
                 76 54 35 255 74 56 36 255 67 55 37 255
                 73 62 45 255 79 69 48 255 81 71 50 255
                 78 69 49 255 72 65 46 255 72 64 48 255
                 72 64 49 255 66 62 46 255 45 44 33 255
                 58 46 34 255 78 62 40 255 85 66 44 255
                 81 69 44 255 36 36 25 255 34 28 22 255
                 43 35 24 255 48 39 26 255 45 36 25 255
                 42 33 24 255 45 36 26 255 49 38 27 255
                 49 38 26 255 54 40 27 255 65 52 33 255
                 26 29 22 255 19 18 19 255 60 47 32 255
                 77 66 39 255 48 45 29 255 52 42 29 255
                 46 42 27 255 35 30 23 255 46 38 26 255
                 51 43 29 255 54 47 32 255 64 53 37 255
                 83 69 52 255 96 85 57 255 94 82 50 255
                 91 78 49 255 80 58 35 255 74 54 33 255
                 73 53 33 255 71 51 32 255 72 52 33 255
                 79 58 37 255 79 58 35 255 76 56 34 255
                 69 51 33 255 67 48 32 255 69 51 33 255
                 72 53 33 255 68 50 33 255 68 49 32 255
                 73 53 34 255 77 57 35 255 75 56 34 255
                 77 55 37 255 77 56 38 255 79 61 36 255
                 79 65 35 255 73 61 36 255 62 52 33 255
                 55 46 31 255 44 38 27 255 31 29 23 255
                 36 33 23 255 38 31 23 255 42 29 26 255
                 47 33 26 255 40 32 22 255 44 35 24 255
                 40 32 25 255 36 28 26 255 39 30 26 255
                 45 34 24 255 48 35 23 255 43 32 23 255
                 42 31 23 255 45 32 26 255 52 37 28 255
                 37 29 25 255 35 27 24 255 34 27 23 255
                 34 26 23 255 37 28 23 255 39 29 23 255
                 38 29 24 255 38 29 23 255 38 29 22 255
                 34 27 21 255 29 23 19 255 23 20 19 255
                 22 18 19 255 24 19 20 255 20 17 17 255
                 18 16 16 255 19 16 16 255 22 18 16 255
                 22 19 16 255 23 19 17 255 24 20 18 255
                 21 18 17 255 19 17 17 255 21 18 17 255
                 29 21 19 255 33 25 20 255 30 24 20 255
                 30 24 20 255 34 24 22 255 35 26 22 255
                 38 28 23 255 42 31 23 255 34 25 23 255
                 35 29 23 255 38 30 23 255 39 28 24 255
                 40 31 23 255 42 33 24 255 45 33 25 255
                 47 36 25 255 37 29 23 255 40 31 24 255
                 45 34 25 255 39 30 23 255 31 26 22 255
                 29 25 21 255 27 23 20 255 27 21 19 255
                 43 30 23 255 55 39 25 255 56 39 26 255
                 42 33 24 255 40 32 24 255 45 35 25 255
                 46 35 26 255 44 34 25 255 52 39 27 255
                 55 40 27 255 54 39 26 255 59 41 28 255
                 53 38 26 255 43 36 24 255 45 34 26 255
                 49 31 24 255 55 31 23 255 62 34 24 255
                 58 33 23 255 51 32 23 255 44 32 21 255
                 46 30 22 255 51 33 23 255 51 35 22 255
                 53 36 25 255 73 50 32 255 88 62 36 255
                 85 61 34 255 70 50 31 255 75 52 33 255
                 75 53 33 255 77 55 34 255 76 54 34 255
                 81 57 33 255 84 60 35 255 78 56 34 255
                 76 54 33 255 68 49 30 255 66 46 30 255
                 66 46 30 255 69 49 31 255 68 49 30 255
                 64 47 29 255 57 41 26 255 60 42 25 255
                 58 40 25 255 57 39 25 255 60 40 26 255
                 64 44 28 255 68 48 31 255 83 60 36 255
                 87 63 35 255 78 56 33 255 74 52 33 255
                 75 53 32 255 76 54 33 255 73 53 33 255
                 66 49 31 255 64 46 29 255 63 44 29 255
                 66 47 30 255 66 47 30 255 62 44 29 255
                 59 43 27 255 55 40 27 255 55 40 27 255
                 53 39 27 255 50 37 26 255 47 35 25 255
                 44 33 25 255 41 31 24 255 34 27 22 255
                 29 24 20 255 27 22 19 255 24 21 19 255
                 25 21 19 255 27 21 19 255 26 21 19 255
                 24 21 18 255 25 21 19 255 25 21 19 255
                 25 20 19 255 27 22 20 255 30 24 21 255
                 34 26 23 255 37 29 24 255 45 34 26 255
                 54 39 28 255 54 42 28 255 49 39 29 255
                 48 36 27 255 53 37 26 255 54 38 25 255
                 50 35 24 255 44 33 24 255 28 23 22 255
                 27 24 21 255 30 23 20 255 62 46 29 255
                 71 55 33 255 79 60 37 255 90 72 44 255
                 92 77 51 255 90 77 52 255 83 71 47 255
                 70 56 37 255 59 46 31 255 57 41 29 255
                 58 42 27 255 57 41 26 255 59 42 27 255
                 56 40 27 255 52 38 26 255 45 35 25 255
                 21 20 18 255 23 20 19 255 51 37 26 255
                 64 49 31 255 55 44 29 255 26 25 21 255
                 22 22 19 255 40 30 23 255 54 39 25 255
                 65 45 29 255 74 52 33 255 73 53 34 255
                 68 55 37 255 76 63 43 255 76 65 45 255
                 76 65 46 255 75 67 48 255 71 64 45 255
                 70 62 45 255 65 59 43 255 59 55 39 255
                 47 41 29 255 64 51 34 255 69 54 37 255
                 75 55 37 255 91 72 43 255 84 70 39 255
                 87 67 39 255 89 70 40 255 89 69 40 255
                 84 65 36 255 77 61 33 255 77 60 35 255
                 77 60 35 255 73 57 33 255 82 62 37 255
                 87 72 43 255 44 44 27 255 36 31 24 255
                 80 63 40 255 90 74 44 255 72 61 35 255
                 65 54 32 255 59 50 32 255 65 52 33 255
                 62 52 33 255 50 44 30 255 46 43 30 255
                 56 47 33 255 72 59 42 255 97 83 59 255
                 102 92 61 255 80 79 53 255 84 61 36 255
                 79 58 34 255 74 54 33 255 74 54 33 255
                 75 55 33 255 69 51 33 255 66 48 32 255
                 69 50 34 255 74 53 33 255 75 55 35 255
                 71 52 34 255 65 48 32 255 60 43 28 255
                 71 50 31 255 81 57 36 255 83 61 36 255
                 82 60 36 255 75 52 36 255 73 55 34 255
                 75 62 35 255 78 67 40 255 79 65 42 255
                 70 55 38 255 61 45 34 255 52 39 31 255
                 37 31 26 255 40 36 25 255 38 34 23 255
                 41 31 24 255 45 32 27 255 42 32 24 255
                 42 33 23 255 38 31 23 255 36 28 24 255
                 35 27 24 255 39 29 24 255 44 32 24 255
                 42 31 24 255 43 32 25 255 47 34 28 255
                 52 38 29 255 40 30 25 255 39 30 25 255
                 38 29 23 255 38 29 22 255 37 29 22 255
                 42 31 25 255 43 32 25 255 38 29 24 255
                 39 30 23 255 34 27 21 255 32 26 21 255
                 27 22 19 255 21 17 18 255 21 17 18 255
                 20 17 18 255 19 17 16 255 19 17 16 255
                 23 19 17 255 24 20 19 255 23 18 18 255
                 23 19 19 255 20 17 17 255 18 16 17 255
                 19 17 16 255 23 19 18 255 29 22 19 255
                 30 23 20 255 29 23 20 255 35 26 22 255
                 37 28 23 255 40 30 22 255 41 30 21 255
                 33 24 21 255 34 27 24 255 38 30 23 255
                 38 27 24 255 35 28 22 255 33 27 21 255
                 41 30 23 255 49 35 25 255 45 34 24 255
                 45 34 24 255 48 37 26 255 44 33 25 255
                 40 31 23 255 32 26 22 255 28 22 19 255
                 27 22 20 255 43 31 24 255 52 38 26 255
                 46 35 25 255 38 30 23 255 37 29 23 255
                 40 32 25 255 46 35 26 255 46 35 25 255
                 50 37 27 255 58 41 27 255 60 43 28 255
                 56 42 27 255 51 36 26 255 43 36 23 255
                 45 34 25 255 49 31 23 255 58 32 21 255
                 60 33 21 255 52 29 20 255 44 27 22 255
                 40 30 22 255 41 30 21 255 46 31 23 255
                 50 36 24 255 64 46 28 255 82 59 35 255
                 86 63 37 255 81 59 34 255 71 51 31 255
                 79 56 34 255 81 57 33 255 79 56 33 255
                 78 55 34 255 82 58 35 255 82 59 34 255
                 75 54 33 255 74 52 34 255 73 52 32 255
                 65 47 30 255 65 46 29 255 67 47 30 255
                 66 47 29 255 59 43 27 255 52 38 25 255
                 57 40 26 255 57 40 25 255 57 39 25 255
                 59 39 26 255 59 41 26 255 58 43 28 255
                 65 46 30 255 78 54 34 255 79 57 35 255
                 76 53 33 255 75 52 32 255 74 52 32 255
                 70 51 32 255 71 52 32 255 69 50 30 255
                 66 47 29 255 66 46 30 255 63 44 29 255
                 60 42 28 255 57 42 28 255 52 39 26 255
                 53 38 26 255 51 38 27 255 48 36 26 255
                 44 34 24 255 42 31 23 255 39 30 23 255
                 35 28 22 255 31 25 21 255 27 22 20 255
                 25 21 20 255 24 20 19 255 24 20 18 255
)"
        R"(                 25 20 19 255 26 21 19 255 26 21 19 255
                 22 19 18 255 23 20 19 255 28 22 20 255
                 29 23 19 255 29 24 21 255 33 25 22 255
                 44 30 24 255 50 36 25 255 50 41 29 255
                 46 38 29 255 43 32 25 255 50 35 25 255
                 52 38 26 255 37 29 23 255 43 33 25 255
                 33 25 20 255 46 35 24 255 51 38 26 255
                 73 54 34 255 89 71 43 255 95 80 50 255
                 95 82 53 255 87 72 47 255 72 59 39 255
                 64 50 33 255 59 46 30 255 37 32 25 255
                 45 32 24 255 54 39 26 255 49 38 25 255
                 51 38 25 255 50 38 25 255 50 38 27 255
                 42 35 26 255 13 14 16 255 12 10 14 255
                 26 21 22 255 37 30 27 255 33 30 25 255
                 13 13 16 255 15 15 17 255 34 26 21 255
                 50 36 26 255 59 42 29 255 61 43 29 255
                 56 42 28 255 38 33 25 255 65 50 35 255
                 53 48 35 255 61 50 38 255 78 65 45 255
                 74 64 44 255 57 54 39 255 32 32 29 255
                 52 42 35 255 70 56 38 255 56 48 32 255
                 52 40 28 255 73 54 35 255 85 67 43 255
                 97 79 47 255 93 70 41 255 91 68 39 255
                 98 71 43 255 94 70 40 255 89 65 37 255
                 90 67 39 255 86 65 38 255 74 57 35 255
                 66 54 36 255 65 53 37 255 85 71 42 255
                 77 65 36 255 86 68 41 255 72 62 39 255
                 70 58 36 255 75 59 35 255 76 61 36 255
                 77 63 37 255 68 58 35 255 48 43 28 255
                 43 40 27 255 48 42 28 255 70 57 39 255
                 90 79 55 255 85 78 56 255 47 53 39 255
                 89 62 36 255 87 62 35 255 84 59 34 255
                 83 59 34 255 86 63 36 255 79 60 34 255
                 69 52 31 255 66 48 33 255 73 52 32 255
                 73 53 31 255 70 51 30 255 66 48 27 255
                 71 50 30 255 79 56 36 255 82 60 37 255
                 87 64 36 255 85 59 38 255 74 53 35 255
                 64 52 31 255 69 58 34 255 79 66 40 255
                 82 67 43 255 74 57 40 255 63 46 34 255
                 57 41 32 255 50 38 30 255 47 40 29 255
                 43 38 25 255 44 35 24 255 45 32 26 255
                 41 30 24 255 42 33 23 255 40 33 23 255
                 38 29 25 255 35 27 24 255 39 29 24 255
                 42 31 24 255 41 30 24 255 43 31 26 255
                 50 36 29 255 49 36 29 255 41 31 26 255
                 38 30 24 255 36 28 22 255 39 30 22 255
                 35 29 22 255 41 32 24 255 45 35 26 255
                 38 30 24 255 34 27 23 255 32 25 22 255
                 34 26 21 255 31 24 20 255 25 20 19 255
                 21 18 19 255 21 18 18 255 20 17 16 255
                 19 17 16 255 21 17 17 255 20 16 17 255
                 18 15 16 255 19 16 17 255 21 18 17 255
                 20 18 17 255 20 17 17 255 23 19 18 255
                 25 20 18 255 29 23 19 255 29 23 20 255
                 29 23 20 255 31 25 21 255 37 27 22 255
                 35 25 20 255 31 22 21 255 31 26 23 255
                 38 30 22 255 37 27 23 255 35 27 22 255
                 31 25 21 255 38 28 23 255 49 35 25 255
                 54 39 27 255 51 39 26 255 48 37 27 255
                 46 34 25 255 48 36 25 255 44 34 23 255
                 31 25 20 255 33 25 21 255 47 34 24 255
                 48 36 25 255 39 30 23 255 36 29 23 255
                 40 32 24 255 41 32 25 255 45 35 25 255
                 48 36 25 255 54 40 27 255 59 42 27 255
                 59 43 28 255 54 40 26 255 52 37 26 255
                 44 36 23 255 44 32 24 255 52 32 21 255
                 58 35 20 255 54 33 20 255 47 29 19 255
                 42 26 21 255 39 28 22 255 39 30 21 255
                 45 32 24 255 62 43 29 255 80 58 32 255
                 83 61 34 255 84 61 36 255 82 60 36 255
                 70 50 33 255 76 53 34 255 82 58 35 255
                 81 58 33 255 82 58 34 255 86 61 36 255
                 82 59 35 255 72 53 32 255 72 51 33 255
                 71 50 31 255 68 48 31 255 65 46 29 255
                 65 46 29 255 66 47 29 255 58 43 27 255
                 52 38 25 255 56 40 26 255 59 41 26 255
                 63 43 27 255 64 46 29 255 58 44 28 255
                 61 45 29 255 68 49 31 255 69 49 31 255
                 68 49 32 255 69 49 32 255 70 50 31 255
                 71 50 31 255 74 53 32 255 76 56 33 255
                 74 54 32 255 69 50 31 255 66 47 30 255
                 62 44 28 255 60 42 28 255 56 41 27 255
                 54 39 26 255 53 39 26 255 50 37 26 255
                 49 36 25 255 45 34 23 255 43 32 23 255
                 41 31 23 255 36 28 22 255 32 25 21 255
                 28 23 20 255 27 22 20 255 25 21 19 255
                 25 20 18 255 26 21 19 255 26 21 20 255
                 24 20 19 255 23 20 18 255 24 20 18 255
                 26 22 19 255 28 23 19 255 29 23 20 255
                 31 23 20 255 39 28 22 255 46 35 24 255
                 46 38 27 255 47 40 29 255 43 37 28 255
                 38 31 25 255 41 30 23 255 43 31 23 255
                 53 40 28 255 51 38 24 255 65 47 29 255
                 77 59 37 255 90 74 47 255 94 82 52 255
                 93 79 51 255 83 69 44 255 71 55 34 255
                 67 51 33 255 67 50 32 255 61 46 29 255
                 40 32 23 255 46 33 24 255 41 32 23 255
                 25 22 19 255 33 26 22 255 36 30 24 255
                 25 23 21 255 18 16 19 255 9 9 13 255
                 9 8 13 255 11 10 15 255 12 11 16 255
                 12 12 16 255 8 8 12 255 10 9 14 255
                 24 18 19 255 39 29 24 255 49 36 26 255
                 51 38 26 255 44 35 25 255 35 28 21 255
                 49 38 27 255 22 23 21 255 39 30 27 255
                 51 43 33 255 47 40 32 255 31 32 27 255
                 13 14 17 255 29 22 22 255 42 33 27 255
                 26 24 22 255 40 30 25 255 63 49 33 255
                 69 54 37 255 92 74 47 255 92 71 42 255
                 97 73 41 255 104 77 45 255 98 73 41 255
                 95 70 38 255 92 69 39 255 90 66 37 255
                 81 61 35 255 61 51 32 255 66 51 33 255
                 97 76 46 255 92 75 44 255 84 68 40 255
                 73 62 36 255 80 62 36 255 99 77 43 255
                 102 83 47 255 99 83 46 255 81 67 38 255
                 68 55 34 255 68 56 34 255 67 56 35 255
                 81 70 46 255 68 65 46 255 54 49 37 255
                 27 30 26 255 91 62 37 255 89 61 38 255
                 87 58 39 255 92 62 41 255 94 66 42 255
                 88 65 38 255 70 54 30 255 63 46 31 255
                 67 47 32 255 70 49 29 255 73 52 27 255
                 80 57 30 255 78 55 34 255 70 49 35 255
                 74 54 33 255 83 60 36 255 82 56 37 255
                 74 53 33 255 63 50 29 255 63 52 31 255
                 74 62 38 255 83 67 44 255 77 61 42 255
                 66 49 36 255 64 47 36 255 59 45 35 255
                 53 44 32 255 46 40 26 255 45 37 25 255
                 46 33 27 255 43 30 26 255 44 34 24 255
                 44 36 23 255 40 32 24 255 34 27 25 255
                 39 28 25 255 42 30 25 255 42 31 24 255
                 42 31 25 255 51 36 29 255 48 35 28 255
                 40 31 26 255 35 29 24 255 38 30 23 255
                 36 30 22 255 34 28 21 255 40 32 23 255
                 43 34 24 255 40 32 24 255 33 27 23 255
                 29 24 21 255 30 24 20 255 32 25 19 255
                 27 23 20 255 24 20 20 255 21 18 17 255
                 19 17 16 255 20 18 17 255 21 17 17 255
                 19 16 16 255 17 16 16 255 19 17 17 255
                 21 18 17 255 22 19 18 255 22 19 17 255
                 24 20 18 255 23 19 18 255 26 21 19 255
                 29 23 20 255 30 23 19 255 29 23 20 255
                 31 25 22 255 34 24 22 255 31 24 22 255
                 28 25 21 255 36 29 22 255 38 27 23 255
                 33 26 22 255 31 25 21 255 34 25 22 255
                 49 36 25 255 53 39 27 255 48 36 25 255
                 48 36 26 255 52 38 26 255 51 38 27 255
                 48 36 25 255 42 32 23 255 48 34 24 255
                 51 38 25 255 47 35 25 255 35 29 22 255
                 38 30 24 255 42 33 25 255 40 31 24 255
                 47 35 26 255 49 37 26 255 57 41 27 255
                 64 46 30 255 58 44 28 255 51 38 25 255
                 48 35 25 255 42 33 23 255 45 31 23 255
                 54 34 21 255 53 37 21 255 45 34 21 255
                 42 30 20 255 41 27 20 255 40 28 22 255
                 40 32 23 255 54 39 27 255 76 51 33 255
                 84 60 33 255 85 62 33 255 87 64 38 255
                 84 62 39 255 68 49 34 255 69 47 33 255
                 78 55 37 255 79 57 35 255 81 58 35 255
                 83 60 36 255 83 61 36 255 69 51 32 255
                 71 51 32 255 68 49 31 255 65 46 30 255
                 64 44 29 255 62 44 28 255 61 43 28 255
                 56 40 26 255 60 42 26 255 58 41 26 255
                 60 41 26 255 61 43 28 255 59 44 29 255
                 54 41 28 255 60 44 29 255 71 52 32 255
                 62 46 29 255 58 42 29 255 65 46 31 255
                 66 47 30 255 69 49 31 255 77 55 34 255
                 84 61 35 255 81 59 34 255 73 53 33 255
                 66 48 30 255 61 44 29 255 57 42 28 255
                 60 44 28 255 57 41 27 255 52 39 26 255
                 48 35 25 255 48 35 25 255 46 35 24 255
                 48 35 25 255 45 34 25 255 39 30 23 255
                 32 27 21 255 29 24 20 255 28 23 20 255
                 25 21 19 255 26 21 19 255 25 21 19 255
                 25 21 19 255 25 20 19 255 23 19 18 255
                 24 21 18 255 26 22 19 255 28 21 19 255
                 28 23 20 255 26 23 20 255 30 26 21 255
                 39 32 23 255 44 38 26 255 44 40 30 255
                 32 31 27 255 36 31 26 255 45 34 26 255
                 50 36 26 255 54 39 27 255 71 52 31 255
                 86 68 43 255 92 78 51 255 91 78 51 255
                 84 70 46 255 73 57 38 255 67 51 33 255
                 69 50 31 255 72 53 32 255 71 52 32 255
                 68 49 30 255 60 45 27 255 59 44 28 255
                 39 35 24 255 12 12 15 255 12 11 16 255
                 11 11 16 255 10 10 14 255 9 9 14 255
                 9 9 13 255 9 10 14 255 10 10 14 255
                 10 10 15 255 9 10 14 255 9 9 13 255
                 9 9 14 255 10 9 15 255 16 13 17 255
                 32 24 22 255 29 25 22 255 35 29 23 255
                 37 31 22 255 32 29 22 255 15 14 16 255
                 36 27 22 255 27 25 21 255 24 19 20 255
                 14 14 16 255 11 9 14 255 28 22 20 255
                 26 24 21 255 12 11 16 255 26 20 21 255
                 50 42 31 255 54 46 32 255 80 65 43 255
                 92 73 43 255 100 75 42 255 106 79 46 255
                 99 74 42 255 99 74 41 255 97 73 40 255
                 95 70 39 255 98 73 41 255 88 69 39 255
                 88 67 40 255 90 70 42 255 80 64 38 255
                 80 63 37 255 95 74 43 255 100 80 46 255
                 106 85 48 255 103 83 49 255 98 80 48 255
                 84 69 40 255 81 64 38 255 82 67 40 255
                 88 74 47 255 92 81 54 255 84 78 50 255
                 70 65 41 255 36 38 27 255 89 68 35 255
                 89 67 36 255 87 60 37 255 93 61 41 255
                 95 64 43 255 90 65 38 255 78 59 32 255
                 79 58 35 255 82 57 37 255 82 58 31 255
                 80 58 29 255 79 56 30 255 76 53 33 255
                 72 49 33 255 71 51 30 255 80 57 33 255
                 79 54 36 255 74 50 34 255 67 49 30 255
                 60 47 29 255 66 54 33 255 79 65 40 255
                 77 64 40 255 67 55 37 255 62 48 36 255
                 61 48 35 255 58 49 32 255 50 42 26 255
                 49 39 25 255 48 34 27 255 44 31 27 255
                 42 33 24 255 43 35 24 255 44 35 26 255
                 37 28 25 255 39 28 24 255 42 31 24 255
                 40 30 23 255 44 32 24 255 53 38 27 255
                 55 39 29 255 46 34 27 255 37 28 25 255
                 35 28 24 255 33 27 22 255 38 30 22 255
                 40 33 23 255 39 30 22 255 36 29 23 255
                 32 26 22 255 29 24 22 255 27 22 20 255
                 31 24 19 255 28 23 19 255 23 20 19 255
                 21 18 18 255 19 17 17 255 18 16 17 255
                 21 17 19 255 25 20 18 255 23 20 18 255
                 18 16 16 255 17 15 16 255 20 17 17 255
                 22 18 17 255 24 20 19 255 22 20 17 255
                 23 19 18 255 28 22 19 255 29 23 19 255
                 30 23 19 255 29 25 21 255 33 28 24 255
                 34 28 24 255 28 26 21 255 35 29 22 255
                 35 26 22 255 33 26 22 255 29 25 20 255
                 31 24 21 255 44 32 24 255 49 37 27 255
                 45 34 24 255 48 36 26 255 55 40 27 255
                 55 40 26 255 57 40 26 255 54 39 26 255
                 55 40 27 255 48 37 25 255 41 31 24 255
                 43 32 25 255 48 38 26 255 48 38 27 255
                 49 37 27 255 52 39 27 255 54 39 26 255
                 61 43 28 255 62 45 30 255 58 43 28 255
                 47 35 24 255 43 31 22 255 42 32 22 255
                 48 31 21 255 53 36 22 255 45 34 23 255
                 37 29 23 255 37 29 22 255 44 32 21 255
                 46 32 23 255 54 41 28 255 72 53 30 255
                 86 58 36 255 88 62 35 255 88 65 34 255
                 88 65 37 255 82 62 39 255 62 46 33 255
                 61 44 31 255 74 52 34 255 78 58 34 255
                 75 56 33 255 79 57 34 255 79 59 34 255
                 66 49 30 255 71 51 33 255 70 50 31 255
                 61 43 29 255 60 42 27 255 56 39 26 255
                 52 37 25 255 55 38 24 255 56 39 24 255
                 56 38 24 255 58 40 25 255 50 37 26 255
                 52 38 27 255 52 39 27 255 55 40 27 255
                 65 46 30 255 60 45 28 255 59 42 28 255
                 64 45 30 255 67 48 31 255 68 48 31 255
                 69 47 31 255 74 52 32 255 73 53 33 255
                 74 53 33 255 78 56 33 255 71 52 31 255
                 60 43 27 255 65 45 29 255 64 46 30 255
                 56 41 27 255 50 37 25 255 47 35 25 255
                 49 36 25 255 51 37 26 255 47 35 25 255
                 43 32 24 255 40 31 23 255 34 28 22 255
                 30 25 21 255 27 23 20 255 27 22 20 255
                 27 21 19 255 25 20 19 255 24 20 18 255
                 26 22 19 255 25 22 20 255 26 19 19 255
                 27 20 17 255 27 24 20 255 25 24 21 255
                 30 27 22 255 32 30 23 255 29 28 23 255
                 28 27 24 255 29 28 25 255 36 34 28 255
                 40 36 27 255 55 44 30 255 75 59 38 255
                 86 72 47 255 88 77 52 255 82 69 47 255
                 70 56 38 255 66 49 32 255 68 49 31 255
                 68 50 32 255 72 51 32 255 75 54 33 255
                 69 50 31 255 67 48 30 255 73 55 33 255
                 56 47 31 255 24 24 21 255 10 11 15 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 10 10 14 255 10 11 15 255
                 9 10 15 255 9 10 14 255 9 10 15 255
                 10 9 15 255 12 11 16 255 13 11 16 255
                 19 17 19 255 24 21 19 255 30 25 20 255
                 25 22 18 255 34 28 22 255 34 29 21 255
                 34 28 22 255 15 15 16 255 12 10 15 255
                 22 19 21 255 14 14 17 255 9 9 14 255
                 13 12 16 255 34 28 26 255 46 40 29 255
                 63 51 37 255 92 73 46 255 99 74 43 255
                 104 78 45 255 98 73 43 255 103 77 44 255
                 102 77 43 255 102 75 43 255 106 79 44 255
                 97 75 42 255 84 64 39 255 77 60 37 255
                 79 61 36 255 99 78 44 255 102 84 48 255
                 74 64 42 255 90 69 46 255 109 89 55 255
                 107 92 55 255 99 83 49 255 88 76 45 255
                 72 63 44 255 86 74 51 255 93 80 55 255
                 96 84 58 255 89 80 54 255 51 53 36 255
                 86 68 37 255 84 66 35 255 85 60 35 255
                 90 61 40 255 90 62 40 255 87 65 36 255
                 86 64 37 255 87 62 40 255 86 61 36 255
                 84 60 34 255 79 57 32 255 76 54 31 255
                 78 55 31 255 76 52 33 255 74 52 32 255
                 77 55 31 255 70 50 31 255 64 44 32 255
)"
        R"(                 68 47 33 255 62 45 30 255 64 46 31 255
                 77 60 36 255 76 63 37 255 67 56 34 255
                 63 51 33 255 62 50 33 255 63 53 32 255
                 59 48 28 255 57 43 28 255 51 35 27 255
                 44 32 25 255 42 33 23 255 39 32 23 255
                 45 34 27 255 44 32 27 255 41 30 24 255
                 40 30 23 255 41 31 22 255 45 33 23 255
                 52 37 25 255 55 40 27 255 53 38 28 255
                 46 33 26 255 34 26 24 255 33 27 23 255
                 43 33 23 255 43 34 23 255 37 29 22 255
                 38 30 22 255 34 27 23 255 29 23 22 255
                 27 22 21 255 27 21 19 255 26 22 18 255
                 23 19 18 255 19 17 18 255 17 15 17 255
                 16 14 16 255 17 14 17 255 22 18 18 255
                 23 20 18 255 18 16 16 255 16 15 16 255
                 18 16 17 255 19 17 17 255 20 17 17 255
                 21 19 17 255 21 19 18 255 26 21 19 255
                 28 22 19 255 30 23 19 255 29 24 20 255
                 33 29 23 255 35 30 23 255 30 28 22 255
                 37 30 22 255 37 27 23 255 37 29 22 255
                 32 27 21 255 32 25 22 255 40 30 24 255
                 47 35 26 255 50 37 25 255 51 38 26 255
                 56 40 26 255 56 40 26 255 59 42 27 255
                 57 41 26 255 55 41 26 255 49 38 26 255
                 46 34 25 255 48 36 26 255 50 37 26 255
                 51 39 27 255 58 42 28 255 57 42 27 255
                 60 42 28 255 63 45 30 255 56 42 28 255
                 51 37 25 255 43 32 22 255 44 31 22 255
                 49 35 23 255 54 34 22 255 50 36 22 255
                 40 29 22 255 34 25 21 255 35 27 22 255
                 45 34 24 255 56 39 26 255 73 52 34 255
                 83 61 34 255 86 59 36 255 88 62 36 255
                 87 64 34 255 91 68 38 255 83 63 39 255
                 63 47 32 255 64 47 31 255 74 54 32 255
                 76 56 32 255 71 51 32 255 73 51 33 255
                 77 54 33 255 73 52 32 255 66 46 31 255
                 62 43 27 255 55 38 24 255 52 36 24 255
                 50 33 23 255 50 34 23 255 54 37 24 255
                 55 38 24 255 56 38 24 255 56 39 25 255
                 51 37 26 255 55 40 27 255 56 41 28 255
                 61 44 29 255 63 46 30 255 62 45 28 255
                 64 45 29 255 65 46 29 255 65 46 31 255
                 63 45 28 255 59 41 26 255 59 41 27 255
                 60 41 27 255 63 43 28 255 72 49 32 255
                 76 54 33 255 75 53 32 255 78 55 33 255
                 76 54 32 255 69 50 30 255 60 44 28 255
                 53 39 27 255 51 38 26 255 51 38 26 255
                 48 36 26 255 46 35 25 255 41 33 24 255
                 33 28 23 255 31 26 22 255 30 25 21 255
                 28 22 20 255 28 22 20 255 29 24 20 255
                 29 24 21 255 30 23 21 255 30 22 21 255
                 29 20 18 255 28 20 16 255 30 24 19 255
                 33 29 22 255 30 30 23 255 17 20 19 255
                 21 20 20 255 33 30 25 255 38 34 27 255
                 46 39 28 255 65 55 36 255 83 73 46 255
                 89 80 55 255 84 75 51 255 74 61 42 255
                 64 48 32 255 61 44 29 255 64 47 30 255
                 66 48 31 255 68 48 30 255 71 50 32 255
                 69 50 31 255 72 52 31 255 73 57 35 255
                 53 46 31 255 25 24 20 255 12 12 15 255
                 10 10 14 255 9 10 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 10 10 15 255 10 10 15 255 9 9 14 255
                 8 8 13 255 9 8 13 255 13 11 15 255
                 24 20 20 255 23 21 20 255 23 20 19 255
                 33 27 22 255 31 27 23 255 14 16 17 255
                 10 9 15 255 10 10 16 255 9 10 15 255
                 9 10 15 255 10 11 15 255 23 19 21 255
                 44 37 28 255 51 42 31 255 82 64 43 255
                 96 75 43 255 101 75 44 255 102 76 43 255
                 109 81 45 255 111 84 45 255 111 83 45 255
                 110 83 46 255 103 78 44 255 88 67 39 255
                 84 64 37 255 95 74 43 255 89 74 46 255
                 77 66 41 255 49 44 31 255 91 71 49 255
                 103 87 59 255 103 88 62 255 99 83 53 255
                 70 65 42 255 29 30 27 255 41 36 33 255
                 69 58 45 255 93 80 55 255 92 82 56 255
                 59 61 42 255 86 68 37 255 86 65 35 255
                 89 62 38 255 93 64 40 255 90 64 37 255
                 80 60 34 255 76 54 36 255 77 55 35 255
                 76 54 33 255 73 52 34 255 71 51 34 255
                 73 52 35 255 75 54 32 255 76 54 31 255
                 77 53 33 255 79 56 33 255 75 55 30 255
                 63 46 28 255 64 46 31 255 71 50 33 255
                 75 53 35 255 79 57 37 255 76 58 36 255
                 68 54 33 255 65 52 32 255 66 53 32 255
                 63 51 31 255 63 47 29 255 62 43 29 255
                 59 40 30 255 54 41 27 255 45 36 23 255
                 37 31 23 255 42 31 26 255 48 35 28 255
                 44 32 25 255 40 31 22 255 44 33 23 255
                 48 36 23 255 55 40 25 255 58 43 25 255
                 54 40 26 255 46 34 26 255 34 27 24 255
                 32 25 23 255 38 30 25 255 41 32 24 255
                 37 30 22 255 40 32 23 255 37 30 23 255
                 31 25 22 255 22 19 19 255 22 18 19 255
                 23 20 18 255 22 19 17 255 21 18 17 255
                 19 18 18 255 17 15 17 255 19 17 17 255
                 22 19 18 255 21 19 18 255 19 17 16 255
                 18 16 16 255 17 16 16 255 17 16 16 255
                 21 18 17 255 21 19 17 255 19 17 17 255
                 23 19 18 255 28 23 19 255 29 23 20 255
                 29 24 19 255 31 28 22 255 36 31 23 255
                 34 31 22 255 31 27 21 255 37 27 24 255
                 40 32 23 255 31 25 21 255 32 25 22 255
                 37 27 23 255 46 33 25 255 54 40 27 255
                 56 41 27 255 59 42 27 255 54 39 26 255
                 53 39 26 255 53 39 26 255 52 39 26 255
                 45 35 25 255 46 34 25 255 48 36 25 255
                 54 39 27 255 59 42 28 255 59 42 27 255
                 61 43 28 255 64 46 29 255 63 46 29 255
                 53 40 27 255 48 36 24 255 45 32 22 255
                 46 32 22 255 49 34 22 255 52 33 21 255
                 44 33 22 255 37 28 21 255 35 27 21 255
                 42 33 25 255 55 42 29 255 72 49 30 255
                 80 59 37 255 81 62 35 255 79 55 35 255
                 83 57 35 255 86 63 34 255 94 71 39 255
                 84 65 39 255 63 48 31 255 62 46 28 255
                 70 50 30 255 71 50 32 255 68 47 33 255
                 68 47 32 255 67 47 30 255 62 45 29 255
                 52 37 24 255 53 35 23 255 51 35 23 255
                 49 33 22 255 47 33 22 255 49 34 22 255
                 52 35 22 255 55 37 23 255 56 39 24 255
                 57 40 27 255 60 43 28 255 66 48 31 255
                 68 49 31 255 67 49 30 255 66 47 30 255
                 70 50 31 255 71 51 31 255 68 50 31 255
                 64 46 29 255 58 41 26 255 54 37 25 255
                 60 41 26 255 59 41 26 255 58 38 26 255
                 67 44 29 255 74 52 32 255 79 57 34 255
                 80 57 35 255 83 60 35 255 81 59 33 255
                 69 50 30 255 58 43 28 255 53 40 27 255
                 50 38 26 255 50 36 25 255 47 36 24 255
                 41 32 24 255 32 27 22 255 29 24 20 255
                 29 23 20 255 28 23 20 255 31 25 21 255
                 36 27 22 255 36 26 22 255 32 23 19 255
                 33 23 19 255 32 23 18 255 31 22 17 255
                 34 26 19 255 29 27 21 255 16 18 18 255
                 13 14 17 255 27 25 22 255 40 35 27 255
                 57 47 31 255 78 66 39 255 91 78 48 255
                 93 80 53 255 84 71 48 255 71 56 37 255
                 65 46 30 255 63 45 29 255 63 45 29 255
                 60 44 28 255 61 43 28 255 67 47 29 255
                 67 47 30 255 74 53 33 255 75 60 36 255
                 45 41 29 255 19 19 19 255 11 11 15 255
                 10 10 14 255 9 10 14 255 9 10 14 255
                 8 9 14 255 9 9 13 255 9 9 14 255
                 8 9 13 255 8 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 9 11 15 255 9 11 15 255
                 9 10 15 255 8 9 14 255 8 9 13 255
                 8 8 13 255 9 8 14 255 9 8 14 255
                 10 8 14 255 12 11 16 255 11 11 16 255
                 9 9 15 255 9 9 14 255 9 10 15 255
                 9 10 15 255 9 10 15 255 10 10 15 255
                 14 14 18 255 38 32 26 255 46 40 28 255
                 68 53 38 255 93 74 45 255 102 75 44 255
                 113 86 48 255 114 88 47 255 113 86 47 255
                 111 83 46 255 109 81 46 255 103 77 44 255
                 94 71 40 255 96 74 42 255 79 69 42 255
                 38 39 29 255 42 36 28 255 59 48 32 255
                 101 80 54 255 97 85 53 255 86 71 48 255
                 89 71 45 255 62 55 35 255 20 23 20 255
                 14 14 18 255 39 30 29 255 88 73 52 255
                 93 84 57 255 57 61 41 255 85 65 35 255
                 83 60 36 255 88 61 40 255 92 67 38 255
                 84 61 34 255 74 53 33 255 73 52 32 255
                 70 50 31 255 69 48 33 255 71 51 32 255
                 72 52 31 255 72 53 32 255 70 51 33 255
                 72 51 32 255 80 56 32 255 84 58 33 255
                 85 60 35 255 75 54 32 255 71 51 32 255
                 80 59 35 255 76 57 34 255 63 47 33 255
                 75 55 37 255 74 53 36 255 68 49 34 255
                 66 49 32 255 63 47 31 255 68 48 33 255
                 66 46 33 255 61 43 31 255 55 43 27 255
                 43 36 23 255 38 31 24 255 41 30 26 255
                 47 34 27 255 49 36 24 255 44 34 22 255
                 46 36 23 255 51 38 24 255 54 41 24 255
                 56 42 24 255 53 39 25 255 47 35 26 255
                 39 29 25 255 35 26 24 255 32 25 23 255
                 30 25 21 255 32 27 21 255 35 28 22 255
                 36 29 22 255 31 25 22 255 24 20 20 255
                 21 17 20 255 18 16 18 255 22 18 18 255
                 23 20 17 255 24 21 18 255 20 18 18 255
                 17 15 17 255 20 18 18 255 20 18 17 255
                 20 18 18 255 20 17 17 255 19 17 16 255
                 19 17 17 255 22 19 18 255 23 20 18 255
                 19 18 17 255 21 19 18 255 27 22 19 255
                 29 23 20 255 27 23 20 255 26 24 20 255
                 32 28 23 255 30 28 22 255 27 24 19 255
                 31 23 22 255 34 26 21 255 29 24 21 255
                 34 26 22 255 35 27 22 255 40 30 23 255
                 51 37 26 255 52 38 26 255 52 39 26 255
                 50 37 25 255 50 37 25 255 48 36 26 255
                 50 37 28 255 54 40 27 255 54 40 26 255
                 54 39 26 255 59 41 29 255 64 45 29 255
                 64 46 29 255 64 45 29 255 62 44 29 255
                 62 45 29 255 51 39 26 255 45 34 23 255
                 43 31 22 255 44 31 22 255 45 31 21 255
                 47 30 22 255 42 30 22 255 39 31 23 255
                 52 42 29 255 57 46 31 255 75 55 32 255
                 80 56 33 255 75 55 35 255 74 56 32 255
                 74 50 31 255 82 55 35 255 81 57 33 255
                 92 68 35 255 82 65 34 255 62 47 28 255
                 63 46 27 255 69 48 31 255 66 44 32 255
                 67 47 31 255 62 47 27 255 58 45 27 255
                 53 41 25 255 46 35 22 255 47 33 22 255
                 47 32 22 255 43 31 22 255 38 29 22 255
                 44 31 23 255 50 34 23 255 52 36 24 255
                 49 36 24 255 51 38 26 255 55 40 28 255
                 70 49 32 255 74 54 32 255 73 54 32 255
                 72 50 31 255 80 57 33 255 75 54 32 255
                 63 45 28 255 62 44 28 255 56 39 24 255
                 59 40 26 255 59 41 26 255 56 39 25 255
                 54 36 25 255 57 38 26 255 71 48 31 255
                 82 59 35 255 78 57 34 255 77 55 34 255
                 77 54 33 255 76 53 31 255 70 50 29 255
                 62 46 28 255 52 39 26 255 47 35 25 255
                 47 36 25 255 45 34 24 255 40 32 23 255
                 34 28 21 255 30 23 20 255 30 25 21 255
                 34 26 22 255 36 26 22 255 34 26 21 255
                 32 25 19 255 33 26 19 255 33 26 18 255
                 31 25 19 255 24 21 19 255 16 16 16 255
                 17 17 17 255 24 24 20 255 39 35 27 255
                 62 54 36 255 85 75 47 255 94 83 52 255
                 91 75 48 255 79 63 43 255 67 51 34 255
                 67 48 30 255 67 48 29 255 64 46 29 255
                 61 45 28 255 60 43 28 255 60 45 28 255
                 61 45 28 255 65 46 29 255 64 51 34 255
                 37 35 27 255 16 16 18 255 10 11 15 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 14 255 9 10 14 255 9 9 13 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 10 10 14 255 10 10 15 255
                 9 10 14 255 9 10 15 255 9 10 15 255
                 10 11 15 255 9 10 15 255 10 10 15 255
                 9 10 15 255 9 9 14 255 9 9 14 255
                 8 9 13 255 8 8 13 255 9 9 14 255
                 9 10 15 255 9 10 15 255 9 9 15 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 10 10 15 255 11 11 16 255 26 21 22 255
                 46 40 29 255 52 41 32 255 84 65 44 255
                 98 73 45 255 108 81 46 255 107 80 46 255
                 108 81 44 255 110 83 44 255 111 83 46 255
                 108 83 45 255 103 79 43 255 97 77 45 255
                 62 55 35 255 31 30 23 255 26 25 22 255
                 44 35 27 255 90 70 48 255 103 87 57 255
                 98 82 51 255 86 70 43 255 57 51 33 255
                 19 21 19 255 13 13 17 255 42 32 28 255
                 80 68 49 255 91 80 58 255 87 81 55 255
                 88 63 37 255 85 60 38 255 86 63 37 255
                 85 63 37 255 85 60 36 255 78 55 33 255
                 75 55 33 255 73 52 33 255 70 50 31 255
                 73 52 31 255 73 53 33 255 72 53 33 255
                 67 50 31 255 67 48 31 255 74 52 33 255
                 81 56 33 255 83 59 33 255 84 59 34 255
                 80 57 35 255 84 61 38 255 79 59 35 255
                 59 45 30 255 70 52 35 255 77 57 37 255
                 73 54 37 255 72 52 36 255 71 51 35 255
                 71 49 35 255 64 45 34 255 56 43 30 255
                 47 39 25 255 42 35 23 255 43 35 26 255
                 43 33 27 255 47 34 26 255 50 37 24 255
                 49 37 23 255 49 38 24 255 53 40 24 255
                 51 39 24 255 53 40 24 255 53 40 24 255
                 50 37 24 255 44 32 25 255 41 30 26 255
                 36 28 24 255 31 25 21 255 30 25 20 255
                 35 29 21 255 39 31 22 255 36 29 22 255
                 30 25 21 255 23 20 19 255 20 17 18 255
                 23 18 19 255 26 21 20 255 23 20 19 255
                 19 17 18 255 15 14 16 255 17 16 17 255
                 18 17 17 255 17 16 17 255 18 16 17 255
                 18 16 17 255 19 16 17 255 20 17 17 255
                 21 19 18 255 19 17 17 255 21 18 18 255
                 25 21 18 255 23 20 18 255 22 21 19 255
                 23 21 20 255 26 22 22 255 24 23 20 255
                 26 23 19 255 28 22 21 255 31 25 21 255
                 28 22 20 255 33 25 21 255 33 26 22 255
                 34 26 21 255 46 32 24 255 48 35 25 255
                 48 36 25 255 45 34 25 255 48 36 25 255
                 49 37 25 255 50 37 27 255 53 38 27 255
                 58 41 27 255 59 41 27 255 63 44 29 255
                 65 45 28 255 65 47 29 255 66 47 29 255
                 64 46 29 255 60 43 28 255 52 39 26 255
                 45 35 23 255 43 33 23 255 46 32 22 255
                 50 34 22 255 48 33 22 255 47 32 22 255
                 61 45 28 255 70 56 34 255 69 52 31 255
                 82 57 32 255 82 57 34 255 75 58 34 255
                 73 55 30 255 76 51 32 255 77 51 34 255
                 84 57 34 255 96 70 37 255 81 62 32 255
                 67 48 28 255 67 46 29 255 69 46 32 255
                 60 43 29 255 59 46 28 255 57 47 28 255
                 56 43 28 255 52 39 26 255 45 35 23 255
                 42 31 22 255 38 27 21 255 33 26 20 255
)"
        R"(                 31 23 20 255 44 32 23 255 48 34 24 255
                 49 35 24 255 47 35 25 255 49 36 26 255
                 50 37 26 255 64 44 30 255 72 52 32 255
                 76 55 33 255 87 63 37 255 86 63 36 255
                 72 53 31 255 56 41 26 255 55 38 25 255
                 57 39 25 255 61 42 27 255 54 38 24 255
                 51 35 23 255 47 33 23 255 49 33 23 255
                 62 41 27 255 72 51 32 255 73 52 31 255
                 74 51 32 255 76 54 32 255 75 51 31 255
                 67 47 29 255 59 43 27 255 54 39 26 255
                 48 35 25 255 46 35 24 255 43 33 24 255
                 42 32 24 255 42 32 23 255 38 28 23 255
                 32 27 21 255 34 26 22 255 37 27 21 255
                 34 27 21 255 33 28 21 255 33 29 21 255
                 28 26 21 255 16 16 17 255 14 13 15 255
                 21 19 17 255 30 27 22 255 47 41 29 255
                 70 59 41 255 87 78 54 255 92 84 58 255
                 85 73 46 255 68 54 35 255 62 47 32 255
                 62 45 30 255 63 45 29 255 62 45 29 255
                 59 43 27 255 60 44 28 255 56 42 28 255
                 43 35 24 255 45 35 25 255 57 44 30 255
                 33 31 24 255 15 16 17 255 11 11 15 255
                 9 10 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 13 255 8 9 13 255
                 8 9 13 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 10 11 15 255 9 10 15 255
                 9 10 15 255 9 10 15 255 9 10 14 255
                 9 10 15 255 9 10 14 255 9 10 14 255
                 9 10 14 255 9 10 15 255 9 11 15 255
                 9 10 15 255 9 11 15 255 9 10 15 255
                 9 10 15 255 9 11 15 255 10 11 16 255
                 16 15 18 255 42 35 28 255 46 39 29 255
                 70 54 39 255 92 71 44 255 100 74 43 255
                 104 78 45 255 109 83 47 255 108 84 46 255
                 106 81 46 255 105 81 47 255 105 81 46 255
                 95 75 41 255 82 65 37 255 74 60 34 255
                 53 47 29 255 61 47 31 255 94 75 48 255
                 96 82 53 255 99 82 53 255 83 70 44 255
                 48 45 32 255 26 25 21 255 31 26 23 255
                 41 37 29 255 34 34 31 255 54 45 41 255
                 88 75 56 255 91 64 38 255 86 64 37 255
                 87 63 38 255 85 61 38 255 81 58 35 255
                 75 54 34 255 73 52 34 255 72 52 32 255
                 68 50 31 255 68 48 32 255 68 48 32 255
                 70 49 33 255 70 50 32 255 70 49 30 255
                 69 49 30 255 69 49 31 255 72 51 32 255
                 76 54 34 255 78 56 34 255 77 56 34 255
                 73 53 34 255 63 46 32 255 70 52 34 255
                 70 54 34 255 67 53 34 255 73 55 36 255
                 74 55 37 255 72 52 36 255 59 45 31 255
                 51 40 26 255 47 38 24 255 44 36 25 255
                 42 33 27 255 44 33 28 255 49 36 27 255
                 50 38 24 255 53 40 24 255 52 39 25 255
                 52 39 26 255 45 35 24 255 49 37 24 255
                 53 40 24 255 56 40 24 255 54 38 27 255
                 49 34 29 255 45 33 26 255 38 30 22 255
                 34 28 21 255 36 29 21 255 38 31 22 255
                 34 29 21 255 34 27 21 255 28 24 18 255
                 26 22 18 255 27 22 19 255 29 25 21 255
                 26 23 20 255 20 19 18 255 17 16 17 255
                 17 16 16 255 17 16 17 255 16 15 16 255
                 16 14 16 255 15 14 16 255 16 14 16 255
                 19 17 17 255 22 19 17 255 23 20 18 255
                 24 20 18 255 24 20 18 255 21 19 17 255
                 22 19 19 255 23 19 19 255 22 18 20 255
                 22 20 20 255 25 21 19 255 28 22 20 255
                 30 25 21 255 36 26 22 255 46 33 23 255
                 42 31 22 255 34 25 20 255 44 31 23 255
                 47 35 24 255 44 32 24 255 45 33 25 255
                 49 37 26 255 52 38 26 255 46 35 24 255
                 47 34 24 255 58 40 27 255 60 42 28 255
                 65 45 30 255 67 47 29 255 65 46 29 255
                 66 47 29 255 65 47 29 255 62 44 28 255
                 53 39 25 255 44 34 23 255 45 33 22 255
                 51 34 23 255 57 37 24 255 53 36 24 255
                 65 42 26 255 76 54 30 255 73 52 30 255
                 79 54 31 255 83 56 33 255 80 59 35 255
                 71 56 32 255 73 53 31 255 77 51 34 255
                 78 51 35 255 91 61 39 255 103 74 43 255
                 83 62 36 255 67 46 32 255 63 42 30 255
                 65 46 30 255 57 45 28 255 59 46 31 255
                 52 40 28 255 53 38 27 255 49 36 25 255
                 43 33 22 255 34 27 20 255 21 18 18 255
                 28 22 19 255 34 26 20 255 40 30 22 255
                 42 31 23 255 43 31 23 255 45 33 25 255
                 50 37 26 255 48 36 26 255 60 43 29 255
                 74 53 33 255 82 59 36 255 88 64 38 255
                 75 56 33 255 61 43 27 255 57 39 25 255
                 58 39 25 255 58 40 25 255 55 38 24 255
                 55 39 24 255 48 35 23 255 44 31 22 255
                 50 34 23 255 53 37 24 255 57 38 25 255
                 67 44 27 255 75 51 30 255 76 54 31 255
                 72 50 30 255 67 46 28 255 60 42 25 255
                 54 39 25 255 50 36 25 255 44 33 24 255
                 44 33 24 255 44 34 24 255 45 34 24 255
                 47 34 25 255 39 30 23 255 34 27 22 255
                 40 27 21 255 39 28 20 255 37 29 22 255
                 31 30 23 255 18 20 19 255 10 10 13 255
                 15 13 14 255 39 32 23 255 62 54 36 255
                 80 69 46 255 90 75 52 255 85 71 51 255
                 67 56 41 255 58 47 31 255 55 41 27 255
                 59 43 29 255 60 43 29 255 59 43 28 255
                 56 41 27 255 59 44 28 255 52 41 27 255
                 43 35 24 255 33 28 21 255 36 30 23 255
                 30 28 23 255 14 15 17 255 11 11 15 255
                 10 11 14 255 9 10 14 255 9 10 14 255
                 9 9 13 255 9 9 13 255 9 9 13 255
                 8 9 13 255 8 9 13 255 8 9 14 255
                 8 9 14 255 9 10 14 255 9 10 14 255
                 10 10 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 11 15 255 9 10 15 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 15 255 10 10 15 255 9 10 15 255
                 9 11 15 255 9 10 15 255 9 11 15 255
                 9 11 15 255 9 11 15 255 9 11 15 255
                 10 11 15 255 12 12 16 255 32 26 24 255
                 48 42 28 255 58 46 33 255 91 71 44 255
                 98 74 43 255 101 78 46 255 94 74 45 255
                 88 67 40 255 85 63 38 255 87 64 38 255
                 89 65 39 255 91 70 40 255 92 71 41 255
                 97 75 43 255 89 70 40 255 87 67 42 255
                 128 107 72 255 134 122 80 255 121 109 69 255
                 85 76 47 255 37 37 27 255 50 39 29 255
                 62 50 34 255 33 34 28 255 13 15 18 255
                 33 27 26 255 71 60 45 255 88 65 37 255
                 85 61 37 255 86 61 37 255 82 60 36 255
                 76 54 34 255 72 51 33 255 74 53 33 255
                 73 52 34 255 67 46 32 255 64 45 30 255
                 63 45 30 255 65 45 30 255 66 47 30 255
                 69 48 30 255 72 50 31 255 69 48 30 255
                 67 48 30 255 74 52 33 255 76 54 34 255
                 69 51 32 255 66 48 31 255 66 48 31 255
                 72 52 33 255 72 54 35 255 66 51 34 255
                 68 54 35 255 72 56 35 255 71 55 34 255
                 57 46 28 255 48 39 24 255 42 35 23 255
                 41 33 24 255 40 32 25 255 43 32 26 255
                 50 37 26 255 52 40 24 255 50 38 25 255
                 49 37 26 255 44 34 26 255 44 33 24 255
                 48 37 24 255 50 38 23 255 57 41 26 255
                 60 43 29 255 52 37 30 255 52 39 29 255
                 54 41 26 255 49 39 23 255 43 34 22 255
                 40 33 21 255 35 29 20 255 33 27 19 255
                 29 25 18 255 27 24 18 255 30 25 19 255
                 32 26 21 255 30 24 21 255 22 19 18 255
                 18 16 17 255 18 17 17 255 17 16 17 255
                 18 16 18 255 19 17 18 255 20 18 17 255
                 19 17 16 255 18 16 17 255 19 17 17 255
                 23 19 18 255 24 20 19 255 22 20 18 255
                 22 19 19 255 22 17 19 255 22 16 18 255
                 25 18 19 255 23 20 20 255 24 21 19 255
                 28 23 20 255 29 24 20 255 31 24 21 255
                 43 31 24 255 40 30 23 255 39 29 22 255
                 44 32 23 255 44 33 24 255 41 30 23 255
                 45 34 25 255 48 36 25 255 51 38 26 255
                 50 36 25 255 53 37 26 255 57 40 27 255
                 62 44 30 255 63 44 29 255 64 45 28 255
                 65 47 29 255 66 47 29 255 62 45 28 255
                 53 39 26 255 44 34 24 255 44 32 22 255
                 49 34 22 255 51 34 23 255 59 39 25 255
                 63 44 27 255 74 49 30 255 76 53 31 255
                 76 51 31 255 87 59 35 255 85 62 36 255
                 81 63 35 255 75 56 32 255 78 53 33 255
                 80 54 35 255 82 55 37 255 98 67 44 255
                 107 76 47 255 82 59 38 255 63 41 32 255
                 57 39 27 255 56 42 26 255 51 39 27 255
                 54 39 29 255 52 35 26 255 49 32 25 255
                 44 31 23 255 41 31 22 255 35 26 20 255
                 29 23 19 255 34 26 21 255 32 25 21 255
                 34 27 22 255 40 30 23 255 40 30 22 255
                 40 30 23 255 56 41 27 255 54 41 27 255
                 61 44 29 255 71 52 33 255 76 54 34 255
                 72 54 33 255 64 47 29 255 55 39 25 255
                 50 34 24 255 51 35 25 255 54 37 24 255
                 51 35 23 255 48 33 22 255 44 31 22 255
                 47 31 22 255 51 34 23 255 48 34 23 255
                 53 36 24 255 65 43 27 255 75 52 31 255
                 75 52 32 255 72 51 32 255 74 52 30 255
                 70 49 28 255 61 43 26 255 59 42 27 255
                 59 42 26 255 49 37 23 255 37 29 22 255
                 33 26 21 255 37 28 23 255 40 29 23 255
                 42 32 23 255 45 34 25 255 43 31 24 255
                 35 27 21 255 17 16 17 255 16 14 15 255
                 24 20 16 255 43 33 22 255 73 63 40 255
                 86 78 53 255 86 74 51 255 77 60 41 255
                 66 47 31 255 56 40 27 255 54 41 28 255
                 58 43 28 255 60 43 29 255 58 41 27 255
                 58 41 27 255 50 38 27 255 38 31 25 255
                 41 32 25 255 55 42 29 255 40 35 25 255
                 24 23 20 255 14 15 17 255 11 12 15 255
                 9 10 15 255 9 10 14 255 9 9 14 255
                 9 9 14 255 9 9 13 255 9 9 13 255
                 9 9 13 255 8 9 13 255 8 9 13 255
                 9 9 13 255 9 9 14 255 9 10 14 255
                 9 10 14 255 11 11 15 255 10 11 15 255
                 9 10 14 255 9 10 15 255 9 10 15 255
                 9 9 14 255 10 10 15 255 10 11 15 255
                 10 11 15 255 9 10 14 255 9 9 14 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 11 15 255 9 10 15 255 9 11 15 255
                 10 11 15 255 10 11 16 255 10 11 15 255
                 20 17 19 255 48 39 29 255 52 42 30 255
                 85 66 44 255 84 68 40 255 73 55 35 255
                 74 54 34 255 80 57 35 255 81 60 36 255
                 82 61 36 255 84 62 36 255 88 66 38 255
                 95 72 41 255 106 83 47 255 101 79 45 255
                 93 72 44 255 122 98 71 255 133 115 83 255
                 117 102 70 255 66 61 41 255 38 35 27 255
                 67 57 39 255 60 52 38 255 36 35 26 255
                 19 18 18 255 45 34 27 255 70 57 40 255
                 84 60 36 255 81 59 35 255 78 56 35 255
                 78 56 35 255 80 57 35 255 84 61 36 255
                 84 63 38 255 82 60 37 255 75 55 33 255
                 69 50 31 255 63 47 30 255 60 45 30 255
                 63 46 31 255 67 49 31 255 72 51 32 255
                 75 53 32 255 75 53 33 255 74 53 34 255
                 69 51 34 255 64 48 31 255 63 46 30 255
                 70 50 33 255 74 54 34 255 74 57 35 255
                 73 55 35 255 71 53 36 255 71 55 36 255
                 70 55 33 255 59 47 28 255 45 38 24 255
                 42 35 23 255 42 34 24 255 43 33 27 255
                 47 34 28 255 56 41 29 255 58 44 27 255
                 54 41 25 255 48 37 25 255 43 34 25 255
                 45 34 24 255 51 39 24 255 50 38 23 255
                 54 39 25 255 58 41 29 255 51 37 30 255
                 48 36 28 255 53 41 26 255 51 39 23 255
                 53 40 23 255 46 36 22 255 40 31 22 255
                 35 28 21 255 31 25 20 255 29 24 20 255
                 33 26 22 255 31 23 21 255 28 21 21 255
                 24 21 18 255 20 19 17 255 20 18 17 255
                 20 17 17 255 20 18 18 255 21 18 18 255
                 21 19 17 255 18 17 16 255 16 14 16 255
                 19 17 17 255 21 18 18 255 23 20 18 255
                 24 20 19 255 23 18 19 255 23 17 18 255
                 24 17 18 255 25 18 19 255 23 20 19 255
                 24 21 19 255 25 21 19 255 27 23 20 255
                 25 21 19 255 34 25 21 255 35 26 21 255
                 31 24 21 255 40 29 23 255 37 28 22 255
                 37 28 23 255 42 32 24 255 45 34 25 255
                 46 34 25 255 49 35 26 255 52 37 27 255
                 53 38 27 255 58 42 28 255 60 43 28 255
                 60 42 27 255 64 45 28 255 65 46 29 255
                 61 44 28 255 47 37 24 255 37 28 22 255
                 42 30 22 255 49 33 23 255 56 38 24 255
                 61 42 26 255 73 51 30 255 79 57 33 255
                 74 54 34 255 81 58 35 255 85 62 36 255
                 82 61 35 255 79 58 34 255 77 54 34 255
                 82 57 36 255 81 58 35 255 83 59 35 255
                 101 71 43 255 106 76 48 255 80 57 38 255
                 57 40 28 255 50 38 24 255 53 40 26 255
                 51 36 26 255 49 32 24 255 47 30 23 255
                 43 29 22 255 32 26 20 255 34 26 21 255
                 40 29 22 255 38 29 22 255 35 27 21 255
                 34 27 21 255 38 28 22 255 42 31 23 255
                 41 31 23 255 36 28 23 255 50 36 26 255
                 53 39 27 255 59 42 29 255 65 47 31 255
                 69 50 32 255 65 48 30 255 56 41 27 255
                 48 33 23 255 46 32 23 255 42 30 22 255
                 43 30 22 255 44 30 22 255 45 31 21 255
                 43 29 21 255 48 32 22 255 52 35 24 255
                 48 34 24 255 51 35 23 255 61 41 27 255
                 67 47 30 255 71 50 31 255 68 48 31 255
                 69 49 31 255 74 52 30 255 68 47 28 255
                 60 41 25 255 62 42 26 255 58 42 26 255
                 51 38 24 255 43 32 23 255 38 30 22 255
                 36 28 22 255 32 25 21 255 28 25 21 255
                 23 21 20 255 23 20 19 255 14 13 15 255
                 36 26 21 255 64 48 31 255 80 65 39 255
                 82 74 49 255 72 64 46 255 67 53 36 255
                 64 48 31 255 66 48 30 255 63 45 28 255
                 57 41 26 255 53 40 27 255 56 41 27 255
                 56 41 27 255 52 39 26 255 43 35 25 255
                 25 23 20 255 32 26 24 255 31 27 23 255
                 18 17 19 255 13 13 16 255 11 11 15 255
                 10 10 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 9 9 13 255 9 9 13 255
                 8 9 13 255 9 9 13 255 8 9 13 255
                 8 9 13 255 9 9 13 255 9 9 14 255
                 9 9 14 255 9 10 14 255 9 9 14 255
                 9 9 15 255 9 9 14 255 9 10 14 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 10 14 255 9 9 14 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 11 15 255 9 11 15 255
                 9 10 15 255 10 11 16 255 10 11 15 255
                 10 11 15 255 13 13 17 255 37 30 25 255
                 50 42 29 255 70 53 38 255 79 65 40 255
                 68 51 32 255 74 54 34 255 76 56 35 255
                 78 57 36 255 80 59 36 255 83 62 37 255
                 81 62 37 255 88 66 40 255 109 83 48 255
)"
        R"(                 112 87 50 255 107 84 48 255 108 83 51 255
                 110 86 54 255 97 80 49 255 48 47 31 255
                 48 39 30 255 77 69 48 255 65 56 40 255
                 65 56 36 255 59 50 32 255 74 59 37 255
                 75 60 38 255 81 59 34 255 73 53 33 255
                 70 51 34 255 78 57 35 255 88 64 39 255
                 95 70 44 255 91 70 43 255 88 67 41 255
                 85 65 40 255 83 62 38 255 71 53 33 255
                 61 44 31 255 63 45 31 255 67 47 32 255
                 75 53 34 255 81 59 36 255 82 61 36 255
                 73 55 34 255 60 45 31 255 52 40 29 255
                 54 41 29 255 64 46 32 255 73 53 35 255
                 74 55 35 255 74 55 35 255 71 52 34 255
                 69 52 35 255 70 53 35 255 61 47 31 255
                 45 36 26 255 42 33 26 255 46 35 27 255
                 46 34 28 255 50 37 29 255 59 42 31 255
                 61 45 28 255 54 42 25 255 45 36 24 255
                 44 34 23 255 46 36 23 255 54 41 24 255
                 55 41 23 255 53 38 25 255 54 39 30 255
                 50 37 30 255 51 39 26 255 55 41 23 255
                 59 43 24 255 65 45 28 255 55 39 26 255
                 46 34 24 255 39 29 23 255 32 25 22 255
                 30 23 22 255 36 25 24 255 31 22 22 255
                 26 21 19 255 24 22 19 255 22 19 19 255
                 28 20 18 255 23 21 19 255 23 22 20 255
                 22 21 18 255 21 18 17 255 19 17 17 255
                 16 15 17 255 17 16 18 255 20 18 19 255
                 22 19 19 255 26 19 20 255 27 20 19 255
                 26 20 20 255 26 20 20 255 24 21 19 255
                 23 21 18 255 24 20 19 255 22 19 18 255
                 25 21 19 255 27 22 19 255 39 27 22 255
                 43 30 22 255 39 28 22 255 38 28 22 255
                 33 25 21 255 38 28 23 255 41 30 23 255
                 41 31 23 255 43 32 24 255 46 34 25 255
                 50 37 26 255 55 40 26 255 53 39 26 255
                 57 41 27 255 57 41 27 255 56 40 27 255
                 56 41 26 255 53 39 26 255 40 31 23 255
                 40 29 22 255 48 33 23 255 63 44 27 255
                 72 50 29 255 68 48 28 255 76 52 32 255
                 76 55 32 255 74 55 33 255 82 60 34 255
                 79 57 32 255 79 55 33 255 78 55 34 255
                 78 55 34 255 80 59 34 255 84 63 35 255
                 90 67 36 255 102 75 41 255 101 75 45 255
                 74 54 35 255 55 40 27 255 46 37 24 255
                 46 33 25 255 48 31 23 255 46 28 20 255
                 42 27 21 255 35 25 20 255 20 17 16 255
                 29 21 19 255 42 30 22 255 39 28 22 255
                 36 27 21 255 37 28 22 255 40 30 23 255
                 41 30 23 255 38 30 23 255 35 27 22 255
                 44 32 24 255 48 37 26 255 51 38 27 255
                 54 40 28 255 57 42 29 255 58 42 27 255
                 47 35 23 255 42 29 22 255 43 30 22 255
                 40 28 21 255 38 26 20 255 41 28 22 255
                 44 30 22 255 49 33 23 255 50 35 23 255
                 48 33 23 255 49 34 23 255 50 34 23 255
                 56 38 25 255 60 41 27 255 63 44 29 255
                 62 44 29 255 65 45 29 255 70 49 31 255
                 70 48 29 255 66 44 26 255 62 43 26 255
                 60 42 26 255 57 41 28 255 55 40 26 255
                 50 38 27 255 43 33 25 255 32 28 21 255
                 15 14 17 255 16 13 16 255 23 21 19 255
                 30 27 23 255 66 53 39 255 83 67 47 255
                 77 63 40 255 59 51 36 255 53 40 30 255
                 63 47 31 255 66 51 34 255 66 50 33 255
                 66 49 32 255 59 44 27 255 51 39 26 255
                 49 38 26 255 46 35 25 255 50 39 27 255
                 44 37 27 255 23 23 20 255 15 15 18 255
                 12 12 15 255 11 11 15 255 11 11 15 255
                 10 11 15 255 9 10 14 255 9 10 14 255
                 9 9 14 255 9 9 13 255 8 9 13 255
                 8 9 13 255 8 9 12 255 8 9 13 255
                 8 9 12 255 8 9 13 255 9 9 13 255
                 9 9 13 255 8 9 13 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 9 14 255 9 9 15 255 9 9 14 255
                 9 9 14 255 9 9 15 255 9 9 15 255
                 9 10 15 255 9 10 15 255 9 10 14 255
                 9 9 14 255 9 10 14 255 9 10 15 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 10 11 15 255 11 12 16 255
                 26 21 22 255 51 42 30 255 55 43 32 255
                 80 64 43 255 72 56 35 255 73 54 34 255
                 77 56 34 255 80 58 35 255 81 59 35 255
                 82 60 36 255 77 58 35 255 79 58 36 255
                 104 79 47 255 117 92 53 255 115 90 52 255
                 110 87 49 255 107 83 48 255 82 70 43 255
                 35 34 27 255 60 46 35 255 93 79 54 255
                 111 94 63 255 106 94 58 255 89 73 44 255
                 98 78 48 255 88 77 45 255 73 53 34 255
                 67 49 33 255 78 58 38 255 102 79 49 255
                 110 88 54 255 113 90 54 255 110 88 52 255
                 105 82 49 255 96 73 44 255 87 66 39 255
                 79 61 36 255 67 49 31 255 63 45 31 255
                 67 48 32 255 75 53 34 255 80 57 36 255
                 79 57 35 255 68 50 32 255 54 41 29 255
                 46 35 27 255 50 37 27 255 56 41 28 255
                 67 48 33 255 75 56 35 255 77 58 36 255
                 72 55 35 255 64 49 33 255 64 48 31 255
                 56 42 28 255 43 33 25 255 42 31 26 255
                 49 36 30 255 52 38 29 255 54 39 29 255
                 60 43 30 255 61 44 28 255 53 41 24 255
                 46 37 23 255 45 35 23 255 44 35 22 255
                 50 39 23 255 51 38 23 255 50 37 25 255
                 47 34 27 255 49 36 27 255 54 41 25 255
                 61 45 25 255 63 42 27 255 66 42 30 255
                 60 40 29 255 47 33 26 255 41 28 25 255
                 36 25 24 255 33 24 23 255 32 23 23 255
                 26 19 21 255 23 19 18 255 24 22 19 255
                 25 21 19 255 31 23 19 255 24 22 19 255
                 23 22 21 255 23 22 20 255 21 20 18 255
                 19 17 16 255 16 12 17 255 16 13 18 255
                 20 16 19 255 23 19 20 255 28 21 21 255
                 29 22 22 255 26 22 21 255 25 22 20 255
                 24 21 18 255 23 20 18 255 23 20 18 255
                 26 21 19 255 32 25 20 255 35 26 21 255
                 42 30 22 255 50 34 23 255 42 31 22 255
                 32 25 21 255 32 25 21 255 39 29 22 255
                 39 29 23 255 40 30 23 255 45 33 24 255
                 48 36 25 255 54 39 26 255 58 42 27 255
                 53 39 25 255 54 39 26 255 53 40 27 255
                 52 39 26 255 48 36 25 255 40 32 23 255
                 38 28 21 255 49 35 24 255 71 50 30 255
                 76 57 33 255 69 50 31 255 76 54 31 255
                 81 57 32 255 79 57 33 255 82 58 34 255
                 82 58 33 255 76 54 31 255 74 53 32 255
                 74 54 32 255 78 56 32 255 79 56 33 255
                 90 64 37 255 97 71 40 255 100 75 41 255
                 96 72 40 255 71 53 33 255 56 40 27 255
                 47 37 24 255 42 30 23 255 43 28 22 255
                 42 27 21 255 38 26 21 255 34 24 20 255
                 30 21 18 255 37 26 20 255 39 27 21 255
                 35 25 20 255 35 25 20 255 34 25 20 255
                 32 26 22 255 33 26 22 255 24 22 19 255
                 32 25 21 255 31 26 21 255 28 23 21 255
                 42 32 24 255 42 32 24 255 49 36 26 255
                 53 39 26 255 46 33 22 255 40 27 21 255
                 39 26 20 255 39 26 21 255 39 27 20 255
                 40 28 21 255 42 29 22 255 48 33 24 255
                 49 34 24 255 45 31 22 255 47 32 23 255
                 51 35 24 255 52 36 24 255 55 38 26 255
                 53 39 26 255 55 40 27 255 62 43 28 255
                 68 47 29 255 69 48 28 255 70 49 28 255
                 69 47 27 255 67 47 27 255 57 41 27 255
                 49 37 27 255 35 30 23 255 35 28 24 255
                 24 22 20 255 11 11 14 255 33 25 23 255
                 60 49 35 255 69 63 40 255 73 67 45 255
                 63 52 40 255 54 39 28 255 50 38 26 255
                 60 43 29 255 69 51 34 255 65 49 33 255
                 64 48 33 255 60 47 33 255 52 40 28 255
                 49 36 25 255 52 41 27 255 50 42 29 255
                 33 30 25 255 17 17 18 255 11 12 15 255
                 10 11 14 255 10 11 14 255 10 11 15 255
                 10 11 15 255 9 10 14 255 9 10 14 255
                 9 9 14 255 8 9 13 255 8 9 13 255
                 9 9 14 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 9 9 14 255 8 9 13 255 8 9 14 255
                 8 9 14 255 9 9 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 10 14 255 9 9 14 255 9 9 15 255
                 9 10 14 255 9 10 14 255 9 9 14 255
                 9 9 14 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 10 14 255 9 11 15 255
                 9 10 15 255 9 10 15 255 9 11 15 255
                 10 11 15 255 16 14 17 255 42 34 27 255
                 48 39 28 255 74 56 40 255 78 62 38 255
                 77 56 34 255 82 60 35 255 82 59 35 255
                 84 60 35 255 83 61 35 255 82 60 35 255
                 84 62 37 255 100 75 44 255 120 93 54 255
                 120 94 53 255 114 89 50 255 112 86 50 255
                 87 75 44 255 47 41 27 255 60 47 34 255
                 102 81 57 255 138 121 85 255 121 111 73 255
                 89 74 46 255 81 66 44 255 54 53 38 255
                 66 49 31 255 71 52 35 255 103 83 59 255
                 120 106 72 255 105 96 65 255 113 100 70 255
                 125 108 71 255 115 97 62 255 109 91 57 255
                 106 88 54 255 96 79 45 255 78 62 36 255
                 70 52 34 255 70 52 34 255 72 53 34 255
                 78 57 35 255 77 57 35 255 67 51 32 255
                 55 42 28 255 44 34 25 255 53 39 28 255
                 56 42 29 255 63 46 31 255 68 52 33 255
                 64 49 33 255 68 51 34 255 59 46 31 255
                 48 38 27 255 41 32 25 255 45 34 25 255
                 51 38 28 255 59 43 31 255 61 44 32 255
                 61 43 31 255 58 42 30 255 55 40 27 255
                 51 39 24 255 48 38 23 255 44 34 22 255
                 41 32 21 255 44 33 22 255 45 33 23 255
                 48 35 26 255 46 33 26 255 48 35 24 255
                 56 41 24 255 60 42 26 255 63 41 29 255
                 64 41 30 255 55 36 28 255 45 30 25 255
                 41 27 25 255 38 26 25 255 37 26 24 255
                 35 25 24 255 27 20 21 255 25 19 19 255
                 26 21 19 255 24 21 19 255 27 21 19 255
                 26 22 19 255 26 24 21 255 25 24 21 255
                 25 22 18 255 24 19 16 255 19 15 16 255
                 19 15 17 255 21 17 19 255 22 20 20 255
                 24 21 20 255 26 23 21 255 24 21 19 255
                 25 20 18 255 26 21 19 255 27 22 19 255
                 26 22 19 255 29 22 20 255 38 28 22 255
                 36 27 22 255 36 27 23 255 41 30 24 255
                 38 29 22 255 35 26 21 255 39 29 22 255
                 39 29 23 255 41 30 23 255 44 33 24 255
                 48 36 25 255 51 38 26 255 53 39 25 255
                 57 41 26 255 53 39 26 255 50 37 25 255
                 48 36 25 255 51 38 26 255 47 36 25 255
                 36 29 22 255 45 32 23 255 69 48 29 255
                 81 59 34 255 69 52 30 255 65 47 30 255
                 78 55 32 255 81 57 32 255 79 58 34 255
                 83 60 34 255 79 56 33 255 75 53 32 255
                 74 53 31 255 76 54 33 255 84 59 33 255
                 89 62 35 255 96 68 39 255 99 72 41 255
                 102 74 42 255 97 73 41 255 75 58 34 255
                 57 40 27 255 47 35 23 255 40 29 21 255
                 38 27 21 255 37 26 21 255 34 25 19 255
                 33 23 19 255 34 24 19 255 37 27 20 255
                 36 26 20 255 34 24 20 255 32 24 19 255
                 30 23 19 255 29 23 19 255 27 22 19 255
                 16 15 15 255 25 20 18 255 21 19 17 255
                 21 16 17 255 35 26 21 255 41 30 23 255
                 48 35 25 255 47 35 24 255 42 30 22 255
                 39 28 21 255 38 25 20 255 37 25 20 255
                 37 26 20 255 38 28 21 255 40 28 21 255
                 45 31 23 255 45 32 23 255 44 30 22 255
                 45 31 22 255 51 36 24 255 51 37 25 255
                 48 35 24 255 47 35 26 255 52 38 27 255
                 58 41 28 255 66 45 29 255 69 48 29 255
                 67 46 28 255 73 50 28 255 69 48 29 255
                 59 43 27 255 42 35 24 255 18 17 17 255
                 26 22 19 255 23 22 19 255 17 15 17 255
                 54 44 34 255 75 64 45 255 66 55 40 255
                 50 42 30 255 47 38 27 255 55 38 26 255
                 58 42 27 255 63 45 30 255 65 49 33 255
                 56 44 31 255 47 38 28 255 47 37 28 255
                 55 44 32 255 59 48 32 255 44 38 28 255
                 23 22 21 255 12 12 16 255 10 11 14 255
                 10 10 14 255 9 10 14 255 10 11 14 255
                 10 11 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 8 9 13 255 9 9 14 255
                 9 9 14 255 9 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 14 255 8 9 14 255 8 9 14 255
                 8 9 14 255 8 9 14 255 8 9 13 255
                 9 9 14 255 8 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 8 9 14 255 8 9 14 255 8 9 14 255
                 9 10 14 255 9 9 14 255 9 9 15 255
                 9 10 15 255 9 10 15 255 9 10 14 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 10 14 255 9 10 15 255
                 9 10 15 255 10 11 15 255 11 11 16 255
                 30 24 22 255 48 41 28 255 61 46 33 255
                 82 65 41 255 78 59 36 255 83 60 35 255
                 83 59 36 255 88 62 36 255 90 65 37 255
                 92 67 39 255 91 68 40 255 96 72 43 255
                 117 90 52 255 126 99 55 255 122 97 53 255
                 119 91 52 255 112 91 52 255 73 64 38 255
                 44 39 31 255 96 76 59 255 139 123 87 255
                 111 103 68 255 70 61 40 255 37 36 28 255
                 18 20 21 255 68 49 32 255 87 65 45 255
                 104 91 65 255 67 67 50 255 44 45 37 255
                 64 58 50 255 89 78 58 255 77 68 47 255
                 69 61 47 255 87 76 57 255 105 91 61 255
                 96 79 46 255 70 54 34 255 67 49 32 255
                 72 51 33 255 79 57 35 255 80 59 36 255
                 75 55 34 255 64 49 31 255 51 40 27 255
                 51 39 28 255 50 38 28 255 61 44 31 255
                 64 49 32 255 52 40 29 255 60 45 30 255
                 53 41 28 255 37 30 24 255 31 26 23 255
                 40 32 26 255 52 40 28 255 62 47 31 255
                 62 46 30 255 56 40 29 255 46 35 26 255
                 46 34 24 255 50 37 23 255 49 38 23 255
                 43 33 22 255 40 31 21 255 43 32 21 255
                 43 31 23 255 43 31 25 255 42 31 24 255
                 45 33 23 255 54 38 25 255 58 38 28 255
                 57 36 29 255 50 34 26 255 41 28 23 255
                 42 29 24 255 42 28 25 255 41 27 25 255
                 38 27 24 255 37 28 24 255 31 24 21 255
                 27 20 20 255 28 21 20 255 28 23 18 255
                 25 21 19 255 29 22 19 255 29 22 19 255
                 25 21 19 255 27 21 18 255 31 22 19 255
                 27 19 19 255 25 20 19 255 23 21 20 255
                 23 22 19 255 25 22 19 255 28 23 19 255
                 29 22 19 255 28 22 19 255 26 21 19 255
                 27 21 20 255 32 24 20 255 35 26 21 255
                 41 31 22 255 36 28 22 255 30 24 21 255
                 32 25 22 255 35 27 22 255 38 28 22 255
                 42 32 23 255 40 30 23 255 42 31 24 255
                 45 34 24 255 47 36 25 255 52 39 27 255
                 52 38 26 255 54 38 26 255 50 37 25 255
                 50 37 25 255 52 38 26 255 48 36 25 255
                 39 30 23 255 48 34 24 255 73 53 31 255
                 79 57 33 255 72 53 31 255 67 49 29 255
)"
        R"(                 65 46 29 255 76 53 31 255 80 58 33 255
                 77 56 33 255 79 57 33 255 75 54 32 255
                 71 50 31 255 71 50 31 255 81 57 34 255
                 91 65 37 255 94 66 37 255 94 67 37 255
                 97 69 39 255 103 74 42 255 102 76 44 255
                 75 58 34 255 54 39 26 255 45 32 23 255
                 38 26 20 255 36 25 20 255 34 24 19 255
                 31 23 19 255 31 23 19 255 33 24 19 255
                 33 24 19 255 32 23 19 255 31 22 18 255
                 29 21 17 255 28 21 18 255 27 21 17 255
                 24 20 17 255 15 14 15 255 17 16 17 255
                 14 13 15 255 21 16 16 255 30 22 18 255
                 42 30 22 255 47 35 23 255 46 35 23 255
                 40 30 22 255 37 27 21 255 38 26 20 255
                 39 27 20 255 37 26 20 255 38 27 21 255
                 39 27 21 255 40 28 21 255 42 29 22 255
                 43 31 22 255 47 33 23 255 50 36 24 255
                 53 38 25 255 45 33 23 255 45 33 25 255
                 49 36 27 255 55 39 27 255 68 46 28 255
                 69 48 29 255 63 44 28 255 63 44 28 255
                 59 43 27 255 49 36 26 255 27 25 20 255
                 17 15 16 255 49 39 30 255 53 49 31 255
                 42 36 28 255 57 49 36 255 51 43 29 255
                 47 35 25 255 52 36 26 255 56 43 26 255
                 55 41 28 255 50 38 25 255 44 34 25 255
                 37 31 26 255 35 30 25 255 39 33 26 255
                 39 34 28 255 35 31 28 255 26 25 24 255
                 15 14 17 255 10 10 14 255 10 10 14 255
                 10 10 14 255 10 11 15 255 10 10 14 255
                 10 10 14 255 9 10 14 255 9 10 14 255
                 9 9 14 255 8 9 13 255 8 9 13 255
                 8 9 13 255 9 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 14 255 8 9 14 255
                 8 9 14 255 8 9 13 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 9 13 255
                 9 9 14 255 8 9 14 255 8 9 13 255
                 8 9 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 8 9 14 255 8 9 14 255
                 8 10 14 255 9 10 15 255 9 10 15 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 14 255 9 10 14 255 10 11 15 255
                 10 11 15 255 20 17 19 255 48 40 29 255
                 51 41 29 255 79 61 41 255 81 64 38 255
                 88 63 37 255 95 68 39 255 97 71 40 255
                 94 69 41 255 86 63 39 255 81 59 37 255
                 81 60 37 255 105 76 45 255 123 96 54 255
                 122 98 54 255 122 94 53 255 119 95 55 255
                 72 65 40 255 31 30 25 255 92 73 56 255
                 133 118 84 255 101 93 60 255 53 48 33 255
                 18 20 19 255 12 13 16 255 73 53 36 255
                 105 84 59 255 90 85 52 255 65 63 47 255
                 63 69 53 255 55 63 56 255 64 68 54 255
                 47 49 36 255 29 31 29 255 46 43 36 255
                 73 62 49 255 98 84 55 255 68 56 33 255
                 63 48 32 255 77 58 36 255 82 62 37 255
                 82 61 37 255 76 57 36 255 63 49 32 255
                 53 41 29 255 51 39 27 255 51 39 28 255
                 58 43 30 255 57 44 30 255 44 35 26 255
                 50 38 27 255 48 37 26 255 40 32 24 255
                 34 28 23 255 38 29 24 255 48 36 27 255
                 57 43 29 255 55 42 26 255 46 35 25 255
                 39 30 23 255 40 30 22 255 47 36 24 255
                 46 35 23 255 42 32 21 255 39 30 20 255
                 41 30 21 255 42 30 23 255 40 29 24 255
                 38 29 22 255 39 29 21 255 45 31 24 255
                 49 32 24 255 47 31 23 255 44 31 23 255
                 39 29 22 255 41 28 22 255 42 28 24 255
                 40 29 24 255 39 29 23 255 42 32 23 255
                 36 29 22 255 32 26 20 255 32 23 22 255
                 34 24 21 255 35 27 21 255 36 30 22 255
                 32 26 20 255 26 21 18 255 27 21 19 255
                 31 23 21 255 32 25 22 255 29 25 21 255
                 24 21 19 255 26 21 19 255 28 22 20 255
                 32 25 20 255 37 28 21 255 34 26 20 255
                 30 23 20 255 30 23 20 255 36 26 21 255
                 41 30 23 255 37 29 22 255 30 25 21 255
                 29 23 20 255 36 28 22 255 38 30 23 255
                 38 29 22 255 40 31 23 255 42 32 23 255
                 43 33 24 255 47 36 26 255 48 37 25 255
                 50 38 26 255 47 35 25 255 49 36 25 255
                 47 35 24 255 47 36 25 255 50 37 26 255
                 46 35 24 255 48 35 24 255 74 53 32 255
                 80 58 33 255 71 53 32 255 64 48 29 255
                 62 46 28 255 67 48 30 255 79 56 33 255
                 82 60 35 255 85 62 35 255 80 59 33 255
                 72 52 32 255 69 48 29 255 72 50 31 255
                 86 60 35 255 89 63 35 255 90 63 35 255
                 94 67 37 255 98 70 39 255 106 77 44 255
                 110 84 47 255 80 64 35 255 52 39 26 255
                 40 30 22 255 35 25 20 255 34 24 19 255
                 32 23 19 255 30 22 18 255 29 22 18 255
                 30 22 19 255 30 22 19 255 28 21 17 255
                 28 21 17 255 28 20 17 255 29 21 17 255
                 26 20 17 255 22 18 16 255 13 12 13 255
                 13 11 14 255 18 15 15 255 22 18 16 255
                 26 19 17 255 36 26 21 255 42 31 23 255
                 41 30 22 255 36 27 21 255 34 25 20 255
                 35 24 20 255 36 25 20 255 36 26 20 255
                 37 26 20 255 36 26 20 255 38 27 21 255
                 41 28 22 255 42 29 22 255 43 31 22 255
                 44 31 22 255 47 33 23 255 44 31 22 255
                 40 30 22 255 36 27 23 255 45 32 26 255
                 63 43 29 255 60 43 28 255 39 31 24 255
                 42 31 24 255 61 44 27 255 48 38 24 255
                 24 23 19 255 34 27 23 255 71 59 43 255
                 71 61 40 255 52 43 30 255 43 33 27 255
                 45 35 24 255 50 39 24 255 50 37 27 255
                 42 33 23 255 38 34 24 255 37 32 23 255
                 30 29 22 255 25 25 22 255 23 23 23 255
                 21 21 21 255 15 16 19 255 12 13 17 255
                 11 11 15 255 10 9 14 255 9 9 14 255
                 9 10 13 255 9 10 13 255 9 10 14 255
                 9 10 14 255 9 10 14 255 9 10 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 9 9 13 255 8 9 13 255
                 8 9 13 255 9 9 13 255 8 9 13 255
                 9 9 13 255 8 9 13 255 8 9 14 255
                 8 9 14 255 9 9 15 255 8 9 14 255
                 8 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 10 14 255 9 10 14 255
                 9 9 14 255 8 9 14 255 9 9 14 255
                 8 9 13 255 8 9 14 255 9 9 14 255
                 9 9 14 255 9 10 15 255 9 10 15 255
                 9 10 15 255 8 9 15 255 9 9 15 255
                 8 10 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 9 9 15 255 9 10 14 255
                 9 11 15 255 10 10 15 255 14 13 16 255
                 42 33 27 255 50 41 29 255 69 51 37 255
                 90 71 44 255 87 64 40 255 90 64 39 255
                 90 64 38 255 85 62 37 255 80 57 34 255
                 79 57 34 255 78 59 35 255 88 67 40 255
                 104 81 47 255 116 90 50 255 121 94 53 255
                 116 92 53 255 85 72 43 255 69 58 39 255
                 110 93 64 255 122 107 73 255 106 95 61 255
                 70 60 35 255 34 33 22 255 20 18 17 255
                 86 66 47 255 108 94 66 255 78 76 50 255
                 70 67 53 255 69 75 62 255 57 68 63 255
                 69 75 62 255 63 64 41 255 28 33 25 255
                 33 35 30 255 43 43 36 255 70 62 49 255
                 73 61 39 255 69 52 34 255 79 60 38 255
                 82 62 38 255 81 61 37 255 74 56 35 255
                 60 46 31 255 48 38 27 255 49 39 27 255
                 51 39 28 255 55 41 29 255 53 41 28 255
                 39 32 25 255 40 32 25 255 46 36 26 255
                 42 34 25 255 38 30 23 255 40 30 24 255
                 52 39 27 255 53 41 28 255 44 35 25 255
                 44 35 24 255 41 33 23 255 39 30 22 255
                 40 31 22 255 43 32 21 255 41 31 20 255
                 34 28 19 255 33 25 19 255 34 25 22 255
                 33 25 21 255 35 27 21 255 39 27 22 255
                 40 27 22 255 40 28 21 255 40 29 21 255
                 39 30 21 255 38 28 21 255 41 28 23 255
                 41 28 25 255 42 30 24 255 42 33 22 255
                 42 33 22 255 36 30 20 255 32 27 19 255
                 32 26 20 255 35 26 22 255 37 27 22 255
                 40 30 22 255 41 32 23 255 34 28 21 255
                 36 29 22 255 36 29 22 255 36 29 22 255
                 36 27 21 255 31 24 19 255 28 23 20 255
                 28 22 20 255 35 26 20 255 40 29 22 255
                 40 29 22 255 39 28 22 255 38 28 22 255
                 38 28 22 255 37 28 22 255 31 25 21 255
                 31 24 20 255 31 25 21 255 37 29 22 255
                 40 30 23 255 40 30 23 255 41 32 24 255
                 40 31 23 255 45 33 24 255 50 37 26 255
                 50 36 25 255 49 36 25 255 49 36 25 255
                 47 34 25 255 50 37 25 255 47 36 25 255
                 46 34 24 255 60 42 27 255 77 55 32 255
                 78 56 33 255 74 53 32 255 68 50 31 255
                 61 46 28 255 66 49 29 255 74 53 32 255
                 79 57 34 255 86 63 36 255 90 66 36 255
                 77 57 32 255 68 49 30 255 70 49 30 255
                 71 50 30 255 80 56 34 255 84 59 33 255
                 90 63 36 255 97 69 38 255 104 75 41 255
                 115 86 47 255 110 85 47 255 80 64 35 255
                 48 37 25 255 36 28 21 255 33 24 20 255
                 32 23 19 255 31 23 19 255 29 22 18 255
                 28 21 18 255 29 22 18 255 28 21 18 255
                 28 21 18 255 29 21 17 255 32 23 18 255
                 34 24 19 255 29 22 18 255 25 20 17 255
                 18 16 15 255 20 16 15 255 23 18 16 255
                 22 17 16 255 24 19 17 255 32 23 19 255
                 33 25 20 255 36 26 21 255 33 25 20 255
                 30 22 18 255 30 21 18 255 31 22 18 255
                 32 23 20 255 34 25 20 255 35 25 20 255
                 37 26 20 255 38 26 21 255 39 27 22 255
                 39 27 21 255 42 29 22 255 44 31 23 255
                 41 29 21 255 37 27 21 255 31 24 20 255
                 34 25 21 255 49 34 26 255 39 31 24 255
                 19 18 18 255 30 22 20 255 74 53 34 255
                 74 63 38 255 56 50 32 255 59 50 35 255
                 54 46 34 255 48 37 27 255 46 34 23 255
                 46 34 26 255 43 35 24 255 39 35 22 255
                 40 33 24 255 37 30 24 255 31 29 23 255
                 25 23 21 255 16 17 19 255 13 13 17 255
                 12 12 16 255 11 11 15 255 10 10 14 255
                 9 9 13 255 9 9 12 255 9 9 14 255
                 9 9 14 255 9 9 13 255 9 9 13 255
                 9 9 13 255 9 10 13 255 9 10 14 255
                 9 10 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 9 10 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 9 9 14 255 8 9 14 255 8 9 14 255
                 8 9 14 255 9 9 14 255 9 9 14 255
                 8 9 14 255 8 9 13 255 8 9 14 255
                 8 9 14 255 8 10 14 255 9 9 14 255
                 9 10 14 255 8 9 14 255 8 9 14 255
                 9 10 14 255 9 10 14 255 8 9 14 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 15 255 9 10 15 255 10 10 15 255
                 11 12 15 255 31 25 24 255 50 41 30 255
                 57 43 31 255 87 68 42 255 78 61 37 255
                 78 56 35 255 87 61 36 255 86 62 35 255
                 82 59 34 255 79 58 35 255 75 59 35 255
                 57 48 31 255 77 59 38 255 96 77 47 255
                 116 90 53 255 119 95 54 255 92 76 45 255
                 90 71 48 255 123 107 74 255 108 97 70 255
                 95 82 56 255 82 68 43 255 56 54 35 255
                 37 33 25 255 93 80 57 255 60 60 43 255
                 50 48 36 255 53 51 39 255 48 48 37 255
                 44 46 39 255 60 57 49 255 70 67 47 255
                 31 34 27 255 24 27 27 255 29 32 27 255
                 37 37 32 255 62 53 38 255 70 54 35 255
                 77 57 37 255 77 57 36 255 74 54 35 255
                 72 52 34 255 62 47 31 255 44 35 26 255
                 45 35 27 255 47 35 27 255 50 38 28 255
                 49 38 27 255 36 29 23 255 35 28 23 255
                 42 33 25 255 39 31 24 255 38 29 23 255
                 45 34 25 255 58 43 29 255 49 39 26 255
                 40 32 25 255 39 32 24 255 39 32 23 255
                 38 31 21 255 32 26 19 255 37 28 20 255
                 39 29 20 255 31 25 19 255 27 22 20 255
                 26 20 21 255 28 23 19 255 32 24 21 255
                 36 24 22 255 37 27 21 255 36 29 20 255
                 35 29 20 255 35 29 20 255 38 27 21 255
                 38 26 23 255 42 29 24 255 44 32 23 255
                 42 33 21 255 38 31 21 255 33 28 20 255
                 30 26 19 255 27 24 18 255 29 25 20 255
                 34 26 22 255 45 32 24 255 50 35 26 255
                 48 34 24 255 47 34 23 255 46 33 23 255
                 43 31 23 255 44 32 23 255 42 32 22 255
                 36 28 21 255 32 25 21 255 37 27 21 255
                 40 30 22 255 43 32 23 255 42 30 22 255
                 37 27 22 255 33 25 21 255 33 24 20 255
                 32 25 21 255 37 28 22 255 40 31 23 255
                 40 32 23 255 42 32 24 255 41 32 24 255
                 44 34 24 255 43 32 23 255 48 35 25 255
                 50 36 25 255 54 38 26 255 57 41 27 255
                 52 38 26 255 47 35 25 255 47 36 25 255
                 45 34 24 255 59 41 26 255 79 58 32 255
                 76 56 33 255 74 52 31 255 73 52 31 255
                 72 52 30 255 71 51 30 255 75 54 32 255
                 79 58 34 255 80 59 35 255 92 68 39 255
                 88 63 35 255 79 57 32 255 68 49 29 255
                 67 46 28 255 67 47 28 255 75 52 31 255
                 82 57 33 255 94 66 37 255 105 77 42 255
                 111 80 44 255 118 89 48 255 112 86 46 255
                 79 63 35 255 50 38 25 255 37 28 21 255
                 32 24 20 255 29 22 18 255 29 21 18 255
                 29 22 18 255 28 21 18 255 30 22 19 255
                 30 23 18 255 30 22 18 255 32 23 18 255
                 34 24 19 255 36 25 20 255 35 24 19 255
                 27 21 17 255 17 14 15 255 23 17 16 255
                 23 18 16 255 18 16 16 255 20 16 16 255
                 27 20 18 255 28 22 18 255 30 22 19 255
                 30 22 18 255 28 21 17 255 27 20 17 255
                 28 20 17 255 29 22 18 255 31 23 19 255
                 34 25 20 255 34 25 20 255 32 24 20 255
                 34 24 20 255 37 26 20 255 40 28 22 255
                 40 28 21 255 40 28 20 255 36 26 20 255
                 37 27 21 255 44 31 24 255 38 30 23 255
                 20 19 18 255 14 13 16 255 42 31 26 255
                 84 68 45 255 85 74 49 255 66 58 39 255
                 45 38 29 255 39 30 23 255 41 31 23 255
                 45 35 23 255 43 35 27 255 43 39 25 255
                 41 39 23 255 32 30 23 255 20 18 20 255
                 13 13 16 255 11 11 15 255 10 10 14 255
                 8 9 13 255 8 7 12 255 8 8 12 255
                 8 8 12 255 8 8 12 255 8 8 13 255
                 8 9 14 255 9 9 14 255 8 9 13 255
                 8 9 13 255 9 10 13 255 9 9 13 255
                 9 9 13 255 9 9 13 255 9 9 14 255
                 8 9 13 255 8 9 14 255 8 9 13 255
                 8 9 13 255 9 9 13 255 8 9 13 255
                 8 8 13 255 8 9 13 255 8 9 12 255
                 8 9 13 255 8 9 13 255 8 9 14 255
                 9 9 14 255 8 9 14 255 8 9 13 255
                 8 9 14 255 8 9 14 255 8 9 13 255
                 8 9 13 255 8 9 14 255 8 9 14 255
                 8 9 13 255 8 9 14 255 8 9 13 255
                 8 9 13 255 8 9 14 255 8 9 14 255
                 9 9 15 255 8 9 14 255 8 9 14 255
                 9 9 14 255 9 10 14 255 9 10 14 255
)"
        R"(                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 9 9 14 255 9 10 14 255
                 10 10 15 255 11 11 16 255 21 18 20 255
                 49 40 30 255 55 43 29 255 83 62 41 255
                 79 63 39 255 73 52 34 255 84 59 36 255
                 90 63 37 255 85 61 36 255 76 56 35 255
                 69 54 33 255 38 36 26 255 51 43 33 255
                 46 41 32 255 100 74 47 255 121 97 55 255
                 98 80 46 255 103 84 57 255 104 97 69 255
                 65 58 44 255 71 55 41 255 64 55 40 255
                 26 30 27 255 16 17 20 255 78 74 49 255
                 42 43 33 255 76 70 55 255 94 89 61 255
                 92 85 59 255 96 90 58 255 93 85 55 255
                 97 89 56 255 71 66 41 255 59 56 36 255
                 36 38 27 255 27 29 25 255 52 46 37 255
                 68 52 34 255 70 51 34 255 72 52 33 255
                 75 55 35 255 79 58 36 255 70 53 32 255
                 46 37 24 255 39 30 24 255 45 34 25 255
                 52 39 27 255 53 40 27 255 37 30 23 255
                 33 27 22 255 42 33 25 255 38 30 24 255
                 39 30 23 255 46 35 26 255 52 40 28 255
                 44 35 25 255 39 31 24 255 33 27 24 255
                 32 27 22 255 33 27 21 255 29 25 19 255
                 30 24 19 255 36 28 20 255 29 23 19 255
                 24 20 20 255 25 21 20 255 29 24 20 255
                 31 24 21 255 31 23 20 255 32 27 20 255
                 35 30 21 255 37 31 21 255 36 28 20 255
                 38 26 22 255 42 28 23 255 42 30 23 255
                 45 34 23 255 40 32 22 255 32 27 22 255
                 28 23 21 255 28 23 20 255 24 22 19 255
                 26 23 19 255 29 25 20 255 38 30 22 255
                 49 37 25 255 49 36 25 255 50 37 25 255
                 47 35 24 255 39 30 22 255 40 30 22 255
                 49 35 24 255 45 33 23 255 37 28 22 255
                 36 27 22 255 39 29 22 255 43 32 23 255
                 40 30 22 255 33 26 21 255 31 24 20 255
                 31 24 20 255 32 26 21 255 35 28 22 255
                 38 30 23 255 37 30 23 255 36 29 23 255
                 38 30 23 255 44 34 24 255 48 35 24 255
                 54 38 26 255 63 45 28 255 63 45 28 255
                 57 41 27 255 50 37 25 255 49 36 25 255
                 47 35 24 255 63 45 27 255 80 58 33 255
                 72 54 30 255 65 48 29 255 69 50 30 255
                 70 51 30 255 78 56 32 255 79 57 33 255
                 76 55 32 255 77 57 34 255 86 62 36 255
                 98 72 39 255 90 64 35 255 82 59 33 255
                 72 52 30 255 68 48 29 255 70 50 30 255
                 77 54 32 255 85 60 34 255 89 63 35 255
                 97 69 39 255 104 75 41 255 109 79 44 255
                 105 79 44 255 77 59 34 255 49 38 26 255
                 37 28 22 255 38 28 22 255 31 24 19 255
                 28 22 18 255 28 21 18 255 29 22 18 255
                 32 24 19 255 35 25 19 255 35 25 19 255
                 34 25 19 255 36 25 19 255 35 25 19 255
                 33 24 18 255 30 22 18 255 23 19 16 255
                 23 18 16 255 22 18 16 255 15 13 14 255
                 23 17 16 255 28 21 17 255 28 21 18 255
                 28 20 18 255 30 22 18 255 29 21 18 255
                 26 19 17 255 27 20 17 255 28 21 18 255
                 30 22 18 255 31 23 18 255 31 23 19 255
                 31 23 19 255 34 24 19 255 34 24 19 255
                 37 25 20 255 40 28 21 255 41 28 21 255
                 43 29 22 255 43 31 23 255 36 29 23 255
                 20 18 18 255 22 18 18 255 41 33 25 255
                 73 60 41 255 79 68 46 255 57 48 34 255
                 35 30 24 255 28 25 21 255 43 33 24 255
                 40 33 23 255 42 34 25 255 37 32 27 255
                 30 29 22 255 22 23 19 255 15 15 17 255
                 11 10 15 255 9 10 14 255 9 9 14 255
                 9 9 13 255 8 9 13 255 7 8 12 255
                 8 7 12 255 8 8 12 255 8 8 12 255
                 8 9 13 255 8 9 14 255 9 9 13 255
                 9 9 13 255 8 9 13 255 9 10 13 255
                 8 9 13 255 8 9 13 255 9 9 13 255
                 9 9 14 255 8 9 13 255 9 9 14 255
                 8 9 13 255 8 9 13 255 9 9 13 255
                 9 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 9 9 13 255 9 9 14 255
                 9 10 15 255 9 10 15 255 8 10 14 255
                 8 9 14 255 8 9 14 255 8 9 14 255
                 8 9 13 255 8 9 13 255 8 9 14 255
                 8 9 14 255 8 9 14 255 8 9 14 255
                 8 9 13 255 9 9 14 255 8 9 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 9 10 14 255 9 9 14 255 9 9 14 255
                 9 10 14 255 9 10 14 255 9 9 14 255
                 9 10 14 255 10 10 15 255 11 11 16 255
                 15 14 18 255 45 35 29 255 53 43 30 255
                 73 55 38 255 86 69 43 255 75 57 36 255
                 81 58 36 255 85 60 36 255 85 62 36 255
                 76 57 35 255 62 50 32 255 33 30 24 255
                 52 43 29 255 57 45 29 255 109 82 48 255
                 120 95 53 255 96 79 46 255 84 69 50 255
                 72 70 54 255 43 41 32 255 67 53 37 255
                 49 46 33 255 16 20 21 255 13 15 18 255
                 47 50 34 255 43 41 33 255 63 59 52 255
                 79 75 60 255 93 86 69 255 109 101 77 255
                 109 101 71 255 105 97 70 255 114 103 72 255
                 107 97 62 255 57 58 36 255 29 32 24 255
                 49 45 36 255 66 53 34 255 65 48 32 255
                 72 52 35 255 79 58 38 255 84 62 38 255
                 79 60 36 255 58 45 27 255 44 34 24 255
                 45 35 26 255 48 36 26 255 50 38 26 255
                 40 31 23 255 34 27 23 255 43 33 25 255
                 38 31 24 255 36 29 23 255 40 30 24 255
                 45 34 26 255 44 33 25 255 40 32 23 255
                 35 29 23 255 34 27 23 255 31 25 22 255
                 28 23 20 255 26 22 19 255 31 25 19 255
                 27 22 19 255 21 18 19 255 23 20 19 255
                 27 23 20 255 30 22 21 255 32 24 20 255
                 29 25 19 255 33 28 20 255 36 29 20 255
                 37 27 20 255 36 25 22 255 40 29 23 255
                 41 31 22 255 39 31 22 255 35 28 23 255
                 31 24 22 255 27 22 21 255 27 22 21 255
                 26 21 21 255 27 21 21 255 28 23 19 255
                 31 25 20 255 39 31 22 255 43 34 23 255
                 47 36 24 255 46 34 24 255 39 29 22 255
                 42 29 22 255 48 34 24 255 45 33 23 255
                 36 29 21 255 35 27 21 255 38 28 22 255
                 36 28 22 255 34 26 21 255 33 26 21 255
                 32 25 20 255 34 26 21 255 32 27 21 255
                 32 26 22 255 34 27 22 255 36 28 23 255
                 40 31 24 255 42 32 24 255 50 37 26 255
                 56 40 26 255 58 41 28 255 61 43 28 255
                 56 40 27 255 57 41 27 255 49 38 25 255
                 52 38 26 255 69 50 30 255 77 57 32 255
                 71 53 31 255 57 43 27 255 53 39 27 255
                 56 42 27 255 62 44 28 255 79 56 34 255
                 81 59 34 255 79 58 34 255 80 58 35 255
                 96 69 39 255 98 72 40 255 92 65 36 255
                 86 62 33 255 79 57 32 255 73 52 31 255
                 74 53 30 255 80 57 32 255 81 58 33 255
                 77 55 32 255 88 62 35 255 96 70 39 255
                 95 69 39 255 91 68 38 255 71 54 33 255
                 44 34 25 255 32 26 21 255 36 27 22 255
                 34 26 21 255 32 24 19 255 30 22 19 255
                 30 22 18 255 35 25 19 255 40 28 20 255
                 38 27 20 255 37 26 20 255 36 26 19 255
                 33 24 18 255 30 22 18 255 27 21 17 255
                 25 20 16 255 24 19 16 255 24 19 17 255
                 19 15 15 255 24 19 17 255 27 21 18 255
                 29 22 18 255 27 20 17 255 28 21 18 255
                 27 21 18 255 24 18 17 255 26 20 18 255
                 28 21 18 255 29 22 18 255 29 22 18 255
                 30 22 18 255 32 23 18 255 34 24 20 255
                 33 24 19 255 35 24 20 255 38 27 21 255
                 40 28 22 255 36 27 23 255 29 24 21 255
                 25 21 19 255 34 26 21 255 66 51 34 255
                 82 68 45 255 74 64 42 255 54 45 31 255
                 43 33 24 255 25 22 19 255 14 13 15 255
                 24 20 20 255 27 23 20 255 21 18 19 255
                 17 17 18 255 15 16 17 255 13 14 16 255
                 11 11 16 255 9 9 13 255 8 9 12 255
                 8 8 14 255 8 8 13 255 8 9 13 255
                 8 9 14 255 8 8 13 255 8 8 13 255
                 8 9 14 255 8 9 13 255 9 9 13 255
                 9 9 13 255 9 9 13 255 9 10 13 255
                 9 10 13 255 9 10 13 255 8 10 13 255
                 9 9 13 255 9 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 12 255 8 9 13 255 9 9 14 255
                 9 10 14 255 9 10 14 255 9 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 9 9 14 255 8 9 14 255 9 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 8 9 14 255 8 9 13 255 9 9 14 255
                 9 10 14 255 8 9 14 255 8 9 13 255
                 9 9 14 255 9 10 14 255 9 9 14 255
                 9 10 14 255 9 10 14 255 10 10 15 255
                 10 10 15 255 10 11 15 255 10 11 15 255
                 10 11 15 255 12 12 17 255 36 28 27 255
                 52 43 30 255 63 47 33 255 88 69 45 255
                 78 61 38 255 73 53 35 255 77 55 34 255
                 83 61 36 255 78 59 36 255 71 55 33 255
                 62 48 29 255 74 59 36 255 102 79 45 255
                 127 101 57 255 122 99 55 255 87 74 44 255
                 63 52 35 255 50 44 32 255 46 36 28 255
                 75 57 37 255 46 45 31 255 14 17 19 255
                 12 15 18 255 34 38 30 255 50 49 38 255
                 36 38 35 255 38 38 40 255 46 46 45 255
                 54 53 49 255 58 57 52 255 86 79 64 255
                 111 97 70 255 111 97 66 255 71 69 43 255
                 30 33 25 255 54 49 39 255 68 55 35 255
                 65 48 32 255 72 53 36 255 81 61 38 255
                 83 62 38 255 79 60 37 255 68 52 32 255
                 56 42 27 255 54 40 27 255 49 37 26 255
                 46 35 25 255 43 33 25 255 36 29 23 255
                 46 35 25 255 33 28 23 255 35 27 23 255
                 41 32 24 255 39 30 24 255 40 31 24 255
                 44 34 25 255 37 30 23 255 34 27 22 255
                 31 25 22 255 28 23 22 255 26 22 20 255
                 27 23 18 255 24 21 18 255 21 17 19 255
                 24 21 19 255 26 23 19 255 33 24 22 255
                 35 26 21 255 31 26 20 255 34 27 20 255
                 38 29 21 255 38 26 22 255 39 28 22 255
                 36 29 21 255 34 27 22 255 31 25 22 255
                 35 27 23 255 39 29 22 255 34 26 21 255
                 35 27 21 255 36 27 22 255 32 23 21 255
                 30 22 20 255 29 23 20 255 28 22 21 255
                 33 24 23 255 46 33 25 255 51 37 24 255
                 45 34 24 255 38 30 23 255 33 26 21 255
                 37 28 22 255 34 27 21 255 38 28 22 255
                 44 32 24 255 40 31 23 255 33 26 21 255
                 32 25 21 255 35 26 22 255 36 27 22 255
                 34 27 22 255 35 28 22 255 39 30 23 255
                 37 28 22 255 41 31 23 255 47 34 24 255
                 55 39 26 255 63 45 27 255 65 45 28 255
                 59 42 27 255 54 39 26 255 50 37 25 255
                 51 38 25 255 70 50 31 255 72 54 32 255
                 57 44 27 255 55 41 26 255 49 38 25 255
                 48 36 25 255 49 37 25 255 58 42 28 255
                 76 54 33 255 79 57 33 255 78 57 34 255
                 88 62 37 255 100 73 40 255 93 67 37 255
                 90 64 35 255 86 62 34 255 82 59 33 255
                 75 54 31 255 71 51 30 255 71 51 31 255
                 69 49 30 255 74 52 31 255 87 63 35 255
                 88 63 36 255 83 59 34 255 76 55 32 255
                 63 47 30 255 43 32 23 255 32 26 21 255
                 35 26 21 255 38 28 21 255 37 27 21 255
                 35 25 20 255 34 24 19 255 40 28 21 255
                 43 30 21 255 39 27 20 255 37 26 19 255
                 36 25 19 255 32 23 18 255 29 21 17 255
                 28 21 18 255 26 20 17 255 25 19 17 255
                 26 20 17 255 26 19 17 255 26 20 17 255
                 27 20 18 255 29 22 18 255 29 21 17 255
                 29 22 18 255 29 21 18 255 30 21 18 255
                 26 20 17 255 27 21 17 255 28 22 18 255
                 30 22 19 255 31 23 19 255 32 23 18 255
                 33 23 19 255 32 24 19 255 36 25 20 255
                 36 27 22 255 32 26 22 255 20 18 18 255
                 23 19 18 255 50 37 26 255 76 62 40 255
                 88 74 48 255 74 62 42 255 49 40 28 255
                 41 32 23 255 29 25 19 255 14 14 15 255
                 11 10 13 255 14 13 15 255 13 12 15 255
                 11 10 14 255 11 11 15 255 11 10 15 255
                 11 10 15 255 10 10 14 255 9 11 13 255
                 8 10 13 255 8 9 14 255 9 8 13 255
                 9 9 13 255 8 9 14 255 8 9 13 255
                 8 9 14 255 8 9 14 255 8 9 13 255
                 9 9 13 255 8 9 13 255 9 10 14 255
                 9 10 14 255 9 10 14 255 9 10 14 255
                 9 10 13 255 9 9 13 255 9 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 9 9 14 255 9 10 14 255 8 9 13 255
                 8 9 13 255 8 9 12 255 9 9 13 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 10 10 15 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 8 9 14 255
                 9 10 14 255 10 10 14 255 9 10 14 255
                 9 9 13 255 8 9 14 255 8 8 14 255
                 8 9 14 255 8 9 14 255 8 9 14 255
                 8 9 14 255 9 9 14 255 8 9 14 255
                 8 9 14 255 9 9 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 10 10 14 255
                 10 10 15 255 9 10 15 255 10 10 15 255
                 10 11 15 255 10 11 15 255 12 12 16 255
                 29 24 24 255 50 42 30 255 56 43 30 255
                 86 65 43 255 83 66 41 255 70 53 33 255
                 78 55 34 255 85 62 35 255 85 62 36 255
                 83 62 35 255 77 59 35 255 62 51 33 255
                 108 81 49 255 131 106 61 255 119 97 55 255
                 82 68 40 255 68 53 35 255 69 53 33 255
                 81 59 36 255 98 75 44 255 72 67 38 255
                 21 24 21 255 14 15 19 255 21 27 25 255
                 20 23 25 255 14 15 20 255 15 16 23 255
                 21 22 28 255 26 29 30 255 22 24 29 255
                 61 56 55 255 109 98 71 255 110 100 66 255
                 66 67 44 255 45 46 33 255 63 57 40 255
                 64 51 34 255 66 48 32 255 71 52 35 255
                 76 56 37 255 77 57 37 255 77 58 36 255
                 70 52 32 255 62 45 28 255 51 38 27 255
                 46 35 26 255 45 34 24 255 47 36 25 255
                 40 32 23 255 41 32 24 255 29 25 21 255
                 32 25 22 255 42 31 24 255 41 31 24 255
                 38 29 23 255 38 29 24 255 38 30 23 255
                 34 28 21 255 30 25 20 255 27 22 21 255
                 24 21 20 255 26 22 19 255 25 21 18 255
                 25 20 20 255 27 23 21 255 27 23 20 255
                 36 27 23 255 38 27 23 255 37 27 22 255
                 38 28 22 255 42 28 22 255 38 27 22 255
                 43 32 22 255 36 28 22 255 33 25 22 255
                 32 25 20 255 35 27 21 255 38 30 22 255
                 34 27 21 255 37 29 21 255 44 32 22 255
                 48 33 22 255 48 33 24 255 45 32 23 255
                 36 26 21 255 34 25 22 255 43 31 23 255
                 49 36 25 255 43 32 24 255 35 28 22 255
                 25 21 19 255 29 23 21 255 32 25 21 255
                 41 30 23 255 46 33 25 255 46 35 25 255
                 38 29 22 255 37 27 22 255 39 29 22 255
                 37 29 22 255 33 26 21 255 35 26 22 255
                 40 30 23 255 40 29 22 255 46 33 24 255
                 56 39 26 255 61 42 27 255 65 46 28 255
                 60 42 27 255 52 38 25 255 44 33 24 255
                 48 35 24 255 68 49 31 255 75 55 34 255
)"
        R"(                 61 46 29 255 51 40 26 255 49 39 25 255
                 47 37 25 255 51 38 25 255 54 41 26 255
                 64 46 28 255 75 54 31 255 73 54 33 255
                 78 57 35 255 95 67 38 255 99 72 38 255
                 90 64 36 255 86 61 35 255 82 59 33 255
                 79 56 32 255 70 50 29 255 63 45 28 255
                 65 45 28 255 66 46 29 255 72 50 30 255
                 81 58 34 255 79 57 33 255 75 53 32 255
                 73 52 31 255 62 45 28 255 46 34 24 255
                 39 29 22 255 39 28 22 255 42 30 22 255
                 44 31 22 255 42 30 21 255 40 28 21 255
                 43 31 22 255 46 31 22 255 42 29 20 255
                 38 26 19 255 36 25 19 255 33 24 19 255
                 28 21 18 255 27 21 18 255 26 20 17 255
                 27 20 18 255 26 20 17 255 25 19 17 255
                 24 19 17 255 26 20 17 255 29 22 19 255
                 29 21 17 255 31 22 17 255 30 22 18 255
                 31 22 18 255 26 19 17 255 26 20 17 255
                 29 21 18 255 31 23 19 255 33 24 19 255
                 31 23 18 255 31 22 19 255 32 24 20 255
                 33 25 22 255 23 21 19 255 17 15 17 255
                 27 20 19 255 62 46 31 255 84 68 44 255
                 86 72 47 255 68 56 39 255 51 40 28 255
                 37 29 22 255 24 21 18 255 17 16 17 255
                 14 14 16 255 13 13 15 255 11 11 14 255
                 9 9 13 255 9 9 13 255 9 9 13 255
                 9 9 13 255 8 10 13 255 8 10 12 255
                 9 11 14 255 9 11 14 255 9 9 14 255
                 10 8 13 255 9 9 12 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 12 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 9 10 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 9 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 9 9 14 255
                 9 9 13 255 8 9 14 255 8 9 14 255
                 9 9 14 255 9 9 15 255 9 10 14 255
                 9 9 14 255 9 10 14 255 9 9 13 255
                 9 9 14 255 9 10 15 255 9 10 15 255
                 8 9 14 255 8 9 13 255 8 9 14 255
                 9 9 14 255 9 9 14 255 8 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 9 10 14 255 9 9 14 255 9 9 14 255
                 9 10 14 255 9 9 15 255 9 10 15 255
                 10 10 15 255 10 11 15 255 10 11 15 255
                 12 13 17 255 28 23 23 255 50 42 30 255
                 56 43 29 255 82 61 39 255 88 70 43 255
                 75 57 35 255 83 59 36 255 91 67 37 255
                 93 67 37 255 90 65 36 255 98 73 40 255
                 112 90 50 255 124 101 60 255 115 93 56 255
                 113 90 52 255 87 72 41 255 70 54 34 255
                 88 64 38 255 111 84 47 255 122 98 55 255
                 109 93 53 255 64 61 35 255 38 38 25 255
                 45 44 32 255 45 44 33 255 36 35 27 255
                 24 23 20 255 19 18 20 255 20 19 21 255
                 21 21 22 255 32 29 33 255 81 73 61 255
                 70 70 49 255 33 36 29 255 48 43 35 255
                 63 53 36 255 65 50 33 255 68 51 33 255
                 72 53 34 255 72 53 34 255 71 51 33 255
                 75 54 35 255 70 52 32 255 65 46 30 255
                 53 39 27 255 45 33 25 255 43 32 24 255
                 50 37 26 255 46 36 24 255 38 31 23 255
                 28 24 21 255 29 24 22 255 37 29 23 255
                 41 31 24 255 40 30 23 255 36 28 22 255
                 40 30 23 255 39 30 23 255 32 26 21 255
                 26 22 20 255 24 20 20 255 28 23 21 255
                 28 24 19 255 28 23 20 255 28 22 22 255
                 28 24 21 255 33 26 20 255 32 24 21 255
                 38 27 22 255 40 28 22 255 42 29 22 255
                 35 28 22 255 38 29 23 255 36 28 22 255
                 39 30 22 255 37 30 22 255 36 28 23 255
                 36 28 23 255 31 25 22 255 33 25 21 255
                 46 33 22 255 55 38 23 255 53 38 24 255
                 47 34 23 255 38 29 22 255 31 25 20 255
                 36 27 21 255 48 35 25 255 46 34 23 255
                 38 29 22 255 28 23 20 255 29 23 21 255
                 33 26 21 255 38 29 22 255 48 35 25 255
                 49 37 25 255 48 34 24 255 47 34 24 255
                 45 33 23 255 40 31 23 255 32 26 21 255
                 32 25 21 255 38 27 22 255 46 33 24 255
                 57 40 25 255 58 41 26 255 57 40 26 255
                 55 40 27 255 47 35 25 255 42 31 23 255
                 46 34 24 255 61 45 29 255 70 52 32 255
                 67 50 32 255 53 42 27 255 48 38 25 255
                 44 37 25 255 47 37 25 255 52 40 25 255
                 53 41 26 255 66 48 29 255 72 53 32 255
                 74 54 33 255 82 59 35 255 97 69 38 255
                 97 70 37 255 89 63 35 255 83 59 33 255
                 82 59 33 255 79 57 32 255 69 50 29 255
                 63 45 28 255 64 45 28 255 66 47 29 255
                 69 49 30 255 68 49 30 255 65 46 29 255
                 67 47 30 255 68 48 29 255 61 44 28 255
                 45 34 24 255 43 32 23 255 45 32 22 255
                 46 32 22 255 45 32 22 255 44 31 22 255
                 43 30 21 255 41 28 21 255 41 27 20 255
                 41 28 21 255 42 28 21 255 38 25 19 255
                 33 24 18 255 21 18 16 255 24 19 17 255
                 28 21 17 255 27 20 17 255 26 20 17 255
                 24 19 17 255 24 19 16 255 25 19 17 255
                 29 22 18 255 30 22 17 255 30 22 17 255
                 29 22 18 255 29 21 18 255 26 19 17 255
                 27 20 18 255 29 21 18 255 30 23 19 255
                 32 23 19 255 32 23 20 255 40 28 22 255
                 28 24 21 255 21 18 19 255 21 18 18 255
                 32 25 21 255 62 47 34 255 89 73 47 255
                 82 69 45 255 63 50 34 255 55 40 28 255
                 43 33 24 255 21 18 18 255 15 14 16 255
                 15 15 16 255 15 15 16 255 13 13 15 255
                 10 10 14 255 8 8 12 255 8 8 12 255
                 8 9 13 255 9 9 14 255 8 10 13 255
                 9 10 12 255 9 11 13 255 9 11 14 255
                 9 10 15 255 9 8 14 255 9 9 13 255
                 9 9 12 255 9 9 12 255 9 8 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 12 255 8 9 13 255 8 9 13 255
                 9 9 13 255 8 9 13 255 8 9 12 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 9 10 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 9 10 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 9 15 255
                 8 9 14 255 9 9 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 14 255 9 9 14 255 9 9 14 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 15 255 10 10 15 255 10 11 16 255
                 11 12 16 255 13 13 17 255 34 27 24 255
                 55 46 31 255 61 47 30 255 80 58 37 255
                 91 71 44 255 84 64 37 255 90 65 38 255
                 103 75 43 255 106 78 43 255 110 82 43 255
                 123 96 53 255 125 101 59 255 117 96 57 255
                 104 81 48 255 105 79 47 255 97 72 43 255
                 85 65 37 255 102 75 43 255 125 96 55 255
                 129 103 60 255 124 101 59 255 112 95 56 255
                 81 78 44 255 71 68 48 255 45 47 38 255
                 48 47 37 255 67 60 42 255 59 54 37 255
                 40 40 32 255 41 42 31 255 50 47 36 255
                 57 55 42 255 35 37 29 255 53 48 34 255
                 62 51 34 255 67 52 33 255 69 53 34 255
                 74 56 35 255 78 58 36 255 78 58 35 255
                 75 54 34 255 76 55 34 255 75 54 34 255
                 68 49 31 255 59 43 28 255 53 38 27 255
                 46 34 25 255 47 35 26 255 50 38 25 255
                 35 30 23 255 29 25 22 255 30 25 22 255
                 31 25 21 255 34 27 23 255 42 32 24 255
                 39 30 23 255 40 29 23 255 43 32 25 255
                 37 29 22 255 25 23 19 255 23 21 20 255
                 24 21 21 255 27 24 21 255 29 25 19 255
                 32 25 22 255 30 25 22 255 31 25 21 255
                 30 24 19 255 34 27 20 255 35 27 21 255
                 37 27 22 255 34 27 22 255 34 26 22 255
                 36 28 22 255 44 32 24 255 38 29 23 255
                 35 27 23 255 33 26 23 255 29 24 22 255
                 31 24 21 255 42 31 24 255 44 33 23 255
                 44 33 22 255 38 31 20 255 35 27 20 255
                 31 25 20 255 29 23 21 255 42 31 24 255
                 47 34 24 255 41 31 23 255 32 25 21 255
                 32 25 21 255 38 28 22 255 41 31 23 255
                 47 34 25 255 51 37 26 255 49 36 24 255
                 44 32 23 255 46 34 24 255 43 32 23 255
                 35 27 21 255 34 26 21 255 38 28 22 255
                 46 32 24 255 55 38 26 255 57 41 26 255
                 49 37 25 255 41 31 24 255 38 28 22 255
                 46 33 23 255 61 45 28 255 56 43 28 255
                 63 47 30 255 58 45 29 255 47 39 26 255
                 40 33 24 255 41 34 23 255 50 39 26 255
                 55 43 28 255 57 44 28 255 68 50 31 255
                 72 54 34 255 75 55 32 255 84 60 34 255
                 97 71 38 255 89 65 35 255 84 60 34 255
                 82 58 33 255 83 58 32 255 84 59 33 255
                 72 52 30 255 64 46 28 255 64 45 28 255
                 68 48 30 255 67 47 30 255 62 44 28 255
                 59 42 26 255 62 44 27 255 63 45 28 255
                 58 43 28 255 44 32 24 255 44 31 23 255
                 51 35 23 255 46 32 22 255 44 30 22 255
                 43 29 22 255 42 29 21 255 39 26 20 255
                 37 26 19 255 27 21 18 255 38 26 20 255
                 38 26 19 255 34 24 19 255 26 20 16 255
                 32 23 18 255 35 24 19 255 30 22 17 255
                 28 21 17 255 28 21 17 255 27 21 17 255
                 26 20 17 255 29 21 18 255 30 22 18 255
                 29 21 18 255 27 20 18 255 26 19 17 255
                 27 20 18 255 28 21 18 255 30 22 19 255
                 30 23 19 255 32 24 19 255 31 24 21 255
                 37 28 22 255 19 17 18 255 19 16 17 255
                 36 26 22 255 74 58 38 255 90 75 50 255
                 81 68 46 255 61 47 31 255 55 40 26 255
                 53 38 26 255 38 30 22 255 18 17 16 255
                 16 16 16 255 15 16 17 255 14 14 16 255
                 11 12 15 255 9 9 13 255 8 8 13 255
                 8 8 12 255 8 8 13 255 9 9 14 255
                 9 11 14 255 8 10 13 255 8 10 13 255
                 8 10 13 255 8 9 14 255 8 8 14 255
                 8 8 13 255 8 8 12 255 7 8 13 255
                 7 8 13 255 7 8 12 255 8 8 12 255
                 8 8 12 255 8 8 12 255 8 8 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 12 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 14 255 8 9 13 255 8 9 14 255
                 8 9 14 255 8 10 14 255 9 9 15 255
                 8 9 14 255 8 9 14 255 9 10 14 255
                 9 9 14 255 9 10 15 255 9 10 15 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 8 9 14 255 8 9 14 255
                 8 9 14 255 9 8 14 255 9 9 14 255
                 8 9 15 255 8 9 14 255 8 9 13 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 9 15 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 10 14 255 10 10 15 255
                 9 10 15 255 9 10 15 255 10 11 15 255
                 10 11 16 255 11 12 17 255 16 16 18 255
                 48 37 29 255 67 55 35 255 72 54 34 255
                 84 61 38 255 95 71 46 255 97 74 42 255
                 101 75 42 255 111 83 46 255 118 91 51 255
                 122 98 54 255 120 95 55 255 113 89 51 255
                 106 81 48 255 95 69 42 255 89 63 38 255
                 88 62 37 255 92 66 38 255 98 72 42 255
                 122 93 55 255 130 103 59 255 130 105 60 255
                 122 100 59 255 113 96 55 255 47 49 34 255
                 27 30 25 255 36 38 29 255 63 56 47 255
                 64 61 43 255 25 29 25 255 24 25 24 255
                 39 35 30 255 49 44 35 255 44 39 31 255
                 64 52 37 255 70 54 36 255 75 56 35 255
                 75 56 36 255 77 58 36 255 79 59 36 255
                 82 61 37 255 82 61 37 255 83 61 36 255
                 85 62 37 255 79 57 34 255 65 47 31 255
                 56 41 28 255 50 38 27 255 49 37 26 255
                 55 41 27 255 40 32 23 255 27 24 20 255
                 30 25 22 255 30 25 21 255 31 26 22 255
                 40 30 24 255 42 32 24 255 41 32 23 255
                 43 32 25 255 47 35 26 255 32 27 21 255
                 26 23 19 255 26 21 20 255 26 22 21 255
                 27 23 20 255 30 24 20 255 31 25 21 255
                 30 24 21 255 30 23 21 255 29 23 21 255
                 33 25 21 255 38 27 22 255 35 27 22 255
                 34 26 22 255 36 28 23 255 42 32 23 255
                 42 32 23 255 34 27 22 255 31 25 22 255
                 27 23 20 255 29 23 20 255 30 24 21 255
                 31 24 22 255 33 25 21 255 31 26 21 255
                 32 26 21 255 29 24 20 255 32 25 21 255
                 44 31 23 255 49 36 25 255 46 34 24 255
                 47 34 24 255 47 35 24 255 52 38 25 255
                 45 34 24 255 45 33 24 255 47 35 24 255
                 46 34 23 255 44 32 24 255 44 32 24 255
                 46 34 24 255 42 31 22 255 40 29 22 255
                 40 29 22 255 48 34 24 255 53 38 25 255
                 51 39 26 255 43 33 24 255 38 29 22 255
                 46 33 23 255 54 40 26 255 53 40 27 255
                 52 39 26 255 57 43 28 255 47 38 25 255
                 41 35 25 255 41 35 24 255 49 39 25 255
                 56 43 27 255 56 43 27 255 61 45 29 255
                 72 52 33 255 73 54 33 255 72 53 31 255
                 86 62 36 255 95 69 38 255 87 63 34 255
                 80 57 32 255 79 56 31 255 81 57 32 255
                 80 57 33 255 71 52 31 255 64 46 28 255
                 67 47 29 255 66 46 28 255 66 46 29 255
                 63 45 29 255 62 44 27 255 57 41 26 255
                 64 45 28 255 59 44 27 255 44 32 23 255
                 46 31 23 255 51 34 23 255 45 31 22 255
                 43 29 21 255 43 29 22 255 42 28 20 255
                 41 27 20 255 32 23 18 255 20 15 15 255
                 36 24 19 255 39 26 20 255 39 27 20 255
                 33 25 19 255 34 25 20 255 39 27 20 255
                 37 26 19 255 35 25 19 255 31 23 18 255
                 29 22 18 255 27 21 17 255 28 21 18 255
                 30 22 18 255 30 22 18 255 28 22 18 255
                 27 20 17 255 28 20 18 255 30 22 18 255
                 33 24 20 255 36 25 21 255 34 26 21 255
                 22 19 19 255 32 25 22 255 28 22 19 255
                 49 37 26 255 74 59 40 255 92 75 49 255
                 78 65 43 255 63 48 32 255 59 42 27 255
                 53 39 25 255 44 33 23 255 26 22 19 255
                 16 16 17 255 14 15 17 255 14 14 16 255
                 12 13 15 255 10 10 14 255 8 9 13 255
                 8 8 13 255 9 9 13 255 9 9 14 255
                 9 10 13 255 9 10 13 255 9 10 13 255
                 9 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 7 8 12 255 7 8 13 255
                 7 8 12 255 7 8 12 255 7 7 12 255
                 7 7 12 255 7 7 12 255 8 8 12 255
                 8 8 12 255 8 8 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 8 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 8 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
                 9 10 14 255 9 9 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 10 14 255 9 9 14 255
                 9 9 14 255 9 10 14 255 8 9 14 255
                 9 9 14 255 9 9 14 255 9 10 14 255
)"
        R"(                 9 10 14 255 9 9 14 255 9 9 14 255
                 9 10 15 255 9 10 15 255 9 10 15 255
                 9 10 15 255 9 10 15 255 10 10 15 255
                 10 12 15 255 11 12 16 255 13 13 17 255
                 29 24 22 255 65 51 35 255 76 60 37 255
                 70 55 36 255 73 55 37 255 92 69 44 255
                 103 79 47 255 105 81 47 255 107 81 48 255
                 111 85 50 255 115 90 52 255 112 87 52 255
                 99 74 42 255 96 68 38 255 97 69 39 255
                 92 66 38 255 85 60 35 255 82 58 34 255
                 84 61 36 255 103 75 46 255 127 99 58 255
                 131 105 60 255 123 101 58 255 123 100 60 255
                 71 67 40 255 37 38 27 255 34 36 28 255
                 59 53 42 255 48 50 33 255 25 28 22 255
                 43 37 28 255 58 46 33 255 62 48 33 255
                 66 50 33 255 70 53 35 255 72 54 35 255
                 76 55 36 255 76 56 35 255 70 52 34 255
                 73 53 34 255 78 57 35 255 83 61 37 255
                 87 65 39 255 90 68 40 255 86 64 38 255
                 68 50 32 255 50 37 26 255 43 34 25 255
                 45 35 25 255 51 38 27 255 48 38 25 255
                 29 25 20 255 25 22 20 255 26 23 21 255
                 29 25 21 255 35 27 22 255 41 31 24 255
                 43 34 24 255 49 36 25 255 49 36 27 255
                 37 30 24 255 27 23 20 255 28 24 20 255
                 28 23 21 255 27 23 21 255 28 23 21 255
                 30 25 20 255 32 26 21 255 32 25 20 255
                 28 23 19 255 30 23 20 255 34 25 22 255
                 30 25 21 255 35 27 22 255 39 30 22 255
                 42 32 24 255 42 32 24 255 35 27 22 255
                 32 25 21 255 32 24 20 255 31 25 20 255
                 34 27 21 255 35 27 21 255 29 23 20 255
                 27 22 21 255 29 22 22 255 32 25 21 255
                 37 28 22 255 45 32 24 255 49 37 26 255
                 54 40 27 255 58 42 27 255 57 43 28 255
                 54 40 27 255 49 37 25 255 46 35 24 255
                 42 31 23 255 45 33 23 255 48 34 24 255
                 49 35 24 255 47 35 24 255 47 35 24 255
                 46 33 24 255 48 34 24 255 55 39 25 255
                 52 38 25 255 46 34 23 255 41 31 22 255
                 47 35 24 255 53 40 26 255 45 36 24 255
                 39 31 23 255 47 36 25 255 52 40 26 255
                 43 37 25 255 37 32 24 255 42 35 25 255
                 49 39 26 255 56 43 27 255 58 45 28 255
                 64 49 31 255 68 51 31 255 62 46 29 255
                 69 50 31 255 87 63 36 255 88 64 35 255
                 82 59 33 255 77 55 32 255 79 56 31 255
                 81 57 33 255 77 56 32 255 71 51 30 255
                 68 48 29 255 69 48 29 255 66 46 28 255
                 66 46 29 255 65 46 29 255 62 44 27 255
                 59 43 27 255 65 46 29 255 60 46 28 255
                 46 34 24 255 47 33 23 255 48 33 22 255
                 43 29 22 255 39 28 21 255 40 27 21 255
                 40 27 19 255 43 28 20 255 38 27 20 255
                 32 22 18 255 38 26 20 255 38 27 20 255
                 32 25 19 255 18 16 16 255 28 21 19 255
                 39 27 21 255 36 26 21 255 39 27 21 255
                 38 26 20 255 33 24 19 255 29 21 18 255
                 29 22 18 255 31 23 19 255 32 23 18 255
                 30 23 18 255 29 21 18 255 30 21 18 255
                 32 23 19 255 37 26 21 255 44 30 23 255
                 29 25 20 255 22 18 18 255 43 30 24 255
                 64 47 32 255 87 70 46 255 90 75 50 255
                 78 61 40 255 64 47 30 255 61 43 27 255
                 53 39 26 255 44 33 24 255 28 24 20 255
                 17 16 16 255 13 14 16 255 12 13 16 255
                 11 12 15 255 11 12 15 255 11 11 14 255
                 9 10 14 255 9 9 13 255 9 9 13 255
                 9 9 13 255 9 9 13 255 9 9 14 255
                 9 9 13 255 9 9 14 255 9 9 14 255
                 8 8 13 255 8 8 13 255 8 8 12 255
                 7 8 12 255 7 8 12 255 7 7 12 255
                 7 7 12 255 8 8 13 255 7 8 12 255
                 7 8 13 255 8 8 13 255 7 8 13 255
                 7 8 13 255 8 8 12 255 8 8 12 255
                 8 9 13 255 8 9 13 255 8 8 13 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 9 10 13 255 9 9 14 255 9 9 14 255
                 8 9 14 255 8 9 14 255 9 9 14 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 15 255 9 10 14 255 9 10 14 255
                 9 9 14 255 9 10 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 10 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 9 10 15 255 9 10 15 255
                 10 11 15 255 10 11 15 255 10 11 15 255
                 10 12 15 255 11 12 16 255 12 13 17 255
                 20 18 19 255 54 42 31 255 73 58 37 255
                 79 59 36 255 82 63 37 255 79 63 38 255
                 83 64 41 255 82 64 41 255 89 70 44 255
                 95 72 44 255 107 80 46 255 106 80 46 255
                 103 75 43 255 95 68 38 255 99 70 39 255
                 103 75 42 255 101 74 42 255 93 68 38 255
                 85 61 34 255 77 56 33 255 82 60 39 255
                 115 86 52 255 129 102 58 255 120 97 54 255
                 116 93 56 255 108 95 60 255 83 78 47 255
                 70 65 42 255 60 57 40 255 31 35 26 255
                 36 33 26 255 62 50 35 255 65 50 34 255
                 66 50 34 255 70 53 35 255 68 52 35 255
                 68 50 34 255 75 54 36 255 75 56 35 255
                 69 51 33 255 70 51 32 255 73 54 34 255
                 81 61 38 255 85 63 38 255 85 63 37 255
                 80 59 35 255 71 52 32 255 55 42 27 255
                 38 31 23 255 39 32 24 255 46 35 26 255
                 50 38 26 255 37 30 22 255 24 22 19 255
                 24 21 20 255 25 22 20 255 32 25 21 255
                 36 28 23 255 40 31 24 255 47 35 25 255
                 50 36 27 255 45 33 25 255 34 27 22 255
                 28 24 20 255 27 23 20 255 26 23 20 255
                 24 21 21 255 25 21 21 255 27 23 21 255
                 25 21 19 255 25 20 19 255 28 22 20 255
                 33 26 21 255 34 27 21 255 37 28 23 255
                 40 30 23 255 38 30 23 255 41 31 24 255
                 42 33 24 255 42 32 23 255 41 30 22 255
                 35 26 21 255 41 30 23 255 41 31 22 255
                 35 27 20 255 30 23 20 255 29 23 19 255
                 33 25 21 255 43 30 23 255 39 28 23 255
                 44 33 25 255 53 39 27 255 56 43 28 255
                 56 42 28 255 54 40 26 255 53 39 26 255
                 50 37 25 255 47 34 23 255 46 34 24 255
                 54 37 26 255 52 37 25 255 50 36 24 255
                 45 33 23 255 47 34 24 255 54 37 26 255
                 56 40 27 255 48 36 24 255 43 31 22 255
                 51 37 25 255 54 41 26 255 46 37 25 255
                 39 31 22 255 39 31 23 255 41 33 24 255
                 47 36 25 255 41 34 24 255 37 30 23 255
                 44 35 25 255 47 37 26 255 55 42 27 255
                 60 46 29 255 63 48 30 255 58 45 27 255
                 55 41 27 255 72 51 32 255 86 63 36 255
                 78 56 33 255 74 54 32 255 76 54 32 255
                 81 56 32 255 81 57 32 255 75 54 30 255
                 71 49 29 255 73 51 30 255 69 49 29 255
                 66 47 29 255 68 48 30 255 66 46 29 255
                 63 44 28 255 60 43 27 255 64 46 29 255
                 64 47 29 255 51 38 25 255 50 35 24 255
                 47 32 21 255 42 29 21 255 41 27 20 255
                 42 28 20 255 44 29 20 255 47 31 21 255
                 43 30 21 255 40 27 20 255 40 27 20 255
                 30 23 19 255 24 19 16 255 18 14 14 255
                 34 23 19 255 39 26 20 255 24 19 17 255
                 35 24 19 255 41 27 21 255 36 25 20 255
                 34 23 18 255 34 24 19 255 31 23 18 255
                 33 24 18 255 35 24 19 255 34 23 18 255
                 34 23 18 255 36 24 20 255 45 30 23 255
                 45 33 24 255 33 27 20 255 43 30 23 255
                 73 53 35 255 90 73 48 255 86 71 48 255
                 72 56 38 255 67 48 31 255 66 48 29 255
                 52 40 26 255 35 29 22 255 25 21 18 255
                 16 15 16 255 13 13 15 255 10 11 15 255
                 10 10 14 255 10 10 14 255 10 10 14 255
                 10 10 14 255 9 9 13 255 8 8 12 255
                 8 8 13 255 8 9 13 255 8 8 13 255
                 9 9 14 255 9 9 13 255 9 10 14 255
                 8 9 13 255 7 8 12 255 8 8 12 255
                 8 8 12 255 7 7 12 255 7 8 12 255
                 8 8 12 255 8 8 12 255 7 8 13 255
                 8 8 13 255 8 8 14 255 8 8 13 255
                 7 8 13 255 8 8 13 255 8 8 12 255
                 8 8 12 255 8 9 13 255 8 9 13 255
                 8 8 13 255 8 9 13 255 9 9 14 255
                 8 9 14 255 9 9 14 255 8 9 14 255
                 9 9 14 255 8 9 14 255 8 9 14 255
                 9 9 14 255 9 9 13 255 9 9 14 255
                 9 9 14 255 9 10 14 255 9 10 14 255
                 9 9 14 255 9 10 14 255 9 10 14 255
                 9 10 15 255 9 10 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 15 255 10 10 15 255
                 9 10 14 255 9 10 15 255 9 10 14 255
                 9 11 15 255 10 11 15 255 10 11 15 255
                 10 11 15 255 10 11 16 255 10 12 16 255
                 10 11 16 255 11 12 16 255 12 13 17 255
                 19 17 19 255 47 37 26 255 74 58 37 255
                 79 58 36 255 85 60 34 255 91 65 38 255
                 101 75 45 255 101 78 47 255 94 75 44 255
                 100 78 47 255 100 77 46 255 94 68 40 255
                 98 70 40 255 101 72 41 255 103 74 41 255
                 106 77 43 255 106 78 43 255 104 77 43 255
                 95 69 40 255 86 62 36 255 74 54 33 255
                 72 52 34 255 93 68 43 255 125 98 58 255
                 121 97 54 255 113 90 51 255 88 80 54 255
                 57 58 43 255 41 45 35 255 31 35 27 255
                 37 34 26 255 55 45 32 255 65 51 34 255
                 63 48 32 255 59 45 31 255 61 47 33 255
                 63 48 33 255 61 46 31 255 70 51 35 255
                 67 50 32 255 58 44 29 255 60 44 30 255
                 71 52 35 255 78 58 38 255 80 59 37 255
                 79 58 35 255 80 59 34 255 76 56 33 255
                 65 49 29 255 47 38 25 255 35 28 23 255
                 42 32 24 255 46 35 25 255 48 37 25 255
                 28 25 20 255 23 20 20 255 23 21 20 255
                 24 21 19 255 28 23 21 255 33 27 22 255
                 39 30 23 255 46 33 26 255 46 34 27 255
                 39 30 24 255 31 25 21 255 26 23 18 255
                 23 21 18 255 21 19 19 255 22 19 19 255
                 23 20 19 255 20 18 17 255 18 17 17 255
                 24 20 19 255 33 26 22 255 32 25 21 255
                 32 26 21 255 32 27 21 255 30 25 21 255
                 38 29 23 255 43 32 25 255 42 32 24 255
                 44 32 22 255 43 32 22 255 40 29 22 255
                 37 27 23 255 41 31 23 255 40 31 22 255
                 38 30 21 255 40 30 24 255 42 31 24 255
                 36 28 22 255 47 35 25 255 50 37 26 255
                 53 40 28 255 56 42 29 255 56 41 27 255
                 58 42 27 255 53 39 26 255 51 37 25 255
                 50 35 25 255 55 39 26 255 50 35 25 255
                 47 34 24 255 43 32 23 255 45 32 24 255
                 46 34 24 255 49 35 25 255 51 36 23 255
                 59 42 26 255 59 45 28 255 51 41 26 255
                 41 33 24 255 38 30 23 255 38 31 23 255
                 35 29 22 255 46 35 25 255 51 40 26 255
                 43 34 24 255 44 35 24 255 50 38 26 255
                 57 44 28 255 62 48 30 255 57 44 28 255
                 56 42 26 255 58 43 27 255 73 52 32 255
                 75 56 33 255 67 49 29 255 71 50 31 255
                 73 52 31 255 75 53 31 255 79 55 32 255
                 76 55 32 255 70 50 29 255 72 51 30 255
                 73 52 31 255 65 46 28 255 67 47 29 255
                 65 46 29 255 61 43 27 255 58 42 27 255
                 63 45 28 255 65 48 30 255 54 40 26 255
                 52 37 24 255 46 32 22 255 44 30 21 255
                 45 30 21 255 50 34 22 255 53 36 22 255
                 53 36 23 255 52 35 22 255 49 34 22 255
                 46 31 21 255 33 25 18 255 33 23 18 255
                 35 24 18 255 42 29 21 255 38 27 20 255
                 19 17 16 255 26 20 19 255 41 28 21 255
                 40 27 21 255 39 26 20 255 42 28 20 255
                 40 27 19 255 40 27 20 255 44 29 20 255
                 40 27 20 255 36 25 19 255 43 29 22 255
                 54 37 26 255 48 35 24 255 56 40 26 255
                 78 59 38 255 91 74 49 255 80 68 45 255
                 62 49 33 255 65 46 31 255 66 47 30 255
                 57 43 27 255 46 36 24 255 27 23 19 255
                 16 15 16 255 13 13 16 255 11 11 14 255
                 9 9 14 255 9 9 13 255 9 9 13 255
                 9 9 14 255 9 9 13 255 9 9 13 255
                 8 8 12 255 8 8 12 255 8 8 12 255
                 8 8 12 255 9 9 13 255 8 9 13 255
                 9 10 13 255 8 8 13 255 8 8 12 255
                 8 8 12 255 8 8 12 255 8 8 12 255
                 8 8 12 255 9 10 14 255 8 10 14 255
                 8 9 13 255 8 9 13 255 8 8 13 255
                 8 9 14 255 9 10 15 255 8 9 14 255
                 8 8 13 255 8 8 12 255 8 9 13 255
                 8 9 12 255 8 8 12 255 8 9 13 255
                 8 9 14 255 9 9 14 255 8 9 13 255
                 8 9 14 255 8 9 13 255 9 9 14 255
                 9 9 14 255 8 10 13 255 8 9 13 255
                 9 10 14 255 9 9 14 255 9 10 14 255
                 9 10 14 255 9 10 15 255 9 10 15 255
                 9 9 14 255 9 10 14 255 9 10 15 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 10 14 255 9 10 15 255 9 10 15 255
                 9 11 15 255 9 10 15 255 9 11 15 255
                 10 11 15 255 10 11 15 255 10 12 16 255
                 11 12 16 255 10 11 16 255 10 12 16 255
                 10 12 16 255 11 12 17 255 12 13 16 255
                 21 19 18 255 48 37 27 255 73 57 36 255
                 86 63 37 255 88 62 35 255 87 62 34 255
                 95 68 39 255 100 73 43 255 99 72 43 255
                 99 73 44 255 95 71 42 255 90 66 38 255
                 89 64 37 255 96 69 39 255 96 69 39 255
                 98 70 39 255 101 72 41 255 103 74 42 255
                 103 74 43 255 99 73 42 255 84 63 36 255
                 69 50 32 255 67 49 32 255 80 57 36 255
                 112 84 53 255 126 101 56 255 123 98 53 255
                 68 58 38 255 42 41 28 255 23 26 22 255
                 37 34 27 255 56 44 31 255 67 52 34 255
                 65 49 33 255 62 47 32 255 58 44 30 255
                 55 43 29 255 56 43 30 255 59 44 30 255
                 62 46 31 255 60 45 30 255 56 42 28 255
                 57 42 28 255 65 48 33 255 70 53 35 255
                 74 55 35 255 75 55 34 255 81 59 35 255
                 85 63 36 255 74 55 32 255 60 45 29 255
                 46 34 25 255 45 34 24 255 45 34 24 255
                 49 37 26 255 42 34 23 255 24 21 20 255
                 22 21 20 255 25 21 20 255 28 24 22 255
                 31 27 22 255 34 27 22 255 41 30 25 255
                 44 33 26 255 39 31 25 255 36 29 23 255
                 28 25 19 255 21 20 16 255 19 18 16 255
                 19 18 17 255 21 20 17 255 20 19 17 255
                 17 16 16 255 20 17 18 255 29 23 20 255
                 27 22 19 255 24 22 19 255 24 21 19 255
                 24 19 18 255 34 25 21 255 41 29 23 255
                 44 31 23 255 51 36 24 255 48 37 24 255
                 38 30 22 255 35 26 22 255 38 28 23 255
                 44 32 24 255 51 37 25 255 50 36 26 255
                 45 32 24 255 45 32 24 255 53 38 27 255
                 56 39 26 255 56 41 28 255 56 42 27 255
                 55 41 27 255 59 42 27 255 55 39 25 255
                 54 39 25 255 48 35 24 255 48 35 24 255
                 43 31 23 255 43 32 24 255 43 32 23 255
                 43 32 23 255 45 33 23 255 50 36 24 255
                 63 44 27 255 65 48 29 255 56 44 27 255
)"
        R"(                 43 35 24 255 39 32 23 255 39 32 23 255
                 38 32 23 255 36 29 22 255 49 37 26 255
                 58 43 28 255 50 40 25 255 42 34 23 255
                 50 38 26 255 60 46 29 255 51 40 26 255
                 46 35 24 255 52 39 25 255 58 43 27 255
                 73 53 33 255 66 50 31 255 61 45 27 255
                 64 46 29 255 70 50 30 255 71 51 31 255
                 71 52 31 255 70 50 30 255 67 48 29 255
                 67 49 29 255 65 47 30 255 68 48 29 255
                 70 49 30 255 67 48 29 255 61 43 28 255
                 62 43 28 255 67 47 29 255 68 48 30 255
                 57 41 27 255 55 38 24 255 50 35 23 255
                 45 31 21 255 48 32 22 255 57 38 24 255
                 57 39 23 255 54 36 23 255 51 34 22 255
                 46 30 21 255 44 29 21 255 41 27 20 255
                 45 30 21 255 48 33 22 255 47 32 22 255
                 42 30 21 255 29 22 17 255 20 17 16 255
                 31 22 19 255 42 29 21 255 41 27 20 255
                 43 27 20 255 48 30 21 255 46 30 20 255
                 44 30 20 255 34 26 19 255 26 22 19 255
                 41 29 23 255 61 42 27 255 70 49 29 255
                 87 68 42 255 93 76 49 255 77 64 43 255
                 63 49 32 255 68 50 30 255 69 50 31 255
                 58 43 28 255 49 37 26 255 34 28 22 255
                 18 17 17 255 14 13 15 255 12 13 15 255
                 10 11 14 255 9 9 13 255 9 9 13 255
                 9 9 13 255 9 9 13 255 9 9 13 255
                 8 9 13 255 8 8 12 255 8 8 12 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 8 9 13 255 8 8 12 255
                 8 8 12 255 8 8 12 255 8 8 12 255
                 8 8 12 255 8 9 13 255 9 10 14 255
                 10 11 14 255 9 10 14 255 9 10 14 255
                 11 10 15 255 11 12 16 255 11 12 16 255
                 9 11 15 255 9 10 14 255 9 9 13 255
                 8 9 13 255 8 9 13 255 8 8 12 255
                 8 9 13 255 8 9 13 255 8 9 14 255
                 8 9 14 255 8 9 14 255 8 9 13 255
                 9 10 14 255 9 10 14 255 9 10 13 255
                 9 10 14 255 9 10 15 255 9 10 14 255
                 9 11 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 9 10 14 255 9 10 15 255
                 9 11 15 255 9 10 14 255 9 11 15 255
                 9 10 14 255 9 10 15 255 10 11 15 255
                 10 11 15 255 10 11 15 255 10 11 15 255
                 10 11 15 255 10 11 14 255 10 11 15 255
                 10 11 16 255 10 11 16 255 11 12 16 255
                 11 12 17 255 13 14 17 255 16 16 17 255
                 24 20 18 255 49 36 25 255 67 51 33 255
                 75 55 35 255 91 66 37 255 90 65 36 255
                 88 64 36 255 88 63 37 255 93 66 39 255
                 89 65 39 255 89 63 38 255 86 63 37 255
                 83 60 36 255 82 59 36 255 85 60 36 255
                 91 65 38 255 94 68 38 255 99 71 40 255
                 103 73 41 255 98 71 40 255 91 66 39 255
                 82 58 35 255 79 56 34 255 82 60 36 255
                 87 64 37 255 91 68 41 255 120 91 54 255
                 129 103 57 255 58 45 32 255 49 42 29 255
                 35 31 24 255 47 39 30 255 58 45 30 255
                 59 46 31 255 65 48 32 255 63 47 31 255
                 58 43 29 255 54 41 28 255 55 42 28 255
                 57 43 29 255 54 41 28 255 55 42 28 255
                 61 44 30 255 61 45 30 255 55 43 30 255
                 51 39 30 255 61 46 32 255 72 51 33 255
                 79 57 34 255 83 60 36 255 74 54 33 255
                 69 49 31 255 61 45 29 255 56 42 26 255
                 46 36 25 255 43 33 25 255 51 39 26 255
                 35 29 21 255 24 22 20 255 27 23 21 255
                 29 25 22 255 30 26 22 255 32 25 22 255
                 36 28 24 255 40 31 25 255 45 35 25 255
                 44 34 24 255 33 28 19 255 24 22 17 255
                 20 20 16 255 20 19 17 255 21 19 18 255
                 21 18 18 255 18 16 17 255 20 18 18 255
                 26 22 19 255 25 22 20 255 25 22 19 255
                 27 21 19 255 31 23 19 255 34 25 20 255
                 41 29 22 255 42 30 22 255 46 32 24 255
                 42 33 24 255 31 26 21 255 33 25 21 255
                 42 29 22 255 47 33 25 255 55 38 27 255
                 55 38 27 255 50 36 25 255 55 39 27 255
                 60 42 28 255 64 44 28 255 60 44 28 255
                 56 41 26 255 54 40 26 255 57 41 26 255
                 55 39 26 255 50 37 25 255 42 31 23 255
                 39 29 22 255 37 28 22 255 40 29 23 255
                 47 34 24 255 46 34 23 255 52 37 24 255
                 69 48 29 255 69 51 30 255 57 45 28 255
                 51 41 27 255 43 35 24 255 39 32 24 255
                 38 32 23 255 37 30 22 255 37 30 22 255
                 51 38 27 255 60 45 29 255 49 39 25 255
                 48 36 24 255 56 44 28 255 48 39 26 255
                 42 33 23 255 46 34 25 255 53 39 26 255
                 60 44 28 255 73 54 34 255 63 48 30 255
                 56 41 27 255 54 40 27 255 58 43 28 255
                 63 45 29 255 67 48 29 255 68 48 28 255
                 65 47 28 255 60 44 28 255 62 44 27 255
                 72 50 31 255 76 54 31 255 71 51 30 255
                 62 45 28 255 65 45 29 255 75 53 30 255
                 74 53 31 255 59 42 26 255 54 38 24 255
                 51 35 23 255 47 32 22 255 50 33 22 255
                 59 38 24 255 58 39 24 255 53 35 23 255
                 52 34 22 255 46 31 21 255 48 31 20 255
                 49 32 21 255 51 33 22 255 57 37 23 255
                 54 38 23 255 48 33 22 255 41 29 20 255
                 22 19 16 255 29 20 18 255 43 29 21 255
                 47 31 20 255 48 31 20 255 48 30 20 255
                 46 30 20 255 43 30 21 255 26 22 19 255
                 18 17 17 255 38 27 22 255 73 51 32 255
                 88 68 43 255 93 77 49 255 80 65 42 255
                 54 43 29 255 63 46 30 255 70 52 33 255
                 63 47 30 255 53 39 26 255 38 31 23 255
                 19 17 17 255 14 13 16 255 13 13 15 255
                 12 12 15 255 10 10 14 255 9 10 13 255
                 9 10 14 255 9 10 14 255 9 9 14 255
                 9 9 13 255 8 9 13 255 8 9 13 255
                 9 9 13 255 9 9 14 255 9 9 13 255
                 9 9 13 255 9 9 13 255 8 9 13 255
                 8 9 13 255 8 9 12 255 8 9 12 255
                 8 9 13 255 8 9 14 255 9 10 14 255
                 10 11 15 255 13 13 16 255 15 16 17 255
                 20 18 17 255 31 26 20 255 34 30 22 255
                 23 23 20 255 12 13 16 255 10 10 15 255
                 10 10 13 255 10 9 13 255 9 9 13 255
                 9 9 13 255 8 9 13 255 8 9 13 255
                 9 9 14 255 8 8 13 255 8 8 13 255
                 8 9 14 255 8 9 14 255 9 10 14 255
                 9 10 14 255 9 9 14 255 9 9 15 255
                 9 9 14 255 9 10 15 255 9 10 14 255
                 9 10 14 255 9 9 14 255 9 10 14 255
                 9 10 15 255 9 10 15 255 9 10 14 255
                 9 10 15 255 9 11 15 255 10 11 15 255
                 10 11 15 255 10 11 16 255 10 11 15 255
                 11 11 15 255 11 12 15 255 11 12 15 255
                 11 12 15 255 12 12 16 255 13 14 16 255
                 17 17 18 255 24 22 19 255 35 29 22 255
                 36 29 22 255 47 34 23 255 65 46 29 255
                 71 52 33 255 74 54 33 255 84 60 37 255
                 88 63 37 255 81 58 34 255 78 55 33 255
                 85 59 35 255 76 56 36 255 73 52 34 255
                 77 56 35 255 80 57 35 255 89 64 37 255
                 93 66 37 255 98 70 39 255 100 73 40 255
                 101 73 41 255 98 69 40 255 86 62 36 255
                 80 55 33 255 85 59 35 255 101 73 41 255
                 98 75 43 255 87 66 38 255 80 63 36 255
                 108 79 47 255 130 102 57 255 54 40 28 255
                 51 40 28 255 45 37 27 255 49 39 29 255
                 59 44 31 255 60 46 31 255 63 46 31 255
                 60 44 30 255 59 43 28 255 53 40 27 255
                 52 40 28 255 53 41 29 255 55 41 29 255
                 54 42 29 255 56 42 29 255 51 40 28 255
                 41 33 25 255 36 30 24 255 43 33 27 255
                 67 49 32 255 78 56 33 255 82 58 35 255
                 76 55 33 255 73 53 33 255 68 49 31 255
                 65 47 29 255 50 39 25 255 41 32 24 255
                 50 37 27 255 54 40 26 255 34 27 21 255
                 30 24 21 255 28 24 21 255 31 27 22 255
                 33 26 22 255 33 26 23 255 36 29 24 255
                 41 33 25 255 46 36 25 255 46 36 22 255
                 39 31 20 255 28 24 18 255 21 19 18 255
                 23 19 19 255 22 18 18 255 20 18 17 255
                 20 19 18 255 22 20 20 255 22 20 19 255
                 32 24 20 255 42 30 22 255 49 35 24 255
                 50 35 24 255 50 36 24 255 49 33 22 255
                 54 37 24 255 47 35 24 255 31 26 21 255
                 33 26 21 255 39 28 22 255 47 33 24 255
                 54 37 27 255 55 39 27 255 51 37 25 255
                 54 38 26 255 60 43 29 255 64 46 29 255
                 61 44 28 255 55 40 27 255 53 39 26 255
                 58 41 27 255 59 42 27 255 50 37 24 255
                 42 31 23 255 40 30 23 255 43 32 24 255
                 47 34 23 255 51 36 25 255 57 40 25 255
                 74 52 30 255 76 55 32 255 69 51 31 255
                 55 44 27 255 49 40 27 255 43 35 25 255
                 39 32 23 255 38 31 23 255 36 30 23 255
                 40 32 23 255 53 40 27 255 58 44 28 255
                 49 38 25 255 58 44 29 255 50 40 26 255
                 42 34 23 255 43 34 24 255 51 38 26 255
                 57 42 28 255 69 49 31 255 71 52 32 255
                 61 45 29 255 57 43 27 255 51 38 26 255
                 53 39 27 255 62 44 29 255 69 50 31 255
                 70 50 30 255 66 47 29 255 65 46 29 255
                 68 48 30 255 70 49 31 255 82 58 34 255
                 82 59 33 255 76 55 31 255 78 54 31 255
                 86 60 33 255 77 56 32 255 60 43 27 255
                 55 38 24 255 55 37 24 255 49 33 22 255
                 50 33 21 255 59 39 23 255 62 41 24 255
                 60 40 23 255 57 37 23 255 57 37 22 255
                 58 38 23 255 63 40 23 255 64 42 24 255
                 59 40 23 255 54 37 23 255 51 35 23 255
                 47 34 22 255 28 23 18 255 35 25 20 255
                 41 27 21 255 50 32 21 255 54 35 22 255
                 52 34 21 255 52 34 22 255 36 29 21 255
                 15 15 17 255 20 15 17 255 59 41 29 255
                 85 67 44 255 81 69 46 255 58 52 37 255
                 61 47 32 255 66 49 30 255 71 51 33 255
                 67 51 32 255 58 43 28 255 46 35 25 255
                 22 20 18 255 13 13 16 255 13 12 15 255
                 13 13 16 255 11 12 15 255 10 10 14 255
                 10 10 13 255 10 10 14 255 10 10 14 255
                 9 10 14 255 9 9 13 255 8 9 13 255
                 9 9 13 255 9 10 13 255 9 10 13 255
                 9 10 13 255 8 9 13 255 9 9 13 255
                 9 10 13 255 8 9 13 255 9 10 13 255
                 8 9 13 255 8 9 13 255 9 10 14 255
                 10 11 14 255 14 14 16 255 21 21 19 255
                 31 28 21 255 42 35 24 255 70 56 36 255
                 86 70 42 255 73 63 38 255 33 34 23 255
                 11 12 15 255 10 9 14 255 10 9 14 255
                 10 10 14 255 10 9 13 255 9 9 14 255
                 9 9 13 255 8 9 13 255 8 9 13 255
                 8 8 13 255 8 9 13 255 9 9 14 255
                 9 10 14 255 9 9 14 255 10 10 14 255
                 9 10 14 255 9 9 14 255 9 9 14 255
                 9 10 14 255 9 10 14 255 9 10 14 255
                 9 10 14 255 9 10 14 255 9 10 14 255
                 9 10 15 255 9 10 15 255 10 11 15 255
                 10 11 15 255 11 11 15 255 13 13 16 255
                 19 18 17 255 19 19 18 255 20 20 18 255
                 24 24 20 255 34 30 21 255 28 25 20 255
                 23 22 19 255 26 23 21 255 47 36 25 255
                 63 48 30 255 59 44 28 255 65 46 29 255
                 70 51 32 255 77 56 35 255 74 54 34 255
                 77 54 33 255 85 61 35 255 84 60 34 255
                 85 62 35 255 89 63 36 255 84 61 36 255
                 82 59 34 255 87 63 37 255 91 65 37 255
                 97 69 40 255 100 73 42 255 100 73 42 255
                 92 66 39 255 89 61 36 255 86 60 34 255
                 86 60 35 255 87 63 35 255 94 66 38 255
                 108 79 46 255 101 77 45 255 86 65 39 255
                 83 62 37 255 97 71 42 255 123 94 55 255
                 56 41 28 255 54 41 29 255 49 38 28 255
                 48 37 28 255 58 43 31 255 55 41 29 255
                 58 42 29 255 63 45 30 255 62 45 29 255
                 54 40 27 255 52 40 27 255 53 41 27 255
                 51 39 28 255 51 39 29 255 53 41 28 255
                 47 37 26 255 37 31 24 255 33 28 23 255
                 35 28 24 255 53 39 30 255 71 51 34 255
                 78 56 35 255 77 55 33 255 73 53 32 255
                 69 50 31 255 65 47 30 255 52 40 26 255
                 41 32 25 255 44 34 26 255 54 39 28 255
                 55 41 27 255 49 36 24 255 39 29 22 255
                 31 26 22 255 32 26 23 255 35 28 23 255
                 35 29 22 255 33 28 22 255 38 31 22 255
                 40 33 22 255 38 31 21 255 32 27 21 255
                 23 21 19 255 23 19 19 255 25 20 19 255
                 21 19 18 255 20 19 19 255 21 19 19 255
                 24 19 19 255 34 25 20 255 43 31 24 255
                 45 33 25 255 49 35 25 255 56 39 26 255
                 58 40 26 255 60 41 26 255 49 36 25 255
                 35 28 22 255 34 26 21 255 41 29 23 255
                 50 35 25 255 53 38 28 255 52 38 27 255
                 52 38 26 255 54 38 26 255 53 38 26 255
                 55 40 27 255 56 40 26 255 56 40 26 255
                 59 42 27 255 63 45 28 255 58 42 27 255
                 51 37 25 255 45 33 24 255 47 35 24 255
                 51 36 25 255 56 40 26 255 64 45 28 255
                 76 53 31 255 79 56 32 255 76 55 32 255
                 65 49 30 255 51 41 27 255 44 36 25 255
                 41 34 24 255 42 34 24 255 39 33 23 255
                 40 33 24 255 44 35 25 255 54 42 28 255
                 58 44 29 255 54 43 28 255 47 37 26 255
                 43 34 24 255 39 33 23 255 45 35 25 255
                 56 41 27 255 61 45 29 255 74 54 33 255
                 69 51 30 255 59 45 29 255 54 41 27 255
                 53 40 26 255 57 42 27 255 64 45 29 255
                 66 48 30 255 66 47 30 255 66 47 29 255
                 64 45 29 255 69 48 30 255 73 51 31 255
                 79 56 33 255 81 57 32 255 84 59 33 255
                 91 64 36 255 95 67 37 255 82 60 33 255
                 65 46 29 255 59 41 26 255 56 37 24 255
                 53 35 23 255 56 37 23 255 60 40 24 255
                 59 39 24 255 59 38 23 255 59 39 23 255
                 57 39 23 255 41 31 21 255 60 40 24 255
                 70 48 27 255 68 48 27 255 60 42 25 255
                 54 37 23 255 46 32 22 255 36 26 19 255
                 41 28 21 255 47 31 22 255 51 34 21 255
                 36 28 20 255 39 27 20 255 53 35 24 255
                 25 22 19 255 11 10 15 255 24 18 20 255
                 70 53 39 255 78 67 44 255 49 46 32 255
                 24 22 21 255 50 36 27 255 74 53 33 255
                 77 57 35 255 68 51 31 255 56 42 28 255
                 29 25 20 255 15 14 16 255 13 13 16 255
                 12 12 16 255 12 12 16 255 12 12 15 255
                 11 11 14 255 10 11 14 255 9 10 13 255
                 10 10 14 255 9 10 14 255 9 9 13 255
                 8 9 13 255 8 9 13 255 9 9 13 255
                 9 10 14 255 9 10 13 255 8 9 13 255
                 8 9 13 255 8 9 14 255 8 9 13 255
                 9 9 13 255 9 10 14 255 9 10 14 255
                 10 11 15 255 16 16 17 255 35 28 23 255
                 45 38 26 255 28 27 21 255 32 28 23 255
                 64 50 36 255 94 75 47 255 93 76 48 255
                 66 60 38 255 20 23 19 255 9 10 14 255
                 9 9 14 255 9 9 13 255 9 9 13 255
                 9 10 14 255 9 10 14 255 10 10 14 255
                 9 10 13 255 9 9 14 255 9 9 14 255
                 10 10 15 255 10 11 14 255 9 10 14 255
                 9 10 14 255 9 9 14 255 9 9 14 255
)"
        R"(                 8 9 14 255 9 9 14 255 9 10 14 255
                 9 9 14 255 9 9 14 255 9 10 15 255
                 9 11 15 255 10 11 15 255 10 11 15 255
                 11 12 16 255 14 14 16 255 25 20 18 255
                 37 31 22 255 37 33 22 255 31 30 22 255
                 22 23 20 255 26 26 21 255 42 35 25 255
                 61 47 30 255 54 43 27 255 48 37 24 255
                 61 45 28 255 73 53 32 255 79 57 34 255
                 77 57 35 255 75 55 34 255 83 60 36 255
                 83 60 34 255 89 63 36 255 88 64 37 255
                 81 59 35 255 84 60 35 255 90 64 37 255
                 99 71 40 255 96 70 39 255 96 69 40 255
                 98 72 42 255 98 72 42 255 92 68 39 255
                 86 62 38 255 86 61 36 255 82 57 33 255
                 78 54 32 255 82 57 34 255 80 57 35 255
                 85 60 36 255 99 72 42 255 97 73 43 255
                 81 60 37 255 72 54 35 255 78 57 36 255
                 94 69 44 255 67 49 32 255 65 47 31 255
                 51 39 27 255 46 36 27 255 56 42 30 255
                 52 40 28 255 52 39 28 255 58 43 30 255
                 62 46 30 255 59 43 29 255 57 42 29 255
                 51 39 28 255 43 34 26 255 42 33 26 255
                 51 39 28 255 51 39 27 255 40 33 24 255
                 33 27 23 255 35 28 23 255 40 30 24 255
                 56 40 30 255 68 49 33 255 68 50 32 255
                 65 48 31 255 59 44 29 255 53 40 27 255
                 45 34 25 255 40 31 24 255 47 36 26 255
                 49 37 27 255 60 45 31 255 64 47 29 255
                 55 39 26 255 40 31 23 255 33 26 22 255
                 39 30 24 255 33 28 21 255 29 25 19 255
                 29 25 20 255 32 27 20 255 29 26 19 255
                 26 23 19 255 22 20 19 255 22 18 17 255
                 25 20 18 255 25 22 19 255 23 20 20 255
                 23 19 18 255 30 22 19 255 30 22 19 255
                 29 23 20 255 35 26 22 255 44 31 24 255
                 46 33 24 255 45 32 24 255 43 32 24 255
                 35 28 23 255 36 28 23 255 39 29 22 255
                 41 30 23 255 48 34 25 255 49 36 26 255
                 50 38 26 255 51 38 27 255 51 37 26 255
                 50 36 26 255 52 37 26 255 52 38 26 255
                 54 40 27 255 61 44 28 255 65 46 29 255
                 59 43 27 255 51 38 25 255 46 34 25 255
                 46 34 25 255 59 41 27 255 72 50 30 255
                 79 57 33 255 80 56 32 255 81 58 32 255
                 75 55 32 255 60 46 29 255 49 39 26 255
                 48 38 26 255 47 37 25 255 42 34 23 255
                 38 32 23 255 41 32 24 255 44 34 25 255
                 55 42 30 255 56 43 30 255 45 36 26 255
                 39 31 23 255 38 31 23 255 38 31 23 255
                 48 37 26 255 58 44 29 255 70 52 32 255
                 76 56 34 255 68 51 30 255 61 46 29 255
                 53 40 26 255 54 40 27 255 61 45 29 255
                 66 48 30 255 68 49 30 255 66 48 29 255
                 66 47 29 255 70 50 30 255 77 53 32 255
                 81 57 33 255 83 60 33 255 85 60 35 255
                 93 65 36 255 98 70 38 255 98 70 38 255
                 87 63 35 255 68 48 30 255 61 42 25 255
                 57 38 23 255 57 36 23 255 66 43 26 255
                 61 40 24 255 60 40 24 255 59 40 23 255
                 49 35 22 255 37 30 21 255 21 19 18 255
                 30 25 22 255 53 39 28 255 64 48 30 255
                 57 42 26 255 55 38 24 255 52 37 24 255
                 49 34 23 255 49 33 22 255 54 35 23 255
                 39 29 19 255 16 15 15 255 23 18 17 255
                 40 30 23 255 16 15 16 255 11 10 14 255
                 31 25 24 255 68 55 39 255 50 45 31 255
                 22 23 20 255 34 26 21 255 63 45 30 255
                 82 59 36 255 80 61 37 255 70 53 33 255
                 47 38 25 255 19 18 17 255 14 13 16 255
                 12 12 15 255 11 11 15 255 12 12 16 255
                 13 13 16 255 13 13 15 255 11 12 15 255
                 10 11 14 255 9 10 14 255 9 10 13 255
                 9 10 13 255 8 9 13 255 8 9 13 255
                 9 9 13 255 9 9 13 255 9 10 14 255
                 9 10 14 255 8 9 13 255 8 9 13 255
                 8 9 14 255 9 10 14 255 10 11 15 255
                 12 12 16 255 18 16 17 255 36 29 23 255
                 60 47 32 255 59 49 31 255 23 24 19 255
                 22 21 19 255 53 43 32 255 90 71 46 255
                 98 78 49 255 90 76 47 255 42 42 26 255
                 12 13 15 255 10 10 14 255 9 10 14 255
                 9 9 13 255 9 10 14 255 10 10 14 255
                 10 11 15 255 10 10 14 255 10 10 14 255
                 10 10 14 255 11 11 15 255 10 11 15 255
                 10 11 15 255 9 10 14 255 9 9 14 255
                 9 8 14 255 9 9 14 255 9 9 14 255
                 9 9 14 255 9 9 14 255 9 10 15 255
                 10 11 15 255 10 11 16 255 11 12 16 255
                 13 13 17 255 22 20 19 255 41 32 23 255
                 59 45 29 255 42 37 25 255 23 22 19 255
                 30 27 21 255 19 19 18 255 19 18 19 255
                 40 30 23 255 75 53 33 255 78 57 33 255
                 79 56 34 255 78 57 34 255 80 58 36 255
                 80 58 37 255 71 54 34 255 66 49 31 255
                 74 55 35 255 87 62 37 255 90 65 39 255
                 82 60 37 255 89 65 37 255 89 65 36 255
                 91 65 36 255 102 73 41 255 95 70 39 255
                 90 64 38 255 95 68 39 255 99 71 41 255
                 92 68 39 255 81 59 35 255 85 60 35 255
                 82 57 33 255 83 57 33 255 78 54 32 255
                 77 53 32 255 81 57 34 255 96 69 40 255
                 97 72 41 255 78 59 35 255 64 47 31 255
                 65 47 30 255 66 50 33 255 76 56 36 255
                 71 52 33 255 62 46 30 255 55 42 29 255
                 60 45 30 255 54 41 28 255 50 38 28 255
                 51 38 27 255 51 38 28 255 61 45 31 255
                 59 44 30 255 48 37 27 255 40 32 24 255
                 39 31 24 255 45 35 26 255 46 36 27 255
                 40 32 24 255 35 28 22 255 32 26 23 255
                 35 28 23 255 48 36 27 255 56 42 30 255
                 51 38 28 255 53 39 28 255 53 39 27 255
                 48 36 26 255 45 35 25 255 48 37 27 255
                 53 41 28 255 50 39 26 255 56 40 29 255
                 67 49 33 255 59 43 27 255 46 36 24 255
                 42 32 24 255 38 30 24 255 34 28 22 255
                 31 26 21 255 27 24 19 255 33 27 21 255
                 30 27 21 255 28 24 21 255 24 21 19 255
                 20 18 17 255 21 19 17 255 26 22 19 255
                 30 24 21 255 32 24 19 255 45 31 22 255
                 38 28 21 255 26 21 19 255 37 27 23 255
                 38 29 23 255 34 26 21 255 34 25 21 255
                 34 26 21 255 29 24 21 255 34 28 22 255
                 35 27 22 255 38 27 22 255 47 34 25 255
                 49 37 26 255 50 38 26 255 49 36 26 255
                 48 35 25 255 52 38 26 255 55 40 26 255
                 53 40 27 255 53 39 27 255 61 43 28 255
                 63 45 28 255 63 45 28 255 56 41 26 255
                 47 34 25 255 44 33 24 255 67 47 30 255
                 80 58 33 255 80 58 33 255 77 55 33 255
                 76 55 32 255 67 51 31 255 59 45 29 255
                 57 44 28 255 55 42 27 255 51 40 26 255
                 46 37 25 255 45 36 25 255 47 36 26 255
                 52 40 27 255 55 43 30 255 50 41 28 255
                 39 32 24 255 47 35 25 255 49 37 25 255
                 50 38 26 255 54 41 27 255 63 46 30 255
                 78 58 35 255 79 59 34 255 74 56 33 255
                 65 49 30 255 59 44 27 255 59 44 28 255
                 61 46 30 255 66 48 30 255 69 50 31 255
                 67 49 30 255 67 48 30 255 73 51 31 255
                 81 55 32 255 84 59 34 255 90 63 36 255
                 97 70 39 255 94 67 37 255 93 66 36 255
                 94 66 37 255 86 62 34 255 69 49 30 255
                 62 43 26 255 57 39 24 255 61 39 25 255
                 69 46 28 255 68 47 27 255 69 47 27 255
                 61 45 26 255 30 27 19 255 15 14 16 255
                 18 18 18 255 15 16 17 255 30 25 21 255
                 30 26 22 255 55 39 27 255 62 45 27 255
                 56 40 25 255 52 36 24 255 51 34 23 255
                 57 37 23 255 28 23 17 255 11 10 13 255
                 16 14 16 255 23 21 19 255 15 14 16 255
                 29 23 21 255 59 48 34 255 54 48 33 255
                 25 26 21 255 33 25 20 255 69 48 30 255
                 86 62 36 255 89 66 39 255 79 60 37 255
                 70 53 33 255 34 31 22 255 15 15 16 255
                 12 12 15 255 11 11 15 255 11 11 15 255
                 12 12 15 255 11 12 15 255 11 12 15 255
                 10 11 14 255 10 11 14 255 10 10 14 255
                 10 10 13 255 9 10 14 255 8 10 13 255
                 8 9 13 255 8 9 13 255 8 8 13 255
                 8 9 13 255 9 9 13 255 8 9 13 255
                 9 10 14 255 9 10 15 255 10 10 15 255
                 12 12 16 255 25 19 20 255 48 35 27 255
                 41 36 25 255 50 37 27 255 66 52 32 255
                 28 28 21 255 28 25 22 255 39 32 26 255
                 87 66 44 255 102 80 49 255 100 81 49 255
                 63 58 35 255 18 20 17 255 10 10 14 255
                 9 10 14 255 11 11 15 255 10 11 15 255
                 10 10 14 255 9 10 14 255 10 10 14 255
                 10 10 14 255 10 11 15 255 10 11 15 255
                 10 11 15 255 10 11 15 255 10 11 15 255
                 10 11 15 255 9 10 14 255 9 10 15 255
                 10 10 15 255 10 11 15 255 10 11 15 255
                 11 12 16 255 11 12 16 255 12 13 16 255
                 14 15 17 255 28 24 20 255 55 43 29 255
                 70 53 33 255 67 51 32 255 39 35 23 255
                 25 21 17 255 50 34 23 255 50 38 23 255
                 42 30 21 255 69 47 28 255 82 57 33 255
                 88 62 35 255 90 64 36 255 86 64 37 255
                 73 56 34 255 76 55 36 255 68 52 32 255
                 64 50 31 255 61 46 30 255 77 53 33 255
                 84 59 35 255 82 59 35 255 96 69 40 255
                 99 72 41 255 98 71 38 255 100 71 40 255
                 87 64 37 255 84 59 35 255 96 67 38 255
                 103 74 42 255 98 73 41 255 84 61 36 255
                 82 57 33 255 87 59 34 255 89 63 36 255
                 84 60 34 255 88 61 35 255 87 62 35 255
                 88 62 38 255 92 66 41 255 83 62 36 255
                 75 55 33 255 76 55 32 255 77 57 33 255
                 79 58 36 255 75 55 35 255 74 54 35 255
                 70 53 33 255 67 50 33 255 56 44 29 255
                 46 36 27 255 47 36 26 255 44 33 25 255
                 51 38 28 255 53 41 29 255 44 34 26 255
                 41 33 25 255 41 33 25 255 43 34 26 255
                 45 35 27 255 41 32 25 255 39 31 23 255
                 33 27 23 255 36 29 23 255 41 32 25 255
                 42 33 26 255 43 33 25 255 53 40 28 255
                 58 43 29 255 57 42 28 255 59 44 28 255
                 57 43 30 255 55 42 30 255 56 43 29 255
                 54 40 28 255 64 47 32 255 66 48 30 255
                 55 42 26 255 51 37 25 255 47 35 25 255
                 36 29 22 255 33 28 21 255 35 28 21 255
                 31 27 20 255 29 25 20 255 25 22 21 255
                 22 19 19 255 20 18 17 255 22 19 17 255
                 33 25 21 255 45 33 23 255 45 31 21 255
                 54 37 23 255 42 31 22 255 27 22 19 255
                 29 23 20 255 34 26 21 255 35 26 21 255
                 33 24 20 255 33 25 21 255 31 25 21 255
                 32 26 21 255 34 26 21 255 41 30 22 255
                 48 35 24 255 48 36 25 255 50 38 25 255
                 50 37 25 255 50 36 25 255 52 38 26 255
                 45 34 25 255 42 32 25 255 52 38 27 255
                 60 42 28 255 68 48 30 255 71 50 31 255
                 67 48 29 255 61 43 27 255 66 46 29 255
                 79 56 33 255 76 54 31 255 70 50 30 255
                 69 50 31 255 68 51 31 255 63 47 29 255
                 63 47 30 255 63 49 30 255 62 47 29 255
                 58 44 28 255 55 43 27 255 54 42 27 255
                 58 44 28 255 63 48 31 255 59 46 30 255
                 50 40 26 255 46 36 25 255 52 40 27 255
                 57 44 28 255 60 47 29 255 60 46 28 255
                 73 52 32 255 86 64 37 255 82 63 37 255
                 74 57 35 255 69 52 33 255 65 48 30 255
                 62 45 29 255 59 45 29 255 68 50 31 255
                 73 54 32 255 67 48 30 255 71 50 32 255
                 77 55 33 255 83 58 33 255 85 60 34 255
                 91 64 36 255 101 73 40 255 97 70 38 255
                 98 69 37 255 99 70 37 255 88 64 35 255
                 73 52 32 255 71 50 30 255 66 46 28 255
                 68 45 28 255 68 47 29 255 69 48 28 255
                 69 48 28 255 47 38 25 255 16 18 17 255
                 15 15 17 255 16 16 17 255 15 14 16 255
                 28 24 20 255 24 19 18 255 55 38 28 255
                 70 50 31 255 67 48 28 255 64 45 27 255
                 55 39 24 255 49 34 22 255 21 19 16 255
                 12 13 15 255 15 16 17 255 20 21 20 255
                 37 32 25 255 69 57 40 255 72 63 42 255
                 33 35 25 255 23 23 20 255 55 40 27 255
                 85 60 35 255 96 70 42 255 91 69 41 255
                 67 54 33 255 61 49 32 255 28 27 21 255
                 14 16 17 255 12 13 15 255 11 11 15 255
                 12 12 15 255 13 13 16 255 13 13 15 255
                 11 13 15 255 10 11 14 255 10 11 14 255
                 10 10 14 255 10 11 14 255 11 12 16 255
                 9 11 15 255 8 10 14 255 8 9 14 255
                 8 9 13 255 8 9 13 255 8 9 13 255
                 8 9 13 255 9 9 14 255 10 11 15 255
                 13 13 16 255 28 22 19 255 59 43 30 255
                 71 55 35 255 43 38 25 255 58 42 28 255
                 70 53 31 255 44 36 24 255 46 37 26 255
                 59 45 29 255 96 73 44 255 104 82 49 255
                 103 82 50 255 76 67 40 255 29 31 22 255
                 11 11 14 255 9 9 14 255 10 11 15 255
                 10 11 15 255 9 10 15 255 9 10 13 255
                 9 9 14 255 9 10 14 255 10 10 15 255
                 10 11 14 255 10 11 15 255 10 11 15 255
                 10 11 15 255 10 11 15 255 10 11 15 255
                 10 12 16 255 10 12 16 255 11 12 16 255
                 11 12 16 255 11 13 16 255 13 13 17 255
                 18 17 18 255 34 28 22 255 60 48 30 255
                 72 55 35 255 70 52 33 255 46 40 27 255
                 27 25 21 255 39 30 22 255 70 48 30 255
                 88 61 34 255 88 61 32 255 94 65 35 255
                 92 66 37 255 104 76 42 255 101 76 43 255
                 76 63 37 255 44 38 28 255 76 54 34 255
                 82 60 35 255 72 54 33 255 74 54 33 255
                 88 62 36 255 95 68 38 255 93 68 38 255
                 92 67 38 255 97 69 41 255 97 69 39 255
                 99 70 40 255 90 66 38 255 95 68 38 255
                 107 78 43 255 109 80 44 255 106 78 43 255
                 95 69 39 255 87 61 35 255 88 62 36 255
                 89 64 37 255 83 60 36 255 85 60 36 255
                 91 64 37 255 89 64 38 255 89 63 39 255
                 91 65 37 255 89 66 37 255 85 63 36 255
                 84 62 35 255 74 55 36 255 70 52 35 255
                 74 54 36 255 74 55 36 255 71 54 34 255
                 54 42 28 255 42 33 25 255 44 34 26 255
                 44 33 25 255 46 35 26 255 48 36 26 255
                 40 31 25 255 40 31 25 255 39 31 24 255
                 40 31 24 255 41 32 25 255 44 34 25 255
                 47 36 25 255 47 35 26 255 54 41 28 255
                 53 41 28 255 52 39 27 255 52 39 27 255
                 58 43 30 255 64 48 32 255 65 49 32 255
                 68 50 33 255 65 48 32 255 57 42 30 255
                 54 41 29 255 48 37 28 255 54 40 30 255
                 66 48 32 255 65 48 31 255 55 40 26 255
                 57 40 27 255 46 36 24 255 32 28 21 255
                 42 33 23 255 35 29 20 255 36 29 21 255
                 24 21 20 255 23 19 19 255 22 18 17 255
                 25 21 18 255 45 33 24 255 62 44 27 255
                 63 42 25 255 55 38 24 255 35 27 21 255
                 27 22 20 255 28 22 20 255 31 24 20 255
                 40 29 22 255 41 29 22 255 39 28 22 255
                 39 30 22 255 37 29 22 255 40 29 23 255
)"
        R"(                 40 29 23 255 45 34 24 255 42 32 23 255
                 43 32 24 255 49 36 25 255 50 37 25 255
                 49 37 25 255 39 30 22 255 47 33 24 255
                 58 42 28 255 59 42 28 255 66 46 29 255
                 73 51 31 255 75 52 32 255 80 56 33 255
                 83 59 33 255 81 58 32 255 75 54 30 255
                 66 48 29 255 62 46 29 255 63 48 30 255
                 65 47 30 255 67 49 31 255 65 49 30 255
                 65 47 29 255 63 47 29 255 53 41 27 255
                 49 38 27 255 57 44 30 255 66 51 33 255
                 60 47 30 255 58 45 29 255 57 44 28 255
                 55 43 28 255 56 43 28 255 62 46 29 255
                 66 49 30 255 84 61 36 255 90 66 38 255
                 81 62 36 255 74 56 34 255 72 53 33 255
                 73 54 33 255 67 50 31 255 62 47 29 255
                 69 50 32 255 76 56 34 255 73 53 32 255
                 77 55 34 255 81 59 35 255 85 62 35 255
                 88 62 35 255 93 65 36 255 99 70 39 255
                 99 71 38 255 100 71 38 255 99 71 39 255
                 90 64 35 255 80 58 34 255 76 54 32 255
                 74 52 31 255 72 51 30 255 67 49 30 255
                 65 46 29 255 65 47 29 255 31 28 19 255
                 12 11 15 255 13 12 16 255 25 20 18 255
                 41 29 20 255 57 42 26 255 50 37 23 255
                 53 38 25 255 66 46 29 255 75 53 31 255
                 70 50 29 255 61 42 25 255 42 32 22 255
                 16 17 17 255 11 12 16 255 12 14 17 255
                 28 25 24 255 70 59 42 255 84 71 48 255
                 66 60 41 255 22 25 21 255 18 18 20 255
                 52 38 28 255 81 58 36 255 92 67 41 255
                 78 63 37 255 36 34 25 255 45 37 28 255
                 27 26 22 255 16 17 18 255 13 14 16 255
                 13 13 16 255 14 14 16 255 15 16 17 255
                 13 14 17 255 11 12 15 255 10 11 15 255
                 10 11 15 255 9 11 15 255 10 11 15 255
                 10 11 16 255 10 11 15 255 9 10 15 255
                 9 10 15 255 9 9 14 255 9 9 13 255
                 8 9 13 255 9 9 13 255 10 11 15 255
                 14 14 16 255 31 25 21 255 69 52 33 255
                 87 66 39 255 91 67 40 255 87 68 40 255
                 88 66 38 255 85 62 34 255 75 57 31 255
                 78 57 33 255 93 68 40 255 106 82 48 255
                 104 82 49 255 98 80 50 255 63 57 38 255
                 27 29 23 255 16 18 17 255 11 12 15 255
                 10 11 15 255 10 11 15 255 10 11 15 255
                 9 10 15 255 10 10 15 255 11 10 15 255
                 11 11 16 255 11 12 15 255 11 12 16 255
                 11 12 15 255 11 13 16 255 11 13 16 255
                 11 12 17 255 11 12 16 255 11 12 16 255
                 12 12 16 255 12 14 17 255 15 16 18 255
                 27 24 21 255 49 39 27 255 71 55 35 255
                 74 56 35 255 72 53 33 255 63 49 32 255
                 26 26 22 255 15 15 17 255 23 21 20 255
                 43 32 26 255 87 58 34 255 97 67 36 255
                 97 67 37 255 100 71 40 255 105 77 44 255
                 92 72 42 255 47 42 28 255 56 41 27 255
                 94 67 39 255 100 74 41 255 95 70 39 255
                 97 70 40 255 97 70 39 255 93 67 39 255
                 86 61 37 255 86 60 35 255 97 69 40 255
                 96 69 38 255 97 68 39 255 94 67 37 255
                 105 75 43 255 115 85 48 255 118 89 49 255
                 114 88 47 255 101 75 40 255 91 63 35 255
                 93 66 37 255 92 66 37 255 83 61 36 255
                 80 58 35 255 86 61 37 255 91 66 38 255
                 94 67 39 255 100 72 40 255 98 73 41 255
                 88 65 38 255 86 63 37 255 69 51 33 255
                 69 50 34 255 73 53 35 255 76 55 35 255
                 73 54 34 255 59 45 28 255 47 37 24 255
                 45 34 25 255 45 33 25 255 48 36 26 255
                 46 34 25 255 42 31 24 255 39 30 24 255
                 44 34 26 255 47 36 26 255 43 33 24 255
                 47 36 26 255 57 42 29 255 52 39 27 255
                 55 42 29 255 64 47 31 255 68 49 32 255
                 65 48 31 255 62 45 30 255 67 49 31 255
                 69 50 32 255 68 51 33 255 68 50 33 255
                 65 48 32 255 59 45 30 255 48 38 26 255
                 46 34 26 255 59 42 29 255 66 47 32 255
                 59 44 28 255 57 39 27 255 59 43 27 255
                 50 37 23 255 50 38 24 255 48 38 24 255
                 42 34 23 255 26 22 20 255 26 21 20 255
                 26 21 18 255 26 21 18 255 39 29 23 255
                 63 44 28 255 62 43 26 255 47 34 23 255
                 31 25 20 255 29 22 19 255 33 25 21 255
                 37 27 21 255 42 30 22 255 44 31 23 255
                 42 31 24 255 48 35 25 255 45 34 23 255
                 43 31 23 255 41 29 23 255 44 33 24 255
                 41 32 22 255 39 30 22 255 43 31 24 255
                 48 35 25 255 52 39 26 255 53 39 26 255
                 62 44 29 255 65 47 30 255 61 43 28 255
                 65 45 29 255 70 48 31 255 79 56 33 255
                 80 58 33 255 80 57 32 255 79 56 32 255
                 73 52 31 255 65 48 30 255 64 47 30 255
                 65 49 31 255 65 48 31 255 69 50 31 255
                 62 47 29 255 63 47 30 255 62 46 29 255
                 53 40 26 255 58 44 28 255 65 50 32 255
                 64 49 31 255 60 45 29 255 62 48 31 255
                 60 46 30 255 62 48 30 255 64 49 31 255
                 67 50 30 255 78 56 34 255 92 67 38 255
                 94 68 37 255 88 66 36 255 82 62 34 255
                 75 56 33 255 78 58 34 255 78 57 33 255
                 78 58 33 255 81 59 34 255 83 60 34 255
                 83 60 34 255 75 54 33 255 79 56 34 255
                 89 63 36 255 93 66 36 255 95 67 36 255
                 95 69 37 255 98 70 39 255 102 73 41 255
                 92 67 37 255 85 61 35 255 83 60 35 255
                 76 56 34 255 69 52 32 255 66 49 32 255
                 68 50 31 255 65 48 30 255 59 46 29 255
                 36 33 21 255 16 17 16 255 26 19 17 255
                 60 42 27 255 74 52 31 255 78 57 33 255
                 73 53 31 255 69 50 30 255 66 47 29 255
                 62 46 29 255 60 43 27 255 61 42 27 255
                 39 31 23 255 14 14 16 255 10 10 15 255
                 14 13 16 255 47 36 29 255 70 58 40 255
                 68 55 40 255 63 55 38 255 40 37 26 255
                 24 23 20 255 42 33 26 255 62 49 33 255
                 88 64 41 255 88 70 41 255 56 47 28 255
                 51 44 28 255 30 30 22 255 19 21 20 255
                 15 17 18 255 18 18 17 255 18 18 18 255
                 14 16 17 255 12 13 17 255 11 12 16 255
                 10 12 16 255 10 12 16 255 10 11 16 255
                 11 12 16 255 10 12 16 255 9 10 15 255
                 9 10 14 255 10 11 15 255 9 11 15 255
                 9 10 14 255 9 10 14 255 10 11 14 255
                 17 15 17 255 40 31 23 255 73 55 35 255
                 89 67 40 255 96 72 42 255 99 74 44 255
                 97 72 43 255 93 68 39 255 93 68 37 255
                 96 70 38 255 98 71 40 255 100 74 44 255
                 105 82 48 255 96 76 45 255 91 73 48 255
                 46 47 32 255 26 25 22 255 33 31 24 255
                 21 22 19 255 15 15 16 255 11 11 15 255
                 11 12 15 255 10 12 16 255 11 12 16 255
                 11 12 16 255 12 13 17 255 12 14 17 255
                 13 14 17 255 13 15 18 255 13 16 18 255
                 13 16 18 255 13 14 18 255 12 13 17 255
                 12 13 17 255 13 15 18 255 17 17 19 255
                 40 31 24 255 65 49 32 255 71 53 35 255
                 72 53 34 255 76 54 33 255 76 54 32 255
                 50 41 27 255 15 16 17 255 13 13 16 255
                 15 14 17 255 37 26 22 255 80 53 32 255
                 94 65 36 255 95 66 36 255 103 74 40 255
                 106 78 43 255 99 73 41 255 83 61 33 255
                 93 67 39 255 97 71 43 255 98 72 41 255
                 100 73 41 255 101 72 42 255 100 73 41 255
                 93 68 38 255 85 60 35 255 91 65 37 255
                 94 69 38 255 90 64 36 255 92 64 37 255
                 84 60 35 255 90 64 38 255 106 75 43 255
                 116 86 49 255 112 85 47 255 99 72 39 255
                 96 67 37 255 101 71 40 255 99 72 39 255
                 91 65 37 255 94 67 38 255 97 71 38 255
                 97 68 38 255 101 71 39 255 104 74 40 255
                 107 77 42 255 97 71 38 255 89 65 37 255
                 74 54 34 255 76 55 34 255 75 54 34 255
                 73 53 34 255 73 53 34 255 66 49 31 255
                 51 39 25 255 46 34 25 255 50 36 26 255
                 49 36 25 255 50 37 26 255 51 38 26 255
                 41 32 24 255 40 31 25 255 42 33 25 255
                 43 33 25 255 51 39 27 255 58 44 31 255
                 53 41 27 255 56 42 28 255 62 46 30 255
                 66 47 31 255 64 47 31 255 67 49 32 255
                 69 50 32 255 69 50 33 255 69 51 32 255
                 70 51 33 255 71 52 33 255 70 52 33 255
                 62 47 29 255 56 41 27 255 64 46 31 255
                 67 49 33 255 63 48 31 255 62 45 29 255
                 61 44 29 255 62 44 28 255 57 42 26 255
                 50 39 24 255 46 36 24 255 36 29 22 255
                 30 25 21 255 28 23 20 255 28 22 19 255
                 29 23 20 255 39 30 23 255 47 35 25 255
                 42 31 23 255 36 27 21 255 41 30 22 255
                 48 34 24 255 50 35 24 255 50 36 24 255
                 44 32 23 255 42 30 23 255 45 34 25 255
                 43 34 23 255 40 30 22 255 40 29 23 255
                 42 31 23 255 43 32 24 255 46 34 24 255
                 46 35 24 255 44 32 24 255 49 36 25 255
                 56 42 27 255 64 46 30 255 65 47 30 255
                 62 45 29 255 67 47 29 255 77 55 32 255
                 76 55 33 255 75 54 33 255 76 56 33 255
                 74 54 32 255 68 50 31 255 65 48 30 255
                 61 46 30 255 59 44 29 255 60 45 30 255
                 66 49 31 255 66 49 30 255 68 51 32 255
                 70 53 32 255 65 50 31 255 71 54 34 255
                 74 57 33 255 59 46 29 255 61 46 30 255
                 69 52 34 255 68 51 32 255 68 51 32 255
                 71 53 33 255 75 56 33 255 85 63 36 255
                 94 69 38 255 97 72 40 255 97 73 40 255
                 97 73 41 255 89 68 38 255 90 68 38 255
                 91 67 38 255 90 67 38 255 90 66 36 255
                 95 68 38 255 102 75 42 255 94 70 38 255
                 88 63 35 255 93 65 37 255 94 67 36 255
                 95 68 37 255 94 68 38 255 97 68 39 255
                 103 74 41 255 93 68 36 255 82 58 34 255
                 83 60 36 255 79 58 37 255 77 62 39 255
                 75 61 39 255 72 58 34 255 48 41 26 255
                 26 23 20 255 19 19 18 255 19 17 17 255
                 55 38 26 255 78 55 32 255 78 55 32 255
                 79 56 32 255 76 55 32 255 76 55 32 255
                 57 44 27 255 28 25 21 255 41 29 24 255
                 56 39 28 255 26 23 20 255 12 12 15 255
                 13 12 16 255 28 22 21 255 76 57 39 255
                 71 58 36 255 49 40 30 255 59 46 35 255
                 74 62 42 255 58 53 32 255 31 30 23 255
                 46 37 28 255 91 68 44 255 102 78 48 255
                 96 76 44 255 67 57 33 255 36 33 24 255
                 26 26 22 255 22 22 20 255 23 22 20 255
                 21 21 19 255 16 18 18 255 13 14 17 255
                 12 13 17 255 11 12 16 255 11 13 16 255
                 12 13 16 255 13 14 17 255 12 13 17 255
                 11 11 15 255 11 12 15 255 10 11 15 255
                 10 11 15 255 12 12 15 255 15 15 16 255
                 22 21 18 255 49 40 27 255 81 63 37 255
                 93 71 41 255 96 73 42 255 99 76 44 255
                 97 72 42 255 96 69 39 255 95 68 38 255
                 98 71 39 255 102 74 40 255 103 76 44 255
                 101 76 44 255 100 77 45 255 91 71 44 255
                 95 78 51 255 74 69 43 255 47 46 31 255
                 30 31 25 255 30 28 23 255 43 39 26 255
                 24 26 20 255 14 16 17 255 13 14 17 255
                 12 13 17 255 12 13 17 255 13 14 18 255
                 14 16 18 255 14 17 19 255 14 16 19 255
                 16 19 20 255 16 19 19 255 17 18 19 255
                 16 18 19 255 18 19 18 255 25 23 20 255
                 45 35 25 255 70 52 33 255 76 52 34 255
                 81 53 35 255 81 55 34 255 82 58 34 255
                 80 57 33 255 55 45 28 255 22 21 18 255
                 17 17 17 255 20 17 18 255 59 40 26 255
                 86 59 33 255 93 65 36 255 98 69 38 255
                 106 78 43 255 102 74 41 255 103 73 41 255
                 100 72 40 255 93 68 39 255 90 66 39 255
                 100 72 42 255 99 73 41 255 96 68 40 255
                 100 72 41 255 96 70 40 255 90 64 37 255
                 91 66 38 255 88 65 37 255 85 61 35 255
                 85 61 37 255 77 57 34 255 81 56 34 255
                 98 68 40 255 108 78 44 255 105 78 43 255
                 98 70 38 255 102 73 40 255 109 78 44 255
                 104 76 42 255 95 68 38 255 103 72 39 255
                 111 82 43 255 109 81 43 255 107 77 42 255
                 108 77 42 255 110 79 42 255 107 79 42 255
                 99 72 39 255 83 60 36 255 82 59 36 255
                 78 55 34 255 71 51 33 255 71 50 33 255
                 65 47 30 255 55 40 27 255 47 35 26 255
                 49 37 26 255 52 38 26 255 52 38 27 255
                 49 37 26 255 36 28 23 255 35 28 23 255
                 37 29 24 255 45 34 24 255 50 38 27 255
                 47 36 27 255 56 42 29 255 58 45 30 255
                 56 43 29 255 58 43 29 255 61 44 29 255
                 67 48 32 255 67 49 32 255 68 49 32 255
                 69 50 32 255 76 55 34 255 80 59 36 255
                 81 58 36 255 79 57 34 255 74 54 34 255
                 69 52 34 255 65 49 33 255 65 49 33 255
                 67 50 33 255 61 46 31 255 57 41 28 255
                 54 41 26 255 51 38 25 255 51 39 25 255
                 42 34 24 255 30 25 22 255 28 23 21 255
                 27 22 19 255 25 21 18 255 26 22 19 255
                 34 26 22 255 46 33 23 255 47 34 23 255
                 54 38 26 255 56 40 26 255 56 39 26 255
                 55 39 26 255 49 36 24 255 42 31 23 255
                 40 30 23 255 37 29 23 255 37 28 22 255
                 38 29 22 255 37 27 22 255 42 31 23 255
                 51 36 25 255 55 39 25 255 47 35 24 255
                 45 33 24 255 55 39 27 255 57 42 28 255
                 59 43 29 255 68 47 29 255 77 55 32 255
                 76 55 32 255 77 55 32 255 75 54 33 255
                 68 51 32 255 66 50 30 255 66 49 31 255
                 64 49 30 255 55 43 28 255 53 41 27 255
                 60 46 30 255 65 50 32 255 64 49 31 255
                 68 51 32 255 73 54 33 255 72 54 35 255
                 80 60 35 255 78 58 33 255 66 49 28 255
                 61 45 29 255 72 52 34 255 76 56 34 255
                 78 57 34 255 83 60 35 255 88 65 37 255
                 94 69 38 255 100 73 42 255 103 78 44 255
                 108 85 48 255 110 89 52 255 107 90 53 255
                 105 86 50 255 107 86 49 255 101 80 46 255
                 95 74 41 255 101 77 44 255 113 87 49 255
                 115 88 48 255 106 80 42 255 99 72 40 255
                 91 66 37 255 96 69 38 255 96 70 39 255
                 93 67 38 255 99 71 40 255 97 71 38 255
                 83 59 34 255 86 62 38 255 77 57 38 255
                 81 62 41 255 78 61 40 255 66 52 32 255
                 36 31 21 255 21 19 17 255 30 24 19 255
                 43 31 22 255 64 46 29 255 72 53 32 255
                 75 54 33 255 75 53 31 255 74 51 30 255
                 74 53 31 255 45 38 24 255 16 16 17 255
                 33 23 22 255 43 32 25 255 17 16 17 255
                 30 25 23 255 50 41 29 255 73 56 35 255
                 95 72 44 255 74 58 36 255 47 39 29 255
                 45 37 30 255 73 56 43 255 82 70 44 255
                 34 34 24 255 55 42 30 255 91 69 42 255
                 96 72 44 255 101 77 47 255 89 71 40 255
                 71 58 33 255 47 41 27 255 28 26 22 255
                 24 24 21 255 20 21 20 255 18 20 19 255
                 15 17 18 255 14 16 17 255 15 16 18 255
                 16 16 18 255 17 17 18 255 19 18 18 255
)"
        R"(                 21 19 18 255 22 20 18 255 23 21 18 255
                 28 24 20 255 31 27 21 255 32 28 20 255
                 30 29 21 255 29 27 21 255 72 55 36 255
                 94 73 43 255 92 73 43 255 82 64 40 255
                 94 69 38 255 96 69 39 255 99 71 38 255
                 99 71 38 255 100 72 40 255 102 74 41 255
                 95 71 41 255 95 71 42 255 94 72 41 255
                 94 76 49 255 94 81 55 255 93 81 54 255
                 62 61 39 255 21 25 21 255 32 28 23 255
                 68 55 37 255 61 57 35 255 38 38 26 255
                 24 25 21 255 17 18 19 255 15 16 18 255
                 15 16 19 255 17 19 19 255 18 19 19 255
                 19 19 19 255 25 24 22 255 29 28 23 255
                 29 28 23 255 27 26 22 255 31 28 22 255
                 53 41 27 255 74 54 34 255 75 54 34 255
                 78 52 33 255 82 53 34 255 86 58 33 255
                 87 61 34 255 86 61 36 255 76 56 33 255
                 60 46 27 255 35 31 21 255 40 29 21 255
                 79 54 32 255 93 65 36 255 97 69 37 255
                 103 74 41 255 102 74 42 255 100 71 40 255
                 101 71 40 255 102 73 42 255 96 71 41 255
                 94 68 39 255 99 71 41 255 100 73 40 255
                 96 68 37 255 97 68 39 255 93 68 39 255
                 87 63 37 255 84 60 35 255 84 61 35 255
                 91 65 37 255 95 69 39 255 89 65 37 255
                 85 61 36 255 90 63 38 255 99 71 42 255
                 101 74 42 255 102 74 42 255 105 76 43 255
                 114 83 46 255 113 84 45 255 111 83 44 255
                 115 83 45 255 117 87 49 255 117 89 48 255
                 113 85 46 255 112 82 44 255 112 82 43 255
                 113 83 45 255 108 78 41 255 84 61 36 255
                 81 58 35 255 79 56 35 255 74 52 34 255
                 74 52 34 255 68 49 31 255 62 45 30 255
                 52 39 27 255 52 38 27 255 50 38 26 255
                 48 36 26 255 39 30 23 255 28 23 21 255
                 29 24 22 255 34 27 23 255 45 34 25 255
                 45 35 26 255 43 33 25 255 49 37 28 255
                 48 37 27 255 49 36 27 255 50 37 28 255
                 54 40 28 255 63 46 30 255 69 50 32 255
                 70 50 33 255 74 54 34 255 79 59 35 255
                 82 60 35 255 82 59 34 255 80 58 34 255
                 74 55 34 255 64 49 32 255 62 46 30 255
                 59 45 31 255 60 46 31 255 65 48 33 255
                 63 46 30 255 55 41 26 255 51 37 24 255
                 47 36 23 255 36 29 22 255 33 27 22 255
                 31 25 21 255 29 23 20 255 26 22 18 255
                 28 23 19 255 38 29 23 255 50 36 25 255
                 54 38 25 255 59 40 27 255 63 44 29 255
                 63 44 28 255 54 39 25 255 49 35 24 255
                 52 37 25 255 47 36 25 255 35 29 22 255
                 34 26 22 255 38 28 22 255 40 29 22 255
                 45 33 24 255 52 37 26 255 55 40 26 255
                 48 36 25 255 49 35 25 255 61 44 28 255
                 59 44 27 255 63 45 28 255 78 56 33 255
                 78 57 32 255 74 53 31 255 76 55 32 255
                 67 50 31 255 62 46 30 255 64 48 30 255
                 66 50 32 255 59 47 30 255 52 42 28 255
                 53 42 28 255 59 46 30 255 65 50 32 255
                 67 51 31 255 67 52 32 255 73 55 34 255
                 84 61 35 255 85 61 33 255 82 58 33 255
                 80 58 33 255 70 51 32 255 69 50 31 255
                 80 58 35 255 84 62 35 255 89 65 36 255
                 97 71 40 255 103 77 44 255 109 85 51 255
                 109 88 54 255 106 87 54 255 102 83 52 255
                 98 79 51 255 97 77 50 255 103 82 53 255
                 107 88 57 255 108 91 56 255 107 88 51 255
                 106 83 48 255 112 85 49 255 113 88 49 255
                 102 77 44 255 86 65 37 255 78 58 35 255
                 89 64 37 255 94 68 37 255 97 70 39 255
                 102 76 41 255 83 60 34 255 84 61 36 255
                 77 56 35 255 72 53 33 255 67 47 30 255
                 65 46 28 255 60 45 26 255 37 34 23 255
                 46 37 26 255 56 44 28 255 39 35 26 255
                 33 29 24 255 43 34 26 255 64 46 29 255
                 69 48 29 255 59 44 28 255 26 24 19 255
                 15 14 16 255 28 21 20 255 50 37 26 255
                 40 35 26 255 75 59 42 255 93 73 45 255
                 89 68 41 255 97 73 45 255 85 67 41 255
                 57 47 31 255 47 38 29 255 80 62 45 255
                 89 76 49 255 50 44 27 255 46 37 28 255
                 82 60 38 255 97 71 43 255 100 75 45 255
                 100 77 45 255 94 74 42 255 61 50 30 255
                 39 32 23 255 33 29 22 255 27 26 21 255
                 28 26 21 255 29 26 21 255 33 29 22 255
                 42 35 25 255 45 38 26 255 39 34 25 255
                 53 43 29 255 62 50 31 255 65 54 33 255
                 67 55 34 255 75 60 37 255 58 51 32 255
                 32 30 23 255 22 23 20 255 28 23 21 255
                 78 58 38 255 90 69 41 255 85 64 37 255
                 81 59 33 255 95 68 38 255 96 69 38 255
                 98 70 39 255 96 69 38 255 95 69 40 255
                 97 71 39 255 90 67 38 255 90 67 39 255
                 91 71 44 255 90 77 52 255 90 78 55 255
                 92 81 54 255 78 72 46 255 41 42 28 255
                 48 38 29 255 82 66 43 255 63 58 38 255
                 64 54 37 255 62 55 34 255 42 38 26 255
                 31 30 23 255 27 27 22 255 30 28 22 255
                 36 31 24 255 44 37 27 255 65 51 33 255
                 78 63 38 255 70 58 35 255 37 36 26 255
                 25 25 21 255 46 34 26 255 74 52 32 255
                 80 56 32 255 86 60 34 255 92 64 36 255
                 94 66 35 255 92 65 36 255 89 63 37 255
                 86 62 36 255 83 59 34 255 74 54 30 255
                 79 54 30 255 95 65 36 255 98 69 37 255
                 100 72 39 255 100 72 41 255 98 69 39 255
                 96 70 40 255 101 71 41 255 102 73 41 255
                 96 69 38 255 97 68 38 255 98 70 38 255
                 100 72 40 255 99 71 38 255 94 67 36 255
                 86 63 38 255 80 59 37 255 78 57 36 255
                 88 63 37 255 91 65 37 255 97 69 39 255
                 94 68 38 255 85 61 36 255 90 63 37 255
                 91 66 38 255 89 65 37 255 92 65 38 255
                 93 66 39 255 109 78 44 255 120 89 49 255
                 121 91 50 255 119 87 48 255 115 85 48 255
                 113 83 46 255 112 81 45 255 110 80 43 255
                 112 82 44 255 111 82 43 255 106 76 40 255
                 81 59 36 255 80 58 35 255 79 57 35 255
                 76 55 35 255 73 52 34 255 69 49 32 255
                 65 47 31 255 56 42 27 255 52 38 26 255
                 50 36 26 255 44 32 25 255 38 30 23 255
                 31 25 21 255 28 23 20 255 32 25 21 255
                 40 31 24 255 43 34 25 255 40 32 24 255
                 40 31 24 255 41 31 24 255 44 33 25 255
                 43 32 25 255 46 35 26 255 57 42 28 255
                 62 46 31 255 68 50 33 255 73 54 34 255
                 80 59 35 255 81 60 35 255 79 59 34 255
                 73 54 33 255 62 47 32 255 61 46 31 255
                 66 49 32 255 63 47 31 255 58 44 30 255
                 60 43 31 255 68 49 32 255 64 47 28 255
                 58 42 26 255 52 39 24 255 43 33 22 255
                 38 31 22 255 37 29 22 255 37 28 22 255
                 30 23 20 255 32 24 20 255 43 32 24 255
                 52 39 27 255 58 41 26 255 59 41 27 255
                 62 43 28 255 59 42 28 255 51 37 25 255
                 53 37 26 255 51 37 26 255 41 32 23 255
                 34 26 22 255 34 26 22 255 38 29 22 255
                 42 31 22 255 43 32 23 255 45 33 23 255
                 46 34 24 255 44 32 23 255 51 36 25 255
                 60 43 28 255 67 48 30 255 68 50 31 255
                 64 48 30 255 66 47 29 255 75 53 32 255
                 71 51 32 255 62 46 29 255 63 46 30 255
                 68 49 31 255 63 48 31 255 52 42 28 255
                 52 41 28 255 59 46 30 255 64 49 31 255
                 66 51 33 255 66 51 32 255 76 56 34 255
                 88 63 35 255 93 66 36 255 93 66 35 255
                 91 64 36 255 88 63 36 255 80 58 34 255
                 75 54 32 255 87 63 36 255 87 64 35 255
                 93 68 39 255 103 79 46 255 107 86 53 255
                 107 87 53 255 99 78 46 255 92 71 41 255
                 85 63 38 255 84 62 37 255 87 64 38 255
                 94 70 42 255 95 73 45 255 101 80 52 255
                 108 89 57 255 111 92 57 255 110 88 51 255
                 107 83 47 255 104 80 46 255 85 65 37 255
                 70 51 31 255 93 66 39 255 106 79 42 255
                 102 74 42 255 98 72 41 255 89 64 36 255
                 86 61 36 255 83 59 34 255 73 52 30 255
                 68 46 28 255 66 45 27 255 64 47 28 255
                 25 25 20 255 32 26 23 255 45 38 26 255
                 16 17 18 255 12 12 16 255 20 16 18 255
                 52 37 26 255 56 42 26 255 32 28 21 255
                 21 21 18 255 32 24 20 255 57 41 28 255
                 82 65 42 255 83 69 44 255 92 72 46 255
                 98 74 45 255 88 68 39 255 90 67 41 255
                 94 73 45 255 83 67 42 255 75 63 41 255
                 95 80 53 255 81 70 44 255 54 46 29 255
                 38 32 25 255 70 52 36 255 96 71 44 255
                 98 73 44 255 101 76 45 255 105 81 47 255
                 90 71 39 255 71 55 31 255 58 47 28 255
                 38 35 23 255 43 36 25 255 63 50 32 255
                 75 59 37 255 83 67 41 255 72 63 38 255
                 44 40 28 255 70 55 37 255 74 60 38 255
                 51 47 33 255 51 44 33 255 80 61 39 255
                 68 57 33 255 35 32 22 255 36 30 21 255
                 48 36 24 255 82 60 36 255 83 61 35 255
                 80 58 34 255 78 57 34 255 83 61 36 255
                 87 63 37 255 91 66 38 255 93 68 39 255
                 94 68 39 255 95 69 38 255 94 69 38 255
                 90 69 40 255 90 76 50 255 86 74 51 255
                 99 84 61 255 98 86 59 255 90 81 53 255
                 76 70 43 255 77 62 38 255 87 69 43 255
                 58 52 34 255 71 56 39 255 85 70 43 255
                 74 63 40 255 45 44 30 255 43 37 27 255
                 63 52 34 255 73 60 37 255 78 63 39 255
                 88 70 43 255 93 72 46 255 83 68 43 255
                 41 40 27 255 22 20 19 255 50 34 25 255
                 80 55 33 255 80 58 33 255 70 54 33 255
                 86 60 36 255 94 67 37 255 92 66 36 255
                 89 64 37 255 88 63 37 255 85 61 35 255
                 84 60 34 255 90 62 34 255 96 66 36 255
                 97 69 38 255 99 71 41 255 100 71 41 255
                 99 69 39 255 94 68 38 255 100 70 39 255
                 103 73 40 255 99 70 39 255 99 70 40 255
                 100 72 40 255 101 73 41 255 99 70 40 255
                 95 68 37 255 81 60 36 255 64 48 32 255
                 65 47 31 255 82 58 35 255 85 61 36 255
                 99 70 40 255 101 72 41 255 98 71 39 255
                 97 71 39 255 94 67 37 255 93 68 38 255
                 94 67 38 255 99 71 40 255 108 78 44 255
                 114 83 46 255 120 89 50 255 116 85 47 255
                 116 85 47 255 115 85 47 255 115 84 47 255
                 114 85 45 255 110 82 45 255 109 79 43 255
                 106 76 41 255 85 62 36 255 81 59 35 255
                 80 58 35 255 81 58 35 255 75 54 34 255
                 70 50 33 255 66 48 32 255 60 43 28 255
                 53 39 27 255 51 38 27 255 44 33 25 255
                 36 28 22 255 34 26 22 255 35 27 22 255
                 36 28 22 255 36 27 23 255 35 28 23 255
                 37 30 23 255 43 34 24 255 44 34 24 255
                 40 30 23 255 48 35 25 255 51 38 26 255
                 51 39 26 255 47 35 25 255 53 39 28 255
                 64 46 33 255 79 58 36 255 79 58 35 255
                 70 52 32 255 55 42 29 255 47 37 27 255
                 52 39 29 255 63 48 33 255 66 50 32 255
                 61 47 30 255 59 42 30 255 64 46 31 255
                 70 51 32 255 65 47 29 255 59 43 27 255
                 53 39 25 255 46 35 24 255 41 33 23 255
                 40 31 23 255 39 29 22 255 36 27 21 255
                 45 34 24 255 51 38 26 255 56 40 26 255
                 51 37 25 255 53 37 25 255 48 34 24 255
                 47 32 24 255 52 37 26 255 48 36 25 255
                 39 30 22 255 37 28 22 255 35 27 22 255
                 37 29 22 255 43 32 23 255 47 34 23 255
                 52 37 25 255 54 39 25 255 48 35 23 255
                 51 36 25 255 65 46 29 255 74 54 32 255
                 62 46 28 255 58 41 26 255 67 46 29 255
                 76 54 31 255 69 51 31 255 69 50 31 255
                 71 51 31 255 68 51 31 255 57 45 29 255
                 53 42 28 255 62 47 31 255 70 53 33 255
                 70 53 33 255 66 50 33 255 76 55 34 255
                 91 66 36 255 95 67 36 255 96 67 37 255
                 98 70 37 255 97 68 37 255 96 68 37 255
                 89 65 36 255 83 60 35 255 92 67 38 255
                 102 76 43 255 110 87 52 255 110 89 53 255
                 108 85 50 255 100 76 43 255 91 67 38 255
                 86 63 35 255 83 59 33 255 81 58 33 255
                 82 59 34 255 90 65 37 255 92 68 38 255
                 96 71 41 255 100 75 47 255 105 83 55 255
                 113 93 58 255 109 89 51 255 107 83 49 255
                 101 77 42 255 89 65 36 255 106 75 43 255
                 116 87 47 255 104 77 41 255 99 72 39 255
                 92 65 37 255 98 71 40 255 93 67 37 255
                 81 58 32 255 72 49 28 255 69 46 27 255
                 62 45 26 255 23 21 17 255 28 22 20 255
                 32 29 22 255 13 12 14 255 15 12 14 255
                 29 20 18 255 47 34 25 255 41 33 24 255
                 18 18 18 255 23 19 19 255 65 47 32 255
                 92 73 47 255 98 81 53 255 94 74 45 255
                 86 66 41 255 94 70 42 255 91 71 41 255
                 96 76 47 255 106 87 57 255 108 92 60 255
                 103 90 59 255 82 74 49 255 60 51 34 255
                 58 46 30 255 55 46 30 255 52 40 31 255
                 88 65 42 255 98 74 45 255 103 77 46 255
                 107 81 48 255 105 82 47 255 98 76 42 255
                 77 62 35 255 32 32 23 255 41 33 25 255
                 81 60 39 255 92 71 43 255 95 75 45 255
                 80 68 40 255 60 49 30 255 78 61 37 255
                 60 52 34 255 21 24 21 255 31 27 24 255
                 80 60 40 255 76 62 37 255 57 47 28 255
                 75 56 32 255 83 63 34 255 83 64 37 255
                 70 54 32 255 59 46 30 255 53 42 30 255
                 59 45 30 255 66 49 32 255 77 55 34 255
                 87 63 37 255 87 66 37 255 94 69 37 255
                 93 70 38 255 89 72 45 255 83 72 49 255
                 83 70 50 255 102 87 70 255 97 87 62 255
                 86 76 52 255 86 74 49 255 90 71 42 255
                 99 75 43 255 87 69 41 255 87 69 42 255
                 90 72 43 255 82 69 43 255 49 45 30 255
                 58 46 32 255 84 69 44 255 85 71 45 255
                 88 72 44 255 90 71 44 255 88 68 43 255
                 79 62 40 255 62 49 30 255 50 38 24 255
                 71 48 29 255 83 58 33 255 64 50 31 255
                 46 36 26 255 78 55 33 255 80 60 35 255
                 86 61 36 255 90 64 36 255 87 62 37 255
                 85 60 34 255 85 61 34 255 92 65 35 255
                 95 67 37 255 94 67 37 255 97 69 39 255
                 97 69 39 255 100 70 40 255 101 72 41 255
                 100 71 40 255 101 72 40 255 101 72 40 255
                 103 73 41 255 103 75 42 255 100 73 41 255
                 99 70 40 255 95 68 39 255 87 63 36 255
                 76 56 33 255 82 58 34 255 92 66 37 255
                 93 66 37 255 103 73 42 255 104 75 42 255
                 107 79 44 255 105 78 44 255 99 72 41 255
                 95 70 39 255 99 70 40 255 109 80 45 255
                 109 80 44 255 107 78 43 255 114 83 46 255
                 111 80 45 255 113 81 44 255 114 83 44 255
                 112 80 45 255 113 83 47 255 104 77 43 255
                 100 71 40 255 102 70 39 255 87 64 37 255
                 86 63 38 255 90 66 39 255 88 64 38 255
                 84 61 36 255 76 55 33 255 70 51 31 255
)"
        R"(                 63 47 29 255 53 39 27 255 51 37 27 255
                 46 35 25 255 37 29 22 255 36 28 23 255
                 42 32 24 255 42 31 24 255 36 27 23 255
                 32 26 22 255 34 27 22 255 41 31 24 255
                 41 31 23 255 44 32 24 255 52 38 27 255
                 53 40 28 255 47 37 25 255 44 34 25 255
                 52 39 27 255 59 42 30 255 77 56 35 255
                 79 59 35 255 71 52 32 255 55 41 27 255
                 47 36 25 255 47 35 25 255 54 41 28 255
                 63 46 32 255 64 49 31 255 64 47 31 255
                 60 45 30 255 59 45 30 255 67 50 33 255
                 64 47 30 255 58 41 27 255 51 37 25 255
                 41 32 23 255 36 28 22 255 40 30 23 255
                 39 29 22 255 43 32 23 255 49 37 26 255
                 53 39 26 255 52 36 25 255 56 39 26 255
                 59 40 25 255 58 39 26 255 59 41 27 255
                 53 39 25 255 45 33 23 255 42 32 23 255
                 39 29 23 255 44 32 23 255 50 36 25 255
                 54 39 26 255 54 38 24 255 49 35 24 255
                 48 35 24 255 59 43 28 255 73 53 32 255
                 72 52 31 255 69 51 30 255 73 53 31 255
                 77 55 31 255 73 53 31 255 67 49 31 255
                 73 53 33 255 73 53 33 255 65 49 31 255
                 54 42 28 255 59 45 29 255 73 54 33 255
                 74 56 34 255 72 54 34 255 80 58 34 255
                 88 62 35 255 94 66 37 255 97 68 37 255
                 98 69 38 255 98 71 38 255 98 70 38 255
                 100 73 40 255 89 66 37 255 93 69 41 255
                 106 84 50 255 112 92 56 255 114 92 54 255
                 114 87 49 255 109 82 44 255 97 71 39 255
                 88 62 36 255 89 63 35 255 92 65 36 255
                 86 62 34 255 86 61 35 255 94 66 37 255
                 94 68 37 255 98 71 39 255 100 73 41 255
                 98 73 43 255 105 81 51 255 113 92 58 255
                 111 89 51 255 112 85 48 255 109 82 45 255
                 112 82 46 255 115 87 48 255 109 81 44 255
                 103 78 41 255 92 67 37 255 101 74 43 255
                 90 69 38 255 82 60 34 255 75 51 29 255
                 72 48 27 255 72 49 27 255 50 37 21 255
                 40 31 21 255 19 19 18 255 25 20 18 255
                 48 34 24 255 49 38 26 255 33 30 23 255
                 21 19 19 255 12 12 15 255 32 25 24 255
                 82 67 46 255 98 82 54 255 99 79 49 255
                 95 73 43 255 90 68 41 255 98 75 45 255
                 104 87 54 255 110 94 60 255 112 97 63 255
                 114 99 65 255 95 87 57 255 46 47 33 255
                 59 48 33 255 83 65 39 255 79 63 36 255
                 79 60 35 255 91 67 39 255 90 67 41 255
                 99 75 46 255 100 77 46 255 80 67 40 255
                 76 61 38 255 81 66 38 255 42 39 24 255
                 61 46 31 255 93 71 43 255 100 79 47 255
                 100 79 48 255 98 77 46 255 87 72 42 255
                 69 59 38 255 46 43 30 255 18 18 17 255
                 41 30 23 255 79 59 35 255 68 55 33 255
                 52 40 27 255 84 61 34 255 87 64 35 255
                 70 54 32 255 52 43 29 255 43 37 27 255
                 39 34 25 255 44 36 26 255 51 41 29 255
                 62 47 31 255 65 51 32 255 50 41 29 255
                 84 63 38 255 90 71 43 255 88 75 50 255
                 64 56 39 255 47 40 31 255 52 42 38 255
                 75 61 46 255 78 68 46 255 83 71 46 255
                 90 70 41 255 100 74 43 255 98 73 42 255
                 93 70 41 255 91 71 43 255 84 68 43 255
                 82 65 40 255 84 68 41 255 81 67 44 255
                 59 52 37 255 79 60 41 255 92 71 42 255
                 85 63 38 255 83 60 37 255 80 59 35 255
                 75 53 32 255 84 57 34 255 89 63 36 255
                 80 58 33 255 82 58 33 255 88 64 36 255
                 57 46 29 255 77 53 33 255 94 66 36 255
                 93 66 38 255 90 63 35 255 92 65 36 255
                 91 65 37 255 91 64 37 255 91 64 37 255
                 93 65 37 255 96 68 39 255 97 69 39 255
                 95 69 40 255 93 66 39 255 98 69 40 255
                 98 70 40 255 98 70 41 255 98 71 39 255
                 97 70 39 255 92 66 38 255 83 60 36 255
                 85 61 37 255 84 62 36 255 91 65 38 255
                 98 70 40 255 101 72 41 255 105 76 44 255
                 98 72 41 255 98 71 41 255 104 76 44 255
                 100 72 41 255 101 73 41 255 103 73 41 255
                 106 77 43 255 109 80 44 255 110 81 46 255
                 106 77 44 255 98 70 41 255 102 71 40 255
                 108 76 42 255 110 80 44 255 113 83 47 255
                 105 79 44 255 100 73 41 255 99 70 40 255
                 93 68 39 255 91 66 39 255 91 66 41 255
                 92 67 40 255 91 66 39 255 86 63 36 255
                 76 56 34 255 67 49 31 255 59 43 28 255
                 52 38 27 255 48 36 26 255 42 33 24 255
                 42 32 23 255 43 33 24 255 39 29 23 255
                 35 27 22 255 32 26 21 255 37 28 22 255
                 40 30 23 255 35 27 21 255 40 30 23 255
                 46 35 25 255 47 36 27 255 44 34 25 255
                 38 30 24 255 46 35 26 255 54 39 27 255
                 67 49 32 255 62 48 31 255 58 44 30 255
                 56 42 28 255 49 37 26 255 49 37 26 255
                 54 40 28 255 65 47 31 255 64 48 31 255
                 63 46 30 255 60 45 30 255 57 43 30 255
                 63 47 33 255 67 50 33 255 66 47 31 255
                 61 43 28 255 46 35 24 255 32 27 21 255
                 37 29 22 255 40 30 23 255 41 30 23 255
                 45 34 24 255 51 38 26 255 56 39 27 255
                 58 41 26 255 60 42 26 255 62 43 27 255
                 58 41 27 255 51 37 25 255 50 36 24 255
                 51 37 25 255 48 35 24 255 54 38 26 255
                 52 38 25 255 55 37 25 255 54 38 24 255
                 50 36 24 255 61 44 29 255 68 51 31 255
                 73 53 32 255 75 54 32 255 75 55 32 255
                 72 53 32 255 69 51 31 255 65 49 31 255
                 64 48 31 255 67 49 30 255 67 50 32 255
                 62 47 31 255 65 48 31 255 73 54 33 255
                 73 55 34 255 76 56 34 255 87 62 36 255
                 95 68 36 255 95 67 36 255 97 69 37 255
                 100 70 39 255 101 71 38 255 99 71 37 255
                 97 69 38 255 103 76 44 255 106 83 48 255
                 109 87 53 255 112 90 54 255 109 84 49 255
                 110 81 44 255 113 83 44 255 107 79 41 255
                 95 68 37 255 87 61 34 255 89 61 34 255
                 94 66 36 255 92 66 36 255 90 63 36 255
                 94 66 38 255 96 69 38 255 97 70 39 255
                 99 72 39 255 96 69 40 255 98 71 42 255
                 105 81 53 255 115 94 60 255 113 90 51 255
                 109 82 47 255 114 85 47 255 117 87 47 255
                 115 86 47 255 102 77 42 255 93 68 38 255
                 84 65 38 255 51 45 29 255 54 41 28 255
                 72 52 31 255 70 50 28 255 81 56 31 255
                 80 56 30 255 59 45 24 255 26 20 17 255
                 49 34 25 255 59 44 29 255 33 29 23 255
                 19 18 19 255 20 18 18 255 14 13 17 255
                 45 35 31 255 89 72 50 255 98 77 48 255
                 76 62 38 255 88 65 41 255 100 79 49 255
                 108 91 59 255 112 98 64 255 113 100 66 255
                 114 100 66 255 114 99 67 255 91 84 54 255
                 56 52 33 255 45 41 30 255 59 48 34 255
                 64 54 35 255 75 59 38 255 84 64 39 255
                 72 55 36 255 65 53 36 255 76 60 40 255
                 45 44 30 255 50 39 29 255 92 69 42 255
                 93 74 40 255 98 76 43 255 101 78 45 255
                 98 74 42 255 97 72 41 255 98 73 42 255
                 82 67 39 255 48 42 29 255 48 39 27 255
                 57 44 26 255 67 52 30 255 60 50 31 255
                 65 50 33 255 78 58 34 255 88 65 36 255
                 84 62 35 255 63 49 30 255 48 40 27 255
                 40 36 25 255 37 34 25 255 39 34 26 255
                 45 37 27 255 55 44 29 255 55 44 29 255
                 45 36 25 255 50 44 31 255 61 52 38 255
                 79 68 46 255 69 55 33 255 61 46 28 255
                 62 46 30 255 67 50 33 255 73 59 41 255
                 80 66 44 255 77 62 38 255 66 53 34 255
                 88 65 39 255 91 69 40 255 71 59 37 255
                 61 47 34 255 91 68 43 255 87 70 42 255
                 67 56 36 255 49 40 28 255 80 59 37 255
                 91 70 41 255 88 64 38 255 90 65 37 255
                 81 58 33 255 78 54 32 255 86 58 35 255
                 93 65 37 255 93 65 37 255 97 69 38 255
                 97 71 40 255 85 64 35 255 95 67 38 255
                 98 70 39 255 94 66 38 255 91 63 36 255
                 91 64 36 255 88 62 36 255 86 60 35 255
                 90 63 37 255 91 64 37 255 90 64 37 255
                 93 66 38 255 95 69 40 255 94 67 39 255
                 98 70 41 255 96 70 40 255 95 68 39 255
                 95 68 38 255 96 69 39 255 91 66 37 255
                 75 55 33 255 76 54 34 255 86 61 36 255
                 94 67 38 255 89 64 36 255 96 68 39 255
                 103 74 43 255 96 69 39 255 99 70 39 255
                 108 78 43 255 105 76 42 255 104 75 42 255
                 103 74 42 255 101 74 41 255 103 75 43 255
                 104 76 44 255 103 76 43 255 91 65 38 255
                 95 66 38 255 105 73 41 255 110 79 45 255
                 109 80 45 255 108 80 46 255 99 73 41 255
                 93 66 38 255 89 63 38 255 85 62 37 255
                 80 58 37 255 87 63 39 255 92 66 39 255
                 89 64 37 255 79 58 35 255 67 49 32 255
                 62 45 29 255 58 42 27 255 49 38 26 255
                 42 33 24 255 45 34 25 255 45 34 24 255
                 43 32 24 255 40 30 23 255 34 27 22 255
                 38 28 22 255 38 28 22 255 31 25 21 255
                 33 26 21 255 39 30 23 255 43 33 24 255
                 45 34 25 255 38 30 23 255 36 28 23 255
                 48 36 26 255 51 39 27 255 41 33 25 255
                 40 31 24 255 47 36 25 255 49 37 27 255
                 53 40 28 255 56 43 29 255 67 49 33 255
                 65 49 32 255 63 46 30 255 65 47 30 255
                 61 45 30 255 54 41 29 255 53 40 29 255
                 67 49 32 255 62 46 30 255 47 36 26 255
                 35 28 22 255 37 29 23 255 43 31 23 255
                 46 33 24 255 54 39 25 255 56 41 26 255
                 59 42 27 255 61 43 28 255 64 44 29 255
                 64 45 28 255 64 44 29 255 55 39 26 255
                 51 37 25 255 57 40 27 255 53 38 25 255
                 56 39 25 255 57 38 24 255 55 37 24 255
                 54 39 25 255 60 44 28 255 69 51 32 255
                 73 53 32 255 73 53 32 255 76 55 33 255
                 75 55 33 255 66 48 30 255 56 43 29 255
                 57 44 29 255 63 47 30 255 63 48 31 255
                 61 47 31 255 63 48 31 255 75 56 35 255
                 73 56 36 255 80 58 36 255 96 68 37 255
                 104 73 39 255 103 73 39 255 100 71 38 255
                 98 68 37 255 100 70 38 255 103 73 39 255
                 105 75 40 255 107 80 45 255 113 90 55 255
                 117 95 58 255 113 88 52 255 110 82 46 255
                 106 77 42 255 110 79 42 255 113 83 44 255
                 105 77 40 255 98 69 37 255 95 67 36 255
                 92 65 35 255 96 68 37 255 94 68 38 255
                 88 63 36 255 89 63 36 255 92 66 38 255
                 97 70 40 255 103 74 41 255 103 74 41 255
                 103 73 41 255 100 73 44 255 109 86 58 255
                 115 96 59 255 112 86 48 255 122 93 51 255
                 125 96 51 255 117 89 48 255 95 71 38 255
                 85 63 36 255 51 45 29 255 19 21 18 255
                 31 25 21 255 49 38 25 255 52 40 26 255
                 70 49 29 255 83 57 31 255 72 51 28 255
                 58 42 25 255 54 41 28 255 41 35 26 255
                 17 18 18 255 21 18 19 255 27 26 21 255
                 31 26 23 255 66 53 38 255 70 58 40 255
                 88 67 42 255 83 65 39 255 97 77 49 255
                 109 94 62 255 112 99 66 255 113 101 67 255
                 112 101 67 255 105 93 62 255 97 84 57 255
                 86 73 48 255 66 57 34 255 22 23 19 255
                 31 26 23 255 28 27 24 255 49 37 29 255
                 55 45 30 255 43 35 27 255 29 28 23 255
                 48 38 30 255 37 35 25 255 67 49 32 255
                 100 74 44 255 105 79 46 255 96 76 44 255
                 88 68 41 255 101 75 41 255 102 75 41 255
                 101 76 41 255 89 70 38 255 75 59 34 255
                 64 52 33 255 83 62 36 255 73 59 34 255
                 31 29 23 255 58 43 31 255 72 55 34 255
                 72 55 34 255 73 54 33 255 62 48 31 255
                 49 40 28 255 41 36 26 255 39 35 26 255
                 40 35 25 255 46 37 26 255 58 44 30 255
                 69 52 33 255 58 49 30 255 21 24 21 255
                 40 34 29 255 71 61 42 255 69 55 34 255
                 80 59 35 255 79 58 35 255 74 55 34 255
                 75 60 39 255 77 64 42 255 58 50 32 255
                 35 33 26 255 61 48 33 255 76 58 37 255
                 45 40 29 255 56 41 33 255 92 72 47 255
                 77 64 40 255 62 51 33 255 67 52 32 255
                 88 66 39 255 88 68 38 255 91 65 37 255
                 99 69 39 255 92 66 36 255 86 59 33 255
                 89 60 35 255 94 66 37 255 92 65 36 255
                 97 68 39 255 104 76 43 255 101 75 40 255
                 105 75 41 255 105 77 42 255 98 70 39 255
                 93 65 36 255 96 66 37 255 94 67 37 255
                 86 61 35 255 89 63 35 255 87 63 37 255
                 82 59 36 255 87 62 36 255 93 66 39 255
                 95 67 38 255 95 68 39 255 91 66 37 255
                 95 67 38 255 95 68 38 255 94 68 39 255
                 84 62 36 255 71 53 33 255 64 47 31 255
                 78 54 35 255 94 68 39 255 85 62 35 255
                 86 61 36 255 100 71 41 255 102 73 40 255
                 105 76 42 255 105 77 43 255 102 73 40 255
                 104 73 41 255 98 70 39 255 98 70 40 255
                 96 70 39 255 96 67 39 255 106 77 44 255
                 103 76 42 255 100 72 40 255 104 75 42 255
                 102 73 41 255 100 71 40 255 104 75 43 255
                 98 72 41 255 96 69 38 255 75 52 35 255
                 78 55 34 255 80 58 35 255 83 60 36 255
                 86 61 37 255 84 61 36 255 82 60 35 255
                 73 53 32 255 65 46 30 255 61 45 28 255
                 48 37 25 255 41 32 24 255 42 32 25 255
                 46 35 25 255 46 35 25 255 41 32 24 255
                 35 28 23 255 36 27 22 255 32 25 21 255
                 30 24 20 255 24 20 18 255 27 22 21 255
                 38 30 24 255 44 34 25 255 34 28 22 255
                 28 23 21 255 36 28 23 255 38 29 23 255
                 31 26 21 255 39 30 24 255 51 39 27 255
                 52 39 27 255 52 39 28 255 57 43 29 255
                 64 47 31 255 57 44 30 255 54 41 30 255
                 61 44 29 255 62 43 28 255 59 42 27 255
                 44 34 24 255 58 43 30 255 62 48 30 255
                 48 36 26 255 44 33 24 255 47 35 25 255
                 50 37 25 255 46 33 24 255 56 40 27 255
                 61 45 28 255 62 45 28 255 59 43 28 255
                 66 47 30 255 66 47 29 255 70 49 30 255
                 67 49 28 255 55 40 25 255 51 37 25 255
                 51 35 24 255 55 38 24 255 57 39 24 255
                 54 38 24 255 63 47 29 255 64 49 31 255
                 71 52 33 255 75 55 33 255 76 55 32 255
                 75 55 33 255 71 53 32 255 65 47 29 255
                 58 43 29 255 59 44 29 255 65 49 31 255
                 61 47 30 255 64 47 31 255 72 54 34 255
                 74 56 35 255 80 60 36 255 94 66 38 255
                 103 72 41 255 105 75 42 255 104 75 40 255
                 101 72 39 255 97 69 36 255 97 68 37 255
                 106 78 43 255 112 88 51 255 115 93 58 255
                 116 92 55 255 113 86 49 255 108 79 43 255
                 107 77 41 255 106 76 40 255 112 80 41 255
                 111 81 42 255 103 74 39 255 99 70 37 255
                 100 71 38 255 96 67 36 255 95 68 37 255
                 88 63 36 255 82 58 35 255 84 59 34 255
                 89 63 36 255 94 66 37 255 105 75 42 255
)"
        R"(                 107 77 42 255 106 76 42 255 98 70 40 255
                 101 74 47 255 114 91 59 255 122 99 59 255
                 127 101 57 255 130 103 57 255 117 91 48 255
                 97 73 38 255 74 58 33 255 30 29 22 255
                 15 14 16 255 35 28 22 255 37 32 23 255
                 35 30 23 255 55 40 26 255 69 51 30 255
                 58 45 28 255 49 41 27 255 26 26 21 255
                 20 19 19 255 18 17 19 255 39 33 27 255
                 52 47 32 255 67 54 36 255 68 59 36 255
                 35 33 26 255 75 56 40 255 100 80 53 255
                 109 93 63 255 115 101 67 255 114 102 67 255
                 109 98 66 255 102 92 62 255 82 75 50 255
                 51 48 36 255 50 41 33 255 65 51 32 255
                 38 33 21 255 24 23 19 255 15 15 17 255
                 43 31 25 255 58 46 29 255 42 37 26 255
                 28 28 21 255 24 22 22 255 38 29 23 255
                 81 58 36 255 95 71 41 255 95 71 41 255
                 79 63 37 255 69 52 33 255 96 71 42 255
                 100 75 42 255 98 72 41 255 89 67 38 255
                 77 60 36 255 48 41 28 255 73 53 34 255
                 66 54 31 255 32 30 22 255 52 41 29 255
                 53 43 29 255 52 41 28 255 60 45 30 255
                 64 49 32 255 55 44 29 255 46 39 26 255
                 42 36 26 255 45 37 26 255 51 40 27 255
                 61 46 30 255 76 56 34 255 63 53 31 255
                 27 26 20 255 54 42 33 255 68 62 42 255
                 38 35 27 255 70 53 34 255 80 63 36 255
                 63 51 32 255 75 61 40 255 69 60 39 255
                 42 40 28 255 26 27 23 255 33 29 26 255
                 58 46 33 255 52 44 28 255 61 47 32 255
                 74 57 38 255 63 52 34 255 60 48 32 255
                 66 51 33 255 87 63 38 255 92 68 38 255
                 100 72 39 255 105 75 40 255 103 73 40 255
                 96 67 36 255 91 62 34 255 92 65 36 255
                 89 63 36 255 95 68 39 255 102 75 43 255
                 97 71 38 255 101 72 40 255 100 73 43 255
                 98 72 42 255 97 68 38 255 100 71 40 255
                 98 70 39 255 92 65 37 255 91 64 36 255
                 82 59 35 255 80 58 35 255 88 63 36 255
                 93 66 38 255 97 68 38 255 96 69 38 255
                 95 67 38 255 100 71 41 255 99 71 40 255
                 95 69 39 255 82 61 35 255 71 52 32 255
                 73 52 32 255 81 58 34 255 92 66 39 255
                 93 68 38 255 94 66 37 255 106 75 43 255
                 110 81 44 255 106 77 42 255 103 74 42 255
                 104 75 41 255 108 78 42 255 105 76 41 255
                 105 77 41 255 99 71 38 255 100 69 39 255
                 108 78 43 255 110 80 44 255 104 76 43 255
                 98 70 39 255 98 68 38 255 101 71 40 255
                 104 75 42 255 102 73 41 255 102 75 43 255
                 67 48 31 255 71 50 33 255 80 57 36 255
                 81 58 36 255 81 58 35 255 80 58 35 255
                 77 56 34 255 72 52 33 255 68 49 31 255
                 64 46 30 255 56 42 27 255 46 34 24 255
                 38 29 23 255 40 31 23 255 41 31 24 255
                 37 29 23 255 32 26 22 255 35 26 21 255
                 35 27 22 255 36 27 21 255 29 24 19 255
                 28 23 20 255 34 27 22 255 32 27 22 255
                 24 21 20 255 27 22 20 255 38 28 23 255
                 42 31 23 255 36 28 22 255 36 28 23 255
                 43 32 25 255 51 39 27 255 51 39 27 255
                 55 41 29 255 59 44 30 255 49 38 26 255
                 49 36 26 255 62 44 28 255 65 45 28 255
                 64 45 28 255 54 40 25 255 51 38 26 255
                 55 41 27 255 54 41 26 255 54 39 27 255
                 56 40 26 255 56 39 26 255 51 37 25 255
                 52 37 25 255 58 42 26 255 59 44 27 255
                 60 43 28 255 66 47 29 255 64 46 28 255
                 67 48 30 255 69 50 29 255 59 43 26 255
                 56 39 25 255 56 39 24 255 53 37 24 255
                 56 40 25 255 68 49 30 255 67 51 31 255
                 66 49 31 255 71 52 33 255 75 55 33 255
                 78 57 32 255 80 57 33 255 76 56 32 255
                 73 53 32 255 72 53 32 255 70 52 31 255
                 77 56 32 255 67 51 30 255 69 51 33 255
                 76 57 36 255 82 61 36 255 89 65 36 255
                 96 68 38 255 101 72 40 255 105 75 40 255
                 104 74 40 255 101 72 39 255 102 75 41 255
                 106 80 45 255 113 91 54 255 114 92 55 255
                 112 86 51 255 112 83 46 255 111 82 43 255
                 109 79 42 255 109 79 40 255 111 80 42 255
                 115 84 44 255 111 81 41 255 106 75 39 255
                 104 74 39 255 105 75 39 255 102 72 39 255
                 102 73 39 255 98 70 37 255 94 66 36 255
                 90 64 35 255 90 64 35 255 96 67 37 255
                 106 75 40 255 107 77 41 255 107 77 42 255
                 102 74 40 255 100 72 41 255 106 81 50 255
                 119 96 62 255 123 100 60 255 125 98 56 255
                 116 90 48 255 95 72 39 255 52 45 28 255
                 18 19 17 255 14 14 16 255 27 23 20 255
                 23 22 19 255 29 24 21 255 56 42 27 255
                 42 37 26 255 31 27 22 255 25 24 21 255
                 21 18 19 255 49 39 29 255 62 53 35 255
                 78 66 43 255 71 63 39 255 53 46 33 255
                 59 51 34 255 50 43 31 255 90 75 52 255
                 107 92 64 255 113 99 67 255 114 101 67 255
                 108 97 64 255 93 85 59 255 64 62 45 255
                 34 34 29 255 16 18 20 255 25 20 21 255
                 66 47 32 255 63 50 30 255 38 34 23 255
                 19 19 17 255 38 30 24 255 50 42 28 255
                 32 29 22 255 26 26 21 255 23 19 19 255
                 57 42 28 255 72 54 33 255 83 62 38 255
                 90 67 40 255 84 65 38 255 74 58 35 255
                 83 63 38 255 91 69 39 255 96 70 39 255
                 98 71 40 255 92 70 39 255 75 58 33 255
                 76 58 34 255 51 45 29 255 23 25 21 255
                 40 32 26 255 43 36 26 255 43 35 26 255
                 52 40 28 255 67 50 33 255 66 51 32 255
                 58 46 30 255 52 42 28 255 49 40 28 255
                 57 44 29 255 73 54 33 255 86 63 36 255
                 81 64 36 255 64 52 31 255 74 57 37 255
                 74 65 43 255 28 31 23 255 37 30 25 255
                 70 55 36 255 54 46 30 255 71 60 41 255
                 62 56 37 255 43 38 27 255 34 33 24 255
                 22 22 22 255 52 40 31 255 68 53 34 255
                 69 54 34 255 72 57 36 255 64 54 35 255
                 62 51 34 255 68 53 35 255 80 59 36 255
                 93 66 38 255 107 77 42 255 109 79 43 255
                 109 79 42 255 100 73 38 255 91 63 34 255
                 92 65 36 255 89 64 36 255 93 66 38 255
                 96 70 40 255 93 67 37 255 96 69 38 255
                 90 64 36 255 94 66 38 255 97 68 37 255
                 96 68 38 255 96 68 38 255 94 66 38 255
                 90 64 37 255 80 57 34 255 79 56 34 255
                 87 62 37 255 90 65 37 255 98 69 39 255
                 98 69 38 255 97 68 38 255 99 70 41 255
                 94 67 38 255 89 65 38 255 81 59 35 255
                 83 59 34 255 88 62 35 255 87 62 36 255
                 94 66 37 255 104 76 41 255 104 76 41 255
                 111 82 46 255 108 80 44 255 100 73 41 255
                 94 68 38 255 93 67 39 255 98 71 41 255
                 96 71 40 255 100 73 40 255 99 71 39 255
                 107 77 42 255 111 82 45 255 111 81 44 255
                 107 78 42 255 101 72 40 255 100 71 40 255
                 100 71 40 255 98 71 40 255 97 70 39 255
                 96 69 40 255 57 42 28 255 56 42 29 255
                 69 50 33 255 73 53 35 255 73 54 34 255
                 72 53 34 255 73 53 34 255 72 52 34 255
                 67 49 31 255 61 44 29 255 60 44 28 255
                 48 36 25 255 40 31 23 255 40 30 24 255
                 38 29 23 255 35 27 22 255 31 25 21 255
                 37 27 23 255 45 33 24 255 45 33 23 255
                 46 35 24 255 44 34 24 255 40 31 23 255
                 27 23 19 255 24 21 19 255 34 27 22 255
                 47 34 25 255 54 40 27 255 52 39 25 255
                 45 34 24 255 43 33 24 255 51 38 26 255
                 51 39 27 255 50 38 28 255 52 39 28 255
                 46 36 26 255 45 34 25 255 57 41 27 255
                 63 43 28 255 59 42 27 255 49 37 25 255
                 56 39 25 255 64 44 26 255 68 47 28 255
                 68 48 29 255 59 43 26 255 59 42 26 255
                 57 40 27 255 58 40 26 255 54 39 26 255
                 54 40 25 255 60 43 27 255 60 43 28 255
                 58 42 27 255 59 42 27 255 62 43 27 255
                 59 42 25 255 56 40 25 255 52 37 24 255
                 57 42 27 255 71 51 31 255 71 52 33 255
                 69 51 31 255 69 51 31 255 73 53 32 255
                 79 57 33 255 83 59 33 255 87 61 35 255
                 85 61 34 255 86 61 34 255 90 64 35 255
                 95 67 37 255 96 70 37 255 83 62 34 255
                 78 59 35 255 86 63 37 255 91 66 37 255
                 91 66 36 255 97 68 38 255 100 71 40 255
                 103 74 41 255 101 74 40 255 103 77 43 255
                 110 89 51 255 114 93 56 255 113 91 53 255
                 111 85 47 255 109 79 44 255 109 79 43 255
                 110 79 42 255 112 81 42 255 111 80 41 255
                 113 81 44 255 113 83 44 255 109 78 41 255
                 106 76 41 255 106 75 41 255 108 78 41 255
                 107 76 41 255 108 77 42 255 106 77 42 255
                 103 74 41 255 98 70 38 255 94 66 36 255
                 98 69 37 255 104 74 38 255 104 74 39 255
                 105 73 40 255 110 79 42 255 105 76 41 255
                 104 77 44 255 109 85 54 255 118 99 62 255
                 120 98 57 255 113 88 48 255 92 72 39 255
                 38 38 24 255 15 18 17 255 11 11 14 255
                 13 13 16 255 14 14 17 255 35 27 23 255
                 53 43 29 255 22 23 20 255 15 16 19 255
                 15 16 19 255 38 30 27 255 83 68 48 255
                 95 79 50 255 91 74 44 255 59 54 33 255
                 31 29 24 255 65 54 38 255 91 78 54 255
                 106 94 65 255 111 99 69 255 111 100 69 255
                 106 94 63 255 87 80 54 255 45 47 37 255
                 19 22 22 255 11 12 16 255 10 10 15 255
                 29 22 21 255 54 42 30 255 43 36 26 255
                 31 26 22 255 24 22 19 255 36 29 24 255
                 38 32 24 255 54 41 27 255 55 44 27 255
                 56 42 26 255 70 52 32 255 69 52 32 255
                 80 59 35 255 85 64 38 255 72 58 35 255
                 40 37 27 255 56 43 32 255 80 61 38 255
                 87 64 37 255 96 69 39 255 99 73 41 255
                 96 72 40 255 79 62 35 255 35 36 25 255
                 22 22 20 255 40 33 26 255 42 35 26 255
                 43 36 26 255 50 39 27 255 72 52 33 255
                 81 59 35 255 76 57 34 255 65 51 31 255
                 54 42 28 255 57 46 32 255 74 56 36 255
                 86 65 38 255 59 51 32 255 50 40 29 255
                 76 57 36 255 76 65 43 255 28 31 24 255
                 38 30 25 255 75 60 39 255 72 62 41 255
                 77 67 45 255 64 59 38 255 56 46 31 255
                 53 47 30 255 37 31 24 255 71 54 35 255
                 82 64 37 255 80 61 37 255 65 54 36 255
                 58 48 34 255 63 52 34 255 67 54 35 255
                 59 48 32 255 88 62 38 255 107 77 42 255
                 109 78 43 255 111 80 44 255 103 75 39 255
                 91 65 35 255 77 58 34 255 67 49 32 255
                 85 58 35 255 86 62 36 255 86 64 38 255
                 90 66 38 255 88 62 35 255 92 66 38 255
                 97 69 39 255 95 68 38 255 93 67 38 255
                 92 65 37 255 89 62 37 255 91 65 37 255
                 89 64 37 255 82 59 36 255 84 59 36 255
                 94 66 38 255 93 65 37 255 96 67 37 255
                 96 69 39 255 92 67 38 255 83 62 37 255
                 81 59 35 255 86 61 35 255 97 68 39 255
                 103 74 41 255 110 80 44 255 106 81 44 255
                 95 71 41 255 86 65 39 255 76 56 35 255
                 69 50 34 255 63 46 31 255 62 44 31 255
                 64 47 31 255 68 49 32 255 74 54 34 255
                 85 61 38 255 99 72 43 255 102 75 44 255
                 108 78 44 255 109 81 44 255 107 78 43 255
                 103 73 42 255 100 73 41 255 94 68 38 255
                 90 65 37 255 92 65 37 255 56 40 27 255
                 57 41 28 255 64 46 30 255 62 46 30 255
                 68 50 32 255 71 52 33 255 75 53 34 255
                 77 56 35 255 74 54 33 255 65 49 29 255
                 57 43 27 255 44 33 24 255 42 31 24 255
                 41 31 23 255 38 29 22 255 38 29 22 255
                 31 25 21 255 31 25 22 255 38 29 23 255
                 42 32 24 255 46 35 25 255 45 35 25 255
                 37 30 22 255 31 25 20 255 31 25 21 255
                 45 33 25 255 51 38 27 255 54 40 28 255
                 55 42 28 255 47 36 25 255 40 31 23 255
                 52 38 27 255 50 38 27 255 47 36 26 255
                 50 38 27 255 46 36 25 255 43 32 24 255
                 47 34 25 255 48 35 25 255 46 35 25 255
                 48 36 23 255 70 47 27 255 77 52 28 255
                 75 52 29 255 75 52 31 255 60 43 27 255
                 57 41 26 255 58 41 26 255 58 41 28 255
                 53 39 26 255 50 38 25 255 51 38 26 255
                 50 37 25 255 49 35 24 255 54 37 25 255
                 57 39 24 255 56 39 24 255 54 39 24 255
                 60 43 26 255 67 50 30 255 64 50 31 255
                 63 47 31 255 66 49 31 255 76 54 33 255
                 80 58 34 255 81 59 33 255 89 63 34 255
                 95 67 36 255 97 69 37 255 100 70 38 255
                 103 73 40 255 102 73 41 255 95 69 38 255
                 87 65 37 255 89 65 38 255 97 70 40 255
                 102 73 41 255 101 73 40 255 99 71 39 255
                 101 72 41 255 105 77 45 255 109 86 51 255
                 111 90 52 255 111 88 51 255 109 82 46 255
                 105 78 42 255 106 77 41 255 107 76 41 255
                 110 79 42 255 111 80 43 255 113 83 44 255
                 113 83 43 255 110 80 43 255 110 79 41 255
                 108 78 40 255 105 75 41 255 106 76 41 255
                 108 77 41 255 109 77 42 255 109 78 42 255
                 108 79 43 255 106 76 41 255 105 75 39 255
                 104 74 40 255 103 72 38 255 101 72 38 255
                 104 74 40 255 106 74 40 255 114 82 44 255
                 117 87 46 255 117 88 47 255 110 83 47 255
                 112 89 57 255 118 99 61 255 113 93 51 255
                 83 70 38 255 27 29 21 255 12 14 16 255
                 11 12 15 255 13 14 17 255 13 14 18 255
                 25 20 22 255 33 30 25 255 14 15 17 255
                 13 13 17 255 24 23 22 255 64 51 39 255
                 89 73 47 255 86 69 41 255 73 60 37 255
                 69 58 35 255 66 56 37 255 93 80 54 255
                 105 93 63 255 109 98 67 255 107 96 67 255
                 96 88 61 255 79 75 51 255 46 47 34 255
                 14 17 18 255 9 10 14 255 9 9 13 255
                 14 11 15 255 28 23 21 255 19 19 19 255
                 16 15 17 255 35 27 22 255 49 41 26 255
                 33 31 24 255 45 36 26 255 64 48 31 255
                 73 55 35 255 80 60 36 255 80 59 34 255
                 79 58 33 255 87 63 36 255 85 65 37 255
                 76 59 34 255 59 48 29 255 71 53 33 255
                 83 62 37 255 82 60 34 255 97 71 38 255
                 100 73 40 255 91 69 39 255 69 56 34 255
                 25 27 21 255 33 28 23 255 46 39 27 255
                 44 37 27 255 49 39 27 255 57 43 29 255
                 79 56 35 255 92 67 38 255 88 65 37 255
                 80 60 35 255 59 50 31 255 28 28 23 255
                 48 38 30 255 74 57 36 255 50 44 27 255
                 54 40 27 255 78 59 37 255 79 65 44 255
                 59 55 36 255 56 51 36 255 62 55 40 255
                 72 59 41 255 79 67 46 255 81 71 47 255
                 78 68 45 255 77 67 43 255 70 61 39 255
                 79 67 44 255 85 69 45 255 86 69 42 255
                 68 56 35 255 59 48 32 255 62 50 33 255
                 71 54 35 255 57 45 29 255 90 63 38 255
)"
        R"(                 107 78 43 255 106 76 42 255 107 77 42 255
                 101 74 41 255 77 61 35 255 41 35 25 255
                 39 28 22 255 76 51 31 255 56 44 29 255
                 41 35 27 255 69 49 32 255 79 56 33 255
                 87 61 37 255 96 68 40 255 97 69 39 255
                 94 67 37 255 91 65 37 255 88 62 36 255
                 95 68 40 255 94 67 38 255 91 65 37 255
                 92 66 37 255 90 64 37 255 89 63 37 255
                 95 67 37 255 92 65 37 255 93 68 39 255
                 87 64 37 255 89 65 37 255 98 69 39 255
                 107 76 42 255 110 81 45 255 96 72 42 255
                 78 59 37 255 70 51 32 255 73 53 32 255
                 72 53 32 255 71 52 33 255 72 53 32 255
                 75 56 33 255 75 56 32 255 77 56 33 255
                 75 55 32 255 75 54 32 255 76 55 33 255
                 70 51 32 255 74 53 34 255 82 57 36 255
                 94 67 40 255 99 72 42 255 105 76 43 255
                 105 79 42 255 101 75 40 255 98 71 39 255
                 58 41 26 255 56 41 27 255 56 40 28 255
                 55 40 28 255 62 45 30 255 70 51 33 255
                 76 55 34 255 74 54 33 255 71 52 32 255
                 67 50 31 255 53 41 27 255 42 33 24 255
                 38 30 23 255 36 28 23 255 33 26 22 255
                 34 27 22 255 32 26 21 255 30 24 21 255
                 30 24 21 255 33 25 22 255 39 30 23 255
                 41 32 23 255 37 30 23 255 30 25 21 255
                 31 25 21 255 43 33 25 255 45 35 25 255
                 49 37 27 255 53 41 28 255 48 37 26 255
                 47 36 25 255 56 41 28 255 53 40 27 255
                 48 37 27 255 51 40 28 255 51 40 26 255
                 46 34 24 255 45 34 25 255 46 35 25 255
                 47 36 24 255 61 43 25 255 75 51 28 255
                 76 51 28 255 72 50 27 255 71 49 29 255
                 63 45 28 255 55 39 26 255 54 40 25 255
                 50 38 25 255 44 34 24 255 44 33 24 255
                 44 32 23 255 44 31 23 255 46 31 22 255
                 51 34 24 255 51 36 25 255 55 38 25 255
                 66 46 28 255 69 49 30 255 59 43 27 255
                 59 44 28 255 64 47 31 255 70 51 33 255
                 76 55 33 255 77 56 32 255 79 58 33 255
                 89 64 34 255 97 68 37 255 103 73 40 255
                 104 74 39 255 103 74 41 255 97 71 39 255
                 89 65 37 255 91 66 38 255 100 73 41 255
                 106 77 42 255 107 77 41 255 103 75 40 255
                 101 73 42 255 106 82 47 255 109 88 55 255
                 112 91 55 255 110 86 49 255 103 77 43 255
  