--------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2021-present Ondrej Ille
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
-- -------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2015-2020 MIT License
-- 
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
-- 
-- Project advisors: 
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
-- 
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Memory map for: CAN_Registers
-- This file is autogenerated, DO NOT EDIT!
--------------------------------------------------------------------------------

Library ieee;
use ieee.std_logic_1164.all;

Library ctu_can_fd_tb;
use ctu_can_fd_tb.tb_reg_map_defs_pkg.all;
Library ctu_can_fd_rtl;
use ctu_can_fd_rtl.CAN_FD_register_map.all;

package can_fd_tb_register_map is


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_Control_registers_list is array (0 to 51) of t_memory_reg;

  constant Control_registers_list : t_Control_registers_list :=(

    (address   => DEVICE_ID_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000001100101011111101",
     is_implem => "00000000000000001111111111111111"),
    (address   => VERSION_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => MODE_ADR,
     size      => 16,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000001000010000",
     is_implem => "00000000000000000001111111111111"),
    (address   => SETTINGS_ADR,
     size      => 16,
     reg_type  => reg_read_write,
     reset_val => "00000010000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => STATUS_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000010000100",
     is_implem => "00000000000001110000111111111111"),
    (address   => COMMAND_ADR,
     size      => 32,
     reg_type  => reg_write_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000011111111110"),
    (address   => INT_STAT_ADR,
     size      => 16,
     reg_type  => reg_read_write_once,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000111111111111"),
    (address   => INT_ENA_SET_ADR,
     size      => 16,
     reg_type  => reg_read_write_once,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000111111111111"),
    (address   => INT_ENA_CLR_ADR,
     size      => 16,
     reg_type  => reg_write_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000111111111111"),
    (address   => INT_MASK_SET_ADR,
     size      => 16,
     reg_type  => reg_read_write_once,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000111111111111"),
    (address   => INT_MASK_CLR_ADR,
     size      => 16,
     reg_type  => reg_write_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000111111111111"),
    (address   => BTR_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00010000010100001010000110000101",
     is_implem => "11111111111111111111111111111111"),
    (address   => BTR_FD_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00010000001000000110000110000011",
     is_implem => "11111111111110111110111110111111"),
    (address   => EWL_ADR,
     size      => 8,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000001100000",
     is_implem => "00000000000000000000000011111111"),
    (address   => ERP_ADR,
     size      => 8,
     reg_type  => reg_read_write,
     reset_val => "00000000000000001000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => FAULT_STATE_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000001000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => REC_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000111111111"),
    (address   => TEC_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => ERR_NORM_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000001111111111111111"),
    (address   => ERR_FD_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => CTR_PRES_ADR,
     size      => 32,
     reg_type  => reg_write_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000001111111111111"),
    (address   => FILTER_A_MASK_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_A_VAL_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_B_MASK_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_B_VAL_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_C_MASK_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_C_VAL_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_RAN_LOW_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_RAN_HIGH_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111111111111111111111"),
    (address   => FILTER_CONTROL_ADR,
     size      => 16,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000001111",
     is_implem => "00000000000000001111111111111111"),
    (address   => FILTER_STATUS_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => RX_MEM_INFO_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00011111111111110001111111111111"),
    (address   => RX_POINTERS_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00001111111111110000111111111111"),
    (address   => RX_STATUS_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000001",
     is_implem => "00000000000000000111111111110111"),
    (address   => RX_SETTINGS_ADR,
     size      => 8,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => RX_DATA_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TX_STATUS_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "10001000100010001000100010001000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TX_COMMAND_ADR,
     size      => 16,
     reg_type  => reg_write_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000001111111100000111"),
    (address   => TXTB_INFO_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => TX_PRIORITY_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000001",
     is_implem => "01110111011101110111011101110111"),
    (address   => ERR_CAPT_ADR,
     size      => 8,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000001111",
     is_implem => "00000000000000000000000011111111"),
    (address   => RETR_CTR_ADR,
     size      => 8,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => ALC_ADR,
     size      => 8,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => TS_INFO_ADR,
     size      => 8,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => TRV_DELAY_ADR,
     size      => 16,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000001111111"),
    (address   => SSP_CFG_ADR,
     size      => 16,
     reg_type  => reg_read_write,
     reset_val => "00000000000010100000000000000000",
     is_implem => "00000000000000000000000000000000"),
    (address   => RX_FR_CTR_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TX_FR_CTR_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => DEBUG_REGISTER_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000001111111111111111111"),
    (address   => YOLO_REG_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "11011110101011011011111011101111",
     is_implem => "11111111111111111111111111111111"),
    (address   => TIMESTAMP_LOW_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TIMESTAMP_HIGH_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_1_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_1_list : t_TX_Buffer_1_list :=(

    (address   => TXTB1_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB1_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_2_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_2_list : t_TX_Buffer_2_list :=(

    (address   => TXTB2_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB2_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_3_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_3_list : t_TX_Buffer_3_list :=(

    (address   => TXTB3_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB3_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_4_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_4_list : t_TX_Buffer_4_list :=(

    (address   => TXTB4_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB4_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_5_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_5_list : t_TX_Buffer_5_list :=(

    (address   => TXTB5_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB5_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_6_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_6_list : t_TX_Buffer_6_list :=(

    (address   => TXTB6_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB6_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_7_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_7_list : t_TX_Buffer_7_list :=(

    (address   => TXTB7_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB7_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_TX_Buffer_8_list is array (0 to 20) of t_memory_reg;

  constant TX_Buffer_8_list : t_TX_Buffer_8_list :=(

    (address   => TXTB8_DATA_1_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_2_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_3_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_4_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_5_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_6_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_7_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_8_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_9_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_10_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_11_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_12_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_13_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_14_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_15_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_16_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_17_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_18_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_19_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_20_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TXTB8_DATA_21_ADR,
     size      => 32,
     reg_type  => reg_none,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );


  ------------------------------------------------------------------------------
  -- Register list
  ------------------------------------------------------------------------------

  type t_Test_registers_list is array (0 to 3) of t_memory_reg;

  constant Test_registers_list : t_Test_registers_list :=(

    (address   => TST_CONTROL_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000000000000000000000011"),
    (address   => TST_DEST_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "00000000000011111111111111111111"),
    (address   => TST_WDATA_ADR,
     size      => 32,
     reg_type  => reg_read_write,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111"),
    (address   => TST_RDATA_ADR,
     size      => 32,
     reg_type  => reg_read_only,
     reset_val => "00000000000000000000000000000000",
     is_implem => "11111111111111111111111111111111")
  );

end package;
