--------------------------------------------------------------------------------
-- 
-- Register map generation tool
--
-- Copyright (C) 2018 Ondrej Ille <ondrej.ille@gmail.com>
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this SW component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
--
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Purpose:
--  Package with types used by register map generator generated packages for TB.
--
--------------------------------------------------------------------------------
-- Revision History:
--   17.01.2020   Created file
--------------------------------------------------------------------------------
Library ieee;
use ieee.std_logic_1164.all;

package tb_reg_map_defs_pkg is

  ------------------------------------------------------------------------------
  -- Common types
  ------------------------------------------------------------------------------
  type t_reg_type is (
    reg_none,
    reg_write_only,
    reg_read_only,
    reg_read_write,
    reg_read_write_once
  );

  type t_memory_reg is record
       address       : std_logic_vector(11 downto 0);
       size                                : integer;
       reg_type                         : t_reg_type;
       reset_val     : std_logic_vector(31 downto 0);
       is_implem     : std_logic_vector(31 downto 0);
  end record;

end package;
