/*
 * Simple Virtual Machine - A versatile and robust architecture to
 * easily write applications.
 * Copyright (C) 2021  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/machine/extensions/automate_deterministe.h>
using namespace SVM::Machine::Extension;

bool AutomateDeterministe::inclus_dans(const AutomateDeterministeSP& automate) const
{
	std::set<std::pair<size_t,size_t> > etats;
	std::list<std::pair<size_t,size_t> > a_traiter = { { _initial, automate->_initial} };
	while(not a_traiter.empty())
	{
		auto e = a_traiter.back();
		a_traiter.pop_back();
		if((_final.find(e.first)!=_final.end()) and not (automate->_final.find(e.second)!=automate->_final.end()))
		{
			return false;
		}
		for(auto& l:_transitions[e.first])
		{
			RegexParametresElementCSP lc = l.first;
			for( ; static_cast<bool>(lc) ; lc = lc->joker())
			{
				auto it = automate->_transitions[e.second].find(lc);
				if(it!=automate->_transitions[e.second].end())
				{
					auto ne = std::make_pair(l.second,it->second);
					if(etats.insert(ne).second)
					{
						a_traiter.push_back(ne);
					}
					break;
				}
				if(not l.first->_modifiable)
					continue;
				it = automate->_transitions[e.second].find(lc->version_non_modifiable());
				if(it!=automate->_transitions[e.second].end())
				{
					auto ne = std::make_pair(l.second,it->second);
					if(etats.insert(ne).second)
					{
						a_traiter.push_back(ne);
					}
					break;
				}
			}
			if(not lc)
			{
				return false;
			}
		}
	}
	return true;
}

ConformiteAutomate AutomateDeterministe::conforme(const std::vector<RegexParametresElementCSP>& valeurs) const
{
	size_t etat_courant = _initial;
	size_t indice_valeur=0;
	for(auto& v: valeurs)
	{
		++indice_valeur;
		bool ok = false;
		for(RegexParametresElementCSP lettre = v ; static_cast<bool>(lettre) ; lettre=lettre->joker())
		{
			//AutomateDeterministe::chronometre_recherche_base().debut();
			auto it = _transitions[etat_courant].find(lettre);
			//AutomateDeterministe::chronometre_recherche_base().fin();
			if(it!=_transitions[etat_courant].end())
			{
				ok = true;
				etat_courant = it->second;
				break;
			}
			if(not v->_modifiable)
				continue;
			//AutomateDeterministe::chronometre_recherche_constante().debut();
			it = _transitions[etat_courant].find(lettre->version_non_modifiable());
			//AutomateDeterministe::chronometre_recherche_constante().fin();
			if(it!=_transitions[etat_courant].end())
			{
				ok = true;
				etat_courant = it->second;
				break;
			}
		}
		if(not ok)
		{
			ConformiteAutomate c(false,indice_valeur);
			for(const auto& t: _transitions[etat_courant])
			{
				c._suggestions.push_back(t.first);
			}
			if(_final.find(etat_courant)!=_final.end())
			{
				c._suggestions.push_back(std::make_shared<RegexParametresPasDeParametres>());
			}
			return c;
		}
	}
	ConformiteAutomate c(_final.find(etat_courant)!=_final.end(),indice_valeur+1);
	if(not c._conforme)
	{
		for(const auto& t: _transitions[etat_courant])
		{
			c._suggestions.push_back(t.first);
		}
		if(_final.find(etat_courant)!=_final.end())
		{
			c._suggestions.push_back(std::make_shared<RegexParametresPasDeParametres>());
		}
	}
	return c;
}
