.TH "Simple Virtual Machine - Package generator" 1 "2020-12-10"
.SH NAME
.BR svm_package
\- generates packages for SVM applications, libraries and plugins.
.SH SYNOPSIS
svm_package [-i input_file] [-o output_file] [-O] [-d] [-y flag] [-f flavor] [-l] [h] [-v]
.SH DESCRIPTION
This command produces a shell script acting as a SVM applications/libraries/plugins local installer.
.P
This installation script can be transmitted for local installations on other systems, and comes with some options presented in its own help.
.P
.I This command is suitable only for applications/libraries/plugins installed locally. For system wide applications/libraries/plugins installation, please use the distribution package manager.
.SH OPTIONS
.TP
.B -i input_file
By default, svm_package reads the package description from the standard input.
This option indicates which file to use (the file extension .svm_pkg is recommended) to get the package description.
.TP
.B -o output_file
By default, svm_package writes the installation script to the standard output.
This option indicates which file to use (the file extension .sh is recommended) to write the package installer script.
.TP
.B -O
This option behaves like the -o one with a file name set to:
.nf
<package name>-<package version>-installer.sh
.fi
.TP
.B -d
By default, the generated package is created in release mode.
In release mode, when the installer fails during its execution, it removes the target directory containing the partially installed content.
This option switches the creation in developper mode, where a failed installation is kept for investigation.
Some variables can be used to detect the mode: See Automatic variables below for more information.
.TP
.B -y flag
This option raises the corresponding named flag.
(See flags below.)
.TP
.B -f flavor
This option adds a flavor to the name of the package.
The new name is composed of <name>-<flavor>.
The option also raises the flag having the flavor as name.
.TP
.B -l
This option does not generate a package, but list all supported options and configuration names, with their arguments description.
.TP
.B -h
This option displays the help of the command.
.TP
.B -v
This option displays the version and the licence of the command.
.SH PACKAGE FILE
The package file is made of three sections:
 - A header for general package description,
 - A list of package options,
 - A list of package elements.
.P
Within the package file:
 - Comments starts by a hash (#) and ends at the end of the line,
 - Commands are always terminated by an end of line.
.SS Package header
The header always starts with the package command:
.nf

PACKAGE <package name>

.fi
This command specifies the name of the package.
.P
Then, an optional licence block can immediately follow (no line shall be present between the package and license definitions):
.nf

LICENCE
<licence text>
END

.fi
This command describes the licence and the usage of the package installer.
.SS Package options
Some options can be set at package level with this command:
.nf

OPTION <option name> <list of values>

.fi
.P
The supported option names are displayed by the option -l, please refer to its display for more information.
The values are described in the section "Values and variables" below.
.P
Options are always refering to the package itself, and is unrelated to its content. (Please refer to Package content: Configuration below for options on package content.)
.P
Flags can be used in options (See Flags below), but variables can not be used (See Values and variables below).
.SS Package content: Application
An application can be added to the package with the command:
.nf

APP	<file name>

.fi
The file name is specified without quotes, and shall be separated from the APP command name by a single space (or a single tabulation).
The specified file name can contain a relative or an absolute path to the real file on the file system.
The file will be inserted in the current package path (Please refer to the 'path' configuration on the list provided by the -l option).
.P
The installer can perform various transformations on the file (Please refer to Package content: Configuration below) and set the file as executable by the user installing the package.
.SS Package content: Library
A library (in SVM machine language) can be added to the package with the command:
.nf

LIB	<file name>

.fi
The file name is specified like in the APP command. Please refer to this command for more information.
.P
The file is inserted inside the package like in the APP command and has no specific transformations or setup.
.SS Package content: Plugin
A plugin can be added to the package with this command:
.nf

PLUGIN	<file name>

.fi
The file name is specified like in the APP command. Please refer to this command for more information.
.P
Depending on the configuration (Please refer to Package content: Configuration below), the plugin can be automatically generated and built during the installation.
.SS Package content: File
A generic file can be added to the package with the command:
.nf

FILE	<file name>

.fi
The file name is specified like in the APP command. Please refer to this command for more information.
.P
The file is inserted inside the package like in the APP command and has no specific transformations or setup.
.SS Package content: Shell code
This command inserts shell code directly inside the package installer:
.nf

SHELL
<shell code>
END

.fi
This can be used for installation customisation.
.P
Within the shell code, variables and flags can be used.
.SS Package content: Configuration
The package content installation can be altered by some dedicated configuration.
Each configuration key is associated to some arguments having a default value and some accepted types.
(The option -l also gives the possible configuration keys with the arguments.)
.P
The configuration can be controled with this command:
.nf

SET <configuration name> <list of values>

.fi
All subsequent content definitions using a modified key will use the corresponding values for their installation.
.SS Package content: Variable
A package description can use variables to avoid value replication within the file.
.P
A variable can be created or updated with the command:
.nf

VAR <variable name> <value>

.fi
.P
A variable can be read by using its name at the place of a value.
.SS Package content: Conditionals
A package conditional command can be inserted with this command:
.nf

IF <condition>

.fi
All package content commands following this IF command are enabled only if the condition is evaluated to true, until another conditional command is reached.
.P
Conditions can be composed of:
 - Flags (YES/NO variables) (See Flags below for more information);
 - Variables:
     - Integers are evaluated to false when equal to 0 and true otherwise,
     - Strings are evaluated to false when empty and true otherwise,
     - DEFAULT is always evaluated as false;
 - (<condition>) for precedence in evaluation;
 - NOT <condition> for condition negation;
 - <condition> AND <condition> for intersection evaluation;
 - <condition> OR <condition> for union evaluation;
 - <condition> XOR <condition> for difference evaluation.
.P
The following conditional command changes back the condition to true:
.nf

FI

.fi
.SS Values and variables
Options, configurations and variables use values.
When a list of values is used, each value is separated from others with spaces or tabulations.
.P
Accepted values are:
 - Integers written in decimal;
 - Strings surrounded by double-quotes (");
 - The YES boolean and the NO boolean;
 - The DEFAULT value, replaced by the real default value;
 - A variable name;
 - A string concatenation using the dot (.) as infix operator:
     - integers are converted to their decimal representation,
     - strings are kept as it,
     - YES is transformed to the string yes,
     - NO is transformed to the string no,
     - DEFAULT is transformed to the empty string.
.P
Variables are names referencing a value, and are set by the VAR command.
.SS Automatic variables
Two variables are automatically created by svm_package:
 - only_in_dev: Set to NO by default, or to YES when the -d option is present,
 - only_in_release: Set to YES by default, or to NO when the -d option is present.
 - package_flavor: Set to the empty string by default, and the flavor string when the -f option is present.
.SS Flags
Flags are variables present within conditions (even without any VAR definition) or raised with the -y command line option.
By default, flags are set to NO, and the -y option in the command line can set one of them to YES.
.P
Flags can be used in options, unlike other variables.
.SH PACKAGE FILE EXAMPLE
.nf

PACKAGE myapp
LICENCE
This program comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it under certain conditions.
See GNU GPLv3 terms for details.
END

OPTION	version "1.1"
OPTION	author "A. Nonymous"
OPTION	maintainer "A. Nonymous" "a.nonymous@somemail.com"
OPTION	svm_api_version_check only_in_release

VAR	plugin_root "plugins"
IF	only_in_release AND NOT visible_plugins
VAR	plugin_root ".".plugin_root
FI

SET	app_change_sheebang YES
SET	app_local_plugins_root plugin_root

APP	myapp.svm

LIB	list.lib.svm
LIB	toolbox.lib.svm

SET	plugin_keep_build NO
SET	plugin_check only_in_dev
SET	path plugin_root
PLUGIN	map.svm_plugin
IF	only_in_release AND hide_plugin_source
SET	plugin_remove_source YES
FI
PLUGIN	myapp.svm_plugin
SET	plugin_remove_source DEFAULT

SET	path DEFAULT
FILE	default.cfg

# Extra optional content: requires -y extra_content
IF	extra_content
APP	asidetool.svm
FI
SHELL
echo "Extra content activated: $extra_content"
END

.fi
.SH RETURN VALUES
The svm_package command returns 0 when the Simple Virtual Machine package installer has been successfully generated, and another value otherwise.
.P
.SH SEE ALSO
.BR svm (1)
.BR svm_plugin (1)
for general documentation on the Simple Virtual Machine, in particular with plugin objects usage and low-level C/C++ plugin interface.
.SH AUTHOR
The Simple Virtual Machine is designed, implemented and maintained by Julien Bruguier <===EMAILCONTACT===>.
.SH BUGS
In case of bug on the virtual machine or on a plugin delivered with it, please send an email to the address above.
Other plugins can not be covered here, so please contact preferably the author of the plugin whenever possible.
