# -*- coding: utf-8 -*-

# a helper program takes a list of unordered words and returns a sorted and counted list suitable for the "di" word list. Best run in python3 if non ASCII characters are being used.
import os
import sys

os.chdir(os.path.abspath(os.path.dirname(sys.argv[0])))

original_list = [
    "act","add","age","ago","air","all","and","any","are","art","bad","bed","big","bit","box","boy","but","buy","can","car","cat","cry","cut","day","did","dog","dry","eat","end","far","few","fig","fit","flu","fly","for","fun","gas","get","got","had","has","hat","her","him","his","hit","hot","how","ice","its","job","key","law","lay","led","let","lie","lot","low","man","map","may","men","new","nor","not","now","off","old","one","our","out","own","pay","per","pry","put","ran","red","row","run","sat","saw","say","sea","see","set","she","sir","sit","six","ski","sky","son","spy","sum","sun","ten","the","too","top","try","two","use","war","was","way","who","why","win","yes","yet","you","able","also","area","arms","army","away","baby","back","ball","bank","base","bear","beat","been","bell","best","bill","blab","blew","blip","blob","blot","blow","blue","boat","body","book","born","both","bran","brat","bray","brew","brim","busy","came","care","case","city","clad","clam","clan","clap","claw","clay","clip","clod","clog","club","clue","cold","come","cook","cool","copy","corn","cost","cows","crab","crib","crop","crow","dark","deal","deep","does","done","door","down","drab","drag","draw","drew","drip","drop","drum","each","ears","east","easy","edge","eggs","else","even","ever","eyes","face","fact","fair","fall","farm","fast","fear","feel","feet","fell","felt","find","fine","fire","fish","five","flag","flap","flat","flaw","flea","flew","flex","flip","flop","flow","food","foot","four","free","frog","from","full","game","gave","girl","give","glad","glee","glob","glow","glue","gold","gone","good","grab","gram","gray","grew","grid","grim","grin","grip","grit","grow","grub","hair","halt","hand","hard","have","head","hear","heat","held","help","here","high","hill","hold","hole","home","hope","huge","idea","into","iron","just","keep","kept","kind","king","knew","know","lady","lake","land","last","lead","left","legs","less","life","like","line","list","live","long","look","lost","loud","love","made","main","make","many","mark",
    "meet","milk","mind","mine","miss","moon","more","most","move","much","must","name","near","need","next","nose","note","noun","once","only","open","over","page","pair","park","part","past","plan","play","plod","plot","plow","plug","plum","poem","pole","poor","pray","prod","prop","race","rain","read","rest","rich","ride","ring","rise","road","rock","room","root","rope","rose","rule","safe","said","sail","same","sand","save","scab","scan","scar","scat","seat","seen","sell","send","sent","ship","shop","show","side","sign","sing","size","skid","skin","skip","skit","slab","slam","slap","sled","slid","slim","slip","slit","slot","slow","slug","smog","snag","snap","snip","snob","snow","snug","soft","soil","some","song","soon","span","spat","spin","spot","spur","star","stay","stem","step","stew","stir","stop","such","sure","swam","swan","swap","swat","sway","swim","tail","take","talk","tall","team","tell","test","than","that","them","then","they","thin","this","thus","tied","time","tiny","told","tone","took","town","trap","tray","tree","trek","trim","trip","trot","true","tube","turn","type","unit","upon","verb","very","view","wait","wall","want","warm","wash","wear","week","well","went","were","west","what","when","wide","wife","wild","will","wind","wire","wish","with","wood","work","yard","your","about","above","after","again","ahead","allow","alone","along","among","angle","apple","asked","began","being","below","birds","black","blade","blame","blank","blast","blaze","bleat","bleed","bleep","blend","bless","blind","blink","block","blood","bloom","bluff","blunt","blush","board","bones","brace","braid","brain","brake","brand","brass","brave","brawl","bread","break","brick","bride","bring","brisk","broad","broil","broke","brood","brook","broom","broth","brown","brush","build","built","carry","catch","cause","cells","cents","chart","check","child","clack","claim","clamp","clang","clash","clasp","class","clean","clear","cleat","clerk","click","cliff","climb","cling","clink","cloak","clock","clomp","close","cloth","cloud","clove","clown","cluck","clump","coast","could","count","crack","craft","crane","crash","crawl","crazy","creek","creep","cried","croak","crook","crops","cross","crowd","crown","crumb","crust","dance","draft","drain","drake","drank","drape","dread","dream","dress","drift","drill","drink","drive","droop","drove","early","earth","eight","enjoy","equal","every","field","fight","first","flake","flame","flare","flash","fleck","fleet","flesh","flick","fling","flint","float","flock","flood","floor","floss","flour","fluff","fluid","fluke","flunk","flush","flute","force","found","frail",
    "frame","frank","freak","fresh","frill","frizz","front","frost","fruit","glare","glass","gleam","glide","gloat","globe","gloom","gloss","glove","grace","grade","graft","grain","grand","grant","grape","graph","grasp","grass","grate","grave","gravy","graze","great","greed","green","greet","grill","grime","grind","groan","groom","group","growl","grown","gruff","grump","guess","happy","heard","heart","heavy","horse","hours","house","human","known","large","later","learn","least","leave","level","light","major","march","match","maybe","means","metal","might","miles","money","mouth","music","never","night","north","ocean","often","order","other","paint","paper","party","piece","place","plaid","plain","plane","plank","plant","plate","plead","pleat","plink","plump","point","power","press","price","pride","print","prize","probe","proof","proud","prove","prowl","prune","quiet","quite","radio","ready","right","river","round","scald","scale","scalp","scamp","scare","scarf","scold","scoop","scoot","scope","score","scour","scout","scram","scrap","screw","scrub","scuba","scuff","seeds","sense","serve","seven","shall","shape","sharp","shoes","short","shown","sight","since","skate","skill","skirt","skull","skunk","slack","slant","slate","sleek","sleep","sleet","slept","slice","slick","slide","slime","sling","slope","slump","slush","smack","small","smart","smash","smear","smell","smile","smock","smoke","snack","snail","snake","snare",
    "snarl","sneak","sniff","snoop","snore","snout","solve","sound","south","space","spare","spark","speak","spear","speck","speed","spell","spend","spent","spike","spill","spine","spire","split","spoil","spoke","spoon","sport","spout","spray","sprig","squat","squid","stack","staff","stage","stain","stair","stake","stale","stalk","stall","stamp","stand","stare","stars","start","state","steak","steal","steam","steel","steep","steer","stick","stiff","still","stilt","sting","stink","stock","stone","stood","stool","stoop","store","storm","story","stove","strap","straw","stray","strip","strum","study","style","sugar","swamp","swarm","sweat","sweep","sweet","swell","swept","swift","swine","swing","swish","swoop","table","terms","their","there","these","thick","thing","think","third","those","three","today","tools","total","touch","trace","track","trade","trail","train","tramp","trash","tread","treat","trees","tribe","trick","troll","tromp","troop","trout","truck","truly","trunk","trust","truth","uncle","under","until","value","visit","voice","vowel","watch","water","waves","where","which","while","white","whole","whose","wings","woman","women","words","world","would","write","wrong","wrote","years","young","across","action","afraid","agreed","almost","always","amount","answer","appear","around","became","become","before","behind","belong","beside","better","bleach","blonde","blouse","bottom","bought","braise","branch","breath","breeze","bridge","bright","broken","bronco","bronze","browse","bruise","called","cannot","cattle","caught","centre","chance","change","choose","church","circle","closet","clutch","colour","column","common","corner","cotton","course","cradle","crayon","create","crunch","desert","design","direct","doctor","dragon","during","effect","either","energy","engine","enough","entire","except","expect","family","famous","father","figure","filled","flight","flower","forest","freeze","friend","fright","fringe","frozen","garden","glance","glitch","grapes","grease","grouch","ground","grudge","inches","inside","island","itself","joined","jumped","killed","length","lifted","listen","little","matter","melody","method","middle","modern","moment","months","mother","nation","notice","number","object","office","oxygen","passed","people","period","person","phrase", "picked","plains","planet","plants","player","please","pledge","plenty","plural","pounds","praise","prance","prayer","pretty","priest","prince","prison","pulled","pushed","raised","rather","really","reason","record","region","remain","report","result","return","rhythm","rolled","scarce","school",
    "scorch","scrape","scrawl","scream","screen","script","scroll","second","seemed","should","silent","simple","single","sister","sketch","sleepy","sleeve","slight","slowly","smiled","smooth","smudge","snatch","sneeze","speech","spirit","splash","splint","sponge","sprain","sprang","sprawl","spread","spring","sprint","sprout","spruce","square","squash","squeak","squeal","squint","squirm","squirt","squish","stable","staple","starch","starve","statue","steady","stereo","sticky","stingy","stitch","strain","strand","streak","stream","street","strict","stride","strike","string","stripe","stroke","stroll","strong","struck","suffix","summer","supply","swatch","swerve","switch","system","though","toward","travel","trough","valley","walked","weight","wheels","window","winter","within","wonder","yellow","against","already","animals","another","arrived","because","believe","between","blanket","blossom","brother","brought","burning","capital","captain","century","certain","climate","climbed","clothes","company","compare","contain","control","correct","country","covered","cricket","current","decided","decimal","details","distant","divided","dollars","drawing","entered","evening","exactly","example","explain","express","factors","farmers","feeling","finally","fingers","flowers","forward","freight","friends","general","gravity","himself","history","however","hundred","hunting","include","insects","instead","laughed","letters","located","machine","measure","members","million","minutes","morning","natural","nothing","numeral","observe","outside","pattern","perhaps","picture","planets","prepare","present","pretzel","printed","problem","process","produce","product","program","project","promise","pronoun","protect","provide","quickly","reached","scallop","science","scooter","scraper","scratch","screech","section","settled","several","shouted","similar","skillet","slipper","snuggle","someone","special","squeeze","stadium","stapler","started","station","stirrup","stomach","strange","stretch","subject","suppose","surface","swallow","sweater","sweeten","swollen","symbols","teacher","thought","through","trouble","trumpet","usually","various","village","weather","western","whether","without","workers","written","actually","addition","although","anything","blizzard","branches","building","business","children","clothing","complete","compound","consider","describe","division","electric","elements","equation","everyone","exciting","exercise","finished","fraction","freckles","happened","increase","indicate","industry","interest","language",
    "material","movement","northern","opposite","pleasant","position","possible","practice","practise","precious","prepared","princess","prisoner","probably","products","property","received","remember","repeated","scallion","scramble","scribble","sentence","separate","shoulder","soldiers","solution","southern","splendid","splinter","sprinkle","squirrel","starfish","stocking","straight","strainer","stranger","strength","stronger","struggle","students","suddenly","surprise","together","triangle","yourself","adjective","beautiful","beginning","carefully","consonant","continued","determine","developed","different","difficult","direction","factories","following","groceries","important","molecules","mountains","necessary","paragraph","president","principal","professor","pronounce","propeller","questions","represent","something","sometimes","sprinkler","statement","stretched","stretcher","suggested","syllables","thousands","underline","blackboard","conditions","dictionary","difference","discovered","especially","everything","experience","experiment","flashlight","government","particular","scientists","stationary","strawberry","substances","themselves","understand"
]
translated_list_of_words = [
"agera","lägg till","ålder","sedan","luft","alla","och","alla","är","konst","dålig","säng","stor","bit","låda","pojke","men","köp","kan","bil","katt"," gråta","klippte","dag","gjorde","hund","torr","ät","slut","långt","få","fikon","pass","influensa","fluga","för","kul","gas","få","fick","hade","har","h vid","henne","honom","hans","hit","hot","hur","is","dess","jobb","nyckel","lag","låg","led","låt","ljug","lott","låg","man","karta","kan","inte","inte","nu","av","gammal","en","vår","ut","egen","betala","per","bända","sätta","sprang","röd","rad","kör","satt","såg","säg ","hav","se","set","hon","sir","sit","sex","ski","sky","son","spion","summa","sol","tio","den","för","top","försök","två","använd","krig" "var","sätt","vem","varför","vinner","ja","ännu","du","kan","också","område","armar","armé","borta","bebis","tillbaka","boll","bank","bas"," björn","beat","varit","klocka","bäst","bill","blab","blåste","blip","blob","blot","blow","blå","båt","kropp","bok","född","båda","b sprang","brat","bray","brew","brim","upptagen","kom","vård","case","stad","klädd","mussla","klan","klapp","klo","lera","klipp","klump","clo g","klubb","ledtråd","kall","kom","laga","cool","kopia","majs","kostnad","kor","krabba","spjälsäng","gröda","kråka","mörk","deal","djup","gör ","klar","dörr","ner","drab","dra","draw","draw","dropp","drop","trumma","varje","öron","öst","lätt","kant","ägg","annat","jämn" "någonsin","ögon","ansikte","faktum","rättvist","fall","gård","snabb","rädsla","känn","fötter","föll","kände","hitta","bra","eld","fisk","fem", "flagga","klaff","platt","fel","loppa","flög","flex","flip","flopp","flöde","mat","fot","fyra","gratis","groda","från","full","spel","g ave","tjej","ge","glad","glee","glob","glöd","lim","guld","borta","bra","grab","gram","grå","växte","grid","grim","grin","gr ip","grit","väx","grub","hår","halt","hand","hård","har","huvud","hör","värme","håll","hjälp","här","hög","backe","håll","hol e","hem","hopp","enormt","idé","in","järn","bara","behåll","hålls","snäll","kung","visste","vet","dam","sjö","land","sista","leda ","vänster","ben","mindre","liv","gilla","linje","lista","live","lång","look","förlorad","högt","kärlek","gjord","huvud","make","många","markera",
"träffa","mjölk","sinne","min","miss","måne","mer","mest","flytta","mycket","måste","namn","nära","behöver","nästa","näsa","notera","substantiv","en gång","bara","öppna","över","sida","pa ir","park","del","förflutna","plan","lek","plod","plot","plog","plugg","plommon","dikt","stång","fattig","be","prod","prop","lopp","regn","läs","vila","rik","ride","ring" "stiga","väg","rock","rum","rot","rep","ros","regel","säkert","sägt","segel","samma","sand","spara","skorpor","skanna","ärr","scat","säte","sett","sälj","skicka","skickad","s hip","shop","show","side","skylt","sing","size","skid","skin","skip","skit","slab","slam","slap","sled","slid","slim","slip","slit","slot","slow","slug","smog","snag" "snap","snip","snobb","snö","snäll","mjuk","jord","någon","låt","snart","span","spat","snurra","fläck","sporre","stjärna","stay","stam","steg","gryta","röra","stopp","sådan","s ure","simmade","svan","byta","swat","gunga","simma","svans","ta","prata","hög","lag","berätta","testa","än","att","dem","då","de","tunna","detta","sålunda","knut","tid","liten","berättade","ton","tog","stad","fälla","bricka","träd","trek","trimma","tur","trav","sant","rör","sväng","typ","enhet","på","verb","mycket","se","vänta","vägg"," vill","varm","tvätt","bär","vecka","väl","gick","var","väst","vad","när","bred","fru","vild","vil","vind","tråd","önske","med","trä","arbete","gård","din","abou t","ovan","efter","igen","framåt","tillåt","ensam","med","bland","vinkel","äpple","frågade","började","vara","under","fåglar","svart","blad","skylla","tom","spränga"," blaze","bleat","bleed","bleep","blend","bless","blind","blink","block","blod","bloom","bluff","blunt","blush","board","bones","brace","fläta","hjärna","broms","mässing","modig","bråk","bröd","bryt","tegel","brud","bring","brisk","bred","broil","bröt","brood","bäck","kvast","buljong","brun","borste","bygga","byggd"," bära","fånga","orsak","celler","cent","diagram","check","barn","clack","claim","clamp","clang","clash","clasp","klass","ren","rensa","cleat","clerk","click","cliff","klättra","klänga","klinka","kappa","klocka","klumpa","stänga","tyg","moln","nejlika","clown","klack","klump","kust","kunde","räkna","spricka","hantverk","kran","krasch","c rawla","galen","bäck","krypa","grät","krök","skurk","grödor","kors","publik","krona","smula","skorpa","dans","drag","avlopp","drake","drack","drapera","dread","dröm" "klänning","drift","borr","drink","kör","droop","körde","tidigt","jorden","åtta","njut","lika","varje","fält","kamp","först","flake","flame","flare","flash","fl eck","flotta","kött","snärta","slänga","flint","flotta","flock","flod","golv","floss","mjöl","fluff","vätska","fluke","flunk","flush","flöjt","kraft","hittad","bräcklig",
"frame","frank","freak","fresh","frill","frizz","front","frost","frukt","glare","glas","gleam","glide","gloat","globe","groom","gloss","glove","grace","grade","graft","grain","gra nd","grant","druva","graf","gräs","gräs","grill","grav","sås","beta","stor","girighet","grön","hälsa","grill","grime","mala","stöna","brudgum","grupp","brumma","vuxen","gruff", "grump","gissa","glad","hört","hjärta","tung","häst","timmar","hus","människa","känd","stor","senare","lär dig","minst","lämna","nivå","lätt","stor","marsch","match","kanske","metall","might","miles","pengar","mun","musik","aldrig","natt","nord","hav","ofta","order","annat","färg","papper","fest","pjäs","plats","pläd","vanlig","plan","planka", "planta","plåt","plead","veck","plink","plump","point","power","press","pris","pride","print","pris","probe","proof","stolt","bevisa","prowl","prune","tyst","ganska","radio","höger","flod","rund","skålla","skala","hårbotten","skrämma","skrämma","scarf","skälla","scoop","scoot","räckvidd","poäng","skura","scout","scram","skrot","skrubb","skur","scuba","frön","sinne","servera","sju","ska","form","skarpa","skor","kort","visad","syn","sedan","skridsko","skicklighet","kjol","skalle","skunk","slack","sned","skiffer","slank","sömn", "sov","slice","slick","slide","slime","sling","slope","slump","slash","smack","liten","smart","smash","smeta","lukt","le","smock","rök","snack","snigel","orm","snäcka",
"snurra","smyga","sniffa","snoka","snarka","nosa","lösa","ljud","söder","mellanrum","spara","gnista","tala","spjut","fläck","hastighet","stava","spendera" ,"spent","spike","spill","ryggrad","spira","split","spoke","spoke","sked","sport","pip","spray","kvist","squat","squid","stack","staff","scen" "fläck","trappa","insats","inaktuell","stjälk","stall","stämpel","stativ","stirra","stjärnor","start","stat","biff","stjäla","ånga","stål","brant","styra","pinne","styv","stilla","stylta","sticka","stink","stock","sten","stod","pall","stoop","butik","storm","story","spis","rem","halm","stray","strum","studera","stil","socker","träsk","svärm","svett","svep","söt","sväll","sopade","snabba","svin","gunga","svätta","svepa","tabl e","termer","deras","där","dessa","tjocka","sak","tänk","tredje","de","tre","idag","verktyg","totalt","touch","spåra","spåra","handel","tåg","tramp","skräp","trampa","treat","träd","stam","trick","troll","tromp","trupp","öring","lastbil","verkligt","trunk","lita","sanning","unc le","under","tills","värde","besök","röst","vokal","klocka","vatten","vågor","var","vilken","medan","vit","hel","vars","vingar","kvinna","värld","skulle","skriva","fel","skrev","år","ung","tvärs","handling","rädd","överens om","nästan","alltid","belopp","svar","ap päron","runt","blev","blev","före","bakom","hör till","bredvid","bättre","blekmedel","blond","blus","botten","köpt","braise","gren","br eath","bris","bro","bright","trasig","bronco","brons","bläddra","blåmärke","kallad","kan inte","boskap","fångad","center","chans","förändring","c hoose","kyrka","cirkel","garderob","clutch","färg","kolonn","gemensam","hörn","bomull","bana","vagga","krita","skapa","crunch","öken","d esign","direkt","läkare","drake","under","effekt","antingen","energi","motor","tillräckligt","hela","utom","förväntar","familj","känd","far"," figur","fylld","flygning","blomma","skog","frysa","vän","skräck","fransar","frusen","trädgård","blick","glitch","druvor","fett","groch"," mark","agg","tum","inne","ö","själv","förenad","hoppad","dödad","längd","lyft","lyssna","liten","materia","melodi","metod", "mitten","modernt","ögonblick","månader","mamma","nation","notis","nummer","objekt","kontor","syre","passerat","människor","period","person","fras", "plockade","slätter","planet","växter","spelare","snälla","löfte","mycket","plural","pund","beröm","prance","bön","snygg","präst","prins","pri son","drade","knuffade","höjt","snarare","verkligen","orsak","rekord","region","förbli","rapport","resultat","retur","rytm","rullad","brist","skola",
"svida","skrapa","skrapa","skrika","skärm","manus","rulla","andra","verkade","bör","tyst","enkel","singel","syster","skiss","sömnig","ärm","långsamt","log","slät","smeta","rycka","nysa","tal","anda","stänk","skena","svamp","vrickning","sprang","spridning","spridning","vår","sprint","sp rut","gran","kvadrat","squash","gnisslande","gnisslande","kisande","squirm","squirt","squish","stabil","häfta","stärkelse","svälta","staty","stadig","stereo","klibbig", "snål","stygn","strain","strand","strim","ström","gata","strikt","stride","strike","sträng","stripe","stroke","promenad","stark","slag","suffix","sommar ","tillförsel","swatch","svänga","switch","system","men","mot","resor","tråg","dal","promenerade","vikt","hjul","fönster","vinter","inom","undrar","yel låg","mot","redan","djur","en annan","kom","eftersom","tror","mellan","filt","blomning","bror","fört","brinnande","kapital","kapten","cent ury","visst","klimat","klättrat","kläder","företag","jämför","innehåll","kontroll","rätt","land","täckt","syrsa","nuvarande","beslutat","decimal","det ails","avlägsen","delad","dollar","ritning","in","kväll","exakt","exempel","förklara","uttrycka","faktorer","bönder","känsla","äntligen","fingrar","flo wers","framåt","frakt","vänner","allmän","gravitation","själv","historia","dock","hundra","jakt","inkludera","insekter","istället","skrattade","bokstäver","lo cated","maskin","mått","medlemmar","miljoner","minuter","morgon","naturligt","ingenting","siffra","observera","utanför","mönster","kanske","bild","planeter","pr epare","present","kringla","tryckt","problem","process","producera","produkt","program","projekt","löfte","pronomen","skydda","ge","snabbt","nådd","s callop","vetenskap","skoter","skrapa","skrapa","skrik","sektion","fast","flera","ropade","liknande","panna","toffel","mysa","någon","speciell","s queeze","stadion","häftapparat","startad","station","stigbygel","mage","konstigt","stretch","ämne","tänk","yta","svala","tröja","söta","svullen"," symboler","lärare","tanke","genom","problem","trumpet","vanligtvis","olika","by","väder","västerländsk","om","utan","arbetare","skriven","faktiskt", "tillägg","även om","vad som helst","snöstorm","filialer","byggnad","företag","barn","kläder","komplett","sammansatt","överväg","beskriv","uppdelning","elc tric","element","ekvation","alla","spännande","övning","färdig","fraktion","fräknar","hände","öka","indikera","industri","intresse","språk",
"material","rörelse","nordlig","motsatt","trevlig","position","möjlig","övning","öva","dyrbar","förberedd","prinsessa","fånge","pr obably","produkter","egendom","mottagen","kom ihåg","upprepad","sallad","scramble","klottrar","mening","separat","axel","soldater","lösning jon","södra","fantastisk","splittra","strö","ekorre","sjöstjärna","strumpa","rak","sil","främling","styrka","starkare","kamp","elever","plötsligt","överraskning","tillsammans","triangel","dig själv","adjektiv","vacker","början","försiktigt","konsonant","fortsättning","bestämma ine","utvecklat","annorlunda","svårt","riktning","fabriker","följer","livsmedel","viktigt","molekyler","berg","nödvändigt","paragrap h","president","rektor","professor","uttala","propeller","frågor","representera","något","ibland","sprinkler","uttalande","sträckt", "bår","föreslagna","stavelser","tusentals","understrykning","svarta tavla","villkor","ordbok","skillnad","upptäckt","särskilt","allt","erfarenhet","experiment","ficklampa","regering","särskilda","vetenskapsmän","bär","förstås","förstås"
]

mixed_list_of_words = []

# filter out any untranslated words (or any english words that appear in the original list)
for each in translated_list_of_words:
    if each not in original_list:
        mixed_list_of_words.append(each)

a = 0
for each in mixed_list_of_words:
    if len(each) > a:
        a = len(each)

word_sets = [[] for i in range(a)]
alphabet_lc = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u',
               'v', 'w', 'x', 'y', 'z', 'å', 'ä', 'ö']
alphabet_uc = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',
               'V', 'W', 'X', 'Y', 'Z', 'Å', 'Ä', 'Ö']
accents = []
alpha = []
alpha.extend(alphabet_lc)
alpha.extend(alphabet_uc)
alpha.extend(accents)
ignore = [" ", "-", "'"]

for each in mixed_list_of_words:
    b = len(each)
    if 2 < b < 11:
        if each.lower()[0] in alpha:
            one_word = True
            for letter in each:
                if letter in ignore:
                    one_word = False
            if one_word:
                # if not a duplicate
                if each.lower() not in word_sets[b - 1]:
                    word_sets[b - 1].append(each.lower())

# save to file
file_name = os.path.join("new_list_2.txt")

for each in word_sets:
    a = len(each)
    if a > 0:
        each.sort()
        row = list()
        row.append(a)
        row.extend(each)
        # print(row)
        # save to file instead
        with open(file_name, 'a') as f:
            f.write("      " + str(row) + ",\n")
print("Completed - check the %s file." % file_name)

"""
initial word list
act, add, age, ago, air, all, and, any, are, art, bad, bed, big, bit, box, boy, but, buy, can, car, cat, cry, cut, day, did, dog, dry, eat, end, far, few, fig, fit, flu, fly, for, fun, gas, get, got, had, has, hat, her, him, his, hit, hot, how, ice, its, job, key, law, lay, led, let, lie, lot, low, man, map, may, men, new, nor, not, now, off, old, one, our, out, own, pay, per, pry, put, ran, red, row, run, sat, saw, say, sea, see, set, she, sir, sit, six, ski, sky, son, spy, sum, sun, ten, the, too, top, try, two, use, war, was, way, who, why, win, yes, yet, you, able, also, area, arms, army, away, baby, back, ball, bank, base, bear, beat, been, bell, best, bill, blab, blew, blip, blob, blot, blow, blue, boat, body, book, born, both, bran, brat, bray, brew, brim, busy, came, care, case, city, clad, clam, clan, clap, claw, clay, clip, clod, clog, club, clue, cold, come, cook, cool, copy, corn, cost, cows, crab, crib, crop, crow, dark, deal, deep, does, done, door, down, drab, drag, draw, drew, drip, drop, drum, each, ears, east, easy, edge, eggs, else, even, ever, eyes, face, fact, fair, fall, farm, fast, fear, feel, feet, fell, felt, find, fine, fire, fish, five, flag, flap, flat, flaw, flea, flew, flex, flip, flop, flow, food, foot, four, free, frog, from, full, game, gave, girl, give, glad, glee, glob, glow, glue, gold, gone, good, grab, gram, gray, grew, grid, grim, grin, grip, grit, grow, grub, hair, halt, hand, hard, have, head, hear, heat, held, help, here, high, hill, hold, hole, home, hope, huge, idea, into, iron, just, keep, kept, kind, king, knew, know, lady, lake, land, last, lead, left, legs, less, life, like, line, list, live, long, look, lost, loud, love, made, main, make, many, mark,
meet, milk, mind, mine, miss, moon, more, most, move, much, must, name, near, need, next, nose, note, noun, once, only, open, over, page, pair, park, part, past, plan, play, plod, plot, plow, plug, plum, poem, pole, poor, pray, prod, prop, race, rain, read, rest, rich, ride, ring, rise, road, rock, room, root, rope, rose, rule, safe, said, sail, same, sand, save, scab, scan, scar, scat, seat, seen, sell, send, sent, ship, shop, show, side, sign, sing, size, skid, skin, skip, skit, slab, slam, slap, sled, slid, slim, slip, slit, slot, slow, slug, smog, snag, snap, snip, snob, snow, snug, soft, soil, some, song, soon, span, spat, spin, spot, spur, star, stay, stem, step, stew, stir, stop, such, sure, swam, swan, swap, swat, sway, swim, tail, take, talk, tall, team, tell, test, than, that, them, then, they, thin, this, thus, tied, time, tiny, told, tone, took, town, trap, tray, tree, trek, trim, trip, trot, true, tube, turn, type, unit, upon, verb, very, view, wait, wall, want, warm, wash, wear, week, well, went, were, west, what, when, wide, wife, wild, will, wind, wire, wish, with, wood, work, yard, your, about, above, after, again, ahead, allow, alone, along, among, angle, apple, asked, began, being, below, birds, black, blade, blame, blank, blast, blaze, bleat, bleed, bleep, blend, bless, blind, blink, block, blood, bloom, bluff, blunt, blush, board, bones, brace, braid, brain, brake, brand, brass, brave, brawl, bread, break, brick, bride, bring, brisk, broad, broil, broke, brood, brook, broom, broth, brown, brush, build, built, carry, catch, cause, cells, cents, chart, check, child, clack, claim, clamp, clang, clash, clasp, class, clean, clear, cleat, clerk, click, cliff, climb, cling, clink, cloak, clock, clomp, close, cloth, cloud, clove, clown, cluck, clump, coast, could, count, crack, craft, crane, crash, crawl, crazy, creek, creep, cried, croak, crook, crops, cross, crowd, crown, crumb, crust, dance, draft, drain, drake, drank, drape, dread, dream, dress, drift, drill, drink, drive, droop, drove, early, earth, eight, enjoy, equal, every, field, fight, first, flake, flame, flare, flash, fleck, fleet, flesh, flick, fling, flint, float, flock, flood, floor, floss, flour, fluff, fluid, fluke, flunk, flush, flute, force, found, frail,
frame, frank, freak, fresh, frill, frizz, front, frost, fruit, glare, glass, gleam, glide, gloat, globe, gloom, gloss, glove, grace, grade, graft, grain, grand, grant, grape, graph, grasp, grass, grate, grave, gravy, graze, great, greed, green, greet, grill, grime, grind, groan, groom, group, growl, grown, gruff, grump, guess, happy, heard, heart, heavy, horse, hours, house, human, known, large, later, learn, least, leave, level, light, major, march, match, maybe, means, metal, might, miles, money, mouth, music, never, night, north, ocean, often, order, other, paint, paper, party, piece, place, plaid, plain, plane, plank, plant, plate, plead, pleat, plink, plump, point, power, press, price, pride, print, prize, probe, proof, proud, prove, prowl, prune, quiet, quite, radio, ready, right, river, round, scald, scale, scalp, scamp, scare, scarf, scold, scoop, scoot, scope, score, scour, scout, scram, scrap, screw, scrub, scuba, scuff, seeds, sense, serve, seven, shall, shape, sharp, shoes, short, shown, sight, since, skate, skill, skirt, skull, skunk, slack, slant, slate, sleek, sleep, sleet, slept, slice, slick, slide, slime, sling, slope, slump, slush, smack, small, smart, smash, smear, smell, smile, smock, smoke, snack, snail, snake, snare,
snarl, sneak, sniff, snoop, snore, snout, solve, sound, south, space, spare, spark, speak, spear, speck, speed, spell, spend, spent, spike, spill, spine, spire, split, spoil, spoke, spoon, sport, spout, spray, sprig, squat, squid, stack, staff, stage, stain, stair, stake, stale, stalk, stall, stamp, stand, stare, stars, start, state, steak, steal, steam, steel, steep, steer, stick, stiff, still, stilt, sting, stink, stock, stone, stood, stool, stoop, store, storm, story, stove, strap, straw, stray, strip, strum, study, style, sugar, swamp, swarm, sweat, sweep, sweet, swell, swept, swift, swine, swing, swish, swoop, table, terms, their, there, these, thick, thing, think, third, those, three, today, tools, total, touch, trace, track, trade, trail, train, tramp, trash, tread, treat, trees, tribe, trick, troll, tromp, troop, trout, truck, truly, trunk, trust, truth, uncle, under, until, value, visit, voice, vowel, watch, water, waves, where, which, while, white, whole, whose, wings, woman, women, words, world, would, write, wrong, wrote, years, young, across, action, afraid, agreed, almost, always, amount, answer, appear, around, became, become, before, behind, belong, beside, better, bleach, blonde, blouse, bottom, bought, braise, branch, breath, breeze, bridge, bright, broken, bronco, bronze, browse, bruise, called, cannot, cattle, caught, centre, chance, change, choose, church, circle, closet, clutch, colour, column, common, corner, cotton, course, cradle, crayon, create, crunch, desert, design, direct, doctor, dragon, during, effect, either, energy, engine, enough, entire, except, expect, family, famous, father, figure, filled, flight, flower, forest, freeze, friend, fright, fringe, frozen, garden, glance, glitch, grapes, grease, grouch, ground, grudge, inches, inside, island, itself, joined, jumped, killed, length, lifted, listen, little, matter, melody, method, middle, modern, moment, months, mother, nation, notice, number, object, office, oxygen, passed, people, period, person, phrase,  picked, plains, planet, plants, player, please, pledge, plenty, plural, pounds, praise, prance, prayer, pretty, priest, prince, prison, pulled, pushed, raised, rather, really, reason, record, region, remain, report, result, return, rhythm, rolled, scarce, school,
scorch, scrape, scrawl, scream, screen, script, scroll, second, seemed, should, silent, simple, single, sister, sketch, sleepy, sleeve, slight, slowly, smiled, smooth, smudge, snatch, sneeze, speech, spirit, splash, splint, sponge, sprain, sprang, sprawl, spread, spring, sprint, sprout, spruce, square, squash, squeak, squeal, squint, squirm, squirt, squish, stable, staple, starch, starve, statue, steady, stereo, sticky, stingy, stitch, strain, strand, streak, stream, street, strict, stride, strike, string, stripe, stroke, stroll, strong, struck, suffix, summer, supply, swatch, swerve, switch, system, though, toward, travel, trough, valley, walked, weight, wheels, window, winter, within, wonder, yellow, against, already, animals, another, arrived, because, believe, between, blanket, blossom, brother, brought, burning, capital, captain, century, certain, climate, climbed, clothes, company, compare, contain, control, correct, country, covered, cricket, current, decided, decimal, details, distant, divided, dollars, drawing, entered, evening, exactly, example, explain, express, factors, farmers, feeling, finally, fingers, flowers, forward, freight, friends, general, gravity, himself, history, however, hundred, hunting, include, insects, instead, laughed, letters, located, machine, measure, members, million, minutes, morning, natural, nothing, numeral, observe, outside, pattern, perhaps, picture, planets, prepare, present, pretzel, printed, problem, process, produce, product, program, project, promise, pronoun, protect, provide, quickly, reached, scallop, science, scooter, scraper, scratch, screech, section, settled, several, shouted, similar, skillet, slipper, snuggle, someone, special, squeeze, stadium, stapler, started, station, stirrup, stomach, strange, stretch, subject, suppose, surface, swallow, sweater, sweeten, swollen, symbols, teacher, thought, through, trouble, trumpet, usually, various, village, weather, western, whether, without, workers, written, actually, addition, although, anything, blizzard, branches, building, business, children, clothing, complete, compound, consider, describe, division, electric, elements, equation, everyone, exciting, exercise, finished, fraction, freckles, happened, increase, indicate, industry, interest, language,
material, movement, northern, opposite, pleasant, position, possible, practice, practise, precious, prepared, princess, prisoner, probably, products, property, received, remember, repeated, scallion, scramble, scribble, sentence, separate, shoulder, soldiers, solution, southern, splendid, splinter, sprinkle, squirrel, starfish, stocking, straight, strainer, stranger, strength, stronger, struggle, students, suddenly, surprise, together, triangle, yourself, adjective, beautiful, beginning, carefully, consonant, continued, determine, developed, different, difficult, direction, factories, following, groceries, important, molecules, mountains, necessary, paragraph, president, principal, professor, pronounce, propeller, questions, represent, something, sometimes, sprinkler, statement, stretched, stretcher, suggested, syllables, thousands, underline, blackboard, conditions, dictionary, difference, discovered, especially, everything, experience, experiment, flashlight, government, particular, scientists, stationary, strawberry, substances, themselves, understand
"""

""" after translation

"""