# A helper program to add new keys to all language files at once.
# The key still have to be added to the default.py and default.pot

import os
import sys

os.chdir(os.path.abspath(os.path.dirname(sys.argv[0])))

import polib

def merge_translations(filename):
    # Paths
    original_path = os.path.join(os.getcwd(), filename)
    translated_path = os.path.join("extracted", f"extracted_{filename}")
    merged_dir = "merged"
    os.makedirs(merged_dir, exist_ok=True)
    output_path = os.path.join(merged_dir, f"merged_{filename}")

    # Load files
    original_po = polib.pofile(original_path)
    translated_po = polib.pofile(translated_path)

    # Build a lookup dictionary from translated entries
    translations = {entry.msgid: entry.msgstr for entry in translated_po if entry.msgstr}

    # Merge
    for entry in original_po:
        if not entry.msgstr and entry.msgid in translations:
            entry.msgstr = translations[entry.msgid]

    # Save the merged file
    original_po.save(output_path)
    print(f"✅ Merged file saved to: {output_path}")

# Example usage:
# merge_translations("yourfile.po")


if __name__ == "__main__":
    merge_translations('sv.po')
    print("Done!")

"""
argv = sys.argv
if len(argv) == 2:
    line = argv[1]
else:
    print("Enter the line to be added to all files (or press ENTER to exit):")
    line = raw_input()

if len(line) > 2 and line not in ["exit", "exit()", "cancel", "cancel()"]:
    for i in range(len(langs)):
        FILE = langs[i]
        with open(FILE,"a") as f:
            f.write("\n"+line)
    print("Completed...")
else:
    print("Aborting...")
"""


# Example usage:
# extract_untranslated_po_entries('original.po', 'untranslated.po')
