import os
import sys
import polib

# Change working directory to script location
os.chdir(os.path.abspath(os.path.dirname(sys.argv[0])))

def extract_untranslated_po_entries(filename):
    # Ensure the extracted directory exists
    os.makedirs("extracted", exist_ok=True)

    input_path = os.path.join(os.getcwd(), filename)
    output_filename = f"extracted_{filename}"
    output_path = os.path.join("extracted", output_filename)

    # Load .po file using polib
    po = polib.pofile(input_path)

    # Create a new .po file for untranslated entries
    untranslated_po = polib.POFile()
    untranslated_po.metadata = po.metadata  # Copy metadata

    # Add only entries with empty msgstr
    for entry in po:
        if not entry.msgstr.strip():
            untranslated_po.append(entry)

    # Save the result
    untranslated_po.save(output_path)

    print(f"Extracted untranslated entries saved to: {output_path}")

if __name__ == "__main__":
    extract_untranslated_po_entries('sv.po')
    print("Done!")
