/* Copying and distribution of this file, with or without modification,
 * are permitted in any medium without royalty provided the copyright
 * notice and this notice are preserved.
 * This file is offered as-is, without any warranty.
 */

import std.stdio;
import std.file;

import amalthea.csv;

auto csvText = `"key","value"
"strange,field",""","""
"filetype","r"
"some numbers","1759824192,768708993"
`;


void printTable(const ref CSV csv) {
    foreach(row; csv.getTable()) {
        foreach(i, field; row) {
            std.stdio.writef("'%s'", field);
            if (i + 1 != row.length) {
                std.stdio.write(" : ");
            } else {
                std.stdio.writeln;
            }
        }
    }
}


void main() {
    enum csvFile = "temp.csv";
    std.file.write(csvFile, csvText);
    scope(exit) std.file.remove(csvFile);
    CSV csv = CSV(csvFile);
    printTable(csv);
    writeln;
    // change the 'filetype' field
    csv.setValueOfField("key", "filetype", "value", "s");
    printTable(csv);
}
