The Amalthea Library is free software.
This library is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.


**Official repository**: [https://codeberg.org/os-18/amalthea](https://codeberg.org/os-18/amalthea)  

**Mirror:** [https://gitlab.com/os-18/amalthea](https://gitlab.com/os-18/amalthea)

---

## Amalthea

Amalthea is a small, general-purpose, Linux-specific library for the D programming language.
It provides a few useful functions.

**Library documentation:**  
[https://os-18.codeberg.page/amalthea/](https://os-18.codeberg.page/amalthea/)

---

## Ready-made packages

See:  
[Download Page of OS-18](https://codeberg.org/os-18/os-18-docs/src/branch/master/OS-18_Packages.md)  

The page contains information on how to install several packages,
including **Amalthea**.

---

## Build from source

### Preparing

You need to have at least one of the following compilers installed:

- [Digital Mars D Compiler](https://dlang.org/download.html#dmd)
- [LLVM D Compiler](https://wiki.dlang.org/LDC)
- [GNU D Compiler](https://www.gdcproject.org)

The library also depends on **libgio-2.0** and **libglib-2.0**.
These libraries are most likely already installed on your system.


### Compilation and installation

To build static and dynamic libraries using the **ldc2** compiler (default):

```bash
make
```

Installation (root privileges may be required):

```bash
make install
```

After that, the library for ldc2 is ready for use.


The Makefile contains variables:

* `DESTDIR` specifies the root directory for installing (empty by default);
* `PREFIX` specifies the base directory, such as `usr/local` or `usr`.

The installation directory is defined as `$(DESTDIR)/$(PREFIX)` in the Makefile.

You can install the library files in any directory.
For example, to install into `$HOME/.local`:

```bash
make install DESTDIR=$HOME PREFIX=.local
```

Uninstall:

```bash
make uninstall
```

If the project was installed in a non-default location,
use the corresponding paths:

```bash
make uninstall DESTDIR=$HOME PREFIX=.local
```

### Other compilers

The default compiler is **ldc2**.  
You can choose another compiler (for example, **dmd**):

```bash
make DC=dmd
```

Installing:

```bash
make install DC=dmd
```

Uninstalling:

```bash
make uninstall DC=dmd
```

---

## Feedback

For questions, suggestions, comments, or bugs reports, contact:

**tech.vindex@gmail.com**

Also use the repository service tools.

---
