require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&VFIO_H)) {
    eval 'sub VFIO_H () {1;}' unless defined(&VFIO_H);
    require 'linux/types.ph';
    require 'linux/ioctl.ph';
    eval 'sub VFIO_API_VERSION () {0;}' unless defined(&VFIO_API_VERSION);
    eval 'sub VFIO_TYPE1_IOMMU () {1;}' unless defined(&VFIO_TYPE1_IOMMU);
    eval 'sub VFIO_SPAPR_TCE_IOMMU () {2;}' unless defined(&VFIO_SPAPR_TCE_IOMMU);
    eval 'sub VFIO_TYPE1v2_IOMMU () {3;}' unless defined(&VFIO_TYPE1v2_IOMMU);
    eval 'sub VFIO_DMA_CC_IOMMU () {4;}' unless defined(&VFIO_DMA_CC_IOMMU);
    eval 'sub VFIO_EEH () {5;}' unless defined(&VFIO_EEH);
    eval 'sub VFIO_TYPE1_NESTING_IOMMU () {6;}' unless defined(&VFIO_TYPE1_NESTING_IOMMU);
    eval 'sub VFIO_SPAPR_TCE_v2_IOMMU () {7;}' unless defined(&VFIO_SPAPR_TCE_v2_IOMMU);
    eval 'sub VFIO_NOIOMMU_IOMMU () {8;}' unless defined(&VFIO_NOIOMMU_IOMMU);
    eval 'sub VFIO_UNMAP_ALL () {9;}' unless defined(&VFIO_UNMAP_ALL);
    eval 'sub VFIO_UPDATE_VADDR () {10;}' unless defined(&VFIO_UPDATE_VADDR);
    eval 'sub VFIO_TYPE () {(ord(\';\'));}' unless defined(&VFIO_TYPE);
    eval 'sub VFIO_BASE () {100;}' unless defined(&VFIO_BASE);
    eval 'sub VFIO_GET_API_VERSION () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 0);}' unless defined(&VFIO_GET_API_VERSION);
    eval 'sub VFIO_CHECK_EXTENSION () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 1);}' unless defined(&VFIO_CHECK_EXTENSION);
    eval 'sub VFIO_SET_IOMMU () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 2);}' unless defined(&VFIO_SET_IOMMU);
    eval 'sub VFIO_GROUP_FLAGS_VIABLE () {(1<< 0);}' unless defined(&VFIO_GROUP_FLAGS_VIABLE);
    eval 'sub VFIO_GROUP_FLAGS_CONTAINER_SET () {(1<< 1);}' unless defined(&VFIO_GROUP_FLAGS_CONTAINER_SET);
    eval 'sub VFIO_GROUP_GET_STATUS () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 3);}' unless defined(&VFIO_GROUP_GET_STATUS);
    eval 'sub VFIO_GROUP_SET_CONTAINER () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 4);}' unless defined(&VFIO_GROUP_SET_CONTAINER);
    eval 'sub VFIO_GROUP_UNSET_CONTAINER () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 5);}' unless defined(&VFIO_GROUP_UNSET_CONTAINER);
    eval 'sub VFIO_GROUP_GET_DEVICE_FD () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 6);}' unless defined(&VFIO_GROUP_GET_DEVICE_FD);
    eval 'sub VFIO_DEVICE_FLAGS_RESET () {(1<< 0);}' unless defined(&VFIO_DEVICE_FLAGS_RESET);
    eval 'sub VFIO_DEVICE_FLAGS_PCI () {(1<< 1);}' unless defined(&VFIO_DEVICE_FLAGS_PCI);
    eval 'sub VFIO_DEVICE_FLAGS_PLATFORM () {(1<< 2);}' unless defined(&VFIO_DEVICE_FLAGS_PLATFORM);
    eval 'sub VFIO_DEVICE_FLAGS_AMBA () {(1<< 3);}' unless defined(&VFIO_DEVICE_FLAGS_AMBA);
    eval 'sub VFIO_DEVICE_FLAGS_CCW () {(1<< 4);}' unless defined(&VFIO_DEVICE_FLAGS_CCW);
    eval 'sub VFIO_DEVICE_FLAGS_AP () {(1<< 5);}' unless defined(&VFIO_DEVICE_FLAGS_AP);
    eval 'sub VFIO_DEVICE_FLAGS_FSL_MC () {(1<< 6);}' unless defined(&VFIO_DEVICE_FLAGS_FSL_MC);
    eval 'sub VFIO_DEVICE_FLAGS_CAPS () {(1<< 7);}' unless defined(&VFIO_DEVICE_FLAGS_CAPS);
    eval 'sub VFIO_DEVICE_FLAGS_CDX () {(1<< 8);}' unless defined(&VFIO_DEVICE_FLAGS_CDX);
    eval 'sub VFIO_DEVICE_GET_INFO () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 7);}' unless defined(&VFIO_DEVICE_GET_INFO);
    eval 'sub VFIO_DEVICE_API_PCI_STRING () {"vfio-pci";}' unless defined(&VFIO_DEVICE_API_PCI_STRING);
    eval 'sub VFIO_DEVICE_API_PLATFORM_STRING () {"vfio-platform";}' unless defined(&VFIO_DEVICE_API_PLATFORM_STRING);
    eval 'sub VFIO_DEVICE_API_AMBA_STRING () {"vfio-amba";}' unless defined(&VFIO_DEVICE_API_AMBA_STRING);
    eval 'sub VFIO_DEVICE_API_CCW_STRING () {"vfio-ccw";}' unless defined(&VFIO_DEVICE_API_CCW_STRING);
    eval 'sub VFIO_DEVICE_API_AP_STRING () {"vfio-ap";}' unless defined(&VFIO_DEVICE_API_AP_STRING);
    eval 'sub VFIO_DEVICE_INFO_CAP_ZPCI_BASE () {1;}' unless defined(&VFIO_DEVICE_INFO_CAP_ZPCI_BASE);
    eval 'sub VFIO_DEVICE_INFO_CAP_ZPCI_GROUP () {2;}' unless defined(&VFIO_DEVICE_INFO_CAP_ZPCI_GROUP);
    eval 'sub VFIO_DEVICE_INFO_CAP_ZPCI_UTIL () {3;}' unless defined(&VFIO_DEVICE_INFO_CAP_ZPCI_UTIL);
    eval 'sub VFIO_DEVICE_INFO_CAP_ZPCI_PFIP () {4;}' unless defined(&VFIO_DEVICE_INFO_CAP_ZPCI_PFIP);
    eval 'sub VFIO_DEVICE_INFO_CAP_PCI_ATOMIC_COMP () {5;}' unless defined(&VFIO_DEVICE_INFO_CAP_PCI_ATOMIC_COMP);
    eval 'sub VFIO_PCI_ATOMIC_COMP32 () {(1<< 0);}' unless defined(&VFIO_PCI_ATOMIC_COMP32);
    eval 'sub VFIO_PCI_ATOMIC_COMP64 () {(1<< 1);}' unless defined(&VFIO_PCI_ATOMIC_COMP64);
    eval 'sub VFIO_PCI_ATOMIC_COMP128 () {(1<< 2);}' unless defined(&VFIO_PCI_ATOMIC_COMP128);
    eval 'sub VFIO_REGION_INFO_FLAG_READ () {(1<< 0);}' unless defined(&VFIO_REGION_INFO_FLAG_READ);
    eval 'sub VFIO_REGION_INFO_FLAG_WRITE () {(1<< 1);}' unless defined(&VFIO_REGION_INFO_FLAG_WRITE);
    eval 'sub VFIO_REGION_INFO_FLAG_MMAP () {(1<< 2);}' unless defined(&VFIO_REGION_INFO_FLAG_MMAP);
    eval 'sub VFIO_REGION_INFO_FLAG_CAPS () {(1<< 3);}' unless defined(&VFIO_REGION_INFO_FLAG_CAPS);
    eval 'sub VFIO_DEVICE_GET_REGION_INFO () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 8);}' unless defined(&VFIO_DEVICE_GET_REGION_INFO);
    eval 'sub VFIO_REGION_INFO_CAP_SPARSE_MMAP () {1;}' unless defined(&VFIO_REGION_INFO_CAP_SPARSE_MMAP);
    eval 'sub VFIO_REGION_INFO_CAP_TYPE () {2;}' unless defined(&VFIO_REGION_INFO_CAP_TYPE);
    eval 'sub VFIO_REGION_TYPE_PCI_VENDOR_TYPE () {(1<< 31);}' unless defined(&VFIO_REGION_TYPE_PCI_VENDOR_TYPE);
    eval 'sub VFIO_REGION_TYPE_PCI_VENDOR_MASK () {(0xffff);}' unless defined(&VFIO_REGION_TYPE_PCI_VENDOR_MASK);
    eval 'sub VFIO_REGION_TYPE_GFX () {(1);}' unless defined(&VFIO_REGION_TYPE_GFX);
    eval 'sub VFIO_REGION_TYPE_CCW () {(2);}' unless defined(&VFIO_REGION_TYPE_CCW);
    eval 'sub VFIO_REGION_TYPE_MIGRATION_DEPRECATED () {(3);}' unless defined(&VFIO_REGION_TYPE_MIGRATION_DEPRECATED);
    eval 'sub VFIO_REGION_SUBTYPE_INTEL_IGD_OPREGION () {(1);}' unless defined(&VFIO_REGION_SUBTYPE_INTEL_IGD_OPREGION);
    eval 'sub VFIO_REGION_SUBTYPE_INTEL_IGD_HOST_CFG () {(2);}' unless defined(&VFIO_REGION_SUBTYPE_INTEL_IGD_HOST_CFG);
    eval 'sub VFIO_REGION_SUBTYPE_INTEL_IGD_LPC_CFG () {(3);}' unless defined(&VFIO_REGION_SUBTYPE_INTEL_IGD_LPC_CFG);
    eval 'sub VFIO_REGION_SUBTYPE_NVIDIA_NVLINK2_RAM () {(1);}' unless defined(&VFIO_REGION_SUBTYPE_NVIDIA_NVLINK2_RAM);
    eval 'sub VFIO_REGION_SUBTYPE_IBM_NVLINK2_ATSD () {(1);}' unless defined(&VFIO_REGION_SUBTYPE_IBM_NVLINK2_ATSD);
    eval 'sub VFIO_REGION_SUBTYPE_GFX_EDID () {(1);}' unless defined(&VFIO_REGION_SUBTYPE_GFX_EDID);
    eval 'sub VFIO_DEVICE_GFX_LINK_STATE_UP () {1;}' unless defined(&VFIO_DEVICE_GFX_LINK_STATE_UP);
    eval 'sub VFIO_DEVICE_GFX_LINK_STATE_DOWN () {2;}' unless defined(&VFIO_DEVICE_GFX_LINK_STATE_DOWN);
    eval 'sub VFIO_REGION_SUBTYPE_CCW_ASYNC_CMD () {(1);}' unless defined(&VFIO_REGION_SUBTYPE_CCW_ASYNC_CMD);
    eval 'sub VFIO_REGION_SUBTYPE_CCW_SCHIB () {(2);}' unless defined(&VFIO_REGION_SUBTYPE_CCW_SCHIB);
    eval 'sub VFIO_REGION_SUBTYPE_CCW_CRW () {(3);}' unless defined(&VFIO_REGION_SUBTYPE_CCW_CRW);
    eval 'sub VFIO_REGION_SUBTYPE_MIGRATION_DEPRECATED () {(1);}' unless defined(&VFIO_REGION_SUBTYPE_MIGRATION_DEPRECATED);
    eval 'sub VFIO_DEVICE_STATE_V1_STOP () {(0);}' unless defined(&VFIO_DEVICE_STATE_V1_STOP);
    eval 'sub VFIO_DEVICE_STATE_V1_RUNNING () {(1<< 0);}' unless defined(&VFIO_DEVICE_STATE_V1_RUNNING);
    eval 'sub VFIO_DEVICE_STATE_V1_SAVING () {(1<< 1);}' unless defined(&VFIO_DEVICE_STATE_V1_SAVING);
    eval 'sub VFIO_DEVICE_STATE_V1_RESUMING () {(1<< 2);}' unless defined(&VFIO_DEVICE_STATE_V1_RESUMING);
    eval 'sub VFIO_DEVICE_STATE_MASK () {( &VFIO_DEVICE_STATE_V1_RUNNING |  &VFIO_DEVICE_STATE_V1_SAVING |  &VFIO_DEVICE_STATE_V1_RESUMING);}' unless defined(&VFIO_DEVICE_STATE_MASK);
    eval 'sub VFIO_DEVICE_STATE_VALID {
        my($state) = @_;
	    eval q(($state &  &VFIO_DEVICE_STATE_V1_RESUMING ? ($state &  &VFIO_DEVICE_STATE_MASK) ==  &VFIO_DEVICE_STATE_V1_RESUMING : 1));
    }' unless defined(&VFIO_DEVICE_STATE_VALID);
    eval 'sub VFIO_DEVICE_STATE_IS_ERROR {
        my($state) = @_;
	    eval q((($state &  &VFIO_DEVICE_STATE_MASK) == ( &VFIO_DEVICE_STATE_V1_SAVING |  &VFIO_DEVICE_STATE_V1_RESUMING)));
    }' unless defined(&VFIO_DEVICE_STATE_IS_ERROR);
    eval 'sub VFIO_DEVICE_STATE_SET_ERROR {
        my($state) = @_;
	    eval q((($state & ~ &VFIO_DEVICE_STATE_MASK) |  &VFIO_DEVICE_STATE_V1_SAVING |  &VFIO_DEVICE_STATE_V1_RESUMING));
    }' unless defined(&VFIO_DEVICE_STATE_SET_ERROR);
    eval 'sub VFIO_REGION_INFO_CAP_MSIX_MAPPABLE () {3;}' unless defined(&VFIO_REGION_INFO_CAP_MSIX_MAPPABLE);
    eval 'sub VFIO_REGION_INFO_CAP_NVLINK2_SSATGT () {4;}' unless defined(&VFIO_REGION_INFO_CAP_NVLINK2_SSATGT);
    eval 'sub VFIO_REGION_INFO_CAP_NVLINK2_LNKSPD () {5;}' unless defined(&VFIO_REGION_INFO_CAP_NVLINK2_LNKSPD);
    eval 'sub VFIO_IRQ_INFO_EVENTFD () {(1<< 0);}' unless defined(&VFIO_IRQ_INFO_EVENTFD);
    eval 'sub VFIO_IRQ_INFO_MASKABLE () {(1<< 1);}' unless defined(&VFIO_IRQ_INFO_MASKABLE);
    eval 'sub VFIO_IRQ_INFO_AUTOMASKED () {(1<< 2);}' unless defined(&VFIO_IRQ_INFO_AUTOMASKED);
    eval 'sub VFIO_IRQ_INFO_NORESIZE () {(1<< 3);}' unless defined(&VFIO_IRQ_INFO_NORESIZE);
    eval 'sub VFIO_DEVICE_GET_IRQ_INFO () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 9);}' unless defined(&VFIO_DEVICE_GET_IRQ_INFO);
    eval 'sub VFIO_IRQ_SET_DATA_NONE () {(1<< 0);}' unless defined(&VFIO_IRQ_SET_DATA_NONE);
    eval 'sub VFIO_IRQ_SET_DATA_BOOL () {(1<< 1);}' unless defined(&VFIO_IRQ_SET_DATA_BOOL);
    eval 'sub VFIO_IRQ_SET_DATA_EVENTFD () {(1<< 2);}' unless defined(&VFIO_IRQ_SET_DATA_EVENTFD);
    eval 'sub VFIO_IRQ_SET_ACTION_MASK () {(1<< 3);}' unless defined(&VFIO_IRQ_SET_ACTION_MASK);
    eval 'sub VFIO_IRQ_SET_ACTION_UNMASK () {(1<< 4);}' unless defined(&VFIO_IRQ_SET_ACTION_UNMASK);
    eval 'sub VFIO_IRQ_SET_ACTION_TRIGGER () {(1<< 5);}' unless defined(&VFIO_IRQ_SET_ACTION_TRIGGER);
    eval 'sub VFIO_DEVICE_SET_IRQS () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 10);}' unless defined(&VFIO_DEVICE_SET_IRQS);
    eval 'sub VFIO_IRQ_SET_DATA_TYPE_MASK () {( &VFIO_IRQ_SET_DATA_NONE |  &VFIO_IRQ_SET_DATA_BOOL |  &VFIO_IRQ_SET_DATA_EVENTFD);}' unless defined(&VFIO_IRQ_SET_DATA_TYPE_MASK);
    eval 'sub VFIO_IRQ_SET_ACTION_TYPE_MASK () {( &VFIO_IRQ_SET_ACTION_MASK |  &VFIO_IRQ_SET_ACTION_UNMASK |  &VFIO_IRQ_SET_ACTION_TRIGGER);}' unless defined(&VFIO_IRQ_SET_ACTION_TYPE_MASK);
    eval 'sub VFIO_DEVICE_RESET () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 11);}' unless defined(&VFIO_DEVICE_RESET);
    eval("sub VFIO_PCI_BAR0_REGION_INDEX () { 0; }") unless defined(&VFIO_PCI_BAR0_REGION_INDEX);
    eval("sub VFIO_PCI_BAR1_REGION_INDEX () { 1; }") unless defined(&VFIO_PCI_BAR1_REGION_INDEX);
    eval("sub VFIO_PCI_BAR2_REGION_INDEX () { 2; }") unless defined(&VFIO_PCI_BAR2_REGION_INDEX);
    eval("sub VFIO_PCI_BAR3_REGION_INDEX () { 3; }") unless defined(&VFIO_PCI_BAR3_REGION_INDEX);
    eval("sub VFIO_PCI_BAR4_REGION_INDEX () { 4; }") unless defined(&VFIO_PCI_BAR4_REGION_INDEX);
    eval("sub VFIO_PCI_BAR5_REGION_INDEX () { 5; }") unless defined(&VFIO_PCI_BAR5_REGION_INDEX);
    eval("sub VFIO_PCI_ROM_REGION_INDEX () { 6; }") unless defined(&VFIO_PCI_ROM_REGION_INDEX);
    eval("sub VFIO_PCI_CONFIG_REGION_INDEX () { 7; }") unless defined(&VFIO_PCI_CONFIG_REGION_INDEX);
    eval("sub VFIO_PCI_VGA_REGION_INDEX () { 8; }") unless defined(&VFIO_PCI_VGA_REGION_INDEX);
    eval("sub VFIO_PCI_NUM_REGIONS () { 9; }") unless defined(&VFIO_PCI_NUM_REGIONS);
    eval("sub VFIO_PCI_INTX_IRQ_INDEX () { 0; }") unless defined(&VFIO_PCI_INTX_IRQ_INDEX);
    eval("sub VFIO_PCI_MSI_IRQ_INDEX () { 1; }") unless defined(&VFIO_PCI_MSI_IRQ_INDEX);
    eval("sub VFIO_PCI_MSIX_IRQ_INDEX () { 2; }") unless defined(&VFIO_PCI_MSIX_IRQ_INDEX);
    eval("sub VFIO_PCI_ERR_IRQ_INDEX () { 3; }") unless defined(&VFIO_PCI_ERR_IRQ_INDEX);
    eval("sub VFIO_PCI_REQ_IRQ_INDEX () { 4; }") unless defined(&VFIO_PCI_REQ_IRQ_INDEX);
    eval("sub VFIO_PCI_NUM_IRQS () { 5; }") unless defined(&VFIO_PCI_NUM_IRQS);
    eval("sub VFIO_CCW_CONFIG_REGION_INDEX () { 0; }") unless defined(&VFIO_CCW_CONFIG_REGION_INDEX);
    eval("sub VFIO_CCW_NUM_REGIONS () { 1; }") unless defined(&VFIO_CCW_NUM_REGIONS);
    eval("sub VFIO_CCW_IO_IRQ_INDEX () { 0; }") unless defined(&VFIO_CCW_IO_IRQ_INDEX);
    eval("sub VFIO_CCW_CRW_IRQ_INDEX () { 1; }") unless defined(&VFIO_CCW_CRW_IRQ_INDEX);
    eval("sub VFIO_CCW_REQ_IRQ_INDEX () { 2; }") unless defined(&VFIO_CCW_REQ_IRQ_INDEX);
    eval("sub VFIO_CCW_NUM_IRQS () { 3; }") unless defined(&VFIO_CCW_NUM_IRQS);
    eval("sub VFIO_AP_REQ_IRQ_INDEX () { 0; }") unless defined(&VFIO_AP_REQ_IRQ_INDEX);
    eval("sub VFIO_AP_NUM_IRQS () { 1; }") unless defined(&VFIO_AP_NUM_IRQS);
    eval 'sub VFIO_PCI_DEVID_OWNED () {0;}' unless defined(&VFIO_PCI_DEVID_OWNED);
    eval 'sub VFIO_PCI_DEVID_NOT_OWNED () {-1;}' unless defined(&VFIO_PCI_DEVID_NOT_OWNED);
    eval 'sub VFIO_PCI_HOT_RESET_FLAG_DEV_ID () {(1<< 0);}' unless defined(&VFIO_PCI_HOT_RESET_FLAG_DEV_ID);
    eval 'sub VFIO_PCI_HOT_RESET_FLAG_DEV_ID_OWNED () {(1<< 1);}' unless defined(&VFIO_PCI_HOT_RESET_FLAG_DEV_ID_OWNED);
    eval 'sub VFIO_DEVICE_GET_PCI_HOT_RESET_INFO () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 12);}' unless defined(&VFIO_DEVICE_GET_PCI_HOT_RESET_INFO);
    eval 'sub VFIO_DEVICE_PCI_HOT_RESET () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 13);}' unless defined(&VFIO_DEVICE_PCI_HOT_RESET);
    eval 'sub VFIO_GFX_PLANE_TYPE_PROBE () {(1<< 0);}' unless defined(&VFIO_GFX_PLANE_TYPE_PROBE);
    eval 'sub VFIO_GFX_PLANE_TYPE_DMABUF () {(1<< 1);}' unless defined(&VFIO_GFX_PLANE_TYPE_DMABUF);
    eval 'sub VFIO_GFX_PLANE_TYPE_REGION () {(1<< 2);}' unless defined(&VFIO_GFX_PLANE_TYPE_REGION);
    eval 'sub VFIO_DEVICE_QUERY_GFX_PLANE () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 14);}' unless defined(&VFIO_DEVICE_QUERY_GFX_PLANE);
    eval 'sub VFIO_DEVICE_GET_GFX_DMABUF () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 15);}' unless defined(&VFIO_DEVICE_GET_GFX_DMABUF);
    eval 'sub VFIO_DEVICE_IOEVENTFD_8 () {(1<< 0);}' unless defined(&VFIO_DEVICE_IOEVENTFD_8);
    eval 'sub VFIO_DEVICE_IOEVENTFD_16 () {(1<< 1);}' unless defined(&VFIO_DEVICE_IOEVENTFD_16);
    eval 'sub VFIO_DEVICE_IOEVENTFD_32 () {(1<< 2);}' unless defined(&VFIO_DEVICE_IOEVENTFD_32);
    eval 'sub VFIO_DEVICE_IOEVENTFD_64 () {(1<< 3);}' unless defined(&VFIO_DEVICE_IOEVENTFD_64);
    eval 'sub VFIO_DEVICE_IOEVENTFD_SIZE_MASK () {(0xf);}' unless defined(&VFIO_DEVICE_IOEVENTFD_SIZE_MASK);
    eval 'sub VFIO_DEVICE_IOEVENTFD () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 16);}' unless defined(&VFIO_DEVICE_IOEVENTFD);
    eval 'sub VFIO_DEVICE_FEATURE_MASK () {(0xffff);}' unless defined(&VFIO_DEVICE_FEATURE_MASK);
    eval 'sub VFIO_DEVICE_FEATURE_GET () {(1<< 16);}' unless defined(&VFIO_DEVICE_FEATURE_GET);
    eval 'sub VFIO_DEVICE_FEATURE_SET () {(1<< 17);}' unless defined(&VFIO_DEVICE_FEATURE_SET);
    eval 'sub VFIO_DEVICE_FEATURE_PROBE () {(1<< 18);}' unless defined(&VFIO_DEVICE_FEATURE_PROBE);
    eval 'sub VFIO_DEVICE_FEATURE () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 17);}' unless defined(&VFIO_DEVICE_FEATURE);
    eval 'sub VFIO_DEVICE_BIND_IOMMUFD () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 18);}' unless defined(&VFIO_DEVICE_BIND_IOMMUFD);
    eval 'sub VFIO_DEVICE_ATTACH_IOMMUFD_PT () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 19);}' unless defined(&VFIO_DEVICE_ATTACH_IOMMUFD_PT);
    eval 'sub VFIO_DEVICE_DETACH_IOMMUFD_PT () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 20);}' unless defined(&VFIO_DEVICE_DETACH_IOMMUFD_PT);
    eval 'sub VFIO_DEVICE_FEATURE_PCI_VF_TOKEN () {(0);}' unless defined(&VFIO_DEVICE_FEATURE_PCI_VF_TOKEN);
    eval 'sub VFIO_MIGRATION_STOP_COPY () {(1<< 0);}' unless defined(&VFIO_MIGRATION_STOP_COPY);
    eval 'sub VFIO_MIGRATION_P2P () {(1<< 1);}' unless defined(&VFIO_MIGRATION_P2P);
    eval 'sub VFIO_MIGRATION_PRE_COPY () {(1<< 2);}' unless defined(&VFIO_MIGRATION_PRE_COPY);
    eval 'sub VFIO_DEVICE_FEATURE_MIGRATION () {1;}' unless defined(&VFIO_DEVICE_FEATURE_MIGRATION);
    eval 'sub VFIO_DEVICE_FEATURE_MIG_DEVICE_STATE () {2;}' unless defined(&VFIO_DEVICE_FEATURE_MIG_DEVICE_STATE);
    eval("sub VFIO_DEVICE_STATE_ERROR () { 0; }") unless defined(&VFIO_DEVICE_STATE_ERROR);
    eval("sub VFIO_DEVICE_STATE_STOP () { 1; }") unless defined(&VFIO_DEVICE_STATE_STOP);
    eval("sub VFIO_DEVICE_STATE_RUNNING () { 2; }") unless defined(&VFIO_DEVICE_STATE_RUNNING);
    eval("sub VFIO_DEVICE_STATE_STOP_COPY () { 3; }") unless defined(&VFIO_DEVICE_STATE_STOP_COPY);
    eval("sub VFIO_DEVICE_STATE_RESUMING () { 4; }") unless defined(&VFIO_DEVICE_STATE_RESUMING);
    eval("sub VFIO_DEVICE_STATE_RUNNING_P2P () { 5; }") unless defined(&VFIO_DEVICE_STATE_RUNNING_P2P);
    eval("sub VFIO_DEVICE_STATE_PRE_COPY () { 6; }") unless defined(&VFIO_DEVICE_STATE_PRE_COPY);
    eval("sub VFIO_DEVICE_STATE_PRE_COPY_P2P () { 7; }") unless defined(&VFIO_DEVICE_STATE_PRE_COPY_P2P);
    eval("sub VFIO_DEVICE_STATE_NR () { 8; }") unless defined(&VFIO_DEVICE_STATE_NR);
    eval 'sub VFIO_MIG_GET_PRECOPY_INFO () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 21);}' unless defined(&VFIO_MIG_GET_PRECOPY_INFO);
    eval 'sub VFIO_DEVICE_FEATURE_LOW_POWER_ENTRY () {3;}' unless defined(&VFIO_DEVICE_FEATURE_LOW_POWER_ENTRY);
    eval 'sub VFIO_DEVICE_FEATURE_LOW_POWER_ENTRY_WITH_WAKEUP () {4;}' unless defined(&VFIO_DEVICE_FEATURE_LOW_POWER_ENTRY_WITH_WAKEUP);
    eval 'sub VFIO_DEVICE_FEATURE_LOW_POWER_EXIT () {5;}' unless defined(&VFIO_DEVICE_FEATURE_LOW_POWER_EXIT);
    eval 'sub VFIO_DEVICE_FEATURE_DMA_LOGGING_START () {6;}' unless defined(&VFIO_DEVICE_FEATURE_DMA_LOGGING_START);
    eval 'sub VFIO_DEVICE_FEATURE_DMA_LOGGING_STOP () {7;}' unless defined(&VFIO_DEVICE_FEATURE_DMA_LOGGING_STOP);
    eval 'sub VFIO_DEVICE_FEATURE_DMA_LOGGING_REPORT () {8;}' unless defined(&VFIO_DEVICE_FEATURE_DMA_LOGGING_REPORT);
    eval 'sub VFIO_DEVICE_FEATURE_MIG_DATA_SIZE () {9;}' unless defined(&VFIO_DEVICE_FEATURE_MIG_DATA_SIZE);
    eval 'sub VFIO_DEVICE_FEATURE_CLEAR_MASTER () {0;}' unless defined(&VFIO_DEVICE_FEATURE_CLEAR_MASTER);
    eval 'sub VFIO_DEVICE_FEATURE_SET_MASTER () {1;}' unless defined(&VFIO_DEVICE_FEATURE_SET_MASTER);
    eval 'sub VFIO_DEVICE_FEATURE_BUS_MASTER () {10;}' unless defined(&VFIO_DEVICE_FEATURE_BUS_MASTER);
    eval 'sub VFIO_IOMMU_INFO_PGSIZES () {(1<< 0);}' unless defined(&VFIO_IOMMU_INFO_PGSIZES);
    eval 'sub VFIO_IOMMU_INFO_CAPS () {(1<< 1);}' unless defined(&VFIO_IOMMU_INFO_CAPS);
    eval 'sub VFIO_IOMMU_TYPE1_INFO_CAP_IOVA_RANGE () {1;}' unless defined(&VFIO_IOMMU_TYPE1_INFO_CAP_IOVA_RANGE);
    eval 'sub VFIO_IOMMU_TYPE1_INFO_CAP_MIGRATION () {2;}' unless defined(&VFIO_IOMMU_TYPE1_INFO_CAP_MIGRATION);
    eval 'sub VFIO_IOMMU_TYPE1_INFO_DMA_AVAIL () {3;}' unless defined(&VFIO_IOMMU_TYPE1_INFO_DMA_AVAIL);
    eval 'sub VFIO_IOMMU_GET_INFO () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 12);}' unless defined(&VFIO_IOMMU_GET_INFO);
    eval 'sub VFIO_DMA_MAP_FLAG_READ () {(1<< 0);}' unless defined(&VFIO_DMA_MAP_FLAG_READ);
    eval 'sub VFIO_DMA_MAP_FLAG_WRITE () {(1<< 1);}' unless defined(&VFIO_DMA_MAP_FLAG_WRITE);
    eval 'sub VFIO_DMA_MAP_FLAG_VADDR () {(1<< 2);}' unless defined(&VFIO_DMA_MAP_FLAG_VADDR);
    eval 'sub VFIO_IOMMU_MAP_DMA () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 13);}' unless defined(&VFIO_IOMMU_MAP_DMA);
    eval 'sub VFIO_DMA_UNMAP_FLAG_GET_DIRTY_BITMAP () {(1<< 0);}' unless defined(&VFIO_DMA_UNMAP_FLAG_GET_DIRTY_BITMAP);
    eval 'sub VFIO_DMA_UNMAP_FLAG_ALL () {(1<< 1);}' unless defined(&VFIO_DMA_UNMAP_FLAG_ALL);
    eval 'sub VFIO_DMA_UNMAP_FLAG_VADDR () {(1<< 2);}' unless defined(&VFIO_DMA_UNMAP_FLAG_VADDR);
    eval 'sub VFIO_IOMMU_UNMAP_DMA () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 14);}' unless defined(&VFIO_IOMMU_UNMAP_DMA);
    eval 'sub VFIO_IOMMU_ENABLE () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 15);}' unless defined(&VFIO_IOMMU_ENABLE);
    eval 'sub VFIO_IOMMU_DISABLE () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 16);}' unless defined(&VFIO_IOMMU_DISABLE);
    eval 'sub VFIO_IOMMU_DIRTY_PAGES_FLAG_START () {(1<< 0);}' unless defined(&VFIO_IOMMU_DIRTY_PAGES_FLAG_START);
    eval 'sub VFIO_IOMMU_DIRTY_PAGES_FLAG_STOP () {(1<< 1);}' unless defined(&VFIO_IOMMU_DIRTY_PAGES_FLAG_STOP);
    eval 'sub VFIO_IOMMU_DIRTY_PAGES_FLAG_GET_BITMAP () {(1<< 2);}' unless defined(&VFIO_IOMMU_DIRTY_PAGES_FLAG_GET_BITMAP);
    eval 'sub VFIO_IOMMU_DIRTY_PAGES () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 17);}' unless defined(&VFIO_IOMMU_DIRTY_PAGES);
    eval 'sub VFIO_IOMMU_SPAPR_INFO_DDW () {(1<< 0);}' unless defined(&VFIO_IOMMU_SPAPR_INFO_DDW);
    eval 'sub VFIO_IOMMU_SPAPR_TCE_GET_INFO () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 12);}' unless defined(&VFIO_IOMMU_SPAPR_TCE_GET_INFO);
    eval 'sub VFIO_EEH_PE_DISABLE () {0;}' unless defined(&VFIO_EEH_PE_DISABLE);
    eval 'sub VFIO_EEH_PE_ENABLE () {1;}' unless defined(&VFIO_EEH_PE_ENABLE);
    eval 'sub VFIO_EEH_PE_UNFREEZE_IO () {2;}' unless defined(&VFIO_EEH_PE_UNFREEZE_IO);
    eval 'sub VFIO_EEH_PE_UNFREEZE_DMA () {3;}' unless defined(&VFIO_EEH_PE_UNFREEZE_DMA);
    eval 'sub VFIO_EEH_PE_GET_STATE () {4;}' unless defined(&VFIO_EEH_PE_GET_STATE);
    eval 'sub VFIO_EEH_PE_STATE_NORMAL () {0;}' unless defined(&VFIO_EEH_PE_STATE_NORMAL);
    eval 'sub VFIO_EEH_PE_STATE_RESET () {1;}' unless defined(&VFIO_EEH_PE_STATE_RESET);
    eval 'sub VFIO_EEH_PE_STATE_STOPPED () {2;}' unless defined(&VFIO_EEH_PE_STATE_STOPPED);
    eval 'sub VFIO_EEH_PE_STATE_STOPPED_DMA () {4;}' unless defined(&VFIO_EEH_PE_STATE_STOPPED_DMA);
    eval 'sub VFIO_EEH_PE_STATE_UNAVAIL () {5;}' unless defined(&VFIO_EEH_PE_STATE_UNAVAIL);
    eval 'sub VFIO_EEH_PE_RESET_DEACTIVATE () {5;}' unless defined(&VFIO_EEH_PE_RESET_DEACTIVATE);
    eval 'sub VFIO_EEH_PE_RESET_HOT () {6;}' unless defined(&VFIO_EEH_PE_RESET_HOT);
    eval 'sub VFIO_EEH_PE_RESET_FUNDAMENTAL () {7;}' unless defined(&VFIO_EEH_PE_RESET_FUNDAMENTAL);
    eval 'sub VFIO_EEH_PE_CONFIGURE () {8;}' unless defined(&VFIO_EEH_PE_CONFIGURE);
    eval 'sub VFIO_EEH_PE_INJECT_ERR () {9;}' unless defined(&VFIO_EEH_PE_INJECT_ERR);
    eval 'sub VFIO_EEH_PE_OP () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 21);}' unless defined(&VFIO_EEH_PE_OP);
    eval 'sub VFIO_IOMMU_SPAPR_REGISTER_MEMORY () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 17);}' unless defined(&VFIO_IOMMU_SPAPR_REGISTER_MEMORY);
    eval 'sub VFIO_IOMMU_SPAPR_UNREGISTER_MEMORY () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 18);}' unless defined(&VFIO_IOMMU_SPAPR_UNREGISTER_MEMORY);
    eval 'sub VFIO_IOMMU_SPAPR_TCE_CREATE () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 19);}' unless defined(&VFIO_IOMMU_SPAPR_TCE_CREATE);
    eval 'sub VFIO_IOMMU_SPAPR_TCE_REMOVE () { &_IO( &VFIO_TYPE,  &VFIO_BASE + 20);}' unless defined(&VFIO_IOMMU_SPAPR_TCE_REMOVE);
}
1;
