/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class VersionExtended {
    private long cppAddr = 0L;

    public native String getBuildDate();

    public native String getBuildTime();

    public native String getBuildHost();

    public native String getCopyright();

    public native String getRuntimeHost();

    public native String getRuntimeOSName();

    public Iterator<LinkedLib> getLinkedLibs() {
        return new LinkedLibIterator(this);
    }

    public Iterator<LoadedLib> getLoadedLibs() {
        return new LoadedLibIterator(this);
    }

    private class LoadedLibIterator
    implements Iterator<LoadedLib> {
        private final VersionExtended wrapper;
        private int index;

        public LoadedLibIterator(VersionExtended versionExtended2) {
            this.wrapper = versionExtended2;
            this.index = -1;
        }

        @Override
        public native boolean hasNext();

        @Override
        public LoadedLib next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new LoadedLib(this.wrapper, ++this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class LinkedLibIterator
    implements Iterator<LinkedLib> {
        private final VersionExtended wrapper;
        private int index;

        public LinkedLibIterator(VersionExtended versionExtended2) {
            this.wrapper = versionExtended2;
            this.index = -1;
        }

        @Override
        public native boolean hasNext();

        @Override
        public LinkedLib next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new LinkedLib(this.wrapper, ++this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class LoadedLib {
        private final VersionExtended wrapper;
        private final int index;

        public final native String getName();

        public final native String getVersion();

        LoadedLib(VersionExtended versionExtended2, int n) {
            this.wrapper = versionExtended2;
            this.index = n;
        }
    }

    public class LinkedLib {
        private final VersionExtended wrapper;
        private final int index;

        public final native String getName();

        public final native String getCompiledVersion();

        public final native String getRuntimeVersion();

        LinkedLib(VersionExtended versionExtended2, int n) {
            this.wrapper = versionExtended2;
            this.index = n;
        }
    }
}

