/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.subversion.javahl.types.RevisionRange;

public class Mergeinfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<RevisionRange>> mergeSources = new HashMap<String, List<RevisionRange>>();

    public Mergeinfo() {
    }

    public Mergeinfo(String string) {
        this();
        this.loadFromMergeinfoProperty(string);
    }

    public void addRevisions(String string, List<RevisionRange> list) {
        for (RevisionRange revisionRange : list) {
            this.addRevisionRange(string, revisionRange);
        }
    }

    public void addRevisionRange(String string, RevisionRange revisionRange) {
        List<RevisionRange> list = this.getRevisions(string);
        if (list == null) {
            list = new ArrayList<RevisionRange>();
        }
        list.add(revisionRange);
        this.setRevisionList(string, list);
    }

    public Set<String> getPaths() {
        return this.mergeSources.keySet();
    }

    public List<RevisionRange> getRevisions(String string) {
        if (string == null) {
            return null;
        }
        return this.mergeSources.get(string);
    }

    public List<RevisionRange> getRevisionRange(String string) {
        return this.getRevisions(string);
    }

    public void loadFromMergeinfoProperty(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            this.parseMergeinfoLine(stringTokenizer.nextToken());
        }
    }

    private void parseMergeinfoLine(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.parseRevisions(string2, string3);
        }
    }

    private void parseRevisions(String string, String string2) {
        List<RevisionRange> list = this.getRevisions(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            RevisionRange revisionRange = new RevisionRange(string3);
            if (list == null) {
                list = new ArrayList<RevisionRange>();
            }
            list.add(revisionRange);
        }
        if (list != null) {
            this.setRevisionList(string, list);
        }
    }

    private void setRevisionList(String string, List<RevisionRange> list) {
        this.mergeSources.put(string, list);
    }

    public static enum LogKind {
        eligible,
        merged;

    }
}

