/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Status;

public class WC {
    Map<String, Item> items = new HashMap<String, Item>();

    public void materialize(File file) throws IOException {
        File file2;
        for (Item item : this.items.values()) {
            if (item.myContent != null || (file2 = new File(file, item.myPath)).exists()) continue;
            file2.mkdirs();
        }
        for (Item item : this.items.values()) {
            if (item.myContent == null) continue;
            file2 = new File(file, item.myPath);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
            printWriter.print(item.myContent);
            printWriter.close();
        }
    }

    public Item addItem(String string, String string2) {
        return new Item(string, string2);
    }

    public Item getItem(String string) {
        return this.items.get(string);
    }

    public void removeItem(String string) {
        this.items.remove(string);
    }

    public void setItemTextStatus(String string, Status.Kind kind) {
        this.items.get((Object)string).textStatus = kind;
    }

    public void setItemPropStatus(String string, Status.Kind kind) {
        this.items.get((Object)string).propStatus = kind;
    }

    public void setItemWorkingCopyRevision(String string, long l) {
        this.items.get((Object)string).workingCopyRev = l;
    }

    public void setRevision(long l) {
        for (Item item : this.items.values()) {
            item.workingCopyRev = l;
        }
    }

    public String getItemContent(String string) {
        return this.items.get((Object)string).myContent;
    }

    public void setItemContent(String string, String string2) {
        Assert.assertNotNull((String)"cannot unset content", (Object)string2);
        Item item = this.items.get(string);
        Assert.assertNotNull((String)"cannot set content on directory", (Object)item.myContent);
        item.myContent = string2;
    }

    public void setItemCheckContent(String string, boolean bl) {
        this.items.get((Object)string).checkContent = bl;
    }

    public void setItemNodeKind(String string, NodeKind nodeKind) {
        this.items.get((Object)string).nodeKind = nodeKind;
    }

    public void setItemIsLocked(String string, boolean bl) {
        this.items.get((Object)string).isLocked = bl;
    }

    public void setItemIsSwitched(String string, boolean bl) {
        this.items.get((Object)string).isSwitched = bl;
    }

    public void setItemReposLastCmtRevision(String string, long l) {
        this.items.get((Object)string).reposLastCmtRevision = l;
    }

    public void setItemReposLastCmtAuthor(String string, String string2) {
        this.items.get((Object)string).reposLastCmtAuthor = string2;
    }

    public void setItemReposLastCmtDate(String string, long l) {
        this.items.get((Object)string).reposLastCmtDate = l;
    }

    public void setItemReposKind(String string, NodeKind nodeKind) {
        this.items.get((Object)string).reposKind = nodeKind;
    }

    public void setItemOODInfo(String string, long l, String string2, long l2, NodeKind nodeKind) {
        this.setItemReposLastCmtRevision(string, l);
        this.setItemReposLastCmtAuthor(string, string2);
        this.setItemReposLastCmtDate(string, l2);
        this.setItemReposKind(string, nodeKind);
    }

    public WC copy() {
        WC wC = new WC();
        for (Item item : this.items.values()) {
            item.copy(wC);
        }
        return wC;
    }

    void check(DirEntry[] dirEntryArray, String string) {
        Assert.assertEquals((String)"not a single dir entry", (int)1, (int)dirEntryArray.length);
        Item item = this.items.get(string);
        Assert.assertNotNull((String)"not found in working copy", (Object)item);
        Assert.assertNotNull((String)"not a file", (Object)item.myContent);
        Assert.assertEquals((String)"state says file, working copy not", (Object)((Object)dirEntryArray[0].getNodeKind()), (Object)((Object)(item.nodeKind == null ? NodeKind.file : item.nodeKind)));
    }

    void check(DirEntry[] dirEntryArray, String string, boolean bl) {
        for (Item item : this.items.values()) {
            item.touched = false;
        }
        string = string != null && string.length() > 0 ? string + '/' : "";
        for (DirEntry dirEntryArray2 : dirEntryArray) {
            String string2 = string + dirEntryArray2.getPath();
            Item item = this.items.get(string2);
            Assert.assertNotNull((String)"null paths won't be found in working copy", (Object)item);
            if (item.myContent != null) {
                Assert.assertEquals((String)("Expected '" + dirEntryArray2 + "' to be file"), (Object)((Object)dirEntryArray2.getNodeKind()), (Object)((Object)(item.nodeKind == null ? NodeKind.file : item.nodeKind)));
            } else {
                Assert.assertEquals((String)("Expected '" + dirEntryArray2 + "' to be dir"), (Object)((Object)dirEntryArray2.getNodeKind()), (Object)((Object)(item.nodeKind == null ? NodeKind.dir : item.nodeKind)));
            }
            item.touched = true;
        }
        for (Item item : this.items.values()) {
            if (item.touched || !item.myPath.startsWith(string) || item.myPath.equals(string)) continue;
            Assert.assertFalse((String)("Expected path '" + item.myPath + "' not found in dir entries"), (boolean)bl);
            int n = 0;
            for (DirEntry dirEntry : dirEntryArray) {
                if (dirEntry.getNodeKind() != NodeKind.dir || !item.myPath.startsWith(string + dirEntry.getPath())) continue;
                n = 1;
                break;
            }
            Assert.assertTrue((String)("Expected path '" + item.myPath + "' not found in dir entries"), n != 0);
        }
    }

    void check(Status[] statusArray, String string) throws IOException {
        this.check(statusArray, string, false);
    }

    void check(Status[] statusArray, String string, boolean bl) throws IOException {
        for (Item object : this.items.values()) {
            object.touched = false;
        }
        String string2 = string.replace(File.separatorChar, '/');
        for (Status status : statusArray) {
            String string3 = status.getPath();
            Assert.assertTrue((String)"status path starts not with working copy path", (boolean)string3.startsWith(string2));
            if (string3.length() > string.length() + 1) {
                Assert.assertEquals((String)"missing '/' in status path", (char)string3.charAt(string.length()), (char)'/');
                string3 = string3.substring(string.length() + 1);
            } else {
                string3 = "";
            }
            Item item = this.items.get(string3);
            Assert.assertNotNull((String)("status not found in working copy: " + string3), (Object)item);
            Assert.assertEquals((String)("wrong text status in working copy: " + string3), (Object)((Object)item.textStatus), (Object)((Object)status.getTextStatus()));
            if (item.workingCopyRev != -1L) {
                Assert.assertEquals((String)("wrong revision number in working copy: " + string3), (long)item.workingCopyRev, (long)status.getRevisionNumber());
            }
            Assert.assertEquals((String)("lock status wrong: " + string3), (boolean)item.isLocked, (boolean)status.isLocked());
            Assert.assertEquals((String)("switch status wrong: " + string3), (boolean)item.isSwitched, (boolean)status.isSwitched());
            Assert.assertEquals((String)("wrong prop status in working copy: " + string3), (Object)((Object)item.propStatus), (Object)((Object)status.getPropStatus()));
            if (item.myContent != null) {
                Assert.assertEquals((String)("state says file, working copy not: " + string3), (Object)((Object)status.getNodeKind()), (Object)((Object)(item.nodeKind == null ? NodeKind.file : item.nodeKind)));
                if (status.getTextStatus() == Status.Kind.normal || item.checkContent) {
                    int n;
                    File file = new File(string, item.myPath);
                    InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n = ((Reader)inputStreamReader).read()) != -1) {
                        stringBuffer.append((char)n);
                    }
                    ((Reader)inputStreamReader).close();
                    Assert.assertEquals((String)("content mismatch: " + string3), (String)stringBuffer.toString(), (String)item.myContent);
                }
            } else {
                Assert.assertEquals((String)("state says dir, working copy not: " + string3), (Object)((Object)status.getNodeKind()), (Object)((Object)(item.nodeKind == null ? NodeKind.dir : item.nodeKind)));
            }
            if (bl) {
                Assert.assertEquals((String)("Last commit revisions for OOD path '" + item.myPath + "' don't match:"), (long)item.reposLastCmtRevision, (long)status.getReposLastCmtRevisionNumber());
                Assert.assertEquals((String)("Last commit kinds for OOD path '" + item.myPath + "' don't match:"), (Object)((Object)item.reposKind), (Object)((Object)status.getReposKind()));
                if (status.getRepositoryTextStatus() != Status.Kind.deleted) {
                    long l = status.getReposLastCmtDate() == null ? 0L : status.getReposLastCmtDate().getTime();
                    Assert.assertEquals((String)("Last commit dates for OOD path '" + item.myPath + "' don't match:"), (Object)new Date(item.reposLastCmtDate), (Object)new Date(l));
                    Assert.assertEquals((String)("Last commit authors for OOD path '" + item.myPath + "' don't match:"), (String)item.reposLastCmtAuthor, (String)status.getReposLastCmtAuthor());
                    Assert.assertNotNull((String)("URL for path " + item.myPath + " should not be null"), (Object)status.getUrl());
                }
            }
            item.touched = true;
        }
        for (Item item : this.items.values()) {
            Assert.assertTrue((String)("item '" + item.myPath + "' in working copy not found in status"), (boolean)item.touched);
        }
    }

    public class Item {
        String myContent;
        String myPath;
        Status.Kind textStatus = Status.Kind.normal;
        Status.Kind propStatus = Status.Kind.none;
        long workingCopyRev = -1L;
        boolean touched;
        boolean checkContent;
        NodeKind nodeKind = null;
        boolean isLocked;
        boolean isSwitched;
        long reposLastCmtRevision = -1L;
        long reposLastCmtDate = 0L;
        NodeKind reposKind = NodeKind.none;
        String reposLastCmtAuthor;

        private Item(String string, String string2) {
            this.myPath = string;
            this.myContent = string2;
            WC.this.items.put(string, this);
        }

        private Item(Item item, WC wC2) {
            this.myPath = item.myPath;
            this.myContent = item.myContent;
            this.textStatus = item.textStatus;
            this.propStatus = item.propStatus;
            wC2.items.put(this.myPath, this);
        }

        private Item copy(WC wC) {
            return new Item(this, wC);
        }
    }
}

