" An example for a gvimrc file.
" The commands in this are executed when the GUI is started, after the vimrc
" has been executed.
"
" Maintainer:	The Vim Project <https://github.com/vim/vim>
" Last Change:	2023 Aug 10
" Former Maintainer:	Bram Moolenaar <Bram@vim.org>
"
" To use it, copy it to
"         for Unix:  ~/.gvimrc
"        for Amiga:  s:.gvimrc
"   for MS-Windows:  $VIM\_gvimrc
"        for Haiku:  ~/config/settings/vim/gvimrc
"      for OpenVMS:  sys$login:.gvimrc

" Make external commands work through a pipe instead of a pseudo-tty
"set noguipty

set ch=2		" Make command line two lines high

set mousehide		" Hide the mouse when typing text

" Make shift-insert work like in Xterm
map <S-Insert> <MiddleMouse>
map! <S-Insert> <MiddleMouse>

" Only do this for Vim version 5.0 and later.
if version >= 500

  " Switch on syntax highlighting if it wasn't on yet.
  if !exists("syntax_on")
    syntax on
  endif

  " For Win32 version, have "K" lookup the keyword in a help file
  "if has("win32")
  "  let winhelpfile='windows.hlp'
  "  map K :execute "!start winhlp32 -k <cword> " . winhelpfile <CR>
  "endif

  " Set nice colors
  " background for normal text is light grey
  " Text below the last line is darker grey
  " Cursor is green, Cyan when ":lmap" mappings are active
  " Constants are not underlined but have a slightly lighter background
  highlight Normal guibg=grey90
  highlight Cursor guibg=Green guifg=NONE
  highlight lCursor guibg=Cyan guifg=NONE
  highlight NonText guibg=grey80
  highlight Constant gui=NONE guibg=grey95
  highlight Special gui=NONE guibg=grey95

endif

" Determine the LC_CTYPE locale category setting and try to set guifontset accordingly:

let tmplang = $LC_ALL
if tmplang =~ "^$"
  let tmplang = $LC_CTYPE
endif
if tmplang =~ "^$"
  let tmplang = $LANG
endif
if tmplang =~ "^$"
  let tmplang = "en_US"
endif

if tmplang =~ "^ko"
  set guifont=Luxi\ Mono
elseif tmplang =~ "^ja"
  set guifont=Luxi\ Mono
elseif tmplang =~ "^zh"
  set guifont=Luxi\ Mono
else
  set guifont=monospace
endif


" /etc/gvimrc ends here
