require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_TIPC_H_)) {
    eval 'sub _LINUX_TIPC_H_ () {1;}' unless defined(&_LINUX_TIPC_H_);
    require 'linux/types.ph';
    require 'linux/sockios.ph';
    eval 'sub TIPC_NODE_STATE () {0;}' unless defined(&TIPC_NODE_STATE);
    eval 'sub TIPC_TOP_SRV () {1;}' unless defined(&TIPC_TOP_SRV);
    eval 'sub TIPC_LINK_STATE () {2;}' unless defined(&TIPC_LINK_STATE);
    eval 'sub TIPC_RESERVED_TYPES () {64;}' unless defined(&TIPC_RESERVED_TYPES);
    eval("sub TIPC_CLUSTER_SCOPE () { 2; }") unless defined(&TIPC_CLUSTER_SCOPE);
    eval("sub TIPC_NODE_SCOPE () { 3; }") unless defined(&TIPC_NODE_SCOPE);
    eval 'sub TIPC_MAX_USER_MSG_SIZE () {66000;}' unless defined(&TIPC_MAX_USER_MSG_SIZE);
    eval 'sub TIPC_LOW_IMPORTANCE () {0;}' unless defined(&TIPC_LOW_IMPORTANCE);
    eval 'sub TIPC_MEDIUM_IMPORTANCE () {1;}' unless defined(&TIPC_MEDIUM_IMPORTANCE);
    eval 'sub TIPC_HIGH_IMPORTANCE () {2;}' unless defined(&TIPC_HIGH_IMPORTANCE);
    eval 'sub TIPC_CRITICAL_IMPORTANCE () {3;}' unless defined(&TIPC_CRITICAL_IMPORTANCE);
    eval 'sub TIPC_OK () {0;}' unless defined(&TIPC_OK);
    eval 'sub TIPC_ERR_NO_NAME () {1;}' unless defined(&TIPC_ERR_NO_NAME);
    eval 'sub TIPC_ERR_NO_PORT () {2;}' unless defined(&TIPC_ERR_NO_PORT);
    eval 'sub TIPC_ERR_NO_NODE () {3;}' unless defined(&TIPC_ERR_NO_NODE);
    eval 'sub TIPC_ERR_OVERLOAD () {4;}' unless defined(&TIPC_ERR_OVERLOAD);
    eval 'sub TIPC_CONN_SHUTDOWN () {5;}' unless defined(&TIPC_CONN_SHUTDOWN);
    eval 'sub TIPC_SUB_PORTS () {0x1;}' unless defined(&TIPC_SUB_PORTS);
    eval 'sub TIPC_SUB_SERVICE () {0x2;}' unless defined(&TIPC_SUB_SERVICE);
    eval 'sub TIPC_SUB_CANCEL () {0x4;}' unless defined(&TIPC_SUB_CANCEL);
    eval 'sub TIPC_WAIT_FOREVER () {(~0);}' unless defined(&TIPC_WAIT_FOREVER);
    eval 'sub TIPC_PUBLISHED () {1;}' unless defined(&TIPC_PUBLISHED);
    eval 'sub TIPC_WITHDRAWN () {2;}' unless defined(&TIPC_WITHDRAWN);
    eval 'sub TIPC_SUBSCR_TIMEOUT () {3;}' unless defined(&TIPC_SUBSCR_TIMEOUT);
    unless(defined(&AF_TIPC)) {
	eval 'sub AF_TIPC () {30;}' unless defined(&AF_TIPC);
    }
    unless(defined(&PF_TIPC)) {
	eval 'sub PF_TIPC () { &AF_TIPC;}' unless defined(&PF_TIPC);
    }
    unless(defined(&SOL_TIPC)) {
	eval 'sub SOL_TIPC () {271;}' unless defined(&SOL_TIPC);
    }
    eval 'sub TIPC_ADDR_MCAST () {1;}' unless defined(&TIPC_ADDR_MCAST);
    eval 'sub TIPC_SERVICE_RANGE () {1;}' unless defined(&TIPC_SERVICE_RANGE);
    eval 'sub TIPC_SERVICE_ADDR () {2;}' unless defined(&TIPC_SERVICE_ADDR);
    eval 'sub TIPC_SOCKET_ADDR () {3;}' unless defined(&TIPC_SOCKET_ADDR);
    eval 'sub TIPC_ERRINFO () {1;}' unless defined(&TIPC_ERRINFO);
    eval 'sub TIPC_RETDATA () {2;}' unless defined(&TIPC_RETDATA);
    eval 'sub TIPC_DESTNAME () {3;}' unless defined(&TIPC_DESTNAME);
    eval 'sub TIPC_IMPORTANCE () {127;}' unless defined(&TIPC_IMPORTANCE);
    eval 'sub TIPC_SRC_DROPPABLE () {128;}' unless defined(&TIPC_SRC_DROPPABLE);
    eval 'sub TIPC_DEST_DROPPABLE () {129;}' unless defined(&TIPC_DEST_DROPPABLE);
    eval 'sub TIPC_CONN_TIMEOUT () {130;}' unless defined(&TIPC_CONN_TIMEOUT);
    eval 'sub TIPC_NODE_RECVQ_DEPTH () {131;}' unless defined(&TIPC_NODE_RECVQ_DEPTH);
    eval 'sub TIPC_SOCK_RECVQ_DEPTH () {132;}' unless defined(&TIPC_SOCK_RECVQ_DEPTH);
    eval 'sub TIPC_MCAST_BROADCAST () {133;}' unless defined(&TIPC_MCAST_BROADCAST);
    eval 'sub TIPC_MCAST_REPLICAST () {134;}' unless defined(&TIPC_MCAST_REPLICAST);
    eval 'sub TIPC_GROUP_JOIN () {135;}' unless defined(&TIPC_GROUP_JOIN);
    eval 'sub TIPC_GROUP_LEAVE () {136;}' unless defined(&TIPC_GROUP_LEAVE);
    eval 'sub TIPC_SOCK_RECVQ_USED () {137;}' unless defined(&TIPC_SOCK_RECVQ_USED);
    eval 'sub TIPC_NODELAY () {138;}' unless defined(&TIPC_NODELAY);
    eval 'sub TIPC_GROUP_LOOPBACK () {0x1;}' unless defined(&TIPC_GROUP_LOOPBACK);
    eval 'sub TIPC_GROUP_MEMBER_EVTS () {0x2;}' unless defined(&TIPC_GROUP_MEMBER_EVTS);
    eval 'sub TIPC_NODEID_LEN () {16;}' unless defined(&TIPC_NODEID_LEN);
    eval 'sub TIPC_MAX_MEDIA_NAME () {16;}' unless defined(&TIPC_MAX_MEDIA_NAME);
    eval 'sub TIPC_MAX_IF_NAME () {16;}' unless defined(&TIPC_MAX_IF_NAME);
    eval 'sub TIPC_MAX_BEARER_NAME () {32;}' unless defined(&TIPC_MAX_BEARER_NAME);
    eval 'sub TIPC_MAX_LINK_NAME () {68;}' unless defined(&TIPC_MAX_LINK_NAME);
    eval 'sub SIOCGETLINKNAME () { &SIOCPROTOPRIVATE;}' unless defined(&SIOCGETLINKNAME);
    eval 'sub SIOCGETNODEID () {( &SIOCPROTOPRIVATE + 1);}' unless defined(&SIOCGETNODEID);
    eval 'sub TIPC_AEAD_ALG_NAME () {(32);}' unless defined(&TIPC_AEAD_ALG_NAME);
    eval 'sub TIPC_AEAD_KEYLEN_MIN () {(16+ 4);}' unless defined(&TIPC_AEAD_KEYLEN_MIN);
    eval 'sub TIPC_AEAD_KEYLEN_MAX () {(32+ 4);}' unless defined(&TIPC_AEAD_KEYLEN_MAX);
    eval 'sub TIPC_AEAD_KEY_SIZE_MAX () {($sizeof{\'struct tipc_aead_key\'} +  &TIPC_AEAD_KEYLEN_MAX);}' unless defined(&TIPC_AEAD_KEY_SIZE_MAX);
    eval 'sub tipc_aead_key_size {
        my($key) = @_;
	    eval q({ $sizeof{$key} +  ($key->{keylen}); });
    }' unless defined(&tipc_aead_key_size);
    eval 'sub TIPC_CFG_SRV () {0;}' unless defined(&TIPC_CFG_SRV);
    eval 'sub TIPC_ZONE_SCOPE () {1;}' unless defined(&TIPC_ZONE_SCOPE);
    eval 'sub TIPC_ADDR_NAMESEQ () {1;}' unless defined(&TIPC_ADDR_NAMESEQ);
    eval 'sub TIPC_ADDR_NAME () {2;}' unless defined(&TIPC_ADDR_NAME);
    eval 'sub TIPC_ADDR_ID () {3;}' unless defined(&TIPC_ADDR_ID);
    eval 'sub TIPC_NODE_BITS () {12;}' unless defined(&TIPC_NODE_BITS);
    eval 'sub TIPC_CLUSTER_BITS () {12;}' unless defined(&TIPC_CLUSTER_BITS);
    eval 'sub TIPC_ZONE_BITS () {8;}' unless defined(&TIPC_ZONE_BITS);
    eval 'sub TIPC_NODE_OFFSET () {0;}' unless defined(&TIPC_NODE_OFFSET);
    eval 'sub TIPC_CLUSTER_OFFSET () { &TIPC_NODE_BITS;}' unless defined(&TIPC_CLUSTER_OFFSET);
    eval 'sub TIPC_ZONE_OFFSET () {( &TIPC_CLUSTER_OFFSET +  &TIPC_CLUSTER_BITS);}' unless defined(&TIPC_ZONE_OFFSET);
    eval 'sub TIPC_NODE_SIZE () {((1 <<  &TIPC_NODE_BITS) - 1);}' unless defined(&TIPC_NODE_SIZE);
    eval 'sub TIPC_CLUSTER_SIZE () {((1 <<  &TIPC_CLUSTER_BITS) - 1);}' unless defined(&TIPC_CLUSTER_SIZE);
    eval 'sub TIPC_ZONE_SIZE () {((1 <<  &TIPC_ZONE_BITS) - 1);}' unless defined(&TIPC_ZONE_SIZE);
    eval 'sub TIPC_NODE_MASK () {( &TIPC_NODE_SIZE <<  &TIPC_NODE_OFFSET);}' unless defined(&TIPC_NODE_MASK);
    eval 'sub TIPC_CLUSTER_MASK () {( &TIPC_CLUSTER_SIZE <<  &TIPC_CLUSTER_OFFSET);}' unless defined(&TIPC_CLUSTER_MASK);
    eval 'sub TIPC_ZONE_MASK () {( &TIPC_ZONE_SIZE <<  &TIPC_ZONE_OFFSET);}' unless defined(&TIPC_ZONE_MASK);
    eval 'sub TIPC_ZONE_CLUSTER_MASK () {( &TIPC_ZONE_MASK |  &TIPC_CLUSTER_MASK);}' unless defined(&TIPC_ZONE_CLUSTER_MASK);
    eval 'sub tipc_portid () { &tipc_socket_addr;}' unless defined(&tipc_portid);
    eval 'sub tipc_name () { &tipc_service_addr;}' unless defined(&tipc_name);
    eval 'sub tipc_name_seq () { &tipc_service_range;}' unless defined(&tipc_name_seq);
    eval 'sub tipc_addr {
        my($zone,$cluster,$node) = @_;
	    eval q({ ($zone <<  &TIPC_ZONE_OFFSET) | ($cluster <<  &TIPC_CLUSTER_OFFSET) | $node; });
    }' unless defined(&tipc_addr);
    eval 'sub tipc_zone {
        my($addr) = @_;
	    eval q({ $addr >>  &TIPC_ZONE_OFFSET; });
    }' unless defined(&tipc_zone);
    eval 'sub tipc_cluster {
        my($addr) = @_;
	    eval q({ ($addr &  &TIPC_CLUSTER_MASK) >>  &TIPC_CLUSTER_OFFSET; });
    }' unless defined(&tipc_cluster);
    eval 'sub tipc_node {
        my($addr) = @_;
	    eval q({ $addr &  &TIPC_NODE_MASK; });
    }' unless defined(&tipc_node);
}
1;
