.TH "ZIP_GET_NAME" "3" "February 20, 2013" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_get_name\fP
\- get name of file by index
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
const char *
zip_get_name zip_t *archive zip_uint64_t index zip_flags_t flags
.SH "DESCRIPTION"
The
zip_get_name
function returns the name of the file at position
\fIindex\fP
in
\fIarchive\fP.
The name is in UTF-8 encoding unless
\fRZIP_FL_ENC_RAW\fP
was specified (see below).
.PP
If
\fIflags\fP
is set to
\fRZIP_FL_UNCHANGED\fP,
the original unchanged filename is returned.
The returned string must not be modified or freed, and becomes invalid when
\fIarchive\fP
is closed.
.PP
Additionally, the following
\fIflags\fP
are supported:
.TP ZIP_FL_ENC_STRICTXX
\fRZIP_FL_ENC_RAW\fP
Return the unmodified names as it is in the ZIP archive.
.TP ZIP_FL_ENC_STRICTXX
\fRZIP_FL_ENC_GUESS\fP
(Default.)
Guess the encoding of the name in the ZIP archive and convert it
to UTF-8, if necessary.
.TP ZIP_FL_ENC_STRICTXX
\fRZIP_FL_ENC_STRICT\fP
Follow the ZIP specification and expect CP-437 encoded names in
the ZIP archive (except if they are explicitly marked as UTF-8).
Convert it to UTF-8.
\fINote\fP:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the name is returned.
Otherwise,
\fRNULL\fP
and the error code in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_get_name
fails if:
.TP 17n
[\fRZIP_ER_DELETED\fP]
\fIindex\fP
refers to a file that has been deleted
(see
zip_delete(3)).
.TP 17n
[\fRZIP_ER_INVAL\fP]
\fIindex\fP
is not a valid file index in
\fIarchive\fP,
or
\fIindex\fP
points to an added file and
\fRZIP_FL_UNCHANGED\fP
is set.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_name_locate(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
