.TH sane\-mustek_pp 5 "13 Jul 2008"
.de EX
.sp
.nf
.ft CW
..
.de EE
.ft R
.fi
.sp
..
.IX sane\-mustek_pp
.SH NAME
sane\-mustek_pp \- SANE backend for Mustek parallel port flatbed scanners
.SH DESCRIPTION
The
.B sane\-mustek_pp
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Mustek parallel port flatbed scanners and OEM versions.

There are 2 classes of Mustek parallel port scanners: regular
.B CCD
(cold cathode device) scanners and
.B CIS
(contact image sensor) scanners.
.P
The current version of this backend supports both CCD type scanners and
CIS type scanners.
.P
The following scanners might work with this backend:

.SS "CCD scanners"

.EX
Model:                  ASIC ID:        CCD Type:       works:
--------------------------------------------------------------
SE 6000 P               1013            00              yes
SM 4800 P               1013/1015       04/01           yes
SE 1200 ED Plus         1015            01              no
SM 1200 ED Plus         1015            01              no
SE 12000 P              1505            05              no
600 III EP Plus         1013/1015       00/01           yes
SE 600 SEP              1013            ??              yes
600 II EP               ????            ??              no
MD9848                  1015            00              yes
Gallery 4800            ????            ??              yes
Viviscan Compact II     1013            00              yes
.EE
.SS CIS scanners
.EX
Model:                  ASIC ID:        works:
-----------------------------------------------
Mustek 600 CP & 96 CP   1015            yes (*)
Mustek 1200 CP          1015            yes
Mustek 1200 CP+         1015            yes
.EE

.EX
OEM versions            Original        works
--------------------------------------------------
Medion/LifeTec/Tevion
   MD/LT 9350/9351      1200 CP         yes
   MD/LT 9850/9851      1200 CP         maybe (**)
   MD/LT 9858           1200 CP         probably
   MD/LT 9890/9891      1200 CP         yes
Targa
   Funline TS12EP       1200 CP         yes
   Funline TS6EP        600 CP          yes
Trust
   Easy Connect 9600+   600 CP          yes
Cybercom
   9352                 1200 CP         yes (***)
.EE
.HP
(*)    Calibration  problems existed with earlier version of
this driver. They seem to be solved now.
.HP
(**)   Problems have been reported in the past for the
MD/LT9850 type (striped scans, head moving in wrong
direction at some resolutions). It is not known whether
the current version of the driver still has these problems.
.PP
.B  IF YOU HEAR LOUD CLICKING NOISES, IMMEDIATELY UNPLUG THE SCANNER !
(This holds for any type of scanner).
.HP
(***)  Possibly, the engine_delay parameter has to be set to 1 ms
for accurate engine movements.
.PP
Please note that this backend is still under construction. Certain models
are currently not supported and some may never be because the communication
protocol is still unknown (eg., SE 12000 P).
.PP
Some scanners work faster when
.B EPP/ECP
is enabled in the BIOS. EPP mode however may lead to hard-locks on some Linux
systems. If that is the case for you, you can either disable ECP/EPP in your
BIOS or disable it in the backend itself (see GLOBAL OPTIONS).
.PP
Note that the backend needs to run as root or has to have appropriate access
rights to
.I /dev/parport*
if libieee1284 support is compiled in. To allow user
access to the scanner run the backend through the network interface (See
.BR saned (8)
and
.BR sane\-net (5)).
Note also that the backend
.I does not
support
.IR "parport sharing" ,
i.e. if you try printing while scanning, your computer may crash. To enable
parport sharing, you have to enable libieee1284 at compile time. This backend
also conflicts with the
.BR sane\-musteka4s2 (5)
backend. You can only enable one of them in your
.IR dll.conf .
However, you have
to enable the backend explicitly in your
.IR dll.conf ,
just remove the hash mark in the line "mustek_pp".

.SH "DEVICE DEFINITION"
This backend allows multiple devices being defined and configured via the
.I mustek_pp.conf
file (even simultaneously, provided that they are connected to different
parallel ports). Please make sure to edit this file
.B before
you use the backend.
.PP
A device can be defined as follows:
.PP
.RS
.I scanner <name> <port name> <driver>
.RE
.PP
where
.HP
.B <name>
is an arbitrary name for the device, optionally enclosed by double quotes,
for instance "LifeTec 9350".
.HP
.B <port name>
is the name of the parallel port to which the device is connected. In case
libieee1284 is used for communication with the port
.I (default
.IR setup) ,
valid port names are
.BR parport0 ,
.BR parport1 ,
and
.BR parport2 .
.PP
In case the backend is configured for raw IO
.I (old
.IR setup) ,
port addresses have to be used instead of port names:
.BR 0x378 ,
.BR 0x278 ,
or
.BR 0x3BC .
The mapping of parallel ports (lp0, lp1, and lp2) to these addresses
can be different for different Linux kernel versions. For instance,
if you are using a Kernel 2.2.x or better and you have only one
parallel port, this port is named lp0 regardless of the base address. However,
this backend requires the base address of your port. If you are not sure which
port your scanner is connected to, have a look at your
.IR /etc/conf.modules ,
.I /etc/modules.conf
and/or
.IR /proc/ioports .
.PP
If you are unsure which port to use, you can use the magic value
.BR *
to probe for your scanner.
.PP
.HP
.B <driver>
is the driver to use for this device. Currently available drivers are:
.IP
.BR cis600 "   : for 600 CP, 96 CP & OEM versions"
.br
.BR cis1200 "  : for 1200 CP & OEM versions"
.br
.BR cis1200+ " : for 1200 CP+ & OEM versions"
.br
.BR ccd300 "   : for 600 IIIE P & OEM version"
.IP
.B Choosing  the  wrong  driver  can  damage  your scanner!
.br
Especially, using the 1200CP settings on a 600CP can be
harmful. If the scanner starts making a loud noise, turn
it off immediately !!!
.PP
Using the cis600 driver on a 1200CP or a 1200CP+ is probably not
dangerous. The cis1200+ driver also works for the 1200CP, and using
the cis1200 driver on a 1200CP+ will typically result in scans that
cover only half of the width of the scan area (also not dangerous).
.PP
If unsure about the exact model of your OEM version, check the optical
resolution in the manual or on the box: the 600CP has a maximum optical
resolution of 300x600 DPI, whereas the 1200CP and 1200CP+ have a maximum
optical resolution of 600x1200 DPI.
.PP
Examples:
.PP
.RS
scanner "LifeTec 9350" 0x378 cis1200
.PP
scanner Mustek_600CP 0x378 cis600
.PP
scanner Mustek_600IIIEP * ccd300
.RE

If in doubt which port you have to use, or whether your scanner is
detected at all, you can use
.I sane\-find\-scanner \-p
to probe all configured ports.

.SH CONFIGURATION
.PP
The contents of the
.I mustek_pp.conf
file is a list of device definitions and device options that correspond to
Mustek scanners.  Empty lines and lines starting with a hash mark (#) are
ignored. Options have the following format:
.PP
.RS
.I option <name> [<value>]
.RE
.PP
Depending on the nature of the option, a value may or may not be present.
Options always apply to the scanner definition that precedes them. There
are no global options. Options are also driver-specific: not all drivers
support all possible options.

.SS Common options
.TP
.B bw <value>
Black/white discrimination value to be used during lineart scanning. Pixel
values below this value are assumed to be black, values above are
assumed to be white.
.br
Default value: 127
.br
Minimum:         0
.br
Maximum:       255
.sp
Example:  option bw 150

.SS CIS driver options
.TP
.B top_adjust <value>
Vertical adjustment of the origin, expressed in millimeter (floating point).
This option can be used to calibrate the position of the origin, within
certain limits. Note that CIS scanners are probably temperature sensitive, and
that a certain inaccuracy may be hard to avoid. Differences in offset between
runs in the order of 1 to 2 mm are not unusual.
.br
Default value: 0.0
.br
Minimum:      \-5.0
.br
Maximum:       5.0
.br
.sp
Example:  option top_adjust \-2.5
.TP
.B slow_skip
Turns fast skipping to the start of the scan region off. When the region to
scan does not start at the origin, the driver will try to move the scanhead
to the start of the scan area at the fastest possible speed. On some models,
this may not work, resulting in large inaccuracies (up to centimeters).
By setting this option, the driver is forced to use normal speed during
skipping, which can circumvent the accuracy problems. Currently, there are
no models for which these inaccuracy problems are known to occur.
.sp
By default, fast skipping is used.
.sp
Example:  option slow_skip
.TP
.B engine_delay <value>
Under normal circumstances, it is sufficient for the driver to wait for the
scanner signaling that the engine is stable, before a new engine command can
be transmitted. In rare cases, certain scanners and/or parallel port chipsets
appear to prevent reliable detection of the engine state. As a result, engine
commands are transmitted too soon and the movement of the scanner head becomes
unreliable. Inaccuracies ranging up to 10 cm over the whole vertical scan
range have been reported. To work around this problem, the engine_delay option
can be set. If it is set, the driver waits an additional amount of time after
every engine command, equal to the engine_delay parameter, expressed in
milliseconds. It practice an engine_delay of 1 ms is usually sufficient. The
maximum delay is 100 ms.
.sp
Note that every additional ms of delay can add up to 14 seconds to the total
scanning time (highest resolution), so an as small as possible value is
preferred.
.sp
Default value:   0
.br
Minimum:         0
.br
Maximum:       100
.sp
Example:  option engine_delay 1

.SS CCD driver options
.TP
.B top <value>
Number of scanlines to skip to the start of the scan area. The number can
be any positive integer. Values known to me are 47 and 56.
.sp
Default value: 47
.br
Minimum:       0
.br
Maximum:       none
.br
.sp
Example:  option top 56
.TP
.B waitbank <value>
The number of usecs to wait for a bank change. You should not touch this
value actually. May be any positive integer
.sp
Default value: 700
.br
Minimum:       0
.br
Maximum:       none
.sp
Example:  option waitbank 700
.PP
A sample configuration file is shown below:
.PP
.EX
#
# LifeTec/Medion 9350 on port 0x378
#
scanner "LifeTec 9350" 0x378 cis1200

# Some calibration options (examples!).
option bw 127
option top_skip \-0.8

#
# A Mustek 600CP on port 0x3BC
#
scanner "Mustek 600CP" 0x3BC cis600

# Some calibration options (examples!).
option bw 120
option top_skip 1.2

#
# A Mustek 1200CP+ on port 0x278
#
scanner "Mustek 1200CP plus" 0x278 cis1200+

# Some calibration options (examples!).
option bw 130
option top_skip 0.2

#
# A Mustek 600 III EPP on port parport0
#
scanner "Mustek 600 III EPP" parport0 ccd300

# Some calibration options (examples!).
option bw 130
option top 56
.EE

.SH GLOBAL OPTIONS
.PP
You can control the overall behaviour of the
.B sane-\mustek_pp
backend by global
options which precede any scanner definition in the
.I mustek_pp.conf
file.
.sp
Currently, there is only one global option:

.SS Global options
.TP
.B no_epp
Disable parallel port mode EPP: works around a known bug in the Linux parport
code. Enable this option, if the backend hangs when trying to access the
parallel port in EPP mode.
.sp
Default value: use EPP
.sp
Example:  option no_epp

.SH FILES
.TP
.I @CONFIGDIR@/mustek_pp.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-mustek_pp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-mustek_pp.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR "tmp/config" ,
.IR "." ,
and
.I "@CONFIGDIR@"
being searched (in this order).
.TP
.B SANE_DEBUG_MUSTEK_PP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.
.EX
level   debug output
--------------------------------------
 0      nothing
 1      errors
 2      warnings & minor errors
 3      additional information
 4      debug information
 5      code flow (not supported yet)
 6      special debug information
.EE
.TP
.B SANE_DEBUG_SANEI_PA4S2
This variable sets the debug level for the SANE interface for the Mustek
chipset A4S2. Note that enabling this will spam your terminal with some
million lines of debug output.
.EX
level   debug output
----------------------------
 0      nothing
 1      errors
 2      warnings
 3      things nice to know
 4      code flow
 5      detailed code flow
 6      everything
.EE

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-mustek (5),
.BR sane\-net (5),
.BR saned (8),
.BR sane\-find\-scanner (1),
.BR scanimage (1)

.TP
For latest bug fixes and information see
.I http://www.penguin\-breeder.org/sane/mustek_pp/

.TP
For additional information on the CIS driver, see
.I http://home.scarlet.be/eddy_de_greef/

.SH AUTHORS
.nf
Jochen Eisinger
.RI < "jochen at penguin\-breeder dot org" >
Eddy De Greef
.RI < "eddy_de_greef at scarlet dot be" >
.fi

.SH BUGS
Too many... please send bug reports to
.I sane\-devel@alioth-lists.debian.net
(note that you have to subscribe first to the list before you can send
emails... see
.IR http://www.sane\-project.org/mailing\-lists.html ).

.SH BUG REPORTS
If something doesn't work, please contact us (Jochen for the CCD scanners,
Eddy for the CIS scanners). But we need some information about
your scanner to be able to help you...

.TP
.I SANE version
Run
.I scanimage \-V
to determine this.
.TP
.I the backend version and your scanner hardware
Run
.I SANE_DEBUG_MUSTEK_PP=128 scanimage \-L
as root. If you don't get any output from the
.BR sane\-mustek_pp
backend, make sure a line "mustek_pp" is included into your
.IR @CONFIGDIR@/dll.conf .
If your scanner isn't detected, make sure you've defined the right port address
in your
.IR mustek_pp.conf .
.TP
.I the name of your scanner/vendor also a worthy information. Please also include the
optical resolution and lamp type of your scanner, both can be found in the manual of
your scanner.
.TP
.I any further comments
if you have comments about the documentation (what could be done better), or you
think I should know something, please include it.
