/* $Id: tstIEMAImplDataFpuOther.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data - r150967 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_UNARY_R80_TEST_T const g_aTests_fabs_r80[] =
{
    { 0x007f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/0/m = #0 */
    { 0x0000, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/0/u = #1 */
    { 0x017f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/1/m = #2 */
    { 0x0100, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/1/u = #3 */
    { 0x027f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/2/m = #4 */
    { 0x0200, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/2/u = #5 */
    { 0x037f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/3/m = #6 */
    { 0x0300, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/0/3/u = #7 */
    { 0x047f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/0/m = #8 */
    { 0x0400, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/0/u = #9 */
    { 0x057f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/1/m = #10 */
    { 0x0500, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/1/u = #11 */
    { 0x067f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/2/m = #12 */
    { 0x0600, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/2/u = #13 */
    { 0x077f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/3/m = #14 */
    { 0x0700, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/1/3/u = #15 */
    { 0x087f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/0/m = #16 */
    { 0x0800, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/0/u = #17 */
    { 0x097f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/1/m = #18 */
    { 0x0900, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/1/u = #19 */
    { 0x0a7f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/2/m = #20 */
    { 0x0a00, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/2/u = #21 */
    { 0x0b7f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/3/m = #22 */
    { 0x0b00, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/2/3/u = #23 */
    { 0x0c7f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/0/m = #24 */
    { 0x0c00, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/0/u = #25 */
    { 0x0d7f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/1/m = #26 */
    { 0x0d00, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/1/u = #27 */
    { 0x0e7f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/2/m = #28 */
    { 0x0e00, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/2/u = #29 */
    { 0x0f7f, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/3/m = #30 */
    { 0x0f00, 0xdf8c, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f0e76ed71d0dc95,16336), RTFLOAT80U_INIT_C(0,0x8f0e76ed71d0dc95,16336) }, /* #0/3/3/u = #31 */
    { 0x007f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/0/m = #32 */
    { 0x0000, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/0/u = #33 */
    { 0x017f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/1/m = #34 */
    { 0x0100, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/1/u = #35 */
    { 0x027f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/2/m = #36 */
    { 0x0200, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/2/u = #37 */
    { 0x037f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/3/m = #38 */
    { 0x0300, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/0/3/u = #39 */
    { 0x047f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/0/m = #40 */
    { 0x0400, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/0/u = #41 */
    { 0x057f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/1/m = #42 */
    { 0x0500, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/1/u = #43 */
    { 0x067f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/2/m = #44 */
    { 0x0600, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/2/u = #45 */
    { 0x077f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/3/m = #46 */
    { 0x0700, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/1/3/u = #47 */
    { 0x087f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/0/m = #48 */
    { 0x0800, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/0/u = #49 */
    { 0x097f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/1/m = #50 */
    { 0x0900, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/1/u = #51 */
    { 0x0a7f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/2/m = #52 */
    { 0x0a00, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/2/u = #53 */
    { 0x0b7f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/3/m = #54 */
    { 0x0b00, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/2/3/u = #55 */
    { 0x0c7f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/0/m = #56 */
    { 0x0c00, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/0/u = #57 */
    { 0x0d7f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/1/m = #58 */
    { 0x0d00, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/1/u = #59 */
    { 0x0e7f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/2/m = #60 */
    { 0x0e00, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/2/u = #61 */
    { 0x0f7f, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/3/m = #62 */
    { 0x0f00, 0x2314, 0x3900, RTFLOAT80U_INIT_C(1,0xd6d54c7727e69b27,22714), RTFLOAT80U_INIT_C(0,0xd6d54c7727e69b27,22714) }, /* #1/3/3/u = #63 */
    { 0x007f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/0/m = #64 */
    { 0x0000, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/0/u = #65 */
    { 0x017f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/1/m = #66 */
    { 0x0100, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/1/u = #67 */
    { 0x027f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/2/m = #68 */
    { 0x0200, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/2/u = #69 */
    { 0x037f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/3/m = #70 */
    { 0x0300, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/0/3/u = #71 */
    { 0x047f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/0/m = #72 */
    { 0x0400, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/0/u = #73 */
    { 0x057f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/1/m = #74 */
    { 0x0500, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/1/u = #75 */
    { 0x067f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/2/m = #76 */
    { 0x0600, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/2/u = #77 */
    { 0x077f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/3/m = #78 */
    { 0x0700, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/1/3/u = #79 */
    { 0x087f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/0/m = #80 */
    { 0x0800, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/0/u = #81 */
    { 0x097f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/1/m = #82 */
    { 0x0900, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/1/u = #83 */
    { 0x0a7f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/2/m = #84 */
    { 0x0a00, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/2/u = #85 */
    { 0x0b7f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/3/m = #86 */
    { 0x0b00, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/2/3/u = #87 */
    { 0x0c7f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/0/m = #88 */
    { 0x0c00, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/0/u = #89 */
    { 0x0d7f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/1/m = #90 */
    { 0x0d00, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/1/u = #91 */
    { 0x0e7f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/2/m = #92 */
    { 0x0e00, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/2/u = #93 */
    { 0x0f7f, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/3/m = #94 */
    { 0x0f00, 0x7265, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #2/3/3/u = #95 */
    { 0x007f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/0/m = #96 */
    { 0x0000, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/0/u = #97 */
    { 0x017f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/1/m = #98 */
    { 0x0100, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/1/u = #99 */
    { 0x027f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/2/m = #100 */
    { 0x0200, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/2/u = #101 */
    { 0x037f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/3/m = #102 */
    { 0x0300, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/0/3/u = #103 */
    { 0x047f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/0/m = #104 */
    { 0x0400, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/0/u = #105 */
    { 0x057f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/1/m = #106 */
    { 0x0500, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/1/u = #107 */
    { 0x067f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/2/m = #108 */
    { 0x0600, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/2/u = #109 */
    { 0x077f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/3/m = #110 */
    { 0x0700, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/1/3/u = #111 */
    { 0x087f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/0/m = #112 */
    { 0x0800, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/0/u = #113 */
    { 0x097f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/1/m = #114 */
    { 0x0900, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/1/u = #115 */
    { 0x0a7f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/2/m = #116 */
    { 0x0a00, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/2/u = #117 */
    { 0x0b7f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/3/m = #118 */
    { 0x0b00, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/2/3/u = #119 */
    { 0x0c7f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/0/m = #120 */
    { 0x0c00, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/0/u = #121 */
    { 0x0d7f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/1/m = #122 */
    { 0x0d00, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/1/u = #123 */
    { 0x0e7f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/2/m = #124 */
    { 0x0e00, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/2/u = #125 */
    { 0x0f7f, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/3/m = #126 */
    { 0x0f00, 0x079d, 0x3d00, RTFLOAT80U_INIT_C(0,0x59295bc,3746), RTFLOAT80U_INIT_C(0,0x59295bc,3746) }, /* #3/3/3/u = #127 */
    { 0x007f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/0/m = #128 */
    { 0x0000, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/0/u = #129 */
    { 0x017f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/1/m = #130 */
    { 0x0100, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/1/u = #131 */
    { 0x027f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/2/m = #132 */
    { 0x0200, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/2/u = #133 */
    { 0x037f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/3/m = #134 */
    { 0x0300, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/0/3/u = #135 */
    { 0x047f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/0/m = #136 */
    { 0x0400, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/0/u = #137 */
    { 0x057f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/1/m = #138 */
    { 0x0500, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/1/u = #139 */
    { 0x067f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/2/m = #140 */
    { 0x0600, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/2/u = #141 */
    { 0x077f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/3/m = #142 */
    { 0x0700, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/1/3/u = #143 */
    { 0x087f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/0/m = #144 */
    { 0x0800, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/0/u = #145 */
    { 0x097f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/1/m = #146 */
    { 0x0900, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/1/u = #147 */
    { 0x0a7f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/2/m = #148 */
    { 0x0a00, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/2/u = #149 */
    { 0x0b7f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/3/m = #150 */
    { 0x0b00, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/2/3/u = #151 */
    { 0x0c7f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/0/m = #152 */
    { 0x0c00, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/0/u = #153 */
    { 0x0d7f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/1/m = #154 */
    { 0x0d00, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/1/u = #155 */
    { 0x0e7f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/2/m = #156 */
    { 0x0e00, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/2/u = #157 */
    { 0x0f7f, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/3/m = #158 */
    { 0x0f00, 0x803b, 0x3800, RTFLOAT80U_INIT_C(1,0x4e81bd4e09794281,68), RTFLOAT80U_INIT_C(0,0x4e81bd4e09794281,68) }, /* #4/3/3/u = #159 */
    { 0x007f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/0/m = #160 */
    { 0x0000, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/0/u = #161 */
    { 0x017f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/1/m = #162 */
    { 0x0100, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/1/u = #163 */
    { 0x027f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/2/m = #164 */
    { 0x0200, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/2/u = #165 */
    { 0x037f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/3/m = #166 */
    { 0x0300, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/0/3/u = #167 */
    { 0x047f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/0/m = #168 */
    { 0x0400, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/0/u = #169 */
    { 0x057f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/1/m = #170 */
    { 0x0500, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/1/u = #171 */
    { 0x067f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/2/m = #172 */
    { 0x0600, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/2/u = #173 */
    { 0x077f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/3/m = #174 */
    { 0x0700, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/1/3/u = #175 */
    { 0x087f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/0/m = #176 */
    { 0x0800, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/0/u = #177 */
    { 0x097f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/1/m = #178 */
    { 0x0900, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/1/u = #179 */
    { 0x0a7f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/2/m = #180 */
    { 0x0a00, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/2/u = #181 */
    { 0x0b7f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/3/m = #182 */
    { 0x0b00, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/2/3/u = #183 */
    { 0x0c7f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/0/m = #184 */
    { 0x0c00, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/0/u = #185 */
    { 0x0d7f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/1/m = #186 */
    { 0x0d00, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/1/u = #187 */
    { 0x0e7f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/2/m = #188 */
    { 0x0e00, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/2/u = #189 */
    { 0x0f7f, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/3/m = #190 */
    { 0x0f00, 0x3098, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000039220,32767), RTFLOAT80U_INIT_C(0,0x8000000000039220,32767) }, /* #5/3/3/u = #191 */
    { 0x007f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/0/m = #192 */
    { 0x0000, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/0/u = #193 */
    { 0x017f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/1/m = #194 */
    { 0x0100, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/1/u = #195 */
    { 0x027f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/2/m = #196 */
    { 0x0200, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/2/u = #197 */
    { 0x037f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/3/m = #198 */
    { 0x0300, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/0/3/u = #199 */
    { 0x047f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/0/m = #200 */
    { 0x0400, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/0/u = #201 */
    { 0x057f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/1/m = #202 */
    { 0x0500, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/1/u = #203 */
    { 0x067f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/2/m = #204 */
    { 0x0600, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/2/u = #205 */
    { 0x077f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/3/m = #206 */
    { 0x0700, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/1/3/u = #207 */
    { 0x087f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/0/m = #208 */
    { 0x0800, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/0/u = #209 */
    { 0x097f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/1/m = #210 */
    { 0x0900, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/1/u = #211 */
    { 0x0a7f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/2/m = #212 */
    { 0x0a00, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/2/u = #213 */
    { 0x0b7f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/3/m = #214 */
    { 0x0b00, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/2/3/u = #215 */
    { 0x0c7f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/0/m = #216 */
    { 0x0c00, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/0/u = #217 */
    { 0x0d7f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/1/m = #218 */
    { 0x0d00, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/1/u = #219 */
    { 0x0e7f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/2/m = #220 */
    { 0x0e00, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/2/u = #221 */
    { 0x0f7f, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/3/m = #222 */
    { 0x0f00, 0x506b, 0x7800, RTFLOAT80U_INIT_C(1,0x93e273c980026f1b,32767), RTFLOAT80U_INIT_C(0,0x93e273c980026f1b,32767) }, /* #6/3/3/u = #223 */
    { 0x007f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/0/m = #224 */
    { 0x0000, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/0/u = #225 */
    { 0x017f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/1/m = #226 */
    { 0x0100, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/1/u = #227 */
    { 0x027f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/2/m = #228 */
    { 0x0200, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/2/u = #229 */
    { 0x037f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/3/m = #230 */
    { 0x0300, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/0/3/u = #231 */
    { 0x047f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/0/m = #232 */
    { 0x0400, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/0/u = #233 */
    { 0x057f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/1/m = #234 */
    { 0x0500, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/1/u = #235 */
    { 0x067f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/2/m = #236 */
    { 0x0600, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/2/u = #237 */
    { 0x077f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/3/m = #238 */
    { 0x0700, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/1/3/u = #239 */
    { 0x087f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/0/m = #240 */
    { 0x0800, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/0/u = #241 */
    { 0x097f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/1/m = #242 */
    { 0x0900, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/1/u = #243 */
    { 0x0a7f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/2/m = #244 */
    { 0x0a00, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/2/u = #245 */
    { 0x0b7f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/3/m = #246 */
    { 0x0b00, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/2/3/u = #247 */
    { 0x0c7f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/0/m = #248 */
    { 0x0c00, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/0/u = #249 */
    { 0x0d7f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/1/m = #250 */
    { 0x0d00, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/1/u = #251 */
    { 0x0e7f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/2/m = #252 */
    { 0x0e00, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/2/u = #253 */
    { 0x0f7f, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/3/m = #254 */
    { 0x0f00, 0x18ae, 0x3800, RTFLOAT80U_INIT_C(0,0xc000000000000015,32767), RTFLOAT80U_INIT_C(0,0xc000000000000015,32767) }, /* #7/3/3/u = #255 */
    { 0x007f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/0/m = #256 */
    { 0x0000, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/0/u = #257 */
    { 0x017f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/1/m = #258 */
    { 0x0100, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/1/u = #259 */
    { 0x027f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/2/m = #260 */
    { 0x0200, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/2/u = #261 */
    { 0x037f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/3/m = #262 */
    { 0x0300, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/0/3/u = #263 */
    { 0x047f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/0/m = #264 */
    { 0x0400, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/0/u = #265 */
    { 0x057f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/1/m = #266 */
    { 0x0500, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/1/u = #267 */
    { 0x067f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/2/m = #268 */
    { 0x0600, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/2/u = #269 */
    { 0x077f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/3/m = #270 */
    { 0x0700, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/1/3/u = #271 */
    { 0x087f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/0/m = #272 */
    { 0x0800, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/0/u = #273 */
    { 0x097f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/1/m = #274 */
    { 0x0900, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/1/u = #275 */
    { 0x0a7f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/2/m = #276 */
    { 0x0a00, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/2/u = #277 */
    { 0x0b7f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/3/m = #278 */
    { 0x0b00, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/2/3/u = #279 */
    { 0x0c7f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/0/m = #280 */
    { 0x0c00, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/0/u = #281 */
    { 0x0d7f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/1/m = #282 */
    { 0x0d00, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/1/u = #283 */
    { 0x0e7f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/2/m = #284 */
    { 0x0e00, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/2/u = #285 */
    { 0x0f7f, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/3/m = #286 */
    { 0x0f00, 0x9771, 0x3d00, RTFLOAT80U_INIT_C(1,0xceb154ed0b5aaecd,32767), RTFLOAT80U_INIT_C(0,0xceb154ed0b5aaecd,32767) }, /* #8/3/3/u = #287 */
    { 0x007f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/0/m = #288 */
    { 0x0000, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/0/u = #289 */
    { 0x017f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/1/m = #290 */
    { 0x0100, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/1/u = #291 */
    { 0x027f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/2/m = #292 */
    { 0x0200, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/2/u = #293 */
    { 0x037f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/3/m = #294 */
    { 0x0300, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/0/3/u = #295 */
    { 0x047f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/0/m = #296 */
    { 0x0400, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/0/u = #297 */
    { 0x057f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/1/m = #298 */
    { 0x0500, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/1/u = #299 */
    { 0x067f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/2/m = #300 */
    { 0x0600, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/2/u = #301 */
    { 0x077f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/3/m = #302 */
    { 0x0700, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/1/3/u = #303 */
    { 0x087f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/0/m = #304 */
    { 0x0800, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/0/u = #305 */
    { 0x097f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/1/m = #306 */
    { 0x0900, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/1/u = #307 */
    { 0x0a7f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/2/m = #308 */
    { 0x0a00, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/2/u = #309 */
    { 0x0b7f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/3/m = #310 */
    { 0x0b00, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/2/3/u = #311 */
    { 0x0c7f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/0/m = #312 */
    { 0x0c00, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/0/u = #313 */
    { 0x0d7f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/1/m = #314 */
    { 0x0d00, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/1/u = #315 */
    { 0x0e7f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/2/m = #316 */
    { 0x0e00, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/2/u = #317 */
    { 0x0f7f, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/3/m = #318 */
    { 0x0f00, 0xb562, 0x3d00, RTFLOAT80U_INIT_C(1,0x400000006d21efc2,32767), RTFLOAT80U_INIT_C(0,0x400000006d21efc2,32767) }, /* #9/3/3/u = #319 */
    { 0x007f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/0/m = #320 */
    { 0x0000, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/0/u = #321 */
    { 0x017f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/1/m = #322 */
    { 0x0100, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/1/u = #323 */
    { 0x027f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/2/m = #324 */
    { 0x0200, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/2/u = #325 */
    { 0x037f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/3/m = #326 */
    { 0x0300, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/0/3/u = #327 */
    { 0x047f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/0/m = #328 */
    { 0x0400, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/0/u = #329 */
    { 0x057f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/1/m = #330 */
    { 0x0500, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/1/u = #331 */
    { 0x067f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/2/m = #332 */
    { 0x0600, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/2/u = #333 */
    { 0x077f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/3/m = #334 */
    { 0x0700, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/1/3/u = #335 */
    { 0x087f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/0/m = #336 */
    { 0x0800, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/0/u = #337 */
    { 0x097f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/1/m = #338 */
    { 0x0900, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/1/u = #339 */
    { 0x0a7f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/2/m = #340 */
    { 0x0a00, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/2/u = #341 */
    { 0x0b7f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/3/m = #342 */
    { 0x0b00, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/2/3/u = #343 */
    { 0x0c7f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/0/m = #344 */
    { 0x0c00, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/0/u = #345 */
    { 0x0d7f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/1/m = #346 */
    { 0x0d00, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/1/u = #347 */
    { 0x0e7f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/2/m = #348 */
    { 0x0e00, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/2/u = #349 */
    { 0x0f7f, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/3/m = #350 */
    { 0x0f00, 0x18bb, 0x3800, RTFLOAT80U_INIT_C(1,0x363caee02e484b46,32767), RTFLOAT80U_INIT_C(0,0x363caee02e484b46,32767) }, /* #10/3/3/u = #351 */
    { 0x007f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/0/m = #352 */
    { 0x0000, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/0/u = #353 */
    { 0x017f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/1/m = #354 */
    { 0x0100, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/1/u = #355 */
    { 0x027f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/2/m = #356 */
    { 0x0200, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/2/u = #357 */
    { 0x037f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/3/m = #358 */
    { 0x0300, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/0/3/u = #359 */
    { 0x047f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/0/m = #360 */
    { 0x0400, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/0/u = #361 */
    { 0x057f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/1/m = #362 */
    { 0x0500, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/1/u = #363 */
    { 0x067f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/2/m = #364 */
    { 0x0600, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/2/u = #365 */
    { 0x077f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/3/m = #366 */
    { 0x0700, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/1/3/u = #367 */
    { 0x087f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/0/m = #368 */
    { 0x0800, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/0/u = #369 */
    { 0x097f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/1/m = #370 */
    { 0x0900, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/1/u = #371 */
    { 0x0a7f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/2/m = #372 */
    { 0x0a00, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/2/u = #373 */
    { 0x0b7f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/3/m = #374 */
    { 0x0b00, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/2/3/u = #375 */
    { 0x0c7f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/0/m = #376 */
    { 0x0c00, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/0/u = #377 */
    { 0x0d7f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/1/m = #378 */
    { 0x0d00, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/1/u = #379 */
    { 0x0e7f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/2/m = #380 */
    { 0x0e00, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/2/u = #381 */
    { 0x0f7f, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/3/m = #382 */
    { 0x0f00, 0x094d, 0x3900, RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0), RTFLOAT80U_INIT_C(0,0x800000bf9a116f94,0) }, /* #11/3/3/u = #383 */
    { 0x007f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/0/m = #384 */
    { 0x0000, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/0/u = #385 */
    { 0x017f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/1/m = #386 */
    { 0x0100, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/1/u = #387 */
    { 0x027f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/2/m = #388 */
    { 0x0200, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/2/u = #389 */
    { 0x037f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/3/m = #390 */
    { 0x0300, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/0/3/u = #391 */
    { 0x047f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/0/m = #392 */
    { 0x0400, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/0/u = #393 */
    { 0x057f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/1/m = #394 */
    { 0x0500, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/1/u = #395 */
    { 0x067f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/2/m = #396 */
    { 0x0600, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/2/u = #397 */
    { 0x077f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/3/m = #398 */
    { 0x0700, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/1/3/u = #399 */
    { 0x087f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/0/m = #400 */
    { 0x0800, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/0/u = #401 */
    { 0x097f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/1/m = #402 */
    { 0x0900, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/1/u = #403 */
    { 0x0a7f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/2/m = #404 */
    { 0x0a00, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/2/u = #405 */
    { 0x0b7f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/3/m = #406 */
    { 0x0b00, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/2/3/u = #407 */
    { 0x0c7f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/0/m = #408 */
    { 0x0c00, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/0/u = #409 */
    { 0x0d7f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/1/m = #410 */
    { 0x0d00, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/1/u = #411 */
    { 0x0e7f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/2/m = #412 */
    { 0x0e00, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/2/u = #413 */
    { 0x0f7f, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/3/m = #414 */
    { 0x0f00, 0xa808, 0x3800, RTFLOAT80U_INIT_C(1,0x84703769f227e766,0), RTFLOAT80U_INIT_C(0,0x84703769f227e766,0) }, /* #12/3/3/u = #415 */
    { 0x007f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/0/m = #416 */
    { 0x0000, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/0/u = #417 */
    { 0x017f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/1/m = #418 */
    { 0x0100, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/1/u = #419 */
    { 0x027f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/2/m = #420 */
    { 0x0200, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/2/u = #421 */
    { 0x037f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/3/m = #422 */
    { 0x0300, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/0/3/u = #423 */
    { 0x047f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/0/m = #424 */
    { 0x0400, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/0/u = #425 */
    { 0x057f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/1/m = #426 */
    { 0x0500, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/1/u = #427 */
    { 0x067f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/2/m = #428 */
    { 0x0600, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/2/u = #429 */
    { 0x077f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/3/m = #430 */
    { 0x0700, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/1/3/u = #431 */
    { 0x087f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/0/m = #432 */
    { 0x0800, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/0/u = #433 */
    { 0x097f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/1/m = #434 */
    { 0x0900, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/1/u = #435 */
    { 0x0a7f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/2/m = #436 */
    { 0x0a00, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/2/u = #437 */
    { 0x0b7f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/3/m = #438 */
    { 0x0b00, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/2/3/u = #439 */
    { 0x0c7f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/0/m = #440 */
    { 0x0c00, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/0/u = #441 */
    { 0x0d7f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/1/m = #442 */
    { 0x0d00, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/1/u = #443 */
    { 0x0e7f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/2/m = #444 */
    { 0x0e00, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/2/u = #445 */
    { 0x0f7f, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/3/m = #446 */
    { 0x0f00, 0x1811, 0x3800, RTFLOAT80U_INIT_C(1,0x60bcd0ae8d01,0), RTFLOAT80U_INIT_C(0,0x60bcd0ae8d01,0) }, /* #13/3/3/u = #447 */
    { 0x007f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/0/m = #448 */
    { 0x0000, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/0/u = #449 */
    { 0x017f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/1/m = #450 */
    { 0x0100, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/1/u = #451 */
    { 0x027f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/2/m = #452 */
    { 0x0200, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/2/u = #453 */
    { 0x037f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/3/m = #454 */
    { 0x0300, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/0/3/u = #455 */
    { 0x047f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/0/m = #456 */
    { 0x0400, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/0/u = #457 */
    { 0x057f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/1/m = #458 */
    { 0x0500, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/1/u = #459 */
    { 0x067f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/2/m = #460 */
    { 0x0600, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/2/u = #461 */
    { 0x077f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/3/m = #462 */
    { 0x0700, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/1/3/u = #463 */
    { 0x087f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/0/m = #464 */
    { 0x0800, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/0/u = #465 */
    { 0x097f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/1/m = #466 */
    { 0x0900, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/1/u = #467 */
    { 0x0a7f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/2/m = #468 */
    { 0x0a00, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/2/u = #469 */
    { 0x0b7f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/3/m = #470 */
    { 0x0b00, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/2/3/u = #471 */
    { 0x0c7f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/0/m = #472 */
    { 0x0c00, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/0/u = #473 */
    { 0x0d7f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/1/m = #474 */
    { 0x0d00, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/1/u = #475 */
    { 0x0e7f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/2/m = #476 */
    { 0x0e00, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/2/u = #477 */
    { 0x0f7f, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/3/m = #478 */
    { 0x0f00, 0xd28a, 0x7800, RTFLOAT80U_INIT_C(1,0x257b1d528dba60b8,0), RTFLOAT80U_INIT_C(0,0x257b1d528dba60b8,0) }, /* #14/3/3/u = #479 */
    { 0x007f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/0/m = #480 */
    { 0x0000, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/0/u = #481 */
    { 0x017f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/1/m = #482 */
    { 0x0100, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/1/u = #483 */
    { 0x027f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/2/m = #484 */
    { 0x0200, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/2/u = #485 */
    { 0x037f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/3/m = #486 */
    { 0x0300, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/0/3/u = #487 */
    { 0x047f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/0/m = #488 */
    { 0x0400, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/0/u = #489 */
    { 0x057f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/1/m = #490 */
    { 0x0500, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/1/u = #491 */
    { 0x067f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/2/m = #492 */
    { 0x0600, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/2/u = #493 */
    { 0x077f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/3/m = #494 */
    { 0x0700, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/1/3/u = #495 */
    { 0x087f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/0/m = #496 */
    { 0x0800, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/0/u = #497 */
    { 0x097f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/1/m = #498 */
    { 0x0900, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/1/u = #499 */
    { 0x0a7f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/2/m = #500 */
    { 0x0a00, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/2/u = #501 */
    { 0x0b7f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/3/m = #502 */
    { 0x0b00, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/2/3/u = #503 */
    { 0x0c7f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/0/m = #504 */
    { 0x0c00, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/0/u = #505 */
    { 0x0d7f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/1/m = #506 */
    { 0x0d00, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/1/u = #507 */
    { 0x0e7f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/2/m = #508 */
    { 0x0e00, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/2/u = #509 */
    { 0x0f7f, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/3/m = #510 */
    { 0x0f00, 0xfb1e, 0x7900, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #15/3/3/u = #511 */
    { 0x007f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/0/m = #512 */
    { 0x0000, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/0/u = #513 */
    { 0x017f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/1/m = #514 */
    { 0x0100, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/1/u = #515 */
    { 0x027f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/2/m = #516 */
    { 0x0200, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/2/u = #517 */
    { 0x037f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/3/m = #518 */
    { 0x0300, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/3/u = #519 */
    { 0x047f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/0/m = #520 */
    { 0x0400, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/0/u = #521 */
    { 0x057f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/1/m = #522 */
    { 0x0500, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/1/u = #523 */
    { 0x067f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/2/m = #524 */
    { 0x0600, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/2/u = #525 */
    { 0x077f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/3/m = #526 */
    { 0x0700, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/3/u = #527 */
    { 0x087f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/0/m = #528 */
    { 0x0800, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/0/u = #529 */
    { 0x097f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/1/m = #530 */
    { 0x0900, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/1/u = #531 */
    { 0x0a7f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/2/m = #532 */
    { 0x0a00, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/2/u = #533 */
    { 0x0b7f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/3/m = #534 */
    { 0x0b00, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/3/u = #535 */
    { 0x0c7f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/0/m = #536 */
    { 0x0c00, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/0/u = #537 */
    { 0x0d7f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/1/m = #538 */
    { 0x0d00, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/1/u = #539 */
    { 0x0e7f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/2/m = #540 */
    { 0x0e00, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/2/u = #541 */
    { 0x0f7f, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/3/m = #542 */
    { 0x0f00, 0x1485, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/3/u = #543 */
    { 0x007f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/0/m = #544 */
    { 0x0000, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/0/u = #545 */
    { 0x017f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/1/m = #546 */
    { 0x0100, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/1/u = #547 */
    { 0x027f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/2/m = #548 */
    { 0x0200, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/2/u = #549 */
    { 0x037f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/3/m = #550 */
    { 0x0300, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/3/u = #551 */
    { 0x047f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/0/m = #552 */
    { 0x0400, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/0/u = #553 */
    { 0x057f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/1/m = #554 */
    { 0x0500, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/1/u = #555 */
    { 0x067f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/2/m = #556 */
    { 0x0600, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/2/u = #557 */
    { 0x077f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/3/m = #558 */
    { 0x0700, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/3/u = #559 */
    { 0x087f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/0/m = #560 */
    { 0x0800, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/0/u = #561 */
    { 0x097f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/1/m = #562 */
    { 0x0900, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/1/u = #563 */
    { 0x0a7f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/2/m = #564 */
    { 0x0a00, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/2/u = #565 */
    { 0x0b7f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/3/m = #566 */
    { 0x0b00, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/3/u = #567 */
    { 0x0c7f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/0/m = #568 */
    { 0x0c00, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/0/u = #569 */
    { 0x0d7f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/1/m = #570 */
    { 0x0d00, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/1/u = #571 */
    { 0x0e7f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/2/m = #572 */
    { 0x0e00, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/2/u = #573 */
    { 0x0f7f, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/3/m = #574 */
    { 0x0f00, 0xd2dd, 0x7800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/3/u = #575 */
    { 0x007f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/0/m = #576 */
    { 0x0000, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/0/u = #577 */
    { 0x017f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/1/m = #578 */
    { 0x0100, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/1/u = #579 */
    { 0x027f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/2/m = #580 */
    { 0x0200, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/2/u = #581 */
    { 0x037f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/3/m = #582 */
    { 0x0300, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/0/3/u = #583 */
    { 0x047f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/0/m = #584 */
    { 0x0400, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/0/u = #585 */
    { 0x057f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/1/m = #586 */
    { 0x0500, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/1/u = #587 */
    { 0x067f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/2/m = #588 */
    { 0x0600, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/2/u = #589 */
    { 0x077f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/3/m = #590 */
    { 0x0700, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/1/3/u = #591 */
    { 0x087f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/0/m = #592 */
    { 0x0800, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/0/u = #593 */
    { 0x097f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/1/m = #594 */
    { 0x0900, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/1/u = #595 */
    { 0x0a7f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/2/m = #596 */
    { 0x0a00, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/2/u = #597 */
    { 0x0b7f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/3/m = #598 */
    { 0x0b00, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/2/3/u = #599 */
    { 0x0c7f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/0/m = #600 */
    { 0x0c00, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/0/u = #601 */
    { 0x0d7f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/1/m = #602 */
    { 0x0d00, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/1/u = #603 */
    { 0x0e7f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/2/m = #604 */
    { 0x0e00, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/2/u = #605 */
    { 0x0f7f, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/3/m = #606 */
    { 0x0f00, 0x14bd, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #18/3/3/u = #607 */
    { 0x007f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/0/m = #608 */
    { 0x0000, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/0/u = #609 */
    { 0x017f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/1/m = #610 */
    { 0x0100, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/1/u = #611 */
    { 0x027f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/2/m = #612 */
    { 0x0200, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/2/u = #613 */
    { 0x037f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/3/m = #614 */
    { 0x0300, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/0/3/u = #615 */
    { 0x047f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/0/m = #616 */
    { 0x0400, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/0/u = #617 */
    { 0x057f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/1/m = #618 */
    { 0x0500, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/1/u = #619 */
    { 0x067f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/2/m = #620 */
    { 0x0600, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/2/u = #621 */
    { 0x077f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/3/m = #622 */
    { 0x0700, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/1/3/u = #623 */
    { 0x087f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/0/m = #624 */
    { 0x0800, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/0/u = #625 */
    { 0x097f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/1/m = #626 */
    { 0x0900, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/1/u = #627 */
    { 0x0a7f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/2/m = #628 */
    { 0x0a00, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/2/u = #629 */
    { 0x0b7f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/3/m = #630 */
    { 0x0b00, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/2/3/u = #631 */
    { 0x0c7f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/0/m = #632 */
    { 0x0c00, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/0/u = #633 */
    { 0x0d7f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/1/m = #634 */
    { 0x0d00, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/1/u = #635 */
    { 0x0e7f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/2/m = #636 */
    { 0x0e00, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/2/u = #637 */
    { 0x0f7f, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/3/m = #638 */
    { 0x0f00, 0x4cb9, 0x7c00, RTFLOAT80U_INIT_C(1,0x13da98100aa,12334), RTFLOAT80U_INIT_C(0,0x13da98100aa,12334) }, /* #19/3/3/u = #639 */
    { 0x007f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/0/m = #640 */
    { 0x0000, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/0/u = #641 */
    { 0x017f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/1/m = #642 */
    { 0x0100, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/1/u = #643 */
    { 0x027f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/2/m = #644 */
    { 0x0200, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/2/u = #645 */
    { 0x037f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/3/m = #646 */
    { 0x0300, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/0/3/u = #647 */
    { 0x047f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/0/m = #648 */
    { 0x0400, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/0/u = #649 */
    { 0x057f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/1/m = #650 */
    { 0x0500, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/1/u = #651 */
    { 0x067f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/2/m = #652 */
    { 0x0600, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/2/u = #653 */
    { 0x077f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/3/m = #654 */
    { 0x0700, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/1/3/u = #655 */
    { 0x087f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/0/m = #656 */
    { 0x0800, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/0/u = #657 */
    { 0x097f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/1/m = #658 */
    { 0x0900, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/1/u = #659 */
    { 0x0a7f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/2/m = #660 */
    { 0x0a00, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/2/u = #661 */
    { 0x0b7f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/3/m = #662 */
    { 0x0b00, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/2/3/u = #663 */
    { 0x0c7f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/0/m = #664 */
    { 0x0c00, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/0/u = #665 */
    { 0x0d7f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/1/m = #666 */
    { 0x0d00, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/1/u = #667 */
    { 0x0e7f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/2/m = #668 */
    { 0x0e00, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/2/u = #669 */
    { 0x0f7f, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/3/m = #670 */
    { 0x0f00, 0x5d85, 0x7d00, RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767), RTFLOAT80U_INIT_C(0,0xf0e1e0d0b1d7d301,32767) }, /* #20/3/3/u = #671 */
    { 0x007f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/0/m = #672 */
    { 0x0000, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/0/u = #673 */
    { 0x017f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/1/m = #674 */
    { 0x0100, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/1/u = #675 */
    { 0x027f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/2/m = #676 */
    { 0x0200, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/2/u = #677 */
    { 0x037f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/3/m = #678 */
    { 0x0300, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/0/3/u = #679 */
    { 0x047f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/0/m = #680 */
    { 0x0400, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/0/u = #681 */
    { 0x057f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/1/m = #682 */
    { 0x0500, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/1/u = #683 */
    { 0x067f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/2/m = #684 */
    { 0x0600, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/2/u = #685 */
    { 0x077f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/3/m = #686 */
    { 0x0700, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/1/3/u = #687 */
    { 0x087f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/0/m = #688 */
    { 0x0800, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/0/u = #689 */
    { 0x097f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/1/m = #690 */
    { 0x0900, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/1/u = #691 */
    { 0x0a7f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/2/m = #692 */
    { 0x0a00, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/2/u = #693 */
    { 0x0b7f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/3/m = #694 */
    { 0x0b00, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/2/3/u = #695 */
    { 0x0c7f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/0/m = #696 */
    { 0x0c00, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/0/u = #697 */
    { 0x0d7f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/1/m = #698 */
    { 0x0d00, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/1/u = #699 */
    { 0x0e7f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/2/m = #700 */
    { 0x0e00, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/2/u = #701 */
    { 0x0f7f, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/3/m = #702 */
    { 0x0f00, 0xf182, 0x7900, RTFLOAT80U_INIT_C(1,0xa0e87d403eaa93da,12040), RTFLOAT80U_INIT_C(0,0xa0e87d403eaa93da,12040) }, /* #21/3/3/u = #703 */
    { 0x007f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/0/m = #704 */
    { 0x0000, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/0/u = #705 */
    { 0x017f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/1/m = #706 */
    { 0x0100, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/1/u = #707 */
    { 0x027f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/2/m = #708 */
    { 0x0200, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/2/u = #709 */
    { 0x037f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/3/m = #710 */
    { 0x0300, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/0/3/u = #711 */
    { 0x047f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/0/m = #712 */
    { 0x0400, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/0/u = #713 */
    { 0x057f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/1/m = #714 */
    { 0x0500, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/1/u = #715 */
    { 0x067f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/2/m = #716 */
    { 0x0600, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/2/u = #717 */
    { 0x077f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/3/m = #718 */
    { 0x0700, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/1/3/u = #719 */
    { 0x087f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/0/m = #720 */
    { 0x0800, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/0/u = #721 */
    { 0x097f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/1/m = #722 */
    { 0x0900, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/1/u = #723 */
    { 0x0a7f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/2/m = #724 */
    { 0x0a00, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/2/u = #725 */
    { 0x0b7f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/3/m = #726 */
    { 0x0b00, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/2/3/u = #727 */
    { 0x0c7f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/0/m = #728 */
    { 0x0c00, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/0/u = #729 */
    { 0x0d7f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/1/m = #730 */
    { 0x0d00, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/1/u = #731 */
    { 0x0e7f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/2/m = #732 */
    { 0x0e00, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/2/u = #733 */
    { 0x0f7f, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/3/m = #734 */
    { 0x0f00, 0x3c9d, 0x3c00, RTFLOAT80U_INIT_C(1,0xc61de63ca4c5dd61,7612), RTFLOAT80U_INIT_C(0,0xc61de63ca4c5dd61,7612) }, /* #22/3/3/u = #735 */
    { 0x007f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/0/m = #736 */
    { 0x0000, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/0/u = #737 */
    { 0x017f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/1/m = #738 */
    { 0x0100, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/1/u = #739 */
    { 0x027f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/2/m = #740 */
    { 0x0200, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/2/u = #741 */
    { 0x037f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/3/m = #742 */
    { 0x0300, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/0/3/u = #743 */
    { 0x047f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/0/m = #744 */
    { 0x0400, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/0/u = #745 */
    { 0x057f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/1/m = #746 */
    { 0x0500, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/1/u = #747 */
    { 0x067f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/2/m = #748 */
    { 0x0600, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/2/u = #749 */
    { 0x077f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/3/m = #750 */
    { 0x0700, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/1/3/u = #751 */
    { 0x087f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/0/m = #752 */
    { 0x0800, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/0/u = #753 */
    { 0x097f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/1/m = #754 */
    { 0x0900, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/1/u = #755 */
    { 0x0a7f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/2/m = #756 */
    { 0x0a00, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/2/u = #757 */
    { 0x0b7f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/3/m = #758 */
    { 0x0b00, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/2/3/u = #759 */
    { 0x0c7f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/0/m = #760 */
    { 0x0c00, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/0/u = #761 */
    { 0x0d7f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/1/m = #762 */
    { 0x0d00, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/1/u = #763 */
    { 0x0e7f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/2/m = #764 */
    { 0x0e00, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/2/u = #765 */
    { 0x0f7f, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/3/m = #766 */
    { 0x0f00, 0xb3b6, 0x3900, RTFLOAT80U_INIT_C(1,0x63c68b3c2fe4aa6d,5961), RTFLOAT80U_INIT_C(0,0x63c68b3c2fe4aa6d,5961) }, /* #23/3/3/u = #767 */
    { 0x007f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/0/m = #768 */
    { 0x0000, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/0/u = #769 */
    { 0x017f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/1/m = #770 */
    { 0x0100, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/1/u = #771 */
    { 0x027f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/2/m = #772 */
    { 0x0200, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/2/u = #773 */
    { 0x037f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/3/m = #774 */
    { 0x0300, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/0/3/u = #775 */
    { 0x047f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/0/m = #776 */
    { 0x0400, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/0/u = #777 */
    { 0x057f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/1/m = #778 */
    { 0x0500, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/1/u = #779 */
    { 0x067f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/2/m = #780 */
    { 0x0600, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/2/u = #781 */
    { 0x077f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/3/m = #782 */
    { 0x0700, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/1/3/u = #783 */
    { 0x087f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/0/m = #784 */
    { 0x0800, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/0/u = #785 */
    { 0x097f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/1/m = #786 */
    { 0x0900, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/1/u = #787 */
    { 0x0a7f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/2/m = #788 */
    { 0x0a00, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/2/u = #789 */
    { 0x0b7f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/3/m = #790 */
    { 0x0b00, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/2/3/u = #791 */
    { 0x0c7f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/0/m = #792 */
    { 0x0c00, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/0/u = #793 */
    { 0x0d7f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/1/m = #794 */
    { 0x0d00, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/1/u = #795 */
    { 0x0e7f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/2/m = #796 */
    { 0x0e00, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/2/u = #797 */
    { 0x0f7f, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/3/m = #798 */
    { 0x0f00, 0x749c, 0x7c00, RTFLOAT80U_INIT_C(1,0xe18427b416042e23,32767), RTFLOAT80U_INIT_C(0,0xe18427b416042e23,32767) }, /* #24/3/3/u = #799 */
    { 0x007f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/0/m = #800 */
    { 0x0000, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/0/u = #801 */
    { 0x017f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/1/m = #802 */
    { 0x0100, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/1/u = #803 */
    { 0x027f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/2/m = #804 */
    { 0x0200, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/2/u = #805 */
    { 0x037f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/3/m = #806 */
    { 0x0300, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/0/3/u = #807 */
    { 0x047f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/0/m = #808 */
    { 0x0400, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/0/u = #809 */
    { 0x057f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/1/m = #810 */
    { 0x0500, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/1/u = #811 */
    { 0x067f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/2/m = #812 */
    { 0x0600, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/2/u = #813 */
    { 0x077f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/3/m = #814 */
    { 0x0700, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/1/3/u = #815 */
    { 0x087f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/0/m = #816 */
    { 0x0800, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/0/u = #817 */
    { 0x097f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/1/m = #818 */
    { 0x0900, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/1/u = #819 */
    { 0x0a7f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/2/m = #820 */
    { 0x0a00, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/2/u = #821 */
    { 0x0b7f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/3/m = #822 */
    { 0x0b00, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/2/3/u = #823 */
    { 0x0c7f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/0/m = #824 */
    { 0x0c00, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/0/u = #825 */
    { 0x0d7f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/1/m = #826 */
    { 0x0d00, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/1/u = #827 */
    { 0x0e7f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/2/m = #828 */
    { 0x0e00, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/2/u = #829 */
    { 0x0f7f, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/3/m = #830 */
    { 0x0f00, 0x948b, 0x3c00, RTFLOAT80U_INIT_C(1,0x33fae1aea297565f,9104), RTFLOAT80U_INIT_C(0,0x33fae1aea297565f,9104) }, /* #25/3/3/u = #831 */
    { 0x007f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/0/m = #832 */
    { 0x0000, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/0/u = #833 */
    { 0x017f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/1/m = #834 */
    { 0x0100, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/1/u = #835 */
    { 0x027f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/2/m = #836 */
    { 0x0200, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/2/u = #837 */
    { 0x037f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/3/m = #838 */
    { 0x0300, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/0/3/u = #839 */
    { 0x047f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/0/m = #840 */
    { 0x0400, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/0/u = #841 */
    { 0x057f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/1/m = #842 */
    { 0x0500, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/1/u = #843 */
    { 0x067f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/2/m = #844 */
    { 0x0600, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/2/u = #845 */
    { 0x077f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/3/m = #846 */
    { 0x0700, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/1/3/u = #847 */
    { 0x087f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/0/m = #848 */
    { 0x0800, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/0/u = #849 */
    { 0x097f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/1/m = #850 */
    { 0x0900, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/1/u = #851 */
    { 0x0a7f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/2/m = #852 */
    { 0x0a00, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/2/u = #853 */
    { 0x0b7f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/3/m = #854 */
    { 0x0b00, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/2/3/u = #855 */
    { 0x0c7f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/0/m = #856 */
    { 0x0c00, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/0/u = #857 */
    { 0x0d7f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/1/m = #858 */
    { 0x0d00, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/1/u = #859 */
    { 0x0e7f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/2/m = #860 */
    { 0x0e00, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/2/u = #861 */
    { 0x0f7f, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/3/m = #862 */
    { 0x0f00, 0x8992, 0x3900, RTFLOAT80U_INIT_C(1,0x89bc2ec5b9562e1a,1974), RTFLOAT80U_INIT_C(0,0x89bc2ec5b9562e1a,1974) }, /* #26/3/3/u = #863 */
    { 0x007f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/0/m = #864 */
    { 0x0000, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/0/u = #865 */
    { 0x017f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/1/m = #866 */
    { 0x0100, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/1/u = #867 */
    { 0x027f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/2/m = #868 */
    { 0x0200, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/2/u = #869 */
    { 0x037f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/3/m = #870 */
    { 0x0300, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/0/3/u = #871 */
    { 0x047f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/0/m = #872 */
    { 0x0400, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/0/u = #873 */
    { 0x057f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/1/m = #874 */
    { 0x0500, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/1/u = #875 */
    { 0x067f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/2/m = #876 */
    { 0x0600, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/2/u = #877 */
    { 0x077f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/3/m = #878 */
    { 0x0700, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/1/3/u = #879 */
    { 0x087f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/0/m = #880 */
    { 0x0800, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/0/u = #881 */
    { 0x097f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/1/m = #882 */
    { 0x0900, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/1/u = #883 */
    { 0x0a7f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/2/m = #884 */
    { 0x0a00, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/2/u = #885 */
    { 0x0b7f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/3/m = #886 */
    { 0x0b00, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/2/3/u = #887 */
    { 0x0c7f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/0/m = #888 */
    { 0x0c00, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/0/u = #889 */
    { 0x0d7f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/1/m = #890 */
    { 0x0d00, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/1/u = #891 */
    { 0x0e7f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/2/m = #892 */
    { 0x0e00, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/2/u = #893 */
    { 0x0f7f, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/3/m = #894 */
    { 0x0f00, 0xc225, 0x7800, RTFLOAT80U_INIT_C(1,0x90405367192c35f1,0), RTFLOAT80U_INIT_C(0,0x90405367192c35f1,0) }, /* #27/3/3/u = #895 */
    { 0x007f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/0/m = #896 */
    { 0x0000, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/0/u = #897 */
    { 0x017f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/1/m = #898 */
    { 0x0100, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/1/u = #899 */
    { 0x027f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/2/m = #900 */
    { 0x0200, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/2/u = #901 */
    { 0x037f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/3/m = #902 */
    { 0x0300, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/0/3/u = #903 */
    { 0x047f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/0/m = #904 */
    { 0x0400, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/0/u = #905 */
    { 0x057f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/1/m = #906 */
    { 0x0500, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/1/u = #907 */
    { 0x067f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/2/m = #908 */
    { 0x0600, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/2/u = #909 */
    { 0x077f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/3/m = #910 */
    { 0x0700, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/1/3/u = #911 */
    { 0x087f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/0/m = #912 */
    { 0x0800, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/0/u = #913 */
    { 0x097f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/1/m = #914 */
    { 0x0900, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/1/u = #915 */
    { 0x0a7f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/2/m = #916 */
    { 0x0a00, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/2/u = #917 */
    { 0x0b7f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/3/m = #918 */
    { 0x0b00, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/2/3/u = #919 */
    { 0x0c7f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/0/m = #920 */
    { 0x0c00, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/0/u = #921 */
    { 0x0d7f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/1/m = #922 */
    { 0x0d00, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/1/u = #923 */
    { 0x0e7f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/2/m = #924 */
    { 0x0e00, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/2/u = #925 */
    { 0x0f7f, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/3/m = #926 */
    { 0x0f00, 0x7ae5, 0x7800, RTFLOAT80U_INIT_C(1,0xa13d6bcfa16aa7cf,27056), RTFLOAT80U_INIT_C(0,0xa13d6bcfa16aa7cf,27056) }, /* #28/3/3/u = #927 */
    { 0x007f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/0/m = #928 */
    { 0x0000, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/0/u = #929 */
    { 0x017f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/1/m = #930 */
    { 0x0100, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/1/u = #931 */
    { 0x027f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/2/m = #932 */
    { 0x0200, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/2/u = #933 */
    { 0x037f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/3/m = #934 */
    { 0x0300, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/0/3/u = #935 */
    { 0x047f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/0/m = #936 */
    { 0x0400, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/0/u = #937 */
    { 0x057f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/1/m = #938 */
    { 0x0500, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/1/u = #939 */
    { 0x067f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/2/m = #940 */
    { 0x0600, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/2/u = #941 */
    { 0x077f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/3/m = #942 */
    { 0x0700, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/1/3/u = #943 */
    { 0x087f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/0/m = #944 */
    { 0x0800, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/0/u = #945 */
    { 0x097f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/1/m = #946 */
    { 0x0900, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/1/u = #947 */
    { 0x0a7f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/2/m = #948 */
    { 0x0a00, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/2/u = #949 */
    { 0x0b7f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/3/m = #950 */
    { 0x0b00, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/2/3/u = #951 */
    { 0x0c7f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/0/m = #952 */
    { 0x0c00, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/0/u = #953 */
    { 0x0d7f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/1/m = #954 */
    { 0x0d00, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/1/u = #955 */
    { 0x0e7f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/2/m = #956 */
    { 0x0e00, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/2/u = #957 */
    { 0x0f7f, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/3/m = #958 */
    { 0x0f00, 0x71b0, 0x7900, RTFLOAT80U_INIT_C(1,0x154a42,4664), RTFLOAT80U_INIT_C(0,0x154a42,4664) }, /* #29/3/3/u = #959 */
    { 0x007f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/0/m = #960 */
    { 0x0000, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/0/u = #961 */
    { 0x017f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/1/m = #962 */
    { 0x0100, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/1/u = #963 */
    { 0x027f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/2/m = #964 */
    { 0x0200, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/2/u = #965 */
    { 0x037f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/3/m = #966 */
    { 0x0300, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/0/3/u = #967 */
    { 0x047f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/0/m = #968 */
    { 0x0400, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/0/u = #969 */
    { 0x057f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/1/m = #970 */
    { 0x0500, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/1/u = #971 */
    { 0x067f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/2/m = #972 */
    { 0x0600, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/2/u = #973 */
    { 0x077f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/3/m = #974 */
    { 0x0700, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/1/3/u = #975 */
    { 0x087f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/0/m = #976 */
    { 0x0800, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/0/u = #977 */
    { 0x097f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/1/m = #978 */
    { 0x0900, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/1/u = #979 */
    { 0x0a7f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/2/m = #980 */
    { 0x0a00, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/2/u = #981 */
    { 0x0b7f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/3/m = #982 */
    { 0x0b00, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/2/3/u = #983 */
    { 0x0c7f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/0/m = #984 */
    { 0x0c00, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/0/u = #985 */
    { 0x0d7f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/1/m = #986 */
    { 0x0d00, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/1/u = #987 */
    { 0x0e7f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/2/m = #988 */
    { 0x0e00, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/2/u = #989 */
    { 0x0f7f, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/3/m = #990 */
    { 0x0f00, 0x43f9, 0x7900, RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036), RTFLOAT80U_INIT_C(0,0x610b4d6d2f9bca7e,23036) }, /* #30/3/3/u = #991 */
    { 0x007f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/0/m = #992 */
    { 0x0000, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/0/u = #993 */
    { 0x017f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/1/m = #994 */
    { 0x0100, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/1/u = #995 */
    { 0x027f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/2/m = #996 */
    { 0x0200, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/2/u = #997 */
    { 0x037f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/3/m = #998 */
    { 0x0300, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/0/3/u = #999 */
    { 0x047f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/0/m = #1000 */
    { 0x0400, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/0/u = #1001 */
    { 0x057f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/1/m = #1002 */
    { 0x0500, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/1/u = #1003 */
    { 0x067f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/2/m = #1004 */
    { 0x0600, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/2/u = #1005 */
    { 0x077f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/3/m = #1006 */
    { 0x0700, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/1/3/u = #1007 */
    { 0x087f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/0/m = #1008 */
    { 0x0800, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/0/u = #1009 */
    { 0x097f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/1/m = #1010 */
    { 0x0900, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/1/u = #1011 */
    { 0x0a7f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/2/m = #1012 */
    { 0x0a00, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/2/u = #1013 */
    { 0x0b7f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/3/m = #1014 */
    { 0x0b00, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/2/3/u = #1015 */
    { 0x0c7f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/0/m = #1016 */
    { 0x0c00, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/0/u = #1017 */
    { 0x0d7f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/1/m = #1018 */
    { 0x0d00, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/1/u = #1019 */
    { 0x0e7f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/2/m = #1020 */
    { 0x0e00, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/2/u = #1021 */
    { 0x0f7f, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/3/m = #1022 */
    { 0x0f00, 0x19da, 0x3900, RTFLOAT80U_INIT_C(1,0xe09862b9239ac302,32767), RTFLOAT80U_INIT_C(0,0xe09862b9239ac302,32767) }, /* #31/3/3/u = #1023 */
    { 0x007f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/0/m = #1024 */
    { 0x0000, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/0/u = #1025 */
    { 0x017f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/1/m = #1026 */
    { 0x0100, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/1/u = #1027 */
    { 0x027f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/2/m = #1028 */
    { 0x0200, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/2/u = #1029 */
    { 0x037f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/3/m = #1030 */
    { 0x0300, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/0/3/u = #1031 */
    { 0x047f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/0/m = #1032 */
    { 0x0400, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/0/u = #1033 */
    { 0x057f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/1/m = #1034 */
    { 0x0500, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/1/u = #1035 */
    { 0x067f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/2/m = #1036 */
    { 0x0600, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/2/u = #1037 */
    { 0x077f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/3/m = #1038 */
    { 0x0700, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/1/3/u = #1039 */
    { 0x087f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/0/m = #1040 */
    { 0x0800, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/0/u = #1041 */
    { 0x097f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/1/m = #1042 */
    { 0x0900, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/1/u = #1043 */
    { 0x0a7f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/2/m = #1044 */
    { 0x0a00, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/2/u = #1045 */
    { 0x0b7f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/3/m = #1046 */
    { 0x0b00, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/2/3/u = #1047 */
    { 0x0c7f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/0/m = #1048 */
    { 0x0c00, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/0/u = #1049 */
    { 0x0d7f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/1/m = #1050 */
    { 0x0d00, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/1/u = #1051 */
    { 0x0e7f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/2/m = #1052 */
    { 0x0e00, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/2/u = #1053 */
    { 0x0f7f, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/3/m = #1054 */
    { 0x0f00, 0xed52, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767), RTFLOAT80U_INIT_C(0,0x8000000152a8f9ad,32767) }, /* #32/3/3/u = #1055 */
    { 0x007f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/0/m = #1056 */
    { 0x0000, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/0/u = #1057 */
    { 0x017f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/1/m = #1058 */
    { 0x0100, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/1/u = #1059 */
    { 0x027f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/2/m = #1060 */
    { 0x0200, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/2/u = #1061 */
    { 0x037f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/3/m = #1062 */
    { 0x0300, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/0/3/u = #1063 */
    { 0x047f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/0/m = #1064 */
    { 0x0400, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/0/u = #1065 */
    { 0x057f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/1/m = #1066 */
    { 0x0500, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/1/u = #1067 */
    { 0x067f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/2/m = #1068 */
    { 0x0600, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/2/u = #1069 */
    { 0x077f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/3/m = #1070 */
    { 0x0700, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/1/3/u = #1071 */
    { 0x087f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/0/m = #1072 */
    { 0x0800, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/0/u = #1073 */
    { 0x097f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/1/m = #1074 */
    { 0x0900, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/1/u = #1075 */
    { 0x0a7f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/2/m = #1076 */
    { 0x0a00, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/2/u = #1077 */
    { 0x0b7f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/3/m = #1078 */
    { 0x0b00, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/2/3/u = #1079 */
    { 0x0c7f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/0/m = #1080 */
    { 0x0c00, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/0/u = #1081 */
    { 0x0d7f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/1/m = #1082 */
    { 0x0d00, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/1/u = #1083 */
    { 0x0e7f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/2/m = #1084 */
    { 0x0e00, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/2/u = #1085 */
    { 0x0f7f, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/3/m = #1086 */
    { 0x0f00, 0x2de9, 0x3d00, RTFLOAT80U_INIT_C(1,0x205c1aa0690f3af9,0), RTFLOAT80U_INIT_C(0,0x205c1aa0690f3af9,0) }, /* #33/3/3/u = #1087 */
    { 0x007f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/0/m = #1088 */
    { 0x0000, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/0/u = #1089 */
    { 0x017f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/1/m = #1090 */
    { 0x0100, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/1/u = #1091 */
    { 0x027f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/2/m = #1092 */
    { 0x0200, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/2/u = #1093 */
    { 0x037f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/3/m = #1094 */
    { 0x0300, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/0/3/u = #1095 */
    { 0x047f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/0/m = #1096 */
    { 0x0400, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/0/u = #1097 */
    { 0x057f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/1/m = #1098 */
    { 0x0500, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/1/u = #1099 */
    { 0x067f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/2/m = #1100 */
    { 0x0600, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/2/u = #1101 */
    { 0x077f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/3/m = #1102 */
    { 0x0700, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/1/3/u = #1103 */
    { 0x087f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/0/m = #1104 */
    { 0x0800, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/0/u = #1105 */
    { 0x097f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/1/m = #1106 */
    { 0x0900, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/1/u = #1107 */
    { 0x0a7f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/2/m = #1108 */
    { 0x0a00, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/2/u = #1109 */
    { 0x0b7f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/3/m = #1110 */
    { 0x0b00, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/2/3/u = #1111 */
    { 0x0c7f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/0/m = #1112 */
    { 0x0c00, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/0/u = #1113 */
    { 0x0d7f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/1/m = #1114 */
    { 0x0d00, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/1/u = #1115 */
    { 0x0e7f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/2/m = #1116 */
    { 0x0e00, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/2/u = #1117 */
    { 0x0f7f, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/3/m = #1118 */
    { 0x0f00, 0xca6c, 0x7800, RTFLOAT80U_INIT_C(1,0xe50720b648985910,3705), RTFLOAT80U_INIT_C(0,0xe50720b648985910,3705) }, /* #34/3/3/u = #1119 */
    { 0x007f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/0/m = #1120 */
    { 0x0000, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/0/u = #1121 */
    { 0x017f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/1/m = #1122 */
    { 0x0100, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/1/u = #1123 */
    { 0x027f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/2/m = #1124 */
    { 0x0200, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/2/u = #1125 */
    { 0x037f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/3/m = #1126 */
    { 0x0300, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/0/3/u = #1127 */
    { 0x047f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/0/m = #1128 */
    { 0x0400, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/0/u = #1129 */
    { 0x057f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/1/m = #1130 */
    { 0x0500, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/1/u = #1131 */
    { 0x067f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/2/m = #1132 */
    { 0x0600, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/2/u = #1133 */
    { 0x077f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/3/m = #1134 */
    { 0x0700, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/1/3/u = #1135 */
    { 0x087f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/0/m = #1136 */
    { 0x0800, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/0/u = #1137 */
    { 0x097f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/1/m = #1138 */
    { 0x0900, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/1/u = #1139 */
    { 0x0a7f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/2/m = #1140 */
    { 0x0a00, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/2/u = #1141 */
    { 0x0b7f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/3/m = #1142 */
    { 0x0b00, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/2/3/u = #1143 */
    { 0x0c7f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/0/m = #1144 */
    { 0x0c00, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/0/u = #1145 */
    { 0x0d7f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/1/m = #1146 */
    { 0x0d00, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/1/u = #1147 */
    { 0x0e7f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/2/m = #1148 */
    { 0x0e00, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/2/u = #1149 */
    { 0x0f7f, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/3/m = #1150 */
    { 0x0f00, 0xc176, 0x7900, RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269), RTFLOAT80U_INIT_C(0,0x918f787ba2ba3940,11269) }, /* #35/3/3/u = #1151 */
    { 0x007f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/0/m = #1152 */
    { 0x0000, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/0/u = #1153 */
    { 0x017f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/1/m = #1154 */
    { 0x0100, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/1/u = #1155 */
    { 0x027f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/2/m = #1156 */
    { 0x0200, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/2/u = #1157 */
    { 0x037f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/3/m = #1158 */
    { 0x0300, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/0/3/u = #1159 */
    { 0x047f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/0/m = #1160 */
    { 0x0400, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/0/u = #1161 */
    { 0x057f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/1/m = #1162 */
    { 0x0500, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/1/u = #1163 */
    { 0x067f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/2/m = #1164 */
    { 0x0600, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/2/u = #1165 */
    { 0x077f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/3/m = #1166 */
    { 0x0700, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/1/3/u = #1167 */
    { 0x087f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/0/m = #1168 */
    { 0x0800, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/0/u = #1169 */
    { 0x097f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/1/m = #1170 */
    { 0x0900, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/1/u = #1171 */
    { 0x0a7f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/2/m = #1172 */
    { 0x0a00, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/2/u = #1173 */
    { 0x0b7f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/3/m = #1174 */
    { 0x0b00, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/2/3/u = #1175 */
    { 0x0c7f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/0/m = #1176 */
    { 0x0c00, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/0/u = #1177 */
    { 0x0d7f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/1/m = #1178 */
    { 0x0d00, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/1/u = #1179 */
    { 0x0e7f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/2/m = #1180 */
    { 0x0e00, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/2/u = #1181 */
    { 0x0f7f, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/3/m = #1182 */
    { 0x0f00, 0x94b6, 0x3c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #36/3/3/u = #1183 */
    { 0x007f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/0/m = #1184 */
    { 0x0000, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/0/u = #1185 */
    { 0x017f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/1/m = #1186 */
    { 0x0100, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/1/u = #1187 */
    { 0x027f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/2/m = #1188 */
    { 0x0200, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/2/u = #1189 */
    { 0x037f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/3/m = #1190 */
    { 0x0300, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/0/3/u = #1191 */
    { 0x047f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/0/m = #1192 */
    { 0x0400, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/0/u = #1193 */
    { 0x057f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/1/m = #1194 */
    { 0x0500, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/1/u = #1195 */
    { 0x067f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/2/m = #1196 */
    { 0x0600, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/2/u = #1197 */
    { 0x077f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/3/m = #1198 */
    { 0x0700, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/1/3/u = #1199 */
    { 0x087f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/0/m = #1200 */
    { 0x0800, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/0/u = #1201 */
    { 0x097f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/1/m = #1202 */
    { 0x0900, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/1/u = #1203 */
    { 0x0a7f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/2/m = #1204 */
    { 0x0a00, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/2/u = #1205 */
    { 0x0b7f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/3/m = #1206 */
    { 0x0b00, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/2/3/u = #1207 */
    { 0x0c7f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/0/m = #1208 */
    { 0x0c00, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/0/u = #1209 */
    { 0x0d7f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/1/m = #1210 */
    { 0x0d00, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/1/u = #1211 */
    { 0x0e7f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/2/m = #1212 */
    { 0x0e00, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/2/u = #1213 */
    { 0x0f7f, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/3/m = #1214 */
    { 0x0f00, 0x0b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0), RTFLOAT80U_INIT_C(0,0x6577aa461452a8ce,0) }, /* #37/3/3/u = #1215 */
    { 0x007f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/0/m = #1216 */
    { 0x0000, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/0/u = #1217 */
    { 0x017f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/1/m = #1218 */
    { 0x0100, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/1/u = #1219 */
    { 0x027f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/2/m = #1220 */
    { 0x0200, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/2/u = #1221 */
    { 0x037f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/3/m = #1222 */
    { 0x0300, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/0/3/u = #1223 */
    { 0x047f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/0/m = #1224 */
    { 0x0400, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/0/u = #1225 */
    { 0x057f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/1/m = #1226 */
    { 0x0500, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/1/u = #1227 */
    { 0x067f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/2/m = #1228 */
    { 0x0600, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/2/u = #1229 */
    { 0x077f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/3/m = #1230 */
    { 0x0700, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/1/3/u = #1231 */
    { 0x087f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/0/m = #1232 */
    { 0x0800, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/0/u = #1233 */
    { 0x097f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/1/m = #1234 */
    { 0x0900, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/1/u = #1235 */
    { 0x0a7f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/2/m = #1236 */
    { 0x0a00, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/2/u = #1237 */
    { 0x0b7f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/3/m = #1238 */
    { 0x0b00, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/2/3/u = #1239 */
    { 0x0c7f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/0/m = #1240 */
    { 0x0c00, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/0/u = #1241 */
    { 0x0d7f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/1/m = #1242 */
    { 0x0d00, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/1/u = #1243 */
    { 0x0e7f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/2/m = #1244 */
    { 0x0e00, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/2/u = #1245 */
    { 0x0f7f, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/3/m = #1246 */
    { 0x0f00, 0x0c35, 0x3c00, RTFLOAT80U_INIT_C(1,0x3dfdfa10623b,26592), RTFLOAT80U_INIT_C(0,0x3dfdfa10623b,26592) }, /* #38/3/3/u = #1247 */
    { 0x007f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/0/m = #1248 */
    { 0x0000, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/0/u = #1249 */
    { 0x017f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/1/m = #1250 */
    { 0x0100, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/1/u = #1251 */
    { 0x027f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/2/m = #1252 */
    { 0x0200, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/2/u = #1253 */
    { 0x037f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/3/m = #1254 */
    { 0x0300, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/0/3/u = #1255 */
    { 0x047f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/0/m = #1256 */
    { 0x0400, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/0/u = #1257 */
    { 0x057f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/1/m = #1258 */
    { 0x0500, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/1/u = #1259 */
    { 0x067f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/2/m = #1260 */
    { 0x0600, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/2/u = #1261 */
    { 0x077f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/3/m = #1262 */
    { 0x0700, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/1/3/u = #1263 */
    { 0x087f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/0/m = #1264 */
    { 0x0800, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/0/u = #1265 */
    { 0x097f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/1/m = #1266 */
    { 0x0900, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/1/u = #1267 */
    { 0x0a7f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/2/m = #1268 */
    { 0x0a00, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/2/u = #1269 */
    { 0x0b7f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/3/m = #1270 */
    { 0x0b00, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/2/3/u = #1271 */
    { 0x0c7f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/0/m = #1272 */
    { 0x0c00, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/0/u = #1273 */
    { 0x0d7f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/1/m = #1274 */
    { 0x0d00, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/1/u = #1275 */
    { 0x0e7f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/2/m = #1276 */
    { 0x0e00, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/2/u = #1277 */
    { 0x0f7f, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/3/m = #1278 */
    { 0x0f00, 0x328f, 0x3800, RTFLOAT80U_INIT_C(1,0x4ca9291e16fb4f58,10860), RTFLOAT80U_INIT_C(0,0x4ca9291e16fb4f58,10860) }, /* #39/3/3/u = #1279 */
    { 0x007f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/0/m = #1280 */
    { 0x0000, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/0/u = #1281 */
    { 0x017f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/1/m = #1282 */
    { 0x0100, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/1/u = #1283 */
    { 0x027f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/2/m = #1284 */
    { 0x0200, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/2/u = #1285 */
    { 0x037f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/3/m = #1286 */
    { 0x0300, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/0/3/u = #1287 */
    { 0x047f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/0/m = #1288 */
    { 0x0400, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/0/u = #1289 */
    { 0x057f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/1/m = #1290 */
    { 0x0500, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/1/u = #1291 */
    { 0x067f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/2/m = #1292 */
    { 0x0600, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/2/u = #1293 */
    { 0x077f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/3/m = #1294 */
    { 0x0700, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/1/3/u = #1295 */
    { 0x087f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/0/m = #1296 */
    { 0x0800, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/0/u = #1297 */
    { 0x097f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/1/m = #1298 */
    { 0x0900, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/1/u = #1299 */
    { 0x0a7f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/2/m = #1300 */
    { 0x0a00, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/2/u = #1301 */
    { 0x0b7f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/3/m = #1302 */
    { 0x0b00, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/2/3/u = #1303 */
    { 0x0c7f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/0/m = #1304 */
    { 0x0c00, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/0/u = #1305 */
    { 0x0d7f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/1/m = #1306 */
    { 0x0d00, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/1/u = #1307 */
    { 0x0e7f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/2/m = #1308 */
    { 0x0e00, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/2/u = #1309 */
    { 0x0f7f, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/3/m = #1310 */
    { 0x0f00, 0xdf08, 0x7d00, RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011), RTFLOAT80U_INIT_C(0,0x7ebf9cac087757f7,28011) }, /* #40/3/3/u = #1311 */
    { 0x007f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/0/m = #1312 */
    { 0x0000, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/0/u = #1313 */
    { 0x017f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/1/m = #1314 */
    { 0x0100, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/1/u = #1315 */
    { 0x027f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/2/m = #1316 */
    { 0x0200, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/2/u = #1317 */
    { 0x037f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/3/m = #1318 */
    { 0x0300, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/0/3/u = #1319 */
    { 0x047f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/0/m = #1320 */
    { 0x0400, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/0/u = #1321 */
    { 0x057f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/1/m = #1322 */
    { 0x0500, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/1/u = #1323 */
    { 0x067f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/2/m = #1324 */
    { 0x0600, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/2/u = #1325 */
    { 0x077f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/3/m = #1326 */
    { 0x0700, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/1/3/u = #1327 */
    { 0x087f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/0/m = #1328 */
    { 0x0800, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/0/u = #1329 */
    { 0x097f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/1/m = #1330 */
    { 0x0900, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/1/u = #1331 */
    { 0x0a7f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/2/m = #1332 */
    { 0x0a00, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/2/u = #1333 */
    { 0x0b7f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/3/m = #1334 */
    { 0x0b00, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/2/3/u = #1335 */
    { 0x0c7f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/0/m = #1336 */
    { 0x0c00, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/0/u = #1337 */
    { 0x0d7f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/1/m = #1338 */
    { 0x0d00, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/1/u = #1339 */
    { 0x0e7f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/2/m = #1340 */
    { 0x0e00, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/2/u = #1341 */
    { 0x0f7f, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/3/m = #1342 */
    { 0x0f00, 0xd3e9, 0x7900, RTFLOAT80U_INIT_C(1,0xc0001660497ff6c4,32767), RTFLOAT80U_INIT_C(0,0xc0001660497ff6c4,32767) }, /* #41/3/3/u = #1343 */
    { 0x007f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/0/m = #1344 */
    { 0x0000, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/0/u = #1345 */
    { 0x017f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/1/m = #1346 */
    { 0x0100, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/1/u = #1347 */
    { 0x027f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/2/m = #1348 */
    { 0x0200, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/2/u = #1349 */
    { 0x037f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/3/m = #1350 */
    { 0x0300, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/0/3/u = #1351 */
    { 0x047f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/0/m = #1352 */
    { 0x0400, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/0/u = #1353 */
    { 0x057f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/1/m = #1354 */
    { 0x0500, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/1/u = #1355 */
    { 0x067f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/2/m = #1356 */
    { 0x0600, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/2/u = #1357 */
    { 0x077f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/3/m = #1358 */
    { 0x0700, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/1/3/u = #1359 */
    { 0x087f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/0/m = #1360 */
    { 0x0800, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/0/u = #1361 */
    { 0x097f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/1/m = #1362 */
    { 0x0900, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/1/u = #1363 */
    { 0x0a7f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/2/m = #1364 */
    { 0x0a00, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/2/u = #1365 */
    { 0x0b7f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/3/m = #1366 */
    { 0x0b00, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/2/3/u = #1367 */
    { 0x0c7f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/0/m = #1368 */
    { 0x0c00, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/0/u = #1369 */
    { 0x0d7f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/1/m = #1370 */
    { 0x0d00, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/1/u = #1371 */
    { 0x0e7f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/2/m = #1372 */
    { 0x0e00, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/2/u = #1373 */
    { 0x0f7f, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/3/m = #1374 */
    { 0x0f00, 0xabd5, 0x3900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #42/3/3/u = #1375 */
    { 0x007f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/0/m = #1376 */
    { 0x0000, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/0/u = #1377 */
    { 0x017f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/1/m = #1378 */
    { 0x0100, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/1/u = #1379 */
    { 0x027f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/2/m = #1380 */
    { 0x0200, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/2/u = #1381 */
    { 0x037f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/3/m = #1382 */
    { 0x0300, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/0/3/u = #1383 */
    { 0x047f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/0/m = #1384 */
    { 0x0400, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/0/u = #1385 */
    { 0x057f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/1/m = #1386 */
    { 0x0500, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/1/u = #1387 */
    { 0x067f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/2/m = #1388 */
    { 0x0600, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/2/u = #1389 */
    { 0x077f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/3/m = #1390 */
    { 0x0700, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/1/3/u = #1391 */
    { 0x087f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/0/m = #1392 */
    { 0x0800, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/0/u = #1393 */
    { 0x097f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/1/m = #1394 */
    { 0x0900, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/1/u = #1395 */
    { 0x0a7f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/2/m = #1396 */
    { 0x0a00, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/2/u = #1397 */
    { 0x0b7f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/3/m = #1398 */
    { 0x0b00, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/2/3/u = #1399 */
    { 0x0c7f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/0/m = #1400 */
    { 0x0c00, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/0/u = #1401 */
    { 0x0d7f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/1/m = #1402 */
    { 0x0d00, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/1/u = #1403 */
    { 0x0e7f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/2/m = #1404 */
    { 0x0e00, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/2/u = #1405 */
    { 0x0f7f, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/3/m = #1406 */
    { 0x0f00, 0xe9b8, 0x7900, RTFLOAT80U_INIT_C(1,0xfdff40bcdfae0df3,9161), RTFLOAT80U_INIT_C(0,0xfdff40bcdfae0df3,9161) }, /* #43/3/3/u = #1407 */
    { 0x007f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/0/m = #1408 */
    { 0x0000, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/0/u = #1409 */
    { 0x017f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/1/m = #1410 */
    { 0x0100, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/1/u = #1411 */
    { 0x027f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/2/m = #1412 */
    { 0x0200, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/2/u = #1413 */
    { 0x037f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/3/m = #1414 */
    { 0x0300, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/0/3/u = #1415 */
    { 0x047f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/0/m = #1416 */
    { 0x0400, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/0/u = #1417 */
    { 0x057f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/1/m = #1418 */
    { 0x0500, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/1/u = #1419 */
    { 0x067f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/2/m = #1420 */
    { 0x0600, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/2/u = #1421 */
    { 0x077f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/3/m = #1422 */
    { 0x0700, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/1/3/u = #1423 */
    { 0x087f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/0/m = #1424 */
    { 0x0800, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/0/u = #1425 */
    { 0x097f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/1/m = #1426 */
    { 0x0900, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/1/u = #1427 */
    { 0x0a7f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/2/m = #1428 */
    { 0x0a00, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/2/u = #1429 */
    { 0x0b7f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/3/m = #1430 */
    { 0x0b00, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/2/3/u = #1431 */
    { 0x0c7f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/0/m = #1432 */
    { 0x0c00, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/0/u = #1433 */
    { 0x0d7f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/1/m = #1434 */
    { 0x0d00, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/1/u = #1435 */
    { 0x0e7f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/2/m = #1436 */
    { 0x0e00, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/2/u = #1437 */
    { 0x0f7f, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/3/m = #1438 */
    { 0x0f00, 0x7e52, 0x7c00, RTFLOAT80U_INIT_C(1,0xc00000000000336d,32767), RTFLOAT80U_INIT_C(0,0xc00000000000336d,32767) }, /* #44/3/3/u = #1439 */
    { 0x007f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/0/m = #1440 */
    { 0x0000, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/0/u = #1441 */
    { 0x017f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/1/m = #1442 */
    { 0x0100, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/1/u = #1443 */
    { 0x027f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/2/m = #1444 */
    { 0x0200, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/2/u = #1445 */
    { 0x037f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/3/m = #1446 */
    { 0x0300, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/0/3/u = #1447 */
    { 0x047f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/0/m = #1448 */
    { 0x0400, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/0/u = #1449 */
    { 0x057f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/1/m = #1450 */
    { 0x0500, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/1/u = #1451 */
    { 0x067f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/2/m = #1452 */
    { 0x0600, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/2/u = #1453 */
    { 0x077f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/3/m = #1454 */
    { 0x0700, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/1/3/u = #1455 */
    { 0x087f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/0/m = #1456 */
    { 0x0800, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/0/u = #1457 */
    { 0x097f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/1/m = #1458 */
    { 0x0900, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/1/u = #1459 */
    { 0x0a7f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/2/m = #1460 */
    { 0x0a00, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/2/u = #1461 */
    { 0x0b7f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/3/m = #1462 */
    { 0x0b00, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/2/3/u = #1463 */
    { 0x0c7f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/0/m = #1464 */
    { 0x0c00, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/0/u = #1465 */
    { 0x0d7f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/1/m = #1466 */
    { 0x0d00, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/1/u = #1467 */
    { 0x0e7f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/2/m = #1468 */
    { 0x0e00, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/2/u = #1469 */
    { 0x0f7f, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/3/m = #1470 */
    { 0x0f00, 0x39ec, 0x3900, RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054), RTFLOAT80U_INIT_C(0,0xf441409e6bbcc150,10054) }, /* #45/3/3/u = #1471 */
    { 0x007f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/0/m = #1472 */
    { 0x0000, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/0/u = #1473 */
    { 0x017f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/1/m = #1474 */
    { 0x0100, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/1/u = #1475 */
    { 0x027f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/2/m = #1476 */
    { 0x0200, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/2/u = #1477 */
    { 0x037f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/3/m = #1478 */
    { 0x0300, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/0/3/u = #1479 */
    { 0x047f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/0/m = #1480 */
    { 0x0400, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/0/u = #1481 */
    { 0x057f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/1/m = #1482 */
    { 0x0500, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/1/u = #1483 */
    { 0x067f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/2/m = #1484 */
    { 0x0600, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/2/u = #1485 */
    { 0x077f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/3/m = #1486 */
    { 0x0700, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/1/3/u = #1487 */
    { 0x087f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/0/m = #1488 */
    { 0x0800, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/0/u = #1489 */
    { 0x097f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/1/m = #1490 */
    { 0x0900, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/1/u = #1491 */
    { 0x0a7f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/2/m = #1492 */
    { 0x0a00, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/2/u = #1493 */
    { 0x0b7f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/3/m = #1494 */
    { 0x0b00, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/2/3/u = #1495 */
    { 0x0c7f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/0/m = #1496 */
    { 0x0c00, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/0/u = #1497 */
    { 0x0d7f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/1/m = #1498 */
    { 0x0d00, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/1/u = #1499 */
    { 0x0e7f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/2/m = #1500 */
    { 0x0e00, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/2/u = #1501 */
    { 0x0f7f, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/3/m = #1502 */
    { 0x0f00, 0xb411, 0x3c00, RTFLOAT80U_INIT_C(1,0xa04fc24d71052744,21022), RTFLOAT80U_INIT_C(0,0xa04fc24d71052744,21022) }, /* #46/3/3/u = #1503 */
    { 0x007f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/0/m = #1504 */
    { 0x0000, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/0/u = #1505 */
    { 0x017f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/1/m = #1506 */
    { 0x0100, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/1/u = #1507 */
    { 0x027f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/2/m = #1508 */
    { 0x0200, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/2/u = #1509 */
    { 0x037f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/3/m = #1510 */
    { 0x0300, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/0/3/u = #1511 */
    { 0x047f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/0/m = #1512 */
    { 0x0400, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/0/u = #1513 */
    { 0x057f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/1/m = #1514 */
    { 0x0500, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/1/u = #1515 */
    { 0x067f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/2/m = #1516 */
    { 0x0600, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/2/u = #1517 */
    { 0x077f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/3/m = #1518 */
    { 0x0700, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/1/3/u = #1519 */
    { 0x087f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/0/m = #1520 */
    { 0x0800, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/0/u = #1521 */
    { 0x097f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/1/m = #1522 */
    { 0x0900, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/1/u = #1523 */
    { 0x0a7f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/2/m = #1524 */
    { 0x0a00, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/2/u = #1525 */
    { 0x0b7f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/3/m = #1526 */
    { 0x0b00, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/2/3/u = #1527 */
    { 0x0c7f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/0/m = #1528 */
    { 0x0c00, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/0/u = #1529 */
    { 0x0d7f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/1/m = #1530 */
    { 0x0d00, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/1/u = #1531 */
    { 0x0e7f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/2/m = #1532 */
    { 0x0e00, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/2/u = #1533 */
    { 0x0f7f, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/3/m = #1534 */
    { 0x0f00, 0xee03, 0x7c00, RTFLOAT80U_INIT_C(1,0x245d2533ddc,11550), RTFLOAT80U_INIT_C(0,0x245d2533ddc,11550) }, /* #47/3/3/u = #1535 */
    { 0x007f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/0/m = #1536 */
    { 0x0000, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/0/u = #1537 */
    { 0x017f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/1/m = #1538 */
    { 0x0100, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/1/u = #1539 */
    { 0x027f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/2/m = #1540 */
    { 0x0200, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/2/u = #1541 */
    { 0x037f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/3/m = #1542 */
    { 0x0300, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/0/3/u = #1543 */
    { 0x047f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/0/m = #1544 */
    { 0x0400, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/0/u = #1545 */
    { 0x057f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/1/m = #1546 */
    { 0x0500, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/1/u = #1547 */
    { 0x067f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/2/m = #1548 */
    { 0x0600, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/2/u = #1549 */
    { 0x077f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/3/m = #1550 */
    { 0x0700, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/1/3/u = #1551 */
    { 0x087f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/0/m = #1552 */
    { 0x0800, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/0/u = #1553 */
    { 0x097f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/1/m = #1554 */
    { 0x0900, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/1/u = #1555 */
    { 0x0a7f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/2/m = #1556 */
    { 0x0a00, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/2/u = #1557 */
    { 0x0b7f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/3/m = #1558 */
    { 0x0b00, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/2/3/u = #1559 */
    { 0x0c7f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/0/m = #1560 */
    { 0x0c00, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/0/u = #1561 */
    { 0x0d7f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/1/m = #1562 */
    { 0x0d00, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/1/u = #1563 */
    { 0x0e7f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/2/m = #1564 */
    { 0x0e00, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/2/u = #1565 */
    { 0x0f7f, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/3/m = #1566 */
    { 0x0f00, 0x1a49, 0x3800, RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767), RTFLOAT80U_INIT_C(0,0x80b4f466935561d8,32767) }, /* #48/3/3/u = #1567 */
    { 0x007f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/0/m = #1568 */
    { 0x0000, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/0/u = #1569 */
    { 0x017f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/1/m = #1570 */
    { 0x0100, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/1/u = #1571 */
    { 0x027f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/2/m = #1572 */
    { 0x0200, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/2/u = #1573 */
    { 0x037f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/3/m = #1574 */
    { 0x0300, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/0/3/u = #1575 */
    { 0x047f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/0/m = #1576 */
    { 0x0400, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/0/u = #1577 */
    { 0x057f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/1/m = #1578 */
    { 0x0500, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/1/u = #1579 */
    { 0x067f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/2/m = #1580 */
    { 0x0600, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/2/u = #1581 */
    { 0x077f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/3/m = #1582 */
    { 0x0700, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/1/3/u = #1583 */
    { 0x087f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/0/m = #1584 */
    { 0x0800, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/0/u = #1585 */
    { 0x097f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/1/m = #1586 */
    { 0x0900, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/1/u = #1587 */
    { 0x0a7f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/2/m = #1588 */
    { 0x0a00, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/2/u = #1589 */
    { 0x0b7f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/3/m = #1590 */
    { 0x0b00, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/2/3/u = #1591 */
    { 0x0c7f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/0/m = #1592 */
    { 0x0c00, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/0/u = #1593 */
    { 0x0d7f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/1/m = #1594 */
    { 0x0d00, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/1/u = #1595 */
    { 0x0e7f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/2/m = #1596 */
    { 0x0e00, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/2/u = #1597 */
    { 0x0f7f, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/3/m = #1598 */
    { 0x0f00, 0x99a0, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000000004e6,32767), RTFLOAT80U_INIT_C(0,0x80000000000004e6,32767) }, /* #49/3/3/u = #1599 */
    { 0x007f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/0/m = #1600 */
    { 0x0000, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/0/u = #1601 */
    { 0x017f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/1/m = #1602 */
    { 0x0100, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/1/u = #1603 */
    { 0x027f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/2/m = #1604 */
    { 0x0200, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/2/u = #1605 */
    { 0x037f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/3/m = #1606 */
    { 0x0300, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/0/3/u = #1607 */
    { 0x047f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/0/m = #1608 */
    { 0x0400, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/0/u = #1609 */
    { 0x057f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/1/m = #1610 */
    { 0x0500, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/1/u = #1611 */
    { 0x067f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/2/m = #1612 */
    { 0x0600, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/2/u = #1613 */
    { 0x077f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/3/m = #1614 */
    { 0x0700, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/1/3/u = #1615 */
    { 0x087f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/0/m = #1616 */
    { 0x0800, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/0/u = #1617 */
    { 0x097f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/1/m = #1618 */
    { 0x0900, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/1/u = #1619 */
    { 0x0a7f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/2/m = #1620 */
    { 0x0a00, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/2/u = #1621 */
    { 0x0b7f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/3/m = #1622 */
    { 0x0b00, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/2/3/u = #1623 */
    { 0x0c7f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/0/m = #1624 */
    { 0x0c00, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/0/u = #1625 */
    { 0x0d7f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/1/m = #1626 */
    { 0x0d00, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/1/u = #1627 */
    { 0x0e7f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/2/m = #1628 */
    { 0x0e00, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/2/u = #1629 */
    { 0x0f7f, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/3/m = #1630 */
    { 0x0f00, 0x28aa, 0x3800, RTFLOAT80U_INIT_C(1,0xc0000000001563ca,32767), RTFLOAT80U_INIT_C(0,0xc0000000001563ca,32767) }, /* #50/3/3/u = #1631 */
    { 0x007f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/0/m = #1632 */
    { 0x0000, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/0/u = #1633 */
    { 0x017f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/1/m = #1634 */
    { 0x0100, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/1/u = #1635 */
    { 0x027f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/2/m = #1636 */
    { 0x0200, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/2/u = #1637 */
    { 0x037f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/3/m = #1638 */
    { 0x0300, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/0/3/u = #1639 */
    { 0x047f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/0/m = #1640 */
    { 0x0400, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/0/u = #1641 */
    { 0x057f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/1/m = #1642 */
    { 0x0500, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/1/u = #1643 */
    { 0x067f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/2/m = #1644 */
    { 0x0600, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/2/u = #1645 */
    { 0x077f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/3/m = #1646 */
    { 0x0700, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/1/3/u = #1647 */
    { 0x087f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/0/m = #1648 */
    { 0x0800, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/0/u = #1649 */
    { 0x097f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/1/m = #1650 */
    { 0x0900, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/1/u = #1651 */
    { 0x0a7f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/2/m = #1652 */
    { 0x0a00, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/2/u = #1653 */
    { 0x0b7f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/3/m = #1654 */
    { 0x0b00, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/2/3/u = #1655 */
    { 0x0c7f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/0/m = #1656 */
    { 0x0c00, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/0/u = #1657 */
    { 0x0d7f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/1/m = #1658 */
    { 0x0d00, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/1/u = #1659 */
    { 0x0e7f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/2/m = #1660 */
    { 0x0e00, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/2/u = #1661 */
    { 0x0f7f, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/3/m = #1662 */
    { 0x0f00, 0x84ff, 0x3c00, RTFLOAT80U_INIT_C(1,0xdce96c0b0b4396fd,8405), RTFLOAT80U_INIT_C(0,0xdce96c0b0b4396fd,8405) }, /* #51/3/3/u = #1663 */
    { 0x007f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/0/m = #1664 */
    { 0x0000, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/0/u = #1665 */
    { 0x017f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/1/m = #1666 */
    { 0x0100, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/1/u = #1667 */
    { 0x027f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/2/m = #1668 */
    { 0x0200, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/2/u = #1669 */
    { 0x037f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/3/m = #1670 */
    { 0x0300, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/0/3/u = #1671 */
    { 0x047f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/0/m = #1672 */
    { 0x0400, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/0/u = #1673 */
    { 0x057f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/1/m = #1674 */
    { 0x0500, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/1/u = #1675 */
    { 0x067f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/2/m = #1676 */
    { 0x0600, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/2/u = #1677 */
    { 0x077f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/3/m = #1678 */
    { 0x0700, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/1/3/u = #1679 */
    { 0x087f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/0/m = #1680 */
    { 0x0800, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/0/u = #1681 */
    { 0x097f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/1/m = #1682 */
    { 0x0900, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/1/u = #1683 */
    { 0x0a7f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/2/m = #1684 */
    { 0x0a00, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/2/u = #1685 */
    { 0x0b7f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/3/m = #1686 */
    { 0x0b00, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/2/3/u = #1687 */
    { 0x0c7f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/0/m = #1688 */
    { 0x0c00, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/0/u = #1689 */
    { 0x0d7f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/1/m = #1690 */
    { 0x0d00, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/1/u = #1691 */
    { 0x0e7f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/2/m = #1692 */
    { 0x0e00, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/2/u = #1693 */
    { 0x0f7f, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/3/m = #1694 */
    { 0x0f00, 0xbac8, 0x3800, RTFLOAT80U_INIT_C(1,0x894ab001c06d4752,16954), RTFLOAT80U_INIT_C(0,0x894ab001c06d4752,16954) }, /* #52/3/3/u = #1695 */
    { 0x007f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/0/m = #1696 */
    { 0x0000, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/0/u = #1697 */
    { 0x017f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/1/m = #1698 */
    { 0x0100, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/1/u = #1699 */
    { 0x027f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/2/m = #1700 */
    { 0x0200, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/2/u = #1701 */
    { 0x037f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/3/m = #1702 */
    { 0x0300, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/0/3/u = #1703 */
    { 0x047f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/0/m = #1704 */
    { 0x0400, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/0/u = #1705 */
    { 0x057f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/1/m = #1706 */
    { 0x0500, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/1/u = #1707 */
    { 0x067f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/2/m = #1708 */
    { 0x0600, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/2/u = #1709 */
    { 0x077f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/3/m = #1710 */
    { 0x0700, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/1/3/u = #1711 */
    { 0x087f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/0/m = #1712 */
    { 0x0800, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/0/u = #1713 */
    { 0x097f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/1/m = #1714 */
    { 0x0900, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/1/u = #1715 */
    { 0x0a7f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/2/m = #1716 */
    { 0x0a00, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/2/u = #1717 */
    { 0x0b7f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/3/m = #1718 */
    { 0x0b00, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/2/3/u = #1719 */
    { 0x0c7f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/0/m = #1720 */
    { 0x0c00, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/0/u = #1721 */
    { 0x0d7f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/1/m = #1722 */
    { 0x0d00, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/1/u = #1723 */
    { 0x0e7f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/2/m = #1724 */
    { 0x0e00, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/2/u = #1725 */
    { 0x0f7f, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/3/m = #1726 */
    { 0x0f00, 0x5077, 0x7800, RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163), RTFLOAT80U_INIT_C(0,0xaa18b98dedce82e2,6163) }, /* #53/3/3/u = #1727 */
    { 0x007f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/0/m = #1728 */
    { 0x0000, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/0/u = #1729 */
    { 0x017f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/1/m = #1730 */
    { 0x0100, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/1/u = #1731 */
    { 0x027f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/2/m = #1732 */
    { 0x0200, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/2/u = #1733 */
    { 0x037f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/3/m = #1734 */
    { 0x0300, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/0/3/u = #1735 */
    { 0x047f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/0/m = #1736 */
    { 0x0400, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/0/u = #1737 */
    { 0x057f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/1/m = #1738 */
    { 0x0500, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/1/u = #1739 */
    { 0x067f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/2/m = #1740 */
    { 0x0600, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/2/u = #1741 */
    { 0x077f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/3/m = #1742 */
    { 0x0700, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/1/3/u = #1743 */
    { 0x087f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/0/m = #1744 */
    { 0x0800, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/0/u = #1745 */
    { 0x097f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/1/m = #1746 */
    { 0x0900, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/1/u = #1747 */
    { 0x0a7f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/2/m = #1748 */
    { 0x0a00, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/2/u = #1749 */
    { 0x0b7f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/3/m = #1750 */
    { 0x0b00, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/2/3/u = #1751 */
    { 0x0c7f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/0/m = #1752 */
    { 0x0c00, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/0/u = #1753 */
    { 0x0d7f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/1/m = #1754 */
    { 0x0d00, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/1/u = #1755 */
    { 0x0e7f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/2/m = #1756 */
    { 0x0e00, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/2/u = #1757 */
    { 0x0f7f, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/3/m = #1758 */
    { 0x0f00, 0xe247, 0x7800, RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410), RTFLOAT80U_INIT_C(0,0x9a4debc911ddf8ae,32410) }, /* #54/3/3/u = #1759 */
    { 0x007f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/0/m = #1760 */
    { 0x0000, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/0/u = #1761 */
    { 0x017f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/1/m = #1762 */
    { 0x0100, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/1/u = #1763 */
    { 0x027f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/2/m = #1764 */
    { 0x0200, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/2/u = #1765 */
    { 0x037f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/3/m = #1766 */
    { 0x0300, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/0/3/u = #1767 */
    { 0x047f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/0/m = #1768 */
    { 0x0400, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/0/u = #1769 */
    { 0x057f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/1/m = #1770 */
    { 0x0500, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/1/u = #1771 */
    { 0x067f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/2/m = #1772 */
    { 0x0600, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/2/u = #1773 */
    { 0x077f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/3/m = #1774 */
    { 0x0700, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/1/3/u = #1775 */
    { 0x087f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/0/m = #1776 */
    { 0x0800, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/0/u = #1777 */
    { 0x097f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/1/m = #1778 */
    { 0x0900, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/1/u = #1779 */
    { 0x0a7f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/2/m = #1780 */
    { 0x0a00, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/2/u = #1781 */
    { 0x0b7f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/3/m = #1782 */
    { 0x0b00, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/2/3/u = #1783 */
    { 0x0c7f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/0/m = #1784 */
    { 0x0c00, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/0/u = #1785 */
    { 0x0d7f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/1/m = #1786 */
    { 0x0d00, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/1/u = #1787 */
    { 0x0e7f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/2/m = #1788 */
    { 0x0e00, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/2/u = #1789 */
    { 0x0f7f, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/3/m = #1790 */
    { 0x0f00, 0xe761, 0x7d00, RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102), RTFLOAT80U_INIT_C(0,0x505de39376fe2847,7102) }, /* #55/3/3/u = #1791 */
    { 0x007f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/0/m = #1792 */
    { 0x0000, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/0/u = #1793 */
    { 0x017f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/1/m = #1794 */
    { 0x0100, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/1/u = #1795 */
    { 0x027f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/2/m = #1796 */
    { 0x0200, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/2/u = #1797 */
    { 0x037f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/3/m = #1798 */
    { 0x0300, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/0/3/u = #1799 */
    { 0x047f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/0/m = #1800 */
    { 0x0400, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/0/u = #1801 */
    { 0x057f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/1/m = #1802 */
    { 0x0500, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/1/u = #1803 */
    { 0x067f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/2/m = #1804 */
    { 0x0600, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/2/u = #1805 */
    { 0x077f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/3/m = #1806 */
    { 0x0700, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/1/3/u = #1807 */
    { 0x087f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/0/m = #1808 */
    { 0x0800, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/0/u = #1809 */
    { 0x097f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/1/m = #1810 */
    { 0x0900, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/1/u = #1811 */
    { 0x0a7f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/2/m = #1812 */
    { 0x0a00, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/2/u = #1813 */
    { 0x0b7f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/3/m = #1814 */
    { 0x0b00, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/2/3/u = #1815 */
    { 0x0c7f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/0/m = #1816 */
    { 0x0c00, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/0/u = #1817 */
    { 0x0d7f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/1/m = #1818 */
    { 0x0d00, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/1/u = #1819 */
    { 0x0e7f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/2/m = #1820 */
    { 0x0e00, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/2/u = #1821 */
    { 0x0f7f, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/3/m = #1822 */
    { 0x0f00, 0x253e, 0x3d00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #56/3/3/u = #1823 */
    { 0x007f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/0/m = #1824 */
    { 0x0000, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/0/u = #1825 */
    { 0x017f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/1/m = #1826 */
    { 0x0100, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/1/u = #1827 */
    { 0x027f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/2/m = #1828 */
    { 0x0200, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/2/u = #1829 */
    { 0x037f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/3/m = #1830 */
    { 0x0300, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/0/3/u = #1831 */
    { 0x047f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/0/m = #1832 */
    { 0x0400, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/0/u = #1833 */
    { 0x057f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/1/m = #1834 */
    { 0x0500, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/1/u = #1835 */
    { 0x067f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/2/m = #1836 */
    { 0x0600, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/2/u = #1837 */
    { 0x077f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/3/m = #1838 */
    { 0x0700, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/1/3/u = #1839 */
    { 0x087f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/0/m = #1840 */
    { 0x0800, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/0/u = #1841 */
    { 0x097f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/1/m = #1842 */
    { 0x0900, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/1/u = #1843 */
    { 0x0a7f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/2/m = #1844 */
    { 0x0a00, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/2/u = #1845 */
    { 0x0b7f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/3/m = #1846 */
    { 0x0b00, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/2/3/u = #1847 */
    { 0x0c7f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/0/m = #1848 */
    { 0x0c00, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/0/u = #1849 */
    { 0x0d7f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/1/m = #1850 */
    { 0x0d00, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/1/u = #1851 */
    { 0x0e7f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/2/m = #1852 */
    { 0x0e00, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/2/u = #1853 */
    { 0x0f7f, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/3/m = #1854 */
    { 0x0f00, 0x3746, 0x3d00, RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767), RTFLOAT80U_INIT_C(0,0x9b5f59b42ab69769,32767) }, /* #57/3/3/u = #1855 */
    { 0x007f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/0/m = #1856 */
    { 0x0000, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/0/u = #1857 */
    { 0x017f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/1/m = #1858 */
    { 0x0100, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/1/u = #1859 */
    { 0x027f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/2/m = #1860 */
    { 0x0200, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/2/u = #1861 */
    { 0x037f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/3/m = #1862 */
    { 0x0300, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/0/3/u = #1863 */
    { 0x047f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/0/m = #1864 */
    { 0x0400, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/0/u = #1865 */
    { 0x057f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/1/m = #1866 */
    { 0x0500, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/1/u = #1867 */
    { 0x067f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/2/m = #1868 */
    { 0x0600, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/2/u = #1869 */
    { 0x077f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/3/m = #1870 */
    { 0x0700, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/1/3/u = #1871 */
    { 0x087f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/0/m = #1872 */
    { 0x0800, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/0/u = #1873 */
    { 0x097f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/1/m = #1874 */
    { 0x0900, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/1/u = #1875 */
    { 0x0a7f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/2/m = #1876 */
    { 0x0a00, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/2/u = #1877 */
    { 0x0b7f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/3/m = #1878 */
    { 0x0b00, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/2/3/u = #1879 */
    { 0x0c7f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/0/m = #1880 */
    { 0x0c00, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/0/u = #1881 */
    { 0x0d7f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/1/m = #1882 */
    { 0x0d00, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/1/u = #1883 */
    { 0x0e7f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/2/m = #1884 */
    { 0x0e00, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/2/u = #1885 */
    { 0x0f7f, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/3/m = #1886 */
    { 0x0f00, 0x9ae0, 0x3800, RTFLOAT80U_INIT_C(1,0xe9ee47ba0e283f3b,25515), RTFLOAT80U_INIT_C(0,0xe9ee47ba0e283f3b,25515) }, /* #58/3/3/u = #1887 */
    { 0x007f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/0/m = #1888 */
    { 0x0000, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/0/u = #1889 */
    { 0x017f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/1/m = #1890 */
    { 0x0100, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/1/u = #1891 */
    { 0x027f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/2/m = #1892 */
    { 0x0200, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/2/u = #1893 */
    { 0x037f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/3/m = #1894 */
    { 0x0300, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/0/3/u = #1895 */
    { 0x047f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/0/m = #1896 */
    { 0x0400, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/0/u = #1897 */
    { 0x057f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/1/m = #1898 */
    { 0x0500, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/1/u = #1899 */
    { 0x067f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/2/m = #1900 */
    { 0x0600, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/2/u = #1901 */
    { 0x077f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/3/m = #1902 */
    { 0x0700, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/1/3/u = #1903 */
    { 0x087f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/0/m = #1904 */
    { 0x0800, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/0/u = #1905 */
    { 0x097f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/1/m = #1906 */
    { 0x0900, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/1/u = #1907 */
    { 0x0a7f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/2/m = #1908 */
    { 0x0a00, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/2/u = #1909 */
    { 0x0b7f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/3/m = #1910 */
    { 0x0b00, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/2/3/u = #1911 */
    { 0x0c7f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/0/m = #1912 */
    { 0x0c00, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/0/u = #1913 */
    { 0x0d7f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/1/m = #1914 */
    { 0x0d00, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/1/u = #1915 */
    { 0x0e7f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/2/m = #1916 */
    { 0x0e00, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/2/u = #1917 */
    { 0x0f7f, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/3/m = #1918 */
    { 0x0f00, 0xf469, 0x7c00, RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767), RTFLOAT80U_INIT_C(0,0xd2e1e7dc0fb802e0,32767) }, /* #59/3/3/u = #1919 */
    { 0x007f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/0/m = #1920 */
    { 0x0000, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/0/u = #1921 */
    { 0x017f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/1/m = #1922 */
    { 0x0100, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/1/u = #1923 */
    { 0x027f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/2/m = #1924 */
    { 0x0200, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/2/u = #1925 */
    { 0x037f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/3/m = #1926 */
    { 0x0300, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/0/3/u = #1927 */
    { 0x047f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/0/m = #1928 */
    { 0x0400, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/0/u = #1929 */
    { 0x057f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/1/m = #1930 */
    { 0x0500, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/1/u = #1931 */
    { 0x067f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/2/m = #1932 */
    { 0x0600, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/2/u = #1933 */
    { 0x077f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/3/m = #1934 */
    { 0x0700, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/1/3/u = #1935 */
    { 0x087f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/0/m = #1936 */
    { 0x0800, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/0/u = #1937 */
    { 0x097f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/1/m = #1938 */
    { 0x0900, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/1/u = #1939 */
    { 0x0a7f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/2/m = #1940 */
    { 0x0a00, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/2/u = #1941 */
    { 0x0b7f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/3/m = #1942 */
    { 0x0b00, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/2/3/u = #1943 */
    { 0x0c7f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/0/m = #1944 */
    { 0x0c00, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/0/u = #1945 */
    { 0x0d7f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/1/m = #1946 */
    { 0x0d00, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/1/u = #1947 */
    { 0x0e7f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/2/m = #1948 */
    { 0x0e00, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/2/u = #1949 */
    { 0x0f7f, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/3/m = #1950 */
    { 0x0f00, 0x36c6, 0x3c00, RTFLOAT80U_INIT_C(1,0x71f89b2bac31268b,11121), RTFLOAT80U_INIT_C(0,0x71f89b2bac31268b,11121) }, /* #60/3/3/u = #1951 */
    { 0x007f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/0/m = #1952 */
    { 0x0000, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/0/u = #1953 */
    { 0x017f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/1/m = #1954 */
    { 0x0100, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/1/u = #1955 */
    { 0x027f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/2/m = #1956 */
    { 0x0200, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/2/u = #1957 */
    { 0x037f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/3/m = #1958 */
    { 0x0300, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/0/3/u = #1959 */
    { 0x047f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/0/m = #1960 */
    { 0x0400, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/0/u = #1961 */
    { 0x057f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/1/m = #1962 */
    { 0x0500, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/1/u = #1963 */
    { 0x067f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/2/m = #1964 */
    { 0x0600, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/2/u = #1965 */
    { 0x077f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/3/m = #1966 */
    { 0x0700, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/1/3/u = #1967 */
    { 0x087f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/0/m = #1968 */
    { 0x0800, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/0/u = #1969 */
    { 0x097f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/1/m = #1970 */
    { 0x0900, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/1/u = #1971 */
    { 0x0a7f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/2/m = #1972 */
    { 0x0a00, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/2/u = #1973 */
    { 0x0b7f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/3/m = #1974 */
    { 0x0b00, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/2/3/u = #1975 */
    { 0x0c7f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/0/m = #1976 */
    { 0x0c00, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/0/u = #1977 */
    { 0x0d7f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/1/m = #1978 */
    { 0x0d00, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/1/u = #1979 */
    { 0x0e7f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/2/m = #1980 */
    { 0x0e00, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/2/u = #1981 */
    { 0x0f7f, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/3/m = #1982 */
    { 0x0f00, 0x3658, 0x3c00, RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094), RTFLOAT80U_INIT_C(0,0xa7d35d6828000d12,18094) }, /* #61/3/3/u = #1983 */
    { 0x007f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/0/m = #1984 */
    { 0x0000, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/0/u = #1985 */
    { 0x017f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/1/m = #1986 */
    { 0x0100, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/1/u = #1987 */
    { 0x027f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/2/m = #1988 */
    { 0x0200, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/2/u = #1989 */
    { 0x037f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/3/m = #1990 */
    { 0x0300, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/0/3/u = #1991 */
    { 0x047f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/0/m = #1992 */
    { 0x0400, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/0/u = #1993 */
    { 0x057f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/1/m = #1994 */
    { 0x0500, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/1/u = #1995 */
    { 0x067f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/2/m = #1996 */
    { 0x0600, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/2/u = #1997 */
    { 0x077f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/3/m = #1998 */
    { 0x0700, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/1/3/u = #1999 */
    { 0x087f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/0/m = #2000 */
    { 0x0800, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/0/u = #2001 */
    { 0x097f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/1/m = #2002 */
    { 0x0900, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/1/u = #2003 */
    { 0x0a7f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/2/m = #2004 */
    { 0x0a00, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/2/u = #2005 */
    { 0x0b7f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/3/m = #2006 */
    { 0x0b00, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/2/3/u = #2007 */
    { 0x0c7f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/0/m = #2008 */
    { 0x0c00, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/0/u = #2009 */
    { 0x0d7f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/1/m = #2010 */
    { 0x0d00, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/1/u = #2011 */
    { 0x0e7f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/2/m = #2012 */
    { 0x0e00, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/2/u = #2013 */
    { 0x0f7f, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/3/m = #2014 */
    { 0x0f00, 0x4468, 0x7c00, RTFLOAT80U_INIT_C(1,0xdd74f7c8eb718e97,4669), RTFLOAT80U_INIT_C(0,0xdd74f7c8eb718e97,4669) }, /* #62/3/3/u = #2015 */
    { 0x007f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/0/m = #2016 */
    { 0x0000, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/0/u = #2017 */
    { 0x017f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/1/m = #2018 */
    { 0x0100, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/1/u = #2019 */
    { 0x027f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/2/m = #2020 */
    { 0x0200, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/2/u = #2021 */
    { 0x037f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/3/m = #2022 */
    { 0x0300, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/0/3/u = #2023 */
    { 0x047f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/0/m = #2024 */
    { 0x0400, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/0/u = #2025 */
    { 0x057f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/1/m = #2026 */
    { 0x0500, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/1/u = #2027 */
    { 0x067f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/2/m = #2028 */
    { 0x0600, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/2/u = #2029 */
    { 0x077f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/3/m = #2030 */
    { 0x0700, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/1/3/u = #2031 */
    { 0x087f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/0/m = #2032 */
    { 0x0800, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/0/u = #2033 */
    { 0x097f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/1/m = #2034 */
    { 0x0900, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/1/u = #2035 */
    { 0x0a7f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/2/m = #2036 */
    { 0x0a00, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/2/u = #2037 */
    { 0x0b7f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/3/m = #2038 */
    { 0x0b00, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/2/3/u = #2039 */
    { 0x0c7f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/0/m = #2040 */
    { 0x0c00, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/0/u = #2041 */
    { 0x0d7f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/1/m = #2042 */
    { 0x0d00, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/1/u = #2043 */
    { 0x0e7f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/2/m = #2044 */
    { 0x0e00, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/2/u = #2045 */
    { 0x0f7f, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/3/m = #2046 */
    { 0x0f00, 0x226e, 0x3800, RTFLOAT80U_INIT_C(1,0xd34a1a4edac2049d,9847), RTFLOAT80U_INIT_C(0,0xd34a1a4edac2049d,9847) }, /* #63/3/3/u = #2047 */
    { 0x007f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/0/m = #2048 */
    { 0x0000, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/0/u = #2049 */
    { 0x017f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/1/m = #2050 */
    { 0x0100, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/1/u = #2051 */
    { 0x027f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/2/m = #2052 */
    { 0x0200, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/2/u = #2053 */
    { 0x037f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/3/m = #2054 */
    { 0x0300, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/0/3/u = #2055 */
    { 0x047f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/0/m = #2056 */
    { 0x0400, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/0/u = #2057 */
    { 0x057f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/1/m = #2058 */
    { 0x0500, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/1/u = #2059 */
    { 0x067f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/2/m = #2060 */
    { 0x0600, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/2/u = #2061 */
    { 0x077f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/3/m = #2062 */
    { 0x0700, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/1/3/u = #2063 */
    { 0x087f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/0/m = #2064 */
    { 0x0800, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/0/u = #2065 */
    { 0x097f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/1/m = #2066 */
    { 0x0900, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/1/u = #2067 */
    { 0x0a7f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/2/m = #2068 */
    { 0x0a00, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/2/u = #2069 */
    { 0x0b7f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/3/m = #2070 */
    { 0x0b00, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/2/3/u = #2071 */
    { 0x0c7f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/0/m = #2072 */
    { 0x0c00, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/0/u = #2073 */
    { 0x0d7f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/1/m = #2074 */
    { 0x0d00, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/1/u = #2075 */
    { 0x0e7f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/2/m = #2076 */
    { 0x0e00, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/2/u = #2077 */
    { 0x0f7f, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/3/m = #2078 */
    { 0x0f00, 0x0fad, 0x3d00, RTFLOAT80U_INIT_C(1,0xab0e5252d4754dc2,30257), RTFLOAT80U_INIT_C(0,0xab0e5252d4754dc2,30257) }, /* #64/3/3/u = #2079 */
    { 0x007f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/0/m = #2080 */
    { 0x0000, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/0/u = #2081 */
    { 0x017f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/1/m = #2082 */
    { 0x0100, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/1/u = #2083 */
    { 0x027f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/2/m = #2084 */
    { 0x0200, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/2/u = #2085 */
    { 0x037f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/3/m = #2086 */
    { 0x0300, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/0/3/u = #2087 */
    { 0x047f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/0/m = #2088 */
    { 0x0400, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/0/u = #2089 */
    { 0x057f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/1/m = #2090 */
    { 0x0500, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/1/u = #2091 */
    { 0x067f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/2/m = #2092 */
    { 0x0600, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/2/u = #2093 */
    { 0x077f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/3/m = #2094 */
    { 0x0700, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/1/3/u = #2095 */
    { 0x087f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/0/m = #2096 */
    { 0x0800, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/0/u = #2097 */
    { 0x097f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/1/m = #2098 */
    { 0x0900, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/1/u = #2099 */
    { 0x0a7f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/2/m = #2100 */
    { 0x0a00, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/2/u = #2101 */
    { 0x0b7f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/3/m = #2102 */
    { 0x0b00, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/2/3/u = #2103 */
    { 0x0c7f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/0/m = #2104 */
    { 0x0c00, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/0/u = #2105 */
    { 0x0d7f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/1/m = #2106 */
    { 0x0d00, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/1/u = #2107 */
    { 0x0e7f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/2/m = #2108 */
    { 0x0e00, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/2/u = #2109 */
    { 0x0f7f, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/3/m = #2110 */
    { 0x0f00, 0x77fc, 0x7d00, RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767), RTFLOAT80U_INIT_C(0,0xbc9dfeb203fa0ba5,32767) }, /* #65/3/3/u = #2111 */
    { 0x007f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/0/m = #2112 */
    { 0x0000, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/0/u = #2113 */
    { 0x017f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/1/m = #2114 */
    { 0x0100, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/1/u = #2115 */
    { 0x027f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/2/m = #2116 */
    { 0x0200, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/2/u = #2117 */
    { 0x037f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/3/m = #2118 */
    { 0x0300, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/0/3/u = #2119 */
    { 0x047f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/0/m = #2120 */
    { 0x0400, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/0/u = #2121 */
    { 0x057f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/1/m = #2122 */
    { 0x0500, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/1/u = #2123 */
    { 0x067f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/2/m = #2124 */
    { 0x0600, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/2/u = #2125 */
    { 0x077f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/3/m = #2126 */
    { 0x0700, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/1/3/u = #2127 */
    { 0x087f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/0/m = #2128 */
    { 0x0800, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/0/u = #2129 */
    { 0x097f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/1/m = #2130 */
    { 0x0900, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/1/u = #2131 */
    { 0x0a7f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/2/m = #2132 */
    { 0x0a00, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/2/u = #2133 */
    { 0x0b7f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/3/m = #2134 */
    { 0x0b00, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/2/3/u = #2135 */
    { 0x0c7f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/0/m = #2136 */
    { 0x0c00, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/0/u = #2137 */
    { 0x0d7f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/1/m = #2138 */
    { 0x0d00, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/1/u = #2139 */
    { 0x0e7f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/2/m = #2140 */
    { 0x0e00, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/2/u = #2141 */
    { 0x0f7f, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/3/m = #2142 */
    { 0x0f00, 0xf39a, 0x7900, RTFLOAT80U_INIT_C(1,0x6db4737b69f1a9a9,25404), RTFLOAT80U_INIT_C(0,0x6db4737b69f1a9a9,25404) }, /* #66/3/3/u = #2143 */
    { 0x007f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/0/m = #2144 */
    { 0x0000, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/0/u = #2145 */
    { 0x017f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/1/m = #2146 */
    { 0x0100, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/1/u = #2147 */
    { 0x027f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/2/m = #2148 */
    { 0x0200, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/2/u = #2149 */
    { 0x037f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/3/m = #2150 */
    { 0x0300, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/0/3/u = #2151 */
    { 0x047f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/0/m = #2152 */
    { 0x0400, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/0/u = #2153 */
    { 0x057f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/1/m = #2154 */
    { 0x0500, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/1/u = #2155 */
    { 0x067f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/2/m = #2156 */
    { 0x0600, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/2/u = #2157 */
    { 0x077f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/3/m = #2158 */
    { 0x0700, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/1/3/u = #2159 */
    { 0x087f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/0/m = #2160 */
    { 0x0800, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/0/u = #2161 */
    { 0x097f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/1/m = #2162 */
    { 0x0900, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/1/u = #2163 */
    { 0x0a7f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/2/m = #2164 */
    { 0x0a00, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/2/u = #2165 */
    { 0x0b7f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/3/m = #2166 */
    { 0x0b00, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/2/3/u = #2167 */
    { 0x0c7f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/0/m = #2168 */
    { 0x0c00, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/0/u = #2169 */
    { 0x0d7f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/1/m = #2170 */
    { 0x0d00, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/1/u = #2171 */
    { 0x0e7f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/2/m = #2172 */
    { 0x0e00, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/2/u = #2173 */
    { 0x0f7f, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/3/m = #2174 */
    { 0x0f00, 0x621c, 0x7800, RTFLOAT80U_INIT_C(1,0xf9f947edbf03b4c8,11690), RTFLOAT80U_INIT_C(0,0xf9f947edbf03b4c8,11690) }, /* #67/3/3/u = #2175 */
    { 0x007f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/0/m = #2176 */
    { 0x0000, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/0/u = #2177 */
    { 0x017f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/1/m = #2178 */
    { 0x0100, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/1/u = #2179 */
    { 0x027f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/2/m = #2180 */
    { 0x0200, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/2/u = #2181 */
    { 0x037f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/3/m = #2182 */
    { 0x0300, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/0/3/u = #2183 */
    { 0x047f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/0/m = #2184 */
    { 0x0400, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/0/u = #2185 */
    { 0x057f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/1/m = #2186 */
    { 0x0500, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/1/u = #2187 */
    { 0x067f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/2/m = #2188 */
    { 0x0600, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/2/u = #2189 */
    { 0x077f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/3/m = #2190 */
    { 0x0700, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/1/3/u = #2191 */
    { 0x087f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/0/m = #2192 */
    { 0x0800, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/0/u = #2193 */
    { 0x097f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/1/m = #2194 */
    { 0x0900, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/1/u = #2195 */
    { 0x0a7f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/2/m = #2196 */
    { 0x0a00, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/2/u = #2197 */
    { 0x0b7f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/3/m = #2198 */
    { 0x0b00, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/2/3/u = #2199 */
    { 0x0c7f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/0/m = #2200 */
    { 0x0c00, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/0/u = #2201 */
    { 0x0d7f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/1/m = #2202 */
    { 0x0d00, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/1/u = #2203 */
    { 0x0e7f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/2/m = #2204 */
    { 0x0e00, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/2/u = #2205 */
    { 0x0f7f, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/3/m = #2206 */
    { 0x0f00, 0x73e9, 0x7900, RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432), RTFLOAT80U_INIT_C(0,0x4920c1d8b1430db9,21432) }, /* #68/3/3/u = #2207 */
    { 0x007f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/0/m = #2208 */
    { 0x0000, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/0/u = #2209 */
    { 0x017f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/1/m = #2210 */
    { 0x0100, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/1/u = #2211 */
    { 0x027f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/2/m = #2212 */
    { 0x0200, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/2/u = #2213 */
    { 0x037f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/3/m = #2214 */
    { 0x0300, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/0/3/u = #2215 */
    { 0x047f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/0/m = #2216 */
    { 0x0400, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/0/u = #2217 */
    { 0x057f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/1/m = #2218 */
    { 0x0500, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/1/u = #2219 */
    { 0x067f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/2/m = #2220 */
    { 0x0600, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/2/u = #2221 */
    { 0x077f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/3/m = #2222 */
    { 0x0700, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/1/3/u = #2223 */
    { 0x087f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/0/m = #2224 */
    { 0x0800, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/0/u = #2225 */
    { 0x097f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/1/m = #2226 */
    { 0x0900, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/1/u = #2227 */
    { 0x0a7f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/2/m = #2228 */
    { 0x0a00, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/2/u = #2229 */
    { 0x0b7f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/3/m = #2230 */
    { 0x0b00, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/2/3/u = #2231 */
    { 0x0c7f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/0/m = #2232 */
    { 0x0c00, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/0/u = #2233 */
    { 0x0d7f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/1/m = #2234 */
    { 0x0d00, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/1/u = #2235 */
    { 0x0e7f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/2/m = #2236 */
    { 0x0e00, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/2/u = #2237 */
    { 0x0f7f, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/3/m = #2238 */
    { 0x0f00, 0xf9e5, 0x7900, RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0), RTFLOAT80U_INIT_C(0,0xd3da9ee071f327ab,0) }, /* #69/3/3/u = #2239 */
    { 0x007f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/0/m = #2240 */
    { 0x0000, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/0/u = #2241 */
    { 0x017f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/1/m = #2242 */
    { 0x0100, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/1/u = #2243 */
    { 0x027f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/2/m = #2244 */
    { 0x0200, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/2/u = #2245 */
    { 0x037f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/3/m = #2246 */
    { 0x0300, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/0/3/u = #2247 */
    { 0x047f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/0/m = #2248 */
    { 0x0400, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/0/u = #2249 */
    { 0x057f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/1/m = #2250 */
    { 0x0500, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/1/u = #2251 */
    { 0x067f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/2/m = #2252 */
    { 0x0600, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/2/u = #2253 */
    { 0x077f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/3/m = #2254 */
    { 0x0700, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/1/3/u = #2255 */
    { 0x087f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/0/m = #2256 */
    { 0x0800, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/0/u = #2257 */
    { 0x097f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/1/m = #2258 */
    { 0x0900, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/1/u = #2259 */
    { 0x0a7f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/2/m = #2260 */
    { 0x0a00, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/2/u = #2261 */
    { 0x0b7f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/3/m = #2262 */
    { 0x0b00, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/2/3/u = #2263 */
    { 0x0c7f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/0/m = #2264 */
    { 0x0c00, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/0/u = #2265 */
    { 0x0d7f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/1/m = #2266 */
    { 0x0d00, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/1/u = #2267 */
    { 0x0e7f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/2/m = #2268 */
    { 0x0e00, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/2/u = #2269 */
    { 0x0f7f, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/3/m = #2270 */
    { 0x0f00, 0x4e3b, 0x7c00, RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669), RTFLOAT80U_INIT_C(0,0x8b9f3b178addd2b9,24669) }, /* #70/3/3/u = #2271 */
    { 0x007f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/0/m = #2272 */
    { 0x0000, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/0/u = #2273 */
    { 0x017f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/1/m = #2274 */
    { 0x0100, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/1/u = #2275 */
    { 0x027f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/2/m = #2276 */
    { 0x0200, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/2/u = #2277 */
    { 0x037f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/3/m = #2278 */
    { 0x0300, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/0/3/u = #2279 */
    { 0x047f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/0/m = #2280 */
    { 0x0400, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/0/u = #2281 */
    { 0x057f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/1/m = #2282 */
    { 0x0500, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/1/u = #2283 */
    { 0x067f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/2/m = #2284 */
    { 0x0600, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/2/u = #2285 */
    { 0x077f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/3/m = #2286 */
    { 0x0700, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/1/3/u = #2287 */
    { 0x087f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/0/m = #2288 */
    { 0x0800, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/0/u = #2289 */
    { 0x097f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/1/m = #2290 */
    { 0x0900, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/1/u = #2291 */
    { 0x0a7f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/2/m = #2292 */
    { 0x0a00, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/2/u = #2293 */
    { 0x0b7f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/3/m = #2294 */
    { 0x0b00, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/2/3/u = #2295 */
    { 0x0c7f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/0/m = #2296 */
    { 0x0c00, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/0/u = #2297 */
    { 0x0d7f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/1/m = #2298 */
    { 0x0d00, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/1/u = #2299 */
    { 0x0e7f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/2/m = #2300 */
    { 0x0e00, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/2/u = #2301 */
    { 0x0f7f, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/3/m = #2302 */
    { 0x0f00, 0x183e, 0x3800, RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554), RTFLOAT80U_INIT_C(0,0xffe8a88e055a548f,26554) }, /* #71/3/3/u = #2303 */
    { 0x007f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/0/m = #2304 */
    { 0x0000, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/0/u = #2305 */
    { 0x017f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/1/m = #2306 */
    { 0x0100, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/1/u = #2307 */
    { 0x027f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/2/m = #2308 */
    { 0x0200, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/2/u = #2309 */
    { 0x037f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/3/m = #2310 */
    { 0x0300, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/0/3/u = #2311 */
    { 0x047f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/0/m = #2312 */
    { 0x0400, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/0/u = #2313 */
    { 0x057f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/1/m = #2314 */
    { 0x0500, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/1/u = #2315 */
    { 0x067f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/2/m = #2316 */
    { 0x0600, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/2/u = #2317 */
    { 0x077f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/3/m = #2318 */
    { 0x0700, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/1/3/u = #2319 */
    { 0x087f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/0/m = #2320 */
    { 0x0800, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/0/u = #2321 */
    { 0x097f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/1/m = #2322 */
    { 0x0900, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/1/u = #2323 */
    { 0x0a7f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/2/m = #2324 */
    { 0x0a00, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/2/u = #2325 */
    { 0x0b7f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/3/m = #2326 */
    { 0x0b00, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/2/3/u = #2327 */
    { 0x0c7f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/0/m = #2328 */
    { 0x0c00, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/0/u = #2329 */
    { 0x0d7f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/1/m = #2330 */
    { 0x0d00, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/1/u = #2331 */
    { 0x0e7f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/2/m = #2332 */
    { 0x0e00, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/2/u = #2333 */
    { 0x0f7f, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/3/m = #2334 */
    { 0x0f00, 0x89cb, 0x3900, RTFLOAT80U_INIT_C(1,0x8001b4fe8edd5b81,0), RTFLOAT80U_INIT_C(0,0x8001b4fe8edd5b81,0) }, /* #72/3/3/u = #2335 */
    { 0x007f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/0/m = #2336 */
    { 0x0000, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/0/u = #2337 */
    { 0x017f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/1/m = #2338 */
    { 0x0100, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/1/u = #2339 */
    { 0x027f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/2/m = #2340 */
    { 0x0200, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/2/u = #2341 */
    { 0x037f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/3/m = #2342 */
    { 0x0300, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/0/3/u = #2343 */
    { 0x047f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/0/m = #2344 */
    { 0x0400, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/0/u = #2345 */
    { 0x057f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/1/m = #2346 */
    { 0x0500, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/1/u = #2347 */
    { 0x067f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/2/m = #2348 */
    { 0x0600, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/2/u = #2349 */
    { 0x077f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/3/m = #2350 */
    { 0x0700, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/1/3/u = #2351 */
    { 0x087f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/0/m = #2352 */
    { 0x0800, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/0/u = #2353 */
    { 0x097f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/1/m = #2354 */
    { 0x0900, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/1/u = #2355 */
    { 0x0a7f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/2/m = #2356 */
    { 0x0a00, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/2/u = #2357 */
    { 0x0b7f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/3/m = #2358 */
    { 0x0b00, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/2/3/u = #2359 */
    { 0x0c7f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/0/m = #2360 */
    { 0x0c00, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/0/u = #2361 */
    { 0x0d7f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/1/m = #2362 */
    { 0x0d00, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/1/u = #2363 */
    { 0x0e7f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/2/m = #2364 */
    { 0x0e00, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/2/u = #2365 */
    { 0x0f7f, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/3/m = #2366 */
    { 0x0f00, 0xc5fe, 0x7d00, RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767), RTFLOAT80U_INIT_C(0,0xd46b4d7a249a8bbb,32767) }, /* #73/3/3/u = #2367 */
    { 0x007f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/0/m = #2368 */
    { 0x0000, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/0/u = #2369 */
    { 0x017f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/1/m = #2370 */
    { 0x0100, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/1/u = #2371 */
    { 0x027f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/2/m = #2372 */
    { 0x0200, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/2/u = #2373 */
    { 0x037f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/3/m = #2374 */
    { 0x0300, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/0/3/u = #2375 */
    { 0x047f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/0/m = #2376 */
    { 0x0400, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/0/u = #2377 */
    { 0x057f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/1/m = #2378 */
    { 0x0500, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/1/u = #2379 */
    { 0x067f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/2/m = #2380 */
    { 0x0600, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/2/u = #2381 */
    { 0x077f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/3/m = #2382 */
    { 0x0700, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/1/3/u = #2383 */
    { 0x087f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/0/m = #2384 */
    { 0x0800, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/0/u = #2385 */
    { 0x097f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/1/m = #2386 */
    { 0x0900, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/1/u = #2387 */
    { 0x0a7f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/2/m = #2388 */
    { 0x0a00, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/2/u = #2389 */
    { 0x0b7f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/3/m = #2390 */
    { 0x0b00, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/2/3/u = #2391 */
    { 0x0c7f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/0/m = #2392 */
    { 0x0c00, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/0/u = #2393 */
    { 0x0d7f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/1/m = #2394 */
    { 0x0d00, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/1/u = #2395 */
    { 0x0e7f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/2/m = #2396 */
    { 0x0e00, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/2/u = #2397 */
    { 0x0f7f, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/3/m = #2398 */
    { 0x0f00, 0x4c61, 0x7c00, RTFLOAT80U_INIT_C(1,0xb24ba38ff7bb94f9,3518), RTFLOAT80U_INIT_C(0,0xb24ba38ff7bb94f9,3518) }, /* #74/3/3/u = #2399 */
    { 0x007f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/0/m = #2400 */
    { 0x0000, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/0/u = #2401 */
    { 0x017f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/1/m = #2402 */
    { 0x0100, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/1/u = #2403 */
    { 0x027f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/2/m = #2404 */
    { 0x0200, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/2/u = #2405 */
    { 0x037f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/3/m = #2406 */
    { 0x0300, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/0/3/u = #2407 */
    { 0x047f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/0/m = #2408 */
    { 0x0400, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/0/u = #2409 */
    { 0x057f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/1/m = #2410 */
    { 0x0500, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/1/u = #2411 */
    { 0x067f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/2/m = #2412 */
    { 0x0600, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/2/u = #2413 */
    { 0x077f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/3/m = #2414 */
    { 0x0700, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/1/3/u = #2415 */
    { 0x087f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/0/m = #2416 */
    { 0x0800, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/0/u = #2417 */
    { 0x097f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/1/m = #2418 */
    { 0x0900, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/1/u = #2419 */
    { 0x0a7f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/2/m = #2420 */
    { 0x0a00, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/2/u = #2421 */
    { 0x0b7f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/3/m = #2422 */
    { 0x0b00, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/2/3/u = #2423 */
    { 0x0c7f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/0/m = #2424 */
    { 0x0c00, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/0/u = #2425 */
    { 0x0d7f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/1/m = #2426 */
    { 0x0d00, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/1/u = #2427 */
    { 0x0e7f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/2/m = #2428 */
    { 0x0e00, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/2/u = #2429 */
    { 0x0f7f, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/3/m = #2430 */
    { 0x0f00, 0x053f, 0x3d00, RTFLOAT80U_INIT_C(1,0xc00007e4da7c4883,32767), RTFLOAT80U_INIT_C(0,0xc00007e4da7c4883,32767) }, /* #75/3/3/u = #2431 */
    { 0x007f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/0/m = #2432 */
    { 0x0000, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/0/u = #2433 */
    { 0x017f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/1/m = #2434 */
    { 0x0100, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/1/u = #2435 */
    { 0x027f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/2/m = #2436 */
    { 0x0200, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/2/u = #2437 */
    { 0x037f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/3/m = #2438 */
    { 0x0300, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/0/3/u = #2439 */
    { 0x047f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/0/m = #2440 */
    { 0x0400, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/0/u = #2441 */
    { 0x057f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/1/m = #2442 */
    { 0x0500, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/1/u = #2443 */
    { 0x067f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/2/m = #2444 */
    { 0x0600, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/2/u = #2445 */
    { 0x077f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/3/m = #2446 */
    { 0x0700, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/1/3/u = #2447 */
    { 0x087f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/0/m = #2448 */
    { 0x0800, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/0/u = #2449 */
    { 0x097f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/1/m = #2450 */
    { 0x0900, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/1/u = #2451 */
    { 0x0a7f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/2/m = #2452 */
    { 0x0a00, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/2/u = #2453 */
    { 0x0b7f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/3/m = #2454 */
    { 0x0b00, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/2/3/u = #2455 */
    { 0x0c7f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/0/m = #2456 */
    { 0x0c00, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/0/u = #2457 */
    { 0x0d7f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/1/m = #2458 */
    { 0x0d00, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/1/u = #2459 */
    { 0x0e7f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/2/m = #2460 */
    { 0x0e00, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/2/u = #2461 */
    { 0x0f7f, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/3/m = #2462 */
    { 0x0f00, 0xa8ac, 0x3800, RTFLOAT80U_INIT_C(1,0x6531c4815566478b,20405), RTFLOAT80U_INIT_C(0,0x6531c4815566478b,20405) }, /* #76/3/3/u = #2463 */
    { 0x007f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/0/m = #2464 */
    { 0x0000, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/0/u = #2465 */
    { 0x017f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/1/m = #2466 */
    { 0x0100, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/1/u = #2467 */
    { 0x027f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/2/m = #2468 */
    { 0x0200, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/2/u = #2469 */
    { 0x037f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/3/m = #2470 */
    { 0x0300, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/0/3/u = #2471 */
    { 0x047f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/0/m = #2472 */
    { 0x0400, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/0/u = #2473 */
    { 0x057f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/1/m = #2474 */
    { 0x0500, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/1/u = #2475 */
    { 0x067f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/2/m = #2476 */
    { 0x0600, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/2/u = #2477 */
    { 0x077f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/3/m = #2478 */
    { 0x0700, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/1/3/u = #2479 */
    { 0x087f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/0/m = #2480 */
    { 0x0800, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/0/u = #2481 */
    { 0x097f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/1/m = #2482 */
    { 0x0900, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/1/u = #2483 */
    { 0x0a7f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/2/m = #2484 */
    { 0x0a00, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/2/u = #2485 */
    { 0x0b7f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/3/m = #2486 */
    { 0x0b00, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/2/3/u = #2487 */
    { 0x0c7f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/0/m = #2488 */
    { 0x0c00, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/0/u = #2489 */
    { 0x0d7f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/1/m = #2490 */
    { 0x0d00, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/1/u = #2491 */
    { 0x0e7f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/2/m = #2492 */
    { 0x0e00, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/2/u = #2493 */
    { 0x0f7f, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/3/m = #2494 */
    { 0x0f00, 0xfba9, 0x7900, RTFLOAT80U_INIT_C(1,0x958b4ba08c72cb84,32767), RTFLOAT80U_INIT_C(0,0x958b4ba08c72cb84,32767) }, /* #77/3/3/u = #2495 */
    { 0x007f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/0/m = #2496 */
    { 0x0000, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/0/u = #2497 */
    { 0x017f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/1/m = #2498 */
    { 0x0100, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/1/u = #2499 */
    { 0x027f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/2/m = #2500 */
    { 0x0200, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/2/u = #2501 */
    { 0x037f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/3/m = #2502 */
    { 0x0300, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/0/3/u = #2503 */
    { 0x047f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/0/m = #2504 */
    { 0x0400, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/0/u = #2505 */
    { 0x057f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/1/m = #2506 */
    { 0x0500, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/1/u = #2507 */
    { 0x067f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/2/m = #2508 */
    { 0x0600, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/2/u = #2509 */
    { 0x077f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/3/m = #2510 */
    { 0x0700, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/1/3/u = #2511 */
    { 0x087f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/0/m = #2512 */
    { 0x0800, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/0/u = #2513 */
    { 0x097f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/1/m = #2514 */
    { 0x0900, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/1/u = #2515 */
    { 0x0a7f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/2/m = #2516 */
    { 0x0a00, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/2/u = #2517 */
    { 0x0b7f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/3/m = #2518 */
    { 0x0b00, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/2/3/u = #2519 */
    { 0x0c7f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/0/m = #2520 */
    { 0x0c00, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/0/u = #2521 */
    { 0x0d7f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/1/m = #2522 */
    { 0x0d00, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/1/u = #2523 */
    { 0x0e7f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/2/m = #2524 */
    { 0x0e00, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/2/u = #2525 */
    { 0x0f7f, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/3/m = #2526 */
    { 0x0f00, 0xce41, 0x7c00, RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819), RTFLOAT80U_INIT_C(0,0x10ab15cdb6f488b5,23819) }, /* #78/3/3/u = #2527 */
    { 0x007f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/0/m = #2528 */
    { 0x0000, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/0/u = #2529 */
    { 0x017f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/1/m = #2530 */
    { 0x0100, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/1/u = #2531 */
    { 0x027f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/2/m = #2532 */
    { 0x0200, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/2/u = #2533 */
    { 0x037f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/3/m = #2534 */
    { 0x0300, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/0/3/u = #2535 */
    { 0x047f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/0/m = #2536 */
    { 0x0400, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/0/u = #2537 */
    { 0x057f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/1/m = #2538 */
    { 0x0500, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/1/u = #2539 */
    { 0x067f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/2/m = #2540 */
    { 0x0600, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/2/u = #2541 */
    { 0x077f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/3/m = #2542 */
    { 0x0700, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/1/3/u = #2543 */
    { 0x087f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/0/m = #2544 */
    { 0x0800, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/0/u = #2545 */
    { 0x097f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/1/m = #2546 */
    { 0x0900, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/1/u = #2547 */
    { 0x0a7f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/2/m = #2548 */
    { 0x0a00, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/2/u = #2549 */
    { 0x0b7f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/3/m = #2550 */
    { 0x0b00, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/2/3/u = #2551 */
    { 0x0c7f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/0/m = #2552 */
    { 0x0c00, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/0/u = #2553 */
    { 0x0d7f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/1/m = #2554 */
    { 0x0d00, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/1/u = #2555 */
    { 0x0e7f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/2/m = #2556 */
    { 0x0e00, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/2/u = #2557 */
    { 0x0f7f, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/3/m = #2558 */
    { 0x0f00, 0x8f08, 0x3d00, RTFLOAT80U_INIT_C(1,0x931231ef0f5edb55,12130), RTFLOAT80U_INIT_C(0,0x931231ef0f5edb55,12130) }, /* #79/3/3/u = #2559 */
    { 0x007f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/0/m = #2560 */
    { 0x0000, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/0/u = #2561 */
    { 0x017f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/1/m = #2562 */
    { 0x0100, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/1/u = #2563 */
    { 0x027f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/2/m = #2564 */
    { 0x0200, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/2/u = #2565 */
    { 0x037f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/3/m = #2566 */
    { 0x0300, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/0/3/u = #2567 */
    { 0x047f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/0/m = #2568 */
    { 0x0400, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/0/u = #2569 */
    { 0x057f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/1/m = #2570 */
    { 0x0500, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/1/u = #2571 */
    { 0x067f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/2/m = #2572 */
    { 0x0600, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/2/u = #2573 */
    { 0x077f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/3/m = #2574 */
    { 0x0700, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/1/3/u = #2575 */
    { 0x087f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/0/m = #2576 */
    { 0x0800, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/0/u = #2577 */
    { 0x097f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/1/m = #2578 */
    { 0x0900, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/1/u = #2579 */
    { 0x0a7f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/2/m = #2580 */
    { 0x0a00, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/2/u = #2581 */
    { 0x0b7f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/3/m = #2582 */
    { 0x0b00, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/2/3/u = #2583 */
    { 0x0c7f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/0/m = #2584 */
    { 0x0c00, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/0/u = #2585 */
    { 0x0d7f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/1/m = #2586 */
    { 0x0d00, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/1/u = #2587 */
    { 0x0e7f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/2/m = #2588 */
    { 0x0e00, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/2/u = #2589 */
    { 0x0f7f, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/3/m = #2590 */
    { 0x0f00, 0x0ec4, 0x3c00, RTFLOAT80U_INIT_C(1,0x392f4bdb84024b68,0), RTFLOAT80U_INIT_C(0,0x392f4bdb84024b68,0) }, /* #80/3/3/u = #2591 */
    { 0x007f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/0/m = #2592 */
    { 0x0000, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/0/u = #2593 */
    { 0x017f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/1/m = #2594 */
    { 0x0100, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/1/u = #2595 */
    { 0x027f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/2/m = #2596 */
    { 0x0200, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/2/u = #2597 */
    { 0x037f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/3/m = #2598 */
    { 0x0300, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/0/3/u = #2599 */
    { 0x047f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/0/m = #2600 */
    { 0x0400, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/0/u = #2601 */
    { 0x057f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/1/m = #2602 */
    { 0x0500, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/1/u = #2603 */
    { 0x067f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/2/m = #2604 */
    { 0x0600, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/2/u = #2605 */
    { 0x077f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/3/m = #2606 */
    { 0x0700, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/1/3/u = #2607 */
    { 0x087f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/0/m = #2608 */
    { 0x0800, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/0/u = #2609 */
    { 0x097f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/1/m = #2610 */
    { 0x0900, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/1/u = #2611 */
    { 0x0a7f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/2/m = #2612 */
    { 0x0a00, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/2/u = #2613 */
    { 0x0b7f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/3/m = #2614 */
    { 0x0b00, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/2/3/u = #2615 */
    { 0x0c7f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/0/m = #2616 */
    { 0x0c00, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/0/u = #2617 */
    { 0x0d7f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/1/m = #2618 */
    { 0x0d00, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/1/u = #2619 */
    { 0x0e7f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/2/m = #2620 */
    { 0x0e00, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/2/u = #2621 */
    { 0x0f7f, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/3/m = #2622 */
    { 0x0f00, 0x4e77, 0x7c00, RTFLOAT80U_INIT_C(1,0x992d98137e9115bb,32767), RTFLOAT80U_INIT_C(0,0x992d98137e9115bb,32767) }, /* #81/3/3/u = #2623 */
    { 0x007f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/0/m = #2624 */
    { 0x0000, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/0/u = #2625 */
    { 0x017f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/1/m = #2626 */
    { 0x0100, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/1/u = #2627 */
    { 0x027f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/2/m = #2628 */
    { 0x0200, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/2/u = #2629 */
    { 0x037f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/3/m = #2630 */
    { 0x0300, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/0/3/u = #2631 */
    { 0x047f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/0/m = #2632 */
    { 0x0400, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/0/u = #2633 */
    { 0x057f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/1/m = #2634 */
    { 0x0500, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/1/u = #2635 */
    { 0x067f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/2/m = #2636 */
    { 0x0600, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/2/u = #2637 */
    { 0x077f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/3/m = #2638 */
    { 0x0700, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/1/3/u = #2639 */
    { 0x087f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/0/m = #2640 */
    { 0x0800, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/0/u = #2641 */
    { 0x097f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/1/m = #2642 */
    { 0x0900, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/1/u = #2643 */
    { 0x0a7f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/2/m = #2644 */
    { 0x0a00, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/2/u = #2645 */
    { 0x0b7f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/3/m = #2646 */
    { 0x0b00, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/2/3/u = #2647 */
    { 0x0c7f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/0/m = #2648 */
    { 0x0c00, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/0/u = #2649 */
    { 0x0d7f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/1/m = #2650 */
    { 0x0d00, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/1/u = #2651 */
    { 0x0e7f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/2/m = #2652 */
    { 0x0e00, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/2/u = #2653 */
    { 0x0f7f, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/3/m = #2654 */
    { 0x0f00, 0xe043, 0x7800, RTFLOAT80U_INIT_C(1,0xc0000000000338a4,32767), RTFLOAT80U_INIT_C(0,0xc0000000000338a4,32767) }, /* #82/3/3/u = #2655 */
    { 0x007f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/0/m = #2656 */
    { 0x0000, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/0/u = #2657 */
    { 0x017f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/1/m = #2658 */
    { 0x0100, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/1/u = #2659 */
    { 0x027f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/2/m = #2660 */
    { 0x0200, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/2/u = #2661 */
    { 0x037f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/3/m = #2662 */
    { 0x0300, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/0/3/u = #2663 */
    { 0x047f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/0/m = #2664 */
    { 0x0400, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/0/u = #2665 */
    { 0x057f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/1/m = #2666 */
    { 0x0500, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/1/u = #2667 */
    { 0x067f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/2/m = #2668 */
    { 0x0600, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/2/u = #2669 */
    { 0x077f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/3/m = #2670 */
    { 0x0700, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/1/3/u = #2671 */
    { 0x087f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/0/m = #2672 */
    { 0x0800, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/0/u = #2673 */
    { 0x097f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/1/m = #2674 */
    { 0x0900, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/1/u = #2675 */
    { 0x0a7f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/2/m = #2676 */
    { 0x0a00, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/2/u = #2677 */
    { 0x0b7f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/3/m = #2678 */
    { 0x0b00, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/2/3/u = #2679 */
    { 0x0c7f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/0/m = #2680 */
    { 0x0c00, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/0/u = #2681 */
    { 0x0d7f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/1/m = #2682 */
    { 0x0d00, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/1/u = #2683 */
    { 0x0e7f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/2/m = #2684 */
    { 0x0e00, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/2/u = #2685 */
    { 0x0f7f, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/3/m = #2686 */
    { 0x0f00, 0x7877, 0x7800, RTFLOAT80U_INIT_C(1,0xe1186d9eb2366c69,18172), RTFLOAT80U_INIT_C(0,0xe1186d9eb2366c69,18172) }, /* #83/3/3/u = #2687 */
    { 0x007f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/0/m = #2688 */
    { 0x0000, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/0/u = #2689 */
    { 0x017f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/1/m = #2690 */
    { 0x0100, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/1/u = #2691 */
    { 0x027f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/2/m = #2692 */
    { 0x0200, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/2/u = #2693 */
    { 0x037f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/3/m = #2694 */
    { 0x0300, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/0/3/u = #2695 */
    { 0x047f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/0/m = #2696 */
    { 0x0400, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/0/u = #2697 */
    { 0x057f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/1/m = #2698 */
    { 0x0500, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/1/u = #2699 */
    { 0x067f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/2/m = #2700 */
    { 0x0600, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/2/u = #2701 */
    { 0x077f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/3/m = #2702 */
    { 0x0700, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/1/3/u = #2703 */
    { 0x087f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/0/m = #2704 */
    { 0x0800, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/0/u = #2705 */
    { 0x097f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/1/m = #2706 */
    { 0x0900, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/1/u = #2707 */
    { 0x0a7f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/2/m = #2708 */
    { 0x0a00, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/2/u = #2709 */
    { 0x0b7f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/3/m = #2710 */
    { 0x0b00, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/2/3/u = #2711 */
    { 0x0c7f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/0/m = #2712 */
    { 0x0c00, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/0/u = #2713 */
    { 0x0d7f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/1/m = #2714 */
    { 0x0d00, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/1/u = #2715 */
    { 0x0e7f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/2/m = #2716 */
    { 0x0e00, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/2/u = #2717 */
    { 0x0f7f, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/3/m = #2718 */
    { 0x0f00, 0x26ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178), RTFLOAT80U_INIT_C(0,0xf719ea85d1a78a90,31178) }, /* #84/3/3/u = #2719 */
    { 0x007f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/0/m = #2720 */
    { 0x0000, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/0/u = #2721 */
    { 0x017f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/1/m = #2722 */
    { 0x0100, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/1/u = #2723 */
    { 0x027f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/2/m = #2724 */
    { 0x0200, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/2/u = #2725 */
    { 0x037f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/3/m = #2726 */
    { 0x0300, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/0/3/u = #2727 */
    { 0x047f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/0/m = #2728 */
    { 0x0400, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/0/u = #2729 */
    { 0x057f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/1/m = #2730 */
    { 0x0500, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/1/u = #2731 */
    { 0x067f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/2/m = #2732 */
    { 0x0600, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/2/u = #2733 */
    { 0x077f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/3/m = #2734 */
    { 0x0700, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/1/3/u = #2735 */
    { 0x087f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/0/m = #2736 */
    { 0x0800, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/0/u = #2737 */
    { 0x097f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/1/m = #2738 */
    { 0x0900, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/1/u = #2739 */
    { 0x0a7f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/2/m = #2740 */
    { 0x0a00, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/2/u = #2741 */
    { 0x0b7f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/3/m = #2742 */
    { 0x0b00, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/2/3/u = #2743 */
    { 0x0c7f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/0/m = #2744 */
    { 0x0c00, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/0/u = #2745 */
    { 0x0d7f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/1/m = #2746 */
    { 0x0d00, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/1/u = #2747 */
    { 0x0e7f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/2/m = #2748 */
    { 0x0e00, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/2/u = #2749 */
    { 0x0f7f, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/3/m = #2750 */
    { 0x0f00, 0x3bb0, 0x3900, RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767), RTFLOAT80U_INIT_C(0,0x34bc7af70ea546db,32767) }, /* #85/3/3/u = #2751 */
    { 0x007f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/0/m = #2752 */
    { 0x0000, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/0/u = #2753 */
    { 0x017f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/1/m = #2754 */
    { 0x0100, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/1/u = #2755 */
    { 0x027f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/2/m = #2756 */
    { 0x0200, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/2/u = #2757 */
    { 0x037f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/3/m = #2758 */
    { 0x0300, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/0/3/u = #2759 */
    { 0x047f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/0/m = #2760 */
    { 0x0400, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/0/u = #2761 */
    { 0x057f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/1/m = #2762 */
    { 0x0500, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/1/u = #2763 */
    { 0x067f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/2/m = #2764 */
    { 0x0600, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/2/u = #2765 */
    { 0x077f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/3/m = #2766 */
    { 0x0700, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/1/3/u = #2767 */
    { 0x087f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/0/m = #2768 */
    { 0x0800, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/0/u = #2769 */
    { 0x097f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/1/m = #2770 */
    { 0x0900, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/1/u = #2771 */
    { 0x0a7f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/2/m = #2772 */
    { 0x0a00, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/2/u = #2773 */
    { 0x0b7f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/3/m = #2774 */
    { 0x0b00, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/2/3/u = #2775 */
    { 0x0c7f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/0/m = #2776 */
    { 0x0c00, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/0/u = #2777 */
    { 0x0d7f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/1/m = #2778 */
    { 0x0d00, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/1/u = #2779 */
    { 0x0e7f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/2/m = #2780 */
    { 0x0e00, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/2/u = #2781 */
    { 0x0f7f, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/3/m = #2782 */
    { 0x0f00, 0x4358, 0x7900, RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025), RTFLOAT80U_INIT_C(0,0xba711c9fa8cf3a1f,2025) }, /* #86/3/3/u = #2783 */
    { 0x007f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/0/m = #2784 */
    { 0x0000, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/0/u = #2785 */
    { 0x017f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/1/m = #2786 */
    { 0x0100, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/1/u = #2787 */
    { 0x027f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/2/m = #2788 */
    { 0x0200, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/2/u = #2789 */
    { 0x037f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/3/m = #2790 */
    { 0x0300, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/0/3/u = #2791 */
    { 0x047f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/0/m = #2792 */
    { 0x0400, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/0/u = #2793 */
    { 0x057f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/1/m = #2794 */
    { 0x0500, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/1/u = #2795 */
    { 0x067f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/2/m = #2796 */
    { 0x0600, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/2/u = #2797 */
    { 0x077f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/3/m = #2798 */
    { 0x0700, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/1/3/u = #2799 */
    { 0x087f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/0/m = #2800 */
    { 0x0800, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/0/u = #2801 */
    { 0x097f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/1/m = #2802 */
    { 0x0900, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/1/u = #2803 */
    { 0x0a7f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/2/m = #2804 */
    { 0x0a00, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/2/u = #2805 */
    { 0x0b7f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/3/m = #2806 */
    { 0x0b00, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/2/3/u = #2807 */
    { 0x0c7f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/0/m = #2808 */
    { 0x0c00, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/0/u = #2809 */
    { 0x0d7f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/1/m = #2810 */
    { 0x0d00, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/1/u = #2811 */
    { 0x0e7f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/2/m = #2812 */
    { 0x0e00, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/2/u = #2813 */
    { 0x0f7f, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/3/m = #2814 */
    { 0x0f00, 0xf365, 0x7900, RTFLOAT80U_INIT_C(1,0x8d8448d6c0748216,28831), RTFLOAT80U_INIT_C(0,0x8d8448d6c0748216,28831) }, /* #87/3/3/u = #2815 */
    { 0x007f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/0/m = #2816 */
    { 0x0000, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/0/u = #2817 */
    { 0x017f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/1/m = #2818 */
    { 0x0100, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/1/u = #2819 */
    { 0x027f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/2/m = #2820 */
    { 0x0200, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/2/u = #2821 */
    { 0x037f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/3/m = #2822 */
    { 0x0300, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/0/3/u = #2823 */
    { 0x047f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/0/m = #2824 */
    { 0x0400, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/0/u = #2825 */
    { 0x057f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/1/m = #2826 */
    { 0x0500, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/1/u = #2827 */
    { 0x067f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/2/m = #2828 */
    { 0x0600, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/2/u = #2829 */
    { 0x077f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/3/m = #2830 */
    { 0x0700, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/1/3/u = #2831 */
    { 0x087f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/0/m = #2832 */
    { 0x0800, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/0/u = #2833 */
    { 0x097f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/1/m = #2834 */
    { 0x0900, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/1/u = #2835 */
    { 0x0a7f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/2/m = #2836 */
    { 0x0a00, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/2/u = #2837 */
    { 0x0b7f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/3/m = #2838 */
    { 0x0b00, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/2/3/u = #2839 */
    { 0x0c7f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/0/m = #2840 */
    { 0x0c00, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/0/u = #2841 */
    { 0x0d7f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/1/m = #2842 */
    { 0x0d00, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/1/u = #2843 */
    { 0x0e7f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/2/m = #2844 */
    { 0x0e00, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/2/u = #2845 */
    { 0x0f7f, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/3/m = #2846 */
    { 0x0f00, 0x2e67, 0x3c00, RTFLOAT80U_INIT_C(1,0xef61bce1688b5c8f,10155), RTFLOAT80U_INIT_C(0,0xef61bce1688b5c8f,10155) }, /* #88/3/3/u = #2847 */
    { 0x007f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/0/m = #2848 */
    { 0x0000, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/0/u = #2849 */
    { 0x017f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/1/m = #2850 */
    { 0x0100, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/1/u = #2851 */
    { 0x027f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/2/m = #2852 */
    { 0x0200, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/2/u = #2853 */
    { 0x037f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/3/m = #2854 */
    { 0x0300, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/0/3/u = #2855 */
    { 0x047f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/0/m = #2856 */
    { 0x0400, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/0/u = #2857 */
    { 0x057f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/1/m = #2858 */
    { 0x0500, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/1/u = #2859 */
    { 0x067f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/2/m = #2860 */
    { 0x0600, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/2/u = #2861 */
    { 0x077f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/3/m = #2862 */
    { 0x0700, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/1/3/u = #2863 */
    { 0x087f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/0/m = #2864 */
    { 0x0800, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/0/u = #2865 */
    { 0x097f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/1/m = #2866 */
    { 0x0900, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/1/u = #2867 */
    { 0x0a7f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/2/m = #2868 */
    { 0x0a00, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/2/u = #2869 */
    { 0x0b7f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/3/m = #2870 */
    { 0x0b00, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/2/3/u = #2871 */
    { 0x0c7f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/0/m = #2872 */
    { 0x0c00, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/0/u = #2873 */
    { 0x0d7f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/1/m = #2874 */
    { 0x0d00, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/1/u = #2875 */
    { 0x0e7f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/2/m = #2876 */
    { 0x0e00, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/2/u = #2877 */
    { 0x0f7f, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/3/m = #2878 */
    { 0x0f00, 0xc7f2, 0x7d00, RTFLOAT80U_INIT_C(1,0x2e453b4d14cf466f,0), RTFLOAT80U_INIT_C(0,0x2e453b4d14cf466f,0) }, /* #89/3/3/u = #2879 */
    { 0x007f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/0/m = #2880 */
    { 0x0000, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/0/u = #2881 */
    { 0x017f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/1/m = #2882 */
    { 0x0100, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/1/u = #2883 */
    { 0x027f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/2/m = #2884 */
    { 0x0200, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/2/u = #2885 */
    { 0x037f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/3/m = #2886 */
    { 0x0300, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/0/3/u = #2887 */
    { 0x047f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/0/m = #2888 */
    { 0x0400, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/0/u = #2889 */
    { 0x057f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/1/m = #2890 */
    { 0x0500, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/1/u = #2891 */
    { 0x067f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/2/m = #2892 */
    { 0x0600, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/2/u = #2893 */
    { 0x077f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/3/m = #2894 */
    { 0x0700, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/1/3/u = #2895 */
    { 0x087f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/0/m = #2896 */
    { 0x0800, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/0/u = #2897 */
    { 0x097f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/1/m = #2898 */
    { 0x0900, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/1/u = #2899 */
    { 0x0a7f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/2/m = #2900 */
    { 0x0a00, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/2/u = #2901 */
    { 0x0b7f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/3/m = #2902 */
    { 0x0b00, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/2/3/u = #2903 */
    { 0x0c7f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/0/m = #2904 */
    { 0x0c00, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/0/u = #2905 */
    { 0x0d7f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/1/m = #2906 */
    { 0x0d00, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/1/u = #2907 */
    { 0x0e7f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/2/m = #2908 */
    { 0x0e00, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/2/u = #2909 */
    { 0x0f7f, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/3/m = #2910 */
    { 0x0f00, 0x91df, 0x3900, RTFLOAT80U_INIT_C(1,0x253a545b703738e1,32767), RTFLOAT80U_INIT_C(0,0x253a545b703738e1,32767) }, /* #90/3/3/u = #2911 */
    { 0x007f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/0/m = #2912 */
    { 0x0000, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/0/u = #2913 */
    { 0x017f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/1/m = #2914 */
    { 0x0100, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/1/u = #2915 */
    { 0x027f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/2/m = #2916 */
    { 0x0200, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/2/u = #2917 */
    { 0x037f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/3/m = #2918 */
    { 0x0300, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/0/3/u = #2919 */
    { 0x047f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/0/m = #2920 */
    { 0x0400, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/0/u = #2921 */
    { 0x057f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/1/m = #2922 */
    { 0x0500, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/1/u = #2923 */
    { 0x067f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/2/m = #2924 */
    { 0x0600, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/2/u = #2925 */
    { 0x077f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/3/m = #2926 */
    { 0x0700, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/1/3/u = #2927 */
    { 0x087f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/0/m = #2928 */
    { 0x0800, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/0/u = #2929 */
    { 0x097f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/1/m = #2930 */
    { 0x0900, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/1/u = #2931 */
    { 0x0a7f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/2/m = #2932 */
    { 0x0a00, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/2/u = #2933 */
    { 0x0b7f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/3/m = #2934 */
    { 0x0b00, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/2/3/u = #2935 */
    { 0x0c7f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/0/m = #2936 */
    { 0x0c00, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/0/u = #2937 */
    { 0x0d7f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/1/m = #2938 */
    { 0x0d00, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/1/u = #2939 */
    { 0x0e7f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/2/m = #2940 */
    { 0x0e00, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/2/u = #2941 */
    { 0x0f7f, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/3/m = #2942 */
    { 0x0f00, 0x6c6e, 0x7c00, RTFLOAT80U_INIT_C(1,0xabe627853a308460,32767), RTFLOAT80U_INIT_C(0,0xabe627853a308460,32767) }, /* #91/3/3/u = #2943 */
    { 0x007f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/0/m = #2944 */
    { 0x0000, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/0/u = #2945 */
    { 0x017f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/1/m = #2946 */
    { 0x0100, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/1/u = #2947 */
    { 0x027f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/2/m = #2948 */
    { 0x0200, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/2/u = #2949 */
    { 0x037f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/3/m = #2950 */
    { 0x0300, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/0/3/u = #2951 */
    { 0x047f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/0/m = #2952 */
    { 0x0400, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/0/u = #2953 */
    { 0x057f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/1/m = #2954 */
    { 0x0500, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/1/u = #2955 */
    { 0x067f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/2/m = #2956 */
    { 0x0600, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/2/u = #2957 */
    { 0x077f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/3/m = #2958 */
    { 0x0700, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/1/3/u = #2959 */
    { 0x087f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/0/m = #2960 */
    { 0x0800, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/0/u = #2961 */
    { 0x097f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/1/m = #2962 */
    { 0x0900, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/1/u = #2963 */
    { 0x0a7f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/2/m = #2964 */
    { 0x0a00, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/2/u = #2965 */
    { 0x0b7f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/3/m = #2966 */
    { 0x0b00, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/2/3/u = #2967 */
    { 0x0c7f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/0/m = #2968 */
    { 0x0c00, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/0/u = #2969 */
    { 0x0d7f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/1/m = #2970 */
    { 0x0d00, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/1/u = #2971 */
    { 0x0e7f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/2/m = #2972 */
    { 0x0e00, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/2/u = #2973 */
    { 0x0f7f, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/3/m = #2974 */
    { 0x0f00, 0xb5b0, 0x3d00, RTFLOAT80U_INIT_C(1,0xbcb103397d2a5b3a,10711), RTFLOAT80U_INIT_C(0,0xbcb103397d2a5b3a,10711) }, /* #92/3/3/u = #2975 */
    { 0x007f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/0/m = #2976 */
    { 0x0000, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/0/u = #2977 */
    { 0x017f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/1/m = #2978 */
    { 0x0100, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/1/u = #2979 */
    { 0x027f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/2/m = #2980 */
    { 0x0200, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/2/u = #2981 */
    { 0x037f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/3/m = #2982 */
    { 0x0300, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/0/3/u = #2983 */
    { 0x047f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/0/m = #2984 */
    { 0x0400, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/0/u = #2985 */
    { 0x057f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/1/m = #2986 */
    { 0x0500, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/1/u = #2987 */
    { 0x067f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/2/m = #2988 */
    { 0x0600, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/2/u = #2989 */
    { 0x077f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/3/m = #2990 */
    { 0x0700, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/1/3/u = #2991 */
    { 0x087f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/0/m = #2992 */
    { 0x0800, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/0/u = #2993 */
    { 0x097f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/1/m = #2994 */
    { 0x0900, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/1/u = #2995 */
    { 0x0a7f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/2/m = #2996 */
    { 0x0a00, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/2/u = #2997 */
    { 0x0b7f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/3/m = #2998 */
    { 0x0b00, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/2/3/u = #2999 */
    { 0x0c7f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/0/m = #3000 */
    { 0x0c00, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/0/u = #3001 */
    { 0x0d7f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/1/m = #3002 */
    { 0x0d00, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/1/u = #3003 */
    { 0x0e7f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/2/m = #3004 */
    { 0x0e00, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/2/u = #3005 */
    { 0x0f7f, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/3/m = #3006 */
    { 0x0f00, 0x2cf0, 0x3c00, RTFLOAT80U_INIT_C(1,0xf774067089cf8d0f,9088), RTFLOAT80U_INIT_C(0,0xf774067089cf8d0f,9088) }, /* #93/3/3/u = #3007 */
    { 0x007f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/0/m = #3008 */
    { 0x0000, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/0/u = #3009 */
    { 0x017f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/1/m = #3010 */
    { 0x0100, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/1/u = #3011 */
    { 0x027f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/2/m = #3012 */
    { 0x0200, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/2/u = #3013 */
    { 0x037f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/3/m = #3014 */
    { 0x0300, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/0/3/u = #3015 */
    { 0x047f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/0/m = #3016 */
    { 0x0400, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/0/u = #3017 */
    { 0x057f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/1/m = #3018 */
    { 0x0500, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/1/u = #3019 */
    { 0x067f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/2/m = #3020 */
    { 0x0600, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/2/u = #3021 */
    { 0x077f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/3/m = #3022 */
    { 0x0700, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/1/3/u = #3023 */
    { 0x087f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/0/m = #3024 */
    { 0x0800, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/0/u = #3025 */
    { 0x097f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/1/m = #3026 */
    { 0x0900, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/1/u = #3027 */
    { 0x0a7f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/2/m = #3028 */
    { 0x0a00, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/2/u = #3029 */
    { 0x0b7f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/3/m = #3030 */
    { 0x0b00, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/2/3/u = #3031 */
    { 0x0c7f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/0/m = #3032 */
    { 0x0c00, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/0/u = #3033 */
    { 0x0d7f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/1/m = #3034 */
    { 0x0d00, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/1/u = #3035 */
    { 0x0e7f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/2/m = #3036 */
    { 0x0e00, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/2/u = #3037 */
    { 0x0f7f, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/3/m = #3038 */
    { 0x0f00, 0x4740, 0x7d00, RTFLOAT80U_INIT_C(1,0xc201fa7a500c01ab,22943), RTFLOAT80U_INIT_C(0,0xc201fa7a500c01ab,22943) }, /* #94/3/3/u = #3039 */
    { 0x007f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/0/m = #3040 */
    { 0x0000, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/0/u = #3041 */
    { 0x017f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/1/m = #3042 */
    { 0x0100, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/1/u = #3043 */
    { 0x027f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/2/m = #3044 */
    { 0x0200, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/2/u = #3045 */
    { 0x037f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/3/m = #3046 */
    { 0x0300, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/0/3/u = #3047 */
    { 0x047f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/0/m = #3048 */
    { 0x0400, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/0/u = #3049 */
    { 0x057f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/1/m = #3050 */
    { 0x0500, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/1/u = #3051 */
    { 0x067f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/2/m = #3052 */
    { 0x0600, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/2/u = #3053 */
    { 0x077f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/3/m = #3054 */
    { 0x0700, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/1/3/u = #3055 */
    { 0x087f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/0/m = #3056 */
    { 0x0800, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/0/u = #3057 */
    { 0x097f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/1/m = #3058 */
    { 0x0900, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/1/u = #3059 */
    { 0x0a7f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/2/m = #3060 */
    { 0x0a00, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/2/u = #3061 */
    { 0x0b7f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/3/m = #3062 */
    { 0x0b00, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/2/3/u = #3063 */
    { 0x0c7f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/0/m = #3064 */
    { 0x0c00, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/0/u = #3065 */
    { 0x0d7f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/1/m = #3066 */
    { 0x0d00, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/1/u = #3067 */
    { 0x0e7f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/2/m = #3068 */
    { 0x0e00, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/2/u = #3069 */
    { 0x0f7f, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/3/m = #3070 */
    { 0x0f00, 0x9e00, 0x3c00, RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767), RTFLOAT80U_INIT_C(0,0xd84f57c2a15f8c08,32767) }, /* #95/3/3/u = #3071 */
    { 0x007f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/0/m = #3072 */
    { 0x0000, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/0/u = #3073 */
    { 0x017f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/1/m = #3074 */
    { 0x0100, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/1/u = #3075 */
    { 0x027f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/2/m = #3076 */
    { 0x0200, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/2/u = #3077 */
    { 0x037f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/3/m = #3078 */
    { 0x0300, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/0/3/u = #3079 */
    { 0x047f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/0/m = #3080 */
    { 0x0400, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/0/u = #3081 */
    { 0x057f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/1/m = #3082 */
    { 0x0500, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/1/u = #3083 */
    { 0x067f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/2/m = #3084 */
    { 0x0600, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/2/u = #3085 */
    { 0x077f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/3/m = #3086 */
    { 0x0700, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/1/3/u = #3087 */
    { 0x087f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/0/m = #3088 */
    { 0x0800, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/0/u = #3089 */
    { 0x097f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/1/m = #3090 */
    { 0x0900, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/1/u = #3091 */
    { 0x0a7f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/2/m = #3092 */
    { 0x0a00, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/2/u = #3093 */
    { 0x0b7f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/3/m = #3094 */
    { 0x0b00, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/2/3/u = #3095 */
    { 0x0c7f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/0/m = #3096 */
    { 0x0c00, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/0/u = #3097 */
    { 0x0d7f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/1/m = #3098 */
    { 0x0d00, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/1/u = #3099 */
    { 0x0e7f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/2/m = #3100 */
    { 0x0e00, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/2/u = #3101 */
    { 0x0f7f, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/3/m = #3102 */
    { 0x0f00, 0xba28, 0x3800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #96/3/3/u = #3103 */
    { 0x007f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/0/m = #3104 */
    { 0x0000, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/0/u = #3105 */
    { 0x017f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/1/m = #3106 */
    { 0x0100, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/1/u = #3107 */
    { 0x027f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/2/m = #3108 */
    { 0x0200, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/2/u = #3109 */
    { 0x037f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/3/m = #3110 */
    { 0x0300, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/3/u = #3111 */
    { 0x047f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/0/m = #3112 */
    { 0x0400, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/0/u = #3113 */
    { 0x057f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/1/m = #3114 */
    { 0x0500, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/1/u = #3115 */
    { 0x067f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/2/m = #3116 */
    { 0x0600, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/2/u = #3117 */
    { 0x077f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/3/m = #3118 */
    { 0x0700, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/3/u = #3119 */
    { 0x087f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/0/m = #3120 */
    { 0x0800, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/0/u = #3121 */
    { 0x097f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/1/m = #3122 */
    { 0x0900, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/1/u = #3123 */
    { 0x0a7f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/2/m = #3124 */
    { 0x0a00, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/2/u = #3125 */
    { 0x0b7f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/3/m = #3126 */
    { 0x0b00, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/3/u = #3127 */
    { 0x0c7f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/0/m = #3128 */
    { 0x0c00, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/0/u = #3129 */
    { 0x0d7f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/1/m = #3130 */
    { 0x0d00, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/1/u = #3131 */
    { 0x0e7f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/2/m = #3132 */
    { 0x0e00, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/2/u = #3133 */
    { 0x0f7f, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/3/m = #3134 */
    { 0x0f00, 0x66a0, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/3/u = #3135 */
    { 0x007f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/0/m = #3136 */
    { 0x0000, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/0/u = #3137 */
    { 0x017f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/1/m = #3138 */
    { 0x0100, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/1/u = #3139 */
    { 0x027f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/2/m = #3140 */
    { 0x0200, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/2/u = #3141 */
    { 0x037f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/3/m = #3142 */
    { 0x0300, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/3/u = #3143 */
    { 0x047f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/0/m = #3144 */
    { 0x0400, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/0/u = #3145 */
    { 0x057f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/1/m = #3146 */
    { 0x0500, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/1/u = #3147 */
    { 0x067f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/2/m = #3148 */
    { 0x0600, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/2/u = #3149 */
    { 0x077f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/3/m = #3150 */
    { 0x0700, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/3/u = #3151 */
    { 0x087f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/0/m = #3152 */
    { 0x0800, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/0/u = #3153 */
    { 0x097f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/1/m = #3154 */
    { 0x0900, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/1/u = #3155 */
    { 0x0a7f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/2/m = #3156 */
    { 0x0a00, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/2/u = #3157 */
    { 0x0b7f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/3/m = #3158 */
    { 0x0b00, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/3/u = #3159 */
    { 0x0c7f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/0/m = #3160 */
    { 0x0c00, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/0/u = #3161 */
    { 0x0d7f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/1/m = #3162 */
    { 0x0d00, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/1/u = #3163 */
    { 0x0e7f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/2/m = #3164 */
    { 0x0e00, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/2/u = #3165 */
    { 0x0f7f, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/3/m = #3166 */
    { 0x0f00, 0xdd7b, 0x7d00, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/3/u = #3167 */
    { 0x007f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/0/m = #3168 */
    { 0x0000, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/0/u = #3169 */
    { 0x017f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/1/m = #3170 */
    { 0x0100, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/1/u = #3171 */
    { 0x027f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/2/m = #3172 */
    { 0x0200, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/2/u = #3173 */
    { 0x037f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/3/m = #3174 */
    { 0x0300, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/3/u = #3175 */
    { 0x047f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/0/m = #3176 */
    { 0x0400, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/0/u = #3177 */
    { 0x057f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/1/m = #3178 */
    { 0x0500, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/1/u = #3179 */
    { 0x067f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/2/m = #3180 */
    { 0x0600, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/2/u = #3181 */
    { 0x077f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/3/m = #3182 */
    { 0x0700, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/3/u = #3183 */
    { 0x087f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/0/m = #3184 */
    { 0x0800, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/0/u = #3185 */
    { 0x097f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/1/m = #3186 */
    { 0x0900, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/1/u = #3187 */
    { 0x0a7f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/2/m = #3188 */
    { 0x0a00, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/2/u = #3189 */
    { 0x0b7f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/3/m = #3190 */
    { 0x0b00, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/3/u = #3191 */
    { 0x0c7f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/0/m = #3192 */
    { 0x0c00, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/0/u = #3193 */
    { 0x0d7f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/1/m = #3194 */
    { 0x0d00, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/1/u = #3195 */
    { 0x0e7f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/2/m = #3196 */
    { 0x0e00, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/2/u = #3197 */
    { 0x0f7f, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/3/m = #3198 */
    { 0x0f00, 0xa3a1, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/3/u = #3199 */
    { 0x007f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/0/m = #3200 */
    { 0x0000, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/0/u = #3201 */
    { 0x017f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/1/m = #3202 */
    { 0x0100, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/1/u = #3203 */
    { 0x027f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/2/m = #3204 */
    { 0x0200, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/2/u = #3205 */
    { 0x037f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/3/m = #3206 */
    { 0x0300, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/3/u = #3207 */
    { 0x047f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/0/m = #3208 */
    { 0x0400, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/0/u = #3209 */
    { 0x057f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/1/m = #3210 */
    { 0x0500, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/1/u = #3211 */
    { 0x067f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/2/m = #3212 */
    { 0x0600, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/2/u = #3213 */
    { 0x077f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/3/m = #3214 */
    { 0x0700, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/3/u = #3215 */
    { 0x087f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/0/m = #3216 */
    { 0x0800, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/0/u = #3217 */
    { 0x097f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/1/m = #3218 */
    { 0x0900, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/1/u = #3219 */
    { 0x0a7f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/2/m = #3220 */
    { 0x0a00, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/2/u = #3221 */
    { 0x0b7f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/3/m = #3222 */
    { 0x0b00, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/3/u = #3223 */
    { 0x0c7f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/0/m = #3224 */
    { 0x0c00, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/0/u = #3225 */
    { 0x0d7f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/1/m = #3226 */
    { 0x0d00, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/1/u = #3227 */
    { 0x0e7f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/2/m = #3228 */
    { 0x0e00, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/2/u = #3229 */
    { 0x0f7f, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/3/m = #3230 */
    { 0x0f00, 0xdc71, 0x7c00, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/3/u = #3231 */
    { 0x007f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/0/m = #3232 */
    { 0x0000, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/0/u = #3233 */
    { 0x017f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/1/m = #3234 */
    { 0x0100, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/1/u = #3235 */
    { 0x027f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/2/m = #3236 */
    { 0x0200, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/2/u = #3237 */
    { 0x037f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/3/m = #3238 */
    { 0x0300, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/3/u = #3239 */
    { 0x047f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/0/m = #3240 */
    { 0x0400, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/0/u = #3241 */
    { 0x057f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/1/m = #3242 */
    { 0x0500, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/1/u = #3243 */
    { 0x067f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/2/m = #3244 */
    { 0x0600, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/2/u = #3245 */
    { 0x077f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/3/m = #3246 */
    { 0x0700, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/3/u = #3247 */
    { 0x087f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/0/m = #3248 */
    { 0x0800, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/0/u = #3249 */
    { 0x097f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/1/m = #3250 */
    { 0x0900, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/1/u = #3251 */
    { 0x0a7f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/2/m = #3252 */
    { 0x0a00, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/2/u = #3253 */
    { 0x0b7f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/3/m = #3254 */
    { 0x0b00, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/3/u = #3255 */
    { 0x0c7f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/0/m = #3256 */
    { 0x0c00, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/0/u = #3257 */
    { 0x0d7f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/1/m = #3258 */
    { 0x0d00, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/1/u = #3259 */
    { 0x0e7f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/2/m = #3260 */
    { 0x0e00, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/2/u = #3261 */
    { 0x0f7f, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/3/m = #3262 */
    { 0x0f00, 0x7ec7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/3/u = #3263 */
    { 0x007f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/0/m = #3264 */
    { 0x0000, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/0/u = #3265 */
    { 0x017f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/1/m = #3266 */
    { 0x0100, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/1/u = #3267 */
    { 0x027f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/2/m = #3268 */
    { 0x0200, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/2/u = #3269 */
    { 0x037f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/3/m = #3270 */
    { 0x0300, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/3/u = #3271 */
    { 0x047f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/0/m = #3272 */
    { 0x0400, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/0/u = #3273 */
    { 0x057f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/1/m = #3274 */
    { 0x0500, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/1/u = #3275 */
    { 0x067f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/2/m = #3276 */
    { 0x0600, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/2/u = #3277 */
    { 0x077f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/3/m = #3278 */
    { 0x0700, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/3/u = #3279 */
    { 0x087f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/0/m = #3280 */
    { 0x0800, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/0/u = #3281 */
    { 0x097f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/1/m = #3282 */
    { 0x0900, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/1/u = #3283 */
    { 0x0a7f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/2/m = #3284 */
    { 0x0a00, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/2/u = #3285 */
    { 0x0b7f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/3/m = #3286 */
    { 0x0b00, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/3/u = #3287 */
    { 0x0c7f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/0/m = #3288 */
    { 0x0c00, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/0/u = #3289 */
    { 0x0d7f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/1/m = #3290 */
    { 0x0d00, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/1/u = #3291 */
    { 0x0e7f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/2/m = #3292 */
    { 0x0e00, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/2/u = #3293 */
    { 0x0f7f, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/3/m = #3294 */
    { 0x0f00, 0x3123, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/3/u = #3295 */
    { 0x007f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/0/m = #3296 */
    { 0x0000, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/0/u = #3297 */
    { 0x017f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/1/m = #3298 */
    { 0x0100, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/1/u = #3299 */
    { 0x027f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/2/m = #3300 */
    { 0x0200, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/2/u = #3301 */
    { 0x037f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/3/m = #3302 */
    { 0x0300, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/3/u = #3303 */
    { 0x047f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/0/m = #3304 */
    { 0x0400, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/0/u = #3305 */
    { 0x057f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/1/m = #3306 */
    { 0x0500, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/1/u = #3307 */
    { 0x067f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/2/m = #3308 */
    { 0x0600, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/2/u = #3309 */
    { 0x077f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/3/m = #3310 */
    { 0x0700, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/3/u = #3311 */
    { 0x087f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/0/m = #3312 */
    { 0x0800, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/0/u = #3313 */
    { 0x097f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/1/m = #3314 */
    { 0x0900, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/1/u = #3315 */
    { 0x0a7f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/2/m = #3316 */
    { 0x0a00, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/2/u = #3317 */
    { 0x0b7f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/3/m = #3318 */
    { 0x0b00, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/3/u = #3319 */
    { 0x0c7f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/0/m = #3320 */
    { 0x0c00, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/0/u = #3321 */
    { 0x0d7f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/1/m = #3322 */
    { 0x0d00, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/1/u = #3323 */
    { 0x0e7f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/2/m = #3324 */
    { 0x0e00, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/2/u = #3325 */
    { 0x0f7f, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/3/m = #3326 */
    { 0x0f00, 0xb3d5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/3/u = #3327 */
    { 0x007f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/0/m = #3328 */
    { 0x0000, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/0/u = #3329 */
    { 0x017f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/1/m = #3330 */
    { 0x0100, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/1/u = #3331 */
    { 0x027f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/2/m = #3332 */
    { 0x0200, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/2/u = #3333 */
    { 0x037f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/3/m = #3334 */
    { 0x0300, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/3/u = #3335 */
    { 0x047f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/0/m = #3336 */
    { 0x0400, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/0/u = #3337 */
    { 0x057f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/1/m = #3338 */
    { 0x0500, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/1/u = #3339 */
    { 0x067f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/2/m = #3340 */
    { 0x0600, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/2/u = #3341 */
    { 0x077f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/3/m = #3342 */
    { 0x0700, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/3/u = #3343 */
    { 0x087f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/0/m = #3344 */
    { 0x0800, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/0/u = #3345 */
    { 0x097f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/1/m = #3346 */
    { 0x0900, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/1/u = #3347 */
    { 0x0a7f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/2/m = #3348 */
    { 0x0a00, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/2/u = #3349 */
    { 0x0b7f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/3/m = #3350 */
    { 0x0b00, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/3/u = #3351 */
    { 0x0c7f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/0/m = #3352 */
    { 0x0c00, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/0/u = #3353 */
    { 0x0d7f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/1/m = #3354 */
    { 0x0d00, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/1/u = #3355 */
    { 0x0e7f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/2/m = #3356 */
    { 0x0e00, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/2/u = #3357 */
    { 0x0f7f, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/3/m = #3358 */
    { 0x0f00, 0x0409, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/3/u = #3359 */
    { 0x007f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/0/m = #3360 */
    { 0x0000, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/0/u = #3361 */
    { 0x017f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/1/m = #3362 */
    { 0x0100, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/1/u = #3363 */
    { 0x027f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/2/m = #3364 */
    { 0x0200, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/2/u = #3365 */
    { 0x037f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/3/m = #3366 */
    { 0x0300, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/3/u = #3367 */
    { 0x047f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/0/m = #3368 */
    { 0x0400, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/0/u = #3369 */
    { 0x057f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/1/m = #3370 */
    { 0x0500, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/1/u = #3371 */
    { 0x067f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/2/m = #3372 */
    { 0x0600, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/2/u = #3373 */
    { 0x077f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/3/m = #3374 */
    { 0x0700, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/3/u = #3375 */
    { 0x087f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/0/m = #3376 */
    { 0x0800, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/0/u = #3377 */
    { 0x097f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/1/m = #3378 */
    { 0x0900, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/1/u = #3379 */
    { 0x0a7f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/2/m = #3380 */
    { 0x0a00, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/2/u = #3381 */
    { 0x0b7f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/3/m = #3382 */
    { 0x0b00, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/3/u = #3383 */
    { 0x0c7f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/0/m = #3384 */
    { 0x0c00, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/0/u = #3385 */
    { 0x0d7f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/1/m = #3386 */
    { 0x0d00, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/1/u = #3387 */
    { 0x0e7f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/2/m = #3388 */
    { 0x0e00, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/2/u = #3389 */
    { 0x0f7f, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/3/m = #3390 */
    { 0x0f00, 0xa174, 0x3900, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/3/u = #3391 */
};
uint32_t const g_cTests_fabs_r80 = RT_ELEMENTS(g_aTests_fabs_r80);

FPU_UNARY_R80_TEST_T const g_aTests_fchs_r80[] =
{
    { 0x007f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/0/m = #0 */
    { 0x0000, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/0/u = #1 */
    { 0x017f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/1/m = #2 */
    { 0x0100, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/1/u = #3 */
    { 0x027f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/2/m = #4 */
    { 0x0200, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/2/u = #5 */
    { 0x037f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/3/m = #6 */
    { 0x0300, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/0/3/u = #7 */
    { 0x047f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/0/m = #8 */
    { 0x0400, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/0/u = #9 */
    { 0x057f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/1/m = #10 */
    { 0x0500, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/1/u = #11 */
    { 0x067f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/2/m = #12 */
    { 0x0600, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/2/u = #13 */
    { 0x077f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/3/m = #14 */
    { 0x0700, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/1/3/u = #15 */
    { 0x087f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/0/m = #16 */
    { 0x0800, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/0/u = #17 */
    { 0x097f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/1/m = #18 */
    { 0x0900, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/1/u = #19 */
    { 0x0a7f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/2/m = #20 */
    { 0x0a00, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/2/u = #21 */
    { 0x0b7f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/3/m = #22 */
    { 0x0b00, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/2/3/u = #23 */
    { 0x0c7f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/0/m = #24 */
    { 0x0c00, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/0/u = #25 */
    { 0x0d7f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/1/m = #26 */
    { 0x0d00, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/1/u = #27 */
    { 0x0e7f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/2/m = #28 */
    { 0x0e00, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/2/u = #29 */
    { 0x0f7f, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/3/m = #30 */
    { 0x0f00, 0xf529, 0x7d00, RTFLOAT80U_INIT_C(0,0xe2484f511136da98,17631), RTFLOAT80U_INIT_C(1,0xe2484f511136da98,17631) }, /* #0/3/3/u = #31 */
    { 0x007f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/0/m = #32 */
    { 0x0000, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/0/u = #33 */
    { 0x017f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/1/m = #34 */
    { 0x0100, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/1/u = #35 */
    { 0x027f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/2/m = #36 */
    { 0x0200, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/2/u = #37 */
    { 0x037f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/3/m = #38 */
    { 0x0300, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/0/3/u = #39 */
    { 0x047f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/0/m = #40 */
    { 0x0400, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/0/u = #41 */
    { 0x057f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/1/m = #42 */
    { 0x0500, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/1/u = #43 */
    { 0x067f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/2/m = #44 */
    { 0x0600, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/2/u = #45 */
    { 0x077f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/3/m = #46 */
    { 0x0700, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/1/3/u = #47 */
    { 0x087f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/0/m = #48 */
    { 0x0800, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/0/u = #49 */
    { 0x097f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/1/m = #50 */
    { 0x0900, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/1/u = #51 */
    { 0x0a7f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/2/m = #52 */
    { 0x0a00, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/2/u = #53 */
    { 0x0b7f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/3/m = #54 */
    { 0x0b00, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/2/3/u = #55 */
    { 0x0c7f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/0/m = #56 */
    { 0x0c00, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/0/u = #57 */
    { 0x0d7f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/1/m = #58 */
    { 0x0d00, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/1/u = #59 */
    { 0x0e7f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/2/m = #60 */
    { 0x0e00, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/2/u = #61 */
    { 0x0f7f, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/3/m = #62 */
    { 0x0f00, 0xff36, 0x7d00, RTFLOAT80U_INIT_C(1,0xac81daf85be0308d,22994), RTFLOAT80U_INIT_C(0,0xac81daf85be0308d,22994) }, /* #1/3/3/u = #63 */
    { 0x007f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/0/m = #64 */
    { 0x0000, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/0/u = #65 */
    { 0x017f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/1/m = #66 */
    { 0x0100, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/1/u = #67 */
    { 0x027f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/2/m = #68 */
    { 0x0200, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/2/u = #69 */
    { 0x037f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/3/m = #70 */
    { 0x0300, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/0/3/u = #71 */
    { 0x047f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/0/m = #72 */
    { 0x0400, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/0/u = #73 */
    { 0x057f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/1/m = #74 */
    { 0x0500, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/1/u = #75 */
    { 0x067f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/2/m = #76 */
    { 0x0600, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/2/u = #77 */
    { 0x077f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/3/m = #78 */
    { 0x0700, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/1/3/u = #79 */
    { 0x087f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/0/m = #80 */
    { 0x0800, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/0/u = #81 */
    { 0x097f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/1/m = #82 */
    { 0x0900, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/1/u = #83 */
    { 0x0a7f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/2/m = #84 */
    { 0x0a00, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/2/u = #85 */
    { 0x0b7f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/3/m = #86 */
    { 0x0b00, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/2/3/u = #87 */
    { 0x0c7f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/0/m = #88 */
    { 0x0c00, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/0/u = #89 */
    { 0x0d7f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/1/m = #90 */
    { 0x0d00, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/1/u = #91 */
    { 0x0e7f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/2/m = #92 */
    { 0x0e00, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/2/u = #93 */
    { 0x0f7f, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/3/m = #94 */
    { 0x0f00, 0x7e9b, 0x7c00, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,14881), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,14881) }, /* #2/3/3/u = #95 */
    { 0x007f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/0/m = #96 */
    { 0x0000, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/0/u = #97 */
    { 0x017f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/1/m = #98 */
    { 0x0100, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/1/u = #99 */
    { 0x027f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/2/m = #100 */
    { 0x0200, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/2/u = #101 */
    { 0x037f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/3/m = #102 */
    { 0x0300, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/0/3/u = #103 */
    { 0x047f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/0/m = #104 */
    { 0x0400, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/0/u = #105 */
    { 0x057f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/1/m = #106 */
    { 0x0500, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/1/u = #107 */
    { 0x067f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/2/m = #108 */
    { 0x0600, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/2/u = #109 */
    { 0x077f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/3/m = #110 */
    { 0x0700, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/1/3/u = #111 */
    { 0x087f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/0/m = #112 */
    { 0x0800, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/0/u = #113 */
    { 0x097f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/1/m = #114 */
    { 0x0900, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/1/u = #115 */
    { 0x0a7f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/2/m = #116 */
    { 0x0a00, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/2/u = #117 */
    { 0x0b7f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/3/m = #118 */
    { 0x0b00, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/2/3/u = #119 */
    { 0x0c7f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/0/m = #120 */
    { 0x0c00, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/0/u = #121 */
    { 0x0d7f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/1/m = #122 */
    { 0x0d00, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/1/u = #123 */
    { 0x0e7f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/2/m = #124 */
    { 0x0e00, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/2/u = #125 */
    { 0x0f7f, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/3/m = #126 */
    { 0x0f00, 0x9a20, 0x3800, RTFLOAT80U_INIT_C(1,0x11fd4,8991), RTFLOAT80U_INIT_C(0,0x11fd4,8991) }, /* #3/3/3/u = #127 */
    { 0x007f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/0/m = #128 */
    { 0x0000, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/0/u = #129 */
    { 0x017f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/1/m = #130 */
    { 0x0100, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/1/u = #131 */
    { 0x027f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/2/m = #132 */
    { 0x0200, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/2/u = #133 */
    { 0x037f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/3/m = #134 */
    { 0x0300, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/0/3/u = #135 */
    { 0x047f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/0/m = #136 */
    { 0x0400, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/0/u = #137 */
    { 0x057f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/1/m = #138 */
    { 0x0500, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/1/u = #139 */
    { 0x067f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/2/m = #140 */
    { 0x0600, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/2/u = #141 */
    { 0x077f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/3/m = #142 */
    { 0x0700, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/1/3/u = #143 */
    { 0x087f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/0/m = #144 */
    { 0x0800, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/0/u = #145 */
    { 0x097f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/1/m = #146 */
    { 0x0900, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/1/u = #147 */
    { 0x0a7f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/2/m = #148 */
    { 0x0a00, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/2/u = #149 */
    { 0x0b7f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/3/m = #150 */
    { 0x0b00, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/2/3/u = #151 */
    { 0x0c7f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/0/m = #152 */
    { 0x0c00, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/0/u = #153 */
    { 0x0d7f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/1/m = #154 */
    { 0x0d00, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/1/u = #155 */
    { 0x0e7f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/2/m = #156 */
    { 0x0e00, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/2/u = #157 */
    { 0x0f7f, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/3/m = #158 */
    { 0x0f00, 0xc2ee, 0x7800, RTFLOAT80U_INIT_C(1,0x50377e6ac8d723d6,4282), RTFLOAT80U_INIT_C(0,0x50377e6ac8d723d6,4282) }, /* #4/3/3/u = #159 */
    { 0x007f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/0/m = #160 */
    { 0x0000, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/0/u = #161 */
    { 0x017f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/1/m = #162 */
    { 0x0100, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/1/u = #163 */
    { 0x027f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/2/m = #164 */
    { 0x0200, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/2/u = #165 */
    { 0x037f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/3/m = #166 */
    { 0x0300, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/0/3/u = #167 */
    { 0x047f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/0/m = #168 */
    { 0x0400, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/0/u = #169 */
    { 0x057f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/1/m = #170 */
    { 0x0500, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/1/u = #171 */
    { 0x067f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/2/m = #172 */
    { 0x0600, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/2/u = #173 */
    { 0x077f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/3/m = #174 */
    { 0x0700, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/1/3/u = #175 */
    { 0x087f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/0/m = #176 */
    { 0x0800, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/0/u = #177 */
    { 0x097f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/1/m = #178 */
    { 0x0900, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/1/u = #179 */
    { 0x0a7f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/2/m = #180 */
    { 0x0a00, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/2/u = #181 */
    { 0x0b7f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/3/m = #182 */
    { 0x0b00, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/2/3/u = #183 */
    { 0x0c7f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/0/m = #184 */
    { 0x0c00, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/0/u = #185 */
    { 0x0d7f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/1/m = #186 */
    { 0x0d00, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/1/u = #187 */
    { 0x0e7f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/2/m = #188 */
    { 0x0e00, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/2/u = #189 */
    { 0x0f7f, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/3/m = #190 */
    { 0x0f00, 0xbb89, 0x3900, RTFLOAT80U_INIT_C(1,0x80000000011f5740,32767), RTFLOAT80U_INIT_C(0,0x80000000011f5740,32767) }, /* #5/3/3/u = #191 */
    { 0x007f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/0/m = #192 */
    { 0x0000, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/0/u = #193 */
    { 0x017f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/1/m = #194 */
    { 0x0100, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/1/u = #195 */
    { 0x027f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/2/m = #196 */
    { 0x0200, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/2/u = #197 */
    { 0x037f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/3/m = #198 */
    { 0x0300, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/0/3/u = #199 */
    { 0x047f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/0/m = #200 */
    { 0x0400, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/0/u = #201 */
    { 0x057f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/1/m = #202 */
    { 0x0500, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/1/u = #203 */
    { 0x067f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/2/m = #204 */
    { 0x0600, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/2/u = #205 */
    { 0x077f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/3/m = #206 */
    { 0x0700, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/1/3/u = #207 */
    { 0x087f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/0/m = #208 */
    { 0x0800, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/0/u = #209 */
    { 0x097f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/1/m = #210 */
    { 0x0900, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/1/u = #211 */
    { 0x0a7f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/2/m = #212 */
    { 0x0a00, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/2/u = #213 */
    { 0x0b7f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/3/m = #214 */
    { 0x0b00, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/2/3/u = #215 */
    { 0x0c7f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/0/m = #216 */
    { 0x0c00, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/0/u = #217 */
    { 0x0d7f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/1/m = #218 */
    { 0x0d00, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/1/u = #219 */
    { 0x0e7f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/2/m = #220 */
    { 0x0e00, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/2/u = #221 */
    { 0x0f7f, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/3/m = #222 */
    { 0x0f00, 0xaffe, 0x3d00, RTFLOAT80U_INIT_C(1,0xa148a323fac7a19a,32767), RTFLOAT80U_INIT_C(0,0xa148a323fac7a19a,32767) }, /* #6/3/3/u = #223 */
    { 0x007f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/0/m = #224 */
    { 0x0000, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/0/u = #225 */
    { 0x017f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/1/m = #226 */
    { 0x0100, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/1/u = #227 */
    { 0x027f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/2/m = #228 */
    { 0x0200, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/2/u = #229 */
    { 0x037f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/3/m = #230 */
    { 0x0300, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/0/3/u = #231 */
    { 0x047f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/0/m = #232 */
    { 0x0400, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/0/u = #233 */
    { 0x057f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/1/m = #234 */
    { 0x0500, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/1/u = #235 */
    { 0x067f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/2/m = #236 */
    { 0x0600, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/2/u = #237 */
    { 0x077f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/3/m = #238 */
    { 0x0700, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/1/3/u = #239 */
    { 0x087f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/0/m = #240 */
    { 0x0800, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/0/u = #241 */
    { 0x097f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/1/m = #242 */
    { 0x0900, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/1/u = #243 */
    { 0x0a7f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/2/m = #244 */
    { 0x0a00, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/2/u = #245 */
    { 0x0b7f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/3/m = #246 */
    { 0x0b00, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/2/3/u = #247 */
    { 0x0c7f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/0/m = #248 */
    { 0x0c00, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/0/u = #249 */
    { 0x0d7f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/1/m = #250 */
    { 0x0d00, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/1/u = #251 */
    { 0x0e7f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/2/m = #252 */
    { 0x0e00, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/2/u = #253 */
    { 0x0f7f, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/3/m = #254 */
    { 0x0f00, 0x1164, 0x3900, RTFLOAT80U_INIT_C(0,0xc00003623a9b6042,32767), RTFLOAT80U_INIT_C(1,0xc00003623a9b6042,32767) }, /* #7/3/3/u = #255 */
    { 0x007f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/0/m = #256 */
    { 0x0000, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/0/u = #257 */
    { 0x017f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/1/m = #258 */
    { 0x0100, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/1/u = #259 */
    { 0x027f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/2/m = #260 */
    { 0x0200, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/2/u = #261 */
    { 0x037f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/3/m = #262 */
    { 0x0300, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/0/3/u = #263 */
    { 0x047f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/0/m = #264 */
    { 0x0400, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/0/u = #265 */
    { 0x057f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/1/m = #266 */
    { 0x0500, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/1/u = #267 */
    { 0x067f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/2/m = #268 */
    { 0x0600, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/2/u = #269 */
    { 0x077f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/3/m = #270 */
    { 0x0700, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/1/3/u = #271 */
    { 0x087f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/0/m = #272 */
    { 0x0800, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/0/u = #273 */
    { 0x097f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/1/m = #274 */
    { 0x0900, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/1/u = #275 */
    { 0x0a7f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/2/m = #276 */
    { 0x0a00, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/2/u = #277 */
    { 0x0b7f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/3/m = #278 */
    { 0x0b00, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/2/3/u = #279 */
    { 0x0c7f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/0/m = #280 */
    { 0x0c00, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/0/u = #281 */
    { 0x0d7f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/1/m = #282 */
    { 0x0d00, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/1/u = #283 */
    { 0x0e7f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/2/m = #284 */
    { 0x0e00, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/2/u = #285 */
    { 0x0f7f, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/3/m = #286 */
    { 0x0f00, 0x1ab5, 0x3800, RTFLOAT80U_INIT_C(1,0xe4e69c3cd0acaaa1,32767), RTFLOAT80U_INIT_C(0,0xe4e69c3cd0acaaa1,32767) }, /* #8/3/3/u = #287 */
    { 0x007f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/0/m = #288 */
    { 0x0000, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/0/u = #289 */
    { 0x017f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/1/m = #290 */
    { 0x0100, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/1/u = #291 */
    { 0x027f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/2/m = #292 */
    { 0x0200, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/2/u = #293 */
    { 0x037f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/3/m = #294 */
    { 0x0300, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/0/3/u = #295 */
    { 0x047f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/0/m = #296 */
    { 0x0400, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/0/u = #297 */
    { 0x057f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/1/m = #298 */
    { 0x0500, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/1/u = #299 */
    { 0x067f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/2/m = #300 */
    { 0x0600, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/2/u = #301 */
    { 0x077f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/3/m = #302 */
    { 0x0700, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/1/3/u = #303 */
    { 0x087f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/0/m = #304 */
    { 0x0800, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/0/u = #305 */
    { 0x097f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/1/m = #306 */
    { 0x0900, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/1/u = #307 */
    { 0x0a7f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/2/m = #308 */
    { 0x0a00, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/2/u = #309 */
    { 0x0b7f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/3/m = #310 */
    { 0x0b00, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/2/3/u = #311 */
    { 0x0c7f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/0/m = #312 */
    { 0x0c00, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/0/u = #313 */
    { 0x0d7f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/1/m = #314 */
    { 0x0d00, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/1/u = #315 */
    { 0x0e7f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/2/m = #316 */
    { 0x0e00, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/2/u = #317 */
    { 0x0f7f, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/3/m = #318 */
    { 0x0f00, 0x1e70, 0x3c00, RTFLOAT80U_INIT_C(1,0x1e,32767), RTFLOAT80U_INIT_C(0,0x1e,32767) }, /* #9/3/3/u = #319 */
    { 0x007f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/0/m = #320 */
    { 0x0000, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/0/u = #321 */
    { 0x017f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/1/m = #322 */
    { 0x0100, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/1/u = #323 */
    { 0x027f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/2/m = #324 */
    { 0x0200, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/2/u = #325 */
    { 0x037f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/3/m = #326 */
    { 0x0300, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/0/3/u = #327 */
    { 0x047f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/0/m = #328 */
    { 0x0400, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/0/u = #329 */
    { 0x057f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/1/m = #330 */
    { 0x0500, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/1/u = #331 */
    { 0x067f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/2/m = #332 */
    { 0x0600, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/2/u = #333 */
    { 0x077f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/3/m = #334 */
    { 0x0700, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/1/3/u = #335 */
    { 0x087f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/0/m = #336 */
    { 0x0800, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/0/u = #337 */
    { 0x097f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/1/m = #338 */
    { 0x0900, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/1/u = #339 */
    { 0x0a7f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/2/m = #340 */
    { 0x0a00, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/2/u = #341 */
    { 0x0b7f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/3/m = #342 */
    { 0x0b00, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/2/3/u = #343 */
    { 0x0c7f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/0/m = #344 */
    { 0x0c00, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/0/u = #345 */
    { 0x0d7f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/1/m = #346 */
    { 0x0d00, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/1/u = #347 */
    { 0x0e7f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/2/m = #348 */
    { 0x0e00, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/2/u = #349 */
    { 0x0f7f, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/3/m = #350 */
    { 0x0f00, 0x9af2, 0x3800, RTFLOAT80U_INIT_C(0,0x262c6836e90dabf,32767), RTFLOAT80U_INIT_C(1,0x262c6836e90dabf,32767) }, /* #10/3/3/u = #351 */
    { 0x007f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/0/m = #352 */
    { 0x0000, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/0/u = #353 */
    { 0x017f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/1/m = #354 */
    { 0x0100, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/1/u = #355 */
    { 0x027f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/2/m = #356 */
    { 0x0200, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/2/u = #357 */
    { 0x037f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/3/m = #358 */
    { 0x0300, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/0/3/u = #359 */
    { 0x047f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/0/m = #360 */
    { 0x0400, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/0/u = #361 */
    { 0x057f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/1/m = #362 */
    { 0x0500, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/1/u = #363 */
    { 0x067f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/2/m = #364 */
    { 0x0600, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/2/u = #365 */
    { 0x077f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/3/m = #366 */
    { 0x0700, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/1/3/u = #367 */
    { 0x087f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/0/m = #368 */
    { 0x0800, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/0/u = #369 */
    { 0x097f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/1/m = #370 */
    { 0x0900, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/1/u = #371 */
    { 0x0a7f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/2/m = #372 */
    { 0x0a00, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/2/u = #373 */
    { 0x0b7f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/3/m = #374 */
    { 0x0b00, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/2/3/u = #375 */
    { 0x0c7f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/0/m = #376 */
    { 0x0c00, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/0/u = #377 */
    { 0x0d7f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/1/m = #378 */
    { 0x0d00, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/1/u = #379 */
    { 0x0e7f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/2/m = #380 */
    { 0x0e00, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/2/u = #381 */
    { 0x0f7f, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/3/m = #382 */
    { 0x0f00, 0x9482, 0x3c00, RTFLOAT80U_INIT_C(0,0x800000000001c157,0), RTFLOAT80U_INIT_C(1,0x800000000001c157,0) }, /* #11/3/3/u = #383 */
    { 0x007f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/0/m = #384 */
    { 0x0000, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/0/u = #385 */
    { 0x017f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/1/m = #386 */
    { 0x0100, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/1/u = #387 */
    { 0x027f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/2/m = #388 */
    { 0x0200, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/2/u = #389 */
    { 0x037f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/3/m = #390 */
    { 0x0300, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/0/3/u = #391 */
    { 0x047f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/0/m = #392 */
    { 0x0400, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/0/u = #393 */
    { 0x057f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/1/m = #394 */
    { 0x0500, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/1/u = #395 */
    { 0x067f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/2/m = #396 */
    { 0x0600, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/2/u = #397 */
    { 0x077f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/3/m = #398 */
    { 0x0700, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/1/3/u = #399 */
    { 0x087f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/0/m = #400 */
    { 0x0800, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/0/u = #401 */
    { 0x097f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/1/m = #402 */
    { 0x0900, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/1/u = #403 */
    { 0x0a7f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/2/m = #404 */
    { 0x0a00, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/2/u = #405 */
    { 0x0b7f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/3/m = #406 */
    { 0x0b00, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/2/3/u = #407 */
    { 0x0c7f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/0/m = #408 */
    { 0x0c00, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/0/u = #409 */
    { 0x0d7f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/1/m = #410 */
    { 0x0d00, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/1/u = #411 */
    { 0x0e7f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/2/m = #412 */
    { 0x0e00, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/2/u = #413 */
    { 0x0f7f, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/3/m = #414 */
    { 0x0f00, 0x1d5c, 0x3d00, RTFLOAT80U_INIT_C(0,0xe040010ee86e6748,0), RTFLOAT80U_INIT_C(1,0xe040010ee86e6748,0) }, /* #12/3/3/u = #415 */
    { 0x007f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/0/m = #416 */
    { 0x0000, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/0/u = #417 */
    { 0x017f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/1/m = #418 */
    { 0x0100, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/1/u = #419 */
    { 0x027f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/2/m = #420 */
    { 0x0200, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/2/u = #421 */
    { 0x037f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/3/m = #422 */
    { 0x0300, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/0/3/u = #423 */
    { 0x047f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/0/m = #424 */
    { 0x0400, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/0/u = #425 */
    { 0x057f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/1/m = #426 */
    { 0x0500, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/1/u = #427 */
    { 0x067f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/2/m = #428 */
    { 0x0600, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/2/u = #429 */
    { 0x077f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/3/m = #430 */
    { 0x0700, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/1/3/u = #431 */
    { 0x087f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/0/m = #432 */
    { 0x0800, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/0/u = #433 */
    { 0x097f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/1/m = #434 */
    { 0x0900, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/1/u = #435 */
    { 0x0a7f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/2/m = #436 */
    { 0x0a00, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/2/u = #437 */
    { 0x0b7f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/3/m = #438 */
    { 0x0b00, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/2/3/u = #439 */
    { 0x0c7f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/0/m = #440 */
    { 0x0c00, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/0/u = #441 */
    { 0x0d7f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/1/m = #442 */
    { 0x0d00, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/1/u = #443 */
    { 0x0e7f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/2/m = #444 */
    { 0x0e00, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/2/u = #445 */
    { 0x0f7f, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/3/m = #446 */
    { 0x0f00, 0x1ee1, 0x3c00, RTFLOAT80U_INIT_C(1,0x4bc7ce78ef13,0), RTFLOAT80U_INIT_C(0,0x4bc7ce78ef13,0) }, /* #13/3/3/u = #447 */
    { 0x007f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/0/m = #448 */
    { 0x0000, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/0/u = #449 */
    { 0x017f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/1/m = #450 */
    { 0x0100, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/1/u = #451 */
    { 0x027f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/2/m = #452 */
    { 0x0200, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/2/u = #453 */
    { 0x037f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/3/m = #454 */
    { 0x0300, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/0/3/u = #455 */
    { 0x047f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/0/m = #456 */
    { 0x0400, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/0/u = #457 */
    { 0x057f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/1/m = #458 */
    { 0x0500, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/1/u = #459 */
    { 0x067f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/2/m = #460 */
    { 0x0600, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/2/u = #461 */
    { 0x077f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/3/m = #462 */
    { 0x0700, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/1/3/u = #463 */
    { 0x087f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/0/m = #464 */
    { 0x0800, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/0/u = #465 */
    { 0x097f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/1/m = #466 */
    { 0x0900, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/1/u = #467 */
    { 0x0a7f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/2/m = #468 */
    { 0x0a00, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/2/u = #469 */
    { 0x0b7f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/3/m = #470 */
    { 0x0b00, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/2/3/u = #471 */
    { 0x0c7f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/0/m = #472 */
    { 0x0c00, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/0/u = #473 */
    { 0x0d7f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/1/m = #474 */
    { 0x0d00, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/1/u = #475 */
    { 0x0e7f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/2/m = #476 */
    { 0x0e00, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/2/u = #477 */
    { 0x0f7f, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/3/m = #478 */
    { 0x0f00, 0x3b4b, 0x3900, RTFLOAT80U_INIT_C(0,0x37e9abd602ad987a,0), RTFLOAT80U_INIT_C(1,0x37e9abd602ad987a,0) }, /* #14/3/3/u = #479 */
    { 0x007f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/0/m = #480 */
    { 0x0000, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/0/u = #481 */
    { 0x017f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/1/m = #482 */
    { 0x0100, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/1/u = #483 */
    { 0x027f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/2/m = #484 */
    { 0x0200, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/2/u = #485 */
    { 0x037f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/3/m = #486 */
    { 0x0300, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/0/3/u = #487 */
    { 0x047f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/0/m = #488 */
    { 0x0400, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/0/u = #489 */
    { 0x057f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/1/m = #490 */
    { 0x0500, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/1/u = #491 */
    { 0x067f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/2/m = #492 */
    { 0x0600, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/2/u = #493 */
    { 0x077f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/3/m = #494 */
    { 0x0700, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/1/3/u = #495 */
    { 0x087f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/0/m = #496 */
    { 0x0800, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/0/u = #497 */
    { 0x097f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/1/m = #498 */
    { 0x0900, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/1/u = #499 */
    { 0x0a7f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/2/m = #500 */
    { 0x0a00, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/2/u = #501 */
    { 0x0b7f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/3/m = #502 */
    { 0x0b00, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/2/3/u = #503 */
    { 0x0c7f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/0/m = #504 */
    { 0x0c00, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/0/u = #505 */
    { 0x0d7f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/1/m = #506 */
    { 0x0d00, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/1/u = #507 */
    { 0x0e7f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/2/m = #508 */
    { 0x0e00, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/2/u = #509 */
    { 0x0f7f, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/3/m = #510 */
    { 0x0f00, 0x17f6, 0x3d00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #15/3/3/u = #511 */
    { 0x007f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/0/m = #512 */
    { 0x0000, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/0/u = #513 */
    { 0x017f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/1/m = #514 */
    { 0x0100, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/1/u = #515 */
    { 0x027f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/2/m = #516 */
    { 0x0200, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/2/u = #517 */
    { 0x037f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/3/m = #518 */
    { 0x0300, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/0/3/u = #519 */
    { 0x047f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/0/m = #520 */
    { 0x0400, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/0/u = #521 */
    { 0x057f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/1/m = #522 */
    { 0x0500, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/1/u = #523 */
    { 0x067f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/2/m = #524 */
    { 0x0600, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/2/u = #525 */
    { 0x077f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/3/m = #526 */
    { 0x0700, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/1/3/u = #527 */
    { 0x087f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/0/m = #528 */
    { 0x0800, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/0/u = #529 */
    { 0x097f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/1/m = #530 */
    { 0x0900, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/1/u = #531 */
    { 0x0a7f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/2/m = #532 */
    { 0x0a00, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/2/u = #533 */
    { 0x0b7f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/3/m = #534 */
    { 0x0b00, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/2/3/u = #535 */
    { 0x0c7f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/0/m = #536 */
    { 0x0c00, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/0/u = #537 */
    { 0x0d7f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/1/m = #538 */
    { 0x0d00, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/1/u = #539 */
    { 0x0e7f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/2/m = #540 */
    { 0x0e00, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/2/u = #541 */
    { 0x0f7f, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/3/m = #542 */
    { 0x0f00, 0x5305, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #16/3/3/u = #543 */
    { 0x007f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/0/m = #544 */
    { 0x0000, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/0/u = #545 */
    { 0x017f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/1/m = #546 */
    { 0x0100, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/1/u = #547 */
    { 0x027f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/2/m = #548 */
    { 0x0200, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/2/u = #549 */
    { 0x037f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/3/m = #550 */
    { 0x0300, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/0/3/u = #551 */
    { 0x047f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/0/m = #552 */
    { 0x0400, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/0/u = #553 */
    { 0x057f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/1/m = #554 */
    { 0x0500, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/1/u = #555 */
    { 0x067f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/2/m = #556 */
    { 0x0600, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/2/u = #557 */
    { 0x077f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/3/m = #558 */
    { 0x0700, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/1/3/u = #559 */
    { 0x087f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/0/m = #560 */
    { 0x0800, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/0/u = #561 */
    { 0x097f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/1/m = #562 */
    { 0x0900, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/1/u = #563 */
    { 0x0a7f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/2/m = #564 */
    { 0x0a00, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/2/u = #565 */
    { 0x0b7f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/3/m = #566 */
    { 0x0b00, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/2/3/u = #567 */
    { 0x0c7f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/0/m = #568 */
    { 0x0c00, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/0/u = #569 */
    { 0x0d7f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/1/m = #570 */
    { 0x0d00, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/1/u = #571 */
    { 0x0e7f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/2/m = #572 */
    { 0x0e00, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/2/u = #573 */
    { 0x0f7f, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/3/m = #574 */
    { 0x0f00, 0xa7e5, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #17/3/3/u = #575 */
    { 0x007f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/0/m = #576 */
    { 0x0000, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/0/u = #577 */
    { 0x017f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/1/m = #578 */
    { 0x0100, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/1/u = #579 */
    { 0x027f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/2/m = #580 */
    { 0x0200, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/2/u = #581 */
    { 0x037f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/3/m = #582 */
    { 0x0300, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/3/u = #583 */
    { 0x047f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/0/m = #584 */
    { 0x0400, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/0/u = #585 */
    { 0x057f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/1/m = #586 */
    { 0x0500, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/1/u = #587 */
    { 0x067f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/2/m = #588 */
    { 0x0600, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/2/u = #589 */
    { 0x077f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/3/m = #590 */
    { 0x0700, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/3/u = #591 */
    { 0x087f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/0/m = #592 */
    { 0x0800, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/0/u = #593 */
    { 0x097f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/1/m = #594 */
    { 0x0900, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/1/u = #595 */
    { 0x0a7f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/2/m = #596 */
    { 0x0a00, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/2/u = #597 */
    { 0x0b7f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/3/m = #598 */
    { 0x0b00, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/3/u = #599 */
    { 0x0c7f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/0/m = #600 */
    { 0x0c00, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/0/u = #601 */
    { 0x0d7f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/1/m = #602 */
    { 0x0d00, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/1/u = #603 */
    { 0x0e7f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/2/m = #604 */
    { 0x0e00, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/2/u = #605 */
    { 0x0f7f, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/3/m = #606 */
    { 0x0f00, 0x703c, 0x7800, RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/3/u = #607 */
    { 0x007f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/0/m = #608 */
    { 0x0000, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/0/u = #609 */
    { 0x017f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/1/m = #610 */
    { 0x0100, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/1/u = #611 */
    { 0x027f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/2/m = #612 */
    { 0x0200, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/2/u = #613 */
    { 0x037f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/3/m = #614 */
    { 0x0300, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/0/3/u = #615 */
    { 0x047f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/0/m = #616 */
    { 0x0400, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/0/u = #617 */
    { 0x057f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/1/m = #618 */
    { 0x0500, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/1/u = #619 */
    { 0x067f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/2/m = #620 */
    { 0x0600, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/2/u = #621 */
    { 0x077f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/3/m = #622 */
    { 0x0700, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/1/3/u = #623 */
    { 0x087f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/0/m = #624 */
    { 0x0800, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/0/u = #625 */
    { 0x097f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/1/m = #626 */
    { 0x0900, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/1/u = #627 */
    { 0x0a7f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/2/m = #628 */
    { 0x0a00, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/2/u = #629 */
    { 0x0b7f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/3/m = #630 */
    { 0x0b00, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/2/3/u = #631 */
    { 0x0c7f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/0/m = #632 */
    { 0x0c00, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/0/u = #633 */
    { 0x0d7f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/1/m = #634 */
    { 0x0d00, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/1/u = #635 */
    { 0x0e7f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/2/m = #636 */
    { 0x0e00, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/2/u = #637 */
    { 0x0f7f, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/3/m = #638 */
    { 0x0f00, 0xcd4e, 0x7d00, RTFLOAT80U_INIT_C(1,0x50f24fd0583d3961,0), RTFLOAT80U_INIT_C(0,0x50f24fd0583d3961,0) }, /* #19/3/3/u = #639 */
    { 0x007f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/0/m = #640 */
    { 0x0000, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/0/u = #641 */
    { 0x017f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/1/m = #642 */
    { 0x0100, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/1/u = #643 */
    { 0x027f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/2/m = #644 */
    { 0x0200, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/2/u = #645 */
    { 0x037f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/3/m = #646 */
    { 0x0300, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/0/3/u = #647 */
    { 0x047f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/0/m = #648 */
    { 0x0400, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/0/u = #649 */
    { 0x057f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/1/m = #650 */
    { 0x0500, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/1/u = #651 */
    { 0x067f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/2/m = #652 */
    { 0x0600, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/2/u = #653 */
    { 0x077f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/3/m = #654 */
    { 0x0700, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/1/3/u = #655 */
    { 0x087f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/0/m = #656 */
    { 0x0800, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/0/u = #657 */
    { 0x097f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/1/m = #658 */
    { 0x0900, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/1/u = #659 */
    { 0x0a7f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/2/m = #660 */
    { 0x0a00, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/2/u = #661 */
    { 0x0b7f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/3/m = #662 */
    { 0x0b00, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/2/3/u = #663 */
    { 0x0c7f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/0/m = #664 */
    { 0x0c00, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/0/u = #665 */
    { 0x0d7f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/1/m = #666 */
    { 0x0d00, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/1/u = #667 */
    { 0x0e7f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/2/m = #668 */
    { 0x0e00, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/2/u = #669 */
    { 0x0f7f, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/3/m = #670 */
    { 0x0f00, 0x1be3, 0x3900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #20/3/3/u = #671 */
    { 0x007f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/0/m = #672 */
    { 0x0000, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/0/u = #673 */
    { 0x017f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/1/m = #674 */
    { 0x0100, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/1/u = #675 */
    { 0x027f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/2/m = #676 */
    { 0x0200, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/2/u = #677 */
    { 0x037f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/3/m = #678 */
    { 0x0300, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/0/3/u = #679 */
    { 0x047f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/0/m = #680 */
    { 0x0400, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/0/u = #681 */
    { 0x057f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/1/m = #682 */
    { 0x0500, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/1/u = #683 */
    { 0x067f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/2/m = #684 */
    { 0x0600, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/2/u = #685 */
    { 0x077f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/3/m = #686 */
    { 0x0700, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/1/3/u = #687 */
    { 0x087f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/0/m = #688 */
    { 0x0800, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/0/u = #689 */
    { 0x097f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/1/m = #690 */
    { 0x0900, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/1/u = #691 */
    { 0x0a7f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/2/m = #692 */
    { 0x0a00, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/2/u = #693 */
    { 0x0b7f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/3/m = #694 */
    { 0x0b00, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/2/3/u = #695 */
    { 0x0c7f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/0/m = #696 */
    { 0x0c00, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/0/u = #697 */
    { 0x0d7f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/1/m = #698 */
    { 0x0d00, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/1/u = #699 */
    { 0x0e7f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/2/m = #700 */
    { 0x0e00, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/2/u = #701 */
    { 0x0f7f, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/3/m = #702 */
    { 0x0f00, 0x2e64, 0x3c00, RTFLOAT80U_INIT_C(0,0xc005f1fad0d59d83,32767), RTFLOAT80U_INIT_C(1,0xc005f1fad0d59d83,32767) }, /* #21/3/3/u = #703 */
    { 0x007f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/0/m = #704 */
    { 0x0000, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/0/u = #705 */
    { 0x017f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/1/m = #706 */
    { 0x0100, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/1/u = #707 */
    { 0x027f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/2/m = #708 */
    { 0x0200, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/2/u = #709 */
    { 0x037f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/3/m = #710 */
    { 0x0300, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/0/3/u = #711 */
    { 0x047f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/0/m = #712 */
    { 0x0400, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/0/u = #713 */
    { 0x057f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/1/m = #714 */
    { 0x0500, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/1/u = #715 */
    { 0x067f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/2/m = #716 */
    { 0x0600, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/2/u = #717 */
    { 0x077f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/3/m = #718 */
    { 0x0700, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/1/3/u = #719 */
    { 0x087f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/0/m = #720 */
    { 0x0800, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/0/u = #721 */
    { 0x097f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/1/m = #722 */
    { 0x0900, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/1/u = #723 */
    { 0x0a7f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/2/m = #724 */
    { 0x0a00, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/2/u = #725 */
    { 0x0b7f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/3/m = #726 */
    { 0x0b00, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/2/3/u = #727 */
    { 0x0c7f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/0/m = #728 */
    { 0x0c00, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/0/u = #729 */
    { 0x0d7f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/1/m = #730 */
    { 0x0d00, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/1/u = #731 */
    { 0x0e7f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/2/m = #732 */
    { 0x0e00, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/2/u = #733 */
    { 0x0f7f, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/3/m = #734 */
    { 0x0f00, 0x7a44, 0x7800, RTFLOAT80U_INIT_C(1,0xb257adba9959500d,1823), RTFLOAT80U_INIT_C(0,0xb257adba9959500d,1823) }, /* #22/3/3/u = #735 */
    { 0x007f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/0/m = #736 */
    { 0x0000, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/0/u = #737 */
    { 0x017f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/1/m = #738 */
    { 0x0100, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/1/u = #739 */
    { 0x027f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/2/m = #740 */
    { 0x0200, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/2/u = #741 */
    { 0x037f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/3/m = #742 */
    { 0x0300, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/0/3/u = #743 */
    { 0x047f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/0/m = #744 */
    { 0x0400, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/0/u = #745 */
    { 0x057f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/1/m = #746 */
    { 0x0500, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/1/u = #747 */
    { 0x067f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/2/m = #748 */
    { 0x0600, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/2/u = #749 */
    { 0x077f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/3/m = #750 */
    { 0x0700, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/1/3/u = #751 */
    { 0x087f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/0/m = #752 */
    { 0x0800, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/0/u = #753 */
    { 0x097f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/1/m = #754 */
    { 0x0900, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/1/u = #755 */
    { 0x0a7f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/2/m = #756 */
    { 0x0a00, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/2/u = #757 */
    { 0x0b7f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/3/m = #758 */
    { 0x0b00, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/2/3/u = #759 */
    { 0x0c7f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/0/m = #760 */
    { 0x0c00, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/0/u = #761 */
    { 0x0d7f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/1/m = #762 */
    { 0x0d00, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/1/u = #763 */
    { 0x0e7f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/2/m = #764 */
    { 0x0e00, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/2/u = #765 */
    { 0x0f7f, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/3/m = #766 */
    { 0x0f00, 0x2767, 0x3d00, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #23/3/3/u = #767 */
    { 0x007f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/0/m = #768 */
    { 0x0000, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/0/u = #769 */
    { 0x017f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/1/m = #770 */
    { 0x0100, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/1/u = #771 */
    { 0x027f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/2/m = #772 */
    { 0x0200, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/2/u = #773 */
    { 0x037f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/3/m = #774 */
    { 0x0300, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/0/3/u = #775 */
    { 0x047f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/0/m = #776 */
    { 0x0400, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/0/u = #777 */
    { 0x057f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/1/m = #778 */
    { 0x0500, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/1/u = #779 */
    { 0x067f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/2/m = #780 */
    { 0x0600, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/2/u = #781 */
    { 0x077f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/3/m = #782 */
    { 0x0700, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/1/3/u = #783 */
    { 0x087f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/0/m = #784 */
    { 0x0800, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/0/u = #785 */
    { 0x097f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/1/m = #786 */
    { 0x0900, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/1/u = #787 */
    { 0x0a7f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/2/m = #788 */
    { 0x0a00, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/2/u = #789 */
    { 0x0b7f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/3/m = #790 */
    { 0x0b00, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/2/3/u = #791 */
    { 0x0c7f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/0/m = #792 */
    { 0x0c00, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/0/u = #793 */
    { 0x0d7f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/1/m = #794 */
    { 0x0d00, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/1/u = #795 */
    { 0x0e7f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/2/m = #796 */
    { 0x0e00, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/2/u = #797 */
    { 0x0f7f, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/3/m = #798 */
    { 0x0f00, 0xb239, 0x3800, RTFLOAT80U_INIT_C(0,0x97157f9e71c47f9b,710), RTFLOAT80U_INIT_C(1,0x97157f9e71c47f9b,710) }, /* #24/3/3/u = #799 */
    { 0x007f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/0/m = #800 */
    { 0x0000, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/0/u = #801 */
    { 0x017f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/1/m = #802 */
    { 0x0100, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/1/u = #803 */
    { 0x027f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/2/m = #804 */
    { 0x0200, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/2/u = #805 */
    { 0x037f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/3/m = #806 */
    { 0x0300, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/0/3/u = #807 */
    { 0x047f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/0/m = #808 */
    { 0x0400, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/0/u = #809 */
    { 0x057f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/1/m = #810 */
    { 0x0500, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/1/u = #811 */
    { 0x067f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/2/m = #812 */
    { 0x0600, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/2/u = #813 */
    { 0x077f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/3/m = #814 */
    { 0x0700, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/1/3/u = #815 */
    { 0x087f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/0/m = #816 */
    { 0x0800, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/0/u = #817 */
    { 0x097f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/1/m = #818 */
    { 0x0900, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/1/u = #819 */
    { 0x0a7f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/2/m = #820 */
    { 0x0a00, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/2/u = #821 */
    { 0x0b7f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/3/m = #822 */
    { 0x0b00, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/2/3/u = #823 */
    { 0x0c7f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/0/m = #824 */
    { 0x0c00, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/0/u = #825 */
    { 0x0d7f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/1/m = #826 */
    { 0x0d00, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/1/u = #827 */
    { 0x0e7f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/2/m = #828 */
    { 0x0e00, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/2/u = #829 */
    { 0x0f7f, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/3/m = #830 */
    { 0x0f00, 0xee23, 0x7c00, RTFLOAT80U_INIT_C(0,0x934339362ddc8894,14140), RTFLOAT80U_INIT_C(1,0x934339362ddc8894,14140) }, /* #25/3/3/u = #831 */
    { 0x007f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/0/m = #832 */
    { 0x0000, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/0/u = #833 */
    { 0x017f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/1/m = #834 */
    { 0x0100, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/1/u = #835 */
    { 0x027f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/2/m = #836 */
    { 0x0200, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/2/u = #837 */
    { 0x037f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/3/m = #838 */
    { 0x0300, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/0/3/u = #839 */
    { 0x047f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/0/m = #840 */
    { 0x0400, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/0/u = #841 */
    { 0x057f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/1/m = #842 */
    { 0x0500, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/1/u = #843 */
    { 0x067f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/2/m = #844 */
    { 0x0600, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/2/u = #845 */
    { 0x077f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/3/m = #846 */
    { 0x0700, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/1/3/u = #847 */
    { 0x087f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/0/m = #848 */
    { 0x0800, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/0/u = #849 */
    { 0x097f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/1/m = #850 */
    { 0x0900, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/1/u = #851 */
    { 0x0a7f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/2/m = #852 */
    { 0x0a00, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/2/u = #853 */
    { 0x0b7f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/3/m = #854 */
    { 0x0b00, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/2/3/u = #855 */
    { 0x0c7f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/0/m = #856 */
    { 0x0c00, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/0/u = #857 */
    { 0x0d7f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/1/m = #858 */
    { 0x0d00, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/1/u = #859 */
    { 0x0e7f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/2/m = #860 */
    { 0x0e00, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/2/u = #861 */
    { 0x0f7f, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/3/m = #862 */
    { 0x0f00, 0x91b0, 0x3900, RTFLOAT80U_INIT_C(0,0xafe921a02161be6a,1367), RTFLOAT80U_INIT_C(1,0xafe921a02161be6a,1367) }, /* #26/3/3/u = #863 */
    { 0x007f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/0/m = #864 */
    { 0x0000, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/0/u = #865 */
    { 0x017f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/1/m = #866 */
    { 0x0100, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/1/u = #867 */
    { 0x027f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/2/m = #868 */
    { 0x0200, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/2/u = #869 */
    { 0x037f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/3/m = #870 */
    { 0x0300, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/0/3/u = #871 */
    { 0x047f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/0/m = #872 */
    { 0x0400, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/0/u = #873 */
    { 0x057f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/1/m = #874 */
    { 0x0500, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/1/u = #875 */
    { 0x067f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/2/m = #876 */
    { 0x0600, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/2/u = #877 */
    { 0x077f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/3/m = #878 */
    { 0x0700, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/1/3/u = #879 */
    { 0x087f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/0/m = #880 */
    { 0x0800, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/0/u = #881 */
    { 0x097f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/1/m = #882 */
    { 0x0900, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/1/u = #883 */
    { 0x0a7f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/2/m = #884 */
    { 0x0a00, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/2/u = #885 */
    { 0x0b7f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/3/m = #886 */
    { 0x0b00, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/2/3/u = #887 */
    { 0x0c7f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/0/m = #888 */
    { 0x0c00, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/0/u = #889 */
    { 0x0d7f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/1/m = #890 */
    { 0x0d00, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/1/u = #891 */
    { 0x0e7f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/2/m = #892 */
    { 0x0e00, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/2/u = #893 */
    { 0x0f7f, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/3/m = #894 */
    { 0x0f00, 0x3b2e, 0x3900, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #27/3/3/u = #895 */
    { 0x007f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/0/m = #896 */
    { 0x0000, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/0/u = #897 */
    { 0x017f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/1/m = #898 */
    { 0x0100, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/1/u = #899 */
    { 0x027f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/2/m = #900 */
    { 0x0200, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/2/u = #901 */
    { 0x037f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/3/m = #902 */
    { 0x0300, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/0/3/u = #903 */
    { 0x047f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/0/m = #904 */
    { 0x0400, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/0/u = #905 */
    { 0x057f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/1/m = #906 */
    { 0x0500, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/1/u = #907 */
    { 0x067f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/2/m = #908 */
    { 0x0600, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/2/u = #909 */
    { 0x077f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/3/m = #910 */
    { 0x0700, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/1/3/u = #911 */
    { 0x087f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/0/m = #912 */
    { 0x0800, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/0/u = #913 */
    { 0x097f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/1/m = #914 */
    { 0x0900, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/1/u = #915 */
    { 0x0a7f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/2/m = #916 */
    { 0x0a00, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/2/u = #917 */
    { 0x0b7f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/3/m = #918 */
    { 0x0b00, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/2/3/u = #919 */
    { 0x0c7f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/0/m = #920 */
    { 0x0c00, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/0/u = #921 */
    { 0x0d7f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/1/m = #922 */
    { 0x0d00, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/1/u = #923 */
    { 0x0e7f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/2/m = #924 */
    { 0x0e00, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/2/u = #925 */
    { 0x0f7f, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/3/m = #926 */
    { 0x0f00, 0x6dd8, 0x7d00, RTFLOAT80U_INIT_C(1,0x400013ddd6d2a257,32767), RTFLOAT80U_INIT_C(0,0x400013ddd6d2a257,32767) }, /* #28/3/3/u = #927 */
    { 0x007f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/0/m = #928 */
    { 0x0000, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/0/u = #929 */
    { 0x017f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/1/m = #930 */
    { 0x0100, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/1/u = #931 */
    { 0x027f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/2/m = #932 */
    { 0x0200, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/2/u = #933 */
    { 0x037f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/3/m = #934 */
    { 0x0300, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/0/3/u = #935 */
    { 0x047f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/0/m = #936 */
    { 0x0400, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/0/u = #937 */
    { 0x057f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/1/m = #938 */
    { 0x0500, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/1/u = #939 */
    { 0x067f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/2/m = #940 */
    { 0x0600, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/2/u = #941 */
    { 0x077f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/3/m = #942 */
    { 0x0700, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/1/3/u = #943 */
    { 0x087f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/0/m = #944 */
    { 0x0800, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/0/u = #945 */
    { 0x097f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/1/m = #946 */
    { 0x0900, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/1/u = #947 */
    { 0x0a7f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/2/m = #948 */
    { 0x0a00, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/2/u = #949 */
    { 0x0b7f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/3/m = #950 */
    { 0x0b00, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/2/3/u = #951 */
    { 0x0c7f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/0/m = #952 */
    { 0x0c00, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/0/u = #953 */
    { 0x0d7f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/1/m = #954 */
    { 0x0d00, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/1/u = #955 */
    { 0x0e7f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/2/m = #956 */
    { 0x0e00, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/2/u = #957 */
    { 0x0f7f, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/3/m = #958 */
    { 0x0f00, 0x4414, 0x7c00, RTFLOAT80U_INIT_C(1,0xffd5ceabb875faf3,0), RTFLOAT80U_INIT_C(0,0xffd5ceabb875faf3,0) }, /* #29/3/3/u = #959 */
    { 0x007f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/0/m = #960 */
    { 0x0000, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/0/u = #961 */
    { 0x017f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/1/m = #962 */
    { 0x0100, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/1/u = #963 */
    { 0x027f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/2/m = #964 */
    { 0x0200, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/2/u = #965 */
    { 0x037f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/3/m = #966 */
    { 0x0300, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/0/3/u = #967 */
    { 0x047f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/0/m = #968 */
    { 0x0400, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/0/u = #969 */
    { 0x057f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/1/m = #970 */
    { 0x0500, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/1/u = #971 */
    { 0x067f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/2/m = #972 */
    { 0x0600, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/2/u = #973 */
    { 0x077f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/3/m = #974 */
    { 0x0700, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/1/3/u = #975 */
    { 0x087f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/0/m = #976 */
    { 0x0800, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/0/u = #977 */
    { 0x097f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/1/m = #978 */
    { 0x0900, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/1/u = #979 */
    { 0x0a7f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/2/m = #980 */
    { 0x0a00, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/2/u = #981 */
    { 0x0b7f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/3/m = #982 */
    { 0x0b00, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/2/3/u = #983 */
    { 0x0c7f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/0/m = #984 */
    { 0x0c00, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/0/u = #985 */
    { 0x0d7f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/1/m = #986 */
    { 0x0d00, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/1/u = #987 */
    { 0x0e7f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/2/m = #988 */
    { 0x0e00, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/2/u = #989 */
    { 0x0f7f, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/3/m = #990 */
    { 0x0f00, 0x4624, 0x7c00, RTFLOAT80U_INIT_C(1,0x9bbea4807070fa19,3882), RTFLOAT80U_INIT_C(0,0x9bbea4807070fa19,3882) }, /* #30/3/3/u = #991 */
    { 0x007f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/0/m = #992 */
    { 0x0000, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/0/u = #993 */
    { 0x017f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/1/m = #994 */
    { 0x0100, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/1/u = #995 */
    { 0x027f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/2/m = #996 */
    { 0x0200, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/2/u = #997 */
    { 0x037f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/3/m = #998 */
    { 0x0300, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/0/3/u = #999 */
    { 0x047f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/0/m = #1000 */
    { 0x0400, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/0/u = #1001 */
    { 0x057f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/1/m = #1002 */
    { 0x0500, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/1/u = #1003 */
    { 0x067f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/2/m = #1004 */
    { 0x0600, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/2/u = #1005 */
    { 0x077f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/3/m = #1006 */
    { 0x0700, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/1/3/u = #1007 */
    { 0x087f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/0/m = #1008 */
    { 0x0800, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/0/u = #1009 */
    { 0x097f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/1/m = #1010 */
    { 0x0900, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/1/u = #1011 */
    { 0x0a7f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/2/m = #1012 */
    { 0x0a00, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/2/u = #1013 */
    { 0x0b7f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/3/m = #1014 */
    { 0x0b00, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/2/3/u = #1015 */
    { 0x0c7f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/0/m = #1016 */
    { 0x0c00, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/0/u = #1017 */
    { 0x0d7f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/1/m = #1018 */
    { 0x0d00, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/1/u = #1019 */
    { 0x0e7f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/2/m = #1020 */
    { 0x0e00, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/2/u = #1021 */
    { 0x0f7f, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/3/m = #1022 */
    { 0x0f00, 0xff61, 0x7d00, RTFLOAT80U_INIT_C(0,0xeab5a53496f5547a,31994), RTFLOAT80U_INIT_C(1,0xeab5a53496f5547a,31994) }, /* #31/3/3/u = #1023 */
    { 0x007f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/0/m = #1024 */
    { 0x0000, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/0/u = #1025 */
    { 0x017f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/1/m = #1026 */
    { 0x0100, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/1/u = #1027 */
    { 0x027f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/2/m = #1028 */
    { 0x0200, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/2/u = #1029 */
    { 0x037f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/3/m = #1030 */
    { 0x0300, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/0/3/u = #1031 */
    { 0x047f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/0/m = #1032 */
    { 0x0400, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/0/u = #1033 */
    { 0x057f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/1/m = #1034 */
    { 0x0500, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/1/u = #1035 */
    { 0x067f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/2/m = #1036 */
    { 0x0600, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/2/u = #1037 */
    { 0x077f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/3/m = #1038 */
    { 0x0700, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/1/3/u = #1039 */
    { 0x087f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/0/m = #1040 */
    { 0x0800, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/0/u = #1041 */
    { 0x097f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/1/m = #1042 */
    { 0x0900, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/1/u = #1043 */
    { 0x0a7f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/2/m = #1044 */
    { 0x0a00, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/2/u = #1045 */
    { 0x0b7f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/3/m = #1046 */
    { 0x0b00, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/2/3/u = #1047 */
    { 0x0c7f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/0/m = #1048 */
    { 0x0c00, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/0/u = #1049 */
    { 0x0d7f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/1/m = #1050 */
    { 0x0d00, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/1/u = #1051 */
    { 0x0e7f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/2/m = #1052 */
    { 0x0e00, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/2/u = #1053 */
    { 0x0f7f, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/3/m = #1054 */
    { 0x0f00, 0xd926, 0x7900, RTFLOAT80U_INIT_C(0,0xfe079ac8bfcee7,18035), RTFLOAT80U_INIT_C(1,0xfe079ac8bfcee7,18035) }, /* #32/3/3/u = #1055 */
    { 0x007f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/0/m = #1056 */
    { 0x0000, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/0/u = #1057 */
    { 0x017f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/1/m = #1058 */
    { 0x0100, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/1/u = #1059 */
    { 0x027f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/2/m = #1060 */
    { 0x0200, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/2/u = #1061 */
    { 0x037f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/3/m = #1062 */
    { 0x0300, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/0/3/u = #1063 */
    { 0x047f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/0/m = #1064 */
    { 0x0400, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/0/u = #1065 */
    { 0x057f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/1/m = #1066 */
    { 0x0500, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/1/u = #1067 */
    { 0x067f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/2/m = #1068 */
    { 0x0600, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/2/u = #1069 */
    { 0x077f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/3/m = #1070 */
    { 0x0700, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/1/3/u = #1071 */
    { 0x087f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/0/m = #1072 */
    { 0x0800, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/0/u = #1073 */
    { 0x097f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/1/m = #1074 */
    { 0x0900, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/1/u = #1075 */
    { 0x0a7f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/2/m = #1076 */
    { 0x0a00, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/2/u = #1077 */
    { 0x0b7f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/3/m = #1078 */
    { 0x0b00, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/2/3/u = #1079 */
    { 0x0c7f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/0/m = #1080 */
    { 0x0c00, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/0/u = #1081 */
    { 0x0d7f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/1/m = #1082 */
    { 0x0d00, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/1/u = #1083 */
    { 0x0e7f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/2/m = #1084 */
    { 0x0e00, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/2/u = #1085 */
    { 0x0f7f, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/3/m = #1086 */
    { 0x0f00, 0x9825, 0x3800, RTFLOAT80U_INIT_C(1,0xe30127e4cd19989a,32767), RTFLOAT80U_INIT_C(0,0xe30127e4cd19989a,32767) }, /* #33/3/3/u = #1087 */
    { 0x007f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/0/m = #1088 */
    { 0x0000, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/0/u = #1089 */
    { 0x017f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/1/m = #1090 */
    { 0x0100, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/1/u = #1091 */
    { 0x027f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/2/m = #1092 */
    { 0x0200, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/2/u = #1093 */
    { 0x037f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/3/m = #1094 */
    { 0x0300, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/0/3/u = #1095 */
    { 0x047f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/0/m = #1096 */
    { 0x0400, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/0/u = #1097 */
    { 0x057f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/1/m = #1098 */
    { 0x0500, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/1/u = #1099 */
    { 0x067f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/2/m = #1100 */
    { 0x0600, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/2/u = #1101 */
    { 0x077f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/3/m = #1102 */
    { 0x0700, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/1/3/u = #1103 */
    { 0x087f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/0/m = #1104 */
    { 0x0800, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/0/u = #1105 */
    { 0x097f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/1/m = #1106 */
    { 0x0900, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/1/u = #1107 */
    { 0x0a7f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/2/m = #1108 */
    { 0x0a00, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/2/u = #1109 */
    { 0x0b7f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/3/m = #1110 */
    { 0x0b00, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/2/3/u = #1111 */
    { 0x0c7f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/0/m = #1112 */
    { 0x0c00, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/0/u = #1113 */
    { 0x0d7f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/1/m = #1114 */
    { 0x0d00, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/1/u = #1115 */
    { 0x0e7f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/2/m = #1116 */
    { 0x0e00, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/2/u = #1117 */
    { 0x0f7f, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/3/m = #1118 */
    { 0x0f00, 0x9d0e, 0x3d00, RTFLOAT80U_INIT_C(0,0xeb9493c3e68a64c0,27373), RTFLOAT80U_INIT_C(1,0xeb9493c3e68a64c0,27373) }, /* #34/3/3/u = #1119 */
    { 0x007f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/0/m = #1120 */
    { 0x0000, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/0/u = #1121 */
    { 0x017f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/1/m = #1122 */
    { 0x0100, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/1/u = #1123 */
    { 0x027f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/2/m = #1124 */
    { 0x0200, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/2/u = #1125 */
    { 0x037f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/3/m = #1126 */
    { 0x0300, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/0/3/u = #1127 */
    { 0x047f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/0/m = #1128 */
    { 0x0400, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/0/u = #1129 */
    { 0x057f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/1/m = #1130 */
    { 0x0500, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/1/u = #1131 */
    { 0x067f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/2/m = #1132 */
    { 0x0600, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/2/u = #1133 */
    { 0x077f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/3/m = #1134 */
    { 0x0700, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/1/3/u = #1135 */
    { 0x087f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/0/m = #1136 */
    { 0x0800, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/0/u = #1137 */
    { 0x097f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/1/m = #1138 */
    { 0x0900, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/1/u = #1139 */
    { 0x0a7f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/2/m = #1140 */
    { 0x0a00, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/2/u = #1141 */
    { 0x0b7f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/3/m = #1142 */
    { 0x0b00, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/2/3/u = #1143 */
    { 0x0c7f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/0/m = #1144 */
    { 0x0c00, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/0/u = #1145 */
    { 0x0d7f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/1/m = #1146 */
    { 0x0d00, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/1/u = #1147 */
    { 0x0e7f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/2/m = #1148 */
    { 0x0e00, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/2/u = #1149 */
    { 0x0f7f, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/3/m = #1150 */
    { 0x0f00, 0xc6a7, 0x7c00, RTFLOAT80U_INIT_C(1,0x549a5a2cd3adf6dd,1990), RTFLOAT80U_INIT_C(0,0x549a5a2cd3adf6dd,1990) }, /* #35/3/3/u = #1151 */
    { 0x007f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/0/m = #1152 */
    { 0x0000, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/0/u = #1153 */
    { 0x017f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/1/m = #1154 */
    { 0x0100, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/1/u = #1155 */
    { 0x027f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/2/m = #1156 */
    { 0x0200, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/2/u = #1157 */
    { 0x037f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/3/m = #1158 */
    { 0x0300, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/0/3/u = #1159 */
    { 0x047f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/0/m = #1160 */
    { 0x0400, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/0/u = #1161 */
    { 0x057f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/1/m = #1162 */
    { 0x0500, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/1/u = #1163 */
    { 0x067f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/2/m = #1164 */
    { 0x0600, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/2/u = #1165 */
    { 0x077f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/3/m = #1166 */
    { 0x0700, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/1/3/u = #1167 */
    { 0x087f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/0/m = #1168 */
    { 0x0800, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/0/u = #1169 */
    { 0x097f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/1/m = #1170 */
    { 0x0900, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/1/u = #1171 */
    { 0x0a7f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/2/m = #1172 */
    { 0x0a00, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/2/u = #1173 */
    { 0x0b7f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/3/m = #1174 */
    { 0x0b00, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/2/3/u = #1175 */
    { 0x0c7f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/0/m = #1176 */
    { 0x0c00, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/0/u = #1177 */
    { 0x0d7f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/1/m = #1178 */
    { 0x0d00, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/1/u = #1179 */
    { 0x0e7f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/2/m = #1180 */
    { 0x0e00, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/2/u = #1181 */
    { 0x0f7f, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/3/m = #1182 */
    { 0x0f00, 0xac9e, 0x3c00, RTFLOAT80U_INIT_C(1,0xf08381ee6b579e8a,2712), RTFLOAT80U_INIT_C(0,0xf08381ee6b579e8a,2712) }, /* #36/3/3/u = #1183 */
    { 0x007f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/0/m = #1184 */
    { 0x0000, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/0/u = #1185 */
    { 0x017f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/1/m = #1186 */
    { 0x0100, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/1/u = #1187 */
    { 0x027f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/2/m = #1188 */
    { 0x0200, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/2/u = #1189 */
    { 0x037f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/3/m = #1190 */
    { 0x0300, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/0/3/u = #1191 */
    { 0x047f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/0/m = #1192 */
    { 0x0400, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/0/u = #1193 */
    { 0x057f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/1/m = #1194 */
    { 0x0500, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/1/u = #1195 */
    { 0x067f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/2/m = #1196 */
    { 0x0600, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/2/u = #1197 */
    { 0x077f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/3/m = #1198 */
    { 0x0700, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/1/3/u = #1199 */
    { 0x087f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/0/m = #1200 */
    { 0x0800, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/0/u = #1201 */
    { 0x097f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/1/m = #1202 */
    { 0x0900, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/1/u = #1203 */
    { 0x0a7f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/2/m = #1204 */
    { 0x0a00, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/2/u = #1205 */
    { 0x0b7f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/3/m = #1206 */
    { 0x0b00, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/2/3/u = #1207 */
    { 0x0c7f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/0/m = #1208 */
    { 0x0c00, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/0/u = #1209 */
    { 0x0d7f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/1/m = #1210 */
    { 0x0d00, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/1/u = #1211 */
    { 0x0e7f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/2/m = #1212 */
    { 0x0e00, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/2/u = #1213 */
    { 0x0f7f, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/3/m = #1214 */
    { 0x0f00, 0xf106, 0x7900, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #37/3/3/u = #1215 */
    { 0x007f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/0/m = #1216 */
    { 0x0000, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/0/u = #1217 */
    { 0x017f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/1/m = #1218 */
    { 0x0100, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/1/u = #1219 */
    { 0x027f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/2/m = #1220 */
    { 0x0200, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/2/u = #1221 */
    { 0x037f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/3/m = #1222 */
    { 0x0300, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/0/3/u = #1223 */
    { 0x047f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/0/m = #1224 */
    { 0x0400, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/0/u = #1225 */
    { 0x057f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/1/m = #1226 */
    { 0x0500, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/1/u = #1227 */
    { 0x067f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/2/m = #1228 */
    { 0x0600, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/2/u = #1229 */
    { 0x077f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/3/m = #1230 */
    { 0x0700, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/1/3/u = #1231 */
    { 0x087f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/0/m = #1232 */
    { 0x0800, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/0/u = #1233 */
    { 0x097f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/1/m = #1234 */
    { 0x0900, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/1/u = #1235 */
    { 0x0a7f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/2/m = #1236 */
    { 0x0a00, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/2/u = #1237 */
    { 0x0b7f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/3/m = #1238 */
    { 0x0b00, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/2/3/u = #1239 */
    { 0x0c7f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/0/m = #1240 */
    { 0x0c00, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/0/u = #1241 */
    { 0x0d7f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/1/m = #1242 */
    { 0x0d00, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/1/u = #1243 */
    { 0x0e7f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/2/m = #1244 */
    { 0x0e00, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/2/u = #1245 */
    { 0x0f7f, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/3/m = #1246 */
    { 0x0f00, 0x9a09, 0x3800, RTFLOAT80U_INIT_C(0,0xc5435b3d3e86bbc6,30347), RTFLOAT80U_INIT_C(1,0xc5435b3d3e86bbc6,30347) }, /* #38/3/3/u = #1247 */
    { 0x007f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/0/m = #1248 */
    { 0x0000, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/0/u = #1249 */
    { 0x017f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/1/m = #1250 */
    { 0x0100, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/1/u = #1251 */
    { 0x027f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/2/m = #1252 */
    { 0x0200, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/2/u = #1253 */
    { 0x037f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/3/m = #1254 */
    { 0x0300, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/0/3/u = #1255 */
    { 0x047f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/0/m = #1256 */
    { 0x0400, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/0/u = #1257 */
    { 0x057f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/1/m = #1258 */
    { 0x0500, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/1/u = #1259 */
    { 0x067f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/2/m = #1260 */
    { 0x0600, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/2/u = #1261 */
    { 0x077f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/3/m = #1262 */
    { 0x0700, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/1/3/u = #1263 */
    { 0x087f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/0/m = #1264 */
    { 0x0800, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/0/u = #1265 */
    { 0x097f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/1/m = #1266 */
    { 0x0900, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/1/u = #1267 */
    { 0x0a7f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/2/m = #1268 */
    { 0x0a00, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/2/u = #1269 */
    { 0x0b7f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/3/m = #1270 */
    { 0x0b00, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/2/3/u = #1271 */
    { 0x0c7f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/0/m = #1272 */
    { 0x0c00, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/0/u = #1273 */
    { 0x0d7f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/1/m = #1274 */
    { 0x0d00, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/1/u = #1275 */
    { 0x0e7f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/2/m = #1276 */
    { 0x0e00, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/2/u = #1277 */
    { 0x0f7f, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/3/m = #1278 */
    { 0x0f00, 0xe986, 0x7900, RTFLOAT80U_INIT_C(1,0x3a885b614585ed85,5740), RTFLOAT80U_INIT_C(0,0x3a885b614585ed85,5740) }, /* #39/3/3/u = #1279 */
    { 0x007f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/0/m = #1280 */
    { 0x0000, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/0/u = #1281 */
    { 0x017f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/1/m = #1282 */
    { 0x0100, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/1/u = #1283 */
    { 0x027f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/2/m = #1284 */
    { 0x0200, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/2/u = #1285 */
    { 0x037f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/3/m = #1286 */
    { 0x0300, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/0/3/u = #1287 */
    { 0x047f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/0/m = #1288 */
    { 0x0400, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/0/u = #1289 */
    { 0x057f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/1/m = #1290 */
    { 0x0500, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/1/u = #1291 */
    { 0x067f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/2/m = #1292 */
    { 0x0600, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/2/u = #1293 */
    { 0x077f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/3/m = #1294 */
    { 0x0700, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/1/3/u = #1295 */
    { 0x087f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/0/m = #1296 */
    { 0x0800, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/0/u = #1297 */
    { 0x097f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/1/m = #1298 */
    { 0x0900, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/1/u = #1299 */
    { 0x0a7f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/2/m = #1300 */
    { 0x0a00, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/2/u = #1301 */
    { 0x0b7f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/3/m = #1302 */
    { 0x0b00, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/2/3/u = #1303 */
    { 0x0c7f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/0/m = #1304 */
    { 0x0c00, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/0/u = #1305 */
    { 0x0d7f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/1/m = #1306 */
    { 0x0d00, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/1/u = #1307 */
    { 0x0e7f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/2/m = #1308 */
    { 0x0e00, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/2/u = #1309 */
    { 0x0f7f, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/3/m = #1310 */
    { 0x0f00, 0xee05, 0x7c00, RTFLOAT80U_INIT_C(0,0xce17d7bbd5d3a0cb,32767), RTFLOAT80U_INIT_C(1,0xce17d7bbd5d3a0cb,32767) }, /* #40/3/3/u = #1311 */
    { 0x007f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/0/m = #1312 */
    { 0x0000, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/0/u = #1313 */
    { 0x017f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/1/m = #1314 */
    { 0x0100, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/1/u = #1315 */
    { 0x027f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/2/m = #1316 */
    { 0x0200, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/2/u = #1317 */
    { 0x037f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/3/m = #1318 */
    { 0x0300, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/0/3/u = #1319 */
    { 0x047f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/0/m = #1320 */
    { 0x0400, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/0/u = #1321 */
    { 0x057f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/1/m = #1322 */
    { 0x0500, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/1/u = #1323 */
    { 0x067f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/2/m = #1324 */
    { 0x0600, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/2/u = #1325 */
    { 0x077f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/3/m = #1326 */
    { 0x0700, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/1/3/u = #1327 */
    { 0x087f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/0/m = #1328 */
    { 0x0800, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/0/u = #1329 */
    { 0x097f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/1/m = #1330 */
    { 0x0900, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/1/u = #1331 */
    { 0x0a7f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/2/m = #1332 */
    { 0x0a00, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/2/u = #1333 */
    { 0x0b7f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/3/m = #1334 */
    { 0x0b00, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/2/3/u = #1335 */
    { 0x0c7f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/0/m = #1336 */
    { 0x0c00, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/0/u = #1337 */
    { 0x0d7f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/1/m = #1338 */
    { 0x0d00, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/1/u = #1339 */
    { 0x0e7f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/2/m = #1340 */
    { 0x0e00, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/2/u = #1341 */
    { 0x0f7f, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/3/m = #1342 */
    { 0x0f00, 0x0e92, 0x3c00, RTFLOAT80U_INIT_C(1,0x800000003b841066,32767), RTFLOAT80U_INIT_C(0,0x800000003b841066,32767) }, /* #41/3/3/u = #1343 */
    { 0x007f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/0/m = #1344 */
    { 0x0000, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/0/u = #1345 */
    { 0x017f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/1/m = #1346 */
    { 0x0100, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/1/u = #1347 */
    { 0x027f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/2/m = #1348 */
    { 0x0200, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/2/u = #1349 */
    { 0x037f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/3/m = #1350 */
    { 0x0300, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/0/3/u = #1351 */
    { 0x047f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/0/m = #1352 */
    { 0x0400, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/0/u = #1353 */
    { 0x057f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/1/m = #1354 */
    { 0x0500, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/1/u = #1355 */
    { 0x067f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/2/m = #1356 */
    { 0x0600, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/2/u = #1357 */
    { 0x077f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/3/m = #1358 */
    { 0x0700, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/1/3/u = #1359 */
    { 0x087f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/0/m = #1360 */
    { 0x0800, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/0/u = #1361 */
    { 0x097f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/1/m = #1362 */
    { 0x0900, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/1/u = #1363 */
    { 0x0a7f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/2/m = #1364 */
    { 0x0a00, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/2/u = #1365 */
    { 0x0b7f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/3/m = #1366 */
    { 0x0b00, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/2/3/u = #1367 */
    { 0x0c7f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/0/m = #1368 */
    { 0x0c00, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/0/u = #1369 */
    { 0x0d7f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/1/m = #1370 */
    { 0x0d00, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/1/u = #1371 */
    { 0x0e7f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/2/m = #1372 */
    { 0x0e00, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/2/u = #1373 */
    { 0x0f7f, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/3/m = #1374 */
    { 0x0f00, 0xc644, 0x7c00, RTFLOAT80U_INIT_C(0,0x400000000e4e3b9d,32767), RTFLOAT80U_INIT_C(1,0x400000000e4e3b9d,32767) }, /* #42/3/3/u = #1375 */
    { 0x007f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/0/m = #1376 */
    { 0x0000, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/0/u = #1377 */
    { 0x017f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/1/m = #1378 */
    { 0x0100, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/1/u = #1379 */
    { 0x027f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/2/m = #1380 */
    { 0x0200, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/2/u = #1381 */
    { 0x037f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/3/m = #1382 */
    { 0x0300, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/0/3/u = #1383 */
    { 0x047f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/0/m = #1384 */
    { 0x0400, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/0/u = #1385 */
    { 0x057f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/1/m = #1386 */
    { 0x0500, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/1/u = #1387 */
    { 0x067f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/2/m = #1388 */
    { 0x0600, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/2/u = #1389 */
    { 0x077f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/3/m = #1390 */
    { 0x0700, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/1/3/u = #1391 */
    { 0x087f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/0/m = #1392 */
    { 0x0800, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/0/u = #1393 */
    { 0x097f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/1/m = #1394 */
    { 0x0900, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/1/u = #1395 */
    { 0x0a7f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/2/m = #1396 */
    { 0x0a00, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/2/u = #1397 */
    { 0x0b7f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/3/m = #1398 */
    { 0x0b00, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/2/3/u = #1399 */
    { 0x0c7f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/0/m = #1400 */
    { 0x0c00, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/0/u = #1401 */
    { 0x0d7f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/1/m = #1402 */
    { 0x0d00, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/1/u = #1403 */
    { 0x0e7f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/2/m = #1404 */
    { 0x0e00, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/2/u = #1405 */
    { 0x0f7f, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/3/m = #1406 */
    { 0x0f00, 0xafc4, 0x3d00, RTFLOAT80U_INIT_C(0,0xe8e211642833777c,10287), RTFLOAT80U_INIT_C(1,0xe8e211642833777c,10287) }, /* #43/3/3/u = #1407 */
    { 0x007f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/0/m = #1408 */
    { 0x0000, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/0/u = #1409 */
    { 0x017f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/1/m = #1410 */
    { 0x0100, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/1/u = #1411 */
    { 0x027f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/2/m = #1412 */
    { 0x0200, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/2/u = #1413 */
    { 0x037f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/3/m = #1414 */
    { 0x0300, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/0/3/u = #1415 */
    { 0x047f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/0/m = #1416 */
    { 0x0400, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/0/u = #1417 */
    { 0x057f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/1/m = #1418 */
    { 0x0500, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/1/u = #1419 */
    { 0x067f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/2/m = #1420 */
    { 0x0600, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/2/u = #1421 */
    { 0x077f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/3/m = #1422 */
    { 0x0700, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/1/3/u = #1423 */
    { 0x087f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/0/m = #1424 */
    { 0x0800, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/0/u = #1425 */
    { 0x097f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/1/m = #1426 */
    { 0x0900, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/1/u = #1427 */
    { 0x0a7f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/2/m = #1428 */
    { 0x0a00, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/2/u = #1429 */
    { 0x0b7f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/3/m = #1430 */
    { 0x0b00, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/2/3/u = #1431 */
    { 0x0c7f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/0/m = #1432 */
    { 0x0c00, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/0/u = #1433 */
    { 0x0d7f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/1/m = #1434 */
    { 0x0d00, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/1/u = #1435 */
    { 0x0e7f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/2/m = #1436 */
    { 0x0e00, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/2/u = #1437 */
    { 0x0f7f, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/3/m = #1438 */
    { 0x0f00, 0x17ad, 0x3d00, RTFLOAT80U_INIT_C(1,0xbe3d46d8a61a4263,32767), RTFLOAT80U_INIT_C(0,0xbe3d46d8a61a4263,32767) }, /* #44/3/3/u = #1439 */
    { 0x007f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/0/m = #1440 */
    { 0x0000, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/0/u = #1441 */
    { 0x017f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/1/m = #1442 */
    { 0x0100, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/1/u = #1443 */
    { 0x027f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/2/m = #1444 */
    { 0x0200, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/2/u = #1445 */
    { 0x037f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/3/m = #1446 */
    { 0x0300, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/0/3/u = #1447 */
    { 0x047f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/0/m = #1448 */
    { 0x0400, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/0/u = #1449 */
    { 0x057f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/1/m = #1450 */
    { 0x0500, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/1/u = #1451 */
    { 0x067f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/2/m = #1452 */
    { 0x0600, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/2/u = #1453 */
    { 0x077f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/3/m = #1454 */
    { 0x0700, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/1/3/u = #1455 */
    { 0x087f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/0/m = #1456 */
    { 0x0800, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/0/u = #1457 */
    { 0x097f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/1/m = #1458 */
    { 0x0900, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/1/u = #1459 */
    { 0x0a7f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/2/m = #1460 */
    { 0x0a00, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/2/u = #1461 */
    { 0x0b7f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/3/m = #1462 */
    { 0x0b00, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/2/3/u = #1463 */
    { 0x0c7f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/0/m = #1464 */
    { 0x0c00, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/0/u = #1465 */
    { 0x0d7f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/1/m = #1466 */
    { 0x0d00, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/1/u = #1467 */
    { 0x0e7f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/2/m = #1468 */
    { 0x0e00, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/2/u = #1469 */
    { 0x0f7f, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/3/m = #1470 */
    { 0x0f00, 0x67a6, 0x7d00, RTFLOAT80U_INIT_C(1,0xe2bb5d0e7c02925f,5322), RTFLOAT80U_INIT_C(0,0xe2bb5d0e7c02925f,5322) }, /* #45/3/3/u = #1471 */
    { 0x007f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/0/m = #1472 */
    { 0x0000, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/0/u = #1473 */
    { 0x017f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/1/m = #1474 */
    { 0x0100, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/1/u = #1475 */
    { 0x027f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/2/m = #1476 */
    { 0x0200, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/2/u = #1477 */
    { 0x037f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/3/m = #1478 */
    { 0x0300, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/0/3/u = #1479 */
    { 0x047f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/0/m = #1480 */
    { 0x0400, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/0/u = #1481 */
    { 0x057f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/1/m = #1482 */
    { 0x0500, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/1/u = #1483 */
    { 0x067f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/2/m = #1484 */
    { 0x0600, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/2/u = #1485 */
    { 0x077f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/3/m = #1486 */
    { 0x0700, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/1/3/u = #1487 */
    { 0x087f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/0/m = #1488 */
    { 0x0800, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/0/u = #1489 */
    { 0x097f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/1/m = #1490 */
    { 0x0900, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/1/u = #1491 */
    { 0x0a7f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/2/m = #1492 */
    { 0x0a00, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/2/u = #1493 */
    { 0x0b7f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/3/m = #1494 */
    { 0x0b00, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/2/3/u = #1495 */
    { 0x0c7f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/0/m = #1496 */
    { 0x0c00, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/0/u = #1497 */
    { 0x0d7f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/1/m = #1498 */
    { 0x0d00, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/1/u = #1499 */
    { 0x0e7f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/2/m = #1500 */
    { 0x0e00, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/2/u = #1501 */
    { 0x0f7f, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/3/m = #1502 */
    { 0x0f00, 0xd31c, 0x7900, RTFLOAT80U_INIT_C(1,0x4002aab0d265814d,32767), RTFLOAT80U_INIT_C(0,0x4002aab0d265814d,32767) }, /* #46/3/3/u = #1503 */
    { 0x007f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/0/m = #1504 */
    { 0x0000, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/0/u = #1505 */
    { 0x017f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/1/m = #1506 */
    { 0x0100, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/1/u = #1507 */
    { 0x027f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/2/m = #1508 */
    { 0x0200, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/2/u = #1509 */
    { 0x037f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/3/m = #1510 */
    { 0x0300, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/0/3/u = #1511 */
    { 0x047f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/0/m = #1512 */
    { 0x0400, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/0/u = #1513 */
    { 0x057f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/1/m = #1514 */
    { 0x0500, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/1/u = #1515 */
    { 0x067f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/2/m = #1516 */
    { 0x0600, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/2/u = #1517 */
    { 0x077f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/3/m = #1518 */
    { 0x0700, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/1/3/u = #1519 */
    { 0x087f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/0/m = #1520 */
    { 0x0800, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/0/u = #1521 */
    { 0x097f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/1/m = #1522 */
    { 0x0900, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/1/u = #1523 */
    { 0x0a7f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/2/m = #1524 */
    { 0x0a00, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/2/u = #1525 */
    { 0x0b7f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/3/m = #1526 */
    { 0x0b00, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/2/3/u = #1527 */
    { 0x0c7f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/0/m = #1528 */
    { 0x0c00, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/0/u = #1529 */
    { 0x0d7f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/1/m = #1530 */
    { 0x0d00, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/1/u = #1531 */
    { 0x0e7f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/2/m = #1532 */
    { 0x0e00, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/2/u = #1533 */
    { 0x0f7f, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/3/m = #1534 */
    { 0x0f00, 0x0dbc, 0x3d00, RTFLOAT80U_INIT_C(1,0x598a66762f394829,18750), RTFLOAT80U_INIT_C(0,0x598a66762f394829,18750) }, /* #47/3/3/u = #1535 */
    { 0x007f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/0/m = #1536 */
    { 0x0000, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/0/u = #1537 */
    { 0x017f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/1/m = #1538 */
    { 0x0100, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/1/u = #1539 */
    { 0x027f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/2/m = #1540 */
    { 0x0200, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/2/u = #1541 */
    { 0x037f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/3/m = #1542 */
    { 0x0300, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/0/3/u = #1543 */
    { 0x047f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/0/m = #1544 */
    { 0x0400, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/0/u = #1545 */
    { 0x057f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/1/m = #1546 */
    { 0x0500, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/1/u = #1547 */
    { 0x067f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/2/m = #1548 */
    { 0x0600, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/2/u = #1549 */
    { 0x077f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/3/m = #1550 */
    { 0x0700, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/1/3/u = #1551 */
    { 0x087f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/0/m = #1552 */
    { 0x0800, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/0/u = #1553 */
    { 0x097f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/1/m = #1554 */
    { 0x0900, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/1/u = #1555 */
    { 0x0a7f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/2/m = #1556 */
    { 0x0a00, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/2/u = #1557 */
    { 0x0b7f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/3/m = #1558 */
    { 0x0b00, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/2/3/u = #1559 */
    { 0x0c7f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/0/m = #1560 */
    { 0x0c00, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/0/u = #1561 */
    { 0x0d7f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/1/m = #1562 */
    { 0x0d00, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/1/u = #1563 */
    { 0x0e7f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/2/m = #1564 */
    { 0x0e00, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/2/u = #1565 */
    { 0x0f7f, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/3/m = #1566 */
    { 0x0f00, 0xa7b3, 0x3d00, RTFLOAT80U_INIT_C(1,0xd2a05ef9795c78a7,11987), RTFLOAT80U_INIT_C(0,0xd2a05ef9795c78a7,11987) }, /* #48/3/3/u = #1567 */
    { 0x007f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/0/m = #1568 */
    { 0x0000, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/0/u = #1569 */
    { 0x017f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/1/m = #1570 */
    { 0x0100, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/1/u = #1571 */
    { 0x027f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/2/m = #1572 */
    { 0x0200, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/2/u = #1573 */
    { 0x037f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/3/m = #1574 */
    { 0x0300, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/0/3/u = #1575 */
    { 0x047f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/0/m = #1576 */
    { 0x0400, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/0/u = #1577 */
    { 0x057f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/1/m = #1578 */
    { 0x0500, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/1/u = #1579 */
    { 0x067f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/2/m = #1580 */
    { 0x0600, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/2/u = #1581 */
    { 0x077f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/3/m = #1582 */
    { 0x0700, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/1/3/u = #1583 */
    { 0x087f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/0/m = #1584 */
    { 0x0800, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/0/u = #1585 */
    { 0x097f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/1/m = #1586 */
    { 0x0900, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/1/u = #1587 */
    { 0x0a7f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/2/m = #1588 */
    { 0x0a00, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/2/u = #1589 */
    { 0x0b7f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/3/m = #1590 */
    { 0x0b00, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/2/3/u = #1591 */
    { 0x0c7f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/0/m = #1592 */
    { 0x0c00, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/0/u = #1593 */
    { 0x0d7f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/1/m = #1594 */
    { 0x0d00, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/1/u = #1595 */
    { 0x0e7f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/2/m = #1596 */
    { 0x0e00, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/2/u = #1597 */
    { 0x0f7f, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/3/m = #1598 */
    { 0x0f00, 0xe496, 0x7c00, RTFLOAT80U_INIT_C(0,0xba12197ed27e750,0), RTFLOAT80U_INIT_C(1,0xba12197ed27e750,0) }, /* #49/3/3/u = #1599 */
    { 0x007f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/0/m = #1600 */
    { 0x0000, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/0/u = #1601 */
    { 0x017f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/1/m = #1602 */
    { 0x0100, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/1/u = #1603 */
    { 0x027f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/2/m = #1604 */
    { 0x0200, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/2/u = #1605 */
    { 0x037f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/3/m = #1606 */
    { 0x0300, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/0/3/u = #1607 */
    { 0x047f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/0/m = #1608 */
    { 0x0400, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/0/u = #1609 */
    { 0x057f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/1/m = #1610 */
    { 0x0500, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/1/u = #1611 */
    { 0x067f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/2/m = #1612 */
    { 0x0600, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/2/u = #1613 */
    { 0x077f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/3/m = #1614 */
    { 0x0700, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/1/3/u = #1615 */
    { 0x087f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/0/m = #1616 */
    { 0x0800, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/0/u = #1617 */
    { 0x097f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/1/m = #1618 */
    { 0x0900, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/1/u = #1619 */
    { 0x0a7f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/2/m = #1620 */
    { 0x0a00, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/2/u = #1621 */
    { 0x0b7f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/3/m = #1622 */
    { 0x0b00, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/2/3/u = #1623 */
    { 0x0c7f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/0/m = #1624 */
    { 0x0c00, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/0/u = #1625 */
    { 0x0d7f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/1/m = #1626 */
    { 0x0d00, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/1/u = #1627 */
    { 0x0e7f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/2/m = #1628 */
    { 0x0e00, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/2/u = #1629 */
    { 0x0f7f, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/3/m = #1630 */
    { 0x0f00, 0x4dec, 0x7d00, RTFLOAT80U_INIT_C(1,0x8f91ff7108faa004,32767), RTFLOAT80U_INIT_C(0,0x8f91ff7108faa004,32767) }, /* #50/3/3/u = #1631 */
    { 0x007f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/0/m = #1632 */
    { 0x0000, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/0/u = #1633 */
    { 0x017f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/1/m = #1634 */
    { 0x0100, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/1/u = #1635 */
    { 0x027f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/2/m = #1636 */
    { 0x0200, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/2/u = #1637 */
    { 0x037f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/3/m = #1638 */
    { 0x0300, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/0/3/u = #1639 */
    { 0x047f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/0/m = #1640 */
    { 0x0400, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/0/u = #1641 */
    { 0x057f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/1/m = #1642 */
    { 0x0500, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/1/u = #1643 */
    { 0x067f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/2/m = #1644 */
    { 0x0600, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/2/u = #1645 */
    { 0x077f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/3/m = #1646 */
    { 0x0700, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/1/3/u = #1647 */
    { 0x087f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/0/m = #1648 */
    { 0x0800, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/0/u = #1649 */
    { 0x097f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/1/m = #1650 */
    { 0x0900, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/1/u = #1651 */
    { 0x0a7f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/2/m = #1652 */
    { 0x0a00, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/2/u = #1653 */
    { 0x0b7f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/3/m = #1654 */
    { 0x0b00, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/2/3/u = #1655 */
    { 0x0c7f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/0/m = #1656 */
    { 0x0c00, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/0/u = #1657 */
    { 0x0d7f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/1/m = #1658 */
    { 0x0d00, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/1/u = #1659 */
    { 0x0e7f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/2/m = #1660 */
    { 0x0e00, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/2/u = #1661 */
    { 0x0f7f, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/3/m = #1662 */
    { 0x0f00, 0x3cc6, 0x3c00, RTFLOAT80U_INIT_C(1,0x7204f,15409), RTFLOAT80U_INIT_C(0,0x7204f,15409) }, /* #51/3/3/u = #1663 */
    { 0x007f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/0/m = #1664 */
    { 0x0000, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/0/u = #1665 */
    { 0x017f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/1/m = #1666 */
    { 0x0100, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/1/u = #1667 */
    { 0x027f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/2/m = #1668 */
    { 0x0200, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/2/u = #1669 */
    { 0x037f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/3/m = #1670 */
    { 0x0300, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/0/3/u = #1671 */
    { 0x047f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/0/m = #1672 */
    { 0x0400, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/0/u = #1673 */
    { 0x057f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/1/m = #1674 */
    { 0x0500, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/1/u = #1675 */
    { 0x067f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/2/m = #1676 */
    { 0x0600, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/2/u = #1677 */
    { 0x077f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/3/m = #1678 */
    { 0x0700, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/1/3/u = #1679 */
    { 0x087f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/0/m = #1680 */
    { 0x0800, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/0/u = #1681 */
    { 0x097f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/1/m = #1682 */
    { 0x0900, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/1/u = #1683 */
    { 0x0a7f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/2/m = #1684 */
    { 0x0a00, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/2/u = #1685 */
    { 0x0b7f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/3/m = #1686 */
    { 0x0b00, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/2/3/u = #1687 */
    { 0x0c7f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/0/m = #1688 */
    { 0x0c00, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/0/u = #1689 */
    { 0x0d7f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/1/m = #1690 */
    { 0x0d00, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/1/u = #1691 */
    { 0x0e7f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/2/m = #1692 */
    { 0x0e00, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/2/u = #1693 */
    { 0x0f7f, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/3/m = #1694 */
    { 0x0f00, 0xbb5a, 0x3900, RTFLOAT80U_INIT_C(1,0x8e3931a655a4582b,25623), RTFLOAT80U_INIT_C(0,0x8e3931a655a4582b,25623) }, /* #52/3/3/u = #1695 */
    { 0x007f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/0/m = #1696 */
    { 0x0000, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/0/u = #1697 */
    { 0x017f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/1/m = #1698 */
    { 0x0100, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/1/u = #1699 */
    { 0x027f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/2/m = #1700 */
    { 0x0200, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/2/u = #1701 */
    { 0x037f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/3/m = #1702 */
    { 0x0300, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/0/3/u = #1703 */
    { 0x047f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/0/m = #1704 */
    { 0x0400, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/0/u = #1705 */
    { 0x057f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/1/m = #1706 */
    { 0x0500, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/1/u = #1707 */
    { 0x067f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/2/m = #1708 */
    { 0x0600, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/2/u = #1709 */
    { 0x077f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/3/m = #1710 */
    { 0x0700, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/1/3/u = #1711 */
    { 0x087f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/0/m = #1712 */
    { 0x0800, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/0/u = #1713 */
    { 0x097f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/1/m = #1714 */
    { 0x0900, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/1/u = #1715 */
    { 0x0a7f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/2/m = #1716 */
    { 0x0a00, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/2/u = #1717 */
    { 0x0b7f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/3/m = #1718 */
    { 0x0b00, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/2/3/u = #1719 */
    { 0x0c7f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/0/m = #1720 */
    { 0x0c00, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/0/u = #1721 */
    { 0x0d7f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/1/m = #1722 */
    { 0x0d00, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/1/u = #1723 */
    { 0x0e7f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/2/m = #1724 */
    { 0x0e00, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/2/u = #1725 */
    { 0x0f7f, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/3/m = #1726 */
    { 0x0f00, 0x8e4b, 0x3c00, RTFLOAT80U_INIT_C(1,0x23ed3b10d457922e,32767), RTFLOAT80U_INIT_C(0,0x23ed3b10d457922e,32767) }, /* #53/3/3/u = #1727 */
    { 0x007f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/0/m = #1728 */
    { 0x0000, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/0/u = #1729 */
    { 0x017f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/1/m = #1730 */
    { 0x0100, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/1/u = #1731 */
    { 0x027f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/2/m = #1732 */
    { 0x0200, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/2/u = #1733 */
    { 0x037f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/3/m = #1734 */
    { 0x0300, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/0/3/u = #1735 */
    { 0x047f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/0/m = #1736 */
    { 0x0400, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/0/u = #1737 */
    { 0x057f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/1/m = #1738 */
    { 0x0500, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/1/u = #1739 */
    { 0x067f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/2/m = #1740 */
    { 0x0600, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/2/u = #1741 */
    { 0x077f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/3/m = #1742 */
    { 0x0700, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/1/3/u = #1743 */
    { 0x087f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/0/m = #1744 */
    { 0x0800, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/0/u = #1745 */
    { 0x097f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/1/m = #1746 */
    { 0x0900, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/1/u = #1747 */
    { 0x0a7f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/2/m = #1748 */
    { 0x0a00, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/2/u = #1749 */
    { 0x0b7f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/3/m = #1750 */
    { 0x0b00, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/2/3/u = #1751 */
    { 0x0c7f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/0/m = #1752 */
    { 0x0c00, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/0/u = #1753 */
    { 0x0d7f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/1/m = #1754 */
    { 0x0d00, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/1/u = #1755 */
    { 0x0e7f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/2/m = #1756 */
    { 0x0e00, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/2/u = #1757 */
    { 0x0f7f, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/3/m = #1758 */
    { 0x0f00, 0x8b9a, 0x3900, RTFLOAT80U_INIT_C(0,0x53310d34ef85dc53,26062), RTFLOAT80U_INIT_C(1,0x53310d34ef85dc53,26062) }, /* #54/3/3/u = #1759 */
    { 0x007f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/0/m = #1760 */
    { 0x0000, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/0/u = #1761 */
    { 0x017f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/1/m = #1762 */
    { 0x0100, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/1/u = #1763 */
    { 0x027f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/2/m = #1764 */
    { 0x0200, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/2/u = #1765 */
    { 0x037f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/3/m = #1766 */
    { 0x0300, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/0/3/u = #1767 */
    { 0x047f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/0/m = #1768 */
    { 0x0400, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/0/u = #1769 */
    { 0x057f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/1/m = #1770 */
    { 0x0500, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/1/u = #1771 */
    { 0x067f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/2/m = #1772 */
    { 0x0600, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/2/u = #1773 */
    { 0x077f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/3/m = #1774 */
    { 0x0700, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/1/3/u = #1775 */
    { 0x087f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/0/m = #1776 */
    { 0x0800, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/0/u = #1777 */
    { 0x097f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/1/m = #1778 */
    { 0x0900, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/1/u = #1779 */
    { 0x0a7f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/2/m = #1780 */
    { 0x0a00, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/2/u = #1781 */
    { 0x0b7f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/3/m = #1782 */
    { 0x0b00, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/2/3/u = #1783 */
    { 0x0c7f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/0/m = #1784 */
    { 0x0c00, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/0/u = #1785 */
    { 0x0d7f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/1/m = #1786 */
    { 0x0d00, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/1/u = #1787 */
    { 0x0e7f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/2/m = #1788 */
    { 0x0e00, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/2/u = #1789 */
    { 0x0f7f, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/3/m = #1790 */
    { 0x0f00, 0x869e, 0x3c00, RTFLOAT80U_INIT_C(1,0x1717c6d3262339fa,0), RTFLOAT80U_INIT_C(0,0x1717c6d3262339fa,0) }, /* #55/3/3/u = #1791 */
    { 0x007f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/0/m = #1792 */
    { 0x0000, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/0/u = #1793 */
    { 0x017f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/1/m = #1794 */
    { 0x0100, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/1/u = #1795 */
    { 0x027f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/2/m = #1796 */
    { 0x0200, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/2/u = #1797 */
    { 0x037f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/3/m = #1798 */
    { 0x0300, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/0/3/u = #1799 */
    { 0x047f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/0/m = #1800 */
    { 0x0400, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/0/u = #1801 */
    { 0x057f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/1/m = #1802 */
    { 0x0500, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/1/u = #1803 */
    { 0x067f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/2/m = #1804 */
    { 0x0600, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/2/u = #1805 */
    { 0x077f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/3/m = #1806 */
    { 0x0700, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/1/3/u = #1807 */
    { 0x087f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/0/m = #1808 */
    { 0x0800, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/0/u = #1809 */
    { 0x097f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/1/m = #1810 */
    { 0x0900, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/1/u = #1811 */
    { 0x0a7f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/2/m = #1812 */
    { 0x0a00, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/2/u = #1813 */
    { 0x0b7f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/3/m = #1814 */
    { 0x0b00, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/2/3/u = #1815 */
    { 0x0c7f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/0/m = #1816 */
    { 0x0c00, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/0/u = #1817 */
    { 0x0d7f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/1/m = #1818 */
    { 0x0d00, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/1/u = #1819 */
    { 0x0e7f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/2/m = #1820 */
    { 0x0e00, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/2/u = #1821 */
    { 0x0f7f, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/3/m = #1822 */
    { 0x0f00, 0x9ba1, 0x3900, RTFLOAT80U_INIT_C(0,0xa0c7311b46435a9a,8004), RTFLOAT80U_INIT_C(1,0xa0c7311b46435a9a,8004) }, /* #56/3/3/u = #1823 */
    { 0x007f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/0/m = #1824 */
    { 0x0000, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/0/u = #1825 */
    { 0x017f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/1/m = #1826 */
    { 0x0100, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/1/u = #1827 */
    { 0x027f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/2/m = #1828 */
    { 0x0200, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/2/u = #1829 */
    { 0x037f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/3/m = #1830 */
    { 0x0300, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/0/3/u = #1831 */
    { 0x047f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/0/m = #1832 */
    { 0x0400, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/0/u = #1833 */
    { 0x057f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/1/m = #1834 */
    { 0x0500, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/1/u = #1835 */
    { 0x067f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/2/m = #1836 */
    { 0x0600, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/2/u = #1837 */
    { 0x077f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/3/m = #1838 */
    { 0x0700, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/1/3/u = #1839 */
    { 0x087f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/0/m = #1840 */
    { 0x0800, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/0/u = #1841 */
    { 0x097f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/1/m = #1842 */
    { 0x0900, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/1/u = #1843 */
    { 0x0a7f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/2/m = #1844 */
    { 0x0a00, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/2/u = #1845 */
    { 0x0b7f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/3/m = #1846 */
    { 0x0b00, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/2/3/u = #1847 */
    { 0x0c7f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/0/m = #1848 */
    { 0x0c00, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/0/u = #1849 */
    { 0x0d7f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/1/m = #1850 */
    { 0x0d00, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/1/u = #1851 */
    { 0x0e7f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/2/m = #1852 */
    { 0x0e00, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/2/u = #1853 */
    { 0x0f7f, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/3/m = #1854 */
    { 0x0f00, 0x36ec, 0x3c00, RTFLOAT80U_INIT_C(0,0xc162925999f0128c,22654), RTFLOAT80U_INIT_C(1,0xc162925999f0128c,22654) }, /* #57/3/3/u = #1855 */
    { 0x007f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/0/m = #1856 */
    { 0x0000, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/0/u = #1857 */
    { 0x017f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/1/m = #1858 */
    { 0x0100, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/1/u = #1859 */
    { 0x027f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/2/m = #1860 */
    { 0x0200, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/2/u = #1861 */
    { 0x037f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/3/m = #1862 */
    { 0x0300, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/0/3/u = #1863 */
    { 0x047f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/0/m = #1864 */
    { 0x0400, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/0/u = #1865 */
    { 0x057f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/1/m = #1866 */
    { 0x0500, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/1/u = #1867 */
    { 0x067f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/2/m = #1868 */
    { 0x0600, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/2/u = #1869 */
    { 0x077f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/3/m = #1870 */
    { 0x0700, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/1/3/u = #1871 */
    { 0x087f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/0/m = #1872 */
    { 0x0800, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/0/u = #1873 */
    { 0x097f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/1/m = #1874 */
    { 0x0900, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/1/u = #1875 */
    { 0x0a7f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/2/m = #1876 */
    { 0x0a00, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/2/u = #1877 */
    { 0x0b7f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/3/m = #1878 */
    { 0x0b00, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/2/3/u = #1879 */
    { 0x0c7f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/0/m = #1880 */
    { 0x0c00, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/0/u = #1881 */
    { 0x0d7f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/1/m = #1882 */
    { 0x0d00, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/1/u = #1883 */
    { 0x0e7f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/2/m = #1884 */
    { 0x0e00, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/2/u = #1885 */
    { 0x0f7f, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/3/m = #1886 */
    { 0x0f00, 0x1663, 0x3c00, RTFLOAT80U_INIT_C(1,0x3748,0), RTFLOAT80U_INIT_C(0,0x3748,0) }, /* #58/3/3/u = #1887 */
    { 0x007f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/0/m = #1888 */
    { 0x0000, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/0/u = #1889 */
    { 0x017f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/1/m = #1890 */
    { 0x0100, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/1/u = #1891 */
    { 0x027f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/2/m = #1892 */
    { 0x0200, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/2/u = #1893 */
    { 0x037f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/3/m = #1894 */
    { 0x0300, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/0/3/u = #1895 */
    { 0x047f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/0/m = #1896 */
    { 0x0400, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/0/u = #1897 */
    { 0x057f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/1/m = #1898 */
    { 0x0500, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/1/u = #1899 */
    { 0x067f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/2/m = #1900 */
    { 0x0600, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/2/u = #1901 */
    { 0x077f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/3/m = #1902 */
    { 0x0700, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/1/3/u = #1903 */
    { 0x087f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/0/m = #1904 */
    { 0x0800, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/0/u = #1905 */
    { 0x097f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/1/m = #1906 */
    { 0x0900, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/1/u = #1907 */
    { 0x0a7f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/2/m = #1908 */
    { 0x0a00, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/2/u = #1909 */
    { 0x0b7f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/3/m = #1910 */
    { 0x0b00, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/2/3/u = #1911 */
    { 0x0c7f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/0/m = #1912 */
    { 0x0c00, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/0/u = #1913 */
    { 0x0d7f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/1/m = #1914 */
    { 0x0d00, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/1/u = #1915 */
    { 0x0e7f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/2/m = #1916 */
    { 0x0e00, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/2/u = #1917 */
    { 0x0f7f, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/3/m = #1918 */
    { 0x0f00, 0x26b1, 0x3c00, RTFLOAT80U_INIT_C(0,0x80000fa92f71050d,32767), RTFLOAT80U_INIT_C(1,0x80000fa92f71050d,32767) }, /* #59/3/3/u = #1919 */
    { 0x007f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/0/m = #1920 */
    { 0x0000, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/0/u = #1921 */
    { 0x017f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/1/m = #1922 */
    { 0x0100, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/1/u = #1923 */
    { 0x027f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/2/m = #1924 */
    { 0x0200, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/2/u = #1925 */
    { 0x037f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/3/m = #1926 */
    { 0x0300, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/0/3/u = #1927 */
    { 0x047f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/0/m = #1928 */
    { 0x0400, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/0/u = #1929 */
    { 0x057f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/1/m = #1930 */
    { 0x0500, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/1/u = #1931 */
    { 0x067f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/2/m = #1932 */
    { 0x0600, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/2/u = #1933 */
    { 0x077f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/3/m = #1934 */
    { 0x0700, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/1/3/u = #1935 */
    { 0x087f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/0/m = #1936 */
    { 0x0800, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/0/u = #1937 */
    { 0x097f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/1/m = #1938 */
    { 0x0900, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/1/u = #1939 */
    { 0x0a7f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/2/m = #1940 */
    { 0x0a00, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/2/u = #1941 */
    { 0x0b7f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/3/m = #1942 */
    { 0x0b00, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/2/3/u = #1943 */
    { 0x0c7f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/0/m = #1944 */
    { 0x0c00, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/0/u = #1945 */
    { 0x0d7f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/1/m = #1946 */
    { 0x0d00, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/1/u = #1947 */
    { 0x0e7f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/2/m = #1948 */
    { 0x0e00, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/2/u = #1949 */
    { 0x0f7f, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/3/m = #1950 */
    { 0x0f00, 0x013b, 0x3900, RTFLOAT80U_INIT_C(1,0x3e3c582a11f1159b,17689), RTFLOAT80U_INIT_C(0,0x3e3c582a11f1159b,17689) }, /* #60/3/3/u = #1951 */
    { 0x007f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/0/m = #1952 */
    { 0x0000, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/0/u = #1953 */
    { 0x017f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/1/m = #1954 */
    { 0x0100, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/1/u = #1955 */
    { 0x027f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/2/m = #1956 */
    { 0x0200, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/2/u = #1957 */
    { 0x037f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/3/m = #1958 */
    { 0x0300, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/0/3/u = #1959 */
    { 0x047f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/0/m = #1960 */
    { 0x0400, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/0/u = #1961 */
    { 0x057f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/1/m = #1962 */
    { 0x0500, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/1/u = #1963 */
    { 0x067f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/2/m = #1964 */
    { 0x0600, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/2/u = #1965 */
    { 0x077f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/3/m = #1966 */
    { 0x0700, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/1/3/u = #1967 */
    { 0x087f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/0/m = #1968 */
    { 0x0800, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/0/u = #1969 */
    { 0x097f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/1/m = #1970 */
    { 0x0900, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/1/u = #1971 */
    { 0x0a7f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/2/m = #1972 */
    { 0x0a00, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/2/u = #1973 */
    { 0x0b7f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/3/m = #1974 */
    { 0x0b00, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/2/3/u = #1975 */
    { 0x0c7f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/0/m = #1976 */
    { 0x0c00, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/0/u = #1977 */
    { 0x0d7f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/1/m = #1978 */
    { 0x0d00, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/1/u = #1979 */
    { 0x0e7f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/2/m = #1980 */
    { 0x0e00, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/2/u = #1981 */
    { 0x0f7f, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/3/m = #1982 */
    { 0x0f00, 0x699b, 0x7900, RTFLOAT80U_INIT_C(1,0xa011386ea5f3a439,20283), RTFLOAT80U_INIT_C(0,0xa011386ea5f3a439,20283) }, /* #61/3/3/u = #1983 */
    { 0x007f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/0/m = #1984 */
    { 0x0000, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/0/u = #1985 */
    { 0x017f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/1/m = #1986 */
    { 0x0100, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/1/u = #1987 */
    { 0x027f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/2/m = #1988 */
    { 0x0200, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/2/u = #1989 */
    { 0x037f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/3/m = #1990 */
    { 0x0300, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/0/3/u = #1991 */
    { 0x047f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/0/m = #1992 */
    { 0x0400, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/0/u = #1993 */
    { 0x057f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/1/m = #1994 */
    { 0x0500, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/1/u = #1995 */
    { 0x067f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/2/m = #1996 */
    { 0x0600, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/2/u = #1997 */
    { 0x077f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/3/m = #1998 */
    { 0x0700, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/1/3/u = #1999 */
    { 0x087f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/0/m = #2000 */
    { 0x0800, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/0/u = #2001 */
    { 0x097f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/1/m = #2002 */
    { 0x0900, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/1/u = #2003 */
    { 0x0a7f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/2/m = #2004 */
    { 0x0a00, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/2/u = #2005 */
    { 0x0b7f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/3/m = #2006 */
    { 0x0b00, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/2/3/u = #2007 */
    { 0x0c7f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/0/m = #2008 */
    { 0x0c00, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/0/u = #2009 */
    { 0x0d7f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/1/m = #2010 */
    { 0x0d00, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/1/u = #2011 */
    { 0x0e7f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/2/m = #2012 */
    { 0x0e00, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/2/u = #2013 */
    { 0x0f7f, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/3/m = #2014 */
    { 0x0f00, 0xf214, 0x7800, RTFLOAT80U_INIT_C(1,0xc3633e7c780694c9,32325), RTFLOAT80U_INIT_C(0,0xc3633e7c780694c9,32325) }, /* #62/3/3/u = #2015 */
    { 0x007f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/0/m = #2016 */
    { 0x0000, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/0/u = #2017 */
    { 0x017f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/1/m = #2018 */
    { 0x0100, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/1/u = #2019 */
    { 0x027f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/2/m = #2020 */
    { 0x0200, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/2/u = #2021 */
    { 0x037f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/3/m = #2022 */
    { 0x0300, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/0/3/u = #2023 */
    { 0x047f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/0/m = #2024 */
    { 0x0400, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/0/u = #2025 */
    { 0x057f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/1/m = #2026 */
    { 0x0500, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/1/u = #2027 */
    { 0x067f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/2/m = #2028 */
    { 0x0600, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/2/u = #2029 */
    { 0x077f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/3/m = #2030 */
    { 0x0700, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/1/3/u = #2031 */
    { 0x087f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/0/m = #2032 */
    { 0x0800, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/0/u = #2033 */
    { 0x097f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/1/m = #2034 */
    { 0x0900, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/1/u = #2035 */
    { 0x0a7f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/2/m = #2036 */
    { 0x0a00, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/2/u = #2037 */
    { 0x0b7f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/3/m = #2038 */
    { 0x0b00, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/2/3/u = #2039 */
    { 0x0c7f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/0/m = #2040 */
    { 0x0c00, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/0/u = #2041 */
    { 0x0d7f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/1/m = #2042 */
    { 0x0d00, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/1/u = #2043 */
    { 0x0e7f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/2/m = #2044 */
    { 0x0e00, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/2/u = #2045 */
    { 0x0f7f, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/3/m = #2046 */
    { 0x0f00, 0x7f5d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc26d3ecac1ab7768,32767), RTFLOAT80U_INIT_C(1,0xc26d3ecac1ab7768,32767) }, /* #63/3/3/u = #2047 */
    { 0x007f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/0/m = #2048 */
    { 0x0000, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/0/u = #2049 */
    { 0x017f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/1/m = #2050 */
    { 0x0100, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/1/u = #2051 */
    { 0x027f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/2/m = #2052 */
    { 0x0200, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/2/u = #2053 */
    { 0x037f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/3/m = #2054 */
    { 0x0300, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/0/3/u = #2055 */
    { 0x047f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/0/m = #2056 */
    { 0x0400, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/0/u = #2057 */
    { 0x057f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/1/m = #2058 */
    { 0x0500, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/1/u = #2059 */
    { 0x067f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/2/m = #2060 */
    { 0x0600, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/2/u = #2061 */
    { 0x077f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/3/m = #2062 */
    { 0x0700, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/1/3/u = #2063 */
    { 0x087f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/0/m = #2064 */
    { 0x0800, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/0/u = #2065 */
    { 0x097f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/1/m = #2066 */
    { 0x0900, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/1/u = #2067 */
    { 0x0a7f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/2/m = #2068 */
    { 0x0a00, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/2/u = #2069 */
    { 0x0b7f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/3/m = #2070 */
    { 0x0b00, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/2/3/u = #2071 */
    { 0x0c7f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/0/m = #2072 */
    { 0x0c00, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/0/u = #2073 */
    { 0x0d7f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/1/m = #2074 */
    { 0x0d00, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/1/u = #2075 */
    { 0x0e7f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/2/m = #2076 */
    { 0x0e00, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/2/u = #2077 */
    { 0x0f7f, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/3/m = #2078 */
    { 0x0f00, 0x7478, 0x7c00, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #64/3/3/u = #2079 */
    { 0x007f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/0/m = #2080 */
    { 0x0000, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/0/u = #2081 */
    { 0x017f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/1/m = #2082 */
    { 0x0100, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/1/u = #2083 */
    { 0x027f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/2/m = #2084 */
    { 0x0200, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/2/u = #2085 */
    { 0x037f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/3/m = #2086 */
    { 0x0300, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/0/3/u = #2087 */
    { 0x047f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/0/m = #2088 */
    { 0x0400, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/0/u = #2089 */
    { 0x057f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/1/m = #2090 */
    { 0x0500, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/1/u = #2091 */
    { 0x067f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/2/m = #2092 */
    { 0x0600, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/2/u = #2093 */
    { 0x077f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/3/m = #2094 */
    { 0x0700, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/1/3/u = #2095 */
    { 0x087f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/0/m = #2096 */
    { 0x0800, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/0/u = #2097 */
    { 0x097f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/1/m = #2098 */
    { 0x0900, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/1/u = #2099 */
    { 0x0a7f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/2/m = #2100 */
    { 0x0a00, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/2/u = #2101 */
    { 0x0b7f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/3/m = #2102 */
    { 0x0b00, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/2/3/u = #2103 */
    { 0x0c7f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/0/m = #2104 */
    { 0x0c00, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/0/u = #2105 */
    { 0x0d7f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/1/m = #2106 */
    { 0x0d00, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/1/u = #2107 */
    { 0x0e7f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/2/m = #2108 */
    { 0x0e00, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/2/u = #2109 */
    { 0x0f7f, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/3/m = #2110 */
    { 0x0f00, 0xb857, 0x3800, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #65/3/3/u = #2111 */
    { 0x007f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/0/m = #2112 */
    { 0x0000, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/0/u = #2113 */
    { 0x017f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/1/m = #2114 */
    { 0x0100, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/1/u = #2115 */
    { 0x027f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/2/m = #2116 */
    { 0x0200, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/2/u = #2117 */
    { 0x037f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/3/m = #2118 */
    { 0x0300, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/0/3/u = #2119 */
    { 0x047f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/0/m = #2120 */
    { 0x0400, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/0/u = #2121 */
    { 0x057f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/1/m = #2122 */
    { 0x0500, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/1/u = #2123 */
    { 0x067f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/2/m = #2124 */
    { 0x0600, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/2/u = #2125 */
    { 0x077f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/3/m = #2126 */
    { 0x0700, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/1/3/u = #2127 */
    { 0x087f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/0/m = #2128 */
    { 0x0800, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/0/u = #2129 */
    { 0x097f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/1/m = #2130 */
    { 0x0900, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/1/u = #2131 */
    { 0x0a7f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/2/m = #2132 */
    { 0x0a00, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/2/u = #2133 */
    { 0x0b7f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/3/m = #2134 */
    { 0x0b00, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/2/3/u = #2135 */
    { 0x0c7f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/0/m = #2136 */
    { 0x0c00, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/0/u = #2137 */
    { 0x0d7f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/1/m = #2138 */
    { 0x0d00, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/1/u = #2139 */
    { 0x0e7f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/2/m = #2140 */
    { 0x0e00, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/2/u = #2141 */
    { 0x0f7f, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/3/m = #2142 */
    { 0x0f00, 0xa0cb, 0x3800, RTFLOAT80U_INIT_C(1,0xf731806a133285ea,5757), RTFLOAT80U_INIT_C(0,0xf731806a133285ea,5757) }, /* #66/3/3/u = #2143 */
    { 0x007f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/0/m = #2144 */
    { 0x0000, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/0/u = #2145 */
    { 0x017f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/1/m = #2146 */
    { 0x0100, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/1/u = #2147 */
    { 0x027f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/2/m = #2148 */
    { 0x0200, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/2/u = #2149 */
    { 0x037f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/3/m = #2150 */
    { 0x0300, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/0/3/u = #2151 */
    { 0x047f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/0/m = #2152 */
    { 0x0400, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/0/u = #2153 */
    { 0x057f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/1/m = #2154 */
    { 0x0500, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/1/u = #2155 */
    { 0x067f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/2/m = #2156 */
    { 0x0600, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/2/u = #2157 */
    { 0x077f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/3/m = #2158 */
    { 0x0700, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/1/3/u = #2159 */
    { 0x087f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/0/m = #2160 */
    { 0x0800, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/0/u = #2161 */
    { 0x097f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/1/m = #2162 */
    { 0x0900, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/1/u = #2163 */
    { 0x0a7f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/2/m = #2164 */
    { 0x0a00, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/2/u = #2165 */
    { 0x0b7f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/3/m = #2166 */
    { 0x0b00, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/2/3/u = #2167 */
    { 0x0c7f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/0/m = #2168 */
    { 0x0c00, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/0/u = #2169 */
    { 0x0d7f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/1/m = #2170 */
    { 0x0d00, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/1/u = #2171 */
    { 0x0e7f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/2/m = #2172 */
    { 0x0e00, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/2/u = #2173 */
    { 0x0f7f, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/3/m = #2174 */
    { 0x0f00, 0xa9f5, 0x3900, RTFLOAT80U_INIT_C(1,0x38d9f81ccda,0), RTFLOAT80U_INIT_C(0,0x38d9f81ccda,0) }, /* #67/3/3/u = #2175 */
    { 0x007f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/0/m = #2176 */
    { 0x0000, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/0/u = #2177 */
    { 0x017f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/1/m = #2178 */
    { 0x0100, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/1/u = #2179 */
    { 0x027f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/2/m = #2180 */
    { 0x0200, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/2/u = #2181 */
    { 0x037f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/3/m = #2182 */
    { 0x0300, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/0/3/u = #2183 */
    { 0x047f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/0/m = #2184 */
    { 0x0400, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/0/u = #2185 */
    { 0x057f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/1/m = #2186 */
    { 0x0500, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/1/u = #2187 */
    { 0x067f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/2/m = #2188 */
    { 0x0600, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/2/u = #2189 */
    { 0x077f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/3/m = #2190 */
    { 0x0700, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/1/3/u = #2191 */
    { 0x087f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/0/m = #2192 */
    { 0x0800, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/0/u = #2193 */
    { 0x097f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/1/m = #2194 */
    { 0x0900, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/1/u = #2195 */
    { 0x0a7f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/2/m = #2196 */
    { 0x0a00, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/2/u = #2197 */
    { 0x0b7f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/3/m = #2198 */
    { 0x0b00, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/2/3/u = #2199 */
    { 0x0c7f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/0/m = #2200 */
    { 0x0c00, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/0/u = #2201 */
    { 0x0d7f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/1/m = #2202 */
    { 0x0d00, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/1/u = #2203 */
    { 0x0e7f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/2/m = #2204 */
    { 0x0e00, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/2/u = #2205 */
    { 0x0f7f, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/3/m = #2206 */
    { 0x0f00, 0x86c6, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(0) }, /* #68/3/3/u = #2207 */
    { 0x007f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/0/m = #2208 */
    { 0x0000, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/0/u = #2209 */
    { 0x017f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/1/m = #2210 */
    { 0x0100, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/1/u = #2211 */
    { 0x027f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/2/m = #2212 */
    { 0x0200, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/2/u = #2213 */
    { 0x037f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/3/m = #2214 */
    { 0x0300, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/0/3/u = #2215 */
    { 0x047f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/0/m = #2216 */
    { 0x0400, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/0/u = #2217 */
    { 0x057f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/1/m = #2218 */
    { 0x0500, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/1/u = #2219 */
    { 0x067f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/2/m = #2220 */
    { 0x0600, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/2/u = #2221 */
    { 0x077f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/3/m = #2222 */
    { 0x0700, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/1/3/u = #2223 */
    { 0x087f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/0/m = #2224 */
    { 0x0800, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/0/u = #2225 */
    { 0x097f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/1/m = #2226 */
    { 0x0900, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/1/u = #2227 */
    { 0x0a7f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/2/m = #2228 */
    { 0x0a00, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/2/u = #2229 */
    { 0x0b7f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/3/m = #2230 */
    { 0x0b00, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/2/3/u = #2231 */
    { 0x0c7f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/0/m = #2232 */
    { 0x0c00, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/0/u = #2233 */
    { 0x0d7f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/1/m = #2234 */
    { 0x0d00, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/1/u = #2235 */
    { 0x0e7f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/2/m = #2236 */
    { 0x0e00, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/2/u = #2237 */
    { 0x0f7f, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/3/m = #2238 */
    { 0x0f00, 0x2dd7, 0x3d00, RTFLOAT80U_INIT_C(0,0x984663e2eee701c3,6827), RTFLOAT80U_INIT_C(1,0x984663e2eee701c3,6827) }, /* #69/3/3/u = #2239 */
    { 0x007f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/0/m = #2240 */
    { 0x0000, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/0/u = #2241 */
    { 0x017f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/1/m = #2242 */
    { 0x0100, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/1/u = #2243 */
    { 0x027f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/2/m = #2244 */
    { 0x0200, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/2/u = #2245 */
    { 0x037f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/3/m = #2246 */
    { 0x0300, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/0/3/u = #2247 */
    { 0x047f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/0/m = #2248 */
    { 0x0400, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/0/u = #2249 */
    { 0x057f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/1/m = #2250 */
    { 0x0500, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/1/u = #2251 */
    { 0x067f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/2/m = #2252 */
    { 0x0600, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/2/u = #2253 */
    { 0x077f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/3/m = #2254 */
    { 0x0700, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/1/3/u = #2255 */
    { 0x087f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/0/m = #2256 */
    { 0x0800, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/0/u = #2257 */
    { 0x097f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/1/m = #2258 */
    { 0x0900, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/1/u = #2259 */
    { 0x0a7f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/2/m = #2260 */
    { 0x0a00, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/2/u = #2261 */
    { 0x0b7f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/3/m = #2262 */
    { 0x0b00, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/2/3/u = #2263 */
    { 0x0c7f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/0/m = #2264 */
    { 0x0c00, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/0/u = #2265 */
    { 0x0d7f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/1/m = #2266 */
    { 0x0d00, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/1/u = #2267 */
    { 0x0e7f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/2/m = #2268 */
    { 0x0e00, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/2/u = #2269 */
    { 0x0f7f, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/3/m = #2270 */
    { 0x0f00, 0x139f, 0x3900, RTFLOAT80U_INIT_C(1,0x8b30f3f891530b89,9658), RTFLOAT80U_INIT_C(0,0x8b30f3f891530b89,9658) }, /* #70/3/3/u = #2271 */
    { 0x007f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/0/m = #2272 */
    { 0x0000, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/0/u = #2273 */
    { 0x017f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/1/m = #2274 */
    { 0x0100, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/1/u = #2275 */
    { 0x027f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/2/m = #2276 */
    { 0x0200, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/2/u = #2277 */
    { 0x037f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/3/m = #2278 */
    { 0x0300, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/0/3/u = #2279 */
    { 0x047f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/0/m = #2280 */
    { 0x0400, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/0/u = #2281 */
    { 0x057f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/1/m = #2282 */
    { 0x0500, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/1/u = #2283 */
    { 0x067f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/2/m = #2284 */
    { 0x0600, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/2/u = #2285 */
    { 0x077f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/3/m = #2286 */
    { 0x0700, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/1/3/u = #2287 */
    { 0x087f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/0/m = #2288 */
    { 0x0800, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/0/u = #2289 */
    { 0x097f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/1/m = #2290 */
    { 0x0900, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/1/u = #2291 */
    { 0x0a7f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/2/m = #2292 */
    { 0x0a00, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/2/u = #2293 */
    { 0x0b7f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/3/m = #2294 */
    { 0x0b00, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/2/3/u = #2295 */
    { 0x0c7f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/0/m = #2296 */
    { 0x0c00, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/0/u = #2297 */
    { 0x0d7f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/1/m = #2298 */
    { 0x0d00, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/1/u = #2299 */
    { 0x0e7f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/2/m = #2300 */
    { 0x0e00, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/2/u = #2301 */
    { 0x0f7f, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/3/m = #2302 */
    { 0x0f00, 0xc8ee, 0x7800, RTFLOAT80U_INIT_C(1,0x543,0), RTFLOAT80U_INIT_C(0,0x543,0) }, /* #71/3/3/u = #2303 */
    { 0x007f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/0/m = #2304 */
    { 0x0000, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/0/u = #2305 */
    { 0x017f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/1/m = #2306 */
    { 0x0100, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/1/u = #2307 */
    { 0x027f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/2/m = #2308 */
    { 0x0200, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/2/u = #2309 */
    { 0x037f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/3/m = #2310 */
    { 0x0300, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/0/3/u = #2311 */
    { 0x047f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/0/m = #2312 */
    { 0x0400, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/0/u = #2313 */
    { 0x057f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/1/m = #2314 */
    { 0x0500, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/1/u = #2315 */
    { 0x067f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/2/m = #2316 */
    { 0x0600, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/2/u = #2317 */
    { 0x077f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/3/m = #2318 */
    { 0x0700, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/1/3/u = #2319 */
    { 0x087f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/0/m = #2320 */
    { 0x0800, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/0/u = #2321 */
    { 0x097f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/1/m = #2322 */
    { 0x0900, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/1/u = #2323 */
    { 0x0a7f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/2/m = #2324 */
    { 0x0a00, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/2/u = #2325 */
    { 0x0b7f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/3/m = #2326 */
    { 0x0b00, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/2/3/u = #2327 */
    { 0x0c7f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/0/m = #2328 */
    { 0x0c00, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/0/u = #2329 */
    { 0x0d7f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/1/m = #2330 */
    { 0x0d00, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/1/u = #2331 */
    { 0x0e7f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/2/m = #2332 */
    { 0x0e00, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/2/u = #2333 */
    { 0x0f7f, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/3/m = #2334 */
    { 0x0f00, 0x4b8e, 0x7900, RTFLOAT80U_INIT_C(0,0x87f9b878106c08cb,28827), RTFLOAT80U_INIT_C(1,0x87f9b878106c08cb,28827) }, /* #72/3/3/u = #2335 */
    { 0x007f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/0/m = #2336 */
    { 0x0000, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/0/u = #2337 */
    { 0x017f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/1/m = #2338 */
    { 0x0100, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/1/u = #2339 */
    { 0x027f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/2/m = #2340 */
    { 0x0200, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/2/u = #2341 */
    { 0x037f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/3/m = #2342 */
    { 0x0300, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/0/3/u = #2343 */
    { 0x047f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/0/m = #2344 */
    { 0x0400, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/0/u = #2345 */
    { 0x057f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/1/m = #2346 */
    { 0x0500, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/1/u = #2347 */
    { 0x067f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/2/m = #2348 */
    { 0x0600, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/2/u = #2349 */
    { 0x077f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/3/m = #2350 */
    { 0x0700, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/1/3/u = #2351 */
    { 0x087f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/0/m = #2352 */
    { 0x0800, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/0/u = #2353 */
    { 0x097f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/1/m = #2354 */
    { 0x0900, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/1/u = #2355 */
    { 0x0a7f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/2/m = #2356 */
    { 0x0a00, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/2/u = #2357 */
    { 0x0b7f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/3/m = #2358 */
    { 0x0b00, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/2/3/u = #2359 */
    { 0x0c7f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/0/m = #2360 */
    { 0x0c00, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/0/u = #2361 */
    { 0x0d7f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/1/m = #2362 */
    { 0x0d00, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/1/u = #2363 */
    { 0x0e7f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/2/m = #2364 */
    { 0x0e00, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/2/u = #2365 */
    { 0x0f7f, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/3/m = #2366 */
    { 0x0f00, 0xd4d6, 0x7c00, RTFLOAT80U_INIT_C(1,0x13ed9b1683,13391), RTFLOAT80U_INIT_C(0,0x13ed9b1683,13391) }, /* #73/3/3/u = #2367 */
    { 0x007f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/0/m = #2368 */
    { 0x0000, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/0/u = #2369 */
    { 0x017f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/1/m = #2370 */
    { 0x0100, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/1/u = #2371 */
    { 0x027f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/2/m = #2372 */
    { 0x0200, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/2/u = #2373 */
    { 0x037f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/3/m = #2374 */
    { 0x0300, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/0/3/u = #2375 */
    { 0x047f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/0/m = #2376 */
    { 0x0400, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/0/u = #2377 */
    { 0x057f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/1/m = #2378 */
    { 0x0500, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/1/u = #2379 */
    { 0x067f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/2/m = #2380 */
    { 0x0600, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/2/u = #2381 */
    { 0x077f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/3/m = #2382 */
    { 0x0700, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/1/3/u = #2383 */
    { 0x087f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/0/m = #2384 */
    { 0x0800, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/0/u = #2385 */
    { 0x097f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/1/m = #2386 */
    { 0x0900, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/1/u = #2387 */
    { 0x0a7f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/2/m = #2388 */
    { 0x0a00, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/2/u = #2389 */
    { 0x0b7f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/3/m = #2390 */
    { 0x0b00, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/2/3/u = #2391 */
    { 0x0c7f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/0/m = #2392 */
    { 0x0c00, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/0/u = #2393 */
    { 0x0d7f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/1/m = #2394 */
    { 0x0d00, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/1/u = #2395 */
    { 0x0e7f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/2/m = #2396 */
    { 0x0e00, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/2/u = #2397 */
    { 0x0f7f, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/3/m = #2398 */
    { 0x0f00, 0xb3b0, 0x3900, RTFLOAT80U_INIT_C(0,0xfcc759eb428c33a7,12037), RTFLOAT80U_INIT_C(1,0xfcc759eb428c33a7,12037) }, /* #74/3/3/u = #2399 */
    { 0x007f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/0/m = #2400 */
    { 0x0000, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/0/u = #2401 */
    { 0x017f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/1/m = #2402 */
    { 0x0100, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/1/u = #2403 */
    { 0x027f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/2/m = #2404 */
    { 0x0200, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/2/u = #2405 */
    { 0x037f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/3/m = #2406 */
    { 0x0300, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/0/3/u = #2407 */
    { 0x047f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/0/m = #2408 */
    { 0x0400, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/0/u = #2409 */
    { 0x057f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/1/m = #2410 */
    { 0x0500, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/1/u = #2411 */
    { 0x067f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/2/m = #2412 */
    { 0x0600, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/2/u = #2413 */
    { 0x077f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/3/m = #2414 */
    { 0x0700, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/1/3/u = #2415 */
    { 0x087f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/0/m = #2416 */
    { 0x0800, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/0/u = #2417 */
    { 0x097f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/1/m = #2418 */
    { 0x0900, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/1/u = #2419 */
    { 0x0a7f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/2/m = #2420 */
    { 0x0a00, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/2/u = #2421 */
    { 0x0b7f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/3/m = #2422 */
    { 0x0b00, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/2/3/u = #2423 */
    { 0x0c7f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/0/m = #2424 */
    { 0x0c00, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/0/u = #2425 */
    { 0x0d7f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/1/m = #2426 */
    { 0x0d00, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/1/u = #2427 */
    { 0x0e7f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/2/m = #2428 */
    { 0x0e00, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/2/u = #2429 */
    { 0x0f7f, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/3/m = #2430 */
    { 0x0f00, 0x13f0, 0x3900, RTFLOAT80U_INIT_C(0,0xc00000000000ccc2,32767), RTFLOAT80U_INIT_C(1,0xc00000000000ccc2,32767) }, /* #75/3/3/u = #2431 */
    { 0x007f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/0/m = #2432 */
    { 0x0000, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/0/u = #2433 */
    { 0x017f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/1/m = #2434 */
    { 0x0100, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/1/u = #2435 */
    { 0x027f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/2/m = #2436 */
    { 0x0200, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/2/u = #2437 */
    { 0x037f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/3/m = #2438 */
    { 0x0300, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/0/3/u = #2439 */
    { 0x047f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/0/m = #2440 */
    { 0x0400, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/0/u = #2441 */
    { 0x057f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/1/m = #2442 */
    { 0x0500, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/1/u = #2443 */
    { 0x067f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/2/m = #2444 */
    { 0x0600, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/2/u = #2445 */
    { 0x077f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/3/m = #2446 */
    { 0x0700, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/1/3/u = #2447 */
    { 0x087f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/0/m = #2448 */
    { 0x0800, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/0/u = #2449 */
    { 0x097f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/1/m = #2450 */
    { 0x0900, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/1/u = #2451 */
    { 0x0a7f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/2/m = #2452 */
    { 0x0a00, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/2/u = #2453 */
    { 0x0b7f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/3/m = #2454 */
    { 0x0b00, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/2/3/u = #2455 */
    { 0x0c7f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/0/m = #2456 */
    { 0x0c00, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/0/u = #2457 */
    { 0x0d7f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/1/m = #2458 */
    { 0x0d00, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/1/u = #2459 */
    { 0x0e7f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/2/m = #2460 */
    { 0x0e00, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/2/u = #2461 */
    { 0x0f7f, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/3/m = #2462 */
    { 0x0f00, 0x31de, 0x3900, RTFLOAT80U_INIT_C(1,0xc00000000000001e,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001e,32767) }, /* #76/3/3/u = #2463 */
    { 0x007f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/0/m = #2464 */
    { 0x0000, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/0/u = #2465 */
    { 0x017f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/1/m = #2466 */
    { 0x0100, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/1/u = #2467 */
    { 0x027f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/2/m = #2468 */
    { 0x0200, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/2/u = #2469 */
    { 0x037f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/3/m = #2470 */
    { 0x0300, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/0/3/u = #2471 */
    { 0x047f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/0/m = #2472 */
    { 0x0400, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/0/u = #2473 */
    { 0x057f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/1/m = #2474 */
    { 0x0500, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/1/u = #2475 */
    { 0x067f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/2/m = #2476 */
    { 0x0600, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/2/u = #2477 */
    { 0x077f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/3/m = #2478 */
    { 0x0700, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/1/3/u = #2479 */
    { 0x087f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/0/m = #2480 */
    { 0x0800, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/0/u = #2481 */
    { 0x097f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/1/m = #2482 */
    { 0x0900, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/1/u = #2483 */
    { 0x0a7f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/2/m = #2484 */
    { 0x0a00, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/2/u = #2485 */
    { 0x0b7f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/3/m = #2486 */
    { 0x0b00, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/2/3/u = #2487 */
    { 0x0c7f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/0/m = #2488 */
    { 0x0c00, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/0/u = #2489 */
    { 0x0d7f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/1/m = #2490 */
    { 0x0d00, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/1/u = #2491 */
    { 0x0e7f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/2/m = #2492 */
    { 0x0e00, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/2/u = #2493 */
    { 0x0f7f, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/3/m = #2494 */
    { 0x0f00, 0xaff3, 0x3d00, RTFLOAT80U_INIT_C(1,0x35c10d7719f018f,20558), RTFLOAT80U_INIT_C(0,0x35c10d7719f018f,20558) }, /* #77/3/3/u = #2495 */
    { 0x007f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/0/m = #2496 */
    { 0x0000, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/0/u = #2497 */
    { 0x017f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/1/m = #2498 */
    { 0x0100, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/1/u = #2499 */
    { 0x027f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/2/m = #2500 */
    { 0x0200, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/2/u = #2501 */
    { 0x037f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/3/m = #2502 */
    { 0x0300, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/0/3/u = #2503 */
    { 0x047f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/0/m = #2504 */
    { 0x0400, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/0/u = #2505 */
    { 0x057f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/1/m = #2506 */
    { 0x0500, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/1/u = #2507 */
    { 0x067f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/2/m = #2508 */
    { 0x0600, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/2/u = #2509 */
    { 0x077f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/3/m = #2510 */
    { 0x0700, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/1/3/u = #2511 */
    { 0x087f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/0/m = #2512 */
    { 0x0800, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/0/u = #2513 */
    { 0x097f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/1/m = #2514 */
    { 0x0900, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/1/u = #2515 */
    { 0x0a7f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/2/m = #2516 */
    { 0x0a00, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/2/u = #2517 */
    { 0x0b7f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/3/m = #2518 */
    { 0x0b00, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/2/3/u = #2519 */
    { 0x0c7f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/0/m = #2520 */
    { 0x0c00, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/0/u = #2521 */
    { 0x0d7f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/1/m = #2522 */
    { 0x0d00, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/1/u = #2523 */
    { 0x0e7f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/2/m = #2524 */
    { 0x0e00, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/2/u = #2525 */
    { 0x0f7f, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/3/m = #2526 */
    { 0x0f00, 0xac7d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8e52f1e4a3f7c582,89), RTFLOAT80U_INIT_C(0,0x8e52f1e4a3f7c582,89) }, /* #78/3/3/u = #2527 */
    { 0x007f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/0/m = #2528 */
    { 0x0000, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/0/u = #2529 */
    { 0x017f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/1/m = #2530 */
    { 0x0100, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/1/u = #2531 */
    { 0x027f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/2/m = #2532 */
    { 0x0200, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/2/u = #2533 */
    { 0x037f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/3/m = #2534 */
    { 0x0300, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/0/3/u = #2535 */
    { 0x047f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/0/m = #2536 */
    { 0x0400, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/0/u = #2537 */
    { 0x057f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/1/m = #2538 */
    { 0x0500, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/1/u = #2539 */
    { 0x067f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/2/m = #2540 */
    { 0x0600, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/2/u = #2541 */
    { 0x077f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/3/m = #2542 */
    { 0x0700, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/1/3/u = #2543 */
    { 0x087f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/0/m = #2544 */
    { 0x0800, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/0/u = #2545 */
    { 0x097f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/1/m = #2546 */
    { 0x0900, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/1/u = #2547 */
    { 0x0a7f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/2/m = #2548 */
    { 0x0a00, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/2/u = #2549 */
    { 0x0b7f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/3/m = #2550 */
    { 0x0b00, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/2/3/u = #2551 */
    { 0x0c7f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/0/m = #2552 */
    { 0x0c00, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/0/u = #2553 */
    { 0x0d7f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/1/m = #2554 */
    { 0x0d00, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/1/u = #2555 */
    { 0x0e7f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/2/m = #2556 */
    { 0x0e00, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/2/u = #2557 */
    { 0x0f7f, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/3/m = #2558 */
    { 0x0f00, 0xa091, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #79/3/3/u = #2559 */
    { 0x007f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/0/m = #2560 */
    { 0x0000, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/0/u = #2561 */
    { 0x017f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/1/m = #2562 */
    { 0x0100, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/1/u = #2563 */
    { 0x027f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/2/m = #2564 */
    { 0x0200, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/2/u = #2565 */
    { 0x037f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/3/m = #2566 */
    { 0x0300, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/0/3/u = #2567 */
    { 0x047f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/0/m = #2568 */
    { 0x0400, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/0/u = #2569 */
    { 0x057f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/1/m = #2570 */
    { 0x0500, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/1/u = #2571 */
    { 0x067f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/2/m = #2572 */
    { 0x0600, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/2/u = #2573 */
    { 0x077f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/3/m = #2574 */
    { 0x0700, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/1/3/u = #2575 */
    { 0x087f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/0/m = #2576 */
    { 0x0800, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/0/u = #2577 */
    { 0x097f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/1/m = #2578 */
    { 0x0900, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/1/u = #2579 */
    { 0x0a7f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/2/m = #2580 */
    { 0x0a00, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/2/u = #2581 */
    { 0x0b7f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/3/m = #2582 */
    { 0x0b00, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/2/3/u = #2583 */
    { 0x0c7f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/0/m = #2584 */
    { 0x0c00, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/0/u = #2585 */
    { 0x0d7f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/1/m = #2586 */
    { 0x0d00, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/1/u = #2587 */
    { 0x0e7f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/2/m = #2588 */
    { 0x0e00, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/2/u = #2589 */
    { 0x0f7f, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/3/m = #2590 */
    { 0x0f00, 0xc441, 0x7c00, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0) }, /* #80/3/3/u = #2591 */
    { 0x007f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/0/m = #2592 */
    { 0x0000, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/0/u = #2593 */
    { 0x017f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/1/m = #2594 */
    { 0x0100, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/1/u = #2595 */
    { 0x027f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/2/m = #2596 */
    { 0x0200, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/2/u = #2597 */
    { 0x037f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/3/m = #2598 */
    { 0x0300, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/0/3/u = #2599 */
    { 0x047f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/0/m = #2600 */
    { 0x0400, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/0/u = #2601 */
    { 0x057f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/1/m = #2602 */
    { 0x0500, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/1/u = #2603 */
    { 0x067f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/2/m = #2604 */
    { 0x0600, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/2/u = #2605 */
    { 0x077f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/3/m = #2606 */
    { 0x0700, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/1/3/u = #2607 */
    { 0x087f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/0/m = #2608 */
    { 0x0800, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/0/u = #2609 */
    { 0x097f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/1/m = #2610 */
    { 0x0900, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/1/u = #2611 */
    { 0x0a7f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/2/m = #2612 */
    { 0x0a00, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/2/u = #2613 */
    { 0x0b7f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/3/m = #2614 */
    { 0x0b00, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/2/3/u = #2615 */
    { 0x0c7f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/0/m = #2616 */
    { 0x0c00, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/0/u = #2617 */
    { 0x0d7f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/1/m = #2618 */
    { 0x0d00, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/1/u = #2619 */
    { 0x0e7f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/2/m = #2620 */
    { 0x0e00, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/2/u = #2621 */
    { 0x0f7f, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/3/m = #2622 */
    { 0x0f00, 0xa0d0, 0x3800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #81/3/3/u = #2623 */
    { 0x007f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/0/m = #2624 */
    { 0x0000, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/0/u = #2625 */
    { 0x017f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/1/m = #2626 */
    { 0x0100, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/1/u = #2627 */
    { 0x027f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/2/m = #2628 */
    { 0x0200, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/2/u = #2629 */
    { 0x037f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/3/m = #2630 */
    { 0x0300, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/0/3/u = #2631 */
    { 0x047f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/0/m = #2632 */
    { 0x0400, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/0/u = #2633 */
    { 0x057f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/1/m = #2634 */
    { 0x0500, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/1/u = #2635 */
    { 0x067f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/2/m = #2636 */
    { 0x0600, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/2/u = #2637 */
    { 0x077f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/3/m = #2638 */
    { 0x0700, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/1/3/u = #2639 */
    { 0x087f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/0/m = #2640 */
    { 0x0800, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/0/u = #2641 */
    { 0x097f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/1/m = #2642 */
    { 0x0900, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/1/u = #2643 */
    { 0x0a7f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/2/m = #2644 */
    { 0x0a00, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/2/u = #2645 */
    { 0x0b7f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/3/m = #2646 */
    { 0x0b00, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/2/3/u = #2647 */
    { 0x0c7f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/0/m = #2648 */
    { 0x0c00, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/0/u = #2649 */
    { 0x0d7f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/1/m = #2650 */
    { 0x0d00, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/1/u = #2651 */
    { 0x0e7f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/2/m = #2652 */
    { 0x0e00, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/2/u = #2653 */
    { 0x0f7f, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/3/m = #2654 */
    { 0x0f00, 0x98e6, 0x3800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #82/3/3/u = #2655 */
    { 0x007f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/0/m = #2656 */
    { 0x0000, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/0/u = #2657 */
    { 0x017f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/1/m = #2658 */
    { 0x0100, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/1/u = #2659 */
    { 0x027f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/2/m = #2660 */
    { 0x0200, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/2/u = #2661 */
    { 0x037f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/3/m = #2662 */
    { 0x0300, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/0/3/u = #2663 */
    { 0x047f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/0/m = #2664 */
    { 0x0400, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/0/u = #2665 */
    { 0x057f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/1/m = #2666 */
    { 0x0500, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/1/u = #2667 */
    { 0x067f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/2/m = #2668 */
    { 0x0600, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/2/u = #2669 */
    { 0x077f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/3/m = #2670 */
    { 0x0700, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/1/3/u = #2671 */
    { 0x087f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/0/m = #2672 */
    { 0x0800, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/0/u = #2673 */
    { 0x097f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/1/m = #2674 */
    { 0x0900, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/1/u = #2675 */
    { 0x0a7f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/2/m = #2676 */
    { 0x0a00, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/2/u = #2677 */
    { 0x0b7f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/3/m = #2678 */
    { 0x0b00, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/2/3/u = #2679 */
    { 0x0c7f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/0/m = #2680 */
    { 0x0c00, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/0/u = #2681 */
    { 0x0d7f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/1/m = #2682 */
    { 0x0d00, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/1/u = #2683 */
    { 0x0e7f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/2/m = #2684 */
    { 0x0e00, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/2/u = #2685 */
    { 0x0f7f, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/3/m = #2686 */
    { 0x0f00, 0xdd2d, 0x7d00, RTFLOAT80U_INIT_C(0,0xc0000000002f5ebe,32767), RTFLOAT80U_INIT_C(1,0xc0000000002f5ebe,32767) }, /* #83/3/3/u = #2687 */
    { 0x007f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/0/m = #2688 */
    { 0x0000, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/0/u = #2689 */
    { 0x017f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/1/m = #2690 */
    { 0x0100, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/1/u = #2691 */
    { 0x027f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/2/m = #2692 */
    { 0x0200, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/2/u = #2693 */
    { 0x037f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/3/m = #2694 */
    { 0x0300, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/0/3/u = #2695 */
    { 0x047f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/0/m = #2696 */
    { 0x0400, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/0/u = #2697 */
    { 0x057f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/1/m = #2698 */
    { 0x0500, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/1/u = #2699 */
    { 0x067f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/2/m = #2700 */
    { 0x0600, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/2/u = #2701 */
    { 0x077f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/3/m = #2702 */
    { 0x0700, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/1/3/u = #2703 */
    { 0x087f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/0/m = #2704 */
    { 0x0800, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/0/u = #2705 */
    { 0x097f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/1/m = #2706 */
    { 0x0900, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/1/u = #2707 */
    { 0x0a7f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/2/m = #2708 */
    { 0x0a00, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/2/u = #2709 */
    { 0x0b7f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/3/m = #2710 */
    { 0x0b00, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/2/3/u = #2711 */
    { 0x0c7f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/0/m = #2712 */
    { 0x0c00, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/0/u = #2713 */
    { 0x0d7f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/1/m = #2714 */
    { 0x0d00, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/1/u = #2715 */
    { 0x0e7f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/2/m = #2716 */
    { 0x0e00, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/2/u = #2717 */
    { 0x0f7f, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/3/m = #2718 */
    { 0x0f00, 0x8b4e, 0x3900, RTFLOAT80U_INIT_C(1,0xdd7dd8e83b562531,24832), RTFLOAT80U_INIT_C(0,0xdd7dd8e83b562531,24832) }, /* #84/3/3/u = #2719 */
    { 0x007f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/0/m = #2720 */
    { 0x0000, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/0/u = #2721 */
    { 0x017f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/1/m = #2722 */
    { 0x0100, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/1/u = #2723 */
    { 0x027f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/2/m = #2724 */
    { 0x0200, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/2/u = #2725 */
    { 0x037f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/3/m = #2726 */
    { 0x0300, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/0/3/u = #2727 */
    { 0x047f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/0/m = #2728 */
    { 0x0400, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/0/u = #2729 */
    { 0x057f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/1/m = #2730 */
    { 0x0500, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/1/u = #2731 */
    { 0x067f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/2/m = #2732 */
    { 0x0600, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/2/u = #2733 */
    { 0x077f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/3/m = #2734 */
    { 0x0700, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/1/3/u = #2735 */
    { 0x087f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/0/m = #2736 */
    { 0x0800, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/0/u = #2737 */
    { 0x097f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/1/m = #2738 */
    { 0x0900, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/1/u = #2739 */
    { 0x0a7f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/2/m = #2740 */
    { 0x0a00, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/2/u = #2741 */
    { 0x0b7f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/3/m = #2742 */
    { 0x0b00, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/2/3/u = #2743 */
    { 0x0c7f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/0/m = #2744 */
    { 0x0c00, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/0/u = #2745 */
    { 0x0d7f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/1/m = #2746 */
    { 0x0d00, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/1/u = #2747 */
    { 0x0e7f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/2/m = #2748 */
    { 0x0e00, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/2/u = #2749 */
    { 0x0f7f, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/3/m = #2750 */
    { 0x0f00, 0xc149, 0x7900, RTFLOAT80U_INIT_C(0,0xb4e4296dbd1621d2,11414), RTFLOAT80U_INIT_C(1,0xb4e4296dbd1621d2,11414) }, /* #85/3/3/u = #2751 */
    { 0x007f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/0/m = #2752 */
    { 0x0000, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/0/u = #2753 */
    { 0x017f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/1/m = #2754 */
    { 0x0100, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/1/u = #2755 */
    { 0x027f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/2/m = #2756 */
    { 0x0200, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/2/u = #2757 */
    { 0x037f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/3/m = #2758 */
    { 0x0300, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/0/3/u = #2759 */
    { 0x047f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/0/m = #2760 */
    { 0x0400, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/0/u = #2761 */
    { 0x057f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/1/m = #2762 */
    { 0x0500, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/1/u = #2763 */
    { 0x067f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/2/m = #2764 */
    { 0x0600, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/2/u = #2765 */
    { 0x077f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/3/m = #2766 */
    { 0x0700, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/1/3/u = #2767 */
    { 0x087f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/0/m = #2768 */
    { 0x0800, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/0/u = #2769 */
    { 0x097f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/1/m = #2770 */
    { 0x0900, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/1/u = #2771 */
    { 0x0a7f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/2/m = #2772 */
    { 0x0a00, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/2/u = #2773 */
    { 0x0b7f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/3/m = #2774 */
    { 0x0b00, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/2/3/u = #2775 */
    { 0x0c7f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/0/m = #2776 */
    { 0x0c00, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/0/u = #2777 */
    { 0x0d7f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/1/m = #2778 */
    { 0x0d00, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/1/u = #2779 */
    { 0x0e7f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/2/m = #2780 */
    { 0x0e00, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/2/u = #2781 */
    { 0x0f7f, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/3/m = #2782 */
    { 0x0f00, 0x04a1, 0x3c00, RTFLOAT80U_INIT_C(0,0xbc5f61d6d6e1c0bc,20940), RTFLOAT80U_INIT_C(1,0xbc5f61d6d6e1c0bc,20940) }, /* #86/3/3/u = #2783 */
    { 0x007f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/0/m = #2784 */
    { 0x0000, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/0/u = #2785 */
    { 0x017f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/1/m = #2786 */
    { 0x0100, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/1/u = #2787 */
    { 0x027f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/2/m = #2788 */
    { 0x0200, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/2/u = #2789 */
    { 0x037f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/3/m = #2790 */
    { 0x0300, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/0/3/u = #2791 */
    { 0x047f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/0/m = #2792 */
    { 0x0400, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/0/u = #2793 */
    { 0x057f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/1/m = #2794 */
    { 0x0500, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/1/u = #2795 */
    { 0x067f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/2/m = #2796 */
    { 0x0600, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/2/u = #2797 */
    { 0x077f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/3/m = #2798 */
    { 0x0700, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/1/3/u = #2799 */
    { 0x087f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/0/m = #2800 */
    { 0x0800, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/0/u = #2801 */
    { 0x097f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/1/m = #2802 */
    { 0x0900, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/1/u = #2803 */
    { 0x0a7f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/2/m = #2804 */
    { 0x0a00, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/2/u = #2805 */
    { 0x0b7f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/3/m = #2806 */
    { 0x0b00, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/2/3/u = #2807 */
    { 0x0c7f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/0/m = #2808 */
    { 0x0c00, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/0/u = #2809 */
    { 0x0d7f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/1/m = #2810 */
    { 0x0d00, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/1/u = #2811 */
    { 0x0e7f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/2/m = #2812 */
    { 0x0e00, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/2/u = #2813 */
    { 0x0f7f, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/3/m = #2814 */
    { 0x0f00, 0xa8be, 0x3800, RTFLOAT80U_INIT_C(0,0xcd202c1487a8416a,26542), RTFLOAT80U_INIT_C(1,0xcd202c1487a8416a,26542) }, /* #87/3/3/u = #2815 */
    { 0x007f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/0/m = #2816 */
    { 0x0000, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/0/u = #2817 */
    { 0x017f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/1/m = #2818 */
    { 0x0100, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/1/u = #2819 */
    { 0x027f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/2/m = #2820 */
    { 0x0200, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/2/u = #2821 */
    { 0x037f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/3/m = #2822 */
    { 0x0300, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/0/3/u = #2823 */
    { 0x047f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/0/m = #2824 */
    { 0x0400, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/0/u = #2825 */
    { 0x057f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/1/m = #2826 */
    { 0x0500, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/1/u = #2827 */
    { 0x067f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/2/m = #2828 */
    { 0x0600, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/2/u = #2829 */
    { 0x077f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/3/m = #2830 */
    { 0x0700, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/1/3/u = #2831 */
    { 0x087f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/0/m = #2832 */
    { 0x0800, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/0/u = #2833 */
    { 0x097f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/1/m = #2834 */
    { 0x0900, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/1/u = #2835 */
    { 0x0a7f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/2/m = #2836 */
    { 0x0a00, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/2/u = #2837 */
    { 0x0b7f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/3/m = #2838 */
    { 0x0b00, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/2/3/u = #2839 */
    { 0x0c7f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/0/m = #2840 */
    { 0x0c00, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/0/u = #2841 */
    { 0x0d7f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/1/m = #2842 */
    { 0x0d00, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/1/u = #2843 */
    { 0x0e7f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/2/m = #2844 */
    { 0x0e00, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/2/u = #2845 */
    { 0x0f7f, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/3/m = #2846 */
    { 0x0f00, 0xb754, 0x3d00, RTFLOAT80U_INIT_C(0,0x7be495bab8eacb07,30744), RTFLOAT80U_INIT_C(1,0x7be495bab8eacb07,30744) }, /* #88/3/3/u = #2847 */
    { 0x007f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/0/m = #2848 */
    { 0x0000, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/0/u = #2849 */
    { 0x017f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/1/m = #2850 */
    { 0x0100, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/1/u = #2851 */
    { 0x027f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/2/m = #2852 */
    { 0x0200, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/2/u = #2853 */
    { 0x037f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/3/m = #2854 */
    { 0x0300, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/0/3/u = #2855 */
    { 0x047f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/0/m = #2856 */
    { 0x0400, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/0/u = #2857 */
    { 0x057f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/1/m = #2858 */
    { 0x0500, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/1/u = #2859 */
    { 0x067f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/2/m = #2860 */
    { 0x0600, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/2/u = #2861 */
    { 0x077f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/3/m = #2862 */
    { 0x0700, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/1/3/u = #2863 */
    { 0x087f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/0/m = #2864 */
    { 0x0800, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/0/u = #2865 */
    { 0x097f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/1/m = #2866 */
    { 0x0900, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/1/u = #2867 */
    { 0x0a7f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/2/m = #2868 */
    { 0x0a00, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/2/u = #2869 */
    { 0x0b7f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/3/m = #2870 */
    { 0x0b00, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/2/3/u = #2871 */
    { 0x0c7f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/0/m = #2872 */
    { 0x0c00, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/0/u = #2873 */
    { 0x0d7f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/1/m = #2874 */
    { 0x0d00, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/1/u = #2875 */
    { 0x0e7f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/2/m = #2876 */
    { 0x0e00, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/2/u = #2877 */
    { 0x0f7f, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/3/m = #2878 */
    { 0x0f00, 0x8862, 0x3800, RTFLOAT80U_INIT_C(0,0xe151db45526d6610,12410), RTFLOAT80U_INIT_C(1,0xe151db45526d6610,12410) }, /* #89/3/3/u = #2879 */
    { 0x007f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/0/m = #2880 */
    { 0x0000, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/0/u = #2881 */
    { 0x017f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/1/m = #2882 */
    { 0x0100, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/1/u = #2883 */
    { 0x027f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/2/m = #2884 */
    { 0x0200, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/2/u = #2885 */
    { 0x037f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/3/m = #2886 */
    { 0x0300, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/0/3/u = #2887 */
    { 0x047f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/0/m = #2888 */
    { 0x0400, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/0/u = #2889 */
    { 0x057f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/1/m = #2890 */
    { 0x0500, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/1/u = #2891 */
    { 0x067f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/2/m = #2892 */
    { 0x0600, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/2/u = #2893 */
    { 0x077f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/3/m = #2894 */
    { 0x0700, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/1/3/u = #2895 */
    { 0x087f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/0/m = #2896 */
    { 0x0800, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/0/u = #2897 */
    { 0x097f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/1/m = #2898 */
    { 0x0900, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/1/u = #2899 */
    { 0x0a7f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/2/m = #2900 */
    { 0x0a00, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/2/u = #2901 */
    { 0x0b7f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/3/m = #2902 */
    { 0x0b00, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/2/3/u = #2903 */
    { 0x0c7f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/0/m = #2904 */
    { 0x0c00, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/0/u = #2905 */
    { 0x0d7f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/1/m = #2906 */
    { 0x0d00, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/1/u = #2907 */
    { 0x0e7f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/2/m = #2908 */
    { 0x0e00, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/2/u = #2909 */
    { 0x0f7f, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/3/m = #2910 */
    { 0x0f00, 0xb0d5, 0x3800, RTFLOAT80U_INIT_C(1,0x28a5e1d7d913734c,32767), RTFLOAT80U_INIT_C(0,0x28a5e1d7d913734c,32767) }, /* #90/3/3/u = #2911 */
    { 0x007f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/0/m = #2912 */
    { 0x0000, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/0/u = #2913 */
    { 0x017f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/1/m = #2914 */
    { 0x0100, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/1/u = #2915 */
    { 0x027f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/2/m = #2916 */
    { 0x0200, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/2/u = #2917 */
    { 0x037f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/3/m = #2918 */
    { 0x0300, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/0/3/u = #2919 */
    { 0x047f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/0/m = #2920 */
    { 0x0400, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/0/u = #2921 */
    { 0x057f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/1/m = #2922 */
    { 0x0500, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/1/u = #2923 */
    { 0x067f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/2/m = #2924 */
    { 0x0600, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/2/u = #2925 */
    { 0x077f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/3/m = #2926 */
    { 0x0700, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/1/3/u = #2927 */
    { 0x087f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/0/m = #2928 */
    { 0x0800, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/0/u = #2929 */
    { 0x097f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/1/m = #2930 */
    { 0x0900, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/1/u = #2931 */
    { 0x0a7f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/2/m = #2932 */
    { 0x0a00, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/2/u = #2933 */
    { 0x0b7f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/3/m = #2934 */
    { 0x0b00, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/2/3/u = #2935 */
    { 0x0c7f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/0/m = #2936 */
    { 0x0c00, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/0/u = #2937 */
    { 0x0d7f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/1/m = #2938 */
    { 0x0d00, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/1/u = #2939 */
    { 0x0e7f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/2/m = #2940 */
    { 0x0e00, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/2/u = #2941 */
    { 0x0f7f, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/3/m = #2942 */
    { 0x0f00, 0x3bf3, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000240,0), RTFLOAT80U_INIT_C(1,0x8000000000000240,0) }, /* #91/3/3/u = #2943 */
    { 0x007f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/0/m = #2944 */
    { 0x0000, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/0/u = #2945 */
    { 0x017f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/1/m = #2946 */
    { 0x0100, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/1/u = #2947 */
    { 0x027f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/2/m = #2948 */
    { 0x0200, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/2/u = #2949 */
    { 0x037f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/3/m = #2950 */
    { 0x0300, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/0/3/u = #2951 */
    { 0x047f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/0/m = #2952 */
    { 0x0400, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/0/u = #2953 */
    { 0x057f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/1/m = #2954 */
    { 0x0500, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/1/u = #2955 */
    { 0x067f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/2/m = #2956 */
    { 0x0600, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/2/u = #2957 */
    { 0x077f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/3/m = #2958 */
    { 0x0700, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/1/3/u = #2959 */
    { 0x087f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/0/m = #2960 */
    { 0x0800, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/0/u = #2961 */
    { 0x097f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/1/m = #2962 */
    { 0x0900, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/1/u = #2963 */
    { 0x0a7f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/2/m = #2964 */
    { 0x0a00, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/2/u = #2965 */
    { 0x0b7f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/3/m = #2966 */
    { 0x0b00, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/2/3/u = #2967 */
    { 0x0c7f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/0/m = #2968 */
    { 0x0c00, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/0/u = #2969 */
    { 0x0d7f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/1/m = #2970 */
    { 0x0d00, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/1/u = #2971 */
    { 0x0e7f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/2/m = #2972 */
    { 0x0e00, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/2/u = #2973 */
    { 0x0f7f, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/3/m = #2974 */
    { 0x0f00, 0x0b9d, 0x3900, RTFLOAT80U_INIT_C(0,0xfb69a01e9f5ad652,24728), RTFLOAT80U_INIT_C(1,0xfb69a01e9f5ad652,24728) }, /* #92/3/3/u = #2975 */
    { 0x007f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/0/m = #2976 */
    { 0x0000, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/0/u = #2977 */
    { 0x017f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/1/m = #2978 */
    { 0x0100, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/1/u = #2979 */
    { 0x027f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/2/m = #2980 */
    { 0x0200, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/2/u = #2981 */
    { 0x037f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/3/m = #2982 */
    { 0x0300, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/0/3/u = #2983 */
    { 0x047f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/0/m = #2984 */
    { 0x0400, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/0/u = #2985 */
    { 0x057f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/1/m = #2986 */
    { 0x0500, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/1/u = #2987 */
    { 0x067f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/2/m = #2988 */
    { 0x0600, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/2/u = #2989 */
    { 0x077f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/3/m = #2990 */
    { 0x0700, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/1/3/u = #2991 */
    { 0x087f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/0/m = #2992 */
    { 0x0800, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/0/u = #2993 */
    { 0x097f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/1/m = #2994 */
    { 0x0900, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/1/u = #2995 */
    { 0x0a7f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/2/m = #2996 */
    { 0x0a00, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/2/u = #2997 */
    { 0x0b7f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/3/m = #2998 */
    { 0x0b00, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/2/3/u = #2999 */
    { 0x0c7f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/0/m = #3000 */
    { 0x0c00, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/0/u = #3001 */
    { 0x0d7f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/1/m = #3002 */
    { 0x0d00, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/1/u = #3003 */
    { 0x0e7f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/2/m = #3004 */
    { 0x0e00, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/2/u = #3005 */
    { 0x0f7f, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/3/m = #3006 */
    { 0x0f00, 0x944a, 0x3c00, RTFLOAT80U_INIT_C(0,0x943a03c3ed88dae3,0), RTFLOAT80U_INIT_C(1,0x943a03c3ed88dae3,0) }, /* #93/3/3/u = #3007 */
    { 0x007f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/0/m = #3008 */
    { 0x0000, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/0/u = #3009 */
    { 0x017f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/1/m = #3010 */
    { 0x0100, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/1/u = #3011 */
    { 0x027f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/2/m = #3012 */
    { 0x0200, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/2/u = #3013 */
    { 0x037f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/3/m = #3014 */
    { 0x0300, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/0/3/u = #3015 */
    { 0x047f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/0/m = #3016 */
    { 0x0400, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/0/u = #3017 */
    { 0x057f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/1/m = #3018 */
    { 0x0500, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/1/u = #3019 */
    { 0x067f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/2/m = #3020 */
    { 0x0600, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/2/u = #3021 */
    { 0x077f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/3/m = #3022 */
    { 0x0700, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/1/3/u = #3023 */
    { 0x087f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/0/m = #3024 */
    { 0x0800, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/0/u = #3025 */
    { 0x097f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/1/m = #3026 */
    { 0x0900, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/1/u = #3027 */
    { 0x0a7f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/2/m = #3028 */
    { 0x0a00, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/2/u = #3029 */
    { 0x0b7f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/3/m = #3030 */
    { 0x0b00, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/2/3/u = #3031 */
    { 0x0c7f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/0/m = #3032 */
    { 0x0c00, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/0/u = #3033 */
    { 0x0d7f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/1/m = #3034 */
    { 0x0d00, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/1/u = #3035 */
    { 0x0e7f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/2/m = #3036 */
    { 0x0e00, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/2/u = #3037 */
    { 0x0f7f, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/3/m = #3038 */
    { 0x0f00, 0x09db, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000179,0), RTFLOAT80U_INIT_C(0,0x8000000000000179,0) }, /* #94/3/3/u = #3039 */
    { 0x007f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/0/m = #3040 */
    { 0x0000, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/0/u = #3041 */
    { 0x017f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/1/m = #3042 */
    { 0x0100, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/1/u = #3043 */
    { 0x027f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/2/m = #3044 */
    { 0x0200, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/2/u = #3045 */
    { 0x037f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/3/m = #3046 */
    { 0x0300, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/0/3/u = #3047 */
    { 0x047f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/0/m = #3048 */
    { 0x0400, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/0/u = #3049 */
    { 0x057f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/1/m = #3050 */
    { 0x0500, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/1/u = #3051 */
    { 0x067f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/2/m = #3052 */
    { 0x0600, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/2/u = #3053 */
    { 0x077f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/3/m = #3054 */
    { 0x0700, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/1/3/u = #3055 */
    { 0x087f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/0/m = #3056 */
    { 0x0800, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/0/u = #3057 */
    { 0x097f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/1/m = #3058 */
    { 0x0900, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/1/u = #3059 */
    { 0x0a7f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/2/m = #3060 */
    { 0x0a00, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/2/u = #3061 */
    { 0x0b7f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/3/m = #3062 */
    { 0x0b00, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/2/3/u = #3063 */
    { 0x0c7f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/0/m = #3064 */
    { 0x0c00, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/0/u = #3065 */
    { 0x0d7f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/1/m = #3066 */
    { 0x0d00, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/1/u = #3067 */
    { 0x0e7f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/2/m = #3068 */
    { 0x0e00, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/2/u = #3069 */
    { 0x0f7f, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/3/m = #3070 */
    { 0x0f00, 0xa8a2, 0x3800, RTFLOAT80U_INIT_C(1,0xa5da28acce372e6d,18610), RTFLOAT80U_INIT_C(0,0xa5da28acce372e6d,18610) }, /* #95/3/3/u = #3071 */
    { 0x007f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/0/m = #3072 */
    { 0x0000, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/0/u = #3073 */
    { 0x017f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/1/m = #3074 */
    { 0x0100, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/1/u = #3075 */
    { 0x027f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/2/m = #3076 */
    { 0x0200, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/2/u = #3077 */
    { 0x037f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/3/m = #3078 */
    { 0x0300, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/0/3/u = #3079 */
    { 0x047f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/0/m = #3080 */
    { 0x0400, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/0/u = #3081 */
    { 0x057f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/1/m = #3082 */
    { 0x0500, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/1/u = #3083 */
    { 0x067f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/2/m = #3084 */
    { 0x0600, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/2/u = #3085 */
    { 0x077f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/3/m = #3086 */
    { 0x0700, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/1/3/u = #3087 */
    { 0x087f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/0/m = #3088 */
    { 0x0800, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/0/u = #3089 */
    { 0x097f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/1/m = #3090 */
    { 0x0900, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/1/u = #3091 */
    { 0x0a7f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/2/m = #3092 */
    { 0x0a00, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/2/u = #3093 */
    { 0x0b7f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/3/m = #3094 */
    { 0x0b00, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/2/3/u = #3095 */
    { 0x0c7f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/0/m = #3096 */
    { 0x0c00, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/0/u = #3097 */
    { 0x0d7f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/1/m = #3098 */
    { 0x0d00, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/1/u = #3099 */
    { 0x0e7f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/2/m = #3100 */
    { 0x0e00, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/2/u = #3101 */
    { 0x0f7f, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/3/m = #3102 */
    { 0x0f00, 0x4223, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #96/3/3/u = #3103 */
    { 0x007f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/0/m = #3104 */
    { 0x0000, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/0/u = #3105 */
    { 0x017f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/1/m = #3106 */
    { 0x0100, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/1/u = #3107 */
    { 0x027f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/2/m = #3108 */
    { 0x0200, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/2/u = #3109 */
    { 0x037f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/3/m = #3110 */
    { 0x0300, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/0/3/u = #3111 */
    { 0x047f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/0/m = #3112 */
    { 0x0400, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/0/u = #3113 */
    { 0x057f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/1/m = #3114 */
    { 0x0500, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/1/u = #3115 */
    { 0x067f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/2/m = #3116 */
    { 0x0600, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/2/u = #3117 */
    { 0x077f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/3/m = #3118 */
    { 0x0700, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/1/3/u = #3119 */
    { 0x087f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/0/m = #3120 */
    { 0x0800, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/0/u = #3121 */
    { 0x097f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/1/m = #3122 */
    { 0x0900, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/1/u = #3123 */
    { 0x0a7f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/2/m = #3124 */
    { 0x0a00, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/2/u = #3125 */
    { 0x0b7f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/3/m = #3126 */
    { 0x0b00, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/2/3/u = #3127 */
    { 0x0c7f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/0/m = #3128 */
    { 0x0c00, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/0/u = #3129 */
    { 0x0d7f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/1/m = #3130 */
    { 0x0d00, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/1/u = #3131 */
    { 0x0e7f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/2/m = #3132 */
    { 0x0e00, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/2/u = #3133 */
    { 0x0f7f, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/3/m = #3134 */
    { 0x0f00, 0x3b42, 0x3900, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0x8000000000000000,16382) }, /* #97/3/3/u = #3135 */
    { 0x007f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/0/m = #3136 */
    { 0x0000, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/0/u = #3137 */
    { 0x017f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/1/m = #3138 */
    { 0x0100, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/1/u = #3139 */
    { 0x027f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/2/m = #3140 */
    { 0x0200, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/2/u = #3141 */
    { 0x037f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/3/m = #3142 */
    { 0x0300, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/0/3/u = #3143 */
    { 0x047f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/0/m = #3144 */
    { 0x0400, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/0/u = #3145 */
    { 0x057f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/1/m = #3146 */
    { 0x0500, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/1/u = #3147 */
    { 0x067f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/2/m = #3148 */
    { 0x0600, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/2/u = #3149 */
    { 0x077f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/3/m = #3150 */
    { 0x0700, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/1/3/u = #3151 */
    { 0x087f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/0/m = #3152 */
    { 0x0800, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/0/u = #3153 */
    { 0x097f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/1/m = #3154 */
    { 0x0900, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/1/u = #3155 */
    { 0x0a7f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/2/m = #3156 */
    { 0x0a00, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/2/u = #3157 */
    { 0x0b7f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/3/m = #3158 */
    { 0x0b00, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/2/3/u = #3159 */
    { 0x0c7f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/0/m = #3160 */
    { 0x0c00, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/0/u = #3161 */
    { 0x0d7f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/1/m = #3162 */
    { 0x0d00, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/1/u = #3163 */
    { 0x0e7f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/2/m = #3164 */
    { 0x0e00, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/2/u = #3165 */
    { 0x0f7f, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/3/m = #3166 */
    { 0x0f00, 0x7949, 0x7900, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #98/3/3/u = #3167 */
    { 0x007f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/0/m = #3168 */
    { 0x0000, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/0/u = #3169 */
    { 0x017f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/1/m = #3170 */
    { 0x0100, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/1/u = #3171 */
    { 0x027f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/2/m = #3172 */
    { 0x0200, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/2/u = #3173 */
    { 0x037f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/3/m = #3174 */
    { 0x0300, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/0/3/u = #3175 */
    { 0x047f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/0/m = #3176 */
    { 0x0400, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/0/u = #3177 */
    { 0x057f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/1/m = #3178 */
    { 0x0500, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/1/u = #3179 */
    { 0x067f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/2/m = #3180 */
    { 0x0600, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/2/u = #3181 */
    { 0x077f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/3/m = #3182 */
    { 0x0700, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/1/3/u = #3183 */
    { 0x087f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/0/m = #3184 */
    { 0x0800, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/0/u = #3185 */
    { 0x097f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/1/m = #3186 */
    { 0x0900, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/1/u = #3187 */
    { 0x0a7f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/2/m = #3188 */
    { 0x0a00, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/2/u = #3189 */
    { 0x0b7f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/3/m = #3190 */
    { 0x0b00, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/2/3/u = #3191 */
    { 0x0c7f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/0/m = #3192 */
    { 0x0c00, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/0/u = #3193 */
    { 0x0d7f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/1/m = #3194 */
    { 0x0d00, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/1/u = #3195 */
    { 0x0e7f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/2/m = #3196 */
    { 0x0e00, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/2/u = #3197 */
    { 0x0f7f, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/3/m = #3198 */
    { 0x0f00, 0x963d, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #99/3/3/u = #3199 */
    { 0x007f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/0/m = #3200 */
    { 0x0000, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/0/u = #3201 */
    { 0x017f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/1/m = #3202 */
    { 0x0100, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/1/u = #3203 */
    { 0x027f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/2/m = #3204 */
    { 0x0200, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/2/u = #3205 */
    { 0x037f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/3/m = #3206 */
    { 0x0300, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/0/3/u = #3207 */
    { 0x047f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/0/m = #3208 */
    { 0x0400, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/0/u = #3209 */
    { 0x057f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/1/m = #3210 */
    { 0x0500, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/1/u = #3211 */
    { 0x067f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/2/m = #3212 */
    { 0x0600, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/2/u = #3213 */
    { 0x077f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/3/m = #3214 */
    { 0x0700, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/1/3/u = #3215 */
    { 0x087f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/0/m = #3216 */
    { 0x0800, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/0/u = #3217 */
    { 0x097f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/1/m = #3218 */
    { 0x0900, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/1/u = #3219 */
    { 0x0a7f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/2/m = #3220 */
    { 0x0a00, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/2/u = #3221 */
    { 0x0b7f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/3/m = #3222 */
    { 0x0b00, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/2/3/u = #3223 */
    { 0x0c7f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/0/m = #3224 */
    { 0x0c00, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/0/u = #3225 */
    { 0x0d7f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/1/m = #3226 */
    { 0x0d00, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/1/u = #3227 */
    { 0x0e7f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/2/m = #3228 */
    { 0x0e00, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/2/u = #3229 */
    { 0x0f7f, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/3/m = #3230 */
    { 0x0f00, 0x6a67, 0x7800, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #100/3/3/u = #3231 */
    { 0x007f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/0/m = #3232 */
    { 0x0000, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/0/u = #3233 */
    { 0x017f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/1/m = #3234 */
    { 0x0100, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/1/u = #3235 */
    { 0x027f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/2/m = #3236 */
    { 0x0200, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/2/u = #3237 */
    { 0x037f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/3/m = #3238 */
    { 0x0300, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/0/3/u = #3239 */
    { 0x047f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/0/m = #3240 */
    { 0x0400, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/0/u = #3241 */
    { 0x057f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/1/m = #3242 */
    { 0x0500, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/1/u = #3243 */
    { 0x067f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/2/m = #3244 */
    { 0x0600, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/2/u = #3245 */
    { 0x077f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/3/m = #3246 */
    { 0x0700, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/1/3/u = #3247 */
    { 0x087f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/0/m = #3248 */
    { 0x0800, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/0/u = #3249 */
    { 0x097f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/1/m = #3250 */
    { 0x0900, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/1/u = #3251 */
    { 0x0a7f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/2/m = #3252 */
    { 0x0a00, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/2/u = #3253 */
    { 0x0b7f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/3/m = #3254 */
    { 0x0b00, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/2/3/u = #3255 */
    { 0x0c7f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/0/m = #3256 */
    { 0x0c00, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/0/u = #3257 */
    { 0x0d7f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/1/m = #3258 */
    { 0x0d00, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/1/u = #3259 */
    { 0x0e7f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/2/m = #3260 */
    { 0x0e00, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/2/u = #3261 */
    { 0x0f7f, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/3/m = #3262 */
    { 0x0f00, 0x5c6f, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #101/3/3/u = #3263 */
    { 0x007f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/0/m = #3264 */
    { 0x0000, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/0/u = #3265 */
    { 0x017f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/1/m = #3266 */
    { 0x0100, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/1/u = #3267 */
    { 0x027f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/2/m = #3268 */
    { 0x0200, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/2/u = #3269 */
    { 0x037f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/3/m = #3270 */
    { 0x0300, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/0/3/u = #3271 */
    { 0x047f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/0/m = #3272 */
    { 0x0400, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/0/u = #3273 */
    { 0x057f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/1/m = #3274 */
    { 0x0500, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/1/u = #3275 */
    { 0x067f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/2/m = #3276 */
    { 0x0600, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/2/u = #3277 */
    { 0x077f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/3/m = #3278 */
    { 0x0700, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/1/3/u = #3279 */
    { 0x087f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/0/m = #3280 */
    { 0x0800, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/0/u = #3281 */
    { 0x097f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/1/m = #3282 */
    { 0x0900, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/1/u = #3283 */
    { 0x0a7f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/2/m = #3284 */
    { 0x0a00, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/2/u = #3285 */
    { 0x0b7f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/3/m = #3286 */
    { 0x0b00, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/2/3/u = #3287 */
    { 0x0c7f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/0/m = #3288 */
    { 0x0c00, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/0/u = #3289 */
    { 0x0d7f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/1/m = #3290 */
    { 0x0d00, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/1/u = #3291 */
    { 0x0e7f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/2/m = #3292 */
    { 0x0e00, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/2/u = #3293 */
    { 0x0f7f, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/3/m = #3294 */
    { 0x0f00, 0xfe0c, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #102/3/3/u = #3295 */
    { 0x007f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/0/m = #3296 */
    { 0x0000, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/0/u = #3297 */
    { 0x017f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/1/m = #3298 */
    { 0x0100, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/1/u = #3299 */
    { 0x027f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/2/m = #3300 */
    { 0x0200, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/2/u = #3301 */
    { 0x037f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/3/m = #3302 */
    { 0x0300, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/0/3/u = #3303 */
    { 0x047f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/0/m = #3304 */
    { 0x0400, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/0/u = #3305 */
    { 0x057f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/1/m = #3306 */
    { 0x0500, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/1/u = #3307 */
    { 0x067f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/2/m = #3308 */
    { 0x0600, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/2/u = #3309 */
    { 0x077f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/3/m = #3310 */
    { 0x0700, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/1/3/u = #3311 */
    { 0x087f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/0/m = #3312 */
    { 0x0800, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/0/u = #3313 */
    { 0x097f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/1/m = #3314 */
    { 0x0900, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/1/u = #3315 */
    { 0x0a7f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/2/m = #3316 */
    { 0x0a00, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/2/u = #3317 */
    { 0x0b7f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/3/m = #3318 */
    { 0x0b00, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/2/3/u = #3319 */
    { 0x0c7f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/0/m = #3320 */
    { 0x0c00, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/0/u = #3321 */
    { 0x0d7f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/1/m = #3322 */
    { 0x0d00, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/1/u = #3323 */
    { 0x0e7f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/2/m = #3324 */
    { 0x0e00, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/2/u = #3325 */
    { 0x0f7f, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/3/m = #3326 */
    { 0x0f00, 0xfbad, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #103/3/3/u = #3327 */
    { 0x007f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/0/m = #3328 */
    { 0x0000, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/0/u = #3329 */
    { 0x017f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/1/m = #3330 */
    { 0x0100, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/1/u = #3331 */
    { 0x027f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/2/m = #3332 */
    { 0x0200, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/2/u = #3333 */
    { 0x037f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/3/m = #3334 */
    { 0x0300, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/0/3/u = #3335 */
    { 0x047f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/0/m = #3336 */
    { 0x0400, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/0/u = #3337 */
    { 0x057f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/1/m = #3338 */
    { 0x0500, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/1/u = #3339 */
    { 0x067f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/2/m = #3340 */
    { 0x0600, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/2/u = #3341 */
    { 0x077f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/3/m = #3342 */
    { 0x0700, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/1/3/u = #3343 */
    { 0x087f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/0/m = #3344 */
    { 0x0800, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/0/u = #3345 */
    { 0x097f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/1/m = #3346 */
    { 0x0900, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/1/u = #3347 */
    { 0x0a7f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/2/m = #3348 */
    { 0x0a00, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/2/u = #3349 */
    { 0x0b7f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/3/m = #3350 */
    { 0x0b00, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/2/3/u = #3351 */
    { 0x0c7f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/0/m = #3352 */
    { 0x0c00, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/0/u = #3353 */
    { 0x0d7f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/1/m = #3354 */
    { 0x0d00, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/1/u = #3355 */
    { 0x0e7f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/2/m = #3356 */
    { 0x0e00, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/2/u = #3357 */
    { 0x0f7f, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/3/m = #3358 */
    { 0x0f00, 0x566f, 0x7c00, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #104/3/3/u = #3359 */
    { 0x007f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/0/m = #3360 */
    { 0x0000, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/0/u = #3361 */
    { 0x017f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/1/m = #3362 */
    { 0x0100, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/1/u = #3363 */
    { 0x027f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/2/m = #3364 */
    { 0x0200, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/2/u = #3365 */
    { 0x037f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/3/m = #3366 */
    { 0x0300, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/0/3/u = #3367 */
    { 0x047f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/0/m = #3368 */
    { 0x0400, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/0/u = #3369 */
    { 0x057f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/1/m = #3370 */
    { 0x0500, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/1/u = #3371 */
    { 0x067f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/2/m = #3372 */
    { 0x0600, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/2/u = #3373 */
    { 0x077f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/3/m = #3374 */
    { 0x0700, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/1/3/u = #3375 */
    { 0x087f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/0/m = #3376 */
    { 0x0800, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/0/u = #3377 */
    { 0x097f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/1/m = #3378 */
    { 0x0900, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/1/u = #3379 */
    { 0x0a7f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/2/m = #3380 */
    { 0x0a00, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/2/u = #3381 */
    { 0x0b7f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/3/m = #3382 */
    { 0x0b00, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/2/3/u = #3383 */
    { 0x0c7f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/0/m = #3384 */
    { 0x0c00, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/0/u = #3385 */
    { 0x0d7f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/1/m = #3386 */
    { 0x0d00, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/1/u = #3387 */
    { 0x0e7f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/2/m = #3388 */
    { 0x0e00, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/2/u = #3389 */
    { 0x0f7f, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/3/m = #3390 */
    { 0x0f00, 0xaa93, 0x3800, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #105/3/3/u = #3391 */
};
uint32_t const g_cTests_fchs_r80 = RT_ELEMENTS(g_aTests_fchs_r80);

FPU_UNARY_R80_TEST_T const g_aTests_fsqrt_r80[] =
{
    { 0x007f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/0/m = #0 */
    { 0x0000, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/0/0/u = #1 */
    { 0x0001, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/0/0x1 = #2 */
    { 0x017f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/1/m = #3 */
    { 0x0100, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/0/1/u = #4 */
    { 0x0101, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/1/0x1 = #5 */
    { 0x027f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/2/m = #6 */
    { 0x0200, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/0/2/u = #7 */
    { 0x0201, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/2/0x1 = #8 */
    { 0x037f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/3/m = #9 */
    { 0x0300, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/0/3/u = #10 */
    { 0x0301, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/0/3/0x1 = #11 */
    { 0x047f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/0/m = #12 */
    { 0x0400, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/1/0/u = #13 */
    { 0x0401, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/0/0x1 = #14 */
    { 0x057f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/1/m = #15 */
    { 0x0500, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/1/1/u = #16 */
    { 0x0501, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/1/0x1 = #17 */
    { 0x067f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/2/m = #18 */
    { 0x0600, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/1/2/u = #19 */
    { 0x0601, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/2/0x1 = #20 */
    { 0x077f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/3/m = #21 */
    { 0x0700, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/1/3/u = #22 */
    { 0x0701, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/1/3/0x1 = #23 */
    { 0x087f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/0/m = #24 */
    { 0x0800, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/2/0/u = #25 */
    { 0x0801, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/0/0x1 = #26 */
    { 0x097f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/1/m = #27 */
    { 0x0900, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/2/1/u = #28 */
    { 0x0901, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/1/0x1 = #29 */
    { 0x0a7f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/2/m = #30 */
    { 0x0a00, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/2/2/u = #31 */
    { 0x0a01, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/2/0x1 = #32 */
    { 0x0b7f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/3/m = #33 */
    { 0x0b00, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/2/3/u = #34 */
    { 0x0b01, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/2/3/0x1 = #35 */
    { 0x0c7f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/0/m = #36 */
    { 0x0c00, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/3/0/u = #37 */
    { 0x0c01, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/0/0x1 = #38 */
    { 0x0d7f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/1/m = #39 */
    { 0x0d00, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/3/1/u = #40 */
    { 0x0d01, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/1/0x1 = #41 */
    { 0x0e7f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/2/m = #42 */
    { 0x0e00, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/3/2/u = #43 */
    { 0x0e01, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/2/0x1 = #44 */
    { 0x0f7f, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/3/m = #45 */
    { 0x0f00, 0x3bf2, 0xb981, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022) }, /* #0/3/3/u = #46 */
    { 0x0f01, 0x3bf2, 0x3901, RTFLOAT80U_INIT_C(1,0xf4e03a30a2ee6fc9,22022), RTFLOAT80U_INIT_IND(1) }, /* #0/3/3/0x1 = #47 */
    { 0x007f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31640000000000,23624) }, /* #1/0/0/m = #48 */
    { 0x0000, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31640000000000,23624) }, /* #1/0/0/u = #49 */
    { 0x0020, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31640000000000,23624) }, /* #1/0/0/0x20 = #50 */
    { 0x017f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/0/1/m = #51 */
    { 0x0100, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/0/1/u = #52 */
    { 0x0120, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/0/1/0x20 = #53 */
    { 0x027f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2382000,23624) }, /* #1/0/2/m = #54 */
    { 0x0200, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2382000,23624) }, /* #1/0/2/u = #55 */
    { 0x0220, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2382000,23624) }, /* #1/0/2/0x20 = #56 */
    { 0x037f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/0/3/m = #57 */
    { 0x0300, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/0/3/u = #58 */
    { 0x0320, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/0/3/0x20 = #59 */
    { 0x047f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31630000000000,23624) }, /* #1/1/0/m = #60 */
    { 0x0400, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31630000000000,23624) }, /* #1/1/0/u = #61 */
    { 0x0420, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31630000000000,23624) }, /* #1/1/0/0x20 = #62 */
    { 0x057f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/1/1/m = #63 */
    { 0x0500, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/1/1/u = #64 */
    { 0x0520, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/1/1/0x20 = #65 */
    { 0x067f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381800,23624) }, /* #1/1/2/m = #66 */
    { 0x0600, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381800,23624) }, /* #1/1/2/u = #67 */
    { 0x0620, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381800,23624) }, /* #1/1/2/0x20 = #68 */
    { 0x077f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/1/3/m = #69 */
    { 0x0700, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/1/3/u = #70 */
    { 0x0720, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/1/3/0x20 = #71 */
    { 0x087f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31640000000000,23624) }, /* #1/2/0/m = #72 */
    { 0x0800, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31640000000000,23624) }, /* #1/2/0/u = #73 */
    { 0x0820, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31640000000000,23624) }, /* #1/2/0/0x20 = #74 */
    { 0x097f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/2/1/m = #75 */
    { 0x0900, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/2/1/u = #76 */
    { 0x0920, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/2/1/0x20 = #77 */
    { 0x0a7f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2382000,23624) }, /* #1/2/2/m = #78 */
    { 0x0a00, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2382000,23624) }, /* #1/2/2/u = #79 */
    { 0x0a20, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2382000,23624) }, /* #1/2/2/0x20 = #80 */
    { 0x0b7f, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/2/3/m = #81 */
    { 0x0b00, 0x1482, 0xbea0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/2/3/u = #82 */
    { 0x0b20, 0x1482, 0x3e20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ecf,23624) }, /* #1/2/3/0x20 = #83 */
    { 0x0c7f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31630000000000,23624) }, /* #1/3/0/m = #84 */
    { 0x0c00, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31630000000000,23624) }, /* #1/3/0/u = #85 */
    { 0x0c20, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b31630000000000,23624) }, /* #1/3/0/0x20 = #86 */
    { 0x0d7f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/3/1/m = #87 */
    { 0x0d00, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/3/1/u = #88 */
    { 0x0d20, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/3/1/0x20 = #89 */
    { 0x0e7f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381800,23624) }, /* #1/3/2/m = #90 */
    { 0x0e00, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381800,23624) }, /* #1/3/2/u = #91 */
    { 0x0e20, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381800,23624) }, /* #1/3/2/0x20 = #92 */
    { 0x0f7f, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/3/3/m = #93 */
    { 0x0f00, 0x1482, 0xbca0, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/3/3/u = #94 */
    { 0x0f20, 0x1482, 0x3c20, RTFLOAT80U_INIT_C(0,0x975d579af4487fb9,30865), RTFLOAT80U_INIT_C(0,0x8b3163b4a2381ece,23624) }, /* #1/3/3/0x20 = #95 */
    { 0x007f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/0/m = #96 */
    { 0x0000, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/0/u = #97 */
    { 0x0001, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/0/0x1 = #98 */
    { 0x017f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/1/m = #99 */
    { 0x0100, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/1/u = #100 */
    { 0x0101, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/1/0x1 = #101 */
    { 0x027f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/2/m = #102 */
    { 0x0200, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/2/u = #103 */
    { 0x0201, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/2/0x1 = #104 */
    { 0x037f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/3/m = #105 */
    { 0x0300, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/3/u = #106 */
    { 0x0301, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/0/3/0x1 = #107 */
    { 0x047f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/0/m = #108 */
    { 0x0400, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/0/u = #109 */
    { 0x0401, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/0/0x1 = #110 */
    { 0x057f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/1/m = #111 */
    { 0x0500, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/1/u = #112 */
    { 0x0501, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/1/0x1 = #113 */
    { 0x067f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/2/m = #114 */
    { 0x0600, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/2/u = #115 */
    { 0x0601, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/2/0x1 = #116 */
    { 0x077f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/3/m = #117 */
    { 0x0700, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/3/u = #118 */
    { 0x0701, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/1/3/0x1 = #119 */
    { 0x087f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/0/m = #120 */
    { 0x0800, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/0/u = #121 */
    { 0x0801, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/0/0x1 = #122 */
    { 0x097f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/1/m = #123 */
    { 0x0900, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/1/u = #124 */
    { 0x0901, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/1/0x1 = #125 */
    { 0x0a7f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/2/m = #126 */
    { 0x0a00, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/2/u = #127 */
    { 0x0a01, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/2/0x1 = #128 */
    { 0x0b7f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/3/m = #129 */
    { 0x0b00, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/3/u = #130 */
    { 0x0b01, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/2/3/0x1 = #131 */
    { 0x0c7f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/0/m = #132 */
    { 0x0c00, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/0/u = #133 */
    { 0x0c01, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/0/0x1 = #134 */
    { 0x0d7f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/1/m = #135 */
    { 0x0d00, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/1/u = #136 */
    { 0x0d01, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/1/0x1 = #137 */
    { 0x0e7f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/2/m = #138 */
    { 0x0e00, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/2/u = #139 */
    { 0x0e01, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/2/0x1 = #140 */
    { 0x0f7f, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/3/m = #141 */
    { 0x0f00, 0xb994, 0xb981, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/3/u = #142 */
    { 0x0f01, 0xb994, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #2/3/3/0x1 = #143 */
    { 0x007f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/0/m = #144 */
    { 0x0000, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/0/0/u = #145 */
    { 0x0001, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/0/0x1 = #146 */
    { 0x017f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/1/m = #147 */
    { 0x0100, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/0/1/u = #148 */
    { 0x0101, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/1/0x1 = #149 */
    { 0x027f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/2/m = #150 */
    { 0x0200, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/0/2/u = #151 */
    { 0x0201, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/2/0x1 = #152 */
    { 0x037f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/3/m = #153 */
    { 0x0300, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/0/3/u = #154 */
    { 0x0301, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/0/3/0x1 = #155 */
    { 0x047f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/0/m = #156 */
    { 0x0400, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/1/0/u = #157 */
    { 0x0401, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/0/0x1 = #158 */
    { 0x057f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/1/m = #159 */
    { 0x0500, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/1/1/u = #160 */
    { 0x0501, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/1/0x1 = #161 */
    { 0x067f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/2/m = #162 */
    { 0x0600, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/1/2/u = #163 */
    { 0x0601, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/2/0x1 = #164 */
    { 0x077f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/3/m = #165 */
    { 0x0700, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/1/3/u = #166 */
    { 0x0701, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/1/3/0x1 = #167 */
    { 0x087f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/0/m = #168 */
    { 0x0800, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/2/0/u = #169 */
    { 0x0801, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/0/0x1 = #170 */
    { 0x097f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/1/m = #171 */
    { 0x0900, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/2/1/u = #172 */
    { 0x0901, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/1/0x1 = #173 */
    { 0x0a7f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/2/m = #174 */
    { 0x0a00, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/2/2/u = #175 */
    { 0x0a01, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/2/0x1 = #176 */
    { 0x0b7f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/3/m = #177 */
    { 0x0b00, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/2/3/u = #178 */
    { 0x0b01, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/2/3/0x1 = #179 */
    { 0x0c7f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/0/m = #180 */
    { 0x0c00, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/3/0/u = #181 */
    { 0x0c01, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/0/0x1 = #182 */
    { 0x0d7f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/1/m = #183 */
    { 0x0d00, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/3/1/u = #184 */
    { 0x0d01, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/1/0x1 = #185 */
    { 0x0e7f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/2/m = #186 */
    { 0x0e00, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/3/2/u = #187 */
    { 0x0e01, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/2/0x1 = #188 */
    { 0x0f7f, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/3/m = #189 */
    { 0x0f00, 0x4bc7, 0xf981, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162) }, /* #3/3/3/u = #190 */
    { 0x0f01, 0x4bc7, 0x7901, RTFLOAT80U_INIT_C(1,0x1bedbb99faba0,162), RTFLOAT80U_INIT_IND(1) }, /* #3/3/3/0x1 = #191 */
    { 0x007f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/0/m = #192 */
    { 0x0000, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/0/0/u = #193 */
    { 0x0001, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/0/0x1 = #194 */
    { 0x017f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/1/m = #195 */
    { 0x0100, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/0/1/u = #196 */
    { 0x0101, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/1/0x1 = #197 */
    { 0x027f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/2/m = #198 */
    { 0x0200, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/0/2/u = #199 */
    { 0x0201, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/2/0x1 = #200 */
    { 0x037f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/3/m = #201 */
    { 0x0300, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/0/3/u = #202 */
    { 0x0301, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/0/3/0x1 = #203 */
    { 0x047f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/0/m = #204 */
    { 0x0400, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/1/0/u = #205 */
    { 0x0401, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/0/0x1 = #206 */
    { 0x057f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/1/m = #207 */
    { 0x0500, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/1/1/u = #208 */
    { 0x0501, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/1/0x1 = #209 */
    { 0x067f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/2/m = #210 */
    { 0x0600, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/1/2/u = #211 */
    { 0x0601, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/2/0x1 = #212 */
    { 0x077f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/3/m = #213 */
    { 0x0700, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/1/3/u = #214 */
    { 0x0701, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/1/3/0x1 = #215 */
    { 0x087f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/2/0/m = #216 */
    { 0x0800, 0x99c5, 0xb981, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536) }, /* #4/2/0/u = #217 */
    { 0x0801, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f43,21536), RTFLOAT80U_INIT_IND(1) }, /* #4/2/0/0x1 = #218 */
    { 0x097f, 0x99c5, 0x3901, RTFLOAT80U_INIT_C(0,0x5a2125a1e8db4f