/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.UnknownDatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.registry.BasePluginRegistry;
import schemacrawler.tools.registry.PluginCommandRegistry;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public final class DatabaseConnectorRegistry
extends BasePluginRegistry
implements PluginCommandRegistry {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnectorRegistry.class.getName());
    private static DatabaseConnectorRegistry databaseConnectorRegistrySingleton;
    private final Map<String, DatabaseConnector> databaseConnectorRegistry = DatabaseConnectorRegistry.loadDatabaseConnectorRegistry();

    public static DatabaseConnectorRegistry getDatabaseConnectorRegistry() {
        if (databaseConnectorRegistrySingleton == null) {
            databaseConnectorRegistrySingleton = new DatabaseConnectorRegistry();
            databaseConnectorRegistrySingleton.log();
        }
        return databaseConnectorRegistrySingleton;
    }

    private static Map<String, DatabaseConnector> loadDatabaseConnectorRegistry() {
        ConcurrentHashMap<String, DatabaseConnector> databaseConnectorRegistry = new ConcurrentHashMap<String, DatabaseConnector>();
        try {
            ServiceLoader<DatabaseConnector> serviceLoader = ServiceLoader.load(DatabaseConnector.class, DatabaseConnectorRegistry.class.getClassLoader());
            for (DatabaseConnector databaseConnector : serviceLoader) {
                String databaseSystemIdentifier = databaseConnector.getDatabaseServerType().getDatabaseSystemIdentifier();
                LOGGER.log(Level.CONFIG, new StringFormat("Loading database connector, %s=%s", databaseSystemIdentifier, databaseConnector.getClass().getName()));
                databaseConnectorRegistry.put(databaseSystemIdentifier, databaseConnector);
            }
        }
        catch (Throwable e) {
            throw new InternalRuntimeException("Could not load database connector registry", e);
        }
        LOGGER.log(Level.CONFIG, new StringFormat("Loaded %d database connectors", databaseConnectorRegistry.size()));
        return databaseConnectorRegistry;
    }

    private DatabaseConnectorRegistry() {
    }

    public DatabaseConnector findDatabaseConnector(Connection connection) {
        try {
            DatabaseUtility.checkConnection(connection);
            String url = connection.getMetaData().getURL();
            return this.findDatabaseConnectorFromUrl(url);
        }
        catch (SQLException e) {
            return UnknownDatabaseConnector.UNKNOWN;
        }
    }

    public DatabaseConnector findDatabaseConnectorFromDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        if (this.hasDatabaseSystemIdentifier(databaseSystemIdentifier)) {
            return this.databaseConnectorRegistry.get(databaseSystemIdentifier);
        }
        return UnknownDatabaseConnector.UNKNOWN;
    }

    public DatabaseConnector findDatabaseConnectorFromUrl(String url) {
        if (Utility.isBlank(url)) {
            return UnknownDatabaseConnector.UNKNOWN;
        }
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            if (!databaseConnector.supportsUrl(url)) continue;
            return databaseConnector;
        }
        return UnknownDatabaseConnector.UNKNOWN;
    }

    @Override
    public Collection<PluginCommand> getHelpCommands() {
        ArrayList<PluginCommand> commandLineHelpCommands = new ArrayList<PluginCommand>();
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            commandLineHelpCommands.add(databaseConnector.getHelpCommand());
        }
        return commandLineHelpCommands;
    }

    public boolean hasDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        return this.databaseConnectorRegistry.containsKey(databaseSystemIdentifier);
    }

    @Override
    public Collection<PropertyName> getRegisteredPlugins() {
        ArrayList<PropertyName> availableServers = new ArrayList<PropertyName>();
        for (DatabaseServerType serverType : this.getDatabaseServerTypes()) {
            PropertyName serverDescription = new PropertyName(serverType.getDatabaseSystemIdentifier(), serverType.getDatabaseSystemName());
            availableServers.add(serverDescription);
        }
        Collections.sort(availableServers);
        return availableServers;
    }

    public List<DatabaseServerType> getDatabaseServerTypes() {
        ArrayList<DatabaseServerType> databaseServerTypes = new ArrayList<DatabaseServerType>();
        for (DatabaseConnector databaseConnector : this.databaseConnectorRegistry.values()) {
            databaseServerTypes.add(databaseConnector.getDatabaseServerType());
        }
        databaseServerTypes.sort(Comparator.naturalOrder());
        return databaseServerTypes;
    }

    @Override
    public String getName() {
        return "SchemaCrawler Database Server Plugins";
    }
}

