/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.sqlserver;

import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.database.SqlScript;
import us.fatehi.utility.string.StringFormat;

public final class SqlServerConnectionInitializer
implements Consumer<Connection> {
    private static final Logger LOGGER = Logger.getLogger(SqlServerConnectionInitializer.class.getName());

    @Override
    public void accept(Connection connection) {
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Initializing SQL Server connection <%s>", new Object[]{connection}));
        SqlScript.executeScriptFromResource((String)"/initialize-all-routines.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-triggers.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-views.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-view-table-usage.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-table-constraints.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-check-constraints.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-constraint-column-usage.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-sequences.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-synonyms.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-additional-column-attributes.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-additional-table-attributes.sql", (String)"@", (Connection)connection);
        SqlScript.executeScriptFromResource((String)"/initialize-all-database-users.sql", (String)"@", (Connection)connection);
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Initialized SQL Server connection <%s>", new Object[]{connection}));
    }
}

