/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.HttpBufferedInputStream;
import com.informix.asf.HttpBufferedOutputStream;
import com.informix.asf.HttpConnection;
import com.informix.asf.IfxASFException;
import com.informix.asf.IfxASFRemoteException;
import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.asf.IfxDebugDataInputStream;
import com.informix.asf.IfxDebugDataOutputStream;
import com.informix.asf.JnsObject;
import com.informix.asf.SqliDbg;
import com.informix.jdbc.IfxDriver;
import com.informix.jns.ServerGroup;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.AdvancedUppercaseProperties;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class Connection {
    private static final Object logger = Trace.getLoggerForClass(Connection.class);
    private static final short SQ_DONE = 15;
    private static final short SQ_COST = 55;
    private static final short SQ_EXIT = 56;
    private static final short SQ_EOT = 12;
    private static final short SQ_ERR = 13;
    private static final short SQ_VERSION_REQ = 203;
    private static final short SQ_VERSION_REPLY = 204;
    private static final short SQ_XACTSTAT = 99;
    private static final short SQ_ASSOC = 100;
    private static final short SQ_ASCBINARY = 101;
    private static final short SQ_ASCINITRESP = 102;
    private static final short SQ_ASCDBLIST = 103;
    private static final short SQ_ASCINITREQ = 104;
    private static final short SQ_ASCENV = 106;
    private static final short SQ_ASCPINFO = 107;
    private static final short SQ_ASCBPARMS = 108;
    private static final short SQ_ASCMISC_60 = 116;
    private String AppName = "";
    private static final short SQ_ASSOCBIND = 110;
    private static final short SQ_ASSOCRESP = 111;
    private static final short SQ_ASCEOT = 127;
    private static final short PF_PROT_SQLI_0600 = 60;
    private static final short PF_PROT_SQLI_WITH_CSS = 61;
    private static final short SL_PROT_SQLI_0600 = 60;
    private static final short UTYPE_INTERNET = 1;
    private static final short NET_LEV_1 = 1;
    private static final short ASF_XCONNECT = 11;
    private static final int ASF_AMBIG_SEOL = 3;
    private static final int ASF_GRPREF = 0x2000000;
    private static final short SLTYPE_CONREQ = 1;
    private static final short SLTYPE_CONACC = 2;
    private static final short SLTYPE_CONREJ = 3;
    private static final short SLTYPE_REDIRECT = 13;
    private static final int ASF_TRUSTCTXT = 0x4000000;
    private static final short ASSOCBIND_ACCEPT = 0;
    private static final short ASSOCBIND_REJECT = 1;
    private static final short ASCII_SP = 32;
    private static final short ASCII_EQ = 61;
    private static final int MAX_BUFF_SIZE = 32768;
    private static final int MIN_BUFF_SIZE = 140;
    private static final int STREAM_BUF_SIZE = 4096;
    private static final int PFCONREQ_BUF_SIZE = 2048;
    private static final int SL_HEADER_SIZE = 6;
    private static final short FORMAT1_50RSP = 1;
    private static final short FORMAT4_50RSP = 4;
    private static final String applType = "sqlexec\u0000\u0000\u0000\u0000\u0000";
    private static final String applID = "sqli";
    private static final String PROT_SQLIOL = "ol\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final String NET_TLITCP = "tlitcp\u0000\u0000";
    private static final String floatType = "IEEEM";
    boolean fInProcessReq = false;
    private String proxy = null;
    private String redSrvDetail = null;
    private String dbEnc = null;
    private IfxToJavaType ifxtojava = new IfxToJavaType();
    private int conTime = 0;
    private final boolean SSLconnection;
    private final boolean sslCertificateVerification;
    private String[] sslProtocols = null;
    private Socket asfSocket = null;
    private InputStream asfSocketIs = null;
    private OutputStream asfSocketOs = null;
    private FilterInputStream asfBufIs = null;
    private FilterOutputStream asfBufOs = null;
    private IfxDataInputStream asfIfxIs = null;
    private IfxDataOutputStream asfIfxOs = null;
    private String sqliFile;
    public SqliDbg sqliTrace = null;
    private int response50format = 0;
    private boolean usingProxy = false;
    private boolean proxyLookup = false;
    private final String ClientLocale;
    private String username;
    public String VersionNumber;
    public String SerialNumber;
    public String ApplidName;
    public int Cap_1;
    public int Cap_2;
    public int Cap_3;
    public short Warnings = 0;
    private short svcError;
    private short osError;
    private String errMsg = "";
    private int retryCount = 0;
    private String ipAddr = null;
    private String portNo = null;
    private int PortNumber = 0;
    private ServerGroup myGroup = null;
    private boolean sqlhGroup = false;
    private boolean isTrustedContext = false;
    private final AdvancedUppercaseProperties optProps;
    private String servername = "";
    private int socTimeout = 0;
    private boolean socKeepAlive = false;
    private boolean encoption = false;
    private final int loginTimeOut;
    private final Trace trace;
    private final AdvancedUppercaseProperties userProperties;

    public Connection(String username, String password, String addr, String servername, String dbname, AdvancedUppercaseProperties envlist, int capabilities, int retryCount, AdvancedUppercaseProperties optProps, Trace trace, AdvancedUppercaseProperties userProperties) throws IfxASFException {
        this.userProperties = userProperties;
        this.optProps = optProps;
        this.retryCount = retryCount;
        this.trace = trace;
        this.encoption = optProps.asBool("IFX_USE_STRENC", "false");
        this.isTrustedContext = optProps.asBool("TRUSTED_CONTEXT", "false");
        this.SSLconnection = optProps.asBool("SSLCONNECTION", "false");
        this.sslCertificateVerification = optProps.asBool("SSLCERTIFICATEVERIFICATION", "true");
        String javaVersion = System.getProperty("java.version");
        this.sslProtocols = javaVersion.startsWith("11.") ? optProps.getProperty("SSL_PROTOCOLS", "TLSv1.3,TLSv1.2,TLSv1.1,TLSv1").split(",") : optProps.getProperty("SSL_PROTOCOLS", "TLSv1.2,TLSv1.1,TLSv1").split(",");
        for (int i = 0; i < this.sslProtocols.length; ++i) {
            this.sslProtocols[i] = this.sslProtocols[i].trim();
        }
        this.loginTimeOut = optProps.asInt("LOGINTIMEOUT", "0");
        this.ClientLocale = envlist.getProperty("CLIENT_LOCALE");
        this.socTimeout = optProps.asInt("IFX_SOC_TIMEOUT", "0");
        this.servername = servername;
        this.socKeepAlive = optProps.asBool("IFX_SOC_KEEPALIVE", "false");
        this.prepareForConnect(username, password, servername, addr);
        if (this.sqlhGroup) {
            this.connectToPrimary(password, dbname, envlist, capabilities, servername);
        } else {
            this.connect(password, this.servername, dbname, envlist, capabilities);
        }
    }

    private void connect(String password, String serverName, String dbname, Properties envlist, int capabilities) throws IfxASFException {
        try {
            this.openSocket();
            this.getIfxDataStreams();
            this.establishConnection(password, serverName, dbname, envlist, capabilities);
        }
        catch (IfxASFException e) {
            this.disconnectAbortive();
            throw e;
        }
        catch (Exception e) {
            this.disconnectAbortive();
            throw new IfxASFException("An unexpected error occurred", e);
        }
    }

    public synchronized void sOOBSocket() throws IfxASFException {
        int MSG_OOB = 66;
        if (null == this.asfSocket && !this.usingProxy) {
            return;
        }
        try {
            if (this.usingProxy) {
                HttpBufferedOutputStream oob_BufOs = (HttpBufferedOutputStream)this.asfBufOs;
                oob_BufOs.sendOOBData();
            } else {
                this.asfSocket.sendUrgentData(MSG_OOB);
            }
        }
        catch (IOException e) {
            throw IfxErrMsg.getLocIfxASFException(-908, this.getAddress(), this.ClientLocale, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnectOrderly() throws IfxASFException {
        try {
            short lastbyte = 0;
            if (null == this.asfSocket && !this.usingProxy) {
                return;
            }
            byte[] b = JavaToIfxType.JavaToIfxSmallInt((short)56);
            try {
                this.asfIfxOs.write(b);
                this.asfIfxOs.flush();
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordC2S();
                }
            }
            catch (IOException e) {
                throw IfxErrMsg.getLocIfxASFException(-908, this.getAddress(), this.ClientLocale, e);
            }
            this.asfIfxIs.read(b);
            lastbyte = IfxToJavaType.IfxToJavaSmallInt(b);
            while (lastbyte == 99) {
                lastbyte = this.asfIfxIs.readSmallInt();
                lastbyte = this.asfIfxIs.readSmallInt();
                lastbyte = this.asfIfxIs.readSmallInt();
                this.asfIfxIs.read(b);
                lastbyte = IfxToJavaType.IfxToJavaSmallInt(b);
            }
            if (lastbyte != 56 && lastbyte != 12) {
                throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
            }
            if (this.sqliTrace != null) {
                this.sqliTrace.recordS2C();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.disconnect();
        }
    }

    public synchronized void disconnectAbortive() throws IfxASFException {
        if (null == this.asfSocket && !this.usingProxy) {
            return;
        }
        try {
            if (this.asfIfxOs != null) {
                this.asfIfxOs.flush();
            }
            if (this.sqliTrace != null) {
                this.sqliTrace.recordC2S();
            }
        }
        catch (IOException e) {
            throw IfxErrMsg.getLocIfxASFException(-908, this.getAddress(), this.ClientLocale, e);
        }
        finally {
            this.disconnect();
        }
    }

    public IfxDataInputStream getIfxDataInputStream() {
        if (null == this.asfSocket && !this.usingProxy) {
            return null;
        }
        return this.asfIfxIs;
    }

    public IfxDataOutputStream getIfxDataOutputStream() {
        if (null == this.asfSocket && !this.usingProxy) {
            return null;
        }
        return this.asfIfxOs;
    }

    public String getUserName() {
        return this.username;
    }

    private void sendConnectionRequest(String password, String servername, String dbname, Properties envlist, int capabilities) throws IOException, SQLException {
        if (capabilities > 0) {
            ByteArrayOutputStream pfByteArrayOs = new ByteArrayOutputStream(2048);
            ByteArrayOutputStream slByteArrayOs = new ByteArrayOutputStream(6);
            this.response50format = 0;
            this.encodeAscBinary(new IfxDataOutputStream(pfByteArrayOs), this.username, password, servername, dbname, envlist, capabilities);
            this.EncodeSLheader(new IfxDataOutputStream(slByteArrayOs), pfByteArrayOs.size(), 1, 60, 0);
            slByteArrayOs.writeTo(this.asfIfxOs);
            this.asfIfxOs.writeWithMangledTrace(pfByteArrayOs.toByteArray());
        } else {
            ByteArrayOutputStream pfByteArrayOs = new ByteArrayOutputStream(2048);
            this.response50format = dbname == null ? 4 : 1;
            this.EncodeAscString(new IfxDataOutputStream(pfByteArrayOs), this.username, password, servername, dbname, envlist, "9.280", capabilities, "RDS#R000000");
            pfByteArrayOs.writeTo(this.asfIfxOs);
        }
        if (this.sqliTrace != null) {
            this.sqliTrace.clearC2S();
        }
    }

    private void recvConnectionResponse() throws IOException, IfxASFException, IfxASFRemoteException {
        if (this.response50format > 0) {
            this.DecodeAscString();
            return;
        }
        byte[] byteArrayInput = new byte[4096];
        IfxDataInputStream in = null;
        this.asfIfxOs.flush();
        short length = this.asfIfxIs.readShort();
        this.asfIfxIs.read(byteArrayInput, 0, length - 2);
        in = new IfxDataInputStream(new ByteArrayInputStream(byteArrayInput));
        byte SLType = in.readByte();
        switch (SLType) {
            case 2: {
                in.skipBytes(3);
                short junk = in.readShort();
                if (100 != junk || 101 != (junk = in.readShort())) break;
                this.DecodeAscBinary(in);
                if (this.sqliTrace != null) {
                    this.sqliTrace.clearS2C();
                }
                return;
            }
            case 3: {
                in.skipBytes(3);
                short junk = in.readShort();
                if (100 != junk) {
                    if (this.sqliTrace == null) break;
                    this.sqliTrace.recordS2C();
                    break;
                }
                junk = in.readShort();
                if (101 != junk) {
                    if (this.sqliTrace == null) break;
                    this.sqliTrace.recordS2C();
                    break;
                }
                this.DecodeAscBinary(in);
                if (this.svcError == 0) break;
                throw new IfxASFRemoteException((int)this.svcError, this.osError, this.errMsg);
            }
            case 13: {
                in.skipBytes(3);
                short lredJunk = in.readShort();
                if (100 != lredJunk || 101 != (lredJunk = in.readShort())) break;
                this.DecodeAscBinary(in);
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
                throw new IfxASFException(-79998, this.redSrvDetail);
            }
        }
        throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
    }

    private void disconnect() {
        if (this.asfIfxIs != null) {
            try {
                this.asfIfxIs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfIfxOs != null) {
            try {
                this.asfIfxOs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfSocketIs != null) {
            try {
                this.asfSocketIs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfSocketOs != null) {
            try {
                this.asfSocketOs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.asfSocket != null) {
            try {
                this.asfSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sqliTrace != null) {
            this.sqliTrace.close();
        }
        this.asfIfxIs = null;
        this.asfIfxOs = null;
        this.asfBufIs = null;
        this.asfBufOs = null;
        this.asfSocketIs = null;
        this.asfSocketOs = null;
        this.asfSocket = null;
    }

    private void EncodeAscString(IfxDataOutputStream o, String Username, String Password, String Servername, String Dbname, Properties envlist, String Versionnumber, int Capabilities, String Serialnumber) throws IOException, SQLException {
        String SQLapplType = "sqlexec";
        String buf = new String(SQLapplType + " " + Username + " " + (Password != null ? "-p" + Password : "") + " " + Versionnumber + " " + Serialnumber + " " + (this.response50format == 1 ? "-d" + Dbname : "-p") + " -f" + floatType + " ");
        o.writeBytes(o.getJavaToIfxChar(buf, this.dbEnc));
        this.encodeAscEnv(o, envlist);
        o.write(0);
    }

    private void encodeAscEnv(IfxDataOutputStream o, Properties EnvVars) throws IOException, SQLException {
        String name = null;
        String value = null;
        Enumeration<?> e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = EnvVars.getProperty(name);
            byte[] nameBytes = o.getJavaToIfxChar(name);
            byte[] valueBytes = o.getJavaToIfxChar(value, this.dbEnc);
            o.writeBytes(nameBytes);
            o.writeByte(61);
            o.writeBytes(valueBytes);
            o.writeByte(32);
        }
    }

    private void getOptProperties(AdvancedUppercaseProperties optProps) throws IfxASFException {
        if (optProps.getProperty("SECURITY") != null || optProps.getProperty("CSM") != null) {
            throw new IfxASFException(0, "CSM Encryption is no longer supported");
        }
        if (optProps.getProperty("PROXY", "").startsWith("http")) {
            this.proxy = optProps.getProperty("PROXY");
        }
        this.dbEnc = optProps.getProperty("DBENC");
        this.conTime = optProps.asInt("INFORMIXCONTIME", "0");
        this.sqliFile = optProps.getProperty("SQLITRACEFILE");
    }

    private void DecodeAscString() throws IOException, IfxASFException {
        this.asfIfxOs.flush();
        this.VersionNumber = null;
        this.SerialNumber = null;
        this.ApplidName = null;
        this.Cap_1 = 0;
        this.Cap_2 = 0;
        this.Cap_3 = 0;
        short segment = this.asfIfxIs.readSmallInt();
        switch (segment) {
            case 15: {
                if (this.response50format == 4) {
                    this.Warnings = 0;
                    return;
                }
                segment = this.asfIfxIs.readSmallInt();
                if (15 == segment && 15 == (segment = this.asfIfxIs.readSmallInt())) {
                    this.Warnings = this.asfIfxIs.readSmallInt();
                    int ljunk = this.asfIfxIs.readInt();
                    if (-1 == ljunk || -1 == (ljunk = this.asfIfxIs.readInt()) || -1 == (ljunk = this.asfIfxIs.readInt())) break;
                    segment = this.asfIfxIs.readSmallInt();
                    if (55 == segment) {
                        ljunk = this.asfIfxIs.readInt();
                        if (-1 == ljunk || -1 == (ljunk = this.asfIfxIs.readInt())) break;
                        segment = this.asfIfxIs.readSmallInt();
                    }
                    if (12 != segment) break;
                    return;
                }
                if (13 != segment) break;
            }
            case 13: {
                this.Warnings = 0;
                this.svcError = this.asfIfxIs.readSmallInt();
                this.osError = this.asfIfxIs.readSmallInt();
                short offset = this.asfIfxIs.readSmallInt();
                if (-1 == offset) break;
                this.errMsg = this.asfIfxIs.readChar();
                throw new IfxASFRemoteException((int)this.svcError, this.osError, this.errMsg);
            }
        }
        throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
    }

    private void DecodeAscBinary(IfxDataInputStream in) throws IOException, IfxASFException {
        byte[] Tempbyte = new byte[4096];
        in.skipBytes(4);
        short length = in.readShort();
        in.skipBytes(length);
        short junk = in.readShort();
        if (108 != junk) {
            throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
        }
        in.skipBytes(12);
        junk = in.readShort();
        in.readFully(Tempbyte, 0, junk);
        this.VersionNumber = IfxToJavaType.IfxToJavaChar(Tempbyte, false);
        int index95 = this.VersionNumber.indexOf("9.5");
        if (this.VersionNumber.indexOf("9.50") > 0) {
            String newVersion;
            this.VersionNumber = newVersion = this.VersionNumber.substring(0, index95) + "10.00" + this.VersionNumber.substring(index95 + 4);
        }
        junk = in.readShort();
        in.readFully(Tempbyte, 0, junk);
        this.SerialNumber = IfxToJavaType.IfxToJavaChar(Tempbyte, false);
        junk = in.readShort();
        in.readFully(Tempbyte, 0, junk);
        this.ApplidName = IfxToJavaType.IfxToJavaChar(Tempbyte, false);
        this.Cap_1 = in.readInt();
        this.Cap_2 = in.readInt();
        this.Cap_3 = in.readInt();
        in.skipBytes(2);
        junk = in.readShort();
        if (junk > 0) {
            in.skipBytes(junk);
        }
        if ((junk = in.readShort()) > 0) {
            in.skipBytes(junk);
        }
        in.skipBytes(24);
        junk = in.readShort();
        switch (junk) {
            case 102: {
                short offset;
                in.skipBytes(6);
                this.svcError = in.readShort();
                this.osError = in.readShort();
                this.Warnings = in.readShort();
                int numErrors = in.readShort();
                if (numErrors < 0) break;
                for (int i = 0; i < numErrors && (offset = in.readShort()) >= 0; ++i) {
                    this.errMsg = in.readChar();
                }
                return;
            }
            case 103: {
                junk = in.readShort();
                this.redSrvDetail = in.readChar();
                return;
            }
            case 127: {
                return;
            }
        }
        throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
    }

    private void encodeAscBinary(IfxDataOutputStream o, String Username, String Password, String Servername, String Dbname, Properties envlist, int capabilities) throws IOException, SQLException {
        byte[] appNameBytes;
        byte[] userNameBytes = o.getJavaToIfxChar(Username);
        byte[] passwordBytes = Password != null ? o.getJavaToIfxChar(Password) : null;
        byte[] servernameBytes = o.getJavaToIfxChar(Servername);
        byte[] dbnameBytes = Dbname != null ? o.getJavaToIfxChar(Dbname, this.dbEnc) : null;
        o.writeShort((short)100);
        o.writeShort((short)101);
        o.writeInt(61);
        o.writeShort(floatType.length() + 1);
        o.writeBytesConstant(floatType);
        o.writeByte(0);
        o.writeShort((short)108);
        o.writeBytesConstant(applType);
        o.writeShort("9.280".length() + 1);
        o.writeBytesConstant("9.280");
        o.writeByte(0);
        o.writeShort("RDS#R000000".length() + 1);
        o.writeBytesConstant("RDS#R000000");
        o.writeByte(0);
        o.writeShort(applID.length() + 1);
        o.writeBytesConstant(applID);
        o.writeByte(0);
        o.writeInt(capabilities);
        o.writeInt(0);
        o.writeInt(0);
        o.writeShort((short)1);
        o.writeShort(Username.length() + 1);
        o.writeBytes(userNameBytes);
        o.writeByte(0);
        if (Password == null) {
            o.writeShort(0);
        } else {
            o.writeShort(Password.length() + 1);
            o.writeBytes(passwordBytes);
            o.writeByte(0);
        }
        o.writeBytesConstant(PROT_SQLIOL);
        o.writeInt(61);
        o.writeBytesConstant(NET_TLITCP);
        o.writeInt(1);
        o.writeShort((short)104);
        o.writeShort((short)11);
        int stmtoptions = 0;
        stmtoptions |= 3;
        if (this.sqlhGroup) {
            stmtoptions |= 0x2000000;
        }
        if (this.isTrustedContext) {
            stmtoptions |= 0x4000000;
        }
        o.writeInt(stmtoptions);
        o.writeShort(Servername.length() + 1);
        o.writeBytes(servernameBytes);
        o.writeByte(0);
        if (Dbname == null) {
            o.writeShort(0);
        } else {
            if (this.dbEnc != null) {
                byte[] temp = Dbname.getBytes(this.dbEnc);
                o.writeShort(temp.length + 1);
            } else {
                o.writeShort(Dbname.length() + 1);
            }
            o.writeBytes(dbnameBytes);
            o.writeByte(0);
        }
        o.writeShort(0);
        o.writeShort(0);
        o.writeShort(0);
        o.writeShort(0);
        this.encodeEnv(o, envlist);
        this.encodeEnvPInfo(o);
        this.AppName = "Thread[id:" + Thread.currentThread().getId() + ", name:" + Thread.currentThread().getName() + ", path:" + this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath() + ']';
        try {
            appNameBytes = o.getJavaToIfxChar(this.AppName, "ISO8859_1");
        }
        catch (SQLException e) {
            this.AppName = "Thread[id:" + Thread.currentThread().getId() + ", name:jdbc_thread, path:unkwown]";
            appNameBytes = o.getJavaToIfxChar(this.AppName);
        }
        o.writeShort((short)116);
        o.writeShort(10 + this.AppName.length() + 1);
        o.writeInt(0);
        o.writeInt(0);
        o.writeShort(this.AppName.length() + 1);
        o.writeBytes(appNameBytes);
        o.writeByte(0);
        o.writeShort((short)127);
    }

    private void encodeEnvPInfo(IfxDataOutputStream o) throws IOException, SQLException {
        o.writeShort((short)107);
        o.writeInt(0);
        String procName = ManagementFactory.getRuntimeMXBean().getName();
        int procId = 0;
        if (procName != null) {
            procName = procName.split("@")[0];
            try {
                if (procName != null) {
                    procId = Integer.valueOf(procName);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        o.writeInt(procId);
        long tId = Thread.currentThread().getId();
        int thId = 0;
        try {
            thId = Integer.valueOf(Long.toString(tId));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        o.writeInt(thId);
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            hostName = this.asfSocket.getLocalAddress().getHostName();
        }
        if (hostName == null) {
            hostName = "";
        }
        o.writeShort(hostName.length() + 1);
        o.writeBytesConstant(hostName);
        o.writeByte(0);
        o.writeShort(0);
        String cwd = "";
        try {
            cwd = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            // empty catch block
        }
        o.writeShort(cwd.length() + 1);
        o.writeBytesConstant(cwd);
        o.writeByte(0);
    }

    private void encodeEnv(IfxDataOutputStream o, Properties EnvVars) throws IOException, SQLException {
        int NumEnvVar = 0;
        String name = null;
        String value = null;
        o.writeShort((short)106);
        Enumeration<?> e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            ++NumEnvVar;
        }
        o.writeShort(NumEnvVar);
        e = EnvVars.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            value = EnvVars.getProperty(name);
            byte[] nameBytes = o.getJavaToIfxChar(name);
            byte[] valueBytes = o.getJavaToIfxChar(value, this.dbEnc);
            o.writeShort(name.length() + 1);
            o.writeBytes(nameBytes);
            o.writeByte(0);
            o.writeShort(value.length() + 1);
            o.writeBytes(valueBytes);
            o.writeByte(0);
        }
    }

    private void EncodeSLheader(IfxDataOutputStream o, int pfPDUsize, int slType, int slAttribute, int slOptions) throws IOException {
        o.writeShort(pfPDUsize + 6);
        o.writeByte(slType);
        o.writeByte(slAttribute);
        o.writeShort(slOptions);
    }

    private void recvBindResponse() throws IOException, IfxASFException, IfxASFRemoteException {
        byte[] byteArrayInput = new byte[4096];
        IfxDataInputStream in = null;
        this.asfIfxOs.flush();
        short junk = this.asfIfxIs.readShort();
        if (junk != 111) {
            throw IfxErrMsg.getLocIfxASFException(-27003, this.ClientLocale);
        }
        int ljunk = this.asfIfxIs.available();
        this.asfIfxIs.readFully(byteArrayInput, 0, ljunk);
        in = new IfxDataInputStream(new ByteArrayInputStream(byteArrayInput));
        junk = in.readShort();
        switch (junk) {
            case 0: {
                junk = in.readShort();
                if (101 != junk) break;
                this.DecodeAscBinary(in);
                return;
            }
            case 1: {
                junk = in.readShort();
                if (101 != junk) break;
                this.DecodeAscBinary(in);
                if (this.svcError == 0) break;
                throw new IfxASFRemoteException((int)this.svcError, this.osError, this.errMsg);
            }
        }
        throw IfxErrMsg.getLocIfxASFException(-408, this.ClientLocale);
    }

    private void getProxyConnection(String proxy, String ipAddr, String portNo, String username, String servername, Properties optProps) throws IOException {
        String key;
        String value;
        int jdbcVersion = IfxDriver.getMajorMinorVersion();
        int jdbcTimeout = 60;
        String url = null;
        String parms = null;
        Hashtable<String, String> options = new Hashtable<String, String>();
        int i = proxy.indexOf(63);
        if (i != -1) {
            url = proxy.substring(0, i);
            parms = proxy.substring(i + 1, proxy.length());
        } else {
            url = proxy;
        }
        if (parms != null) {
            StringTokenizer subtoken = null;
            StringTokenizer token = new StringTokenizer(parms, "&");
            while (token.hasMoreTokens()) {
                String keyval = token.nextToken();
                subtoken = new StringTokenizer(keyval, "=");
                if (subtoken.countTokens() != 2) continue;
                String key2 = subtoken.nextToken().trim();
                value = subtoken.nextToken().trim();
                options.put(key2.toUpperCase(), value);
            }
        }
        HttpConnection http = new HttpConnection(url);
        URLConnection conn = http.openConnection(false, true, true);
        http.setRequestProperty("JDBC_SESSION", "null");
        http.setRequestProperty("JDBC_REQUEST", "OPEN");
        http.setRequestProperty("IPADDR", ipAddr);
        http.setRequestProperty("PORTNO", portNo);
        http.setRequestProperty("JDBC_USER", username);
        http.setRequestProperty("JDBC_SERVER", servername);
        http.setRequestProperty("JDBC_VERSION", Integer.toString(jdbcVersion));
        http.setRequestProperty("CLIENT_LOCALE", this.ClientLocale);
        if (options.size() > 0 && options.containsKey("PROXYTIMEOUT")) {
            int seconds = 0;
            String strtime = (String)options.get("PROXYTIMEOUT");
            if (strtime != null) {
                seconds = Integer.parseInt(strtime);
            }
            if (seconds == -1 || seconds > 59) {
                jdbcTimeout = seconds;
            }
        }
        http.setRequestProperty("PROXY_TIMEOUT", Integer.toString(jdbcTimeout));
        if (this.proxyLookup) {
            for (String name : optProps.stringPropertyNames()) {
                value = optProps.getProperty(name);
                if (name.equalsIgnoreCase("PROXY")) continue;
                http.setRequestProperty(name, value);
            }
        }
        http.flush(conn);
        String session = http.getHeaderField("JDBC_SESSION");
        String status = http.getHeaderField("JDBC_REQUEST");
        String proxyVer = http.getHeaderField("JDBC_PROXY");
        String timeout = http.getHeaderField("JDBC_TIMEACK");
        String sessionURL = http.getHeaderField("JDBC_URL_REWRITE");
        if (sessionURL.length() > 0) {
            http.updateURL(sessionURL);
        }
        int j = 1;
        while ((key = conn.getHeaderFieldKey(j)) != null) {
            if (key.equalsIgnoreCase("Set-Cookie")) {
                http.saveCookie(conn.getHeaderField(j));
            }
            ++j;
        }
        long interval = 0L;
        if (timeout != null) {
            interval = Long.parseLong(timeout);
        }
        int version = 0;
        if (proxyVer != null) {
            version = Integer.parseInt(proxyVer);
            http.setProxyVersion(version);
        }
        if (status.equals("SESSION_OK") && session.startsWith("JDBC")) {
            if (version >= 210 && interval > 59L) {
                http.startKeepAlive(session, interval);
            }
        } else {
            throw new IOException(session);
        }
        this.asfBufOs = new HttpBufferedOutputStream(http.getOutputStream(), http, session);
        this.asfBufIs = new HttpBufferedInputStream(new ByteArrayInputStream(new byte[0]), http, session);
    }

    private void establishConnection(String pwd, String srvrname, String dbname, Properties envlist, int capabilities) throws IfxASFException {
        block9: {
            try {
                this.sendConnectionRequest(pwd, srvrname, dbname, envlist, capabilities);
                if (this.conTime > 0) {
                    try {
                        int getOrgTimeOut = this.asfSocket.getSoTimeout();
                        this.asfSocket.setSoTimeout(this.conTime * 1000);
                        this.recvConnectionResponse();
                        this.asfSocket.setSoTimeout(getOrgTimeOut);
                        break block9;
                    }
                    catch (Exception x) {
                        this.disconnect();
                        throw x;
                    }
                }
                this.recvConnectionResponse();
            }
            catch (IOException e) {
                this.disconnect();
                if (this.usingProxy) {
                    throw IfxErrMsg.getLocIfxASFException(-908, e.toString(), this.ClientLocale, e);
                }
                throw IfxErrMsg.getLocIfxASFException(-908, this.getAddress(), this.ClientLocale, e);
            }
            catch (IfxASFException e) {
                this.disconnect();
                throw e;
            }
            catch (SQLException e) {
                this.disconnect();
                throw new IfxASFException(e.getErrorCode(), e.getLocalizedMessage());
            }
            catch (Exception e) {
                this.disconnect();
                throw new IfxASFException(e.getMessage(), e);
            }
        }
    }

    private String getAddress() {
        StringBuilder sb = new StringBuilder();
        if (!this.servername.isEmpty()) {
            sb.append(this.servername);
            sb.append("@");
        }
        sb.append(this.ipAddr + ":" + this.portNo);
        return sb.toString();
    }

    private void openSocket() throws IfxASFException {
        if (this.proxy != null) {
            try {
                this.usingProxy = true;
                this.getProxyConnection(this.proxy, this.ipAddr, this.portNo, this.username, this.servername, this.optProps);
            }
            catch (IOException e) {
                throw IfxErrMsg.getLocIfxASFException(-908, null, this.ClientLocale, e);
            }
        }
        for (int retryNumber = 0; retryNumber <= this.retryCount; ++retryNumber) {
            try {
                this.asfSocket = null;
                if (this.SSLconnection) {
                    String sslTrustStorePassword = this.userProperties.asString("SSL_TRUSTSTORE_PASSWORD", System.getProperty("javax.net.ssl.trustStorePassword"));
                    String sslTrustStoreLocation = this.userProperties.asString("SSL_TRUSTSTORE", System.getProperty("javax.net.ssl.trustStore"));
                    if (sslTrustStoreLocation == null) {
                        SSLSocketFactory sslsocketfactory;
                        if (this.sslCertificateVerification) {
                            sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                        } else {
                            SSLContext sslContext = SSLContext.getInstance("TLS");
                            TrustManager[] ALL_TRUSTING_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return null;
                                }

                                @Override
                                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                                }
                            }};
                            sslContext.init(null, ALL_TRUSTING_TRUST_MANAGER, new SecureRandom());
                            sslsocketfactory = sslContext.getSocketFactory();
                        }
                        SSLSocket sslSocket = (SSLSocket)sslsocketfactory.createSocket();
                        this.asfSocket = sslSocket;
                        sslSocket.setEnabledProtocols(this.getSupportedSSLProtocols(sslSocket.getSupportedProtocols()));
                    } else {
                        try {
                            SSLContext sslContext = null;
                            sslContext = SSLContext.getInstance("TLS");
                            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                            char[] passwordCharArray = null;
                            if (sslTrustStorePassword != null) {
                                passwordCharArray = sslTrustStorePassword.toCharArray();
                            }
                            ks.load(new FileInputStream(sslTrustStoreLocation), passwordCharArray);
                            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                            tmf.init(ks);
                            TrustManager[] tm = tmf.getTrustManagers();
                            sslContext.init(null, tm, null);
                            SSLSocketFactory sslsocketfactory = sslContext.getSocketFactory();
                            SSLSocket sslSocket = (SSLSocket)sslsocketfactory.createSocket();
                            this.asfSocket = sslSocket;
                            sslSocket.setEnabledProtocols(this.getSupportedSSLProtocols(sslSocket.getSupportedProtocols()));
                        }
                        catch (CertificateException e) {
                            throw IfxErrMsg.getLocIfxASFException(-28014, this.servername, this.ClientLocale, e);
                        }
                        catch (KeyManagementException e) {
                            throw IfxErrMsg.getLocIfxASFException(-28014, this.servername, this.ClientLocale, e);
                        }
                        catch (KeyStoreException e) {
                            throw IfxErrMsg.getLocIfxASFException(-28014, this.servername, this.ClientLocale, e);
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw IfxErrMsg.getLocIfxASFException(-28014, this.servername, this.ClientLocale, e);
                        }
                    }
                }
                if (this.asfSocket == null) {
                    this.asfSocket = new Socket();
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.ipAddr, this.PortNumber);
                this.asfSocket.connect(inetSocketAddress, this.loginTimeOut);
                if (this.socTimeout > 0) {
                    this.asfSocket.setSoTimeout(this.socTimeout);
                }
                this.asfSocket.setTcpNoDelay(true);
                this.asfSocket.setKeepAlive(this.socKeepAlive);
                break;
            }
            catch (Exception e) {
                if (retryNumber < this.retryCount) {
                    if (this.sqlhGroup) {
                        this.getServerInfoFromSqlhost();
                    }
                    try {
                        Thread.sleep((long)this.conTime * 1000L);
                    }
                    catch (InterruptedException ignoreException) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw IfxErrMsg.getLocIfxASFException(-908, this.getAddress(), this.ClientLocale, e);
            }
        }
        try {
            this.asfSocketIs = this.asfSocket.getInputStream();
            this.asfSocketOs = this.asfSocket.getOutputStream();
            this.asfBufIs = new BufferedInputStream(this.asfSocketIs, 4096);
            this.asfBufOs = new BufferedOutputStream(this.asfSocketOs, 4096);
        }
        catch (IOException e) {
            this.disconnect();
            throw IfxErrMsg.getLocIfxASFException(-908, this.servername, this.ClientLocale, e);
        }
    }

    private void prepareForConnect(String username, String password, String servername, String addr) throws IfxASFException {
        this.getOptProperties(this.optProps);
        this.checkUsernamePassword(username, password);
        this.prepareIP_PortInfo(addr);
    }

    private void getIfxDataStreams() {
        if (this.sqliFile == null) {
            this.asfIfxIs = new IfxDataInputStream(this.asfBufIs, this.encoption);
            this.asfIfxOs = new IfxDataOutputStream(this.asfBufOs, this.encoption);
        } else {
            this.asfIfxIs = new IfxDebugDataInputStream(this.asfBufIs, this.encoption);
            this.asfIfxOs = new IfxDebugDataOutputStream(this.asfBufOs, this.encoption);
            this.sqliTrace = new SqliDbg((IfxDebugDataInputStream)this.asfIfxIs, (IfxDebugDataOutputStream)this.asfIfxOs, this.sqliFile);
        }
    }

    private void prepareIP_PortInfo(String addr) throws IfxASFException {
        if (null != addr) {
            if (addr.indexOf(44) == -1) {
                throw IfxErrMsg.getLocIfxASFException(-25563, this.ClientLocale);
            }
            StringTokenizer aToken = new StringTokenizer(addr, ",");
            this.ipAddr = aToken.nextToken();
            this.portNo = aToken.nextToken();
            this.PortNumber = Integer.parseInt(this.portNo);
        } else {
            String sqlhloc = this.optProps.getProperty("SQLH_LOC");
            if (sqlhloc != null && !sqlhloc.equalsIgnoreCase("PROXY")) {
                this.getServerInfoFromSqlhost();
            } else {
                this.proxyLookup = true;
            }
        }
    }

    private void checkUsernamePassword(String username, String password) throws IfxASFException {
        if (null != username && null == password) {
            throw IfxErrMsg.getLocIfxASFException(-952, this.ClientLocale);
        }
        if (null == username) {
            if (null != password) {
                throw IfxErrMsg.getLocIfxASFException(-25563, this.ClientLocale);
            }
            this.username = System.getProperty("user.name");
        } else {
            this.username = username;
        }
    }

    private void getServerInfoFromSqlhost() throws IfxASFException {
        if (this.sqlhGroup && this.myGroup.hasMoreElements()) {
            this.servername = this.myGroup.nextElement();
        }
        JnsObject jnsobj = new JnsObject();
        jnsobj.setClientLocale(this.ClientLocale);
        jnsobj.JnsLookup(this.servername, this.optProps);
        this.ipAddr = jnsobj.getIPAddr();
        this.portNo = jnsobj.getPortNo();
        this.PortNumber = jnsobj.getPortNumber();
        if (this.myGroup == null) {
            this.myGroup = jnsobj.getServerGroup();
            if (this.myGroup != null) {
                this.servername = jnsobj.getServerName();
                this.retryCount = jnsobj.getGroupCount();
                this.sqlhGroup = true;
            }
        }
    }

    private void connectToPrimary(String password, String dbname, Properties envlist, int capabilities, String groupName) throws IfxASFException {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "ASF.Connection:connectToPrimary() : Trying connection group -> " + groupName);
        }
        int sqlcode = 0;
        int groupCount = this.myGroup.size();
        int elementCount = 1;
        do {
            try {
                if (TraceFlag.isTraceEnabled() && this.trace != null) {
                    this.trace.writeTrace(logger, 1, "Trying connection to  -> address=" + this.ipAddr + ",port=" + this.portNo + ",servername=" + this.servername);
                }
                sqlcode = 0;
                this.connect(password, this.servername, dbname, envlist, capabilities);
            }
            catch (IfxASFException ex) {
                sqlcode = ex.getErrorId();
                if (TraceFlag.isTraceEnabled() && this.trace != null) {
                    this.trace.writeTrace(logger, 1, "Error during connection, sqlcode=" + sqlcode + ",message=" + ex.getMessage());
                }
                this.sqlhGroup = false;
                if (sqlcode == -79998) {
                    if (TraceFlag.isTraceEnabled() && this.trace != null) {
                        this.trace.writeTrace(logger, 1, "Trying redirect information returned by connection manager...");
                    }
                    this.processGroupRedirectRequest(ex.toString());
                    continue;
                }
                if (this.myGroup.hasMoreElements()) {
                    if (TraceFlag.isTraceEnabled() && this.trace != null) {
                        this.trace.writeTrace(logger, 1, "Trying " + ++elementCount + " of " + groupCount + " elements in the given connection group");
                    }
                    this.sqlhGroup = true;
                    this.getServerInfoFromSqlhost();
                    continue;
                }
                if (TraceFlag.isTraceEnabled() && this.trace != null) {
                    this.trace.writeTrace(logger, 1, "Failed to connect to any element in the given connection group");
                }
                throw ex;
            }
        } while (sqlcode != 0);
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "ASF.Connection:connectToPrimary() exiting, connection established to address=" + this.ipAddr + ",port=" + this.portNo + ",server=" + this.servername);
        }
    }

    private void processGroupRedirectRequest(String errtxt) throws IfxASFException {
        String ipAddr = null;
        String portNo = null;
        String servername = null;
        StringTokenizer st = new StringTokenizer(errtxt, ":=|");
        if (st.hasMoreTokens()) {
            st.nextToken();
            if (st.hasMoreTokens()) {
                servername = st.nextToken().trim();
                if (st.hasMoreTokens()) {
                    ipAddr = st.nextToken().trim();
                    if (st.hasMoreTokens()) {
                        portNo = st.nextToken().trim();
                    }
                }
            }
        }
        try {
            this.PortNumber = Integer.parseInt(portNo);
        }
        catch (NumberFormatException nfe) {
            int poNo = -1;
            poNo = JnsObject.getServiceByName(portNo);
            if (poNo == -1) {
                throw new IfxASFException(-79759, ": '" + portNo + "'");
            }
            this.PortNumber = poNo;
            portNo = "" + poNo;
        }
        this.ipAddr = ipAddr;
        this.portNo = portNo;
        this.servername = servername;
    }

    private String[] getSupportedSSLProtocols(String[] defaultProtocols) {
        if (this.sslProtocols != null && this.sslProtocols.length > 0 && defaultProtocols != null && defaultProtocols.length > 0) {
            Object[] allProtocols = new String[this.sslProtocols.length + defaultProtocols.length];
            System.arraycopy(this.sslProtocols, 0, allProtocols, 0, this.sslProtocols.length);
            System.arraycopy(defaultProtocols, 0, allProtocols, this.sslProtocols.length, defaultProtocols.length);
            if (TraceFlag.isTraceEnabled() && this.trace != null) {
                this.trace.writeTrace(logger, 1, "SSL Protocol list ->" + Arrays.toString(allProtocols));
            }
            return allProtocols;
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "SSL Protocol list ->" + Arrays.toString(defaultProtocols));
        }
        return defaultProtocols;
    }

    public void setNetworkTimeout(int timeout) throws SocketException {
        this.asfSocket.setSoTimeout(timeout);
    }

    public int getNetworkTimeout() throws SocketException {
        return this.asfSocket.getSoTimeout();
    }

    public boolean isValid() {
        return !this.asfSocket.isClosed();
    }
}

