/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializer;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.overrides.IrJavaIncompatibilityRulesOverridabilityCondition;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.utils.InjectedValue;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.scopes.jvm.FirJvmDelegatedMembersFilter;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020;2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010<\u001a\u00020\u000e2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030>H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0010\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "irDeserializer", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "parametersAreAssignable", "", "getParametersAreAssignable", "()Z", "externalOverridabilityConditions", "", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getCachedFields", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "kotlinIrInternalPackage", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrExternalPackageFragmentImpl;", "kotlinJvmInternalPackage", "specialAnnotationConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "rawTypeAnnotationClassConstructor", "generateRawTypeAnnotationCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "createSpecialAnnotationClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "findInjectedValue", "Lorg/jetbrains/kotlin/fir/backend/utils/InjectedValue;", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "irNeedsDeserialization", "getIrNeedsDeserialization", "deserializeToplevelClass", "irClass", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "hasBackingField", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "initializeIrBuiltInsAndSymbolTable", "", "shouldGenerateDelegatedMember", "delegateMemberFromBaseType", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nJvmFir2IrExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class JvmFir2IrExtensions
implements JvmGeneratorExtensions,
Fir2IrExtensions {
    @NotNull
    private final JvmIrDeserializer irDeserializer;
    @Nullable
    private IrBuiltIns irBuiltIns;
    @Nullable
    private SymbolTable symbolTable;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinIrInternalPackage;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinJvmInternalPackage;
    @NotNull
    private final List<IrConstructor> specialAnnotationConstructors;
    @NotNull
    private final IrConstructor rawTypeAnnotationClassConstructor;
    private final boolean irNeedsDeserialization;

    public JvmFir2IrExtensions(@NotNull CompilerConfiguration configuration2, @NotNull JvmIrDeserializer irDeserializer) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(irDeserializer, "irDeserializer");
        this.irDeserializer = irDeserializer;
        this.cachedFields = new CachedFieldsForObjectInstances(IrFactoryImpl.INSTANCE, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2));
        this.kotlinIrInternalPackage = new IrExternalPackageFragmentImpl(new DescriptorlessExternalPackageFragmentSymbol(), IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN());
        IrExternalPackageFragmentSymbol irExternalPackageFragmentSymbol = new DescriptorlessExternalPackageFragmentSymbol();
        FqName fqName = JvmAnnotationNames.KOTLIN_JVM_INTERNAL;
        Intrinsics.checkNotNullExpressionValue(fqName, "KOTLIN_JVM_INTERNAL");
        this.kotlinJvmInternalPackage = new IrExternalPackageFragmentImpl(irExternalPackageFragmentSymbol, fqName);
        this.specialAnnotationConstructors = new ArrayList();
        this.rawTypeAnnotationClassConstructor = SequencesKt.single(IrUtilsKt.getConstructors(this.createSpecialAnnotationClass(JvmSymbols.Companion.getRAW_TYPE_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage)));
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ENHANCED_NULLABILITY_ANNOTATION");
        this.createSpecialAnnotationClass(fqName2, this.kotlinJvmInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_MUTABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.irNeedsDeserialization = configuration2.get(JVMConfigurationKeys.SERIALIZE_IR, JvmSerializeIrMode.NONE) != JvmSerializeIrMode.NONE;
    }

    @Override
    public boolean getParametersAreAssignable() {
        return true;
    }

    @Override
    @NotNull
    public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions() {
        return CollectionsKt.listOf(new IrJavaIncompatibilityRulesOverridabilityCondition());
    }

    @Override
    @NotNull
    public CachedFieldsForObjectInstances getCachedFields() {
        return this.cachedFields;
    }

    @Override
    @NotNull
    public IrConstructorCall generateRawTypeAnnotationCall() {
        IrConstructor it = this.rawTypeAnnotationClassConstructor;
        boolean bl = false;
        return BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, IrUtilsKt.getConstructedClassType(it), it.getSymbol(), null, 16, null);
    }

    private final IrClass createSpecialAnnotationClass(FqName fqn, IrPackageFragment parent2) {
        IrClass irClass;
        IrClass $this$createSpecialAnnotationClass_u24lambda_u241 = irClass = IrUtilsKt.createSpecialAnnotationClass(IrFactoryImpl.INSTANCE, fqn, parent2);
        boolean bl = false;
        this.specialAnnotationConstructors.add(SequencesKt.single(IrUtilsKt.getConstructors($this$createSpecialAnnotationClass_u24lambda_u241)));
        return irClass;
    }

    @Override
    @Nullable
    public InjectedValue findInjectedValue(@NotNull FirReference calleeReference, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter(calleeReference, "calleeReference");
        Intrinsics.checkNotNullParameter(conversionScope, "conversionScope");
        return null;
    }

    @Override
    public boolean getIrNeedsDeserialization() {
        return this.irNeedsDeserialization;
    }

    @Override
    public boolean deserializeToplevelClass(@NotNull IrClass irClass, @NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(components, "components");
        IrBuiltIns irBuiltIns = this.irBuiltIns;
        if (irBuiltIns == null) {
            throw new IllegalStateException("BuiltIns are not initialized".toString());
        }
        IrBuiltIns builtIns = irBuiltIns;
        SymbolTable symbolTable = this.symbolTable;
        if (symbolTable == null) {
            throw new IllegalStateException("SymbolTable is not initialized".toString());
        }
        SymbolTable symbolTable2 = symbolTable;
        return this.irDeserializer.deserializeTopLevelClass(irClass, builtIns, symbolTable2, components.getIrProviders(), this);
    }

    @Override
    public boolean hasBackingField(@NotNull FirProperty property2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(session, "session");
        return property2.getOrigin() instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual(DeclarationAttributesKt.isDeserializedPropertyFromAnnotation(property2), true) || Fir2IrExtensions.Default.INSTANCE.hasBackingField(property2, session);
    }

    @Override
    public void initializeIrBuiltInsAndSymbolTable(@NotNull IrBuiltIns irBuiltIns, @NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        if (!(this.irBuiltIns == null)) {
            boolean $i$a$-require-JvmFir2IrExtensions$initializeIrBuiltInsAndSymbolTable$32 = false;
            String $i$a$-require-JvmFir2IrExtensions$initializeIrBuiltInsAndSymbolTable$32 = "BuiltIns are already initialized";
            throw new IllegalArgumentException($i$a$-require-JvmFir2IrExtensions$initializeIrBuiltInsAndSymbolTable$32.toString());
        }
        this.irBuiltIns = irBuiltIns;
        if (!(this.symbolTable == null)) {
            boolean bl = false;
            String string = "SymboTable is already initialized";
            throw new IllegalArgumentException(string.toString());
        }
        this.symbolTable = symbolTable;
    }

    @Override
    public boolean shouldGenerateDelegatedMember(@NotNull IrOverridableDeclaration<?> delegateMemberFromBaseType) {
        Intrinsics.checkNotNullParameter(delegateMemberFromBaseType, "delegateMemberFromBaseType");
        IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default(delegateMemberFromBaseType, null, 1, null);
        if (irOverridableDeclaration == null) {
            return true;
        }
        IrOverridableDeclaration original = irOverridableDeclaration;
        boolean shouldNotGenerate = JvmFir2IrExtensions.shouldGenerateDelegatedMember$isNonAbstractJavaMethod(original) || JvmFir2IrExtensions.shouldGenerateDelegatedMember$hasJvmDefaultAnnotation(original) || JvmFir2IrExtensions.shouldGenerateDelegatedMember$isBuiltInMemberMappedToJavaDefault(original);
        return !shouldNotGenerate;
    }

    private static final boolean shouldGenerateDelegatedMember$isNonAbstractJavaMethod(IrOverridableDeclaration<?> $this$shouldGenerateDelegatedMember_u24isNonAbstractJavaMethod) {
        return Intrinsics.areEqual($this$shouldGenerateDelegatedMember_u24isNonAbstractJavaMethod.getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) && $this$shouldGenerateDelegatedMember_u24isNonAbstractJavaMethod.getModality() != Modality.ABSTRACT;
    }

    private static final boolean shouldGenerateDelegatedMember$hasJvmDefaultAnnotation(IrOverridableDeclaration<?> $this$shouldGenerateDelegatedMember_u24hasJvmDefaultAnnotation) {
        return AdditionalIrUtilsKt.hasAnnotation($this$shouldGenerateDelegatedMember_u24hasJvmDefaultAnnotation.getAnnotations(), JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_CLASS_ID());
    }

    private static final boolean shouldGenerateDelegatedMember$isBuiltInMemberMappedToJavaDefault(IrOverridableDeclaration<?> $this$shouldGenerateDelegatedMember_u24isBuiltInMemberMappedToJavaDefault) {
        return $this$shouldGenerateDelegatedMember_u24isBuiltInMemberMappedToJavaDefault.getModality() != Modality.ABSTRACT && AdditionalIrUtilsKt.hasAnnotation($this$shouldGenerateDelegatedMember_u24isBuiltInMemberMappedToJavaDefault.getAnnotations(), FirJvmDelegatedMembersFilter.Companion.getPLATFORM_DEPENDENT_ANNOTATION_CLASS_ID());
    }
}

