/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.diff;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.Side;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.diff.DiffHolderBase;
import com.intellij.lang.properties.diff.FileInfoHolder;
import com.intellij.lang.properties.diff.data.FileInfo;
import com.intellij.lang.properties.diff.data.ModifiedPropertyRange;
import com.intellij.lang.properties.diff.data.PropertiesDiffContext;
import com.intellij.lang.properties.diff.data.SemiOpenLineRange;
import com.intellij.lang.properties.diff.data.UnchangedRangeInfo;
import com.intellij.lang.properties.diff.util.AffectedChangeInfo;
import com.intellij.lang.properties.diff.util.AffectedChangeInfoKt;
import com.intellij.lang.properties.diff.util.DiffTextRangeWithData;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 %2\u00020\u0001:\u0003#$%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J.\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/lang/properties/diff/MatchProcessor;", "", "fileInfoHolder", "Lcom/intellij/lang/properties/diff/FileInfoHolder;", "fragmentList", "", "Lcom/intellij/diff/fragments/LineFragment;", "<init>", "(Lcom/intellij/lang/properties/diff/FileInfoHolder;Ljava/util/List;)V", "disabledRangeMap", "", "", "Lcom/intellij/lang/properties/diff/data/UnchangedRangeInfo;", "modifiedPropertyList", "Lcom/intellij/lang/properties/diff/data/ModifiedPropertyRange;", "collect", "Lcom/intellij/lang/properties/diff/data/PropertiesDiffContext;", "matchProperties", "", "holder", "Lcom/intellij/lang/properties/diff/MatchProcessor$PropertyInfoHolder;", "collectEmptyLines", "collectComments", "findAndDisableLineRanges", "fileInfo", "Lcom/intellij/lang/properties/diff/data/FileInfo;", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "side", "Lcom/intellij/diff/util/Side;", "diffRangeWithDataList", "Lcom/intellij/lang/properties/diff/util/DiffTextRangeWithData;", "addDisabledRanges", "changeInfo", "Lcom/intellij/lang/properties/diff/MatchProcessor$NonSignificantChangeInfo;", "PropertyInfoHolder", "NonSignificantChangeInfo", "Companion", "intellij.properties.backend"})
@SourceDebugExtension(value={"SMAP\nMatchProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchProcessor.kt\ncom/intellij/lang/properties/diff/MatchProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1285#2,2:157\n1299#2,4:159\n1869#2:163\n1011#2,2:164\n1870#2:166\n1869#2:167\n1617#2,9:168\n1869#2:177\n1870#2:179\n1626#2:180\n1870#2:181\n1869#2,2:182\n1869#2,2:184\n1#3:178\n*S KotlinDebug\n*F\n+ 1 MatchProcessor.kt\ncom/intellij/lang/properties/diff/MatchProcessor\n*L\n18#1:157,2\n18#1:159,4\n28#1:163\n28#1:164,2\n28#1:166\n47#1:167\n52#1:168,9\n52#1:177\n52#1:179\n52#1:180\n47#1:181\n68#1:182,2\n86#1:184,2\n52#1:178\n*E\n"})
public final class MatchProcessor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final FileInfoHolder fileInfoHolder;
    @NotNull
    private final List<LineFragment> fragmentList;
    @NotNull
    private final Map<LineFragment, List<UnchangedRangeInfo>> disabledRangeMap;
    @NotNull
    private final List<ModifiedPropertyRange> modifiedPropertyList;

    /*
     * WARNING - void declaration
     */
    public MatchProcessor(@NotNull FileInfoHolder fileInfoHolder, @NotNull List<? extends LineFragment> fragmentList) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)fileInfoHolder, (String)"fileInfoHolder");
        Intrinsics.checkNotNullParameter(fragmentList, (String)"fragmentList");
        this.fileInfoHolder = fileInfoHolder;
        this.fragmentList = fragmentList;
        Iterable iterable = this.fragmentList;
        MatchProcessor matchProcessor = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            LineFragment lineFragment = (LineFragment)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List list = new ArrayList();
            map.put(t, list);
        }
        matchProcessor.disabledRangeMap = result$iv;
        this.modifiedPropertyList = new ArrayList();
    }

    @NotNull
    public final PropertiesDiffContext collect() {
        this.collectEmptyLines(this.fileInfoHolder);
        this.collectComments(this.fileInfoHolder);
        PropertyInfoHolder changedPropertyInfoHolder = PropertyInfoHolder.Companion.create$intellij_properties_backend(this.fileInfoHolder);
        this.matchProperties(changedPropertyInfoHolder);
        Iterable $this$forEach$iv = this.disabledRangeMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list = (List)element$iv;
            boolean bl = false;
            List $this$sortBy$iv = list;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    UnchangedRangeInfo it = (UnchangedRangeInfo)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRange().getStartLine());
                    it = (UnchangedRangeInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRange().getStartLine()));
                }
            });
        }
        return new PropertiesDiffContext(this.fileInfoHolder, this.disabledRangeMap, this.modifiedPropertyList);
    }

    private final void matchProperties(PropertyInfoHolder holder) {
        for (Map.Entry entry : ((Map)holder.get(Side.RIGHT)).entrySet()) {
            IProperty rightProperty;
            IProperty leftProperty;
            NonSignificantChangeInfo leftPropertyInfo;
            Object object;
            String key = (String)entry.getKey();
            NonSignificantChangeInfo rightPropertyInfo = (NonSignificantChangeInfo)entry.getValue();
            if ((NonSignificantChangeInfo)((Map)holder.get(Side.LEFT)).get(key) == null || ((object = leftPropertyInfo.getData()) instanceof IProperty ? (IProperty)object : null) == null) continue;
            leftProperty = leftProperty;
            Object object2 = rightPropertyInfo.getData();
            if ((object2 instanceof IProperty ? (IProperty)object2 : null) == null) continue;
            rightProperty = rightProperty;
            if (!Intrinsics.areEqual((Object)leftProperty.getUnescapedValue(), (Object)rightProperty.getUnescapedValue())) {
                this.modifiedPropertyList.add(new ModifiedPropertyRange(leftPropertyInfo.getRange(), rightPropertyInfo.getRange()));
            }
            this.addDisabledRanges(leftPropertyInfo);
            this.addDisabledRanges(rightPropertyInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectEmptyLines(FileInfoHolder fileInfoHolder) {
        Iterable $this$forEach$iv = (Iterable)Side.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            Document document;
            Side side = (Side)element$iv;
            boolean bl = false;
            FileInfo fileInfo = (FileInfo)fileInfoHolder.get(side);
            Intrinsics.checkNotNullExpressionValue((Object)fileInfo.getFile().getFileDocument(), (String)"getFileDocument(...)");
            LineOffsets lineOffsets = fileInfo.getLineOffsets();
            Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)document.getLineCount());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DiffTextRangeWithData it$iv$iv;
                String text;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl2 = false;
                int lineIndex = element$iv$iv;
                boolean bl3 = false;
                int startOffset = lineOffsets.getLineStart(lineIndex);
                int endOffset = lineOffsets.getLineEnd(lineIndex);
                TextRange range = new TextRange(startOffset, endOffset);
                Intrinsics.checkNotNullExpressionValue((Object)document.getText(range), (String)"getText(...)");
                if ((!StringsKt.isBlank((CharSequence)text) ? null : new DiffTextRangeWithData(range, null, 2, null)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List diffRangeWithDataList = (List)destination$iv$iv;
            this.findAndDisableLineRanges(fileInfo, lineOffsets, side, diffRangeWithDataList);
        }
    }

    private final void collectComments(FileInfoHolder fileInfoHolder) {
        Iterable $this$forEach$iv = (Iterable)Side.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List diffRangeWithDataList;
            Side side = (Side)element$iv;
            boolean bl = false;
            FileInfo fileInfo = (FileInfo)fileInfoHolder.get(side);
            Intrinsics.checkNotNullExpressionValue((Object)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)fileInfo.getFile())).filter(PsiComment.class).map(arg_0 -> MatchProcessor.collectComments$lambda$7$lambda$6(MatchProcessor::collectComments$lambda$7$lambda$5, arg_0)).toList(), (String)"toList(...)");
            LineOffsets lineOffsets = fileInfo.getLineOffsets();
            this.findAndDisableLineRanges(fileInfo, lineOffsets, side, diffRangeWithDataList);
        }
    }

    private final void findAndDisableLineRanges(FileInfo fileInfo, LineOffsets lineOffsets, Side side, List<DiffTextRangeWithData> diffRangeWithDataList) {
        List<TextRange> lineFragmentRangeList = fileInfo.getLineFragmentRangeList();
        Iterable $this$forEach$iv = Companion.findNonSignificantChanges(lineOffsets, lineFragmentRangeList, diffRangeWithDataList, side);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NonSignificantChangeInfo changeInfo = (NonSignificantChangeInfo)element$iv;
            boolean bl = false;
            this.addDisabledRanges(changeInfo);
        }
    }

    private final void addDisabledRanges(NonSignificantChangeInfo changeInfo) {
        Iterator<Integer> iterator = changeInfo.getFragmentIndexList().iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            LineFragment lineFragment = this.fragmentList.get(index);
            List<UnchangedRangeInfo> list = this.disabledRangeMap.get(lineFragment);
            if (list == null) continue;
            list.add(new UnchangedRangeInfo(changeInfo.getRange(), changeInfo.getSide()));
        }
    }

    private static final DiffTextRangeWithData collectComments$lambda$7$lambda$5(PsiComment it) {
        TextRange textRange = it.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return new DiffTextRangeWithData(textRange, null, 2, null);
    }

    private static final DiffTextRangeWithData collectComments$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (DiffTextRangeWithData)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/properties/diff/MatchProcessor$Companion;", "", "<init>", "()V", "findNonSignificantChanges", "", "Lcom/intellij/lang/properties/diff/MatchProcessor$NonSignificantChangeInfo;", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineFragmentRangeList", "Lcom/intellij/openapi/util/TextRange;", "diffRangeWithDataList", "Lcom/intellij/lang/properties/diff/util/DiffTextRangeWithData;", "side", "Lcom/intellij/diff/util/Side;", "intellij.properties.backend"})
    @SourceDebugExtension(value={"SMAP\nMatchProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchProcessor.kt\ncom/intellij/lang/properties/diff/MatchProcessor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1563#2:157\n1634#2,3:158\n*S KotlinDebug\n*F\n+ 1 MatchProcessor.kt\ncom/intellij/lang/properties/diff/MatchProcessor$Companion\n*L\n149#1:157\n149#1:158,3\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<NonSignificantChangeInfo> findNonSignificantChanges(@NotNull LineOffsets lineOffsets, @NotNull List<? extends TextRange> lineFragmentRangeList, @NotNull List<DiffTextRangeWithData> diffRangeWithDataList, @NotNull Side side) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
            Intrinsics.checkNotNullParameter(lineFragmentRangeList, (String)"lineFragmentRangeList");
            Intrinsics.checkNotNullParameter(diffRangeWithDataList, (String)"diffRangeWithDataList");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Iterable $this$map$iv = AffectedChangeInfoKt.findAffectedChanges(lineFragmentRangeList, diffRangeWithDataList);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AffectedChangeInfo affectedChangeInfo = (AffectedChangeInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int startLine = lineOffsets.getLineNumber(it.getRange().getStartOffset());
                int endLine = lineOffsets.getLineNumber(it.getRange().getEndOffset());
                collection.add(new NonSignificantChangeInfo(new SemiOpenLineRange(startLine, endLine + 1), it.getFragmentIndexList(), side, it.getData()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/properties/diff/MatchProcessor$NonSignificantChangeInfo;", "", "range", "Lcom/intellij/lang/properties/diff/data/SemiOpenLineRange;", "fragmentIndexList", "", "", "side", "Lcom/intellij/diff/util/Side;", "data", "<init>", "(Lcom/intellij/lang/properties/diff/data/SemiOpenLineRange;Ljava/util/List;Lcom/intellij/diff/util/Side;Ljava/lang/Object;)V", "getRange", "()Lcom/intellij/lang/properties/diff/data/SemiOpenLineRange;", "getFragmentIndexList", "()Ljava/util/List;", "getSide", "()Lcom/intellij/diff/util/Side;", "getData", "()Ljava/lang/Object;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.properties.backend"})
    public static final class NonSignificantChangeInfo {
        @NotNull
        private final SemiOpenLineRange range;
        @NotNull
        private final List<Integer> fragmentIndexList;
        @NotNull
        private final Side side;
        @Nullable
        private final Object data;

        public NonSignificantChangeInfo(@NotNull SemiOpenLineRange range, @NotNull List<Integer> fragmentIndexList, @NotNull Side side, @Nullable Object data) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(fragmentIndexList, (String)"fragmentIndexList");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            this.range = range;
            this.fragmentIndexList = fragmentIndexList;
            this.side = side;
            this.data = data;
        }

        public /* synthetic */ NonSignificantChangeInfo(SemiOpenLineRange semiOpenLineRange, List list, Side side, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                object = null;
            }
            this(semiOpenLineRange, list, side, object);
        }

        @NotNull
        public final SemiOpenLineRange getRange() {
            return this.range;
        }

        @NotNull
        public final List<Integer> getFragmentIndexList() {
            return this.fragmentIndexList;
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        @Nullable
        public final Object getData() {
            return this.data;
        }

        @NotNull
        public final SemiOpenLineRange component1() {
            return this.range;
        }

        @NotNull
        public final List<Integer> component2() {
            return this.fragmentIndexList;
        }

        @NotNull
        public final Side component3() {
            return this.side;
        }

        @Nullable
        public final Object component4() {
            return this.data;
        }

        @NotNull
        public final NonSignificantChangeInfo copy(@NotNull SemiOpenLineRange range, @NotNull List<Integer> fragmentIndexList, @NotNull Side side, @Nullable Object data) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter(fragmentIndexList, (String)"fragmentIndexList");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return new NonSignificantChangeInfo(range, fragmentIndexList, side, data);
        }

        public static /* synthetic */ NonSignificantChangeInfo copy$default(NonSignificantChangeInfo nonSignificantChangeInfo, SemiOpenLineRange semiOpenLineRange, List list, Side side, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                semiOpenLineRange = nonSignificantChangeInfo.range;
            }
            if ((n & 2) != 0) {
                list = nonSignificantChangeInfo.fragmentIndexList;
            }
            if ((n & 4) != 0) {
                side = nonSignificantChangeInfo.side;
            }
            if ((n & 8) != 0) {
                object = nonSignificantChangeInfo.data;
            }
            return nonSignificantChangeInfo.copy(semiOpenLineRange, list, side, object);
        }

        @NotNull
        public String toString() {
            return "NonSignificantChangeInfo(range=" + this.range + ", fragmentIndexList=" + this.fragmentIndexList + ", side=" + this.side + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result = this.range.hashCode();
            result = result * 31 + ((Object)this.fragmentIndexList).hashCode();
            result = result * 31 + this.side.hashCode();
            result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NonSignificantChangeInfo)) {
                return false;
            }
            NonSignificantChangeInfo nonSignificantChangeInfo = (NonSignificantChangeInfo)other;
            if (!Intrinsics.areEqual((Object)this.range, (Object)nonSignificantChangeInfo.range)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.fragmentIndexList, nonSignificantChangeInfo.fragmentIndexList)) {
                return false;
            }
            if (this.side != nonSignificantChangeInfo.side) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)nonSignificantChangeInfo.data);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \t2\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\tB1\b\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/properties/diff/MatchProcessor$PropertyInfoHolder;", "Lcom/intellij/lang/properties/diff/DiffHolderBase;", "", "", "Lcom/intellij/lang/properties/diff/MatchProcessor$NonSignificantChangeInfo;", "leftMap", "rightMap", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "Companion", "intellij.properties.backend"})
    public static final class PropertyInfoHolder
    extends DiffHolderBase<Map<String, ? extends NonSignificantChangeInfo>> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private PropertyInfoHolder(Map<String, NonSignificantChangeInfo> leftMap, Map<String, NonSignificantChangeInfo> rightMap) {
            super(leftMap, rightMap);
        }

        @JvmStatic
        @NotNull
        public static final PropertyInfoHolder create$intellij_properties_backend(@NotNull FileInfoHolder changedFileInfoHolder) {
            return Companion.create$intellij_properties_backend(changedFileInfoHolder);
        }

        public /* synthetic */ PropertyInfoHolder(Map leftMap, Map rightMap, DefaultConstructorMarker $constructor_marker) {
            this(leftMap, rightMap);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b\bJ$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/properties/diff/MatchProcessor$PropertyInfoHolder$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/lang/properties/diff/MatchProcessor$PropertyInfoHolder;", "changedFileInfoHolder", "Lcom/intellij/lang/properties/diff/FileInfoHolder;", "create$intellij_properties_backend", "findAffectedProperties", "", "", "Lcom/intellij/lang/properties/diff/MatchProcessor$NonSignificantChangeInfo;", "holder", "side", "Lcom/intellij/diff/util/Side;", "extractDiffRangesWithData", "", "Lcom/intellij/lang/properties/diff/util/DiffTextRangeWithData;", "file", "Lcom/intellij/lang/properties/psi/PropertiesFile;", "intellij.properties.backend"})
        @SourceDebugExtension(value={"SMAP\nMatchProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchProcessor.kt\ncom/intellij/lang/properties/diff/MatchProcessor$PropertyInfoHolder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1563#2:157\n1634#2,3:158\n1617#2,9:161\n1869#2:170\n1870#2:172\n1626#2:173\n1617#2,9:174\n1869#2:183\n1870#2:185\n1626#2:186\n1#3:171\n1#3:184\n*S KotlinDebug\n*F\n+ 1 MatchProcessor.kt\ncom/intellij/lang/properties/diff/MatchProcessor$PropertyInfoHolder$Companion\n*L\n112#1:157\n112#1:158,3\n120#1:161,9\n120#1:170\n120#1:172\n120#1:173\n129#1:174,9\n129#1:183\n129#1:185\n129#1:186\n120#1:171\n129#1:184\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final PropertyInfoHolder create$intellij_properties_backend(@NotNull FileInfoHolder changedFileInfoHolder) {
                Intrinsics.checkNotNullParameter((Object)changedFileInfoHolder, (String)"changedFileInfoHolder");
                return new PropertyInfoHolder(this.findAffectedProperties(changedFileInfoHolder, Side.LEFT), this.findAffectedProperties(changedFileInfoHolder, Side.RIGHT), null);
            }

            /*
             * WARNING - void declaration
             */
            private final Map<String, NonSignificantChangeInfo> findAffectedProperties(FileInfoHolder holder, Side side) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapTo$iv$iv;
                FileInfo changedFileInfo = (FileInfo)holder.get(side);
                PsiFile file = changedFileInfo.getFile();
                if (!(file instanceof PropertiesFile)) {
                    throw new IllegalStateException("Not a properties file: " + file);
                }
                List list = ((PropertiesFile)file).getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
                List propertyList = list;
                Iterable $this$map$iv = propertyList;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo22 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IProperty iProperty = (IProperty)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getUnescapedKey());
                }
                if (CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() != propertyList.size()) {
                    throw new IllegalStateException("Properties file contains duplicated keys: " + file);
                }
                List<TextRange> lineFragmentRangeList = ((FileInfo)holder.get(side)).getLineFragmentRangeList();
                List<DiffTextRangeWithData> diffRangeWithDataList = this.extractDiffRangesWithData((PropertiesFile)file);
                Iterable $this$mapNotNull$iv = Companion.findNonSignificantChanges(changedFileInfo.getLineOffsets(), lineFragmentRangeList, diffRangeWithDataList, side);
                boolean $i$f$mapNotNull = false;
                Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    NonSignificantChangeInfo changeInfo = (NonSignificantChangeInfo)element$iv$iv;
                    boolean bl2 = false;
                    Object object2 = changeInfo.getData();
                    if ((object2 instanceof IProperty ? (IProperty)object2 : null) == null) {
                        object = null;
                    } else {
                        String key;
                        IProperty property;
                        property = property;
                        String string = key = property.getUnescapedKey();
                        object = string != null ? TuplesKt.to((Object)string, (Object)changeInfo) : null;
                    }
                    if (object == null) continue;
                    Pair it$iv$iv = object;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                return MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            }

            /*
             * WARNING - void declaration
             */
            private final List<DiffTextRangeWithData> extractDiffRangesWithData(PropertiesFile file) {
                void $this$mapNotNullTo$iv$iv;
                List list = file.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    DiffTextRangeWithData diffTextRangeWithData;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    IProperty property = (IProperty)element$iv$iv;
                    boolean bl2 = false;
                    if (!(property instanceof Property)) {
                        diffTextRangeWithData = null;
                    } else {
                        TextRange textRange = ((Property)property).getTextRange();
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                        diffTextRangeWithData = new DiffTextRangeWithData(textRange, property);
                    }
                    if (diffTextRangeWithData == null) continue;
                    DiffTextRangeWithData it$iv$iv = diffTextRangeWithData;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

