/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.roots.ui.configuration.actions.AlignedIconWithTextAction;
import com.intellij.util.ui.JBInsets;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"format", "", "Lcom/intellij/openapi/util/NlsSafe;", "num", "", "createCustomComponentForResultViewToolbar", "Ljavax/swing/JComponent;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "setPageSizeAndReload", "", "pageSize", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "intellij.grid.impl"})
public final class ChangePageSizeUtilKt {
    @NotNull
    public static final String format(long num) {
        String string = "%,d";
        Object[] objectArray = new Object[]{num};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final JComponent createCustomComponentForResultViewToolbar(@NotNull AnAction action, @NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText c2 = new ActionButtonWithText(action, presentation, place, dimension){

            public Insets getInsets() {
                return (Insets)new JBInsets(0, 0, 0, 0);
            }
        };
        JComponent jComponent = AlignedIconWithTextAction.align((JComponent)((JComponent)c2));
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"align(...)");
        return jComponent;
    }

    public static final void setPageSizeAndReload(int pageSize, @NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        GridPagingModel gridPagingModel = grid.getDataHookup().getPageModel();
        Intrinsics.checkNotNullExpressionValue((Object)gridPagingModel, (String)"getPageModel(...)");
        GridPagingModel pageModel = gridPagingModel;
        pageModel.setPageSize(pageSize);
        GridLoader gridLoader = grid.getDataHookup().getLoader();
        Intrinsics.checkNotNullExpressionValue((Object)gridLoader, (String)"getLoader(...)");
        GridLoader loader = gridLoader;
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid));
        if (GridUtilCore.isPageSizeUnlimited((int)pageSize)) {
            loader.load(source, 0);
        } else {
            loader.reloadCurrentPage(source);
        }
    }
}

